/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2018-12-11 16:47:30 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_bwg_album` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `description` mediumtext NOT NULL,
  `preview_image` mediumtext NOT NULL,
  `random_preview_image` mediumtext NOT NULL,
  `order` bigint(20) NOT NULL,
  `author` bigint(20) NOT NULL,
  `published` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_bwg_album_gallery` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `album_id` bigint(20) NOT NULL,
  `is_album` tinyint(1) NOT NULL,
  `alb_gal_id` bigint(20) NOT NULL,
  `order` bigint(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_bwg_gallery` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `description` mediumtext NOT NULL,
  `page_link` mediumtext NOT NULL,
  `preview_image` mediumtext NOT NULL,
  `random_preview_image` mediumtext NOT NULL,
  `order` bigint(20) NOT NULL,
  `author` bigint(20) NOT NULL,
  `published` tinyint(1) NOT NULL,
  `gallery_type` varchar(32) NOT NULL,
  `gallery_source` varchar(256) NOT NULL,
  `autogallery_image_number` int(4) NOT NULL,
  `update_flag` varchar(32) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_bwg_image` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `gallery_id` bigint(20) NOT NULL,
  `slug` longtext NOT NULL,
  `filename` varchar(255) NOT NULL,
  `image_url` mediumtext NOT NULL,
  `thumb_url` mediumtext NOT NULL,
  `description` mediumtext NOT NULL,
  `alt` mediumtext NOT NULL,
  `date` varchar(128) NOT NULL,
  `size` varchar(128) NOT NULL,
  `filetype` varchar(128) NOT NULL,
  `resolution` varchar(128) NOT NULL,
  `author` bigint(20) NOT NULL,
  `order` bigint(20) NOT NULL,
  `published` tinyint(1) NOT NULL,
  `comment_count` bigint(20) NOT NULL,
  `avg_rating` float NOT NULL,
  `rate_count` bigint(20) NOT NULL,
  `hit_count` bigint(20) NOT NULL,
  `redirect_url` varchar(255) NOT NULL,
  `pricelist_id` int(16) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=37 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_bwg_image_comment` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `image_id` bigint(20) NOT NULL,
  `name` varchar(255) NOT NULL,
  `date` varchar(64) NOT NULL,
  `comment` mediumtext NOT NULL,
  `url` mediumtext NOT NULL,
  `mail` mediumtext NOT NULL,
  `published` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_bwg_image_rate` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `image_id` bigint(20) NOT NULL,
  `rate` float NOT NULL,
  `ip` varchar(64) NOT NULL,
  `date` varchar(64) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_bwg_image_tag` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `tag_id` bigint(20) NOT NULL,
  `image_id` bigint(20) NOT NULL,
  `gallery_id` bigint(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_bwg_option` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `images_directory` mediumtext NOT NULL,
  `masonry` varchar(255) NOT NULL,
  `mosaic` varchar(255) NOT NULL,
  `resizable_mosaic` tinyint(1) NOT NULL,
  `mosaic_total_width` int(4) NOT NULL,
  `image_column_number` int(4) NOT NULL,
  `images_per_page` int(4) NOT NULL,
  `thumb_width` int(4) NOT NULL,
  `thumb_height` int(4) NOT NULL,
  `upload_thumb_width` int(4) NOT NULL,
  `upload_thumb_height` int(4) NOT NULL,
  `image_enable_page` tinyint(1) NOT NULL,
  `image_title_show_hover` varchar(20) NOT NULL,
  `album_column_number` int(4) NOT NULL,
  `albums_per_page` int(4) NOT NULL,
  `album_title_show_hover` varchar(8) NOT NULL,
  `album_thumb_width` int(4) NOT NULL,
  `album_thumb_height` int(4) NOT NULL,
  `album_enable_page` tinyint(1) NOT NULL,
  `extended_album_height` int(4) NOT NULL,
  `extended_album_description_enable` tinyint(1) NOT NULL,
  `image_browser_width` int(4) NOT NULL,
  `image_browser_title_enable` tinyint(1) NOT NULL,
  `image_browser_description_enable` tinyint(1) NOT NULL,
  `blog_style_width` int(4) NOT NULL,
  `blog_style_title_enable` tinyint(1) NOT NULL,
  `blog_style_images_per_page` int(4) NOT NULL,
  `blog_style_enable_page` tinyint(1) NOT NULL,
  `slideshow_type` varchar(16) NOT NULL,
  `slideshow_interval` int(4) NOT NULL,
  `slideshow_width` int(4) NOT NULL,
  `slideshow_height` int(4) NOT NULL,
  `slideshow_enable_autoplay` tinyint(1) NOT NULL,
  `slideshow_enable_shuffle` tinyint(1) NOT NULL,
  `slideshow_enable_ctrl` tinyint(1) NOT NULL,
  `slideshow_enable_filmstrip` tinyint(1) NOT NULL,
  `slideshow_filmstrip_height` int(4) NOT NULL,
  `slideshow_enable_title` tinyint(1) NOT NULL,
  `slideshow_title_position` varchar(16) NOT NULL,
  `slideshow_enable_description` tinyint(1) NOT NULL,
  `slideshow_description_position` varchar(16) NOT NULL,
  `slideshow_enable_music` tinyint(1) NOT NULL,
  `slideshow_audio_url` varchar(255) NOT NULL,
  `popup_width` int(4) NOT NULL,
  `popup_height` int(4) NOT NULL,
  `popup_type` varchar(16) NOT NULL,
  `popup_interval` int(4) NOT NULL,
  `popup_enable_filmstrip` tinyint(1) NOT NULL,
  `popup_filmstrip_height` int(4) NOT NULL,
  `popup_enable_ctrl_btn` tinyint(1) NOT NULL,
  `popup_enable_fullscreen` tinyint(1) NOT NULL,
  `popup_enable_info` tinyint(1) NOT NULL,
  `popup_info_always_show` tinyint(1) NOT NULL,
  `popup_enable_rate` tinyint(1) NOT NULL,
  `popup_enable_comment` tinyint(1) NOT NULL,
  `popup_enable_email` tinyint(1) NOT NULL,
  `popup_enable_captcha` tinyint(1) NOT NULL,
  `popup_enable_download` tinyint(1) NOT NULL,
  `popup_enable_fullsize_image` tinyint(1) NOT NULL,
  `popup_enable_facebook` tinyint(1) NOT NULL,
  `popup_enable_twitter` tinyint(1) NOT NULL,
  `popup_enable_google` tinyint(1) NOT NULL,
  `watermark_type` varchar(8) NOT NULL,
  `watermark_position` varchar(16) NOT NULL,
  `watermark_width` int(4) NOT NULL,
  `watermark_height` int(4) NOT NULL,
  `watermark_url` mediumtext NOT NULL,
  `watermark_text` mediumtext NOT NULL,
  `watermark_link` mediumtext NOT NULL,
  `watermark_font_size` int(4) NOT NULL,
  `watermark_font` varchar(16) NOT NULL,
  `watermark_color` varchar(8) NOT NULL,
  `watermark_opacity` int(4) NOT NULL,
  `built_in_watermark_type` varchar(16) NOT NULL,
  `built_in_watermark_position` varchar(16) NOT NULL,
  `built_in_watermark_size` int(4) NOT NULL,
  `built_in_watermark_url` mediumtext NOT NULL,
  `built_in_watermark_text` mediumtext NOT NULL,
  `built_in_watermark_font_size` int(4) NOT NULL,
  `built_in_watermark_font` varchar(16) NOT NULL,
  `built_in_watermark_color` varchar(8) NOT NULL,
  `built_in_watermark_opacity` int(4) NOT NULL,
  `image_right_click` tinyint(1) NOT NULL,
  `popup_fullscreen` tinyint(1) NOT NULL,
  `gallery_role` tinyint(1) NOT NULL,
  `album_role` tinyint(1) NOT NULL,
  `image_role` tinyint(1) NOT NULL,
  `popup_autoplay` tinyint(1) NOT NULL,
  `album_view_type` varchar(16) NOT NULL,
  `popup_enable_pinterest` tinyint(1) NOT NULL,
  `popup_enable_tumblr` tinyint(1) NOT NULL,
  `show_search_box` tinyint(1) NOT NULL,
  `search_box_width` int(4) NOT NULL,
  `preload_images` tinyint(1) NOT NULL,
  `preload_images_count` int(4) NOT NULL,
  `thumb_click_action` varchar(16) NOT NULL,
  `thumb_link_target` tinyint(1) NOT NULL,
  `comment_moderation` tinyint(1) NOT NULL,
  `popup_hit_counter` tinyint(1) NOT NULL,
  `enable_ML_import` tinyint(1) NOT NULL,
  `showthumbs_name` tinyint(1) NOT NULL,
  `show_album_name` tinyint(1) NOT NULL,
  `show_image_counts` tinyint(1) NOT NULL,
  `upload_img_width` int(4) NOT NULL,
  `upload_img_height` int(4) NOT NULL,
  `play_icon` tinyint(1) NOT NULL,
  `show_masonry_thumb_description` tinyint(1) NOT NULL,
  `slideshow_title_full_width` tinyint(1) NOT NULL,
  `popup_info_full_width` tinyint(1) NOT NULL,
  `show_sort_images` tinyint(1) NOT NULL,
  `autoupdate_interval` int(4) NOT NULL,
  `instagram_access_token` varchar(128) NOT NULL DEFAULT '',
  `description_tb` tinyint(1) NOT NULL,
  `enable_seo` tinyint(1) NOT NULL,
  `autohide_lightbox_navigation` tinyint(1) NOT NULL,
  `autohide_slideshow_navigation` tinyint(1) NOT NULL,
  `read_metadata` tinyint(1) NOT NULL,
  `enable_loop` tinyint(1) NOT NULL DEFAULT '1',
  `enable_addthis` tinyint(1) NOT NULL DEFAULT '0',
  `addthis_profile_id` varchar(32) NOT NULL DEFAULT '',
  `carousel_width` int(4) NOT NULL DEFAULT '300',
  `carousel_height` int(4) NOT NULL DEFAULT '300',
  `carousel_interval` int(4) NOT NULL DEFAULT '5',
  `carousel_image_column_number` int(4) NOT NULL DEFAULT '5',
  `carousel_image_par` varchar(32) NOT NULL DEFAULT '0.75',
  `carousel_enable_autoplay` tinyint(1) NOT NULL DEFAULT '0',
  `carousel_enable_title` tinyint(1) NOT NULL DEFAULT '0',
  `carousel_r_width` int(4) NOT NULL DEFAULT '800',
  `carousel_fit_containerWidth` tinyint(1) NOT NULL DEFAULT '1',
  `carousel_prev_next_butt` tinyint(1) NOT NULL DEFAULT '1',
  `carousel_play_pause_butt` tinyint(1) NOT NULL DEFAULT '1',
  `permissions` varchar(20) NOT NULL DEFAULT 'manage_options',
  `facebook_app_id` varchar(64) NOT NULL DEFAULT '',
  `facebook_app_secret` varchar(64) NOT NULL DEFAULT '',
  `show_tag_box` tinyint(1) NOT NULL DEFAULT '0',
  `show_hide_custom_post` tinyint(1) NOT NULL DEFAULT '0',
  `show_hide_post_meta` tinyint(1) NOT NULL DEFAULT '0',
  `placeholder` varchar(32) NOT NULL DEFAULT '',
  `ecommerce_icon_show_hover` varchar(32) NOT NULL DEFAULT '0',
  `popup_enable_ecommerce` tinyint(1) NOT NULL DEFAULT '0',
  `slideshow_effect_duration` int(4) NOT NULL DEFAULT '1',
  `popup_effect_duration` int(4) NOT NULL DEFAULT '1',
  `use_inline_stiles_and_scripts` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_bwg_shortcode` (
  `id` bigint(20) NOT NULL,
  `tagtext` mediumtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_bwg_theme` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `default_theme` tinyint(1) NOT NULL,
  `options` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_defender_lockout` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ip` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(16) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lockout_message` text COLLATE utf8mb4_unicode_ci,
  `release_time` int(11) DEFAULT NULL,
  `lock_time` int(11) DEFAULT NULL,
  `lock_time_404` int(11) DEFAULT NULL,
  `attempt` int(11) DEFAULT NULL,
  `attempt_404` int(11) DEFAULT NULL,
  `meta` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_defender_lockout_log` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `log` text COLLATE utf8mb4_unicode_ci,
  `ip` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date` int(11) DEFAULT NULL,
  `type` varchar(16) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `blog_id` int(11) DEFAULT NULL,
  `tried` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_easy_gallery` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `slug` varchar(30) NOT NULL,
  `description` text NOT NULL,
  `thumbnail` longtext NOT NULL,
  `thumbwidth` int(11) DEFAULT NULL,
  `thumbheight` int(11) DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_easy_gallery_images` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `gid` int(11) NOT NULL,
  `imagePath` longtext NOT NULL,
  `title` varchar(50) NOT NULL,
  `description` longtext NOT NULL,
  `sortOrder` int(11) NOT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=MyISAM AUTO_INCREMENT=295 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_ngg_album` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `previewpic` bigint(20) NOT NULL DEFAULT '0',
  `albumdesc` mediumtext,
  `sortorder` longtext NOT NULL,
  `pageid` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_ngg_gallery` (
  `gid` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `path` mediumtext,
  `title` mediumtext,
  `galdesc` mediumtext,
  `pageid` bigint(20) NOT NULL DEFAULT '0',
  `previewpic` bigint(20) NOT NULL DEFAULT '0',
  `author` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`gid`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_ngg_pictures` (
  `pid` bigint(20) NOT NULL AUTO_INCREMENT,
  `image_slug` varchar(255) NOT NULL,
  `post_id` bigint(20) NOT NULL DEFAULT '0',
  `galleryid` bigint(20) NOT NULL DEFAULT '0',
  `filename` varchar(255) NOT NULL,
  `description` mediumtext,
  `alttext` mediumtext,
  `imagedate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `exclude` tinyint(4) DEFAULT '0',
  `sortorder` bigint(20) NOT NULL DEFAULT '0',
  `meta_data` longtext,
  PRIMARY KEY (`pid`),
  KEY `post_id` (`post_id`)
) ENGINE=MyISAM AUTO_INCREMENT=23 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) DEFAULT NULL,
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=155199 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=13257 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `post_name` (`post_name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3414 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_redirects` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `url_from` varchar(256) NOT NULL DEFAULT '',
  `url_to` varchar(256) NOT NULL DEFAULT '',
  `status` varchar(12) NOT NULL DEFAULT '301',
  `type` varchar(12) NOT NULL DEFAULT 'url',
  `count` mediumint(9) NOT NULL DEFAULT '0',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_smush_dir_images` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `path` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `resize` varchar(55) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lossy` varchar(55) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `error` varchar(55) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image_size` int(10) unsigned DEFAULT NULL,
  `orig_size` int(10) unsigned DEFAULT NULL,
  `file_time` int(10) unsigned DEFAULT NULL,
  `last_scan` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `meta` text COLLATE utf8mb4_unicode_ci,
  `path_hash` char(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `path_hash` (`path_hash`),
  KEY `image_size` (`image_size`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=241 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfBadLeechers` (
  `eMin` int(10) unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hits` int(10) unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_wfBlockedCommentLog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `countryCode` varchar(2) NOT NULL,
  `blockCount` int(10) unsigned NOT NULL DEFAULT '0',
  `unixday` int(10) unsigned NOT NULL,
  `blockType` varchar(50) NOT NULL DEFAULT 'gsb',
  PRIMARY KEY (`IP`,`unixday`,`blockType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfBlockedIPLog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `countryCode` varchar(2) NOT NULL,
  `blockCount` int(10) unsigned NOT NULL DEFAULT '0',
  `unixday` int(10) unsigned NOT NULL,
  `blockType` varchar(50) NOT NULL DEFAULT 'generic',
  PRIMARY KEY (`IP`,`unixday`,`blockType`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfBlocks` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint(20) NOT NULL,
  `reason` varchar(255) NOT NULL,
  `lastAttempt` int(10) unsigned DEFAULT '0',
  `blockedHits` int(10) unsigned DEFAULT '0',
  `wfsn` tinyint(3) unsigned DEFAULT '0',
  `permanent` tinyint(3) unsigned DEFAULT '0',
  PRIMARY KEY (`IP`),
  KEY `k1` (`wfsn`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfBlocks7` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(10) unsigned NOT NULL DEFAULT '0',
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint(20) NOT NULL,
  `reason` varchar(255) NOT NULL,
  `lastAttempt` int(10) unsigned DEFAULT '0',
  `blockedHits` int(10) unsigned DEFAULT '0',
  `expiration` bigint(20) unsigned NOT NULL DEFAULT '0',
  `parameters` text,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `IP` (`IP`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB AUTO_INCREMENT=132 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfBlocksAdv` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `blockType` char(2) NOT NULL,
  `blockString` varchar(255) NOT NULL,
  `ctime` int(10) unsigned NOT NULL,
  `reason` varchar(255) NOT NULL,
  `totalBlocked` int(10) unsigned DEFAULT '0',
  `lastBlocked` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfConfig` (
  `name` varchar(100) NOT NULL,
  `val` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfCrawlers` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `patternSig` binary(16) NOT NULL,
  `status` char(8) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  `PTR` varchar(255) DEFAULT '',
  PRIMARY KEY (`IP`,`patternSig`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_wfFileChanges` (
  `filenameHash` char(64) NOT NULL,
  `file` varchar(1000) NOT NULL,
  `md5` char(32) NOT NULL,
  PRIMARY KEY (`filenameHash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfFileMods` (
  `filenameMD5` binary(16) NOT NULL,
  `filename` varchar(1000) NOT NULL,
  `knownFile` tinyint(3) unsigned NOT NULL,
  `oldMD5` binary(16) NOT NULL,
  `newMD5` binary(16) NOT NULL,
  `SHAC` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `stoppedOnSignature` varchar(255) NOT NULL DEFAULT '',
  `stoppedOnPosition` int(10) unsigned NOT NULL DEFAULT '0',
  `isSafeFile` varchar(1) NOT NULL DEFAULT '?',
  PRIMARY KEY (`filenameMD5`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfHits` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attackLogTime` double(17,6) unsigned NOT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `jsRun` tinyint(4) DEFAULT '0',
  `statusCode` int(11) NOT NULL DEFAULT '0',
  `isGoogle` tinyint(4) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `newVisit` tinyint(3) unsigned NOT NULL,
  `URL` text,
  `referer` text,
  `UA` text,
  `action` varchar(64) NOT NULL DEFAULT '',
  `actionDescription` text,
  `actionData` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`IP`,`ctime`),
  KEY `attackLogTime` (`attackLogTime`)
) ENGINE=MyISAM AUTO_INCREMENT=285720 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_wfHoover` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `owner` text,
  `host` text,
  `path` text,
  `hostKey` varbinary(124) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k2` (`hostKey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfIssues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=MyISAM AUTO_INCREMENT=710 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfKnownFileList` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4636 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfLeechers` (
  `eMin` int(10) unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hits` int(10) unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_wfLiveTrafficHuman` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `identifier` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `expiration` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`,`identifier`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfLockedOut` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint(20) NOT NULL,
  `reason` varchar(255) NOT NULL,
  `lastAttempt` int(10) unsigned DEFAULT '0',
  `blockedHits` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfLocs` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int(10) unsigned NOT NULL,
  `failed` tinyint(3) unsigned NOT NULL,
  `city` varchar(255) DEFAULT '',
  `region` varchar(255) DEFAULT '',
  `countryName` varchar(255) DEFAULT '',
  `countryCode` char(2) DEFAULT '',
  `lat` float(10,7) DEFAULT '0.0000000',
  `lon` float(10,7) DEFAULT '0.0000000',
  PRIMARY KEY (`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfLogins` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hitID` int(11) DEFAULT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `fail` tinyint(3) unsigned NOT NULL,
  `action` varchar(40) NOT NULL,
  `username` varchar(255) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `UA` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`IP`,`fail`),
  KEY `hitID` (`hitID`)
) ENGINE=MyISAM AUTO_INCREMENT=15905 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfNet404s` (
  `sig` binary(16) NOT NULL,
  `ctime` int(10) unsigned NOT NULL,
  `URI` varchar(1000) NOT NULL,
  PRIMARY KEY (`sig`),
  KEY `k1` (`ctime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfNotifications` (
  `id` varchar(32) NOT NULL DEFAULT '',
  `new` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `category` varchar(255) NOT NULL,
  `priority` int(11) NOT NULL DEFAULT '1000',
  `ctime` int(10) unsigned NOT NULL,
  `html` text NOT NULL,
  `links` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfPendingIssues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfReverseCache` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `host` varchar(255) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_wfSNIPCache` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `IP` varchar(45) NOT NULL DEFAULT '',
  `expiration` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `body` varchar(255) NOT NULL DEFAULT '',
  `count` int(10) unsigned NOT NULL DEFAULT '0',
  `type` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `expiration` (`expiration`),
  KEY `IP` (`IP`),
  KEY `type` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=137 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfScanners` (
  `eMin` int(10) unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hits` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_wfStatus` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `ctime` double(17,6) unsigned NOT NULL,
  `level` tinyint(3) unsigned NOT NULL,
  `type` char(5) NOT NULL,
  `msg` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=180872 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfThrottleLog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `startTime` int(10) unsigned NOT NULL,
  `endTime` int(10) unsigned NOT NULL,
  `timesThrottled` int(10) unsigned NOT NULL,
  `lastReason` varchar(255) NOT NULL,
  PRIMARY KEY (`IP`),
  KEY `k2` (`endTime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfTrafficRates` (
  `eMin` int(10) unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hitType` enum('hit','404') NOT NULL DEFAULT 'hit',
  `hits` int(10) unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`,`hitType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfVulnScanners` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int(10) unsigned NOT NULL,
  `hits` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_yoast_seo_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_id` bigint(20) unsigned NOT NULL,
  `target_post_id` bigint(20) unsigned NOT NULL,
  `type` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=6024 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_yoast_seo_meta` (
  `object_id` bigint(20) unsigned NOT NULL,
  `internal_link_count` int(10) unsigned DEFAULT NULL,
  `incoming_link_count` int(10) unsigned DEFAULT NULL,
  UNIQUE KEY `object_id` (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


/* INSERT TABLE DATA: wp_bwg_gallery */
INSERT INTO `wp_bwg_gallery` VALUES("1", "Guest Rooms", "guest-rooms", "", "", "", "/thumb/room34towardocean.jpg", "1", "1", "1", "", "", "0", "");
INSERT INTO `wp_bwg_gallery` VALUES("2", "Location Amenities", "location-amenities", "", "", "", "/thumb/motelexterior.jpg", "2", "1", "1", "", "", "0", "");

/* INSERT TABLE DATA: wp_bwg_image */
INSERT INTO `wp_bwg_image` VALUES("1", "1", "Guest Room Baths  ", "Guest Room Bath", "/Guest Room Bath.jpg", "/thumb/Guest Room Bath.jpg", "Guest Room Baths Are Freshly Remodeled In All Rooms", "Guest Room Baths  ", "20 May 2015, 20:08", "446 KB", "JPG", "787 x 1200 px", "1", "21", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("2", "1", "King Efficiency Room     ", "room7deck", "/room7deck.jpg", "/thumb/room7deck.jpg", "Located directly on the beach with oceanfront deck and 100% view of Front Beach and the harbor. One king size bed, sleeps 2. This room includes A/C, cable TV, Wi-Fi, hairdryer, coffee maker, microwave, refrigerator, stove, and sink.", "King Efficiency Room     ", "20 May 2015, 20:07", "272 KB", "JPG", "800 x 517 px", "1", "20", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("3", "1", "King Efficiency Room            ", "room7fromcorner", "/room7fromcorner.jpg", "/thumb/room7fromcorner.jpg", "Located directly on the beach with oceanfront deck and 100% view of Front Beach and the harbor. One king size bed, sleeps 2. This room includes A/C, cable TV, Wi-Fi, hairdryer, coffee maker, microwave, refrigerator, stove, and sink.", "King Efficiency Room            ", "20 May 2015, 20:07", "348 KB", "JPG", "800 x 533 px", "1", "19", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("5", "1", "King Efficiency Room              ", "room7reversed", "/room7reversed.jpg", "/thumb/room7reversed.jpg", "Located directly on the beach with oceanfront deck and 100% view of Front Beach and the harbor. One king size bed, sleeps 2. This room includes A/C, cable TV, Wi-Fi, hairdryer, coffee maker, microwave, refrigerator, stove, and sink.\n", "King Efficiency Room              ", "20 May 2015, 20:07", "327 KB", "JPG", "800 x 467 px", "1", "18", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("6", "1", "King Efficiency Room            ", "room7towater", "/room7towater.jpg", "/thumb/room7towater.jpg", "Located directly on the beach with oceanfront deck and 100% view of Front Beach and the harbor. One king size bed, sleeps 2. This room includes A/C, cable TV, Wi-Fi, hairdryer, coffee maker, microwave, refrigerator, stove, and sink.\n\n", "King Efficiency Room            ", "20 May 2015, 20:07", "296 KB", "JPG", "800 x 460 px", "1", "17", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("7", "1", "Standard Efficiency Suite            ", "room20deck", "/room20deck.jpg", "/thumb/room20deck.jpg", "Located directly on the beach with oceanfront deck and 100% view of Front Beach and the harbor. Two full size beds and a day bed, sleeps 5. This room includes A/C, cable TV, Wi-Fi, hairdryer, coffee maker, microwave, refrigerator, stove, and sink.", "Standard Efficiency Suite            ", "20 May 2015, 20:08", "330 KB", "JPG", "800 x 497 px", "1", "16", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("8", "1", "Standard Efficiency Suite              ", "room20towardkitchen", "/room20towardkitchen.jpg", "/thumb/room20towardkitchen.jpg", "Located directly on the beach with oceanfront deck and 100% view of Front Beach and the harbor. Two full size beds and a day bed, sleeps 5. This room includes A/C, cable TV, Wi-Fi, hairdryer, coffee maker, microwave, refrigerator, stove, and sink.\n", "Standard Efficiency Suite              ", "20 May 2015, 20:08", "293 KB", "JPG", "800 x 472 px", "1", "15", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("9", "1", "Standard Efficiency Suite            ", "room20towater", "/room20towater.jpg", "/thumb/room20towater.jpg", "Located directly on the beach with oceanfront deck and 100% view of Front Beach and the harbor. Two full size beds and a day bed, sleeps 5. This room includes A/C, cable TV, Wi-Fi, hairdryer, coffee maker, microwave, refrigerator, stove, and sink.", "Standard Efficiency Suite            ", "20 May 2015, 20:08", "298 KB", "JPG", "800 x 486 px", "1", "14", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("10", "1", "Queen Room             ", "room23", "/room23.jpg", "/thumb/room23.jpg", "Located directly on the beach with oceanfront deck and 100% view of Front Beach and the harbor. One queen size bed, sleeps 2. This room includes A/C, cable TV, Wi-Fi, coffee maker, microwave, in-room refrigerator and hairdryer.", "Queen Room             ", "20 May 2015, 20:08", "326 KB", "JPG", "800 x 473 px", "1", "13", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("11", "1", "Queen Room             ", "room23deck", "/room23deck.jpg", "/thumb/room23deck.jpg", "Located directly on the beach with oceanfront deck and 100% view of Front Beach and the harbor. One queen size bed, sleeps 2. This room includes A/C, cable TV, Wi-Fi, coffee maker, microwave, in-room refrigerator and hairdryer.", "Queen Room             ", "20 May 2015, 20:08", "281 KB", "JPG", "800 x 533 px", "1", "12", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("12", "1", "Queen Room              ", "room23reversed", "/room23reversed.jpg", "/thumb/room23reversed.jpg", "Located directly on the beach with oceanfront deck and 100% view of Front Beach and the harbor. One queen size bed, sleeps 2. This room includes A/C, cable TV, Wi-Fi, coffee maker, microwave, in-room refrigerator and hairdryer.", "Queen Room              ", "20 May 2015, 20:08", "333 KB", "JPG", "800 x 495 px", "1", "11", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("13", "1", "Standard Room             ", "room26", "/room26.jpg", "/thumb/room26.jpg", "Located directly on the beach with oceanfront deck and 100% view of Front Beach and the harbor. Two full size beds, sleeps 4. This room includes A/C, cable TV, Wi-Fi, coffee maker, microwave, in-room refrigerator and hairdryer.", "Standard Room             ", "20 May 2015, 20:07", "285 KB", "JPG", "800 x 462 px", "1", "10", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("14", "1", "Standard Room              ", "room26deck", "/room26deck.jpg", "/thumb/room26deck.jpg", "Located directly on the beach with oceanfront deck and 100% view of Front Beach and the harbor. Two full size beds, sleeps 4. This room includes A/C, cable TV, Wi-Fi, coffee maker, microwave, in-room refrigerator and hairdryer.\n", "Standard Room              ", "20 May 2015, 20:07", "289 KB", "JPG", "800 x 528 px", "1", "9", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("15", "1", "Standard Room             ", "room26hdr", "/room26hdr.jpg", "/thumb/room26hdr.jpg", "Located directly on the beach with oceanfront deck and 100% view of Front Beach and the harbor. Two full size beds, sleeps 4. This room includes A/C, cable TV, Wi-Fi, coffee maker, microwave, in-room refrigerator and hairdryer.", "Standard Room             ", "20 May 2015, 20:07", "332 KB", "JPG", "800 x 493 px", "1", "8", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("16", "1", "Queen Efficiency                  ", "room28deck", "/room28deck.jpg", "/thumb/room28deck.jpg", "Located directly on the beach with oceanfront deck and 100% view of Front Beach and the harbor. One queen size bed, sleeps 2. This room includes A/C, cable TV, Wi-Fi, hairdryer, coffee maker, microwave, refrigerator, stove, and sink.\n", "Queen Efficiency                  ", "20 May 2015, 20:07", "322 KB", "JPG", "800 x 533 px", "1", "7", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("17", "1", "Queen Efficiency                  ", "room28hdr", "/room28hdr.jpg", "/thumb/room28hdr.jpg", "Located directly on the beach with oceanfront deck and 100% view of Front Beach and the harbor. One queen size bed, sleeps 2. This room includes A/C, cable TV, Wi-Fi, hairdryer, coffee maker, microwave, refrigerator, stove, and sink.\n", "Queen Efficiency                  ", "20 May 2015, 20:07", "377 KB", "JPG", "800 x 533 px", "1", "6", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("18", "1", "Queen Efficiency                ", "room28reversed", "/room28reversed.jpg", "/thumb/room28reversed.jpg", "Located directly on the beach with oceanfront deck and 100% view of Front Beach and the harbor. One queen size bed, sleeps 2. This room includes A/C, cable TV, Wi-Fi, hairdryer, coffee maker, microwave, refrigerator, stove, and sink.\n", "Queen Efficiency                ", "20 May 2015, 20:07", "276 KB", "JPG", "800 x 475 px", "1", "5", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("19", "1", "Queen Efficiency                ", "room28reversedfromslider", "/room28reversedfromslider.jpg", "/thumb/room28reversedfromslider.jpg", "Located directly on the beach with oceanfront deck and 100% view of Front Beach and the harbor. One queen size bed, sleeps 2. This room includes A/C, cable TV, Wi-Fi, hairdryer, coffee maker, microwave, refrigerator, stove, and sink.", "Queen Efficiency                ", "20 May 2015, 20:07", "333 KB", "JPG", "800 x 533 px", "1", "4", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("20", "1", "King Room with Pull Out Sofa      ", "room34deck", "/room34deck.jpg", "/thumb/room34deck.jpg", "Located directly on the beach with oceanfront deck and 100% view of Front Beach and the harbor. One king size bed, and single pull-out, sleeps 3. This room includes A/C, cable TV, Wi-Fi, coffee maker, microwave, in-room refrigerator and hairdryer.\n", "King Room with Pull Out Sofa      ", "20 May 2015, 20:07", "306 KB", "JPG", "800 x 533 px", "1", "3", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("22", "1", "King Room with Pull Out Sofa             ", "room34reverse", "/room34reverse.jpg", "/thumb/room34reverse.jpg", "Located directly on the beach with oceanfront deck and 100% view of Front Beach and the harbor. One king size bed, and single pull-out, sleeps 3. This room includes A/C, cable TV, Wi-Fi, coffee maker, microwave, in-room refrigerator and hairdryer.\n", "King Room with Pull Out Sofa             ", "20 May 2015, 20:07", "248 KB", "JPG", "800 x 455 px", "1", "2", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("23", "1", "King Room with Pull Out Sofa                  ", "room34towardocean", "/room34towardocean.jpg", "/thumb/room34towardocean.jpg", "Located directly on the beach with oceanfront deck and 100% view of Front Beach and the harbor. One king size bed, and single pull-out, sleeps 3. This room includes A/C, cable TV,  Wi-Fi, coffee maker, microwave, in-room refrigerator and hairdryer.\n", "King Room with Pull Out Sofa                  ", "20 May 2015, 20:07", "311 KB", "JPG", "800 x 490 px", "1", "1", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("24", "1", "Sitting Areas Street Side  ", "sittingareafrontside", "/sittingareafrontside.jpg", "/thumb/sittingareafrontside.jpg", "Enjoy Breezes and Sun From Both Sides, The Ocean Side And Beach Street Side", "Sitting Areas Street Side  ", "20 May 2015, 20:07", "472 KB", "JPG", "800 x 615 px", "1", "22", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("36", "2", "Rockport Is A Beautiful, Welcoming Town To Visit", "rockportsign800px", "/rockportsign800px.jpg", "/thumb/rockportsign800px.jpg", "", "Rockport Is A Beautiful, Welcoming Town To Visit", "20 May 2015, 23:52", "67 KB", "JPG", "781 x 347 px", "1", "10", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("26", "2", "Welcome To Captains Bounty On The Beach      ", "motelexterior", "/motelexterior.jpg", "/thumb/motelexterior.jpg", "", "Welcome To Captains Bounty On The Beach      ", "20 May 2015, 21:31", "266 KB", "JPG", "800 x 362 px", "1", "1", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("27", "2", "View Of Our Ocean Front Decks ", "motelfrombeach", "/motelfrombeach.jpg", "/thumb/motelfrombeach.jpg", "", "View Of Our Ocean Front Decks ", "20 May 2015, 21:31", "338 KB", "JPG", "800 x 536 px", "1", "9", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("28", "2", "Another View Of Captains Bounty    ", "motelnorthside", "/motelnorthside.jpg", "/thumb/motelnorthside.jpg", "", "Another View Of Captains Bounty    ", "20 May 2015, 21:31", "314 KB", "JPG", "800 x 445 px", "1", "8", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("29", "2", "An Adjacent Stone Garden Overlooks The Beach       ", "motelsidegardenstones", "/motelsidegardenstones.jpg", "/thumb/motelsidegardenstones.jpg", "", "An Adjacent Stone Garden Overlooks The Beach       ", "20 May 2015, 21:31", "427 KB", "JPG", "800 x 533 px", "1", "7", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("31", "2", "Shops &amp; Restaurants On Bearskin Neck  - A Short Walk Away   ", "bearskinneck", "/bearskinneck.jpg", "/thumb/bearskinneck.jpg", "", "Shops &amp; Restaurants On Bearskin Neck  - A Short Walk Away   ", "20 May 2015, 21:37", "765 KB", "JPG", "1200 x 800 px", "1", "6", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("32", "2", "Shops In The Village At Dock Square - A Short Walk Away    ", "docksquareshop", "/docksquareshop.jpg", "/thumb/docksquareshop.jpg", "", "Shops In The Village At Dock Square - A Short Walk Away    ", "20 May 2015, 21:37", "668 KB", "JPG", "1200 x 800 px", "1", "5", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("33", "2", "Front Beach Is Right Here! We Are Directly On The Beach   ", "frontbeach", "/frontbeach.jpg", "/thumb/frontbeach.jpg", "", "Front Beach Is Right Here! We Are Directly On The Beach   ", "20 May 2015, 21:38", "632 KB", "JPG", "1200 x 800 px", "1", "3", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("34", "2", "All Rooms Have Beachfront Decks  ", "room20deck", "/room20deck.jpg", "/thumb/room20deck.jpg", "", "All Rooms Have Beachfront Decks  ", "20 May 2015, 20:08", "330 KB", "JPG", "800 x 497 px", "1", "2", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("35", "2", "Wake To A Beautiful Sunrise  ", "balconysunrise", "/balconysunrise.jpg", "/thumb/balconysunrise.jpg", "", "Wake To A Beautiful Sunrise  ", "20 May 2015, 23:52", "226 KB", "JPG", "1023 x 633 px", "1", "4", "1", "0", "0", "0", "0", "", "0");

/* INSERT TABLE DATA: wp_bwg_option */
INSERT INTO `wp_bwg_option` VALUES("1", "wp-content/uploads", "vertical", "vertical", "0", "100", "5", "30", "180", "90", "300", "300", "1", "none", "5", "30", "hover", "120", "90", "1", "150", "1", "800", "1", "1", "800", "1", "5", "1", "fade", "5", "800", "500", "0", "0", "1", "1", "90", "0", "top-right", "0", "bottom-right", "0", "", "800", "500", "fade", "5", "1", "70", "1", "1", "1", "0", "0", "1", "0", "0", "0", "0", "1", "1", "1", "none", "bottom-left", "90", "90", "http://www.captainsbountymotorinn.com/wp-content/plugins/photo-gallery/images/watermark.png", "web-dorado.com", "https://web-dorado.com", "20", "arial", "FFFFFF", "30", "none", "middle-center", "15", "http://www.captainsbountymotorinn.com/wp-content/plugins/photo-gallery/images/watermark.png", "web-dorado.com", "20", "arial", "FFFFFF", "30", "0", "0", "0", "0", "0", "0", "thumbnail", "0", "0", "0", "180", "0", "10", "open_lightbox", "1", "0", "0", "0", "0", "0", "0", "1200", "1200", "1", "0", "0", "0", "0", "30", "0", "0", "1", "1", "1", "1", "1", "0", "", "300", "300", "5", "5", "0.75", "0", "0", "800", "1", "1", "1", "manage_options", "", "", "0", "0", "0", "", "0", "0", "1", "1", "0");

/* INSERT TABLE DATA: wp_bwg_shortcode */
INSERT INTO `wp_bwg_shortcode` VALUES("1", " gallery_type=\"thumbnails\" theme_id=\"1\" gallery_id=\"1\" sort_by=\"order\" order_by=\"asc\" show_search_box=\"0\" show_sort_images=\"0\" search_box_width=\"180\" image_column_number=\"5\" images_per_page=\"30\" image_title=\"hover\" image_enable_page=\"1\" thumb_width=\"180\" thumb_height=\"90\" thumb_click_action=\"undefined\" thumb_link_target=\"undefined\" popup_fullscreen=\"0\" popup_autoplay=\"0\" popup_width=\"800\" popup_height=\"500\" popup_effect=\"fade\" popup_interval=\"5\" popup_enable_filmstrip=\"1\" popup_filmstrip_height=\"70\" popup_enable_ctrl_btn=\"1\" popup_enable_fullscreen=\"1\" popup_enable_info=\"1\" popup_info_always_show=\"1\" popup_info_full_width=\"0\" popup_enable_rate=\"0\" popup_enable_comment=\"1\" popup_hit_counter=\"0\" popup_enable_facebook=\"1\" popup_enable_twitter=\"1\" popup_enable_google=\"1\" popup_enable_pinterest=\"0\" popup_enable_tumblr=\"0\" watermark_type=\"none\" watermark_link=\"https%3A%2F%2Fweb-dorado.com\"");
INSERT INTO `wp_bwg_shortcode` VALUES("2", " gallery_type=\"thumbnails\" theme_id=\"1\" gallery_id=\"2\" sort_by=\"order\" order_by=\"asc\" show_search_box=\"0\" show_sort_images=\"0\" search_box_width=\"180\" image_column_number=\"5\" images_per_page=\"30\" image_title=\"none\" image_enable_page=\"1\" thumb_width=\"180\" thumb_height=\"90\" thumb_click_action=\"undefined\" thumb_link_target=\"undefined\" popup_fullscreen=\"0\" popup_autoplay=\"0\" popup_width=\"800\" popup_height=\"500\" popup_effect=\"fade\" popup_interval=\"5\" popup_enable_filmstrip=\"1\" popup_filmstrip_height=\"70\" popup_enable_ctrl_btn=\"1\" popup_enable_fullscreen=\"1\" popup_enable_info=\"1\" popup_info_always_show=\"1\" popup_info_full_width=\"0\" popup_enable_rate=\"0\" popup_enable_comment=\"1\" popup_hit_counter=\"0\" popup_enable_facebook=\"1\" popup_enable_twitter=\"1\" popup_enable_google=\"1\" popup_enable_pinterest=\"0\" popup_enable_tumblr=\"0\" watermark_type=\"none\" watermark_link=\"https%3A%2F%2Fweb-dorado.com\"");

/* INSERT TABLE DATA: wp_bwg_theme */
INSERT INTO `wp_bwg_theme` VALUES("1", "Theme 1", "1", "{\"thumb_margin\":\"4\",\"thumb_padding\":\"0\",\"thumb_border_radius\":\"0\",\"thumb_border_width\":\"0\",\"thumb_border_style\":\"none\",\"thumb_border_color\":\"CCCCCC\",\"thumb_bg_color\":\"FFFFFF\",\"thumbs_bg_color\":\"FFFFFF\",\"thumb_bg_transparent\":\"0\",\"thumb_box_shadow\":\"0px 0px 0px #888888\",\"thumb_transparent\":\"100\",\"thumb_align\":\"center\",\"thumb_hover_effect\":\"scale\",\"thumb_hover_effect_value\":\"1.1\",\"thumb_transition\":\"1\",\"thumb_title_font_color\":\"CCCCCC\",\"thumb_title_font_style\":\"segoe ui\",\"thumb_title_pos\":\"bottom\",\"thumb_title_font_size\":\"16\",\"thumb_title_font_weight\":\"bold\",\"thumb_title_margin\":\"2px\",\"thumb_title_shadow\":\"0px 0px 0px #888888\",\"page_nav_position\":\"bottom\",\"page_nav_align\":\"center\",\"page_nav_number\":\"0\",\"page_nav_font_size\":\"12\",\"page_nav_font_style\":\"segoe ui\",\"page_nav_font_color\":\"666666\",\"page_nav_font_weight\":\"bold\",\"page_nav_border_width\":\"1\",\"page_nav_border_style\":\"solid\",\"page_nav_border_color\":\"E3E3E3\",\"page_nav_border_radius\":\"0\",\"page_nav_margin\":\"0\",\"page_nav_padding\":\"3px 6px\",\"page_nav_button_bg_color\":\"FFFFFF\",\"page_nav_button_bg_transparent\":\"100\",\"page_nav_box_shadow\":\"0\",\"page_nav_button_transition\":\"1\",\"page_nav_button_text\":\"0\",\"lightbox_overlay_bg_color\":\"000000\",\"lightbox_overlay_bg_transparent\":\"70\",\"lightbox_bg_color\":\"000000\",\"lightbox_ctrl_btn_pos\":\"bottom\",\"lightbox_ctrl_btn_align\":\"center\",\"lightbox_ctrl_btn_height\":\"20\",\"lightbox_ctrl_btn_margin_top\":\"10\",\"lightbox_ctrl_btn_margin_left\":\"7\",\"lightbox_ctrl_btn_transparent\":\"100\",\"lightbox_ctrl_btn_color\":\"FFFFFF\",\"lightbox_toggle_btn_height\":\"14\",\"lightbox_toggle_btn_width\":\"100\",\"lightbox_ctrl_cont_bg_color\":\"000000\",\"lightbox_ctrl_cont_transparent\":\"65\",\"lightbox_ctrl_cont_border_radius\":\"4\",\"lightbox_close_btn_transparent\":\"100\",\"lightbox_close_btn_bg_color\":\"000000\",\"lightbox_close_btn_border_width\":\"2\",\"lightbox_close_btn_border_radius\":\"16px\",\"lightbox_close_btn_border_style\":\"none\",\"lightbox_close_btn_border_color\":\"FFFFFF\",\"lightbox_close_btn_box_shadow\":\"0\",\"lightbox_close_btn_color\":\"FFFFFF\",\"lightbox_close_btn_size\":\"10\",\"lightbox_close_btn_width\":\"20\",\"lightbox_close_btn_height\":\"20\",\"lightbox_close_btn_top\":\"-10\",\"lightbox_close_btn_right\":\"-10\",\"lightbox_close_btn_full_color\":\"FFFFFF\",\"lightbox_rl_btn_bg_color\":\"000000\",\"lightbox_rl_btn_transparent\":\"80\",\"lightbox_rl_btn_border_radius\":\"20px\",\"lightbox_rl_btn_border_width\":\"0\",\"lightbox_rl_btn_border_style\":\"none\",\"lightbox_rl_btn_border_color\":\"FFFFFF\",\"lightbox_rl_btn_box_shadow\":\"\",\"lightbox_rl_btn_color\":\"FFFFFF\",\"lightbox_rl_btn_height\":\"40\",\"lightbox_rl_btn_width\":\"40\",\"lightbox_rl_btn_size\":\"20\",\"lightbox_close_rl_btn_hover_color\":\"CCCCCC\",\"lightbox_comment_pos\":\"left\",\"lightbox_comment_width\":\"400\",\"lightbox_comment_bg_color\":\"000000\",\"lightbox_comment_font_color\":\"CCCCCC\",\"lightbox_comment_font_style\":\"segoe ui\",\"lightbox_comment_font_size\":\"12\",\"lightbox_comment_button_bg_color\":\"616161\",\"lightbox_comment_button_border_color\":\"666666\",\"lightbox_comment_button_border_width\":\"1\",\"lightbox_comment_button_border_style\":\"none\",\"lightbox_comment_button_border_radius\":\"3px\",\"lightbox_comment_button_padding\":\"3px 10px\",\"lightbox_comment_input_bg_color\":\"333333\",\"lightbox_comment_input_border_color\":\"666666\",\"lightbox_comment_input_border_width\":\"1\",\"lightbox_comment_input_border_style\":\"none\",\"lightbox_comment_input_border_radius\":\"0\",\"lightbox_comment_input_padding\":\"2px\",\"lightbox_comment_separator_width\":\"1\",\"lightbox_comment_separator_style\":\"solid\",\"lightbox_comment_separator_color\":\"383838\",\"lightbox_comment_author_font_size\":\"14\",\"lightbox_comment_date_font_size\":\"10\",\"lightbox_comment_body_font_size\":\"12\",\"lightbox_comment_share_button_color\":\"CCCCCC\",\"lightbox_filmstrip_pos\":\"top\",\"lightbox_filmstrip_rl_bg_color\":\"3B3B3B\",\"lightbox_filmstrip_rl_btn_size\":\"20\",\"lightbox_filmstrip_rl_btn_color\":\"FFFFFF\",\"lightbox_filmstrip_thumb_margin\":\"0 1px\",\"lightbox_filmstrip_thumb_border_width\":\"1\",\"lightbox_filmstrip_thumb_border_style\":\"solid\",\"lightbox_filmstrip_thumb_border_color\":\"000000\",\"lightbox_filmstrip_thumb_border_radius\":\"0\",\"lightbox_filmstrip_thumb_deactive_transparent\":\"80\",\"lightbox_filmstrip_thumb_active_border_width\":\"0\",\"lightbox_filmstrip_thumb_active_border_color\":\"FFFFFF\",\"lightbox_rl_btn_style\":\"fa-chevron\",\"album_compact_back_font_color\":\"000000\",\"album_compact_back_font_style\":\"segoe ui\",\"album_compact_back_font_size\":\"16\",\"album_compact_back_font_weight\":\"bold\",\"album_compact_back_padding\":\"0\",\"album_compact_title_font_color\":\"CCCCCC\",\"album_compact_title_font_style\":\"segoe ui\",\"album_compact_thumb_title_pos\":\"bottom\",\"album_compact_title_font_size\":\"16\",\"album_compact_title_font_weight\":\"bold\",\"album_compact_title_margin\":\"2px\",\"album_compact_title_shadow\":\"0px 0px 0px #888888\",\"album_compact_thumb_margin\":\"4\",\"album_compact_thumb_padding\":\"0\",\"album_compact_thumb_border_radius\":\"0\",\"album_compact_thumb_border_width\":\"0\",\"album_compact_thumb_border_style\":\"none\",\"album_compact_thumb_border_color\":\"CCCCCC\",\"album_compact_thumb_bg_color\":\"FFFFFF\",\"album_compact_thumbs_bg_color\":\"FFFFFF\",\"album_compact_thumb_bg_transparent\":\"0\",\"album_compact_thumb_box_shadow\":\"0px 0px 0px #888888\",\"album_compact_thumb_transparent\":\"100\",\"album_compact_thumb_align\":\"center\",\"album_compact_thumb_hover_effect\":\"scale\",\"album_compact_thumb_hover_effect_value\":\"1.1\",\"album_compact_thumb_transition\":\"0\",\"album_extended_thumb_margin\":\"2\",\"album_extended_thumb_padding\":\"0\",\"album_extended_thumb_border_radius\":\"0\",\"album_extended_thumb_border_width\":\"0\",\"album_extended_thumb_border_style\":\"none\",\"album_extended_thumb_border_color\":\"CCCCCC\",\"album_extended_thumb_bg_color\":\"FFFFFF\",\"album_extended_thumbs_bg_color\":\"FFFFFF\",\"album_extended_thumb_bg_transparent\":\"0\",\"album_extended_thumb_box_shadow\":\"\",\"album_extended_thumb_transparent\":\"100\",\"album_extended_thumb_align\":\"left\",\"album_extended_thumb_hover_effect\":\"scale\",\"album_extended_thumb_hover_effect_value\":\"1.1\",\"album_extended_thumb_transition\":\"0\",\"album_extended_back_font_color\":\"000000\",\"album_extended_back_font_style\":\"segoe ui\",\"album_extended_back_font_size\":\"20\",\"album_extended_back_font_weight\":\"bold\",\"album_extended_back_padding\":\"0\",\"album_extended_div_bg_color\":\"FFFFFF\",\"album_extended_div_bg_transparent\":\"0\",\"album_extended_div_border_radius\":\"0 0 0 0\",\"album_extended_div_margin\":\"0 0 5px 0\",\"album_extended_div_padding\":\"10\",\"album_extended_div_separator_width\":\"1\",\"album_extended_div_separator_style\":\"solid\",\"album_extended_div_separator_color\":\"E0E0E0\",\"album_extended_thumb_div_bg_color\":\"FFFFFF\",\"album_extended_thumb_div_border_radius\":\"0\",\"album_extended_thumb_div_border_width\":\"1\",\"album_extended_thumb_div_border_style\":\"solid\",\"album_extended_thumb_div_border_color\":\"E8E8E8\",\"album_extended_thumb_div_padding\":\"5px\",\"album_extended_text_div_bg_color\":\"FFFFFF\",\"album_extended_text_div_border_radius\":\"0\",\"album_extended_text_div_border_width\":\"1\",\"album_extended_text_div_border_style\":\"solid\",\"album_extended_text_div_border_color\":\"E8E8E8\",\"album_extended_text_div_padding\":\"5px\",\"album_extended_title_span_border_width\":\"1\",\"album_extended_title_span_border_style\":\"none\",\"album_extended_title_span_border_color\":\"CCCCCC\",\"album_extended_title_font_color\":\"000000\",\"album_extended_title_font_style\":\"segoe ui\",\"album_extended_title_font_size\":\"16\",\"album_extended_title_font_weight\":\"bold\",\"album_extended_title_margin_bottom\":\"2\",\"album_extended_title_padding\":\"2px\",\"album_extended_desc_span_border_width\":\"1\",\"album_extended_desc_span_border_style\":\"none\",\"album_extended_desc_span_border_color\":\"CCCCCC\",\"album_extended_desc_font_color\":\"000000\",\"album_extended_desc_font_style\":\"segoe ui\",\"album_extended_desc_font_size\":\"14\",\"album_extended_desc_font_weight\":\"normal\",\"album_extended_desc_padding\":\"2px\",\"album_extended_desc_more_color\":\"F2D22E\",\"album_extended_desc_more_size\":\"12\",\"masonry_thumb_padding\":\"4\",\"masonry_thumb_border_radius\":\"0\",\"masonry_thumb_border_width\":\"0\",\"masonry_thumb_border_style\":\"none\",\"masonry_thumb_border_color\":\"CCCCCC\",\"masonry_thumbs_bg_color\":\"FFFFFF\",\"masonry_thumb_bg_transparent\":\"0\",\"masonry_thumb_transparent\":\"100\",\"masonry_thumb_align\":\"center\",\"masonry_thumb_hover_effect\":\"scale\",\"masonry_thumb_hover_effect_value\":\"1.1\",\"masonry_thumb_transition\":\"0\",\"mosaic_thumb_padding\":\"4\",\"mosaic_thumb_border_radius\":\"0\",\"mosaic_thumb_border_width\":\"0\",\"mosaic_thumb_border_style\":\"none\",\"mosaic_thumb_border_color\":\"CCCCCC\",\"mosaic_thumbs_bg_color\":\"FFFFFF\",\"mosaic_thumb_bg_transparent\":\"0\",\"mosaic_thumb_transparent\":\"100\",\"mosaic_thumb_align\":\"center\",\"mosaic_thumb_hover_effect\":\"scale\",\"mosaic_thumb_hover_effect_value\":\"1.1\",\"mosaic_thumb_title_font_color\":\"CCCCCC\",\"mosaic_thumb_title_font_style\":\"segoe ui\",\"mosaic_thumb_title_font_size\":\"16\",\"mosaic_thumb_title_font_weight\":\"bold\",\"mosaic_thumb_title_margin\":\"2px\",\"mosaic_thumb_title_shadow\":\"0px 0px 0px #888888\",\"slideshow_cont_bg_color\":\"000000\",\"slideshow_close_btn_transparent\":\"100\",\"slideshow_rl_btn_bg_color\":\"000000\",\"slideshow_rl_btn_border_radius\":\"20px\",\"slideshow_rl_btn_border_width\":\"0\",\"slideshow_rl_btn_border_style\":\"none\",\"slideshow_rl_btn_border_color\":\"FFFFFF\",\"slideshow_rl_btn_box_shadow\":\"0px 0px 0px #000000\",\"slideshow_rl_btn_color\":\"FFFFFF\",\"slideshow_rl_btn_height\":\"40\",\"slideshow_rl_btn_size\":\"20\",\"slideshow_rl_btn_width\":\"40\",\"slideshow_close_rl_btn_hover_color\":\"CCCCCC\",\"slideshow_filmstrip_pos\":\"top\",\"slideshow_filmstrip_thumb_border_width\":\"1\",\"slideshow_filmstrip_thumb_border_style\":\"solid\",\"slideshow_filmstrip_thumb_border_color\":\"000000\",\"slideshow_filmstrip_thumb_border_radius\":\"0\",\"slideshow_filmstrip_thumb_margin\":\"0 1px\",\"slideshow_filmstrip_thumb_active_border_width\":\"0\",\"slideshow_filmstrip_thumb_active_border_color\":\"FFFFFF\",\"slideshow_filmstrip_thumb_deactive_transparent\":\"80\",\"slideshow_filmstrip_rl_bg_color\":\"3B3B3B\",\"slideshow_filmstrip_rl_btn_color\":\"FFFFFF\",\"slideshow_filmstrip_rl_btn_size\":\"20\",\"slideshow_title_font_size\":\"16\",\"slideshow_title_font\":\"segoe ui\",\"slideshow_title_color\":\"FFFFFF\",\"slideshow_title_opacity\":\"70\",\"slideshow_title_border_radius\":\"5px\",\"slideshow_title_background_color\":\"000000\",\"slideshow_title_padding\":\"0 0 0 0\",\"slideshow_description_font_size\":\"14\",\"slideshow_description_font\":\"segoe ui\",\"slideshow_description_color\":\"FFFFFF\",\"slideshow_description_opacity\":\"70\",\"slideshow_description_border_radius\":\"0\",\"slideshow_description_background_color\":\"000000\",\"slideshow_description_padding\":\"5px 10px 5px 10px\",\"slideshow_dots_width\":\"12\",\"slideshow_dots_height\":\"12\",\"slideshow_dots_border_radius\":\"5px\",\"slideshow_dots_background_color\":\"F2D22E\",\"slideshow_dots_margin\":\"3\",\"slideshow_dots_active_background_color\":\"FFFFFF\",\"slideshow_dots_active_border_width\":\"1\",\"slideshow_dots_active_border_color\":\"000000\",\"slideshow_play_pause_btn_size\":\"60\",\"slideshow_rl_btn_style\":\"fa-chevron\",\"blog_style_margin\":\"2px\",\"blog_style_padding\":\"0\",\"blog_style_border_radius\":\"0\",\"blog_style_border_width\":\"1\",\"blog_style_border_style\":\"solid\",\"blog_style_border_color\":\"F5F5F5\",\"blog_style_bg_color\":\"FFFFFF\",\"blog_style_box_shadow\":\"\",\"blog_style_transparent\":\"80\",\"blog_style_align\":\"center\",\"blog_style_share_buttons_bg_color\":\"FFFFFF\",\"blog_style_share_buttons_margin\":\"5px auto 10px auto\",\"blog_style_share_buttons_border_radius\":\"0\",\"blog_style_share_buttons_border_width\":\"0\",\"blog_style_share_buttons_border_style\":\"none\",\"blog_style_share_buttons_border_color\":\"000000\",\"blog_style_share_buttons_align\":\"right\",\"blog_style_img_font_size\":\"16\",\"blog_style_img_font_family\":\"segoe ui\",\"blog_style_img_font_color\":\"000000\",\"blog_style_share_buttons_color\":\"B3AFAF\",\"blog_style_share_buttons_bg_transparent\":\"0\",\"blog_style_share_buttons_font_size\":\"20\",\"image_browser_margin\":\"2px auto\",\"image_browser_padding\":\"4px\",\"image_browser_border_radius\":\"0\",\"image_browser_border_width\":\"1\",\"image_browser_border_style\":\"none\",\"image_browser_border_color\":\"F5F5F5\",\"image_browser_bg_color\":\"EBEBEB\",\"image_browser_box_shadow\":\"\",\"image_browser_transparent\":\"80\",\"image_browser_align\":\"center\",\"image_browser_image_description_margin\":\"0px 5px 0px 5px\",\"image_browser_image_description_padding\":\"8px 8px 8px 8px\",\"image_browser_image_description_border_radius\":\"0\",\"image_browser_image_description_border_width\":\"1\",\"image_browser_image_description_border_style\":\"none\",\"image_browser_image_description_border_color\":\"FFFFFF\",\"image_browser_image_description_bg_color\":\"EBEBEB\",\"image_browser_image_description_align\":\"center\",\"image_browser_img_font_size\":\"15\",\"image_browser_img_font_family\":\"segoe ui\",\"image_browser_img_font_color\":\"000000\",\"image_browser_full_padding\":\"4px\",\"image_browser_full_border_radius\":\"0\",\"image_browser_full_border_width\":\"2\",\"image_browser_full_border_style\":\"none\",\"image_browser_full_border_color\":\"F7F7F7\",\"image_browser_full_bg_color\":\"F5F5F5\",\"image_browser_full_transparent\":\"90\",\"lightbox_info_pos\":\"top\",\"lightbox_info_align\":\"right\",\"lightbox_info_bg_color\":\"000000\",\"lightbox_info_bg_transparent\":\"70\",\"lightbox_info_border_width\":\"1\",\"lightbox_info_border_style\":\"none\",\"lightbox_info_border_color\":\"000000\",\"lightbox_info_border_radius\":\"5px\",\"lightbox_info_padding\":\"5px\",\"lightbox_info_margin\":\"15px\",\"lightbox_title_color\":\"FFFFFF\",\"lightbox_title_font_style\":\"segoe ui\",\"lightbox_title_font_weight\":\"bold\",\"lightbox_title_font_size\":\"18\",\"lightbox_description_color\":\"FFFFFF\",\"lightbox_description_font_style\":\"segoe ui\",\"lightbox_description_font_weight\":\"normal\",\"lightbox_description_font_size\":\"14\",\"lightbox_rate_pos\":\"bottom\",\"lightbox_rate_align\":\"right\",\"lightbox_rate_icon\":\"star\",\"lightbox_rate_color\":\"F9D062\",\"lightbox_rate_size\":\"20\",\"lightbox_rate_stars_count\":\"5\",\"lightbox_rate_padding\":\"15px\",\"lightbox_rate_hover_color\":\"F7B50E\",\"lightbox_hit_pos\":\"bottom\",\"lightbox_hit_align\":\"left\",\"lightbox_hit_bg_color\":\"000000\",\"lightbox_hit_bg_transparent\":\"70\",\"lightbox_hit_border_width\":\"1\",\"lightbox_hit_border_style\":\"none\",\"lightbox_hit_border_color\":\"000000\",\"lightbox_hit_border_radius\":\"5px\",\"lightbox_hit_padding\":\"5px\",\"lightbox_hit_margin\":\"0 5px\",\"lightbox_hit_color\":\"FFFFFF\",\"lightbox_hit_font_style\":\"segoe ui\",\"lightbox_hit_font_weight\":\"normal\",\"lightbox_hit_font_size\":\"14\",\"masonry_description_font_size\":\"12\",\"masonry_description_color\":\"CCCCCC\",\"masonry_description_font_style\":\"segoe ui\",\"album_masonry_back_font_color\":\"000000\",\"album_masonry_back_font_style\":\"segoe ui\",\"album_masonry_back_font_size\":\"16\",\"album_masonry_back_font_weight\":\"bold\",\"album_masonry_back_padding\":\"0\",\"album_masonry_title_font_color\":\"CCCCCC\",\"album_masonry_title_font_style\":\"segoe ui\",\"album_masonry_thumb_title_pos\":\"bottom\",\"album_masonry_title_font_size\":\"16\",\"album_masonry_title_font_weight\":\"bold\",\"album_masonry_title_margin\":\"2px\",\"album_masonry_title_shadow\":\"0px 0px 0px #888888\",\"album_masonry_thumb_margin\":\"4\",\"album_masonry_thumb_padding\":\"0\",\"album_masonry_thumb_border_radius\":\"0\",\"album_masonry_thumb_border_width\":\"0\",\"album_masonry_thumb_border_style\":\"none\",\"album_masonry_thumb_border_color\":\"CCCCCC\",\"album_masonry_thumb_bg_color\":\"FFFFFF\",\"album_masonry_thumbs_bg_color\":\"FFFFFF\",\"album_masonry_thumb_bg_transparent\":\"0\",\"album_masonry_thumb_box_shadow\":\"0px 0px 0px #888888\",\"album_masonry_thumb_transparent\":\"100\",\"album_masonry_thumb_align\":\"center\",\"album_masonry_thumb_hover_effect\":\"scale\",\"album_masonry_thumb_hover_effect_value\":\"1.1\",\"album_masonry_thumb_transition\":\"0\",\"carousel_cont_bg_color\":\"000000\",\"carousel_cont_btn_transparent\":\"0\",\"carousel_close_btn_transparent\":\"100\",\"carousel_rl_btn_bg_color\":\"000000\",\"carousel_rl_btn_border_radius\":\"20px\",\"carousel_rl_btn_border_width\":\"0\",\"carousel_rl_btn_border_style\":\"none\",\"carousel_rl_btn_border_color\":\"FFFFFF\",\"carousel_rl_btn_color\":\"FFFFFF\",\"carousel_rl_btn_height\":\"40\",\"carousel_rl_btn_size\":\"20\",\"carousel_play_pause_btn_size\":\"20\",\"carousel_rl_btn_width\":\"40\",\"carousel_close_rl_btn_hover_color\":\"CCCCCC\",\"carousel_rl_btn_style\":\"fa-chevron\",\"carousel_mergin_bottom\":\"0.5\",\"carousel_font_family\":\"Arial\",\"carousel_feature_border_width\":\"2\",\"carousel_feature_border_style\":\"solid\",\"carousel_feature_border_color\":\"5D204F\",\"carousel_caption_background_color\":\"000000\",\"carousel_caption_bottom\":\"0\",\"carousel_caption_p_mergin\":\"0\",\"carousel_caption_p_pedding\":\"5\",\"carousel_caption_p_font_weight\":\"bold\",\"carousel_caption_p_font_size\":\"14\",\"carousel_caption_p_color\":\"white\",\"carousel_title_opacity\":\"100\",\"carousel_title_border_radius\":\"5px\",\"mosaic_thumb_transition\":\"1\"}");
INSERT INTO `wp_bwg_theme` VALUES("2", "Theme 2", "0", "{\"thumb_margin\":\"4\",\"thumb_padding\":\"4\",\"thumb_border_radius\":\"0\",\"thumb_border_width\":\"5\",\"thumb_border_style\":\"none\",\"thumb_border_color\":\"FFFFFF\",\"thumb_bg_color\":\"E8E8E8\",\"thumbs_bg_color\":\"FFFFFF\",\"thumb_bg_transparent\":\"0\",\"thumb_box_shadow\":\"0px 0px 0px #888888\",\"thumb_transparent\":\"100\",\"thumb_align\":\"center\",\"thumb_hover_effect\":\"rotate\",\"thumb_hover_effect_value\":\"2deg\",\"thumb_transition\":\"1\",\"thumb_title_font_color\":\"CCCCCC\",\"thumb_title_font_style\":\"segoe ui\",\"thumb_title_pos\":\"bottom\",\"thumb_title_font_size\":\"16\",\"thumb_title_font_weight\":\"bold\",\"thumb_title_margin\":\"5px\",\"thumb_title_shadow\":\"\",\"page_nav_position\":\"bottom\",\"page_nav_align\":\"center\",\"page_nav_number\":\"0\",\"page_nav_font_size\":\"12\",\"page_nav_font_style\":\"segoe ui\",\"page_nav_font_color\":\"666666\",\"page_nav_font_weight\":\"bold\",\"page_nav_border_width\":\"1\",\"page_nav_border_style\":\"none\",\"page_nav_border_color\":\"E3E3E3\",\"page_nav_border_radius\":\"0\",\"page_nav_margin\":\"0\",\"page_nav_padding\":\"3px 6px\",\"page_nav_button_bg_color\":\"FCFCFC\",\"page_nav_button_bg_transparent\":\"100\",\"page_nav_box_shadow\":\"0\",\"page_nav_button_transition\":\"1\",\"page_nav_button_text\":\"0\",\"lightbox_overlay_bg_color\":\"000000\",\"lightbox_overlay_bg_transparent\":\"70\",\"lightbox_bg_color\":\"000000\",\"lightbox_ctrl_btn_pos\":\"bottom\",\"lightbox_ctrl_btn_align\":\"center\",\"lightbox_ctrl_btn_height\":\"20\",\"lightbox_ctrl_btn_margin_top\":\"10\",\"lightbox_ctrl_btn_margin_left\":\"7\",\"lightbox_ctrl_btn_transparent\":\"80\",\"lightbox_ctrl_btn_color\":\"FFFFFF\",\"lightbox_toggle_btn_height\":\"14\",\"lightbox_toggle_btn_width\":\"100\",\"lightbox_ctrl_cont_bg_color\":\"000000\",\"lightbox_ctrl_cont_transparent\":\"80\",\"lightbox_ctrl_cont_border_radius\":\"4\",\"lightbox_close_btn_transparent\":\"95\",\"lightbox_close_btn_bg_color\":\"000000\",\"lightbox_close_btn_border_width\":\"0\",\"lightbox_close_btn_border_radius\":\"16px\",\"lightbox_close_btn_border_style\":\"none\",\"lightbox_close_btn_border_color\":\"FFFFFF\",\"lightbox_close_btn_box_shadow\":\"\",\"lightbox_close_btn_color\":\"FFFFFF\",\"lightbox_close_btn_size\":\"10\",\"lightbox_close_btn_width\":\"20\",\"lightbox_close_btn_height\":\"20\",\"lightbox_close_btn_top\":\"-10\",\"lightbox_close_btn_right\":\"-10\",\"lightbox_close_btn_full_color\":\"FFFFFF\",\"lightbox_rl_btn_bg_color\":\"000000\",\"lightbox_rl_btn_transparent\":\"80\",\"lightbox_rl_btn_border_radius\":\"20px\",\"lightbox_rl_btn_border_width\":\"2\",\"lightbox_rl_btn_border_style\":\"none\",\"lightbox_rl_btn_border_color\":\"FFFFFF\",\"lightbox_rl_btn_box_shadow\":\"\",\"lightbox_rl_btn_color\":\"FFFFFF\",\"lightbox_rl_btn_height\":\"40\",\"lightbox_rl_btn_width\":\"40\",\"lightbox_rl_btn_size\":\"20\",\"lightbox_close_rl_btn_hover_color\":\"FFFFFF\",\"lightbox_comment_pos\":\"left\",\"lightbox_comment_width\":\"400\",\"lightbox_comment_bg_color\":\"000000\",\"lightbox_comment_font_color\":\"CCCCCC\",\"lightbox_comment_font_style\":\"arial\",\"lightbox_comment_font_size\":\"12\",\"lightbox_comment_button_bg_color\":\"333333\",\"lightbox_comment_button_border_color\":\"666666\",\"lightbox_comment_button_border_width\":\"1\",\"lightbox_comment_button_border_style\":\"none\",\"lightbox_comment_button_border_radius\":\"3px\",\"lightbox_comment_button_padding\":\"3px 10px\",\"lightbox_comment_input_bg_color\":\"333333\",\"lightbox_comment_input_border_color\":\"666666\",\"lightbox_comment_input_border_width\":\"1\",\"lightbox_comment_input_border_style\":\"none\",\"lightbox_comment_input_border_radius\":\"0\",\"lightbox_comment_input_padding\":\"3px\",\"lightbox_comment_separator_width\":\"1\",\"lightbox_comment_separator_style\":\"solid\",\"lightbox_comment_separator_color\":\"2B2B2B\",\"lightbox_comment_author_font_size\":\"14\",\"lightbox_comment_date_font_size\":\"10\",\"lightbox_comment_body_font_size\":\"12\",\"lightbox_comment_share_button_color\":\"FFFFFF\",\"lightbox_filmstrip_pos\":\"top\",\"lightbox_filmstrip_rl_bg_color\":\"2B2B2B\",\"lightbox_filmstrip_rl_btn_size\":\"20\",\"lightbox_filmstrip_rl_btn_color\":\"FFFFFF\",\"lightbox_filmstrip_thumb_margin\":\"0 1px\",\"lightbox_filmstrip_thumb_border_width\":\"1\",\"lightbox_filmstrip_thumb_border_style\":\"none\",\"lightbox_filmstrip_thumb_border_color\":\"000000\",\"lightbox_filmstrip_thumb_border_radius\":\"0\",\"lightbox_filmstrip_thumb_deactive_transparent\":\"80\",\"lightbox_filmstrip_thumb_active_border_width\":\"0\",\"lightbox_filmstrip_thumb_active_border_color\":\"FFFFFF\",\"lightbox_rl_btn_style\":\"fa-chevron\",\"album_compact_back_font_color\":\"000000\",\"album_compact_back_font_style\":\"segoe ui\",\"album_compact_back_font_size\":\"14\",\"album_compact_back_font_weight\":\"normal\",\"album_compact_back_padding\":\"0\",\"album_compact_title_font_color\":\"CCCCCC\",\"album_compact_title_font_style\":\"segoe ui\",\"album_compact_thumb_title_pos\":\"bottom\",\"album_compact_title_font_size\":\"16\",\"album_compact_title_font_weight\":\"bold\",\"album_compact_title_margin\":\"5px\",\"album_compact_title_shadow\":\"\",\"album_compact_thumb_margin\":\"4\",\"album_compact_thumb_padding\":\"4\",\"album_compact_thumb_border_radius\":\"0\",\"album_compact_thumb_border_width\":\"1\",\"album_compact_thumb_border_style\":\"none\",\"album_compact_thumb_border_color\":\"000000\",\"album_compact_thumb_bg_color\":\"E8E8E8\",\"album_compact_thumbs_bg_color\":\"FFFFFF\",\"album_compact_thumb_bg_transparent\":\"100\",\"album_compact_thumb_box_shadow\":\"\",\"album_compact_thumb_transparent\":\"100\",\"album_compact_thumb_align\":\"center\",\"album_compact_thumb_hover_effect\":\"rotate\",\"album_compact_thumb_hover_effect_value\":\"2deg\",\"album_compact_thumb_transition\":\"1\",\"album_extended_thumb_margin\":\"2\",\"album_extended_thumb_padding\":\"4\",\"album_extended_thumb_border_radius\":\"0\",\"album_extended_thumb_border_width\":\"4\",\"album_extended_thumb_border_style\":\"none\",\"album_extended_thumb_border_color\":\"E8E8E8\",\"album_extended_thumb_bg_color\":\"E8E8E8\",\"album_extended_thumbs_bg_color\":\"FFFFFF\",\"album_extended_thumb_bg_transparent\":\"100\",\"album_extended_thumb_box_shadow\":\"\",\"album_extended_thumb_transparent\":\"100\",\"album_extended_thumb_align\":\"left\",\"album_extended_thumb_hover_effect\":\"rotate\",\"album_extended_thumb_hover_effect_value\":\"2deg\",\"album_extended_thumb_transition\":\"0\",\"album_extended_back_font_color\":\"000000\",\"album_extended_back_font_style\":\"segoe ui\",\"album_extended_back_font_size\":\"16\",\"album_extended_back_font_weight\":\"bold\",\"album_extended_back_padding\":\"0\",\"album_extended_div_bg_color\":\"FFFFFF\",\"album_extended_div_bg_transparent\":\"0\",\"album_extended_div_border_radius\":\"0\",\"album_extended_div_margin\":\"0 0 5px 0\",\"album_extended_div_padding\":\"10\",\"album_extended_div_separator_width\":\"1\",\"album_extended_div_separator_style\":\"none\",\"album_extended_div_separator_color\":\"CCCCCC\",\"album_extended_thumb_div_bg_color\":\"FFFFFF\",\"album_extended_thumb_div_border_radius\":\"0\",\"album_extended_thumb_div_border_width\":\"0\",\"album_extended_thumb_div_border_style\":\"none\",\"album_extended_thumb_div_border_color\":\"CCCCCC\",\"album_extended_thumb_div_padding\":\"0\",\"album_extended_text_div_bg_color\":\"FFFFFF\",\"album_extended_text_div_border_radius\":\"0\",\"album_extended_text_div_border_width\":\"1\",\"album_extended_text_div_border_style\":\"none\",\"album_extended_text_div_border_color\":\"CCCCCC\",\"album_extended_text_div_padding\":\"5px\",\"album_extended_title_span_border_width\":\"1\",\"album_extended_title_span_border_style\":\"none\",\"album_extended_title_span_border_color\":\"CCCCCC\",\"album_extended_title_font_color\":\"000000\",\"album_extended_title_font_style\":\"segoe ui\",\"album_extended_title_font_size\":\"16\",\"album_extended_title_font_weight\":\"bold\",\"album_extended_title_margin_bottom\":\"2\",\"album_extended_title_padding\":\"2px\",\"album_extended_desc_span_border_width\":\"1\",\"album_extended_desc_span_border_style\":\"none\",\"album_extended_desc_span_border_color\":\"CCCCCC\",\"album_extended_desc_font_color\":\"000000\",\"album_extended_desc_font_style\":\"segoe ui\",\"album_extended_desc_font_size\":\"14\",\"album_extended_desc_font_weight\":\"normal\",\"album_extended_desc_padding\":\"2px\",\"album_extended_desc_more_color\":\"FFC933\",\"album_extended_desc_more_size\":\"12\",\"masonry_thumb_padding\":\"4\",\"masonry_thumb_border_radius\":\"2px\",\"masonry_thumb_border_width\":\"1\",\"masonry_thumb_border_style\":\"none\",\"masonry_thumb_border_color\":\"CCCCCC\",\"masonry_thumbs_bg_color\":\"FFFFFF\",\"masonry_thumb_bg_transparent\":\"0\",\"masonry_thumb_transparent\":\"80\",\"masonry_thumb_align\":\"center\",\"masonry_thumb_hover_effect\":\"rotate\",\"masonry_thumb_hover_effect_value\":\"2deg\",\"masonry_thumb_transition\":\"0\",\"mosaic_thumb_padding\":\"4\",\"mosaic_thumb_border_radius\":\"2px\",\"mosaic_thumb_border_width\":\"1\",\"mosaic_thumb_border_style\":\"none\",\"mosaic_thumb_border_color\":\"CCCCCC\",\"mosaic_thumbs_bg_color\":\"FFFFFF\",\"mosaic_thumb_bg_transparent\":\"0\",\"mosaic_thumb_transparent\":\"80\",\"mosaic_thumb_align\":\"center\",\"mosaic_thumb_hover_effect\":\"rotate\",\"mosaic_thumb_hover_effect_value\":\"2deg\",\"mosaic_thumb_title_font_color\":\"CCCCCC\",\"mosaic_thumb_title_font_style\":\"segoe ui\",\"mosaic_thumb_title_font_size\":\"16\",\"mosaic_thumb_title_font_weight\":\"bold\",\"mosaic_thumb_title_margin\":\"2px\",\"mosaic_thumb_title_shadow\":\"0px 0px 0px #888888\",\"slideshow_cont_bg_color\":\"000000\",\"slideshow_close_btn_transparent\":\"100\",\"slideshow_rl_btn_bg_color\":\"000000\",\"slideshow_rl_btn_border_radius\":\"20px\",\"slideshow_rl_btn_border_width\":\"0\",\"slideshow_rl_btn_border_style\":\"none\",\"slideshow_rl_btn_border_color\":\"FFFFFF\",\"slideshow_rl_btn_box_shadow\":\"\",\"slideshow_rl_btn_color\":\"FFFFFF\",\"slideshow_rl_btn_height\":\"40\",\"slideshow_rl_btn_size\":\"20\",\"slideshow_rl_btn_width\":\"40\",\"slideshow_close_rl_btn_hover_color\":\"DBDBDB\",\"slideshow_filmstrip_pos\":\"bottom\",\"slideshow_filmstrip_thumb_border_width\":\"1\",\"slideshow_filmstrip_thumb_border_style\":\"none\",\"slideshow_filmstrip_thumb_border_color\":\"000000\",\"slideshow_filmstrip_thumb_border_radius\":\"0\",\"slideshow_filmstrip_thumb_margin\":\"0 1px\",\"slideshow_filmstrip_thumb_active_border_width\":\"0\",\"slideshow_filmstrip_thumb_active_border_color\":\"FFFFFF\",\"slideshow_filmstrip_thumb_deactive_transparent\":\"80\",\"slideshow_filmstrip_rl_bg_color\":\"303030\",\"slideshow_filmstrip_rl_btn_color\":\"FFFFFF\",\"slideshow_filmstrip_rl_btn_size\":\"20\",\"slideshow_title_font_size\":\"16\",\"slideshow_title_font\":\"segoe ui\",\"slideshow_title_color\":\"FFFFFF\",\"slideshow_title_opacity\":\"70\",\"slideshow_title_border_radius\":\"5px\",\"slideshow_title_background_color\":\"000000\",\"slideshow_title_padding\":\"5px 10px 5px 10px\",\"slideshow_description_font_size\":\"14\",\"slideshow_description_font\":\"segoe ui\",\"slideshow_description_color\":\"FFFFFF\",\"slideshow_description_opacity\":\"70\",\"slideshow_description_border_radius\":\"0\",\"slideshow_description_background_color\":\"000000\",\"slideshow_description_padding\":\"5px 10px 5px 10px\",\"slideshow_dots_width\":\"10\",\"slideshow_dots_height\":\"10\",\"slideshow_dots_border_radius\":\"10px\",\"slideshow_dots_background_color\":\"292929\",\"slideshow_dots_margin\":\"1\",\"slideshow_dots_active_background_color\":\"292929\",\"slideshow_dots_active_border_width\":\"2\",\"slideshow_dots_active_border_color\":\"FFC933\",\"slideshow_play_pause_btn_size\":\"60\",\"slideshow_rl_btn_style\":\"fa-chevron\",\"blog_style_margin\":\"2px\",\"blog_style_padding\":\"4px\",\"blog_style_border_radius\":\"0\",\"blog_style_border_width\":\"1\",\"blog_style_border_style\":\"none\",\"blog_style_border_color\":\"CCCCCC\",\"blog_style_bg_color\":\"E8E8E8\",\"blog_style_box_shadow\":\"\",\"blog_style_transparent\":\"70\",\"blog_style_align\":\"center\",\"blog_style_share_buttons_bg_color\":\"FFFFFF\",\"blog_style_share_buttons_margin\":\"5px auto 10px auto\",\"blog_style_share_buttons_border_radius\":\"0\",\"blog_style_share_buttons_border_width\":\"0\",\"blog_style_share_buttons_border_style\":\"none\",\"blog_style_share_buttons_border_color\":\"000000\",\"blog_style_share_buttons_align\":\"right\",\"blog_style_img_font_size\":\"16\",\"blog_style_img_font_family\":\"segoe ui\",\"blog_style_img_font_color\":\"000000\",\"blog_style_share_buttons_color\":\"A1A1A1\",\"blog_style_share_buttons_bg_transparent\":\"0\",\"blog_style_share_buttons_font_size\":\"20\",\"image_browser_margin\":\"2px auto\",\"image_browser_padding\":\"4px\",\"image_browser_border_radius\":\"2px\",\"image_browser_border_width\":\"1\",\"image_browser_border_style\":\"none\",\"image_browser_border_color\":\"E8E8E8\",\"image_browser_bg_color\":\"E8E8E8\",\"image_browser_box_shadow\":\"\",\"image_browser_transparent\":\"80\",\"image_browser_align\":\"center\",\"image_browser_image_description_margin\":\"24px 0px 0px 0px\",\"image_browser_image_description_padding\":\"8px 8px 8px 8px\",\"image_browser_image_description_border_radius\":\"0\",\"image_browser_image_description_border_width\":\"1\",\"image_browser_image_description_border_style\":\"none\",\"image_browser_image_description_border_color\":\"FFFFFF\",\"image_browser_image_description_bg_color\":\"E8E8E8\",\"image_browser_image_description_align\":\"center\",\"image_browser_img_font_size\":\"14\",\"image_browser_img_font_family\":\"segoe ui\",\"image_browser_img_font_color\":\"000000\",\"image_browser_full_padding\":\"4px\",\"image_browser_full_border_radius\":\"0\",\"image_browser_full_border_width\":\"1\",\"image_browser_full_border_style\":\"solid\",\"image_browser_full_border_color\":\"EDEDED\",\"image_browser_full_bg_color\":\"FFFFFF\",\"image_browser_full_transparent\":\"90\",\"lightbox_info_pos\":\"top\",\"lightbox_info_align\":\"right\",\"lightbox_info_bg_color\":\"000000\",\"lightbox_info_bg_transparent\":\"70\",\"lightbox_info_border_width\":\"1\",\"lightbox_info_border_style\":\"none\",\"lightbox_info_border_color\":\"000000\",\"lightbox_info_border_radius\":\"5px\",\"lightbox_info_padding\":\"5px\",\"lightbox_info_margin\":\"15px\",\"lightbox_title_color\":\"FFFFFF\",\"lightbox_title_font_style\":\"segoe ui\",\"lightbox_title_font_weight\":\"bold\",\"lightbox_title_font_size\":\"18\",\"lightbox_description_color\":\"FFFFFF\",\"lightbox_description_font_style\":\"segoe ui\",\"lightbox_description_font_weight\":\"normal\",\"lightbox_description_font_size\":\"14\",\"lightbox_rate_pos\":\"bottom\",\"lightbox_rate_align\":\"right\",\"lightbox_rate_icon\":\"star\",\"lightbox_rate_color\":\"F9D062\",\"lightbox_rate_size\":\"20\",\"lightbox_rate_stars_count\":\"5\",\"lightbox_rate_padding\":\"15px\",\"lightbox_rate_hover_color\":\"F7B50E\",\"lightbox_hit_pos\":\"bottom\",\"lightbox_hit_align\":\"left\",\"lightbox_hit_bg_color\":\"000000\",\"lightbox_hit_bg_transparent\":\"70\",\"lightbox_hit_border_width\":\"1\",\"lightbox_hit_border_style\":\"none\",\"lightbox_hit_border_color\":\"000000\",\"lightbox_hit_border_radius\":\"5px\",\"lightbox_hit_padding\":\"5px\",\"lightbox_hit_margin\":\"0 5px\",\"lightbox_hit_color\":\"FFFFFF\",\"lightbox_hit_font_style\":\"segoe ui\",\"lightbox_hit_font_weight\":\"normal\",\"lightbox_hit_font_size\":\"14\",\"masonry_description_font_size\":\"12\",\"masonry_description_color\":\"CCCCCC\",\"masonry_description_font_style\":\"segoe ui\",\"album_masonry_back_font_color\":\"000000\",\"album_masonry_back_font_style\":\"segoe ui\",\"album_masonry_back_font_size\":\"14\",\"album_masonry_back_font_weight\":\"normal\",\"album_masonry_back_padding\":\"0\",\"album_masonry_title_font_color\":\"CCCCCC\",\"album_masonry_title_font_style\":\"segoe ui\",\"album_masonry_thumb_title_pos\":\"bottom\",\"album_masonry_title_font_size\":\"16\",\"album_masonry_title_font_weight\":\"bold\",\"album_masonry_title_margin\":\"5px\",\"album_masonry_title_shadow\":\"\",\"album_masonry_thumb_margin\":\"4\",\"album_masonry_thumb_padding\":\"4\",\"album_masonry_thumb_border_radius\":\"0\",\"album_masonry_thumb_border_width\":\"1\",\"album_masonry_thumb_border_style\":\"none\",\"album_masonry_thumb_border_color\":\"000000\",\"album_masonry_thumb_bg_color\":\"E8E8E8\",\"album_masonry_thumbs_bg_color\":\"FFFFFF\",\"album_masonry_thumb_bg_transparent\":\"100\",\"album_masonry_thumb_box_shadow\":\"\",\"album_masonry_thumb_transparent\":\"100\",\"album_masonry_thumb_align\":\"center\",\"album_masonry_thumb_hover_effect\":\"rotate\",\"album_masonry_thumb_hover_effect_value\":\"2deg\",\"album_masonry_thumb_transition\":\"1\",\"carousel_cont_bg_color\":\"000000\",\"carousel_cont_btn_transparent\":\"0\",\"carousel_close_btn_transparent\":\"100\",\"carousel_rl_btn_bg_color\":\"000000\",\"carousel_rl_btn_border_radius\":\"20px\",\"carousel_rl_btn_border_width\":\"0\",\"carousel_rl_btn_border_style\":\"none\",\"carousel_rl_btn_border_color\":\"FFFFFF\",\"carousel_rl_btn_color\":\"FFFFFF\",\"carousel_rl_btn_height\":\"40\",\"carousel_rl_btn_size\":\"20\",\"carousel_play_pause_btn_size\":\"20\",\"carousel_rl_btn_width\":\"40\",\"carousel_close_rl_btn_hover_color\":\"CCCCCC\",\"carousel_rl_btn_style\":\"fa-chevron\",\"carousel_mergin_bottom\":\"0.5\",\"carousel_font_family\":\"Arial\",\"carousel_feature_border_width\":\"2\",\"carousel_feature_border_style\":\"solid\",\"carousel_feature_border_color\":\"5D204F\",\"carousel_caption_background_color\":\"000000\",\"carousel_caption_bottom\":\"0\",\"carousel_caption_p_mergin\":\"0\",\"carousel_caption_p_pedding\":\"5\",\"carousel_caption_p_font_weight\":\"bold\",\"carousel_caption_p_font_size\":\"14\",\"carousel_caption_p_color\":\"white\",\"carousel_title_opacity\":\"100\",\"carousel_title_border_radius\":\"5px\",\"mosaic_thumb_transition\":\"1\"}");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "econolodge", "723466409e890c2d4743_20181211164701", "20", "2018-12-11 16:47:30", "econolodge", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2018-12-11 16:47:01\";s:7:\"Version\";s:6:\"1.2.52\";s:9:\"VersionWP\";s:3:\"5.0\";s:9:\"VersionDB\";s:7:\"10.1.36\";s:10:\"VersionPHP\";s:6:\"5.6.38\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:10:\"econolodge\";s:4:\"Hash\";s:35:\"723466409e890c2d4743_20181211164701\";s:8:\"NameHash\";s:46:\"econolodge_723466409e890c2d4743_20181211164701\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:48:\"/home/econolodge/public_html/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:47:\"https://www.econolodgeloon.com/wp/wp-snapshots/\";s:8:\"ScanFile\";s:56:\"econolodge_723466409e890c2d4743_20181211164701_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";s:10:\"econolodge\";s:7:\"Archive\";O:11:\"DUP_Archive\":19:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:58:\"econolodge_723466409e890c2d4743_20181211164701_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:31:\"/home/econolodge/public_html/wp\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2018-12-11 16:47:01\";s:7:\"Version\";s:6:\"1.2.52\";s:9:\"VersionWP\";s:3:\"5.0\";s:9:\"VersionDB\";s:7:\"10.1.36\";s:10:\"VersionPHP\";s:6:\"5.6.38\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:10:\"econolodge\";s:4:\"Hash\";s:35:\"723466409e890c2d4743_20181211164701\";s:8:\"NameHash\";s:46:\"econolodge_723466409e890c2d4743_20181211164701\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:48:\"/home/econolodge/public_html/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:47:\"https://www.econolodgeloon.com/wp/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";r:22;s:9:\"Installer\";O:13:\"DUP_Installer\":9:{s:4:\"File\";s:60:\"econolodge_723466409e890c2d4743_20181211164701_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:20:\"dGVdUm1Ie3BlU31FIUAj\";s:10:\"\0*\0Package\";r:58;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:59:\"econolodge_723466409e890c2d4743_20181211164701_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:40:\"/home/econolodge/public_html/wp/wp-admin\";i:1;s:50:\"/home/econolodge/public_html/wp/wp-content/uploads\";i:2;s:52:\"/home/econolodge/public_html/wp/wp-content/languages\";i:3;s:50:\"/home/econolodge/public_html/wp/wp-content/plugins\";i:4;s:49:\"/home/econolodge/public_html/wp/wp-content/themes\";i:5;s:43:\"/home/econolodge/public_html/wp/wp-includes\";}}s:9:\"Installer\";r:80;s:8:\"Database\";r:90;}");

/* INSERT TABLE DATA: wp_easy_gallery */
INSERT INTO `wp_easy_gallery` VALUES("16", "Captain Bounty Rooms", "captainbountyrooms", "", "", "300", "175");

/* INSERT TABLE DATA: wp_ngg_gallery */
INSERT INTO `wp_ngg_gallery` VALUES("1", "boscobel-mansion-rooms", "boscobel-mansion-rooms", "wp-content/gallery/boscobel-mansion-rooms", "Boscobel Mansion Rooms", "", "0", "0", "1");

/* INSERT TABLE DATA: wp_ngg_pictures */
INSERT INTO `wp_ngg_pictures` VALUES("1", "bocobel-room-1", "0", "1", "boscobel1.jpg", "", "Bocobel Room 1", "2014-02-27 20:55:38", "0", "0", "eyJ3aWR0aCI6NzAwLCJoZWlnaHQiOjQ2NSwiZnVsbCI6eyJ3aWR0aCI6NzAwLCJoZWlnaHQiOjQ2NX0sInRodW1ibmFpbCI6eyJ3aWR0aCI6MTIwLCJoZWlnaHQiOjkwLCJmaWxlbmFtZSI6InRodW1ic19ib3Njb2JlbDEuanBnIiwiZ2VuZXJhdGVkIjoiMC43MzM4NTAwMCAxMzkzNTM0NTM4In0sImFwZXJ0dXJlIjpmYWxzZSwiY3JlZGl0IjpmYWxzZSwiY2FtZXJhIjpmYWxzZSwiY2FwdGlvbiI6ZmFsc2UsImNyZWF0ZWRfdGltZXN0YW1wIjpmYWxzZSwiY29weXJpZ2h0IjpmYWxzZSwiZm9jYWxfbGVuZ3RoIjpmYWxzZSwiaXNvIjpmYWxzZSwic2h1dHRlcl9zcGVlZCI6ZmFsc2UsImZsYXNoIjpmYWxzZSwidGl0bGUiOmZhbHNlLCJrZXl3b3JkcyI6ZmFsc2UsInNhdmVkIjp0cnVlLCJuZ2cwZHluLTIwMHgyMDB4OTAtMDBmMHcwMTBjMDEwcjExMGYxMTByMDEwdDAzanBnIjp7IndpZHRoIjoxOTgsImhlaWdodCI6MTMyLCJmaWxlbmFtZSI6ImJvc2NvYmVsMS1uZ2dpZDAxMS1uZ2cwZHluLTIwMHgyMDB4OTAtMDBmMHcwMTBjMDEwcjExMGYxMTByMDEwdDAzanBnLmpwZyIsImdlbmVyYXRlZCI6IjAuMjk0NzY2MDAgMTM5MzUzOTUzNyJ9fQ==");
INSERT INTO `wp_ngg_pictures` VALUES("2", "boscobel-room-2-sitting-area", "0", "1", "boscobel2sit_copy.jpg", " ", "Boscobel Room 2 Sitting Area", "2014-02-27 20:56:38", "0", "0", "a:17:{s:5:\"width\";i:700;s:6:\"height\";i:977;s:4:\"full\";a:2:{s:5:\"width\";i:700;s:6:\"height\";i:977;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:28:\"thumbs_boscobel2sit_copy.jpg\";s:9:\"generated\";s:21:\"0.81888000 1393534598\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");
INSERT INTO `wp_ngg_pictures` VALUES("3", "boscobel2b", "0", "1", "boscobel2b.jpg", " ", "boscobel2b", "2014-02-27 20:56:38", "0", "0", "a:17:{s:5:\"width\";i:377;s:6:\"height\";i:650;s:4:\"full\";a:2:{s:5:\"width\";i:377;s:6:\"height\";i:650;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:21:\"thumbs_boscobel2b.jpg\";s:9:\"generated\";s:21:\"0.89606800 1393534598\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");
INSERT INTO `wp_ngg_pictures` VALUES("4", "boscobel3", "0", "1", "boscobel3.jpg", " ", "boscobel3", "2014-02-27 20:56:41", "0", "0", "a:17:{s:5:\"width\";i:700;s:6:\"height\";i:454;s:4:\"full\";a:2:{s:5:\"width\";i:700;s:6:\"height\";i:454;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:20:\"thumbs_boscobel3.jpg\";s:9:\"generated\";s:21:\"0.28556100 1393534601\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");
INSERT INTO `wp_ngg_pictures` VALUES("5", "boscobel3a_copy", "0", "1", "boscobel3a_copy.jpg", " ", "boscobel3a_copy", "2014-02-27 20:56:41", "0", "0", "a:17:{s:5:\"width\";i:418;s:6:\"height\";i:600;s:4:\"full\";a:2:{s:5:\"width\";i:418;s:6:\"height\";i:600;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:26:\"thumbs_boscobel3a_copy.jpg\";s:9:\"generated\";s:21:\"0.70641600 1393534601\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");
INSERT INTO `wp_ngg_pictures` VALUES("6", "boscobel3a", "0", "1", "boscobel3a.jpg", " ", "boscobel3a", "2014-02-27 20:56:41", "0", "0", "a:17:{s:5:\"width\";i:292;s:6:\"height\";i:400;s:4:\"full\";a:2:{s:5:\"width\";i:292;s:6:\"height\";i:400;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:21:\"thumbs_boscobel3a.jpg\";s:9:\"generated\";s:21:\"0.92983300 1393534601\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");
INSERT INTO `wp_ngg_pictures` VALUES("7", "boscobel2sit", "0", "1", "boscobel2sit.jpg", " ", "boscobel2sit", "2014-02-27 20:56:42", "0", "0", "a:17:{s:5:\"width\";i:324;s:6:\"height\";i:400;s:4:\"full\";a:2:{s:5:\"width\";i:324;s:6:\"height\";i:400;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:23:\"thumbs_boscobel2sit.jpg\";s:9:\"generated\";s:21:\"0.66840700 1393534602\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");
INSERT INTO `wp_ngg_pictures` VALUES("8", "boscobel3bath_copy", "0", "1", "boscobel3bath_copy.jpg", " ", "boscobel3bath_copy", "2014-02-27 20:56:43", "0", "0", "a:17:{s:5:\"width\";i:418;s:6:\"height\";i:600;s:4:\"full\";a:2:{s:5:\"width\";i:418;s:6:\"height\";i:600;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:29:\"thumbs_boscobel3bath_copy.jpg\";s:9:\"generated\";s:21:\"0.34080900 1393534603\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");
INSERT INTO `wp_ngg_pictures` VALUES("9", "boscobel3bath", "0", "1", "boscobel3bath.jpg", " ", "boscobel3bath", "2014-02-27 20:56:44", "0", "0", "a:17:{s:5:\"width\";i:279;s:6:\"height\";i:400;s:4:\"full\";a:2:{s:5:\"width\";i:279;s:6:\"height\";i:400;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:24:\"thumbs_boscobel3bath.jpg\";s:9:\"generated\";s:21:\"0.56111100 1393534604\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");
INSERT INTO `wp_ngg_pictures` VALUES("10", "boscobel4", "0", "1", "boscobel4.jpg", " ", "boscobel4", "2014-02-27 20:56:46", "0", "0", "a:17:{s:5:\"width\";i:700;s:6:\"height\";i:401;s:4:\"full\";a:2:{s:5:\"width\";i:700;s:6:\"height\";i:401;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:20:\"thumbs_boscobel4.jpg\";s:9:\"generated\";s:21:\"0.14617400 1393534606\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");
INSERT INTO `wp_ngg_pictures` VALUES("11", "boscobel4a", "0", "1", "boscobel4a.jpg", " ", "boscobel4a", "2014-02-27 20:56:47", "0", "0", "a:17:{s:5:\"width\";i:700;s:6:\"height\";i:429;s:4:\"full\";a:2:{s:5:\"width\";i:700;s:6:\"height\";i:429;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:21:\"thumbs_boscobel4a.jpg\";s:9:\"generated\";s:21:\"0.45744800 1393534607\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");
INSERT INTO `wp_ngg_pictures` VALUES("12", "boscobel4bath_copy", "0", "1", "boscobel4bath_copy.jpg", " ", "boscobel4bath_copy", "2014-02-27 20:56:49", "0", "0", "a:17:{s:5:\"width\";i:700;s:6:\"height\";i:1299;s:4:\"full\";a:2:{s:5:\"width\";i:700;s:6:\"height\";i:1299;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:29:\"thumbs_boscobel4bath_copy.jpg\";s:9:\"generated\";s:21:\"0.53150200 1393534609\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");
INSERT INTO `wp_ngg_pictures` VALUES("13", "boscobel4bath", "0", "1", "boscobel4bath.jpg", " ", "boscobel4bath", "2014-02-27 20:56:50", "0", "0", "a:17:{s:5:\"width\";i:251;s:6:\"height\";i:400;s:4:\"full\";a:2:{s:5:\"width\";i:251;s:6:\"height\";i:400;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:24:\"thumbs_boscobel4bath.jpg\";s:9:\"generated\";s:21:\"0.57713900 1393534610\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");
INSERT INTO `wp_ngg_pictures` VALUES("14", "boscobel5", "0", "1", "boscobel5.jpg", " ", "boscobel5", "2014-02-27 20:56:51", "0", "0", "a:17:{s:5:\"width\";i:700;s:6:\"height\";i:434;s:4:\"full\";a:2:{s:5:\"width\";i:700;s:6:\"height\";i:434;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:20:\"thumbs_boscobel5.jpg\";s:9:\"generated\";s:21:\"0.79187200 1393534611\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");
INSERT INTO `wp_ngg_pictures` VALUES("15", "boscobel5a", "0", "1", "boscobel5a.jpg", " ", "boscobel5a", "2014-02-27 20:56:52", "0", "0", "a:17:{s:5:\"width\";i:700;s:6:\"height\";i:468;s:4:\"full\";a:2:{s:5:\"width\";i:700;s:6:\"height\";i:468;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:21:\"thumbs_boscobel5a.jpg\";s:9:\"generated\";s:21:\"0.10513500 1393534613\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");
INSERT INTO `wp_ngg_pictures` VALUES("16", "boscobel5bath", "0", "1", "boscobel5bath.jpg", " ", "boscobel5bath", "2014-02-27 20:56:54", "0", "0", "a:17:{s:5:\"width\";i:341;s:6:\"height\";i:500;s:4:\"full\";a:2:{s:5:\"width\";i:341;s:6:\"height\";i:500;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:24:\"thumbs_boscobel5bath.jpg\";s:9:\"generated\";s:21:\"0.34781200 1393534614\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");
INSERT INTO `wp_ngg_pictures` VALUES("17", "boscobel6", "0", "1", "boscobel6.jpg", " ", "boscobel6", "2014-02-27 20:56:55", "0", "0", "a:17:{s:5:\"width\";i:700;s:6:\"height\";i:411;s:4:\"full\";a:2:{s:5:\"width\";i:700;s:6:\"height\";i:411;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:20:\"thumbs_boscobel6.jpg\";s:9:\"generated\";s:21:\"0.58743100 1393534615\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");
INSERT INTO `wp_ngg_pictures` VALUES("18", "boscobel6bath", "0", "1", "boscobel6bath.jpg", " ", "boscobel6bath", "2014-02-27 20:56:56", "0", "0", "a:17:{s:5:\"width\";i:334;s:6:\"height\";i:550;s:4:\"full\";a:2:{s:5:\"width\";i:334;s:6:\"height\";i:550;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:24:\"thumbs_boscobel6bath.jpg\";s:9:\"generated\";s:21:\"0.71017000 1393534616\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");
INSERT INTO `wp_ngg_pictures` VALUES("19", "boscobel8", "0", "1", "boscobel8.jpg", " ", "boscobel8", "2014-02-27 20:57:08", "0", "0", "a:17:{s:5:\"width\";i:700;s:6:\"height\";i:431;s:4:\"full\";a:2:{s:5:\"width\";i:700;s:6:\"height\";i:431;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:20:\"thumbs_boscobel8.jpg\";s:9:\"generated\";s:21:\"0.04488000 1393534629\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");
INSERT INTO `wp_ngg_pictures` VALUES("20", "boscobel10", "0", "1", "boscobel10.jpg", " ", "boscobel10", "2014-02-27 20:57:10", "0", "0", "a:17:{s:5:\"width\";i:700;s:6:\"height\";i:484;s:4:\"full\";a:2:{s:5:\"width\";i:700;s:6:\"height\";i:484;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:21:\"thumbs_boscobel10.jpg\";s:9:\"generated\";s:21:\"0.75061200 1393534630\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");
INSERT INTO `wp_ngg_pictures` VALUES("21", "boscobel10b", "0", "1", "boscobel10b.jpg", " ", "boscobel10b", "2014-02-27 20:57:11", "0", "0", "a:17:{s:5:\"width\";i:700;s:6:\"height\";i:464;s:4:\"full\";a:2:{s:5:\"width\";i:700;s:6:\"height\";i:464;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:22:\"thumbs_boscobel10b.jpg\";s:9:\"generated\";s:21:\"0.97819200 1393534631\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");
INSERT INTO `wp_ngg_pictures` VALUES("22", "boscobel10c", "0", "1", "boscobel10c.jpg", " ", "boscobel10c", "2014-02-27 20:57:13", "0", "0", "a:17:{s:5:\"width\";i:700;s:6:\"height\";i:462;s:4:\"full\";a:2:{s:5:\"width\";i:700;s:6:\"height\";i:462;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:22:\"thumbs_boscobel10c.jpg\";s:9:\"generated\";s:21:\"0.25917900 1393534633\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "https://www.econolodgeloon.com/wp", "yes");
INSERT INTO `wp_options` VALUES("2", "blogname", "", "yes");
INSERT INTO `wp_options` VALUES("3", "blogdescription", "", "yes");
INSERT INTO `wp_options` VALUES("4", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("5", "admin_email", "info@touristmarketing.com", "yes");
INSERT INTO `wp_options` VALUES("6", "start_of_week", "0", "yes");
INSERT INTO `wp_options` VALUES("7", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("8", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("9", "require_name_email", "", "yes");
INSERT INTO `wp_options` VALUES("10", "comments_notify", "", "yes");
INSERT INTO `wp_options` VALUES("11", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("12", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("13", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("17", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("18", "default_comment_status", "closed", "yes");
INSERT INTO `wp_options` VALUES("19", "default_ping_status", "closed", "yes");
INSERT INTO `wp_options` VALUES("20", "default_pingback_flag", "", "yes");
INSERT INTO `wp_options` VALUES("21", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("22", "date_format", "F j, Y", "yes");
INSERT INTO `wp_options` VALUES("23", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("24", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("28", "comment_moderation", "", "yes");
INSERT INTO `wp_options` VALUES("29", "moderation_notify", "", "yes");
INSERT INTO `wp_options` VALUES("30", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("32", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("33", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("34", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("35", "active_plugins", "a:14:{i:0;s:60:\"advanced-floating-content-lite/advanced-floating-content.php\";i:1;s:47:\"cryout-theme-settings/cryout-theme-settings.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:24:\"simple-lightbox/main.php\";i:4;s:21:\"snapshot/snapshot.php\";i:5;s:53:\"velvet-blues-update-urls/velvet-blues-update-urls.php\";i:6;s:23:\"wordfence/wordfence.php\";i:7;s:24:\"wordpress-seo/wp-seo.php\";i:8;s:27:\"wp-defender/wp-defender.php\";i:9;s:33:\"wp-hummingbird/wp-hummingbird.php\";i:10;s:25:\"wp-smush-pro/wp-smush.php\";i:11;s:27:\"wp-super-cache/wp-cache.php\";i:12;s:43:\"wp-updates-settings/wp-updates-settings.php\";i:13;s:40:\"wpmudev-updates/update-notifications.php\";}", "yes");
INSERT INTO `wp_options` VALUES("36", "home", "https://www.econolodgeloon.com/wp", "yes");
INSERT INTO `wp_options` VALUES("37", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("38", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("40", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("41", "gmt_offset", "", "yes");
INSERT INTO `wp_options` VALUES("42", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("43", "recently_edited", "a:5:{i:0;s:104:\"/home/econolodge/public_html/wp/wp-content/plugins/velvet-blues-update-urls/velvet-blues-update-urls.php\";i:1;s:97:\"/home/econolodge/public_html/wp/wp/wp-content/plugins/wp-updates-settings/wp-updates-settings.php\";i:2;s:70:\"/home/econolodge/public_html/wp/wp/wp-content/themes/tempera/style.css\";i:3;s:79:\"/home/econolodge/public_html/wp/wp/wp-content/themes/tempera-nocopyrt/style.css\";i:4;s:109:\"/var/hsphere/local/home/captain/captainsbountymotorinn.com/wp-content/plugins/photo-gallery/photo-gallery.php\";}", "no");
INSERT INTO `wp_options` VALUES("44", "template", "tempera", "yes");
INSERT INTO `wp_options` VALUES("45", "stylesheet", "tempera-nocopyrt", "yes");
INSERT INTO `wp_options` VALUES("46", "comment_whitelist", "", "yes");
INSERT INTO `wp_options` VALUES("47", "blacklist_keys", "", "no");
INSERT INTO `wp_options` VALUES("48", "comment_registration", "", "yes");
INSERT INTO `wp_options` VALUES("49", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("50", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("51", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("52", "db_version", "43764", "yes");
INSERT INTO `wp_options` VALUES("53", "uploads_use_yearmonth_folders", "", "yes");
INSERT INTO `wp_options` VALUES("54", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("55", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("56", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("57", "show_on_front", "posts", "yes");
INSERT INTO `wp_options` VALUES("58", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("59", "show_avatars", "", "yes");
INSERT INTO `wp_options` VALUES("60", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("61", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("62", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("63", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("64", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("65", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("66", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("67", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("68", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("69", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("70", "image_default_link_type", "", "yes");
INSERT INTO `wp_options` VALUES("71", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("72", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("73", "close_comments_for_old_posts", "", "yes");
INSERT INTO `wp_options` VALUES("74", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("75", "thread_comments", "", "yes");
INSERT INTO `wp_options` VALUES("76", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("77", "page_comments", "", "yes");
INSERT INTO `wp_options` VALUES("78", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("79", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("80", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("81", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("82", "widget_categories", "a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("83", "widget_text", "a:3:{i:2;a:4:{s:5:\"title\";s:61:\"Sign Up For Our Newsletter! Receive Updates & Special Offers!\";s:4:\"text\";s:856:\"<p style=\"text-align:center\"><a href=\"https://www.econolodgeloon.com/wp/yarmouth-ma-cape-cod-motel-virtual-tour/\"><img src=\"https://www.econolodgeloon.com/wp/wp-content/uploads/subscribe-animated-gif-150.gif\" width=““150”” height=““80”” border=\"0\" /></a><form action=\"http://touristmarketingservices.com/sendy/subscribe\" method=\"POST\" accept-charset=\"utf-8\">\r\n	<label for=\"name\">Name</label><br/>\r\n	<input type=\"text\" name=\"name\" id=\"name\"/>\r\n	<br/>\r\n	<label for=\"email\">Email</label><br/>\r\n	<input type=\"email\" name=\"email\" id=\"email\"/><br/>\r\n	<div style=\"display:none;\">\r\n	<label for=\"hp\">HP</label><br/>\r\n	<input type=\"text\" name=\"hp\" id=\"hp\"/>\r\n	</div>\r\n	<input type=\"hidden\" name=\"list\" value=\"0bl9FX86PKwQ8i76367h892OOA\"/>\r\n	<input type=\"hidden\" name=\"subform\" value=\"yes\"/>\r\n	<input type=\"submit\" name=\"submit\" id=\"submit\"/>\r\n</form>\";s:6:\"filter\";b:0;s:6:\"visual\";b:0;}i:3;a:3:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("84", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("85", "uninstall_plugins", "a:6:{s:57:\"rk-responsive-contact-form/rk-responsive-contact-form.php\";s:25:\"rk_contact_form_uninstall\";s:20:\"worker/functions.php\";s:13:\"mwp_uninstall\";s:30:\"lightbox-plus/lightboxplus.php\";s:12:\"UninstallLBP\";s:27:\"wp-super-cache/wp-cache.php\";s:22:\"wpsupercache_uninstall\";s:40:\"wpmudev-updates/update-notifications.php\";a:2:{i:0;s:17:\"WPMUDEV_Dashboard\";i:1;s:16:\"uninstall_plugin\";}s:25:\"adminimize/adminimize.php\";s:24:\"_mw_adminimize_uninstall\";}", "no");
INSERT INTO `wp_options` VALUES("86", "timezone_string", "America/New_York", "yes");
INSERT INTO `wp_options` VALUES("87", "page_for_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("88", "page_on_front", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("90", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("91", "initial_db_version", "25824", "yes");
INSERT INTO `wp_options` VALUES("92", "wp_user_roles", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:87:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:24:\"NextGEN Gallery overview\";b:1;s:19:\"NextGEN Use TinyMCE\";b:1;s:21:\"NextGEN Upload images\";b:1;s:22:\"NextGEN Manage gallery\";b:1;s:19:\"NextGEN Manage tags\";b:1;s:29:\"NextGEN Manage others gallery\";b:1;s:18:\"NextGEN Edit album\";b:1;s:20:\"NextGEN Change style\";b:1;s:22:\"NextGEN Change options\";b:1;s:24:\"NextGEN Attach Interface\";b:1;s:22:\"tablepress_edit_tables\";b:1;s:24:\"tablepress_delete_tables\";b:1;s:22:\"tablepress_list_tables\";b:1;s:21:\"tablepress_add_tables\";b:1;s:22:\"tablepress_copy_tables\";b:1;s:24:\"tablepress_import_tables\";b:1;s:24:\"tablepress_export_tables\";b:1;s:32:\"tablepress_access_options_screen\";b:1;s:30:\"tablepress_access_about_screen\";b:1;s:29:\"tablepress_import_tables_wptr\";b:1;s:23:\"tablepress_edit_options\";b:1;s:22:\"manage_snapshots_items\";b:1;s:29:\"manage_snapshots_destinations\";b:1;s:25:\"manage_snapshots_settings\";b:1;s:23:\"manage_snapshots_import\";b:1;s:20:\"wpseo_manage_options\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:44:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:22:\"tablepress_edit_tables\";b:1;s:24:\"tablepress_delete_tables\";b:1;s:22:\"tablepress_list_tables\";b:1;s:21:\"tablepress_add_tables\";b:1;s:22:\"tablepress_copy_tables\";b:1;s:24:\"tablepress_import_tables\";b:1;s:24:\"tablepress_export_tables\";b:1;s:32:\"tablepress_access_options_screen\";b:1;s:30:\"tablepress_access_about_screen\";b:1;s:15:\"wpseo_bulk_edit\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:19:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:22:\"tablepress_edit_tables\";b:1;s:24:\"tablepress_delete_tables\";b:1;s:22:\"tablepress_list_tables\";b:1;s:21:\"tablepress_add_tables\";b:1;s:22:\"tablepress_copy_tables\";b:1;s:24:\"tablepress_import_tables\";b:1;s:24:\"tablepress_export_tables\";b:1;s:32:\"tablepress_access_options_screen\";b:1;s:30:\"tablepress_access_about_screen\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:46:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:22:\"tablepress_edit_tables\";b:1;s:24:\"tablepress_delete_tables\";b:1;s:22:\"tablepress_list_tables\";b:1;s:21:\"tablepress_add_tables\";b:1;s:22:\"tablepress_copy_tables\";b:1;s:24:\"tablepress_import_tables\";b:1;s:24:\"tablepress_export_tables\";b:1;s:32:\"tablepress_access_options_screen\";b:1;s:30:\"tablepress_access_about_screen\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:45:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:22:\"tablepress_edit_tables\";b:1;s:24:\"tablepress_delete_tables\";b:1;s:22:\"tablepress_list_tables\";b:1;s:21:\"tablepress_add_tables\";b:1;s:22:\"tablepress_copy_tables\";b:1;s:24:\"tablepress_import_tables\";b:1;s:24:\"tablepress_export_tables\";b:1;s:32:\"tablepress_access_options_screen\";b:1;s:30:\"tablepress_access_about_screen\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("94", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("95", "widget_recent-posts", "a:2:{s:12:\"_multiwidget\";i:1;i:1;a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("96", "widget_recent-comments", "a:2:{s:12:\"_multiwidget\";i:1;i:1;a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("97", "widget_archives", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("98", "widget_meta", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("99", "sidebars_widgets", "a:12:{s:19:\"wp_inactive_widgets\";a:1:{i:0;s:8:\"search-2\";}s:16:\"left-widget-area\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}s:17:\"right-widget-area\";a:2:{i:0;s:6:\"text-2\";i:1;s:6:\"text-3\";}s:24:\"first-footer-widget-area\";a:0:{}s:25:\"second-footer-widget-area\";a:0:{}s:24:\"third-footer-widget-area\";a:0:{}s:25:\"fourth-footer-widget-area\";a:0:{}s:25:\"above-content-widget-area\";a:0:{}s:25:\"below-content-widget-area\";a:0:{}s:18:\"header-widget-area\";a:0:{}s:30:\"presentation-page-columns-area\";a:2:{i:0;s:16:\"columns_widget-2\";i:1;s:16:\"columns_widget-3\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("32012", "wpseo_social", "a:18:{s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:14:\"plus-publisher\";s:0:\"\";s:7:\"twitter\";b:0;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:7:\"summary\";s:11:\"youtube_url\";s:0:\"\";s:15:\"google_plus_url\";s:0:\"\";s:10:\"fbadminapp\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("2822", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:25:\"info@touristmarketing.com\";s:7:\"version\";s:5:\"4.9.8\";s:9:\"timestamp\";i:1533267380;}", "no");
INSERT INTO `wp_options` VALUES("150", "theme_mods_twentythirteen", "a:1:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1393278602;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}}}}", "yes");
INSERT INTO `wp_options` VALUES("151", "current_theme", "Tempera Child (no copyright link)", "yes");
INSERT INTO `wp_options` VALUES("152", "theme_mods_stay-wpcom", "a:11:{i:0;b:0;s:16:\"header_textcolor\";s:5:\"blank\";s:16:\"background_color\";s:6:\"fdfde3\";s:16:\"background_image\";s:0:\"\";s:17:\"background_repeat\";s:6:\"repeat\";s:21:\"background_position_x\";s:4:\"left\";s:21:\"background_attachment\";s:5:\"fixed\";s:16:\"stay_home_slider\";a:6:{i:1;s:1:\"8\";i:2;s:1:\"0\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";}s:17:\"stay_social_links\";a:7:{s:7:\"twitter\";s:0:\"\";s:8:\"facebook\";s:0:\"\";s:7:\"youtube\";s:0:\"\";s:11:\"google_plus\";s:0:\"\";s:9:\"pinterest\";s:0:\"\";s:5:\"vimeo\";s:0:\"\";s:5:\"email\";s:0:\"\";}s:18:\"nav_menu_locations\";a:0:{}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1393293452;s:4:\"data\";a:9:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:4:{i:0;s:8:\"search-2\";i:1;s:10:\"archives-2\";i:2;s:12:\"categories-2\";i:3;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}s:9:\"sidebar-4\";a:0:{}s:9:\"sidebar-5\";a:0:{}s:9:\"sidebar-6\";a:0:{}s:9:\"sidebar-7\";a:0:{}s:9:\"sidebar-8\";a:0:{}}}}", "yes");
INSERT INTO `wp_options` VALUES("153", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("43909", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("110", "dashboard_widget_options", "a:4:{s:25:\"dashboard_recent_comments\";a:1:{s:5:\"items\";i:5;}s:24:\"dashboard_incoming_links\";a:5:{s:4:\"home\";s:33:\"http://barharbormanorhouse.com/wp\";s:4:\"link\";s:109:\"http://blogsearch.google.com/blogsearch?scoring=d&partner=wordpress&q=link:http://barharbormanorhouse.com/wp/\";s:3:\"url\";s:142:\"http://blogsearch.google.com/blogsearch_feeds?scoring=d&ie=utf-8&num=10&output=rss&partner=wordpress&q=link:http://barharbormanorhouse.com/wp/\";s:5:\"items\";i:10;s:9:\"show_date\";b:0;}s:17:\"dashboard_primary\";a:7:{s:4:\"link\";s:26:\"http://wordpress.org/news/\";s:3:\"url\";s:31:\"http://wordpress.org/news/feed/\";s:5:\"title\";s:14:\"WordPress Blog\";s:5:\"items\";i:2;s:12:\"show_summary\";i:1;s:11:\"show_author\";i:0;s:9:\"show_date\";i:1;}s:19:\"dashboard_secondary\";a:7:{s:4:\"link\";s:28:\"http://planet.wordpress.org/\";s:3:\"url\";s:33:\"http://planet.wordpress.org/feed/\";s:5:\"title\";s:20:\"Other WordPress News\";s:5:\"items\";i:5;s:12:\"show_summary\";i:0;s:11:\"show_author\";i:0;s:9:\"show_date\";i:0;}}", "yes");
INSERT INTO `wp_options` VALUES("320", "wp_ngg_pictures_8", "76", "yes");
INSERT INTO `wp_options` VALUES("321", "wp_ngg_pictures_9", "77", "yes");
INSERT INTO `wp_options` VALUES("322", "wp_ngg_pictures_10", "78", "yes");
INSERT INTO `wp_options` VALUES("323", "wp_ngg_pictures_11", "79", "yes");
INSERT INTO `wp_options` VALUES("324", "wp_ngg_pictures_12", "80", "yes");
INSERT INTO `wp_options` VALUES("325", "wp_ngg_pictures_13", "81", "yes");
INSERT INTO `wp_options` VALUES("326", "wp_ngg_pictures_14", "82", "yes");
INSERT INTO `wp_options` VALUES("327", "wp_ngg_pictures_15", "83", "yes");
INSERT INTO `wp_options` VALUES("328", "wp_ngg_pictures_16", "84", "yes");
INSERT INTO `wp_options` VALUES("329", "wp_ngg_pictures_17", "85", "yes");
INSERT INTO `wp_options` VALUES("330", "wp_ngg_pictures_18", "86", "yes");
INSERT INTO `wp_options` VALUES("331", "wp_ngg_pictures_19", "87", "yes");
INSERT INTO `wp_options` VALUES("332", "wp_ngg_pictures_20", "88", "yes");
INSERT INTO `wp_options` VALUES("333", "wp_ngg_pictures_21", "89", "yes");
INSERT INTO `wp_options` VALUES("334", "wp_ngg_pictures_22", "90", "yes");
INSERT INTO `wp_options` VALUES("292", "wp_flash_img_show", "a:1:{s:7:\"default\";a:7:{s:10:\"pic_number\";s:1:\"4\";s:10:\"autogetimg\";s:0:\"\";s:18:\"autogetimg_page_id\";i:0;s:23:\"autogetimg_page_descend\";s:0:\"\";s:25:\"autogetimg_page_shortcode\";s:4:\"true\";s:3:\"pic\";a:4:{i:1;a:3:{s:3:\"url\";s:84:\"http://barharbormanorhouse.com/wp/wp-content/plugins/wp-flash-img-show/images/01.jpg\";s:4:\"link\";s:16:\"http://xwjie.com\";s:11:\"description\";s:10:\"XWJie Home\";}i:2;a:3:{s:3:\"url\";s:84:\"http://barharbormanorhouse.com/wp/wp-content/plugins/wp-flash-img-show/images/02.jpg\";s:4:\"link\";s:24:\"http://xwjie.com/project\";s:11:\"description\";s:12:\"ore no imoto\";}i:3;a:3:{s:3:\"url\";s:84:\"http://barharbormanorhouse.com/wp/wp-content/plugins/wp-flash-img-show/images/03.jpg\";s:4:\"link\";s:26:\"http://xwjie.com/guestbook\";s:11:\"description\";s:10:\"some fruit\";}i:4;a:3:{s:3:\"url\";s:84:\"http://barharbormanorhouse.com/wp/wp-content/plugins/wp-flash-img-show/images/04.jpg\";s:4:\"link\";s:22:\"http://xwjie.com/about\";s:11:\"description\";s:12:\"strawberries\";}}s:6:\"option\";a:32:{s:29:\"wp_flash_img_show_roundcorner\";s:2:\"10\";s:30:\"wp_flash_img_show_autoplaytime\";s:1:\"3\";s:33:\"wp_flash_img_show_isheightquality\";s:4:\"true\";s:28:\"wp_flash_img_show_windowopen\";s:6:\"_blank\";s:30:\"wp_flash_img_show_btnsetmargin\";s:13:\"auto 5 5 auto\";s:29:\"wp_flash_img_show_btndistance\";s:2:\"20\";s:30:\"wp_flash_img_show_titlebgcolor\";s:8:\"0xff6600\";s:30:\"wp_flash_img_show_titlebgalpha\";s:4:\"0.75\";s:32:\"wp_flash_img_show_titletextcolor\";s:8:\"0xffffff\";s:27:\"wp_flash_img_show_titlefont\";s:6:\"TAHOMA\";s:35:\"wp_flash_img_show_titlemoveduration\";s:1:\"1\";s:26:\"wp_flash_img_show_btnalpha\";s:3:\"0.7\";s:30:\"wp_flash_img_show_btntextcolor\";s:8:\"0xffffff\";s:33:\"wp_flash_img_show_btndefaultcolor\";s:8:\"0x1B3433\";s:31:\"wp_flash_img_show_btnhovercolor\";s:8:\"0xff9900\";s:31:\"wp_flash_img_show_btnfocuscolor\";s:8:\"0xff6600\";s:32:\"wp_flash_img_show_changimagemode\";s:5:\"click\";s:27:\"wp_flash_img_show_isshowbtn\";s:4:\"true\";s:29:\"wp_flash_img_show_isshowtitle\";s:4:\"true\";s:27:\"wp_flash_img_show_scalemode\";s:7:\"noBorde\";s:27:\"wp_flash_img_show_transform\";s:5:\"alpha\";s:29:\"wp_flash_img_show_isshowabout\";s:4:\"true\";s:29:\"wp_flash_img_show_btnfontsize\";s:2:\"10\";s:26:\"wp_flash_img_show_btnwidth\";s:2:\"16\";s:27:\"wp_flash_img_show_btnheight\";s:2:\"16\";s:31:\"wp_flash_img_show_titlelocation\";s:3:\"top\";s:32:\"wp_flash_img_show_titlepositiony\";s:3:\"100\";s:31:\"wp_flash_img_show_titlebgheight\";s:2:\"24\";s:32:\"wp_flash_img_show_titletextalign\";s:6:\"center\";s:31:\"wp_flash_img_show_titlefontsize\";s:2:\"12\";s:23:\"wp_flash_img_show_width\";s:3:\"400\";s:24:\"wp_flash_img_show_height\";s:3:\"250\";}}}", "yes");
INSERT INTO `wp_options` VALUES("293", "wp_flash_img_show_info", "a:1:{s:7:\"version\";s:3:\"1.4\";}", "yes");
INSERT INTO `wp_options` VALUES("316", "wp_ngg_pictures_4", "72", "yes");
INSERT INTO `wp_options` VALUES("299", "photocrati_auto_update_admin_update_list", "", "yes");
INSERT INTO `wp_options` VALUES("300", "photocrati_auto_update_admin_check_date", "", "yes");
INSERT INTO `wp_options` VALUES("301", "ngg_db_version", "1.8.1", "yes");
INSERT INTO `wp_options` VALUES("302", "ngg_options", "a:88:{s:22:\"router_param_separator\";s:2:\"--\";s:19:\"router_param_prefix\";s:0:\"\";s:17:\"router_param_slug\";s:9:\"nggallery\";s:11:\"gallerypath\";s:19:\"wp-content/gallery/\";s:11:\"wpmuCSSfile\";s:13:\"nggallery.css\";s:9:\"wpmuStyle\";b:0;s:9:\"wpmuRoles\";b:0;s:16:\"wpmuImportFolder\";b:0;s:13:\"wpmuZipUpload\";b:0;s:17:\"datamapper_driver\";s:22:\"custom_post_datamapper\";s:21:\"gallerystorage_driver\";s:25:\"ngglegacy_gallery_storage\";s:20:\"maximum_entity_count\";i:500;s:9:\"deleteImg\";b:1;s:9:\"swfUpload\";b:1;s:13:\"usePermalinks\";b:0;s:13:\"permalinkSlug\";s:9:\"nggallery\";s:14:\"graphicLibrary\";s:2:\"gd\";s:14:\"imageMagickDir\";s:15:\"/usr/local/bin/\";s:11:\"useMediaRSS\";b:0;s:10:\"usePicLens\";b:0;s:12:\"activateTags\";i:0;s:10:\"appendType\";s:4:\"tags\";s:9:\"maxImages\";i:7;s:14:\"relatedHeading\";s:24:\"<h3>Related Images:</h3>\";s:10:\"thumbwidth\";i:120;s:11:\"thumbheight\";i:90;s:8:\"thumbfix\";b:1;s:12:\"thumbquality\";i:100;s:8:\"imgWidth\";i:800;s:9:\"imgHeight\";i:600;s:10:\"imgQuality\";i:100;s:9:\"imgBackup\";b:1;s:13:\"imgAutoResize\";b:0;s:9:\"galImages\";s:2:\"20\";s:17:\"galPagedGalleries\";i:0;s:10:\"galColumns\";i:0;s:12:\"galShowSlide\";b:1;s:12:\"galTextSlide\";s:16:\"[Show slideshow]\";s:14:\"galTextGallery\";s:17:\"[Show thumbnails]\";s:12:\"galShowOrder\";s:7:\"gallery\";s:7:\"galSort\";s:9:\"sortorder\";s:10:\"galSortDir\";s:3:\"ASC\";s:10:\"galNoPages\";b:1;s:13:\"galImgBrowser\";i:0;s:12:\"galHiddenImg\";i:0;s:10:\"galAjaxNav\";i:0;s:11:\"thumbEffect\";s:8:\"fancybox\";s:9:\"thumbCode\";s:41:\"class=\"ngg-fancybox\" rel=\"%GALLERY_NAME%\"\";s:18:\"thumbEffectContext\";s:14:\"nextgen_images\";s:5:\"wmPos\";s:8:\"botRight\";s:6:\"wmXpos\";i:5;s:6:\"wmYpos\";i:5;s:6:\"wmType\";i:0;s:6:\"wmPath\";s:0:\"\";s:6:\"wmFont\";s:9:\"arial.ttf\";s:6:\"wmSize\";i:10;s:6:\"wmText\";s:0:\"\";s:7:\"wmColor\";s:6:\"000000\";s:8:\"wmOpaque\";s:3:\"100\";s:8:\"enableIR\";i:0;s:7:\"slideFx\";s:4:\"fade\";s:5:\"irURL\";s:0:\"\";s:12:\"irXHTMLvalid\";i:0;s:7:\"irAudio\";s:0:\"\";s:7:\"irWidth\";i:600;s:8:\"irHeight\";i:400;s:9:\"irShuffle\";b:1;s:17:\"irLinkfromdisplay\";b:1;s:16:\"irShownavigation\";i:0;s:11:\"irShowicons\";i:0;s:11:\"irWatermark\";i:0;s:13:\"irOverstretch\";s:4:\"True\";s:12:\"irRotatetime\";i:10;s:12:\"irTransition\";s:6:\"random\";s:10:\"irKenburns\";i:0;s:11:\"irBackcolor\";s:6:\"000000\";s:12:\"irFrontcolor\";s:6:\"FFFFFF\";s:12:\"irLightcolor\";s:6:\"CC0000\";s:13:\"irScreencolor\";s:6:\"000000\";s:11:\"activateCSS\";i:1;s:7:\"CSSfile\";s:13:\"nggallery.css\";s:20:\"mvc_template_dirname\";s:10:\"/templates\";s:18:\"mvc_static_dirname\";s:7:\"/static\";s:23:\"dynamic_stylesheet_slug\";s:12:\"nextgen-dcss\";s:31:\"frame_communication_option_name\";s:14:\"X-Frame-Events\";s:22:\"dynamic_thumbnail_slug\";s:13:\"nextgen-image\";s:16:\"pope_module_list\";a:36:{s:18:\"photocrati-nextgen\";s:25:\"photocrati-nextgen|2.0.40\";s:13:\"photocrati-fs\";s:17:\"photocrati-fs|0.2\";s:21:\"photocrati-validation\";s:25:\"photocrati-validation|0.1\";s:17:\"photocrati-router\";s:21:\"photocrati-router|0.4\";s:28:\"photocrati-wordpress_routing\";s:32:\"photocrati-wordpress_routing|0.3\";s:19:\"photocrati-security\";s:23:\"photocrati-security|0.2\";s:14:\"photocrati-lzw\";s:18:\"photocrati-lzw|0.1\";s:27:\"photocrati-nextgen_settings\";s:31:\"photocrati-nextgen_settings|0.3\";s:14:\"photocrati-mvc\";s:18:\"photocrati-mvc|0.4\";s:15:\"photocrati-ajax\";s:19:\"photocrati-ajax|0.5\";s:29:\"photocrati-dynamic_stylesheet\";s:33:\"photocrati-dynamic_stylesheet|0.3\";s:30:\"photocrati-frame_communication\";s:34:\"photocrati-frame_communication|0.3\";s:21:\"photocrati-datamapper\";s:25:\"photocrati-datamapper|0.4\";s:25:\"photocrati-nextgen-legacy\";s:29:\"photocrati-nextgen-legacy|0.3\";s:23:\"photocrati-nextgen-data\";s:27:\"photocrati-nextgen-data|0.4\";s:29:\"photocrati-dynamic_thumbnails\";s:33:\"photocrati-dynamic_thumbnails|0.4\";s:24:\"photocrati-nextgen_admin\";s:28:\"photocrati-nextgen_admin|0.5\";s:34:\"photocrati-nextgen_addgallery_page\";s:38:\"photocrati-nextgen_addgallery_page|0.3\";s:29:\"photocrati-nextgen_pagination\";s:33:\"photocrati-nextgen_pagination|0.1\";s:26:\"photocrati-simple_html_dom\";s:30:\"photocrati-simple_html_dom|1.5\";s:34:\"photocrati-nextgen_gallery_display\";s:38:\"photocrati-nextgen_gallery_display|0.7\";s:25:\"photocrati-attach_to_post\";s:29:\"photocrati-attach_to_post|0.8\";s:32:\"photocrati-nextgen_other_options\";s:36:\"photocrati-nextgen_other_options|0.5\";s:30:\"photocrati-nextgen_pro_upgrade\";s:34:\"photocrati-nextgen_pro_upgrade|0.1\";s:19:\"photocrati-mediarss\";s:23:\"photocrati-mediarss|0.2\";s:16:\"photocrati-cache\";s:20:\"photocrati-cache|0.2\";s:19:\"photocrati-lightbox\";s:23:\"photocrati-lightbox|0.5\";s:30:\"photocrati-nextgen_basic_album\";s:34:\"photocrati-nextgen_basic_album|0.5\";s:34:\"photocrati-nextgen_basic_templates\";s:38:\"photocrati-nextgen_basic_templates|0.2\";s:32:\"photocrati-nextgen_basic_gallery\";s:36:\"photocrati-nextgen_basic_gallery|0.7\";s:37:\"photocrati-nextgen_basic_imagebrowser\";s:41:\"photocrati-nextgen_basic_imagebrowser|0.5\";s:34:\"photocrati-nextgen_basic_singlepic\";s:38:\"photocrati-nextgen_basic_singlepic|0.5\";s:33:\"photocrati-nextgen_basic_tagcloud\";s:37:\"photocrati-nextgen_basic_tagcloud|0.5\";s:17:\"photocrati-widget\";s:21:\"photocrati-widget|0.3\";s:29:\"photocrati-third_party_compat\";s:33:\"photocrati-third_party_compat|0.1\";s:25:\"photocrati-nextgen_xmlrpc\";s:29:\"photocrati-nextgen_xmlrpc|0.2\";}s:11:\"installDate\";i:1393534653;}", "yes");
INSERT INTO `wp_options` VALUES("312", "wp_ngg_gallery_1", "68", "yes");
INSERT INTO `wp_options` VALUES("313", "wp_ngg_pictures_1", "69", "yes");
INSERT INTO `wp_options` VALUES("314", "wp_ngg_pictures_2", "70", "yes");
INSERT INTO `wp_options` VALUES("315", "wp_ngg_pictures_3", "71", "yes");
INSERT INTO `wp_options` VALUES("287", "widget_creativeclans_slideshow_version", "1.3.4", "yes");
INSERT INTO `wp_options` VALUES("146", "db_upgraded", "", "yes");
INSERT INTO `wp_options` VALUES("159", "recently_activated", "a:2:{s:16:\"gotmls/index.php\";i:1544209092;s:27:\"updraftplus/updraftplus.php\";i:1544208902;}", "yes");
INSERT INTO `wp_options` VALUES("41890", "jqlb_show_download", "0", "yes");
INSERT INTO `wp_options` VALUES("41891", "jqlb_navbarOnTop", "0", "yes");
INSERT INTO `wp_options` VALUES("41892", "jqlb_resize_speed", "400", "yes");
INSERT INTO `wp_options` VALUES("188", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("189", "wrksettings", "a:1:{s:7:\"dataown\";i:77005;}", "yes");
INSERT INTO `wp_options` VALUES("193", "theme_mods_tempera", "a:10:{i:0;b:0;s:16:\"background_color\";s:6:\"fdfde3\";s:16:\"background_image\";s:0:\"\";s:17:\"background_repeat\";s:6:\"repeat\";s:21:\"background_position_x\";s:4:\"left\";s:21:\"background_attachment\";s:5:\"fixed\";s:18:\"nav_menu_locations\";a:3:{s:7:\"primary\";i:0;s:3:\"top\";i:0;s:6:\"footer\";i:0;}s:12:\"header_image\";s:71:\"http://barharbormanorhouse.com/wp/wp-content/uploads/2014/02/banner.jpg\";s:17:\"header_image_data\";O:8:\"stdClass\":5:{s:13:\"attachment_id\";i:10;s:3:\"url\";s:71:\"http://barharbormanorhouse.com/wp/wp-content/uploads/2014/02/banner.jpg\";s:13:\"thumbnail_url\";s:71:\"http://barharbormanorhouse.com/wp/wp-content/uploads/2014/02/banner.jpg\";s:6:\"height\";i:120;s:5:\"width\";i:1150;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1427764308;s:4:\"data\";a:11:{s:19:\"wp_inactive_widgets\";a:4:{i:0;s:6:\"text-2\";i:1;s:6:\"text-3\";i:2;s:16:\"columns_widget-2\";i:3;s:16:\"columns_widget-3\";}s:16:\"left-widget-area\";a:4:{i:0;s:8:\"search-2\";i:1;s:10:\"archives-2\";i:2;s:12:\"categories-2\";i:3;s:6:\"meta-2\";}s:17:\"right-widget-area\";a:0:{}s:24:\"first-footer-widget-area\";a:0:{}s:25:\"second-footer-widget-area\";a:0:{}s:24:\"third-footer-widget-area\";a:0:{}s:25:\"fourth-footer-widget-area\";a:0:{}s:25:\"above-content-widget-area\";a:0:{}s:25:\"below-content-widget-area\";a:0:{}s:18:\"header-widget-area\";a:0:{}s:30:\"presentation-page-columns-area\";a:0:{}}}}", "yes");
INSERT INTO `wp_options` VALUES("19009", "WPLANG", "", "yes");
INSERT INTO `wp_options` VALUES("198", "tempera_settings", "a:225:{s:12:\"tempera_side\";s:4:\"2cSr\";s:17:\"tempera_sidewidth\";i:900;s:15:\"tempera_sidebar\";i:250;s:22:\"tempera_magazinelayout\";s:7:\"Disable\";s:14:\"tempera_mobile\";s:6:\"Enable\";s:12:\"tempera_zoom\";i:1;s:15:\"tempera_hheight\";i:200;s:15:\"tempera_hcenter\";i:1;s:14:\"tempera_hratio\";i:1;s:18:\"tempera_siteheader\";s:26:\"Site Title and Description\";s:18:\"tempera_logoupload\";s:0:\"\";s:23:\"tempera_headermargintop\";i:5;s:24:\"tempera_headermarginleft\";i:0;s:15:\"tempera_favicon\";s:0:\"\";s:25:\"tempera_headerwidgetwidth\";s:3:\"33%\";s:17:\"tempera_frontpage\";s:6:\"Enable\";s:18:\"tempera_frontposts\";s:7:\"Disable\";s:23:\"tempera_frontpostscount\";i:10;s:24:\"tempera_frontpostsperrow\";i:2;s:22:\"tempera_frontmoreposts\";s:10:\"More Posts\";s:21:\"tempera_fpsliderwidth\";i:1150;s:22:\"tempera_fpsliderheight\";i:450;s:20:\"tempera_fpslideranim\";s:4:\"fade\";s:20:\"tempera_fpslidertime\";i:750;s:21:\"tempera_fpsliderpause\";i:4500;s:19:\"tempera_fpslidernav\";s:7:\"Numbers\";s:22:\"tempera_fpsliderarrows\";s:16:\"Visible on Hover\";s:27:\"tempera_fpslider_bordersize\";i:0;s:26:\"tempera_fpslider_topmargin\";i:0;s:17:\"tempera_slideType\";s:13:\"Custom Slides\";s:22:\"tempera_slideShortcode\";s:0:\"\";s:21:\"tempera_slideSpecific\";s:0:\"\";s:18:\"tempera_slideCateg\";s:0:\"\";s:19:\"tempera_slideNumber\";i:5;s:18:\"tempera_sliderimg1\";s:74:\"https://www.econolodgeloon.com/wp/wp-content/uploads/slidefrontandsign.jpg\";s:20:\"tempera_slidertitle1\";s:0:\"\";s:19:\"tempera_slidertext1\";s:188:\"Welcome to the Econo Lodge Inn &amp; Suites in Lincoln, NH. We are in the Loon, Franconia Notch area, near dozens of attractions, skiing, shops, hiking and much more. We are open all year.\";s:19:\"tempera_sliderlink1\";s:0:\"\";s:18:\"tempera_sliderimg2\";s:76:\"https://www.econolodgeloon.com/wp/wp-content/uploads/slidehottubandpool1.jpg\";s:20:\"tempera_slidertitle2\";s:0:\"\";s:19:\"tempera_slidertext2\";s:159:\"Enjoy our large indoor heated pool and hot tub all year! This is a great White Mountains NH Location for relaxing, hiking, attractions, skiing or any activity.\";s:19:\"tempera_sliderlink2\";s:0:\"\";s:18:\"tempera_sliderimg3\";s:77:\"https://www.econolodgeloon.com/wp/wp-content/uploads/slidegazeboandchairs.jpg\";s:20:\"tempera_slidertitle3\";s:0:\"\";s:19:\"tempera_slidertext3\";s:174:\"Enjoy mountain views and easy access to a wide variety of year round attractions.We offer beautiful, newly renovated guest rooms, Jacuzzi rooms, cottages and a vacation home.\";s:19:\"tempera_sliderlink3\";s:0:\"\";s:18:\"tempera_sliderimg4\";s:72:\"https://www.econolodgeloon.com/wp/wp-content/uploads/slideguestrooms.jpg\";s:20:\"tempera_slidertitle4\";s:0:\"\";s:19:\"tempera_slidertext4\";s:93:\"We offer beautiful, newly renovated guest rooms, Jacuzzi rooms, cottages and a vacation home.\";s:19:\"tempera_sliderlink4\";s:0:\"\";s:18:\"tempera_sliderimg5\";s:80:\"https://www.econolodgeloon.com/wp/wp-content/uploads/slidechairsmountainview.jpg\";s:20:\"tempera_slidertitle5\";s:0:\"\";s:19:\"tempera_slidertext5\";s:38:\"Relax And Enjoy. We Are Open All Year.\";s:19:\"tempera_sliderlink5\";s:0:\"\";s:18:\"tempera_columnType\";s:8:\"Disabled\";s:22:\"tempera_columnSpecific\";s:0:\"\";s:19:\"tempera_columnCateg\";s:0:\"\";s:20:\"tempera_columnNumber\";i:3;s:18:\"tempera_coldisplay\";i:0;s:17:\"tempera_nrcolumns\";i:3;s:22:\"tempera_colimageheight\";i:201;s:21:\"tempera_colimagewidth\";i:318;s:22:\"tempera_columnreadmore\";s:9:\"Read more\";s:18:\"tempera_fronttext1\";s:96:\"Econolodge Inn &amp; Suites • A Lincoln NH Lodging Near White Mountains Attractions And Skiing\";s:18:\"tempera_fronttext3\";s:1177:\"Spectacular mountain location and superb amenities make the EconoLodge Inn &amp; Suites of Lincoln, NH the very best choice for your lodging in the White Mountains Region. We are centrally located among all major White Mountain attractions. The best value for your hard-earned dollar is here. We are a AAA approved family motel conveniently located just off I-93 at Exit 33!<br> \r\n\r\n<p style=\"text-align:center\"><a href=\"https://www.econolodgeloon.com/wp/loon-mountain-nh-hotel-motel-virtual-video-tour/\"><img src=\"https://www.econolodgeloon.com/wp/wp-content/uploads/virtualtouricon-econolodge.jpg\" width=\"“226”\" height=\"“137”\" border=\"0\" /></a><br> \r\n\r\n<p style=\"text-align:left\">Start your day off with hot coffee, cocoa, juice, egg and sausage sandwiches, waffles, pastries, cereals and more! Our deluxe continental breakfast is complimentary every day of your stay! Enjoy a copy of our complimentary USA Today newspaper and don’t hesitate to ask our friendly staff for information on area events and happenings!  For those wishing to check their e-mail accounts or weather conditions, bring your laptop and enjoy complimentary Wi-Fi that stretches to every room!\";s:18:\"tempera_fronttext2\";s:112:\"Great Lincoln White Mountains NH Family Motel Amenities • Swimming Pool, Sauna, Breakfast &amp; Great Location\";s:18:\"tempera_fronttext4\";s:508:\"End your long day full of activities in our muscle-relaxing Jacuzzi and hot Sauna, or take a swim in our warm heated indoor pool.  We offer Double Bed Rooms, King Bed Rooms, Jacuzzi Rooms and Suites, and all featuring our expansive amenity offerings such as Cable TV, Free Local Calls, Micro Fridges in every room  and on site Guest Laundry Facilities. At the EconoLodge Inn &amp; Suites, we combine warm mountain hospitality with high, brand name standards. Call 800-762-7275 today and we’ll see you soon!\";s:16:\"tempera_fontsize\";s:4:\"16px\";s:18:\"tempera_fontfamily\";s:10:\"Droid Sans\";s:18:\"tempera_googlefont\";s:0:\"\";s:20:\"tempera_headfontsize\";s:4:\"24px\";s:17:\"tempera_fonttitle\";s:10:\"Droid Sans\";s:23:\"tempera_googlefonttitle\";s:0:\"\";s:20:\"tempera_sidefontsize\";s:4:\"18px\";s:16:\"tempera_fontside\";s:15:\"Open Sans Light\";s:22:\"tempera_googlefontside\";s:0:\"\";s:21:\"tempera_sitetitlesize\";s:4:\"38px\";s:21:\"tempera_sitetitlefont\";s:25:\"Yanone Kaffeesatz Regular\";s:27:\"tempera_sitetitlegooglefont\";s:0:\"\";s:20:\"tempera_menufontsize\";s:4:\"14px\";s:16:\"tempera_menufont\";s:6:\"Ubuntu\";s:22:\"tempera_menugooglefont\";s:0:\"\";s:24:\"tempera_headingsfontsize\";s:3:\"70%\";s:20:\"tempera_headingsfont\";s:10:\"Droid Sans\";s:26:\"tempera_headingsgooglefont\";s:0:\"\";s:17:\"tempera_textalign\";s:7:\"Default\";s:22:\"tempera_paragraphspace\";s:5:\"1.0em\";s:17:\"tempera_parindent\";s:3:\"0px\";s:22:\"tempera_headingsindent\";s:7:\"Disable\";s:18:\"tempera_lineheight\";s:3:\"1.7\";s:17:\"tempera_wordspace\";s:7:\"Default\";s:21:\"tempera_uppercasetext\";i:0;s:23:\"tempera_backcolorheader\";s:0:\"\";s:21:\"tempera_backcolormain\";s:7:\"#ffffff\";s:24:\"tempera_backcolorfooterw\";s:0:\"\";s:23:\"tempera_backcolorfooter\";s:7:\"#F7F7F7\";s:23:\"tempera_contentcolortxt\";s:7:\"#444444\";s:28:\"tempera_contentcolortxtlight\";s:7:\"#999999\";s:22:\"tempera_footercolortxt\";s:7:\"#AAAAAA\";s:20:\"tempera_accentcolora\";s:7:\"#1693A5\";s:20:\"tempera_accentcolorb\";s:7:\"#D6341D\";s:20:\"tempera_accentcolorc\";s:7:\"#EEEEEE\";s:20:\"tempera_accentcolord\";s:7:\"#CCCCCC\";s:20:\"tempera_accentcolore\";s:7:\"#F7F7F7\";s:21:\"tempera_descriptionbg\";s:0:\"\";s:18:\"tempera_titlecolor\";s:7:\"#1693A5\";s:24:\"tempera_descriptioncolor\";s:7:\"#999999\";s:26:\"tempera_menucolorbgdefault\";s:7:\"#da0025\";s:27:\"tempera_menucolortxtdefault\";s:7:\"#ffffff\";s:29:\"tempera_submenucolorbgdefault\";s:7:\"#8f3927\";s:30:\"tempera_submenucolortxtdefault\";s:7:\"#ffffff\";s:26:\"tempera_submenucolorshadow\";s:0:\"\";s:21:\"tempera_topbarcolorbg\";s:7:\"#000000\";s:23:\"tempera_topmenucolortxt\";s:7:\"#CCCCCC\";s:28:\"tempera_topmenucolortxthover\";s:7:\"#EEEEEE\";s:22:\"tempera_contentcolorbg\";s:7:\"#FFFFFF\";s:28:\"tempera_contentcolortxttitle\";s:7:\"#444444\";s:33:\"tempera_contentcolortxttitlehover\";s:7:\"#000000\";s:31:\"tempera_contentcolortxtheadings\";s:7:\"#444444\";s:23:\"tempera_fronttitlecolor\";s:7:\"#444444\";s:27:\"tempera_fpsliderbordercolor\";s:7:\"#ffffff\";s:28:\"tempera_fpslidercaptioncolor\";s:7:\"#ffffff\";s:25:\"tempera_fpslidercaptionbg\";s:7:\"#000000\";s:14:\"tempera_sidebg\";s:0:\"\";s:19:\"tempera_sidetitlebg\";s:7:\"#F7F7F7\";s:15:\"tempera_sidetxt\";s:7:\"#333333\";s:20:\"tempera_sidetitletxt\";s:7:\"#666666\";s:16:\"tempera_widgetbg\";s:0:\"\";s:21:\"tempera_widgettitlebg\";s:7:\"#F7F7F7\";s:17:\"tempera_widgettxt\";s:7:\"#333333\";s:22:\"tempera_widgettitletxt\";s:7:\"#666666\";s:21:\"tempera_linkcolortext\";s:7:\"#1693A5\";s:22:\"tempera_linkcolorhover\";s:7:\"#D6341D\";s:21:\"tempera_linkcolorside\";s:0:\"\";s:26:\"tempera_linkcolorsidehover\";s:0:\"\";s:23:\"tempera_linkcolorwooter\";s:0:\"\";s:28:\"tempera_linkcolorwooterhover\";s:0:\"\";s:23:\"tempera_linkcolorfooter\";s:0:\"\";s:28:\"tempera_linkcolorfooterhover\";s:0:\"\";s:22:\"tempera_metacoloricons\";s:7:\"#CCCCCC\";s:22:\"tempera_metacolorlinks\";s:7:\"#666666\";s:27:\"tempera_metacolorlinkshover\";s:0:\"\";s:21:\"tempera_socialcolorbg\";s:7:\"#1693A5\";s:26:\"tempera_socialcolorbghover\";s:7:\"#D6341D\";s:15:\"tempera_caption\";s:12:\"caption-dark\";s:14:\"tempera_topbar\";s:4:\"Hide\";s:19:\"tempera_topbarwidth\";s:10:\"Site width\";s:19:\"tempera_breadcrumbs\";s:7:\"Disable\";s:18:\"tempera_pagination\";s:7:\"Disable\";s:17:\"tempera_menualign\";s:6:\"center\";s:24:\"tempera_contentmargintop\";i:2;s:22:\"tempera_contentpadding\";i:30;s:19:\"tempera_image_style\";s:18:\"tempera-image-none\";s:19:\"tempera_contentlist\";s:4:\"Show\";s:17:\"tempera_pagetitle\";s:4:\"Hide\";s:18:\"tempera_categtitle\";s:4:\"Hide\";s:14:\"tempera_tables\";s:7:\"Disable\";s:15:\"tempera_backtop\";s:6:\"Enable\";s:15:\"tempera_metapos\";s:6:\"Bottom\";s:19:\"tempera_single_show\";a:6:{s:6:\"author\";i:1;s:4:\"date\";i:1;s:8:\"category\";i:1;s:3:\"tag\";i:1;s:8:\"bookmark\";i:1;s:4:\"time\";i:0;}s:15:\"tempera_comtext\";s:4:\"Show\";s:17:\"tempera_comclosed\";s:15:\"Hide everywhere\";s:14:\"tempera_comoff\";s:4:\"Show\";s:19:\"tempera_excerpthome\";s:7:\"Excerpt\";s:21:\"tempera_excerptsticky\";s:9:\"Full Post\";s:22:\"tempera_excerptarchive\";s:7:\"Excerpt\";s:20:\"tempera_excerptwords\";i:50;s:19:\"tempera_excerptdots\";s:3:\"…\";s:19:\"tempera_excerptcont\";s:16:\"Continue reading\";s:13:\"tempera_fpost\";s:6:\"Enable\";s:17:\"tempera_fpostlink\";i:1;s:13:\"tempera_fauto\";s:6:\"Enable\";s:14:\"tempera_falign\";s:4:\"Left\";s:14:\"tempera_fwidth\";i:250;s:15:\"tempera_fheight\";i:150;s:13:\"tempera_fcrop\";i:1;s:15:\"tempera_fheader\";s:7:\"Disable\";s:15:\"tempera_social1\";s:8:\"Facebook\";s:15:\"tempera_social2\";s:32:\"https://www.facebook.com/ELNH032\";s:22:\"tempera_social_target1\";i:1;s:21:\"tempera_social_title1\";s:8:\"Facebook\";s:15:\"tempera_social3\";s:8:\"Facebook\";s:15:\"tempera_social4\";s:0:\"\";s:21:\"tempera_social_title3\";s:0:\"\";s:15:\"tempera_social5\";s:3:\"RSS\";s:15:\"tempera_social6\";s:0:\"\";s:21:\"tempera_social_title5\";s:0:\"\";s:15:\"tempera_social7\";s:7:\"AboutMe\";s:15:\"tempera_social8\";s:0:\"\";s:21:\"tempera_social_title7\";s:0:\"\";s:15:\"tempera_social9\";s:7:\"AboutMe\";s:16:\"tempera_social10\";s:0:\"\";s:21:\"tempera_social_title9\";s:0:\"\";s:23:\"tempera_socialsdisplay5\";i:1;s:16:\"tempera_iecompat\";i:0;s:26:\"tempera_current_admin_menu\";i:9;s:17:\"tempera_postboxes\";s:5:\"Array\";s:15:\"tempera_fitvids\";i:1;s:19:\"tempera_editorstyle\";i:1;s:17:\"tempera_copyright\";s:131:\"<b>Econolodge Inn &amp; Suites Loon Mountain Area • 381 US Route 3 • Lincoln, New Hampshire 03251 • Toll Free: 1-800-762-7275\";s:17:\"tempera_customcss\";s:467:\"/* Tempera Custom CSS */ \r\n\r\n.footermenu, .footermenu + span {\r\ndisplay: table !important; float: none !important; margin: 0 auto !important;\r\n} \r\n\r\n#branding #header-container { position: relative; }\r\n#branding #bg_image + #header-container { position: absolute; } \r\n\r\n/* Tempera Custom CSS */\r\n#access {\r\ndisplay: block;\r\nfloat: left;\r\nmargin: 1px auto 0;\r\nwidth:100%;\r\n}\r\n\r\n#main {\r\nclear: both;\r\npadding: 0px;\r\nmargin-top: 2px;\r\n} \r\n\r\n#access { margin-top: 2px; }\";s:16:\"tempera_customjs\";s:0:\"\";s:14:\"tempera_submit\";s:12:\"Save Changes\";s:22:\"tempera_social_target3\";s:1:\"0\";s:22:\"tempera_social_target5\";s:1:\"0\";s:22:\"tempera_social_target7\";s:1:\"0\";s:22:\"tempera_social_target9\";s:1:\"0\";s:23:\"tempera_socialsdisplay0\";s:1:\"0\";s:23:\"tempera_socialsdisplay1\";s:1:\"0\";s:23:\"tempera_socialsdisplay2\";s:1:\"0\";s:23:\"tempera_socialsdisplay3\";s:1:\"0\";s:23:\"tempera_socialsdisplay4\";s:1:\"0\";s:17:\"tempera_searchbar\";a:3:{s:3:\"top\";i:0;s:4:\"main\";i:0;s:6:\"footer\";i:0;}s:17:\"tempera_blog_show\";a:6:{s:6:\"author\";i:0;s:4:\"date\";i:0;s:4:\"time\";i:0;s:8:\"category\";i:0;s:3:\"tag\";i:0;s:8:\"comments\";i:0;}s:10:\"tempera_db\";s:0:\"\";s:16:\"tempera_hcontain\";s:0:\"\";s:23:\"tempera_fronthideheader\";s:0:\"\";s:21:\"tempera_fronthidemenu\";s:0:\"\";s:23:\"tempera_fronthidewidget\";s:0:\"\";s:23:\"tempera_fronthidefooter\";s:0:\"\";s:21:\"tempera_fronthideback\";s:0:\"\";s:19:\"tempera_letterspace\";s:0:\"\";s:20:\"tempera_colorschemes\";s:0:\"\";s:13:\"tempera_title\";s:0:\"\";s:19:\"tempera_excerpttags\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("136120", "wpseo-gsc-refresh_token", "1/4deINKlJQFS7M6A-qXXwD0jfZXr-93LZqinxneE0de4nL_HMfW4D5UvzRIiUtRFG", "yes");
INSERT INTO `wp_options` VALUES("136121", "wpseo-gsc-access_token", "a:5:{s:13:\"refresh_token\";s:66:\"1/4deINKlJQFS7M6A-qXXwD0jfZXr-93LZqinxneE0de4nL_HMfW4D5UvzRIiUtRFG\";s:12:\"access_token\";s:132:\"ya29.Gl01BgQyIzHfaACEc4hLUl7eV7y7Zqn4DGSTc2J1wANc0fAhrCCiogRVJxZljPvO8H3QLRU2TeF50l11rtQtjtMlY88H2W_3mXn9qou3-HiYXmDH_2_02jhr5FpSDoA\";s:7:\"expires\";d:1539453474;s:10:\"expires_in\";i:3600;s:7:\"created\";i:1539464274;}", "yes");
INSERT INTO `wp_options` VALUES("251", "theme_mods_tempera-nocopyrt", "a:10:{i:0;b:0;s:16:\"background_color\";s:6:\"f4f4f4\";s:16:\"background_image\";s:0:\"\";s:17:\"background_repeat\";s:6:\"repeat\";s:21:\"background_position_x\";s:4:\"left\";s:21:\"background_attachment\";s:5:\"fixed\";s:18:\"nav_menu_locations\";a:3:{s:7:\"primary\";i:2;s:3:\"top\";i:0;s:6:\"footer\";i:2;}s:18:\"custom_css_post_id\";i:-1;s:12:\"header_image\";s:75:\"https://www.econolodgeloon.com/wp/wp-content/uploads/econolodgebanner-2.jpg\";s:17:\"header_image_data\";O:8:\"stdClass\":5:{s:13:\"attachment_id\";i:3412;s:3:\"url\";s:75:\"https://www.econolodgeloon.com/wp/wp-content/uploads/econolodgebanner-2.jpg\";s:13:\"thumbnail_url\";s:75:\"https://www.econolodgeloon.com/wp/wp-content/uploads/econolodgebanner-2.jpg\";s:6:\"height\";i:200;s:5:\"width\";i:1150;}}", "yes");
INSERT INTO `wp_options` VALUES("288", "widget_creativeclans_slideshow", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("317", "wp_ngg_pictures_5", "73", "yes");
INSERT INTO `wp_options` VALUES("318", "wp_ngg_pictures_6", "74", "yes");
INSERT INTO `wp_options` VALUES("319", "wp_ngg_pictures_7", "75", "yes");
INSERT INTO `wp_options` VALUES("482", "easy_gallery_db_version", "1.1", "yes");
INSERT INTO `wp_options` VALUES("483", "wp_easy_gallery_defaults", "a:9:{s:7:\"version\";s:5:\"3.6.2\";s:15:\"thumbnail_width\";s:4:\"auto\";s:16:\"thumbnail_height\";s:4:\"auto\";s:12:\"hide_overlay\";s:5:\"false\";s:11:\"hide_social\";s:5:\"false\";s:12:\"custom_style\";s:0:\"\";s:17:\"use_default_style\";s:4:\"true\";s:13:\"editor_access\";s:5:\"false\";i:1;a:7:{s:15:\"thumbnail_width\";s:3:\"300\";s:16:\"thumbnail_height\";s:3:\"175\";s:12:\"hide_overlay\";s:5:\"false\";s:11:\"hide_social\";s:4:\"true\";s:13:\"editor_access\";s:5:\"false\";s:12:\"custom_style\";s:0:\"\";s:17:\"use_default_style\";s:4:\"true\";}}", "yes");
INSERT INTO `wp_options` VALUES("504", "emediagallery_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("380", "ngg_cache_971b618ce72727d7647d3b957ba5714b", "1393539540", "yes");
INSERT INTO `wp_options` VALUES("417", "displayed_gallery_rendering_35bfe32ef7743fcf97c7e531364010a1", "1393543433", "yes");
INSERT INTO `wp_options` VALUES("420", "displayed_gallery_rendering_9b6abeaaa054b494e314dbc388cc0205", "1393543455", "yes");
INSERT INTO `wp_options` VALUES("423", "displayed_gallery_rendering_d99291efc4a27d160232225a91945883", "1393543455", "yes");
INSERT INTO `wp_options` VALUES("508", "portfolio_slideshow_options", "a:30:{s:4:\"size\";s:9:\"thumbnail\";s:5:\"trans\";s:4:\"fade\";s:5:\"speed\";s:3:\"600\";s:10:\"showtitles\";s:4:\"true\";s:8:\"showcaps\";s:4:\"true\";s:8:\"showdesc\";s:4:\"true\";s:10:\"allowfluid\";s:4:\"true\";s:7:\"timeout\";s:4:\"4000\";s:8:\"autoplay\";s:4:\"true\";s:10:\"showloader\";s:4:\"true\";s:4:\"loop\";s:4:\"true\";s:5:\"click\";s:7:\"advance\";s:12:\"click_target\";s:6:\"_blank\";s:6:\"navpos\";s:3:\"top\";s:8:\"pagerpos\";s:3:\"top\";s:6:\"jquery\";s:2:\"wp\";s:5:\"cycle\";s:4:\"true\";s:5:\"debug\";s:4:\"true\";s:7:\"version\";s:5:\"1.5.1\";s:8:\"centered\";s:5:\"false\";s:6:\"random\";s:5:\"false\";s:16:\"exclude_featured\";s:5:\"false\";s:8:\"showhash\";s:5:\"false\";s:12:\"togglethumbs\";s:5:\"false\";s:8:\"showplay\";s:5:\"false\";s:8:\"showinfo\";s:5:\"false\";s:10:\"touchswipe\";s:5:\"false\";s:11:\"keyboardnav\";s:5:\"false\";s:8:\"carousel\";s:5:\"false\";s:8:\"fancybox\";s:5:\"false\";}", "yes");
INSERT INTO `wp_options` VALUES("470", "emg-notifier-cache", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<notifier>\n<latest>1.3.1.3</latest>\n\n\n<updateinstruct>\n<![CDATA[\n\n<h3>Update instructions for version 1.3.0.0 and below</h3>\n			<p style=\"color:#F00;\"><strong>ATTENTION! Do not uninstall from wordpress dashboard, follow the instructions below.</strong></p>\n		    <ol>\n			<li><strong>Please note:</strong> make a <strong>backup</strong> of the Plugin inside your WordPress installation folder <strong>/wp-content/plugins/easy-media-gallery/</strong></li>\n		    <li>Make sure you have sent an email to <strong>update@ghozylab.com</strong> for request the latest updates link download. Login to your email and re-download the plugin that we send to you.</li>\n		    <li>Extract the zip\'s contents, within the unzipped folder you will see a file named <strong>easy-media-gallery.zip</strong> – this is the plugin itself, and after you have all the new files upload them using FTP to the <strong>/wp-content/plugins/easy-media-gallery/</strong> folder overwriting the old ones (this is why it\'s important to backup any changes you\'ve made to the plugin files).</li>\n		    <li>If you didn\'t make any changes to the plugin files, you are free to overwrite them with the new ones without the risk of losing plugin settings, pages, posts, etc, and backwards compatibility is guaranteed.</li></ol>\n<br />\n<h3>Update instructions for version 1.3.1.1 and above</h3>\n<ol>\n<li>Make sure you have sent an email to <strong>update@ghozylab.com</strong> for request the latest updates link download. Login to your email and re-download the plugin that we send to you.</li>\n<li>Check your junk/spam/bulk mail folder. Download the ZIP package and Unzip it, within the unzipped folder you will see a file named <strong>easy-media-gallery.zip</strong> – this is the plugin itself.</li>\n<li>From wordpress left panel  click Easy Media > Settings > Miscellaneous > then switch ON <strong>Keep data when uninstall/update</strong> option.</li>\n<li>From wordpress left panel  click plugins > installed plugins > then Deactivate Easy media gallery, after that click Delete.</li>\n<li>Click plugins again, then click Add New > Upload > then upload the file that you extracted before (<strong>easy-media-gallery.zip</strong>). Please wait a moment, you should see a message stating that the plugin was installed successfully, after the plugin has installed click on activate the plugin.</li>\n<li>Finally, click Easy Media > Settings and click <strong>Save Changes</strong>.</li>\n</ol>\n\n<p>You can follow the steps above from this video : <a target=\"_blank\" href=\"http://www.youtube.com/watch?v=sj-eEgtDwFA\">How to Update Easy Media Gallery</a></p>\n\n]]>\n</updateinstruct>\n\n<changelog>\n<![CDATA[\n\n<h4><strong>v1.3.1.3</strong> Add New Features 3/20/2013</h4>\n            <ol>\n			<li><span style=\"font-weight:bold; color:#F00;\">NEW</span> : Soundcloud and Reverbnation Embed</li>\n            <li><span style=\"font-weight:bold; color:#F00;\">NEW</span> : Use information of each image (Gallery Option). This option allow you to use different title and description for each image.Learn more <a target=\"_blank\" href=\"http://youtu.be/BWmWAPb_z90\"> HERE</a></li>\n            <li><span style=\"font-weight:bold; color:#F00;\">NEW</span> : Keep Data Option, this option will keep all plugin data and settings before you uninstall for update this plugin. So you no need to update with complicated way. Learn more <a target=\"_blank\" href=\"http://youtu.be/sj-eEgtDwFA\"> HERE</a></li>\n			<li>Removed the use of PHP function getimagesize()</li>	\n<li>Replace file_get_contents() PHP function with cURL</li>\n			<li>Fixed: Remove HTML tag on social media content</li>\n		    <li>Update tutorials</li>\n            <li>Many other code clean and optimization</li>															\n            </ol>\n		\n<h4><strong>v1.3.0.0</strong> Forward-Compatibility Upgrade 3/11/2013</h4>\n            <ol>\n	    <li>Fixed: PHP warning in the tinymce-dlg.php file</li>\n            <li>Fixed: Hover effect not works on several themes</li>\n            <li>Fixed: Only display 10 media, although we have determined more than 10. Now you can put unlimited media</li>\n            <li>Fixed: Title was given wrong position by CSS</li>\n            <li>Added jQuery 1.9 compatibility (will be required for WordPress 3.6)</li>\n            <li>Fixed: Theme\'s that set image heights affected the media image dimensions.</li>	\n            <li>Updated Timthumb (Note: there was no security risk with the previous version)</li>	\n            <li>Add Dasboard Share Button</li>															\n            </ol>			\n					\n<h4><strong>v1.0.0.0</strong> Release 03/03/2013</h4>\n 			<ol>	\n            <li>This is the launch version. No changes yet.</li>															\n            </ol>\n]]>\n</changelog>\n</notifier>", "yes");
INSERT INTO `wp_options` VALUES("471", "emg-notifier-cache-last-updated", "1393625360", "yes");
INSERT INTO `wp_options` VALUES("42173", "worker_migration_version", "2", "yes");
INSERT INTO `wp_options` VALUES("711", "widget_columns_widget", "a:3:{i:2;a:5:{s:5:\"image\";s:0:\"\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:0:\"\";s:4:\"link\";s:0:\"\";s:5:\"blank\";N;}i:3;a:5:{s:5:\"image\";s:65:\"http://barharbormanorhouse.com/wp/wp-content/uploads/registry.gif\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:0:\"\";s:4:\"link\";s:30:\"http://www.selectregistry.com/\";s:5:\"blank\";s:1:\"1\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("755", "mwp_backup_tasks", "a:1:{s:10:\"Backup Now\";a:2:{s:9:\"task_args\";a:9:{s:4:\"what\";s:4:\"full\";s:15:\"optimize_tables\";b:0;s:7:\"exclude\";a:0:{}s:7:\"include\";a:0:{}s:13:\"del_host_file\";b:0;s:12:\"disable_comp\";i:0;s:5:\"limit\";s:1:\"3\";s:18:\"compression_method\";i:0;s:12:\"account_info\";a:0:{}}s:12:\"task_results\";a:1:{i:0;a:4:{s:4:\"size\";s:5:\"136MB\";s:8:\"duration\";s:6:\"49.79s\";s:6:\"server\";a:2:{s:9:\"file_path\";s:140:\"/home/econolodge/public_html/wp/wp/wp-content/managewp/backups/theterninn.com-wp_manual_full_2015-07-25_9c6763f17d129ddd3bb53c3b9ca4248e.zip\";s:8:\"file_url\";s:144:\"http://67.23.236.217/~windriftmotel/wp/wp-content/managewp/backups/theterninn.com-wp_manual_full_2015-07-25_9c6763f17d129ddd3bb53c3b9ca4248e.zip\";}s:4:\"time\";i:1437850739;}}}}", "yes");
INSERT INTO `wp_options` VALUES("978", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("41886", "jqlb_help_text", "", "yes");
INSERT INTO `wp_options` VALUES("41887", "jqlb_automate", "1", "yes");
INSERT INTO `wp_options` VALUES("41888", "jqlb_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("41889", "jqlb_resize_on_demand", "0", "yes");
INSERT INTO `wp_options` VALUES("19530", "auth_key", "DPBwoam|Shf5NVmKg8)X8plL}??Vgw]|63$(>[aciXg6Yd!GI].|468p56<@e8og", "yes");
INSERT INTO `wp_options` VALUES("19531", "auth_salt", "nY?w3DFsG^.J>!FHJ86i6T6wS7q{:fzoKzp:v::8?7#`jU_Z[9^v!_3Mox0am}T,", "yes");
INSERT INTO `wp_options` VALUES("19532", "logged_in_key", "P@&2!|h]i1~,Ih6grp%z{-$=.OJiC+99{6Z^)X9h5mm6{?G dyy` vH,2t35&xVe", "yes");
INSERT INTO `wp_options` VALUES("19533", "logged_in_salt", "P^V%5^$>2hxeB_/2kr7O4kmXtu){_TfY?},Z.pN{rMYzu[TT%}Lr!TyO3a5QlwcS", "yes");
INSERT INTO `wp_options` VALUES("19534", "nonce_key", "y6%3~RJqML[<U`BJLNe.b*,/fiTKId$TGNv*^I_W?(tqn=t1M;;Q%iV6r3b[XdQ@", "yes");
INSERT INTO `wp_options` VALUES("19535", "nonce_salt", "9WPh)2(^xDkaZCgKxHr$1 {uE5rF}H)zkoUPOa6(yyk23(yYD/K5/3kCGbf,~8mo", "yes");
INSERT INTO `wp_options` VALUES("36598", "wd_bwg_version", "1.3.45", "no");
INSERT INTO `wp_options` VALUES("36599", "wd_bwg_theme_version", "1.0.0", "no");
INSERT INTO `wp_options` VALUES("19622", "tablepress_plugin_options", "{\"plugin_options_db_version\":29,\"table_scheme_db_version\":3,\"prev_tablepress_version\":\"1.4\",\"tablepress_version\":\"1.5.1\",\"first_activation\":1415785312,\"message_plugin_update\":true,\"message_plugin_update_content\":\"<info>This update includes several new features, enhancements, and bugfixes. Updating is recommended.<\\/info>\",\"message_donation_nag\":true,\"use_custom_css\":true,\"use_custom_css_file\":true,\"custom_css\":\".tablepress-id-2 .column-1 {\\n\\twidth: 250px;\\n}\\n\\n.tablepress-id-2 .column-2 {\\n\\twidth: 400px;\\n}\",\"custom_css_minified\":\".tablepress-id-2 .column-1{width:250px}.tablepress-id-2 .column-2{width:400px}\",\"custom_css_version\":9}", "yes");
INSERT INTO `wp_options` VALUES("19623", "tablepress_tables", "{\"last_id\":2,\"table_post\":{\"1\":825,\"2\":848}}", "yes");
INSERT INTO `wp_options` VALUES("32011", "wpseo_titles", "a:65:{s:10:\"title_test\";i:0;s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-pipe\";s:16:\"title-home-wpseo\";s:69:\"White Mountains NH Motel Hotel | Swimming Pool | Loon Mountain Skiing\";s:18:\"title-author-wpseo\";s:41:\"%%name%%, Author at %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:63:\"You searched for %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:35:\"Page not found %%sep%% %%sitename%%\";s:19:\"metadesc-home-wpseo\";s:373:\"Econo Lodge Loon Inn & Suites is a White Mountains New Hampshire Motel with an indoor swimming pool in a convenient location. We offer newly renovated beautiful guest rooms, Jacuzzi rooms and suites and are near White Mountains NH attractions, skiing, golf, hiking and much more. Our family motel is a great vacation or getaway lodging for your White Mountains NH vacation.\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:53:\"The post %%POSTLINK%% appeared first on %%BLOGLINK%%.\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:18:\"disable-attachment\";b:1;s:23:\"is-media-purge-relevant\";b:0;s:20:\"breadcrumbs-404crumb\";s:25:\"Error 404: Page not found\";s:29:\"breadcrumbs-display-blog-page\";b:0;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:12:\"Archives for\";s:18:\"breadcrumbs-enable\";b:0;s:16:\"breadcrumbs-home\";s:4:\"Home\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:16:\"You searched for\";s:15:\"breadcrumbs-sep\";s:2:\"»\";s:12:\"website_name\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"company_logo\";s:74:\"https://www.econolodgeloon.com/wp/wp-content/uploads/signsiloforbanner.jpg\";s:12:\"company_name\";s:24:\"Econo Lodge Inn & Suites\";s:17:\"company_or_person\";s:7:\"company\";s:17:\"stripcategorybase\";b:0;s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:13:\"showdate-post\";b:0;s:23:\"display-metabox-pt-post\";b:1;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:13:\"showdate-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:19:\"showdate-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:18:\"title-tax-category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:1;s:20:\"noindex-tax-category\";b:0;s:18:\"title-tax-post_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:1;s:20:\"noindex-tax-post_tag\";b:0;s:21:\"title-tax-post_format\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:0;s:23:\"noindex-tax-post_format\";b:0;s:23:\"post_types-post-maintax\";i:0;}", "yes");
INSERT INTO `wp_options` VALUES("19680", "widget_pages", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("19681", "widget_calendar", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("19682", "widget_tag_cloud", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("19683", "widget_nav_menu", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("19684", "widget_mmb_widget", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("32009", "wpseo", "a:19:{s:15:\"ms_defaults_set\";b:0;s:7:\"version\";s:5:\"9.2.1\";s:20:\"disableadvanced_meta\";b:1;s:19:\"onpage_indexability\";b:1;s:11:\"baiduverify\";s:0:\"\";s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";b:0;s:16:\"environment_type\";s:0:\"\";s:23:\"content_analysis_active\";b:1;s:23:\"keyword_analysis_active\";b:1;s:21:\"enable_admin_bar_menu\";b:1;s:26:\"enable_cornerstone_content\";b:1;s:18:\"enable_xml_sitemap\";b:1;s:24:\"enable_text_link_counter\";b:1;s:22:\"show_onboarding_notice\";b:0;s:18:\"first_activated_on\";i:1475013214;}", "yes");
INSERT INTO `wp_options` VALUES("36672", "manage-multiple-blogs", "a:2:{s:5:\"blogs\";a:0:{}s:12:\"current_blog\";a:1:{s:4:\"type\";N;}}", "yes");
INSERT INTO `wp_options` VALUES("36663", "widget_bwp_gallery_slideshow", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("36664", "widget_bwp_gallery", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("46215", "eps_redirects_redirects", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("46216", "eps_redirects_404s", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("46217", "eps_redirects_import-export", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("53739", "wordfence_syncAttackDataAttempts", "0", "no");
INSERT INTO `wp_options` VALUES("53597", "updraftplus_dismisseddashnotice", "1561764304", "yes");
INSERT INTO `wp_options` VALUES("46168", "bwg_admin_notice", "a:3:{s:15:\"two_week_review\";a:3:{s:5:\"start\";s:9:\"4/29/2016\";s:3:\"int\";i:14;s:9:\"dismissed\";i:1;}s:16:\"one_week_support\";a:3:{s:5:\"start\";s:10:\"12/23/2015\";s:3:\"int\";i:7;s:9:\"dismissed\";i:1;}s:15:\"ecommerce_promo\";a:3:{s:5:\"start\";s:9:\"2/26/2016\";s:3:\"int\";i:3;s:9:\"dismissed\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("46203", "site_icon", "0", "yes");
INSERT INTO `wp_options` VALUES("46204", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("46205", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("46212", "eps_redirects_version", "2.3.0", "yes");
INSERT INTO `wp_options` VALUES("46233", "slb_version", "2.7.0", "yes");
INSERT INTO `wp_options` VALUES("46234", "slb_options", "a:27:{s:7:\"enabled\";b:1;s:12:\"enabled_home\";b:1;s:12:\"enabled_post\";b:1;s:12:\"enabled_page\";b:1;s:15:\"enabled_archive\";b:1;s:14:\"enabled_widget\";b:0;s:12:\"enabled_menu\";b:0;s:11:\"group_links\";b:1;s:10:\"group_post\";b:1;s:13:\"group_gallery\";b:0;s:12:\"group_widget\";b:0;s:10:\"group_menu\";b:0;s:10:\"ui_autofit\";b:1;s:10:\"ui_animate\";b:1;s:19:\"slideshow_autostart\";b:1;s:18:\"slideshow_duration\";s:1:\"4\";s:10:\"group_loop\";b:1;s:18:\"ui_overlay_opacity\";s:3:\"0.8\";s:16:\"ui_title_default\";b:0;s:11:\"txt_loading\";s:7:\"Loading\";s:9:\"txt_close\";s:5:\"Close\";s:12:\"txt_nav_next\";s:4:\"Next\";s:12:\"txt_nav_prev\";s:8:\"Previous\";s:19:\"txt_slideshow_start\";s:15:\"Start slideshow\";s:18:\"txt_slideshow_stop\";s:14:\"Stop slideshow\";s:16:\"txt_group_status\";s:25:\"Item %current% of %total%\";s:13:\"theme_default\";s:11:\"slb_default\";}", "yes");
INSERT INTO `wp_options` VALUES("48294", "tc_theme_options", "a:170:{s:14:\"tc_logo_upload\";N;s:14:\"tc_logo_resize\";b:1;s:21:\"tc_sticky_logo_upload\";N;s:13:\"tc_fav_upload\";N;s:7:\"tc_skin\";s:9:\"blue3.css\";s:14:\"tc_skin_random\";b:0;s:8:\"tc_fonts\";s:19:\"_g_fjalla_cantarell\";s:17:\"tc_body_font_size\";i:15;s:6:\"tc_rss\";s:48:\"http://67.23.236.217/~windriftmotel/wp/feed/rss/\";s:8:\"tc_email\";N;s:10:\"tc_twitter\";N;s:11:\"tc_facebook\";N;s:9:\"tc_google\";N;s:12:\"tc_instagram\";N;s:9:\"tc_tumblr\";N;s:9:\"tc_flickr\";N;s:12:\"tc_wordpress\";N;s:10:\"tc_youtube\";N;s:12:\"tc_pinterest\";N;s:9:\"tc_github\";N;s:11:\"tc_dribbble\";N;s:11:\"tc_linkedin\";N;s:18:\"tc_show_title_icon\";b:1;s:23:\"tc_show_page_title_icon\";b:0;s:23:\"tc_show_post_title_icon\";b:0;s:26:\"tc_show_archive_title_icon\";b:1;s:28:\"tc_show_post_list_title_icon\";b:0;s:27:\"tc_show_sidebar_widget_icon\";b:1;s:26:\"tc_show_footer_widget_icon\";b:1;s:14:\"tc_link_scroll\";b:0;s:20:\"tc_link_hover_effect\";b:1;s:17:\"tc_ext_link_style\";b:0;s:18:\"tc_ext_link_target\";b:0;s:11:\"tc_fancybox\";b:1;s:21:\"tc_fancybox_autoscale\";b:1;s:17:\"tc_retina_support\";b:0;s:23:\"tc_display_slide_loader\";b:0;s:20:\"tc_center_slider_img\";b:1;s:13:\"tc_center_img\";b:1;s:16:\"tc_block_reorder\";b:1;s:19:\"tc_show_author_info\";b:1;s:15:\"tc_smoothscroll\";b:1;s:16:\"tc_header_layout\";s:4:\"left\";s:13:\"tc_top_border\";b:1;s:15:\"tc_show_tagline\";b:1;s:19:\"tc_social_in_header\";b:1;s:23:\"tc_display_boxed_navbar\";b:0;s:16:\"tc_sticky_header\";b:1;s:22:\"tc_sticky_show_tagline\";b:0;s:25:\"tc_sticky_show_title_logo\";b:1;s:27:\"tc_sticky_shrink_title_logo\";b:1;s:19:\"tc_sticky_show_menu\";b:1;s:31:\"tc_sticky_transparent_on_scroll\";b:1;s:17:\"tc_sticky_z_index\";i:100;s:22:\"tc_display_second_menu\";b:0;s:13:\"tc_menu_style\";s:5:\"aside\";s:39:\"tc_menu_resp_dropdown_limit_to_viewport\";b:0;s:21:\"tc_display_menu_label\";b:0;s:16:\"tc_menu_position\";s:15:\"pull-menu-right\";s:23:\"tc_second_menu_position\";s:14:\"pull-menu-left\";s:12:\"tc_menu_type\";s:5:\"hover\";s:27:\"tc_menu_submenu_fade_effect\";b:1;s:32:\"tc_menu_submenu_item_move_effect\";b:1;s:27:\"tc_second_menu_resp_setting\";s:12:\"in-sn-before\";s:17:\"tc_hide_all_menus\";b:0;s:23:\"tc_blog_restrict_by_cat\";a:0:{}s:15:\"tc_front_layout\";s:1:\"f\";s:15:\"tc_front_slider\";s:4:\"demo\";s:22:\"tc_posts_slider_number\";i:1;s:24:\"tc_posts_slider_stickies\";b:0;s:21:\"tc_posts_slider_title\";b:1;s:20:\"tc_posts_slider_text\";b:1;s:20:\"tc_posts_slider_link\";s:3:\"cta\";s:27:\"tc_posts_slider_button_text\";s:17:\"Read more &raquo;\";s:15:\"tc_slider_width\";b:1;s:15:\"tc_slider_delay\";i:5000;s:24:\"tc_slider_default_height\";i:500;s:34:\"tc_slider_default_height_apply_all\";b:1;s:33:\"tc_slider_change_default_img_size\";b:0;s:22:\"tc_show_featured_pages\";i:1;s:26:\"tc_show_featured_pages_img\";b:1;s:28:\"tc_featured_page_button_text\";s:17:\"Read more &raquo;\";s:20:\"tc_featured_page_one\";N;s:20:\"tc_featured_page_two\";N;s:22:\"tc_featured_page_three\";N;s:20:\"tc_featured_text_one\";N;s:20:\"tc_featured_text_two\";N;s:22:\"tc_featured_text_three\";N;s:24:\"tc_sidebar_global_layout\";s:1:\"l\";s:23:\"tc_sidebar_force_layout\";b:0;s:22:\"tc_sidebar_post_layout\";s:1:\"l\";s:19:\"tc_post_list_length\";s:7:\"excerpt\";s:22:\"tc_sidebar_page_layout\";s:1:\"l\";s:22:\"tc_comment_show_bubble\";b:1;s:23:\"tc_comment_bubble_shape\";s:7:\"default\";s:28:\"tc_comment_bubble_color_type\";s:4:\"skin\";s:23:\"tc_comment_bubble_color\";s:7:\"#27CDA5\";s:16:\"tc_page_comments\";b:0;s:16:\"tc_post_comments\";b:1;s:20:\"tc_show_comment_list\";b:1;s:13:\"tc_breadcrumb\";b:1;s:23:\"tc_show_breadcrumb_home\";b:0;s:27:\"tc_show_breadcrumb_in_pages\";b:1;s:34:\"tc_show_breadcrumb_in_single_posts\";b:1;s:32:\"tc_show_breadcrumb_in_post_lists\";b:1;s:18:\"tc_show_post_metas\";b:1;s:20:\"tc_post_metas_design\";s:10:\"no-buttons\";s:23:\"tc_show_post_metas_home\";b:0;s:30:\"tc_show_post_metas_single_post\";b:1;s:29:\"tc_show_post_metas_post_lists\";b:1;s:29:\"tc_show_post_metas_categories\";b:1;s:23:\"tc_show_post_metas_tags\";b:1;s:35:\"tc_show_post_metas_publication_date\";b:1;s:25:\"tc_show_post_metas_author\";b:1;s:30:\"tc_show_post_metas_update_date\";b:0;s:32:\"tc_post_metas_update_date_format\";s:4:\"days\";s:36:\"tc_post_metas_update_notice_in_title\";b:0;s:36:\"tc_post_metas_update_notice_interval\";i:10;s:32:\"tc_post_metas_update_notice_text\";s:18:\"Recently updated !\";s:34:\"tc_post_metas_update_notice_format\";s:13:\"label-default\";s:27:\"tc_post_list_excerpt_length\";i:50;s:23:\"tc_post_list_show_thumb\";b:1;s:36:\"tc_post_list_use_attachment_as_thumb\";b:1;s:26:\"tc_post_list_default_thumb\";N;s:24:\"tc_post_list_thumb_shape\";s:7:\"rounded\";s:25:\"tc_post_list_thumb_height\";i:250;s:27:\"tc_post_list_thumb_position\";s:5:\"right\";s:28:\"tc_post_list_thumb_alternate\";b:1;s:12:\"tc_cat_title\";s:0:\"\";s:12:\"tc_tag_title\";s:0:\"\";s:15:\"tc_author_title\";s:0:\"\";s:15:\"tc_search_title\";s:20:\"Search Results for :\";s:17:\"tc_post_list_grid\";s:4:\"grid\";s:15:\"tc_grid_columns\";s:1:\"3\";s:23:\"tc_grid_expand_featured\";b:1;s:15:\"tc_grid_in_blog\";b:1;s:18:\"tc_grid_in_archive\";b:1;s:17:\"tc_grid_in_search\";b:1;s:14:\"tc_grid_shadow\";b:1;s:21:\"tc_grid_bottom_border\";b:1;s:13:\"tc_grid_icons\";b:1;s:17:\"tc_grid_num_words\";i:10;s:20:\"tc_grid_thumb_height\";i:350;s:29:\"tc_single_post_thumb_location\";s:4:\"hide\";s:27:\"tc_single_post_thumb_height\";i:250;s:17:\"tc_enable_gallery\";b:1;s:19:\"tc_gallery_fancybox\";b:1;s:16:\"tc_gallery_style\";b:1;s:17:\"tc_enable_dropcap\";b:0;s:19:\"tc_dropcap_minwords\";i:50;s:17:\"tc_dropcap_design\";s:11:\"skin-shadow\";s:15:\"tc_post_dropcap\";b:0;s:15:\"tc_page_dropcap\";b:0;s:23:\"tc_show_post_navigation\";b:1;s:28:\"tc_show_post_navigation_page\";b:0;s:30:\"tc_show_post_navigation_single\";b:1;s:31:\"tc_show_post_navigation_archive\";b:1;s:25:\"tc_social_in_left-sidebar\";b:0;s:26:\"tc_social_in_right-sidebar\";b:0;s:26:\"tc_social_in_sidebar_title\";s:12:\"Social links\";s:19:\"tc_social_in_footer\";b:1;s:16:\"tc_sticky_footer\";b:1;s:19:\"tc_show_back_to_top\";b:1;s:13:\"tc_custom_css\";N;s:16:\"tc_minified_skin\";b:1;s:17:\"tc_img_smart_load\";b:0;s:21:\"tc_display_front_help\";b:1;s:3:\"ver\";s:6:\"3.4.15\";s:18:\"last_update_notice\";a:2:{s:7:\"version\";s:6:\"3.4.15\";s:13:\"display_count\";i:0;}s:8:\"defaults\";a:168:{s:14:\"tc_logo_upload\";N;s:14:\"tc_logo_resize\";b:1;s:21:\"tc_sticky_logo_upload\";N;s:13:\"tc_fav_upload\";N;s:7:\"tc_skin\";s:9:\"blue3.css\";s:14:\"tc_skin_random\";b:0;s:8:\"tc_fonts\";s:19:\"_g_fjalla_cantarell\";s:17:\"tc_body_font_size\";i:15;s:6:\"tc_rss\";s:48:\"http://67.23.236.217/~windriftmotel/wp/feed/rss/\";s:8:\"tc_email\";N;s:10:\"tc_twitter\";N;s:11:\"tc_facebook\";N;s:9:\"tc_google\";N;s:12:\"tc_instagram\";N;s:9:\"tc_tumblr\";N;s:9:\"tc_flickr\";N;s:12:\"tc_wordpress\";N;s:10:\"tc_youtube\";N;s:12:\"tc_pinterest\";N;s:9:\"tc_github\";N;s:11:\"tc_dribbble\";N;s:11:\"tc_linkedin\";N;s:18:\"tc_show_title_icon\";b:1;s:23:\"tc_show_page_title_icon\";b:0;s:23:\"tc_show_post_title_icon\";b:0;s:26:\"tc_show_archive_title_icon\";b:1;s:28:\"tc_show_post_list_title_icon\";b:0;s:27:\"tc_show_sidebar_widget_icon\";b:1;s:26:\"tc_show_footer_widget_icon\";b:1;s:14:\"tc_link_scroll\";b:0;s:20:\"tc_link_hover_effect\";b:1;s:17:\"tc_ext_link_style\";b:0;s:18:\"tc_ext_link_target\";b:0;s:11:\"tc_fancybox\";b:1;s:21:\"tc_fancybox_autoscale\";b:1;s:17:\"tc_retina_support\";b:0;s:23:\"tc_display_slide_loader\";b:0;s:20:\"tc_center_slider_img\";b:1;s:13:\"tc_center_img\";b:1;s:16:\"tc_block_reorder\";b:1;s:19:\"tc_show_author_info\";b:1;s:15:\"tc_smoothscroll\";b:1;s:16:\"tc_header_layout\";s:4:\"left\";s:13:\"tc_top_border\";b:1;s:15:\"tc_show_tagline\";b:1;s:19:\"tc_social_in_header\";b:1;s:23:\"tc_display_boxed_navbar\";b:0;s:16:\"tc_sticky_header\";b:1;s:22:\"tc_sticky_show_tagline\";b:0;s:25:\"tc_sticky_show_title_logo\";b:1;s:27:\"tc_sticky_shrink_title_logo\";b:1;s:19:\"tc_sticky_show_menu\";b:1;s:31:\"tc_sticky_transparent_on_scroll\";b:1;s:17:\"tc_sticky_z_index\";i:100;s:22:\"tc_display_second_menu\";b:0;s:13:\"tc_menu_style\";s:5:\"aside\";s:39:\"tc_menu_resp_dropdown_limit_to_viewport\";b:0;s:21:\"tc_display_menu_label\";b:0;s:16:\"tc_menu_position\";s:15:\"pull-menu-right\";s:23:\"tc_second_menu_position\";s:14:\"pull-menu-left\";s:12:\"tc_menu_type\";s:5:\"hover\";s:27:\"tc_menu_submenu_fade_effect\";b:1;s:32:\"tc_menu_submenu_item_move_effect\";b:1;s:27:\"tc_second_menu_resp_setting\";s:12:\"in-sn-before\";s:17:\"tc_hide_all_menus\";b:0;s:23:\"tc_blog_restrict_by_cat\";a:0:{}s:15:\"tc_front_layout\";s:1:\"f\";s:15:\"tc_front_slider\";s:4:\"demo\";s:22:\"tc_posts_slider_number\";i:1;s:24:\"tc_posts_slider_stickies\";b:0;s:21:\"tc_posts_slider_title\";b:1;s:20:\"tc_posts_slider_text\";b:1;s:20:\"tc_posts_slider_link\";s:3:\"cta\";s:27:\"tc_posts_slider_button_text\";s:17:\"Read more &raquo;\";s:15:\"tc_slider_width\";b:1;s:15:\"tc_slider_delay\";i:5000;s:24:\"tc_slider_default_height\";i:500;s:34:\"tc_slider_default_height_apply_all\";b:1;s:33:\"tc_slider_change_default_img_size\";b:0;s:22:\"tc_show_featured_pages\";i:1;s:26:\"tc_show_featured_pages_img\";b:1;s:28:\"tc_featured_page_button_text\";s:17:\"Read more &raquo;\";s:20:\"tc_featured_page_one\";N;s:20:\"tc_featured_page_two\";N;s:22:\"tc_featured_page_three\";N;s:20:\"tc_featured_text_one\";N;s:20:\"tc_featured_text_two\";N;s:22:\"tc_featured_text_three\";N;s:24:\"tc_sidebar_global_layout\";s:1:\"l\";s:23:\"tc_sidebar_force_layout\";b:0;s:22:\"tc_sidebar_post_layout\";s:1:\"l\";s:19:\"tc_post_list_length\";s:7:\"excerpt\";s:22:\"tc_sidebar_page_layout\";s:1:\"l\";s:22:\"tc_comment_show_bubble\";b:1;s:23:\"tc_comment_bubble_shape\";s:7:\"default\";s:28:\"tc_comment_bubble_color_type\";s:4:\"skin\";s:23:\"tc_comment_bubble_color\";s:7:\"#27CDA5\";s:16:\"tc_page_comments\";b:0;s:16:\"tc_post_comments\";b:1;s:20:\"tc_show_comment_list\";b:1;s:13:\"tc_breadcrumb\";b:1;s:23:\"tc_show_breadcrumb_home\";b:0;s:27:\"tc_show_breadcrumb_in_pages\";b:1;s:34:\"tc_show_breadcrumb_in_single_posts\";b:1;s:32:\"tc_show_breadcrumb_in_post_lists\";b:1;s:18:\"tc_show_post_metas\";b:1;s:20:\"tc_post_metas_design\";s:10:\"no-buttons\";s:23:\"tc_show_post_metas_home\";b:0;s:30:\"tc_show_post_metas_single_post\";b:1;s:29:\"tc_show_post_metas_post_lists\";b:1;s:29:\"tc_show_post_metas_categories\";b:1;s:23:\"tc_show_post_metas_tags\";b:1;s:35:\"tc_show_post_metas_publication_date\";b:1;s:25:\"tc_show_post_metas_author\";b:1;s:30:\"tc_show_post_metas_update_date\";b:0;s:32:\"tc_post_metas_update_date_format\";s:4:\"days\";s:36:\"tc_post_metas_update_notice_in_title\";b:0;s:36:\"tc_post_metas_update_notice_interval\";i:10;s:32:\"tc_post_metas_update_notice_text\";s:18:\"Recently updated !\";s:34:\"tc_post_metas_update_notice_format\";s:13:\"label-default\";s:27:\"tc_post_list_excerpt_length\";i:50;s:23:\"tc_post_list_show_thumb\";b:1;s:36:\"tc_post_list_use_attachment_as_thumb\";b:1;s:26:\"tc_post_list_default_thumb\";N;s:24:\"tc_post_list_thumb_shape\";s:7:\"rounded\";s:25:\"tc_post_list_thumb_height\";i:250;s:27:\"tc_post_list_thumb_position\";s:5:\"right\";s:28:\"tc_post_list_thumb_alternate\";b:1;s:12:\"tc_cat_title\";s:0:\"\";s:12:\"tc_tag_title\";s:0:\"\";s:15:\"tc_author_title\";s:0:\"\";s:15:\"tc_search_title\";s:20:\"Search Results for :\";s:17:\"tc_post_list_grid\";s:4:\"grid\";s:15:\"tc_grid_columns\";s:1:\"3\";s:23:\"tc_grid_expand_featured\";b:1;s:15:\"tc_grid_in_blog\";b:1;s:18:\"tc_grid_in_archive\";b:1;s:17:\"tc_grid_in_search\";b:1;s:14:\"tc_grid_shadow\";b:1;s:21:\"tc_grid_bottom_border\";b:1;s:13:\"tc_grid_icons\";b:1;s:17:\"tc_grid_num_words\";i:10;s:20:\"tc_grid_thumb_height\";i:350;s:29:\"tc_single_post_thumb_location\";s:4:\"hide\";s:27:\"tc_single_post_thumb_height\";i:250;s:17:\"tc_enable_gallery\";b:1;s:19:\"tc_gallery_fancybox\";b:1;s:16:\"tc_gallery_style\";b:1;s:17:\"tc_enable_dropcap\";b:0;s:19:\"tc_dropcap_minwords\";i:50;s:17:\"tc_dropcap_design\";s:11:\"skin-shadow\";s:15:\"tc_post_dropcap\";b:0;s:15:\"tc_page_dropcap\";b:0;s:23:\"tc_show_post_navigation\";b:1;s:28:\"tc_show_post_navigation_page\";b:0;s:30:\"tc_show_post_navigation_single\";b:1;s:31:\"tc_show_post_navigation_archive\";b:1;s:25:\"tc_social_in_left-sidebar\";b:0;s:26:\"tc_social_in_right-sidebar\";b:0;s:26:\"tc_social_in_sidebar_title\";s:12:\"Social links\";s:19:\"tc_social_in_footer\";b:1;s:16:\"tc_sticky_footer\";b:1;s:19:\"tc_show_back_to_top\";b:1;s:13:\"tc_custom_css\";N;s:16:\"tc_minified_skin\";b:1;s:17:\"tc_img_smart_load\";b:0;s:21:\"tc_display_front_help\";b:1;s:3:\"ver\";s:6:\"3.4.15\";}}", "yes");
INSERT INTO `wp_options` VALUES("48133", "wordfence_version", "7.1.18", "yes");
INSERT INTO `wp_options` VALUES("47198", "yslo_wpus_options", "a:8:{s:20:\"notification_updates\";s:1:\"1\";s:12:\"menu_updates\";s:1:\"1\";s:13:\"minor_updates\";s:1:\"1\";s:14:\"plugin_updates\";s:1:\"1\";s:13:\"theme_updates\";s:1:\"1\";s:19:\"translation_updates\";s:1:\"1\";s:27:\"auto_core_update_send_email\";s:1:\"1\";s:7:\"version\";s:5:\"1.1.4\";}", "yes");
INSERT INTO `wp_options` VALUES("85694", "hefo", "a:74:{s:4:\"head\";s:521:\"<meta name=\"google-site-verification\" content=\"nSThvu54-pCCW64-2IBcCSTmtqSnUr4wM5yvvrz9c9U\" />\r\n\r\n<script>\r\n  (function(i,s,o,g,r,a,m){i[\'GoogleAnalyticsObject\']=r;i[r]=i[r]||function(){\r\n  (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),\r\n  m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)\r\n  })(window,document,\'script\',\'https://www.google-analytics.com/analytics.js\',\'ga\');\r\n\r\n  ga(\'create\', \'UA-96076322-1\', \'auto\');\r\n  ga(\'send\', \'pageview\');\r\n\r\n</script>\";s:9:\"head_home\";s:0:\"\";s:4:\"body\";s:0:\"\";s:11:\"mobile_body\";s:0:\"\";s:6:\"footer\";s:0:\"\";s:13:\"mobile_footer\";s:0:\"\";s:13:\"generic_tag_1\";s:0:\"\";s:9:\"generic_1\";s:0:\"\";s:16:\"mobile_generic_1\";s:0:\"\";s:13:\"generic_tag_2\";s:0:\"\";s:9:\"generic_2\";s:0:\"\";s:16:\"mobile_generic_2\";s:0:\"\";s:13:\"generic_tag_3\";s:0:\"\";s:9:\"generic_3\";s:0:\"\";s:16:\"mobile_generic_3\";s:0:\"\";s:13:\"generic_tag_4\";s:0:\"\";s:9:\"generic_4\";s:0:\"\";s:16:\"mobile_generic_4\";s:0:\"\";s:6:\"before\";s:0:\"\";s:13:\"mobile_before\";s:0:\"\";s:5:\"after\";s:0:\"\";s:12:\"mobile_after\";s:0:\"\";s:14:\"excerpt_before\";s:0:\"\";s:13:\"excerpt_after\";s:0:\"\";s:11:\"inner_pos_1\";s:5:\"after\";s:11:\"inner_tag_1\";s:0:\"\";s:12:\"inner_skip_1\";s:1:\"0\";s:11:\"inner_alt_1\";s:0:\"\";s:7:\"inner_1\";s:0:\"\";s:14:\"mobile_inner_1\";s:0:\"\";s:11:\"inner_pos_2\";s:5:\"after\";s:11:\"inner_tag_2\";s:0:\"\";s:12:\"inner_skip_2\";s:1:\"0\";s:11:\"inner_alt_2\";s:0:\"\";s:7:\"inner_2\";s:0:\"\";s:14:\"mobile_inner_2\";s:0:\"\";s:11:\"inner_pos_3\";s:5:\"after\";s:11:\"inner_tag_3\";s:0:\"\";s:12:\"inner_skip_3\";s:1:\"0\";s:11:\"inner_alt_3\";s:0:\"\";s:7:\"inner_3\";s:0:\"\";s:14:\"mobile_inner_3\";s:0:\"\";s:11:\"page_before\";s:0:\"\";s:18:\"mobile_page_before\";s:0:\"\";s:10:\"page_after\";s:0:\"\";s:17:\"mobile_page_after\";s:0:\"\";s:9:\"fb_app_id\";s:0:\"\";s:7:\"og_type\";s:0:\"\";s:12:\"og_type_home\";s:0:\"\";s:16:\"og_image_default\";s:0:\"\";s:8:\"amp_head\";s:0:\"\";s:7:\"amp_css\";s:0:\"\";s:15:\"amp_post_before\";s:0:\"\";s:14:\"amp_post_after\";s:0:\"\";s:10:\"amp_footer\";s:0:\"\";s:9:\"snippet_1\";s:0:\"\";s:9:\"snippet_2\";s:0:\"\";s:9:\"snippet_3\";s:0:\"\";s:9:\"snippet_4\";s:0:\"\";s:9:\"snippet_5\";s:0:\"\";s:32:\"bbp_template_before_single_forum\";s:0:\"\";s:39:\"mobile_bbp_template_before_single_forum\";s:0:\"\";s:32:\"bbp_template_before_single_topic\";s:0:\"\";s:39:\"mobile_bbp_template_before_single_topic\";s:0:\"\";s:31:\"bbp_template_after_single_topic\";s:0:\"\";s:38:\"mobile_bbp_template_after_single_topic\";s:0:\"\";s:30:\"bbp_theme_before_reply_content\";s:0:\"\";s:37:\"mobile_bbp_theme_before_reply_content\";s:0:\"\";s:29:\"bbp_theme_after_reply_content\";s:0:\"\";s:36:\"mobile_bbp_theme_after_reply_content\";s:0:\"\";s:18:\"mobile_user_agents\";s:42:\"phone\r\niphone\r\nipod\r\nandroid.+mobile\r\nxoom\";s:5:\"notes\";s:0:\"\";s:25:\"mobile_user_agents_parsed\";s:38:\"phone|iphone|ipod|android.+mobile|xoom\";s:20:\"script_async_handles\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("51674", "GOTMLS_scan_log/97.96.91.241/1459185081.5386", "a:2:{s:8:\"settings\";a:14:{s:12:\"msg_position\";a:4:{i:0;s:4:\"80px\";i:1;s:4:\"40px\";i:2;s:5:\"400px\";i:3;s:5:\"600px\";}s:10:\"menu_group\";i:0;s:9:\"scan_what\";i:2;s:10:\"scan_depth\";i:-1;s:11:\"exclude_ext\";a:24:{i:0;s:3:\"png\";i:1;s:3:\"jpg\";i:2;s:4:\"jpeg\";i:3;s:3:\"gif\";i:4;s:3:\"bmp\";i:5;s:3:\"tif\";i:6;s:4:\"tiff\";i:7;s:3:\"psd\";i:8;s:3:\"fla\";i:9;s:3:\"flv\";i:10;s:3:\"mov\";i:11;s:3:\"mp3\";i:12;s:3:\"exe\";i:13;s:3:\"zip\";i:14;s:3:\"pdf\";i:15;s:3:\"css\";i:16;s:3:\"pot\";i:17;s:2:\"po\";i:18;s:2:\"mo\";i:19;s:2:\"so\";i:20;s:3:\"doc\";i:21;s:4:\"docx\";i:22;s:3:\"svg\";i:23;s:3:\"ttf\";}s:12:\"check_custom\";s:0:\"\";s:11:\"exclude_dir\";a:0:{}s:8:\"user_can\";s:16:\"activate_plugins\";s:14:\"quarantine_dir\";b:0;s:10:\"dont_check\";a:0:{}s:10:\"scan_level\";i:3;s:23:\"auto_UPDATE_definitions\";i:1;s:15:\"skip_quarantine\";i:0;s:5:\"check\";a:6:{i:0;s:8:\"htaccess\";i:1;s:8:\"timthumb\";i:2;s:8:\"backdoor\";i:3;s:5:\"known\";i:4;s:7:\"wp_core\";i:5;s:9:\"potential\";}}s:4:\"scan\";a:7:{s:3:\"dir\";s:31:\"/home/econolodge/public_html/wp\";s:5:\"start\";i:1459185115;s:4:\"type\";s:13:\"Complete Scan\";s:9:\"microtime\";d:321;s:7:\"percent\";i:-1;s:11:\"last_threat\";d:1459185436.5287048816680908203125;s:6:\"finish\";i:1459185436;}}", "yes");
INSERT INTO `wp_options` VALUES("49281", "GOTMLS_scan_log/97.96.91.241/1456326986.1898", "a:2:{s:8:\"settings\";a:14:{s:12:\"msg_position\";a:4:{i:0;s:4:\"80px\";i:1;s:4:\"40px\";i:2;s:5:\"400px\";i:3;s:5:\"600px\";}s:10:\"menu_group\";i:0;s:9:\"scan_what\";i:2;s:10:\"scan_depth\";i:-1;s:11:\"exclude_ext\";a:24:{i:0;s:3:\"png\";i:1;s:3:\"jpg\";i:2;s:4:\"jpeg\";i:3;s:3:\"gif\";i:4;s:3:\"bmp\";i:5;s:3:\"tif\";i:6;s:4:\"tiff\";i:7;s:3:\"psd\";i:8;s:3:\"fla\";i:9;s:3:\"flv\";i:10;s:3:\"mov\";i:11;s:3:\"mp3\";i:12;s:3:\"exe\";i:13;s:3:\"zip\";i:14;s:3:\"pdf\";i:15;s:3:\"css\";i:16;s:3:\"pot\";i:17;s:2:\"po\";i:18;s:2:\"mo\";i:19;s:2:\"so\";i:20;s:3:\"doc\";i:21;s:4:\"docx\";i:22;s:3:\"svg\";i:23;s:3:\"ttf\";}s:12:\"check_custom\";s:0:\"\";s:11:\"exclude_dir\";a:0:{}s:8:\"user_can\";s:16:\"activate_plugins\";s:14:\"quarantine_dir\";b:0;s:10:\"dont_check\";a:0:{}s:10:\"scan_level\";i:4;s:5:\"check\";a:6:{i:0;s:8:\"htaccess\";i:1;s:8:\"timthumb\";i:2;s:8:\"backdoor\";i:3;s:5:\"known\";i:4;s:7:\"wp_core\";i:5;s:9:\"potential\";}s:23:\"auto_UPDATE_definitions\";i:1;s:15:\"skip_quarantine\";i:0;}s:4:\"scan\";a:7:{s:3:\"dir\";s:34:\"/home/econolodge/public_html/wp/wp\";s:5:\"start\";i:1456326989;s:4:\"type\";s:13:\"Complete Scan\";s:9:\"microtime\";d:9838;s:7:\"percent\";i:-1;s:11:\"last_threat\";d:1456336810.854792118072509765625;s:6:\"finish\";i:1456336827;}}", "yes");
INSERT INTO `wp_options` VALUES("49336", "GOTMLS_scan_log/97.96.91.241/1456348071.775", "a:2:{s:8:\"settings\";a:14:{s:12:\"msg_position\";a:4:{i:0;s:4:\"80px\";i:1;s:4:\"40px\";i:2;s:5:\"400px\";i:3;s:5:\"600px\";}s:10:\"menu_group\";i:0;s:9:\"scan_what\";i:2;s:10:\"scan_depth\";i:-1;s:11:\"exclude_ext\";a:24:{i:0;s:3:\"png\";i:1;s:3:\"jpg\";i:2;s:4:\"jpeg\";i:3;s:3:\"gif\";i:4;s:3:\"bmp\";i:5;s:3:\"tif\";i:6;s:4:\"tiff\";i:7;s:3:\"psd\";i:8;s:3:\"fla\";i:9;s:3:\"flv\";i:10;s:3:\"mov\";i:11;s:3:\"mp3\";i:12;s:3:\"exe\";i:13;s:3:\"zip\";i:14;s:3:\"pdf\";i:15;s:3:\"css\";i:16;s:3:\"pot\";i:17;s:2:\"po\";i:18;s:2:\"mo\";i:19;s:2:\"so\";i:20;s:3:\"doc\";i:21;s:4:\"docx\";i:22;s:3:\"svg\";i:23;s:3:\"ttf\";}s:12:\"check_custom\";s:0:\"\";s:11:\"exclude_dir\";a:0:{}s:8:\"user_can\";s:16:\"activate_plugins\";s:14:\"quarantine_dir\";b:0;s:10:\"dont_check\";a:0:{}s:10:\"scan_level\";i:4;s:5:\"check\";a:6:{i:0;s:8:\"htaccess\";i:1;s:8:\"timthumb\";i:2;s:8:\"backdoor\";i:3;s:5:\"known\";i:4;s:7:\"wp_core\";i:5;s:9:\"potential\";}s:23:\"auto_UPDATE_definitions\";i:1;s:15:\"skip_quarantine\";i:0;}s:4:\"scan\";a:7:{s:3:\"dir\";s:34:\"/home/econolodge/public_html/wp/wp\";s:5:\"start\";i:1456348076;s:4:\"type\";s:13:\"Complete Scan\";s:9:\"microtime\";d:562;s:7:\"percent\";i:-1;s:11:\"last_threat\";d:1456348551.7786099910736083984375;s:6:\"finish\";i:1456348638;}}", "yes");
INSERT INTO `wp_options` VALUES("50264", "updraftplus-addons_siteid", "33f88a58b30cd969fe86bf03a2ae6fcc", "yes");
INSERT INTO `wp_options` VALUES("50265", "updraft_retain_extrarules", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("50266", "updraft_email", "", "yes");
INSERT INTO `wp_options` VALUES("50267", "updraft_report_warningsonly", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("50268", "updraft_report_wholebackup", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("50269", "updraft_extradbs", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("50270", "updraft_include_more_path", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("50271", "updraft_interval", "weekly", "yes");
INSERT INTO `wp_options` VALUES("50272", "updraft_retain", "1", "yes");
INSERT INTO `wp_options` VALUES("50273", "updraft_interval_database", "weekly", "yes");
INSERT INTO `wp_options` VALUES("50274", "updraft_retain_db", "1", "yes");
INSERT INTO `wp_options` VALUES("50275", "updraft_s3", "a:3:{s:9:\"accesskey\";s:0:\"\";s:9:\"secretkey\";s:0:\"\";s:4:\"path\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("50276", "updraft_cloudfiles", "a:5:{s:7:\"authurl\";s:35:\"https://auth.api.rackspacecloud.com\";s:6:\"region\";s:0:\"\";s:4:\"user\";s:0:\"\";s:6:\"apikey\";s:0:\"\";s:4:\"path\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("50277", "updraft_googledrive", "a:3:{s:8:\"clientid\";s:0:\"\";s:6:\"secret\";s:0:\"\";s:6:\"folder\";s:11:\"UpdraftPlus\";}", "yes");
INSERT INTO `wp_options` VALUES("50278", "updraft_ftp", "a:5:{s:4:\"host\";s:0:\"\";s:4:\"user\";s:0:\"\";s:4:\"pass\";s:0:\"\";s:4:\"path\";s:0:\"\";s:7:\"passive\";s:1:\"1\";}", "yes");
INSERT INTO `wp_options` VALUES("50279", "updraft_s3generic", "a:4:{s:8:\"endpoint\";s:0:\"\";s:9:\"accesskey\";s:0:\"\";s:9:\"secretkey\";s:0:\"\";s:4:\"path\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("50280", "updraft_dreamobjects", "a:4:{s:8:\"endpoint\";s:26:\"objects-us-west-1.dream.io\";s:9:\"accesskey\";s:0:\"\";s:9:\"secretkey\";s:0:\"\";s:4:\"path\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("50281", "updraft_include_plugins", "1", "yes");
INSERT INTO `wp_options` VALUES("50282", "updraft_include_themes", "1", "yes");
INSERT INTO `wp_options` VALUES("50283", "updraft_include_uploads", "1", "yes");
INSERT INTO `wp_options` VALUES("50284", "updraft_include_uploads_exclude", "backup*,*backups,backwpup*,wp-clone", "yes");
INSERT INTO `wp_options` VALUES("50285", "updraft_include_others", "1", "yes");
INSERT INTO `wp_options` VALUES("50286", "updraft_include_others_exclude", "upgrade,cache,updraft,backup*,*backups,mysql.sql,debug.log", "yes");
INSERT INTO `wp_options` VALUES("50287", "updraft_split_every", "400", "yes");
INSERT INTO `wp_options` VALUES("50288", "updraft_delete_local", "1", "yes");
INSERT INTO `wp_options` VALUES("50289", "updraft_dir", "updraft", "yes");
INSERT INTO `wp_options` VALUES("50290", "updraft_service", "", "yes");
INSERT INTO `wp_options` VALUES("50291", "updraft_debug_mode", "0", "yes");
INSERT INTO `wp_options` VALUES("50292", "updraft_ssl_useservercerts", "0", "yes");
INSERT INTO `wp_options` VALUES("50293", "updraft_ssl_disableverify", "0", "yes");
INSERT INTO `wp_options` VALUES("50294", "updraft_ssl_nossl", "0", "yes");
INSERT INTO `wp_options` VALUES("50305", "updraft_backup_history", "a:1:{i:1494961815;a:15:{s:7:\"plugins\";a:1:{i:0;s:64:\"backup_2017-05-16-1510_wwwtheterninncom_732f27edac8f-plugins.zip\";}s:12:\"plugins-size\";i:21077762;s:6:\"themes\";a:1:{i:0;s:63:\"backup_2017-05-16-1510_wwwtheterninncom_732f27edac8f-themes.zip\";}s:11:\"themes-size\";i:3579448;s:7:\"uploads\";a:1:{i:0;s:64:\"backup_2017-05-16-1510_wwwtheterninncom_732f27edac8f-uploads.zip\";}s:12:\"uploads-size\";i:161713797;s:6:\"others\";a:1:{i:0;s:63:\"backup_2017-05-16-1510_wwwtheterninncom_732f27edac8f-others.zip\";}s:11:\"others-size\";i:357292;s:2:\"db\";s:58:\"backup_2017-05-16-1510_wwwtheterninncom_732f27edac8f-db.gz\";s:7:\"db-size\";i:1335732;s:9:\"checksums\";a:2:{s:4:\"sha1\";a:5:{s:8:\"plugins0\";s:40:\"ad6a5e19b27e4a2d912244400907e29e4ab17a51\";s:7:\"themes0\";s:40:\"dfa605cc694bd70b850438fb3250e884efea9a86\";s:8:\"uploads0\";s:40:\"44c2ef9ee11e2b7ac4eeded0a00f0ecbd292e27e\";s:7:\"others0\";s:40:\"d0e1634d108fd73afbfc10621c597a3fb7648fa1\";s:3:\"db0\";s:40:\"c699967fa6c015210feae13d392711933988a6d4\";}s:6:\"sha256\";a:5:{s:8:\"plugins0\";s:64:\"9a2dcdc69f84fcc4b3e1e53468f74cc89ff50108d1993b5fa6edc8a5d695a3ad\";s:7:\"themes0\";s:64:\"de71a7b1d7a5ed6af61df15a8185dce1ad7b2c80c455537f909b158039687c3c\";s:8:\"uploads0\";s:64:\"9f424c2eff5de2721b07ee495f9a93745b9465316f707a82d54019b1d09b58ac\";s:7:\"others0\";s:64:\"d681ab9483aea64bb4acc5396ed66f65b6eba83bf1fe8d7e573fb7a76dc4a56b\";s:3:\"db0\";s:64:\"c4cee0c0e4f2ea37e1e2bdbb2c127b890c16837826e6331fddcd2babf3bb42d6\";}}s:5:\"nonce\";s:12:\"732f27edac8f\";s:7:\"service\";a:1:{i:0;s:0:\"\";}s:18:\"created_by_version\";s:6:\"1.13.1\";s:12:\"is_multisite\";b:0;}}", "yes");
INSERT INTO `wp_options` VALUES("50296", "updraft_lastmessage", "The backup apparently succeeded and is now complete (May 16 15:11:07)", "yes");
INSERT INTO `wp_options` VALUES("50297", "updraftplus_unlocked_fd", "1", "yes");
INSERT INTO `wp_options` VALUES("50298", "updraftplus_last_lock_time_fd", "2017-05-16 19:10:15", "yes");
INSERT INTO `wp_options` VALUES("50299", "updraftplus_semaphore_fd", "0", "yes");
INSERT INTO `wp_options` VALUES("50300", "updraft_last_scheduled_fd", "1494961815", "yes");
INSERT INTO `wp_options` VALUES("50302", "updraftplus_unlocked_", "1", "yes");
INSERT INTO `wp_options` VALUES("50303", "updraftplus_last_lock_time_", "2016-03-08 19:12:15", "yes");
INSERT INTO `wp_options` VALUES("50304", "updraftplus_semaphore_", "0", "yes");
INSERT INTO `wp_options` VALUES("50306", "updraft_last_backup", "a:5:{s:11:\"backup_time\";i:1494961815;s:12:\"backup_array\";a:11:{s:7:\"plugins\";a:1:{i:0;s:64:\"backup_2017-05-16-1510_wwwtheterninncom_732f27edac8f-plugins.zip\";}s:12:\"plugins-size\";i:21077762;s:6:\"themes\";a:1:{i:0;s:63:\"backup_2017-05-16-1510_wwwtheterninncom_732f27edac8f-themes.zip\";}s:11:\"themes-size\";i:3579448;s:7:\"uploads\";a:1:{i:0;s:64:\"backup_2017-05-16-1510_wwwtheterninncom_732f27edac8f-uploads.zip\";}s:12:\"uploads-size\";i:161713797;s:6:\"others\";a:1:{i:0;s:63:\"backup_2017-05-16-1510_wwwtheterninncom_732f27edac8f-others.zip\";}s:11:\"others-size\";i:357292;s:2:\"db\";s:58:\"backup_2017-05-16-1510_wwwtheterninncom_732f27edac8f-db.gz\";s:7:\"db-size\";i:1335732;s:9:\"checksums\";a:2:{s:4:\"sha1\";a:5:{s:8:\"plugins0\";s:40:\"ad6a5e19b27e4a2d912244400907e29e4ab17a51\";s:7:\"themes0\";s:40:\"dfa605cc694bd70b850438fb3250e884efea9a86\";s:8:\"uploads0\";s:40:\"44c2ef9ee11e2b7ac4eeded0a00f0ecbd292e27e\";s:7:\"others0\";s:40:\"d0e1634d108fd73afbfc10621c597a3fb7648fa1\";s:3:\"db0\";s:40:\"c699967fa6c015210feae13d392711933988a6d4\";}s:6:\"sha256\";a:5:{s:8:\"plugins0\";s:64:\"9a2dcdc69f84fcc4b3e1e53468f74cc89ff50108d1993b5fa6edc8a5d695a3ad\";s:7:\"themes0\";s:64:\"de71a7b1d7a5ed6af61df15a8185dce1ad7b2c80c455537f909b158039687c3c\";s:8:\"uploads0\";s:64:\"9f424c2eff5de2721b07ee495f9a93745b9465316f707a82d54019b1d09b58ac\";s:7:\"others0\";s:64:\"d681ab9483aea64bb4acc5396ed66f65b6eba83bf1fe8d7e573fb7a76dc4a56b\";s:3:\"db0\";s:64:\"c4cee0c0e4f2ea37e1e2bdbb2c127b890c16837826e6331fddcd2babf3bb42d6\";}}}s:7:\"success\";i:1;s:6:\"errors\";a:0:{}s:12:\"backup_nonce\";s:12:\"732f27edac8f\";}", "yes");
INSERT INTO `wp_options` VALUES("50945", "GOTMLS_scan_log/97.96.91.241/1458248375.5256", "a:2:{s:8:\"settings\";a:14:{s:12:\"msg_position\";a:4:{i:0;s:4:\"80px\";i:1;s:4:\"40px\";i:2;s:5:\"400px\";i:3;s:5:\"600px\";}s:10:\"menu_group\";i:0;s:9:\"scan_what\";i:2;s:10:\"scan_depth\";i:-1;s:11:\"exclude_ext\";a:24:{i:0;s:3:\"png\";i:1;s:3:\"jpg\";i:2;s:4:\"jpeg\";i:3;s:3:\"gif\";i:4;s:3:\"bmp\";i:5;s:3:\"tif\";i:6;s:4:\"tiff\";i:7;s:3:\"psd\";i:8;s:3:\"fla\";i:9;s:3:\"flv\";i:10;s:3:\"mov\";i:11;s:3:\"mp3\";i:12;s:3:\"exe\";i:13;s:3:\"zip\";i:14;s:3:\"pdf\";i:15;s:3:\"css\";i:16;s:3:\"pot\";i:17;s:2:\"po\";i:18;s:2:\"mo\";i:19;s:2:\"so\";i:20;s:3:\"doc\";i:21;s:4:\"docx\";i:22;s:3:\"svg\";i:23;s:3:\"ttf\";}s:12:\"check_custom\";s:0:\"\";s:11:\"exclude_dir\";a:0:{}s:8:\"user_can\";s:16:\"activate_plugins\";s:14:\"quarantine_dir\";b:0;s:10:\"dont_check\";a:0:{}s:10:\"scan_level\";i:3;s:23:\"auto_UPDATE_definitions\";i:1;s:15:\"skip_quarantine\";i:0;s:5:\"check\";a:6:{i:0;s:8:\"htaccess\";i:1;s:8:\"timthumb\";i:2;s:8:\"backdoor\";i:3;s:5:\"known\";i:4;s:7:\"wp_core\";i:5;s:9:\"potential\";}}s:4:\"scan\";a:7:{s:3:\"dir\";s:31:\"/home/econolodge/public_html/wp\";s:5:\"start\";i:1458248376;s:4:\"type\";s:13:\"Complete Scan\";s:9:\"microtime\";d:211;s:7:\"percent\";i:-1;s:11:\"last_threat\";d:1458248587.5224850177764892578125;s:6:\"finish\";i:1458248587;}}", "yes");
INSERT INTO `wp_options` VALUES("137918", "wpseo_flush_rewrite", "1", "yes");
INSERT INTO `wp_options` VALUES("70861", "GOTMLS_Installation_Keys", "s:89:\"a:1:{s:32:\"87b6fce418c674318ece22250c5ee861\";s:35:\"http://67.23.236.217/~windriftmotel\";}\";", "yes");
INSERT INTO `wp_options` VALUES("53009", "GOTMLS_scan_log/97.96.91.241/1460489586.9378", "a:2:{s:8:\"settings\";a:14:{s:12:\"msg_position\";a:4:{i:0;s:4:\"80px\";i:1;s:4:\"40px\";i:2;s:5:\"400px\";i:3;s:5:\"600px\";}s:10:\"menu_group\";i:0;s:9:\"scan_what\";i:2;s:10:\"scan_depth\";i:-1;s:11:\"exclude_ext\";a:24:{i:0;s:3:\"png\";i:1;s:3:\"jpg\";i:2;s:4:\"jpeg\";i:3;s:3:\"gif\";i:4;s:3:\"bmp\";i:5;s:3:\"tif\";i:6;s:4:\"tiff\";i:7;s:3:\"psd\";i:8;s:3:\"fla\";i:9;s:3:\"flv\";i:10;s:3:\"mov\";i:11;s:3:\"mp3\";i:12;s:3:\"exe\";i:13;s:3:\"zip\";i:14;s:3:\"pdf\";i:15;s:3:\"css\";i:16;s:3:\"pot\";i:17;s:2:\"po\";i:18;s:2:\"mo\";i:19;s:2:\"so\";i:20;s:3:\"doc\";i:21;s:4:\"docx\";i:22;s:3:\"svg\";i:23;s:3:\"ttf\";}s:12:\"check_custom\";s:0:\"\";s:11:\"exclude_dir\";a:0:{}s:8:\"user_can\";s:16:\"activate_plugins\";s:14:\"quarantine_dir\";b:0;s:10:\"dont_check\";a:0:{}s:10:\"scan_level\";i:3;s:23:\"auto_UPDATE_definitions\";i:1;s:15:\"skip_quarantine\";i:0;s:5:\"check\";a:6:{i:0;s:8:\"htaccess\";i:1;s:8:\"timthumb\";i:2;s:8:\"backdoor\";i:3;s:5:\"known\";i:4;s:7:\"wp_core\";i:5;s:9:\"potential\";}}s:4:\"scan\";a:7:{s:3:\"dir\";s:31:\"/home/econolodge/public_html/wp\";s:5:\"start\";i:1460489608;s:4:\"type\";s:13:\"Complete Scan\";s:9:\"microtime\";d:30;s:7:\"percent\";i:-1;s:11:\"last_threat\";d:1460489638.31558990478515625;s:6:\"finish\";i:1460489638;}}", "yes");
INSERT INTO `wp_options` VALUES("54508", "addthis_shared_settings", "a:20:{s:25:\"addthis_anonymous_profile\";s:35:\"wp-d2a5e08fcef0522ac12578fdf3a6c2cf\";s:28:\"addthis_asynchronous_loading\";b:1;s:24:\"addthis_per_post_enabled\";b:1;s:15:\"addthis_profile\";s:0:\"\";s:15:\"addthis_rate_us\";s:0:\"\";s:28:\"credential_validation_status\";i:0;s:8:\"wpfooter\";b:1;s:23:\"addthis_plugin_controls\";s:9:\"WordPress\";s:19:\"addthis_environment\";s:0:\"\";s:24:\"addthis_twitter_template\";s:0:\"\";s:13:\"addthis_bitly\";b:0;s:18:\"addthis_share_json\";s:0:\"\";s:19:\"addthis_layers_json\";s:0:\"\";s:16:\"data_ga_property\";s:0:\"\";s:16:\"addthis_language\";s:0:\"\";s:9:\"atversion\";i:300;s:19:\"addthis_append_data\";b:1;s:18:\"addthis_addressbar\";b:0;s:11:\"addthis_508\";s:0:\"\";s:19:\"addthis_config_json\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("134726", "wphb-notice-uptime-info-show", "yes", "no");
INSERT INTO `wp_options` VALUES("48134", "wordfenceActivated", "1", "yes");
INSERT INTO `wp_options` VALUES("48135", "wf_plugin_act_error", "", "yes");
INSERT INTO `wp_options` VALUES("49278", "GOTMLS_nonce_array", "a:19:{s:32:\"20b460efa5f61c66d21e93ed57b9bdda\";d:1456325680.394898891448974609375;s:32:\"d8bb626d15ca0e9f190aefd5282a4776\";d:1456325738.7575490474700927734375;s:32:\"04b85cf0c25471ba2be0c37c650d3b2d\";d:1456325745.937386035919189453125;s:32:\"88aafa95f42b09aa5ea5da9a69089d89\";d:1456325753.526546001434326171875;s:32:\"8a6b5d498d31f2c1adb67ddba72afa4f\";d:1456325763.0546610355377197265625;s:32:\"0f1d628f22ffebb9d1156fdba0423c3d\";d:1456326986.1897990703582763671875;s:32:\"eb1cd231d80413d0a7485a4b67d0a8da\";d:1456348059.3610680103302001953125;s:32:\"393bd5c9a05815bc4f3977baa5fd331b\";d:1456348071.775024890899658203125;s:32:\"e27d7d7f389b73c4bb0a22dbeaea73e5\";d:1456853984.5440580844879150390625;s:32:\"f703e4b8a44a2d72e8f63689cfe88aae\";d:1458247919.76504993438720703125;s:32:\"43045fc632e70e16960f6aa5e797bf84\";d:1458247921.5751860141754150390625;s:32:\"a9533841c2b6f37e472aeeccf6c51287\";d:1458248371.4258739948272705078125;s:32:\"84646919ccb01fae10502a695eb9b440\";d:1458248375.5255920886993408203125;s:32:\"f6dfef083bf61997860edfbc2f532813\";d:1459185081.53864192962646484375;s:32:\"2e286274df3de67519088d4f9e6c1060\";d:1460489586.9377939701080322265625;s:32:\"49dfaf0e31b1d54a3f4f4e8b3c108e02\";d:410487;s:32:\"be237e9f046c2602b94aba9cb7159b8e\";d:410777;s:32:\"a24c8d9bba4441319fa3819caa58c6e6\";d:413247;s:32:\"0c71b64a4b1bf4f0ba5f76d896b05c24\";d:413562;}", "yes");
INSERT INTO `wp_options` VALUES("48143", "mainwp_child_legacy", "", "no");
INSERT INTO `wp_options` VALUES("48144", "mainwp_child_auth", "a:2:{i:5;s:32:\"741bb7cde327b4d3a5c8a2df59e691ec\";s:4:\"last\";i:1452897682;}", "no");
INSERT INTO `wp_options` VALUES("48146", "mainwp_child_uniqueId", "", "no");
INSERT INTO `wp_options` VALUES("48147", "mainwp_child_onetime_htaccess", "", "no");
INSERT INTO `wp_options` VALUES("48148", "mainwp_child_htaccess_set", "", "no");
INSERT INTO `wp_options` VALUES("48149", "mainwp_child_fix_htaccess", "", "no");
INSERT INTO `wp_options` VALUES("48150", "mainwp_child_pubkey", "", "no");
INSERT INTO `wp_options` VALUES("48151", "mainwp_child_server", "", "no");
INSERT INTO `wp_options` VALUES("48152", "mainwp_child_nonce", "", "no");
INSERT INTO `wp_options` VALUES("48153", "mainwp_child_nossl", "", "no");
INSERT INTO `wp_options` VALUES("48154", "mainwp_child_nossl_key", "", "no");
INSERT INTO `wp_options` VALUES("48155", "mainwp_child_remove_wp_version", "", "no");
INSERT INTO `wp_options` VALUES("48156", "mainwp_child_remove_rsd", "", "no");
INSERT INTO `wp_options` VALUES("48157", "mainwp_child_remove_wlw", "", "no");
INSERT INTO `wp_options` VALUES("48158", "mainwp_child_remove_core_updates", "", "no");
INSERT INTO `wp_options` VALUES("48159", "mainwp_child_remove_plugin_updates", "", "no");
INSERT INTO `wp_options` VALUES("48160", "mainwp_child_remove_theme_updates", "", "no");
INSERT INTO `wp_options` VALUES("48161", "mainwp_child_remove_php_reporting", "", "no");
INSERT INTO `wp_options` VALUES("48162", "mainwp_child_remove_scripts_version", "", "no");
INSERT INTO `wp_options` VALUES("48163", "mainwp_child_remove_styles_version", "", "no");
INSERT INTO `wp_options` VALUES("48164", "mainwp_child_remove_readme", "", "no");
INSERT INTO `wp_options` VALUES("48165", "heatMapEnabled", "", "no");
INSERT INTO `wp_options` VALUES("48166", "mainwp_child_clone_sites", "", "no");
INSERT INTO `wp_options` VALUES("48167", "mainwp_child_pluginDir", "", "no");
INSERT INTO `wp_options` VALUES("48168", "mainwp_premium_updates", "", "no");
INSERT INTO `wp_options` VALUES("48169", "mainwp_child_activated_once", "1", "no");
INSERT INTO `wp_options` VALUES("48170", "mainwp_maintenance_opt_alert_404", "", "no");
INSERT INTO `wp_options` VALUES("48171", "mainwp_maintenance_opt_alert_404_email", "", "no");
INSERT INTO `wp_options` VALUES("48174", "mainwp_temp_clone_plugins", "", "no");
INSERT INTO `wp_options` VALUES("48175", "mainwp_temp_clone_themes", "", "no");
INSERT INTO `wp_options` VALUES("48176", "mainwp_child_click_data", "", "no");
INSERT INTO `wp_options` VALUES("48177", "mainwp_child_clone_from_server_last_folder", "", "no");
INSERT INTO `wp_options` VALUES("48178", "mainwp_child_clone_permalink", "", "no");
INSERT INTO `wp_options` VALUES("48179", "mainwp_child_restore_permalink", "", "no");
INSERT INTO `wp_options` VALUES("48180", "mainwp_keyword_links_htaccess_set", "", "no");
INSERT INTO `wp_options` VALUES("48181", "mainwp_kwl_options", "", "no");
INSERT INTO `wp_options` VALUES("48182", "mainwp_kwl_keyword_links", "", "no");
INSERT INTO `wp_options` VALUES("48183", "mainwp_kwl_click_statistic_data", "", "no");
INSERT INTO `wp_options` VALUES("48184", "mainwp_kwl_statistic_data_", "", "no");
INSERT INTO `wp_options` VALUES("48185", "mainwp_kwl_enable_statistic", "", "no");
INSERT INTO `wp_options` VALUES("48186", "mainwpKeywordLinks", "", "no");
INSERT INTO `wp_options` VALUES("48187", "mainwp_branding_plugin_header", "", "no");
INSERT INTO `wp_options` VALUES("48199", "mainwp_branding_disable_wp_branding", "", "no");
INSERT INTO `wp_options` VALUES("48204", "mainwp_child_update_version", "1.3", "yes");
INSERT INTO `wp_options` VALUES("48205", "mainwp_child_plugin_version", "3.0", "yes");
INSERT INTO `wp_options` VALUES("48206", "mainwp_child_branding_disconnected", "yes", "yes");
INSERT INTO `wp_options` VALUES("48291", "theme_mods_customizr", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:3:{s:7:\"primary\";i:2;s:3:\"top\";i:0;s:6:\"footer\";i:2;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1452976082;s:4:\"data\";a:7:{s:19:\"wp_inactive_widgets\";a:1:{i:0;s:8:\"search-2\";}s:4:\"left\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}s:5:\"right\";a:2:{i:0;s:6:\"text-2\";i:1;s:6:\"text-3\";}s:10:\"footer_one\";a:0:{}s:10:\"footer_two\";a:0:{}s:12:\"footer_three\";a:0:{}s:18:\"orphaned_widgets_1\";a:0:{}}}}", "yes");
INSERT INTO `wp_options` VALUES("49277", "GOTMLS_settings_array", "a:14:{s:12:\"msg_position\";a:4:{i:0;s:4:\"80px\";i:1;s:4:\"40px\";i:2;s:5:\"400px\";i:3;s:5:\"600px\";}s:10:\"menu_group\";i:0;s:9:\"scan_what\";i:2;s:10:\"scan_depth\";i:-1;s:11:\"exclude_ext\";a:24:{i:0;s:3:\"png\";i:1;s:3:\"jpg\";i:2;s:4:\"jpeg\";i:3;s:3:\"gif\";i:4;s:3:\"bmp\";i:5;s:3:\"tif\";i:6;s:4:\"tiff\";i:7;s:3:\"psd\";i:8;s:3:\"fla\";i:9;s:3:\"flv\";i:10;s:3:\"mov\";i:11;s:3:\"mp3\";i:12;s:3:\"exe\";i:13;s:3:\"zip\";i:14;s:3:\"pdf\";i:15;s:3:\"css\";i:16;s:3:\"pot\";i:17;s:2:\"po\";i:18;s:2:\"mo\";i:19;s:2:\"so\";i:20;s:3:\"doc\";i:21;s:4:\"docx\";i:22;s:3:\"svg\";i:23;s:3:\"ttf\";}s:12:\"check_custom\";s:0:\"\";s:11:\"exclude_dir\";a:0:{}s:8:\"user_can\";s:16:\"activate_plugins\";s:14:\"quarantine_dir\";b:0;s:10:\"dont_check\";a:0:{}s:10:\"scan_level\";i:3;s:23:\"auto_UPDATE_definitions\";i:1;s:15:\"skip_quarantine\";i:0;s:5:\"check\";a:5:{i:0;s:8:\"htaccess\";i:1;s:8:\"timthumb\";i:2;s:8:\"backdoor\";i:3;s:5:\"known\";i:4;s:7:\"wp_core\";}}", "yes");
INSERT INTO `wp_options` VALUES("54509", "addthis_sharing_buttons_settings", "a:54:{s:5:\"above\";s:13:\"large_toolbox\";s:17:\"above_chosen_list\";s:0:\"\";s:19:\"above_auto_services\";b:1;s:17:\"above_custom_more\";s:0:\"\";s:22:\"above_custom_preferred\";s:0:\"\";s:21:\"above_custom_services\";s:0:\"\";s:17:\"above_custom_size\";s:0:\"\";s:19:\"above_custom_string\";s:0:\"\";s:21:\"addthis_above_enabled\";b:0;s:18:\"addthis_aftertitle\";b:0;s:22:\"addthis_beforecomments\";b:0;s:21:\"addthis_below_enabled\";b:0;s:21:\"addthis_sidebar_count\";s:1:\"5\";s:23:\"addthis_sidebar_enabled\";b:0;s:24:\"addthis_sidebar_position\";s:4:\"left\";s:30:\"addthis_mobile_toolbar_enabled\";b:0;s:43:\"addthis_mobile_toolbar_numPreferredServices\";s:1:\"4\";s:31:\"addthis_mobile_toolbar_position\";s:6:\"bottom\";s:29:\"addthis_mobile_toolbar_counts\";b:1;s:23:\"atversion_update_status\";i:0;s:5:\"below\";s:13:\"large_toolbox\";s:17:\"below_chosen_list\";s:0:\"\";s:19:\"below_auto_services\";b:1;s:17:\"below_custom_more\";s:0:\"\";s:22:\"below_custom_preferred\";s:0:\"\";s:21:\"below_custom_services\";s:0:\"\";s:17:\"below_custom_size\";s:0:\"\";s:19:\"below_custom_string\";s:0:\"\";s:8:\"location\";s:5:\"below\";s:5:\"style\";s:11:\"fb_tw_p1_sc\";s:7:\"toolbox\";s:0:\"\";s:25:\"addthis_above_showon_home\";b:1;s:26:\"addthis_above_showon_posts\";b:1;s:26:\"addthis_above_showon_pages\";b:1;s:29:\"addthis_above_showon_archives\";b:1;s:31:\"addthis_above_showon_categories\";b:1;s:29:\"addthis_above_showon_excerpts\";b:1;s:25:\"addthis_below_showon_home\";b:1;s:26:\"addthis_below_showon_posts\";b:1;s:26:\"addthis_below_showon_pages\";b:1;s:29:\"addthis_below_showon_archives\";b:1;s:31:\"addthis_below_showon_categories\";b:1;s:29:\"addthis_below_showon_excerpts\";b:1;s:27:\"addthis_sidebar_showon_home\";b:1;s:28:\"addthis_sidebar_showon_posts\";b:1;s:28:\"addthis_sidebar_showon_pages\";b:1;s:31:\"addthis_sidebar_showon_archives\";b:1;s:33:\"addthis_sidebar_showon_categories\";b:1;s:34:\"addthis_mobile_toolbar_showon_home\";b:1;s:35:\"addthis_mobile_toolbar_showon_posts\";b:1;s:35:\"addthis_mobile_toolbar_showon_pages\";b:1;s:38:\"addthis_mobile_toolbar_showon_archives\";b:1;s:40:\"addthis_mobile_toolbar_showon_categories\";b:1;s:22:\"addthis_plugin_version\";s:5:\"5.3.5\";}", "yes");
INSERT INTO `wp_options` VALUES("86765", "updraft_dropbox", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("84384", "mwp_openssl_parameters", "a:2:{s:4:\"time\";i:1522950017;s:7:\"working\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("84385", "mwp_incremental_update_active", "", "yes");
INSERT INTO `wp_options` VALUES("83813", "fresh_site", "0", "yes");
INSERT INTO `wp_options` VALUES("54511", "widget_addthis-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("83550", "GOTMLS_definitions_blob", "YTo5OntzOjc6IndwX2NvcmUiO2E6MTp7czo1OiI=LjcuMiI7YToxMzEwOntzOjEwOiIvaW5kZXgucGhwIjtzOjM2OiJiNjFiMjUzMDNiZTBmNTczYTZiOTQ=NmQ1Y2JlM2E1Yk8=MTgiO3M6MTI6Ii9saWNlbnNlLnR4dCI7czozODoiMGQwNDM=YzhiMTc2YzUyNWE2ZmNlOWNlZmRmOGUxMDZPMTk5MzUiO3M6MTY6Ii93cC1hY3RpdmF=ZS5waHAiO3M6Mzc6IjdiYTM4YjNjMmM5ZjY4NDhmYmRhZmY5NGIwYTE4MmI=TzU=NDciO3M6MTk6Ii93cC1hZG1pbi9hYm91dC5waHAiO3M6Mzg6ImM1ODE4ZDY2N2Y5N2Y=MGY2N2VjMWJiMWJlZDcxZjNhTzE4MzgyIjtzOjI=OiIvd3AtYWRtaW4vYWRtaW4tYWpheC5waHAiO3M6Mzc6ImE=ODQ1NGM5ZTY=NjEzYTU1ODA2MWI=OWE2NmNmYjExTzM3OTkiO3M6MjY6Ii93cC1hZG1pbi9hZG1pbi1mb29=ZXIucGhwIjtzOjM3OiIzN2FkMTJlOTVlYzQ3YmYxZTZhMTI4ZWI4ZDZlOTk1OE8yNzg3IjtzOjI5OiIvd3AtYWRtaW4vYWRtaW4tZnVuY3Rpb25zLnBocCI7czozNjoiYWYwYjQ2ZWFmYjI=ZTM3MzNhODgzOTgzNmQyNTYxNDZPNDA1IjtzOjI2OiIvd3AtYWRtaW4vYWRtaW4taGVhZGVyLnBocCI7czozNzoiNzQxZDgxODIxMDM5YjFmNzdmNTI1OGI5MjNkMzhmOTJPNzMzNyI7czoyNDoiL3dwLWFkbWluL2FkbWluLXBvc3QucGhwIjtzOjM3OiIxNjNlY2M1YjczYjQwY2UwMmJhNDE4YTNlZGVlMmM2OE8xNjg2IjtzOjE5OiIvd3AtYWRtaW4vYWRtaW4ucGhwIjtzOjM4OiI=NTBjN2MyYWZhMTI2ODRmMjhmZjk3NmNhZGUxMTk4NU8xMDMzOCI7czoyNjoiL3dwLWFkbWluL2FzeW5jLXVwbG9hZC5waHAiO3M6Mzc6IjMyMDQ4MWM2ODM=NDQyYmZkNzdjM2M4YmM5NTM=OGJmTzQyMTUiO3M6MjE6Ii93cC1hZG1pbi9jb21tZW5=LnBocCI7czozODoiZDc4ZmY4MmQ2ZmUyY2NhNmIwNmNmMzZkNzhhNTgxZGNPMTA=NTkiO3M6MjE6Ii93cC1hZG1pbi9jcmVkaXRzLnBocCI7czozNzoiYmI5ZGM5NjJlMTNhZmMzNzg5YjBkMThhM2M2Y2YxZjdPNDc=NCI7czoyNzoiL3dwLWFkbWluL2Nzcy9hYm91dC1ydGwuY3NzIjtzOjM3OiI5ZjY4ODEyNDM3ZTE4Y2M1YjI3YjQ4YWRlMDFlNjMxOU84Nzk2IjtzOjMxOiIvd3AtYWRtaW4vY3NzL2Fib3V=LXJ=bC5taW4uY3NzIjtzOjM3OiJjYWQ=MzgzODRkNjhkMTczMjlmYzEzN2RjNGU3MGY2Zk82MjQxIjtzOjIzOiIvd3AtYWRtaW4vY3NzL2Fib3V=LmNzcyI7czozNzoiMDU4YTVjOTRhMTY2MTMyMDRiOGI5ODNiZTAzYjE2YzZPODc5OSI7czoyNzoiL3dwLWFkbWluL2Nzcy9hYm91dC5taW4uY3NzIjtzOjM3OiJjMzIxMjlmMzhhNjEwYWZlYjVkYWI4NGNjMmI=MmU=Y=82MjQ=IjtzOjMyOiIvd3AtYWRtaW4vY3NzL2FkbWluLW1lbnUtcnRsLmNzcyI7czozODoiNGRmNmFmOGQyNzRjOWM4NGYwMDk5NWM=YjA2Yjg2NjhPMTk2ODgiO3M6MzY6Ii93cC1hZG1pbi9jc3MvYWRtaW4tbWVudS1ydGwubWluLmNzcyI7czozODoiNzgzNGY3NTZkZjdiY2Q5YjYxNThjYWJlZmUxMGZlYjVPMTYwMDciO3M6Mjg6Ii93cC1hZG1pbi9jc3MvYWRtaW4tbWVudS5jc3MiO3M6Mzg6IjVlMTM=OTE2MWE4NTgzOWJlMDI=NDg4YTUwZGU5NWIzTzE5Njc=IjtzOjMyOiIvd3AtYWRtaW4vY3NzL2FkbWluLW1lbnUubWluLmNzcyI7czozODoiMTA1NmYzMjcyZWJlODNmMTNkNWQzZjg2YTgyYTc3ZjRPMTU5OTMiO3M6MzQ6Ii93cC1hZG1pbi9jc3MvY29sb3ItcGlja2VyLXJ=bC5jc3MiO3M6Mzc6ImY4NzVmZmFkNTU1M2Q2NjJiZWVhOTdlNjNlYzI=YmJmTzI1NDIiO3M6Mzg6Ii93cC1hZG1pbi9jc3MvY29sb3ItcGlja2VyLXJ=bC5taW4uY3NzIjtzOjM3OiI2OTk2YmE5NGY=YjM=Zjc2NjY3M2FlODc5ZTRhNDJkNU8yMTQ3IjtzOjMwOiIvd3AtYWRtaW4vY3NzL2NvbG9yLXBpY2tlci5jc3MiO3M6Mzc6IjEyYjYwZDk=Zjk4MjZkNDAyZTY2YzJlOTE5NGFhODBiTzI1MzkiO3M6MzQ6Ii93cC1hZG1pbi9jc3MvY29sb3ItcGlja2VyLm1pbi5jc3MiO3M6Mzc6IjljN2Y=YWRjMGNkMWZlMWExNWU4OWZmNDA4MmY=YjdjTzIxNDQiO3M6NDA6Ii93cC1hZG1pbi9jc3MvY29sb3JzL2JsdWUvY29sb3JzLXJ=bC5jc3MiO3M6Mzg6ImQ2OTQ4OWQyNjMyMmQwMWQzYjI4NGE2YjcxYTY1ZjlhTzEzMTcwIjtzOjQ=OiIvd3AtYWRtaW4vY3NzL2NvbG9ycy9ibHVlL2NvbG9ycy1ydGwubWluLmNzcyI7czozODoiZDc2ZTNmOTkzZjk2MjMyNmU2YTIzMzZkYjc1ZDNmZDZPMTE=MzgiO3M6MzY6Ii93cC1hZG1pbi9jc3MvY29sb3JzL2JsdWUvY29sb3JzLmNzcyI7czozODoiOGIyOTg4MWNkOGEwMjRhZjFjODkwZjY4OTg5M2U1MGJPMTMxNzIiO3M6NDA6Ii93cC1hZG1pbi9jc3MvY29sb3JzL2JsdWUvY29sb3JzLm1pbi5jc3MiO3M6Mzg6IjgzNTIyOGY=MzdiNzZjYjQzMzZmZDJkYjE4NDFhOTg=TzExNDQwIjtzOjM3OiIvd3AtYWRtaW4vY3NzL2NvbG9ycy9ibHVlL2NvbG9ycy5zY3NzIjtzOjM2OiJkOWQwMzU=OWQ3OTQ4NDY3MmMyOTE=NWFhZDU5NGRiM=8yNDkiO3M6NDI6Ii93cC1hZG1pbi9jc3MvY29sb3JzL2NvZmZlZS9jb2xvcnMtcnRsLmNzcyI7czozODoiNzRkYWI2MTJiNjI2NDdlZWFjNTYxMDJkOWZkZWQ=OTZPMTMxOTQiO3M6NDY6Ii93cC1hZG1pbi9jc3MvY29sb3JzL2NvZmZlZS9jb2xvcnMtcnRsLm1pbi5jc3MiO3M6Mzg6ImY4NjdmZDdhZGNjZDFlY2RmNzY=NzM5MDUzYTZlYzJhTzExNDczIjtzOjM4OiIvd3AtYWRtaW4vY3NzL2NvbG9ycy9jb2ZmZWUvY29sb3JzLmNzcyI7czozODoiMmJkODNjNDNhZWQ2MGMxNzVhMGY4YzVkMjczODYzOWJPMTMxOTYiO3M6NDI6Ii93cC1hZG1pbi9jc3MvY29sb3JzL2NvZmZlZS9jb2xvcnMubWluLmNzcyI7czozODoiYTU4NWQ=ZWIzMjMzMmQ5MGIyM2Y3OTIzMTJiYzRkOGFPMTE=NzUiO3M6Mzk6Ii93cC1hZG1pbi9jc3MvY29sb3JzL2NvZmZlZS9jb2xvcnMuc2NzcyI7czozNjoiMzk3ZTM4MjBiMjdhMjM=MzMwYzk1ZTA1MjUwZjYxY2VPMTM1IjtzOjQ1OiIvd3AtYWRtaW4vY3NzL2NvbG9ycy9lY3RvcGxhc2=vY29sb3JzLXJ=bC5jc3MiO3M6Mzg6IjA5M2RjY2UxNTg4YzNiOGNjNGI=MGZjMzExOTc=NDEyTzEzMTk=IjtzOjQ5OiIvd3AtYWRtaW4vY3NzL2NvbG9ycy9lY3RvcGxhc2=vY29sb3JzLXJ=bC5taW4uY3NzIjtzOjM4OiIxZTVhZTg5MGE=OWFmNGQwNjlhNGY3MzJkODViMWRlM=8xMTQ3MyI7czo=MToiL3dwLWFkbWluL2Nzcy9jb2xvcnMvZWN=b3BsYXNtL2NvbG9ycy5jc3MiO3M6Mzg6ImIyMWYzMjk1M2FkMTY3NDI=ZTk5OTdjOGZmNTMzMGFlTzEzMTk2IjtzOjQ1OiIvd3AtYWRtaW4vY3NzL2NvbG9ycy9lY3RvcGxhc2=vY29sb3JzLm1pbi5jc3MiO3M6Mzg6IjNjMTIxODYyYTBiYTViM2JkNDg5ZDQyOGNjOTI2NjI=TzExNDc1IjtzOjQyOiIvd3AtYWRtaW4vY3NzL2NvbG9ycy9lY3RvcGxhc2=vY29sb3JzLnNjc3MiO3M6MzY6Ijk=MDE3MWQxMzkyYmQ4MDcxMTIyYTkwNWQxMmI5MTk1TzE1NyI7czo=MToiL3dwLWFkbWluL2Nzcy9jb2xvcnMvbGlnaHQvY29sb3JzLXJ=bC5jc3MiO3M6Mzg6ImY2MGUwZWI=N2Y4MWJiYzYzM2ExOWIxOWU2Y2Y2ZjdiTzEzODI1IjtzOjQ1OiIvd3AtYWRtaW4vY3NzL2NvbG9ycy9saWdodC9jb2xvcnMtcnRsLm1pbi5jc3MiO3M6Mzg6ImQxMmM2MzIxYzI5MDVhNzIwODFlMDdkMWYzNjk2NTMyTzExODYzIjtzOjM3OiIvd3AtYWRtaW4vY3NzL2NvbG9ycy9saWdodC9jb2xvcnMuY3NzIjtzOjM4OiJiMGEyZTQxY2M4ZTRmYzFkMjBiNTE5MjNjYzE=MTJiNk8xMzgyNyI7czo=MToiL3dwLWFkbWluL2Nzcy9jb2xvcnMvbGlnaHQvY29sb3JzLm1pbi5jc3MiO3M6Mzg6IjRjMjk5ZmE=MjQxMTFmNWMwOGExOTY1MDExY2VjMjEwTzExODY1IjtzOjM4OiIvd3AtYWRtaW4vY3NzL2NvbG9ycy9saWdodC9jb2xvcnMuc2NzcyI7czozNzoiNDgwYjliZDY=N2U1YjMyM2VmODhkNjNjZTU1ZTFkNmZPMTExOSI7czo=NDoiL3dwLWFkbWluL2Nzcy9jb2xvcnMvbWlkbmlnaHQvY29sb3JzLXJ=bC5jc3MiO3M6Mzg6Ijk1Mjc5MTRkZWU2M2E4OWNmNzI=NzNmYjIzYmYwNjNmTzEzMTk=IjtzOjQ4OiIvd3AtYWRtaW4vY3NzL2NvbG9ycy9taWRuaWdodC9jb2xvcnMtcnRsLm1pbi5jc3MiO3M6Mzg6ImVjYjE2OGFjODgxYjE5NzQzODZkNjcyMjAxODU4OWRmTzExNDczIjtzOjQwOiIvd3AtYWRtaW4vY3NzL2NvbG9ycy9taWRuaWdodC9jb2xvcnMuY3NzIjtzOjM4OiIwNjU3NTA4YjE=YzA2MzU2NGYwMDAxODc4ZWE4OGQwN=8xMzE5NiI7czo=NDoiL3dwLWFkbWluL2Nzcy9jb2xvcnMvbWlkbmlnaHQvY29sb3JzLm1pbi5jc3MiO3M6Mzg6ImVjNjc4ZjE5ZTE2ODFhZTNjZmM2Y2MxNWQxYjBhMTI4TzExNDc1IjtzOjQxOiIvd3AtYWRtaW4vY3NzL2NvbG9ycy9taWRuaWdodC9jb2xvcnMuc2NzcyI7czozNjoiMjZkYzhkYWFmMGM=N2M=NDU3YjhiYzIxNDVmNDg2MzRPMTA2IjtzOjQxOiIvd3AtYWRtaW4vY3NzL2NvbG9ycy9vY2Vhbi9jb2xvcnMtcnRsLmNzcyI7czozODoiMGQ4NjhmZTc3YzU1YWE4MDg2ODE1NTQxYTVmZWJkZjVPMTMxOTQiO3M6NDU6Ii93cC1hZG1pbi9jc3MvY29sb3JzL29jZWFuL2NvbG9ycy1ydGwubWluLmNzcyI7czozODoiZTZjNmNjYmY5ZDMzMjQ5ODczMjRlZDI4MDJhNjk1ZGVPMTE=NzMiO3M6Mzc6Ii93cC1hZG1pbi9jc3MvY29sb3JzL29jZWFuL2NvbG9ycy5jc3MiO3M6Mzg6IjNhNTFhMzk1NDgzZDc3NzU3YzllMWQyMzY2NTE=MTdiTzEzMTk2IjtzOjQxOiIvd3AtYWRtaW4vY3NzL2NvbG9ycy9vY2Vhbi9jb2xvcnMubWluLmNzcyI7czozODoiNmRlZjYzMWRjZTEwODRjZDVlNDdlYzIzNjk5N2FjNzZPMTE=NzUiO3M6Mzg6Ii93cC1hZG1pbi9jc3MvY29sb3JzL29jZWFuL2NvbG9ycy5zY3NzIjtzOjM2OiIxYTdjNWJmZDlmYWY3ZjZjYzc3Y2Q5YjE2NjA2MjU2OE8xNTciO3M6NDM6Ii93cC1hZG1pbi9jc3MvY29sb3JzL3N1bnJpc2UvY29sb3JzLXJ=bC5jc3MiO3M6Mzg6ImQxZWU=NmM5NWMxZmVlNTgxNjY1MmVlMTIwYTcwZjZiTzEzMTk=IjtzOjQ3OiIvd3AtYWRtaW4vY3NzL2NvbG9ycy9zdW5yaXNlL2NvbG9ycy1ydGwubWluLmNzcyI7czozODoiYzI3MTgwNTIwMjdlOWQ2NGY2NWZkY2M2ODMzNjhhZjdPMTE=NzMiO3M6Mzk6Ii93cC1hZG1pbi9jc3MvY29sb3JzL3N1bnJpc2UvY29sb3JzLmNzcyI7czozODoiMzZkYTMxMDI5MDE=ZDVjYmEyZTFkNmIyYzNjOTQ5MDNPMTMxOTYiO3M6NDM6Ii93cC1hZG1pbi9jc3MvY29sb3JzL3N1bnJpc2UvY29sb3JzLm1pbi5jc3MiO3M6Mzg6ImUxNTk2MmI5ZDc1OGNhMmM1OTkxNjNmZjYwYzZkNTI4TzExNDc1IjtzOjQwOiIvd3AtYWRtaW4vY3NzL2NvbG9ycy9zdW5yaXNlL2NvbG9ycy5zY3NzIjtzOjM2OiI1NjkyODcxYThhN2ExOTE=ZWUwOTY4ZGRmOTkyM2RlY=8xNjYiO3M6MzI6Ii93cC1hZG1pbi9jc3MvY29sb3JzL19hZG1pbi5zY3NzIjtzOjM4OiJiZDIwOTRlOWRjMzIwOWU4Mzk=NzZlYmEwMGZmNTgzOE8xMTgyMyI7czozMzoiL3dwLWFkbWluL2Nzcy9jb2xvcnMvX21peGlucy5zY3NzIjtzOjM3OiIxZjVhNTJiMzFjZjVhYmE2MTNhYTg=NWYyZGI3YWM5Zk8xNDUyIjtzOjM2OiIvd3AtYWRtaW4vY3NzL2NvbG9ycy9fdmFyaWFibGVzLnNjc3MiO3M6Mzc6IjNhYjUwMTA5NmIxYTA5MTk3MmQ4NGM4NWIyODQxMzVhTzE4NTQiO3M6Mjg6Ii93cC1hZG1pbi9jc3MvY29tbW9uLXJ=bC5jc3MiO3M6Mzg6Ijg2Y2NmNTZiYmY3NDc4ZWYwNmIyYmYxMmU5M2JkYzNjTzY5NjA1IjtzOjMyOiIvd3AtYWRtaW4vY3NzL2NvbW1vbi1ydGwubWluLmNzcyI7czozODoiNTdkMWQyMzFkODRkMTZlMTA2OGY2YWY4MjE5YzE2YmJPNTMyMDMiO3M6MjQ6Ii93cC1hZG1pbi9jc3MvY29tbW9uLmNzcyI7czozODoiYjE5OTJiNmRlMzYwMGY4MmI4OTNhYTYxMjNmMjk3MmRPNjk1OTQiO3M6Mjg6Ii93cC1hZG1pbi9jc3MvY29tbW9uLm1pbi5jc3MiO3M6Mzg6IjE5NzgzYzBjOGM4MjI1YjNmYzMxZWEwNGU3N2VlNTBhTzUzMTkzIjtzOjQwOiIvd3AtYWRtaW4vY3NzL2N1c3RvbWl6ZS1jb25=cm9scy1ydGwuY3NzIjtzOjM4OiI5Y2EyZjk3Yjk3ZjMzZTA3MjgxNDc3Mjk=OGFkMDUxYU8=NTA5OSI7czo=NDoiL3dwLWFkbWluL2Nzcy9jdXN=b21pemUtY29udHJvbHMtcnRsLm1pbi5jc3MiO3M6Mzg6ImNkZjVmNGJiMDQ5ZjYzZDBjMTAyZWVmZTEwNjU5NWU1TzM3NTY1IjtzOjM2OiIvd3AtYWRtaW4vY3NzL2N1c3RvbWl6ZS1jb25=cm9scy5jc3MiO3M6Mzg6IjMxOGM=OWYxNGQ5ZjkyZjYyYmI=NTY=MWNiM2Y5ZWI1TzQ1MDcyIjtzOjQwOiIvd3AtYWRtaW4vY3NzL2N1c3RvbWl6ZS1jb25=cm9scy5taW4uY3NzIjtzOjM4OiIxZDg2MzJlOThkYWYwNzE4ZDFiMDk5OGI=MzJkNDhjY=8zNzUzOSI7czo=MToiL3dwLWFkbWluL2Nzcy9jdXN=b21pemUtbmF2LW1lbnVzLXJ=bC5jc3MiO3M6Mzg6ImJmMzNmZTFlNDZkMDhlMzYyZWEwOGE5Y2ZmOWM=MjhhTzIxODA1IjtzOjQ1OiIvd3AtYWRtaW4vY3NzL2N1c3RvbWl6ZS1uYXYtbWVudXMtcnRsLm1pbi5jc3MiO3M6Mzg6IjBhY2E1ZmM5NTdkN2Q2NWI3ZGM5MDg5NjdkZjhkMmMxTzE3NjgxIjtzOjM3OiIvd3AtYWRtaW4vY3NzL2N1c3RvbWl6ZS1uYXYtbWVudXMuY3NzIjtzOjM4OiIzYjFhNTRiMGVmMWU=ZmVlYmQ1NzdjMjY4ZjNiN2I1Nk8yMTc5MCI7czo=MToiL3dwLWFkbWluL2Nzcy9jdXN=b21pemUtbmF2LW1lbnVzLm1pbi5jc3MiO3M6Mzg6IjUwMzkyYTk1NGE5NTFlNDYxNzczNTViZTQ=YzIxOTE=TzE3NjY2IjtzOjM5OiIvd3AtYWRtaW4vY3NzL2N1c3RvbWl6ZS13aWRnZXRzLXJ=bC5jc3MiO3M6Mzg6IjdkZDJhNzlkMjg1ZTYwN2JlMWFjMzE1MzRmYThjNmYxTzExNjg4IjtzOjQzOiIvd3AtYWRtaW4vY3NzL2N1c3RvbWl6ZS13aWRnZXRzLXJ=bC5taW4uY3NzIjtzOjM3OiJiYzYwMzVlYmNjMjg2Mzk5YWU4MGM2MzkzMzU2MmZhYU85NTAyIjtzOjM1OiIvd3AtYWRtaW4vY3NzL2N1c3RvbWl6ZS13aWRnZXRzLmNzcyI7czozODoiNDlmMGFkNjNhOTBkNmNmMzE=NmFlZjVmNzA1MzYxYWRPMTE2ODUiO3M6Mzk6Ii93cC1hZG1pbi9jc3MvY3VzdG9taXplLXdpZGdldHMubWluLmNzcyI7czozNzoiYjhhYmY4NTMzYjllOGVkMzUxZTZmMzJiMmIyZTQ5YzhPOTQ5OSI7czozMToiL3dwLWFkbWluL2Nzcy9kYXNoYm9hcmQtcnRsLmNzcyI7czozODoiZDNjM2ZjYzlmODE=ZDU1ZDQwZjYxMWJmNTY4MGUwYjZPMjA1NDIiO3M6MzU6Ii93cC1hZG1pbi9jc3MvZGFzaGJvYXJkLXJ=bC5taW4uY3NzIjtzOjM4OiI4NWQ1NGJiMzQzYTMxYjYyMGExYWYyZDQyOWZjNTQzNk8xNjE2NyI7czoyNzoiL3dwLWFkbWluL2Nzcy9kYXNoYm9hcmQuY3NzIjtzOjM4OiJlZGU=MGE=YTJjMThiZWU4YjkzYzAxZjdlNTUyNDVhOE8yMDU=MyI7czozMToiL3dwLWFkbWluL2Nzcy9kYXNoYm9hcmQubWluLmNzcyI7czozODoiMTUxZGZlOThmZTgxY2YzMDNkZGQ1MTIyOGFjNmYzZDBPMTYxNjciO3M6Mzg6Ii93cC1hZG1pbi9jc3MvZGVwcmVjYXRlZC1tZWRpYS1ydGwuY3NzIjtzOjM3OiIwNzFkYjc4NDQ5ZTUyYjVhOGU=Zjc=ODgxZjQ1Y2E3Nk82NTA=IjtzOjQyOiIvd3AtYWRtaW4vY3NzL2RlcHJlY2F=ZWQtbWVkaWEtcnRsLm1pbi5jc3MiO3M6Mzc6ImFjNWJjMDJiNzEwZTM1MTE1Y2FkY2E5NjAzMDg1NjBjTzUzMjIiO3M6MzQ6Ii93cC1hZG1pbi9jc3MvZGVwcmVjYXRlZC1tZWRpYS5jc3MiO3M6Mzc6IjIyNTdmNTJhOTJkNzgxNzE5NWM3ZWE5NjU5MzQ1ZWMwTzY1MDQiO3M6Mzg6Ii93cC1hZG1pbi9jc3MvZGVwcmVjYXRlZC1tZWRpYS5taW4uY3NzIjtzOjM3OiJiMWNjODAzMGViOWE4MDZmMmZhM2E=YWVlY2RhYzg3Y=81MzIyIjtzOjI2OiIvd3AtYWRtaW4vY3NzL2VkaXQtcnRsLmNzcyI7czozODoiNmY=OGVmNmE=NTM5M2VmZGZkZmJlOGY4ZWQ2YTI1MDZPMjg1ODEiO3M6MzA6Ii93cC1hZG1pbi9jc3MvZWRpdC1ydGwubWluLmNzcyI7czozODoiYTcyYmQzMmYzZDIxYzNmY2RhMzg1YWYzZThiZmY1ZTNPMjI=NjciO3M6MjI6Ii93cC1hZG1pbi9jc3MvZWRpdC5jc3MiO3M6Mzg6IjA5MDJlZGIxYjMzZTYyZGYzYjg5ZTQyZWUwZmI5Mjg=TzI4NTc=IjtzOjI2OiIvd3AtYWRtaW4vY3NzL2VkaXQubWluLmNzcyI7czozODoiMzZiZWJhNDlkZGQ3MDM2NTcwNGU2OGI2NjQxY2FiNjNPMjI=NjAiO3M6MzI6Ii93cC1hZG1pbi9jc3MvZmFyYnRhc3RpYy1ydGwuY3NzIjtzOjM2OiIxMThmMTE4OWZmYmI3MWUwMTQ=MDIxMjFiNTQ1NmJjMk82MTIiO3M6MzY6Ii93cC1hZG1pbi9jc3MvZmFyYnRhc3RpYy1ydGwubWluLmNzcyI7czozNjoiMWE4ODRjMDk2MzdhNDdhZjMwMGM3ZTZjMzA1N2RkYzJPNTAzIjtzOjI4OiIvd3AtYWRtaW4vY3NzL2ZhcmJ=YXN=aWMuY3NzIjtzOjM2OiJmOWUzMzgyOWI4ZmFlZDdkN2JiZWY4NDNmYjY4MzI1NU82MTEiO3M6MzI6Ii93cC1hZG1pbi9jc3MvZmFyYnRhc3RpYy5taW4uY3NzIjtzOjM2OiIzMDk5Njk4MWMxMjliZDMzMWI1Y2RiYjg4YTJmYTIzYk81MDIiO3M6Mjc6Ii93cC1hZG1pbi9jc3MvZm9ybXMtcnRsLmNzcyI7czozODoiMTk1ZjU1ZjYzNDRhZjZhYjQ=ODNkZTQwZmNhZjZkNDZPMjU3MDIiO3M6MzE6Ii93cC1hZG1pbi9jc3MvZm9ybXMtcnRsLm1pbi5jc3MiO3M6Mzg6IjdlZTRjNGE1ODIwNDI=MDlkMTMyNDM1NDI3MWRkMzNhTzE5NTgwIjtzOjIzOiIvd3AtYWRtaW4vY3NzL2Zvcm1zLmNzcyI7czozODoiNzBmYTY=M2Q3MTM3MGNiYWFmZTk3NGFkOWNhMDQ1NjlPMjU2OTAiO3M6Mjc6Ii93cC1hZG1pbi9jc3MvZm9ybXMubWluLmNzcyI7czozODoiZWNiMWZjZjlmZDE1M2JlOTYxYTI5N2I5MWQ1ZGJmZTVPMTk1NzEiO3M6MjQ6Ii93cC1hZG1pbi9jc3MvaWUtcnRsLmNzcyI7czozODoiMTJlMzc5OWYwMDdkMTg3NmIxMjgzNWQwZTVlZjJmNTJPMTIwMDkiO3M6Mjg6Ii93cC1hZG1pbi9jc3MvaWUtcnRsLm1pbi5jc3MiO3M6Mzg6IjI5NjI4ZjI=MGNlYjM5NmVmMGI1NmRhMTljZjMwZjhjTzEwMTk1IjtzOjIwOiIvd3AtYWRtaW4vY3NzL2llLmNzcyI7czozODoiYTg2YmM5M2NiZGRiMWEyYjQ=ZmIzMGE=NmY2NmE4YWRPMTIwMDIiO3M6MjQ6Ii93cC1hZG1pbi9jc3MvaWUubWluLmNzcyI7czozODoiM2FkMTBlMTViNTM2ZDI=Njk4OGU=MTA3MzcyMTkyYWRPMTAxODkiO3M6Mjk6Ii93cC1hZG1pbi9jc3MvaW5zdGFsbC1ydGwuY3NzIjtzOjM3OiI5YzlmMjg2MzI4MzgxNDZlYTViMWY5ZGU5YWMyODljOE83Mzk=IjtzOjMzOiIvd3AtYWRtaW4vY3NzL2luc3RhbGwtcnRsLm1pbi5jc3MiO3M6Mzc6Ijk3ZTRkNWM2M2E=YmQzYTRmMDczYmJhNWRjYWI4Y2E2TzU5NjciO3M6MjU6Ii93cC1hZG1pbi9jc3MvaW5zdGFsbC5jc3MiO3M6Mzc6ImI1YWFjODQyODNhYTcxODNjMzBhMjU1MjdlZGQzMTUyTzczOTMiO3M6Mjk6Ii93cC1hZG1pbi9jc3MvaW5zdGFsbC5taW4uY3NzIjtzOjM3OiJlOTU4MDZlNzRkMDkzOTBhYmMzZGM3YjgwOTRjZGVlYU81OTY2IjtzOjI2OiIvd3AtYWRtaW4vY3NzL2wxMG4tcnRsLmNzcyI7czozNzoiNjliMDUyN2JlNWIzYWEyYzE2NDRmZTVmYzFjMzRhZmFPMzY5MiI7czozMDoiL3dwLWFkbWluL2Nzcy9sMTBuLXJ=bC5taW4uY3NzIjtzOjM3OiIzOTVlYmJiMDFmMDQ5OWRjNzkzMjNkOWU=NmJmOTljOU8yNDI2IjtzOjIyOiIvd3AtYWRtaW4vY3NzL2wxMG4uY3NzIjtzOjM3OiJiNWM=YjhmODUwMjlmYjdjODRmMDcxOWY3MmIyODBhZE8zNjg5IjtzOjI2OiIvd3AtYWRtaW4vY3NzL2wxMG4ubWluLmNzcyI7czozNzoiNTVkNmI1N2Q4MDIwZDk4MWRkMTJlMzMwOGM2ZDMyNmVPMjQyMyI7czozMzoiL3dwLWFkbWluL2Nzcy9saXN=LXRhYmxlcy1ydGwuY3NzIjtzOjM4OiI3NDZiMjNjZDk1NWEwYjcxMDdmNTdiODNiYjQyZWFhOE8=MDM5MCI7czozNzoiL3dwLWFkbWluL2Nzcy9saXN=LXRhYmxlcy1ydGwubWluLmNzcyI7czozODoiNzAzYTZhMjA4NTMxNDA3NDI1NjRjMTk3NzgzZDc1NzRPMzIzOTIiO3M6Mjk6Ii93cC1hZG1pbi9jc3MvbGlzdC1=YWJsZXMuY3NzIjtzOjM4OiI=MmQxNzE=OWM4YmZkZDdiZWJhYjBmNTMwOTFhNTQwYU8=MDM2MSI7czozMzoiL3dwLWFkbWluL2Nzcy9saXN=LXRhYmxlcy5taW4uY3NzIjtzOjM4OiIxOTc5YTAzZTczZGUyYmZlOGFhOTBhYWQ5ZmZkNjA3M=8zMjM2NiI7czoyNzoiL3dwLWFkbWluL2Nzcy9sb2dpbi1ydGwuY3NzIjtzOjM3OiI5NGZjNGIxYjNiNTA2ZmFlOTVlNjVjMDFlYzgwNjBhZE8=MTYwIjtzOjMxOiIvd3AtYWRtaW4vY3NzL2xvZ2luLXJ=bC5taW4uY3NzIjtzOjM4OiIyNzMwZTkzM2M3YTFhMzQyYTIxNmE4OGI1OTA5MDkyMk8yNTQyOCI7czoyMzoiL3dwLWFkbWluL2Nzcy9sb2dpbi5jc3MiO3M6Mzc6ImU5OGFhMWYxZDE=ZmQ=ZmQyYjgwZDQ1Njk=OGI2MjYyTzQxNDgiO3M6Mjc6Ii93cC1hZG1pbi9jc3MvbG9naW4ubWluLmNzcyI7czozODoiNTk4NmExNjgwNTM4YWM4ZTgzZDIxNzAyN2Q1NzU=M2ZPMjU=MTIiO3M6Mjc6Ii93cC1hZG1pbi9jc3MvbWVkaWEtcnRsLmNzcyI7czozODoiZDVmYmJjODAxNTViNTQxNGYyYTRkYTljODUyYmI5YzBPMjQxNTkiO3M6MzE6Ii93cC1hZG1pbi9jc3MvbWVkaWEtcnRsLm1pbi5jc3MiO3M6Mzg6ImRlMDgwOWYyYzk2NzVkMDlmZTRmNDhiNjE3YTdlNmExTzE5NTI=IjtzOjIzOiIvd3AtYWRtaW4vY3NzL21lZGlhLmNzcyI7czozODoiNDhiYWJjOTgxY2YwZjQzOWE3NjkyODZkNmE3MGZkNDhPMjQxNTciO3M6Mjc6Ii93cC1hZG1pbi9jc3MvbWVkaWEubWluLmNzcyI7czozODoiMzFiYjlkNzY3ZGM2NjA4ODNjYmU=ZjEzOWQ=YTE1OTRPMTk1MjMiO3M6MzE6Ii93cC1hZG1pbi9jc3MvbmF2LW1lbnVzLXJ=bC5jc3MiO3M6Mzg6IjYzYWY2NGJhODlmNzY4ZTQ=OGJhYjg3ZWUwY2I5NGRhTzE1ODYyIjtzOjM1OiIvd3AtYWRtaW4vY3NzL25hdi1tZW51cy1ydGwubWluLmNzcyI7czozODoiOTg1YjMzYzNhNDQ2OTFjMGU1OWIzYjQwZGQ1ZGY2MTFPMTI1MjEiO3M6Mjc6Ii93cC1hZG1pbi9jc3MvbmF2LW1lbnVzLmNzcyI7czozODoiNWZjNmFiOTQ1ZTI4YzNlYzEwMThkMjczNTlmYzZmZTBPMTU4MzUiO3M6MzE6Ii93cC1hZG1pbi9jc3MvbmF2LW1lbnVzLm1pbi5jc3MiO3M6Mzg6ImYyMzZmOTUzZDczMmZmZWE4MTg3NGYyMzIyNDZhNDI3TzEyNDk=IjtzOjM5OiIvd3AtYWRtaW4vY3NzL3ByZXNzLXRoaXMtZWRpdG9yLXJ=bC5jc3MiO3M6Mzc6IjQ2NGRhODQ4OTgwNDc2Y2QzN2RlMWMwZDc5NjRjMWU=TzEzNjgiO3M6NDM6Ii93cC1hZG1pbi9jc3MvcHJlc3MtdGhpcy1lZGl=b3ItcnRsLm1pbi5jc3MiO3M6MzY6IjE=M2RhNGU5NzlmZDg2ZTAwMmZiYTZjZGEzMzhjZjdjTzc4MyI7czozNToiL3dwLWFkbWluL2Nzcy9wcmVzcy1=aGlzLWVkaXRvci5jc3MiO3M6Mzc6ImIwMTk=MTQ2MzcyMWE5ZTNkMzZkNGI=ZGMzNzgxYzY2TzEzNjciO3M6Mzk6Ii93cC1hZG1pbi9jc3MvcHJlc3MtdGhpcy1lZGl=b3IubWluLmNzcyI7czozNjoiMmNmMzM=NGNiNzM3ZWM2MjI1MzI1OTZhYzIxY2I4NWZPNzgyIjtzOjMyOiIvd3AtYWRtaW4vY3NzL3ByZXNzLXRoaXMtcnRsLmNzcyI7czozODoiZGUwNWU5MmUzOWRkN2M1NDg4N2U5YWZmMDU5MjhhZTJPMzQ=NDEiO3M6MzY6Ii93cC1hZG1pbi9jc3MvcHJlc3MtdGhpcy1ydGwubWluLmNzcyI7czozODoiZDRjNDE1NWZmZjY2OTQ1ZWYzNjdmODFiOWYwMDdmMjNPMjcxOTEiO3M6Mjg6Ii93cC1hZG1pbi9jc3MvcHJlc3MtdGhpcy5jc3MiO3M6Mzg6IjY3MGQwN2IzNzlmNWJmYWQwOGUwNjI1ZWVjNDY5OWJjTzM=NDIzIjtzOjMyOiIvd3AtYWRtaW4vY3NzL3ByZXNzLXRoaXMubWluLmNzcyI7czozODoiMDFhZTk5NDZlN2E3YTA4YzMyZjEyNjFkMDMxYzAzMjBPMjcxNzMiO3M6MzE6Ii93cC1hZG1pbi9jc3MvcmV2aXNpb25zLXJ=bC5jc3MiO3M6Mzg6ImQyYmI5MWE1ZTE3NTE4MmZkOThiOTI=MjMyNDViODg2TzEwNTg2IjtzOjM1OiIvd3AtYWRtaW4vY3NzL3JldmlzaW9ucy1ydGwubWluLmNzcyI7czozNzoiMDExNGM3OWQ4OWQzZTBlZGQxNGQ3MTFjODY4ZDRmZDdPODY5OCI7czoyNzoiL3dwLWFkbWluL2Nzcy9yZXZpc2lvbnMuY3NzIjtzOjM4OiIyMzExODg3YTFlMTdiOTQyZGU2MTdiYTcwYmFlZGEzNk8xMDU3MSI7czozMToiL3dwLWFkbWluL2Nzcy9yZXZpc2lvbnMubWluLmNzcyI7czozNzoiN2RiNTMwNGVjMjA2NzdjNDZiYmNiZDdiOWU5ZmEzNTBPODY4MyI7czozMToiL3dwLWFkbWluL2Nzcy9zaXRlLWljb24tcnRsLmNzcyI7czozNzoiMDZmYTIwNjI5MDBlYzliOTU2MTQwMzYyNTA1MGM5MzlPMTA1MyI7czozNToiL3dwLWFkbWluL2Nzcy9zaXRlLWljb24tcnRsLm1pbi5jc3MiO3M6MzY6IjUyMTg5ZThmMTg2MjAwMWI3YmQxZjVmMGVkNzFkMzBhTzczOCI7czoyNzoiL3dwLWFkbWluL2Nzcy9zaXRlLWljb24uY3NzIjtzOjM3OiIwMmYzN2M5NTU1MmRjN2NkYTVlMmNhM2M=ZWY2YWMyME8xMDUxIjtzOjMxOiIvd3AtYWRtaW4vY3NzL3NpdGUtaWNvbi5taW4uY3NzIjtzOjM2OiI2NmE1MzM2Mjg=ZGI2ZGM5ODc=NzY=ZmE4NTQ4YTQ3MU83MzYiO3M6Mjg6Ii93cC1hZG1pbi9jc3MvdGhlbWVzLXJ=bC5jc3MiO3M6Mzg6ImI4NDVlMjgwNDQ4N2EyYzVhNGI2NDkzOGE2YzQzMWUxTzQxNTg4IjtzOjMyOiIvd3AtYWRtaW4vY3NzL3RoZW1lcy1ydGwubWluLmNzcyI7czozODoiNDZjN2VlZjk3MDQ=NTg4NDMyNGMwMzVmNzM5Y2E2M2FPMzI4MjkiO3M6MjQ6Ii93cC1hZG1pbi9jc3MvdGhlbWVzLmNzcyI7czozODoiYzFhYmI3YzEyZDRlNTQwNjFlMDExY2EyNWM1MjRlZDhPNDE1NzEiO3M6Mjg6Ii93cC1hZG1pbi9jc3MvdGhlbWVzLm1pbi5jc3MiO3M6Mzg6IjY4ZWIwMmM2ZGMwNDM2NDYxODZiNTlhMzYwNTU5ZjBmTzMyODE3IjtzOjI5OiIvd3AtYWRtaW4vY3NzL3dpZGdldHMtcnRsLmNzcyI7czozODoiNTIyMjIyODIzMjlmMWUyYmE4N2Q5ZGY1NTZiOWRhNTFPMTA5MzEiO3M6MzM6Ii93cC1hZG1pbi9jc3Mvd2lkZ2V=cy1ydGwubWluLmNzcyI7czozNzoiNTZkY2M4Mzg4YTY3ZWVhNWEzNDJkYzAwNDkxODY3ZTRPODcwMCI7czoyNToiL3dwLWFkbWluL2Nzcy93aWRnZXRzLmNzcyI7czozODoiNTNiZmEwMDRiOGVjNWVkMDczNDhiOWZmM2U3OWFmNTVPMTA5MzMiO3M6Mjk6Ii93cC1hZG1pbi9jc3Mvd2lkZ2V=cy5taW4uY3NzIjtzOjM3OiJmZWViMTBiYWViMjliMDkxZjVkOWNkNmJlY2NjMGMxNk84NzAwIjtzOjMwOiIvd3AtYWRtaW4vY3NzL3dwLWFkbWluLXJ=bC5jc3MiO3M6MzY6Ijc=ZjlkY2Y1YWI4YzkyZjY2NjZmZjUyYzY5OTg3M2M4TzQyMSI7czozNDoiL3dwLWFkbWluL2Nzcy93cC1hZG1pbi1ydGwubWluLmNzcyI7czozNjoiMDZkZDlhYWVhMjJhZDhjMTM3MjI=NzAxOTZjNWFhYjRPNDc3IjtzOjI2OiIvd3AtYWRtaW4vY3NzL3dwLWFkbWluLmNzcyI7czozNjoiYmZlNGJkOTAzNTAwMThhYmM3YzkyMTBiZmI5ZDJhNWJPMzY1IjtzOjMwOiIvd3AtYWRtaW4vY3NzL3dwLWFkbWluLm1pbi5jc3MiO3M6MzY6ImEyZTJmNjc2MjZlZDZmOWJlY2E1MzA2YzFhMTZhYmJhTzQyMSI7czozMToiL3dwLWFkbWluL2N1c3RvbS1iYWNrZ3JvdW5kLnBocCI7czozODoiMjM4OTU5MWUzNzk3YTdlODAxNjBiZWFmZGMxYWEwNGVPMTk5NzMiO3M6Mjc6Ii93cC1hZG1pbi9jdXN=b2=taGVhZGVyLnBocCI7czozODoiMTM3ZmU5YzE=MzBhOThlMzYxZmM=NmQ3ZTYwNmYwOWVPNDQ4MzAiO3M6MjM6Ii93cC1hZG1pbi9jdXN=b21pemUucGhwIjtzOjM3OiI1MzI=Y2ZhM2FmOTA3NWE2MjAyYzkyY2QzZDM=NDRjOU83MzkxIjtzOjI3OiIvd3AtYWRtaW4vZWRpdC1jb21tZW5=cy5waHAiO3M6Mzg6ImNkMWJmODhjM2E=NTNlYzRkZGI4NTA1MjI5YWE1NGYxTzEzNzczIjtzOjMyOiIvd3AtYWRtaW4vZWRpdC1mb3JtLWFkdmFuY2VkLnBocCI7czozODoiOTJlNWYxNDVkMGE1YjM2N2UxMWJhNDA=NmI2MzgwNDBPMzI1MDIiO3M6MzE6Ii93cC1hZG1pbi9lZGl=LWZvcm=tY29tbWVudC5waHAiO3M6Mzc6IjMxYWQwMWIyYmE2NWE=YTJlNjMxZTQyMmIyNTgxNTgwTzczMjUiO3M6Mjg6Ii93cC1hZG1pbi9lZGl=LWxpbmstZm9ybS5waHAiO3M6Mzc6IjkwNjk5MDViMDUxNWI=MTYzYzM1MTVlOTg1ZjAyZWE=TzU5ODAiO3M6Mjc6Ii93cC1hZG1pbi9lZGl=LXRhZy1mb3JtLnBocCI7czozNzoiZWI2NGRkZTQ=NzNhMTMxNDI=ZGEzOGFkNTk2NThmMDhPODY4MCI7czoyMzoiL3dwLWFkbWluL2VkaXQtdGFncy5waHAiO3M6Mzg6IjgyZWIzOWUwNjJjZjQzY2Y1YzllNWYzZGZlN2NiY2Y=TzE5OTkxIjtzOjE4OiIvd3AtYWRtaW4vZWRpdC5waHAiO3M6Mzg6IjU1MzczNDQ5Y2MyMzIwYzU3ODAzZjFmNWI1MmI5Y2U5TzE1Njc3IjtzOjIwOiIvd3AtYWRtaW4vZXhwb3J=LnBocCI7czozODoiOWZlZmMyZGZhZmFjY2Y=NjQ=ZGEwMDRiYzVkYjBjZmVPMTA3MDkiO3M6MjI6Ii93cC1hZG1pbi9mcmVlZG9tcy5waHAiO3M6Mzc6IjhiYzNiNTczY2ZiYWRjMzY3MTQ4ZmM=NDM5YWJkNzIzTzM=MDgiO3M6MzY6Ii93cC1hZG1pbi9pbWFnZXMvYWxpZ24tY2VudGVyLTJ4LnBuZyI7czozNjoiOWViZWIyMmRmMzcyODczNTA=MmE=YTM3YTE=OTY2MTFPMTQ3IjtzOjMzOiIvd3AtYWRtaW4vaW1hZ2VzL2FsaWduLWNlbnRlci5wbmciO3M6MzY6IjA5ZDkxYWRkYjZiNTM=NzllNjhjNjQ1OTMxZDk2NThlTzU=NiI7czozNDoiL3dwLWFkbWluL2ltYWdlcy9hbGlnbi1sZWZ=LTJ4LnBuZyI7czozNjoiNjk4NTM4YjE=ZmI5ODM5YWVjZDAxZDVlOTdjNjYzMTZPMTQzIjtzOjMxOiIvd3AtYWRtaW4vaW1hZ2VzL2FsaWduLWxlZnQucG5nIjtzOjM2OiI1Y2ZkNzkzMGNmZmE2NDEyZjc1YWYyNmYyZTY4OWVkNE81NTQiO3M6MzQ6Ii93cC1hZG1pbi9pbWFnZXMvYWxpZ24tbm9uZS=yeC5wbmciO3M6MzY6ImY4NTg=Mzk5MDUyOTViZDcwNWIwOWIyZGJhMzQxOGJkTzEyMSI7czozMToiL3dwLWFkbWluL2ltYWdlcy9hbGlnbi1ub25lLnBuZyI7czozNjoiZjFhZDY1NzE2NDMyYTBhMWRhNzU5MWE1YzJmMTBkMDRPNDE3IjtzOjM1OiIvd3AtYWRtaW4vaW1hZ2VzL2FsaWduLXJpZ2h=LTJ4LnBuZyI7czozNjoiNjg4MzAyNmNiZDNlNzJiYTVkYTM2YzU3YzYwZmMwNzhPMTQyIjtzOjMyOiIvd3AtYWRtaW4vaW1hZ2VzL2FsaWduLXJpZ2h=LnBuZyI7czozNjoiNDJkOGYzZTI4NzRmNjUyM2QzNmM=MDNhNTAyYjIyNzZPNTA5IjtzOjMwOiIvd3AtYWRtaW4vaW1hZ2VzL2Fycm93cy=yeC5wbmciO3M6MzY6Ijk3MjA1MWYwODYwMTdkY2VmMTc5NjQ2MjIzMzY4NDBiTzg2MyI7czoyNzoiL3dwLWFkbWluL2ltYWdlcy9hcnJvd3MucG5nIjtzOjM2OiI3ZmRhNzY5MjAxMjRmMDNlODhkMWRmZDkzZTAzYmY1OU8yNDMiO3M6MzI6Ii93cC1hZG1pbi9pbWFnZXMvYnJvd3Nlci1ydGwucG5nIjtzOjM4OiI=NDIyOTFkOWQzYTA=MWU=MWFhZWZlYmZiZjI1Y2M5ZE8=MDE3MCI7czoyODoiL3dwLWFkbWluL2ltYWdlcy9icm93c2VyLnBuZyI7czozODoiYzFiMmY5YzI5ZWI1NGIxZjVjMDI4NDYyOTUyNGZlNDZPNDA2MjYiO3M6MzM6Ii93cC1hZG1pbi9pbWFnZXMvYnViYmxlX2JnLTJ4LmdpZiI7czozNjoiMTY1MjNkNWJmOWVmZDhjYTNiOTJlNzYzMWVkZmM1MTNPNTA3IjtzOjMwOiIvd3AtYWRtaW4vaW1hZ2VzL2J1YmJsZV9iZy5naWYiO3M6MzY6IjNkMmNiM2Y3YmFhNjI4YzllNTFhMzI2MzU2ZTcyMDM4TzM5OCI7czo=MzoiL3dwLWFkbWluL2ltYWdlcy9jb21tZW5=LWdyZXktYnViYmxlLTJ4LnBuZyI7czozNjoiOWQ1NDU5ZDNjNTlkMzJiNjAyNzMyYzBkZjU2ZDgzYmZPMjU4IjtzOjQwOiIvd3AtYWRtaW4vaW1hZ2VzL2NvbW1lbnQtZ3JleS1idWJibGUucG5nIjtzOjM2OiI4ZjU5MTI4ZjJhMjdiNDg5YjBhOTc=YzBiNmIyMTA=Nk8xMTQiO3M6MzU6Ii93cC1hZG1pbi9pbWFnZXMvZGF=ZS1idXR=b24tMnguZ2lmIjtzOjM2OiIyOTUyOTMyYzI=NmJmOTgyODQyOTM2MTY=M2E4YmI2M=85OTYiO3M6MzI6Ii93cC1hZG1pbi9pbWFnZXMvZGF=ZS1idXR=b24uZ2lmIjtzOjM2OiI5NzlkOGUyZTA4YWFkYTQ5ODE5NTU2OTUwZWM=OGZmNk8=MDAiO3M6Mjg6Ii93cC1hZG1pbi9pbWFnZXMvZ2VuZXJpYy5wbmciO3M6MzY6ImY4OGUxYjk1ZmYyNzhhNWIyMzFmMzkzODBiMjExZWQwTzcxOSI7czozMToiL3dwLWFkbWluL2ltYWdlcy9pY29uczMyLTJ4LnBuZyI7czozODoiYjUyNWE=MmFmOTA4ZmFmY2Y4Y2MwNzY3OWFiNGZhYmJPMjE3NzAiO3M6MzQ6Ii93cC1hZG1pbi9pbWFnZXMvaWNvbnMzMi12cy=yeC5wbmciO3M6Mzg6ImExMmEzMDM=ZmY=NzM=NDY5NzA5MjY1YTgzNjk3ZDIyTzIxMzk2IjtzOjMxOiIvd3AtYWRtaW4vaW1hZ2VzL2ljb25zMzItdnMucG5nIjtzOjM3OiIwNTJjZDY1MDJhMDVlN2QzZjE3YjNlNzZhNWIxNTU2Nk84MDA3IjtzOjI4OiIvd3AtYWRtaW4vaW1hZ2VzL2ljb25zMzIucG5nIjtzOjM3OiJkMWRiYWM1YmU3NmQzOTg1MWNlNzRhYTEzNGNjMWFlYU84MDIzIjtzOjM3OiIvd3AtYWRtaW4vaW1hZ2VzL2ltZ2VkaXQtaWNvbnMtMngucG5nIjtzOjM3OiIyY2UzZWUyNzgzYTMzNjU1YTZiZGZkOWRjM2NjZTE3NE83NjY=IjtzOjM=OiIvd3AtYWRtaW4vaW1hZ2VzL2ltZ2VkaXQtaWNvbnMucG5nIjtzOjM3OiI=YmQ1NWMzMjBiOWZkOWQ4MTI3ZGE5NDc4OTY5M2I=Zk8=MDU1IjtzOjI4OiIvd3AtYWRtaW4vaW1hZ2VzL2xpc3QtMngucG5nIjtzOjM3OiI2OGQ1YmIxMzQ5NTNjMjMyMTdmZGQzNjk4MjY3OWEwY=8xNTIzIjtzOjI1OiIvd3AtYWRtaW4vaW1hZ2VzL2xpc3QucG5nIjtzOjM3OiIxZTEyM2U5NmJkMmExY2UyYzBkM2IzMDVkMTUzZjFjM=8xMDAzIjtzOjI4OiIvd3AtYWRtaW4vaW1hZ2VzL2xvYWRpbmcuZ2lmIjtzOjM3OiIyZDViOTJiNjE2NzRjODUwYmZmMDBjZWNhZjA4NjRlY=8yMjU=IjtzOjI3OiIvd3AtYWRtaW4vaW1hZ2VzL21hcmtlci5wbmciO3M6MzY6IjMzMTNkYzJhNGYzMjJmZDQzMzQ5MzI5Y2ZkZTgxOTFlTzM2MCI7czoyNToiL3dwLWFkbWluL2ltYWdlcy9tYXNrLnBuZyI7czozNzoiZmNmNjkzNjc3ZWE4MjJlNmQyNGFmN2IyZTRhOThlOTlPMjAwMSI7czozNjoiL3dwLWFkbWluL2ltYWdlcy9tZWRpYS1idXR=b24tMngucG5nIjtzOjM2OiIyM2RiNTc=OWU1MWQ4NTEwNWNiOGQwM2ZjODEzMDVjOU84NTAiO3M6Mzk6Ii93cC1hZG1pbi9pbWFnZXMvbWVkaWEtYnV=dG9uLWltYWdlLmdpZiI7czozNjoiN2VhMmM5YzE1N2MzOGVkYjQwYjFjZTYyZDU3MmQ1YjNPMjAwIjtzOjM5OiIvd3AtYWRtaW4vaW1hZ2VzL21lZGlhLWJ1dHRvbi1tdXNpYy5naWYiO3M6MzY6ImVmZjU1ZGYzN2YzMjVjNWFhZTJmMDJlNGQ5MTNkZTk1TzIwNiI7czozOToiL3dwLWFkbWluL2ltYWdlcy9tZWRpYS1idXR=b24tb3RoZXIuZ2lmIjtzOjM2OiI4YmM2YjQ2YmM3MGM3YzE5MThkY2U2MmM=ZmUzMjI5Y=8yNDgiO3M6Mzk6Ii93cC1hZG1pbi9pbWFnZXMvbWVkaWEtYnV=dG9uLXZpZGVvLmdpZiI7czozNjoiYWJhYWMzZGZkODFmYmY3MmU1NzhmMTM=NTFlYWU3ZDBPMTMzIjtzOjMzOiIvd3AtYWRtaW4vaW1hZ2VzL21lZGlhLWJ1dHRvbi5wbmciO3M6MzY6ImIyYjZjM2UzMzYwNTQwNzBlODkyN2E1ZTc5NjVmM2NlTzMyMyI7czoyODoiL3dwLWFkbWluL2ltYWdlcy9tZW51LTJ4LnBuZyI7czozODoiNmE=N2ZmZjVmZWUyZjk3YmJmM2VhZjVlM2IyNDgyZDNPMTI2NzIiO3M6MzE6Ii93cC1hZG1pbi9pbWFnZXMvbWVudS12cy=yeC5wbmciO3M6Mzg6IjRhYTg1YTBjNTkzY2Y3NjljNzE4NTkxMWFlODQ2MmY4TzEyNDUzIjtzOjI4OiIvd3AtYWRtaW4vaW1hZ2VzL21lbnUtdnMucG5nIjtzOjM3OiI3MTk5ODBmMjRjZjAyYzBjNWZhNTNiMzEyZmVmNDVhY=81MDg2IjtzOjI1OiIvd3AtYWRtaW4vaW1hZ2VzL21lbnUucG5nIjtzOjM3OiJlMTBkODEzOTIzMGYxZjhiNjRmMzU5NjAwOThmOGNmZk81MDM5IjtzOjIzOiIvd3AtYWRtaW4vaW1hZ2VzL25vLnBuZyI7czozNjoiYzg2YmJmMWM2NGM5MjRmOTlmZGM5ZjU2MzdmMGMwOGJPNzU1IjtzOjM2OiIvd3AtYWRtaW4vaW1hZ2VzL3Bvc3QtZm9ybWF=cy12cy5wbmciO3M6Mzc6ImE2OGY1M2E2NmM5M2Y=NDg1Y2E5YWNhZmFmZmM4MWU2TzI=NTAiO3M6MzM6Ii93cC1hZG1pbi9pbWFnZXMvcG9zdC1mb3JtYXRzLnBuZyI7czozNzoiZGM=YmZmZTFkMTAwOTNlNGQ5MjUzM2E4ZDYwY2JhMDdPMjE1NyI7czozODoiL3dwLWFkbWluL2ltYWdlcy9wb3N=LWZvcm1hdHMzMi12cy5wbmciO3M6Mzc6ImI3NzQyZTQ1YjZhZGVhMzU=N2E1NGUxYWYzZmU3NjFjTzUxMTEiO3M6MzU6Ii93cC1hZG1pbi9pbWFnZXMvcG9zdC1mb3JtYXRzMzIucG5nIjtzOjM3OiI1NzU5N2U4ZjRmOTJmODdiZjAyYjVmNGM4OTZiNDUzYk81MTQyIjtzOjMwOiIvd3AtYWRtaW4vaW1hZ2VzL3Jlc2l6ZS=yeC5naWYiO3M6MzY6ImY1ZTExODY1M2Y4OTI2MDY2ODJlZTljNTFkMGFiYTk5TzIzNCI7czozNDoiL3dwLWFkbWluL2ltYWdlcy9yZXNpemUtcnRsLTJ4LmdpZiI7czozNjoiZjdjOTllZTc=MDE=ZmU5MjU=MTAxMjMwM2FhYWRjN2RPMjMzIjtzOjMxOiIvd3AtYWRtaW4vaW1hZ2VzL3Jlc2l6ZS1ydGwuZ2lmIjtzOjM2OiJkYjkyMTcxOTYzMTNjOTVhNTlkNDM2MDFkYTE5YzUxZE8xNDkiO3M6Mjc6Ii93cC1hZG1pbi9pbWFnZXMvcmVzaXplLmdpZiI7czozNToiM2ZiYTE1NDRkZjI=ZjQwZGRlNTg3NmM4YzBhZWM=NjFPNzAiO3M6MjM6Ii93cC1hZG1pbi9pbWFnZXMvc2UucG5nIjtzOjM2OiJkNmM4OTQ=MmMzNjBiZDFlMDhkYTJlN2QxNTI3MzczYU8xMjAiO3M6Mjg6Ii93cC1hZG1pbi9pbWFnZXMvc29ydC=yeC5naWYiO3M6MzU6IjE4NmU1MTI2N2ZjYTVkMjBiMjMwYzcyZDlhODk4M2VlTzk3IjtzOjI1OiIvd3AtYWRtaW4vaW1hZ2VzL3NvcnQuZ2lmIjtzOjM1OiIyZThhY2I4ZGVlOTliZmJjYjYxYmQ=NmM=ODZhOTk1ZE81NSI7czozMToiL3dwLWFkbWluL2ltYWdlcy9zcGlubmVyLTJ4LmdpZiI7czozNzoiNWMxMzcxYmNiNDM5Mjk2ODY=Nzg1MmE5YzlkZjVkNmNPODUzNiI7czoyODoiL3dwLWFkbWluL2ltYWdlcy9zcGlubmVyLmdpZiI7czozNzoiYjBhM2RkZTMzMTYzN2UyN2FhNjQ3NmQ=NzY=ODE4NzFPNDE2MiI7czoyOToiL3dwLWFkbWluL2ltYWdlcy9zdGFycy=yeC5wbmciO3M6Mzc6ImY1ZWE=MTk=YTc5YzIzZTY1M2IyNGQwYzY1MDMyZTVlTzEyNTciO3M6MjY6Ii93cC1hZG1pbi9pbWFnZXMvc3RhcnMucG5nIjtzOjM2OiI1YmFjZTAxZjk5OTAzZTNjZjU2YmIyN2JkMmVjMjg5MU85MjQiO3M6MzI6Ii93cC1hZG1pbi9pbWFnZXMvdy1sb2dvLWJsdWUucG5nIjtzOjM3OiJmZDViNGViMDU3MDZhMmYwNWY3MDdmZTA3N2FlMTAzME8zMTEzIjtzOjMzOiIvd3AtYWRtaW4vaW1hZ2VzL3ctbG9nby13aGl=ZS5wbmciO3M6Mzc6IjZlYTZjY2VlNGEwMTc2ZGJhMjdlYmI3OWFjMTc1Yzg1TzUzOTUiO3M6MjY6Ii93cC1hZG1pbi9pbWFnZXMvd2hlZWwucG5nIjtzOjM3OiI=NTMwYmQyMDcxMzA2ZGJiYzYxYTU5MjU1NmI5NThhME82MDQ3IjtzOjQxOiIvd3AtYWRtaW4vaW1hZ2VzL3dvcmRwcmVzcy1sb2dvLXdoaXRlLnN2ZyI7czozNzoiMTliZGQ5NzE1MGZiNDNhYTg2MmQ1MzUwMGM=NGU2ZjdPMTYzOSI7czozNToiL3dwLWFkbWluL2ltYWdlcy93b3JkcHJlc3MtbG9nby5wbmciO3M6Mzc6ImM2YjBmOTc5YjllNjZmYzMzOGY=Y2IzODUzYTU2MDhhTzI=ODAiO3M6MzU6Ii93cC1hZG1pbi9pbWFnZXMvd29yZHByZXNzLWxvZ28uc3ZnIjtzOjM3OiJmMzRlZjYyNTkzNjRmN2VmMGNjZjY3Y2QxZGRkYzk3ME8xNTIxIjtzOjM2OiIvd3AtYWRtaW4vaW1hZ2VzL3dwc3Bpbl9saWdodC=yeC5naWYiO3M6Mzc6IjdkZWYzM2FhZDk1OWNkMjg5ZDQ5ZGRmMmE=MWYwNzZkTzkxMzMiO3M6MzM6Ii93cC1hZG1pbi9pbWFnZXMvd3BzcGluX2xpZ2h=LmdpZiI7czozNzoiZGQ=ZTZkZDI2OGE3MGNlNGMxYzUxNDNiMWE=MDkyZGRPMjIwOSI7czoyNzoiL3dwLWFkbWluL2ltYWdlcy94aXQtMnguZ2lmIjtzOjM2OiI4ZmIwNzI5YzU=MWNiZGM=NjA5ZmFmM2Y=YWQwMmZjN=84MjUiO3M6MjQ6Ii93cC1hZG1pbi9pbWFnZXMveGl=LmdpZiI7czozNjoiZTUwMTI5MDJhMzU4ZmJiOTYwMzFhY2RjZjA=OGQ3Y2FPMTgxIjtzOjI=OiIvd3AtYWRtaW4vaW1hZ2VzL3llcy5wbmciO3M6MzY6ImM=MmJmODE=YTIzN2RjODk5NzBkNzE1YWU4NTE2YjEzTzUzOSI7czoyMDoiL3dwLWFkbWluL2ltcG9ydC5waHAiO3M6Mzc6ImYzZWUxZWYxNWE5YTYyMDIxNzA1OWE4NTNkNzI4ZDdlTzcxOTQiO3M6MzY6Ii93cC1hZG1pbi9pbmNsdWRlcy9hZG1pbi1maWx=ZXJzLnBocCI7czozNzoiYmZlOWJiMGQ4ZDZkN2NiNzE3Y2YzZTdiODI5ZmE1NzJPNTE5MCI7czoyODoiL3dwLWFkbWluL2luY2x1ZGVzL2FkbWluLnBocCI7czozNzoiNWM3YjBjOGM3YWNkNjk1MDhkOGYxOWMzYzYxYTcxYzBPMjk=OCI7czozNToiL3dwLWFkbWluL2luY2x1ZGVzL2FqYXgtYWN=aW9ucy5waHAiO3M6Mzk6ImY5ZjkxZjhlNzI=ZTk2ZGUwNjBiM2IwNmJmMDEwNTIwTzExMTE4MSI7czozMToiL3dwLWFkbWluL2luY2x1ZGVzL2Jvb2ttYXJrLnBocCI7czozNzoiMTI1ZTU5MTRkZDExZTQwZGM1NWMyZTFkY2VlOGVmZjdPOTA3OCI7czo1MjoiL3dwLWFkbWluL2luY2x1ZGVzL2NsYXNzLWF1dG9tYXRpYy11cGdyYWRlci1za2luLnBocCI7czozNzoiZjNkMTllZTRjODU3MjZiMGYyNGNkZDFmMzZjNDE=ZjlPMzE1MyI7czo1NDoiL3dwLWFkbWluL2luY2x1ZGVzL2NsYXNzLWJ1bGstcGx1Z2luLXVwZ3JhZGVyLXNraW4ucGhwIjtzOjM3OiJhM2RlNWZjOTcxNzA3YjhkOTU1YjU3MjQxZTI2MzY1MU8xOTE1IjtzOjUzOiIvd3AtYWRtaW4vaW5jbHVkZXMvY2xhc3MtYnVsay1=aGVtZS11cGdyYWRlci1za2luLnBocCI7czozNzoiMWViMTQxNGM2MzJlMGJiYmI2NDdiYTQwYTQ2ZGMxMWFPMTk1OSI7czo=NzoiL3dwLWFkbWluL2luY2x1ZGVzL2NsYXNzLWJ1bGstdXBncmFkZXItc2tpbi5waHAiO3M6Mzc6IjJhNmY2MzdjODgwYWJjM2RiOGIzM2Y1N2JmNWQ1OTQ3TzUyNDQiO3M6NDI6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy1jb3JlLXVwZ3JhZGVyLnBocCI7czozODoiMzIyMzhmOWIxOTIzMmJmYjRiYjRiYmQ5Zjg1NGRhOWVPMTM=MDAiO3M6NDk6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy1maWxlLXVwbG9hZC11cGdyYWRlci5waHAiO3M6Mzc6IjhmMTYxY2Q1MzliNjBlZmQ2Yzg3ZGM3MTZhN2M3N2Q4TzMzNDciO3M6Mzc6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy1mdHAtcHVyZS5waHAiO3M6Mzc6IjQyZTQ2MjE3NDViZGUwNDUxMjgwM2U4NzAyZGIxMTUyTzUzOTkiO3M6NDA6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy1mdHAtc29ja2V=cy5waHAiO3M6Mzc6IjA3NmNhODM5ZTg1NTJiNDVhM2VlZjU1OGFhMmIxOTk2Tzg=NDgiO3M6MzI6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy1mdHAucGhwIjtzOjM4OiJjOWJlZDEyNjVmOWVmYWUzNzM2NDk5NzI2YTdhMWIyZU8yNzA5NyI7czo1NjoiL3dwLWFkbWluL2luY2x1ZGVzL2NsYXNzLWxhbmd1YWdlLXBhY2stdXBncmFkZXItc2tpbi5waHAiO3M6Mzc6ImUzZTkyZjI=NmZhYjAxMDY5MTc=MDZhOGIxYjczMzk1TzIyNDEiO3M6NTE6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy1sYW5ndWFnZS1wYWNrLXVwZ3JhZGVyLnBocCI7czozODoiMjhmZjhkZGIzYzQ4ZDEwNmM3YmMwNWNhNWViYzhiZTVPMTExNTMiO3M6MzU6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy1wY2x6aXAucGhwIjtzOjM5OiI1OWM3MDFkMDk4OTZjZjg1OTY4OWRjZjQ1NzU5NzA4NE8xOTU3OTUiO3M6NTA6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy1wbHVnaW4taW5zdGFsbGVyLXNraW4ucGhwIjtzOjM3OiJkODBlZDc1MzM3ZGI5NGQyMjA=N2MyOGNjMTkyMDNkNk8zOTY4IjtzOjQ5OiIvd3AtYWRtaW4vaW5jbHVkZXMvY2xhc3MtcGx1Z2luLXVwZ3JhZGVyLXNraW4ucGhwIjtzOjM3OiI1ZGY5OGY5NDI3ZTNjNTRkZDg2NTBiZDIyNzUxZTUxZU8yNTYxIjtzOjQ=OiIvd3AtYWRtaW4vaW5jbHVkZXMvY2xhc3MtcGx1Z2luLXVwZ3JhZGVyLnBocCI7czozODoiZDZjOGZhYjA2MzAzZjk4NTcwOGE4YTI3MDc4MWEwMjRPMTQ3NTIiO3M6NDk6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy1=aGVtZS1pbnN=YWxsZXItc2tpbi5waHAiO3M6Mzc6IjQ5NjRlYmRkZTdjYTBjNjE1MTc2OGZjZGU2ZjM4OTUzTzM4ODgiO3M6NDg6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy1=aGVtZS11cGdyYWRlci1za2luLnBocCI7czozNzoiZjNmNmNkN2M3MGZjMGUxMGUzMGI4ODVlNjA=YzVjODBPMzI2NCI7czo=MzoiL3dwLWFkbWluL2luY2x1ZGVzL2NsYXNzLXRoZW1lLXVwZ3JhZGVyLnBocCI7czozODoiMTZmNDQ=Y2RlMzA5YmMyN2UxMzg3YmJmNzc1ZjczNjFPMTk1NjkiO3M6NTQ6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy13YWxrZXItY2F=ZWdvcnktY2hlY2tsaXN=LnBocCI7czozNzoiYzU=YTVmZmE5MzY1YjQ3MWYzODRhODVmMzUwZjFmMWJPNDE5NCI7czo1NDoiL3dwLWFkbWluL2luY2x1ZGVzL2NsYXNzLXdhbGtlci1uYXYtbWVudS1jaGVja2xpc3QucGhwIjtzOjM3OiJiYzE4YWIxOWQ1ZjUwZTkzYjQ3ZmYwY2IwZWM=NmViZk8=OTI2IjtzOjQ5OiIvd3AtYWRtaW4vaW5jbHVkZXMvY2xhc3Mtd2Fsa2VyLW5hdi1tZW51LWVkaXQucGhwIjtzOjM4OiI4NjIxODcwOGVkYmRkYzliODE1M2UzNTA5ODJjYjMwMU8xMTE4MyI7czo1MDoiL3dwLWFkbWluL2luY2x1ZGVzL2NsYXNzLXdwLWFqYXgtdXBncmFkZXItc2tpbi5waHAiO3M6Mzc6ImE5NDVmNDMyNzdlN2U1MDc1OGQxN2E4MTlhOWU5ZGQ3TzMxODUiO3M6NDk6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy13cC1hdXRvbWF=aWMtdXBkYXRlci5waHAiO3M6Mzg6IjgxMDk3ZjZmM2RhNzJmNDJhNTIzODIyYTZmZjdiMmE2TzM=MjMwIjtzOjUxOiIvd3AtYWRtaW4vaW5jbHVkZXMvY2xhc3Mtd3AtY29tbWVudHMtbGlzdC1=YWJsZS5waHAiO3M6Mzg6ImYyZTQzMjVhZjg2MzdjMWEwZTUwNDYwNzBkNjBlYzViTzI1NTUxIjtzOjQ3OiIvd3AtYWRtaW4vaW5jbHVkZXMvY2xhc3Mtd3AtZmlsZXN5c3RlbS1iYXNlLnBocCI7czozODoiMzFhOTAzMGEwNzg1M2Y=MGU5NmQ4NzNkZGRkNDAxYzlPMjMwMjAiO3M6NDk6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy13cC1maWxlc3lzdGVtLWRpcmVjdC5waHAiO3M6Mzg6IjU=NzgyOGY=M2VlYWUwMDY4YzAwZGJmZmU5OGMwM2ZkTzExNzk1IjtzOjQ5OiIvd3AtYWRtaW4vaW5jbHVkZXMvY2xhc3Mtd3AtZmlsZXN5c3RlbS1mdHBleHQucGhwIjtzOjM4OiJiZmIzMTAzNGUyN2U=MTI3NzMxNmRjZGIyZWRhZGZhN=8xNDA1NyI7czo1MzoiL3dwLWFkbWluL2luY2x1ZGVzL2NsYXNzLXdwLWZpbGVzeXN=ZW=tZnRwc29ja2V=cy5waHAiO3M6Mzg6Ijk1MGIyZjQ2MGU4NzAyYzJjMDQ4ZWU4YzAwMjE4ZjZiTzExMTM1IjtzOjQ3OiIvd3AtYWRtaW4vaW5jbHVkZXMvY2xhc3Mtd3AtZmlsZXN5c3RlbS1zc2gyLnBocCI7czozODoiZTJkYjYwNjBjODczYmNjYzIwY2E=NDFhMDVlZDk4YzlPMTU1NzIiO3M6NDA6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy13cC1pbXBvcnRlci5waHAiO3M6Mzc6IjJjNzdmNWNkZTQwOTVmZWFjYWM5ZDcyZjRhNTMwNTNiTzcyNzYiO3M6NDk6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy13cC1pbnRlcm5hbC1wb2ludGVycy5waHAiO3M6Mzc6ImUzYmU=OTg3OWU=ZTc=OTgyMzUzOWUyMzQxMTNkNmNlTzQzMTkiO3M6NDg6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy13cC1saW5rcy1saXN=LXRhYmxlLnBocCI7czozNzoiNmU4NDc4ZDJiMjllZmRjY2RmNmJlYWI4OWQzNjVmNzlPNzgzMiI7czo=OToiL3dwLWFkbWluL2luY2x1ZGVzL2NsYXNzLXdwLWxpc3QtdGFibGUtY29tcGF=LnBocCI7czozNzoiYzU5ODIyZTI5NGIzMzQ5NTA1NGE=ZmFmNDM5MTk1MjhPMTEwOSI7czo=MjoiL3dwLWFkbWluL2luY2x1ZGVzL2NsYXNzLXdwLWxpc3QtdGFibGUucGhwIjtzOjM4OiJmYzhkYjE5YmE5NTY1YzYyMjc4OTZiNjQ1MTdhNzQxYU8zODQzNyI7czo=ODoiL3dwLWFkbWluL2luY2x1ZGVzL2NsYXNzLXdwLW1lZGlhLWxpc3QtdGFibGUucGhwIjtzOjM4OiI=MzAzMzgzN2U=NmI5NzVmZmNmYTg=OGM5OGY4MzhlNU8yMjY4NiI7czo1MToiL3dwLWFkbWluL2luY2x1ZGVzL2NsYXNzLXdwLW1zLXNpdGVzLWxpc3QtdGFibGUucGhwIjtzOjM4OiIwM2U4MDc1MDkxNTZlZTBmMmMxOTJhOTVmMTllYjM2YU8xNTU5NyI7czo1MjoiL3dwLWFkbWluL2luY2x1ZGVzL2NsYXNzLXdwLW1zLXRoZW1lcy1saXN=LXRhYmxlLnBocCI7czozODoiNzE4NjdiYTQwYTAyOTNjYWU5N2UzNDI3ZjljMjkxYTRPMTk5OTEiO3M6NTE6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy13cC1tcy11c2Vycy1saXN=LXRhYmxlLnBocCI7czozODoiNWM5OGIwNjVkMDdlNmU2NTEzY2RhMTc5YjUwNzBhMjlPMTI1OTEiO3M6NTc6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy13cC1wbHVnaW4taW5zdGFsbC1saXN=LXRhYmxlLnBocCI7czozODoiMGE=ZmY5MThiZTc5OWZhNTI3ZWQ5ZjRmYjA5YzBlNzNPMTgxOTUiO3M6NTA6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy13cC1wbHVnaW5zLWxpc3QtdGFibGUucGhwIjtzOjM4OiIyYTc4NjBmMWYyNTdmMzVhN2I1OTQzNmE=OWEyYzAxM=8zMjU3NSI7czo1NjoiL3dwLWFkbWluL2luY2x1ZGVzL2NsYXNzLXdwLXBvc3QtY29tbWVudHMtbGlzdC1=YWJsZS5waHAiO3M6Mzc6IjVjMzRmODVhMDVlZWUzMDVlYWMyNjU=ZTVkMjVlNTQ=TzE=NzIiO3M6NDg6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy13cC1wb3N=cy1saXN=LXRhYmxlLnBocCI7czozODoiNWU1ZmU=YjVmYTUxZmQyOTFhZWQ5MzM1MDQ=NTFkNjNPNTE5MDgiO3M6NDI6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy13cC1wcmVzcy1=aGlzLnBocCI7czozODoiMjA2ZDcxODU=NjYwNTgxZGFkN2M3NGQ1YzM=MDlhOWNPNDk5MTIiO3M6Mzg6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy13cC1zY3JlZW4ucGhwIjtzOjM4OiI2OWFmMTgzMDYyMzJmZTRmMDMyNDkwZDEzZjBiZGFmM=8zNDQxNyI7czo=MToiL3dwLWFkbWluL2luY2x1ZGVzL2NsYXNzLXdwLXNpdGUtaWNvbi5waHAiO3M6Mzc6ImQ1ZTg4M2YzMTFhZTljODc1ODIyZGU3MTIxOGM3Y2NjTzYyMTQiO3M6NDg6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy13cC1=ZXJtcy1saXN=LXRhYmxlLnBocCI7czozODoiNGY=YTllYmI1ZjNiNGUwYjBjZjViMTBmMzgwMzJiY2FPMTc4NjAiO3M6NTY6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy13cC1=aGVtZS1pbnN=YWxsLWxpc3QtdGFibGUucGhwIjtzOjM4OiI2MTE=NTI1YzdhOTJjMTc5ZmMzNDNlYTJhYmMyMmMyY=8xNDU4MyI7czo=OToiL3dwLWFkbWluL2luY2x1ZGVzL2NsYXNzLXdwLXRoZW1lcy1saXN=LXRhYmxlLnBocCI7czozNzoiNmZhMmFjN2M=ZGVjNjkyYTZkOTFlZDIzMTcyZmU1MzhPOTM4NiI7czo=NToiL3dwLWFkbWluL2luY2x1ZGVzL2NsYXNzLXdwLXVwZ3JhZGVyLXNraW4ucGhwIjtzOjM3OiIyNzg3MzYwZDRmOGM1NjVlOTM5MGNlMTg1N2Y=MDFhNk81MjI4IjtzOjQ2OiIvd3AtYWRtaW4vaW5jbHVkZXMvY2xhc3Mtd3AtdXBncmFkZXItc2tpbnMucGhwIjtzOjM3OiJlYjNmMTUxZmMwYTg=ODVhZTFjYjFlOGNiOWViNzY1NU8xNDU2IjtzOjQwOiIvd3AtYWRtaW4vaW5jbHVkZXMvY2xhc3Mtd3AtdXBncmFkZXIucGhwIjtzOjM4OiIyMmEyMTIwM2VjMDIyYjYzNzkwMjkwM2FiZDliOTk5M=8zMzU5NyI7czo=ODoiL3dwLWFkbWluL2luY2x1ZGVzL2NsYXNzLXdwLXVzZXJzLWxpc3QtdGFibGUucGhwIjtzOjM4OiI4YjlkNGM2NjA3ZWU3N2RlYTUzMTI1ZmE4MTFkMDc3ZU8xNTk=MSI7czozMDoiL3dwLWFkbWluL2luY2x1ZGVzL2NvbW1lbnQucGhwIjtzOjM3OiJkMDk3ZWU4Y2YxMTJhODRmZmEzZTk5OTVhM2Y5MGQ1OE81NzI2IjtzOjQwOiIvd3AtYWRtaW4vaW5jbHVkZXMvY29udGluZW5=cy1jaXRpZXMucGhwIjtzOjM4OiI=NDhiNzEyZTRmNDJiZWIwMGMzNjEyOTkwYWE3NjY4Nk8xOTQ5OSI7czozMDoiL3dwLWFkbWluL2luY2x1ZGVzL2NyZWRpdHMucGhwIjtzOjM3OiI3ZDU=NmExYTJhYzljODkwYWE5ZmQ2OGNjYTRiMjIxZE8xOTM2IjtzOjMyOiIvd3AtYWRtaW4vaW5jbHVkZXMvZGFzaGJvYXJkLnBocCI7czozODoiNjYxMWFkOGMyMTRmN2M4NmJkMTljZjdiOTgyZjM1MDRPNTI5NzciO3M6MzM6Ii93cC1hZG1pbi9pbmNsdWRlcy9kZXByZWNhdGVkLnBocCI7czozODoiZDVkYjFkMzAxYjcyZTYzZTU1MjI3ZGY5MTRjYzFjNThPMzU3MjEiO3M6NDA6Ii93cC1hZG1pbi9pbmNsdWRlcy9lZGl=LXRhZy1tZXNzYWdlcy5waHAiO3M6Mzc6ImVkODcyYWFlMDViYzc5ZmRlNmM4NjRlZGFkZjc3YzgxTzE=MTEiO3M6Mjk6Ii93cC1hZG1pbi9pbmNsdWRlcy9leHBvcnQucGhwIjtzOjM4OiI3NTgzMDQ3Yjg4M2M5NjVjODIxMjJmNjQ5MDk=MDY1ZE8yMjk2NSI7czoyNzoiL3dwLWFkbWluL2luY2x1ZGVzL2ZpbGUucGhwIjtzOjM4OiIzZjU5YjEwMjI=M2Y=YzUyNDZjYThlZmViM2U4ZGM2Mk81MjA4MiI7czozMzoiL3dwLWFkbWluL2luY2x1ZGVzL2ltYWdlLWVkaXQucGhwIjtzOjM4OiI4NDY4MTZmMjY=ZWFhZmRiY2I5ZDIyYTg=NmJhM2Q5Y=8zMzE4OCI7czoyODoiL3dwLWFkbWluL2luY2x1ZGVzL2ltYWdlLnBocCI7czozODoiN2Q=ZmIzMWI=NjRlZDMzZDgyZWY1ZGI5NzcyMjdjNzZPMjE2NjUiO3M6Mjk6Ii93cC1hZG1pbi9pbmNsdWRlcy9pbXBvcnQucGhwIjtzOjM3OiJhNDgxYTY5ZmJlMzIxYzk1ZTAxOWIxODQxZDRhMjQ2N=82MTU2IjtzOjMzOiIvd3AtYWRtaW4vaW5jbHVkZXMvbGlzdC1=YWJsZS5waHAiO3M6Mzc6IjRlN2MyOGNjYThhMzQ2MjUyMWQ3MWQwNjg1YjJmMzZmTzI2NDgiO3M6Mjg6Ii93cC1hZG1pbi9pbmNsdWRlcy9tZWRpYS5waHAiO3M6Mzk6IjdkMjcwNjc5ZWQyODRlODdkZDY3M2FiMDFhNDZmMjhlTzEwMzMxMSI7czoyNzoiL3dwLWFkbWluL2luY2x1ZGVzL21lbnUucGhwIjtzOjM3OiJhMTZjMzI4NzkxNzE2Y2NlNmQwMzJiOTMzZjRjOTM3Nk84NzE1IjtzOjMzOiIvd3AtYWRtaW4vaW5jbHVkZXMvbWV=YS1ib3hlcy5waHAiO3M6Mzg6IjJmYTc1Mzc=NzJkM2Y2M2YwZGY1OGM2OTgyNzdjN2Q1TzUwNzA2IjtzOjI3OiIvd3AtYWRtaW4vaW5jbHVkZXMvbWlzYy5waHAiO3M6Mzg6IjUzY2VhM2E3MGU1ZDJmMDgzZjA3Y2IyMWMyNzBiYjFhTzI2NDEyIjtzOjM5OiIvd3AtYWRtaW4vaW5jbHVkZXMvbXMtYWRtaW4tZmlsdGVycy5waHAiO3M6Mzc6IjUxMzcxNmMwMTgzOWNkMTRlMTg3MDY2YzNiMTkxZjgwTzEyODkiO3M6MzY6Ii93cC1hZG1pbi9pbmNsdWRlcy9tcy1kZXByZWNhdGVkLnBocCI7czozNzoiYmEyMDAyODZjZDZmNmQ4OWRmOWE2ZmMyYjVhYjgyNGRPMjg3OCI7czoyNToiL3dwLWFkbWluL2luY2x1ZGVzL21zLnBocCI7czozODoiYTk=ZGFjMTFmYTI4ZGE1YjhjZjNkYWJkYjZjMmY=OTFPMzg5NjEiO3M6MzE6Ii93cC1hZG1pbi9pbmNsdWRlcy9uYXYtbWVudS5waHAiO3M6Mzg6IjNjMjZkZmFmNmVlNzVhZTkyYzc1YzgzNGY5NDJiOTlmTzQyMjIyIjtzOjMwOiIvd3AtYWRtaW4vaW5jbHVkZXMvbmV=d29yay5waHAiO3M6Mzg6ImVjMjEyNjU2ODhlOTk1ZjZlMzY5MDRkNzE3ZjhmNzhkTzIzNjM5IjtzOjI3OiIvd3AtYWRtaW4vaW5jbHVkZXMvbm9vcC5waHAiO3M6Mzc6ImQ1NGJkMDk4ZTk2NGYyZDRiMGFkYTY4YmMxMmZiNGFkTzEwODMiO3M6MzA6Ii93cC1hZG1pbi9pbmNsdWRlcy9vcHRpb25zLnBocCI7czozNzoiNGUwYjMxMTUzYmFmMGNlNDNhNWRlNDJhNWFkOWUwNjBPNDE=OSI7czozNzoiL3dwLWFkbWluL2luY2x1ZGVzL3BsdWdpbi1pbnN=YWxsLnBocCI7czozODoiZmRjYmZkNDhjMzQ=MDAzOGYyNTBjYWNhMmFkMGIxZjFPMzExNzQiO3M6Mjk6Ii93cC1hZG1pbi9pbmNsdWRlcy9wbHVnaW4ucGhwIjtzOjM4OiJjZWVkMWIzNmYxOTYzOTAyNjNiYzc1MGMyNzYyZmMxMk82NTcwMyI7czoyNzoiL3dwLWFkbWluL2luY2x1ZGVzL3Bvc3QucGhwIjtzOjM4OiI4NmZjYzgyODAyYzg5ZDAwNDAyOWM1YmYzZDQ2MTZiME81OTYxMiI7czozMToiL3dwLWFkbWluL2luY2x1ZGVzL3JldmlzaW9uLnBocCI7czozODoiNWQ4MGMxNmJiYTk3Mjk5ZGJjYzdiNWZjY2Y3MTU4OTFPMTQ5MzYiO3M6Mjk6Ii93cC1hZG1pbi9pbmNsdWRlcy9zY2hlbWEucGhwIjtzOjM4OiI4ODk5MGNkMTM=YzUzOTM3MjQxZjBlN2VkYjc1MzIwOU8zNjg4OCI7czoyOToiL3dwLWFkbWluL2luY2x1ZGVzL3NjcmVlbi5waHAiO3M6Mzc6IjhlMTk3YTAwODEyMzg4NmM3ZjgxMGYzYjgwMjFmYTBjTzYxNDgiO3M6MzE6Ii93cC1hZG1pbi9pbmNsdWRlcy9=YXhvbm9teS5waHAiO3M6Mzc6IjM2MmYzMWI3M2Y=NjJjZWRjOGFhZmYxZmQ3MzBkYjViTzc3MjciO3M6MzE6Ii93cC1hZG1pbi9pbmNsdWRlcy9=ZW1wbGF=ZS5waHAiO3M6Mzg6IjhmZGNjOTFjMjMzY2U1ZTBhNTczNDZiMTE5M2U4Njc=Tzc4MDkyIjtzOjM2OiIvd3AtYWRtaW4vaW5jbHVkZXMvdGhlbWUtaW5zdGFsbC5waHAiO3M6Mzc6ImY1YTQ2M2YwM2RlOWEzZWRmNTMwOTUyZGNiMTliNWVlTzYyNzYiO3M6Mjg6Ii93cC1hZG1pbi9pbmNsdWRlcy9=aGVtZS5waHAiO3M6Mzg6ImUyMzUzZmUwMWNkYTJmZDY=Njc1N2FmNmYyZmFjOTk5TzI3NTgzIjtzOjQyOiIvd3AtYWRtaW4vaW5jbHVkZXMvdHJhbnNsYXRpb24taW5zdGFsbC5waHAiO3M6Mzc6IjA5YzA1YTcxNmQ=ZTg=NWZmYmYwMzgyMTA2ZmJiNmVlTzg1MzUiO3M6MzQ6Ii93cC1hZG1pbi9pbmNsdWRlcy91cGRhdGUtY29yZS5waHAiO3M6Mzg6IjcyNDIwZTYxNjQ1NmI=YjNlYmM4NTc5MzFkNTJhYThkTzUyMzA4IjtzOjI5OiIvd3AtYWRtaW4vaW5jbHVkZXMvdXBkYXRlLnBocCI7czozODoiZWNkYjJmM2M3ZjUxZTM5MmVlZDIyYjA4OTkzMmEzOTVPMjU4OTEiO3M6MzA6Ii93cC1hZG1pbi9pbmNsdWRlcy91cGdyYWRlLnBocCI7czozODoiMjU4OGQ5YjdmOGRiZjE2NWUzNzViZGJmZGEyOGI4ZmVPOTQ=NTYiO3M6Mjc6Ii93cC1hZG1pbi9pbmNsdWRlcy91c2VyLnBocCI7czozODoiNGJhOWNlMWMxNmQ2NTVhYjNlZGI=MTJkNmI2Zjg4MzlPMTc=MDQiO3M6MzA6Ii93cC1hZG1pbi9pbmNsdWRlcy93aWRnZXRzLnBocCI7czozNzoiODljYjRmZDk4NDdiNTNiZDMwYjIxNmQwZjVkNjI3MzhPOTQ5NCI7czoxOToiL3dwLWFkbWluL2luZGV4LnBocCI7czozNzoiMGRkZjg4NjYyMTA4YWY5NDFmMGU=YjQzYzk2ZDM=NWFPNjE5NiI7czoyODoiL3dwLWFkbWluL2luc3RhbGwtaGVscGVyLnBocCI7czozNzoiNjQ1NmIyNjBhYTlkZWNlOWIzMDQzMTI2MGNkYjFhNmNPNTc1MCI7czoyMToiL3dwLWFkbWluL2luc3RhbGwucGhwIjtzOjM4OiJhYTkwODIyM2EwY2Q1MDFhMjYyOTcyMzJlZjk4YzkxZk8xNjQ1OSI7czoyNToiL3dwLWFkbWluL2pzL2FjY29yZGlvbi5qcyI7czozNzoiZWYzZmUzM2Q=Y2UxMmZlNTI1NGU1YWYxMDI1Y2U3MGFPMjkxOCI7czoyOToiL3dwLWFkbWluL2pzL2FjY29yZGlvbi5taW4uanMiO3M6MzY6IjIyNmJjMTQ5ZmM3YTFkMmQ1NmU=NTMwZDNiNjg1ZTU4TzgzNSI7czoyNzoiL3dwLWFkbWluL2pzL2Jvb2ttYXJrbGV=LmpzIjtzOjM3OiI5NWM5ZWYzNWI3NmFmMmFjZWFmOWQ2YzU5NThlOGQ=M=8zOTU3IjtzOjMxOiIvd3AtYWRtaW4vanMvYm9va21hcmtsZXQubWluLmpzIjtzOjM3OiJhOTFjZDk1YmFlYjY2ZDQ4NzNkYmU=MjRiNzU5NzBjM=8yMDU1IjtzOjI4OiIvd3AtYWRtaW4vanMvY29sb3ItcGlja2VyLmpzIjtzOjM3OiIwNWM3ZjY3NTZhZWFjM2YyY2Y3ZDI3NmFmNjg4MTgyNk81NDcxIjtzOjMyOiIvd3AtYWRtaW4vanMvY29sb3ItcGlja2VyLm1pbi5qcyI7czozNzoiMmUzYTFmMmEwYWMyOTkwNjBkM2M4NTNlNjFkMDAyYjBPMzEwNCI7czoyMzoiL3dwLWFkbWluL2pzL2NvbW1lbnQuanMiO3M6Mzc6ImQ5ZTNkYjAwZGNjNmVmNGQ=YzAzZmY=NTVkY2I5YzU1TzIwMzQiO3M6Mjc6Ii93cC1hZG1pbi9qcy9jb21tZW5=Lm1pbi5qcyI7czozNzoiOGYzNjAzZWQwZDc3YzRhMWFlOGY4MmRiZDMxNTllZDlPMTI=NyI7czoyMjoiL3dwLWFkbWluL2pzL2NvbW1vbi5qcyI7czozODoiMzBlNDQ=OWFhNTQ=ZTE2NDhkMjNlZDdjMmQxYTU=MjNPMjc4NDgiO3M6MjY6Ii93cC1hZG1pbi9qcy9jb21tb24ubWluLmpzIjtzOjM4OiJhZGMyZTI1NDZkZWI=OGQxNTY=ZjUzOTI2NTBkMmEwNU8xMzgwMCI7czozMzoiL3dwLWFkbWluL2pzL2N1c3RvbS1iYWNrZ3JvdW5kLmpzIjtzOjM3OiJmNGNlZmY2MGU2MzA=NjI=NTQ=M2JjNTVlZTdiYWJhOU8yMjAwIjtzOjM3OiIvd3AtYWRtaW4vanMvY3VzdG9tLWJhY2tncm91bmQubWluLmpzIjtzOjM3OiIzNTFmMmVlZjFkNTAzM2Q2OGU4OTgyZWE4NjE2N2UzZk8xMTQ4IjtzOjI5OiIvd3AtYWRtaW4vanMvY3VzdG9tLWhlYWRlci5qcyI7czozNzoiMzJiMzAwNTg4N2E=Y2I2MDZmZWNjMDljNzU2NjA1YmJPMTUwMiI7czozNDoiL3dwLWFkbWluL2pzL2N1c3RvbWl6ZS1jb25=cm9scy5qcyI7czozOToiNTYyZThhOTA2N2E2Mjc4OWFjZTBlMjFhMWNiMTJlZmRPMTY=MTg=IjtzOjM4OiIvd3AtYWRtaW4vanMvY3VzdG9taXplLWNvbnRyb2xzLm1pbi5qcyI7czozODoiMGU5Zjc=NjQ3ODNkYjhlZWMwYTM2Mjk3OTE=NDg1NzVPNjQwNDMiO3M6MzU6Ii93cC1hZG1pbi9qcy9jdXN=b21pemUtbmF2LW1lbnVzLmpzIjtzOjM4OiI5YjZmZDM5MDBhMmRkODhjNGRlMGU=NjU1ZjM2MmNiM=85NzgxNiI7czozOToiL3dwLWFkbWluL2pzL2N1c3RvbWl6ZS1uYXYtbWVudXMubWluLmpzIjtzOjM4OiI2NzZmNTU5YzI=ZGNjODY5MTg2OWU4NmJlM2NmNzJjME8=MzU3NCI7czozMzoiL3dwLWFkbWluL2pzL2N1c3RvbWl6ZS13aWRnZXRzLmpzIjtzOjM4OiJkYTA4ZDNlODhlZTY1MjU1MTFkYTBjYTE1MThmZWYwOE82ODM4MSI7czozNzoiL3dwLWFkbWluL2pzL2N1c3RvbWl6ZS13aWRnZXRzLm1pbi5qcyI7czozODoiMDZlMWI5YThiODkyYzcwZTFjODVkNmU3MWE4MTgwNDJPMjc4NTYiO3M6MjU6Ii93cC1hZG1pbi9qcy9kYXNoYm9hcmQuanMiO3M6Mzc6ImU2YWVlMTVhZTdjYmMzOWM=MWUwY2FhMmU5M2VmNjM1TzU3OTAiO3M6Mjk6Ii93cC1hZG1pbi9qcy9kYXNoYm9hcmQubWluLmpzIjtzOjM3OiIwZGMxMzNlMjhkMTllZDZhZTE4NzAyYTU4YTMzNTE4ME8zMjE4IjtzOjI5OiIvd3AtYWRtaW4vanMvZWRpdC1jb21tZW5=cy5qcyI7czozODoiZWFiY2MwYzVlN2Q3YTQzN2I2MTRmYWI=MDg5YTY4MTBPMjc1MDEiO3M6MzM6Ii93cC1hZG1pbi9qcy9lZGl=LWNvbW1lbnRzLm1pbi5qcyI7czozODoiYTIxOWEwYjI3NjIyNWJiM2JhY2FjOGMyY2IzNzc2YjRPMTQ2ODYiO3M6Mjk6Ii93cC1hZG1pbi9qcy9lZGl=b3ItZXhwYW5kLmpzIjtzOjM4OiJjN2Q4ZTI=ZjRjMjA4MTA4YjdjYWYyZGY4OGQ5YjU=YU8zMzQwMyI7czozMzoiL3dwLWFkbWluL2pzL2VkaXRvci1leHBhbmQubWluLmpzIjtzOjM4OiI=NTAwMDM=YTI2ZDczYjczN2Y3NjFhZGNjN2VmNWM3OU8xMzUxOCI7czoyMjoiL3dwLWFkbWluL2pzL2VkaXRvci5qcyI7czozODoiN2Q5MDAxYWEyNDVlNjAwNDI3MGIwMzg5YTk=NWRmODhPMTIwMDAiO3M6MjY6Ii93cC1hZG1pbi9qcy9lZGl=b3IubWluLmpzIjtzOjM3OiIwYmE4ZDdmYTIwZTg2ZjYwYjA2MTc2YzcyMTMwYmM=ZE82NDkzIjtzOjI2OiIvd3AtYWRtaW4vanMvZmFyYnRhc3RpYy5qcyI7czozNzoiYTczYWYzNTRhMDMyNDE3MTVkODY5OGZlZWEzNDBiOTJPNzY4OSI7czoyMzoiL3dwLWFkbWluL2pzL2dhbGxlcnkuanMiO3M6Mzc6Ijc4Y2ZhOTY1MDZiZjM5NjVjMThhZmE2ZGU1YjVhYmI2TzU1NTAiO3M6Mjc6Ii93cC1hZG1pbi9qcy9nYWxsZXJ5Lm1pbi5qcyI7czozNzoiNGU3YjI1ZTliYzMzNzRjZjM5MWQ1YTY1MjY1MWEyNzdPMzgxNSI7czoyNjoiL3dwLWFkbWluL2pzL2ltYWdlLWVkaXQuanMiO3M6Mzg6IjE2YTNjYjI2Y2IwODE=YTIzMWQ1OGIzOGM5N2RmODE=TzE3NzE3IjtzOjMwOiIvd3AtYWRtaW4vanMvaW1hZ2UtZWRpdC5taW4uanMiO3M6Mzc6IjUzMjg2ZDAwM2UzZTE5ZWFjYzI2OTI2Zjc2YzBkN2RmTzk2ODciO3M6MzI6Ii93cC1hZG1pbi9qcy9pbmxpbmUtZWRpdC1wb3N=LmpzIjtzOjM4OiJiOTIwYjI1OTkxMGZkYTMxODdkNzY2OWQzMzQ=YmJlNU8xMTM=NSI7czozNjoiL3dwLWFkbWluL2pzL2lubGluZS1lZGl=LXBvc3QubWluLmpzIjtzOjM3OiIxYzc2Y2JiYjE=NjA4NjU2NTg1MjNjYWE4NmYwNWNiYU83MTc1IjtzOjMxOiIvd3AtYWRtaW4vanMvaW5saW5lLWVkaXQtdGF4LmpzIjtzOjM3OiJlYzU4MThjNDUyMzg=NjFjYmNlMWZlZTE4NzIzNjQ5ME83NDc4IjtzOjM1OiIvd3AtYWRtaW4vanMvaW5saW5lLWVkaXQtdGF4Lm1pbi5qcyI7czozNzoiZGRlOTEyN2RlNGMyOTk1ZmM=MzRiMjAwZjBkZDYxNWJPMjc1NSI7czoyNDoiL3dwLWFkbWluL2pzL2lyaXMubWluLmpzIjtzOjM4OiI=NTA3NjA2NGZkY2JmY2Y5ZjVjODk5NmUxMGFjNGJjOU8yMzYwOCI7czozMjoiL3dwLWFkbWluL2pzL2xhbmd1YWdlLWNob29zZXIuanMiO3M6MzY6IjA5ZTIwMTUwYzc1NjFkMDMzMGQ3MTU4Zjc=NGFiYjRhTzYyNSI7czozNjoiL3dwLWFkbWluL2pzL2xhbmd1YWdlLWNob29zZXIubWluLmpzIjtzOjM2OiIxZDY4MjIzODRhNzEwOTBjNzRhZGQxMDZlNDQ2ODU4MU8zNzQiO3M6MjA6Ii93cC1hZG1pbi9qcy9saW5rLmpzIjtzOjM3OiIxYzg2NzVkY2QwMzVjZmIzNzRmNjdiZmNiZjExN2E4Y=8yMjQ3IjtzOjI=OiIvd3AtYWRtaW4vanMvbGluay5taW4uanMiO3M6Mzc6ImY5ZmY=Njk=OTMzMDAxOTMzYmRlYzJjMTMzYjIyNTJkTzE2NDYiO3M6Mjk6Ii93cC1hZG1pbi9qcy9tZWRpYS1nYWxsZXJ5LmpzIjtzOjM3OiJkMDgwOTA=ODg3NGQyMzRlMzVhYmFlNjVkYzE3NzEwYU8xMTc5IjtzOjMzOiIvd3AtYWRtaW4vanMvbWVkaWEtZ2FsbGVyeS5taW4uanMiO3M6MzY6IjMyOTZkMWZhMjBkMjkyYjAwMmJiYTEwNDkwZjFiYTZlTzUzNyI7czoyODoiL3dwLWFkbWluL2pzL21lZGlhLXVwbG9hZC5qcyI7czozNzoiOTRiNDY=ZTliNGVjNmI1NDU=ODZhZjc5NWYyNDAxNmRPMTk4NCI7czozMjoiL3dwLWFkbWluL2pzL21lZGlhLXVwbG9hZC5taW4uanMiO3M6Mzc6ImYzMjAxNzRlZDYzZGUyNzUyNjRkY2Y1NDMwYzMwOWRjTzExNTMiO3M6MjE6Ii93cC1hZG1pbi9qcy9tZWRpYS5qcyI7czozNzoiOWRkZDRkNzYyZDgwNWIyYzVlYTQ1ODUxNWNjNWUyMTdPMjk3NSI7czoyNToiL3dwLWFkbWluL2pzL21lZGlhLm1pbi5qcyI7czozNzoiOWJlNjNhZGJhZjVhNWFjZmRiZmRkNTU1ZGMxOTc3N2RPMTg3NCI7czoyNDoiL3dwLWFkbWluL2pzL25hdi1tZW51LmpzIjtzOjM4OiJmNWFlOWU3OGI=N2M1MDk2YjEwYWZlYjBlMWU5NTFlNU8=MTU3NCI7czoyODoiL3dwLWFkbWluL2pzL25hdi1tZW51Lm1pbi5qcyI7czozODoiMDMwZGYxZjg1NTA5ODNlZWI2ZjM=ZmY=NmJmZDhkN2JPMjA5ODMiO3M6Mzk6Ii93cC1hZG1pbi9qcy9wYXNzd29yZC1zdHJlbmd=aC1tZXRlci5qcyI7czozNzoiMjg=NzU3NmVjNDUyOTNhYjk2ZGMwMDMwOTc=ZTI2MjlPMjQwNyI7czo=MzoiL3dwLWFkbWluL2pzL3Bhc3N3b3JkLXN=cmVuZ3RoLW1ldGVyLm1pbi5qcyI7czozNjoiMWFhYTc=YTI=YWVmOTgyYjgyNDk4NzE3YzFkMWU2ZDFPNzg=IjtzOjMwOiIvd3AtYWRtaW4vanMvcGx1Z2luLWluc3RhbGwuanMiO3M6Mzc6ImI2MDZjZjJiYTA2MzUzYjBlMzgzZTM2YjRiZDE5YTMwTzYyNjYiO3M6MzQ6Ii93cC1hZG1pbi9qcy9wbHVnaW4taW5zdGFsbC5taW4uanMiO3M6Mzc6IjQ2YWMwMzg3NTI=NWUyNGEwZDFiZTQ4OWI2Y2I=YzJmTzIzMjEiO3M6MjA6Ii93cC1hZG1pbi9qcy9wb3N=LmpzIjtzOjM4OiI=MTBmZDk5YTBhY2EwMmRjZjZhYmRhOGI5ODIyMmQ5OU8zNzQwOSI7czoyNDoiL3dwLWFkbWluL2pzL3Bvc3QubWluLmpzIjtzOjM4OiJlZGU1ZjdlODQzMWRiZWI3OTBlOGNmOTY2NTE5MjE3MU8xODM3OSI7czoyMzoiL3dwLWFkbWluL2pzL3Bvc3Rib3guanMiO3M6Mzg6ImUzZGZjM2I3MWZlZmM4YzZlYjgyZGY1NGUzNDYwYjUzTzExOTA4IjtzOjI3OiIvd3AtYWRtaW4vanMvcG9zdGJveC5taW4uanMiO3M6Mzc6ImRkZmUyN2Y=ZWZhZTczN2I4MDBiYWQ5NmVkOGEwOTY5TzQxOTIiO3M6MjY6Ii93cC1hZG1pbi9qcy9wcmVzcy1=aGlzLmpzIjtzOjM4OiJmMjQ4ZjMwYThhN2Q3ODJkNGUzODk2MmM4ZjBlNjMyOU8yNTc3NCI7czozMDoiL3dwLWFkbWluL2pzL3ByZXNzLXRoaXMubWluLmpzIjtzOjM4OiJjZWVjMDI1ZDQ3MTA1ODFjOGEwOTg2ODYwYzhkZmFjOU8xMTQ2MiI7czoyNToiL3dwLWFkbWluL2pzL3JldmlzaW9ucy5qcyI7czozODoiNGViODI=Yjc1ZDNlNGQ2MmJkYzgwYTZkMmE3OWEzNzdPMzM2NzkiO3M6Mjk6Ii93cC1hZG1pbi9qcy9yZXZpc2lvbnMubWluLmpzIjtzOjM4OiIxODlhNGQ4NDM=OWZlMWY=ZGZhMGVjNDhjODJlZmIwNE8xNzg3NiI7czozNDoiL3dwLWFkbWluL2pzL3NldC1wb3N=LXRodW1ibmFpbC5qcyI7czozNjoiMmI1MTUzNTc2ZDFlZWU=MDAyZmI3ZWQ5ZTU4MzEyNTFPNzc3IjtzOjM4OiIvd3AtYWRtaW4vanMvc2V=LXBvc3QtdGh1bWJuYWlsLm1pbi5qcyI7czozNjoiOGJjNWNhMTJmYTM4YTYwN2Q1YWYyMTgxMzExYjdhNWJPNTI1IjtzOjI3OiIvd3AtYWRtaW4vanMvc3ZnLXBhaW5=ZXIuanMiO3M6Mzc6Ijg3ZGNmYmU5N2Y5MDJmYTc3Y2M=YTk4ODljODI3YWZjTzU=ODQiO3M6MzE6Ii93cC1hZG1pbi9qcy9zdmctcGFpbnRlci5taW4uanMiO3M6Mzc6ImE3OWFjYTU2MWE1Yjg3YjYyYTcxMGIwNTI2YThlNGJkTzI=MTAiO3M6MjQ6Ii93cC1hZG1pbi9qcy9=YWdzLWJveC5qcyI7czozNzoiMjI=MDk2MDViNjRiMzM=Y2I5M2Y3N2UyNDZlMzVmZjVPNjg=MiI7czoyODoiL3dwLWFkbWluL2pzL3RhZ3MtYm94Lm1pbi5qcyI7czozNzoiYjFhNjIzMzkxYTZlNDVlMjM3Yzg4NDk2M2MzZDg2YzVPMzE1MSI7czoyODoiL3dwLWFkbWluL2pzL3RhZ3Mtc3VnZ2VzdC5qcyI7czozNzoiOGJlNzQwNGY=NzIzODY5MGQyNjYxZWYwYzFiMDM=ODFPNTE=OCI7czozMjoiL3dwLWFkbWluL2pzL3RhZ3Mtc3VnZ2VzdC5taW4uanMiO3M6Mzc6IjUwMjNmNjZmYTk4MDQxNGU1MTc3ZTlhNmIyOWFmZjI2TzIxMzkiO3M6MjA6Ii93cC1hZG1pbi9qcy9=YWdzLmpzIjtzOjM3OiI=Y2M2NDI2NmYxYjM1YTg2YzYzY2MxYjJjNDJmNzMwNk8yNTkyIjtzOjI=OiIvd3AtYWRtaW4vanMvdGFncy5taW4uanMiO3M6Mzc6IjRlYzJhZTY2MzYwYWEwZWRjNzIyNzRlYTcxODgzMDlhTzE1NzMiO3M6MjE6Ii93cC1hZG1pbi9qcy9=aGVtZS5qcyI7czozODoiZWNmYjU1ZGRkN2IyZjczNDBlZTUwMTE5NWY2MzZhZmJPNTE4MjgiO3M6MjU6Ii93cC1hZG1pbi9qcy9=aGVtZS5taW4uanMiO3M6Mzg6IjY=Y2ZlNmQyOTE2YzliMjkyNjQ=MTRhNTVmNzllMDM4TzI1MzMxIjtzOjIzOiIvd3AtYWRtaW4vanMvdXBkYXRlcy5qcyI7czozODoiNDgwYTk2ODNhODdlYjMyMGQzM2Q1ZjYwMzBlYWQ2ZjZPNzg2OTIiO3M6Mjc6Ii93cC1hZG1pbi9qcy91cGRhdGVzLm1pbi5qcyI7czozODoiM2U5OTUwOGQ3YjhjNDYzNjJmOTlkY2NkMWRjZjk2M2NPMzQzNDMiO3M6Mjg6Ii93cC1hZG1pbi9qcy91c2VyLXByb2ZpbGUuanMiO3M6Mzg6ImM1Zjk1ZThmOWNlZDNkMDZkMTM3ZWM3ZjVhMTJkZTVhTzEyMDg2IjtzOjMyOiIvd3AtYWRtaW4vanMvdXNlci1wcm9maWxlLm1pbi5qcyI7czozNzoiYzRhNjY=ZWVjOWZlOTcyZmZhNGY1OGE5OTMyYTZiYTFPNjIyNCI7czoyODoiL3dwLWFkbWluL2pzL3VzZXItc3VnZ2VzdC5qcyI7czozNzoiMWUzMzI5MDgwN2ZhOGIyODI5ZGRiMDM=N2QwYTkzMDVPMTA3MCI7czozMjoiL3dwLWFkbWluL2pzL3VzZXItc3VnZ2VzdC5taW4uanMiO3M6MzY6ImUwODk1NDVjZDdmY2RlNWM3Y2Q3MGRlM2E3MDEzOWUxTzY3OSI7czoyMzoiL3dwLWFkbWluL2pzL3dpZGdldHMuanMiO3M6Mzg6ImRiMWZlOGU=ZTJkMjhiMzQ5MzMxNzBlNzY1MWQ5YzNlTzE3MTM4IjtzOjI3OiIvd3AtYWRtaW4vanMvd2lkZ2V=cy5taW4uanMiO3M6Mzg6IjBjYzc1MWFjYmQ5ZDQwY2ZlMjVmMGE1NTIwODk5MzI2TzEwMDA=IjtzOjI2OiIvd3AtYWRtaW4vanMvd29yZC1jb3VudC5qcyI7czozNzoiNzcxNzEwOWY4Nzk3YTFiNmNmZmNhY2NkMmY2OTE4MWZPNzc1OCI7czozMDoiL3dwLWFkbWluL2pzL3dvcmQtY291bnQubWluLmpzIjtzOjM3OiI5OTdmNTA1ZmM5ZDI=YTI3ZTQ5Mzk2NDE=NTBlOTZhNE8xNTA4IjtzOjM=OiIvd3AtYWRtaW4vanMvd3AtZnVsbHNjcmVlbi1zdHViLmpzIjtzOjM2OiI5Njg1MjhjYjMyNTQ3MWViMDAxZmQ4NTc4YTg2MjVlNU82ODQiO3M6Mzg6Ii93cC1hZG1pbi9qcy93cC1mdWxsc2NyZWVuLXN=dWIubWluLmpzIjtzOjM2OiI3MDBhOTRlOTkzNGM3YjQxOWRmYTY3OTBiMWRjNGEzNU8zMzEiO3M6MTk6Ii93cC1hZG1pbi9qcy94Zm4uanMiO3M6MzY6ImUyZDZlZWNiZDc3NGFmMWUyYmIxYTE2ZWMxMTcyODZiTzYyOCI7czoyMzoiL3dwLWFkbWluL2pzL3hmbi5taW4uanMiO3M6MzY6IjY2YjIyN2NhMjhmNDFmMmUwNjE1YjA=YTM5MGQ1ZTA=TzQ=MSI7czoyMjoiL3dwLWFkbWluL2xpbmstYWRkLnBocCI7czozNjoiYTBlZTBlYWFiN2M2ZjMyMTcxYjAyMTU=MDljYWEyZmNPNzAwIjtzOjI2OiIvd3AtYWRtaW4vbGluay1tYW5hZ2VyLnBocCI7czozNzoiMDU4Mjc4NTZkYmRiYWY5ODI=ZTI4ZGYwMzMzOTk3NTBPMzg2NyI7czoyOToiL3dwLWFkbWluL2xpbmstcGFyc2Utb3BtbC5waHAiO3M6Mzc6IjU4NDM2YTVhZjZmMzE4MzUyYmY1OTZhYjhhM2Y=OTYyTzI=MDEiO3M6MTg6Ii93cC1hZG1pbi9saW5rLnBocCI7czozNzoiNmU=MTczZmQ=M2EyYTAxYjM1MDljODBlZTk4NGQyMmJPMjYyNSI7czoyNjoiL3dwLWFkbWluL2xvYWQtc2NyaXB=cy5waHAiO3M6Mzc6ImZhNDM1NGVmOWU3MjlhMDY1YmE=ZGI4OTQzOTYyNzA1TzIxOTciO3M6MjU6Ii93cC1hZG1pbi9sb2FkLXN=eWxlcy5waHAiO3M6Mzc6IjJiOTRhYTcyYTZlMjgzZWY3ZWM=MDFiNDUxN2I5ZGE=TzI4ODEiO3M6MjY6Ii93cC1hZG1pbi9tYWludC9yZXBhaXIucGhwIjtzOjM3OiJlMTgwYTNiYjE3Yjg5NmUxY2RjY2YzMzc5OTViZmUyZk83MTczIjtzOjIzOiIvd3AtYWRtaW4vbWVkaWEtbmV3LnBocCI7czozNzoiODM2ZjkyMDhjNjU2ODJhYWI3NjgxOTA5ZDlhODBhYmRPMzA5NyI7czoyNjoiL3dwLWFkbWluL21lZGlhLXVwbG9hZC5waHAiO3M6Mzc6IjJjMjI3MjA5MTA2YjJjMmQxYTg5NWUxYzFhYjIzM2YyTzMzMjAiO3M6MTk6Ii93cC1hZG1pbi9tZWRpYS5waHAiO3M6Mzc6ImNlZjIwMWU=Yzk3N2M5MDhjODY5YzYzNTAzYzI5MWQxTzUyMDMiO3M6MjU6Ii93cC1hZG1pbi9tZW51LWhlYWRlci5waHAiO3M6Mzc6IjY1NjEzY2MzNDYyZjkwZjZhYmEzZDFlNzdmMmUzNjk4TzkyMzgiO3M6MTg6Ii93cC1hZG1pbi9tZW51LnBocCI7czozODoiYjU3MjcwZTkzNzMzM2E4OWJmYzlkOWE3YzQ3ZGExMDdPMTI4NzIiO3M6MjQ6Ii93cC1hZG1pbi9tb2RlcmF=aW9uLnBocCI7czozNjoiNTQxMjQyYTI5MzgwNTk1MmEwZTIyMjM=ZjA5ZDZmYTlPMzIwIjtzOjIyOiIvd3AtYWRtaW4vbXMtYWRtaW4ucGhwIjtzOjM2OiI5YTA1YjQ5NzQwZGZjZGFmNDUxNjg1MWI2MjM2MDZlNE8yMTEiO3M6Mjg6Ii93cC1hZG1pbi9tcy1kZWxldGUtc2l=ZS5waHAiO3M6Mzc6ImU2YWEyMDNkNjVmNDdjMTFhMGQ3ZDJhMjUxNDhjNzRmTzM5OTMiO3M6MjE6Ii93cC1hZG1pbi9tcy1lZGl=LnBocCI7czozNjoiMTZkNDJmZjYxN2M=YTYxNmMzYmQ5NGJhMTAzYTQ1ODJPMjMxIjtzOjI=OiIvd3AtYWRtaW4vbXMtb3B=aW9ucy5waHAiO3M6MzY6ImEyMWQyNzhlMDBjYTdkY2NmZTNhODFkNGUzODZhZmE5TzIzNiI7czoyMjoiL3dwLWFkbWluL21zLXNpdGVzLnBocCI7czozNjoiNWQxODYyMjRlYmY=ZGRkMGYxNzE5YzllZjRiODA=NjhPMjI4IjtzOjIzOiIvd3AtYWRtaW4vbXMtdGhlbWVzLnBocCI7czozNjoiNTIxY2I5NGI5NTAxY2EyNGJjNDk1YTMxYzY2OTI1ZDhPMjMwIjtzOjMyOiIvd3AtYWRtaW4vbXMtdXBncmFkZS1uZXR3b3JrLnBocCI7czozNjoiN2NiNDkyMjYwZjIyZWU1MzgxNmQ5NmJlMzg2OGJlNmRPMjMyIjtzOjIyOiIvd3AtYWRtaW4vbXMtdXNlcnMucGhwIjtzOjM2OiI=ODIzYzg2NjdiMjNjYTgzYjMxYmY5MDkzNjQ3ZTVhMk8yMjgiO3M6MjI6Ii93cC1hZG1pbi9teS1zaXRlcy5waHAiO3M6Mzc6IjM2OGMwOTJmNDQwZTQ4ODA5YTg5MTFlMzYyODMyZDQzTzQ=MjEiO3M6MjM6Ii93cC1hZG1pbi9uYXYtbWVudXMucGhwIjtzOjM4OiIzZGUwY2I1NTFmNjViYTFjMzExZTM=NmFhZGI=OGYxNE8=MDY4NiI7czoyMToiL3dwLWFkbWluL25ldHdvcmsucGhwIjtzOjM3OiI2ZDVmNDFkNmI5MTc3ZDIxMWQ=MjBhYTZhZjNkMzM1OE81Mjk4IjtzOjI3OiIvd3AtYWRtaW4vbmV=d29yay9hYm91dC5waHAiO3M6MzY6IjM2ZmQ2NjcxYTU=OTNjYzhjNTQwNTYyMWQ5NmRlYTdjTzI2MyI7czoyNzoiL3dwLWFkbWluL25ldHdvcmsvYWRtaW4ucGhwIjtzOjM3OiI=OGYxZmUzMzcwZjlkNzEzYjAyNzY1NWI2Nzg1ZTY5NE8xMDMzIjtzOjI5OiIvd3AtYWRtaW4vbmV=d29yay9jcmVkaXRzLnBocCI7czozNjoiYTFiZTU=MjUzZTcyYWNkOTZjZTYzMTcxMjdlNWE1YzBPMjY3IjtzOjI2OiIvd3AtYWRtaW4vbmV=d29yay9lZGl=LnBocCI7czozNjoiOTRiMmEyNGExZmM5ODgzMjQ2ZmMxMDNmMjI4MTg5MzBPODU1IjtzOjMwOiIvd3AtYWRtaW4vbmV=d29yay9mcmVlZG9tcy5waHAiO3M6MzY6ImUxYWYzOWU5NDIzOWE5NDQ=NDBhYjI5MjUzOTNhZTYwTzI2OSI7czoyNzoiL3dwLWFkbWluL25ldHdvcmsvaW5kZXgucGhwIjtzOjM3OiIyZjEyMGVkNmY2NDQ1NzhiNTE3OTA5MzQ4NzU4MDc5NE8yODAyIjtzOjI2OiIvd3AtYWRtaW4vbmV=d29yay9tZW51LnBocCI7czozNzoiYjU5ZTU2ZGZlMDAzYjk=OGVjNzNjMGU5MWYzM2YwMmRPNDEyMSI7czozNToiL3dwLWFkbWluL25ldHdvcmsvcGx1Z2luLWVkaXRvci5waHAiO3M6MzY6IjY1OGNmNjRiNzdkNDM1NTU1YWUyMTdhNWJiYjE1MzZhTzI3OSI7czozNjoiL3dwLWFkbWluL25ldHdvcmsvcGx1Z2luLWluc3RhbGwucGhwIjtzOjM2OiIxMzJhNmM5ZDZlMmNjNjhkNjUwZTJmY2E5YTAxNWVkMk8zOTAiO3M6Mjk6Ii93cC1hZG1pbi9uZXR3b3JrL3BsdWdpbnMucGhwIjtzOjM2OiJlNGY3Y2RmY2FkZGM=NjkzZmUwYmNjMzliYjU1ZDY4YU8yNjciO3M6Mjk6Ii93cC1hZG1pbi9uZXR3b3JrL3Byb2ZpbGUucGhwIjtzOjM2OiI2ODc=MTU3ZmRhMTgxYmMyODY2ZmQ4NjBkOTMzNzZiOU8yNzIiO3M6MzA6Ii93cC1hZG1pbi9uZXR3b3JrL3NldHRpbmdzLnBocCI7czozODoiY2I4N2JhMzAwMWU=NDdmYWNkZDQ1NjA5YzdmMTVhZGRPMTg=NjAiO3M6Mjc6Ii93cC1hZG1pbi9uZXR3b3JrL3NldHVwLnBocCI7czozNjoiY2U3NGU=M2QyNGQ5YzM2Y2Q1NzllOTMyZWU5NGIxNTJPMjY1IjtzOjMxOiIvd3AtYWRtaW4vbmV=d29yay9zaXRlLWluZm8ucGhwIjtzOjM3OiJjMmVkMTJlNzc4MmJiYjY2NmY5NWEyN2I3Y2NmOTNjNU84NjgwIjtzOjMwOiIvd3AtYWRtaW4vbmV=d29yay9zaXRlLW5ldy5waHAiO3M6Mzc6ImVhY2UzNTZkYTc3ZDRiNTRkZDQyOTkxMGViYzk3MzQ4Tzg5ODciO3M6MzU6Ii93cC1hZG1pbi9uZXR3b3JrL3NpdGUtc2V=dGluZ3MucGhwIjtzOjM3OiJkODI2NTAxMGE5ZGUyMDNiZTkzODc4NTBiYjA1OTU5ME83MTkwIjtzOjMzOiIvd3AtYWRtaW4vbmV=d29yay9zaXRlLXRoZW1lcy5waHAiO3M6Mzc6IjllZWM4OTk1ZDBjY2U=NWU3ZWE1MmZmY2ZiN2NiMTliTzgwNzIiO3M6MzI6Ii93cC1hZG1pbi9uZXR3b3JrL3NpdGUtdXNlcnMucGhwIjtzOjM4OiI5NDVmMGNlNzE3ODM4Yjg3M2UzNTIzOWJjZTI4NzZmOU8xMjYwMyI7czoyNzoiL3dwLWFkbWluL25ldHdvcmsvc2l=ZXMucGhwIjtzOjM4OiI=MWI4YWZiZWMyMzM1OTgxZTliMTFjODBkZmQ2N2I=ME8xMDkwNiI7czozNDoiL3dwLWFkbWluL25ldHdvcmsvdGhlbWUtZWRpdG9yLnBocCI7czozNjoiNWUxODI5YmYxNzk=Y2UwNmM1YWQ3N2I3ZTJkMTcxNDJPMjc3IjtzOjM1OiIvd3AtYWRtaW4vbmV=d29yay9=aGVtZS1pbnN=YWxsLnBocCI7czozNjoiNjI5NzA=ZTQxZmM2NzAxNzhhNDIyNmIzMjNiNmE5ZWNPMzg3IjtzOjI4OiIvd3AtYWRtaW4vbmV=d29yay9=aGVtZXMucGhwIjtzOjM4OiI4ZjBmMTQ1NzVkNTY=MDMyMWYzOTNhOGMxYjcyM2YxZk8xMTY1MiI7czozMzoiL3dwLWFkbWluL25ldHdvcmsvdXBkYXRlLWNvcmUucGhwIjtzOjM2OiI5NWI3ZDQ3ZWQ3MTM=OTEyMjcwZjhkMzA1OTEwMGU4Y=8yNzEiO3M6Mjg6Ii93cC1hZG1pbi9uZXR3b3JrL3VwZGF=ZS5waHAiO3M6MzY6ImZjYTYxMTBiZDJmM2ZiZDlmMjQ3NTQwNjc3ZmNmMWFjTzQ1OCI7czoyOToiL3dwLWFkbWluL25ldHdvcmsvdXBncmFkZS5waHAiO3M6Mzc6ImY1MjMzZWU5OTBjNTBhYWRlN2M=ZTNhYjliNGZlNTI=TzQ2NTUiO3M6MzE6Ii93cC1hZG1pbi9uZXR3b3JrL3VzZXItZWRpdC5waHAiO3M6MzY6IjAzMGJiNmFkM2YxYzYxNGY3ZjFhYTdmZDI3Yjc5NTA5TzI3MSI7czozMDoiL3dwLWFkbWluL25ldHdvcmsvdXNlci1uZXcucGhwIjtzOjM3OiJkZjdhMGVkY2I3OTk=NTgxNDMwMzc5ZGI1NmQ4ZDUzYk8=Nzk2IjtzOjI3OiIvd3AtYWRtaW4vbmV=d29yay91c2Vycy5waHAiO3M6Mzc6IjQ1OGE2MmVkYTA1ODVjYWExYzE5OWM=NTIwMmVjNjMxTzg2NTQiO3M6MzI6Ii93cC1hZG1pbi9vcHRpb25zLWRpc2N1c3Npb24ucGhwIjtzOjM4OiI4ZjNkNGQ=NTg2Y2RkNzgxODg=YzQ2ZmNjYjUwZTVkYk8xNDM5NyI7czoyOToiL3dwLWFkbWluL29wdGlvbnMtZ2VuZXJhbC5waHAiO3M6Mzg6IjBlOTY5MDIzYTA3NzgzOTMwYmE=MmJiNzY1NjQ5YTZjTzE1MjA2IjtzOjI2OiIvd3AtYWRtaW4vb3B=aW9ucy1oZWFkLnBocCI7czozNjoiOWE2MTZlN2RkNDY4ZDFjMjQ5OWI5MDYwMGU3MTBkYTVPNDg4IjtzOjI3OiIvd3AtYWRtaW4vb3B=aW9ucy1tZWRpYS5waHAiO3M6Mzc6IjQ4YjM3MTdjYWJkYmNjZGU1OTEzNmM=ZjVjMGM=YzYwTzU4ODgiO3M6MzE6Ii93cC1hZG1pbi9vcHRpb25zLXBlcm1hbGluay5waHAiO3M6Mzg6ImIzOTllM2YxNmZmYmFkOTc4ZDdkZWM2N2FkZjY2ZWIwTzE1MDI5IjtzOjI5OiIvd3AtYWRtaW4vb3B=aW9ucy1yZWFkaW5nLnBocCI7czozNzoiMjQwYmIwZGIxOGM1NmE1OWQ=ODczNjUzZGZmZDU1Y2ZPODM1NSI7czoyOToiL3dwLWFkbWluL29wdGlvbnMtd3JpdGluZy5waHAiO3M6Mzc6IjZkODE1NWExOTViNmNjMGViNDI4N2M2ZmM4ZjE2YzIwTzgwOTIiO3M6MjE6Ii93cC1hZG1pbi9vcHRpb25zLnBocCI7czozODoiNWQzMmU2NWExZmUwOGRhOGMwMTZkNzIwNmNkMmZjODVPMTE1NzUiO3M6Mjc6Ii93cC1hZG1pbi9wbHVnaW4tZWRpdG9yLnBocCI7czozODoiMDExN2FiMTY4ZjM3NjM2ZTE3OTBiNGVjMTZhNDI=NjlPMTIyNTkiO3M6Mjg6Ii93cC1hZG1pbi9wbHVnaW4taW5zdGFsbC5waHAiO3M6Mzc6ImU3ZDA1YzY2MDdhYjRlZTcyODQ4ZTkyOGQ5MWE4NjM=TzYxNTQiO3M6MjE6Ii93cC1hZG1pbi9wbHVnaW5zLnBocCI7czozODoiYmVjOTIyNTZiNWRhNjU5YjE1NjdkOGE5YjI5NDZiM2NPMjE3MjAiO3M6MjI6Ii93cC1hZG1pbi9wb3N=LW5ldy5waHAiO3M6Mzc6ImM5NjQ4MjFiNTc4NDkwNTE1OWY2MzA=NWZlNTk4M2JiTzI3NDAiO3M6MTg6Ii93cC1hZG1pbi9wb3N=LnBocCI7czozNzoiMjMwN2MyMzY2NGQwYzQ3NWExMmM2MDEwZjI2NGI5MjZPODE1OSI7czoyNDoiL3dwLWFkbWluL3ByZXNzLXRoaXMucGhwIjtzOjM2OiIxZDU5ZTc1MzI=MGFjNjMxM2VkNjg1YjM=ZjlkNTBmYU82MzUiO3M6MjE6Ii93cC1hZG1pbi9wcm9maWxlLnBocCI7czozNjoiOTE4NGU1M2Y5NmJhZGUzZTdhZTdjZGE5ZWRkZjdhMjZPMjk2IjtzOjIyOiIvd3AtYWRtaW4vcmV2aXNpb24ucGhwIjtzOjM3OiI3YzcyNzVhOTQ4MzMzOGQxMTljNDY4MTFkY2IzMWUxN=81MDM5IjtzOjI2OiIvd3AtYWRtaW4vc2V=dXAtY29uZmlnLnBocCI7czozODoiNzcxN2M2ZmRmNmY1NDg4YmY5MDA4ODg5ZGU4ZWY4MzFPMTQ4ODciO3M6MTg6Ii93cC1hZG1pbi9=ZXJtLnBocCI7czozNzoiMzhjMzhhYzlhMWNkNDc=ZTUyOGUwNDJkODMwMmViMDBPMjA1OSI7czoyNjoiL3dwLWFkbWluL3RoZW1lLWVkaXRvci5waHAiO3M6Mzg6IjY=Njk3ZGEwMDNmZjlmNzZjMDQxMDJmZDcwYTc4ZWI3TzExNTcxIjtzOjI3OiIvd3AtYWRtaW4vdGhlbWUtaW5zdGFsbC5waHAiO3M6Mzg6ImQyM2M=NzZlMTk4N2E1Mjk4YTdlMjZlZWJiMjZjZGIyTzE=NTU3IjtzOjIwOiIvd3AtYWRtaW4vdGhlbWVzLnBocCI7czozODoiZmFmNzIxNWZjZDdiYjI1YTZiYmYxODljOWY1MjkwZDNPMjA4MDgiO3M6MTk6Ii93cC1hZG1pbi9=b29scy5waHAiO3M6Mzc6IjBjMTM4ZjM5ZDFiMDcxMWFiOTIxYzYwZjNiNDdlMzE1TzU1MDciO3M6MjU6Ii93cC1hZG1pbi91cGRhdGUtY29yZS5waHAiO3M6Mzg6ImQ3NDY=MWUzMDlmYWQxN2RkNGYyMzY4OTA4N2U3MGViTzMwODgzIjtzOjIwOiIvd3AtYWRtaW4vdXBkYXRlLnBocCI7czozODoiNjk1OTUxZjE=NGZiODMzYzQxMGJkZjQwYWRkZTFhOTlPMTAzNTIiO3M6MzE6Ii93cC1hZG1pbi91cGdyYWRlLWZ1bmN=aW9ucy5waHAiO3M6MzY6IjY4MDcwZGU=MTczNmU1N2Y4NzU3NjQ4YTgwYjljYmJiTzM=MCI7czoyMToiL3dwLWFkbWluL3VwZ3JhZGUucGhwIjtzOjM3OiJiMmVmZGQwMDNhZWFjZDQ5ZWE4MzI1ZmM5MjMwMDBjM=8=NTEyIjtzOjIwOiIvd3AtYWRtaW4vdXBsb2FkLnBocCI7czozODoiNGRmN2Y2MTQwYzQ3NjNhMGJlODkyODNiNzlkYjY3M2JPMTMwODEiO3M6MjM6Ii93cC1hZG1pbi91c2VyLWVkaXQucGhwIjtzOjM4OiJhOTliYTE4NGM1YmVlYjA3NjNmMmJiZDFlYzA=MDY3MU8yNjUxNyI7czoyMjoiL3dwLWFkbWluL3VzZXItbmV3LnBocCI7czozODoiYWU2OWZiMjUyY2E2NjE1NzEzNjM=ODMyZTc2MmI5MWJPMjA4MDMiO3M6MjQ6Ii93cC1hZG1pbi91c2VyL2Fib3V=LnBocCI7czozNjoiOTllYzAwZGE4ZDkxNGI=ZWZkMjA5OGEzZTQ=ZWJlMmRPMjc1IjtzOjI=OiIvd3AtYWRtaW4vdXNlci9hZG1pbi5waHAiO3M6MzY6IjcwMmQ1MjIwYzcwNDU2NDU2ZmU5ZmM4Y2MwOGNjNTI=Tzg=MiI7czoyNjoiL3dwLWFkbWluL3VzZXIvY3JlZGl=cy5waHAiO3M6MzY6ImQ5MjBiNGZiMWJlMmMyYzc4MDA4MWQ1YjRiN2RlNTVhTzI3OSI7czoyNzoiL3dwLWFkbWluL3VzZXIvZnJlZWRvbXMucGhwIjtzOjM2OiIxYmE2Y2JiOWUyYTlkM2RlYjM=ODk5NzQ5MmVkNjkyZU8yODEiO3M6MjQ6Ii93cC1hZG1pbi91c2VyL2luZGV4LnBocCI7czozNjoiYzhmZDk4ZjdmZGQ1MmQ3OGJkYWRmNzRlNjIwNzg5ZmFPMjY5IjtzOjIzOiIvd3AtYWRtaW4vdXNlci9tZW51LnBocCI7czozNjoiYTUyOWUzZDNjMmJiODY2NzFmYjljYzExNDVjZjcwZWVPNzAwIjtzOjI2OiIvd3AtYWRtaW4vdXNlci9wcm9maWxlLnBocCI7czozNjoiYjlmYTE3YTk4MTExOTU4MDAwNzlkZGE=YjEyNjJkMDNPMjcwIjtzOjI4OiIvd3AtYWRtaW4vdXNlci91c2VyLWVkaXQucGhwIjtzOjM2OiIyYTdhNzVhMzYzYjBmODhmMGI2ZDA5NGE5MWVmNjVlYU8yNjgiO3M6MTk6Ii93cC1hZG1pbi91c2Vycy5waHAiO3M6Mzg6ImVmYjI3MjEyZmQ1YmI4NDA3MWEzMzA2NmIzM2M=OGFhTzE4MzA=IjtzOjIxOiIvd3AtYWRtaW4vd2lkZ2V=cy5waHAiO3M6Mzg6IjRlNWNlMGFlOWRkOWEzZWRmNTA4ZDBiMTU5MTk2YmNjTzE4MTc1IjtzOjE5OiIvd3AtYmxvZy1oZWFkZXIucGhwIjtzOjM2OiJlZGFkNzQ2MTRkNmQzZmEyMjUyYzNkNzRmZjAzN2FjN=8zNjQiO3M6MjE6Ii93cC1jb21tZW5=cy1wb3N=LnBocCI7czozNzoiZTU=Y2FlNzBiNzI1MmMzMmMxZjljMGM4YzFhN2QxYTRPMTYyNyI7czoxMjoiL3dwLWNyb24ucGhwIjtzOjM3OiJmMjgyNDJmNTc2NmQ2NTI1Yjk=OWYzNzY4MTMyMzZkM=8zMjg2IjtzOjI2OiIvd3AtaW5jbHVkZXMvYWRtaW4tYmFyLnBocCI7czozODoiNTBkN2I2NGE2YmQ3MzU1MGU4NDUyOWMxOGM4ZDJmZDFPMjcyNTQiO3M6MjQ6Ii93cC1pbmNsdWRlcy9hdG9tbGliLnBocCI7czozODoiODNjZjcwN2I=MTc4NTc1YWJiY2RmNjZkNWU2NGFkMmFPMTEzNTYiO3M6MzI6Ii93cC1pbmNsdWRlcy9hdXRob3ItdGVtcGxhdGUucGhwIjtzOjM4OiIxYTM3OWUzZjNjNzZkMjkzNjkyOWNiZjBjNDdhODQ4Mk8xNTUyMyI7czozNDoiL3dwLWluY2x1ZGVzL2Jvb2ttYXJrLXRlbXBsYXRlLnBocCI7czozODoiYjQ2NzViNmM2NzUwMDQwOThiYTA4YzM1MzUyMmVhODFPMTE2OTkiO3M6MjU6Ii93cC1pbmNsdWRlcy9ib29rbWFyay5waHAiO3M6Mzg6IjY5OTYyMTM1NGExZTZjMTkwYjI=MjhkMGMyNTQwYmNkTzEzNjY=IjtzOjIyOiIvd3AtaW5jbHVkZXMvY2FjaGUucGhwIjtzOjM4OiI5MTNkNWRmMGFlODJiZjcxYjgwZGFlM2EyMWQ3MTJjNk8yMjA1OCI7czoyNjoiL3dwLWluY2x1ZGVzL2Nhbm9uaWNhbC5waHAiO3M6Mzg6IjI=MjQ1YTMzMTcwYWI3ODYyMmNmNmJhOWNlYjU1YTllTzI2OTAyIjtzOjI5OiIvd3AtaW5jbHVkZXMvY2FwYWJpbGl=aWVzLnBocCI7czozODoiMzk3ZmUyODAzYjM2ZTE5MmZkZTU5MWNjNzUxY2VhYjBPMjM2MDEiO3M6MzQ6Ii93cC1pbmNsdWRlcy9jYXRlZ29yeS1=ZW1wbGF=ZS5waHAiO3M6Mzg6ImRlYWQ3YjgzMmM3N2ViYmI5NDhjYTcyMjczNjJlZDJkTzQ4NDkzIjtzOjI1OiIvd3AtaW5jbHVkZXMvY2F=ZWdvcnkucGhwIjtzOjM4OiI2NWY=NDU2ZGI=OThjNzc4NGY1ZTMxYzg3ZjkwMWM2YU8xMTk5NSI7czozOToiL3dwLWluY2x1ZGVzL2NlcnRpZmljYXRlcy9jYS1idW5kbGUuY3J=IjtzOjM5OiJkZDFjN2JkZWJkZmM=MTFlYjhhMzM2ZTNkNzU4NjkyY=8yNzk1NjQiO3M6Mjc6Ii93cC1pbmNsdWRlcy9jbGFzcy1mZWVkLnBocCI7czozNjoiY2MyOTI=NmJhNmJmMzM1YzIwYTIxMmIzZjczMjQ1YjZPNTIyIjtzOjI3OiIvd3AtaW5jbHVkZXMvY2xhc3MtaHR=cC5waHAiO3M6Mzg6ImIxYzUzODM3YjIzNWJmNzEwOTJhMTViZTE5ZTIwODIxTzM1NzQ4IjtzOjI2OiIvd3AtaW5jbHVkZXMvY2xhc3MtSVhSLnBocCI7czozNzoiMzJhYzc2YmVhMjMwNzAyMjg1MmIyZjdhNjJjNjBjMmJPMjU3MyI7czoyNzoiL3dwLWluY2x1ZGVzL2NsYXNzLWpzb24ucGhwIjtzOjM4OiI4MDhhNDI3YmEwNzY=M2Q=ZGVhZjRkZmRjZjQxOGU2ZE8=MDQ3MiI7czoyOToiL3dwLWluY2x1ZGVzL2NsYXNzLW9lbWJlZC5waHAiO3M6Mzg6IjNjNWE4ZWVhMDAwNmU=Y2FjMWEwMGUwODU4OTk4ZDY1TzI5MDQxIjtzOjI5OiIvd3AtaW5jbHVkZXMvY2xhc3MtcGhwYXNzLnBocCI7czozNzoiMDMxOTFhMjEwY2NiZWE1NGNiMDdkZWRmZWRiN2NjNDJPNzMxNyI7czozMjoiL3dwLWluY2x1ZGVzL2NsYXNzLXBocG1haWxlci5waHAiO3M6Mzk6IjNlZmY5ZWQ=YjZjYWRmOTkwYjRmMjM4ZWQ5MWM1YWRlTzE=Njc4NCI7czoyNzoiL3dwLWluY2x1ZGVzL2NsYXNzLXBvcDMucGhwIjtzOjM4OiIxNTRiNTQ1MWM4YTkzYTRmMjFhNzQwNTRiZTk2MWQ3OU8yMDkxOSI7czozMToiL3dwLWluY2x1ZGVzL2NsYXNzLXJlcXVlc3RzLnBocCI7czozODoiMzk2NWFjYTExODFiMmZiNmVjNzU2MTdhYjRkNDIyM2NPMjk3OTAiO3M6MzI6Ii93cC1pbmNsdWRlcy9jbGFzcy1zaW1wbGVwaWUucGhwIjtzOjM4OiIwZGJlZjM5NGE5MTEyN2YwNjhhYzhmZGQ1ODdkNDg5NU84OTI2NCI7czoyNzoiL3dwLWluY2x1ZGVzL2NsYXNzLXNtdHAucGhwIjtzOjM4OiIxMmM2MmIyMjA3NWEzYzRiNzRlYmM4YWIzYTk4ZDI5NU8zOTQ3OCI7czoyOToiL3dwLWluY2x1ZGVzL2NsYXNzLXNub29weS5waHAiO3M6Mzg6IjczYjA1Y2RlYzU4NTlmZjZlZGNmYmNkMjJlYmQwOTYwTzM3Nzg1IjtzOjQ3OiIvd3AtaW5jbHVkZXMvY2xhc3Mtd2Fsa2VyLWNhdGVnb3J5LWRyb3Bkb3duLnBocCI7czozNzoiMDk5MWRmYjZlNmZmNzk3Njg=ZGQyNTYwMmNhZGM5NmRPMjE1NiI7czozODoiL3dwLWluY2x1ZGVzL2NsYXNzLXdhbGtlci1jYXRlZ29yeS5waHAiO3M6Mzc6IjM5NWMzM2ZlNjU=NDdiM2ExODcyYTA4N2Y2MGUzZDRhTzY3NTMiO3M6Mzc6Ii93cC1pbmNsdWRlcy9jbGFzcy13YWxrZXItY29tbWVudC5waHAiO3M6Mzg6Ijk1MmYwNzI4NjM5MDQxNTE1YzFiOGY4OGY3ZWE1MzE2TzExMzcwIjtzOjM4OiIvd3AtaW5jbHVkZXMvY2xhc3Mtd2Fsa2VyLW5hdi1tZW51LnBocCI7czozNzoiMTUwMWVlNGVlNTcxNWIzYjhiZWI5ZWU5NjQ5ODEwM2FPNzg2MCI7czo=MzoiL3dwLWluY2x1ZGVzL2NsYXNzLXdhbGtlci1wYWdlLWRyb3Bkb3duLnBocCI7czozNzoiNDcwMWJjN2M=NmUwOTk3OWZhODIwODI5NTdiYWI=ZjRPMjMzNiI7czozNDoiL3dwLWluY2x1ZGVzL2NsYXNzLXdhbGtlci1wYWdlLnBocCI7czozNzoiMDRiM2VkNGI2YzlhZjliMmY4NGU2MGUyNzdkZjU=NjhPNTgyMSI7czozNToiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLWFkbWluLWJhci5waHAiO3M6Mzg6IjM5YzlkZmQ=ODZiOGYxZDhkMDk=NjhjZjA4NTdiODljTzE2ODIxIjtzOjM5OiIvd3AtaW5jbHVkZXMvY2xhc3Mtd3AtYWpheC1yZXNwb25zZS5waHAiO3M6Mzc6IjIxNWExNjlkMTQ2YjlkODk=ZjY3ODdhNGY3MTc3ZGZlTzUwNDMiO3M6Mzk6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1jb21tZW5=LXF1ZXJ5LnBocCI7czozODoiYTIwMWY1NzhjZTMwOGY1YTE2MTQ4MjhjNDcwYzE5NzRPNDIzNTMiO3M6MzM6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1jb21tZW5=LnBocCI7czozNzoiMmM2N2M1ZDU=NmQ3YzQzYjljMWI2MDQyNjc5YThjYjJPOTQzOSI7czo=MzoiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLWN1c3RvbWl6ZS1jb25=cm9sLnBocCI7czozODoiNjU4MmU5YmU5YTFhMjk1ZDNjODJmMGUxOWY=ZmNjYjBPMjIwMzIiO3M6NDM6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1jdXN=b21pemUtbWFuYWdlci5waHAiO3M6Mzk6ImNhYWEyNTM2NzIxMGNiZThjZmEwMmIxNzU2YWMwODU2TzE=MjgxNCI7czo=NToiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLWN1c3RvbWl6ZS1uYXYtbWVudXMucGhwIjtzOjM4OiIxMjRjZjU=MzQ4OTQ1NDMyZmYwZGM=MGU5NTdhZTZiZE8=OTYxMSI7czo=MToiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLWN1c3RvbWl6ZS1wYW5lbC5waHAiO3M6Mzc6ImYxOGYzMTViODFkOTJjYjY1M2E4MmQ5MDJlNDJkZWU=Tzk2MDMiO3M6NDM6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1jdXN=b21pemUtc2VjdGlvbi5waHAiO3M6Mzg6ImU3NmZhODQ4NGZjMTIwMTE5ZjM5MmQzOTdmNjNhMDgxTzEwMTY2IjtzOjQzOiIvd3AtaW5jbHVkZXMvY2xhc3Mtd3AtY3VzdG9taXplLXNldHRpbmcucGhwIjtzOjM4OiI1ZGU3MjE1OGZlYTIyZDZiYjEzOTIyY2RkOWMzOTBmOU8yNzYwNCI7czo=MzoiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLWN1c3RvbWl6ZS13aWRnZXRzLnBocCI7czozODoiNDhhMTMxYzhhNDFmMDEyNDVlMTFhNjlhYWY3ZjcwYTNPNjUyMzYiO3M6MzY6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1kZXBlbmRlbmN5LnBocCI7czozNzoiMWQwOTk2NWNhNmI4ODI=ZDQ4NDZiNjNmNDY3NDllOWJPMTY4MyI7czozMjoiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLWVkaXRvci5waHAiO3M6Mzg6ImFjMDJiMDA5YjhmODZiZWEwNTFhYTFhM2ZhZGQyMzFiTzU=MDY2IjtzOjMxOiIvd3AtaW5jbHVkZXMvY2xhc3Mtd3AtZW1iZWQucGhwIjtzOjM4OiI1Y2ZhZWIyOTYzZTQ4ZDYyOTJlMDE3Mjc2ZTA=ZTRhY=8xMjA4NSI7czozMToiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLWVycm9yLnBocCI7czozNzoiMzFjYjBiNTRlNTI4MzA5YmQ4ZTc1Nzk4MTQ4YTM4MDZPNDY2NCI7czo=NjoiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLWZlZWQtY2FjaGUtdHJhbnNpZW5=LnBocCI7czozNzoiYWFmNzJkMzNmM2NkMWZjN2FiYTFiZDk1YTliMDExMjJPMjcwOCI7czozNjoiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLWZlZWQtY2FjaGUucGhwIjtzOjM2OiJhZDYyOTMwNGVlNTYxYWQ1MTY=MjNkZTQ3OGZkM2RhYk83NjQiO3M6MzA6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1ob29rLnBocCI7czozODoiZmFmYjhjZTNjMTQ5OThlYmUwMGJjMDhjOWEyZTMxMzhPMTQ=NjAiO3M6Mzc6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1odHRwLWNvb2tpZS5waHAiO3M6Mzc6ImRlZjE4N2JmNjU5ZWVlMmVhOTczZmFjYTg4ZWQ=NmQ4TzY1NTEiO3M6MzU6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1odHRwLWN1cmwucGhwIjtzOjM4OiJlNDEwNTFhZGMwNDdjMTIzNGE4OTUyYzM5OTFjNDFlYU8xMTczMSI7czozOToiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLWh=dHAtZW5jb2RpbmcucGhwIjtzOjM3OiI2YmQ2MTA2Yjk3ZTY2MmVhMzdlNTY4ZGE1ZTIzM2NjME82NDQ=IjtzOjQxOiIvd3AtaW5jbHVkZXMvY2xhc3Mtd3AtaHR=cC1peHItY2xpZW5=LnBocCI7czozNzoiYzFkNWM2M2YwYzZmNjE1YWQ4M2I2Y2ZlOTZiZDExZWNPMzI1MCI7czozNjoiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLWh=dHAtcHJveHkucGhwIjtzOjM3OiJjMDNkODk5YWJhZTc=ZDFhN2JhMzM4Mjk3NjA1YmIxY=81OTU3IjtzOjQ1OiIvd3AtaW5jbHVkZXMvY2xhc3Mtd3AtaHR=cC1yZXF1ZXN=cy1ob29rcy5waHAiO3M6Mzc6IjZmMWNkYTlmMTlmOTA4YTRkODQ=MGE=NjA1N2YyZDhjTzE4ODciO3M6NDg6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1odHRwLXJlcXVlc3RzLXJlc3BvbnNlLnBocCI7czozNzoiNzNlYTdiMmM2OWQzN2IzOWE1Y2FhZmM=N2FjZjI2ODJPNDUyNiI7czozOToiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLWh=dHAtcmVzcG9uc2UucGhwIjtzOjM3OiJjYjE=NWY=ZjAzNzdmNjA5MGFlYzQyM2QzYzExMWI=NU8zMDk=IjtzOjM4OiIvd3AtaW5jbHVkZXMvY2xhc3Mtd3AtaHR=cC1zdHJlYW1zLnBocCI7czozODoiZGFiYTVmNWU2Y2Y2NjVlZDMxMTA5NjYxYjNkNzk1ZThPMTQ5NDgiO3M6NDE6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1pbWFnZS1lZGl=b3ItZ2QucGhwIjtzOjM4OiI5M2IxYTBhMTEwY2VhYmZhMGVkZWE4MDQzNjQwYWI1ME8xMzE3OSI7czo=NjoiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLWltYWdlLWVkaXRvci1pbWFnaWNrLnBocCI7czozODoiYjdmY2E4YzY4ODM2ZTQzMDczZjg3OTRkNmNiYTcyYTRPMjE3MDkiO3M6Mzg6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1pbWFnZS1lZGl=b3IucGhwIjtzOjM4OiJjZWVkMjYxNWY=NGQ1OTdhOGYyYzczM2RkNmEzYTQ2Zk8xMjAxOSI7czozNToiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLWxpc3QtdXRpbC5waHAiO3M6Mzc6ImJlMWEzOWMxZjU=NTFiZTBiMTk2OWJlNDk5OWM1YmEwTzY=ODciO3M6NDE6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1sb2NhbGUtc3dpdGNoZXIucGhwIjtzOjM3OiJlY2EwMmM5NjNkMzA=ODFmYzExNWMzMTM1YWIwYzE4Mk81MTM5IjtzOjMyOiIvd3AtaW5jbHVkZXMvY2xhc3Mtd3AtbG9jYWxlLnBocCI7czozODoiZDg2YmFiNjhkNGQ3Nzg3MWZmM2ZkYzNiOGE2NTBmNDJPMTQ3MzkiO3M6NDE6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1tYXRjaGVzbWFwcmVnZXgucGhwIjtzOjM3OiI1OTQzZDVhNGYyM2M2MmVkZTkzOTY2ZDQ4ZTY5NDY2NU8xOTEzIjtzOjM2OiIvd3AtaW5jbHVkZXMvY2xhc3Mtd3AtbWV=YS1xdWVyeS5waHAiO3M6Mzg6IjFlODQwNGU5Y2UzNmFjMjE5N2RhYWRlZTdkYzQxODcwTzIyNjk1IjtzOjQ1OiIvd3AtaW5jbHVkZXMvY2xhc3Mtd3AtbWV=YWRhdGEtbGF6eWxvYWRlci5waHAiO3M6Mzc6ImI3Y2JmOTkxMWQ=NjkwYTEyYzliMzFmN2NjZWY4MWE1TzU=OTIiO3M6Mzk6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1uZXR3b3JrLXF1ZXJ5LnBocCI7czozODoiN2NkYzc4NDg5M2RhM2ZlOTIzOGIzODczNTI5OTdhZWVPMTY5OTgiO3M6MzM6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1uZXR3b3JrLnBocCI7czozODoiY2MzZWQxZDJlMmM=N2ZiOWM=ZWZhODQ3NjhjMmRhNzVPMTA3MDMiO3M6NDM6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1vZW1iZWQtY29udHJvbGxlci5waHAiO3M6Mzc6IjM5M2U5ZWMwZWQ=MDRmMzgxOTQzYzJmMjZkNzZlMzQ1TzIwODciO3M6MzU6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1wb3N=LXR5cGUucGhwIjtzOjM4OiIzYzgzYzc3ODc=Y2E4YmE2Yzc2ZjVmZjk=M2I5ZDVjNE8xODIwMSI7czozMDoiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLXBvc3QucGhwIjtzOjM3OiIyNzczNzY3N2U2YzRmN2I2ZTNiZmMxMzI2NGVkMzUzZk81ODQ4IjtzOjMxOiIvd3AtaW5jbHVkZXMvY2xhc3Mtd3AtcXVlcnkucGhwIjtzOjM5OiJjNmZkYWNjMjUzYmEzYzZhZWVjMjZjNzgwYWY3MWFkOE8xMjIzNjgiO3M6MzM6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1yZXdyaXRlLnBocCI7czozODoiNzBhZjU2ZjI4MDA=ZWQ2MmYzMzMzYjQ3NmM=MjQwM2FPNjAxMjUiO3M6MzA6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1yb2xlLnBocCI7czozNzoiNWU2ZDY5MDIwYmQxMmFlYjg3NGZmNjRlNzRiMjc5MGNPMjcyOCI7czozMToiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLXJvbGVzLnBocCI7czozNzoiNTFlMTFkOTliMTRhM2I4NWMyZGIxZWU4NWU1NGJlNzVPNjU3NCI7czo=MDoiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLXNlc3Npb24tdG9rZW5zLnBocCI7czozNzoiNjY4NDQyYzhiNTgzMzNmM2E5NDA3ODNiY2Y4OGMwMWZPNzUxMSI7czo=MDoiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLXNpbXBsZXBpZS1maWxlLnBocCI7czozNzoiYzdlYTY4N2Q3Njk4MDVjMDRmYzY4YmYyMzc2YjhhNWZPMjI5MSI7czo=OToiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLXNpbXBsZXBpZS1zYW5pdGl6ZS1rc2VzLnBocCI7czozNzoiNjM1NTFjNWU1YTgwYjY5NDVkNjE=YzFiYzQ5OTQ5YThPMTc5MyI7czozNjoiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLXNpdGUtcXVlcnkucGhwIjtzOjM4OiI3NDgwNWVkNzUwMjY=Njk=ZDA1ZjQ3ZTdlMzE1OWRlZE8yMTk4NyI7czozMDoiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLXNpdGUucGhwIjtzOjM3OiJkYmY1YTc2ZDAyMmRkY2RhMDA=NDUyYmYyNDE5ZGE2Zk83NTcyIjtzOjM1OiIvd3AtaW5jbHVkZXMvY2xhc3Mtd3AtdGF4LXF1ZXJ5LnBocCI7czozODoiZGE=MmUwYWQxM2UxNTdjNTY1ZTAyMzI4MzcwNWEzMzlPMTk2NzciO3M6MzQ6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1=YXhvbm9teS5waHAiO3M6Mzc6IjlmMmZmOWE5ZmUyNjdkZjFmZDJlYTQ4MjFiMzA4NTJkTzk3MDciO3M6MzY6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1=ZXJtLXF1ZXJ5LnBocCI7czozODoiNjkwNTIwYTFjZDcyYTY1ZDI4MTM1Y2I=M2RhODNjNjVPMzI3NDQiO3M6MzA6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1=ZXJtLnBocCI7czozNzoiNWJhNzBiYWRkMDEyN2MxNGRmY2RlZWQ2NzM5NmFkNThPNTQxNiI7czo1MToiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLXRleHQtZGlmZi1yZW5kZXJlci1pbmxpbmUucGhwIjtzOjM2OiI5OTQ=ODZhOTkyNTViNWIxMTBkOTU1MWJiZjc2M2ZjN=83MTIiO3M6NTA6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1=ZXh=LWRpZmYtcmVuZGVyZXItdGFibGUucGhwIjtzOjM4OiIzNWY3ZDAzMzk5MjdhNzBiNzA2NDc5YWI1OThmMGFiOU8xNDA2NiI7czozMToiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLXRoZW1lLnBocCI7czozODoiMTIwMTI=Mjc4NjJiNjVkOTQxODUwNTBjZTlkMWM2ZWFPNDczMjMiO3M6NTA6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC11c2VyLW1ldGEtc2Vzc2lvbi1=b2tlbnMucGhwIjtzOjM3OiJhYWY5OTZlNGQ3ODZjODAyOWZhYzNmMTlhZGRlMTg=OU8zMDY3IjtzOjM2OiIvd3AtaW5jbHVkZXMvY2xhc3Mtd3AtdXNlci1xdWVyeS5waHAiO3M6Mzg6ImE4YWNmMmM4OWVkYjliYTVkNmViOTEyYjdjNGI=MTFjTzI5ODY4IjtzOjMwOiIvd3AtaW5jbHVkZXMvY2xhc3Mtd3AtdXNlci5waHAiO3M6Mzg6ImFhNWNmZGE4NzY4MzYzYzI4YWUyYjcxZWIyMzc3NWMyTzE5NjE=IjtzOjMyOiIvd3AtaW5jbHVkZXMvY2xhc3Mtd3Atd2Fsa2VyLnBocCI7czozODoiM2E1NzczOGZjNzY4MTg2ZjhjZGUzN2UxMmRiZWNjNjFPMTIzNjgiO3M6NDA6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC13aWRnZXQtZmFjdG9yeS5waHAiO3M6Mzc6ImYyYTY3NWJiN2I=ZGZjZDJhNDgzMzM1YjAzZDk4OWRlTzM5MDAiO3M6MzI6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC13aWRnZXQucGhwIjtzOjM4OiJhYjBiNzY1YTM5YWY2NDRmNDFkN2M3NzBkOGM4MzVmY=8xODE4OSI7czozOToiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLXhtbHJwYy1zZXJ2ZXIucGhwIjtzOjM5OiJiM2IzZDgwNWU=NGNjMDE5ZmUzOWNjODA=YWFjYTk1Zk8xOTkzMTIiO3M6MjU6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC5waHAiO3M6Mzg6IjFhNGZmYTMzMWE5YjhiNjc4NDkwMjE3YzlmNTM4M2RjTzI=MTM2IjtzOjM4OiIvd3AtaW5jbHVkZXMvY2xhc3Mud3AtZGVwZW5kZW5jaWVzLnBocCI7czozODoiNTg1Nzc2MWJkZWRhOWZjZmExYmJkYTkzNGE3YWZiYmJPMTE1NDciO3M6MzM6Ii93cC1pbmNsdWRlcy9jbGFzcy53cC1zY3JpcHRzLnBocCI7czozODoiOWFlM2Y2MzRkMWVmYjJmOTU4Mjg=OTEyYmM3YzViOTdPMTQ2ODEiO3M6MzI6Ii93cC1pbmNsdWRlcy9jbGFzcy53cC1zdHlsZXMucGhwIjtzOjM4OiI4MjU1ZGUzYTMwMGFmMTUyYzc4NDY4NjExZGJmMzYwNE8xMDE3NSI7czozMzoiL3dwLWluY2x1ZGVzL2NvbW1lbnQtdGVtcGxhdGUucGhwIjtzOjM4OiJlM2U5ZjA3MmE1NzQ=NmVlOGEzZWI=Y2ViNTk4NmQ2Mk84NzIzNCI7czoyNDoiL3dwLWluY2x1ZGVzL2NvbW1lbnQucGhwIjtzOjM5OiJhYTE5NWZiZDQ3YTI=YjZiZTg=ZWQ=MGI4MmRjZjU2M=8xMDIwMDIiO3M6MjM6Ii93cC1pbmNsdWRlcy9jb21wYXQucGhwIjtzOjM4OiJkODg4MTE1ZTEwMjQwNzcwYjk1ZjZiZTFhMzQ1OGIwMU8xNzE5NSI7czoyMToiL3dwLWluY2x1ZGVzL2Nyb24ucGhwIjtzOjM4OiI4NjQ4YTY=YzMxZDNlMmQ2NzI=MjI=NzcwZjYyOGU1Nk8xNTk=MSI7czozNDoiL3dwLWluY2x1ZGVzL2Nzcy9hZG1pbi1iYXItcnRsLmNzcyI7czozODoiNTBkY2I3NjI2NDdhNDkyZTQ3NjllYTA5NDdiNTAyNDhPMjU2NTkiO3M6Mzg6Ii93cC1pbmNsdWRlcy9jc3MvYWRtaW4tYmFyLXJ=bC5taW4uY3NzIjtzOjM4OiIxZmRmOWZlYWQ3NTdjZGE=NmY1M2YzYjc5YjU1ZmU=N=8yMDU5MSI7czozMDoiL3dwLWluY2x1ZGVzL2Nzcy9hZG1pbi1iYXIuY3NzIjtzOjM4OiJhMmMwNWFlYjFjMTFmMDZhOGIzYzFiYzg4ODg3MTRmOU8yNTY1MyI7czozNDoiL3dwLWluY2x1ZGVzL2Nzcy9hZG1pbi1iYXIubWluLmNzcyI7czozODoiMTgxYTBkZTRmMWM=MjUyYWViYjQ3ZjIyMDRmMGMxMTlPMjA1ODAiO3M6MzI6Ii93cC1pbmNsdWRlcy9jc3MvYnV=dG9ucy1ydGwuY3NzIjtzOjM3OiIxOGNhYzYwZDVkMzFlMzdjMzA3MDgxNzUwNGM2MmFmM=85NzA4IjtzOjM2OiIvd3AtaW5jbHVkZXMvY3NzL2J1dHRvbnMtcnRsLm1pbi5jc3MiO3M6Mzc6IjA=MjAzZDIxYmNjMjBmM2MzMDkxNDZlMjJkYjkyMzMyTzYzNjAiO3M6Mjg6Ii93cC1pbmNsdWRlcy9jc3MvYnV=dG9ucy5jc3MiO3M6Mzc6IjVlNGIyZjFkNDIzYzczZTg2Y2M4NzA1NDZhMzg=M2EzTzk3MDkiO3M6MzI6Ii93cC1pbmNsdWRlcy9jc3MvYnV=dG9ucy5taW4uY3NzIjtzOjM3OiJmYTAzNTE2NjYzYjEwZmI5NjU=YWY=ZTY4MGNjYzQyYk82MzYxIjtzOjQyOiIvd3AtaW5jbHVkZXMvY3NzL2N1c3RvbWl6ZS1wcmV2aWV3LXJ=bC5jc3MiO3M6Mzc6IjUxNDk1MmI4MWM2ZGJlZjE5YjYyYjA=MGU3NjQ4NGY5TzY=OTciO3M6NDY6Ii93cC1pbmNsdWRlcy9jc3MvY3VzdG9taXplLXByZXZpZXctcnRsLm1pbi5jc3MiO3M6Mzc6ImNjY2I5MWE3OWJkMWExYjE=YmRhZDc2OWQzYjA=ZmYyTzUxODgiO3M6Mzg6Ii93cC1pbmNsdWRlcy9jc3MvY3VzdG9taXplLXByZXZpZXcuY3NzIjtzOjM3OiJhNWEwNTJjODg2OWI5ZjMwMjQwNWIwNjliMWFhMDYxM=82NDkyIjtzOjQyOiIvd3AtaW5jbHVkZXMvY3NzL2N1c3RvbWl6ZS1wcmV2aWV3Lm1pbi5jc3MiO3M6Mzc6IjY5YmZjODhlM2YzZDQ2ZjExNmRhODE4NTg4ZTFjOTU4TzUxODMiO3M6MzA6Ii93cC1pbmNsdWRlcy9jc3MvZGFzaGljb25zLmNzcyI7czozODoiY2JkNzgzMDNmMGFiOTliY2Y=NDcwNTc1YjBmOGE3ZWFPNDg4NTUiO3M6MzQ6Ii93cC1pbmNsdWRlcy9jc3MvZGFzaGljb25zLm1pbi5jc3MiO3M6Mzg6ImNmM2MwZThmMjZmZTIwMjVhMGYyMjEzOGZmZTMwZDUzTzQ2MzY=IjtzOjMxOiIvd3AtaW5jbHVkZXMvY3NzL2VkaXRvci1ydGwuY3NzIjtzOjM4OiI2NjkyMTExNGI4M2EyZTczN2U2OWYyODQ3YjRjOWNmM=8zNDIxMyI7czozNToiL3dwLWluY2x1ZGVzL2Nzcy9lZGl=b3ItcnRsLm1pbi5jc3MiO3M6Mzg6IjlmZTNlNmJhN2ViODQ5ZjgzZjk5ZDRjMTU3YTkzNTFmTzI4MTE3IjtzOjI3OiIvd3AtaW5jbHVkZXMvY3NzL2VkaXRvci5jc3MiO3M6Mzg6ImU5N2I=MzlkOWYwYzYzOGU4OGQ4YTRjYzIxODIzMDI1TzM=MjA4IjtzOjMxOiIvd3AtaW5jbHVkZXMvY3NzL2VkaXRvci5taW4uY3NzIjtzOjM4OiJkNWIwM2Y1Y2ExMzYwNTM3OWI2YzU2NWViZmE1NTU3ME8yODExMSI7czo=MToiL3dwLWluY2x1ZGVzL2Nzcy9qcXVlcnktdWktZGlhbG9nLXJ=bC5jc3MiO3M6Mzc6IjEwOTM5ZmY2YTM2MjlmYmE4MGUzMGUyZTdjNTI2OTAxTzYyMzAiO3M6NDU6Ii93cC1pbmNsdWRlcy9jc3MvanF1ZXJ5LXVpLWRpYWxvZy1ydGwubWluLmNzcyI7czozNzoiZGUxYzJlODQxZDUyOTkxY2M3MzhmNGIwMjlhNGYyNDlPNDc5OSI7czozNzoiL3dwLWluY2x1ZGVzL2Nzcy9qcXVlcnktdWktZGlhbG9nLmNzcyI7czozNzoiYTAzNDdiYTY=NzZhYzZiNjQ2ZDE=NTY5Nzk3MGU4MWNPNjIyNiI7czo=MToiL3dwLWluY2x1ZGVzL2Nzcy9qcXVlcnktdWktZGlhbG9nLm1pbi5jc3MiO3M6Mzc6ImRhZTE4ODQ1Y2ZjM2MyMTFjNWM2ZGU5MjQwMWIyYWQ1TzQ3OTYiO3M6MzY6Ii93cC1pbmNsdWRlcy9jc3MvbWVkaWEtdmlld3MtcnRsLmNzcyI7czozODoiMGY1YjRkYzY=OWY1ZDIyMTgwNjdhOGMzN2U3YzFiYWJPNTAwNjkiO3M6NDA6Ii93cC1pbmNsdWRlcy9jc3MvbWVkaWEtdmlld3MtcnRsLm1pbi5jc3MiO3M6Mzg6IjQ3MzE=MzQ2NzA5MzIyOGQ4MzRkZjY2MTMwOTA=NTU4TzQxODI=IjtzOjMyOiIvd3AtaW5jbHVkZXMvY3NzL21lZGlhLXZpZXdzLmNzcyI7czozODoiMjUxZGRkNzA1NDMzYzIwN2RhYzRkYzkwYjAxYWJiZTNPNTAwNzEiO3M6MzY6Ii93cC1pbmNsdWRlcy9jc3MvbWVkaWEtdmlld3MubWluLmNzcyI7czozODoiMmExYWIzODYyOWQ2ZjEwMTc4YTBkMjAwZTdlZGFhZDFPNDE4MjYiO3M6Mzg6Ii93cC1pbmNsdWRlcy9jc3Mvd3AtYXV=aC1jaGVjay1ydGwuY3NzIjtzOjM3OiJjY2VlZmE5NjljYmZmNGJjYWNmYTNhMzlmZjQ4MjE=Y=8yNTk=IjtzOjQyOiIvd3AtaW5jbHVkZXMvY3NzL3dwLWF1dGgtY2hlY2stcnRsLm1pbi5jc3MiO3M6Mzc6IjViYmU=YzJlY2I1NDE5NTJjYTQwODY4M2U3OWZiYjE=TzE5NzYiO3M6MzQ6Ii93cC1pbmNsdWRlcy9jc3Mvd3AtYXV=aC1jaGVjay5jc3MiO3M6Mzc6Ijg1NzUyY2E4Yzg5OWFlZTMyOTdlODc=NzlmZDUxOTk=TzI1OTIiO3M6Mzg6Ii93cC1pbmNsdWRlcy9jc3Mvd3AtYXV=aC1jaGVjay5taW4uY3NzIjtzOjM3OiJkMWY5NGY5YTkzZjgzYjdkYzRkOTI=ZjA=ODQyZDI5NE8xOTc=IjtzOjQxOiIvd3AtaW5jbHVkZXMvY3NzL3dwLWVtYmVkLXRlbXBsYXRlLWllLmNzcyI7czozNzoiZWViNzI5MzY5ZWYzMDlkODllZDBiYzcxMjBhYWNhZGZPMTQ3NyI7czo=NToiL3dwLWluY2x1ZGVzL2Nzcy93cC1lbWJlZC1=ZW1wbGF=ZS1pZS5taW4uY3NzIjtzOjM3OiIxYWVjM2NhYzc3NTZlOWI=MDViY2JmMGFkMzljNzc3Mk8xNDM4IjtzOjM4OiIvd3AtaW5jbHVkZXMvY3NzL3dwLWVtYmVkLXRlbXBsYXRlLmNzcyI7czozNzoiYzAxOTUyODA=Y2Q3MTdjOTZhZmUxMGU5Njg5YmJkMzJPODMzMiI7czo=MjoiL3dwLWluY2x1ZGVzL2Nzcy93cC1lbWJlZC1=ZW1wbGF=ZS5taW4uY3NzIjtzOjM3OiI=MzMzODZkZTRhNjRiOWNhNmQ3NGUxNDc1NmJkYWZmNk83MjAwIjtzOjM1OiIvd3AtaW5jbHVkZXMvY3NzL3dwLXBvaW5=ZXItcnRsLmNzcyI7czozNzoiOGJiMGJlZjkwMzRjNTE=ZjExNGUwNWZmOWZjNjM4NDBPMzg3OCI7czozOToiL3dwLWluY2x1ZGVzL2Nzcy93cC1wb2ludGVyLXJ=bC5taW4uY3NzIjtzOjM3OiI=NTZlMTBmMjU2MWU2NWYyYjc2YzE5ODViNjU3ZWJkYk8zMDYzIjtzOjMxOiIvd3AtaW5jbHVkZXMvY3NzL3dwLXBvaW5=ZXIuY3NzIjtzOjM3OiI4MmVlYWU=YzY4Mjg4ZDI4Yzg4MDllZjlmYjFiYzNlYU8zODczIjtzOjM1OiIvd3AtaW5jbHVkZXMvY3NzL3dwLXBvaW5=ZXIubWluLmNzcyI7czozNzoiN2U5ZmQ3ODI2MDJlYWQwZGRkOTFlY2JlNjAwYmIwNzhPMzA1OCI7czo3MDoiL3dwLWluY2x1ZGVzL2N1c3RvbWl6ZS9jbGFzcy13cC1jdXN=b21pemUtYmFja2dyb3VuZC1pbWFnZS1jb25=cm9sLnBocCI7czozNzoiNzAwZmNmODdmYTE1MGYwNjFmOTA5ZGQxNzQ3Y2NlMzNPMTE3OCI7czo3MDoiL3dwLWluY2x1ZGVzL2N1c3RvbWl6ZS9jbGFzcy13cC1jdXN=b21pemUtYmFja2dyb3VuZC1pbWFnZS1zZXR=aW5nLnBocCI7czozNjoiMjlkOTQwODc3NDk=ZmU2YTEyMzIzM2I=MTNlMzlkNTdPNTA4IjtzOjczOiIvd3AtaW5jbHVkZXMvY3VzdG9taXplL2NsYXNzLXdwLWN1c3RvbWl6ZS1iYWNrZ3JvdW5kLXBvc2l=aW9uLWNvbnRyb2wucGhwIjtzOjM3OiIwYTVkOTMzMzNjNGMxMjI4YzliMGE4NzBlOGFhNDhmZk8yODY=IjtzOjU5OiIvd3AtaW5jbHVkZXMvY3VzdG9taXplL2NsYXNzLXdwLWN1c3RvbWl6ZS1jb2xvci1jb25=cm9sLnBocCI7czozNzoiN2VmNzAwMDAzOTEwZmQxYzI2OTU2Mzk3ODI3NTkzOTBPMjgyMiI7czo2NzoiL3dwLWluY2x1ZGVzL2N1c3RvbWl6ZS9jbGFzcy13cC1jdXN=b21pemUtY3JvcHBlZC1pbWFnZS1jb25=cm9sLnBocCI7czozNzoiMTg4ZTViNTcyNzIyZjE2NmVjZjY=OWRlOTlhOTlmNzRPMTU5MyI7czo2NDoiL3dwLWluY2x1ZGVzL2N1c3RvbWl6ZS9jbGFzcy13cC1jdXN=b21pemUtY3VzdG9tLWNzcy1zZXR=aW5nLnBocCI7czozODoiNDZmYWFkMDMxMjk1ZWNmYjAwNWFjY2VhYTY5NjY1MTZPMTA1NTgiO3M6NjA6Ii93cC1pbmNsdWRlcy9jdXN=b21pemUvY2xhc3Mtd3AtY3VzdG9taXplLWZpbHRlci1zZXR=aW5nLnBocCI7czozNjoiYzhjMjYwNTY3NmZkM2U=MWIzYTIyMGUyMjRiMTFmZjdPNjA3IjtzOjY2OiIvd3AtaW5jbHVkZXMvY3VzdG9taXplL2NsYXNzLXdwLWN1c3RvbWl6ZS1oZWFkZXItaW1hZ2UtY29udHJvbC5waHAiO3M6Mzc6IjJiZTMyZGIxYzVmZTY4ZDVmZGQ=ZDBiM2Q3YjlkMGY5TzcyMDUiO3M6NjY6Ii93cC1pbmNsdWRlcy9jdXN=b21pemUvY2xhc3Mtd3AtY3VzdG9taXplLWhlYWRlci1pbWFnZS1zZXR=aW5nLnBocCI7czozNzoiMzNhN2E2Y2YwYzcwZmNhYzE4MDI=N2M5NzM5MjMwYTRPMTU5MCI7czo1OToiL3dwLWluY2x1ZGVzL2N1c3RvbWl6ZS9jbGFzcy13cC1jdXN=b21pemUtaW1hZ2UtY29udHJvbC5waHAiO3M6Mzc6IjU1NjliNDE=NjgwZTJkYzljMDIwMWI4NGY2ZWU=YmYzTzE3MzciO3M6NTk6Ii93cC1pbmNsdWRlcy9jdXN=b21pemUvY2xhc3Mtd3AtY3VzdG9taXplLW1lZGlhLWNvbnRyb2wucGhwIjtzOjM3OiI3MmQ5NzQ5ZDZhMmI=OTcxMzhlZTg2MzZlMWYwOTA5ZE83NTAzIjtzOjcxOiIvd3AtaW5jbHVkZXMvY3VzdG9taXplL2NsYXNzLXdwLWN1c3RvbWl6ZS1uYXYtbWVudS1hdXRvLWFkZC1jb25=cm9sLnBocCI7czozNzoiMGFiM2I3OTBmNjVhNmRhYzY=ZDUzNWFlMzk4MTM5MzBPMTAwNSI7czo2MjoiL3dwLWluY2x1ZGVzL2N1c3RvbWl6ZS9jbGFzcy13cC1jdXN=b21pemUtbmF2LW1lbnUtY29udHJvbC5waHAiO3M6Mzc6IjE5YzRjNThlOTFjNmNlYmZmMDZjOWIzY2QxMzZjMjQ4TzI5MzkiO3M6Njc6Ii93cC1pbmNsdWRlcy9jdXN=b21pemUvY2xhc3Mtd3AtY3VzdG9taXplLW5hdi1tZW51LWl=ZW=tY29udHJvbC5waHAiO3M6Mzc6ImZiNmVkNTdmNjRjYTUwNTc1OWZmNWRkMDE5MWFkMzMyTzY1NDUiO3M6Njc6Ii93cC1pbmNsdWRlcy9jdXN=b21pemUvY2xhc3Mtd3AtY3VzdG9taXplLW5hdi1tZW51LWl=ZW=tc2V=dGluZy5waHAiO3M6Mzg6ImE3NGI2OTQ3NmRhZDUwMGM2YTgzNzdhMjY=MWEzZjhhTzI2OTQ=IjtzOjcxOiIvd3AtaW5jbHVkZXMvY3VzdG9taXplL2NsYXNzLXdwLWN1c3RvbWl6ZS1uYXYtbWVudS1sb2NhdGlvbi1jb25=cm9sLnBocCI7czozNzoiMjE5MzdhZTdhNmQ=NGU=ODZmM2IxNjI1YjFhOWViM2ZPMTg3OSI7czo2NzoiL3dwLWluY2x1ZGVzL2N1c3RvbWl6ZS9jbGFzcy13cC1jdXN=b21pemUtbmF2LW1lbnUtbmFtZS1jb25=cm9sLnBocCI7czozNjoiN2JlODYwZDk5NmQzNWY5MzM3NTRhODk=YzhhNTA4MzNPOTkzIjtzOjYyOiIvd3AtaW5jbHVkZXMvY3VzdG9taXplL2NsYXNzLXdwLWN1c3RvbWl6ZS1uYXYtbWVudS1zZWN=aW9uLnBocCI7czozNjoiODA1Y2MzOTM=MjcwMGQ2ODcxYzcyNzU=NjQ2ZmI3NDBPNzQ3IjtzOjYyOiIvd3AtaW5jbHVkZXMvY3VzdG9taXplL2NsYXNzLXdwLWN1c3RvbWl6ZS1uYXYtbWVudS1zZXR=aW5nLnBocCI7czozODoiNzhmZWJmNjhhMTBlM2ZjZmU5ZDdhNTNmNTEyNjE3OGZPMTkxNDUiO3M6NjE6Ii93cC1pbmNsdWRlcy9jdXN=b21pemUvY2xhc3Mtd3AtY3VzdG9taXplLW5hdi1tZW51cy1wYW5lbC5waHAiO3M6Mzc6IjExYmM5YTc1ZWMzYTUxMjY5MzgyODQ5ZmMyOTI1Mzg=TzI5MDQiO3M6NjI6Ii93cC1pbmNsdWRlcy9jdXN=b21pemUvY2xhc3Mtd3AtY3VzdG9taXplLW5ldy1tZW51LWNvbnRyb2wucGhwIjtzOjM2OiI1YjhiYzYyMTgyZjViNjQxNWJhYzBkMWQ1YTRjYjRjZE83MDgiO3M6NjI6Ii93cC1pbmNsdWRlcy9jdXN=b21pemUvY2xhc3Mtd3AtY3VzdG9taXplLW5ldy1tZW51LXNlY3Rpb24ucGhwIjtzOjM2OiJlOGQ=ZmM2NDQyM2I3Zjk1YzdhZTBhNGE4N2VkODg2ZE85NjUiO3M6NTM6Ii93cC1pbmNsdWRlcy9jdXN=b21pemUvY2xhc3Mtd3AtY3VzdG9taXplLXBhcnRpYWwucGhwIjtzOjM3OiIyNTg3NzdhMjU5OTBiOTI=MGNiYTkxMTAwYWUxZWI3NU85MTgwIjtzOjYzOiIvd3AtaW5jbHVkZXMvY3VzdG9taXplL2NsYXNzLXdwLWN1c3RvbWl6ZS1zZWxlY3RpdmUtcmVmcmVzaC5waHAiO3M6Mzg6IjkwYjlhZmMzM2I1NzZjODJjODA3N2RiZjJhMGQxZWQyTzEzNTIwIjtzOjYxOiIvd3AtaW5jbHVkZXMvY3VzdG9taXplL2NsYXNzLXdwLWN1c3RvbWl6ZS1zaWRlYmFyLXNlY3Rpb24ucGhwIjtzOjM3OiIyMTU=MmI2MzYxY2ViMjQ2YWZiOGE=YjFlY2M=ZDJlYk8xMTAzIjtzOjYzOiIvd3AtaW5jbHVkZXMvY3VzdG9taXplL2NsYXNzLXdwLWN1c3RvbWl6ZS1zaXRlLWljb24tY29udHJvbC5waHAiO3M6Mzc6ImRmODUwYjM=ZDY2NzQxZmZkNDVkYjljZTQ3YzAzY2UxTzMyNzgiO3M6NTk6Ii93cC1pbmNsdWRlcy9jdXN=b21pemUvY2xhc3Mtd3AtY3VzdG9taXplLXRoZW1lLWNvbnRyb2wucGhwIjtzOjM3OiI5MjI1ZmMxNDlmOWQ3NGE5YjI1ZmM5MGViMmMyZjJjME8zMDU1IjtzOjYwOiIvd3AtaW5jbHVkZXMvY3VzdG9taXplL2NsYXNzLXdwLWN1c3RvbWl6ZS1=aGVtZXMtc2VjdGlvbi5waHAiO3M6Mzc6IjJlZWYxNDFjYThhNjljZmZjOGQ1MWVlZTMxMjI=MTU2TzI4MDgiO3M6NjA6Ii93cC1pbmNsdWRlcy9jdXN=b21pemUvY2xhc3Mtd3AtY3VzdG9taXplLXVwbG9hZC1jb25=cm9sLnBocCI7czozNjoiNGFlYmE3ZDhjMzQ2ZjcxZTc5YzViZWE5NzI=MDkzN2JPOTc3IjtzOjY1OiIvd3AtaW5jbHVkZXMvY3VzdG9taXplL2NsYXNzLXdwLXdpZGdldC1hcmVhLWN1c3RvbWl6ZS1jb25=cm9sLnBocCI7czozNzoiZDk=MWZmOGVkMmNiMTAxMWUxMDJmNGY3ZGY=MzI5ZmZPMTgxMSI7czo2NToiL3dwLWluY2x1ZGVzL2N1c3RvbWl6ZS9jbGFzcy13cC13aWRnZXQtZm9ybS1jdXN=b21pemUtY29udHJvbC5waHAiO3M6Mzc6Ijg4N2ZkMDFiZDRlYmEyZDBlY2M=MTcwZDAwN2Q4OGE5TzE5NzMiO3M6MjE6Ii93cC1pbmNsdWRlcy9kYXRlLnBocCI7czozODoiMTIyMDQ4ODVlYzA=MDZjOWRlZGMzMzNkNzMxYTcyZTJPMzUzMzMiO3M6MzQ6Ii93cC1pbmNsdWRlcy9kZWZhdWx=LWNvbnN=YW5=cy5waHAiO3M6Mzc6IjRiZmYwYjk1NmYxMjY4ZTI5YmIxM2QzNzVmZGFmMDUzTzk=ODkiO3M6MzI6Ii93cC1pbmNsdWRlcy9kZWZhdWx=LWZpbHRlcnMucGhwIjtzOjM4OiI=NTQ5NzM3NTVkMWVmOTk4MjIzNmMwZTAwNDg4YjVmYU8yNTIyMCI7czozMjoiL3dwLWluY2x1ZGVzL2RlZmF1bHQtd2lkZ2V=cy5waHAiO3M6Mzc6IjEyYTk=ZjY5NTRiODMwZmMyYTAwZGE2OGZhMjk2N2JiTzE1MDQiO3M6Mjc6Ii93cC1pbmNsdWRlcy9kZXByZWNhdGVkLnBocCI7czozOToiZWE=YzE4YjAwNzJhNjY4ZDQ=ODk=OTU3NGRiMWI5NjVPMTExNDkzIjtzOjMxOiIvd3AtaW5jbHVkZXMvZW1iZWQtdGVtcGxhdGUucGhwIjtzOjM2OiI4ODBjMGYzZWJkZWY=NTU2NGE3YjNiMTUzNmZmMjEyYU8zNDQiO3M6MjI6Ii93cC1pbmNsdWRlcy9lbWJlZC5waHAiO3M6Mzg6ImFiYzJlNjcwY2Q=ZmY2MTVhMzkxYTFkNTA2ZTRiYmFiTzQzNjM4IjtzOjM1OiIvd3AtaW5jbHVkZXMvZmVlZC1hdG9tLWNvbW1lbnRzLnBocCI7czozNzoiMmVmYTkwZjU3MzA4ZWJjMGE=ZjZmOTUwNzUxNzkzZGNPNTM1MCI7czoyNjoiL3dwLWluY2x1ZGVzL2ZlZWQtYXRvbS5waHAiO3M6Mzc6ImRhYzEwMTAwMTRlMjJjN2QzNWIzN2RjMDQzN2VmY2UzTzMwODMiO3M6MjU6Ii93cC1pbmNsdWRlcy9mZWVkLXJkZi5waHAiO3M6Mzc6IjdjMTU5NzY=NjRmZTk4OWE2MTM2YmVhZWRkMjdkZTlhTzI2NzAiO3M6MjU6Ii93cC1pbmNsdWRlcy9mZWVkLXJzcy5waHAiO3M6Mzc6IjRkYzczM2Q3M2ZkOWViYzgxMGEwNjdjMTJlMGU=MjBkTzEyNDYiO3M6MzU6Ii93cC1pbmNsdWRlcy9mZWVkLXJzczItY29tbWVudHMucGhwIjtzOjM3OiJjMWZiNzdhYjUyYzA5ZWQ1ZWFkMzJmYzU4MjRkMTdkOU8=MDU3IjtzOjI2OiIvd3AtaW5jbHVkZXMvZmVlZC1yc3MyLnBocCI7czozNzoiYTQwOTY3MWU1NGNiN2Y5YzMwMGI3Y2U4NmQ3MWFjZTdPMzgxMSI7czoyMToiL3dwLWluY2x1ZGVzL2ZlZWQucGhwIjtzOjM4OiI4Yjk1MDdmY2Y5ODVmMWE4MjljYjZhOTk1OWNjODAxN=8xOTUyNSI7czozMjoiL3dwLWluY2x1ZGVzL2ZvbnRzL2Rhc2hpY29ucy5lb3QiO3M6Mzg6IjMwZTQxMGM3MTVjNjIxNWZhN2ZhYTFjOTc5YjY=ODBjTzIyNDQ5IjtzOjMyOiIvd3AtaW5jbHVkZXMvZm9udHMvZGFzaGljb25zLnN2ZyI7czozODoiNzgwZTY5NjhjZDBlMzc4YjFmNzcyM2Q4OWZhNTlhYjVPOTU5MTYiO3M6MzI6Ii93cC1pbmNsdWRlcy9mb25=cy9kYXNoaWNvbnMudHRmIjtzOjM4OiI4ZmVhMWZjZTQ2YmFmZTQ2OWJhMmYxMDFmZGM1ODNlMk8=MTcyOCI7czozMzoiL3dwLWluY2x1ZGVzL2ZvbnRzL2Rhc2hpY29ucy53b2ZmIjtzOjM4OiIwYzFjMWFkNDFjMDI1ZjcyNTkyYmNhODIwZTA3M2JlY=8yNjEyNCI7czoyNzoiL3dwLWluY2x1ZGVzL2Zvcm1hdHRpbmcucGhwIjtzOjM5OiI2Yjc3ZjVkZjZiNGRlNWMyMzVjY2IzMjJhZjZmNjFmZU8xODk3MDMiO3M6MjY6Ii93cC1pbmNsdWRlcy9mdW5jdGlvbnMucGhwIjtzOjM5OiJiNzg=NDU4MDBkMjhmNDlkNzE1YzVlMzRiNTdiMTA1NU8xNzQ4MjUiO3M6Mzc6Ii93cC1pbmNsdWRlcy9mdW5jdGlvbnMud3Atc2NyaXB=cy5waHAiO3M6Mzg6ImZhMGJkODg3NTgzZDg5N2M3ZGRjMGZiMzgxMjU4NTU1TzExNDgxIjtzOjM2OiIvd3AtaW5jbHVkZXMvZnVuY3Rpb25zLndwLXN=eWxlcy5waHAiO3M6Mzc6ImU2NjVlMjRhMTU5MjM4ZTI1YTgwNTcxN2RiMzJmYjk4TzgwODAiO3M6MzM6Ii93cC1pbmNsdWRlcy9nZW5lcmFsLXRlbXBsYXRlLnBocCI7czozOToiOTJhYTVhOTE3YjFhMzBiYzMxMzEyN2YyOGEyMzA=YzhPMTI=OTA4IjtzOjIxOiIvd3AtaW5jbHVkZXMvaHR=cC5waHAiO3M6Mzg6IjU3NjBhNGZhYTk=MTU3MWE5NTYxY2EyYzE2NjE3NGU2TzIyMjEwIjtzOjMxOiIvd3AtaW5jbHVkZXMvSUQzL2dldGlkMy5saWIucGhwIjtzOjM4OiJjNTJkZTc2NDcyMjJmZTRiMjRlMmVhMDQ3NTVmOTliOE8=NDg2MCI7czoyNzoiL3dwLWluY2x1ZGVzL=lEMy9nZXRpZDMucGhwIjtzOjM4OiI5N2JjZDYxODU2ZGY3YWZhNjUzZDQ5MTc3NWVmZGE1Y=82MzYyNyI7czozOToiL3dwLWluY2x1ZGVzL=lEMy9saWNlbnNlLmNvbW1lcmNpYWwudHh=IjtzOjM3OiIwYTNiNjcwODk2ZmM=YTgwNjdhZGIyYzZkOTc4NDE4ZU8xMzA3IjtzOjI4OiIvd3AtaW5jbHVkZXMvSUQzL2xpY2Vuc2UudHh=IjtzOjM3OiIzNWQ5OGFhZGY4ZjdjYzY4NTEzMzY2NTFmN2E2NmI5OE8xMzU2IjtzOjQzOiIvd3AtaW5jbHVkZXMvSUQzL21vZHVsZS5hdWRpby12aWRlby5hc2YucGhwIjtzOjM5OiIyODZiMTk5OWMxNTFiN2JhMDFjZmQ1N2MyNGUxMzRjZk8xMjcwNzciO3M6NDM6Ii93cC1pbmNsdWRlcy9JRDMvbW9kdWxlLmF1ZGlvLXZpZGVvLmZsdi5waHAiO3M6Mzg6IjZiODM=ODY5YjYyYzU3ZmVhOTE4NTFiMTQ2ZGNlM2QzTzI1NDAxIjtzOjQ4OiIvd3AtaW5jbHVkZXMvSUQzL21vZHVsZS5hdWRpby12aWRlby5tYXRyb3NrYS5waHAiO3M6Mzk6IjYzOWFhNWFlODk=YjM5NmEwMGZiNTNmYzgwNjllNzRhTzEwMzU=MSI7czo=OToiL3dwLWluY2x1ZGVzL=lEMy9tb2R1bGUuYXVkaW8tdmlkZW8ucXVpY2t=aW1lLnBocCI7czozOToiMjcyZGZkNmU=YzM5MWYyMDYxMWExMWQ5MjFlNjZlZWJPMTE4NzcxIjtzOjQ=OiIvd3AtaW5jbHVkZXMvSUQzL21vZHVsZS5hdWRpby12aWRlby5yaWZmLnBocCI7czozOToiZWU4MjU=MGYwMjY2NjIxOTdmNzAwMzQ3NGZkOTJkZTJPMTE4OTMzIjtzOjM3OiIvd3AtaW5jbHVkZXMvSUQzL21vZHVsZS5hdWRpby5hYzMucGhwIjtzOjM4OiJlODFjNDUwMGZiNGMzYjIyNGZkMmY5YTc4YmE2NjQyN=8xOTAwOSI7czozNzoiL3dwLWluY2x1ZGVzL=lEMy9tb2R1bGUuYXVkaW8uZHRzLnBocCI7czozODoiZjNlYTU2NjAwN2M5NGMwMzM3MmViNmY=NmM1ZDIwMDFPMTA=NjciO3M6Mzg6Ii93cC1pbmNsdWRlcy9JRDMvbW9kdWxlLmF1ZGlvLmZsYWMucGhwIjtzOjM4OiIwNTUwMDNlYTdjMDM4OGZkNzMxMDcxMTNkM2VkM2JjM=8xODUxNyI7czozNzoiL3dwLWluY2x1ZGVzL=lEMy9tb2R1bGUuYXVkaW8ubXAzLnBocCI7czozODoiZWI4NzI1N2IyZjA1MDdmNGFjNTU5MWQ=MjI2ZGZjODZPOTkxNzciO3M6Mzc6Ii93cC1pbmNsdWRlcy9JRDMvbW9kdWxlLmF1ZGlvLm9nZy5waHAiO3M6Mzg6IjdiZGM4MTNhN2ZhOTVmZWNlZWQ=ZjZkNGIzN2QzYzk3TzM5OTg2IjtzOjM4OiIvd3AtaW5jbHVkZXMvSUQzL21vZHVsZS5=YWcuYXBldGFnLnBocCI7czozODoiMzQ2YzhjMWI5N2NhZWNiYTU1OTJhOTE=NTJmYTM5NDlPMTgzNDQiO3M6Mzc6Ii93cC1pbmNsdWRlcy9JRDMvbW9kdWxlLnRhZy5pZDN2MS5waHAiO3M6Mzg6IjJiMzY4YmU5ZTE5MDUxZDAwY2FjMGU2NzM=MWQwNTFkTzExNTcyIjtzOjM3OiIvd3AtaW5jbHVkZXMvSUQzL21vZHVsZS5=YWcuaWQzdjIucGhwIjtzOjM5OiJmMjYzMDZhMzg1OGFkNDA3NDY3OWQ5NGYyYWVlYWQ=ZU8xNDQ1OTkiO3M6Mzk6Ii93cC1pbmNsdWRlcy9JRDMvbW9kdWxlLnRhZy5seXJpY3MzLnBocCI7czozODoiMTI1NWY5ZmIzMzgwYmE5M2RkMjIzOTgxYjIxODMyZWRPMTEyMzgiO3M6Mjc6Ii93cC1pbmNsdWRlcy9JRDMvcmVhZG1lLnR4dCI7czozODoiOTM5NmRmZTFjNjljOTM4ZWIxN2Y1NjRjNGU1YmFiMThPMjQ2NTIiO3M6NDM6Ii93cC1pbmNsdWRlcy9pbWFnZXMvYWRtaW4tYmFyLXNwcml=ZS=yeC5wbmciO3M6Mzc6ImViNTFhYzEzMTJlYjA2MGI5YmM2MzhmZWY=NmY4MGNhTzM5OTkiO3M6NDA6Ii93cC1pbmNsdWRlcy9pbWFnZXMvYWRtaW4tYmFyLXNwcml=ZS5wbmciO3M6Mzc6IjUzY2YxMWE=MWY5NzNhODA1NzBlMGVjYWM1ZDNmZTVlTzI=NjciO3M6NDU6Ii93cC1pbmNsdWRlcy9pbWFnZXMvYXJyb3ctcG9pbnRlci1ibHVlLTJ4LnBuZyI7czozNzoiMjU2ZGUyMTQxMTA1NzJkZThjNWQzNGI4MzkxMTYzY2ZPMTY2NiI7czo=MjoiL3dwLWluY2x1ZGVzL2ltYWdlcy9hcnJvdy1wb2ludGVyLWJsdWUucG5nIjtzOjM2OiI3NzlmZmM2MmUzY2U4NzJhNGNhYmIyYzM1YmJiMTRmOU83OTMiO3M6Mjk6Ii93cC1pbmNsdWRlcy9pbWFnZXMvYmxhbmsuZ2lmIjtzOjM1OiI=OGJiMmJhYWY=MzUzMTA5ZjdjMjY2NWQ5NmFhMzkwYk8=MyI7czozOToiL3dwLWluY2x1ZGVzL2ltYWdlcy9jcnlzdGFsL2FyY2hpdmUucG5nIjtzOjM3OiI5NjUzY2EwN2ZhZjA4ZTljY2M=OTMwNDEwMjBlNmVlYk8yNDU=IjtzOjM3OiIvd3AtaW5jbHVkZXMvaW1hZ2VzL2NyeXN=YWwvYXVkaW8ucG5nIjtzOjM3OiI5OTZlNTZmMThmM2FjOWNmODlmMzQ3ZDhkNDJkMjM2Yk8yMTg=IjtzOjM2OiIvd3AtaW5jbHVkZXMvaW1hZ2VzL2NyeXN=YWwvY29kZS5wbmciO3M6Mzc6IjE=NjBlZjMxYjJjZmZhZWYxY2IwMTJmNTMxYWUzOTFmTzE2MDQiO3M6Mzk6Ii93cC1pbmNsdWRlcy9pbWFnZXMvY3J5c3RhbC9kZWZhdWx=LnBuZyI7czozNjoiNDFmMjNlMjkyYTJmYmVkYzIxZWNhZTJkMDRmMjliYmFPNDUzIjtzOjQwOiIvd3AtaW5jbHVkZXMvaW1hZ2VzL2NyeXN=YWwvZG9jdW1lbnQucG5nIjtzOjM3OiI3Zjg5Mjc1ZTYzOWE3M2MwZjljNDQ=OGJmOTMzNTQ1Y=8yMDYzIjtzOjQzOiIvd3AtaW5jbHVkZXMvaW1hZ2VzL2NyeXN=YWwvaW5=ZXJhY3RpdmUucG5nIjtzOjM3OiJhZjUyY2Y2ZDYwZjJlZGJhNjA5OTM5YTcwMzA=ZTYwMU8yMjE3IjtzOjM5OiIvd3AtaW5jbHVkZXMvaW1hZ2VzL2NyeXN=YWwvbGljZW5zZS5=eHQiO3M6MzY6ImYwNWRiNTRjNjNlMzY5MTg=NzliNjY1MTkzMGRjZmU3TzE=OSI7czo=MzoiL3dwLWluY2x1ZGVzL2ltYWdlcy9jcnlzdGFsL3NwcmVhZHNoZWV=LnBuZyI7czozNzoiMzU4NjM5ZjhkMGEyMGMzMTgwNTRjYjAxYzc2ZWE=ZWFPMjQwOCI7czozNjoiL3dwLWluY2x1ZGVzL2ltYWdlcy9jcnlzdGFsL3RleHQucG5nIjtzOjM2OiI5MGNjMjBkMWIyYWFmYzIzYmU2NGZmMjUxMWUzNWJiNU82NzAiO3M6Mzc6Ii93cC1pbmNsdWRlcy9pbWFnZXMvY3J5c3RhbC92aWRlby5wbmciO3M6Mzc6Ijk=MDEwZWRiZmQ4ZTZjYTU4OWRhYTRiODNiZjUzZDBiTzEzMzkiO3M6Mzc6Ii93cC1pbmNsdWRlcy9pbWFnZXMvZG93bl9hcnJvdy=yeC5naWYiO3M6MzU6ImEwNzNiOGExZWU5YjI=ODIwMTdmMzYyOGRhNDBhODYxTzg=IjtzOjM=OiIvd3AtaW5jbHVkZXMvaW1hZ2VzL2Rvd25fYXJyb3cuZ2lmIjtzOjM1OiI2NWRjYzg1ZDNhNzVmZjU3NzZmYmUzZGYwMTIyYjdlMk81OSI7czo=NDoiL3dwLWluY2x1ZGVzL2ltYWdlcy9pY29uLXBvaW5=ZXItZmxhZy=yeC5wbmciO3M6Mzc6ImE5ZTVlMWE2MzJmMWIzYjk2MmU=YzQyNmQ1NWFjYzcyTzEzNjkiO3M6NDE6Ii93cC1pbmNsdWRlcy9pbWFnZXMvaWNvbi1wb2ludGVyLWZsYWcucG5nIjtzOjM2OiJiMGQzMmM4N2YyYWQ4YmMyNDU1ZWJmNmE2MDE3MTAyN=83ODMiO3M6Mzc6Ii93cC1pbmNsdWRlcy9pbWFnZXMvbWVkaWEvYXJjaGl2ZS5wbmciO3M6MzY6IjExMzkxNGQyZWVkZmYyNjhmYjAwZGFkM2MzYWM5MTc1TzQxNyI7czozNToiL3dwLWluY2x1ZGVzL2ltYWdlcy9tZWRpYS9hdWRpby5wbmciO3M6MzY6Ijg2NzQ2MTQzNDFmMWJlYzVmZWIyMmViN2U3NWFkZmMwTzM4MiI7czozNDoiL3dwLWluY2x1ZGVzL2ltYWdlcy9tZWRpYS9jb2RlLnBuZyI7czozNjoiMmQ2Zjk2MTMwY2FkNTVjYTkzMTBlZWQ1NTVhOTU1NWZPMjc=IjtzOjM3OiIvd3AtaW5jbHVkZXMvaW1hZ2VzL21lZGlhL2RlZmF1bHQucG5nIjtzOjM2OiIyZGI2YTllNmNkNDlkMjQyOTY2OGNlNDBlMGRlZTc2Mk8xNjgiO3M6Mzg6Ii93cC1pbmNsdWRlcy9pbWFnZXMvbWVkaWEvZG9jdW1lbnQucG5nIjtzOjM2OiI3NmU1MzQ5OTM4ZjZjZTkxNzk5MzE=MzZkZTFjNjRhM=8yMDAiO3M6NDE6Ii93cC1pbmNsdWRlcy9pbWFnZXMvbWVkaWEvaW5=ZXJhY3RpdmUucG5nIjtzOjM2OiI1MmQ3YWNjYjgyYWVmMTdmYzJjM2I=YzU4OTY4ZGM=OE8zMTkiO3M6NDE6Ii93cC1pbmNsdWRlcy9pbWFnZXMvbWVkaWEvc3ByZWFkc2hlZXQucG5nIjtzOjM2OiJmMWMwYTAzNGU=ZjExMmQ2MDA1NGZjZGVjYzg3M2ZiMk8xODgiO3M6MzQ6Ii93cC1pbmNsdWRlcy9pbWFnZXMvbWVkaWEvdGV4dC5wbmciO3M6MzY6IjdhYjk4NzczZTZlNDMwZjcxOGM4OWQ5ZjUxMTk4MDRiTzE4OCI7czozNToiL3dwLWluY2x1ZGVzL2ltYWdlcy9tZWRpYS92aWRlby5wbmciO3M6MzY6IjhkZTBlOWYxNzVlYTY4MTc5YjgxZGRkYjcxYTAxMGY3TzI4MyI7czozMDoiL3dwLWluY2x1ZGVzL2ltYWdlcy9yc3MtMngucG5nIjtzOjM3OiJjNzE3NTk2MTViYTA1MWMxZTZmNTk3ZmQ3MjZhOWQxMU8xMzA2IjtzOjI3OiIvd3AtaW5jbHVkZXMvaW1hZ2VzL3Jzcy5wbmciO3M6MzY6ImE1YjA1YmJmMjhmMjk=YjAyZWZkOTQyYTRlNWFiODA2TzYwOCI7czozOToiL3dwLWluY2x1ZGVzL2ltYWdlcy9zbWlsaWVzL2Zyb3duaWUucG5nIjtzOjM3OiI1MTliZjNkMDA1MWI4NDFlMGNiMDhkYzRmNDgzMWVlZE8xMDA3IjtzOjQyOiIvd3AtaW5jbHVkZXMvaW1hZ2VzL3NtaWxpZXMvaWNvbl9hcnJvdy5naWYiO3M6MzY6ImJmY2FiNTA5MGIxMjgwYmJlNDk1ZGJlYWQ=ZDIyODFmTzE2OSI7czo=NDoiL3dwLWluY2x1ZGVzL2ltYWdlcy9zbWlsaWVzL2ljb25fYmlnZ3Jpbi5naWYiO3M6MzY6ImM3NTk3MDUyZmUyYjE2ZGIzMDdkNmJkMTRlN2I4YzZiTzE3MyI7czo=NToiL3dwLWluY2x1ZGVzL2ltYWdlcy9zbWlsaWVzL2ljb25fY29uZnVzZWQuZ2lmIjtzOjM2OiI3ZmVmYTQ3MzU5NDY1MDA1NWEzNmI5ZTMwNjJjOWE5MU8xNzAiO3M6NDE6Ii93cC1pbmNsdWRlcy9pbWFnZXMvc21pbGllcy9pY29uX2Nvb2wuZ2lmIjtzOjM2OiI5NjQ2N2ViNWFlMThkZmEyMmVhMWMwZmEzZTc=MzgwZU8xNzIiO3M6NDA6Ii93cC1pbmNsdWRlcy9pbWFnZXMvc21pbGllcy9pY29uX2NyeS5naWYiO3M6MzY6IjQ1M2U3YTNmOGJiYjQxNzAwOGYwNmQ1NzZjNDFkMDYwTzQ5MCI7czo=MDoiL3dwLWluY2x1ZGVzL2ltYWdlcy9zbWlsaWVzL2ljb25fZWVrLmdpZiI7czozNjoiYTZjNjVmYTZmZjczOGVmNmM=NmE=ZTgwYTY1ZjdhYTBPMTcwIjtzOjQxOiIvd3AtaW5jbHVkZXMvaW1hZ2VzL3NtaWxpZXMvaWNvbl9ldmlsLmdpZiI7czozNjoiNjNiZjEwMWJkM2Q=Zjc1NjRkM2NmMzE4MjIyMThkMmVPMjQxIjtzOjQ=OiIvd3AtaW5jbHVkZXMvaW1hZ2VzL3NtaWxpZXMvaWNvbl9leGNsYWltLmdpZiI7czozNjoiNWNlMzcxNDU4YzFhMjE=ODU5NWY1ZjNkYWY3YjVmYzhPMjM2IjtzOjQxOiIvd3AtaW5jbHVkZXMvaW1hZ2VzL3NtaWxpZXMvaWNvbl9pZGVhLmdpZiI7czozNjoiYmRiMzIyNmQyNTY4YjhjMWVkZjhmNDUzYjFlODcyZTZPMTc=IjtzOjQwOiIvd3AtaW5jbHVkZXMvaW1hZ2VzL3NtaWxpZXMvaWNvbl9sb2wuZ2lmIjtzOjM2OiJkNGYwNGRjNjVhMzg3Y2E5YjhjMGYyMmNhOGMwZWM4Y=8zMzMiO3M6NDA6Ii93cC1pbmNsdWRlcy9pbWFnZXMvc21pbGllcy9pY29uX21hZC5naWYiO3M6MzY6ImQ3YmUwOGI2Njk2NTFhNjMwODBjZmU3YjkwMDRkMzMwTzE3MiI7czo=NDoiL3dwLWluY2x1ZGVzL2ltYWdlcy9zbWlsaWVzL2ljb25fbXJncmVlbi5naWYiO3M6MzY6ImZkZTllNDRhOGFhZTBlODliZDUyNzc5MmI=Nzc5YWNhTzM=OCI7czo=NDoiL3dwLWluY2x1ZGVzL2ltYWdlcy9zbWlsaWVzL2ljb25fbmV1dHJhbC5naWYiO3M6MzY6IjhhOTVkYmZhYTk5ODA5YjAxNTA2ODdhZTBjYjQ1YWVkTzE2NyI7czo=NToiL3dwLWluY2x1ZGVzL2ltYWdlcy9zbWlsaWVzL2ljb25fcXVlc3Rpb24uZ2lmIjtzOjM2OiJkMjI3NzViMmUzMjY=NTkwNzE=MWY3ODhjMzZkNGU5ZE8yNDciO3M6NDE6Ii93cC1pbmNsdWRlcy9pbWFnZXMvc21pbGllcy9pY29uX3JhenouZ2lmIjtzOjM2OiIxN2NiZTVjYmFkZTJiNGVjM2Q4NWJlNGFjOTQwOWFkZE8xNzUiO3M6NDQ6Ii93cC1pbmNsdWRlcy9pbWFnZXMvc21pbGllcy9pY29uX3JlZGZhY2UuZ2lmIjtzOjM2OiIxYzZkOGIxMDFjODIxNjQxZjk4MzE3NTIyMTM=NjExMk82NTAiO3M6NDU6Ii93cC1pbmNsdWRlcy9pbWFnZXMvc21pbGllcy9pY29uX3JvbGxleWVzLmdpZiI7czozNjoiYWZjOGJiYzY1ZmNiZDJiODJhM2UyYzFhYjQxYTIxNmFPNDg5IjtzOjQwOiIvd3AtaW5jbHVkZXMvaW1hZ2VzL3NtaWxpZXMvaWNvbl9zYWQuZ2lmIjtzOjM2OiIxYTI3M2RiM2MzNGY2YWZiM2ZlZDc1NDE3Y2E1ZTdiNk8xNjciO3M6NDI6Ii93cC1pbmNsdWRlcy9pbWFnZXMvc21pbGllcy9pY29uX3NtaWxlLmdpZiI7czozNjoiYjI5ODQ3MjljM2I2Y2RjMDc1MDhiODhiNWMwYTRkMWVPMTczIjtzOjQ2OiIvd3AtaW5jbHVkZXMvaW1hZ2VzL3NtaWxpZXMvaWNvbl9zdXJwcmlzZWQuZ2lmIjtzOjM2OiIyOTk5NzJiNWNkZDFmMWUwNjkwZGQ5NWU=MDM4YmQ4N=8xNzQiO3M6NDQ6Ii93cC1pbmNsdWRlcy9pbWFnZXMvc21pbGllcy9pY29uX3R3aXN=ZWQuZ2lmIjtzOjM2OiI2MmFiZDUwY2E5MmViMjM4MWE3YzYwZTM1MWY2NGM=Nk8yNDEiO3M6NDE6Ii93cC1pbmNsdWRlcy9pbWFnZXMvc21pbGllcy9pY29uX3dpbmsuZ2lmIjtzOjM2OiJkMDFhNGY4NzA1NWFjMGZjZThhNjY3MzlkODA=MzRiYU8xNjgiO3M6Mzk6Ii93cC1pbmNsdWRlcy9pbWFnZXMvc21pbGllcy9tcmdyZWVuLnBuZyI7czozNzoiMmQzNWMxZTA1ZWIxOTQ5MTA2ZDM=YWRkNmE5ZDlkZGFPMTQ4NiI7czo=MDoiL3dwLWluY2x1ZGVzL2ltYWdlcy9zbWlsaWVzL3JvbGxleWVzLnBuZyI7czozNzoiMjBiZWJlZjAwNTRmODUxMzMyZGY=ZjY2ZGRhMzY5OGRPMTIzMyI7czo=NDoiL3dwLWluY2x1ZGVzL2ltYWdlcy9zbWlsaWVzL3NpbXBsZS1zbWlsZS5wbmciO3M6Mzc6ImU5NGJiMmNmN2JjMjg1MTM4ZWIxNjZiMjAxNzc5NzY4TzEwMDgiO3M6MzQ6Ii93cC1pbmNsdWRlcy9pbWFnZXMvc3Bpbm5lci=yeC5naWYiO3M6Mzc6IjVjMTM3MWJjYjQzOTI5Njg2NDc4NTJhOWM5ZGY1ZDZjTzg1MzYiO3M6MzE6Ii93cC1pbmNsdWRlcy9pbWFnZXMvc3Bpbm5lci5naWYiO3M6Mzc6ImIwYTNkZGUzMzE2MzdlMjdhYTY=NzZkNDc2NDgxODcxTzQxNjIiO3M6Mzk6Ii93cC1pbmNsdWRlcy9pbWFnZXMvdG9nZ2xlLWFycm93LTJ4LnBuZyI7czozNjoiNDZjYWUxY2E1Y2Y4ODNmNGM5MTI=MzQ=NzIxNWVmMTFPMzU=IjtzOjM2OiIvd3AtaW5jbHVkZXMvaW1hZ2VzL3RvZ2dsZS1hcnJvdy5wbmciO3M6MzY6ImRjZGZjZTg3OTc2MWZkZTYxMjNiZWI2NGNlY2YyYWYyTzI4OSI7czo=MToiL3dwLWluY2x1ZGVzL2ltYWdlcy91cGxvYWRlci1pY29ucy=yeC5wbmciO3M6Mzc6ImFkYzFlN2IwMjYyZDgwZTQ=ZjE4YTI4N2MzOTVjYjdlTzM1NDIiO3M6Mzg6Ii93cC1pbmNsdWRlcy9pbWFnZXMvdXBsb2FkZXItaWNvbnMucG5nIjtzOjM3OiJiNDAxMWQ5MzVjMGY=ZGNmMGNmZmMwZjk5ZDZkOTY4ME8xNTU2IjtzOjM1OiIvd3AtaW5jbHVkZXMvaW1hZ2VzL3ctbG9nby1ibHVlLnBuZyI7czozNzoiZmQ1YjRlYjA1NzA2YTJmMDVmNzA3ZmUwNzdhZTEwMzBPMzExMyI7czozOToiL3dwLWluY2x1ZGVzL2ltYWdlcy93bHcvd3AtY29tbWVudHMucG5nIjtzOjM3OiI=Y2MyMzY1ZDA=NTBkZWRlYzMwY2VjMmU3M2E4YTFkNE8xMzczIjtzOjM1OiIvd3AtaW5jbHVkZXMvaW1hZ2VzL3dsdy93cC1pY29uLnBuZyI7czozNjoiMzExZDA5OGVjYTlhODkzNzA4NzczMzRiMWI4Zjk5MmFPNjY=IjtzOjQwOiIvd3AtaW5jbHVkZXMvaW1hZ2VzL3dsdy93cC13YXRlcm1hcmsucG5nIjtzOjM3OiIzYjlhODc3NTRkNmRkY2FkNDQ3Yzg5Nzc4ZTkzYzU=NE8yMzc2IjtzOjM=OiIvd3AtaW5jbHVkZXMvaW1hZ2VzL3dwaWNvbnMtMngucG5nIjtzOjM4OiJjM2U3NmVkNzU2YzQwNTZmYTkyNDlhOTQ=ZjY2N2UzN=8xNDkzMSI7czozMToiL3dwLWluY2x1ZGVzL2ltYWdlcy93cGljb25zLnBuZyI7czozNzoiNjQ1M2ZjZjg3NTcxOGQ5MTU2MGY1ZmFlZGNlMzYxZjRPNzA4NiI7czozMzoiL3dwLWluY2x1ZGVzL2ltYWdlcy93cHNwaW4tMnguZ2lmIjtzOjM3OiI3ZGVmMzNhYWQ5NTljZDI4OWQ=OWRkZjJhNDFmMDc2ZE85MTMzIjtzOjMwOiIvd3AtaW5jbHVkZXMvaW1hZ2VzL3dwc3Bpbi5naWYiO3M6Mzc6ImRkNGU2ZGQyNjhhNzBjZTRjMWM1MTQzYjFhNDA5MmRkTzIyMDkiO3M6MzA6Ii93cC1pbmNsdWRlcy9pbWFnZXMveGl=LTJ4LmdpZiI7czozNjoiOGZiMDcyOWM1NDFjYmRjNDYwOWZhZjNmNGFkMDJmYzdPODI1IjtzOjI3OiIvd3AtaW5jbHVkZXMvaW1hZ2VzL3hpdC5naWYiO3M6MzY6ImU1MDEyOTAyYTM1OGZiYjk2MDMxYWNkY2YwNDhkN2NhTzE4MSI7czozNzoiL3dwLWluY2x1ZGVzL=lYUi9jbGFzcy1JWFItYmFzZTY=LnBocCI7czozNjoiZWUyYTM2ZDYwNmQ1MDhhZjQ=YjY1NGU2MTc2NTk5YmJPNDE=IjtzOjM3OiIvd3AtaW5jbHVkZXMvSVhSL2NsYXNzLUlYUi1jbGllbnQucGhwIjtzOjM3OiI1MWM=YTM=YmNlNDFjZmIyNWRkYThlNzU4NTBlNTk1MU8=NjQzIjtzOjQ2OiIvd3AtaW5jbHVkZXMvSVhSL2NsYXNzLUlYUi1jbGllbnRtdWx=aWNhbGwucGhwIjtzOjM2OiJhZjEwOTAzMzQwYjhlYmMzNTNhNTA1MGE1ZmFjZTk5ME85NjMiO3M6MzU6Ii93cC1pbmNsdWRlcy9JWFIvY2xhc3MtSVhSLWRhdGUucGhwIjtzOjM3OiI4YWNhMGUzZGZmMjczZDYzMmVkOGE3ODYxY2ExNjk2N=8xNjc5IjtzOjM2OiIvd3AtaW5jbHVkZXMvSVhSL2NsYXNzLUlYUi1lcnJvci5waHAiO3M6MzY6IjY3MzYyMmFjOTVlZDc1NWMyNzMzYmNiMmFkOWM2MjhhTzg1NCI7czo1MDoiL3dwLWluY2x1ZGVzL=lYUi9jbGFzcy1JWFItaW5=cm9zcGVjdGlvbnNlcnZlci5waHAiO3M6Mzc6IjMyNTU2MWJlNzdlNDNjZjg=OTc3OTE3MDg2NGYzNzJkTzUzMjMiO3M6Mzg6Ii93cC1pbmNsdWRlcy9JWFIvY2xhc3MtSVhSLW1lc3NhZ2UucGhwIjtzOjM3OiI3NzJhYjY3YmNjYjA2ODI1NDRhYjBiNmQ3MmY=MTIyY=84MDExIjtzOjM4OiIvd3AtaW5jbHVkZXMvSVhSL2NsYXNzLUlYUi1yZXF1ZXN=LnBocCI7czozNjoiMjU3MDJlM2M4ZDUzYzdhMWVhOTlkNDdhMzFjZmEyMDRPOTI3IjtzOjM3OiIvd3AtaW5jbHVkZXMvSVhSL2NsYXNzLUlYUi1zZXJ2ZXIucGhwIjtzOjM3OiI5MWYzNzdhZjVjMTQ3ODU=OTgzZTlmY2EzYWE3ZmYxOU82OTMwIjtzOjM2OiIvd3AtaW5jbHVkZXMvSVhSL2NsYXNzLUlYUi12YWx1ZS5waHAiO3M6Mzc6IjAzOTI5ZDY2ZmIzZWE4MzU2Y2NkZjg2YTAwNjZlODBjTzM3OTAiO3M6Mjg6Ii93cC1pbmNsdWRlcy9qcy9hZG1pbi1iYXIuanMiO3M6Mzg6ImQ5N2ExODk5YTdmNjQxZTY5MzkyOGY1YTQ3YzMzZGU=TzExODA5IjtzOjMyOiIvd3AtaW5jbHVkZXMvanMvYWRtaW4tYmFyLm1pbi5qcyI7czozNzoiYjJlNzMzZjBjMTE3ZTMwYWM4OTc=ZGNjNjlhYjExZDhPNzE4OCI7czoyNzoiL3dwLWluY2x1ZGVzL2pzL2F1dG9zYXZlLmpzIjtzOjM4OiI2Y2ZhYzQyMjQ2YTA=YzlmMzdmMGEwZTVmMDQ3NGVlNE8xNjM5NCI7czozMToiL3dwLWluY2x1ZGVzL2pzL2F1dG9zYXZlLm1pbi5qcyI7czozNzoiYzIzNjZiN2RlNzAyN2QwOTY2MWVjZGRlMGM4ZDEwMjVPNTY=NiI7czozMToiL3dwLWluY2x1ZGVzL2pzL2JhY2tib25lLm1pbi5qcyI7czozODoiOTI2M2RkYmU1MmY4NWU3YmUxMzMwMWFjMjY4ODljOGVPMjMzMTgiO3M6MzA6Ii93cC1pbmNsdWRlcy9qcy9jb2xvcnBpY2tlci5qcyI7czozODoiZjAxMDE3Y2E1NjIwNjdmNDg=MGViMmI2Zjk5ZjJkYWZPMjkwODMiO3M6MzQ6Ii93cC1pbmNsdWRlcy9qcy9jb2xvcnBpY2tlci5taW4uanMiO3M6Mzg6ImUxODYyMDlkYzQxYTU5ZjJmYjYyN2MyNGU2NDA3MTJkTzE2Njc1IjtzOjMyOiIvd3AtaW5jbHVkZXMvanMvY29tbWVudC1yZXBseS5qcyI7czozNzoiMTRlYWM3NGVhNGQ4YWVjYTA4ZThlZjhkNTRkNDI2MDBPMjY4NSI7czozNjoiL3dwLWluY2x1ZGVzL2pzL2NvbW1lbnQtcmVwbHkubWluLmpzIjtzOjM3OiI1NmJjMjcyNmQ4MjkyMDdiZmE4MDJmOTU3YWFjMDc5MU8xMDc4IjtzOjMyOiIvd3AtaW5jbHVkZXMvanMvY3JvcC9jcm9wcGVyLmNzcyI7czozNzoiNmI3OTM1MGJmNDZlMGY2OTJhNGQxYjI4MDdlZDAzOTlPMjk=OSI7czozMToiL3dwLWluY2x1ZGVzL2pzL2Nyb3AvY3JvcHBlci5qcyI7czozODoiMWQ5N2IyOTZkOTE4NDgyZTEyNzNjNTZmYmZmNmE4ZTJPMTY=ODUiO3M6Mzc6Ii93cC1pbmNsdWRlcy9qcy9jcm9wL21hcnF1ZWVIb3Jpei5naWYiO3M6MzY6IjhjY2NhZTljMWViYWZkYjgzYmU2MDJlNGQ=NGM2ZjBhTzI3NyI7czozNjoiL3dwLWluY2x1ZGVzL2pzL2Nyb3AvbWFycXVlZVZlcnQuZ2lmIjtzOjM2OiJhZTlhY2NmMTAwYTRiOTkzMDYzOWFkZmY1MmQ=ZGNjN=8yOTMiO3M6MzM6Ii93cC1pbmNsdWRlcy9qcy9jdXN=b21pemUtYmFzZS5qcyI7czozODoiOGNhZGU5NDViNGE4OWQwNDM3NjJmODBiY2FlZDg3YWFPMjIxNDYiO3M6Mzc6Ii93cC1pbmNsdWRlcy9qcy9jdXN=b21pemUtYmFzZS5taW4uanMiO3M6Mzc6IjEyMDRhNjViZGNhOWI1M2IxMWUyMWIwYTQwMDZmZWQwTzc1NjIiO3M6MzU6Ii93cC1pbmNsdWRlcy9qcy9jdXN=b21pemUtbG9hZGVyLmpzIjtzOjM3OiIzNzM1ODk1Y2U=YmMxMDYxYjAzM2IwMGRkYWRjMjJkZU83NTc1IjtzOjM5OiIvd3AtaW5jbHVkZXMvanMvY3VzdG9taXplLWxvYWRlci5taW4uanMiO3M6Mzc6IjA3ZmZiYWMzZjJiYTk4YmU4MDQ=NDA3OGJmNDc4ZTA2TzM=NjEiO3M6MzU6Ii93cC1pbmNsdWRlcy9qcy9jdXN=b21pemUtbW9kZWxzLmpzIjtzOjM3OiIzYTc5OWI3NDdkMWNjOTlmNDQwZWM=NjMwYTMyZTA=ME81ODczIjtzOjM5OiIvd3AtaW5jbHVkZXMvanMvY3VzdG9taXplLW1vZGVscy5taW4uanMiO3M6Mzc6ImU3MTVlYTY4MDZjOWZkYjk=YWE=ZDU2ODEyZGQwMjE3TzM=NTkiO3M6NDY6Ii93cC1pbmNsdWRlcy9qcy9jdXN=b21pemUtcHJldmlldy1uYXYtbWVudXMuanMiO3M6Mzg6IjIwNzM5OWE=MDc=YzllZjA2NmM1ODM=YzA3ZTQzZjA4TzE=NzI=IjtzOjUwOiIvd3AtaW5jbHVkZXMvanMvY3VzdG9taXplLXByZXZpZXctbmF2LW1lbnVzLm1pbi5qcyI7czozNzoiNTI2OTUyZTdhODdhMzM5YjI3NmY1ZGNmYzk2YzUxNzZPNTA1MCI7czo=NDoiL3dwLWluY2x1ZGVzL2pzL2N1c3RvbWl6ZS1wcmV2aWV3LXdpZGdldHMuanMiO3M6Mzg6IjQzNjA5M2VkZWMzMjBjOWY5ZGE3NmNlZTAzZGViM2FjTzE5MzAzIjtzOjQ4OiIvd3AtaW5jbHVkZXMvanMvY3VzdG9taXplLXByZXZpZXctd2lkZ2V=cy5taW4uanMiO3M6Mzc6IjViNDBhZGU3MmE=ZTZhZGQ=ZWMyMTQ3YTU4ODU5YTRiTzc2NTkiO3M6MzY6Ii93cC1pbmNsdWRlcy9qcy9jdXN=b21pemUtcHJldmlldy5qcyI7czozODoiMjA2YzAwMGEzZDBjNTk4ZWM=NzFhZjU4Njg=ZjQzZTFPMjU4ODYiO3M6NDA6Ii93cC1pbmNsdWRlcy9qcy9jdXN=b21pemUtcHJldmlldy5taW4uanMiO3M6Mzg6ImI5ZjYyNjQzYzJiZDIwOWZmZDI4YzY2NWQxNmM3ZDNmTzEwMDQ5IjtzOjQ2OiIvd3AtaW5jbHVkZXMvanMvY3VzdG9taXplLXNlbGVjdGl2ZS1yZWZyZXNoLmpzIjtzOjM4OiI4MmViYTkzYjdhOWIwNWE1NmFjZmRlZDJkM2NlNjVlNU8zMjIwOCI7czo1MDoiL3dwLWluY2x1ZGVzL2pzL2N1c3RvbWl6ZS1zZWxlY3RpdmUtcmVmcmVzaC5taW4uanMiO3M6Mzg6IjlmOTkxMjAzNzBiNzA=ZTZjN2Q=MGY5YTU3MDVlODIzTzEwNTgyIjtzOjM=OiIvd3AtaW5jbHVkZXMvanMvY3VzdG9taXplLXZpZXdzLmpzIjtzOjM3OiI1YWJlYTdiNmQ5YTI1NTZmYjhjYmZjZDNmOGQxYzBmZk81NDI2IjtzOjM4OiIvd3AtaW5jbHVkZXMvanMvY3VzdG9taXplLXZpZXdzLm1pbi5qcyI7czozNzoiYzVmMGFiYjczZTY4N2ZhZWJjOWJmMjI1YTFlMDgyNGVPMjkzOSI7czoyODoiL3dwLWluY2x1ZGVzL2pzL2hlYXJ=YmVhdC5qcyI7czozODoiNDcxNDQwMGQ1NGI5NmEyYzM4MGIyNDUzMDBhNWJlNWFPMjAwNzciO3M6MzI6Ii93cC1pbmNsdWRlcy9qcy9oZWFydGJlYXQubWluLmpzIjtzOjM3OiIxMjZjYzRkMWUzNWI3NGVkYjUyNWIwNmUzNzg4ZTBmMk81NDgzIjtzOjMwOiIvd3AtaW5jbHVkZXMvanMvaG92ZXJJbnRlbnQuanMiO3M6Mzc6ImNhYjM1OThiNDM4YTllNjM5ODRmMWM2ZTlkZDc5YjAxTzQ5NDkiO3M6MzQ6Ii93cC1pbmNsdWRlcy9qcy9ob3ZlckludGVudC5taW4uanMiO3M6Mzc6ImNhNTAwYWRlODU=YzMxNDE3ZmFmNTc2MmUzMWI5ZDAwTzExMTUiO3M6MzU6Ii93cC1pbmNsdWRlcy9qcy9pbWFnZXNsb2FkZWQubWluLmpzIjtzOjM3OiJkMGMyYzBkN2UzNzY1MmU2NjY1N2M4YzhkNjM3NjQ=Mk83OTk=IjtzOjQ3OiIvd3AtaW5jbHVkZXMvanMvaW1nYXJlYXNlbGVjdC9ib3JkZXItYW5pbS1oLmdpZiI7czozNjoiNWFjM2M=MmNjODZlNzQ1YTVlMzZiNjdiNGM3MGExMzRPMTc4IjtzOjQ3OiIvd3AtaW5jbHVkZXMvanMvaW1nYXJlYXNlbGVjdC9ib3JkZXItYW5pbS12LmdpZiI7czozNjoiMjBjOTdhMjE5OTNjZjEzN2VhZDlmZGJlY2JjNDJhYThPMTc4IjtzOjQ3OiIvd3AtaW5jbHVkZXMvanMvaW1nYXJlYXNlbGVjdC9pbWdhcmVhc2VsZWN=LmNzcyI7czozNjoiN2QyOGNhZDkyODI5YjNkNjMzYTA4N2I1ZjNiNTk1YWZPNzkwIjtzOjUzOiIvd3AtaW5jbHVkZXMvanMvaW1nYXJlYXNlbGVjdC9qcXVlcnkuaW1nYXJlYXNlbGVjdC5qcyI7czozODoiN2EwZTFiZmM=MjkyNTI1MzBjZmI4MzE4ZjUzYTU5ODZPMzgxMzMiO3M6NTc6Ii93cC1pbmNsdWRlcy9qcy9pbWdhcmVhc2VsZWN=L2pxdWVyeS5pbWdhcmVhc2VsZWN=Lm1pbi5qcyI7czozNzoiMjVmNDJlMDQ5ZTY1ZWUxNmQ=NDI3OTk3NTU3MjQwMjVPOTg4NyI7czozMToiL3dwLWluY2x1ZGVzL2pzL2pjcm9wL=pjcm9wLmdpZiI7czozNjoiNWE4YmZkMzc2NTEzMDViZGFmYmNmMmNkNTFiMDI1NGJPMzIzIjtzOjQyOiIvd3AtaW5jbHVkZXMvanMvamNyb3AvanF1ZXJ5Lkpjcm9wLm1pbi5jc3MiO3M6Mzc6IjU2Y2M5ZWEyMDFkYzJmNGI5MTBlNzhiZmFjYWM5MjExTzIxMjQiO3M6NDE6Ii93cC1pbmNsdWRlcy9qcy9qY3JvcC9qcXVlcnkuSmNyb3AubWluLmpzIjtzOjM4OiIyZjYxYWI5ODRjMTc3Mjc1YzcxZTM=ZmYxYTE3YzEwMk8xNTg5MyI7czo=MDoiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS9qcXVlcnktbWlncmF=ZS5qcyI7czozODoiNmM1N2I3NjI1ODlmMTNlYTViMzU3OWNhNWU2YzM2OWJPMjM=OTciO3M6NDQ6Ii93cC1pbmNsdWRlcy9qcy9qcXVlcnkvanF1ZXJ5LW1pZ3JhdGUubWluLmpzIjtzOjM4OiI3MTIxOTk=ZWVjNTMyMGZiZTY1ODY=NjNiZjk2NTFjMk8xMDA1NiI7czo=MjoiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS9qcXVlcnkuY29sb3IubWluLmpzIjtzOjM3OiJmZjJkYjhkYmYxNDVjZTQ3ZjMxNzgxZWVmMzNlNzY=YU85Mjk1IjtzOjM3OiIvd3AtaW5jbHVkZXMvanMvanF1ZXJ5L2pxdWVyeS5mb3JtLmpzIjtzOjM4OiJlNWFmZDhlNDFkMmVjMjJjMTk5MzJiMDY4Y2Q5MGE3MU8=MTcxOSI7czo=MToiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS9qcXVlcnkuZm9ybS5taW4uanMiO3M6Mzg6ImRiYzM4MDg=NzNkZWYwMGZjZTQ1ZmU1NjRkYzcyZGNiTzE=NzIwIjtzOjQwOiIvd3AtaW5jbHVkZXMvanMvanF1ZXJ5L2pxdWVyeS5ob3RrZXlzLmpzIjtzOjM3OiJlMjk=ODNhOGNhMjZhMGRkOGIwZDExNDZjNmIwYTZlOU81NjEyIjtzOjQ=OiIvd3AtaW5jbHVkZXMvanMvanF1ZXJ5L2pxdWVyeS5ob3RrZXlzLm1pbi5qcyI7czozNzoiZTM1MzIxN2Q=NTU1YWI1YzYyYjM2N2JlNjg4OTgxM2RPMTc5MyI7czozMjoiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS9qcXVlcnkuanMiO3M6Mzg6Ijg2MTBmMDNmZTc3NjQwZGVlOGM=Y2M5MjRlMDYwZjEyTzk3MTg=IjtzOjQ=OiIvd3AtaW5jbHVkZXMvanMvanF1ZXJ5L2pxdWVyeS5tYXNvbnJ5Lm1pbi5qcyI7czozNzoiY2QwZWIzNDA2MDk2ZmY4MDI2NmU3YzlkN2Q=MTkxODZPMTgxOSI7czozODoiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS9qcXVlcnkucXVlcnkuanMiO3M6Mzc6IjNiY2M1ODdhZjJjN2IwMWZjNmZiYzljMDc3MDUwMTQzTzM3ODUiO3M6NDE6Ii93cC1pbmNsdWRlcy9qcy9qcXVlcnkvanF1ZXJ5LnNjaGVkdWxlLmpzIjtzOjM3OiIwNDI2YjM5NzU=YWE2YmM3NjZkODllYTRjNDFiYmQwNk8zNDU3IjtzOjQ5OiIvd3AtaW5jbHVkZXMvanMvanF1ZXJ5L2pxdWVyeS5zZXJpYWxpemUtb2JqZWN=LmpzIjtzOjM2OiJkMTVjMjlhMThkOWZmYThiOWI=YWU4NmMzYzBjZmEyMk83ODMiO3M6NDY6Ii93cC1pbmNsdWRlcy9qcy9qcXVlcnkvanF1ZXJ5LnRhYmxlLWhvdGtleXMuanMiO3M6Mzc6ImE3MDZlYWQ2OTQyMzFlNzRmZDY3NTBiMTY3MDU4MGE1TzM3MzAiO3M6NTA6Ii93cC1pbmNsdWRlcy9qcy9qcXVlcnkvanF1ZXJ5LnRhYmxlLWhvdGtleXMubWluLmpzIjtzOjM3OiJlNTZmODE2NzZmMTk5ZGI3YmY5MzdlNjlhNjQ5MDlmYU8yMjk1IjtzOjQ3OiIvd3AtaW5jbHVkZXMvanMvanF1ZXJ5L2pxdWVyeS51aS5=b3VjaC1wdW5jaC5qcyI7czozNzoiNGNjODZkMTAwM2M=NTEzNGQ2ODM4ZjEzZTM4ODVkYjFPMTE3OSI7czozMzoiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS9zdWdnZXN=LmpzIjtzOjM3OiIzYTI=NzQ1NjkxNDVkNTFlY2FiZjdmYzRmYjA3ODk4Mk82OTkxIjtzOjM3OiIvd3AtaW5jbHVkZXMvanMvanF1ZXJ5L3N1Z2dlc3QubWluLmpzIjtzOjM3OiI3MzExMDc1YzJiNDExYjI5OWM5NGUzNmUyZTNiYWI4OU8yOTkzIjtzOjQyOiIvd3AtaW5jbHVkZXMvanMvanF1ZXJ5L3VpL2FjY29yZGlvbi5taW4uanMiO3M6Mzc6IjMzNGMyZmZiMGIwODZmZmMwZjZmMTkyZWExMjBmM2MyTzg1ODQiO3M6NDU6Ii93cC1pbmNsdWRlcy9qcy9qcXVlcnkvdWkvYXV=b2NvbXBsZXRlLm1pbi5qcyI7czozNzoiZDBmZjNlYmE2MjU4NjUxNzczYzNhNWNjOTA5ZWZkZTZPODI4MyI7czozOToiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS91aS9idXR=b24ubWluLmpzIjtzOjM3OiIyY2U5OWUxZWQwOGRmMzUxZTZhNThlYjRiNmJjYmZhOU83MjM2IjtzOjM3OiIvd3AtaW5jbHVkZXMvanMvanF1ZXJ5L3VpL2NvcmUubWluLmpzIjtzOjM3OiI5Y2U=ZTE1NzQ=ODQ4N2Q=ZWZlMGNhNTM4ZjY1NmE3MU8=MDAwIjtzOjQzOiIvd3AtaW5jbHVkZXMvanMvanF1ZXJ5L3VpL2RhdGVwaWNrZXIubWluLmpzIjtzOjM4OiJjZmI2M2RjMThmZGU1M2ZlZjRkNGZkYzE5ZGRmZGNkNk8zNjUwOCI7czozOToiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS91aS9kaWFsb2cubWluLmpzIjtzOjM4OiIzZWNkOTU5MGFhYzc3ODUxNGY=ZTY5OTc1ZWQ5MWE2Mk8xMjEzOSI7czo=MjoiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS91aS9kcmFnZ2FibGUubWluLmpzIjtzOjM4OiI=NDNjMjc3Nzg5YmFmNjljNDkwMDE5ZDU5YzFiMzZlZE8xODkwNSI7czo=MjoiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS91aS9kcm9wcGFibGUubWluLmpzIjtzOjM3OiJkZWJmNTIyNGM=MTYyODg3ZDFhNmUzMTk4ZWQ5NTNkOE82MjY3IjtzOjQ1OiIvd3AtaW5jbHVkZXMvanMvanF1ZXJ5L3VpL2VmZmVjdC1ibGluZC5taW4uanMiO3M6Mzc6ImFkZGJlMDlmMTczYzRmMWJkODZkNDFhYzVmM2I=ZjRjTzExMzkiO3M6NDY6Ii93cC1pbmNsdWRlcy9qcy9qcXVlcnkvdWkvZWZmZWN=LWJvdW5jZS5taW4uanMiO3M6Mzc6IjRiYzRjOTc5MjRiZWE=YmY3YjA=ZDdiNDZmZjRmNjRjTzEyNDciO3M6NDQ6Ii93cC1pbmNsdWRlcy9qcy9qcXVlcnkvdWkvZWZmZWN=LWNsaXAubWluLmpzIjtzOjM2OiJjNzkzOTQ1N2U4YWIyMzFiOTUxNzEzNDc1YTA1NjE3M=85MTgiO3M6NDQ6Ii93cC1pbmNsdWRlcy9qcy9qcXVlcnkvdWkvZWZmZWN=LWRyb3AubWluLmpzIjtzOjM2OiI1N2ZlNTYwODg3Y2FjN2E1YjI1OTgxODg=NjMyOTBlOE85OTciO3M6NDc6Ii93cC1pbmNsdWRlcy9qcy9qcXVlcnkvdWkvZWZmZWN=LWV4cGxvZGUubWluLmpzIjtzOjM3OiJjMGRmNjI1Y2NhNDE4Y2ZkODAzYTExNTE=YTNkZDFlNk8xMTc2IjtzOjQ=OiIvd3AtaW5jbHVkZXMvanMvanF1ZXJ5L3VpL2VmZmVjdC1mYWRlLm1pbi5qcyI7czozNjoiOWY2ZmQ2NGY=ZjVmZjU4OTNiN2I3MmEyMzUyNDZkMGNPNTE1IjtzOjQ=OiIvd3AtaW5jbHVkZXMvanMvanF1ZXJ5L3VpL2VmZmVjdC1mb2xkLm1pbi5qcyI7czozNzoiOGQzNjVlYzFiM2E3ZWU4MmY5M2M5YWZkNDQxZTQ1NmNPMTAzMCI7czo=OToiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS91aS9lZmZlY3QtaGlnaGxpZ2h=Lm1pbi5qcyI7czozNjoiOTVlOGViZTYyYWRmMTg3ZmI=YzNiODRlYjViZWY4MjFPNzg5IjtzOjQ=OiIvd3AtaW5jbHVkZXMvanMvanF1ZXJ5L3VpL2VmZmVjdC1wdWZmLm1pbi5qcyI7czozNjoiZmU=OTZkNmM5ZDYzYmM=Nzg1NDA4NGM4YjNmYzIwZDZPNzgzIjtzOjQ3OiIvd3AtaW5jbHVkZXMvanMvanF1ZXJ5L3VpL2VmZmVjdC1wdWxzYXRlLm1pbi5qcyI7czozNjoiYmY4MzZmMjA1MzA=NDAxMTVhMmE4NDg3Y2E3MDIxYzVPNzk4IjtzOjQ1OiIvd3AtaW5jbHVkZXMvanMvanF1ZXJ5L3VpL2VmZmVjdC1zY2FsZS5taW4uanMiO3M6Mzc6ImQ1N2QwODMwNjUyYzI5YzNlMGUzMDFiMDJiNmRiNzU=TzExMjIiO3M6NDU6Ii93cC1pbmNsdWRlcy9qcy9qcXVlcnkvdWkvZWZmZWN=LXNoYWtlLm1pbi5qcyI7czozNzoiMjYwY2JhZmNiY2VkYzIzMzQ4YTM3MWNiODAwODMxMTJPMTEwMSI7czo=NDoiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS91aS9lZmZlY3Qtc2l6ZS5taW4uanMiO3M6Mzc6ImIwMGUzZGZkNmVlYmNjZDVlYTlhZWIzMjkzZDg1YTI1TzMzNTEiO3M6NDU6Ii93cC1pbmNsdWRlcy9qcy9qcXVlcnkvdWkvZWZmZWN=LXNsaWRlLm1pbi5qcyI7czozNjoiZmEyMzQ3NWZiMDFjOGY=ZDU2ZGE5OGNhMGMxMTc5YjVPOTYyIjtzOjQ4OiIvd3AtaW5jbHVkZXMvanMvanF1ZXJ5L3VpL2VmZmVjdC1=cmFuc2Zlci5taW4uanMiO3M6MzY6IjA3ZTViMGRlYTgwMDc3N2RkMjEwODc4OGI1NmVmOTBiTzg1NyI7czozOToiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS91aS9lZmZlY3QubWluLmpzIjtzOjM4OiIzZjcxNjFjZjEzOWQ1YTJjNWU2ZDM=ZTFjMDAyNmY5ZE8xMzQyMCI7czozNzoiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS91aS9tZW51Lm1pbi5qcyI7czozNzoiYzkxY2ZmZjUwNzE1NDQxMjk1ZmU3NDYzYmI1ZDM4OTRPOTYwMCI7czozODoiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS91aS9tb3VzZS5taW4uanMiO3M6Mzc6IjgyODM1YTg5NjBkZGQ3MzAyMDM4OWRiZmE=NWMzOWEwTzMxNDgiO3M6NDE6Ii93cC1pbmNsdWRlcy9qcy9qcXVlcnkvdWkvcG9zaXRpb24ubWluLmpzIjtzOjM3OiIxYzRhMTNlZGVjMTk1ODgxN2U4MzQzM2FlYWE=MmY2Mk82NTI3IjtzOjQ=OiIvd3AtaW5jbHVkZXMvanMvanF1ZXJ5L3VpL3Byb2dyZXNzYmFyLm1pbi5qcyI7czozNzoiYjk=ZDcxZGE1NGQ5YjQ=MTNmZmE=YzdkNzkyMjY5YzVPMjQ3MiI7czo=MjoiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS91aS9yZXNpemFibGUubWluLmpzIjtzOjM4OiJhNTAwMTAzMjE3N2M=OTJjZjBmZjdjODZiYzAxMTY5Zk8xODQyNiI7czo=MzoiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS91aS9zZWxlY3RhYmxlLm1pbi5qcyI7czozNzoiYjYzMmFkZDE5MWVjYWU5MmU2YTdiNmI5NzIxMmE2NDBPNDI1OCI7czo=MzoiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS91aS9zZWxlY3RtZW51Lm1pbi5qcyI7czozNzoiY2I3ZGI=Y2JhYTMyOGUzOTVhNjgwYzc4NjkyMjM2ZjBPODM4NCI7czozOToiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS91aS9zbGlkZXIubWluLmpzIjtzOjM4OiI5NDA4ZWZlMmNlNWE2YjQzNjRmMzRjYmRhMDJmODE=Yk8xMDk4NyI7czo=MToiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS91aS9zb3J=YWJsZS5taW4uanMiO3M6Mzg6IjI4OTZlOTBjYzE3ZTlhYmMxNjBlZDk2YmI4NmIwN2UzTzI=ODk5IjtzOjQwOiIvd3AtaW5jbHVkZXMvanMvanF1ZXJ5L3VpL3NwaW5uZXIubWluLmpzIjtzOjM3OiIzYWNmMzJkYTYxMmJmMzUyMjFjMDkzOTQ4NTY1OTFkY=83MTA=IjtzOjM3OiIvd3AtaW5jbHVkZXMvanMvanF1ZXJ5L3VpL3RhYnMubWluLmpzIjtzOjM4OiI1MzMwYzgzNDI1YWIxYjhmNjdjZTYzZjc=MTQyN2FkYk8xMjExMCI7czo=MDoiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS91aS9=b29sdGlwLm1pbi5qcyI7czozNzoiNDQzZjY4NjkwZDg=ZWVlNDJjZjMwMTkwNzEzNDA3MzBPNTcwNSI7czozOToiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS91aS93aWRnZXQubWluLmpzIjtzOjM3OiI4Y2Y3ZjM2YmJkNzliYzA2NjRiNjExM2Y3YTc4MzdmZU82OTA4IjtzOjI=OiIvd3AtaW5jbHVkZXMvanMvanNvbjIuanMiO3M6Mzg6IjczYTFkNzdiNGU4MjdjNDUwNjFmNGZhYjA=MTAzMGE5TzE4NDIyIjtzOjI4OiIvd3AtaW5jbHVkZXMvanMvanNvbjIubWluLmpzIjtzOjM3OiIzNWQ4OTlhODE5ODYxNzNmNDRmOWJiZTY4NmNjNTgzY=8zMTMzIjtzOjMwOiIvd3AtaW5jbHVkZXMvanMvbWFzb25yeS5taW4uanMiO3M6Mzg6IjU=MjBiNjUxNmMxNDI=NWI1MDRlNzI=MGE4MzEwZjJjTzI4OTU=IjtzOjI3OiIvd3AtaW5jbHVkZXMvanMvbWNlLXZpZXcuanMiO3M6Mzg6IjEzNDg3NTkwMWM=YWVlYzlkZDRkNzkxODI4ZTYzNWExTzI=NDU1IjtzOjMxOiIvd3AtaW5jbHVkZXMvanMvbWNlLXZpZXcubWluLmpzIjtzOjM3OiIyNmE2NGI1ODU3ZjFmYTk4MTY3ODU2YWMzOWIwYTI2OE85MTgzIjtzOjM1OiIvd3AtaW5jbHVkZXMvanMvbWVkaWEtYXVkaW92aWRlby5qcyI7czozODoiZjI1NjUwM2NhYTZiYzIzYjQ=YzgyZTNmNDZiNmIyM2JPMjI=MjMiO3M6Mzk6Ii93cC1pbmNsdWRlcy9qcy9tZWRpYS1hdWRpb3ZpZGVvLm1pbi5qcyI7czozODoiZjA5MzEwMGQ1MzlmMDNiNWQxZDMxZjFlNzQwMjliNDRPMTI4ODMiO3M6MzE6Ii93cC1pbmNsdWRlcy9qcy9tZWRpYS1lZGl=b3IuanMiO3M6Mzg6IjRjNjlhMTU5OWJkNjg2OGEzMWNkNDNiN2Y4OTk5NjRkTzI5ODY4IjtzOjM1OiIvd3AtaW5jbHVkZXMvanMvbWVkaWEtZWRpdG9yLm1pbi5qcyI7czozODoiNzljZjUxYmFlMjU5M2I3YWMyN2I3Mzc4OWU=MzY=NmRPMTA5MDUiO3M6Mjk6Ii93cC1pbmNsdWRlcy9qcy9tZWRpYS1ncmlkLmpzIjtzOjM4OiI4NDZiYmYyZTNhY2MxNTZjZTRkNmRlYjc3MmM3MDNiM=8yMzYyNCI7czozMzoiL3dwLWluY2x1ZGVzL2pzL21lZGlhLWdyaWQubWluLmpzIjtzOjM4OiI3NmZlNjg4NjE2NTQ2NTM=OTFlYzhhNjhjZWIyZGE=Y=8xMzM5OCI7czozMToiL3dwLWluY2x1ZGVzL2pzL21lZGlhLW1vZGVscy5qcyI7czozODoiOWRiZDczOTVmYWMwZjZmMTA2NWJkNTIzMWQxNDk=MWZPNDExNzUiO3M6MzU6Ii93cC1pbmNsdWRlcy9qcy9tZWRpYS1tb2RlbHMubWluLmpzIjtzOjM4OiJlZWQ5ODEzYmFkNTkyZDQyODdiZTBlYjBlYmI2ODQ5N=8xMzcwNSI7czozMDoiL3dwLWluY2x1ZGVzL2pzL21lZGlhLXZpZXdzLmpzIjtzOjM5OiI2ZmFkMDk1YzZmMjk1MTMxODQ=YWZiZmIwODk5NTZkM=8yMjk5ODgiO3M6MzQ6Ii93cC1pbmNsdWRlcy9qcy9tZWRpYS12aWV3cy5taW4uanMiO3M6Mzk6ImU1MDFiZTkxZjgyY2JkYTU3MDU4MmQwMGNlNDNjMDU=TzEwNDQwOSI7czo=MzoiL3dwLWluY2x1ZGVzL2pzL21lZGlhZWxlbWVudC9iYWNrZ3JvdW5kLnBuZyI7czozNjoiNzAzYzY1OWU=YmY1NjNhMDVjNjMzOGExNzI3ZTAwNmNPMTY2IjtzOjQwOiIvd3AtaW5jbHVkZXMvanMvbWVkaWFlbGVtZW5=L2JpZ3BsYXkucG5nIjtzOjM3OiI3MTY=MzZmYjNkZjBkMjllNmIzN2RkNjJkOTUyNjc2YU8zMDAxIjtzOjQwOiIvd3AtaW5jbHVkZXMvanMvbWVkaWFlbGVtZW5=L2JpZ3BsYXkuc3ZnIjtzOjM3OiI3NDZjM2FmN2ExNDVhMDkyMzlhMzZlNWVmNjFjZmVhME8xMDI5IjtzOjQxOiIvd3AtaW5jbHVkZXMvanMvbWVkaWFlbGVtZW5=L2NvbnRyb2xzLnBuZyI7czozNzoiMjRhMDIyN2ZiZGQzYWNmZDg2ZmYwM2ZjM2ZjNmM4YTRPMTg5MiI7czo=MToiL3dwLWluY2x1ZGVzL2pzL21lZGlhZWxlbWVudC9jb25=cm9scy5zdmciO3M6Mzg6IjQwZjU2ZjVhNzM2ZGE=ZWZmZWI3OTBjZWRiOGE1MmYwTzEwMzQ=IjtzOjUwOiIvd3AtaW5jbHVkZXMvanMvbWVkaWFlbGVtZW5=L2ZsYXNobWVkaWFlbGVtZW5=LnN3ZiI7czozOToiMmVmZTFmYWJmZWEwNDQzMmYwOTBlY2IzMTUzYjEwYTFPMTMwMDU=IjtzOjQ2OiIvd3AtaW5jbHVkZXMvanMvbWVkaWFlbGVtZW5=L2Zyb29nYWxvb3AubWluLmpzIjtzOjM3OiIyYTg3NDJjMGFjMWNkYmVjMjNiZTQ=YTdkNGU5YTNjOU8xNzY5IjtzOjQ=OiIvd3AtaW5jbHVkZXMvanMvbWVkaWFlbGVtZW5=L2p1bXBmb3J3YXJkLnBuZyI7czozNzoiMTVlMWFjOGNiYWNjMmVmZGYxYWMyNjc3ZGU=OGEyNTNPMTU2MyI7czo=MDoiL3dwLWluY2x1ZGVzL2pzL21lZGlhZWxlbWVudC9sb2FkaW5nLmdpZiI7czozNzoiNzZiMzI2ZjRkNDQyMjIxMjZmZWUyMTA3NjU5NWJlZjVPNjIyNCI7czo1OToiL3dwLWluY2x1ZGVzL2pzL21lZGlhZWxlbWVudC9tZWRpYWVsZW1lbnQtYW5kLXBsYXllci5taW4uanMiO3M6Mzg6Ijg5NzBlNmU2NzJhMWQzMTJjOGQ4ZWY=NzFmZmI3ZDVmTzgyNjI1IjtzOjU1OiIvd3AtaW5jbHVkZXMvanMvbWVkaWFlbGVtZW5=L21lZGlhZWxlbWVudHBsYXllci5taW4uY3NzIjtzOjM4OiIwNjg3ZTMzZTg=YTg2MGMzM2EzYTg4NTE5M2E2ZDkzN=8yMDQzMSI7czo1NjoiL3dwLWluY2x1ZGVzL2pzL21lZGlhZWxlbWVudC9zaWx2ZXJsaWdodG1lZGlhZWxlbWVudC54YXAiO3M6Mzg6ImQwZTQ=ZmQ2ZWNlYmNhNDZmMzZkNzM=YjMwMTJhYTJjTzEyNDU5IjtzOjQxOiIvd3AtaW5jbHVkZXMvanMvbWVkaWFlbGVtZW5=L3NraXBiYWNrLnBuZyI7czozNzoiY2Q2ZGM4MzBlYjQ1YjNhNWE5NmJiYzkzNmZmNTQ4NDZPNDI=NSI7czo=ODoiL3dwLWluY2x1ZGVzL2pzL21lZGlhZWxlbWVudC93cC1tZWRpYWVsZW1lbnQuY3NzIjtzOjM3OiIwMGY4ZWIzN2Q=ODczYWZmMzM1NTliZTFhYjNhNWRhME81Mjc2IjtzOjQ3OiIvd3AtaW5jbHVkZXMvanMvbWVkaWFlbGVtZW5=L3dwLW1lZGlhZWxlbWVudC5qcyI7czozNzoiMWQ4ODljOTlmMDRhMzk1NzNkNGJlNWIzNDZjNjI3MmZPMTUzNSI7czo1MjoiL3dwLWluY2x1ZGVzL2pzL21lZGlhZWxlbWVudC93cC1tZWRpYWVsZW1lbnQubWluLmNzcyI7czozNzoiNzRjYTA4NGY2NzkxYWY=NTUyN2JlNGI1MzE5MDk1MTJPNDQ3NyI7czo1MToiL3dwLWluY2x1ZGVzL2pzL21lZGlhZWxlbWVudC93cC1tZWRpYWVsZW1lbnQubWluLmpzIjtzOjM2OiI4ZTdhNDQwNWQzNTEzOWY2Mjg3MWE1Mzk1MTY2NzlhMU83OTYiO3M6NDM6Ii93cC1pbmNsdWRlcy9qcy9tZWRpYWVsZW1lbnQvd3AtcGxheWxpc3QuanMiO3M6Mzc6ImFhZjc3Zjc=ODFmNDE5ZjVmOGM=NmFlMzM4ODIwNDQzTzQ3MTciO3M6NDc6Ii93cC1pbmNsdWRlcy9qcy9tZWRpYWVsZW1lbnQvd3AtcGxheWxpc3QubWluLmpzIjtzOjM3OiIyNjQ1NjNlOTRlMmQxNmIxMDY2YmQ=MTNlYmM1OTJkZU8zMzU=IjtzOjM2OiIvd3AtaW5jbHVkZXMvanMvcGx1cGxvYWQvaGFuZGxlcnMuanMiO3M6Mzg6IjA2ZTRkNjRlMDk5NDY2ZWFhMzE4NWYxODUwODg=ODIxTzE2MjU2IjtzOjQwOiIvd3AtaW5jbHVkZXMvanMvcGx1cGxvYWQvaGFuZGxlcnMubWluLmpzIjtzOjM4OiIzZWE=MGFiN2MyN2I3NWQyMGMzZGEyMmYwOTdkNjYxNE8xMDY4MSI7czozNjoiL3dwLWluY2x1ZGVzL2pzL3BsdXBsb2FkL2xpY2Vuc2UudHh=IjtzOjM4OiI3NTE=MTkyNjBhYTk1NDQ5OWY3YWJhYWJhYTg4MmJiZU8xNzk4NyI7czo=MzoiL3dwLWluY2x1ZGVzL2pzL3BsdXBsb2FkL3BsdXBsb2FkLmZsYXNoLnN3ZiI7czozODoiMzcwZDc2OGU=NTUyNGY=N2ZiZDI5ODg5NzRkM2Q3NmNPMjk1NzAiO3M6NDU6Ii93cC1pbmNsdWRlcy9qcy9wbHVwbG9hZC9wbHVwbG9hZC5mdWxsLm1pbi5qcyI7czozOToiNGE=MzFmYjQwNDliMjQ1NjZkMjdjMTJlMjc5M2Q4MThPMTEzMDgxIjtzOjQ5OiIvd3AtaW5jbHVkZXMvanMvcGx1cGxvYWQvcGx1cGxvYWQuc2lsdmVybGlnaHQueGFwIjtzOjM4OiI3NDcxMDBjMTg1Y2YzM2Y2NTg4OTMwYTU5NDFkNjJmN=82MzExOCI7czozOToiL3dwLWluY2x1ZGVzL2pzL3BsdXBsb2FkL3dwLXBsdXBsb2FkLmpzIjtzOjM4OiIyYjZmMGNjNTRlMzgxZmQ1MmYzYTM3MjZlMDljMWQwN=8xMjcxNCI7czo=MzoiL3dwLWluY2x1ZGVzL2pzL3BsdXBsb2FkL3dwLXBsdXBsb2FkLm1pbi5qcyI7czozNzoiN2M3NGEwZjg2NmM1ZGZkMWRjOWE=NTQ3NDY1MWY2ZWZPNDkyMCI7czoyODoiL3dwLWluY2x1ZGVzL2pzL3F1aWNrdGFncy5qcyI7czozODoiNDgxZTkwNGRkNzA2ZjUxYWY=YmYyZmFhNDA3MDE2NWJPMjE2OTYiO3M6MzI6Ii93cC1pbmNsdWRlcy9qcy9xdWlja3RhZ3MubWluLmpzIjtzOjM4OiI2YTM2NWMyZmNkNTI1NjZhZTlmZDNkYjlhMjhjNjczZE8xMDc2MSI7czoyODoiL3dwLWluY2x1ZGVzL2pzL3Nob3J=Y29kZS5qcyI7czozODoiZmM4Y2I1ODBlMGVkYzVjZGExYTU1MDc=N2QwZGU2YzlPMTAzNjYiO3M6MzI6Ii93cC1pbmNsdWRlcy9qcy9zaG9ydGNvZGUubWluLmpzIjtzOjM3OiJiMzQyZDU2YTkwYjA5YWRmYWQ2ZDk1YTQ3MTdjMGIyNE8yNTc3IjtzOjI4OiIvd3AtaW5jbHVkZXMvanMvc3dmb2JqZWN=LmpzIjtzOjM4OiI5ZmZkYmEyY2ZmNDk3ZDcwMTY4NDY1N2UzMjk4NzFmNU8xMDIzMSI7czozNzoiL3dwLWluY2x1ZGVzL2pzL3N3ZnVwbG9hZC9oYW5kbGVycy5qcyI7czozODoiMTRiMmQwNGZkYjg1YmMxZjE3MWNmM2RmYjI5ODdkY2FPMTI2NTUiO3M6NDE6Ii93cC1pbmNsdWRlcy9qcy9zd2Z1cGxvYWQvaGFuZGxlcnMubWluLmpzIjtzOjM3OiI5NjU5MmM2YjNmYWQ1ODBjZTA=ZTEyYmMzMDQ3ZWYzYk84ODY3IjtzOjM3OiIvd3AtaW5jbHVkZXMvanMvc3dmdXBsb2FkL2xpY2Vuc2UudHh=IjtzOjM3OiJjYmUwNWJiMDYwYzg1ZTA3ODgyZGMwNmZmNzUxNTc3YU8xNTQwIjtzOjU=OiIvd3AtaW5jbHVkZXMvanMvc3dmdXBsb2FkL3BsdWdpbnMvc3dmdXBsb2FkLmNvb2tpZXMuanMiO3M6Mzc6IjdmYTU3ZWMwMGRkYTg4ZGQ2YjVjMjAzN2NjYjRkNWNmTzE1NzIiO3M6NTI6Ii93cC1pbmNsdWRlcy9qcy9zd2Z1cGxvYWQvcGx1Z2lucy9zd2Z1cGxvYWQucXVldWUuanMiO3M6Mzc6Ijk5NTM1MjJmYmQ=YTFiMDJiYmY2MzVhOTJkNzZjZDhmTzMzODMiO3M6NTI6Ii93cC1pbmNsdWRlcy9qcy9zd2Z1cGxvYWQvcGx1Z2lucy9zd2Z1cGxvYWQuc3BlZWQuanMiO3M6Mzg6IjQxNWEzNzg3ODQ2YmI2YzJkNzQ1NjAyYzJhZmI3M2FjTzEyMjM=IjtzOjU2OiIvd3AtaW5jbHVkZXMvanMvc3dmdXBsb2FkL3BsdWdpbnMvc3dmdXBsb2FkLnN3Zm9iamVjdC5qcyI7czozNzoiY2NiNTE1NzFhNzU2MzdkYjA4NTQ1Y2FhZjJlZDllNzNPMzkyNiI7czozODoiL3dwLWluY2x1ZGVzL2pzL3N3ZnVwbG9hZC9zd2Z1cGxvYWQuanMiO3M6Mzg6IjZjZDM3MGJmZDRkODZjNDRhYzE1NWZkOTEzZTk3MWFjTzM3NjkwIjtzOjM5OiIvd3AtaW5jbHVkZXMvanMvc3dmdXBsb2FkL3N3ZnVwbG9hZC5zd2YiO3M6Mzg6ImJkNWEyNWYyMzU4OTY1MmNhNDcyZDQxZmUxNDg=ZjBjTzEzMTMzIjtzOjQ1OiIvd3AtaW5jbHVkZXMvanMvdGhpY2tib3gvbG9hZGluZ=FuaW1hdGlvbi5naWYiO3M6Mzg6ImNlMjI2ODAzMGRkMjE1MWI2M2NkZjRmZmMyZjYyNmJhTzE1MjM4IjtzOjQwOiIvd3AtaW5jbHVkZXMvanMvdGhpY2tib3gvbWFjRkZCZ=hhY2sucG5nIjtzOjM1OiIxODkyMTdjOGIwNjdlZjg2YWRkNzU3OTIyYzJmNzViNE85NCI7czozNzoiL3dwLWluY2x1ZGVzL2pzL3RoaWNrYm94L3RoaWNrYm94LmNzcyI7czozNzoiODA1YWExNTBhMzkxZTQ=ZTMyNDVmMjVlYTgzYmRmY2JPMjY1NSI7czozNjoiL3dwLWluY2x1ZGVzL2pzL3RoaWNrYm94L3RoaWNrYm94LmpzIjtzOjM4OiJkNWQyNDhhODczMDc1NDU4N2I=MjI=YzJkOWFkMzZjN=8xMzE2MyI7czo=NDoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvbGFuZ3Mvd3AtbGFuZ3MtZW4uanMiO3M6Mzg6IjA4Zjg2NjlmNzQ1M2IxNzU2M2E2MmU2YmJiMzc2MTM3TzE1NTk5IjtzOjM1OiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9saWNlbnNlLnR4dCI7czozODoiMDQ1ZDA=ZTE3NDIyZDk5ZTMzOGRhNzViOWM3NDliN2NPMjY=MjciO3M6NDk6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3BsdWdpbnMvY2hhcm1hcC9wbHVnaW4uanMiO3M6Mzg6ImQ5OTVhZWFlZjgxOTdjMjNjYjFlMTRlM2E=NzliYzAwTzExNTM2IjtzOjUzOiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9wbHVnaW5zL2NoYXJtYXAvcGx1Z2luLm1pbi5qcyI7czozNzoiYmM1YThjYzIxM2JiM2ZlNTFiNTY3M2I2NGRkOWQ=MDhPODE5OSI7czo1MzoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvcGx1Z2lucy9jb2xvcnBpY2tlci9wbHVnaW4uanMiO3M6Mzc6IjIyNTM4YzQ5ZjUyNDA1MGJkODMwMGI=NDUyNmFiYzJhTzI=NTAiO3M6NTc6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3BsdWdpbnMvY29sb3JwaWNrZXIvcGx1Z2luLm1pbi5qcyI7czozNzoiMTU4MWJiMDIyODZmNTRiNGZiMGNjZTUyZDJlZjYxYzdPMTIyMiI7czo1NToiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvcGx1Z2lucy9jb21wYXQzeC9jc3MvZGlhbG9nLmNzcyI7czozNzoiZTUzMTMxNjhmYjJiNjU3YTRiZDJmNWUwNmI5MzFhMjJPODAzMCI7czo1MDoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvcGx1Z2lucy9jb21wYXQzeC9wbHVnaW4uanMiO3M6Mzc6IjUyMTBjYzkxMzUzNDZkY2MxNWM5MjU4ZWFlNTU4NjhhTzgyODAiO3M6NTQ6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3BsdWdpbnMvY29tcGF=M3gvcGx1Z2luLm1pbi5qcyI7czozNzoiNTc5OGUzZDJmYjAxODBhOTE3OWI4YmQ3Y2Y3MjhlYWVPMzk4NyI7czo1NjoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvcGx1Z2lucy9kaXJlY3Rpb25hbGl=eS9wbHVnaW4uanMiO3M6Mzc6IjVmMjEzODViMWY=NTEzNTY4ZDYxMWQ1OTUwNDBkMTQxTzE=NjUiO3M6NjA6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3BsdWdpbnMvZGlyZWN=aW9uYWxpdHkvcGx1Z2luLm1pbi5qcyI7czozNjoiNjBkZTU3MjUzY2E5MTQzYTZmMWU=YWZmMTBmYzM5ZDJPNzI2IjtzOjUyOiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9wbHVnaW5zL2Z1bGxzY3JlZW4vcGx1Z2luLmpzIjtzOjM3OiJhZTk4M2I5YTdhOGQwYWQ=M2NhZDVlZjVhZDg1YzFhYk8zNTg3IjtzOjU2OiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9wbHVnaW5zL2Z1bGxzY3JlZW4vcGx1Z2luLm1pbi5qcyI7czozNzoiYmExYWQ=YmM=M2UyYWE=MzY2MTMwN2E1NTk5YjQ4YzVPMTY4MCI7czo=NDoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvcGx1Z2lucy9oci9wbHVnaW4uanMiO3M6MzY6IjQyOGM5ZmI=N2E3YjgzZmEwNDQwYTE1ODg2ZDBiMTFhTzY=OCI7czo=ODoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvcGx1Z2lucy9oci9wbHVnaW4ubWluLmpzIjtzOjM2OiI1YzIzMjU1YWQyZDExZGIzZjcyYzMzYjY=OWYxMzg5YU8zMjIiO3M6NDc6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3BsdWdpbnMvaW1hZ2UvcGx1Z2luLmpzIjtzOjM4OiI=NTg=YWY5YmE4YzQzOTYwNGU=MTk5MTY4MTc2YTdiN=8xNjQ1NSI7czo1MToiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvcGx1Z2lucy9pbWFnZS9wbHVnaW4ubWluLmpzIjtzOjM3OiI1NTA2NWI=ZDkwMDY5MmQ=MzA4ZDk3ZTc5YTBmYTAyM=84NDIxIjtzOjQ3OiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9wbHVnaW5zL2xpc3RzL3BsdWdpbi5qcyI7czozODoiZWJiMDNlOTUxYmI4N2Y=YWE2OWExMzI4ZGEwODI1MjJPMjMxNjgiO3M6NTE6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3BsdWdpbnMvbGlzdHMvcGx1Z2luLm1pbi5qcyI7czozNzoiYzU2NDY3NDRlZGU3MDJiNjY4ZmIzMTQ1NjliMzdhNTFPOTcwNSI7czo1MzoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvcGx1Z2lucy9tZWRpYS9tb3hpZXBsYXllci5zd2YiO3M6Mzg6IjRlNTlkMzRlZmIyZGEwYjlhMDMzNTk2YTg1ZTRiMWVmTzIwMDE3IjtzOjQ3OiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9wbHVnaW5zL21lZGlhL3BsdWdpbi5qcyI7czozODoiMDk2NmRhNDg3NDliNmUwODkwMTRhMzc4MmMzMjk5OTlPMjIyOTgiO3M6NTE6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3BsdWdpbnMvbWVkaWEvcGx1Z2luLm1pbi5qcyI7czozODoiYjE1YjBmZWRmNDA=MzY5NjQ4MjJkNGMyMjVlMzZiZGJPMTE2OTYiO3M6NDc6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3BsdWdpbnMvcGFzdGUvcGx1Z2luLmpzIjtzOjM4OiI2YTY1ZjM=NWM5MmUxYjNiMmM1MmUzMjNhNzM5YTAzZk81MjE4NCI7czo1MToiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvcGx1Z2lucy9wYXN=ZS9wbHVnaW4ubWluLmpzIjtzOjM4OiI2OWE2NTkyNzQ2NmRhYjgzNGY1ZDQ4YzI4YzhjMjNiYk8xNzU2MyI7czo1MDoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvcGx1Z2lucy9=YWJmb2N1cy9wbHVnaW4uanMiO3M6Mzc6IjZhNWQ3ODRjMmFjMmNlNWY2NGUwOTY4YzM1NDkyZjAzTzI1MDUiO3M6NTQ6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3BsdWdpbnMvdGFiZm9jdXMvcGx1Z2luLm1pbi5qcyI7czozNzoiZjE5N2NkOTNiMjgyMTA5MjNlMzU5MGM=NDM4ZWI4OTZPMTI3MCI7czo1MToiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvcGx1Z2lucy9=ZXh=Y29sb3IvcGx1Z2luLmpzIjtzOjM3OiI1MjcyYTk5NTE2YzQ2Nzc3MWVmMzA3NjQyMmJlYjE4Zk83MTg5IjtzOjU1OiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9wbHVnaW5zL3RleHRjb2xvci9wbHVnaW4ubWluLmpzIjtzOjM3OiI2OGM5OWI5Y2VhY2Y5MWI=ZTNjM2I=NzFiYTM=OWNmMk8=MTQ1IjtzOjUxOiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9wbHVnaW5zL3dvcmRwcmVzcy9wbHVnaW4uanMiO3M6Mzg6ImRiNzYyNjk1ZmQ1YThkNzY5YjZhNjAwMjQ1MWRiMmJjTzI5MTE2IjtzOjU1OiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9wbHVnaW5zL3dvcmRwcmVzcy9wbHVnaW4ubWluLmpzIjtzOjM4OiIyMGMyYWM2ZGM2NTQ2NDE5MjQ1NjYwNmRhZTA2ZWFlNE8xNDg4MSI7czo1NDoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvcGx1Z2lucy93cGF1dG9yZXNpemUvcGx1Z2luLmpzIjtzOjM3OiI2NDBjYmMwMDU4NjM4YzRmYjA=MDAzNzBkYmNmMjVhM=81OTY2IjtzOjU4OiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9wbHVnaW5zL3dwYXV=b3Jlc2l6ZS9wbHVnaW4ubWluLmpzIjtzOjM3OiI4NjA3ZTg3ZGNiYjM1MWQwNjdkMWE1NDQ4NWU4YTM1N=8yMzk5IjtzOjUxOiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9wbHVnaW5zL3dwZGlhbG9ncy9wbHVnaW4uanMiO3M6Mzc6IjA2ZjdhZWNiNWJkZmEyODczOWVlYTBhNDk4ZDE1YTgxTzI=MzYiO3M6NTU6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3BsdWdpbnMvd3BkaWFsb2dzL3BsdWdpbi5taW4uanMiO3M6Mzc6ImVhZmJiMTQ3ODk4MWUzMzc5ODFkMjg3NDc=ZTI=MGI4TzEzNDUiO3M6NTM6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3BsdWdpbnMvd3BlZGl=aW1hZ2UvcGx1Z2luLmpzIjtzOjM4OiI=NzM4YjgyNjFhZThiMTFkYTcxZDEwYmU1NmMyNTgwN=8zMTA2MyI7czo1NzoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvcGx1Z2lucy93cGVkaXRpbWFnZS9wbHVnaW4ubWluLmpzIjtzOjM4OiJlYWEyMDg4NTFiNjYwODU2MjA3NzljYmYzZDMwZmVmYk8xNTA=NSI7czo=OToiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvcGx1Z2lucy93cGVtYmVkL3BsdWdpbi5qcyI7czozNjoiY2YzODJhZjU1MjJmYTlhMGJiM2YwNDkyMjVkZTE=ZWZPNDQ=IjtzOjUzOiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9wbHVnaW5zL3dwZW1iZWQvcGx1Z2luLm1pbi5qcyI7czozNjoiN2VjNDViY2JlOTkyYzc=YzA5NWE3NWJiMmQyY2YwZmZPMjgwIjtzOjQ5OiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9wbHVnaW5zL3dwZW1vamkvcGx1Z2luLmpzIjtzOjM3OiJmNzdhNjEzMWMxNTA2NTNkZGZhMTdhNTY4YTE5NjJkME8zNTQ2IjtzOjUzOiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9wbHVnaW5zL3dwZW1vamkvcGx1Z2luLm1pbi5qcyI7czozNzoiYzZjYzJjZTQ4NDJjZjM=NDk=YjIwODU1NDE4ZWM3ZWVPMTU2NCI7czo1MToiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvcGx1Z2lucy93cGdhbGxlcnkvcGx1Z2luLmpzIjtzOjM3OiI5ZDQ4MzQ1MDQ=ZTYxMTFmYmViOWQyZmI=NDRkNWM=OU8zMTgwIjtzOjU1OiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9wbHVnaW5zL3dwZ2FsbGVyeS9wbHVnaW4ubWluLmpzIjtzOjM3OiIwNGZiMzc2MDhlZjk=ZjlhNzQ3OTAxYjJmOThiNGZjZU8xNjYxIjtzOjQ4OiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9wbHVnaW5zL3dwbGluay9wbHVnaW4uanMiO3M6Mzg6IjViZDZkOWRjZGZhNjQzMDlhNGY=NzRlM2MxMDNjODdkTzE3NzU2IjtzOjUyOiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9wbHVnaW5zL3dwbGluay9wbHVnaW4ubWluLmpzIjtzOjM3OiI5YTY1YzZmNjk3OWVmNzA=MDFiMGI5MTliMDJlODNlY=84ODgwIjtzOjU1OiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9wbHVnaW5zL3dwdGV4dHBhdHRlcm4vcGx1Z2luLmpzIjtzOjM3OiJiYmUzMTEwOWJiNGEyOTU1YWM3M2MwYjBhYzFlOGQ4Y=84ODA2IjtzOjU5OiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9wbHVnaW5zL3dwdGV4dHBhdHRlcm4vcGx1Z2luLm1pbi5qcyI7czozNzoiYTkyZTQ1NjllOTI=NTA3NzZmMThlMGJiNmRkYWUxYjFPMzE2MiI7czo=ODoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvcGx1Z2lucy93cHZpZXcvcGx1Z2luLmpzIjtzOjM3OiIyNzM2MjMyNTZiYTM5ZWEyMmQ3NzA2ZTk=ZmE3YTcwNk81NjYzIjtzOjUyOiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9wbHVnaW5zL3dwdmlldy9wbHVnaW4ubWluLmpzIjtzOjM3OiIzNmNiY2JiMmY2MjViYjcyNmRmY2NkM2Y1YjQ3ZjI1M=8yNzAxIjtzOjYyOiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9za2lucy9saWdodGdyYXkvY29udGVudC5pbmxpbmUubWluLmNzcyI7czozNzoiOTY1MWMxMDgzOGE3N2ZiNGNjYTkwMGI=N2Q5ZDMzMWNPMjY3NiI7czo1NToiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2Uvc2tpbnMvbGlnaHRncmF5L2NvbnRlbnQubWluLmNzcyI7czozNzoiYTEyMDdiNDMyMTI3ZGRjMGMzODNhY2ZiNzExYjVhNzhPMzA5MSI7czo1NToiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2Uvc2tpbnMvbGlnaHRncmF5L2ZvbnRzL3JlYWRtZS5tZCI7czozNToiN2EwZjY=ODAwY2YzOGIyYmU4ZDNkYzQ1NDBlYzMxZGRPNjciO3M6NjM6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3NraW5zL2xpZ2h=Z3JheS9mb25=cy9=aW55bWNlLXNtYWxsLmVvdCI7czozNzoiMTJkMjZjMjg1YjcxZDc5MGY=YjBjOTQ=MjNlZjFmOTlPOTQ5MiI7czo2NDoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2Uvc2tpbnMvbGlnaHRncmF5L2ZvbnRzL3RpbnltY2Utc21hbGwuanNvbiI7czozODoiZmNmMWFiMGJiYWQ3ZDViZTExNWNhYzlmZmIzNjBhMmJPNDAyNzMiO3M6NjM6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3NraW5zL2xpZ2h=Z3JheS9mb25=cy9=aW55bWNlLXNtYWxsLnN2ZyI7czozODoiYTJhMWY3MzJjYzM=NzY=YzY4NGVkNTIxYzZmMzMyN2NPMjQ3MjciO3M6NjM6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3NraW5zL2xpZ2h=Z3JheS9mb25=cy9=aW55bWNlLXNtYWxsLnR=ZiI7czozNzoiMjg4MDY5NDBjNjQ3Y2Y2NzFiZWJmNGFlMDYzMGU1NzBPOTMwNCI7czo2NDoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2Uvc2tpbnMvbGlnaHRncmF5L2ZvbnRzL3RpbnltY2Utc21hbGwud29mZiI7czozNzoiN2UwYzg4ZjAyZGNhZjJmNzhjOTBiNGRjNzgyN2I3MDlPOTM4MCI7czo1NzoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2Uvc2tpbnMvbGlnaHRncmF5L2ZvbnRzL3RpbnltY2UuZW9=IjtzOjM4OiIyNDAzMTAwNjdhZmIzM2RmNjA2MzlkN2ZkMWZhMTMyZU8xNzI5MiI7czo1ODoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2Uvc2tpbnMvbGlnaHRncmF5L2ZvbnRzL3RpbnltY2UuanNvbiI7czozODoiODk5ZWZlMjJkNzlkZDBkNjc1YzEwNmEyNDJlMTg4NThPODc2NTQiO3M6NTc6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3NraW5zL2xpZ2h=Z3JheS9mb25=cy9=aW55bWNlLnN2ZyI7czozODoiZWRlODA4ZjZmMDQ2MDQ2ODFiMjVmODQzMDY5ZGUzNzlPNDUyMjYiO3M6NTc6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3NraW5zL2xpZ2h=Z3JheS9mb25=cy9=aW55bWNlLnR=ZiI7czozODoiMWZiMjUwYzNiOWJjMzRmZDUzY2Q4ODMwNzBlM2RmZmRPMTcxMjgiO3M6NTg6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3NraW5zL2xpZ2h=Z3JheS9mb25=cy9=aW55bWNlLndvZmYiO3M6Mzg6IjZiMGMzNzU=YjFjZDFmOTA1NjZlMTc=MDk4ZmFlOGY4TzE3MjA=IjtzOjU=OiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9za2lucy9saWdodGdyYXkvaW1nL2FuY2hvci5naWYiO3M6MzU6ImFiZDM2MTM1NzE4MDBmZGNjODkxMTgxZDVmMzRmODQwTzUzIjtzOjU=OiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9za2lucy9saWdodGdyYXkvaW1nL2xvYWRlci5naWYiO3M6Mzc6IjM5NGJhZmMzY2M=ZGZiM2EwZWU=OGMxZjU=NjY5NTM5TzI2MDgiO3M6NTQ6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3NraW5zL2xpZ2h=Z3JheS9pbWcvb2JqZWN=LmdpZiI7czozNjoiZjM3MjY=NTBkNzQ1N2Q3NTBhMmY=ZDk=NDFjN2VlMjBPMTUyIjtzOjUzOiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9za2lucy9saWdodGdyYXkvaW1nL3RyYW5zLmdpZiI7czozNToiMTJiZjllMTkzNzQ5MjBkZTMxNDZhNjQ3NzVmNDZhNWVPNDMiO3M6NTY6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3NraW5zL2xpZ2h=Z3JheS9za2luLmllNy5taW4uY3NzIjtzOjM4OiIxYWI2OGEwYzk1ZjI1MDE4OTMyM2I5ODZhNzA3ZjcwYU8zMzIwMSI7czo1MjoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2Uvc2tpbnMvbGlnaHRncmF5L3NraW4ubWluLmNzcyI7czozODoiMzY1ZGM1NTZiOTcwYWJmZTI4NDBlODE3MTg2Y2RmNDJPMzUzMjEiO3M6NTY6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3NraW5zL3dvcmRwcmVzcy9pbWFnZXMvYXVkaW8ucG5nIjtzOjM2OiIzNzdlMjFlNmRmZTAwMDhlZjdjNmQ=ZmQyMjA4NzcwYk8=MTIiO3M6NjQ6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3NraW5zL3dvcmRwcmVzcy9pbWFnZXMvZGFzaGljb24tZWRpdC5wbmciO3M6MzY6Ijc4NTJkZTA5YWM1OWI1NTg5ZWQ=ZGJkZGE=ZTRkZWU2TzM2OCI7czo2MjoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2Uvc2tpbnMvd29yZHByZXNzL2ltYWdlcy9kYXNoaWNvbi1uby5wbmciO3M6MzY6IjUyZDBjMDhmZTQ1YWNhM2Y2NjJlODFjNzM4ZjVlMjA5TzMzOSI7czo1OToiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2Uvc2tpbnMvd29yZHByZXNzL2ltYWdlcy9lbWJlZGRlZC5wbmciO3M6Mzc6ImY1OGRhYWEwNzBkZDRlYTIxYmQ2NzkwZjdlYzM2ZTIyTzgxNzciO3M6NjE6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3NraW5zL3dvcmRwcmVzcy9pbWFnZXMvZ2FsbGVyeS=yeC5wbmciO3M6MzY6IjFlY2FlZTMxZWMwMjlkZWQwZTE4ZjU3Njk1OGE1MjE=TzQ=NyI7czo1ODoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2Uvc2tpbnMvd29yZHByZXNzL2ltYWdlcy9nYWxsZXJ5LnBuZyI7czozNjoiYTEwNjVmYjE5ZjhjMTA1MDc3ZjliNDUwMTA1NWRiMzRPMzc5IjtzOjU4OiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9za2lucy93b3JkcHJlc3MvaW1hZ2VzL21vcmUtMngucG5nIjtzOjM2OiI2YzJjZDcwYjFjODk3MmNmMjViODVlMWU3OGE1MjUxZU82MDMiO3M6NTU6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3NraW5zL3dvcmRwcmVzcy9pbWFnZXMvbW9yZS5wbmciO3M6MzY6ImZjYjdiY2Q=MGFiYzBhNmQwMDNiZmMwZmNiYWJlNjdhTzQxNCI7czo2MzoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2Uvc2tpbnMvd29yZHByZXNzL2ltYWdlcy9wYWdlYnJlYWstMngucG5nIjtzOjM2OiI3YmNlMzZiZjIzNTU1MTNhZjc5MTdjMTkzZTIzZWJkNk84MzUiO3M6NjA6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3NraW5zL3dvcmRwcmVzcy9pbWFnZXMvcGFnZWJyZWFrLnBuZyI7czozNzoiZTQ=OWUzZGE2ZGM1MWY4NWZjNGM1NzExNzlkZDkzNDhPMTE=MCI7czo2NToiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2Uvc2tpbnMvd29yZHByZXNzL2ltYWdlcy9wbGF5bGlzdC1hdWRpby5wbmciO3M6MzY6IjU1MmNmYjNhMjlhYzAxYTBkODhiMDQyMmM1NTE3MTU5TzQ=MCI7czo2NToiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2Uvc2tpbnMvd29yZHByZXNzL2ltYWdlcy9wbGF5bGlzdC12aWRlby5wbmciO3M6MzY6ImE1NmM3YTU2MzY2MDc3NmQ1YTQyMWM3MzBiOGRjZmQ2TzI5MCI7czo1NjoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2Uvc2tpbnMvd29yZHByZXNzL2ltYWdlcy92aWRlby5wbmciO3M6MzY6ImQwYzJiNmY3YTA=MmE5M2QwZDdhYmIxZTgzMzM2YWMxTzM2MyI7czo1NDoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2Uvc2tpbnMvd29yZHByZXNzL3dwLWNvbnRlbnQuY3NzIjtzOjM3OiI3ODUzMmI1ZjFmZWRhOTE3Y2EzMWRjMTI=MTIyMDM2YU84MDM2IjtzOjQ2OiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9=aGVtZXMvaW5saXRlL3RoZW1lLmpzIjtzOjM4OiJmYjE=Njk4YTM2MGQ1YTNkNzg1NzM5NzEwNGZjNTU2Y=8=NTA3OSI7czo1MDoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvdGhlbWVzL2lubGl=ZS9=aGVtZS5taW4uanMiO3M6Mzg6ImNjODhmMzM2OTk5Mzk3ZDM4M2I1ZmE=MzQyOTRhMjU4TzE2MzMxIjtzOjQ2OiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9=aGVtZXMvbW9kZXJuL3RoZW1lLmpzIjtzOjM4OiJkNTAyYTZhYzI4YmI=OGE3ZDkxYTg5YmE5YjU3MTBjME8yMzAzMSI7czo1MDoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvdGhlbWVzL21vZGVybi9=aGVtZS5taW4uanMiO3M6Mzc6ImUzYjdjZWMyOGNhZDVjYWE1ZmNiY2MyYTE1Y2ViYWU3Tzk5MzQiO3M6Mzg6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3RpbnltY2UubWluLmpzIjtzOjM5OiJiYjE2NTIwYTAyMWFlMTcwYTcwMTk2NzVmMmY1ZjgxZk8zODUwODEiO3M6NDE6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3RpbnlfbWNlX3BvcHVwLmpzIjtzOjM4OiJkYmU2MjA4MjQyMmI3NWQ4OWVjYjk4MzQwOWVjOTY2ZE8xNTA5MSI7czo=OToiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvdXRpbHMvZWRpdGFibGVfc2VsZWN=cy5qcyI7czozNzoiZWI2NDJhMGFiYTdhODY2NmE3YjE=NzIyMzBmY2IzNzRPMTk4MyI7czo=MzoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvdXRpbHMvZm9ybV91dGlscy5qcyI7czozNzoiZjljNjEzNTQzODNmNWE1MGE5YTc3YjkwMmRmZGFlN2ZPNTc5MiI7czozOToiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvdXRpbHMvbWN=YWJzLmpzIjtzOjM3OiJiOWI1MGRkYmUwN2M3NTRhNmI2NTZiMGZkYWRhMzUwME8zOTQwIjtzOjQxOiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS91dGlscy92YWxpZGF=ZS5qcyI7czozNzoiYzQyYjUxNjBiZGJlZmQxMjkzZDc2YjMwNTIwNzU3ZjRPNTg1MCI7czo=MDoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2Uvd3AtdGlueW1jZS5qcy5neiI7czozOToiOWIzN2VlYTQ3MjE3MWRiZTUyYWNlYjkwOWI4MWMyOTJPMTcxODQ4IjtzOjM4OiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS93cC1=aW55bWNlLnBocCI7czozNzoiOGE2MjBhYjgxZGM3MzA3ZjcwNzJiMWQzMTI5MjQ4NzZPMTEyNiI7czoyNjoiL3dwLWluY2x1ZGVzL2pzL3R3LXNhY2suanMiO3M6Mzc6ImI5ODlhNWJkODRmNmViY2JjMTM5M2VjMDAzZTZlOTkxTzQ5NjkiO3M6MzA6Ii93cC1pbmNsdWRlcy9qcy9=dy1zYWNrLm1pbi5qcyI7czozNzoiYmM=NDg3MTk=ZTFmODgxMjZiOGE1MDBhZDQ3ZTY4ODlPMzI4MyI7czoyNjoiL3dwLWluY2x1ZGVzL2pzL3R3ZW1vamkuanMiO3M6Mzg6ImJlMmY2YjgwZDAzMDc4NTdhODNkMGIxN2I5ZjI=ZDJkTzI1MDk4IjtzOjMwOiIvd3AtaW5jbHVkZXMvanMvdHdlbW9qaS5taW4uanMiO3M6Mzc6IjQ2N2VmNTRiZmYxMDg1MWEwNDA2NGVlYmM5ODM3ZDUyTzg1MDYiO3M6MzM6Ii93cC1pbmNsdWRlcy9qcy91bmRlcnNjb3JlLm1pbi5qcyI7czozODoiNmEzYTQzNGExMzYwY2M3NDQzNDFlOTdkZTkxNzdiYzZPMTY=MTAiO3M6MjQ6Ii93cC1pbmNsdWRlcy9qcy91dGlscy5qcyI7czozNzoiMTllYTBkYTIxM2VkYTljN2JjNDM2MGYxZDRjMThiM2NPNDUyMCI7czoyODoiL3dwLWluY2x1ZGVzL2pzL3V=aWxzLm1pbi5qcyI7czozNzoiZjZlM2Q1NzIxN2RlNDFmYTMyNDMzMzExNTU=NTJiYjFPMTgyNSI7czoyNjoiL3dwLWluY2x1ZGVzL2pzL3dwLWExMXkuanMiO3M6Mzc6IjIwMWE3MjAyMjczNzgyODAwODFmNjc4MDlkNzgxYWIyTzIxODgiO3M6MzA6Ii93cC1pbmNsdWRlcy9qcy93cC1hMTF5Lm1pbi5qcyI7czozNjoiZmFkZDc=NmNkZGRhYWZiOTk3OGNiYWIyZTRlNDU4MGZPNjI1IjtzOjM1OiIvd3AtaW5jbHVkZXMvanMvd3AtYWpheC1yZXNwb25zZS5qcyI7czozNzoiYzQwNGQyZWJhYjI5YTc2ZTVhNGVlZjBhMjNjM2ViMTBPMzEzNSI7czozOToiL3dwLWluY2x1ZGVzL2pzL3dwLWFqYXgtcmVzcG9uc2UubWluLmpzIjtzOjM3OiJkMzc=OTdkOGFjOWNjOTFlYWNjOTFiNzZjYmZmMzBjY=8yMDgxIjtzOjI1OiIvd3AtaW5jbHVkZXMvanMvd3AtYXBpLmpzIjtzOjM4OiI=Y2NhMTUwMGU2MWJkNDBhYmU3YjU=M2ZkNzZhNWEwNk8=MDk=OCI7czoyOToiL3dwLWluY2x1ZGVzL2pzL3dwLWFwaS5taW4uanMiO3M6Mzg6IjE=NmIxNGU4Yzc5MzVkOGJkMTRlYjUyMWZiNjE2YTVlTzEyNzYxIjtzOjMyOiIvd3AtaW5jbHVkZXMvanMvd3AtYXV=aC1jaGVjay5qcyI7czozNzoiOTk1MDBkZDU=YWRjNzY3NjllMWE3OThhOTcyNWQ3NjVPMzMwNiI7czozNjoiL3dwLWluY2x1ZGVzL2pzL3dwLWF1dGgtY2hlY2subWluLmpzIjtzOjM3OiI5OWM5N2E3ZDZhZDllMWJhMDZiYmQ3NmYyOWVjYWFkNk8xNzgzIjtzOjMwOiIvd3AtaW5jbHVkZXMvanMvd3AtYmFja2JvbmUuanMiO3M6Mzg6ImZmMDhhOTFlYmE3ZjRmYjk1YmU3ZDVlYjRhMDcyZDc2TzEwNDI3IjtzOjM=OiIvd3AtaW5jbHVkZXMvanMvd3AtYmFja2JvbmUubWluLmpzIjtzOjM3OiJiOTc4ZDNjMjBhMjVjYTFkMzZjMTY4OGMyOThjODIzOU8zMDIwIjtzOjM1OiIvd3AtaW5jbHVkZXMvanMvd3AtY3VzdG9tLWhlYWRlci5qcyI7czozODoiNmU2MjU1MWQ1MzVkYzNiMDA3ODcwZTg5Zjg4MWVlMjFPMTAyMjAiO3M6Mzk6Ii93cC1pbmNsdWRlcy9qcy93cC1jdXN=b2=taGVhZGVyLm1pbi5qcyI7czozNzoiODAyYmVlMGU1ZjYwMDQ4M2UwMjQ3ZjU5YjNiMzI5YjRPNDQ2MiI7czozNjoiL3dwLWluY2x1ZGVzL2pzL3dwLWVtYmVkLXRlbXBsYXRlLmpzIjtzOjM3OiJkNmMzZmIwNDlmNjU3OTI4ZWFjMmNkOWM3ZWVmNjkyNU82MTkwIjtzOjQwOiIvd3AtaW5jbHVkZXMvanMvd3AtZW1iZWQtdGVtcGxhdGUubWluLmpzIjtzOjM3OiJjMDVkNjc4YTgxOTdhNzJjNGE=NGJmNTQwMDE3Mjc4YU8zMTE3IjtzOjI3OiIvd3AtaW5jbHVkZXMvanMvd3AtZW1iZWQuanMiO3M6Mzc6ImI4ZDk=YTY2NDhjN2E3MGMwNDk2MjU3YmIyNjk5NTk5TzMxMTkiO3M6MzE6Ii93cC1pbmNsdWRlcy9qcy93cC1lbWJlZC5taW4uanMiO3M6Mzc6IjVhMDNmOTdjYzQ3OWI5ZjVkN2VmZGFjY2VjMzFiYzE3TzEzOTgiO3M6MzQ6Ii93cC1pbmNsdWRlcy9qcy93cC1lbW9qaS1sb2FkZXIuanMiO3M6Mzc6IjFlMzQ3OTdjYjQxNjllMDUzZTZkNTI2Mjk=OTIxZDY2TzUwNTAiO3M6Mzg6Ii93cC1pbmNsdWRlcy9qcy93cC1lbW9qaS1sb2FkZXIubWluLmpzIjtzOjM3OiJmM2VjMjE5MDRjYzBjZjVkODk5ZjI5ZTM1YjBiNDYxMk8xNzQwIjtzOjM5OiIvd3AtaW5jbHVkZXMvanMvd3AtZW1vamktcmVsZWFzZS5taW4uanMiO3M6Mzg6ImNiNjI4NGI3MGRhMDNhNDM=NjgyNDRiZTdlYWZhMzYyTzExNDE=IjtzOjI3OiIvd3AtaW5jbHVkZXMvanMvd3AtZW1vamkuanMiO3M6Mzc6ImRkYzQ5YWQwZTRiMTQ2Y2M4ZmY3M2Q5NzZmMTI5OGJiTzY3NjAiO3M6MzE6Ii93cC1pbmNsdWRlcy9qcy93cC1lbW9qaS5taW4uanMiO3M6Mzc6IjFhY2RkMGNkNTIzNjk1YmQ5MjBjY2M=MThiMDY3OGM5TzI4MjQiO3M6MzY6Ii93cC1pbmNsdWRlcy9qcy93cC1saXN=LXJldmlzaW9ucy5qcyI7czozNjoiNDc1MTBkNzU2MGQyMmE5NzRjOGMwZWVjNmUyNGJjYmRPOTE=IjtzOjQwOiIvd3AtaW5jbHVkZXMvanMvd3AtbGlzdC1yZXZpc2lvbnMubWluLmpzIjtzOjM2OiJkMjUyZjQzMWQ=MDBiNjk2ZTI1Y2E5ZmVjOWExMTEzZU81NjkiO3M6Mjc6Ii93cC1pbmNsdWRlcy9qcy93cC1saXN=cy5qcyI7czozODoiYTNhZDRmMDgwYmQ2MWRhMmI5ZjJmOTM5MGIxNTMzZDFPMjUyMzUiO3M6MzE6Ii93cC1pbmNsdWRlcy9qcy93cC1saXN=cy5taW4uanMiO3M6Mzc6IjdkZjE4YjQyY2JkNWNiYWE1MDY3YzA2ZjU3YWE4NzZiTzc=MTMiO3M6Mjk6Ii93cC1pbmNsdWRlcy9qcy93cC1wb2ludGVyLmpzIjtzOjM3OiIzNWNiOGIzODBiYmQxZjJlYWE3MjNhYzQ5YmE1ZjNmME82NjA5IjtzOjMzOiIvd3AtaW5jbHVkZXMvanMvd3AtcG9pbnRlci5taW4uanMiO3M6Mzc6IjM2OGY5ODdjNjQ=ZDcwNTgwMDk3ZTQ4MDY2Yzk5MDgyTzM2MzkiO3M6MjY6Ii93cC1pbmNsdWRlcy9qcy93cC11dGlsLmpzIjtzOjM3OiI5MWMzMjI3NTBiYzgwZjFjYWNmZDRmOTkxZTY1YTQxNU8zOTAwIjtzOjMwOiIvd3AtaW5jbHVkZXMvanMvd3AtdXRpbC5taW4uanMiO3M6Mzc6IjgzMTE4YWE5MzliNTgzMmRkNGUxY2FkOGIxODYwMTJjTzEwNDYiO3M6Mjc6Ii93cC1pbmNsdWRlcy9qcy93cGRpYWxvZy5qcyI7czozNjoiNzJlODM5NWZkNDRkNDAzOTAwOWM1Mzk2ODg4ZmE2YmFPNDM1IjtzOjMxOiIvd3AtaW5jbHVkZXMvanMvd3BkaWFsb2cubWluLmpzIjtzOjM2OiJkMjJkOWZhNWJiMDBiYTA2NjcwODBkYTg=NmM=YTFiZU8yMzciO3M6MjU6Ii93cC1pbmNsdWRlcy9qcy93cGxpbmsuanMiO3M6Mzg6ImY5NTU4NDA3NjNjZWMwNTA2NGFmNjhjMzUwNWZjOThhTzIwNTU1IjtzOjI5OiIvd3AtaW5jbHVkZXMvanMvd3BsaW5rLm1pbi5qcyI7czozODoiNTliNGI=NmZmZTE=NjM3MWFhZTlmY2M1MGM3ZTE5MzBPMTEwNDkiO3M6MzE6Ii93cC1pbmNsdWRlcy9qcy96eGN2Ym4tYXN5bmMuanMiO3M6MzY6Ijk3YTc5ZTk2YTgxNWIyMDAxMzkzNTYwNTVkNzUyMzMzTzUwMiI7czozNToiL3dwLWluY2x1ZGVzL2pzL3p4Y3Zibi1hc3luYy5taW4uanMiO3M6MzY6IjMxOTZlOWI2MWY3MDM5MDllMTM5Y2U3ZTA=OWE3ZmZkTzMyNCI7czoyOToiL3dwLWluY2x1ZGVzL2pzL3p4Y3Zibi5taW4uanMiO3M6Mzk6ImExNGNkNTExM2JkMGQ1NzU2M2MxYTliNjNjYWUwNWY4TzY5ODcyOCI7czoyMToiL3dwLWluY2x1ZGVzL2tzZXMucGhwIjtzOjM4OiJhNWI=NzIzMDRlNjc5MWE2ODk4OThiMzUzY2E3ZGRjOU81MDExNiI7czoyMToiL3dwLWluY2x1ZGVzL2wxMG4ucGhwIjtzOjM4OiI2ODY=Y2NjYTdkMWExZmQ4MTVmNTQ=MmM3NmE=ZjczZE8=MzEzMCI7czozMDoiL3dwLWluY2x1ZGVzL2xpbmstdGVtcGxhdGUucGhwIjtzOjM5OiI1OTJhYmE2NzBkZGMyNTA4YjRlOTljNjY5M2RiYzM=OU8xMzUwMDgiO3M6MjE6Ii93cC1pbmNsdWRlcy9sb2FkLnBocCI7czozODoiYzdmM2Q1M2Q4NTRiMmM=OWI4ZDFiZmU1YTFiMmRkZjlPMzEzOTQiO3M6MjM6Ii93cC1pbmNsdWRlcy9sb2NhbGUucGhwIjtzOjM2OiI1ZmFjM2YzZTZlNTllMmJhNzgxNTQ2ZTBlMjg3ZjFhZU8xNDEiO3M6MzE6Ii93cC1pbmNsdWRlcy9tZWRpYS1=ZW1wbGF=ZS5waHAiO3M6Mzg6IjM=NjM3OTViNGQwMDY=MzZlMDU3NWNlZGVhNjE=NjZjTzQ1OTgwIjtzOjIyOiIvd3AtaW5jbHVkZXMvbWVkaWEucGhwIjtzOjM5OiI4NGQzMjk1NDZiOWIxNjI3NjI5NmVlOGY4ZDQxNTgyM=8xMzM5NTIiO3M6MjE6Ii93cC1pbmNsdWRlcy9tZXRhLnBocCI7czozODoiNTZkYTg3ODNmN2EzZGFjYmM=YjA=YzRkNzc4NjdkYTNPMzczMjEiO3M6MjU6Ii93cC1pbmNsdWRlcy9tcy1ibG9ncy5waHAiO3M6Mzg6IjhmMWY2NTYyMjEzNTRjNzBjYjljM2Q2MmMyZWU3MjI4TzM3MTg=IjtzOjM3OiIvd3AtaW5jbHVkZXMvbXMtZGVmYXVsdC1jb25zdGFudHMucGhwIjtzOjM3OiJiNGUyZDQ=MWJlZDNmZDU5MjQ2ZjlkOGQ=ZGY3Njk3N=8=NzU2IjtzOjM1OiIvd3AtaW5jbHVkZXMvbXMtZGVmYXVsdC1maWx=ZXJzLnBocCI7czozNzoiYzU2NmI1NzIyZWYzNGNkYmU3NWNiMGU4OTI4MGMwNjlPNDQ2OSI7czozMDoiL3dwLWluY2x1ZGVzL21zLWRlcHJlY2F=ZWQucGhwIjtzOjM4OiJkY2YwYTQ1Njc3NjhjNzRmMmY1MDM4ZWJlZTQ5NjdiY=8xNDY5MSI7czoyNToiL3dwLWluY2x1ZGVzL21zLWZpbGVzLnBocCI7czozNzoiNmU1MTkyZTllM2JmYmViZWRjMTNjNjJkYjFmOWEwMTNPMjYyMCI7czoyOToiL3dwLWluY2x1ZGVzL21zLWZ1bmN=aW9ucy5waHAiO3M6Mzg6ImI=NmYyZTYyN2VkMTBlYmFjZGE1YmViOTNkNzg=OGY2Tzc4NzI2IjtzOjI=OiIvd3AtaW5jbHVkZXMvbXMtbG9hZC5waHAiO3M6Mzg6IjZlY2VlOTk3ZGMzNDY=NzQzOWM5Nzg2MjdjYWU=ZjNkTzE5ODQ4IjtzOjI4OiIvd3AtaW5jbHVkZXMvbXMtc2V=dGluZ3MucGhwIjtzOjM3OiIzZmMxN2Q=ZjlhNzgyNjZlNDFjYzYyNjFlMmU4MDE4OE8zNDIxIjtzOjM=OiIvd3AtaW5jbHVkZXMvbmF2LW1lbnUtdGVtcGxhdGUucGhwIjtzOjM4OiI3ZDc2ODMzYWNhYTRkMzhiZTQxNjBiMGQwZjA2MGYzOE8yMDMyMyI7czoyNToiL3dwLWluY2x1ZGVzL25hdi1tZW51LnBocCI7czozODoiMWQwMDZiZGUwMmJlMTUxNjNlZDQ4MGZlMzg5ZjQ3NzhPMzIzMzAiO3M6MjM6Ii93cC1pbmNsdWRlcy9vcHRpb24ucGhwIjtzOjM4OiJhZmJjYjlmMTk3YTRhM2FjYmVjZTQyNzMyODdmZWE2Nk82Mzc4NyI7czozNzoiL3dwLWluY2x1ZGVzL3BsdWdnYWJsZS1kZXByZWNhdGVkLnBocCI7czozNzoiZTQ2M2IxODc2NGY5YTkwMGNjZmU3ZWI3MzU2YTEyYzNPNjI2MiI7czoyNjoiL3dwLWluY2x1ZGVzL3BsdWdnYWJsZS5waHAiO3M6Mzg6IjE4YTA4MjM3M2YxMTM=ZWFlZjJiMmZkNTg1Nzg2OTc3Tzg2NDM1IjtzOjIzOiIvd3AtaW5jbHVkZXMvcGx1Z2luLnBocCI7czozODoiN2FmNWRiNDZhOTc4YWM5MTNmODQ4MjEwOGQ=ZWM=YTJPMzEyODIiO3M6Mjc6Ii93cC1pbmNsdWRlcy9wb21vL2VudHJ5LnBocCI7czozNzoiZWQ5ZDgxMWVmMGNiMTNiZGMwZmE2MGI4MzE=YzhkNjFPMjg4NyI7czoyNDoiL3dwLWluY2x1ZGVzL3BvbW8vbW8ucGhwIjtzOjM3OiIxYWU5Nzk=Y2U5Y2E4NDU1MmU1ZTdhMzMyZjE2OGY2NU84NDYyIjtzOjI=OiIvd3AtaW5jbHVkZXMvcG9tby9wby5waHAiO3M6Mzg6IjBhZDgwNTNiMTlmYzIzNTYxNWUxNTY5Yjk3N2M2ZmM2TzEzMjE5IjtzOjI5OiIvd3AtaW5jbHVkZXMvcG9tby9zdHJlYW1zLnBocCI7czozNzoiYmVhYzczYTE3Y2M=MWQyZDEzOGQzYzY5ZjE5NjcwODBPNTk=OCI7czozNDoiL3dwLWluY2x1ZGVzL3BvbW8vdHJhbnNsYXRpb25zLnBocCI7czozNzoiZDFmMzFiNTRmOTM4YzJlNTM2MWE5NTQyZmRiNTUyMTBPODc3OSI7czoyOToiL3dwLWluY2x1ZGVzL3Bvc3QtZm9ybWF=cy5waHAiO3M6Mzc6IjgyNGFlMjUyZjFkNjkzNGMxNzJhNTEyOTNlMWJjZmRkTzY5NTEiO3M6MzA6Ii93cC1pbmNsdWRlcy9wb3N=LXRlbXBsYXRlLnBocCI7czozODoiYzY5Yjc3YmFlYTg5NmZkM2FjNGRjYWEzZWE2NDI3YTVPNTgzNTMiO3M6NDA6Ii93cC1pbmNsdWRlcy9wb3N=LXRodW1ibmFpbC1=ZW1wbGF=ZS5waHAiO3M6Mzc6ImNkMGQyZmNmMjJkMmQ4YTZlMDhhYzM3NTlmZmQzYmJjTzgxMDQiO3M6MjE6Ii93cC1pbmNsdWRlcy9wb3N=LnBocCI7czozOToiNGYzZGExNTJhYmFhYzZjMTQ1NjYxOWEyZDA3OTZkMTdPMjExMjIzIjtzOjIyOiIvd3AtaW5jbHVkZXMvcXVlcnkucGhwIjtzOjM4OiIzMTg2YTU5YWY1YzA5M2YwNGNkZDhlM2FiYTVjODFkZk8yMzQ3NCI7czo=ODoiL3dwLWluY2x1ZGVzL3JhbmRvbV9jb21wYXQvYnl=ZV9zYWZlX3N=cmluZ3MucGhwIjtzOjM3OiJmYzc1YzE4Yzk1ZDk3NGE5ZmRiMWIxMDFmNjZmNzk2OU81NjUxIjtzOjQyOiIvd3AtaW5jbHVkZXMvcmFuZG9tX2NvbXBhdC9jYXN=X3RvX2ludC5waHAiO3M6Mzc6ImZhNWY3Njc=NWFjMmQ2M2I5NDY2ZjEzMGQzNWM3ZmIxTzI=NjEiO3M6NDU6Ii93cC1pbmNsdWRlcy9yYW5kb21fY29tcGF=L2Vycm9yX3BvbHlmaWxsLnBocCI7czozNzoiYzI1OTU=ZTU3ZTFhZTMyNzIyZmE2Yzg=MGE1NTY1OGNPMTUzMyI7czozNzoiL3dwLWluY2x1ZGVzL3JhbmRvbV9jb21wYXQvcmFuZG9tLnBocCI7czozNzoiODc4NTk1ZTkxZWYxNDc3YzhjMzE1YjA4NWY3MzMxOWFPNzY5NCI7czo1NDoiL3dwLWluY2x1ZGVzL3JhbmRvbV9jb21wYXQvcmFuZG9tX2J5dGVzX2NvbV9kb3RuZXQucGhwIjtzOjM3OiIxZTY1NzJiZGUzNGM1NmNiYzQ3Mzc=NzIxY2UxOWVkZU8yNTQwIjtzOjU1OiIvd3AtaW5jbHVkZXMvcmFuZG9tX2NvbXBhdC9yYW5kb21fYnl=ZXNfZGV2X3VyYW5kb2=ucGhwIjtzOjM3OiI1MDNjMjFjYjNkYjAyZGVkNjZlMDFmZjg2MTQ=NjhiY=8=NTQzIjtzOjUzOiIvd3AtaW5jbHVkZXMvcmFuZG9tX2NvbXBhdC9yYW5kb21fYnl=ZXNfbGlic29kaXVtLnBocCI7czozNzoiODE4Yzg4YTRmODY2ZDQxN2ZhZGI3ZDE5MDdmN2FiM2VPMjU3NiI7czo2MDoiL3dwLWluY2x1ZGVzL3JhbmRvbV9jb21wYXQvcmFuZG9tX2J5dGVzX2xpYnNvZGl1bV9sZWdhY3kucGhwIjtzOjM3OiJmNDdlNDY5YTljMmRkZWU1MjZjYTM2MmM4N2UxODU1MU8yNTc2IjtzOjUwOiIvd3AtaW5jbHVkZXMvcmFuZG9tX2NvbXBhdC9yYW5kb21fYnl=ZXNfbWNyeXB=LnBocCI7czozNzoiMjU2Y2Y=ZTkzMTJmNzNjNTgwNmM4YjI5MTY3N2QyNjlPMjMwNiI7czo1MToiL3dwLWluY2x1ZGVzL3JhbmRvbV9jb21wYXQvcmFuZG9tX2J5dGVzX29wZW5zc2wucGhwIjtzOjM3OiJiMzY5NTY=YmZmYzc2ZDgyNDQ5NTI3OTMwYjYzOGRiYU8yNTc=IjtzOjQxOiIvd3AtaW5jbHVkZXMvcmFuZG9tX2NvbXBhdC9yYW5kb21faW5=LnBocCI7czozNzoiOTBlNmRhZjg1ZDZkMGQ2OTU2NjkyYmQ=OTAzM2VkMzhPNTY5NyI7czozOToiL3dwLWluY2x1ZGVzL3JlZ2lzdHJhdGlvbi1mdW5jdGlvbnMucGhwIjtzOjM2OiIxYzRiNjljYTRjZDliODUzODcxNGIyNDgzZDBlNTk5NU8xNzgiO3M6Mjk6Ii93cC1pbmNsdWRlcy9yZWdpc3RyYXRpb24ucGhwIjtzOjM2OiJkNGYzOWU5ODMzNjZlYTVjMWIzZmQ=NjQ=YjE5YWUwNk8xNzgiO3M6MzA6Ii93cC1pbmNsdWRlcy9SZXF1ZXN=cy9BdXRoLnBocCI7czozNjoiMzE5N2QyNTI5ZGQ5NTdiMmFjYzM5NDRmNWJmY2Q2NGFPODEwIjtzOjM2OiIvd3AtaW5jbHVkZXMvUmVxdWVzdHMvQXV=aC9CYXNpYy5waHAiO3M6Mzc6IjY3ZmRkODc4Y2M4NGRmMTUwOTM=NTVkNjA5NmIyMTQzTzE5NDEiO3M6MzI6Ii93cC1pbmNsdWRlcy9SZXF1ZXN=cy9Db29raWUucGhwIjtzOjM4OiJkMTlkNDNhZmU5OWJjNTI4ODEzMjJiOTI3OTYwYTRkM=8xMjg1NCI7czozNjoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=Nvb2tpZS9KYXIucGhwIjtzOjM3OiJlOTMwMGM1ZmIxZjUyNjcwYTBiNTIyMzRkOTVjOTUxME8zODE4IjtzOjM1OiIvd3AtaW5jbHVkZXMvUmVxdWVzdHMvRXhjZXB=aW9uLnBocCI7czozNzoiODc5YmFjOWVmYTE4MDA4NWFiMzNlOTBlMWFjYzUyNDlPMTAyNiI7czo=MDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLnBocCI7czozNzoiZThkNWZjNjhiM2M2ZmExNWU=NTI2YzE2MTE3MmRhZTVPMTQxOSI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzMwNC5waHAiO3M6MzY6ImQzM2I=NjM=Y2U=MTEzZGI=OWVmOWRkZGVkZjc1NGFiTzM5MCI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzMwNS5waHAiO3M6MzY6IjU4ZjhmNzAwOTA=YmViZTYyZjYwYTExYzJjZmJhYjI2TzM4MiI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzMwNi5waHAiO3M6MzY6IjU3NzM3YTA3MWZhMTc1NGU1MGRiNmFkY2M5ZjI1ODc1TzM5MSI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQwMC5waHAiO3M6MzY6IjUxZTU2ZTg3OGNiYjU2NGFiODUyYzk3OGZiMzVmY2QwTzM4NyI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQwMS5waHAiO3M6MzY6IjNiMmFiODBlYjljYmZkODdiYWEyM2ZjMTY=OGU5OTQwTzM5MCI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQwMi5waHAiO3M6MzY6IjYwZjg1OWQ1NTE1MGRhMGIwYTdhOTU5YWM5ZjM=N2Q2TzQwMiI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQwMy5waHAiO3M6MzY6ImJjZDE2MGU4ZjcwZGM3NmZmYmJmNmIzM2I3ZmUzMWRmTzM4MSI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQwNC5waHAiO3M6MzY6IjFlZDQxNmNjNjMxMTgzNTkwMDg1Nzk3M2Y4OTIzYzRkTzM4MSI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQwNS5waHAiO3M6MzY6ImRkMzhkMTgyZGU2ZDIxYjJkMmFjMThiMzgxYWRmOTdmTzQwOCI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQwNi5waHAiO3M6MzY6IjRiYzhjYjZjZWY2ODhjNzI5ZWRjMzk5MDIyMDAwNmFjTzM5NiI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQwNy5waHAiO3M6MzY6ImMyYzgxN2U5ZjVkODc2OGJiZGU=ZDY2YTI2ZTZjNmI1TzQ=MSI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQwOC5waHAiO3M6MzY6IjQwM2UzMTY=ODQ=OTU4YzUxNDRmOThlY2M4Yjc3Njg5TzM5OSI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQwOS5waHAiO3M6MzY6Ijk5NWExZGM=NjllNjdlMmEzZDBiOGY5YmViZmVhOWI2TzM3OCI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQxMC5waHAiO3M6MzY6IjcxYmU=ZjM=MzdkZmJhZGRhNTJmMzg1ODIxODRlMTliTzM2NiI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQxMS5waHAiO3M6MzY6IjI3YTU1MmExZTQxNjBjNGRmNjFiMmVjYTVhNjA=Nzk2TzM5OSI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQxMi5waHAiO3M6MzY6IjI1Yjg4NDQ5ZGNiN2ExYTgzZGQ5MDYzNzhhYTU1NmM3TzQxMSI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQxMy5waHAiO3M6MzY6ImU5OTYzY2MxNWRjOTkwNTliN2Q5ZmY1ODRjMTdiZmQ4TzQyNiI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQxNC5waHAiO3M6MzY6ImJjYTY1ZDU1ZTI=MDllZjZhNTI5MWVkOGU2YTEyMzY4TzQxNyI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQxNS5waHAiO3M6MzY6IjAyNThjYzBmYjA1NDYyZWE4ZjExY2NhZWEzNGE1NWMzTzQyMCI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQxNi5waHAiO3M6MzY6ImY5MzE4MjRlMzllMzk2MTdjOWFhYzY2MTgwNDQ3OGY4TzQ=NyI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQxNy5waHAiO3M6MzY6IjQyNzAwMjZhMWI4ZTY4NGY1ZWMwNjM1YzQ3MjAxYzIzTzQwOCI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQxOC5waHAiO3M6MzY6IjRhMjFiYWUyOThmMWM5ZmVkYTViMGU5M2ZlMzQ4YWYzTzQ3OCI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQyOC5waHAiO3M6MzY6IjlhOTdiYjAzNjlmNzAxNDJlNGU1N2RhNzVlYWU3NDJhTzUwNSI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQyOS5waHAiO3M6MzY6IjUzZjBkZDI1N2MwNDQ2MmVjM2EwNWE2NDg1YjM4ZmNjTzU=OSI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQzMS5waHAiO3M6MzY6ImUwZTM3MzdjNjIyNDE3Y2EwOGQ1ZDE5MzNjMTQ4OWQ5TzUzNSI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzUwMC5waHAiO3M6MzY6ImMwYWZhOWM2NmI2ZDgzMGEwOTQ4MTVmMjEyNGRmZmRhTzQxNyI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzUwMS5waHAiO3M6MzY6IjY1MGNkYWI4MzAzNGYyMmQzZmU4MDNmNWQ3OTFhODM1TzM5OSI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzUwMi5waHAiO3M6MzY6IjdjYzgzYTZjODBjZjdhZjlkNTIxN2IxN2ZiNDdmZjY5TzM4NyI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzUwMy5waHAiO3M6MzY6IjM5MDZmNzUyMDg2MWMzOWY=M2Y=NjAwMGQ=NTU1NGI=TzQxMSI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzUwNC5waHAiO3M6MzY6IjAyZDc2ZDhjY2NhYTQ=NjI5MzIwMTExMjkwOGEyYWE1TzM5OSI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzUwNS5waHAiO3M6MzY6IjhlNWQ=MTA5MDUzMzAzZTY1YjJmNDM2NGMxYWMxMmRlTzQzMiI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzUxMS5waHAiO3M6MzY6IjAzNzU2ZTlhNGUzYzRiNzdmOGQwOWJiOTkxOGZkMTQwTzUzNSI7czo=ODoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQL1Vua25vd24ucGhwIjtzOjM2OiJkYTY=NmMwMmUxYWI4MWI2MzJhZjQxZmJjZjBhNTdhY=84NjciO3M6NDU6Ii93cC1pbmNsdWRlcy9SZXF1ZXN=cy9FeGNlcHRpb24vVHJhbnNwb3J=LnBocCI7czozNToiYWJiYjZjZjhkYTdhZThlYTIwNGEwMTE4YWI1ZWQxMDFPNzQiO3M6NTA6Ii93cC1pbmNsdWRlcy9SZXF1ZXN=cy9FeGNlcHRpb24vVHJhbnNwb3J=L2NVUkwucGhwIjtzOjM2OiI4NTM2NTRjZDY3MmExYTliM2EwOWFmMDc3ODM3ZGZlMU85MTgiO3M6MzI6Ii93cC1pbmNsdWRlcy9SZXF1ZXN=cy9Ib29rZXIucGhwIjtzOjM2OiIwZjA4YzU=MDE=MjVhOTYxNWJkMTllMmYzNGE1ZTEwN=83MDgiO3M6MzE6Ii93cC1pbmNsdWRlcy9SZXF1ZXN=cy9Ib29rcy5waHAiO3M6Mzc6IjJjMTVhMGE1MjBiOWE4OTc2Nzc4YTE2OWNlZWJkOTE5TzEzOTkiO3M6Mzc6Ii93cC1pbmNsdWRlcy9SZXF1ZXN=cy9JRE5BRW5jb2Rlci5waHAiO3M6Mzg6ImQ3N2RhZGEyMzJmMDA3OWIxNDEyZTBkMDUwYjRkOGIxTzExMzI1IjtzOjMwOiIvd3AtaW5jbHVkZXMvUmVxdWVzdHMvSVB2Ni5waHAiO3M6Mzc6ImE1ZGY=Yjg4NGU4YTA3ZTgxNzAzZjFhYzZiNmU1NGIxTzQ5MjciO3M6Mjk6Ii93cC1pbmNsdWRlcy9SZXF1ZXN=cy9JUkkucGhwIjtzOjM4OiIxODM1MDgzMjVkODM5YzdiZjI3ZGI1ZjkwOTYwMGU1OE8yODQ2NyI7czozMToiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL1Byb3h5LnBocCI7czozNjoiYjU=MDZiMTAzN2I1MDBkN2QzNzRiODVjMmE4Nzk5NDdPODEzIjtzOjM2OiIvd3AtaW5jbHVkZXMvUmVxdWVzdHMvUHJveHkvSFRUUC5waHAiO3M6Mzc6ImZmZDBlNjJmMzJkYjA1YmRiZGE2YmNhNDA3ZDdmMDI5TzM=NzEiO3M6MzQ6Ii93cC1pbmNsdWRlcy9SZXF1ZXN=cy9SZXNwb25zZS5waHAiO3M6Mzc6IjExY2U3MDg2YmJiN2FlNTJlNmFiYjdjNGZkMjcwYjQ3TzI1MDUiO3M6NDI6Ii93cC1pbmNsdWRlcy9SZXF1ZXN=cy9SZXNwb25zZS9IZWFkZXJzLnBocCI7czozNzoiMWFkN2MzODJkMmI2OGYxOTQxMmRhN2Y=M2U2M2E5NjBPMjEyNSI7czozMzoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL1Nlc3Npb24ucGhwIjtzOjM3OiIzN2Y4Y2FkZDg2ZmNiZmNlOTYwMmI1YmNmNjdkNmM4ZU83MTUzIjtzOjI5OiIvd3AtaW5jbHVkZXMvUmVxdWVzdHMvU1NMLnBocCI7czozNzoiMjY1MDY3ZWIyNzQxMzZhYzI4YmUzMDBiMzc1NDBjNGZPNDAyMiI7czozNToiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL1RyYW5zcG9ydC5waHAiO3M6Mzc6IjAxOWM5OTNiY2U2YmVkMTc4YmFmNGI1YzU2NmNjNjE3TzEyMjAiO3M6NDA6Ii93cC1pbmNsdWRlcy9SZXF1ZXN=cy9UcmFuc3BvcnQvY1VSTC5waHAiO3M6Mzg6IjBlZTQ4MDFkMDhkYTM4MzcxMjEzNjE2MDQzNWFlMGQxTzE1MzI1IjtzOjQ1OiIvd3AtaW5jbHVkZXMvUmVxdWVzdHMvVHJhbnNwb3J=L2Zzb2Nrb3Blbi5waHAiO3M6Mzg6IjFkMjFlZTRhNGY2MGFkMWFmYzQ4ZjExODQ4M2ZiNzNmTzEyNDM2IjtzOjU5OiIvd3AtaW5jbHVkZXMvUmVxdWVzdHMvVXRpbGl=eS9DYXNlSW5zZW5zaXRpdmVEaWN=aW9uYXJ5LnBocCI7czozNzoiYjVmMDNhYzhjNzUyYjM=YjllNzI2ZjA=ZDU=ODMyN2FPMTk5MyI7czo1MDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL1V=aWxpdHkvRmlsdGVyZWRJdGVyYXRvci5waHAiO3M6MzY6IjEwZjlhMmQ5NjE4ZWQ2NzhiNzI1NDFhYTllMDU3OWQzTzgyOSI7czoyNToiL3dwLWluY2x1ZGVzL3Jlc3QtYXBpLnBocCI7czozODoiZmFmMjA3YjJjYmI=MDA1N2MyYjY4ZDg1YjliNmY2NWNPMzQ5NTciO3M6NDc6Ii93cC1pbmNsdWRlcy9yZXN=LWFwaS9jbGFzcy13cC1yZXN=LXJlcXVlc3QucGhwIjtzOjM4OiI=ZmJjNjAwMzE1OTMxNTlmNzA=Yzk5ZDhjM2RiZGUxZE8yNDc2MCI7czo=ODoiL3dwLWluY2x1ZGVzL3Jlc3QtYXBpL2NsYXNzLXdwLXJlc3QtcmVzcG9uc2UucGhwIjtzOjM3OiIwODc5NmQwY2RhNjM2YzZhMjRiY2ViYmI3M2VmMmM5OE83NjMzIjtzOjQ2OiIvd3AtaW5jbHVkZXMvcmVzdC1hcGkvY2xhc3Mtd3AtcmVzdC1zZXJ2ZXIucGhwIjtzOjM4OiI3MzAxYTM=MTM3NTU3ZWY5MDU1ZmYwOWZjZTk5ODlkNE8zNzUxNSI7czo3MjoiL3dwLWluY2x1ZGVzL3Jlc3QtYXBpL2VuZHBvaW5=cy9jbGFzcy13cC1yZXN=LWF=dGFjaG1lbnRzLWNvbnRyb2xsZXIucGhwIjtzOjM4OiI=OGE1NDk3M2NmYTIzOTEyNDVlMDViOWQyOWI3ZGMzYU8yMzYxOSI7czo2OToiL3dwLWluY2x1ZGVzL3Jlc3QtYXBpL2VuZHBvaW5=cy9jbGFzcy13cC1yZXN=LWNvbW1lbnRzLWNvbnRyb2xsZXIucGhwIjtzOjM4OiJiNGViZjEyMWQ1MDJmNDBmMmJmMzlkYzY2ODI5MzBjOU81MzY2MiI7czo2MDoiL3dwLWluY2x1ZGVzL3Jlc3QtYXBpL2VuZHBvaW5=cy9jbGFzcy13cC1yZXN=LWNvbnRyb2xsZXIucGhwIjtzOjM4OiJlNTM3YTI1MDE4ZjQ1NTZhNGEzYTczZTYwZmM3ZTQwOU8xODA3MCI7czo3NDoiL3dwLWluY2x1ZGVzL3Jlc3QtYXBpL2VuZHBvaW5=cy9jbGFzcy13cC1yZXN=LXBvc3Qtc3RhdHVzZXMtY29udHJvbGxlci5waHAiO3M6Mzc6IjdkNDhiYzRhMzhmM2NmMjkxOTc3NDdlNzE3N2I5YTI1TzkzMDMiO3M6NzE6Ii93cC1pbmNsdWRlcy9yZXN=LWFwaS9lbmRwb2ludHMvY2xhc3Mtd3AtcmVzdC1wb3N=LXR5cGVzLWNvbnRyb2xsZXIucGhwIjtzOjM3OiIwMWM3MmI4ODVkNDYyOGY1Mjg4Y2QwNjRmODQxOWE=Mk84NzM=IjtzOjY2OiIvd3AtaW5jbHVkZXMvcmVzdC1hcGkvZW5kcG9pbnRzL2NsYXNzLXdwLXJlc3QtcG9zdHMtY29udHJvbGxlci5waHAiO3M6Mzg6ImIwOWIwNjk=NDEyNDAwYjVkNTA4OTBiMWM5OTM1YjRjTzcxNDIyIjtzOjcwOiIvd3AtaW5jbHVkZXMvcmVzdC1hcGkvZW5kcG9pbnRzL2NsYXNzLXdwLXJlc3QtcmV2aXNpb25zLWNvbnRyb2xsZXIucGhwIjtzOjM4OiI1MWFhZmExOTdhZDY5NWRlMmM=ZWNlYjc=OTE2NzdhZk8xNzIyMCI7czo2OToiL3dwLWluY2x1ZGVzL3Jlc3QtYXBpL2VuZHBvaW5=cy9jbGFzcy13cC1yZXN=LXNldHRpbmdzLWNvbnRyb2xsZXIucGhwIjtzOjM3OiIwOGE3ZGQyMmE=MzM3MDY4MzRlZTkyNjhhOThkOGM5NU85MzA=IjtzOjcxOiIvd3AtaW5jbHVkZXMvcmVzdC1hcGkvZW5kcG9pbnRzL2NsYXNzLXdwLXJlc3QtdGF4b25vbWllcy1jb25=cm9sbGVyLnBocCI7czozODoiZjEwOWIxNWVhN2RhYjExMWUwOThkNTAzYTc2YjRkMzBPMTAxMDkiO3M6NjY6Ii93cC1pbmNsdWRlcy9yZXN=LWFwaS9lbmRwb2ludHMvY2xhc3Mtd3AtcmVzdC1=ZXJtcy1jb25=cm9sbGVyLnBocCI7czozODoiOWQ4ZjkyNzRiZTU5NmZkZWYwMDM4Y2M1MjY1YzE4NzZPMzA=MDQiO3M6NjY6Ii93cC1pbmNsdWRlcy9yZXN=LWFwaS9lbmRwb2ludHMvY2xhc3Mtd3AtcmVzdC11c2Vycy1jb25=cm9sbGVyLnBocCI7czozODoiZmJkMDNmYzY4MTFkYjFhNWViYjY2ZGI=OGRkNmY2NzNPNDM2MjEiO3M6NjY6Ii93cC1pbmNsdWRlcy9yZXN=LWFwaS9maWVsZHMvY2xhc3Mtd3AtcmVzdC1jb21tZW5=LW1ldGEtZmllbGRzLnBocCI7czozNjoiNDE=YTNkNmE3NTNmYWE5OTRkNzlhNDc4ZGU5MzdlNGFPNzQzIjtzOjU4OiIvd3AtaW5jbHVkZXMvcmVzdC1hcGkvZmllbGRzL2NsYXNzLXdwLXJlc3QtbWV=YS1maWVsZHMucGhwIjtzOjM4OiJhMDE3YThiMzlkNWViMzI3MjIwMDViZDhjZDk3YzFmM=8xMzQ2MCI7czo2MzoiL3dwLWluY2x1ZGVzL3Jlc3QtYXBpL2ZpZWxkcy9jbGFzcy13cC1yZXN=LXBvc3QtbWV=YS1maWVsZHMucGhwIjtzOjM3OiIwZmI=OGNjOGY4MGNlZTUyNjM3NjVkYmM=NDkxNWY1OE8xMDk4IjtzOjYzOiIvd3AtaW5jbHVkZXMvcmVzdC1hcGkvZmllbGRzL2NsYXNzLXdwLXJlc3QtdGVybS1tZXRhLWZpZWxkcy5waHAiO3M6Mzc6ImY3Y2Y1OGE1ZWNlODg5YzE3MjJkZTdmMDkyMzY=ZjY4TzEwOTYiO3M6NjM6Ii93cC1pbmNsdWRlcy9yZXN=LWFwaS9maWVsZHMvY2xhc3Mtd3AtcmVzdC11c2VyLW1ldGEtZmllbGRzLnBocCI7czozNjoiZmQ4MDY=MGFhMzE1ODk2M2NkNTU=YmUzNTg=YWFmMGVPNzE2IjtzOjI1OiIvd3AtaW5jbHVkZXMvcmV2aXNpb24ucGhwIjtzOjM4OiJhNjRhYWM1NzU4NTZjZGUzMmZlZjc1NGZiYThkZjIwZU8yMTMwNSI7czoyNDoiL3dwLWluY2x1ZGVzL3Jld3JpdGUucGhwIjtzOjM4OiI3ZmRiMWU=OWVmY2FkNTkyMTdkMDJiNTg=OWYyMzdiMk8xNzIxNSI7czozMDoiL3dwLWluY2x1ZGVzL3Jzcy1mdW5jdGlvbnMucGhwIjtzOjM2OiIxOWZmMWZhZTMxZmQyZDAzMzhjNzYwMWJjYjRiYWY1OE8xOTEiO3M6MjA6Ii93cC1pbmNsdWRlcy9yc3MucGhwIjtzOjM4OiJjMjFkNmQ4NmU3NWJlZjAwZmE2YzRhMGVjNWUxY2EzYk8yMzIwOCI7czozMDoiL3dwLWluY2x1ZGVzL3NjcmlwdC1sb2FkZXIucGhwIjtzOjM4OiJjODcwMTNhY2E1ZjlmYjZjNzM3MTEyODhlYjgzMTU2MU82NTUwNiI7czoyNDoiL3dwLWluY2x1ZGVzL3Nlc3Npb24ucGhwIjtzOjM2OiJkOTQ1NjFjZWEwYzVjMTNhNjA5YjljZGU1YTc2MzVkNE8yNDIiO3M6Mjc6Ii93cC1pbmNsdWRlcy9zaG9ydGNvZGVzLnBocCI7czozODoiZmUyZjU5NjYwOGEyMGUzNGZlZDA=NWUxOTA2NWU4MTlPMjA3MDYiO3M6MzM6Ii93cC1pbmNsdWRlcy9TaW1wbGVQaWUvQXV=aG9yLnBocCI7czozNzoiMzQ4MDcxZWQxMDVmZjA=MThiMjU5NjRlNzcxYmEzMzFPMzU5MiI7czozMjoiL3dwLWluY2x1ZGVzL1NpbXBsZVBpZS9DYWNoZS5waHAiO3M6Mzc6Ijc5ZmM5MDE3YTIzYTgzNmY=ZDBmNjhmNzc2NGNhNzM=TzQyOTYiO3M6Mzc6Ii93cC1pbmNsdWRlcy9TaW1wbGVQaWUvQ2FjaGUvQmFzZS5waHAiO3M6Mzc6Ijk=NDNlZGExODliYmQ5MzI1ZDBjOWMwNDVkMjM3YzZhTzM=NTIiO3M6MzU6Ii93cC1pbmNsdWRlcy9TaW1wbGVQaWUvQ2FjaGUvREIucGhwIjtzOjM3OiIwNjU5YmYwODRmNTVhMzAzZjU5MjJlZGM2MmJjZmJmNk8=NzI2IjtzOjM3OiIvd3AtaW5jbHVkZXMvU2ltcGxlUGllL=NhY2hlL=ZpbGUucGhwIjtzOjM3OiJhMzNkYmIwNTQwZWNjMjljYzY=MjViMTQxMDA5NTNkMU8=NDI=IjtzOjQxOiIvd3AtaW5jbHVkZXMvU2ltcGxlUGllL=NhY2hlL=1lbWNhY2hlLnBocCI7czozNzoiZjY5ZDRhNTViMmExMTY4NTMxNTM1MTA3YWI4NDNmYjZPNTE=MSI7czozODoiL3dwLWluY2x1ZGVzL1NpbXBsZVBpZS9DYWNoZS9NeVNRTC5waHAiO3M6Mzg6ImU4OTExZWNlMTVkZjQyY2E=Mzk5MWE=OGQ1Nzg1Njg3TzEyMjgwIjtzOjM=OiIvd3AtaW5jbHVkZXMvU2ltcGxlUGllL=NhcHRpb24ucGhwIjtzOjM3OiJiZGJhYmNkY2NhNDI2YTRkYWRmNjY3NWJjNGM=ZWJlOU8=NTEwIjtzOjM1OiIvd3AtaW5jbHVkZXMvU2ltcGxlUGllL=NhdGVnb3J5LnBocCI7czozNzoiYmE3ZWM4Y2MzZjEzZDRmMjdmMmUwYWRjYWY2NGJiMmFPMzcwNyI7czo=NzoiL3dwLWluY2x1ZGVzL1NpbXBsZVBpZS9Db25=ZW5=L1R5cGUvU25pZmZlci5waHAiO3M6Mzc6IjdjNzJjM2YzNjk4NTU1NjJkOTZjNzdlY2UxYzdkYjMzTzgxMzciO3M6MzY6Ii93cC1pbmNsdWRlcy9TaW1wbGVQaWUvQ29weXJpZ2h=LnBocCI7czozNzoiYmQ3ZmJmNjhiOTU=YTlkNTA5NTVjYzgwOGRiN2NiNmFPMzM2NyI7czozMToiL3dwLWluY2x1ZGVzL1NpbXBsZVBpZS9Db3JlLnBocCI7czozNzoiYTRhZTE5YTkyM2I4OTBmMmRjZjdlMmQ=MTVmZDFhZDJPMjI2OCI7czozMzoiL3dwLWluY2x1ZGVzL1NpbXBsZVBpZS9DcmVkaXQucGhwIjtzOjM3OiIwMzg1ZTRhMTRkZTc4YzhiMmExNjdmM2UwYWVhMTk3Y=8zNzIxIjtzOjQ3OiIvd3AtaW5jbHVkZXMvU2ltcGxlUGllL=RlY29kZS9IVE1ML=VudGl=aWVzLnBocCI7czozODoiNDU5NzVlMmZjZjBkNDI4NjkxYTU1YTIzOTQyNTJmNjFPMTczMjEiO3M6MzY6Ii93cC1pbmNsdWRlcy9TaW1wbGVQaWUvRW5jbG9zdXJlLnBocCI7czozODoiMTIyZTg2MWY=MmViNmUwMWNlOGQ=YjBmMTFmYjczNWRPMjc=ODciO3M6MzY6Ii93cC1pbmNsdWRlcy9TaW1wbGVQaWUvRXhjZXB=aW9uLnBocCI7czozNzoiMDk=YmZkNzYyNjljOWZjYzNjNWNkYThmMDVkMDUzMzVPMjE4NyI7czozMToiL3dwLWluY2x1ZGVzL1NpbXBsZVBpZS9GaWxlLnBocCI7czozNzoiYWViYTA4YWQ2YjU1ODczNmVhMGFhZjJiZWIyOTI1YjdPOTY3OCI7czozNToiL3dwLWluY2x1ZGVzL1NpbXBsZVBpZS9nemRlY29kZS5waHAiO3M6Mzc6ImM1MzhlMmJjMGU4NjYxOTdkYjYxNmMxNzg=MTEzNGQ=Tzg1NzIiO3M6Mzg6Ii93cC1pbmNsdWRlcy9TaW1wbGVQaWUvSFRUUC9QYXJzZXIucGhwIjtzOjM4OiI1NzI1YzdkMGZiMzQ3ZjFjMDhkZjM2OTBhNThmMzYwOU8xMDg4MiI7czozMDoiL3dwLWluY2x1ZGVzL1NpbXBsZVBpZS9JUkkucGhwIjtzOjM4OiI2ZTE2ZmYyMGQzZTY4NjkyY2YzYjYxN2I4NzVmMzZmNU8yODM1OSI7czozMToiL3dwLWluY2x1ZGVzL1NpbXBsZVBpZS9JdGVtLnBocCI7czozODoiMTA=NTEwZTIyMWZhMDg=MzdhZWMwMDhlNjMzY2RjYTdPOTgyOTkiO3M6MzQ6Ii93cC1pbmNsdWRlcy9TaW1wbGVQaWUvTG9jYXRvci5waHAiO3M6Mzg6IjgwNzNhNGM2ZGExYmIzM2I4Nzc1NzY2NjVlZjVlYWI1TzExMTg1IjtzOjMxOiIvd3AtaW5jbHVkZXMvU2ltcGxlUGllL=1pc2MucGhwIjtzOjM4OiJjZWNkZTY3OWM2MmRkNTAyMDdkOGQyNWVjZTFhNGI4OU81MTU1MCI7czozNToiL3dwLWluY2x1ZGVzL1NpbXBsZVBpZS9OZXQvSVB2Ni5waHAiO3M6Mzc6ImE1NDY3OTBlMjE2YWJkZDk4MDE3OTU5NDlmYjZiNDBmTzc1NzYiO3M6Mzc6Ii93cC1pbmNsdWRlcy9TaW1wbGVQaWUvUGFyc2UvRGF=ZS5waHAiO3M6Mzg6ImVlODJkMmU3MGRjOGFmYzZiOTY1MTBkMmI5Y2ZmNDVlTzE5NzAxIjtzOjMzOiIvd3AtaW5jbHVkZXMvU2ltcGxlUGllL1BhcnNlci5waHAiO3M6Mzg6IjUyYmIyZWU=NjJlN2U=MTRhNzdlZmRjN2ViZjUyYmNjTzExODUxIjtzOjMzOiIvd3AtaW5jbHVkZXMvU2ltcGxlUGllL1JhdGluZy5waHAiO3M6Mzc6IjNkNzAxM2E=NmQwOWM3NGIwZWUzZDhhZjYxNzQxMmZiTzM=NTEiO3M6MzU6Ii93cC1pbmNsdWRlcy9TaW1wbGVQaWUvUmVnaXN=cnkucGhwIjtzOjM3OiIxY2M4YTJlNmMwYjVkZDMxNzYzOThkNjQwMGYwZDliOE81OTkxIjtzOjM4OiIvd3AtaW5jbHVkZXMvU2ltcGxlUGllL1Jlc3RyaWN=aW9uLnBocCI7czozNzoiMmExOTFlNzE2ODExNjQxODgxNzM4ODExM2JkNTc5MTRPMzgwMCI7czozNToiL3dwLWluY2x1ZGVzL1NpbXBsZVBpZS9TYW5pdGl6ZS5waHAiO3M6Mzg6IjQyZDhiOGMwY2Y=NmI1ZDhhNTExZTBhZTQ4Yjg4Zjc1TzE1Njk4IjtzOjMzOiIvd3AtaW5jbHVkZXMvU2ltcGxlUGllL1NvdXJjZS5waHAiO3M6Mzg6IjhlODNiYjFkZTNlMDE4ZjA1MzdiYjMyYThjOTYxN2ZmTzIwNTM5IjtzOjQ5OiIvd3AtaW5jbHVkZXMvU2ltcGxlUGllL1hNTC9EZWNsYXJhdGlvbi9QYXJzZXIucGhwIjtzOjM3OiI4ZmIxZGE3MDI4YzM4NWJiOWQ=MjAzYzlmNjczMjM2Mk83MTQ5IjtzOjI1OiIvd3AtaW5jbHVkZXMvdGF4b25vbXkucGhwIjtzOjM5OiIyM2YwNjQ=YjczZDZiNWM=OTNiNzQ3ZGZiYmFlMjAyM=8xNDk4NjkiO3M6MzI6Ii93cC1pbmNsdWRlcy9=ZW1wbGF=ZS1sb2FkZXIucGhwIjtzOjM3OiJhNzQ1MDI=ZjQ1ZjAxODc=MTQ3OWJkY2Y1NTE4ZjU5Yk8yODk2IjtzOjI1OiIvd3AtaW5jbHVkZXMvdGVtcGxhdGUucGhwIjtzOjM4OiJjMTc4ZTQ2ZmFiYTA1YmQ1NjgyMWNhNzgwOTcwMzU2OE8xOTMxOCI7czoyNjoiL3dwLWluY2x1ZGVzL1RleHQvRGlmZi5waHAiO3M6Mzg6IjZjNzBkNTllOWU5YTZlOWJkMTE1Mzc3MTkzMTNlMzJhTzEyOTUwIjtzOjQwOiIvd3AtaW5jbHVkZXMvVGV4dC9EaWZmL=VuZ2luZS9uYXRpdmUucGhwIjtzOjM4OiJlNWFkMjcyYTE4ODIxMjEyYmVlM2MzZGYyYWU4NzgwZU8xNTg=MCI7czozOToiL3dwLWluY2x1ZGVzL1RleHQvRGlmZi9FbmdpbmUvc2hlbGwucGhwIjtzOjM3OiI3NWFiNDFkYzkxY2Q3ZTRhYWE1ZTc=YTVmOWU2ZWViYU81MTcwIjtzOjQwOiIvd3AtaW5jbHVkZXMvVGV4dC9EaWZmL=VuZ2luZS9zdHJpbmcucGhwIjtzOjM3OiIzYTExYjE5MzNkMTdmYzRkYTljMzAwMGNhY2VmNjkyOU84MzU=IjtzOjM5OiIvd3AtaW5jbHVkZXMvVGV4dC9EaWZmL=VuZ2luZS94ZGlmZi5waHAiO3M6Mzc6ImQ2YjkxZmM4NjI4YTBjMDQ3NGFkNTgzODlhNDc1ODE1TzIyMTAiO3M6MzU6Ii93cC1pbmNsdWRlcy9UZXh=L=RpZmYvUmVuZGVyZXIucGhwIjtzOjM3OiJmYzg3MjBkZjQzMzBiNTBmNTkzNzRmZGM=MGQ5NDc1M=82ODEzIjtzOjQyOiIvd3AtaW5jbHVkZXMvVGV4dC9EaWZmL1JlbmRlcmVyL2lubGluZS5waHAiO3M6Mzc6Ijg4MGFlNTZlMzViMTUwYjRiMmM3ZTlkOTQyMjdlODFlTzU1MzUiO3M6Mzg6Ii93cC1pbmNsdWRlcy9=aGVtZS1jb21wYXQvY29tbWVudHMucGhwIjtzOjM3OiIxODIyYmE5ZjYyZTRiZjNkNTEwYTdlNDMwNmU2N2Q=Yk8yMTEyIjtzOjM5OiIvd3AtaW5jbHVkZXMvdGhlbWUtY29tcGF=L2VtYmVkLTQwNC5waHAiO3M6MzY6IjhmYWIyNTAwMGZhZmVlNjk5ZmI=ZTc2ODcxZWQwMmY=Tzk3MCI7czo=MzoiL3dwLWluY2x1ZGVzL3RoZW1lLWNvbXBhdC9lbWJlZC1jb25=ZW5=LnBocCI7czozNzoiOGQ1NmI2OGMzODgzZGY4OWRjODEzYjJlYWZhMjkwMWNPMzE5OCI7czozNToiL3dwLWluY2x1ZGVzL3RoZW1lLWNvbXBhdC9lbWJlZC5waHAiO3M6MzY6IjcyYjY=Yzg5YmY=NWYyNzYwYzYxMzNmN2EzZGQzNjQ5TzQ3OSI7czo=MjoiL3dwLWluY2x1ZGVzL3RoZW1lLWNvbXBhdC9mb29=ZXItZW1iZWQucGhwIjtzOjM2OiIxNjg=MWNmNTVhZGMwNGFiODRmMjJlOTMyYjk2MTk2YU8=MzgiO3M6MzY6Ii93cC1pbmNsdWRlcy9=aGVtZS1jb21wYXQvZm9vdGVyLnBocCI7czozNzoiOGM1ZmY4NzNkYzMwOThhNWU=NmNjYmJmOTA5YzM3N2VPMTA1OSI7czo=MjoiL3dwLWluY2x1ZGVzL3RoZW1lLWNvbXBhdC9oZWFkZXItZW1iZWQucGhwIjtzOjM2OiI2Nzk2MmJhMmM4Nzg4MjlkMjY4MTc3NjZkMjU4ZGNjME83MDQiO3M6MzY6Ii93cC1pbmNsdWRlcy9=aGVtZS1jb21wYXQvaGVhZGVyLnBocCI7czozNzoiMzA=YzQwYmJhMWRkMjU4NzBhMGJjZWZmZWZjMjUwMjRPMTg5MyI7czozNzoiL3dwLWluY2x1ZGVzL3RoZW1lLWNvbXBhdC9zaWRlYmFyLnBocCI7czozNzoiODA4N2YzNzMwNGFkODZmZjE3NDhiNDQ=NmM5YTJjMGFPNDA2MCI7czoyMjoiL3dwLWluY2x1ZGVzL3RoZW1lLnBocCI7czozODoiMzQwOGQ5YzE4Zjk=YzI5MGM5MjI4NDEzM2E2MTllYjRPOTU3MjAiO3M6MjM6Ii93cC1pbmNsdWRlcy91cGRhdGUucGhwIjtzOjM4OiIxYmI3YWU5MTUxNTIwZTNlYzhhZjc5MGIzOTE2OGRhMU8yMzYyMSI7czoyMToiL3dwLWluY2x1ZGVzL3VzZXIucGhwIjtzOjM4OiI3NTMwZWI4ODZlZGI=YTFjYzQ4OGYxMmQ1ODJmMTRlNE84NTMxOSI7czoyMToiL3dwLWluY2x1ZGVzL3ZhcnMucGhwIjtzOjM3OiJjZGQxOTM5ZWZjYTJkNWJhZDdlOWVjOGQ=YTgyY2Y4ME81MzI2IjtzOjI=OiIvd3AtaW5jbHVkZXMvd2lkZ2V=cy5waHAiO3M6Mzg6IjI5ZGI4ZjE5MGFkYTcyM2FlNjIzNDhlZjIyNzlkYmUyTzQ4MDk=IjtzOjQ5OiIvd3AtaW5jbHVkZXMvd2lkZ2V=cy9jbGFzcy13cC1uYXYtbWVudS13aWRnZXQucGhwIjtzOjM3OiJhZmJmMTlhZDAxNGRjNjAyMzkyMGU=NGExMDFjNDQ=MU81Mzg=IjtzOjQ5OiIvd3AtaW5jbHVkZXMvd2lkZ2V=cy9jbGFzcy13cC13aWRnZXQtYXJjaGl2ZXMucGhwIjtzOjM3OiJhY2ZkY2ZkMTAzMDFhMDU3MTIyNWVjMzE=NWUyNDFkMk81MTk5IjtzOjQ5OiIvd3AtaW5jbHVkZXMvd2lkZ2V=cy9jbGFzcy13cC13aWRnZXQtY2FsZW5kYXIucGhwIjtzOjM3OiJkNjMxZmU4ZWNkODQxZGE4MTg=NTU3MjY2ZmY2M2FkZE8yOTQ2IjtzOjUxOiIvd3AtaW5jbHVkZXMvd2lkZ2V=cy9jbGFzcy13cC13aWRnZXQtY2F=ZWdvcmllcy5waHAiO3M6Mzc6ImNhZmQ1ZjEyZTQ5YjE5Zjg3M2UyYWMyNmMyZDEyZDI2TzU2NzIiO3M6NDY6Ii93cC1pbmNsdWRlcy93aWRnZXRzL2NsYXNzLXdwLXdpZGdldC1saW5rcy5waHAiO3M6Mzc6Ijk4NWY1YzZmOGE=MGY2N2Y3M2RiMTUzMmY1ZWVlYzUzTzY5ODMiO3M6NDU6Ii93cC1pbmNsdWRlcy93aWRnZXRzL2NsYXNzLXdwLXdpZGdldC1tZXRhLnBocCI7czozNzoiZjc4YWU5MzRjNmYxOTIxYWU2ZGU4NGE=NDU3NGMzNTVPMzUwNiI7czo=NjoiL3dwLWluY2x1ZGVzL3dpZGdldHMvY2xhc3Mtd3Atd2lkZ2V=LXBhZ2VzLnBocCI7czozNzoiOGY2MGRmMWY1NzgzYTA=OTgwZTk=YjE5YjAyN2E2MzJPNDc5NSI7czo1NjoiL3dwLWluY2x1ZGVzL3dpZGdldHMvY2xhc3Mtd3Atd2lkZ2V=LXJlY2VudC1jb21tZW5=cy5waHAiO3M6Mzc6IjBiZWZlMTA3NjI4ZjYwZDk1NTIzNTg1N2IzYTYwZjdhTzU4MDUiO3M6NTM6Ii93cC1pbmNsdWRlcy93aWRnZXRzL2NsYXNzLXdwLXdpZGdldC1yZWNlbnQtcG9zdHMucGhwIjtzOjM3OiJmZDYyYzdmMTJmNGYwMTg3MTYzNzM2MDUzZTZkZTMzY=8=ODI=IjtzOjQ=OiIvd3AtaW5jbHVkZXMvd2lkZ2V=cy9jbGFzcy13cC13aWRnZXQtcnNzLnBocCI7czozNzoiOTk1Y2U3MTM1OWRlYWRlMzAxMmI1MGQ4NjA=OTllMjdPMzc=OSI7czo=NzoiL3dwLWluY2x1ZGVzL3dpZGdldHMvY2xhc3Mtd3Atd2lkZ2V=LXNlYXJjaC5waHAiO3M6Mzc6ImUwNTZhNmViN2VhM2QwNjZlNWUzZTdmYjkyMzI4ZDFiTzI2NjIiO3M6NTA6Ii93cC1pbmNsdWRlcy93aWRnZXRzL2NsYXNzLXdwLXdpZGdldC1=YWctY2xvdWQucGhwIjtzOjM3OiI=OGY2NDY5MzA3YmU2Y2Y5ODg3ZGUxYjRlMzZjNmM2OE81MDU2IjtzOjQ1OiIvd3AtaW5jbHVkZXMvd2lkZ2V=cy9jbGFzcy13cC13aWRnZXQtdGV4dC5waHAiO3M6Mzc6IjllZWQ2NjYyNjI2ZWQzZGVjMDdkOWJiMTgwZGM5NTZlTzQxMTgiO3M6Mjg6Ii93cC1pbmNsdWRlcy93bHdtYW5pZmVzdC54bWwiO3M6Mzc6ImRmZDQ5MGI2ZjM4M2VhMDJhMjY5MDMxZmYwNWU4ODk2TzEwNDUiO3M6MjI6Ii93cC1pbmNsdWRlcy93cC1kYi5waHAiO3M6Mzg6IjkzMThkZGU5ODMwZWQ3YzAyZTQ2MzU2Y2E3NjNiNTgzTzk1NTEzIjtzOjI=OiIvd3AtaW5jbHVkZXMvd3AtZGlmZi5waHAiO3M6MzY6ImI4ZDJhMmYyZjM=OTQzYjY4NGI3ZTAyNTBkMzQyYzJlTzY2MSI7czoxODoiL3dwLWxpbmtzLW9wbWwucGhwIjtzOjM3OiI1NWY1ZWVkYTRmNjQyNzEzMjJkMjQ5YzE=Njg1YzE2Mk8yNDIyIjtzOjEyOiIvd3AtbG9hZC5waHAiO3M6Mzc6IjBjOWY=NDExOGRhZTM4NGU=NTQ3MjMzMTg=OTJhZjRmTzMzMDEiO3M6MTM6Ii93cC1sb2dpbi5waHAiO3M6Mzg6ImQ5ZjMwZDM1MzU5ZmYxYjg4NjViMmQ5NjExNDZmMjJmTzMzOTM5IjtzOjEyOiIvd3AtbWFpbC5waHAiO3M6Mzc6IjhkNmM5ZTRkYWI3Njk3YTA=NGEyMmE5NmNkNzg3MDY4TzgwNDgiO3M6MTY6Ii93cC1zZXR=aW5ncy5waHAiO3M6Mzg6IjAyNzQ3YmNjNjlkODM5YzY5OTE5YzMyMzFkNmY4YjMzTzE2MjUwIjtzOjE=OiIvd3Atc2lnbnVwLnBocCI7czozODoiNDk2YTY2MjlmMmFmZDllODI3NGExODBjYjVjYTBlZjFPMjk4OTYiO3M6MTc6Ii93cC1=cmFja2JhY2sucGhwIjtzOjM3OiIyNTNjYjYzNjM2NWJmZDk5YWYxZTczNDYyMjg2NDM3Zk8=NTEzIjtzOjExOiIveG1scnBjLnBocCI7czozNzoiNmM1M2UyZmYwNzYyODBjNWNmYzQxMGEzYzYzMmM3ODVPMzA2NSI7fX1zOjg6IndwX2xvZ2luIjthOjE6e3M6MzY6ImJydXRlIGZvcmNlIHBvc3NpYmxlIG9uIHdwLWxvZ2luLnBocCI7YToyOntpOjA7czo1OiJENE9BQiI7aToxO3M6MTc1OiIvLio_cmVxdWlyZVwoWyBcdF=qZGlybmFtZVwoX19GSUxFX19cKVsgXHRdKlwuWyBcdF=qWyInXVwvd3BcLWxvYWRcLnBocFsiJ11bIFx=XSpcKTsoPyFcL1wvMjAxMy=wNC=yNCBETyBOT1QgUkVNT1ZFIFRISVMgUkVRVUlSRUQgTElORSlbXlxuXSooW1xyXG4gXHRdKlwkX1NFU1NJT=5cW1teO1=rOykqL2lzIjt9fXM6ODoidGltdGh1bWIiO2E6MTp7czoyOToib3V=ZGF=ZWQgdmVyc2lvbnMgb2YgVGltVGh1bWIiO2E6Mjp7aTowO3M6NToiSDFRSkUiO2k6MTtzOjYwOiIvLitUaW1UaHVtYi4rZGVmaW5lXHMqXChbXHMnIl=rVkVSU=lPTltccyciXSssW1xzJyJdKzFcLi4rL3MiO319czo5OiJ3aGl=ZWxpc3QiO2E6Mjp7czozOiJwaHAiO2E6Mjg6e2k6MDtzOjU6IkZBOEhkIjtzOjM4OiI1ODczY2QxY2VhNjEwODIwMmQyMTM=N2YwMWYwNGRjZk84MTcyOCI7czo1OiJENzU5cCI7czozOToiMDEzNjM3MjhjODQzZmY5M2U5NmI2OTgzY2UzOGViYTZPMTk1NjE4IjtzOjU6IkQ1QTgzIjtzOjM4OiJkNWYzYzljYWZmMTRkNTdjODYwOGQ3OGRiMDA5NGJlME83MzY=MyI7czo1OiJENzVEOSI7czozODoiNTdhZjQ5ODE4YmJiOTQ5ZGMwYWM2Mzg2NzM4NjU1YmJPMjU4NTIiO3M6NToiRDdKRDkiO3M6Mzg6ImQ=OTQwNDI2MGQ3OWE=Y2MzNzU1YzAwZjU1ZGUyMDg5TzI1NjYyIjtzOjU6IkQ4VjhBIjtzOjM3OiI4NjYxZmUyYmZhNTk5NWY1NDZhMzMwNDdlOTAzODU2Y=8xMTM2IjtzOjU6IkRJQ=ZDIjtzOjM4OiI4MTI1ZDQyYzRiZTU=M2Y4NzRlYTVmNmExYjViZGU1NU8yNTg5NCI7czo1OiJESUNGRCI7czozOToiZWRkYjVmZGE3NGQ=MWRiZGFjMDE4MTY3NTM2ZDhkNTNPMjMxMzM4IjtzOjU6IkRJQ=ZFIjtzOjM4OiJjMTVhNGQ1YzM4MzQ=NGI5NWQyODU1OWY4MzQ4MTExZE8yMjU4OCI7czo1OiJFMVIydiI7czozODoiZTIwODM5YzU1OWE2NmM3Y2Y2Mjg2NTNiYTI=ODRlYWVPMjYzOTUiO3M6NToiRTFSMngiO3M6Mzg6ImYzMzgyZWMxNWMwMzBiZDMyZTI5M2ZhZjM=OTdlMjUzTzExMjI2IjtzOjU6IkUyMzBDIjtzOjM3OiIyOGE5MmY=NjQ5OGQzMmI5YTc=YzU4NDdmNzVjOTEyZU83Mzk5IjtzOjU6IkUyMzBDIjtzOjM3OiJmMDBhYWYwMWZmMDJkNTc1NmMyNjdiY2Y5MjBlNGMyOE8xNTQwIjtzOjU6IkUyQU1mIjtzOjM4OiI1N2M2NDdkOTNmYmQ=Nzg2OGI4N2I5MjFiZWU2M2FmOE8yNjM3NiI7czo1OiJFNUVEbyI7czozOToiOGUyYWY=ODg2ZGM4MWE1ZDkyODk4NjViYmI4MTNlZDFPMTk1NjE3IjtzOjU6IkU1SU5QIjtzOjM3OiJmODBkOWVmNGI3YmZkOWVmNTQyZDkwODdhMWRiMmFlOU8yMDEwIjtzOjU6IkU3RU12IjtzOjM4OiI1ZjkyN2YzYTk3MzIxOGQwN2U=M2VhMWM2OWZjMDMzMU8yNjc3NiI7czo1OiJFQTY2bCI7czozODoiYTViMWE3M2UwYzQyOTg5NTA3NTBhOGJjZDk2MjdlYWZPMjY4MTEiO3M6NToiRUNDRTAiO3M6Mzc6IjY=OTQ=ZTIyNTExM2JlMTgzOTRkNWJjMDFmYjNiNTM3Tzc1MzAiO3M6NToiRUNDRTMiO3M6Mzg6Ijk3ZTQzOGQ2YzljNjRhMjAyYjkzMDc4NmQyNzYyMDViTzYyNDU4IjtzOjU6IkVDQ=UzIjtzOjM4OiI2N2VjMWIxNTNjYzNmM2UzNmZiZWU1OTAyOWE5M2Q=YU8yNTkxNCI7czo1OiJFQ=pLRiI7czozNzoiODM2NjU3ZGJhNWNiMjI5MDAwMDI=NDc3NjYwZTlkZGZPODM2OSI7czo1OiJGNDM3MyI7czozODoiZjYwMDc5ZmVjMGU1ZDRkNjdlNDlhZGEzMzZkYWFmOTJPMjY4MTAiO3M6NToiRjQzNzQiO3M6Mzk6IjAzYjIxZmZjOWM3OWNmYjYyNDc5MGIwYmE=ODQ2OTFjTzMyMDMzMiI7czo1OiJGNUxNYiI7czozODoiNWU2ODU1Y2YwMmM=YWEwYWNjODcwMGY3ZjYxM2RmMDBPNjAxNjMiO3M6NToiRjZGSmUiO3M6Mzc6IjcxY2QxNjQ4MGFkZDIwZjUxNmY=MWNmMDQ1NzVmYjE4TzE4ODQiO3M6NToiRjlBOXQiO3M6Mzk6IjgzNGQyMmY4YjY4YTJjNWMwMTg2NmE=M2ViMjRlZmM=TzE5NTcwMiI7czo1OiJGQThIZCI7fXM6MjoianMiO2E6MzQ6e2k6MDtzOjU6IkY5QUFCIjtzOjM3OiI1NTRiYzc2YzcwMzUxMTg3ZjRjZTA1ZGRjMDEyYWFlZE8=Nzc2IjtzOjU6IkQ2NjdYIjtzOjM3OiI5YTljMTI1ODE=Yjk3MTU5ODJkMjQ2YTFlZTc4MDg=Zk81MzQ1IjtzOjU6IkQ2NjdYIjtzOjM4OiJlMzZhMDg2MTIzNzU2NDEyMjkzMjMxYWVhZDE3ZjI=Zk8zNzYyOSI7czo1OiJENzVBSCI7czozNzoiYTM4YWM1MjY2OTI=OTM4YTRmZjU1MTQzNjljNmI=MGRPNDY3NCI7czo1OiJENzVBSiI7czozNzoiMTA=M2ExZDdkODRlZTU2Zjg4MzFhNjBjZGZjNWRjMjhPNzA3NyI7czo1OiJENzVEUyI7czozODoiNmVjMTUwYjc5ODdjYWFlZjk4YjU5Yzg3YjlmNDcxYmVPMTE4NDIiO3M6NToiRTFSMm4iO3M6Mzg6IjYxNDdjY2VlN2FlZjlkYzBjNmViMTBkOGQ3YjMxMWY5TzcwODgzIjtzOjU6IkUxUjJ3IjtzOjM3OiJiYTMyOTM5NzBlMTNiMDNhMmVhOTJmNWI2YjViZjU=NE8zMzc3IjtzOjU6IkUyMk5xIjtzOjM3OiI2M2IwYWVkOWIwMmY4NzlhNmUwMjk1ZmJlYTdkYjg1NE8=NzAyIjtzOjU6IkUyMzBEIjtzOjM3OiJlZjQxODhjYjBiNjBhNzIwMTdmNGM4YTFlODQwYWIxZU8yOTUwIjtzOjU6IkUyNDlMIjtzOjM3OiJmYjhiZjY3ODVlNTVlOWUzOWJlYTU1MjYzNWM=MmE2NE8zMjcwIjtzOjU6IkUyNjBDIjtzOjM5OiJhY2IzMzMyOWI5ZWY4YWFiZDhiZDczMTQyNjgwM2U=ZU8yMzI=ODIiO3M6NToiRTI2MEUiO3M6Mzg6IjZjZWI2NDc1OTI1ODhiY2Y=NjNiZWZkOTQwOGUyN2FkTzEyMDI1IjtzOjU6IkUyNjBIIjtzOjM3OiI1YTMxODI3N2ZlZGY=OTFhMDMwMWUxNzdhOWVmMTBiM=8=OTA4IjtzOjU6IkUyNjBKIjtzOjM4OiJkYmMzODA4NDczZGVmMDBmY2U=NWZlNTY=ZGM3MmRjYk8xNDcyMCI7czo1OiJFMjYwSyI7czozNzoiYjk4OWE1YmQ4NGY2ZWJjYmMxMzkzZWMwMDNlNmU5OTFPNDk2OSI7czo1OiJFMjdFRyI7czozODoiMDMwYjgzODkzNzZhNDJmZjNkYTE4NmJmNjU4MDYyMTdPMTY1MzEiO3M6NToiRTI5RDIiO3M6Mzc6ImRlZjI1N2RiYjBhYjgwNWM=OTk2ZmQ4YWJiMWE2YjQ5TzY3MTciO3M6NToiRTJINW4iO3M6Mzg6Ijc=ZDkwMzA=OTY4M2U1YmJlYTljY2I3NTQ=YTQyYmNhTzE3NDEzIjtzOjU6IkU1RURxIjtzOjM4OiI2MDNiZDE=Mjk5ZjYxYTczMjliMmQzNTNiMmI1NmMyZk8zNzY4OSI7czo1OiJFNUVEcCI7czozNzoiMDQyNmIzOTc1NGFhNmJjNzY2ZDg5ZWE=YzQxYmJkMDZPMzQ1NyI7czo1OiJFNUVEeCI7czozODoiZWFkYzU4MzI1MTNkNTY3MDg4NGE5NzVjNmRlMTBmMDFPMTk2MTUiO3M6NToiRTdVTUEiO3M6Mzg6IjM4ZGJjYzkyNTUyOTM2ODgxMmY1YzJmYmNiMzg5NjE2TzE=OTY1IjtzOjU6IkU3VU1CIjtzOjM3OiJhMWMxODIyN2U2ZTkzNzk4YzQ5M2FlZDk2ZWU2Y2M4NE8zMjY3IjtzOjU6IkU3VU1CIjtzOjM3OiIwNzgzODhhNjQzMWFhNWIwODM4YTg3MzJkMTg3ZmUyOU84OTEzIjtzOjU6IkU4QUFwIjtzOjM3OiJmM2IxYjI4NDI=MzZmN2EzMTFiMzllNGVmNGI=N2Y1OU8=MzUyIjtzOjU6IkU4QkJVIjtzOjM3OiJkNzA5NDA2MTlhOTlkNTU1MTE2MTY3ZDRmYjM5Y2ExNU8=Mzk3IjtzOjU6IkU5Q=x4IjtzOjM4OiJjYmRiZmM5MTg=ZDI4YWM1NWY4M2MwYjBkZjQwZmQ=M=83OTQxNCI7czo1OiJFOUc4aiI7czozODoiZWYzYWU5MDE=NTI1Y2Y4MTE4N2FmYWE2MWJjYTczN2VPMzc2OTEiO3M6NToiRUNDRTEiO3M6Mzg6ImY=NDhjNTkzYzI=MmQxMzRlOTczM2E4NGM3YTRkMjZjTzE1MjQ4IjtzOjU6IkVDSDlYIjtzOjM5OiI1MWJiYTBkNTMzM2RlNGZkYTA5NTRmNTFlYTM1NWE1ME8xMDY3OTciO3M6NToiRjJBOFUiO3M6Mzg6IjY5MmY4ZTg2MWJhZmEzMWZiZjFiMzgwNWI=YjBkN2QzTzE1MDE2IjtzOjU6IkY=NkloIjtzOjM4OiJkODQyMzNkZDI5MzcxN2YwYTA3YjU1OGIyZmUzOGY1Nk8xNTA1MyI7czo1OiJGOUFBQiI7fX1zOjg6ImZpcmV3YWxsIjthOjM6e3M6OToiUmV2U2xpZGVyIjthOjc6e2k6MDtzOjU6IkdCS=ZyIjtpOjE7czozNjoiUmV2b2x1dGlvbiBTbGlkZXIgRXhwbG9pdCBQcm9=ZWN=aW9uIjtpOjI7czo=MTM6IlRoaXMgcHJvdGVjdGlvbiBpcyBhdXRvbWF=aWNhbGx5IGFjdGl2YXRlZCBiZWNhdXNlIG9mIHRoZSB3aWRlc3ByZWFkIGF=dGFja3Mgb24gV29yZFByZXNzIHRoYXQgaGF2ZSBhZmZlY3RlZCBzbyBtYW55IHNpdGVzLiBJdCBpcyBzdGlsbCByZWNvbW1lbmRlZCB=aGF=IHlvdSBtYWtlIHN1cmUgdG8gdXBncmFkZSBhbnkgb2xkZXIgdmVyc2lvbnMgb2YgdGhlIFJldm9sdXRpb24gU2xpZGVyIHBsdWdpbiwgZXNwZWNpYWxseSB=aG9zZSBpbmNsdWRlZCBpbiB=aGVtZXMgdGhhdCB3aWxsIG5vdCB1cGRhdGUgYXV=b21hdGljYWxseS4gRXZlbiBpZiB5b3UgZG9uJ3QgdGhpbmsgeW91IGhhdmUgUmV2b2x1dGlvbiBTbGlkZXIgb24geW91ciBzaXRlIGl=IGRvZW4ndCBodXJ=IHRvIGhhdmUgdGhpcyBwcm9=ZWN=aW9uIGVuYWJsZWQuIjtpOjM7czo2OiJTRVJWRVIiO2k6NDtzOjIwOiIvXC9hZG1pbi1hamF4XC5waHAvaSI7aTo1O3M6NzoiUkVRVUVTVCI7aTo2O3M6MTE5OiIvXCZpbWc9W15cJl=qKD88IVwucG5nKSg_PCFcLmpwZykoPzwhXC5qcGVnKSg_PCFcLmdpZikoPzwhXC5ibXApKD88IVwudGlmKSg_PCFcLnRpZmYpKD88IVwucHNkKSg_PCFcLnN2ZykoPzwhXC5pY28pXCYvaSI7fXM6OToiVHJhdmVyc2FsIjthOjU6e2k6MDtzOjU6IkdCS=M4IjtpOjE7czozMDoiRGlyZWN=b3J5IFRyYXZlcnNhbCBQcm9=ZWN=aW9uIjtpOjI7czoyMTY6IlRoaXMgcHJvdGVjdGlvbiBpcyBhdXRvbWF=aWNhbGx5IGFjdGl2YXRlZCBiZWNhdXNlIHRoaXMgdHlwZSBvZiBhdHRhY2sgaXMgcXVpdGUgY29tbW9uLiBUaGlzIHByb3RlY3Rpb24gY2FuIHByZXZlbnQgaGFja2VycyBmcm9tIGFjY2Vzc2luZyBzZWN1cmUgZmlsZXMgaW4gcGFyZW5=IGRpcmVjdG9yaWVzIChvciB1c2VyJ3MgZm9sZGVycyBvdXRzaWRlIHRoZSBzaXRlX3Jvb3QpLiI7aTozO3M6NzoiUkVRVUVTVCI7aTo=O3M6MjI6Ii89W1xzXC9dKihcLlwufGV=YylcLy8iO31zOjk6IlVwbG9hZFBIUCI7YTo1OntpOjA7czo1OiJHQ=9BVCI7aToxO3M6MjY6IlVwbG9hZCBQSFAgRmlsZSBQcm9=ZWN=aW9uIjtpOjI7czoxNzc6IlRoaXMgcHJvdGVjdGlvbiBpcyBhdXRvbWF=aWNhbGx5IGFjdGl2YXRlZCBiZWNhdXNlIHRoaXMgdHlwZSBvZiBhdHRhY2sgaXMgZXh=cmVtZWx5IGRhbmdlcm91cy4gVGhpcyBwcm9=ZWN=aW9uIGNhbiBwcmV2ZW5=IGhhY2tlcnMgZnJvbSB1cGxvYWRpbmcgbWFsaWNpb3VzIGNvZGUgdmlhIHdlYiBzY3JpcHRzLiI7aTozO3M6NToiRklMRVMiO2k6NDtzOjIwOiIvbmFtZT1bXlwmXSpcLnBocFwmLyI7fX1zOjg6Imh=YWNjZXNzIjthOjE=OntzOjI4OiJleGNlc2l2ZSBzcGFjZXMgaW4gLmh=YWNjZXNzIjthOjI6e2k6MDtzOjU6IkVBODdwIjtpOjE7czozMToiL1tcclxuXSsoW1x=IF17MzB9fFtcdF17MTB9KS4qLyI7fXM6MjY6ImV4Y2VzaXZlIHRhYnMgaW4gLmh=YWNjZXNzIjthOjI6e2k6MDtzOjU6IkVBODhTIjtpOjE7czozMjoiL14oW1x=IF17MzB9fFtcdF17MTB9KS4qW1xyXG5dKy8iO31zOjIyOiJSZXdyaXRlUnVsZSBtb2JpbGUgMzAyIjthOjI6e2k6MDtzOjU6IkQ=NUU5IjtpOjE7czoxMzg6Ii9SZXdyaXRlRW5naW5lIG9uLis_UmV3cml=ZVJ1bGUgXF5bXChdP1wuXCpbXCldP1wkIGh=dHA6XC9cLyhtb2JpbGUtLis_fC4rP2NvdW5=KGVyKT9cLnBocHwuKz9cP2g9WzAtOV=rKSBcWyhMXCwpP1IoPVswLTldezN9KT8oXCxMKT9cXS9zaSI7fXM6MjY6InBocF92YWx1ZSBhdXRvX2FwcGVuZF9maWxlIjthOjI6e2k6MDtzOjU6IkQzQzZGIjtpOjE7czozMToiL3BocF92YWx1ZSBhdXRvX2FwcGVuZF9maWxlIC4rLyI7fXM6NDc6IlRhZ2VkIFJld3JpdGVDb25kIEhUVFBfUkVGRVJFUiBSZXdyaXRlUnVsZSBIVFRQIjthOjI6e2k6MDtzOjU6IkQzSjZ3IjtpOjE7czoxNjc6Ii9cI1thLXpBLVowLTldK1wjLis_UmV3cml=ZUVuZ2luZSBvbltcclxuIFx=XStSZXdyaXRlQ29uZCBcJVx7SFRUUF9SRUZFUkVSXH=uKz9SZXdyaXRlUnVsZSBcXlwoXC5cKlwpXCQgaHR=cDpcL1wvLis_IFxbKExcLCk_Uj1bMC=5XXszfShcLEwpP1xdLis_XCNcL1thLXpBLVowLTldK1wjL3NpIjt9czoyNzoiRXJyb3JEb2N1bWVudCA=MDQgd3BwcG=ucGhwIjthOjI6e2k6MDtzOjU6IkRCSTYwIjtpOjE7czozMjoiL=Vycm9yRG9jdW1lbnQgNDA=IC4rd3BwcG1cLnBocC8iO31zOjU1OiJSZXdyaXRlQ29uZCBVU=VSX=FHRU5UIFJFRkVSRVIgUmV3cml=ZVJ1bGUgc3RhcnRpbmcucGhwIjthOjI6e2k6MDtzOjU6IkU4SDl2IjtpOjE7czo5MToiLyhSZXdyaXRlQ29uZCBcJVx7SFRUUF8oVVNFUl9BR=VOVHxSRUZFUkVSKVx9LitbXHJcbl=rKStSZXdyaXRlUnVsZS4rP1wvc3RhcnRpbmdcLnBocFw_LisvaSI7fXM6NDg6IlJld3JpdGVDb25kIEhUVFBfVVNFUl9BR=VOVCBSZXdyaXRlUnVsZSBodHRwIC5ydSI7YToyOntpOjA7czo1OiJGM1JCVyI7aToxO3M6MTA3OiIvKFJld3JpdGVFbmdpbmUgb25ccyspPyhSZXdyaXRlQ29uZCAuKj9IVFRQKFw6fF9BQ=NFUFR8X1VTRVJfQUdFTlQpLipccyspK1Jld3JpdGVSdWxlLio_IGh=dHAuKz9cLnJ1LipccyovaSI7fXM6NDk6IlJld3JpdGVDb25kIEhUVFBfVVNFUl9BR=VOVCBSZXdyaXRlUnVsZSBodHRwIC5waHAiO2E6Mjp7aTowO3M6NToiRjJPODAiO2k6MTtzOjk3OiIvKFJld3JpdGVDb25kIFwlXHtIVFRQX1VTRVJfQUdFTlRcfSAuK1xzKykrUmV3cml=ZVJ1bGUgXF5cJCBodHRwOlwvXC8uKz8obW9ieTI=XC5jb218XC5waHBcPykuKy9pIjt9czo3OToiUmV3cml=ZUVuZ2luZSBPbiBSZXdyaXRlQmFzZSBSZXdyaXRlQ29uZCBSZXdyaXRlUnVsZSBpbmRleC5waHAgcGFzc2luZyB2YXJpYWJsZSI7YToyOntpOjA7czo1OiJFQ=U4UyI7aToxO3M6MTc3OiIvUmV3cml=ZUVuZ2luZSBPblxzK1Jld3JpdGVCYXNlIFwvKFthLXowLTlcX1wtXSspXC9ccytSZXdyaXRlUnVsZSBcXmluZGV4W15cXV=rXF1ccysoUmV3cml=ZUNvbmQgLitccyspK1Jld3JpdGVSdWxlIFxeXChcLlwqXClcJCBcL1wxXC9pbmRleFwucGhwXD9bYS16MC=5XF9cLV=rPVwkMSBcW1teXF1dK1xdL2kiO31zOjY=OiJSZXdyaXRlRW5naW5lIG9uIFJld3JpdGVDb25kIEhUVFBfVVNFUl9BR=VOVCBSZXdyaXRlUnVsZSBodHRwIElQIjthOjI6e2k6MDtzOjU6Ikc5SkFZIjtpOjE7czoxOTM6Ii8oUmV3cml=ZUVuZ2luZSBvblxzKyk_KFJld3JpdGVDb25kIFwlXHsoUkVRVUVTVF9VUkl8SFRUUF9SRUZFUkVSfEhUVFBfVVNFUl9BR=VOVClcfSg_ISBmYXZpY29uXC5pY28gXFspLitccyspK1Jld3JpdGVSdWxlIC4qIGh=dHA6XC9cLyg_ITEyN1wufFwlXHsoSFRUUF9IT1NUfFJFTU9URV9BRERSKVx9fHdpa2lwZWRpYVwub3JnKS4qL2kiO31zOjQyOiJSZXdyaXRlRW5naW5lIG9uIFVOQ=9ORElUSU9OQUwgUmV3cml=ZVJ1bGUiO2E6Mjp7aTowO3M6NToiSDJLQUsiO2k6MTtzOjc2OiIvUmV3cml=ZVJ1bGUgXF5bXlxzXStccysuKz8oPzwhKGluZGV4XFx8bWluaWZ5KSlcLnBocFw_W149XSs9W1wkXCVce1xcXSsuKy9pIjt9czoxMDk6IlJld3JpdGVDb25kIEVOVjpSRURJUkVDVF9TVEFUVVMgUmV3cml=ZVJ1bGUgUmV3cml=ZUNvbmQgUkVGRVJFUi9VU=VSX=FHRU5UIGdvb2dsZS95YWhvby9iaW5nIFJld3JpdGVSdWxlIC5waHAiO2E6Mjp7aTowO3M6NToiRzE=Qk=iO2k6MTtzOjI2MzoiL1Jld3JpdGVDb25kXHMrXCVce=VOVlw6UkVESVJFQ1RfU1RBVFVTXH1ccysyMDBccytSZXdyaXRlUnVsZVtcXlwtXHNdK1xbW15cXV=rXF1ccysoUmV3cml=ZUNvbmRccytcJVx7SFRUUF8oUkVGRVJFUnxVU=VSX=FHRU5UKVx9XHMrXCgoKGdvb2dsZXx5YWhvb3xtc258YW9sfGJpbmcpKFx8fFwpKSkrKFxzK1xbW15cXV=rXF=pKlxzKykrUmV3cml=ZVJ1bGVccytcXlwoW15cKV=rXClcJFxzK1thLXpfXC=wLTldK1wucGhwXD9cJDFccytbXlxdXStbXF1cc1=rL2kiO31zOjIxOiJEaXJlY3RvcnlJbmRleCAhaW5kZXgiO2E6Mjp7aTowO3M6NToiRzU=RDciO2k6MTtzOjczOiIvKD88PURpcmVjdG9yeUluZGV4ICkoPyFpbmRleC5odG1sIHxpbmRleC5odG=gKSguKz8pKD89W15cL11pbmRleFwucGhwKS9pIjt9fXM6OToicG9=ZW5=aWFsIjthOjE1OntzOjQ6ImV2YWwiO2E6Mjp7aTowO3M6NToiRUFQTHEiO2k6MTtzOjM1OiIvW15hLXpcLyciXWV2YWxcKFteXCldK1snIlxzXCk7XSsvaSI7fXM6OToiYXV=aF9wYXNzIjthOjI6e2k6MDtzOjU6IkgxTjlZIjtpOjE7czoyMToiL1wkYXV=aF9wYXNzXHMqPS4rOy9pIjt9czoyMToiZG9jdW1lbnQud3JpdGUgaWZyYW1lIjthOjI6e2k6MDtzOjU6IkgxUEFPIjtpOjE7czo1MjoiL2RvY3VtZW5=XC53cml=ZVwoKFsnIl=pPGlmcmFtZSAuKzxcL2lmcmFtZT5cMVwpOyovaSI7fXM6MTU6InByZWdfcmVwbGFjZSAvZSI7YToyOntpOjA7czo1OiJHODVGMiI7aToxO3M6NDc6Ii9wcmVnX3JlcGxhY2VccypcKC4rW1wvXCNcfF1baV=qZVtpXSpbJyJdLitcKS9pIjt9czoyMDoiZXhlYyBzeXN=ZW=gcGFzc3RocnUiO2E6Mjp7aTowO3M6NToiRUFQTGciO2k6MTtzOjUxOiIvPFw_Lis_ZXhlY1woLis_c3lzdGVtXCguKz9wYXNzdGhydVwoLitmd3JpdGVcKC4rL3MiO31zOjI5OiJFeHRlcm5hbCBSZWRpcmVjdCBSZXdyaXRlUnVsZSI7YToyOntpOjA7czo1OiJGMVVJWiI7aToxO3M6NDI6Ii9SZXdyaXRlUnVsZSBbXiBdKyBodHRwXDpcL1wvKD8hMTI3XC4pLiovaSI7fXM6MzU6Im5vIGVycm9yX3JlcG9ydGluZyBsb25nIGxpbmVzIGFsb25lIjthOjI6e2k6MDtzOjU6IkgyUzhqIjtpOjE7czo3NDoiLzxcP1tcc2hwXSpcQD9lcnJvcl9yZXBvcnRpbmdcKDBcKTsuKz9bYS16MC=5XC9cLVw9JyJcLl17MjAwMH=uKj8oJHxcPz4pL2kiO31zOjIyOiJwcm9=ZWN=ZWQgYnkgY29weXJpZ2h=IjthOjI6e2k6MDtzOjU6IkQ4TUN3IjtpOjE7czoxMzY6Ii9cL1wqIFRoaXMgZmlsZSBpcyBwcm9=ZWN=ZWQgYnkgY29weXJpZ2h=IGxhdyBhbmQgcHJvdmlkZWQgdW5kZXIgbGljZW5zZS4gUmV2ZXJzZSBlbmdpbmVlcmluZyBvZiB=aGlzIGZpbGUgaXMgc3RyaWN=bHkgcHJvaGliaXRlZC4gXCpcLy8iO31zOjE5OiJhIHNwYW4gY29sb3IgRjFFRkU=IjthOjI6e2k6MDtzOjU6IkQ4UkFQIjtpOjE7czoxMTg6Ii9cPGEgW15cPl=rXD5cPHNwYW4gc3R5bGU9ImNvbG9yXDpcI=YxRUZFNDsiXD4oLis_KVw8XC9zcGFuXD5cPFwvYVw-XDxzcGFuIHN=eWxlPSJjb2xvclw6XCNGMUVGRTQ7Ilw-KC4rPylcPFwvc3Bhblw-L2kiO31zOjE3OiJWYXJpYWJsZSBGdW5jdGlvbiI7YToyOntpOjA7czo1OiJFODU2TCI7aToxO3M6Njc6Ii8oPCFcZClcJFtcJFx7XSpbYS16XC1cXzAtOV=rW1x9IFx=XSooXFtbXlxdXStcXVsgXHRdKikqXCguKj9cKVw7L2kiO31zOjExOiJUYWdnZWQgQ29kZSI7YToyOntpOjA7czo1OiJFNExNRyI7aToxO3M6MjQ6Ii9cIyhcdyspXCMuKz9cI1wvXDFcIy9pcyI7fXM6MTU6ImNyZWF=ZV9mdW5jdGlvbiI7YToyOntpOjA7czo1OiJHMU1GZSI7aToxO3M6Nzg6Ii8oXCRbYS16XzAtOV=rWz1cc1xAXSspP2NyZWF=ZV9mdW5jdGlvblwoW14sXSssW1xzXCRcLlxbXF1hLXpfMC=5XStbXHNcKV=rOyovaSI7fXM6NDM6ImZ1bmN=aW9uIGFkZF9hY3Rpb24gd3BfZW5xdWV1ZV9zY3JpcHQganNvbjIiO2E6Mjp7aTowO3M6NToiRjExNHYiO2k6MTtzOjE3OiIvanNvbjJcLm1pblwuanMvaSI7fXM6NDc6IlJld3JpdGVDb25kIEhUVFBfVVNFUl9BR=VOVCBSZXdyaXRlUnVsZSBodHRwIElQIjthOjI6e2k6MDtzOjU6IkYyNzdoIjtpOjE7czo4NDoiLyhSZXdyaXRlQ29uZCBcJVx7SFRUUF9VU=VSX=FHRU5UXH=gLitccyspK1Jld3JpdGVSdWxlIFxeLipcJCBodHRwOlwvXC8oPyExMjdcLikuKi9pIjt9czoxMjoidGl=bGUgaGFja2VkIjthOjI6e2k6MDtzOjU6IkgyUzhtIjtpOjE7czoyNzoiLzx=aXRsZT5bXjxdKmhhY2tbM2VdW3JkXS9pIjt9fXM6ODoiYmFja2Rvb3IiO2E6ODU6e3M6MjE6InNoZWxsIHN5c3RlbSBwYXNzdGhydSI7YToyOntpOjA7czo1OiJEOERKOSI7aToxO3M6OTk6Ii9cPFw_KC4rPykoc2hlbGx8YXV=aHApKC4rPyllcnJvcl9yZXBvcnRpbmdcKDBcKSguKz8pc2V=X3RpbWVfbGltaXRcKDBcKSguKz8paW5pX3NldFwoLitmb3BlblwoLisvcyI7fXM6MTg6ImF1dGhfcGFzcyBGaWxlc=1hbiI7YToyOntpOjA7czo1OiJIMTZHdCI7aToxO3M6MjA=OiIvPFw_W3BoXHNdK2lmW1xzXChdK2lzc2V=XHMqXChccypcJF8oUkVRVUVTfEdFfFBPUylUXFsoWyciXSkoW2Etel8wLTldKylcMlteXHtdK1x7XHMqc3dpdGNoIFwoXCRfXDFUXFtcMlwzXDJcXS4rP2RlZmF1bHQ6W15cfV=rW1x9XHNdK2RpZVwoW15cfV=rW1x9XHNdK2lmW1xzXChdK1wkd3BkYlwtPmdldF92YXJcKC4rP2V4aXQ7W1x9XHNdKygkfFw_PikvaXMiO31zOjI2OiJHRVRkb19yZW1vdmUgc2FmZV9tb2RlIGVuZCI7YToyOntpOjA7czo1OiJDQ1VMMyI7aToxO3M6MTE=OiIvaWZcKFwkX=dFVFxbJ2RvJ1xdPT=icmVtb3ZlIlwpXHtcbnVubGlua1woZ2V=Y3dkXChcKVwuXCRfU=VSVkVSXFsiU=NSSVBUX=5BTUUiXF1cKTsuK3NhZmVfbW9kZS4rZWxzZS4rJ1wuXCRlbmQ7L3MiO31zOjQwOiJzZXRfZXJyb3JfaGFuZGxlciBldmFsIGZpbGVfZ2V=X2NvbnRlbnRzIjthOjI6e2k6MDtzOjU6IkY5UzlXIjtpOjE7czoxMjQ6Ii8oZXJyb3JfcmVwb3J=aW5nXCguKz98c2V=X2Vycm9yX2hhbmRsZXJcKC4rPykqZXZhbFwoW15cKV=qPyhcJHJlcXVlc3R8c3RycmV2XCgpW15cKV=qP2ZpbGVfZ2V=X2NvbnRlbnRzXCgnW14nXSsnW1wpXHNdKzsvaXMiO31zOjIwOiJHRVRfZGwgc2FmZV9tb2RlIGVuZCI7YToyOntpOjA7czo1OiJFQ1NFViI7aToxO3M6MTAwOiIvPFw_W3BoXHNdK2lmXChpc3NldFwoXCRfR=VUXFtbJyJdZGxbIiddXF1cKS4rP3NhZmVfbW9kZS4rP1w_Pihccyo8XC9kaXY-XHMqPFwvYm9keT5ccyo8XC9odG1sPik_L2lzIjt9czoxMDoidW5zZXQgc2VsZiI7YToyOntpOjA7czo1OiJIMlNKaiI7aToxO3M6MzQyOiIvKFwkW2Etel8wLTldKylccyo9XHMqX19GSUxFX18uK3Vuc2V=XChccypcMVtcKVxzXSo7XHMqfDxcP1tcc2hwXSooXEA_Y2htb2RcKFteXCldK1wpO1xzKikqaWZbXHNcKFwhXSsoaXNzZXR8ZW1wdHkpW1xzXChdK1wkXyhSRVFVRVNUfEdFVHxQT1NUfENPT=tJRSlbXlx7XStbXHtcc1=qKFwkW2Etel8wLTlce1x9XSspXHMqPS4rP21rZGlyW1xzXCgiJ1wuXC9dK1w1W1wpO1xzXStmb3JlYWNoLis_XHtbXlx9XStcfVxzKihpZltcc1woXCFdK2lzX2RpclteXCldK1wpK1tce1xzXEBdKm1rZGlyW1xzXChdK1teXCldK1wpKztbXHNcfV=qKSsuKj8odW5saW5rXChbXlwpXStcKTtccyopKygkfFw_PikvaXMiO31zOjIzOiJjbGVhcnN=YXRjYWNoZSBoZXJlIGRpZSI7YToyOntpOjA7czo1OiJENUVBNSI7aToxO3M6MTQyOiIvPFw_KHBocCk_WyBcdFxyXG5dKyhpZlwoaXNzZXRcKFwkX=dFVFxbWyciXVswLTlhLXpBLVpdK1snIl1cXVwpXClbIFx=XHJcbl=qXHtbIFx=XHJcbl=rKT9jbGVhcnN=YXRjYWNoZS4raGVyZTtbIFx=XHJcbl=rZGllO1tcfSBcdFxyXG5dK1w_Pi9zIjt9czoyMToia2V5c3BhdCB2aWFncmEgY2lhbGlzIjthOjI6e2k6MDtzOjU6IkQxT=4zIjtpOjE7czoxMjA6Ii9lcnJvcl9yZXBvcnRpbmdcKDBcKTtbIFx=XHJcbl=rXCRrZXlzcGF=Wz=gXHRdK2FycmF5XChbIFx=XHJcbl=qKFsnIl=odmlhZ3JhfGFtb3hpY2lsbGlufGNpYWxpcylbJyJdWyBcdFxyXG4sXSspezJ9LisvcyI7fXM6MTg6ImV2YWwgUkVRVUVTVCBhbG9uZSI7YToyOntpOjA7czo1OiJGNFBMUCI7aToxO3M6MTYyOiIvPFw_W3BoXHNdKygoXCRbYS16XF8wLTldKylccyo9XHMqXCRfKFJFUVVFU3xHRXxQT1MpVFteO1=rO1xzKik_XEA_ZXZhbChbXChccypcQF=rc3RyaXBzbGFzaGVzKT9bXChccypcQF=rKFwyfFwkXyhSRVFVRVN8R=V8UE9TKVRccyooXFtbXlxdXStcXVxzKikrKVtcKTtcc1=rXD8-L2kiO31zOjMzOiJhdXRoX3Bhc3MgRmlsZXNNYW4gc2FmZV9tb2RlIGV2YWwiO2E6Mjp7aTowO3M6NToiSDE2QlAiO2k6MTtzOjc3OiIvXDxcPyg_PS4qXCRhdXRoX3Bhc3MpKD89LipGaWxlc=1hbikoPz=uKnNhZmVfbW9kZSkoPz=uKihldmFsfG5ldHN=YXQpXCgpLisvcyI7fXM6MTg6ImV2YWwgYmFzZTY=X2RlY29kZSI7YToyOntpOjA7czo1OiJHOFVOciI7aToxO3M6MzAyOiIvKFxAPygoZXJyb3JfcmVwb3J=aW5nfGluaV8oc2V=fHJlc3RvcmUpKVwoW15cKV=qXCl8XCRbYS16XF8wLTldK1xzKj1ccypbXjtdKyk7XHMqKSooaWZbXChcc1=raXNzZXRcKFwkXyhQT1N8R=V8UkVRVUVTKVRcW1teXCldK1tcKVxzXSspPyhlY2hvXHMqKT8oKFwkW2Etel8wLTldKylccyo9XHMqXEA_YmFzZTY=X2RlY29kZVwoW147XSs7XHMqXEA_KGV2YWxcKC4qXDl8XDlccypcKFxzKlwkXyhQT1N8R=V8UkVRVUVTKVQpfFxAP2V2YWxcKFteO1=qYmFzZTY=X2RlY29kZVwoKVteXCldKlwpKztccyoocmV=dXJuW147XSo7KSovaSI7fXM6NTE6InNlc3Npb25fc3RhcnQgZXJyb3JfcmVwb3J=aW5nIHNldF9=aW1lX2xpbWl=IGZvb3RlciI7YToyOntpOjA7czo1OiJENEpNaCI7aToxO3M6MTIwOiIvXDxcP3BocFtcclxuIFx=XStzZXNzaW9uX3N=YXJ=XChcKTtbXHJcbiBcdF=rZXJyb3JfcmVwb3J=aW5nXCgwXCk7W1xyXG4gXHRdK3NldF9=aW1lX2xpbWl=XCguKz88XD8gZWNobyBcJGZvb3RlcjtcPz4vaXMiO31zOjE4OiJmdW5jdGlvbiBCU1NWIGV2YWwiO2E6Mjp7aTowO3M6NToiRDROQ=MiO2k6MTtzOjY5OiIvKFwvXCouKj9cKlwvW1xyXG4gXHRdKikqZnVuY3Rpb24gQlNTVlwoLitldmFsXChCU1NWXCguKz9bXCldK1s7XSovaXMiO31zOjIzOiJGaWxlc=1hbiBwcmVnX3JlcGxhY2UgLiI7YToyOntpOjA7czo1OiJFQ=ZIcyI7aToxO3M6MjQ2OiIvPFw_W3BoXHNdKihcL1wqLis_XCpcL1xzKikqKFwkW2EtelxfMC=5XStccyo9W147XSs7XHMqKSpcJFthLXpcXzAtOV=rXHMqPVtccyInXSpGWyInXC5cc1=qaVsiJ1wuXHNdKmxbIidcLlxzXSplWyInXC5cc1=qc1siJ1wuXHNdKk1bIidcLlxzXSphWyInXC5cc1=qblsiJ1xzXSo7KFxzKlwkW2EtelxfMC=5XStccyo9W147XSs7KSpccyooXCRbYS16XF8wLTldK3xwcmVnX3JlcGxhY2UpXChbXlwpXSpbXCk7XHNdKygkfFw_PikvaXMiO31zOjI1OiJmdW5jdGlvbiBBcnJheSBwcmludCBleGl=IjthOjI6e2k6MDtzOjU6IkgyN=FzIjtpOjE7czo1ODM6Ii88XD9bcGhcc1=rKFwkW19cLVw-XC5hLXowLTlce1xbJyJcXVx9XStccyo9W147XSs7XHMqKSooKGZ1bmN=aW9uXHMrW2Etel8wLTldK1woLio_XClccypceyhcJFtePV=rPVxzKlsnIl17Mn=pP3xmb3JbXHMoXStbXlx7XStce1teXH1dK1x9Lio_fChyZXR1cm58Z2xvYmFsKVxzKyhcJFx7W15cfV=rXH=rKT9bXjtdKjt8XCRcey4rP1x9XHMqXCguKj9cKSs7fFwkXHsuKz9cfVxzKj1ccyphcnJheVwoKChbYS16XzAtOV=rXCguKj9cKSssXHMqKStbYS16XzAtOV=rXCguKj8pP1wpKzt8aWZccypcKC4qP1wpK1xzKlx7fGVsc2VbXHNce1=qfFwkW19cLVw-XC5hLXowLTlce1xbJyJcXVx9XStbXHNcLl=qPShccypjaHJcKC4qP1wpK3woLis_XF4pezUsfXxbXjtdK1xeXHMqXGQrKVteO1=qO3xleGl=XCguKj9cKSs7fChcJChce1thLXpfMC=5XStcKC4rP1wpXH=oXHMqXFtbXlxdXSpcXSspKnxjb25=ZW5=fHVybClbXHNcK1wuO1x9PD5cLl=qKSs9XHMqKFtcQFwkXHtdKlthLXpfMC=5XH1dKyhcKC4rP1wpfFxbLis_XF=pKVx9Kjt8Zm9yZWFjaC4rP1xzK2FzXHMrW15cKV=rW15ce1=rXHspWztcc1x9XSopezUwLH=oJHxcPz4pL2kiO31zOjMzOiJtZDV=YWdnZWQgZXZhbCB2YXJpYWJsZSBmdW5jdGlvbnMiO2E6Mjp7aTowO3M6NToiRjk2SzEiO2k6MTtzOjcyOiIvKChcJFthLXpcXzAtOV=rKVxzKj1ccypbXjtdKztccyopK1xAP2V2YWxcKFteO1=qXDJccypcKFteXCldKltcKVxzXSs7L2kiO31zOjI5OiJpZiBpc3NldCBSRVFVRVNUIGV2YWwgUkVRVUVTVCI7YToyOntpOjA7czo1OiJGN1VEUCI7aToxO3M6MjI5OiIvaWZbXHNcKF=raXNzZXRbXHNcKF=rXCRfKFJFUVVFU3xHRXxQT1MpVChcKFteXCldKlwpK3xcW1teXF1dKlxdK3xce1teXH1dKlx9KykqW15ce1=rW1x7XHNdK2V2YWxbXHNcKF=rKFthLXpfMC=5XStcKFxzKikqXCRfKFJFUVVFU3xHRXxQT1MpVChcKFteXCldKlwpK3xcW1teXF1dKlxdK3xce1teXH1dKlx9KykqW1xzXCk7XSsoKGRpZXxleGl=fGVjaG98cHJpbnQpW147XSo7XHMqKSpcfVs7XHNdKy9pIjt9czoxNDoiR=xPQkFMUyAwIGV2YWwiO2E6Mjp7aTowO3M6NToiRDU5TUsiO2k6MTtzOjc2OiIvKFwkKEdMT=JBTFNcW1snIl=pKlswb=9dK1snIlxdXD1cLiBcdF=rW147XSs7W1xyXG4gXHRdKikrZXZhbFwoLitbXCldK1s7XSovIjt9czozMjoiZXJyb3JfcmVwb3J=aW5nIHBhc3N3b3JkIGV4aXQgbWUiO2E6Mjp7aTowO3M6NToiRDVCQmsiO2k6MTtzOjE3MjoiLzxcPyhwaHApP1tcclxuIFx=XSplcnJvcl9yZXBvcnRpbmdcKDBcKTtbXHJcbiBcdF=qXC9cL=lmIHRoZXJlIGlzIGFuIGVycm9yLCB3ZSdsbCBzaG93IGl=LCBrXD9bXHJcbiBcdF=qXCRwYXNzd29yZFs9IFx=XSsuKyA6LVwpW1xyXG4gXHRdKmV4aXRcKFwpO1tcclxuIFx=XSpcPz5cLlwkbWVcLi9pcyI7fXM6Mjg6InBocCBTdGFydGluZyBjYWxscyBjOTlzaGV4aXQiO2E6Mjp7aTowO3M6NToiRDVESDciO2k6MTtzOjEwNjoiLzxcPyhwaHApKltcclxuIFx=XStcL1wvU3RhcnRpbmcgY2FsbHMuK2NoZGlyXChcJGxhc3RkaXJcKVs7XHJcbiBcdF=rW2EtejAtOV=rZXhpdFwoXClbO1xyXG4gXHRdKihcPz4pKi9pcyI7fXM6MzU6ImlmIGlzc2V=IFJFUVVFU1QgZm9yZWFjaCBhcnJheSBldmFsIjthOjI6e2k6MDtzOjU6IkczTjAxIjtpOjE7czoxNTk6Ii9pZltcc1woXSsoW2Etel8wLTldK1xzKlwoXHMqKSpcJF8oUkVRVUVTfEdFfFBPUylUXFtbXlx7XStce1xzKihcJFthLXpfMC=5XStccyo9W147XSs7XHMqfC4qP2ZvcmVhY2hcKGFycmF5Lio_KSpbXHNcQF=qKHN5c3RlbXxldmFsKVwoLitccyooZXhpdFteO1=qO1xzKikqXH=vaSI7fXM6MjA6InBocCBwYXNzd29yZCBoZ19leGl=IjthOjI6e2k6MDtzOjU6IkQ4SjdlIjtpOjE7czo=ODoiLzxcPyhwaHApPyhccykrXCRwYXNzd29yZCguKz8paGdfZXhpdFwoXCk7KC4rKS9zIjt9czo3MjoiaWYgZW1wdHkgU=VSVkVSIEhUVFBfVVNFUl9BR=VOVCBzZXRfdGltZV9saW1pdCBtb3ZlX3VwbG9hZGVkX2ZpbGUgcmV=dXJuIjthOjI6e2k6MDtzOjU6Ikc4R=JUIjtpOjE7czozMDM6Ii8oPGh=bWwuKj88Ym9keT5ccyopPzxcP1twaF=qXHMqKChwcmludHxlY2hvKVteO1=qO1xzKnxcL1wqW15cKl=qKFwqW15cKlwvXSopK1wvXHMqKSppZltcc1woXCFdKyhcQD9pc191cGxvYWRlZF9maWxlfGVtcHR5XChcJF9TRVJWRVJcW1siJ11IVFRQX1VTRVJfQUdFTlRbIiddXF1bXClcc1=rKC4rPylzZXRfdGltZV9saW1pdCkuKz9tb3ZlX3VwbG9hZGVkX2ZpbGUuKyhyZXR1cm4gXCRbYS16XzAtOV=rfHRvdWNoXHMqKFwvXCouKj9cKlwvXHMqKSpcKFteO1=rKTtbXHNcfV=rKCR8XD8-KFxzKjxcLyhib2R5fGh=bWwpPikqKS9pcyI7fXM6MzU6ImVycm9yX3JlcG9ydGluZyBpbmlfc2V=IHVubGluayBGSUxFIjthOjI6e2k6MDtzOjU6IkgyRjlqIjtpOjE7czozMDA6Ii9cQD9lcnJvcl9yZXBvcnRpbmdcKDBcKTtccyooaW5pX3NldFwoLitcQD91bmxpbmtcKF9fRklMRV9fXCk7fChpZltcc1woXCFdKyhpc3NldFwofGZpbGVfZXhpc3RzXCgpP1xzKlwkXyhTRVJWRVJ8UkVRVUVTVHxHRVR8UE9TVHxGSUxFUylcW1teXF1dK1xdK1teXCldKlwpW1wpXHNce1=qKGVjaG9bXjtdKztccyopKikrXEA_Y29weVwoKFtcc1wsXSpcJF9GSUxFUyhcW1teXF1dK1xdKykrKStbXClcc1=rO1tcc1x9XStcPz5ccyooPChmb3JtfGlucHV=KVtePl=rPlxzKikrPFwvZm9ybT5ccyooPFw_W3BoXHNdK1x9Kyk_KS9pcyI7fXM6MzE6InBocCBpZiBtZDUgUkVRVUVTVCBldmFsIFJFUVVFU1QiO2E6Mjp7aTowO3M6NToiRUJSTnUiO2k6MTtzOjE1NjoiLzxcP1twaFxzXSsoXCRbYS16XF8wLTldK1xzKj1ccyouKz87XHMqKSppZlwoXChtZDVcKFwkX1JFUVVFU1RcWy4rP2V2YWxcKFwkW2EtelxfMC=5XStcKFwkX1JFUVVFU1RcWy4qPztcfVx9XD8-KDxmb3JtW14-XSooPlxzKjxpbnB1dFtePl=qKSs-XHMqPFwvZm9ybT4pPy9zIjt9czozMzoiL2F1dGhfcGFzcyBsb3ZlIHNldF9lcnJvcl9oYW5kbGVyIjthOjI6e2k6MDtzOjU6IkRBTTlyIjtpOjE7czo5MzoiL1w8XD8oPz=uKlwkYXV=aF9wYXNzKSg_PS4qbG92ZUxvZ2luKSg_PS4qbG92ZXNldGNvb2tpZSkoPz=uKnNldF9lcnJvcl9oYW5kbGVyXCgpLisoXD9cPikqL2lzIjt9czo=OToiZnVuY3Rpb24gZ3ppbmZsYXRlIGJhc2U2NF9kZWNvZGUgZm9yIGNociBvcmQgZXZhbCI7YToyOntpOjA7czo1OiJGOFZHeCI7aToxO3M6MjIxOiIvKGZ1bmN=aW9uXHMrKFthLXpfMC=5XSspXHMqXChccyooXCRbYS16XzAtOV=rKVtcKVxzXHtdK1wzWz1cc1=rZ3ppbmZsYXRlXChiYXNlNjRfZGVjb2RlXCguK1tcKTtcc1=rKT9mb3JbXHNcKF=rLis_XHtccyooXCRbYS16XzAtOV=rKVtcLlxzXSo9W1xAXHNdKmNoclwoW147XStbO1xzXH1dKyhyZXR1cm5bXjtdKls7XH1cc1=rKT9ldmFsXCgoXDJcKHxcNClbXlwpXSpbXClcc1=rOyovaSI7fXM6MTg6Ii9mdW5jdGlvbiB4IGV2YWwgeCI7YToyOntpOjA7czo1OiJHNzFDNCI7aToxO3M6MTUxOiIvKGlmXHMqXChbXlx7XStce1xzKik_ZnVuY3Rpb25ccysoW2Etel8wLTldKylccypcKFteXHtdK1x7XHMqKFwkW2Etel8wLTldK1xzKj1bXjtdKztccyopKlxAPyhhc3NlcnR8ZXZhbClcKC4rP1wyXChcJF8oUkVRVUVTfEdFfFBPUylUXFsuKz9cKTtbXHNcfV=qL2lzIjt9czoxMToiaW5jbHVkZSBHRVQiO2E6Mjp7aTowO3M6NToiSDJBSzciO2k6MTtzOjI5MzoiLygoXCRbMC=5X2Etel=rKVxzKj1ccyooWyInXSkoW2EtelwvX1wtMC=5XC5dKlxceFthLWYwLTldezJ9KStbXlwzXSo_XDM7KT9bXEBcc1=qKGluY2x1ZGV8cmVxdWlyZSkoX29uY2UpP1tcc1woXSooXC9cKlteXCpdKihcKlteXCpcL1=qKStcL1xzKikqW1woXHNdKigoWyInXSkoW2EtelwvX1wtMC=5XC5dKlxceFthLWYwLTldezJ9KStbXlwxMF=qP1wxMHxcMnxcJF8oPyFSRVFVRVNUXFsndGFyZ2V=J1xdOykoUE9TfFJFUVVFU3xHRSlUXHMqKFxbW15cXV=rXF1ccyp8XHtbXlx9XStcfVxzKikrKVtcc1wpXSo7L2kiO31zOjIyOiJldmFsIGFycmF5X3BvcCBSRVFVRVNUIjthOjI6e2k6MDtzOjU6IkRCTTk1IjtpOjE7czo2MzoiL2V2YWxcKFtcdGEtel8wLTkgXChdKmFycmF5X3BvcFwoXCRfKEdFfFBPU3xSRVFVRVMpVFtcKV=rWztdKi9pIjt9czo=MjoiaWYgaXNzZXQgUkVRVUVTVCBldmFsIG9yIGZpbGVfcHV=X2NvbnRlbnRzIjthOjI6e2k6MDtzOjU6IkgxR=NnIjtpOjE7czozNzE6Ii88XD9bcGhcc1=rKGZ1bmN=aW9uIChbYS16XzAtOV=rKVwoW15ce1=rW1x7XHNdKy4rcmV=dXJuW147XSo7W31cc1=rKT9pZltcc1woXStpc3NldFtcc1woXStcJF8oUkVRVUVTfEdFfFBPUylUKFxzKlxbW15cXV=rXF=pK1tcKVxzXHtdKyhcJFthLXpfXC=wLTldK1xzKj1ccyouKz87XHMqKSooKChoZWFkZXJ8dW5saW5rKVwoW147XStbO1xzXSspezIsfVtcfVxzXSplbHNlW1x7XHNdKyhcJFthLXpfXC=wLTldK1xzKj1ccyouKz87XHMqKSooKFwkW2Etel9cLTAtOV=rXHMqPVxzKik_XEA_KGV2YWx8XDIpXCguKz9cKTtccyopezIsfXxmaWxlX3B1dF9jb25=ZW5=c1woW14sXSssXHMqYmFzZTY=X2RlY29kZVwoLis_XCk7KVtcfVxzXSooXD8-fCQpL2lzIjt9czoyMzoiaWYgZm9yIHVuc2V=IHdwX3dwIGZvcm=iO2E6Mjp7aTowO3M6NToiRThHQlAiO2k6MTtzOjEyNDoiLyhcJHdwW19dK3dwWyBcdF=qPVteO1=rO1tcclxuIFx=XSopKihpZnxmb3J8dW5zZXQpWyBcdF=qXChcJHdwW19dK3dwW147XSs7Lis_XD8-PGZvcm=uKz9uYW1lPVsnIl13cFtfXSt3cFsnIl=uKz88XC9mb3JtPi9pcyI7fXM6Mjg6ImFzc2VydCBIZXggNjRlbmNvZGVkVGV4dCBIZXgiO2E6Mjp7aTowO3M6NToiRjUyREUiO2k6MTtzOjI5NDoiLyhhc3NlcnRfb3B=aW9uc1woLis_XCk7XHMqfGZ1bmN=aW9uIFthLXpfMC=5XStcKFteXCldKltcKVxzXHtdKy4rP3JldHVyblteO1=qWztcfVxzXSt8XCQoY29sb3J8YXV=aHxwYXNzfGRlZmF1bHR8X18pW19cLVw-XC5hLXowLTldKlxzKj=uKz87XHMqKSooKChcJFthLXpfMC=5XSspXHMqPS4qP1wkXDJ8KFwkW2Etel8wLTldKylccyo9Lio_XDUpLipccyopKmFzc2VydFwoXHMqKCIoXFx4WzAtOUEtRl1bMC=5QS1GXSkrJ1tcL2EtelxfMC=5XD1dKycoXFx4WzAtOUEtRl1bMC=5QS1GXSkrInxcNilbXClcc1=rOy9pIjt9czoyNDoid2ViIHNoZWxsIGZvcGVuIHBhc3N=aHJ1IjthOjI6e2k6MDtzOjU6IkUyNjRxIjtpOjE7czo2OToiL14uKz9lcnJvcl9yZXBvcnRpbmdcKC4rP3dlYlsgXHRdKnNoZWxsLis_Zm9wZW5cKC4rP3Bhc3N=aHJ1XCguKz8kL2lzIjt9czo1NzoicGhwIGlmIGlzX2RpciBmaWxlX2dldF9jb25=ZW5=cyBpZiBmaWxlX3B1dF9jb25=ZW5=cyBlY2hvIjthOjI6e2k6MDtzOjU6Ikc3RDBXIjtpOjE7czozNDU6Ii88XD9bcGhcc1=rKFwvXC9bXlxuXSpbXHJcbl=rfFwkW2Etel8wLTldK1xzKj1bXjtdKjtccyp8ZXJyb3JfcmVwb3J=aW5nXChbXjtdKztccyopKy4rPyhpbmNsdWRlW147XSp3cC1jbGFzcy1oZWFkZXJzLnBocC4rP3xpZltcKFxzXStpc19kaXJbXlx7XStceyhccypcJFthLXpfMC=5XStccyo9ZmlsZV98W15cfV=rXH1ccyopZ2V=XyhhbGxfZGlyc1woLis_fGNvbnRlbnRzXChbXjtdKjtccypcJFthLXpfMC=5XStccyo9W147XSo7XHMqKGlmW1woXHNdKyk_KSlmaWxlX3B1dF9jb25=ZW5=c1woLis_KCh=b3VjaFwoLit8ZWNob1teO1=qO1xzKnxcfShccyplbHNlW1xzXHtdKyk_KVxzKikrKCR8XD8-KS9pcyI7fXM6NTM6InZhciBmdW5jdGlvbnMgcmV=dXJuIG5ldyBSZWN1cnNpdmVBcnJheUl=ZXJhdG9yIGFycmF5IjthOjI6e2k6MDtzOjU6IkUyNjZjIjtpOjE7czoxOTE6Ii8oXCRbYS16XF8wLTldK1tcdCA9XSsiW2EtelxfXC1cXDAtOV=qIjtbXHJcbiBcdF=qKSsoKFwkW2EtelxfMC=5XStbXHQgPV=rKT9cJFthLXpcXzAtOV=rXCgrLis_W1wpXSs7W1xyXG4gXHRdKikrLityZXR1cm5bIFx=XStuZXdbIFx=XStSZWN1cnNpdmVBcnJheUl=ZXJhdG9yW1woIFx=XSthcnJheS4rP1tcKSBcdF=rO1tcfV=rL2lzIjt9czo3NjoiZGlzcGxheV9lcnJvcnMgZmlsZV9nZXRfY29udGVudHMgX1JFUVVFU1QgZmlsZW5hbWUgdXBkYXRlX2NvZGUgZndyaXRlIHVubGluayI7YToyOntpOjA7czo1OiJHOE1KNCI7aToxO3M6MTUzOiIvXi4rPyhlcnJvcl9yZXBvcnRpbmdcKDBcKXxkaXNwbGF5X2Vycm9ycykuKz8oZmlsZV9nZXRfY29udGVudHNcKFteO1=qfHVybGRlY29kZVwoKVwkXyhQT3xSRVFVRSlTVFxbWyInXWZbaWxlXSpuYW1lW3NdP1siJ11cXS4rP2Z3cml=ZVwoLis_dW5saW5rXCguKyQvaXMiO31zOjUxOiJkaXNwbGF5X2Vycm9ycyBjcmVhdGVfd3BfdXNlciBSRVFVRVNUIGZ3cml=ZSB1bmxpbmsiO2E6Mjp7aTowO3M6NToiRTJGOWIiO2k6MTtzOjc5OiIvXi4rP2Rpc3BsYXlfZXJyb3JzLis_Y3JlYXRlX3dwX3VzZXJcKFwkX1JFUVVFU1RcWy4rP2Z3cml=ZVwoLis_dW5saW5rXCguKz8kL2lzIjt9czoxNzoicGhwIGNsYXNzIHZpYVdvcm=iO2E6Mjp7aTowO3M6NToiRjc=RWUiO2k6MTtzOjI1MjoiLzxcP1twaFxzXSsoXC9cKi4qP1wqXC9ccyopKihjbGFzcyB2aWFXb3JtXHMqXHsuKz9md3JpdGVcKC4rP2ZpbGVfZ2V=X2NvbnRlbnRzXCguKz91bmxpbmtcKC4rP2Jhc2U2NF9lbmNvZGVcKC4rPyk_ZmlsZV9wdXRfY29udGVudHNcKFteLF=rLFxzKmJhc2U2NF9kZWNvZGVcKChcQD9maWxlX2dldF9jb25=ZW5=c1woLit8W15cKV=rW1wpO1xzXStlY2hvW1xzXChdK2ZpbGVfZ2V=X2NvbnRlbnRzXChbXlwpXStbXCk7XHNdKygkfFw_PikpL2lzIjt9czo=MjoiaWYgaXNzZXQgUkVRVUVTVCBGSUxFIHN=cmlwc2xhc2hlcyBSRVFVRVNUIjthOjI6e2k6MDtzOjU6Ikc2OEMzIjtpOjE7czoyODI6Ii9pZltcc1woXStpc3NldFtcc1woXStcJF8oR=V8UE9TfFJFUVVFUylUKFxzKlxbW15cXV=qXF=rfFxzKlx7W15cfV=qXH=rKStbXHNcKVx7XSsoKFwkW2Etel8wLTldKylccyo9XHMqXCRfKEdFfFBPU3xSRVFVRVMpVChccypcW1teXF1dKlxdK3xccypce1teXH1dKlx9KykrW147XSpbO1xzXSopKihhc3NlcnR8ZXZhbHxcJFthLXpfMC=5XSspXHMqXCgrc3RyaXBzbGFzaGVzXChcJF8oR=V8UE9TfFJFUVVFUylUKFxzKlxbW15cXV=qXF=rfFxzKlx7W15cfV=qXH=rKStbXHNcKV=rO1tcfVxzXSovaSI7fXM6ODE6ImVycm9yX3JlcG9ydGluZyBldmFsIGN1cmxfaW5pdCBmaWxlX2dldF9jb25=ZW5=cyBmaWxlX3B1dF9jb25=ZW5=cyBpbmNsdWRlIHVubGluayI7YToyOntpOjA7czo1OiJFNUVEWiI7aToxO3M6MjAxOiIvXCRbYS16XF8wLTldK1s9XHNdK19fRklMRV9fO1xzKlwkW2EtelxfMC=5XStbXHM9XVteO117MjAwMH=uKj9lcnJvcl9yZXBvcnRpbmdcKC4rP2V2YWxcKC4rPyhjdXJsX2luaXR8ZmlsZV9nZXRfY29udGVudHMpLis_ZmlsZV9wdXRfY29udGVudHNcKC4rP2luY2x1ZGUuKj91bmxpbmtcKC4qP1wpO1xzKlx9XHMqZWxzZVxzKlx7W15cfV=rW1x9XSsvaXMiO31zOjU2OiJpZiBpc3NldCBQT1NUIGZpbGVfZ2V=X2NvbnRlbnRzIGZvcGVuIGZ3cml=ZSBmY2xvc2UgZXhpdCI7YToyOntpOjA7czo1OiJFNUlObyI7aToxO3M6MjkyOiIvKFwkYXV=aF9wYXNzWz1cc1=rLis_KT8oaWZbXHNdKlwoW1xzXSppc3NldFtcc1=qXChbXHNdKlwkXyhSRVFVRVN8R=V8UE9TKVRcWy4rP2ZpbGVfZ2V=X2NvbnRlbnRzXChfX=ZJTEVfXy4rP2ZvcGVuXCguKz9md3JpdGVcKC4qP2ZjbG9zZVwoLio_ZXhpdDtbXHNcfV=qKSsoaWZbXHNdKlwoW1xzXSppc3NldFtcc1=qXChbXHNdKlwkXyhSRVFVRVN8R=V8UE9TKVRcW1teXHtdK1tcc1x7XStpZltcc1=qXChbXHNdKmZpbGVfZXhpc3RzW1xzXSpcKFteXHtdK1tcc1x7XStbXlx9XStbXH1dW15cfV=qW1x9XSk_L2lzIjt9czo2MDoicGF=aCBpZiBmaWxlX2V4aXN=cyBpc193cml=YWJsZSBpZiBmdW5jdGlvbl9leGlzdHMgV3JpdGVEYXRhIjthOjI6e2k6MDtzOjU6IkU1RkN2IjtpOjE7czoxMzk6Ii9cJHBhdGhbPVxzXSsuK1tcc1=qaWZbXHNdKlwoXCFmaWxlX2V4aXN=c1woLis_aXNfd3JpdGFibGVcKFteXCldKltcKVxzXHtdK2lmW1xzXSpcKGZ1bmN=aW9uX2V4aXN=c1woLis_V3JpdGVEYXRhLis_V3JpdGVEYXRhXChcKTtbXHNcfV=rL2kiO31zOjUyOiJhdXRoX3Bhc3MgY29weSBGSUxFUyBleGVjIHBhc3N=aHJ1IHN5c3RlbSBzaGVsbF9leGVjIjthOjI6e2k6MDtzOjU6IkY=REgxIjtpOjE7czoxMjE6Ii88XD8oPz=uKlwkKG1kNXxhdXRoKV9wYXNzXHMqPSkoPz=uKmNvcHlcKFwkXyhQT1NUfEZJTEVTKVxbKSg_PS4qZXhlY1woKSg_PS4qcGFzc3RocnUpKD89LipzeXN=ZW=pKD89LipzaGVsbF9leGVjXCgpLisvaXMiO31zOjg4OiJwaHAgc2V=X3RpbWVfbGltaXQgZmlsZV9nZXRfY29udGVudHMgUkVRVUVTVCBmaWxlX2dldF9jb25=ZW5=cyBGSUxFUyBmb3BlbiBSRVFVRVNUZndyaXRlIjthOjI6e2k6MDtzOjU6IkU1SU5BIjtpOjE7czoxNTQ6Ii88XD8ocGhwKT8uKz9zZXRfdGltZV9saW1pdFwoLis_ZmlsZV9nZXRfY29udGVudHNcKFwkXyhSRVFVRVN8R=V8UE9TKVQuKz9maWxlX2dldF9jb25=ZW5=c1woXCRfRklMRVNcWy4rP2ZvcGVuXChcJF8oUkVRVUVTfEdFfFBPUylULis_ZndyaXRlXCguKz8oXD9cPikvaXMiO31zOjE=MDoiZXJyb3JfcmVwb3J=aW5nIGZ1bmN=aW9uIGVycm9yXzQwNCB=dHBfcmVxdWVzdF9jdXN=b2=gZ2V=SXAgZ2V=VXNlcmFnZW5=IGNvbnZlcnRJcFRvU3RyaW5nIGh=dHBfYnVpbGRfcXVlcnkgZmlsZV9nZXRfY29udGVudHMgZndyaXRlIGxvbmcyaXAiO2E6Mjp7aTowO3M6NToiRjdWOWgiO2k6MTtzOjIxMjoiLzxcPy4rP2Vycm9yX3JlcG9ydGluZ1woKD89Lis_Z2V=W19dKklwXCgpKD89Lis_ZnVuY3Rpb24gZXJyb3JfNDA=XCgpKCg_PS4rP3N=cmVhbV9jb25=ZXh=X2NyZWF=ZVwoKXwoPz=uKz9yZXF1ZXN=X2N1c3RvbVwoKSkoPz=uKz9odHRwX2J1aWxkX3F1ZXJ5XCgpKD89Lis_ZmlsZV9nZXRfY29udGVudHNcKCkoPz=uKz9oZWFkZXJcKCkoPz=uKz9sb25nMmlwXCgpLisvaXMiO31zOjQ1OiJpZiBmdW5jdGlvbl9leGlzdHMgZnVuY3Rpb24gdmFyaWFibGUgZnVuY3Rpb24iO2E6Mjp7aTowO3M6NToiRzM5S=YiO2k6MTtzOjMxMjoiLyhcL1wqW15cKl=qKFwqW15cKlwvXSopK1wvXHMqKSooXCRbYS16XzAtOV=rKFxzKlxbW15cXV=rXF=rKSpbXC5cc1=qPVteO1=rO1xzKikqaWZbXChcc1whXStmdW5jdGlvbl9leGlzdHNbXChcc1=rKFsnIl=pKC4rPylcNVtcKVxzXStce1xzKmZ1bmN=aW9uXHMqXDZccypcKC4rP3JldHVybi4qPztbXHNcfV=rKChcJFthLXpfMC=5XSspXHMqPVxzKihjcmVhdGVfZnVuY3Rpb25ccypcKFteLF=rLFxzKik_XDZcKFteO1=rWztcfVxzXSspKyhccyooXCRbYS16XzAtOV=rXHMqPVxzKik_XCRbYS16XzAtOV=rXChbXjtdK1siJ1wpO1x9XHNdKykrL2lzIjt9czo=NjoicGVybCB1c2UgSU86OlNvY2tldCBzY2FuX2RpciB1bmFtZSBzeXN=ZW=gZXhlYyI7YToyOntpOjA7czo1OiJFOFM3ZSI7aToxO3M6NzQ6Ii9cI1whXC91c3JcL2JpblwvcGVybC4rP3NjYW5fZGlyXCguKz91bmFtZVwoLis_c3lzdGVtXCguKz9maWxlbWFuYWdlci4rL2lzIjt9czo2MToiZnVuY3Rpb24gWF9pcCBYX21hY3JvcyBlcnJvcl8=MDQgaHR=cF9yZXF1ZXN=IGZ3cml=ZSBGVU5DVElPTiI7YToyOntpOjA7czo1OiJFOUg5NSI7aToxO3M6MTE2OiIvXDxcPy4rP19pcFwoKC4rP2Z1bmN=aW9uIFthLXowLTldK19tYWNyb3NcKCl7NH=uKz9mdW5jdGlvbiBlcnJvcl8=MDRcKC4rP2h=dHBfcmVxdWVzdC4rP2Z3cml=ZVwoLis_X19GVU5DVElPTl9fLisvcyI7fXM6MzE6ImlmIGlzc2V=IGV2YWwgVmFyaWFibGUgZnVuY3Rpb24iO2E6Mjp7aTowO3M6NToiRzRDRUQiO2k6MTtzOjI1NzoiLyhcQD9=b3VjaFwoLipcKSs7XHMqKSooXCRbYS16XzAtOVx7XCRcfV=rKFxzKlxbW15cXV=rXF=pKlxzKj1bXjtdKztccyopKmlmW1xzXChcIV=raXNzZXRbXHNcKF=rXCRbYS16XzAtOVx7XCRcfV=rKFxzKlxbW15cXV=rXF=pKltcKVxzXHtdKy4qP1xzKihcJFthLXpfMC=5XHtcJFx9XSsoXHMqXFtbXlxdXStcXSkqXHMqPVxzKik_XEA_ZXZhbFwoLio_XCRbYS16XzAtOVx7XCRcfV=rKFxzKlxbW15cXV=rXF=pKlxzKlwoLio_XCkrO1s7XH1cc1=qL2kiO31zOjU3OiJlcnJvcl9yZXBvcnRpbmcgZXhlYyBzeXN=ZW=gcGFzc3RocnUgZm9wZW4gUkVRVUVTVCBmd3JpdGUiO2E6Mjp7aTowO3M6NToiRjQ3NTUiO2k6MTtzOjIzNjoiLzxcPy4rPyhzZXRfdGltZV9saW1pdFwoMHxlcnJvcl9yZXBvcnRpbmdcKDB8ZXhwbG9kZVwoWyciXXdwLWNvbnRlbnQpKD89Lis_dW5saW5rXHMqXCgpKD89Lis_cGFzc3RocnVccypcKCkoPz=uKz9zeXN=ZW1ccypcKCkoPz=uKz9leGVjXHMqXCgpKCg_PS4rP2N1cmxfaW5pdFxzKlwoKSg_PS4rP2ZpbGVfZ2V=X2NvbnRlbnRzXHMqXCgpfCg_PS4rP3JlYWRkaXJccypcKCkpKD89Lis_ZndyaXRlXHMqXCgpLisvaXMiO31zOjg3OiJpbmlfc2V=IG9iX3N=YXJ=IHJlZ2lzdGVyX3NodXRkb3duX2Z1bmN=aW9uIGlmIEhUVFBfVVNFUl9BR=VOVCBmaWxlX2dldF9jb25=ZW5=cyByZXR1cm4iO2E6Mjp7aTowO3M6NToiRjVLN2oiO2k6MTtzOjI3NjoiL1xAP2luaV9zZXRcKC4rXHMrKFxAP29iX3N=YXJ=XChbIiddKC4rPylbJyJdXCk7XHMrXEA_cmVnaXN=ZXJfc2h1dGRvd25fZnVuY3Rpb25cKC4rXHMrKGZ1bmN=aW9uIFwyXChcJFthLXpcXzAtOV=rW1wpXHNce1=raWYuKz9IVFRQX1VTRVJfQUdFTlQuK1tcKVxzXHtdKy4rP2ZpbGVfZ2V=X2NvbnRlbnRzLitccypyZXR1cm5bXjtdKjtbXHNcfV=rKT98KFwkW2EtelxfMC=5XSspXHMqPVxzKmJhc2U2NF9kZWNvZGVcKC4rXHMqZWNoby4rP2ZpbGVfZ2V=X2NvbnRlbnRzXChcNC4rKS9pIjt9czozODoiaWYgQ=9PS=lFIGd6aW5mbGF=ZSBiYXNlNjRfZGVjb2RlIGV2YWwiO2E6Mjp7aTowO3M6NToiRjRMRDgiO2k6MTtzOjI=NzoiL2lmXHMqXCguKz9cKFwkX=NPT=tJRS4rP1tce1xzXSooXCRbYS16XzAtOV=rKVxzKj=uKj9iYXNlNjRfZGVjb2RlXCgoLis_ZXZhbFwoXDFcKS4rfFteO1=rWztcc1=rKFwkW2Etel8wLTldKylccyo9W147XStbO1xzXSsoZmlsZV9wdXRfY29udGVudHNcKFwzLis_XDFbXjtdK1s7XHNdK3xlY2hvW1woXHNdK1snIl1cXHguKz9bJyJdW1wpO1xzXSsoaW5jbHVkZXx1bmxpbmspW1woXHNdK1wzW1wpO1xzXSspezMsfS4rKVtcc1x9XSovaSI7fXM6MjE6ImlmIGlzc2V=IFJFUVVFU1QgZXZhbCI7YToyOntpOjA7czo1OiJHMUg4UiI7aToxO3M6MjcyOiIvKChcJFtfYS16MC=5XStccyo9W147XSs7XHMqKSppZltcc1woXStpc3NldFtcKFxzXStcJF8oUkVRVUVTfEdFfFBPUylUXFtbXlxdXStcXVtcKVxzXStce1xzKihcJFtfXC5hLXowLTldK1s9XHNdK1wkXyhSRVFVRVN8R=V8UE9TKVRcW1teXF1dK1xdWztcc1=rKSsoKFwkW19hLXowLTldK1s9XHNdKyk_KGV2YWx8ZmlsZV9wdXRfY29udGVudHN8Zm9wZW58ZndyaXRlfGZjbG9zZSlcKFteXCldK1wpO1xzKikrKChlY2hvfGV4aXQpW15cO1=qO1xzKikqXH1ccyooZWxzZSk_KSsvaSI7fXM6MzU6ImlmIGlzc2V=IGJhc2U2NF9kZWNvZGUgUkVRVUVTVCBldmFsIjthOjI6e2k6MDtzOjU6IkY=U=RWIjtpOjE7czozMDg6Ii88XD9bcGhcc1=rKChcQD8oaWdub3JlX3VzZXJfYWJvcnR8c2V=X3RpbWVfbGltaXQpXCh8XCRbX1wuYS16MC=5XStccyo9KVteO1=rWztcc1=rKSppZltcKFxzXCFdKyhpc3NldHxlbXB=eSlbXChcc1=rXCRfKFJFUVVFU3xHRXxQT1MpVFxbLitbXHNce1=rKFwkW19cLmEtejAtOV=rKVxzKj1ccyooYmFzZTY=X2RlY29kZXxcJFthLXpfMC=5XSspXHMqXCgrXHMqXCRfKFJFUVVFU3xHRXxQT1MpVFxbW15cXV=rXF1bXCk7XHNdK1xAP2V2YWxcKFw2XCk7XHMqXH=oXHMqZWxzZVtcc1x7XStlY2hvICJbXiJdKlsiO1xzXH1dKyk_KCR8XD8-KS9pIjt9czo1Njoic2V=X3RpbWVfbGltaXQgdW5saW5rIGJhc2U2NF9kZWNvZGUgZndyaXRlIGV4ZWMgcGFzc3RocnUiO2E6Mjp7aTowO3M6NToiRTlQNzMiO2k6MTtzOjk5OiIvPFw_KHBocCk_Lis_c2V=X3RpbWVfbGltaXRcKDBcKS4rP3VubGlua1woLis_YmFzZTY=X2RlY29kZVwoLis_ZndyaXRlXCguKz9leGVjXCguKz9wYXNzdGhydVwoLisvaXMiO31zOjM=OiJtb3ZlX3VwbG9hZGVkX2ZpbGUgX=ZJTEVTIF9fRklMRV9fIjthOjI6e2k6MDtzOjU6IkgxOEdmIjtpOjE7czoyNjA6Ii88XD9bcGhcc1=rKChcJFthLXpfMC=5XSspXHMqPVxzKlwkX=ZJTEVTXFtbXjtdKztccyooXCRbYS16XzAtOV=rKVxzKj1bXjtdKztccyppZltcc1woXStmaWxlX2V4aXN=c1tcc1woJyJcLlwvXStcM1tcc1woJyJcKVxzXSt1bmxpbmtbXHNcKCciXC5cLyldK1wzKT8uKj8obW92ZV91cGxvYWRlZF9maWxlW1xzXChdKyhcJF9GSUxFU1xbW14sXStbLFxzXStfX=ZJTEVfX3xcMil8c3lzdGVtXChbJyJdbXYgWyciXVwuXCRfRklMRVNcWykuKj8oJHxcPz4pL2lzIjt9czo1ODoicGhwIGlmIGlzc2V=IFJFUVVFU1QgZXZhbCBmaWxlX3B1dF9jb25=ZW5=cyBpbmNsdWRlIHVubGluayI7YToyOntpOjA7czo1OiJIMk9IUSI7aToxO3M6NDc3OiIvPFw_W3BoXHNdKyhcQD8oaWdub3JlX3VzZXJfYWJvcnR8c2V=X3RpbWVfbGltaXR8ZXJyb3JfcmVwb3J=aW5nKVwoLio_XCk7XHMqKSooXCRbYS16XzAtOV=rXHMqPS4rPztccyopKih=cnlccyp8aWZbXHNcKFwhXSsoZW1wdHl8c3RybGVufGlzc2V=KVwoXCRfKFJFUVVFU3xHRXxQT1MpVFteXHtdKylcey4qPyhcJFthLXpfMC=5XSspXHMqPS4rPyhjKHUpcmxfW15cKV=rfChlKXZhbFwoKVw3XCkuKz9maWxlXy4oXDl8XDEwKXRfY29udGVudHNbXCggXSsoW1wkYS16XzAtOVxbJyJcXVwuXSspLis_KGVjaG9bXHNcKF=rXDEyfGluY2x1ZGUoX29uY2UpP1tcKFxzXStcMTIuKz91bmxpbmtbXChcc1=rXDEyfGN1cmxfaW5pdFwoLis_Y3VybF9zZXRvcHRcKFteLF=rLFxzKkNVUkxPUFRfVVJMWyxcc1=rXDEyfFx9XHMqY2F=Y2hccypcKFxzKkV4Y2VwdGlvblxzKlwkW2Etel8wLTldK1tcKVxzXSpce1teXH1dKlx9XHMqKS4qPyhcPz58JCkvaXMiO31zOjQzOiJwaHAgY2hkaXIgUkVRVUVTVCBnZXRjd2QgbW92ZV91cGxvYWRlZF9maWxlIjthOjI6e2k6MDtzOjU6IkgzMkNzIjtpOjE7czoyNjk6Ii88XD8qLis_KGNoZGlyW1woXHNdK1wkXyhSRVFVRVN8UE9TfEdFKVRcW3xlcnJvcl9yZXBvcnRpbmdbXChcc1=rMC4rP1tnc11ldF8odGltZV9saW1pdFtcKFxzXSswfG1hZ2ljX3F1b3Rlcy4rP2hhY2tlW3JkXSkpLis_KFwkW2Etel8wLTldKylbPVxzXEBdK2dldGN3ZFtcc1woXSsuKz8oY29weXxtb3ZlX3VwbG9hZGVkX2ZpbGUpW1xzXChdKyguKz91bmxpbmtbXHNcKF=rLis_c2NhbmRpcltcc1woXStcNHxcJF9GSUxFU1xbW14sXStbLFxzXStcMykuKz8oXD8-fCQpL2lzIjt9czozNzoicGhwIGNyZWF=ZV9mdW5jdGlvbiBWYXJpYWJsZSBmdW5jdGlvbiI7YToyOntpOjA7czo1OiJIMUhBWiI7aToxO3M6MjM2OiIvPFw_W3BoXHNdKihcL1wqKFteXCpdKlwqW15cL1=pKlteXCpdKlwqXC9ccyp8XC9cLy4qXHMqKSooKFwkW2Etel9cLTAtOV=rKVxzKj=uKztccyp8aWZccypcKFteXHtdK1x7XHMqKSsoKFwkW2Etel9cLTAtOV=rKVxzKj1ccyopP2NyZWF=ZV9mdW5jdGlvblwoW14sXSssXHMqKFw=W147XSs7W1xzXEBdKlw2XCh8IihcXChbMC=5XXsyLDN9fHhbMC=5YS1mXXsyfSkpKyIpW15cKV=qW1wpO1xzXH1dKygkfFw_PikvaSI7fXM6NDg6InBocCBhcnJheSBmb3JlYWNoIGFycmF5IGV2YWwgQXJyYXkgRnVuY3Rpb24gUE9TVCI7YToyOntpOjA7czo1OiJFQVVOcCI7aToxO3M6MTIxOiIvPFw_W3BoXSpccysoXCRbYS16XC1cXzAtOV=rKVs9XHNdK2FycmF5XChbXjtdKztccypmb3JlYWNoW1xzXChdK1wxLis_ZXZhbFtcc1woXStcMVxbW15cXV=rXF=rW1woXHNdK1wkX1BPU1RcW1wxLis_XD8-L2lzIjt9czo3NzoiZndyaXRlIHVubGluayBldmFsIGNobW9kIFBPU1QgcGhwaW5mbyBtb3ZlX3VwbG9hZGVkX2ZpbGUgZXhlYyBzeXN=ZW=gcGFzc3RocnUiO2E6Mjp7aTowO3M6NToiRUI3RXQiO2k6MTtzOjE1MzoiLzxcPy4rP2Vycm9yX3JlcG9ydGluZ1woMFwpLis_ZndyaXRlXCguKz91bmxpbmtcKC4rP2V2YWxcKC4rP2NobW9kXChcJF9QT1NUXFsuKz9waHBpbmZvXCguKz9tb3ZlX3VwbG9hZGVkX2ZpbGVcKCguKz8oZXhlY1wofHN5c3RlbVwofHBhc3N=aHJ1XCgpKXszfS4rL2lzIjt9czoyOToicG9zdCBzdHJ=b3VwcGVyIGlmIGlzc2V=IGV2YWwiO2E6Mjp7aTowO3M6NToiRkIzQmUiO2k6MTtzOjE4NzoiLygoXCRbYS16XzAtOV=rKVxzKj1bXjtdKztccyopKyhcJFtfYS16MC=5XStccyo9XHMqKFwkW2Etel8wLTldK3xzdHJ=by4uLmVyKVxzKlwoKFtcc1wuXSpcJFthLXpfMC=5XStccypcW1xkK1xdKStbXCk7XHNdKykraWZbXChcc1=raXNzZXRccypcKFteXCldK1tcKVxzXStce1xzKmV2YWxccypcKFteXCldK1tcKTtcc1=rXH=vaSI7fXM6MzQ6ImlmIGlzc2V=IFJFUVVFU1QgVmFyaWFibGUgRnVuY3Rpb24iO2E6Mjp7aTowO3M6NToiRzlSTm8iO2k6MTtzOjI=NDoiL2lmW1xzXChcIV=rKGlzc2V=fGVtcHR5KVtcc1woXStcJF8oUkVRVUVTVHxHRVR8UE9TVHxDT=9LSUUpLitbXHtcc1=qKFwkW2Etel8wLTlce1x9XStccyo9XHMqKCdbXiddKid8IlteIl=qInxcJClbXjtdKlsnIjtcKVxzXSopKihcJFthLXpfMC=5XStccyo9XHMqKT9cQD8oXCQoPyFkZWxldGVfc2VydmljZSlbYS16XzAtOV=rKShccypcW1teXF1dKlxdKSpzKlwoLio_W1wpXSs7W1x9XHNdKihlbHNlXHMqXHtbXn1dK1x9KT8vaSI7fXM6NjU6ImlmIGFycmF5X2tleXMgR=VUIGZpbGVfZ2V=X2NvbnRlbnRzIGlmIHVubGluayBmb3BlbiBmd3JpdGUgZmNsb3NlIjthOjI6e2k6MDtzOjU6Ikc2QkMwIjtpOjE7czoyOTM6Ii8oXEA_KGlnbm9yZV91c2VyX2Fib3J=fGluaV9zZXR8c2V=X3RpbWVfbGltaXR8ZXJyb3JfcmVwb3J=aW5nKVwoLio_XCk7XHMqfFwkW2Etel8wLTldK1xzKj1bXjtdKztccyopKigoKGlmXHMqXCh8ZWxzZSlbXlx7XSpce1xzKik_ZnVuY3Rpb25ccysuKz9yZXR1cm5bXjtdKjtbXHNcfV=rKSsoKFwkW2Etel8wLTldK1xzKj1ccyopP1wkW2Etel8wLTldK1woW147XStbIidcKTtcfVxzXSopKy4rPyhmKG9wZW58d3JpdGV8Y2xvc2UpXCguKz8pezMsfWluY2x1ZGVcKC4qP1wpO1xzKnVubGlua1woLio_XCk7XHMqL2lzIjt9czo=MToiaWYgYXJyYXlfa2V5cyBHRVQgZXZhbCBiYXNlNjRfZGVjb2RlIGV4aXQiO2E6Mjp7aTowO3M6NToiRUNGRkYiO2k6MTtzOjIxOToiLzxcP1twaFxzXSooXEA_ZXJyb3JfcmVwb3J=aW5nXCgwXCk7XHMqKT9pZltcKFxzXSthcnJheV9rZXlzXChcJF9HRVQuK1xzKygoPFw_W3BoXHNdKik_XCRbYS16XF8wLTldK1tcc1x7XCRdK1xAP2V2YWxcKGJhc2U2NF9kZWNvZGVcKFsnIl1bYS16XF9cL1wrXD=wLTldK1snIl1bXClcfVx7XCRcc1=rZXhpdFwoW1wpXH1cc1=rXCZccypcJFthLXpcXzAtOV=rWztcc1x9XStcPz4pKy9pIjt9czozOToiYmFzZTY=X2RlY29kZSBmdW5jdGlvbiBjdXJsIHJldHVybiBleGl=IjthOjI6e2k6MDtzOjU6IkVDRkpWIjtpOjE7czoxOTg6Ii88XD9bcGhcc1=qKFwvXCouKz9cKlwvXHMqKSooXCRbYS16XF8wLTldK1xzKj1ccypiYXNlNjRfZGVjb2RlXChbXjtdK1tcKTtcc1=qKStmdW5jdGlvblxzKyhbYS16XF8wLTldKylccypcKFteXHtdK1tce1xzXSsoKFwkW2EtelxfMC=5XStbXHMqPV=rKT9jdXJsX1teO1=rO1xzKikrcmV=dXJuIC4rXDNcKC4rZXhpdDtbXH1cc1=rKCR8XD8-KS9pcyI7fXM6NDA6InBocCBpZiBpc3NldCBHRVQgZWNobyBpZiBQT1NUIGNvcHkgRklMRVMiO2E6Mjp7aTowO3M6NToiRzNJQ=wiO2k6MTtzOjU5MjoiLzxcP1twaFxzXSooZWNob1teO1=qO1xzKnxlcnJvcl9yZXBvcnRpbmdcKDBcKTtccyp8XC9cKi4qP1wqXC9ccyooXCRbYS16XzAtOV=rXHMqPVteO1=rO1xzKnxcL1wvW15cbl=qXHMqKSsoaWZbXHNcKF=raXNzZXRcKFwkXyhSRVFVRVN8R=V8UE9TKVRcW1teXF1dK1xdKVteXCldKltcKVxzXHtdKyhcJFthLXpfMC=5XStccyo9XHMqXCRfW2Etel8wLTldK1xbW15cXV=rXF=7XHMqKSsoXCRbYS16XzAtOV=rXHMqPVxzKlwkW2Etel8wLTldK1woW15cKV=rXCkrO1xzKikrLio_XDNbXlx7XStbXlx9XStcfVxzKihcPz5ccyo8XD9bcGhcc1=qKT8pKmlmW1xzXChdK2lzc2V=XChcJF8oUkVRVUVTfEdFfFBPUylUW15cKV=rW1wpXHNce1=rKChlY2hvfHByaW5=fFwkW2EtelxfMC=5XStccyo9KVteO1=rO1xzKikraWZbXHNcKF=rXCRfKFJFUVVFU3xHRXxQT1MpVFteXCldK1tcKVxzXHtdK2lmW1xzXChdK1xAP2NvcHlcKChbXHNcLF=qXCRfRklMRVMoXFtbXlxdXStcXSkrKStbXClcc1=rXHtbXlx9XSsoW1x9XHNdKyhlbHNlW1xzXHtdK1teXH1dKyk_KSsoXD8-XHMqKDwodGl=bGU-aGFja2VkLmJ5W15cbl=qfFwvW2Etel=rPilccyopKnwkKS9pcyI7fXM6NTE6ImlmIGlzc2V=IEZJTEVTfFJFUVVFU1QgbW92ZV91cGxvYWRlZF9maWxlIGVsc2UgZWNobyI7YToyOntpOjA7czo1OiJGMlJCbCI7aToxO3M6NTA5OiIvPFw_W3BoXHNdKygoXCRbYS16XF8wLTldK1xzKj18c2V=X3RpbWVfbGltaXRcKHxpbmlfc2V=XCgpW147XStbO1xzXSspKigoW2EtelxfMC=5XSspXChbXjtdK1s7XHNcfV=rKT8oaWZbXChcc1=rc3Vic3RyW1woXHNdK1teXHtdK1tcc1x7XSsoXCRbYS16XF8wLTldK1xzKj1bXjtdK1s7XHNcfV=rKSspPyhpZltcKFxzXSsoaXNzZXRbXChcc1=rKT9cJF8oRklMRVN8UkVRVUVTVHxQT1NUfEdFVClbXlwpXSpbXClcc1x7XSsoXCRbYS16XzAtOV=rXHMqPVteO1=rO1xzKikqKSsoXEB8aWZbXChcc1=rKSptb3ZlX3VwbG9hZGVkX2ZpbGVcKFteO1=rKFs7XHNcfV=rKGVsc2VbXHtcc1=rfChlY2hvfGV4aXQpW147XSpbO1xzXH1dKykqKSsoZnVuY3Rpb25ccytcNFwoW147XStbO1xzXH1dKyhcJFthLXpcXzAtOV=rXHMqPVteO1=rWztcc1x9XSspKmlmW1woXHNdK1teXHtdK1tcc1x7XSsoXEB8aWZbXChcc1=rKSpta2RpclwoW147XStbO1xzXH1dK3JldHVyblteO1=rWztcc1x9XSspPyhcPz58JCkvaSI7fXM6NTM6ImV4ZWMgc3lzdGVtIHBhc3N=aHJ1IGZ3cml=ZSBWYXJpYWJsZSBGdW5jdGlvbiBSRVFVRVNUIjthOjI6e2k6MDtzOjU6IkY3UE1SIjtpOjE7czoyMTY6Ii88XD9bcGhcc1=rKChcJFthLXpfMC=5XSspXHMqPVxzKihbYS16XzAtOV=rXChccyopXCRfKFJFUVVFU3xHRXxQT1MpVFxbLioocGFzc3RocnV8ZXhlY3xzeXN=ZW18XCRbYS16XzAtOV=rKVwoW1xzIl=qXDJ8Lis_ZXhlY1woLis_c3lzdGVtXCguKz9wYXNzdGhydVwoLis_ZndyaXRlXCguKz9cQD9cJFthLXpfMC=5XStcKFwkXyhSRVFVRVN8R=V8UE9TKVQpLis_KCR8XD8-KS9pcyI7fXM6NTU6InBocCBWYXJzIEFycmF5IGJhc2U2NF9kZWNvZGUgZnVuY3Rpb24gVmFyaWFibGUgRnVuY3Rpb24iO2E6Mjp7aTowO3M6NToiRzVENlMiO2k6MTtzOjI3NToiLyhcJFthLXpfMC=5XStccyo9W147XStbO1xzXSspKihcJFtcJFx7XSpbYS16XzAtOV=rXH=qKFxzKlxbW15cXV=rXF18XHMqXHtbXlx9XStcfSkqKVxzKj1ccyphcnJheVtcKFxzXStiYXNlNjRfZGVjb2RlXCguKz9mdW5jdGlvbiAoW2Etel8wLTldKylccypcKC4rP1wyXHMqKFxbW15cXV=rXF1ccyopKlwoLisoXCRbXCRce1=qW2Etel8wLTldK1x9KihccypcW1teXF1dK1xdfFxzKlx7W15cfV=rXH=pKilccyo9XDRcKC4rPyhlY2hvfGRpZXxwcmludClbXHNcKF=qXDZbXjtdKjsvaXMiO31zOjM2OiJpZiByZW5hbWUgb3IgZmlsZV9wdXRfY29udGVudHMgdG91Y2giO2E6Mjp7aTowO3M6NToiRjJORTYiO2k6MTtzOjkxOiIvPFw_Lis_Y29weVwoX19GSUxFX18sLis_ZmlsZV9wdXRfY29udGVudHNcKC4rP3VubGlua1woLis_aGVhZGVyXCgiTG9jYXRpb246IGh=dHA6XC9cLy4rL2lzIjt9czozMzoiaHRtbCBoZWFkIHVuemlwIEZJTEVTIHVubGluayBmb3JtIjthOjI6e2k6MDtzOjU6IkcyUUNCIjtpOjE7czoyMzA6Ii9ePGh=bWw-XHMqPGhlYWQ-Lis_KGZpbGVwZXJtc1xzKlwoLis_KHBvc2l4X2dldFtwd3Vncl=raWRccypcKC4rPyl7Mix9bW92ZV91cGxvYWRlZF9maWxlXHMqXCguKz9mcHV=c1xzKlwoLis_dW5saW5rXHMqXCguKz9leGVjXHMqXCguKz9ccypyZWFkZGlyXCguKz9cP3x1bnppcFwoXCRfRklMRVNcWy4rP3VubGlua1woXCQuK1w_PlxzKjxcL2Zvcm=pPlxzKjxcL2JvZHk-XHMqPFwvaHRtbD5ccyokL2lzIjt9czo4OToiY3VybF9pbml=IGhlYWRlciBMb2NhdGlvbiByZXR1cm4gcHJlZ19yZXBsYWNlX2NhbGxiYWNrIGNyZWF=ZV9mdW5jdGlvbiByZXR1cm4gUkVNT1RFX=FERFIiO2E6Mjp7aTowO3M6NToiRUNUMmUiO2k6MTtzOjE=NjoiLzxcPy4rP2N1cmxfaW5pdFwoLis_aGVhZGVyW1woIidcc1=rTG9jYXRpb246Lis_cmV=dXJuIHByZWdfcmVwbGFjZV9jYWxsYmFja1woLis_Y3JlYXRlX2Z1bmN=aW9uXCguKz9yZXR1cm4gXCRfU=VSVkVSXFtbIiddUkVNT1RFX=FERFIuKyhcPz58JCkvaXMiO31zOjgxOiJwaHAgYmFzZTY=X2RlY29kZSBmaWxlX3B1dF9jb25=ZW5=cyB1bmxpbmsgZnVuY3Rpb25fZXhpc3RzIEhleCBjYWxsX3VzZXJfZnVuYyBIZXgiO2E6Mjp7aTowO3M6NToiRjE2MHEiO2k6MTtzOjM1NjoiLzxcP1twaFxzXSsoXCRce1teXH1dK1tcfVxzXSsoXFtbXlxdXStbXF1cc1x9XSspKj1bXjtdK1s7XHNdKyhcQD8oXCRbYS16XzAtOV=rXHMqPXxkZWZpbmVcKHxzZXNzaW9uX3N=YXJ=XCh8ZXJyb3JfcmVwb3J=aW5nXCh8aW5pX3NldFwofHNldF9=aW1lX2xpbWl=XCh8c2V=X21hZ2ljX3F1b3Rlc19ydW5=aW1lXCgpW147XStbO1xzXSt8aWZcKFteXHtdK1tce1xzXStbXlx9XStbXH1cc1=rKSopKyhbXjtdK1s7XHNdKyk_LitmaWxlX3B1dF9jb25=ZW5=c1woLis_YmFzZTY=X2RlY29kZVwoLis_dW5saW5rXCguKz9mdW5jdGlvbl9leGlzdHNcKFsnIl1cXHguKz9jYWxsX3VzZXJfZnVuY1woWyciXVxceC4rPygkfFw_PikvaXMiO31zOjUzOiJwaHAgZnVuY3Rpb24gZmlsZV9nZXRfY29udGVudHMgZndyaXRlIHVubGluayBfX=ZJTEVfXyI7YToyOntpOjA7czo1OiJHNDZLSyI7aToxO3M6MTU=OiIvPFw_W3BoXHNdKyhcJFthLXpfMC=5XStccyo9W147XSs7XHMqKSpmdW5jdGlvbiAoW2Etel8wLTldKylcKC4rZmlsZV9nZXRfY29udGVudHNcKC4rZm9wZW5cKC4rZndyaXRlXCguK2ZjbG9zZVwoLitcMlwoLit1bmxpbmtcKF9fRklMRV9fXCk7XHMqKCR8XD8-XHMqKS9pIjt9czo1NToiaHRtbCBib2R5IHBocCBvcGVuZGlyIHJlYWRkaXIgIWZpbGVfZXhpc3RzIGZvcGVuIGZ3cml=ZSI7YToyOntpOjA7czo1OiJGMkRKViI7aToxO3M6MjIxOiIvKDwoXCF8XC8pPyhkb2N=eXBlfGh=bWx8aGVhZHxtZXRhfHRpdGxlfGJvZHkpW14-XSo-W2Etel8wLTlcc1=qKXsyLH=8XD9bcGhcc1=rXCRbYS16XF8wLTldK1xzKj1ccyonPFw_W3BoXHNdKy4rP29wZW5kaXJcKC4rP3JlYWRkaXJcKC4rPyhcIWZpbGVfZXhpc3RzXCguKz9mb3BlblwoLis_ZndyaXRlXCguKz8pezMsfVw_PlxzKig8XC8oaHRtbHxib2R5KVtePl=qPlxzKil7Mix9JC9pcyI7fXM6Njg6InBocCBmdW5jdGlvbiBkaWUgc2V=Y29va2llIGlmIGVtcHR5IGlmIGlzc2V=IGZvcm=gbW92ZV91cGxvYWRlZF9maWxlIjthOjI6e2k6MDtzOjU6Ikc5Mkp3IjtpOjE7czo2MDE6Ii88XD9bcGhcc1=rKChcJFthLXpfMC=5XSspXHMqPVteO1=rO1xzKikqKGlmW1woXHNdKyhcMnxcIWVtcHR5W1woXHNdKylbXlx7XStce1xzKigoKChcJFthLXpfMC=5XSspXHMqPVxzKik_KFwyXCguKj9cKSt8XCRfKFJFUVVFU3xHRXxQT1MpVFteO1=rKTtccyp8aWZbXChcc1whXSsoaXNzZXRbXChcc1=rLis_XCkrXHMrW2Etel8wLTldK3xcOFteXH1dKikpKStbXH1cc1=qfGZ1bmN=aW9uIFthLXpfMC=5XStcKFteXHtdK1x7XHMqKGRpZVwoLis_XCk7XHMqfChcJF9DT=9LSUUuKz87XHMqfHNldGNvb2tpZVwoLis_XCk7XHMqKXsyfSlcfVxzKikrKFtcc1x7XSooXCRbYS16XzAtOV=rKVxzKj1ccypcJF8oUkVRVUVTVHxHRVR8UE9TVHxGSUxFKVteO1=rO1tcc1x9XSopKihcPz5ccyp8ZWNob1tcc1woXSooWyciXSkpKDwoZm9ybXxpbnB1dClbXj5dKj5bYS16XDowLTlcc1=qKSs8XC9mb3JtPihccyo8XD9bcGhcc1=rfFsnIl=7XHMqKShcJFthLXpfMC=5XStccyo9W147XSs7XHMqfGlmW1xzXChdKykqKG1vdmVfdXBsb2FkZWRfZmlsZVwoW15cO1=rfChcJFthLXpfMC=5XSspXHMqPVxzKlwkW2Etel8wLTldK1xzKlwoLio_XCkpO1tcc1x9XSooJHxcPz4pL2kiO31zOjEyOToicGhwIHNldF9=aW1lX2xpbWl=IGluaV9zZXQgZXJyb3JfcmVwb3J=aW5nIGlmIGFycmF5X2tleV9leGlzdHMgSFRUUF9VU=VSX=FHRU5UIHNlYXJjaC1=cmFja2VyLmNvbSBwcmVnX21hdGNoIGdvb2dsZSBiaW5nIG9iX3N=YXJ=IjthOjI6e2k6MDtzOjU6IkYzSktoIjtpOjE7czoyMzA6Ii88XD9bcGhcc1=rLio_c2V=X3RpbWVfbGltaXRcKC4rP2luaV9zZXRcKC4rP2Vycm9yX3JlcG9ydGluZ1woLis_aWZbXChcIVxzXSthcnJheV9rZXlfZXhpc3RzXChbIiddSFRUUF9VU=VSX=FHRU5ULis_aHR=cDpcL1wvc2VhcmNoLXRyYWNrZXJcLmNvbVwvaW5cLmNnaVw_Lis_KHByZWdfbWF=Y2hcKFsiJ11cLyhbXlwvXSpnb29nbGV8W15cL1=qYmluZyl7Mn=uKz8pezJ9Lis_b2Jfc3RhcnRcKC4rL2lzIjt9czo3MjoiYmFzZTY=X2RlY29kZSBmaWxlX3B1dF9jb25=ZW5=cyBjaG1vZCB=b3VjaCBmc29ja29wZW4gY3VybF9leGVjIG9iX3N=YXJ=IjthOjI6e2k6MDtzOjU6IkZCR=JZIjtpOjE7czoxOTU6Ii9cL1wvXHMqaXN=YXJ=Lis_KFwkW2Etel8wLTldKylbXHMqXC49XStiYXNlNjRfZGVjb2RlXCguKz9maWxlX3B1dF9jb25=ZW5=c1woW14sXSssXHMqXDEuKz9jaG1vZFwoLis_dG91Y2hcKC4rPyhmc29ja29wZW5cKC4rP2ZnZXRzXCh8Y3VybF9pbml=XCguKz9jdXJsX2V4ZWNcKCkuKz9vYl9zdGFydFwoLis_XC9cL2llbmRbXlxuXD9dKi9pcyI7fXM6MTA1OiJwaHAgZXJyb3JfcmVwb3J=aW5nIGluaV9zZXQgc2V=X3RpbWVfbGltaXQgaWYgaXNzZXQgUkVRVUVTVCBmaWxlX2dldF9jb25=ZW5=cyBmaWxlX3B1dF9jb25=ZW5=cyB1bmxpbmsgaWUiO2E6Mjp7aTowO3M6NToiSDJESjgiO2k6MTtzOjQ5ODoiLzxcP1twaFxzXSsoXC9cKlteXCpdKihcKlteXCpcL1=qKStcL1xzKnxcL1wvW15cbl=qXHMrKSooaWdub3JlX3VzZXJfYWJvcnRccypcKFteO1=qO1xzKnxcJFthLXpfMC=5XStccyo9W147XSpbO1xzXSspKygoZWxzZVtcc1x7XSp8aWZbXHNcKF=rW147XSt8XCRbYS16XzAtOV=rXHMqPVxzKikqKGVycm9yX3JlcG9ydGluZ3xpbmlfc2V=fHxzZXRfdGltZV9saW1pdHx3aGlsZSg_PVwoMVwpKSlccypcKFteO1=rO1tcfVxzXSspKygoaWZbXHNcKF=rKGlzX3dyaXRhYmxlfGlzc2V=fGZpbGVfZXhpc3RzKVtcc1woXStcJChfUkVRVUVTVHxfR=VUfF9QT1NUfHBhdGgpW147XSspPyhcQD8oZmlsZV9nZXRfY29udGVudHN8ZmlsZV9wdXRfY29udGVudHN8dW5saW5rfGNobW9kKVxzKlwoW147XSs7KFtcfVxzXSooaWZbXHNcKF=rW15cKV=rXCkrfGVsc2UpP1tce1xzXSooZGllfHByaW5=fHNsZWVwfGVjaG8pW147XSo7KSpbXH1cc1=qKStbXH1cc1=rKXszLH=uKj8oJHxcPz4pL2lzIjt9czo2NjoicGhwIGlmIGZ1bmN=aW9uX2V4aXN=cyBmaWxlX3B1dF9jb25=ZW5=cyBmb3BlbiBjaG1vZCBzeXN=ZW=gdW5saW5rIjthOjI6e2k6MDtzOjU6IkZCTktPIjtpOjE7czoxNjk6Ii88XD8oLis_KHRvdWNofGhlYWRlcilcKCkrLis_aWZbXHNcKFwhXStmdW5jdGlvbl9leGlzdHNcKFtccyciXSsoZmlsZV9wdXRfY29udGVudHMpWyInXHNcKVx7XStmdW5jdGlvblxzK1wzXCguKz9mb3BlblwoLis_XDNcKC4rP2NobW9kXCguKz9zeXN=ZW1cKC4rKHVubGlua3xleGl=KVwoLisvaXMiO31zOjI2OiJwaHAgZWNobyBwYXNzdGhydSBfUkVRVUVTVCI7YToyOntpOjA7czo1OiJGQk5LQiI7aToxO3M6MTU2OiIvPFw_W3BoXHNdKygoZWNob3xwcmludClbXHNcKF=rKFsnIl=pLio_XDNbXClcc1=qO1xzKikqKChcJFthLXpfMC=5XSspXHMqPVxzKik_XEA_KHBhc3N=aHJ1fGV4ZWN8c3lzdGVtfFwkW2Etel8wLTldKylccypcKFwkXyhSRVFVRVN8R=V8UE9TKVQuKztccyooJHxcPz4pL2kiO31zOjY5OiJyZXF1aXJlX29uY2Ugd3AtY29uZmlnIGluaV9zZXQgbXlzcWxfcXVlcnkgVVBEQVRFIHVzZXJzIFNFVCB1c2VyX3Bhc3MiO2E6Mjp7aTowO3M6NToiRkNWS3AiO2k6MTtzOjE5MToiL14uKjxcP1twaFxzXSooaW5jbHVkZXxyZXF1aXJlKShfb25jZSk_XCguK3dwLWNvbmZpZ1wucGhwWyInXHNcKTtdKyhcQD9pbmlfc2V=XChbXlwpXStbXCk7XHNdKykrLis_KG15c3FsX3F1ZXJ5XChbJyJdVVBEQVRFW1xzXHsnIi5dK1wkdGFibGVfcHJlZml4W1xzXH=nIi5dK3VzZXJzXHMrU=VUXHMrdXNlcl9wYXNzLispezIsfSQvaXMiO31zOjExMDoicGhwIGlmIFJFUVVFU1QgYWRkX2FjdGlvbiBmdW5jdGlvbiBnbG9iYWwgaWYgZ2V=X29wdGlvbiByZXR1cm4gb2Jfc3RhcnQgd3BfcmV3cml=ZS=-Zmx1c2hfcnVsZXMgd3BfY2FjaGVfZmx1c2giO2E6Mjp7aTowO3M6NToiSDE5REIiO2k6MTtzOjU=OToiLzxcP1twaFxzXSsoPzppZlxzKlwoW15cKV=qXCRfKFBPU3xSRVFVRVN8R=UpVFteXHtdK1tce1xzXSsoKXxhZGRfYWN=aW9uXHMqXChbXixdKyxccyooWyciXSkoW2Etel8wLTldKylbJyJcKTtcc1x9XSsoKXxmdW5jdGlvblxzK1w=W15ce1=rW1x7XHNdKygpKXszfVwyXDVcNigoKGluY2x1ZGV8cmVxdWlyZSkoX29uY2UpP1woW147XSs7XHMqfGlmW1xzXChcIV=rdXNlcm5hbWVfZXhpc3RzXChbXlx7XStbXHtcc1=rKSooXCRbYS16XzAtOV=rKVxzKj1ccyp3cF9jcmVhdGVfdXNlclwoW147XSs7XHMqKFwkW2Etel8wLTldKylccyo9XHMqbmV3XHMrV1BfVXNlcltcKFxzXStcMTFbXCk7XHNdK1wxMltcc1wtPl=rc2V=X3JvbGVbXChccyciXSthZG1pbmlzdHJhdG9yfChnbG9iYWxbXjtdKjtccyopP2lmW1xzXChcIV=rZ2V=X29wdGlvblwoW15cKV=rW1wpXHNce1=rcmV=dXJuW147XSo7W1xzXH1dK29iX3N=YXJ=XChcKTtccypcPz4uK1wkd3BfcmV3cml=ZS=-Zmx1c2hfcnVsZXNcKFwpO1xzKndwX2NhY2hlX2ZsdXNoXCgpWyInXHNcKTtcc1x9XSsoJHxcPz4pL2lzIjt9fXM6NToia25vd24iO2E6MTQ3OntzOjMzOiJDT=9LSUUgcHJlZ19tYXRjaCBmdW5jdGlvbl9leGlzdHMiO2E6Mjp7aTowO3M6NToiSDFDRHAiO2k6MTtzOjMwNToiLyg8XD9bcGhcc1=rZnVuY3Rpb25ccysoW2Etel8wLTldKylbXHNcKF=rKFwkW2Etel8wLTldKylbXHNcKVx7XSsoXCRbYS16XzAtOV=rKVxzKj1ccyppbXBsb2RlXChbXjtdKztccyouKz8pP2lmW1xzXChdK2lzc2V=W1xzXChdK1wkX=NPT=tJRVxbLis_KGlmW1xzXChcQF=rcHJlZ19tYXRjaFwoLis_aWZcW1xzXChcQF=rcHJlZ19tYXRjaFwoLis_aWZbXHNcKFxAXStmdW5jdGlvbl9leGlzdHNcKC4rPyhccytcfSl7M318KGVjaG98cHJpbnR8ZGllKVtcc1woXStcMltcc1woXSthcnJheVtcc1woMC=5LFwpXSs7XHMqKCR8XD8-KSkvaXMiO31zOjMxOiJzY3JpcHQgZ29vZ2xlYmxvZ2NvbnRhaW5lciBldmFsIjthOjI6e2k6MDtzOjU6IkdCUjhNIjtpOjE7czoxMjY6Ii88c2NyaXB=W14-XSsoc3JjPVsnImh=cHM6XStcL1wvZ29cLlteXD9dK1w_KHpvbmV8aWR8cCkrPVxkK1snIlwmXVtePl=qPnxpZD=iZ29vZ2xlYmxvZ2NvbnRhaW5lciIuK2V2YWxcKC4rKVxzKjxcL3NjcmlwdD5ccyovaSI7fXM6MjI6ImluY2x1ZGUgcGhwNS5waHAgYWxvbmUiO2E6Mjp7aTowO3M6NToiRjVMQlYiO2k6MTtzOjEwMjoiLzxcP1twaFxzXStpZlxzKlwoaXNbXlwpXStbXClcc1x7XStcQD9pbmNsdWRlXCgoLis_XC5pY298J3BocDVcLnBocClbIiddXCk7KFxzKmRpZVteO1=qOyk_W1xzXH1dKlw_Pi9pIjt9czoyNzoiZG9jdW1lbnQud3JpdGUgaWZyYW1lIHNtYWxsIjthOjI6e2k6MDtzOjU6IkUyR=NIIjtpOjE7czoxNjM6Ii8oZG9jdW1lbnRcLndyaXRlXChbJyJdKT88aWZyYW1lIHNyYz1bJyJdaHR=cDpcL1wvKC4rPykoIChoZWlnaHR8d2lkdGgpPVsnIl=_WzAtNV1bJyJdPykrKCBzdHlsZT1bJyJddmlzaWJpbGl=eTpbXHQgXSpoaWRkZW5bXj5dKj48XC9pZnJhbWU-fD48XC9pZnJhbWU-WyciXVwpKTsqL2kiO31zOjI3OiJkb2N1bWVudC53cml=ZSBpZnJhbWUgLnBocDUiO2E6Mjp7aTowO3M6NToiRDFFSnYiO2k6MTtzOjY1OiIvZG9jdW1lbnRcLndyaXRlXChbJyJdPGlmcmFtZSAuK2xlZnRcOlsgXT8tLis8XC9pZnJhbWU-WyciXVwpOyovaSI7fXM6MTA6ImFycmF5IGV2YWwiO2E6Mjp7aTowO3M6NToiRzM2SUMiO2k6MTtzOjIzMToiLyhmdW5jdGlvblxzKyhbYS16XzAtOV=rKVwoKFteO1=qWztcc1x9XSspKz9yZXR1cm5bXjtdKls7XHNcfV=rKT8oKFwkW1wtXD5cLmEtel8wLTldKylccyo9XHMqKCgoWyciXSkuKlw4W1wuXHNdKikrfGFycmF5KF9tYXApKlxzKlwoW15cKV=qW1wpXHNdKygsW15cKV=qW1wpXHNdKykqKTtccyopK2V2YWxccyooXC9cKlteXCpdKihcKlteXCpcL1=qKStcL1xzKikqXCguKj8oXDJ8XDUpLipbXClcc1=rOy9pIjt9czoyNToiZG9jdW1lbnQud3JpdGUgaWZyYW1lIC5ydSI7YToyOntpOjA7czo1OiJFOUpJYyI7aToxO3M6NzE6Ii8oZG9jdW1lbnRcLndyaXRlXCh8ZWNobyApWyciXTxpZnJhbWUgLitcLnJ1XC8uKzxcL2lmcmFtZT5bJyJdWyBcKTtdKy9pIjt9czo4OiJldmFsIGhleCI7YToyOntpOjA7czo1OiJHODlGMCI7aToxO3M6Nzg6Ii9cQD9ldmFsXHMqXChbYS16XzAtOVxzXChdKihbIiddKVteO1=qKFxcKHhbMC=5YS1mXXsyfXxcZCspKStbXjtdKlwxW1wpXHNdKjsvaSI7fXM6MTk6ImZ1bmN=aW9uX2V4aXN=cyBlbW8iO2E6Mjp7aTowO3M6NToiRzJTOTEiO2k6MTtzOjc1OiIvPFw_W3BoXHNdKihpZiBcKFwhZnVuY3Rpb25fZXhpc3RzXCgnZW1vJ1wpLitleGl=O1x9fHdwX2Zvb3RzXChcKTspXHMqXD8-L2kiO31zOjM=OiJmdW5jdGlvbl9leGlzdHMgYmFzZTY=X2RlY29kZSBldmFsIjthOjI6e2k6MDtzOjU6IkY=N=tXIjtpOjE7czoxNTA6Ii9pZlxzKlwoXHMqXCFmdW5jdGlvbl9leGlzdHNccypcKC4rW1wpXHNdK1tce1xzXSpmdW5jdGlvblxzKlthLXpcXzAtOV=rXCguK1tcKVxzXStbXHtcc1wkYS16XF8wLTlcfVxzXD1cQF=qYmFzZTY=X2RlY29kZVxzKlwoLitldmFsXHMqXCguK1tcKTtcc1x9XSsvaSI7fXM6Mjg6ImVjaG8gZ3ppbmZsYXRlIGJhc2U2NF9kZWNvZGUiO2E6Mjp7aTowO3M6NToiSDFPOTkiO2k6MTtzOjExMDoiL1wjW2Etel9cLT=wLTldK1wjW1xzXEBdK2VjaG9bXChcc1xAXStnemluZmxhdGVbXChcc1xAXStiYXNlNjRfZGVjb2RlW1woXHNdKy4rW1wpXHNdKztccypcI1wvW2Etel9cLT=wLTldK1wjL2kiO31zOjIxOiJwcmVnX3JlcGxhY2UgL2UgYWxvbmUiO2E6Mjp7aTowO3M6NToiRjZPOU=iO2k6MTtzOjIwNToiLzxcP1twaFxzXSooKFxAP2Vycm9yX3JlcG9ydGluZ1wofFwoXCRbYS16XF8wLTldK1xzKj1ccypcJF8oUkVRVUVTfEdFfFBPUylUXFspW15cKV=qW1wpXCY7XHNdKyk_XEA_cHJlZ19yZXBsYWNlW1woIFx=XSsoWyciXSkoW1whXC9cI1x8XEBcJVxeXCpcfl=pLis_XDVbaW1zeF=qZVtpbXN4XSpcNFsgXHRdKixbXixdKyxbXlwpXStbXCk7XHNdKihcPz58JCkvaSI7fXM6MTk6InByZWdfcmVwbGFjZSAvZSBoZXgiO2E6Mjp7aTowO3M6NToiSDJORWYiO2k6MTtzOjI1NToiLygoXC97Mn=uKnxcJFthLXpfMC=5XStccyo9LispXHMqKSpcQD8oXCRbYS16XzAtOV=rfHByZWdfcmVwbGFjZSlccypcKFxzKihbJyJdKShbXCFcL1wjXHxcQFwlXF5cKlx-XXxcXFt4MC=5XXsxLDN9KS4rPyhcNVtpbXN4XSplW2ltc3hdKnxcXHg2NXxcXDE=NSlcNFxzKixccyooWyciXVxceFswLTlBLUZdezJ9fFsnIl=_XCQoPyFjYiwgXCRlbmNvZGVkX3ZhbHVlXFtcJGtleVxdXCk7KSg_IXJlcGxcLic7KSlbXixdKyxbXlwpXStbXCk7XHNdKi9pIjt9czozMToicHJlZ19yZXBsYWNlIC9lIHN=cl9yZXBsYWNlIGhleCI7YToyOntpOjA7czo1OiJGNkZJbiI7aToxO3M6MTQ2OiIvXEA_cHJlZ19yZXBsYWNlXHMqXChccypbJyJdLitbXC9cI1x8XVtpc1=qZVtpc1=qWyciXVxzKixccypcQD8oXCRfKFJFUVVFU3xHRXxQT1MpVFxbfHN=cl9yZXBsYWNlXCgoWyciXHMsXC5cJF=qXFx4WzAtOUEtRl1bMC=5QS1GXSkrKS4qXClbXHM7XSovaSI7fXM6MTc6ImV2YWwgZnJvbUNoYXJDb2RlIjthOjI6e2k6MDtzOjU6IkY4R=RGIjtpOjE7czoyOTc6Ii8oPHNjcmlwdFtePl=qPlxzKigoKHZhclxzKik_W2Etel8wLTldK1xzKig7XHMqW2Etel8wLTldK1xzKj1ccypbYS16XzAtOV1bXHNcLl=qbGVuZ3RofFtcLj1dK1xzKihbIiddKS4qP1w2XHMqfFssPV=rXHMqXFtbXlxdXSpcXStccyopKztccyopK2ZvclteXHtdK1x7XHMqW15cfV=rZnJvbUNoYXJDb2RlXChbXlx9XStbXH1cc1=rKFthLXpfMC=5XStccyo9W147XSs7XHMqKSpkb2N1bWVudFwud3JpdGVcKHxldmFsXCguKmZyb21DaGFyQ29kZVwoKFxzKlswLTldK1xzKiwpKylbXjtdKztccyo8XC9zY3JpcHQ-XHMqKSsvaSI7fXM6MjU6ImluaV9yZXN=b3JlIGJhc2U2NF9kZWNvZGUiO2E6Mjp7aTowO3M6NToiSDFPTmciO2k6MTtzOjk3OiIvPFw_W3BoXHNdK2luaV9yZXN=b3JlXHMqXCguK1xzKy4rYmFzZTY=X2RlY29kZVxzKlwoLitccysuK3BocFwuaW5pLitccysuK2Z3cml=ZVxzKlwoW1xTXHNdK1w_Pi9pIjt9czoxODoiZXZhbCBiYXNlNjRfZGVjb2RlIjthOjI6e2k6MDtzOjU6IkcxMURmIjtpOjE7czoyOTg6Ii8oXC9cKlteXCpdKihcKlteXCpcL1=qKStcL1xzKnxcL1wvW15cbl=qXHMrKSooXEA_ZXJyb3JfcmVwb3J=aW5nXChbXlwpXSpcKSs7XHMqLitccyopPyhiYXNlNjRfZGVjb2RlXCguK1xzKik_XEA_ZXZhbFxzKihcL1wqW15cKl=qKFwqW15cKlwvXSopK1wvXHMqfFwvXC9bXlxuXSpccyspKlwoW15cKV=qYmFzZTY=X2RlY29kZVxzKihcL1wqW15cKl=qKFwqW15cKlwvXSopK1wvXHMqfFwvXC9bXlxuXSpccyspKlwoW15cKV=rKFwpXHMqKFwvXCpbXlwqXSooXCpbXlwqXC9dKikrXC9ccyp8XC9cL1teXG5dKlxzKykqKSs7L2kiO31zOjMzOiJlcnJvcl9yZXBvcnRpbmcgdmFyaWFibGUtZnVuY3Rpb24iO2E6Mjp7aTowO3M6NToiRDZBQWIiO2k6MTtzOjk=OiIvPFw_KHBocCk_W1xyXG4gXHRdKihcJFthLXpcXzAtOV=rKVtcdCA9XStbJyJdLitbJyJdWzsgXHRdK1tcQF=_ZXJyb3JfcmVwb3J=aW5nXCguK1wyXCguK1w_Pi9pIjt9czoxOToiZWNobyBzY3JpcHQgaWZyYW1lICI7YToyOntpOjA7czo1OiJIMU45ZCI7aToxO3M6MTM5OiIvXCNbYS16X1wtPTAtOV=rXCNbXHNcQF=rZWNoby4rPHNjcmlwdC4rXC5jcmVhdGVFbGVtZW5=W1woXHMiJ1=raWZyYW1lLitcLnN=eWxlXC4obGVmdHx=b3ApPVsnIlxcXSstLis8XC9zY3JpcHQ-Lis7XHMrXCNcL1thLXpfXC=9MC=5XStcIy9pIjt9czoxMzoiZXZhbCBfUkVRVUVTVCI7YToyOntpOjA7czo1OiJHMVY4cSI7aToxO3M6MTY2OiIvW1xAXSooZXJyb3JfcmVwb3J=aW5nXCguK2Jhc2U2NF9kZWNvZGVcKC4rKSooPzwhbClldmFsWyBcdF=qKFwvXCouKlwqXC8pKlsgXHRdKlwoWyBcdF=qKFwvXCouKlwqXC8pKlsgXHRdKlwkXyhSRVFVRVN8R=V8UE9TKVRcWy4rP1xdLio_XClbIFx=XSooXC9cKi4qXCpcLykqWyBcdF=qOy9pIjt9czoxODoiZm9yZWFjaCBldmFsIGFycmF5IjthOjI6e2k6MDtzOjU6IkgxNEw3IjtpOjE7czoyMjk6Ii8oXC9cKlxzKyhbYS16X1wtMC=5XSspXHMqXCpcL1xzKnw8XD9bcGhcc1=rKShcJFthLXpfMC=5XSspXHMqPVxzKmFycmF5W147XSs7XHMqLis_ZnVuY3Rpb24gKFthLXpfMC=5XSspXCguKz9yZXR1cm5bXjtdKjtbO1x9XHNdKyhcJFthLXpfMC=5XSspXHMqPVxzKlw=XHMqXChccypcM1teO1=rO1xzKmV2YWxcKFw1W147XStbJyJcKVx9O1xzXSsoXC9cKlxzK1wvXDJccypcKlwvfC4rPygkfFw_PikpL2kiO31zOjMxOiJleGNlc2l2ZSBzcGFjZXMgaW4gaGFzaGVkIGJsb2NrIjthOjI6e2k6MDtzOjU6IkNDVjhGIjtpOjE7czo1NzoiL1wjW2EtekEtWjAtOV=rXCNbXG4gXHRdezUwfS4rW1xuIFx=XStcI1wvW2EtekEtWjAtOV=rXCMvIjt9czoyOToiSmF2YXNjcmlwdCBvYnNjdXJlIGV2YWwgYXJyYXkiO2E6Mjp7aTowO3M6NToiRkI=S2QiO2k6MTtzOjE1MjoiLyhcL1wqWzAtOWEtZl17MzJ9XCpcLylccyoodHJ5XHt8dmFyXHMrW2Etel8wLTldK1xzKj=oXHMqW1xbLF1ccyooWyciXSkoXFx4WzAtOWEtZl17Mn=pK1w=KSsuKylkb2N1bWVudFxzKihcW1teXF1dK1tcXVxzXSspK1woW2Etel8wLTldK1wpK1tcfVxzO1=rXDEvaXMiO31zOjMwOiJKYXZhU2NyaXB=IGZ1bmN=aW9uIHhWaWV3U3RhdGUiO2E6Mjp7aTowO3M6NToiRDc4TGoiO2k6MTtzOjEwNzoiLzxzY3JpcHQgbGFuZ3VhZ2U9WyciXUphdmFTY3JpcHRbJyJdPltcclxuIFx=XSpmdW5jdGlvbiBbYS16MC=5XStWaWV3U3RhdGVcKFwpKC4rP1tcclxuIFx=XSopKz88XC9zY3JpcHQ-L2kiO31zOjI5OiJhZGQtZGl2LWNvbnRlbnQgVmlhZ3JhIENpYWxpcyI7YToyOntpOjA7czo1OiJENDZIYiI7aToxO3M6ODk6Ii88XCEtLXN=YXJ=LWFkZC1kaXYtY29udGVudFswLTldKi=tPi4rVmlhZ3JhLitDaWFsaXMuKzxcIS=tZW5kLWFkZC1kaXYtY29udGVudFswLTldKi=tPi9pIjt9czoyMToiamF2YXNjcmlwdCBhcnJheSBldmFsIjthOjI6e2k6MDtzOjU6IkVDTE5WIjtpOjE7czo5MDoiL3ZhclxzKltfXC1cPlwuYS16MC=5XStccyo9XHMqXFtccypbJyJdKFxceFswLTlBLUZdezJ9KStbIiddW15cXV=qXF=uKz9ldmFsXHMqXCguKz9cKSs7Ki9pIjt9czoyNDoiaXNzZXQgUkVRVUVTVCBldmFsIGFsb25lIjthOjI6e2k6MDtzOjU6IkY4R=JPIjtpOjE7czoxNTQ6Ii88XD9bcGhcc1=rKFwkW19cLVw-XC5hLXowLTldK1xzKj1ccyooWyciXSkuKz9cMjtccyopKmlmW1xzXChdKyhbYS16XzAtOV=rXHMqXChccyopKlwkXyhSRVFVRVN8R=V8UE9TKVRcWy4rKHN5c3RlbXxldmFsKVwoLitccypleGl=W147XSpbO1xzKlx9XSsoJHxcPz4pL2kiO31zOjM=OiJpc3NldCBIVFRQX1VTRVJfQUdFTlQgaGVhZGVyIGFsb25lIjthOjI6e2k6MDtzOjU6IkQxT=5GIjtpOjE7czo5ODoiLzxcP3BocCBpZlwoaXNzZXRcKFwkX1NFUlZFUlxbWyciXUhUVFBfVVNFUl9BR=VOVFsnIl1cXS4raGVhZGVyXChbJyJdTG9jYXRpb246IGh=dHA6XC9cLy4rO1x9XD8-L2kiO31zOjI1OiJzdHJyZXYgQXNzZXJ=IGV2YWwgYmFzZTY=IjthOjI6e2k6MDtzOjU6IkQyNElIIjtpOjE7czoyMjA6Ii9bXHJcbiBcdF=rLis_XChbIiddKFxcMTQ1fGUpKFxcMTY2fHYpKFxcMTQxfGEpKFxcMTU=fGwpKFxcMDUwfFwoKShcXDE=MnxiKShcXDE=MXxhKShcXDE2M3xzKShcXDE=NXxlKShcXDA2Nnw2KShcXDA2NHw=KShcXDEzN3xfKShcXDE=NHxkKShcXDE=NXxlKShcXDE=M3xjKShcXDE1N3xvKShcXDE=NHxkKShcXDE=NXxlKShcXDA1MHxcKCkuKz9cXDA1MVxcMDUxXFwwNzNbIiddXCk7L2kiO31zOjI=OiJSZXRyeSBiYXNlNjRfZGVjb2RlIEN1cmwiO2E6Mjp7aTowO3M6NToiSDJSSk=iO2k6MTtzOjI3NToiLzxcP1tcc2hwXSpcQD9lcnJvcl9yZXBvcnRpbmdcKFtcczBdK1wpO1xzKigoXCRbYS16XzAtOV=rXHMqPVxzKik_KHVybGRlY29kZVtcc1woXSspP1wkX=NPT=tJRVxbW15cXV=rXF=rW1wpO1xzXSspKy4rbWFpbFwoW15cKV=rXCkrW1xzXHtdK3Bvc3Rfc3RhdHNcKCguKz9mdW5jdGlvblxzKyhwb3N=X3N=YXRzfF9ob3N=MmludHxtY2h8c21=cF9sb29rdXB8cG9zdF9tY2gpKXs1fS4rc29ja2V=X2Nsb3NlXChbXlwpXStcKStbO1xzXH1dK2RpZVwoXCk7W1xzXH1dKigkfFw_PikvaXMiO31zOjIwOiJwcmVnX3JlcGxhY2UgYWxsIGhleCI7YToyOntpOjA7czo1OiJGNzE=TyI7aToxO3M6NTY6Ii9cQCpwcmVnX3JlcGxhY2VccypcKChbXlwpXSo_XHhbMC=5QS1GXXsyfSl7MTUsfS4rP1wpOy9pIjt9czoxNDoiaWZyYW1lIGluIGhlYWQiO2E6Mjp7aTowO3M6NToiRDUzSFAiO2k6MTtzOjU2OiIvXDxpZnJhbWUgLitcPFwvaWZyYW1lXD5bXHJcbiBcdF=qKD89XDxcL2godG1sfGVhZClcPikvaSI7fXM6MzY6IlRhZ2dlZCBzY3JpcHQgdHJ5IGRvY3VtZW5=LmJvZHkgZXZhbCI7YToyOntpOjA7czo1OiJHMkdERyI7aToxO3M6MTg3OiIvPFwhLS1bYS16XzAtOVxzXSstLT5ccyo8c2NyaXB=IC4rPyhiZHZfcmVmX3BpZD=oWzAtOV=rKTsuKz88XC9zY3JpcHQ-XHMqPHNjcmlwdCAuKz9waWQ9XDJ8dHJ5XHtkb2N1bWVudFwuYm9keS4rP2V2YWwpLis_PFwvc2NyaXB=PlxzKig8bm9zY3JpcHQuKzxcL25vc2NyaXB=PlxzKik_PFwhLS1bXC9hLXpfMC=5XHNdKy=tPi9pIjt9czoyOToiVGFnZ2VkIHRyeSBkb2N1bWVudC5ib2R5IGV2YWwiO2E6Mjp7aTowO3M6NToiRDNKN=4iO2k6MTtzOjkxOiIvXC9cKlswLTlhLWZdK1wqXC9bXHJcbiBcdF=rLis_dHJ5XHtkb2N1bWVudFwuYm9keS4rP2V2YWwuKz9bXHJcbiBcdF=rXC9cKlwvWzAtOWEtZl=rXCpcLy9pIjt9czozNzoiZXZhbCB2YXJpYWJsZS1mdW5jdGlvbiBsb25nLW5iLXN=cmluZyI7YToyOntpOjA7czo1OiJGNk1EaCI7aToxO3M6MTQxOiIvKChcL1wvLit8XCRbYS16XF8wLTlcW1xdXHtcfSciXStccyo9W15cO1=rOylccyopKlxAPyhldmFsfGFzc2VydClcKChcJFthLXpcXzAtOVxbXF1ce1x9JyJdK1woKStbJyJdW2EtekEtWjAtOVwvXF9cLVwrXD1cclxuXXsyMDAsfVsnIl1cKSs7L2kiO31zOjQxOiJmdW5jdGlvbiBvYl9nZXRfbGV2ZWwgb2Jfc3RhcnQgYWRkX2FjdGlvbiI7YToyOntpOjA7czo1OiJEM=xBNCI7aToxO3M6MTg4OiIvaWYgXChcIWZ1bmN=aW9uXF9leGlzdHNcKC4rP1wpIFx7W1xyXG4gXHRdK2Z1bmN=aW9uIC4rP1wpIFx7W1xyXG4gXHRdK2lmIFwoXCFvYlxfZ2V=XF9sZXZlbFwoXClcKSBvYlxfc3RhcnRcKC4rP1wpO1tcclxuIFx=XStcfVtcclxuIFx=XSsoLitbXHJcbiBcdF=rKSsoYWRkX2FjdGlvblwoLis_XCk7W1xyXG4gXHRdKykrXH=vaSI7fXM6MjY6ImhlYWQgc2NyaXB=IGRvY3VtZW5=LndyaXRlIjthOjI6e2k6MDtzOjU6IkQzUEQ1IjtpOjE7czo2MjoiLyg_PD1cPFwvaGVhZFw-KVw8c2NyaXB=Lis_ZG9jdW1lbnRcLndyaXRlXCguKz9cPFwvc2NyaXB=XD4vc2kiO31zOjE=OiJzY3JpcHQgaHR=cCBJUCI7YToyOntpOjA7czo1OiJHM=c4OCI7aToxO3M6MjY3OiIvKD88IVsnIl=pPHNjcmlwdFtePl=qKHNyYz1bJyJdP2h=dHBbc1=_XDpcLygoW1wvfFwuXVswLTldKyl7NH18XC93d3dcLmFkc3B=cFwuY29tfFwvY2RuXC5wb3BjYXNoXC5uZXQpXC98Y29sbGVjdFwuanN8XC93cC1pbmNsdWRlc1wvanNcL2pjcm9wXC9qcXVlcnlcLmpzfD4uKmh=dHA6XC9cL21icy1zdXBwb3J=XC5jb21cL2pzXC9qcXVlcnlcLm1pblwucGhwLipkb2N1bWVudFwud3JpdGVcKFsiJ1=8c2NyaXB=LipcL3NjcmlwdClbXj5dKj4uKj88XC9zY3JpcHQ-L2kiO31zOjE4OiJzY3JpcHQgZW5jb2RlIGV2YWwiO2E6Mjp7aTowO3M6NToiRTk3R28iO2k6MTtzOjEwNToiLzxzY3JpcHQuKz8oKFswLTlBLUZ4XXsyMDB9fChbJyJdPyxbIiddP1swLTlBLUZ4XSspezIwMH=uKz9ldmFsKXwoZXZhbC4rP1swLTkgXHRcLF17MzAwfSkpLis_PFwvc2NyaXB=Pi9pIjt9czo1NDoiVGFnZ2VkIGJhc2U2NF9kZWNvZGUgZmlsZV9nZXRfY29udGVudHMgcG9zaXRpb24gaWZyYW1lIjthOjI6e2k6MDtzOjU6Ikc=RklWIjtpOjE7czozOTM6Ii8oKFwvXCp8XCMpXHMqKFthLXpfMC=5XStccyooXDJ8XCpcLykpXHMqLis_YmFzZTY=X2RlY29kZS4rP1xzKi4rP2ZpbGVfZ2V=X2NvbnRlbnRzLis_XHMqLis_cG9zaXRpb24uKz9ccyouKz88XC9pZnJhbWU-LitccyooXC9cKnxcIylbXC9cc1=qXDN8aWZccypcKFteXHtdKigoZ29vZ2xlfGJvdHx5YWhvb3xiaW5nfEhUVFBfVVNFUl9BR=VOVClbXlx7XSspezUsfVx7KChcJFthLXpfMC=5XStbXHNcLlwrXSo9XHMqKT8oc2h1ZmZsZXxhcnJheSlcKFteO1=rO1xzKikqZm9yZWFjaFwoW15ce1=rXHtccyppZlxzKlwocHJlZ19tYXRjaFxzKlwoW15ce1=rXHtccyouKz8oW1xAXH5cc1=qKGJhc2U2NF9kZWNvZGV8ZmlsZV9nZXRfY29udGVudHMpXHMqXCgpezN9Lis_XHMqKFx9XHMqKXszfSkvaSI7fXM6MTU6InNjcmlwdCBhamF4IFBPQyI7YToyOntpOjA7czo1OiJHN=c4TyI7aToxO3M6MTkwOiIvPHNjcmlwdFtePl=rKFZCU2NyaXB=Lis_Q3JlYXRlT2JqZWN=XChbJyJdU2NyaXB=aW5nXC5GaWxlU3lzdGVtT2JqZWN=WyciXVwpLis_XC5DcmVhdGVUZXh=RmlsZVwoLis_XC5Xcml=ZS4rP=NyZWF=ZU9iamVjdFwoWyciXVdTY3JpcHRcLlNoZWxsWyciXVwpLis_fGFqYXgucGhwWyciXT5bJyJdUE9DWyciXSk8XC9zY3JpcHQ-L2lzIjt9czoyNjoidGFyZ2V=cyBhcnJheSBKQVBsdWdpbkRvbmUiO2E6Mjp7aTowO3M6NToiRDQ5QUoiO2k6MTtzOjgxOiIvKFwvXC9maWxlc1tcdCBcclxuXSspKlwkdGFyZ2V=c1sgPVx=XSthcnJheVwoLis_ZWNob1sgIiddK=pBUGx1Z2luRG9uZVsgIic7XSsvc2kiO31zOjE1OiJpbmNsdWRlIGZhdmljb24iO2E6Mjp7aTowO3M6NToiRDRBN1EiO2k6MTtzOjQ2OiIvW1xyXG5dK1tcdCA7XSppbmNsdWRlLitmYXZpY29uXC5pY29bJyJcKTtdKy9pIjt9czoxNToiYWRkX2ZpbHRlciBjcmVkIjthOjI6e2k6MDtzOjU6IkQ=SjdXIjtpOjE7czo5MzoiL2FkZF9maWx=ZXJcKCd=ZW1wbGF=ZV9pbmNsdWRlJywnZ2V=X2NyZWQnLDFcKTtbXHQgXHJcbl=rYWRkX2ZpbHRlclwoJ3NodXRkb3duJywnY3JlZCcsMFwpOy9pIjt9czoyMToicHJlZ19yZXBsYWNlIHN=cnJldiBlIjthOjI6e2k6MDtzOjU6IkQ=T=ZkIjtpOjE7czo4NzoiL1wkW2EtekEtWjAtOVxfXStbXD=gXHRdK1snIl1lXC9cKlwuXC9bJyJdO1tcclxuIFx=XStwcmVnX3JlcGxhY2VcKFsgXHRdKnN=cnJldlwoLipcKTsvIjt9czo3NzoiZnVuY3Rpb25fZXhpc3RzIGdldCBmaWxlIGZ1bmN=aW9uIGN1cmxfaW5pdCBmaWxlX2dldF9jb25=ZW5=cyBmb3BlbiBjdXJsX2V4ZWMiO2E6Mjp7aTowO3M6NToiRzJQQUkiO2k6MTtzOjM3NDoiLzxcP1twaFxzXSsoKGluaV9zZXR8XCRbYS16XzAtOV=rXHMqPSlbXjtdKztccyopKmZ1bmN=aW9uXHMrKFthLXpfMC=5XSspW15ce1=rW1xzXHtdKyhcJFthLXpfMC=5XStccyo9W147XSs7XHMqKSooZm9yZWFjaFteXHtdK1tcc1x7XSsoXCRbYS16XzAtOV=rXHMqKFxbW15cXV=rXF=rXHMqKSo9XHMqKT9jdXJsX2luaXQuKz9yZXR1cm5bXjtdKjt8KHJldHVyblxzKyk_Y3VybF9bXjtdKztccyopK1tcfVxzXSsoKFwkW2Etel8wLTldK1xzKj1ccyopPyhcJF9TRVJWRVJcW3xcM1wofGZvcGVuXCh8ZndyaXRlXCh8ZmNsb3NlXCgpW147XSs7XHMqKSooaWZbXHNcKF=rKGZpbGVfZXhpc3RzXCh8XCRfKFJFUVVFU3xHRXxQT1MpVFxbKS4rP1wzXCguKyl7Mn=vaXMiO31zOjMxOiJlcnJvcl9yZXBvcnRpbmcgaW5jbHVkZSB3cC1hcHBzIjthOjI6e2k6MDtzOjU6Ikc2UEVLIjtpOjE7czoxNjg6Ii8oKFwkW2Etel8wLTldK1tccz1dKyk_KGVycm9yX3JlcG9ydGluZ3xpbmlfc2V=fGdldGVudnxzdWJzdHIpXChbXlwpXSpcKSs7XHMqKSpcQCoocmVxdWlyZXxpbmNsdWRlKShfb25jZSk_W1woIidcc1=rW147XSt3cC=oaW5jbHVkZXN8aGVhZHxhcHBzfHRleHQpXC5waHBbIiddW1wpO1xzXSsvaSI7fXM6MzU6InJlcXVpcmUgY2dpLWxvY2FsIHBocCBjb21tZW5=IGFsb25lIjthOjI6e2k6MDtzOjU6IkY3TUI1IjtpOjE7czoxODc6Ii88XD9bcGhcc1=rKFwvXCouKz9cKlwvXHMqfFxAKSoocmVxdWlyZXxpbmNsdWRlKShfb25jZSkqW1woXHNdKyhcJF9TRVJWRVJbXFtce11bIiddRE9DVU1FTlRfUk9PVFsnIl1bXF1cfV1bXHNcLl=rWyInXVtcLlwvXSp3cC1bXjtdK3xbJyJdY2dpLWxvY2FsXC8uKz9cLnBocFsnIl1bXHNcKV=qKTtccysoXCMuKlxzKikqXD8-L2kiO31zOjUyOiJvYl9zdGFydCBnemluZmxhdGUgb2JfZ2V=X2NvbnRlbnRzIG9iX2VuZF9jbGVhbiBldmFsIjthOjI6e2k6MDtzOjU6IkczNkQ4IjtpOjE7czozMjE6Ii88XD9bcGhcc1=qKFtpZlwoXHNcIV=qZGVmaW5lKGRccypcKFteXCldK3xccypcKFteLF=rLFxzKihbYS16XzAtOVwoXSspKVteXCldKltcKTtcc1x7XH1dKykqKFxAfFwkW2Etel8wLTldK1tcc1wuXSo9XHMqKSpvYl9zdGFydFxzKlwoKFsnIlxzXSsoLio_KVsnIlxzXStcKTtccypmdW5jdGlvblxzK1w2XCguKz9mdW5jdGlvblxzK1wzLityZXR1cm5ccyooWyciXSlbXlw3XSpcN3xnemluZmxhdGVbXChcc1=rb2JfZ2V=X2NvbnRlbnRzW1woXCk7XHNdK29iX2VuZF9jbGVhbltcKFwpO1xzXStldmFsXChbXlwpXStbXClcc1=qKTtbXHNcfV=qKCR8XD8-XHMqKS9pcyI7fXM6MTc6InRhZ2dlZCBpZnJhbWUgMXB4IjthOjI6e2k6MDtzOjU6IkQ2MzZyIjtpOjE7czoxMjI6Ii88XCEtLSAuKz8gLS=-W1xyXG4gXHRdKjxpZnJhbWUgd2lkdGg9IjFweCIgaGVpZ2h=PSIxcHgiIHNyYz=iaHR=cDpcL1wvW14-XSs-W1xyXG4gXHRdKjxcL2lmcmFtZT5bXHJcbiBcdF=qPFwhLS=gLis_IC=tPi9pIjt9czoyOToic2NyaXB=IGFmdGVyIGNsb3NpbmcgYm9keSB=YWciO2E6Mjp7aTowO3M6NToiRzVNOUciO2k6MTtzOjc2OiIvKD88PVw8XC8oYm9keXxoZWFkKVw-KShccyo8KChzY3JpcHR8YSlbXHM-XS4qPzxcLyhcNHxib2R5KXxtZXRhW14-XSopPikrL2lzIjt9czoyNzoidmFyIFIgZnVuY3Rpb24gcFlNdVMgd2luZG93IjthOjI6e2k6MDtzOjU6IkY=OThLIjtpOjE7czoxOTI6Ii88c2NyaXB=W14-XSo-XHMqKHZhclxzKyk_KFthLXpfMC=5XSspXHMqPVxzKlxbLis_KChbYS16XzAtOV=rKVxzKj1ccypcMlxbW15cXV=rW1xdXHNdK1wrXDJcWy4rP1x7XHMqd2luZG93W1xbXHNdK1wyW1xbXHNdK1teXF1dK1tcXVxzXSs9XDRbXH=7XHNdK3xmdW5jdGlvbiBwWU11U1woLis_XClcKHdpbmRvd1wpKTxcL3NjcmlwdD4vaSI7fXM6MzE6IlRhZ2dlZCBlY2hvIHNjcmlwdCBldmFsIEhleEhleF8iO2E6Mjp7aTowO3M6NToiRDZVSXIiO2k6MTtzOjEyMjoiL1wjKFthLXowLTldKylcI1tcclxuIFx=XStlY2hvW1xyXG4nIiBcdF=rPHNjcmlwdCouKz9ldmFsLis_KFthLXowLTldW2EtejAtOV1cXyl7MTAwfS4rPzxcL3NjcmlwdD5bXHJcbiciOyBcdF=rXCNcL1wxXCMvaXMiO31zOjMxOiJ2YXJpYWJsZSBjcmVhdGVfZnVuY3Rpb24gc3RycmV2IjthOjI6e2k6MDtzOjU6IkcySUkxIjtpOjE7czoyNDY6Ii88XD9bcGhcc1=qKFwvXCpbXlwqXSooXCpbXlwqXC9dKikrXC9ccyp8XC9cL1teXG5dKlxzKykqKChcJFthLXpfMC=5XSspXHMqPSk_LitmdW5jdGlvblxzKihbYS16XzAtOV=qKVwoLis_KGV2YWxcKFw1XCh8YmFzZTY=X2RlY29kZVwofFxzKlw=XHMqXChccypzdHJyZXZcKCkuKz8oXClccyopezIsfTtccyooZXZhbFwoLis_KFwpXHMqKXsyLH=7XHMqfFwkW2Etel8wLTldK1xzKj1bXjtdKztccyp8XDFccyopKigkfFw_PlxzKikvaSI7fXM6MjI6Imh=bWwgZW1iZWQgb2JqZWN=IGh=bWwiO2E6Mjp7aTowO3M6NToiRDg3OXYiO2k6MTtzOjU3OiIvPGh=bWw-W1xyXG4gXHRdKjxlbWJlZC4rPzxcL29iamVjdD5bXHJcbiBcdF=qPFwvaHRtbD4vaXMiO31zOjM2OiJyZXF1aXJlIG5ldyBTQVBFX2NsaWVudCByZXR1cm5fbGlua3MiO2E6Mjp7aTowO3M6NToiRzFDTmoiO2k6MTtzOjY3OiIvKFwkW2Etel8wLTldKylccyo9XHMqbmV3XHMqU=FQRV9jbGllbnRcKC4rP1wxLT5yZXR1cm5fbGlua3NcKFwpOy9zIjt9czo5MzoiaWYgZnVuY3Rpb25fZXhpc3RzIF9waHBfY2FjaGVfc3BlZWR1cF9mdW5jX29wdGltaXplcl8gcmVnaXN=ZXJfc2h1dGRvd25fZnVuY3Rpb24gb2JfZW5kX2ZsdXNoIjthOjI6e2k6MDtzOjU6IkY2RzdqIjtpOjE7czoxNTA6Ii9bO1xzXSppZlxzKlwoXCFmdW5jdGlvbl9leGlzdHNcKFsnICJdK19waHBfY2FjaGVfc3BlZWR1cF9mdW5jX29wdGltaXplcl9bJyAiXStcKVwpLis_cmVnaXN=ZXJfc2h1dGRvd25fZnVuY3Rpb25cKFsnICJdK29iX2VuZF9mbHVzaFsnICJdK1wpWztcc1=qXH=vcyI7fXM6NDQ6ImVycm9yX3JlcG9ydGluZyBpbmlfc2V=IGlmIGNvdW5=IFBPU1QgcmV=dXJuIjthOjI6e2k6MDtzOjU6IkQ4TUJuIjtpOjE7czoxMTM6Ii9bXEBdKmVycm9yX3JlcG9ydGluZ1woMFwpOyhbXEAgXHJcbl=qaW5pX3NldFwoKC4rPylcKVs7IFxyXG5dKikraWYgXChjb3VudFwoXCRfUE9TVC4rcmV=dXJuIFwkW2EtejAtOV=rWzsgXH1dKy9pIjt9czozODoiZGl2IFZpYWdyYSBDaWFsaXMgc2NyaXB=IHN=eWxlLmRpc3BsYXkiO2E6Mjp7aTowO3M6NToiRDlIQ2YiO2k6MTtzOjE=MzoiLzxkaXYgaWQ9WyciXShbXj5dKilbJyJdPi4qVmlhZ3JhLitDaWFsaXMuKjxcL2Rpdj5bXHJcbiBcdF=qPHNjcmlwdFtePl=qPi4qZG9jdW1lbnRcLmdldEVsZW1lbnRCeUlkXChbIiddXDFbIiddXClcLnN=eWxlXC5kaXNwbGF5Lio8XC9zY3JpcHQ-L2kiO31zOjcxOiJwaHAgdmFyaWFibGUgYXJyYXkgYmFzZTY=X2RlY29kZSBmdW5jdGlvbl9leGlzdHMgbnVtZXJpYy1uYW1lZCBmdW5jdGlvbiI7YToyOntpOjA7czo1OiJHNktLbyI7aToxO3M6Mzc1OiIvPFw_W3BoXHNdKyhcL1wqKFteXCpdKlwqW15cL1=pKlteXCpdKlwqXC9ccyp8XC9cL1teXG5dKlxzKykqXCRbYS16XzAtOSciXFtcXVxzXSs9XHMqYXJyYXlcKC4qP2Jhc2U2NF9kZWNvZGVcKC4rP1wpKztccyooaWZccypcKFwhZnVuY3Rpb25fZXhpc3RzXChbIiddX1swLTldK1siJ11bXClcc1=rXHtccyp8XD8-XHMqPFw_W3BoXHNdKykqZnVuY3Rpb24gX1swLTldK1woKC4rPylbXH1cc1=rKFw_PlxzKjxcP1twaFxzXStcQD9cJEdMT=JBTFNccyooXFtbXlxdXSpcXStccyp8XHtbXlx9XSpcfStccyopK1woLisoZXZhbHxcJEdMT=JBTFMoXHMqXFtbXlxdXSpcXStccyp8XHtbXlx9XSpcfSspKylccypcKFteXCldK1tcKTtcfVxzXSspKihcMXwkfFw_PikrL2kiO31zOjMyOiJUYWdnZWQgaWYgZW1wdHkgc2NyaXB=IGV2YWwgZWNobyI7YToyOntpOjA7czo1OiJFMUc4OCI7aToxO3M6MTc3OiIvXCMoW2EtejAtOV=rKVwjW1xyXG4gXHRdK2lmWyBcdF=qXChlbXB=eVwoKFwkW2Etel8wLTldKylcKVwpW1xyXG5ceyBcdF=rXDJbXHJcbiciID1cdF=rPHNjcmlwdC4rPyhldmFsfHNyYz1bXFwnIl=raHR=cCkuKz88XC9zY3JpcHQ-W1xyXG4nIjsgXHRdK2VjaG8gXDJbXHJcbjsgXH1cdF=rXCNcL1wxXCMvaXMiO31zOjQ=OiJ2YXIgSFRUUF9VU=VSX=FHRU5UIGlmIG1hdGNoIHN=cmluZyB2YXIgZWxzZSI7YToyOntpOjA7czo1OiJEQUpIMiI7aToxO3M6MTI2OiIvKFwkW2EtelxfMC=5XSspW1x=ID1dK1wkX1NFUlZFUlxbWyInXUhUVFBfVVNFUl9BR=VOVFsnIl1cXTsuKz9pZiBcKFwkW2EtelxfMC=5XStcKFteLF=rLCBcMVwpXCkgXHtbXlx9XStcfSBlbHNlIFx7W15cfV=rXH=vaXMiO31zOjM=OiJkaXYgcGhwIGVycm9yX3JlcG9ydGluZyBmb3BlbiBodHRwIjthOjI6e2k6MDtzOjU6Ikc4UTdYIjtpOjE7czo4NDoiLzxkaXYgW14-XSo-XHMqPFw_W3BoXHNdK2Vycm9yX3JlcG9ydGluZ1woLis_Zm9wZW5cKFsiJ11odHRwOlwvXC8uKz9cPz5ccyo8XC9kaXY-L2lzIjt9czo2OToiRE9DVU1FTlRfUk9PVCBpZiBmaWxlX2V4aXN=cyBmaWxlX2dldF9jb25=ZW5=cyBnemluZmxhdGUgcHJlZ19yZXBsYWNlIjthOjI6e2k6MDtzOjU6IkdDVkc2IjtpOjE7czozNjI6Ii9cJChbYS16XzAtOV=rKVxzKj1bXjtdKlwkX1NFUlZFUltcc1xbXHtdKyhbIiddKShET=NVTUVOVF9ST=9UfFNDUklQVF9OQU1FKVwyW1xzXF1cfV=rLis_aWZccypcKFxzKmZpbGVfZXhpc3RzXHMqXCguKz9cJChbYS16XzAtOV=rKVxzKj1bXHNcQF=qKGZpbGVfZ2V=X2NvbnRlbnRzXHMqXChccypcJFwxLis_XCQoW2Etel8wLTldKylccyo9W1xzXEBdKmd6aW5mbGF=ZVxzKlwoXHMqXCRcNC4rP3ByZWdfcmVwbGFjZS4rP1wpO1tcfVxzXSt8c2NhbmRpclxzKlwoW147XSs7XHMqZm9yZWFjaFxzKlwoXCRcNC4rZndyaXRlXHMqXChbXjtdKztccypmY2xvc2VccypcKFteO1=rO1tcfVxzXSt1bmxpbmtccypcKFxzKlwkXDFcKTtccyopL2lzIjt9czo1NDoiZnVuY3Rpb24gZm91cm9mb3VyIGFkZF9maWx=ZXIgYWxsX3BsdWdpbnMgZm91cm9mb3VyX3BwIjthOjI6e2k6MDtzOjU6IkRCSE1tIjtpOjE7czo4MToiL2Z1bmN=aW9uIGZvdXJvZm91clwoXCkuK2FkZF9maWx=ZXJcKFsiJ11hbGxfcGx1Z2luc1ssICInXStmb3Vyb2ZvdXJfcHBbIiddXCk7L2lzIjt9czoxNDoicCBwYXlkYXkgbG9hbnMiO2E6Mjp7aTowO3M6NToiRzVCQ=siO2k6MTtzOjQ2OiIvPHBbXj5dKj5ccyouKz9wYXlkYXkgbG9hbi4rP1tcclxuXStccyo8XC9wPi9pIjt9czoyNjoic2NyaXB=IHNyYyBlYXJubW9uZXlkby5jb2=iO2E6Mjp7aTowO3M6NToiRzZIRnMiO2k6MTtzOjE2NToiLyg8KHNjcmlwdHxhKVtePl=rKGhyZWY9WyciXVtmaHRwc2w6XSpcL1wvKHNlY3VyZVwucGF5emEpW14-XSs-XHMqPGltZ1tePl=rKT9zcmM9WyciXVtmaHRwc2w6XSpcL1wvKFw=fG9ubGluZS1zYWxlMjR8ZWFybm1vbmV5ZG98Z2NjYW5hZGF8ZzAwKVwuY28uKz9ccyo8XC9cMj5ccyopKy9pIjt9czo5MjoicGhwIHZhciBhcnJheSB2YXIgdGV4dCBpZiBmdW5jdGlvbl9leGlzdHMgZnVuY3Rpb24gZm9yZWFjaCBjaHIgcmV=dXJuIHZhcmlhYmxlIGZ1bmN=aW9uIHRleHQiO2E6Mjp7aTowO3M6NToiRzRSS3MiO2k6MTtzOjMwMzoiLzxcP1twaFxzXSsoXCRbYS16XzAtOV=rKFxzKlxbW15cXV=rXF=rKSpbXHNcLlwrXC1dKj1ccyooKGFycmF5XCh8XCRceyk_KChbJyJdKS4qP1w2fFwkW2Etel8wLTldKyhccypcW1teXF1dK1xdKykqKVtcLlwsXHNcKVx9XSopKztccyopKygoaWZccypcKFteXHtdK1x7XHMqKT9mdW5jdGlvblteXHtdK1x7LipyZXR1cm5bXjtdKjtbXHNcfV=rKSsoaWZccypcKFteXHtdK1x7XHMqKT8oZWNob3xwcmludHxkaWUpW1xzXChce1=rXCRbYS16XzAtOV=rKFxzKlxbW15cXV=rXF=rKSpccypcKFteO1=qO1tcc1x9XSsoJHxcPz5ccyopL2lzIjt9czozNjoiVGFnZ2VkIGVycm9yX3JlcG9ydGluZyBiYXNlNjRfZGVjb2RlIjthOjI6e2k6MDtzOjU6IkZBOUNiIjtpOjE7czoxODM6Ii8oXC9cKi4rP1wqXC98PFwhLS=uKz8tLT4pXHMqKGlmW1woIFwhXStkZWZpbmVkXChbXlwpXStbXCkgXHtdKy4qP2RlZmluZVwoLis_XCkrO1tcc1x9XSopKigoXEB8XCRbYS16XF8wLTldK1xzKltcLj1dKykqKGVycm9yX3JlcG9ydGluZ3xpbmlfc2V=fG9iX3N=YXJ=KVwoLis_KStiYXNlNjRfZGVjb2RlXCguKz9cMS9pcyI7fXM6NDM6IlRhZ2dlZCBjcmVhdGVFbGVtZW5=IHNjcmlwdCBzcmMgYXBwZW5kQ2hpbGQiO2E6Mjp7aTowO3M6NToiRTJHQnUiO2k6MTtzOjE1MjoiL1wvXCogWzAtOWEtel=rIFwqXC9bXHJcbiBcdF=qLisoW2EtejAtOV=rKVtcdCA9XWRvY3VtZW5=XC5jcmVhdGVFbGVtZW5=XChbJyJdUy4rP1wxXC5zcmNbXHQ9IF=rLis_XC5hcHBlbmRDaGlsZFwoXDFcKS4rP1tcclxuIFx=XSpcL1wqIFswLTlhLXpdKyBcKlwvL2kiO31zOjM3OiJQSFAgVmFycyBDb25jYXQgVmFyaWFibGUgRnVuY3Rpb24gRU5EIjthOjI6e2k6MDtzOjU6IkY1UkJXIjtpOjE7czoyNjQ6Ii88XD9bcGhcc1=rKFwkW2EtelxfMC=5XSsoXHMqXFtbXlxdXStcXSspKlxzKj1bXjtdKztccyopKygoXCRbYS16XF8wLTldKyhccypcW1teXF1dK1xdKykqXHMqPVxzKik_KFwkW2EtelxfMC=5XSsoXHMqXFtbXlxdXStcXSspKnxzdHJfcmVwbGFjZXxjcmVhdGVfZnVuY3Rpb24pXChbXjtdKztccyopKygoXCRbYS16XF8wLTldKyhccypcW1teXF1dK1xdKykqXHMqPVxzKik_XCRbYS16XF8wLTldKyhccypcW1teXF1dK1xdKykqXChbXjtdKztccyopKyhcPz58JCkvaSI7fXM6NjU6ImRpdiBzY3JpcHQgZG9jdW1lbnQgZ2V=RWxlbWVudEJ5SWQgdmlzaWJpbGl=eSBoaWRkZW4gZGlzcGxheSBub25lIjthOjI6e2k6MDtzOjU6IkY1SjdjIjtpOjE7czoyNDg6Ii88ZGl2IGlkPVsnIl=oW2EtelxfMC=5XSspWyciXS4rPzxcL2Rpdj5ccyo8c2NyaXB=W14-XSo-XHMqKChmdW5jdGlvblxzKD8haGlkZW1lc3NhZ2UpKFthLXpcXzAtOV=rKXxpZilbXHNcKF=rW15cKV=qW1wpXHNce1=qKT8oZG9jdW1lbnRcLmdldEVsZW1lbnRCeUlkXChbIiddXDFbIiddXClcLnN=eWxlXC4odmlzaWJpbGl=eXxkaXNwbGF5KVxzKj1ccypbIiddKGhpZGRlbnxub25lKVsiJ1=7XHMqKStbXHNcfV=qPFwvc2NyaXB=Pi9pIjt9czo=NzoiYWRkX2FjdGlvbiB3cF9mb29=ZXIgc2VydmUgZXhhbXBsZV9hZG1pbl9ub3RpY2UiO2E6Mjp7aTowO3M6NToiR=IzQ=wiO2k6MTtzOjE2MzoiLyhhZGRfYWN=aW9uXChccypbJyJdKHdwX2Zvb3Rlcnxpbml=fGFkbWluX25vdGljZXMpWyciXVssXHNdKyhcQD9jcmVhdGVfZnVuY3Rpb25bXHNcKF=rKT9bJyJdKC4rP2Jhc2U2NF9kZWNvZGUuKz98ZXhhbXBsZV9hZG1pbl9ub3RpY2V8c2VydmUpWyciXVtcc1wpXSs7XHMqKXsyLH=vaSI7fXM6NTE6IlBIUCBlcnJvcl9yZXBvcnRpbmcgaWYgIWlzc2V=IHZhcmlhYmxlIGZ1bmN=aW9uIEVORCI7YToyOntpOjA7czo1OiJHM=5NViI7aToxO3M6MTkxOiIvKChlcnJvcl9yZXBvcnRpbmdccypcKHxcJFthLXpfMC=5XStccyo9KVteO1=rO1xzKikqaWZccypcKC4rP1wpK1xzKlx7XHMqKChcJFthLXpfMC=5XSspXHMqPVteO1=rO1xzKikqKChcJFthLXpfMC=5XSspXHMqPStccyopP1w=XHMqXCguKz8oXCRbYS16XzAtOV=rXHMqPVxzKik_XDZccypcKFteXCldKlwpK1tccyciXCk7XSpcfS9pcyI7fXM6NjY6InNjcmlwdCBpZiBuYXZpZ2F=b3IgdXNlckFnZW5=IG1hdGNoIGRvY3VtZW5=IHdyaXRlIHNjcmlwdCBzcmMgaHR=cCI7YToyOntpOjA7czo1OiJFM1FDZCI7aToxO3M6MTQ=OiIvPHNjcmlwdD5bXHRcclxuIF=qaWZbXHQgXChdK25hdmlnYXRvclwudXNlckFnZW5=XC5tYXRjaFwoLis_XHtbXHRcclxuIF=qZG9jdW1lbnRcLndyaXRlXChbIiddPHNjci4rPyBzcmM9WyciXWh=dHAuKz9cKVs7XH=gXHRcclxyXSs8XC9zY3JpcHQ-L2kiO31zOjYxOiJwaHAgZnVuY3Rpb24gQXJyYXkgcmV=dXJuIGJhc2U2NF9kZWNvZGUgcGhwIFZhcmlhYmxlIGZ1bmN=aW9uIjthOjI6e2k6MDtzOjU6IkczSUFhIjtpOjE7czoyMzk6Ii8oZnVuY3Rpb25ccysoW2Etel8wLTldKylccypcKFxzKihcJFthLXpfMC=5XSspW1wpXHNce1=rXDNbPVxzXStnemluZmxhdGVcKGJhc2U2NF9kZWNvZGVcKC4rW1wpO1xzXSspP2ZvclxzKlwoW15ce1=rXHtccyooXCRbYS16XzAtOV=rKShccypcW1teXF1dK1xdKykqW1wuXHNdKj1bXEBcc1=qY2hyXChbXjtdK1s7XHNcfV=rKHJldHVyblteO1=qWztcfVxzXSspP2V2YWxcKChcMlwofFw=KVteXCldKltcKVxzXSs7Ki9pIjt9czoyNToiaW5jbHVkZV9vbmNlIHJzcy1pbmZvLnBocCI7YToyOntpOjA7czo1OiJHMzJJQSI7aToxO3M6MTQ5OiIvKChcJFthLXpfMC=5XSspXHMqPS4rP1wuKGpzfHBuZ3xnaWYpWyciXTtccyooaWZbXHNcKF=rfGlzX3xmaWxlfF9leGlzdHMpezMsfVtcKFxzXStcMltcKVxzXSspP1xAP2luY2x1ZGVfb25jZVwoWyciXHNdKihcMi4qP3xyc3MtaW5mb1wucGhwWyciXSlcKTsvaSI7fXM6MjE6ImlzX2JvdCBfX3ZpYV9jb25=ZW5=KSI7YToyOntpOjA7czo1OiJHOU1CViI7aToxO3M6Mjg3OiIvKHZhclxzKyhbYS16XzAtOV=rKVxzKj1bXjtdKztccyopKihmdW5jdGlvblxzKyhbXlwoXSpjb29raWVbXlwoXSp8W2EtejAtOV17NDF9KVwoW15ce1=qXHsuKj8oKGRvY3VtZW5=LmNvb2tpZVteO1=rKDtccypbJyJdKT98cmV=dXJufGlmXHMqXChkb2N1bWVudFwucmVmZXJyZXJbXlx7XStce1xzKlwyXHMqPSlbXjtdKjtccyooXH1ccyopKykrKXs1LH=oXCgqZnVuY3Rpb25ccyooW1woXCldK3xbYS16MC=5XXs=MX1cKFteXHtdKilccypcey4qP1wpO1xzKlx9W1wpXHNdKlwxMFxzKjtccyopezIsfS9pcyI7fXM6NDE6InNldCB2YXIgc3RyX3JlcGxhY2UgdmFyIHZhcmlhYmxlIGZ1bmN=aW9uIjthOjI6e2k6MDtzOjU6IkY3TUM3IjtpOjE7czozMTc6Ii8oKFwkW2EtelxfMC=5XSsoXHMqXFtbXlxdXStcXSkqKVxzKj1ccypcQD9cJFthLXpcXzAtOV=rKFxzKlxbW15cXV=rXF=rKSpccypcKFxAP1wkXyhSRVFVRVNUfEdFVHxQT1NUfENPT=tJRSkoXHMqXFtbXlxdXStcXSspKlwpO1xzKikrKFwkW2EtelxfMC=5XSt8cHJlZ19yZXBsYWNlKVxzKlwoXHMqKFsnIl=pKFtcIVwvXCNcfFxAXCVcXlwqXH5dKS4rP1w5W2ltc3hdKmVbaW1zeF=qXDhccyosXHMqXDJccyosKChbXCRhLXpcXzAtOV=rKFxzKlxbW15cXV=rXF=pKnwnW14nXSonfCJbXiJdKiIpW1wuXHNdKikrXCkrO1xzKihkaWVcKFteXCldKlwpKzspPy9pIjt9czo2NDoiVGFnZ2VkIGVycm9yX3JlcG9ydGluZyBjdXJsX2luaXQgZmlsZV9nZXRfY29udGVudHMgZndyaXRlIHNjcmlwdCI7YToyOntpOjA7czo1OiJHNUhFNSI7aToxO3M6NDgxOiIvPFw_W3BoXHNdKyhbXEBcL1wjXHNdKihlcnJvcl9yZXBvcnRpbmd8aW5pX3NldHxzZXRfdGltZV9saW1pdHxoZWFkZXIpXHMqXChbXlwpXSpbXCk7XHNdKykqKChbO1xzXSooXCRbYS16XzAtOV=rXHMqPVteO1=rO1xzKnxlbHNlW1xzXHtdKikqaWZccypcKFteO1=rKSsoKGZpbGVfZ2V=X2NvbnRlbnRzXHMqXCh8bWtkaXJccypcKHxjdXJsX1thLXpdK1xzKlwofGRpZVxzKlwofChlY2hvfHByaW5=KVteO1=rO1xzKihyZXR1cm58ZXhpdCkpW15cfV=rXH1ccyopKykrKGVsc2VbXHNce1=qKT8oXCRbYS16XzAtOV=rXHMqPVxzKmZpbGVfZ2V=X2NvbnRlbnRzXChbXjtdKztbXH1cc1=qKSooXC8qKFwkW2Etel8wLTldK1xzKj=pP1tcQFxzXSooZm9wZW58ZndyaXRlfGZjbG9zZSlccypcKFteO1=rO1xzKil7Myx9KChoZWFkZXJ8ZWNob3xwcmludHxpZlxzKlwoW15ce1=rW1x7XHNdKmNobW9kXHMqXCgpW147XSo7W1x9XHNdKykrKCR8XD8-XHMqKS9pIjt9czo3MDoiZmlsZV9leGlzdHMgY3VybF9pbml=IGZpbGVfZ2V=X2NvbnRlbnRzIGZpbGVfcHV=X2NvbnRlbnRzIGluY2x1ZGVfb25jZSI7YToyOntpOjA7czo1OiJIMTU5NiI7aToxO3M6MjMyOiIvKFwkW2Etel8wLTldKylccyo9XHMqLis_KGN1cmxfaW5pdHxmaWxlX2dldF9jb25=ZW5=c1woW1xzJyJdK2h=dHBbc1w6XC9dKykuKz9maWxlX3B1dF9jb25=ZW5=c1woXDEuKz8oaW5jbHVkZV9vbmNlfChcJFthLXpfMC=5XSspXHMqPVxzKm5ld1xzK1thLXpfMC=5XSspXChcMS4qP1wpO1xzKiguKlw=W147XSo7XHMqfFx9XHMqfGVsc2Vccyp8XHtccyp8ZGllW1xzXCgnIl=rW15cKV=qXCkrO1xzKikqL2lzIjt9czozODoibG9uZyBzdHJpbmcgdmFyIGV2YWwgdmFyaWFibGUgZnVuY3Rpb24iO2E6Mjp7aTowO3M6NToiSDI=RmoiO2k6MTtzOjQyNzoiLzwoXD98c2NyaXB=IGxhbmd1YWdlPSlbcGhccyciPl=rKFwkW2Etel8wLTldKyhccypcW1teXF1dK1xdKykqW1xzXC5dKj1ccyooKFsnIl=pW15cNV=rXDV8W147XSspO1xzKnxcL1wvLipccyp8XC9cKlteXCpdKihcKlteXCpcL1=qKStcL1xzKnxmb3IoZWFjaCk_W1xzXChdK1teXHtdK1x7W15cfV=rXH=rW1x9XHNdKykrKFw_PlxzKjxcP1twaFxzXSspKigoKGV2YWx8aWYoW1xzXChcIVxAXStbYS16XzAtOV=rKT8pXHMqXCgpKihcJFtcJFx7XSpbYS16XzAtOV=rW1x9XHNcKV=qKFxbW15cXV=rXF1ccyp8PStccyooXCRbYS16XzAtOV=rfGNyZWF=ZV9mdW5jdGlvbikpKltcKVxzXHs7XH1dKikrXCguKj9bXClcc1x9O1=rKSsoZWNob1teO1=rO1xzKnxcL1wqW15cKl=qKFwqW15cKlwvXSopK1wvXHMqKSooXD8-KC4rJCk_fCR8PFwvc2NyaXB=PikvaSI7fXM6NDE6InBocCB2YXIgZXhwbG9kZSBudW1iZXJzIFZhcmlhYmxlIGZ1bmN=aW9uIjthOjI6e2k6MDtzOjU6IkgyNEZsIjtpOjE7czoyMTg6Ii88XD9bcGhcc1=rKGlmXHMqXCgoW15ce1=rW1x7XHNdKlwkR=xPQkFMU1tce1xbXVsnIl1cXHhbXjtdKztbXH1cc1=qKSsoXD8-XHMqPFw_W3BoXHNdKykpP1wkW2Etel8wLTldK1xzKj1ccyooJy4rPyd8Ii4rPyIpO1xzKi4qP1xzKlwkW2Etel8wLTldK1xzKj1ccypleHBsb2RlXChbXixdK1ssIidcLjAtOVxzXStcKTtccyouKj9cJFthLXpfMC=5XStccypcKC4qP1w_PiguKyQpPy9pIjt9czo5MzoiZnVuY3Rpb24gWCBpZiBmdW5jdGlvbl9leGlzdHMgY3VybF9pbml=IHNwYW1jaGVja3IuY29tIGN1cmxfZXhlYyBjdXJsX2Nsb3NlIGVjaG8gYWRkX2FjdGlvbiBYIjthOjI6e2k6MDtzOjU6Ikc1TDg4IjtpOjE7czo1MzY6Ii8oXC9cKi4qP1wqXC9ccyopKihcPz5ccyo8XD9bcGhcc1=qKT8oaWZccypcKFteXHtdK1x7XHMqZnVuY3Rpb25ccysoW2Etel8wLTldKylcKFteXHtdK1x7XHMqKT9pZltcc1woXCFdK2Z1bmN=aW9uX2V4aXN=c1woXHMqWyciXShbYS16XzAtOV=rKVsnIl1bXHNcKV=rXHtccyooKGZ1bmN=aW9uXHMrXDVcKCk_Lis_KHNwYW1jaGVja3JcLmNvbXxqYXZhdGVybTFcLnB3fFsnIl1qcXVlcnlcLikuKz9jdXJsX2luaXQuKz9jdXJsX2V4ZWMuKz9jdXJsX2Nsb3NlW147XStbO1xzXStlY2hvfGZ1bmN=aW9uXHMrXDVccypcKFteXCldKltcKVxzXStce1xzKihcJFthLXpfMC=5XStccyo9W147XStbO1xzXSspKihpZltcc1woXStcQD8oXCR8Zm9wZW5bXHNcKF=rKVteXHtdK1tce1xzXSopP2VjaG9cKHdwX3JlbW9=ZV9yZXRyaWV2ZV9ib2R5XCh3cF9yZW1vdGVfZ2V=XCgpW147XSs7W1xzXH1dKyhhZGRfYWN=aW9uW15cLF=rXCxccypbJyJdKFw1fFw=KVsnIl1bXHNcKTtdK1x9KT8oXHMqXD8-XHMqPFw_W3BoXSopPyhccypcL1wqLio_XCpcLykqL2lzIjt9czo5NjoiaWYgZnVuY3Rpb25fZXhpc3RzIGZ1bmN=aW9uIGVycm9yX3JlcG9ydGluZyBWYXJpYWJsZSB4RkYgSCogaWYgZmlsZV9leGlzdHMgZXJyb3JfcmVwb3J=aW5nIGVuZGlmIjthOjI6e2k6MDtzOjU6IkU5MkdwIjtpOjE7czoyNzA6Ii9pZlsgXChcIV=rZnVuY3Rpb25fZXhpc3RzXChbICciXSsoLis_KVsgJyJdK1tcKSBcdF=rXDouKz9mdW5jdGlvbiBcMVwoXCkgXHsuKz9lcnJvcl9yZXBvcnRpbmdcKDAuKz8oXCQoW2EtejAtOVxfXSspWyA9XHRdKyIoXFx4WzAtZl17Mn=pKyI7W1x=IFxyXG5dKyhcJChbYS16MC=5XF9dKylbID1cdF=rXCQoW2EtejAtOVxfXSspXCgiSFwqIlwsLis_O1tcdCBcclxuXSspKykraWZbIFwoXCFdK2ZpbGVfZXhpc3RzLis_ZXJyb3JfcmVwb3J=aW5nXChcJC4rP2VuZGlmOy9pcyI7fXM6MTc6ImluY2x1ZGUgSW1hZ2VGaWxlIjthOjI6e2k6MDtzOjU6IkgxMkoxIjtpOjE7czoyNTY6Ii8oPzwhXC9cL1xzezh9KVxAPyhpbmNsdWRlfHJlcXVpcmUpKF9vbmNlKT9bXChcc1=rW2Etel8wLTksXC4nXHMiXC9cLV=rPyg_PCFHRF9TWVNURU1fUExVR=lOX=RJUiBcLiAnXC9pbWFnZXNcLzQwNCkoXC4oZ2lmfGpwZ3xwbmd8Y2J1fGNzc3xbXHMiJ1=rXC93cC1pbmNsdWRlc1wvaW5pdFwucGhwfFtccyInXStcL3dwLWFkbWluXC9pbmNsdWRlc1wvY2xhc3Mtd3AtaXRlcm5hbC11cGdyYWRlXC5waHApfHdwLWphdmFcLnBocClbIidcc1wpXSs7L2kiO31zOjQxOiIvZnVuY3Rpb24gYXJyYXkgVmFyaWFibGUgRnVuY3Rpb24gaWYgZXZhbCI7YToyOntpOjA7czo1OiJHMk5OQyI7aToxO3M6MzU2OiIvKFwvXCpbXlwqXSooXCpbXlwqXC9dKikrXC9ccyopKigoXCRbX1wtPlwuYS16MC=5XSspXHMqPVteO1=rO1xzKihbYS16XzAtOV=rKVwoW15cKV=qXDRbXlwpXSpbXClccztdK1xzKmZ1bmN=aW9uXHMqXDV8ZnVuY3Rpb25ccypbYS16XzAtOV=rKVxzKlwoW15ce1=rXHtccyooXCRbX1wtPlwuYS16MC=5XSspXHMqKFxbW15cXV=rXF=rXHMqKSo9XHMqYXJyYXkoX21hcCk_XHMqXCguKz9cKTtccyooXCRbX1wuYS16MC=5XFsnIlxdXHNdKyg9W147XSpcNlteO1=qO1xzKnxcKC4rP2lmW1xzXChdKlwkW19cLmEtejAtOVxbJyJcXVxzXStcKVxzKlx7KSkrXHMqKHJldHVyblxzKik_ZXZhbFxzKlwoW15cKV=rW1wpXHM7XH1dKy9pcyI7fXM6NDM6IlRhZ2dlZCBlcnJvcl9yZXBvcnRpbmcgSFRUUF9VU=VSX=FHRU5UIGN1cmwiO2E6Mjp7aTowO3M6NToiRzNON2ciO2k6MTtzOjIyMDoiLyhlcnJvcl9yZXBvcnRpbmdccypcKFteO1=rO1xzKnxcJFthLXpfMC=5XStccyo9XHMqYXJyYXlccypcKFteXCldK1wpK1s7XClcc1=qKSppZlxzKlwoW15cKV=rSFRUUF9VU=VSX=FHRU5UKC4rP2h=dHA6XC9cL3wuKz9jdXJsX2luaXQpezIsfS4rPyhcJFthLXpfMC=5XSspP1tccz1dKmN1cmxfZXhlYy4rPyhwcmludHxkaWV8ZWNobylbJyJcc1woXStcM1snIlxzXCk7XH1dK1xzKi9pcyI7fXM6MzA6ImhlYWRlciBMb2NhdGlvbiBodHRwIHNwYWNlLnBocCI7YToyOntpOjA7czo1OiJFOTlEcCI7aToxO3M6NjM6Ii9oZWFkZXJcKFsnIl1Mb2NhdGlvbjogaHR=cDpcL1wvW15cL1=rXC9zcGFjZVwucGhwXD9bXlwpXStcKTsvaSI7fXM6NTA6IkNvcHlyaWdodCBmdW5jdGlvbiBnZXRDb29raWUgZG9jdW1lbnQud3JpdGUgaWZyYW1lIjthOjI6e2k6MDtzOjU6IkY5VUF4IjtpOjE7czo5MToiLyhcL1wqLis_XCpcLylccypmdW5jdGlvblxzKyhbYS16XzAtOV=rKVwoLis_bmF2aWdhdG9yXC51c2VyQWdlbnQuKz88aWZyYW1lIC4rP1wyXCguKz9cMS9pcyI7fXM6Mzc6IkNvcHlyaWdodCBmdW5jdGlvbiBzZXRDb29raWUgZnVuY3Rpb24iO2E6Mjp7aTowO3M6NToiRjFDRm8iO2k6MTtzOjE5NzoiL1wvXCpccypDb3B5cmlnaHQuK1xzKlwqXC9ccyooZnVuY3Rpb24gW3NnXWV=Q29va2llXCguKz9yZXR1cm5bXjtdKls7XH1cc1=rKSpmdW5jdGlvbiAoW2EtejAtOVxfXSspXChcKVtce1xzXSsoW2EtejAtOVxzXD1dK25hdmlnYXRvclwudXNlckFnZW5=Lis_fGZ1bmN=aW9uXHMrKVtzZ11ldENvb2tpZVwoLis_XDJcKFteO1=rWztcfVxzXSsvaXMiO31zOjIxOiJwaHAgaGV4LWVuY29kZWQtbGluZXMiO2E6Mjp7aTowO3M6NToiRjE=SGsiO2k6MTtzOjYwOiIvPFw_W3BoXHNdKyhbXjtdKlx4WzAtOWEtZl17Mn1bXjtdKls7XHNdKyl7OSx9LipccyooXD8-fCQpL2kiO31zOjM1OiJwaHAgYXJyYXkgaHR=cCBtdF9yYW5kIG1ldGEgcmVmcmVzaCI7YToyOntpOjA7czo1OiJFQTJEdiI7aToxO3M6MjAzOiIvPFw_KHBocCk_W1xyXG4gXHRdKlwkW2EtelxfMC=5XStbXHQgPV=rYXJyYXlbIFwoXHJcblx=XSsoWyciXWh=dHAuK1ssIFwpO1xyXG5cdF=rKStcJFthLXpcXzAtOV=rW1x=ID1dK21=X3JhbmRcKC4rWyBcKTtcclxuXHRdKyhcJFthLXpcXzAtOV=rW1x=ID1dKy4rW1xyXG4gXHRdKikrXD8-WyBcclxuXHRdKjxtZXRhICguKz88XD8uKz9cPz4pKi4qPz4vaSI7fXM6NDQ6InBocCBhcnJheSBmdW5jdGlvbiByZXR1cm4gYmFzZTY=X2RlY29kZSBldmFsIjthOjI6e2k6MDtzOjU6IkY3UTBEIjtpOjE7czoyMjU6Ii88XD9bcGhcc1=rXCRbX1wtXD5cLmEtejAtOVx7XFsnIlxdXH1dK1xzKj1ccyphcnJheVwoLis_ZnVuY3Rpb25ccysoW2Etel8wLTldKylcKCguKz87XHMqKSsoKFwkW2Etel8wLTldK1xzKj1ccyopPyhldmFsfFwkW2Etel8wLTldKyhccypcW1teXF1dK1xdKSopXHMqXChccyooXCRfKFJFUVVFU3xHRXxQT1MpVFxbKT9bXlwpXStbXCk7XHNdKyhleGl=fGRpZSlbXjtdKjtccyopKygkfFw_PikvaSI7fXM6NTY6InBocCBpZiBpc3NldCBHTE9CQUxTIHN=cnRvbG93ZXIgU=VSVkVSIGlmIHN=cnN=ciBHTE9CQUxTIjthOjI6e2k6MDtzOjU6IkVBQUVkIjtpOjE7czoyNDE6Ii88XD9bcGhdKlxzK2lmW1woXHNdK1whaXNzZXRbXChcc1=rXCRHTE9CQUxTXFsiXFx4W15cXV=rW1xdXClcc1x7XSsoXCRbYS16XzAtOV=rKVtccz1dK3N=cnRvbG93ZXJbXChcc1=rXCRfU=VSVkVSXFsiXFx4W15cXV=rW1xdXCk7XHNdKygoaWZ8YW5kKVtcKFxzXCFdK3N=cnN=cltcKFxzXStcMVtccywiJ1=rXFx4W15cKV=rW1wpXHNce1=rKStcJEdMT=JBTFNcWyJcXHhbXlxdXStcXVteO1=qO1tcfVxzXSsoXD8-fCQpL2kiO31zOjQyOiJmdW5jdGlvbiByZXR1cm4gZnVuY3Rpb24gVmFyaWFibGUgZnVuY3Rpb24iO2E6Mjp7aTowO3M6NToiRUFLQUIiO2k6MTtzOjIwMjoiLyhmdW5jdGlvblthLXpfMC=5XHNdK1woW15cKV=qW1wpXHNdK1x7XHMqcmV=dXJuW2Etel8wLTlcc1=rXChbXlwpXSpbXClcc1=rOypcfStccyopKyhcJFthLXpfMC=5XStbPVxzXSsoW2Etel8wLTlcc1=rXChbXlwpXSpbXClcc1=rfFsnIl1bXjtdKik7K1xzKikrKFwkW2Etel8wLTldKylbPVxzXStbXjtdK1snIlwpO1=rXHMqXDRccypcKCsuKj9cKTsvaSI7fXM6MTc6ImV2YWwgY2hyIFJFUEVBVEVEIjthOjI6e2k6MDtzOjU6Ikc1Qk5hIjtpOjE7czoyMTI6Ii8oPFw_W3BoXSp8XC9cKlteXCpdKlwqXC8pXHMqKChcJFthLXpfMC=5XSspXHMqPVxzKicpPyguKz9cLlxzKmNoclwoWzAtOV=rXClccypcLil7MjB9LitccyooXDNccyo9XHMqc3RyX3JlcGxhY2VcKCdcI1snLFxzXStcM1wpO1xzKik_KChcJFthLXpfMC=5XSspXHMqPVxzKmNyZWF=ZV9mdW5jdGlvblwoWydccyxdKlwzXCk7XHMqXDdcKFwpOyk_KFw_PlxzKnwkfFwxKS9pIjt9czozNjoiZ2FyYmFnZSBhcm91bmQgZXZhbCBWZXJpYWJsZUZ1bmN=aW9uIjthOjI6e2k6MDtzOjU6Ikc1TjZiIjtpOjE7czoyNDg6Ii88XD9bcGhcc1=rKFwkW2Etel8wLTldK1tcc1wuXSo9KFtcc1wuXSooKFsiJ1=pLis_KD88IV9lKVw=fFwvXCpbXlwqXSooXCpbXlwqXC9dKikrXC98XCRbXCRce1=qW2Etel8wLTldKltcfVxzXSooXFtbXlxdXStcXStccyopKikpKztccyopKygoZXZhbHxpZilccypcKCk_XCRbXCRce1=qW2Etel8wLTldK1tcfVxzXSooXFtbXlxdXStcXVtcc1=qKSpcKC4qPyguKydbXC47XCldKyk_KFxzKicuKydbXC47XCldKykqXHMqKFw_PnwkKS9pIjt9czo1NjoiaWYgZGVmaW5lZCBkZWZpbmUgZnVuY3Rpb24gZ2xvYmFsIGV2YWwgVmFyaWFibGUgRnVuY3Rpb24iO2E6Mjp7aTowO3M6NToiRzFITGYiO2k6MTtzOjE5NzoiL2lmW1woXHNdK1whZGVmaW5lZFwoW15cKV=rW1wpXHNdK1x7XHMqZGVmaW5lXChbXlwpXStbXClcc1=rO1xzKmZ1bmN=aW9uW15cKF=qXChbXlwpXSpbXClcc1=rXHtccypnbG9iYWwgKFwkW147XSspO1xzKiguKz9ccyopK2V2YWxcKFwxKFxbW15cXV=rXF1ccyopKlwoW15cKV=qW1wpXHNdKzsoXHMqcmV=dXJuW147XSo7KT9ccypcfVxzKlx9L2kiO31zOjI1OiJpZnJhbWUgc21hbGwgaGVpZ2h=fHdpZHRoIjthOjI6e2k6MDtzOjU6IkczUzhmIjtpOjE7czoxNTM6Ii8oPHNjcmlwdFtePl=rc3JjPVsnIl=_aHR=cFw6XC9cLyhbYS16XC5cLTAtOV=rKVtePl=qPjxcL3NjcmlwdD4pPzxpZnJhbWUuKj8oXHMqKGhlaWdodHx3aWR=aHxzcmMpPVsnIl=_KFswLTVdWyciXHNdfGh=dHBcOlwvXC8uKz8pKXszfVtePl=qPjxcL2lmcmFtZT4vaSI7fXM6NDk6InBocCBnbG9iYWwgYXJyYXkgZnVuY3Rpb25fZXhpc3RzIHJldHVybiBmb3IgdW5zZXQiO2E6Mjp7aTowO3M6NToiRUM4MU8iO2k6MTtzOjI2MToiL2dsb2JhbCAoXCRbYS16MC=5XF9dKyk7XHMqXDFbXHM9XSthcnJheVwoLis_ZnVuY3Rpb25fZXhpc3RzXChbXlwpXStbXClcc1wmXStcIWZ1bmN=aW9uX2V4aXN=c1woWyciXShbYS16MC=5XF9dKylbJyJdW1wpXHNce1=rZnVuY3Rpb25ccytcMlwoW15cKV=rW1wpXHNce1=rZ2xvYmFsIFwxOy4rP3JldHVyblteO1=qWztcc1x9XStmb3JccypcKFteXCldKltcKTtcfV=rKFx7XHMqW1wkYS16MC=5XF9dK1woW15cKV=rW1wpO1x9XSspP3Vuc2V=XChcMVwpOy9pIjt9czoxMzoiZXZhbCBwYWNrIEhleCI7YToyOntpOjA7czo1OiJGOFREbyI7aToxO3M6MzI1OiIvKFwvXCouKj9cKlwvXHMqfFwkW2Etel8wLTlcWyciXF1cc1=rPVxzKihbJyJdKS4qP1wyO1xzKikqKGlmW1xzXChcIV=rZnVuY3Rpb25fZXhpc3RzW1woXHNdKyhbJyJdKShbYS16XzAtOV=rKVw=W1wpXHNdK1x7XHMqKT8oZnVuY3Rpb25ccysoW2Etel8wLTldKylcKFteXCldKltcKVxzXStce1teXH1dK3BhY2tcKFsnIl1IXCpbJyIsXHNcLjAtOUEtRl=rW1wpO1xzXStyZXR1cm5bXjtdKls7XHNdK1x9Wztcc1=rKT9ldmFsXCgoXDVcKFteXCldKltcKTtcc1x9XSt8XDdcKFteXCldKltcKTtcc1=rfHBhY2tcKFsnIl1IXCpbJyIsXHNcLjAtOUEtRl=rW1wpO1xzXSspL2lzIjt9czo=NzoicGhwIEhUVFBfVVNFUl9BR=VOVCBpZiBoZWFkZXIgTG9jYXRpb24gaHR=cCAucnUiO2E6Mjp7aTowO3M6NToiRzMxTFIiO2k6MTtzOjMxMDoiLzxcP1twaFxzXSooXCRbYS16XzAtOV=rKVxzKj1ccyooYXJyYXlcKFteXCldK1wucnVbJyJdXCkrO1xzKihcJFthLXpfMC=5XSspXHMqPVxzKlwxXFsuKztccyooXCRbYS16XzAtOV=rKVxzKj1bXHNcKF=qcHJlZ19tYXRjaFxzKnxcJF9TRVJWRVJcW1siJ11IVFRQX1VTRVJfQUdFTlRbJyJdXF=7XHMqaWZbXHNcKF=rW1wkYS16XzAtOV=rKVwoLiooXDN8XDEpLipbXClcc1x7XStoZWFkZXJcKFsnIl1Mb2NhdGlvbjpccyooaHR=cDpcL1wvLitcLnJ1XC8uKnxbJyJcLlxzXSt8XDF8XDN8XDQpK1wpO1tcc2RpZVwoXCk7XH1dKihcPz5ccyp8JCkvaSI7fXM6ODQ6InJlcXVpcmVfb25jZSB3cC11cGRhdGUucGhwIFJFTU9URV9BRERSIEhUVFBfVVNFUl9BR=VOVCByZXF1aXJlX29uY2Ugd3AtY2xhc3MucGhwIGRpZSI7YToyOntpOjA7czo1OiJGM=tHciI7aToxO3M6MTk2OiIvPFw_Lis_cmVxdWlyZV9vbmNlW1xzXCgiJ1=rd3AtdXBkYXRlXC5waHBbIidcKTtcc1=rXCRpcCA9IFwkX1NFUlZFUlxbWyInXVJFTU9URV9BRERSWyInXVxdOy4rP1wkX1NFUlZFUlxbWyInXUhUVFBfVVNFUl9BR=VOVFsiJ11cXS4rP3JlcXVpcmVfb25jZVtcc1woIiddK3dwLWNsYXNzXC5waHBbIidcKTtcc1=rZGllXCguKz8oJHxcPz4pL2lzIjt9czozNjoiZXZhbCBkZWNvZGVVUklDb21wb25lbnQgRW5jb2RlZC1=ZXh=IjthOjI6e2k6MDtzOjU6IkYxMTRnIjtpOjE7czoxMTU6Ii8oXC9cKlxzKmh=dHA6XC9cL3d3dy5KU=9OLm9yZ1wvanNvbjJcLmpzLis_KT9ldmFsW1xzXChdK2RlY29kZVVSSUNvbXBvbmVudFtcc1woXStbIiddXCVbXCUwLTlhLXpdK1snIl1bXCk7XHNdKzsvaXMiO31zOjg2OiJmdW5jdGlvbnMgQkROIFNWQiBTQ2sgR=NrIGlmIGNvb2tpZUVuYWJsZWQgR=NrIGVsc2UgU=NrIGlmIGxvYWRlZCBTVkIgYWRkRXZlbnRMaXN=ZW5lciI7YToyOntpOjA7czo1OiJFQ=ZHWiI7aToxO3M6NDMwOiIvZnVuY3Rpb24gQkROXCguKz9mdW5jdGlvbiBTVkJcKC4rP2Z1bmN=aW9uIFNDa1woLis_ZnVuY3Rpb24gR=NrXCguKz9yZXR1cm4gdW5lc2NhcGVcKGRvY3VtZW5=XC5jb29raWVcLnN1YnN=cmluZ1woW15cKV=rW1wpO1xzXH1dK2lmW1xzXChdK25hdmlnYXRvclwuY29va2llRW5hYmxlZFtcKVxzXHtdK2lmW1xzXChcIV=rR=NrXChbXlx7XStce1tcfWVsc2Vce1xzXSpTQ2tcKFteXCldK1tcKTtcc1=raWZbXHNcKF=rZG9jdW1lbnRcLmxvYWRlZFtcKVx7XHNdK1NWQlwoW15cKV=qW1wpO1xzXH1dK2Vsc2VbXHtcc1=raWZbXHNcKF=rd2luZG93XC5hZGRFdmVudExpc3RlbmVyW1wpXHtcc1=rd2luZG93XC5hZGRFdmVudExpc3RlbmVyXChbXlwpXStbXCk7XHNcfV=rZWxzZVtce1xzXSt3aW5kb3dcLmF=dGFjaEV2ZW5=XChbXlwpXStbXCk7XHNcfV=rL2lzIjt9czoxODoiZGl2IHN=eWxlIG9wYWNpdHkwIjthOjI6e2k6MDtzOjU6IkYzOElNIjtpOjE7czo5MzoiL1xzKjxkaXYgc3R5bGU9WyciXVtePl=qb3BhY2l=eVxzKi5ccyowKFteXC5dfFwuWzAtMV=pW14-XSo-XHMqKDxhIC4rPzxcL2E-XHMqKSsuKz88XC9kaXY-L2lzIjt9czo=NDoicGhwIGVycm9yX3JlcG9ydGluZyBMb25nIG1haWwgcHJpbnRfciBTRVJWRVIiO2E6Mjp7aTowO3M6NToiSDIyTUYiO2k6MTtzOjMxNToiLzxcP1twaFxzXSooZXJyb3JfcmVwb3J=aW5nXCguezk5OTksfXwoXCRbYS16XzAtOV=rXHMqPVxzKigxfFwkXyhSRVFVRVN8R=V8UE9TKVQoXHMqXFtbXlxdXStcXSspKyk7XHMqKSsoaWZccypcKFteXCldK1tcKVxzXHtdK2RpZVtcc1woXStbXjtdKztbXHNcfV=qKStpZlxzKlwoW15cKV=rW1wpXHNce1=rd2hpbGVccypcKFteXCldK1tcKVxzXHtdKyltYWlsXHMqXCguKyhwcmludF9yXChcJF9TRVJWRVIuK3xccyplY2hvLitccypcJFthLXpfMC=5XCs7XStbXH1cc1=qKShcPz4oKFxzKltcWzxdaHRtbFtcXT5dKXsyfVteJF=rPFwvaHRtbD4pP3wkKS9pIjt9czo2NzoiaWYgIWZ1bmN=aW9uX2V4aXN=cyBmdW5jdGlvbiBjdXJsIHJldHVybiBmdW5jdGlvbiBpbmNsdWRlIGZ1bmN=aW9ucyI7YToyOntpOjA7czo1OiJFQ==yNCI7aToxO3M6Mjg3OiIvaWZccypcKFxzKlwhZnVuY3Rpb25fZXhpc3RzXChbIiddKFthLXpfMC=5XSspWyciXVwpW1wpXHNce1=qZnVuY3Rpb25ccypcMVwoW15cKV=rXClbXClcc1x7XSsoW15cbl=qY3VybF9bXlxuXStccyspK3JldHVyblteXG5dK1tccytcfV=rZnVuY3Rpb25ccypbYS16XzAtOV=rXChbXlwpXSpcKVtcKVxzXHtdKygoXCRbYS16XzAtOV=rKVxzKj1ccyooW2Etel8wLTldKylcKFteXG5dK1xzKykraW5jbHVkZVtcKFxzXStcNC4rP2Z1bmN=aW9uXHMrXDUuKz8oJHwoPz1mdW5jdGlvbiApfCg_PVw_XD4pKS9pcyI7fXM6NTk6ImlmICFjdXJyZW5=X3VzZXJfY2FuIGFkZF9maWx=ZXIgZnVuY3Rpb24gYSBocmVmIGh=dHAgcmV=dXJuIjthOjI6e2k6MDtzOjU6IkVDTTNSIjtpOjE7czoyNjU6Ii9pZlxzKlwoXHMqXCFjdXJyZW5=X3VzZXJfY2FuXChbXlwpXStbXClcc1x7XSphZGRfZmlsdGVyW1xzKlwoXStbXixdKyxccypbIiddKFthLXpfMC=5XSspWyciXVwpW1wpO1xzXH1dK2Z1bmN=aW9uXHMqXDFcKC4rP2FkZF9maWx=ZXJbXHMqXChdK1teLF=rLFxzKlsiJ1=oW2Etel8wLTldKylbJyJdXClbXCk7XHNcfV=rLityZXR1cm5bXjtdKls7XHNcfV=rZnVuY3Rpb25ccypcMlwoLis_PGEgaHJlZj1bJyJdaHR=cDpcL1wvLityZXR1cm5bXjtdKls7XHNcfV=rL2kiO31zOjU5OiJwaHAgQXJyYXkgZnVuY3Rpb24gcmV=dXJuIGJhc2U2NF9kZWNvZGUgZXZhbCBGdW5jdGlvbiBBcnJheSI7YToyOntpOjA7czo1OiJFQ=41dCI7aToxO3M6MTgzOiIvPFw_W3BoXHNdKyhcJFthLXpcXzAtOV=rXHMqPVteO1=rWztcc1=rKSooXCRbXCRce1=qW2EtelxfMC=5XStcfSooXHMqXFtbXlxdXStcXSkqKVxzKj1ccyphcnJheS4rP2Z1bmN=aW9uIChbYS16XF8wLTldKykuKz9yZXR1cm4gYmFzZTY=X2RlY29kZS4rP2V2YWxcKFxzKlw=W147XStcMlteO1=rWztcc1x9XD8-XSsvaXMiO31zOjM4OiJwaHAgVmFyIEFycmF5IENvbmNhdCBWYXJpYWJsZSBGdW5jdGlvbiI7YToyOntpOjA7czo1OiJHNU43TyI7aToxO3M6MjM1OiIvPFw_W3BoXHNdKyhcL1wvLipbXHNdKykqKChcJFthLXpfMC=5XSspXHMqPVxzKigoJ1teJ1=qKD88IV9lKSd8IlteIl=qInxcJFthLXpfMC=5XSspW1xzXC5dKikrW147XSo7XHMqKSs_KFxAP1wkKFtcJFx7XSpbYS16XzAtOV=rXH=qKFxzKlxbW15cXV=rXF=pKlxzKj1bXHNcQD9cJFx7XSpcJCk_W1wkXHtdKlthLXpfMC=5XStcfSooXHMqXFtbXlxdXStcXSkqXHMqXChbXjtdKztccyopKy4qXHMqKCR8XD8-KS9pIjt9czo2MzoicGhwIGFycmF5IGltcGxvZGUgZnVuY3Rpb24gVmFyIEhleCByZXR1cm4gVmFyaWFibGVGdW5jdGlvbiBldmFsIjthOjI6e2k6MDtzOjU6IkVDUEQyIjtpOjE7czoyODQ6Ii88XD9bcGhcc1=rKFwkW2EtelxfMC=5XSspXHMqPVxzKmFycmF5W147XStbO1xzXSsuKz8oXCRbYS16XF8wLTldKylccyo9XHMqaW1wbG9kZVteO1=rXDFbXjtdK1s7XHNdK2Z1bmN=aW9uIChbYS16XF8wLTldKylcKFteXCldK1tcKVx7XHNdKyhcJFthLXpcXzAtOV=rXHMqPVtccyciXSsoXFx4WzAtOWEtZl17Mn=pK1snIl=7XHMqKStyZXR1cm5bXjtdKz9cJFthLXpcXzAtOV=rKFxzKlxbW15cXV=rXF=pKlwoW147XStbO1x9XHNdK2V2YWxcKFwzXChccypcMlteO1=rWztcc1=rLis_KCR8XD8-KS9pIjt9czo1ODoicGhwIGFycmF5IGlmIFNFUlZFUiBpZiBpc2JvdCBmaWxlX2dldF9jb25=ZW5=cyBoZWFkZXIgaHR=cCI7YToyOntpOjA7czo1OiJGQVZGOSI7aToxO3M6Mjk4OiIvPFw_W3BoXHNdKygoZXJyb3JfcmVwb3J=aW5nfGluaV9zZXQpXHMqXChbXjtdKjtccyopKihcJFthLXpcXzAtOV=rXHMqPVteO1=rWztcc1=rKSsoaWZbXjtdK1wkaXNib3RbXjtdK1s7XH1cc1=rKSsoLis_KFwkW2Etel8wLTldKylccyo9XHMqKGZpbGVfZ2V=X2NvbnRlbnRzfGN1cmxfZXhlYylccypcKFteXH1dK1tcfVxzXSspKygoXCRbYS16XF8wLTldKylccyo9W147XSpcNlteO1=qWztcc1=rKSouKygoXDZ8XDkpW147XStbO1x9XHNdKygoaGVhZGVyfGVjaG98cHJpbnQpW147XStbO1x9XHNdKykrKSsoJHxcPz4pL2lzIjt9czo=MzoicGhwIFJFUVVFU1QgYXJyYXkgUkVRVUVTVCBhcnJheV9maWx=ZXIgZXhpdCI7YToyOntpOjA7czo1OiJFQ1FDcCI7aToxO3M6MTk2OiIvPFw_W3BoXHNdKyhcJFthLXpcXzAtOV=rKVxzKj1ccypcJF8oUkVRVUVTfEdFfFBPUylUXFtbXjtdK1s7XHNdKyhcJFthLXpcXzAtOV=rKVxzKj1ccyphcnJheVwoXCRfKFJFUVVFU3xHRXxQT1MpVFxbW147XStbO1xzXStcJFthLXpcXzAtOV=rXHMqPVxzKmFycmF5X2ZpbHRlclwoXDNbLFxzXSpcMVwpW2RleGl=XChcKTtcc1=qKCR8XD8-KS9pIjt9czo1MDoicGhwIGJhc2U2NF9kZWNvZGUgY3JlYXRlX2Z1bmN=aW9uIFZhcmlhYmxlRmluY3Rpb24iO2E6Mjp7aTowO3M6NToiRjhCSjgiO2k6MTtzOjI1NDoiLzxcPy4rPyhcJFthLXpfMC=5XSspXHMqPVxzKmJhc2U2NF9kZWNvZGVcKC4rPygoXCRbYS16XzAtOV=rKVxzKj1ccyooXEA_KGd6aW5mbGF=ZXxzdHJyZXYpXCgpK1wxLis_KT8oXCRbYS16XzAtOV=rKVxzKj1ccypjcmVhdGVfZnVuY3Rpb25cKFteLF=rWyxcc1=rKFwxfFwzKVteO1=rWztcc1=rXDZcKFteO1=rWztcc1x9XSsoZWxzZVtce1xzXStbXlx9XStbO1xzXH1dK3xlY2hvW1xzXChdKihbJyJdKS4rP1w5Wztcc1x9XSspKigkfFw_PikvaXMiO31zOjQ3OiJwaHAgZnVuY3Rpb24gd3BfZW5xdWV1ZV9zY3JpcHQganNvbjIgYWRkX2FjdGlvbiI7YToyOntpOjA7czo1OiJGQkE3USI7aToxO3M6Mzk1OiIvKFwvXCpbXlwqXSooXCpbXlwqXC9dKikrXC9ccyopKihpZltcc1woXCFdK2Z1bmN=aW9uX2V4aXN=c1woXHMqWyciXShbYS16XzAtOV=rKVsnIl1bXHNcKV=rXHtccyopP2Z1bmN=aW9uXHMrKFthLXpfMC=5XSspXHMqXChbXlx7XStce1xzKigoaWZbXHNcKFwhXStpc3NldFtcKFxzXStbXlwpXStbXHNcKV=rW1x7XHNdKik_KFwkW2Etel8wLTldK1xzKj1bXjtdKztccyopKihcJFthLXpfMC=5XStccyo9XHMqKT9cJFthLXpfMC=5XStccypcKC4qP2Jhc2U2NF9kZWNvZGVcKHwoZWNob3xwcmludClbXHNcKCciXSs8c2NyaXB=Lis_ZnJvbUNoYXJDb2RlXCguKz9kb2N1bWVudFwud3JpdGVcKCkuKz9hZGRfYWN=aW9uXHMqXChbXHMiJ1=qW14sXStbJyJcLFxzXSsoXDR8XDUpWyciXCk7XHNdKy9pcyI7fXM6NjE6InBocCBpZiBmdW5jdGlvbl9leGlzdHMgZnVuY3Rpb24gcmV=dXJuIFZhcmlhYmxlIEZ1bmN=aW9uIGV2YWwiO2E6Mjp7aTowO3M6NToiRjhGNnciO2k6MTtzOjE5NjoiLzxcP1twaFxzXSooKFwvXCouKz9cKlwvXHMqKSooXCRbYS16XF8wLTldKyhcW1teXF1dK1tcXVxzXH1dKykqPVteO1=rWztcc1=rKSsoaWZbXHNcKF=rXCFmdW5jdGlvbl9leGlzdHNcKFteXHtdK1tce1xzXStmdW5jdGlvbiBbXlx7XStbXHtcc1=rKHJldHVybiBcJFthLXpcXzAtOV=rfGV2YWwpXChbXjtdK1s7XH1cc1=rKSspKygkfFw_PikvaSI7fXM6NDM6IkxlZnRvdmVyIEhlYWRlciBpZiBHTE9CQUxTIEhleCBTRVJWRVIgSGV4L2kiO2E6Mjp7aTowO3M6NToiRjE2RGciO2k6MTtzOjE4ODoiLzxcP1twaFxzXStpZlxzKlwoW15ce1=rXCRHTE9CQUxTW1x7XFtdWyciXVxceFteXHtdK1tce1xzXStcJFthLXpcXzAtOV=rKFxbW15cXV=rW1xdXHNcfV=rKSo9W147XStcJF9TRVJWRVJbXHtcW11bJyJdXFx4W147XStbO1xzXStpZlxzKlwoW15ce1=rXCRHTE9CQUxTW1x7XFtdWyciXVxceFteO1=rW1xzXH=7XSooJHxcPz4pL2kiO31zOjUzOiJpZiBIVFRQX1VTRVJfQUdFTlQgYWRkX2FjdGlvbiB3cF9mb29=ZXIgZnVuY3Rpb24gZWNobyI7YToyOntpOjA7czo1OiJGMThGQiI7aToxO3M6MjE1OiIvKFwkW2EtelxfMC=5XSsoXFtbXlxdXStbXF1dKykqXHMqPVxzKmdldF9vcHRpb25cKFteO1=rWztcc1=raWZccypcKFteXHtdK=hUVFBfVVNFUl9BR=VOVFteXHtdK1tce1xzXSthZGRfYWN=aW9uXChbJyJcc1=rd3BfZm9vdGVyWyciXHMsXSsoW2EtelxfMC=5XSspWyciXHNdK1teO1=rWztcc1x9XSspK2Z1bmN=aW9uXHMrXDNbXlx7XStbXHtcc1=rKFteXH1dK1xzKikrXH=vaSI7fXM6MzA6ImRpdiBkaXNwbGF5IG5vbmUgaHJlZiBodHRwIGJ1eSI7YToyOntpOjA7czo1OiJGM=gwViI7aToxO3M6MTI2OiIvPCgoZGl2KXwoYSkpXHMrW14-XSsoZGlzcGxheVtcc1w6XStub25lW14-XSt8KD5ccyo8KGEpXHMrW14-XSopP2hyZWZbPSciXStodHRwW14-XSspezJ9Pi4qP2J1eS4qP1xzKjxcLyhcM3xcNj5ccyo8XC9cMik-XHMqL2kiO31zOjg1OiJDb3B5cmlnaHQgZnVuY3Rpb24gc2V=Q29va2llIHJldHVybiBmdW5jdGlvbiB1c2VyQWdlbnQgc2V=Q29va2llIHdyaXRlIGlmcmFtZSB=b3AgTmVnIjthOjI6e2k6MDtzOjU6IkdDTUQxIjtpOjE7czo=MDY6Ii8oPChzY3JpcHQpW14-XSo-XHMqKT8oXC9cKlxzKkNvcHlyaWdodC4rXHMqXCpcL1xzKnxbYS16XzAtOVxzXSs9W147XSs7XHMqfHNldFRpbWVvdXRcKFteO1=rO1xzKikqKGZ1bmN=aW9uIFtzZ11ldENvb2tpZVwoLis_KChkb2N1bWVudFwuY29va2llPXxyZXR1cm4pW15cfV=rWztcfVxzXSspKykrLis_W3NnXWV=Q29va2llXCguKz9kb2N1bWVudFwud3JpdGVcKFsiJ1=8KHNjcmlwdHxpZnJhbWUpW14-XSsoc3JjPVsnIlwrXHNodHBzXDpdK1wvXC98dG9wOlxzKlwtKSguKz9kb2N1bWVudFwuY29va2llLis_XC5=b1VUQ1N=cmluZ1tcKFwpXH1dK3wuKz9lbmNvZGVVUklDb21wb25lbnRcKGRvY3VtZW5=XC5yZWZlcnJlclwpLis_KFsnIl=pXC9zY3JpcHQ-XDEwKT9bXjtdK1tcKTtcfVxzXSsoPFwvXDI-fCQpL2kiO31zOjE1OiJwaHAgTG9=cyBvZiBIZXgiO2E6Mjp7aTowO3M6NToiSDMxQVQiO2k6MTtzOjI5NzoiL14oPFw_W3BoXHNdKyhmdW5jdGlvbiBiYXNlNjRbXlx7XStce1xzKnJldHVybiBiYXNlNjRbXlx9XStcfVxzKmlmW1xzXChdK2lzc2V=W1xzXChdK1wkXyhSRVFVRVN8R=V8UE9TKVQuKzxib2R5IG9ubG9hZD1bXHMnIlxcXStsb2NhdGlvbltePl=rW148XSs8XC9ib2R5PlxzKjxcL2h=bWw-XHMqPFw_W3BoXHNcfV=rfCguKz9cXHhbMC=5QS1GXXsyfSl7NTIsfSg_PS4qXCkpW15cbl=rKVxzKigkfFw_Pil8XFx4RUZcXHhCQlxceEJGXHMqPFwhRE9DVFlQRS4rP2V2YWxcKC4rPFwvYm9keT5ccyo8XC9odG1sPlxzKiQpL2lzIjt9czo2MToic2NyaXB=IGRvY3VtZW5=IHdyaXRlIGRpdiBhbmNob3Igc2NyaXB=IGRvY3VtZW5=IHdyaXRlIEVORGRpdiI7YToyOntpOjA7czo1OiJHQlI4SyI7aToxO3M6MTg2OiIvPHNjcmlwdFtePl=qPlxzKmRvY3VtZW5=XC53cml=ZVwoWyInXShbXDxkaXZdWyInIFwrXSopezR9W14-XSo-WyInXVwpO1xzKjxcL3NjcmlwdD5ccyooPGEgLis_PFwvYT5ccyopKzxzY3JpcHRbXj5dKj5ccypkb2N1bWVudFwud3JpdGVcKFsiJ1=oW1w8XC9kaXZdWyInIFwrXSopezV9PlsiJ11cKTtccyo8XC9zY3JpcHQ-L2kiO31zOjQzOiJlY2hvIGRpdiBwb3NpdGlvbiBhYnNvbHV=ZSBuZWdhdGl2ZSBhbmNob3JzIjthOjI6e2k6MDtzOjU6IkgxNTlZIjtpOjE7czozNzE6Ii8oPzwhWyciXSk8KGh=bWw-KT9bXHM8XSooKChzY3JpcHQpW14-XSo-XHMqZG9jdW1lbnRcLndyaXRlW1woXHMnIl=rPCk_ZGl2fChzdHlsZSlbXj5dKj5ccypbXC5cI1=oW2Etel9cLTAtOV=rKVtcc1x7XSspKFteXH1cPl=qKGxlZnR8cG9zaXRpb258dG9wfG9wYWNpdHl8ZmlsdGVyfGRpc3BsYXl8dGV4dC1pbmRlbnQpXDpccyooYWxwaGFcKG9wYWNpdHk9MHwwP1wufFwtWzAtOVwuXXszLH18bm9uZXxhYnNvbHV=ZSkpezMsfVtePl=qPlsnIlwpO1xzXSooPFwvXDU-KT8uKj88KCgoW2Itc11bYS16MC=5XSopW14-XSo-Wy5cc1=qPCkqYSAuKz88XC9hKD5bXjxdKjwoXC8oW15kXVthLXowLTldKnxcMTQpKT8pKikrPihccyo8XC8oXDJ8ZGl2PikpKi9pIjt9czo=MToiUEhQIEdhcmJhZ2UgQXJvdW5kIGV2YWwgVmFyaWFibGUgRnVuY3Rpb24iO2E6Mjp7aTowO3M6NToiRjJDSmQiO2k6MTtzOjE1MToiLzxcP1twaFxzXStcJFthLXpcXzAtOV=rXHMqPShccyonLisnW1wpXC5dKykrKFxzKicuK2V2YWxccypcKFwkW1wkXHtdKlthLXpcXzAtOV=rW1x9IFx=XSooXFtbXlxdXStcXVsgXHRdKikqXCguKydbXClcLl=rKShccyonLisnW1wuO1wpXSspK1xzKihcPz58JCkvaSI7fXM6NzY6InN=cmlwc2xhc2hlcyBSRVFVRVNUIGlmIGVjaG8gcmV=dXJuIGZvcGVuIGZ3cml=ZSBmY2xvc2UgZWNobyBmdW5jdGlvbiByZXR1cm4iO2E6Mjp7aTowO3M6NToiRjJFNmQiO2k6MTtzOjMxMjoiLyhceEVGXHhCQlx4QkYpPzxcP1twaFxzXSsoXCRbYS16XF8wLTldK1xzKj1ccyooc3RyaXBzbGFzaGVzW1woXHNdKyk_XCRfKFJFUVVFU3xHRXxQT1MpVFxbWyInXVteO1=qWztcc1=rKSsoaWZbXChcc1=rXCRbXlx7XSpbXHtcc1=rZWNob1xzKlsiJ11bXjtdK1s7XHNdK3JldHVyblteO1=qO1tcc1x9XSspKy4rP2ZvcGVuXCguKz9md3JpdGVcKC4rP2ZjbG9zZVwoW147XSpbO1xzXStlY2hvXHMqWyInXVteO1=rWztcc1=rKGZ1bmN=aW9uLis_W3Jta117Mn1kaXJcKFteO1=rO1tcc1x9XSsocmV=dXJuW147XSo7W1xzXH1dKykqKSsoJHxcPz4pL2lzIjt9czoyNToiVmFyIEhleCBWYXJpYWJsZSBGdW5jdGlvbiI7YToyOntpOjA7czo1OiJHQ1NBZyI7aToxO3M6MTkyOiIvKCgoXCRbYS16XzAtOVxzXC5dKz1bXjtdKztccyopKlwkW2Etel8wLTlcc1wuXSs9KFteO1=qXFxbeDAtOWEtZl17MiwzfSkrW147XSo7XHMqKSspKyhpZlxzKlwoW15ce1=rXHtccyopPygoXCRbYS16XzAtOV=rXHMqPVxzKik_XEA_XCRbYS16XzAtOV=rKFxzKlxbW15cXV=rXF=pKlwoW147XSs7XHMqKStbXH1cc1=qKFwvXC8uKyk_L2kiO31zOjg5OiJpbmlfc2V=IGlmIGlzc2V=IGFycmF5IGJhc2U2NF9kZWNvZGUgZnVuY3Rpb24gcmV=dXJuIGJhc2U2NF9kZWNvZGUgZXZhbCBWYXJpYWJsZSBGdW5jdGlvbiI7YToyOntpOjA7czo1OiJHNFJMUSI7aToxO3M6MzUwOiIvPFw_W3BoXHNdKyhbaWZcc1woXCFcQF=qKGluaV9zZXRccypcKHxlcnJvcl9yZXBvcnRpbmdccypcKHxzZXRfdGltZV9saW1pdFxzKlwofGlzc2V=XHMqXCh8ZGVmaW5lfGdsb2JhbHxcJFtce1wkYS16XzAtOVx9XFtcXCciXF1cc1=rPSlbXjtdKztbXH1cc1=qKSsoZnVuY3Rpb25ccyooW2Etel8wLTldKylccypcKC4rPyhyZXR1cm5ccyooXDR8YmFzZTY=X2RlY29kZSl8XCRbYS16XzAtOV=rXHMqKFxbW15cXV=qXF1ccyopKilcKC4rPykrKD88IVwvXC8sZnVuY3Rpb25cKHJlc3BvbnNlXCkgXHsgKWV2YWxcKC4rP1wpKztbXHNcfTtdKyhcPz5ccyooXCNcIVtcL2Etel9cLTAtOVwrPVxzXXsyMDAsfSQpP3wkKS9pcyI7fXM6NDY6ImNsYXNzIGNvbnN=IHBhY2sgSCogZnVuY3Rpb24gaW5jbHVkZSBuZXcgQ2xhc3MiO2E6Mjp7aTowO3M6NToiRjVROUciO2k6MTtzOjE5MjoiL2NsYXNzXHMrKFthLXpfMC=5XSspXHMqXHsuKz9jb25zdFxzKyhbYS16XzAtOV=rKVxzKj=uKz9zZWxmXDpcOihbYS16XzAtOV=rKVwocGFja1woJ=hcKidbLFxzXStzZWxmXDpcOlwyXCkrLis_ZnVuY3Rpb25ccytcM1woKFwkW2Etel8wLTldKykuKz9cQD8oaW5jbHVkZXxyZXF1aXJlKShfb25jZSk_W147XStcNC4rbmV3XHMrXDE7L2lzIjt9czoxNDoiZXZhbCBzdHJfcm9=MTMiO2E6Mjp7aTowO3M6NToiRjlQQ2wiO2k6MTtzOjE1OToiLyhcL1wvLispP1xzKigoaW5pX3NldFwofGVycm9yX3JlcG9ydGluZ1wofFwkW2Etel8wLTldK1tcc1wuXSo9KVteO1=qO1xzKikqXEA_KGV2YWx8YXNzZXJ=fFwkW2EtelxfMC=5XSsoXHMqXFtbXlxdXStcXSkqKVxzKlwoXHMqc3RyX3JvdDEzXCgnLionXClcKTsoXHMqXDEpPy9pIjt9czozMjoicGhwIEdMT=JBTFMgSGV4IGZ1bmN=aW9uIGlmIGV2YWwiO2E6Mjp7aTowO3M6NToiRzZHQWoiO2k6MTtzOjYwMjoiLzxcP1twaFxzXSooXHMqXCQoR=xPQkFMU3xbXHtcJCciXStbMC=5X1wtYS16XFwnIlwuXStbXH1cc1=rKVtcc1xbXHsnIl=rKFthLXpfMC=5XSspWyInXH1cXVxzXSsoW147XSo7XHMqZ2xvYmFsXHMqXCRcM1teO1=qO1xzKlwkXDNccyo9XHMqXCRHTE9CQUxTW147XSo7XHMqXCQoXDN8XHtbXlx9XSpcfSspXHMqKFxbW15cXV=rW1xdXHNdK3xce1teXH1dK1tcfVxzXSspKyk_PVxzKlsnIl=oXFx4WzAtOWEtZl17MSwyfSkrWyInXTtccyooKGVjaG98cHJpbnQpP1tcc1xAXSpcJChHTE9CQUx8XDMpW147XSs7XHMqfFwkW2Etel8wLTldK1xzKihbXC49XStccypcQD8oTlVMTHwoYXJyYXlbXChcc1=rKT9cJChHTE9CQUx8XDMpW147XSp8XCRbYS16XzAtOV=rKFxbW15cXV=rW1xdXHNdK3xce1teXH1dK1tcfVxzXSspKnxbIiddKykpKztccyp8Z2xvYmFsXHMqXCRbXjtdKztccyp8ZnVuY3Rpb25ccytbMC=5X2Etel=rXHMqXChbXlx7XSt8XHtccyp8XH1ccyp8KGZvcihlYWNoKT98KGVsc2VccyopP2lmKVxzKlwoLis_XCkrXHMqfHJldHVyblteO1=qO1tcc1x9XSspezMwLH=pK2V2YWxcKC4rP1wpKztbXHNcfV=rKGV4aXRbXjtdKjtbXHNcfV=rKT8oJHxcPz4pL2kiO31zOjM2OiJwaHAgaWYgaXNzZXQgUE9TVCBiYXNlNjRfZGVjb2RlIG1haWwiO2E6Mjp7aTowO3M6NToiR=NVS2=iO2k6MTtzOjQ2ODoiLzxcP1twaFxzXSooKFwkKFswLTlfYS16XSspXHMqPVxzKmV4cGxvZGVbXixdKyxccypiYXNlNjRfZGVjb2RlXChbXjtdKztccyp8KChpZnxpc3NldHxmb3JlYWNoKVxzKlwoKStcJF8oUkVRVUVTfEdFfFBPUylUW15cKV=rW1wpXHNce1=rKT8oXCRbMC=5X2Etel=rW1xzXC5dKj1ccypbYS16XzAtOVxzXChdKlwkKFwzfF9SRVFVRVNUfF9HRVR8X1BPU1QpKFteO1=qW1wpO1x9XHNdK2Vsc2VbXHtcc1=qfGVjaG98cHJpbnQpKlteO1=qWztcc1=rKFxzKmV4aXQ7KT98XC9cLy4rXHMqKVtcfVxzXSopKyhcJFswLTlfYS16XStbXHNcLl=qPVxzKiIuKz9cXHJcXG4iO1xzKikqKChcJFthLXpfMC=5XStccyo9XHMqfGlmW1xzXChdK3xlbHNlW15ce1=qW1x7XHNdKykqbWFpbFxzKlwoW147XStbXCk7XHNcfV=qKChpZltcKFxzXSt8ZWxzZSlbXlx7XSpbXHtcc1=rZWNob1teO1=qWztcc1x9XSt8ZXhpdDtccyopKikrKCR8XD8-KS9pIjt9czozMDoid3BfZW5xdWV1ZV9zY3JpcHQgU1dFRVRDQVBUQ=hBIjthOjI6e2k6MDtzOjU6IkY2VUdsIjtpOjE7czo2MDoiL3dwX2VucXVldWVfc2NyaXB=XChbXixdKyxccypbJyJdaHR=cC4rP1NXRUVUQ=FQVENIQVteO1=rOy9pIjt9czozODoicGhwIGNsYXNzIFZhcmlhYmxlIEZ1bmN=aW9ucyBuZXcgQ=xBU1MiO2E6Mjp7aTowO3M6NToiRzlSQkUiO2k6MTtzOjMyMDoiLzxcP1twaFxzXSsoXC9cKi4qP1wqXC9ccyp8ZXJyb3JfcmVwb3J=aW5nXCgwXCk7XHMqfGZ1bmN=aW9uW15cKF=rZG9sbHlbXlx7XStcey4qPyhyZXR1cm58ZGJEZWx=YSlbXjtdKls7XH1cc1=qKSpjbGFzc1xzKyhbYS16XzAtOV=rKVxzKlx7Lis_KChcJFthLXpfMC=5XHsnIlx9XSsoXHMqXFtbXlxdXStcXSkqXHMqPVxzKik_KFwkW2Etel8wLTlce1x9XSsoXHMqXFtbXlxdXStcXSkqfGJhc2U2NF9kZWNvZGVcKHJhd3VybGRlY29kZXxmaWxlX3B1dF9jb25=ZW5=cylccypcKC4qP1tcKVxzXSs7XHMqKXszLH=uKz9uZXdccytcM1teO1=qO1xzKigkfFw_PikvaXMiO31zOjE=OiJ2aXNpdG9yVHJhY2tlciI7YToyOntpOjA7czo1OiJGOU1IbSI7aToxO3M6MTc3OiIvKCg8XCEtLXxcL1wqKXZpc2l=b3JUcmFja2VyKFwqXC98LS=-KSlccyooPFw_W3BoXHNdKy4rP2Jhc2U2NF9kZWNvZGVccypcKC4rP1w_PnwuKz9kb2N1bWVudFwuY3JlYXRlRWxlbWVudFwoWyciXXNjcmlwdFsiJ11cKTtccypbYS16XzAtOV=rXC5zcmNccyo9W1xzJyJdK2h=dHBcOlwvXC8uKz8pXHMqXDEvaXMiO31zOjU4OiJmc29ja29wZW4gZndyaXRlIHdoaWxlIGZlb2YgZmNsb3NlIHByZWdfbWF=Y2ggZ3p1bmNvbXByZXNzIjthOjI6e2k6MDtzOjU6IkZBNUxPIjtpOjE7czoyMzI6Ii8oXCRbYS16XzAtOV=rKVxzKj1ccypcQD9mc29ja29wZW5cKFteO1=rO1xzKmlmW1woXHNdK1wxW1wpXHNdKlx7Lis_ZndyaXRlXChcMVteO1=rO1xzKndoaWxlW1xzXChcIV=rZmVvZlwoXDEuKz9mY2xvc2VcKFwxXCk7XHMqcHJlZ19tYXRjaFwoW14sXSssW14sXSssXHMqKFwkW2Etel8wLTldKylcKTtccyppZltcKFxzXStcMlxbMVxdW1xzXCFdKj=uKz9nenVuY29tcHJlc3NcKFteO1=rO1tcfVxzXSsvaXMiO31zOjIwOiJUYWdnZWQgZXZhbCBmdW5jdGlvbiI7YToyOntpOjA7czo1OiJHM1Q5QSI7aToxO3M6MTI1OiIvKFwvXCpbXlwqXStcKlwvKVxzKihbXHNhLXpfMC=5XD1dKykqWztcc1woXSood2luZG93W1wuXFsiJ1=rXFx4W147XSt8ZnVuY3Rpb25cKFwpLispO1xzKmV2YWxbXChcc1=rW15cKV=rWyciXHNcKFwpO1x9XStcMS9pcyI7fXM6NDQ6InNjcmlwdCB2YXIgaHR=cCBpZiBkb2N1bWVudCB3cml=ZSBzY3JpcHQgc3JjIjthOjI6e2k6MDtzOjU6IkcyQ=l3IjtpOjE7czozNTI6Ii8oPHNjcmlwdFtePl=qPlxzKigodmFyXHMqKT9bYS16XzAtOV=rXHMqPVsnIjtcc1=qKHNldFRpbWVvdXR8ZW5jb2RlVVJJQ29tcG9uZW5=KVwoW15cKV=qWyciXCk7XHNdezIsfSkrKFt2YXJcc1=qKFthLXpfMC=5XSspXHMqPVxzKlsnIl1baGZ=XSt=cFtzXSo6XC9cL1teO1=rO1xzKigodmFyXHMqKT8oW2Etel8wLTldKylccyo9XHMqXDZbXjtdKztccyopKyk_aWZbXlx7XStce1xzKmRvY3VtZW5=XC53cml=ZVwoWyInXTxbc2NyaXB=XHMnIlwrXXs3LH1bXlx9XSpzcmM9WyciXHNcK1=rKFw5fFtmaHRdK3RwW3NdKjpcL1wvLitqcXVlcnlcLihtaW5cLikqcGhwKShbXjtdK1tcfTtcc1=rKSs_PFwvc2NyaXB=PikrL2kiO31zOjQ1OiJmdW5jdGlvbiB1bnNldCB3cF9saXN=X3RhYmxlIGl=ZW1zIGFkZF9hY3Rpb24iO2E6Mjp7aTowO3M6NToiR=FHRUciO2k6MTtzOjQ=MzoiLyhcL1wqW15cKl=qKFwqW15cKlwvXSopK1wvXHMqKSooXCRbXjtdKz1bXjtdKztccyopKihpZltcKFxzXCFdK2Z1bmN=aW9uX2V4aXN=c1tcKFxzJyJdK2luaV9zZXRbJyJcKVx7XHNdKyhcQD9pbmlfc2V=XChbXjtdK1s7XHNdKykrW1xzXH=7XSspKmZ1bmN=aW9uXHMrKFthLXpfMC=5XSspXHMqXChbXlx9XSsocGFja1woWyciXUhcKlsnIixcc1wuMC=5QS1GXCldKztccyppZltcc1woXEBpc19dK2ZpbGVbX2Etel=qW1woXHNdKyhcJFthLXpfMC=5XSspLis_ZmlsZV9nZXRfY29udGVudHNbXHNcKF=rXDguKz9maWxlX3B1dF9jb25=ZW5=c1tcc1woXStcOHx1bnNldFwoXCR3cF9saXN=X3RhYmxlLT5pdGVtc1xbfGZpbGVfZ2V=X2NvbnRlbnRzXChfX=ZJTEVfXy4rP2ZwdXRzXCguKz9zY2FuZGlyXCgpLis_YWRkX2FjdGlvblwoW14sXStbLFxzMC=5XCknIl=rXDZbXjtdKzsvaXMiO31zOjM5OiJwaHAgZXJyb3JfcmVwb3J=aW5nIGZ1bmN=aW9uIGRldGVjdF9jbXMiO2E6Mjp7aTowO3M6NToiRkJCRzAiO2k6MTtzOjE2MDoiLzxcP1twaFxzXSsoXEA_KGVycm9yX3JlcG9ydGluZ3xzZXRfdGltZV9saW1pdHxpbmlfc2V=KVwoLio_MFwpO1xzKikrLio_ZnVuY3Rpb24gKGRldGVjdF9jbXNcKCkuK1wzW147XSs7XHMqKChpZlxzKlwoW15cKV=rfGVsc2UpW15ce1=qW15cfV=rW1x9XHNdKykrKCR8XD8-KS9pcyI7fXM6NTE6ImZ1bmN=aW9uIGdsdWVzX2l=IHNhbml=aXplX2tleSBjYWxsX3VzZXJfZnVuY19hcnJheSI7YToyOntpOjA7czo1OiJGQkk5SyI7aToxO3M6MjkyOiIvKGlmW1xzXChcIV=rZnVuY3Rpb25fZXhpc3RzXChccypbJyJdW2Etel8wLTldK1snIl1bXHNcKV=rXHtccyopP2Z1bmN=aW9uXHMrKFthLXpfMC=5XSspXHMqXChbXlwpXStbXClcc1=rXHtccyooXCRbYS16XzAtOV=rKVxzKj1ccypzYW5pdGl6ZV9rZXlcKFteO1=rO1xzKihcJFthLXpfMC=5XSspXHMqPVxzKmNhbGxfdXNlcl9mdW5jX2FycmF5XChccypcM1teO1=rO1xzKnJldHVyblxzKlw=LitcMlxzKlwoW147XSs7XHMqLitjYWxsX3VzZXJfZnVuY19hcnJheVwoW147XSs7W1x9XHNdKygkfCg_PVw_PikpL2lzIjt9czoxNjoicGhwIGV2YWwgVmFyIEhleCI7YToyOntpOjA7czo1OiJGQktLUiI7aToxO3M6MTE1OiIvPFw_W3BoXHNdKyhAP2V2YWxccypcKFxzKikrKFsnIl=pW1xzXFxdKlwkW2EtelxfMC=5XFtcXVx7XH1ccyciXSs9W1xzXFwnIl=qKFxceFswLTldezJ9KSsuK1wyKFxzKlwpKSs7XHMqKCR8XD8-KS9pIjt9czoyOToiaWYgc3RycG9zIFJFUVVFU1RfVVJJIGluY2x1ZGUiO2E6Mjp7aTowO3M6NToiRkNRRlMiO2k6MTtzOjE=OToiL2lmKFtcc1woXStzdHJbYS16XzAtOV=rKXsyLH1bXHNcKF=rXCRfU=VSVkVSXFtbIiddUkVRVUVTVF9VUklbJyJdXF1ccypcKStbXlwpXStbXClcc1=rXHtbXHNcQF=qKGluY2x1ZGV8cmVxdWlyZSkoX29uY2UpP1teO1=rWztcc1=rKGV4aXRbXHM7XSspP1x9L2kiO31zOjc2OiJlcnJvcl9yZXBvcnRpbmcgaW5pX3NldCBzZXRfdGltZV9saW1pdCBpZ25vcmVfdXNlcl9hYm9ydCBlbHNlaWYgcmVxdWlyZV9vbmNlIjthOjI6e2k6MDtzOjU6IkZDVUxkIjtpOjE7czoyMTk6Ii88XD9bcGhcc1=rKFwvXCpbXlwqXSooXCpbXlwqXC9dKikrXC9ccyp8XC9cL1teXG5dKlxzKykqKChlcnJvcl9yZXBvcnRpbmd8aW5pX3NldHxzZXRfdGltZV9saW1pdHxpZ25vcmVfdXNlcl9hYm9ydClccypcKFteO1=rWztcc1=rKXs1LH=oKGVsc2Vccyp8aWZccypcKCtbXlwpXStbXHNcKV=rKStcQD8ocmVxdWlyZXxpbmNsdWRlKShfb25jZSk_W147XStbO1xzXSspKygkfFw_PikvaSI7fXM6ODM6InBocCBpZiBmdW5jdGlvbl9leGlzdHMgZnVuY3Rpb24gY3VybF9pbml=IHJldHVybiBmdW5jdGlvbiB=cmltIHJldHVybiBiYXNlNjRfZGVjb2RlIjthOjI6e2k6MDtzOjU6IkcxOEZuIjtpOjE7czo=MDU6Ii88XD9bcGhcc1=rKFwkW2Etel8wLTldKylccyo9W147XSs7XHMqaWZccypcKFxzKlwhZnVuY3Rpb25fZXhpc3RzXChbIiddKFthLXpfMC=5XSspWyciXVwpW1wpXHNce1=qZnVuY3Rpb25ccypcMlwoW15cKV=rXClbXClcc1x7XStbXlxuXSpjdXJsX2luaXRcKFwpOy4rP3JldHVyblteO1=rO1tccytcfV=raWZccypcKFxzKlwhZnVuY3Rpb25fZXhpc3RzXChbIiddKFthLXpfMC=5XSspWyciXVwpW1wpXHNce1=qZnVuY3Rpb25ccypcM1woW15cKV=rXClbXClcc1x7XStbXlxuXSp=cmltW147XSs7Lio_cmV=dXJuW147XSs7W1xzK1x9XSsoLio_KGJhc2U2NF9kZWNvZGVbXChcc1=rXDF8XDJcKHxcM1woKVteXCldKltcKVxzXStbXjtdKls7XHNdKyl7Myx9KChlY2hvfHByaW5=KVteO1=rO1xzKikrKCR8XD8-KS9pcyI7fXM6MTI6IlBIUCByZXZlcnNlZCI7YToyOntpOjA7czo1OiJHMjhBciI7aToxO3M6NDE6Ii9eKFxzKlw-XD9ccyopPzsuK1wkKFtwaFxzXSpcP1w8XHMqKT8kL2lzIjt9fX=2", "yes");
INSERT INTO `wp_options` VALUES("70866", "GOTMLS_scan_log/75.67.101.93/1477752431.3519", "a:2:{s:8:\"settings\";a:14:{s:12:\"msg_position\";a:4:{i:0;s:4:\"80px\";i:1;s:4:\"40px\";i:2;s:5:\"400px\";i:3;s:5:\"600px\";}s:10:\"menu_group\";i:0;s:9:\"scan_what\";i:2;s:10:\"scan_depth\";i:-1;s:11:\"exclude_ext\";a:24:{i:0;s:3:\"png\";i:1;s:3:\"jpg\";i:2;s:4:\"jpeg\";i:3;s:3:\"gif\";i:4;s:3:\"bmp\";i:5;s:3:\"tif\";i:6;s:4:\"tiff\";i:7;s:3:\"psd\";i:8;s:3:\"fla\";i:9;s:3:\"flv\";i:10;s:3:\"mov\";i:11;s:3:\"mp3\";i:12;s:3:\"exe\";i:13;s:3:\"zip\";i:14;s:3:\"pdf\";i:15;s:3:\"css\";i:16;s:3:\"pot\";i:17;s:2:\"po\";i:18;s:2:\"mo\";i:19;s:2:\"so\";i:20;s:3:\"doc\";i:21;s:4:\"docx\";i:22;s:3:\"svg\";i:23;s:3:\"ttf\";}s:12:\"check_custom\";s:0:\"\";s:11:\"exclude_dir\";a:0:{}s:8:\"user_can\";s:16:\"activate_plugins\";s:14:\"quarantine_dir\";b:0;s:10:\"dont_check\";a:0:{}s:10:\"scan_level\";i:3;s:23:\"auto_UPDATE_definitions\";i:1;s:15:\"skip_quarantine\";i:0;s:5:\"check\";a:5:{i:0;s:8:\"htaccess\";i:1;s:8:\"timthumb\";i:2;s:8:\"backdoor\";i:3;s:5:\"known\";i:4;s:9:\"potential\";}}s:4:\"scan\";a:7:{s:3:\"dir\";s:31:\"/home/econolodge/public_html/wp\";s:5:\"start\";i:1477752434;s:4:\"type\";s:13:\"Complete Scan\";s:9:\"microtime\";d:1233;s:7:\"percent\";i:-1;s:11:\"last_threat\";d:1477753667.5743958950042724609375;s:6:\"finish\";i:1477753667;}}", "yes");
INSERT INTO `wp_options` VALUES("80223", "wd_bwg_options", "{\"id\":\"1\",\"images_directory\":\"wp-content\\/uploads\",\"masonry\":\"vertical\",\"mosaic\":\"vertical\",\"resizable_mosaic\":\"0\",\"mosaic_total_width\":\"100\",\"image_column_number\":\"5\",\"images_per_page\":\"30\",\"thumb_width\":\"180\",\"thumb_height\":\"90\",\"upload_thumb_width\":\"300\",\"upload_thumb_height\":\"300\",\"image_enable_page\":\"1\",\"image_title_show_hover\":\"none\",\"album_column_number\":\"5\",\"albums_per_page\":\"30\",\"album_title_show_hover\":\"hover\",\"album_thumb_width\":\"120\",\"album_thumb_height\":\"90\",\"album_enable_page\":\"1\",\"extended_album_height\":\"150\",\"extended_album_description_enable\":\"1\",\"image_browser_width\":\"800\",\"image_browser_title_enable\":\"1\",\"image_browser_description_enable\":\"1\",\"blog_style_width\":\"800\",\"blog_style_title_enable\":\"1\",\"blog_style_images_per_page\":\"5\",\"blog_style_enable_page\":\"1\",\"slideshow_type\":\"fade\",\"slideshow_interval\":\"5\",\"slideshow_width\":\"800\",\"slideshow_height\":\"500\",\"slideshow_enable_autoplay\":\"0\",\"slideshow_enable_shuffle\":\"0\",\"slideshow_enable_ctrl\":\"1\",\"slideshow_enable_filmstrip\":\"1\",\"slideshow_filmstrip_height\":\"90\",\"slideshow_enable_title\":\"0\",\"slideshow_title_position\":\"top-right\",\"slideshow_enable_description\":\"0\",\"slideshow_description_position\":\"bottom-right\",\"slideshow_enable_music\":\"0\",\"slideshow_audio_url\":\"\",\"popup_width\":\"800\",\"popup_height\":\"500\",\"popup_type\":\"fade\",\"popup_interval\":\"5\",\"popup_enable_filmstrip\":\"1\",\"popup_filmstrip_height\":\"70\",\"popup_enable_ctrl_btn\":\"1\",\"popup_enable_fullscreen\":\"1\",\"popup_enable_info\":\"1\",\"popup_info_always_show\":\"0\",\"popup_enable_rate\":\"0\",\"popup_enable_comment\":\"1\",\"popup_enable_email\":\"0\",\"popup_enable_captcha\":\"0\",\"popup_enable_download\":\"0\",\"popup_enable_fullsize_image\":\"0\",\"popup_enable_facebook\":\"1\",\"popup_enable_twitter\":\"1\",\"popup_enable_google\":\"1\",\"watermark_type\":\"none\",\"watermark_position\":\"bottom-left\",\"watermark_width\":\"90\",\"watermark_height\":\"90\",\"watermark_url\":\"http:\\/\\/www.captainsbountymotorinn.com\\/wp-content\\/plugins\\/photo-gallery\\/images\\/watermark.png\",\"watermark_text\":\"web-dorado.com\",\"watermark_link\":\"https:\\/\\/web-dorado.com\",\"watermark_font_size\":\"20\",\"watermark_font\":\"arial\",\"watermark_color\":\"FFFFFF\",\"watermark_opacity\":\"30\",\"built_in_watermark_type\":\"none\",\"built_in_watermark_position\":\"middle-center\",\"built_in_watermark_size\":\"15\",\"built_in_watermark_url\":\"http:\\/\\/www.captainsbountymotorinn.com\\/wp-content\\/plugins\\/photo-gallery\\/images\\/watermark.png\",\"built_in_watermark_text\":\"web-dorado.com\",\"built_in_watermark_font_size\":\"20\",\"built_in_watermark_font\":\"arial\",\"built_in_watermark_color\":\"FFFFFF\",\"built_in_watermark_opacity\":\"30\",\"image_right_click\":\"0\",\"popup_fullscreen\":\"0\",\"gallery_role\":\"0\",\"album_role\":\"0\",\"image_role\":\"0\",\"popup_autoplay\":\"0\",\"album_view_type\":\"thumbnail\",\"popup_enable_pinterest\":\"0\",\"popup_enable_tumblr\":\"0\",\"show_search_box\":\"0\",\"search_box_width\":\"180\",\"preload_images\":\"0\",\"preload_images_count\":\"10\",\"thumb_click_action\":\"open_lightbox\",\"thumb_link_target\":\"1\",\"comment_moderation\":\"0\",\"popup_hit_counter\":\"0\",\"enable_ML_import\":\"0\",\"showthumbs_name\":\"0\",\"show_album_name\":\"0\",\"show_image_counts\":\"0\",\"upload_img_width\":\"1200\",\"upload_img_height\":\"1200\",\"play_icon\":\"1\",\"show_masonry_thumb_description\":\"0\",\"slideshow_title_full_width\":\"0\",\"popup_info_full_width\":\"0\",\"show_sort_images\":\"0\",\"autoupdate_interval\":\"30\",\"instagram_access_token\":\"0\",\"description_tb\":\"0\",\"enable_seo\":\"1\",\"autohide_lightbox_navigation\":\"1\",\"autohide_slideshow_navigation\":\"1\",\"read_metadata\":\"1\",\"enable_loop\":\"1\",\"enable_addthis\":\"0\",\"addthis_profile_id\":\"\",\"carousel_width\":\"300\",\"carousel_height\":\"300\",\"carousel_interval\":\"5\",\"carousel_image_column_number\":\"5\",\"carousel_image_par\":\"0.75\",\"carousel_enable_autoplay\":\"0\",\"carousel_enable_title\":\"0\",\"carousel_r_width\":\"800\",\"carousel_fit_containerWidth\":\"1\",\"carousel_prev_next_butt\":\"1\",\"carousel_play_pause_butt\":\"1\",\"permissions\":\"manage_options\",\"facebook_app_id\":\"\",\"facebook_app_secret\":\"\",\"show_tag_box\":\"0\",\"show_hide_custom_post\":\"0\",\"show_hide_post_meta\":\"0\",\"placeholder\":\"\",\"ecommerce_icon_show_hover\":\"0\",\"popup_enable_ecommerce\":\"0\",\"slideshow_effect_duration\":\"1\",\"popup_effect_duration\":\"1\",\"use_inline_stiles_and_scripts\":\"0\"}", "no");
INSERT INTO `wp_options` VALUES("83806", "GOTMLS_scan_log/97.96.91.241/1487690084.7356", "a:2:{s:8:\"settings\";a:14:{s:12:\"msg_position\";a:4:{i:0;s:4:\"80px\";i:1;s:4:\"40px\";i:2;s:5:\"400px\";i:3;s:5:\"600px\";}s:10:\"menu_group\";i:0;s:9:\"scan_what\";i:2;s:10:\"scan_depth\";i:-1;s:11:\"exclude_ext\";a:24:{i:0;s:3:\"png\";i:1;s:3:\"jpg\";i:2;s:4:\"jpeg\";i:3;s:3:\"gif\";i:4;s:3:\"bmp\";i:5;s:3:\"tif\";i:6;s:4:\"tiff\";i:7;s:3:\"psd\";i:8;s:3:\"fla\";i:9;s:3:\"flv\";i:10;s:3:\"mov\";i:11;s:3:\"mp3\";i:12;s:3:\"exe\";i:13;s:3:\"zip\";i:14;s:3:\"pdf\";i:15;s:3:\"css\";i:16;s:3:\"pot\";i:17;s:2:\"po\";i:18;s:2:\"mo\";i:19;s:2:\"so\";i:20;s:3:\"doc\";i:21;s:4:\"docx\";i:22;s:3:\"svg\";i:23;s:3:\"ttf\";}s:12:\"check_custom\";s:0:\"\";s:11:\"exclude_dir\";a:0:{}s:8:\"user_can\";s:16:\"activate_plugins\";s:14:\"quarantine_dir\";b:0;s:10:\"dont_check\";a:0:{}s:10:\"scan_level\";i:3;s:23:\"auto_UPDATE_definitions\";i:1;s:15:\"skip_quarantine\";i:0;s:5:\"check\";a:4:{i:0;s:8:\"htaccess\";i:1;s:8:\"timthumb\";i:2;s:8:\"backdoor\";i:3;s:5:\"known\";}}s:4:\"scan\";a:7:{s:3:\"dir\";s:31:\"/home/econolodge/public_html/wp\";s:5:\"start\";i:1487690087;s:4:\"type\";s:13:\"Complete Scan\";s:9:\"microtime\";d:1199;s:7:\"percent\";i:-1;s:11:\"last_threat\";d:1487691286.29189395904541015625;s:6:\"finish\";i:1487691286;}}", "yes");
INSERT INTO `wp_options` VALUES("71681", "GOTMLS_scan_log/97.96.91.241/1478796357.4855", "a:2:{s:8:\"settings\";a:14:{s:12:\"msg_position\";a:4:{i:0;s:4:\"80px\";i:1;s:4:\"40px\";i:2;s:5:\"400px\";i:3;s:5:\"600px\";}s:10:\"menu_group\";i:0;s:9:\"scan_what\";i:2;s:10:\"scan_depth\";i:-1;s:11:\"exclude_ext\";a:24:{i:0;s:3:\"png\";i:1;s:3:\"jpg\";i:2;s:4:\"jpeg\";i:3;s:3:\"gif\";i:4;s:3:\"bmp\";i:5;s:3:\"tif\";i:6;s:4:\"tiff\";i:7;s:3:\"psd\";i:8;s:3:\"fla\";i:9;s:3:\"flv\";i:10;s:3:\"mov\";i:11;s:3:\"mp3\";i:12;s:3:\"exe\";i:13;s:3:\"zip\";i:14;s:3:\"pdf\";i:15;s:3:\"css\";i:16;s:3:\"pot\";i:17;s:2:\"po\";i:18;s:2:\"mo\";i:19;s:2:\"so\";i:20;s:3:\"doc\";i:21;s:4:\"docx\";i:22;s:3:\"svg\";i:23;s:3:\"ttf\";}s:12:\"check_custom\";s:0:\"\";s:11:\"exclude_dir\";a:0:{}s:8:\"user_can\";s:16:\"activate_plugins\";s:14:\"quarantine_dir\";b:0;s:10:\"dont_check\";a:0:{}s:10:\"scan_level\";i:3;s:23:\"auto_UPDATE_definitions\";i:1;s:15:\"skip_quarantine\";i:0;s:5:\"check\";a:6:{i:0;s:8:\"htaccess\";i:1;s:8:\"timthumb\";i:2;s:8:\"backdoor\";i:3;s:5:\"known\";i:4;s:7:\"wp_core\";i:5;s:9:\"potential\";}}s:4:\"scan\";a:7:{s:3:\"dir\";s:31:\"/home/econolodge/public_html/wp\";s:5:\"start\";i:1478796401;s:4:\"type\";s:13:\"Complete Scan\";s:9:\"microtime\";d:1445;s:7:\"percent\";i:-1;s:11:\"last_threat\";d:1478797846.7572329044342041015625;s:6:\"finish\";i:1478797846;}}", "yes");
INSERT INTO `wp_options` VALUES("64501", "ct_afc_options", "", "yes");
INSERT INTO `wp_options` VALUES("64502", "verified_purchase", "0", "yes");
INSERT INTO `wp_options` VALUES("64503", "ct_afc_installed_date", "1468830162", "yes");
INSERT INTO `wp_options` VALUES("69160", "wordfence_lastSyncAttackData", "1544253665", "no");
INSERT INTO `wp_options` VALUES("67518", "wpseo_onpage", "a:2:{s:6:\"status\";i:1;s:10:\"last_fetch\";i:1544370227;}", "yes");
INSERT INTO `wp_options` VALUES("89478", "secure_auth_key", "~qaAiCWo8hq_mW4EbeEDb!1{Fww/TcwN_F+z(&s,u=h!0Tr6g5L7i6B!`Nq.8FiS", "no");
INSERT INTO `wp_options` VALUES("89479", "secure_auth_salt", "4[0]O,$MSOn/gz|l*=v^7WH?}JS2F~3Z=>DftFK$vBW*RlqdBW<,2tYt{zeK hI*", "no");
INSERT INTO `wp_options` VALUES("106836", "wphb_settings", "a:39:{s:6:\"minify\";a:13:{s:7:\"enabled\";b:0;s:7:\"use_cdn\";b:0;s:3:\"log\";b:0;s:9:\"file_path\";s:0:\"\";s:11:\"minify_blog\";b:1;s:4:\"view\";s:5:\"basic\";s:5:\"block\";a:2:{s:7:\"scripts\";a:0:{}s:6:\"styles\";a:0:{}}s:6:\"minify\";a:2:{s:7:\"scripts\";a:0:{}s:6:\"styles\";a:0:{}}s:7:\"combine\";a:2:{s:7:\"scripts\";a:0:{}s:6:\"styles\";a:0:{}}s:8:\"position\";a:2:{s:7:\"scripts\";a:0:{}s:6:\"styles\";a:0:{}}s:5:\"defer\";a:2:{s:7:\"scripts\";a:0:{}s:6:\"styles\";a:0:{}}s:6:\"inline\";a:2:{s:7:\"scripts\";a:0:{}s:6:\"styles\";a:0:{}}i:0;s:0:\"\";}s:6:\"uptime\";a:3:{s:7:\"enabled\";b:0;s:13:\"notifications\";a:3:{s:7:\"enabled\";b:0;s:9:\"threshold\";i:0;s:10:\"recipients\";a:0:{}}s:7:\"reports\";a:5:{s:7:\"enabled\";b:0;s:9:\"frequency\";i:7;s:3:\"day\";s:6:\"Sunday\";s:4:\"time\";s:5:\"16:00\";s:10:\"recipients\";a:0:{}}}s:7:\"use_cdn\";b:0;s:14:\"gravatar_cache\";b:0;s:11:\"minify-blog\";b:1;s:10:\"minify-cdn\";b:1;s:5:\"block\";a:2:{s:7:\"scripts\";a:0:{}s:6:\"styles\";a:0:{}}s:11:\"dont_minify\";a:2:{s:7:\"scripts\";a:3:{i:0;s:18:\"tempera-nivoslider\";i:1;s:16:\"tempera-frontend\";i:2;s:16:\"cryout_ajax_more\";}s:6:\"styles\";a:1:{i:0;s:13:\"tempera-style\";}}s:7:\"combine\";a:2:{s:7:\"scripts\";a:0:{}s:6:\"styles\";a:0:{}}s:8:\"position\";a:2:{s:7:\"scripts\";a:0:{}s:6:\"styles\";a:0:{}}s:5:\"defer\";a:2:{s:7:\"scripts\";a:0:{}s:6:\"styles\";a:0:{}}s:18:\"caching_expiry_css\";s:10:\"8d/A691200\";s:25:\"caching_expiry_javascript\";s:10:\"8d/A691200\";s:20:\"caching_expiry_media\";s:10:\"8d/A691200\";s:21:\"caching_expiry_images\";s:10:\"8d/A691200\";s:16:\"cloudflare-email\";s:0:\"\";s:18:\"cloudflare-api-key\";s:0:\"\";s:15:\"cloudflare-zone\";s:0:\"\";s:20:\"cloudflare-zone-name\";s:0:\"\";s:20:\"cloudflare-connected\";b:0;s:15:\"cloudflare-plan\";b:0;s:21:\"cloudflare-page-rules\";a:0:{}s:25:\"cloudflare-caching-expiry\";i:691200;s:19:\"email-notifications\";b:1;s:16:\"email-recipients\";a:0:{}s:15:\"email-frequency\";i:7;s:9:\"email-day\";s:6:\"Sunday\";s:10:\"email-time\";s:4:\"1:22\";s:10:\"minify_cdn\";b:0;s:21:\"wphb-last-sent-report\";i:1503810275;s:8:\"gravatar\";a:1:{s:7:\"enabled\";b:0;}s:10:\"page_cache\";a:5:{s:7:\"enabled\";b:1;s:10:\"cache_blog\";b:1;s:7:\"control\";b:0;s:9:\"detection\";s:6:\"manual\";s:12:\"pages_cached\";i:0;}s:10:\"cloudflare\";a:9:{s:7:\"enabled\";b:0;s:9:\"connected\";b:0;s:5:\"email\";s:0:\"\";s:7:\"api_key\";s:0:\"\";s:4:\"zone\";s:0:\"\";s:9:\"zone_name\";s:0:\"\";s:4:\"plan\";b:0;s:10:\"page_rules\";a:0:{}s:12:\"cache_expiry\";i:691200;}s:11:\"performance\";a:8:{s:7:\"reports\";b:0;s:13:\"subsite_tests\";b:0;s:9:\"dismissed\";b:0;s:10:\"last_score\";i:73;s:9:\"frequency\";i:7;s:3:\"day\";s:8:\"Saturday\";s:4:\"time\";s:5:\"17:00\";s:10:\"recipients\";a:0:{}}s:8:\"advanced\";a:6:{s:12:\"query_string\";b:0;s:5:\"emoji\";b:0;s:8:\"prefetch\";a:9:{i:0;s:22:\"//fonts.googleapis.com\";i:1;s:19:\"//fonts.gstatic.com\";i:2;s:21:\"//ajax.googleapis.com\";i:3;s:17:\"//apis.google.com\";i:4;s:22:\"//google-analytics.com\";i:5;s:26:\"//www.google-analytics.com\";i:6;s:26:\"//ssl.google-analytics.com\";i:7;s:13:\"//youtube.com\";i:8;s:16:\"//s.gravatar.com\";}s:11:\"db_cleanups\";b:0;s:12:\"db_frequency\";i:7;s:9:\"db_tables\";a:6:{s:9:\"revisions\";b:1;s:6:\"drafts\";b:1;s:5:\"trash\";b:1;s:4:\"spam\";b:1;s:13:\"trash_comment\";b:1;s:18:\"expired_transients\";b:1;}}s:3:\"rss\";a:2:{s:7:\"enabled\";b:1;s:8:\"duration\";i:3600;}s:7:\"caching\";a:4:{s:10:\"expiry_css\";s:10:\"8d/A691200\";s:17:\"expiry_javascript\";s:10:\"8d/A691200\";s:12:\"expiry_media\";s:10:\"8d/A691200\";s:13:\"expiry_images\";s:10:\"8d/A691200\";}s:10:\"minify_log\";b:0;s:8:\"settings\";a:1:{s:17:\"accessible_colors\";b:0;}}", "yes");
INSERT INTO `wp_options` VALUES("134611", "wdp_un_profile_data", "a:3:{s:5:\"forum\";a:1:{s:15:\"support_threads\";a:1:{i:0;a:7:{s:5:\"title\";s:44:\"cURL error 60 SSL problem on non-HTTPS sites\";s:4:\"link\";s:98:\"https://premium.wpmudev.org/forums/topic/curl-error-60-ssl-problem-on-non-https-sites#post-1273516\";s:9:\"timestamp\";s:10:\"1503802913\";s:4:\"user\";s:5:\"Brian\";s:6:\"status\";s:12:\"not_resolved\";s:6:\"unread\";b:0;s:5:\"posts\";i:4;}}}s:7:\"profile\";a:5:{s:4:\"name\";s:5:\"Brian\";s:9:\"user_name\";s:25:\"info@touristmarketing.com\";s:12:\"member_since\";i:1393735930;s:6:\"avatar\";s:185:\"https://premium.wpmudev.org/avatar/f0e748f879b19591c219ba1266f70f39?s=150&d=https%3A%2F%2Fpremium.wpmudev.org%2Fwp-content%2Fthemes%2Fwpmudev-2015-1%2Fassets%2Fimg%2Favatars%2Ff.png&r=g\";s:5:\"title\";s:4:\"Gold\";}s:6:\"points\";a:5:{s:10:\"rep_points\";i:2;s:4:\"rank\";i:41725;s:7:\"history\";a:5:{i:0;a:7:{s:4:\"type\";s:3:\"rep\";s:9:\"timestamp\";s:10:\"1503784914\";s:6:\"points\";s:1:\"1\";s:11:\"reason_code\";s:13:\"forum_comment\";s:6:\"reason\";s:189:\"You commented on the discussion <a href=\'https://premium.wpmudev.org/forums/topic/curl-error-60-ssl-problem-on-non-https-sites#post-1273516\'>cURL error 60 SSL problem on non-HTTPS sites</a>\";s:9:\"object_id\";s:7:\"1273516\";s:9:\"from_user\";s:1:\"0\";}i:1;a:7:{s:4:\"type\";s:3:\"rep\";s:9:\"timestamp\";s:10:\"1503700734\";s:6:\"points\";s:1:\"1\";s:11:\"reason_code\";s:13:\"forum_comment\";s:6:\"reason\";s:189:\"You commented on the discussion <a href=\'https://premium.wpmudev.org/forums/topic/curl-error-60-ssl-problem-on-non-https-sites#post-1273401\'>cURL error 60 SSL problem on non-HTTPS sites</a>\";s:9:\"object_id\";s:7:\"1273401\";s:9:\"from_user\";s:1:\"0\";}i:2;a:7:{s:4:\"type\";s:4:\"hero\";s:9:\"timestamp\";s:10:\"1503700734\";s:6:\"points\";s:1:\"1\";s:11:\"reason_code\";s:14:\"daily_activity\";s:6:\"reason\";s:27:\"You were active on WPMU DEV\";s:9:\"object_id\";N;s:9:\"from_user\";N;}i:3;a:7:{s:4:\"type\";s:4:\"hero\";s:9:\"timestamp\";s:10:\"1483668175\";s:6:\"points\";s:2:\"50\";s:11:\"reason_code\";s:14:\"account_signup\";s:6:\"reason\";s:78:\"You\'ve got Hero Points just for signing up. You’re on your way to greatness!\";s:9:\"object_id\";N;s:9:\"from_user\";N;}i:4;a:7:{s:4:\"type\";s:4:\"hero\";s:9:\"timestamp\";s:10:\"1482455197\";s:6:\"points\";s:1:\"3\";s:11:\"reason_code\";s:14:\"profile_detail\";s:6:\"reason\";s:96:\"You filled out the <a href=\'https://premium.wpmudev.org/hub/profile/\'>location profile field</a>\";s:9:\"object_id\";N;s:9:\"from_user\";N;}}s:11:\"hero_points\";i:54;s:9:\"rep_level\";a:4:{s:4:\"base\";i:0;s:5:\"level\";i:0;s:4:\"name\";s:0:\"\";s:5:\"title\";s:11:\"New Recruit\";}}}", "no");
INSERT INTO `wp_options` VALUES("106440", "wdp_un_remote_access", "", "no");
INSERT INTO `wp_options` VALUES("129072", "wdp_un_refresh_local_flag", "1", "no");
INSERT INTO `wp_options` VALUES("135728", "wdp_un_last_run_updates", "1544545896", "no");
INSERT INTO `wp_options` VALUES("134614", "wdp_un_last_run_profile", "1544549619", "no");
INSERT INTO `wp_options` VALUES("106450", "wdp_un_last_check_upfront", "0", "no");
INSERT INTO `wp_options` VALUES("106451", "wdp_un_last_check_autoupdate", "0", "no");
INSERT INTO `wp_options` VALUES("106452", "wdp_un_staff_notes", "", "no");
INSERT INTO `wp_options` VALUES("106454", "wdp_un_autoupdate_dashboard", "1", "no");
INSERT INTO `wp_options` VALUES("134667", "wdp_un_notifications", "a:1:{i:1509947375;a:6:{s:2:\"id\";i:1509947375;s:7:\"content\";s:270:\"<strong>We\'ve pushed all-new updates to The Hub!</strong><br />What\'s The Hub? Only the best way to manage all your sites in one place! Login to your WPMU DEV account to check out the new features. <a href=\"https://premium.wpmudev.org/hub/my-websites/\">Go to The Hub</a>\";s:9:\"dismissed\";b:0;s:11:\"can_dismiss\";b:1;s:3:\"cta\";s:0:\"\";s:11:\"time_create\";i:1522950037;}}", "no");
INSERT INTO `wp_options` VALUES("134613", "wdp_un_auth_user", "info@touristmarketing.com", "no");
INSERT INTO `wp_options` VALUES("106478", "wpmudev_apikey", "01fe25754d5af8a23eb704780feec4313ceea4a9", "no");
INSERT INTO `wp_options` VALUES("133401", "wphb_cron_limit", "2", "no");
INSERT INTO `wp_options` VALUES("99801", "updraft_combine_jobs_around", "1495566600", "yes");
INSERT INTO `wp_options` VALUES("99966", "cron", "a:19:{i:1544547532;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1544548296;a:1:{s:21:\"wordfence_hourly_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1544550105;a:1:{s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1544556663;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1544576865;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1544579423;a:1:{s:15:\"wphb_clear_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1544585689;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1544587200;a:2:{s:15:\"auditReportCron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:17:\"lockoutReportCron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1544589079;a:1:{s:22:\"wpmudev_scheduled_jobs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1544605881;a:1:{s:26:\"wordfence_daily_autoUpdate\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1544605896;a:1:{s:20:\"wordfence_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1544627519;a:1:{s:19:\"wpseo-reindex-links\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1544630980;a:1:{s:23:\"wphb_minify_clear_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1544632514;a:1:{s:50:\"snapshot-controller-full-cron-rotate_local_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:35:\"snapshot-controller-full-cron-daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1544662200;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"ff12648b2bb7a4f455935a92f69e41e5\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1544662200;}}}}i:1544887399;a:1:{s:18:\"wpseo_onpage_fetch\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1544921400;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"420e2a146b8b14aa22aba9680673e170\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1544921400;}}}}i:1545080400;a:1:{s:31:\"wordfence_email_activity_report\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("155188", "snapshot_cron_backup_run", "", "no");
INSERT INTO `wp_options` VALUES("155189", "snapshot-automate-run", "", "no");
INSERT INTO `wp_options` VALUES("99968", "user_hit_count", "a:1:{s:10:\"2018-04-05\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("99971", "mmb_stats_filter", "a:9:{i:0;a:2:{i:0;s:7:\"updates\";i:1;a:3:{s:7:\"plugins\";b:1;s:6:\"themes\";b:1;s:7:\"premium\";b:1;}}i:1;a:2:{i:0;s:11:\"core_update\";i:1;a:1:{s:4:\"core\";b:1;}}i:2;a:2:{i:0;s:5:\"posts\";i:1;a:1:{s:11:\"numberposts\";i:5;}}i:3;a:2:{i:0;s:6:\"drafts\";i:1;a:1:{s:11:\"numberposts\";i:5;}}i:4;a:2:{i:0;s:9:\"scheduled\";i:1;a:1:{s:11:\"numberposts\";i:5;}}i:5;a:1:{i:0;s:11:\"hit_counter\";}i:6;a:2:{i:0;s:8:\"comments\";i:1;a:1:{s:11:\"numberposts\";i:5;}}i:7;a:1:{i:0;s:7:\"backups\";}s:7:\"plugins\";a:1:{s:7:\"cleanup\";a:3:{s:8:\"overhead\";a:0:{}s:9:\"revisions\";a:1:{s:11:\"num_to_keep\";s:3:\"r_5\";}s:4:\"spam\";a:0:{}}}}", "yes");
INSERT INTO `wp_options` VALUES("99979", "wordfence_syncingAttackData", "0", "no");
INSERT INTO `wp_options` VALUES("106840", "wphb-is-cloudflare", "0", "no");
INSERT INTO `wp_options` VALUES("106833", "wphb-pro", "yes", "no");
INSERT INTO `wp_options` VALUES("106424", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("106425", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("106426", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("135717", "wdp_un_updates_data", "a:5:{s:8:\"projects\";a:112:{i:119;a:26:{s:2:\"id\";i:119;s:4:\"paid\";s:4:\"free\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:18:\"WPMU DEV Dashboard\";s:8:\"released\";i:1261074923;s:7:\"updated\";i:1543901149;s:9:\"downloads\";s:7:\"2354089\";s:10:\"popularity\";s:6:\"249560\";s:17:\"short_description\";s:80:\"Instant access to brilliant support and one-click plugin and theme installation.\";s:8:\"features\";a:32:{i:0;s:23:\"One-click installations\";i:1;s:19:\"Unbranded analytics\";i:2;s:35:\"Dashboard plugin browse and install\";i:3;s:34:\"Dashboard theme browse and install\";i:4;s:21:\"Simply login to setup\";i:5;s:30:\"Integrated badge notifications\";i:6;s:17:\"One-click updates\";i:7;s:28:\"WPMU DEV dashboard news feed\";i:8;s:28:\"Dashboard widget quick links\";i:9;s:25:\"New release notifications\";i:10;s:20:\"Update notifications\";i:11;s:29:\"View recent WPMU DEV activity\";i:12;s:18:\"Membership manager\";i:13;s:34:\"Hide/Remove WPMU DEV hero branding\";i:14;s:18:\"Background updates\";i:15;s:18:\"Hide notifications\";i:16;s:30:\"Limit to Multisite Super Admin\";i:17;s:21:\"See reputation points\";i:18;s:27:\"Built-in conflict avoidance\";i:19;s:39:\"Occasional special membership discounts\";i:20;s:33:\"Participate in WPMU DEV community\";i:21;s:19:\"Access forum search\";i:22;s:22:\"Fast access to Q&amp;A\";i:23;s:39:\"Grant temporary access to support staff\";i:24;s:34:\"Direct links to usage instructions\";i:25;s:35:\"Installed theme version information\";i:26;s:36:\"Installed plugin version information\";i:27;s:22:\"Post support questions\";i:28;s:29:\"System information quick view\";i:29;s:29:\"PHP configuration information\";i:30;s:17:\"MySQL information\";i:31;s:18:\"Server information\";}s:7:\"version\";s:3:\"4.6\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:55:\"https://premium.wpmudev.org/project/wpmu-dev-dashboard/\";s:9:\"thumbnail\";s:76:\"https://premium.wpmudev.org/wp-content/uploads/2009/12/Dashboard-280x158.png\";s:16:\"thumbnail_square\";s:74:\"https://premium.wpmudev.org/wp-content/uploads/2009/12/Dashboard-90x90.png\";s:15:\"thumbnail_large\";s:68:\"https://premium.wpmudev.org/wp-content/uploads/2009/12/Dashboard.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/irz1r2ze9m\";s:13:\"wp_config_url\";s:31:\"admin.php?page=wpmudev-settings\";s:13:\"ms_config_url\";s:31:\"admin.php?page=wpmudev-settings\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:96:\"https://premium.wpmudev.org/wp-content/projects/119/screenshots/1372759941_rebrand-dashboard.png\";s:4:\"desc\";s:25:\"Hero hider and rebranding\";}i:1;a:2:{s:3:\"url\";s:86:\"https://premium.wpmudev.org/wp-content/projects/119/screenshots/96343734_analitics.png\";s:4:\"desc\";s:19:\"Unbranded Analytics\";}i:2;a:2:{s:3:\"url\";s:103:\"https://premium.wpmudev.org/wp-content/projects/119/screenshots/1703464822_login-735x470-compressor.jpg\";s:4:\"desc\";s:12:\"Login screen\";}i:3;a:2:{s:3:\"url\";s:109:\"https://premium.wpmudev.org/wp-content/projects/119/screenshots/661633590_quick-access-735x470-compressor.jpg\";s:4:\"desc\";s:10:\"Quicklinks\";}}s:6:\"_order\";i:1;}i:2097296;a:26:{s:2:\"id\";i:2097296;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:14:\"Forminator Pro\";s:8:\"released\";i:1519137568;s:7:\"updated\";i:-62169984000;s:9:\"downloads\";s:5:\"29354\";s:10:\"popularity\";s:4:\"6804\";s:17:\"short_description\";s:135:\"Drag and drop WordPress form builder plugin with interactive polls and quizzes for increasing user engagement and building a following.\";s:8:\"features\";a:29:{i:0;s:31:\"Responsive fit for every screen\";i:1;s:13:\"Developer API\";i:2;s:16:\"Google ReCAPTCHA\";i:3;s:26:\"Drag-and-drop form builder\";i:4;s:26:\"Forms  for every situation\";i:5;s:15:\"+15 Form blocks\";i:6;s:22:\"Toggle styling options\";i:7;s:16:\"Campaign Monitor\";i:8;s:14:\"ActiveCampaign\";i:9;s:13:\"Google Sheets\";i:10;s:31:\"Zapier (connects to +1000 apps)\";i:11;s:18:\"Trello Integration\";i:12;s:9:\"MailChimp\";i:13;s:6:\"AWeber\";i:14;s:17:\"Interactive polls\";i:15;s:18:\"Pagination options\";i:16;s:23:\"Collect and track stats\";i:17;s:23:\"No wrong answer quizzes\";i:18;s:21:\"Submissions dashboard\";i:19;s:15:\"Knowledge tests\";i:20;s:12:\"Live preview\";i:21;s:15:\"Knowledge tests\";i:22;s:24:\"Gutenberg block included\";i:23;s:10:\"GDPR ready\";i:24;s:13:\"Hidden fields\";i:25;s:27:\"Customized submission forms\";i:26;s:32:\"Schedule form submission reports\";i:27;s:16:\"Privacy settings\";i:28;s:29:\"Advanced email configurations\";}s:7:\"version\";s:7:\"1.6.0.1\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:61:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0, Upfront 1.9.4\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:51:\"https://premium.wpmudev.org/project/forminator-pro/\";s:9:\"thumbnail\";s:85:\"https://premium.wpmudev.org/wp-content/uploads/2018/02/forminator-feature-280x158.png\";s:16:\"thumbnail_square\";s:83:\"https://premium.wpmudev.org/wp-content/uploads/2018/02/forminator-feature-90x90.png\";s:15:\"thumbnail_large\";s:77:\"https://premium.wpmudev.org/wp-content/uploads/2018/02/forminator-feature.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:105:\"https://premium.wpmudev.org/wp-content/projects/2097296/screenshots/1276807337_forminator-recaptcha-4.gif\";s:4:\"desc\";s:32:\"Forminator ReCAPTCHA Integration\";}i:1;a:2:{s:3:\"url\";s:98:\"https://premium.wpmudev.org/wp-content/projects/2097296/screenshots/1690180223_forminator-quiz.png\";s:4:\"desc\";s:15:\"Forminator quiz\";}i:2;a:2:{s:3:\"url\";s:101:\"https://premium.wpmudev.org/wp-content/projects/2097296/screenshots/1437585076_forminator-polls-2.png\";s:4:\"desc\";s:23:\"Forminator Poll results\";}i:3;a:2:{s:3:\"url\";s:97:\"https://premium.wpmudev.org/wp-content/projects/2097296/screenshots/1414388846_contact-form-5.png\";s:4:\"desc\";s:23:\"Forminator contact form\";}}s:6:\"_order\";i:2;}i:1081723;a:26:{s:2:\"id\";i:1081723;s:4:\"paid\";s:4:\"full\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:8:\"Defender\";s:8:\"released\";i:1456837142;s:7:\"updated\";i:-62169984000;s:9:\"downloads\";s:6:\"593385\";s:10:\"popularity\";s:5:\"82098\";s:17:\"short_description\";s:104:\"Regular security scans, vulnerability reports, safety recommendations and security tweaks for WordPress.\";s:8:\"features\";a:20:{i:0;s:21:\"Analyze site security\";i:1;s:30:\"Security tweak recommendations\";i:2;s:27:\"Resolve issues with a click\";i:3;s:31:\"Manual and automatic IP lockout\";i:4;s:18:\"Filterable IP logs\";i:5;s:27:\"Scan core files for changes\";i:6;s:25:\"2-Factor Authentification\";i:7;s:24:\"Customize 2-factor email\";i:8;s:19:\"Vulnerability scans\";i:9;s:14:\"Schedule scans\";i:10;s:28:\"Repair/restore changed files\";i:11;s:25:\"Choose file types to scan\";i:12;s:29:\"Skip files based on file size\";i:13;s:21:\"Receive email reports\";i:14;s:21:\"Set report recipients\";i:15;s:27:\"Google blacklist monitoring\";i:16;s:17:\"Automated backups\";i:17;s:20:\"Full website backups\";i:18;s:13:\"Cloud backups\";i:19;s:30:\"Site interactions with logging\";}s:7:\"version\";s:5:\"2.0.1\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:61:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0, Upfront 1.9.4\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:48:\"https://premium.wpmudev.org/project/wp-defender/\";s:9:\"thumbnail\";s:75:\"https://premium.wpmudev.org/wp-content/uploads/2016/02/Defender-280x158.png\";s:16:\"thumbnail_square\";s:73:\"https://premium.wpmudev.org/wp-content/uploads/2016/02/Defender-90x90.png\";s:15:\"thumbnail_large\";s:67:\"https://premium.wpmudev.org/wp-content/uploads/2016/02/Defender.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/ps9y7nphu1\";s:13:\"wp_config_url\";s:26:\"admin.php?page=wp-defender\";s:13:\"ms_config_url\";s:26:\"admin.php?page=wp-defender\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:94:\"https://premium.wpmudev.org/wp-content/projects/1081723/screenshots/675480798_6-ip-lockout.jpg\";s:4:\"desc\";s:10:\"ip-lockout\";}i:1;a:2:{s:3:\"url\";s:94:\"https://premium.wpmudev.org/wp-content/projects/1081723/screenshots/1734340993_5-blacklist.jpg\";s:4:\"desc\";s:20:\"Blacklist Monitoring\";}i:2;a:2:{s:3:\"url\";s:95:\"https://premium.wpmudev.org/wp-content/projects/1081723/screenshots/1971221549_4-audit-logs.jpg\";s:4:\"desc\";s:10:\"Audit Logs\";}i:3;a:2:{s:3:\"url\";s:89:\"https://premium.wpmudev.org/wp-content/projects/1081723/screenshots/1252355198_3-scan.jpg\";s:4:\"desc\";s:12:\"Scan Reports\";}}s:6:\"_order\";i:3;}i:1107020;a:26:{s:2:\"id\";i:1107020;s:4:\"paid\";s:4:\"full\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:6:\"Hustle\";s:8:\"released\";i:1471315160;s:7:\"updated\";i:-62169984000;s:9:\"downloads\";s:5:\"81774\";s:10:\"popularity\";s:5:\"10469\";s:17:\"short_description\";s:100:\"Grow your business and audience with this super easy, super slick email opt-in and marketing plugin.\";s:8:\"features\";a:16:{i:0;s:78:\"Build your business like a pro with the ultimate WordPress email opt-in plugin\";i:1;s:56:\"Pop-up, slide-ins, widgets, embeds and after post opt-in\";i:2;s:35:\"All the social share icons you need\";i:3;s:46:\"Easily customize designs with in built editing\";i:4;s:34:\"Color match your brand, like magic\";i:5;s:43:\"Heaps of smooth built-in display animations\";i:6;s:173:\"Aweber, MailChimp, Constant Contacts, Sendy, ActiveCampaign, SendInBlue, Hubspot, Infusionsoft, Mad Mimi, ConvertKit, MailerLite, iContact, GetResponse, and Campaign Monitor\";i:7;s:46:\"And of course our very own e-Newsletter plugin\";i:8;s:58:\"Manage who sees your hustle with super powerful conditions\";i:9;s:47:\"Track how many times your material is displayed\";i:10;s:42:\"See submissions straight through WordPress\";i:11;s:57:\"Conversion rates overview will make your clients ecstatic\";i:12;s:36:\"Great default layouts to choose from\";i:13;s:25:\"Easy management dashboard\";i:14;s:49:\"New features, layouts and sass coming every month\";i:15;s:38:\"And, of course, completely free to try\";}s:7:\"version\";s:5:\"3.0.6\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:56:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0, bbPress \";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:43:\"https://premium.wpmudev.org/project/hustle/\";s:9:\"thumbnail\";s:76:\"https://premium.wpmudev.org/wp-content/uploads/2016/08/hustle-01-280x158.png\";s:16:\"thumbnail_square\";s:74:\"https://premium.wpmudev.org/wp-content/uploads/2016/08/hustle-01-90x90.png\";s:15:\"thumbnail_large\";s:68:\"https://premium.wpmudev.org/wp-content/uploads/2016/08/hustle-01.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/rwpa1uwzyn\";s:13:\"wp_config_url\";s:21:\"admin.php?page=hustle\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:102:\"https://premium.wpmudev.org/wp-content/projects/1107020/screenshots/960353611_hustle-social-design.png\";s:4:\"desc\";s:18:\"Hustle Social Bars\";}i:1;a:2:{s:3:\"url\";s:100:\"https://premium.wpmudev.org/wp-content/projects/1107020/screenshots/1653524749_2-style-options-1.jpg\";s:4:\"desc\";s:21:\"Hustle Layout Options\";}i:2;a:2:{s:3:\"url\";s:101:\"https://premium.wpmudev.org/wp-content/projects/1107020/screenshots/469638973_premadecolorschemes.png\";s:4:\"desc\";s:20:\"Hustle Color Schemes\";}i:3;a:2:{s:3:\"url\";s:98:\"https://premium.wpmudev.org/wp-content/projects/1107020/screenshots/938384474_layoutvariations.png\";s:4:\"desc\";s:24:\"Hustle Design Variations\";}}s:6:\"_order\";i:4;}i:1081721;a:26:{s:2:\"id\";i:1081721;s:4:\"paid\";s:4:\"full\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:11:\"Hummingbird\";s:8:\"released\";i:1456236462;s:7:\"updated\";i:-62169984000;s:9:\"downloads\";s:6:\"675871\";s:10:\"popularity\";s:5:\"89064\";s:17:\"short_description\";s:56:\"Everything you need to get your site running super fast.\";s:8:\"features\";a:16:{i:0;s:28:\"Generate performance reports\";i:1;s:30:\"Recommended speed improvements\";i:2;s:15:\"Browser caching\";i:3;s:17:\"Full-page caching\";i:4;s:16:\"Gravatar caching\";i:5;s:11:\"RSS caching\";i:6;s:12:\"Minify files\";i:7;s:13:\"Combine files\";i:8;s:17:\"Set load position\";i:9;s:21:\"Included output graph\";i:10;s:25:\"Simple GZIP configuration\";i:11;s:30:\"Advanced Minification controls\";i:12;s:31:\"Bonus: Sync with Uptime monitor\";i:13;s:32:\"Down and slow load notifications\";i:14;s:23:\"Track average pagespeed\";i:15;s:32:\"Better search engine positioning\";}s:7:\"version\";s:5:\"1.9.3\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:43:\"WordPress 5.0, Multisite 5.0, Upfront 1.9.4\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:51:\"https://premium.wpmudev.org/project/wp-hummingbird/\";s:9:\"thumbnail\";s:78:\"https://premium.wpmudev.org/wp-content/uploads/2016/02/HummingBird-280x158.png\";s:16:\"thumbnail_square\";s:76:\"https://premium.wpmudev.org/wp-content/uploads/2016/02/HummingBird-90x90.png\";s:15:\"thumbnail_large\";s:70:\"https://premium.wpmudev.org/wp-content/uploads/2016/02/HummingBird.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/cdpqnbvssg\";s:13:\"wp_config_url\";s:19:\"admin.php?page=wphb\";s:13:\"ms_config_url\";s:19:\"admin.php?page=wphb\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:111:\"https://premium.wpmudev.org/wp-content/projects/1081721/screenshots/1355502351_hum-gcompress-compressor-new.png\";s:4:\"desc\";s:5:\"G-zip\";}i:1;a:2:{s:3:\"url\";s:100:\"https://premium.wpmudev.org/wp-content/projects/1081721/screenshots/1686427142_hum-browser-cache.png\";s:4:\"desc\";s:13:\"Browser Cache\";}i:2;a:2:{s:3:\"url\";s:97:\"https://premium.wpmudev.org/wp-content/projects/1081721/screenshots/355595470_hum-pro-testing.png\";s:4:\"desc\";s:31:\"Hummingbird Performance Testing\";}i:3;a:2:{s:3:\"url\";s:100:\"https://premium.wpmudev.org/wp-content/projects/1081721/screenshots/2090545727_hum-inline-minify.png\";s:4:\"desc\";s:13:\"inline minify\";}}s:6:\"_order\";i:5;}i:257;a:26:{s:2:\"id\";i:257;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:12:\"Snapshot Pro\";s:8:\"released\";i:1328745252;s:7:\"updated\";i:-62169984000;s:9:\"downloads\";s:6:\"431676\";s:10:\"popularity\";s:5:\"55172\";s:17:\"short_description\";s:96:\"The automated, on-demand time-traveler that snaps and stores backups for one-click restoration. \";s:8:\"features\";a:28:{i:0;s:30:\"10GB of WPMU DEV cloud storage\";i:1;s:22:\"The Hub backup manager\";i:2;s:17:\"Redundant backups\";i:3;s:22:\"Server info quick view\";i:4;s:19:\"Manage memory usage\";i:5;s:32:\"Multisite Global file exclusions\";i:6;s:10:\"ZipArchive\";i:7;s:6:\"PclZip\";i:8;s:35:\"Size segmenting eliminates timeouts\";i:9;s:17:\"Scheduled backups\";i:10;s:19:\"Set backup interval\";i:11;s:13:\"Manual backup\";i:12;s:20:\"Multisite compatible\";i:13;s:18:\"Backup entire site\";i:14;s:19:\"Include media files\";i:15;s:22:\"Exclude specific files\";i:16;s:18:\"Annotate snapshots\";i:17;s:25:\"Set custom backup folders\";i:18;s:22:\"Downloadable log files\";i:19;s:24:\"Simple one-click restore\";i:20;s:26:\"Utilize standard WP tables\";i:21;s:11:\"Mirror sync\";i:22;s:30:\"Set number of backups to store\";i:23;s:34:\"Automatically remove oldest backup\";i:24;s:19:\"Dropbox integration\";i:25;s:21:\"Amazon S3 integration\";i:26;s:24:\"FTP and SFTP integration\";i:27;s:24:\"Google Drive integration\";}s:7:\"version\";s:7:\"3.1.9.2\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:61:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0, Upfront 1.9.4\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:45:\"https://premium.wpmudev.org/project/snapshot/\";s:9:\"thumbnail\";s:82:\"https://premium.wpmudev.org/wp-content/uploads/2012/02/Snapshot_plugin-280x158.png\";s:16:\"thumbnail_square\";s:80:\"https://premium.wpmudev.org/wp-content/uploads/2012/02/Snapshot_plugin-90x90.png\";s:15:\"thumbnail_large\";s:74:\"https://premium.wpmudev.org/wp-content/uploads/2012/02/Snapshot_plugin.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/7x4kcv4j15\";s:13:\"wp_config_url\";s:37:\"admin.php?page=snapshot_pro_dashboard\";s:13:\"ms_config_url\";s:37:\"admin.php?page=snapshot_pro_dashboard\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:94:\"https://premium.wpmudev.org/wp-content/projects/257/screenshots/1315522110_schedule-backup.jpg\";s:4:\"desc\";s:30:\"Schedule backups with Snapshot\";}i:1;a:2:{s:3:\"url\";s:97:\"https://premium.wpmudev.org/wp-content/projects/257/screenshots/882714582_destinations-backup.jpg\";s:4:\"desc\";s:20:\"Choose a destination\";}i:2;a:2:{s:3:\"url\";s:91:\"https://premium.wpmudev.org/wp-content/projects/257/screenshots/905771522_snapshot-dash.jpg\";s:4:\"desc\";s:18:\"Snapshot Dashboard\";}i:3;a:2:{s:3:\"url\";s:94:\"https://premium.wpmudev.org/wp-content/projects/257/screenshots/1953204640_managed-backups.jpg\";s:4:\"desc\";s:15:\"Managed Backups\";}}s:6:\"_order\";i:6;}i:912164;a:26:{s:2:\"id\";i:912164;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:12:\"WP Smush Pro\";s:8:\"released\";i:1416856433;s:7:\"updated\";i:-62169984000;s:9:\"downloads\";s:7:\"1067446\";s:10:\"popularity\";s:6:\"162673\";s:17:\"short_description\";s:68:\"Incredibly efficient image optimization for blazing fast load times.\";s:8:\"features\";a:24:{i:0;s:39:\"Automatically optimize images on upload\";i:1;s:25:\"Process JPEG, GIF and PNG\";i:2;s:38:\"Bulk smush all the images on your site\";i:3;s:27:\"Lossless compression option\";i:4;s:32:\"Smush any image in any directory\";i:5;s:29:\"Super-Smush Lossy Compression\";i:6;s:12:\"Image resize\";i:7;s:24:\"WP Offload S3 compatible\";i:8;s:21:\"Smush original images\";i:9;s:35:\"Global Smush Settings for Multisite\";i:10;s:42:\"Lossy compression with little quality loss\";i:11;s:26:\"NextGEN Gallery compatible\";i:12;s:18:\"Preserve EXIF data\";i:13;s:20:\"Keep original images\";i:14;s:28:\"Supports WP Retina 2x Plugin\";i:15;s:26:\"Dedicated smushing servers\";i:16;s:23:\"Smush images up to 32MB\";i:17;s:13:\"HTTPS support\";i:18;s:21:\"WPML media compatible\";i:19;s:39:\"Strip unused colors from indexed images\";i:20;s:25:\"Convert PNG to lossy JPEG\";i:21;s:33:\"Tracks progress and total savings\";i:22;s:26:\"Compress individual images\";i:23;s:29:\"Fast asynchronous compression\";}s:7:\"version\";s:5:\"3.0.1\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:61:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0, Upfront 1.9.4\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:49:\"https://premium.wpmudev.org/project/wp-smush-pro/\";s:9:\"thumbnail\";s:80:\"https://premium.wpmudev.org/wp-content/uploads/2014/11/Smush_2016_02-280x158.png\";s:16:\"thumbnail_square\";s:78:\"https://premium.wpmudev.org/wp-content/uploads/2014/11/Smush_2016_02-90x90.png\";s:15:\"thumbnail_large\";s:72:\"https://premium.wpmudev.org/wp-content/uploads/2014/11/Smush_2016_02.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/9cbykj0q0z\";s:13:\"wp_config_url\";s:20:\"admin.php?page=smush\";s:13:\"ms_config_url\";s:20:\"admin.php?page=smush\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:100:\"https://premium.wpmudev.org/wp-content/projects/912164/screenshots/1554180963_smush-pro-bulk-new.png\";s:4:\"desc\";s:14:\"Bulk Smush Now\";}i:1;a:2:{s:3:\"url\";s:101:\"https://premium.wpmudev.org/wp-content/projects/912164/screenshots/918101858_smush-pro-bulk-smush.png\";s:4:\"desc\";s:20:\"Smush Pro Bulk Smush\";}i:2;a:2:{s:3:\"url\";s:99:\"https://premium.wpmudev.org/wp-content/projects/912164/screenshots/158049080_smush-pro-settings.png\";s:4:\"desc\";s:18:\"Smush Pro Settings\";}i:3;a:2:{s:3:\"url\";s:99:\"https://premium.wpmudev.org/wp-content/projects/912164/screenshots/665647559_image-zoom-735x470.jpg\";s:4:\"desc\";s:29:\"Smush without loss of quality\";}}s:6:\"_order\";i:7;}i:167;a:26:{s:2:\"id\";i:167;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:14:\"SmartCrawl Pro\";s:8:\"released\";i:1298566937;s:7:\"updated\";i:-62169984000;s:9:\"downloads\";s:6:\"297039\";s:10:\"popularity\";s:5:\"41859\";s:17:\"short_description\";s:100:\"Boost your PageRank and drive more traffic to your site with little effort and simple configuration.\";s:8:\"features\";a:40:{i:0;s:22:\"Simple guided settings\";i:1;s:30:\"Offer SEO options by user role\";i:2;s:30:\"Direct interaction with Google\";i:3;s:28:\"Direct interaction with Bing\";i:4;s:48:\"Send sitemap updates automatic to search engines\";i:5;s:32:\"Title and meta data optimization\";i:6;s:26:\"Automatic sitewide linking\";i:7;s:24:\"Complete Moz integration\";i:8;s:38:\"Multisite and BuddyPress compatibility\";i:9;s:36:\"Process posts and pages individually\";i:10;s:17:\"Process RSS feeds\";i:11;s:31:\"Conduct case sensitive matching\";i:12;s:23:\"Prevent duplicate links\";i:13;s:28:\"Open links in new tab/window\";i:14;s:35:\"Exclude posts or pages from sitemap\";i:15;s:25:\"Exclude custom post types\";i:16;s:18:\"Exclude categories\";i:17;s:12:\"Exclude tags\";i:18;s:25:\"Exclude custom taxonomies\";i:19;s:25:\"Include or exclude images\";i:20;s:30:\"Include or exclude stylesheets\";i:21;s:46:\"Include or remove the sitemap dashboard widget\";i:22;s:35:\"Disabling automatic sitemap updates\";i:23;s:17:\"Custom home title\";i:24;s:21:\"Home meta description\";i:25;s:8:\"Keywords\";i:26;s:51:\"Import/export to quickly add SmartCrawl to any site\";i:27;s:39:\"Yoast SEO settings and content importer\";i:28;s:44:\"All in One SEO settings and content importer\";i:29;s:37:\"Main blog archive meta robots options\";i:30;s:19:\"Post title defaults\";i:31;s:30:\"Post meta description defaults\";i:32;s:20:\"Media title defaults\";i:33;s:31:\"Media meta description defaults\";i:34;s:41:\"Custom post titles (per custom post type)\";i:35;s:52:\"Custom post meta descriptions (per custom post type)\";i:36;s:65:\"Post categories, tags and custom taxonomy title and meta defaults\";i:37;s:53:\"Post categories, tags and custom taxonomy robots tags\";i:38;s:24:\"Author and date archives\";i:39;s:39:\"404 page title and description defaults\";}s:7:\"version\";s:5:\"2.2.4\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:61:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0, Upfront 1.9.4\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:61:\"https://premium.wpmudev.org/project/smartcrawl-wordpress-seo/\";s:9:\"thumbnail\";s:106:\"https://premium.wpmudev.org/wp-content/uploads/2011/02/SEO_Webcrawler_1470_SEO_Webcrawler_1470-280x158.png\";s:16:\"thumbnail_square\";s:104:\"https://premium.wpmudev.org/wp-content/uploads/2011/02/SEO_Webcrawler_1470_SEO_Webcrawler_1470-90x90.png\";s:15:\"thumbnail_large\";s:98:\"https://premium.wpmudev.org/wp-content/uploads/2011/02/SEO_Webcrawler_1470_SEO_Webcrawler_1470.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/w6t8a9mq8j\";s:13:\"wp_config_url\";s:35:\"options-general.php?page=wds_wizard\";s:13:\"ms_config_url\";s:28:\"settings.php?page=wds_wizard\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:96:\"https://premium.wpmudev.org/wp-content/projects/167/screenshots/906662147_smartcrawl-checkup.png\";s:4:\"desc\";s:18:\"SmartCrawl Checkup\";}i:1;a:2:{s:3:\"url\";s:97:\"https://premium.wpmudev.org/wp-content/projects/167/screenshots/1008740409_smartcrawl-sitemap.png\";s:4:\"desc\";s:18:\"SmartCrawl Sitemap\";}i:2;a:2:{s:3:\"url\";s:101:\"https://premium.wpmudev.org/wp-content/projects/167/screenshots/1267268902_smartcrawl-autolinking.png\";s:4:\"desc\";s:22:\"SmartCrawl autolinking\";}i:3;a:2:{s:3:\"url\";s:111:\"https://premium.wpmudev.org/wp-content/projects/167/screenshots/205500292_smartcrawl-readability-compressor.png\";s:4:\"desc\";s:22:\"SmartCrawl Readability\";}}s:6:\"_order\";i:8;}i:9135;a:26:{s:2:\"id\";i:9135;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:17:\"Ultimate Branding\";s:8:\"released\";i:1339280384;s:7:\"updated\";i:-62169984000;s:9:\"downloads\";s:6:\"381722\";s:10:\"popularity\";s:5:\"34724\";s:17:\"short_description\";s:80:\"Complete custom branding on both the front and back end of your site or network.\";s:8:\"features\";a:40:{i:0;s:25:\"Remove WordPress branding\";i:1;s:21:\"Highlight your design\";i:2;s:32:\"Add custom logo to the Admin Bar\";i:3;s:33:\"Simple WordPress logo replacement\";i:4;s:26:\"Create custom login screen\";i:5;s:28:\"Replace the word \"WordPress\"\";i:6;s:21:\"Simple brand matching\";i:7;s:21:\"Import/Export setting\";i:8;s:26:\"Reorganize Admin Bar menus\";i:9;s:26:\"Set custom Admin Bar menus\";i:10;s:28:\"Add a direct link to support\";i:11;s:16:\"Add help buttons\";i:12;s:29:\"Send system emails using SMTP\";i:13;s:29:\"Remove core Dashboard widgets\";i:14;s:32:\"Hide 3rd-party dashboard widgets\";i:15;s:29:\"Replace the WordPress \'Howdy\'\";i:16;s:28:\"Coming Soon/Maintenance Mode\";i:17;s:30:\"Customize \'Admin Help Content\'\";i:18;s:32:\"Increase site security and speed\";i:19;s:27:\"One plugin for all settings\";i:20;s:25:\"Create a custom admin bar\";i:21;s:24:\"Set \"From\" Email address\";i:22;s:15:\"Multisite ready\";i:23;s:26:\"Customize/add help content\";i:24;s:20:\"Custom global footer\";i:25;s:20:\"Custom global header\";i:26;s:23:\"Custom dashboard footer\";i:27;s:23:\"Rebrand the meta widget\";i:28;s:22:\"Protect site structure\";i:29;s:27:\"Hide \'Permalinks\' menu item\";i:30;s:25:\"Replace WordPress in HTML\";i:31;s:26:\"Replace any word or phrase\";i:32;s:20:\"Set a custom Favicon\";i:33;s:25:\"Custom Multisite Favicons\";i:34;s:19:\"Customize admin CSS\";i:35;s:21:\"Uses CSS child fields\";i:36;s:22:\"Hide WordPress welcome\";i:37;s:34:\"Add custom dashboard color schemes\";i:38;s:29:\"Display custom admin messages\";i:39;s:30:\"Add Author Boxes to your posts\";}s:7:\"version\";s:3:\"2.3\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:61:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0, Upfront 1.9.4\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:54:\"https://premium.wpmudev.org/project/ultimate-branding/\";s:9:\"thumbnail\";s:102:\"https://premium.wpmudev.org/wp-content/uploads/2012/06/Ultimate_Branding_Product_page_dark-280x158.png\";s:16:\"thumbnail_square\";s:100:\"https://premium.wpmudev.org/wp-content/uploads/2012/06/Ultimate_Branding_Product_page_dark-90x90.png\";s:15:\"thumbnail_large\";s:94:\"https://premium.wpmudev.org/wp-content/uploads/2012/06/Ultimate_Branding_Product_page_dark.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/cel1u3widu\";s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:23:\"admin.php?page=branding\";s:7:\"package\";i:0;s:11:\"screenshots\";a:3:{i:0;a:2:{s:3:\"url\";s:91:\"https://premium.wpmudev.org/wp-content/projects/9135/screenshots/386819911_login-screen.gif\";s:4:\"desc\";s:19:\"Custom login screen\";}i:1;a:2:{s:3:\"url\";s:102:\"https://premium.wpmudev.org/wp-content/projects/9135/screenshots/853652413_wordpress-logos-735x470.jpg\";s:4:\"desc\";s:26:\"Replace WordPress branding\";}i:2;a:2:{s:3:\"url\";s:95:\"https://premium.wpmudev.org/wp-content/projects/9135/screenshots/1121404532_modules-735x470.jpg\";s:4:\"desc\";s:25:\"Ultimate Branding modules\";}}s:6:\"_order\";i:9;}i:51;a:26:{s:2:\"id\";i:51;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:18:\"Google Analytics +\";s:8:\"released\";i:1235347220;s:7:\"updated\";i:-62169984000;s:9:\"downloads\";s:6:\"201090\";s:10:\"popularity\";s:5:\"35281\";s:17:\"short_description\";s:89:\"Google Analytics for a site or an entire network without leaving the WordPress dashboard.\";s:8:\"features\";a:20:{i:0;s:30:\"Powerful Multisite integration\";i:1;s:39:\"One tracking code for an entire network\";i:2;s:26:\"Individual post statistics\";i:3;s:31:\"Statistics module for Edit Post\";i:4;s:26:\"Analytics dashboard widget\";i:5;s:28:\"Integrates statistics screen\";i:6;s:28:\"Toggle statistics date range\";i:7;s:12:\"Track visits\";i:8;s:16:\"Track page views\";i:9;s:16:\"View Bounce Rate\";i:10;s:18:\"See visit duration\";i:11;s:10:\"New visits\";i:12;s:23:\"See top referring links\";i:13;s:22:\"See top post and pages\";i:14;s:34:\"World map with visitors by country\";i:15;s:32:\"Graphs for fast visual reference\";i:16;s:23:\"Collect sub-domain data\";i:17;s:21:\"Tracks mapped domains\";i:18;s:30:\"Integrates with Domain Mapping\";i:19;s:26:\"Fully Pro Sites compatible\";}s:7:\"version\";s:7:\"3.1.7.2\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:104:\"https://premium.wpmudev.org/project/google-analytics-for-wordpress-mu-sitewide-and-single-blog-solution/\";s:9:\"thumbnail\";s:82:\"https://premium.wpmudev.org/wp-content/uploads/2009/02/wp-stats-plugin-280x158.png\";s:16:\"thumbnail_square\";s:80:\"https://premium.wpmudev.org/wp-content/uploads/2009/02/wp-stats-plugin-90x90.png\";s:15:\"thumbnail_large\";s:74:\"https://premium.wpmudev.org/wp-content/uploads/2009/02/wp-stats-plugin.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/hoys33sfb0\";s:13:\"wp_config_url\";s:41:\"options-general.php?page=google-analytics\";s:13:\"ms_config_url\";s:34:\"settings.php?page=google-analytics\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:89:\"https://premium.wpmudev.org/wp-content/projects/51/screenshots/1034790938_g-analitics.png\";s:4:\"desc\";s:13:\"tracking code\";}i:1;a:2:{s:3:\"url\";s:98:\"https://premium.wpmudev.org/wp-content/projects/51/screenshots/552377122_analytics-fix-735x470.jpg\";s:4:\"desc\";s:21:\"Pro Sites Integration\";}i:2;a:2:{s:3:\"url\";s:96:\"https://premium.wpmudev.org/wp-content/projects/51/screenshots/560795892_google-dash-735x470.jpg\";s:4:\"desc\";s:11:\"Small graph\";}i:3;a:2:{s:3:\"url\";s:92:\"https://premium.wpmudev.org/wp-content/projects/51/screenshots/1782085428_dash-2-735x470.jpg\";s:4:\"desc\";s:36:\"Google Analytics WordPress dashboard\";}}s:6:\"_order\";i:10;}i:913071;a:26:{s:2:\"id\";i:913071;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:15:\"CoursePress Pro\";s:8:\"released\";i:1410260000;s:7:\"updated\";i:1533225975;s:9:\"downloads\";s:5:\"82178\";s:10:\"popularity\";s:4:\"3835\";s:17:\"short_description\";s:81:\"Creating, managing and selling online courses in WordPress has never been easier.\";s:8:\"features\";a:33:{i:0;s:25:\"Unlimited course creation\";i:1;s:14:\"Course teasers\";i:2;s:22:\"Full video integration\";i:3;s:19:\"Share audio content\";i:4;s:32:\"Includes a powerful quiz builder\";i:5;s:20:\"Out-of-the-box setup\";i:6;s:14:\"Course paywall\";i:7;s:23:\"MarketPress integration\";i:8;s:23:\"WooCommerce integration\";i:9;s:35:\"Access to over 100 payment gateways\";i:10;s:22:\"Includes amazing theme\";i:11;s:31:\"Automated and manual assessment\";i:12;s:30:\"Automated and manual reporting\";i:13;s:18:\"Offer free courses\";i:14;s:18:\"Course description\";i:15;s:23:\"Import and export tools\";i:16;s:32:\"Course and unit progress display\";i:17;s:24:\"Custom define user roles\";i:18;s:20:\"Course certification\";i:19;s:44:\"Customize certificate design for each course\";i:20;s:26:\"Complete shortcode library\";i:21;s:28:\"Interactive discussion board\";i:22;s:24:\"Built-in email marketing\";i:23;s:21:\"Custom slug structure\";i:24;s:21:\"Use custom login form\";i:25;s:30:\"Auto add pages to Primary Menu\";i:26;s:14:\"Login redirect\";i:27;s:27:\"Show instructor name in URL\";i:28;s:21:\"Set course image size\";i:29;s:13:\"Order by date\";i:30;s:20:\"Order by post number\";i:31;s:24:\"Set font for PDF reports\";i:32;s:28:\"Popup login and signup forms\";}s:7:\"version\";s:3:\"2.2\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:99:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0, WooCommerce 3.5.2, Upfront 1.9.4, MarketPress 3.2.9\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:52:\"https://premium.wpmudev.org/project/coursepress-pro/\";s:9:\"thumbnail\";s:82:\"https://premium.wpmudev.org/wp-content/uploads/2014/09/CoursePress-Pro-280x158.png\";s:16:\"thumbnail_square\";s:80:\"https://premium.wpmudev.org/wp-content/uploads/2014/09/CoursePress-Pro-90x90.png\";s:15:\"thumbnail_large\";s:74:\"https://premium.wpmudev.org/wp-content/uploads/2014/09/CoursePress-Pro.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/1ezhmnbruq\";s:13:\"wp_config_url\";s:51:\"edit.php?post_type=course&page=coursepress_settings\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:101:\"https://premium.wpmudev.org/wp-content/projects/913071/screenshots/1795131377_cp-features-735x470.jpg\";s:4:\"desc\";s:23:\"Payment gateway options\";}i:1;a:2:{s:3:\"url\";s:98:\"https://premium.wpmudev.org/wp-content/projects/913071/screenshots/1193037768_cp-theme-735x470.jpg\";s:4:\"desc\";s:17:\"CoursePress theme\";}i:2;a:2:{s:3:\"url\";s:97:\"https://premium.wpmudev.org/wp-content/projects/913071/screenshots/718588840_cp-video-735x470.jpg\";s:4:\"desc\";s:11:\"Embed media\";}i:3;a:2:{s:3:\"url\";s:99:\"https://premium.wpmudev.org/wp-content/projects/913071/screenshots/1296912759_cp-course-735x470.jpg\";s:4:\"desc\";s:21:\"Course screen layout.\";}}s:6:\"_order\";i:11;}i:123;a:26:{s:2:\"id\";i:123;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:9:\"PopUp Pro\";s:8:\"released\";i:1265844141;s:7:\"updated\";i:1526057124;s:9:\"downloads\";s:6:\"127607\";s:10:\"popularity\";s:5:\"14361\";s:17:\"short_description\";s:68:\"Customizable, smart, responsive, and beautiful popups for WordPress.\";s:8:\"features\";a:57:{i:0;s:14:\"Simple styling\";i:1;s:15:\"Optional header\";i:2;s:18:\"Optional subheader\";i:3;s:12:\"Embed images\";i:4;s:11:\"Video embed\";i:5;s:11:\"Embed forms\";i:6;s:15:\"Email subscribe\";i:7;s:22:\"Squared off or Rounded\";i:8;s:13:\"Custom colors\";i:9;s:20:\"Set reveal animation\";i:10;s:19:\"Set close animation\";i:11;s:10:\"Responsive\";i:12;s:17:\"Set a custom size\";i:13;s:17:\"Preview on demand\";i:14;s:28:\"Never see this message again\";i:15;s:14:\"Set expression\";i:16;s:32:\"Click on background closes PopUp\";i:17;s:26:\"Drag-n-drop PopUp ordering\";i:18;s:25:\"One-click activate status\";i:19;s:14:\"Preview PopUps\";i:20;s:19:\"Control color style\";i:21;s:19:\"Custom button label\";i:22;s:9:\"Point URL\";i:23;s:10:\"CTA Target\";i:24;s:26:\"3 themes or custom styling\";i:25;s:22:\"Style using custom css\";i:26;s:24:\"Build your own templates\";i:27;s:19:\"Upfront integration\";i:28;s:16:\"Load from Footer\";i:29;s:25:\"Load using WordPress AJAX\";i:30;s:22:\"Load using Custom AJAX\";i:31;s:27:\"Load using Anonymous Script\";i:32;s:14:\"Country Lookup\";i:33;s:11:\"Use Host IP\";i:34;s:10:\"Use Telize\";i:35;s:11:\"Free Geo IP\";i:36;s:35:\"PopUp Pro fully supports shortcodes\";i:37;s:25:\"Toggle Display Conditions\";i:38;s:25:\"User arrive from referrer\";i:39;s:31:\"User arrives from specific link\";i:40;s:15:\"On specific URL\";i:41;s:40:\"User arrives from specific search engine\";i:42;s:18:\"Basic URL matching\";i:43;s:23:\"Taxonomy based triggers\";i:44;s:29:\"Behavior-based PopUp triggers\";i:45;s:9:\"User role\";i:46;s:19:\"Trigger by category\";i:47;s:15:\"Post type rules\";i:48;s:26:\"Restrict to mobile devices\";i:49;s:25:\"Block from mobile devices\";i:50;s:22:\"Trigger by screen size\";i:51;s:13:\"Delay trigger\";i:52;s:19:\"Page scroll trigger\";i:53;s:25:\"Trigger with CSS selector\";i:54;s:16:\"Membership level\";i:55;s:9:\"Pro Sites\";i:56;s:28:\"BuddyPress extended profiles\";}s:7:\"version\";s:5:\"4.8.1\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:56:\"https://premium.wpmudev.org/project/the-pop-over-plugin/\";s:9:\"thumbnail\";s:85:\"https://premium.wpmudev.org/wp-content/uploads/2010/02/popup-new-1470x940-280x158.png\";s:16:\"thumbnail_square\";s:83:\"https://premium.wpmudev.org/wp-content/uploads/2010/02/popup-new-1470x940-90x90.png\";s:15:\"thumbnail_large\";s:77:\"https://premium.wpmudev.org/wp-content/uploads/2010/02/popup-new-1470x940.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/b96soi4grz\";s:13:\"wp_config_url\";s:28:\"edit.php?post_type=inc_popup\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:3:{i:0;a:2:{s:3:\"url\";s:104:\"https://premium.wpmudev.org/wp-content/projects/123/screenshots/251881647_cleanbean-popup-compressor.jpg\";s:4:\"desc\";s:14:\"PopUp display.\";}i:1;a:2:{s:3:\"url\";s:103:\"https://premium.wpmudev.org/wp-content/projects/123/screenshots/1575243586_popup-conditions-735x470.jpg\";s:4:\"desc\";s:24:\"PopUp toggle conditions.\";}i:2;a:2:{s:3:\"url\";s:106:\"https://premium.wpmudev.org/wp-content/projects/123/screenshots/1442175891_appearance-settings-735x470.jpg\";s:4:\"desc\";s:52:\"PopUp Pro makes it easy to create beautiful pop-ups.\";}}s:6:\"_order\";i:12;}i:1003656;a:26:{s:2:\"id\";i:1003656;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:16:\"Membership 2 Pro\";s:8:\"released\";i:1433432625;s:7:\"updated\";i:-62169984000;s:9:\"downloads\";s:5:\"86417\";s:10:\"popularity\";s:4:\"8178\";s:17:\"short_description\";s:92:\"The most powerful, easy-to-use and flexible membership plugin for WordPress sites available.\";s:8:\"features\";a:53:{i:0;s:19:\"Standard Membership\";i:1;s:15:\"Dripped Content\";i:2;s:16:\"Guest Membership\";i:3;s:18:\"Default Membership\";i:4;s:23:\"Infinitely customizable\";i:5;s:19:\"Automate page setup\";i:6;s:29:\"Manual page creation override\";i:7;s:25:\"Easy configuration wizard\";i:8;s:26:\"Toggle pages in navigation\";i:9;s:17:\"Shortcode library\";i:10;s:31:\"Editable automated email system\";i:11;s:23:\"Delay message follow-up\";i:12;s:19:\"Membership importer\";i:13;s:29:\"Create a Custom Configuration\";i:14;s:41:\"Create as many configurations as you like\";i:15;s:22:\"Give each setup a name\";i:16;s:34:\"Users can have Multiple Membership\";i:17;s:23:\"Make your system public\";i:18;s:33:\"Build a private membership system\";i:19;s:51:\"Multisite protection managed from the network admin\";i:20;s:15:\"Global settings\";i:21;s:22:\"Free membership system\";i:22;s:15:\"Paid membership\";i:23;s:13:\"Authorize.net\";i:24;s:9:\"2Checkout\";i:25;s:22:\"Accept manual payments\";i:26;s:13:\"PayPal Single\";i:27;s:15:\"PayPal Standard\";i:28;s:13:\"Stripe Single\";i:29;s:20:\"Stripe Subscriptions\";i:30;s:27:\"25 default currency options\";i:31;s:29:\"Taxamo for EU VAT regulations\";i:32;s:23:\"Built-in invoice system\";i:33;s:13:\"Coupon system\";i:34;s:18:\"Offer a free trial\";i:35;s:30:\"Place content behind a paywall\";i:36;s:13:\"Protect pages\";i:37;s:13:\"Protect posts\";i:38;s:24:\"Content protect comments\";i:39;s:37:\"Protect content below \"read more\" tag\";i:40;s:27:\"Protect by custom post type\";i:41;s:19:\"Protect by category\";i:42;s:22:\"Protect specific menus\";i:43;s:27:\"Protect specific menu items\";i:44;s:38:\"Shortcodes to protect specific content\";i:45;s:21:\"Protect specific URLs\";i:46;s:21:\"Protect archive pages\";i:47;s:34:\"Protect any WordPress special page\";i:48;s:28:\"Protect content by user role\";i:49;s:24:\"Protect dashboard access\";i:50;s:31:\"Built-in BuddyPress integration\";i:51;s:28:\"Built-in bbPress integration\";i:52;s:35:\"Bulk actions for members admin page\";}s:7:\"version\";s:5:\"1.1.5\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:47:\"https://premium.wpmudev.org/project/membership/\";s:9:\"thumbnail\";s:82:\"https://premium.wpmudev.org/wp-content/uploads/2015/06/Product-Content-280x158.png\";s:16:\"thumbnail_square\";s:80:\"https://premium.wpmudev.org/wp-content/uploads/2015/06/Product-Content-90x90.png\";s:15:\"thumbnail_large\";s:74:\"https://premium.wpmudev.org/wp-content/uploads/2015/06/Product-Content.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/ata3bxdnfe\";s:13:\"wp_config_url\";s:26:\"admin.php?page=membership2\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:122:\"https://premium.wpmudev.org/wp-content/projects/1003656/screenshots/424684666_2074601056_membership-post-badge-735x470.jpg\";s:4:\"desc\";s:32:\"Tag Membership2 automated pages.\";}i:1;a:2:{s:3:\"url\";s:107:\"https://premium.wpmudev.org/wp-content/projects/1003656/screenshots/1077558186_1129389151_money-735x470.jpg\";s:4:\"desc\";s:28:\"4 built-in payment gateways.\";}i:2;a:2:{s:3:\"url\";s:111:\"https://premium.wpmudev.org/wp-content/projects/1003656/screenshots/2008297256_1538754738_m2-wizard-735x470.jpg\";s:4:\"desc\";s:49:\"Easly Membership2 wizard for simple configuration\";}i:3;a:2:{s:3:\"url\";s:101:\"https://premium.wpmudev.org/wp-content/projects/1003656/screenshots/1671886528_automated-messages.png\";s:4:\"desc\";s:45:\"Send automated system emails with Membership2\";}}s:6:\"_order\";i:13;}i:49;a:26:{s:2:\"id\";i:49;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:9:\"Pro Sites\";s:8:\"released\";i:1233010110;s:7:\"updated\";i:1540680829;s:9:\"downloads\";s:6:\"107920\";s:10:\"popularity\";s:4:\"3702\";s:17:\"short_description\";s:84:\"Offer a service like WordPress.com or Edublogs with paid upgrades and extra storage.\";s:8:\"features\";a:41:{i:0;s:30:\"Give Pro Sites custom branding\";i:1;s:31:\"Toggle upgrade button locations\";i:2;s:23:\"Recurring subscriptions\";i:3;s:28:\"Integrate one time setup fee\";i:4;s:35:\"Google Analytics Ecommerce Tracking\";i:5;s:16:\"Unlimited levels\";i:6;s:18:\"Free access levels\";i:7;s:19:\"Paid premium levels\";i:8;s:11:\"Free trials\";i:9;s:14:\"Coupon manager\";i:10;s:22:\"Built-in pricing table\";i:11;s:20:\"Built-in advertising\";i:12;s:22:\"Premium theme upgrades\";i:13;s:23:\"Premium plugin upgrades\";i:14;s:25:\"Custom email notification\";i:15;s:26:\"Sell bulk service upgrades\";i:16;s:18:\"Front-end checkout\";i:17;s:14:\"PayPal Express\";i:18;s:15:\"Manual Payments\";i:19;s:6:\"Stripe\";i:20;s:22:\"24 included currencies\";i:21;s:27:\"EU VAT - Taxamo Integration\";i:22;s:20:\"Simple pricing table\";i:23;s:24:\"Complete custom branding\";i:24;s:22:\"Custom payment screens\";i:25;s:19:\"Track subscriptions\";i:26;s:19:\"Powerful statistics\";i:27;s:29:\"Individual site modifications\";i:28;s:15:\"Process refunds\";i:29;s:20:\"Manage cancellations\";i:30;s:14:\"Global widgets\";i:31;s:22:\"PayPal sandbox testing\";i:32;s:22:\"BuddyPress integration\";i:33;s:26:\"Disable ads for pro levels\";i:34;s:16:\"Limit publishing\";i:35;s:15:\"Set pay-to-blog\";i:36;s:16:\"Limit post types\";i:37;s:28:\"Premium support as a service\";i:38;s:20:\"Control upload space\";i:39;s:16:\"Restrict XML-RPC\";i:40;s:33:\"Unfiltered HTML for select levels\";}s:7:\"version\";s:7:\"3.5.9.3\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:31:\"Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:46:\"https://premium.wpmudev.org/project/pro-sites/\";s:9:\"thumbnail\";s:77:\"https://premium.wpmudev.org/wp-content/uploads/2009/01/pro-sites1-280x158.png\";s:16:\"thumbnail_square\";s:75:\"https://premium.wpmudev.org/wp-content/uploads/2009/01/pro-sites1-90x90.png\";s:15:\"thumbnail_large\";s:69:\"https://premium.wpmudev.org/wp-content/uploads/2009/01/pro-sites1.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/gz6l3c2y6q\";s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:28:\"admin.php?page=psts-settings\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:111:\"https://premium.wpmudev.org/wp-content/projects/49/screenshots/1138977050_1870602018_price-table-compressor.png\";s:4:\"desc\";s:5:\"Price\";}i:1;a:2:{s:3:\"url\";s:119:\"https://premium.wpmudev.org/wp-content/projects/49/screenshots/410435277_1191832990_bulk-upgrade-735x470-compressor.jpg\";s:4:\"desc\";s:23:\"Pro Sites bulk upgrades\";}i:2;a:2:{s:3:\"url\";s:107:\"https://premium.wpmudev.org/wp-content/projects/49/screenshots/852229220_552588713_prostie84-compressor.jpg\";s:4:\"desc\";s:77:\"Pro Sites Monthly tracking data displayed on the Statistics page in Pro sites\";}i:3;a:2:{s:3:\"url\";s:86:\"https://premium.wpmudev.org/wp-content/projects/49/screenshots/2035245605_features.png\";s:4:\"desc\";s:8:\"Features\";}}s:6:\"_order\";i:14;}i:910520;a:26:{s:2:\"id\";i:910520;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:19:\"Custom Sidebars Pro\";s:8:\"released\";i:1404840607;s:7:\"updated\";i:-62169984000;s:9:\"downloads\";s:5:\"97441\";s:10:\"popularity\";s:4:\"9637\";s:17:\"short_description\";s:65:\"Set custom widget areas to display on every sidebar of your site.\";s:8:\"features\";a:20:{i:0;s:31:\"Dynamically replace any sidebar\";i:1;s:25:\"Create unlimited sidebars\";i:2;s:26:\"One-click sidebar creation\";i:3;s:30:\"Customize widgets by user type\";i:4;s:29:\"Allow replace with a checkbox\";i:5;s:24:\"Custom sidebar by author\";i:6;s:23:\"Set sidebar by category\";i:7;s:34:\"Set archive page specific sidebars\";i:8;s:18:\"Visibility filters\";i:9;s:10:\"Taxonomies\";i:10;s:14:\"Share sidebars\";i:11;s:14:\"Sidebar export\";i:12;s:14:\"Sidebar import\";i:13;s:36:\"Duplicate widget settings with clone\";i:14;s:14:\"Copy and paste\";i:15;s:44:\"Sync configurations across multiple sidebars\";i:16;s:39:\"Integrates with core \'Widgets\' settings\";i:17;s:26:\"Custom wrapper code fields\";i:18;s:12:\"WPML support\";i:19;s:15:\"Multisite ready\";}s:7:\"version\";s:5:\"3.2.2\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:56:\"https://premium.wpmudev.org/project/custom-sidebars-pro/\";s:9:\"thumbnail\";s:82:\"https://premium.wpmudev.org/wp-content/uploads/2014/07/custom-sidebars-280x158.png\";s:16:\"thumbnail_square\";s:80:\"https://premium.wpmudev.org/wp-content/uploads/2014/07/custom-sidebars-90x90.png\";s:15:\"thumbnail_large\";s:74:\"https://premium.wpmudev.org/wp-content/uploads/2014/07/custom-sidebars.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/o35et886n0\";s:13:\"wp_config_url\";s:11:\"widgets.php\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:99:\"https://premium.wpmudev.org/wp-content/projects/910520/screenshots/343439399_display-if-735x470.jpg\";s:4:\"desc\";s:31:\"More Custom Sidebar Pro options\";}i:1;a:2:{s:3:\"url\";s:104:\"https://premium.wpmudev.org/wp-content/projects/910520/screenshots/1612184273_define-sidebar-735x470.jpg\";s:4:\"desc\";s:30:\"Custom Sidebars Pro parameters\";}i:2;a:2:{s:3:\"url\";s:101:\"https://premium.wpmudev.org/wp-content/projects/910520/screenshots/4744525_sidebar-export-735x470.jpg\";s:4:\"desc\";s:37:\"Custom Sidebars Pro import and export\";}i:3;a:2:{s:3:\"url\";s:105:\"https://premium.wpmudev.org/wp-content/projects/910520/screenshots/1449665408_replace-sidebar-735x470.jpg\";s:4:\"desc\";s:35:\"Custom Sidebars Pro replace sidebar\";}}s:6:\"_order\";i:15;}i:144;a:26:{s:2:\"id\";i:144;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:21:\"MarketPress eCommerce\";s:8:\"released\";i:1277136916;s:7:\"updated\";i:-62169984000;s:9:\"downloads\";s:6:\"186429\";s:10:\"popularity\";s:4:\"5454\";s:17:\"short_description\";s:84:\"Sell everything from digital downloads to physical goods – no extensions required.\";s:8:\"features\";a:38:{i:0;s:28:\"15 built-in payment gateways\";i:1;s:22:\"100% translation ready\";i:2;s:29:\"Supports all major currencies\";i:3;s:28:\"Quality Tax and VAT settings\";i:4;s:25:\"Upfront style integration\";i:5;s:18:\"Sell digital files\";i:6;s:19:\"Set download limits\";i:7;s:45:\"Multiple shipping options (including pick up)\";i:8;s:26:\"Google Universal Analytics\";i:9;s:55:\"Pinterest “Rich Pins” with advanced oEmbed endpoint\";i:10;s:20:\"Link related product\";i:11;s:29:\"Coupons and discounts modules\";i:12;s:43:\"Full Google Analytics eCommerce integration\";i:13;s:28:\"Unlimited product variations\";i:14;s:26:\"Stock alerts per variation\";i:15;s:39:\"Configure physical product order limits\";i:16;s:25:\"AJAX cart and cart widget\";i:17;s:31:\"Comprehensive shortcode library\";i:18;s:29:\"Link product to external link\";i:19;s:24:\"Amazon affiliate linking\";i:20;s:36:\"Product specific categories and tags\";i:21;s:18:\"Inventory tracking\";i:22;s:13:\"Order manager\";i:23;s:12:\"Alert system\";i:24;s:23:\"Fully customizable URLs\";i:25;s:29:\"Checkout without registration\";i:26;s:36:\"Build a shopping network (like Etsy)\";i:27;s:29:\"Mutisite global shopping cart\";i:28;s:28:\"Tax inclusive pricing option\";i:29;s:29:\"Custom personalization fields\";i:30;s:19:\"Lightbox image zoom\";i:31;s:35:\"Advanced API support for developers\";i:32;s:25:\"Simple design integration\";i:33;s:22:\"Adaptive theme support\";i:34;s:20:\"No extensions needed\";i:35;s:33:\"Extensive tracking number options\";i:36;s:23:\"Round-the-clock support\";i:37;s:31:\"HTTPS support for custom styles\";}s:7:\"version\";s:5:\"3.2.9\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:61:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0, Upfront 1.9.4\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:47:\"https://premium.wpmudev.org/project/e-commerce/\";s:9:\"thumbnail\";s:88:\"https://premium.wpmudev.org/wp-content/uploads/2010/06/MarketPress-eCommerce-280x158.png\";s:16:\"thumbnail_square\";s:88:\"https://premium.wpmudev.org/wp-content/uploads/2010/06/MarketPress-eCommerce-150x150.png\";s:15:\"thumbnail_large\";s:80:\"https://premium.wpmudev.org/wp-content/uploads/2010/06/MarketPress-eCommerce.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/3hlfs0ef41\";s:13:\"wp_config_url\";s:29:\"admin.php?page=store-settings\";s:13:\"ms_config_url\";s:40:\"settings.php?page=network-store-settings\";s:7:\"package\";i:913071;s:11:\"screenshots\";a:3:{i:0;a:2:{s:3:\"url\";s:85:\"https://premium.wpmudev.org/wp-content/projects/144/screenshots/901462443_wizard2.jpg\";s:4:\"desc\";s:18:\"MarketPress Wizard\";}i:1;a:2:{s:3:\"url\";s:105:\"https://premium.wpmudev.org/wp-content/projects/144/screenshots/2000791255_marketpress-coupon-735x470.jpg\";s:4:\"desc\";s:19:\"MarketPress Coupons\";}i:2;a:2:{s:3:\"url\";s:102:\"https://premium.wpmudev.org/wp-content/projects/144/screenshots/1513544457_featured-images-735x470.jpg\";s:4:\"desc\";s:25:\"MarketPress bold display.\";}}s:6:\"_order\";i:16;}i:679841;a:26:{s:2:\"id\";i:679841;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:13:\"Appointments+\";s:8:\"released\";i:1348185122;s:7:\"updated\";i:-62169984000;s:9:\"downloads\";s:6:\"142451\";s:10:\"popularity\";s:4:\"5103\";s:17:\"short_description\";s:85:\"The most powerful, flexible and feature-rich bookings plugin available for WordPress.\";s:8:\"features\";a:43:{i:0;s:18:\"Unlimited services\";i:1;s:35:\"Unlimited service provider profiles\";i:2;s:24:\"Set “black out” days\";i:3;s:15:\"Schedule breaks\";i:4;s:20:\"Choose working hours\";i:5;s:36:\"Back end and front end schedule edit\";i:6;s:21:\"BuddyPress compatible\";i:7;s:28:\"Shortcode integration option\";i:8;s:32:\"Automatic appointment page setup\";i:9;s:23:\"Display weekly schedule\";i:10;s:24:\"Display Monthly schedule\";i:11;s:22:\"Limit advanced booking\";i:12;s:16:\"Gravatar support\";i:13;s:26:\"Simple appointment manager\";i:14;s:19:\"Transaction manager\";i:15;s:21:\"Includes setup wizard\";i:16;s:36:\"Custom color labels for appointments\";i:17;s:22:\"Calendar style options\";i:18;s:28:\"Auto-fill for repeat clients\";i:19;s:19:\"Login with Facebook\";i:20;s:18:\"Login with Twitter\";i:21;s:18:\"Login with Google+\";i:22;s:20:\"Login with WordPress\";i:23;s:35:\"Integrates with WPMU DEV Membership\";i:24;s:36:\"Integrates with MarketPress gateways\";i:25;s:27:\"Require payment or deposits\";i:26;s:27:\"Fixed or percentage deposit\";i:27;s:20:\"Google Calendar sync\";i:28;s:21:\"Appointment reminders\";i:29;s:26:\"Manual appointment booking\";i:30;s:40:\"Automatically remove unpaid appointments\";i:31;s:23:\"Monthly calendar widget\";i:32;s:23:\"Service provider widget\";i:33;s:15:\"Services widget\";i:34;s:26:\"Tutorials and FAQ included\";i:35;s:35:\"130+ custom filter and action hooks\";i:36;s:19:\"20 included Add-ons\";i:37;s:24:\"Set multiple break times\";i:38;s:35:\"Custom appointments+ profile fields\";i:39;s:28:\"Define appointment locations\";i:40;s:34:\"Add services and workers locations\";i:41;s:23:\"Google Maps integration\";i:42;s:31:\"Integrated notifications system\";}s:7:\"version\";s:5:\"2.4.1\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:65:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0, MarketPress 3.2.9\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:54:\"https://premium.wpmudev.org/project/appointments-plus/\";s:9:\"thumbnail\";s:79:\"https://premium.wpmudev.org/wp-content/uploads/2012/09/Appointment--280x158.png\";s:16:\"thumbnail_square\";s:79:\"https://premium.wpmudev.org/wp-content/uploads/2012/09/Appointment--150x150.png\";s:15:\"thumbnail_large\";s:71:\"https://premium.wpmudev.org/wp-content/uploads/2012/09/Appointment-.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/058dqij5e6\";s:13:\"wp_config_url\";s:27:\"admin.php?page=app_settings\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:97:\"https://premium.wpmudev.org/wp-content/projects/679841/screenshots/690404156_provider-735x470.jpg\";s:4:\"desc\";s:32:\"Appointments + service providers\";}i:1;a:2:{s:3:\"url\";s:103:\"https://premium.wpmudev.org/wp-content/projects/679841/screenshots/1478350223_services-page-735x470.jpg\";s:4:\"desc\";s:23:\"Appointments + services\";}i:2;a:2:{s:3:\"url\";s:116:\"https://premium.wpmudev.org/wp-content/projects/679841/screenshots/1839010802_appointments-working-hours-735x470.jpg\";s:4:\"desc\";s:28:\"Appointments + setting hours\";}i:3;a:2:{s:3:\"url\";s:107:\"https://premium.wpmudev.org/wp-content/projects/679841/screenshots/772768044_appointment-manage-735x470.jpg\";s:4:\"desc\";s:35:\"Appointments + schedule management \";}}s:6:\"_order\";i:17;}i:249;a:26:{s:2:\"id\";i:249;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:8:\"Events +\";s:8:\"released\";i:1321834092;s:7:\"updated\";i:1529530988;s:9:\"downloads\";s:6:\"100499\";s:10:\"popularity\";s:4:\"4986\";s:17:\"short_description\";s:63:\"Create and manage events with incredible power and flexibility.\";s:8:\"features\";a:19:{i:0;s:22:\"Integrates with PayPal\";i:1;s:21:\"Hassle-free interface\";i:2;s:31:\"Facebook and Twitter login RSVP\";i:3;s:22:\"Integrated Google Maps\";i:4;s:30:\"Display event attendee avatars\";i:5;s:22:\"Upcoming events widget\";i:6;s:24:\"Show most popular events\";i:7;s:35:\"Compatible with any WordPress theme\";i:8;s:48:\"Monitor guest list from your WordPress dashboard\";i:9;s:23:\"Create recurring events\";i:10;s:14:\"Auto-scheduler\";i:11;s:24:\"e-Newsletter integration\";i:12;s:18:\"Front-page editing\";i:13;s:50:\"Shortcodes for calendars, maps and expired events.\";i:14;s:15:\"Event countdown\";i:15;s:18:\"Event cancellation\";i:16;s:23:\"Limited capacity events\";i:17;s:39:\"Integration with Membership by WPMU DEV\";i:18;s:28:\"Export events in iCal format\";}s:7:\"version\";s:5:\"1.9.8\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:48:\"https://premium.wpmudev.org/project/events-plus/\";s:9:\"thumbnail\";s:73:\"https://premium.wpmudev.org/wp-content/uploads/2011/11/Event--280x158.png\";s:16:\"thumbnail_square\";s:71:\"https://premium.wpmudev.org/wp-content/uploads/2011/11/Event--90x90.png\";s:15:\"thumbnail_large\";s:65:\"https://premium.wpmudev.org/wp-content/uploads/2011/11/Event-.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/f337z95ryg\";s:13:\"wp_config_url\";s:49:\"edit.php?post_type=incsub_event&page=eab_settings\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:2:{i:0;a:2:{s:3:\"url\";s:97:\"https://premium.wpmudev.org/wp-content/projects/249/screenshots/1903849921_event-page-735x470.jpg\";s:4:\"desc\";s:12:\"Events page.\";}i:1;a:2:{s:3:\"url\";s:97:\"https://premium.wpmudev.org/wp-content/projects/249/screenshots/759942276_events-list-735x470.jpg\";s:4:\"desc\";s:16:\"Upcoming events.\";}}s:6:\"_order\";i:18;}i:912971;a:26:{s:2:\"id\";i:912971;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:18:\"Jobs &amp; Experts\";s:8:\"released\";i:1413145107;s:7:\"updated\";i:-62169984000;s:9:\"downloads\";s:5:\"22062\";s:10:\"popularity\";s:4:\"1464\";s:17:\"short_description\";s:92:\"The ultimate WordPress jobs board with detailed listings, expert profiles, ratings and more.\";s:8:\"features\";a:31:{i:0;s:26:\"Front-end profile creation\";i:1;s:23:\"Front-end jobs creation\";i:2;s:34:\"Job &amp; Expert dashboard manager\";i:3;s:24:\"Adjusts to fit any theme\";i:4;s:23:\"Fully responsive design\";i:5;s:27:\"List industry professionals\";i:6;s:20:\"Toggle style options\";i:7;s:23:\"Avatar uploader options\";i:8;s:25:\"Animated graphic elements\";i:9;s:27:\"Link expert social profiles\";i:10;s:35:\"Promote an expert with a ‘like’\";i:11;s:18:\"List expert skills\";i:12;s:19:\"Expert geo location\";i:13;s:17:\"Private messaging\";i:14;s:22:\"Discreet communication\";i:15;s:20:\"Integrated portfolio\";i:16;s:26:\"Comprehensive job listings\";i:17;s:20:\"Share project budget\";i:18;s:14:\"Set a deadline\";i:19;s:19:\"Project description\";i:20;s:16:\"Share spec files\";i:21;s:19:\"Slick contact forms\";i:22;s:21:\"Shortcode integration\";i:23;s:23:\"Become an Expert widget\";i:24;s:19:\"Post New Job widget\";i:25;s:18:\"Recent Jobs widget\";i:26;s:17:\"Job Search widget\";i:27;s:29:\"Optional automated page setup\";i:28;s:28:\"Flexible listing page layout\";i:29;s:26:\"Advanced search technology\";i:30;s:32:\"Quickly sort by tag and category\";}s:7:\"version\";s:5:\"1.0.3\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:53:\"https://premium.wpmudev.org/project/jobs-and-experts/\";s:9:\"thumbnail\";s:79:\"https://premium.wpmudev.org/wp-content/uploads/2014/10/Jobs_experts-280x158.png\";s:16:\"thumbnail_square\";s:77:\"https://premium.wpmudev.org/wp-content/uploads/2014/10/Jobs_experts-90x90.png\";s:15:\"thumbnail_large\";s:71:\"https://premium.wpmudev.org/wp-content/uploads/2014/10/Jobs_experts.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/apyiefainj\";s:13:\"wp_config_url\";s:46:\"edit.php?post_type=jbp_job&page=jobs-plus-menu\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:96:\"https://premium.wpmudev.org/wp-content/projects/912971/screenshots/1138882855_experts-search.jpg\";s:4:\"desc\";s:12:\"listing page\";}i:1;a:2:{s:3:\"url\";s:91:\"https://premium.wpmudev.org/wp-content/projects/912971/screenshots/886201319_add-expert.jpg\";s:4:\"desc\";s:14:\"Add an expert \";}i:2;a:2:{s:3:\"url\";s:96:\"https://premium.wpmudev.org/wp-content/projects/912971/screenshots/1906186833_wizard-735x470.jpg\";s:4:\"desc\";s:12:\"Simple setup\";}i:3;a:2:{s:3:\"url\";s:103:\"https://premium.wpmudev.org/wp-content/projects/912971/screenshots/549867401_jobs-dashboard-735x470.jpg\";s:4:\"desc\";s:12:\"Jobs options\";}}s:6:\"_order\";i:19;}i:120;a:26:{s:2:\"id\";i:120;s:4:\"paid\";s:4:\"full\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:10:\"Anti-Splog\";s:8:\"released\";i:1263418523;s:7:\"updated\";i:1530081652;s:9:\"downloads\";s:5:\"39792\";s:10:\"popularity\";s:4:\"1537\";s:17:\"short_description\";s:84:\"Stop spam blogs on WordPress Multisite and BuddyPress without shutting down signups.\";s:8:\"features\";a:10:{i:0;s:42:\"Change signup page location every 24 hours\";i:1;s:21:\"5 layer splog protect\";i:2;s:28:\"2 human tests to choose from\";i:3;s:33:\"Smart API is constantly improving\";i:4;s:45:\"Recent splog list and manual splog moderation\";i:5;s:37:\"Block bot and manually created splogs\";i:6;s:27:\"Crowdsourced splog fighting\";i:7;s:13:\"Blacklist IPs\";i:8;s:44:\"Spammed blogs are archived for easy recovery\";i:9;s:16:\"Instant previews\";}s:7:\"version\";s:5:\"2.2.1\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:31:\"Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:47:\"https://premium.wpmudev.org/project/anti-splog/\";s:9:\"thumbnail\";s:77:\"https://premium.wpmudev.org/wp-content/uploads/2010/01/Anti_Splog-280x158.png\";s:16:\"thumbnail_square\";s:75:\"https://premium.wpmudev.org/wp-content/uploads/2010/01/Anti_Splog-90x90.png\";s:15:\"thumbnail_large\";s:69:\"https://premium.wpmudev.org/wp-content/uploads/2010/01/Anti_Splog.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/yhb9deyecd\";s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:27:\"admin.php?page=ust-settings\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:87:\"https://premium.wpmudev.org/wp-content/projects/120/screenshots/110439055_as-review.jpg\";s:4:\"desc\";s:30:\"Anti-splog request validation.\";}i:1;a:2:{s:3:\"url\";s:100:\"https://premium.wpmudev.org/wp-content/projects/120/screenshots/1918537216_hero-recaptcha-demo-3.gif\";s:4:\"desc\";s:31:\"Anti-splog layers of protection\";}i:2;a:2:{s:3:\"url\";s:105:\"https://premium.wpmudev.org/wp-content/projects/120/screenshots/731671931_as-moderation-notifications.jpg\";s:4:\"desc\";s:27:\"Anti-splog automated emails\";}i:3;a:2:{s:3:\"url\";s:87:\"https://premium.wpmudev.org/wp-content/projects/120/screenshots/1825252075_as-ignor.jpg\";s:4:\"desc\";s:18:\"Anti-splog ignore.\";}}s:6:\"_order\";i:20;}i:163;a:26:{s:2:\"id\";i:163;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:11:\"CustomPress\";s:8:\"released\";i:1289336879;s:7:\"updated\";i:1532368435;s:9:\"downloads\";s:5:\"79109\";s:10:\"popularity\";s:4:\"5209\";s:17:\"short_description\";s:58:\"Create custom post types, taxonomies and fields with ease.\";s:8:\"features\";a:19:{i:0;s:24:\"Create custom post types\";i:1;s:24:\"Assign custom taxonomies\";i:2;s:13:\"Custom labels\";i:3;s:11:\"Description\";i:4;s:17:\"Custom menu icons\";i:5;s:24:\"Add a WordPress dashicon\";i:6;s:14:\"Custom post UI\";i:7;s:14:\"Create archive\";i:8;s:29:\"Shortcode integration library\";i:9;s:13:\"Export option\";i:10;s:17:\"Hide custom types\";i:11;s:17:\"Add custom fields\";i:12;s:33:\"Simple ordering for custom fields\";i:13;s:21:\"Multi-line text boxes\";i:14;s:13:\"Radio buttons\";i:15;s:17:\"Assign checkboxes\";i:16;s:21:\"Custom dropdown menus\";i:17;s:29:\"Theme integration embed codes\";i:18;s:37:\"Theme files for each custom post type\";}s:7:\"version\";s:5:\"1.3.7\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:48:\"https://premium.wpmudev.org/project/custompress/\";s:9:\"thumbnail\";s:78:\"https://premium.wpmudev.org/wp-content/uploads/2010/11/CustomPress-280x158.png\";s:16:\"thumbnail_square\";s:76:\"https://premium.wpmudev.org/wp-content/uploads/2010/11/CustomPress-90x90.png\";s:15:\"thumbnail_large\";s:70:\"https://premium.wpmudev.org/wp-content/uploads/2010/11/CustomPress.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/3oetwiiu0k\";s:13:\"wp_config_url\";s:22:\"admin.php?page=cp_main\";s:13:\"ms_config_url\";s:22:\"admin.php?page=cp_main\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:105:\"https://premium.wpmudev.org/wp-content/projects/163/screenshots/1983286917_create-order-field-735x470.jpg\";s:4:\"desc\";s:19:\"Order custom fields\";}i:1;a:2:{s:3:\"url\";s:102:\"https://premium.wpmudev.org/wp-content/projects/163/screenshots/149660541_custom-post-type-735x470.jpg\";s:4:\"desc\";s:16:\"Custom post type\";}i:2;a:2:{s:3:\"url\";s:99:\"https://premium.wpmudev.org/wp-content/projects/163/screenshots/641552100_custom-fields-735x470.jpg\";s:4:\"desc\";s:23:\"CustomPress post fields\";}i:3;a:2:{s:3:\"url\";s:97:\"https://premium.wpmudev.org/wp-content/projects/163/screenshots/635968771_custom-icon-735x470.jpg\";s:4:\"desc\";s:23:\"CustomPress custom icon\";}}s:6:\"_order\";i:21;}i:910241;a:26:{s:2:\"id\";i:910241;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:6:\"Reader\";s:8:\"released\";i:1405430471;s:7:\"updated\";i:1530082535;s:9:\"downloads\";s:4:\"9904\";s:10:\"popularity\";s:3:\"580\";s:17:\"short_description\";s:83:\"A fully-functional dashboard reading experience and author following for Multisite.\";s:8:\"features\";a:14:{i:0;s:18:\"Set featured posts\";i:1;s:17:\"Integrated Reader\";i:2;s:13:\"Follow button\";i:3;s:33:\"Filtering posts by author or site\";i:4;s:14:\"Excluded sites\";i:5;s:20:\"Browse popular posts\";i:6;s:9:\"RSS feeds\";i:7;s:6:\"Search\";i:8;s:22:\"Extra user information\";i:9;s:16:\"Custom locations\";i:10;s:12:\"Recent posts\";i:11;s:8:\"Keywords\";i:12;s:12:\"Title search\";i:13;s:32:\"Use tags to discover new content\";}s:7:\"version\";s:5:\"1.2.6\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:31:\"Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:43:\"https://premium.wpmudev.org/project/reader/\";s:9:\"thumbnail\";s:73:\"https://premium.wpmudev.org/wp-content/uploads/2014/07/Reader-280x158.png\";s:16:\"thumbnail_square\";s:71:\"https://premium.wpmudev.org/wp-content/uploads/2014/07/Reader-90x90.png\";s:15:\"thumbnail_large\";s:65:\"https://premium.wpmudev.org/wp-content/uploads/2014/07/Reader.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/jhml6xwmlx\";s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:30:\"settings.php?page=msreader.php\";s:7:\"package\";i:30;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:103:\"https://premium.wpmudev.org/wp-content/projects/910241/screenshots/1864938671_reader-follow-735x470.jpg\";s:4:\"desc\";s:19:\"Reader search tools\";}i:1;a:2:{s:3:\"url\";s:104:\"https://premium.wpmudev.org/wp-content/projects/910241/screenshots/456093684_reader-settings-735x470.jpg\";s:4:\"desc\";s:20:\"Reader settings page\";}i:2;a:2:{s:3:\"url\";s:105:\"https://premium.wpmudev.org/wp-content/projects/910241/screenshots/1182658267_reader-overview-735x470.jpg\";s:4:\"desc\";s:16:\"Reader dashboard\";}i:3;a:2:{s:3:\"url\";s:110:\"https://premium.wpmudev.org/wp-content/projects/910241/screenshots/1640462001_reader-follow-button-735x470.jpg\";s:4:\"desc\";s:20:\"Reader follow button\";}}s:6:\"_order\";i:22;}i:248;a:26:{s:2:\"id\";i:248;s:4:\"paid\";s:4:\"full\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:26:\"Integrated Video Tutorials\";s:8:\"released\";i:1318459013;s:7:\"updated\";i:-62169984000;s:9:\"downloads\";s:6:\"104073\";s:10:\"popularity\";s:4:\"8033\";s:17:\"short_description\";s:81:\"Complete, quality, always up-to-date list of unbranded WordPress training videos.\";s:8:\"features\";a:15:{i:0;s:27:\"Comprehensive video library\";i:1;s:22:\"Customizable playlists\";i:2;s:26:\"Individual and group embed\";i:3;s:33:\"One-click contextual video access\";i:4;s:15:\"Front end embed\";i:5;s:18:\"Sleek video player\";i:6;s:18:\"Quality production\";i:7;s:52:\"Automatically updates with each version of WordPress\";i:8;s:20:\"Completely unbranded\";i:9;s:12:\"Fully hosted\";i:10;s:19:\"Unlimited bandwidth\";i:11;s:15:\"Unlimited plays\";i:12;s:20:\"SSL embed compatible\";i:13;s:26:\"One API for all your sites\";i:14;s:33:\"Works perfectly with Multi Domain\";}s:7:\"version\";s:5:\"1.5.8\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:62:\"https://premium.wpmudev.org/project/unbranded-video-tutorials/\";s:9:\"thumbnail\";s:94:\"https://premium.wpmudev.org/wp-content/uploads/2011/10/Integration-Video-Tutorials-280x158.png\";s:16:\"thumbnail_square\";s:92:\"https://premium.wpmudev.org/wp-content/uploads/2011/10/Integration-Video-Tutorials-90x90.png\";s:15:\"thumbnail_large\";s:86:\"https://premium.wpmudev.org/wp-content/uploads/2011/10/Integration-Video-Tutorials.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/c5b01yf5xw\";s:13:\"wp_config_url\";s:39:\"options-general.php?page=wpmudev-videos\";s:13:\"ms_config_url\";s:32:\"settings.php?page=wpmudev-videos\";s:7:\"package\";i:0;s:11:\"screenshots\";a:3:{i:0;a:2:{s:3:\"url\";s:100:\"https://premium.wpmudev.org/wp-content/projects/248/screenshots/843594149_video-settings-735x470.jpg\";s:4:\"desc\";s:10:\"Easy setup\";}i:1;a:2:{s:3:\"url\";s:92:\"https://premium.wpmudev.org/wp-content/projects/248/screenshots/1005196382_icons-735x470.jpg\";s:4:\"desc\";s:15:\"A ton of videos\";}i:2;a:2:{s:3:\"url\";s:99:\"https://premium.wpmudev.org/wp-content/projects/248/screenshots/1978520080_video-player-735x470.jpg\";s:4:\"desc\";s:19:\"Videos in dashboard\";}}s:6:\"_order\";i:23;}i:36;a:26:{s:2:\"id\";i:36;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:14:\"Support System\";s:8:\"released\";i:1221592341;s:7:\"updated\";i:1532372107;s:9:\"downloads\";s:5:\"76902\";s:10:\"popularity\";s:4:\"4728\";s:17:\"short_description\";s:81:\"Set up an awesome support ticket system on any WordPress site, complete with FAQ.\";s:8:\"features\";a:10:{i:0;s:55:\"Easy-to-use interface for viewing and answering tickets\";i:1;s:43:\"Email notifications when new tickets arrive\";i:2;s:45:\"Assign tickets to specific team members/staff\";i:3;s:76:\"Fully functional editor lets you include styles and images in your responses\";i:4;s:93:\"Users get a handy built-in Dashboard menu that allows them to view, create and submit tickets\";i:5;s:23:\"Tickets status tracking\";i:6;s:68:\"Create an FAQ area where users can find and vote on existing answers\";i:7;s:46:\"Embed media (like helpful videos) in your FAQs\";i:8;s:73:\"Fully integrates with Pro Sites so you can make support a premium feature\";i:9;s:30:\"Powerful Multisite integration\";}s:7:\"version\";s:7:\"2.1.9.4\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:51:\"https://premium.wpmudev.org/project/support-system/\";s:9:\"thumbnail\";s:81:\"https://premium.wpmudev.org/wp-content/uploads/2008/09/System_Support-280x158.png\";s:16:\"thumbnail_square\";s:79:\"https://premium.wpmudev.org/wp-content/uploads/2008/09/System_Support-90x90.png\";s:15:\"thumbnail_large\";s:73:\"https://premium.wpmudev.org/wp-content/uploads/2008/09/System_Support.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/8fwjhnhafk\";s:13:\"wp_config_url\";s:34:\"admin.php?page=mu-support-settings\";s:13:\"ms_config_url\";s:34:\"admin.php?page=mu-support-settings\";s:7:\"package\";i:0;s:11:\"screenshots\";a:3:{i:0;a:2:{s:3:\"url\";s:93:\"https://premium.wpmudev.org/wp-content/projects/36/screenshots/1483571601_faq-cat-735x470.jpg\";s:4:\"desc\";s:25:\"Support System categories\";}i:1;a:2:{s:3:\"url\";s:107:\"https://premium.wpmudev.org/wp-content/projects/36/screenshots/1532178231_support-notifications-735x470.jpg\";s:4:\"desc\";s:28:\"Support System Notifications\";}i:2;a:2:{s:3:\"url\";s:95:\"https://premium.wpmudev.org/wp-content/projects/36/screenshots/1094430167_help-form-735x470.jpg\";s:4:\"desc\";s:29:\"Support System front end form\";}}s:6:\"_order\";i:24;}i:910773;a:26:{s:2:\"id\";i:910773;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:6:\"Cloner\";s:8:\"released\";i:1408063608;s:7:\"updated\";i:1532371696;s:9:\"downloads\";s:5:\"38784\";s:10:\"popularity\";s:4:\"6148\";s:17:\"short_description\";s:77:\"Smart one-click staging, testing, copying and moving for WordPress Multisite.\";s:8:\"features\";a:11:{i:0;s:51:\"Copy and move sites to any location on your network\";i:1;s:17:\"One-click staging\";i:2;s:47:\"Develop and design from a safe test environment\";i:3;s:35:\"Quickly create sites from templates\";i:4;s:37:\"Keep backup copies of important sites\";i:5;s:38:\"Site overwrite–for deploying changes\";i:6;s:24:\"Give clones unique names\";i:7;s:23:\"Clone only select items\";i:8;s:63:\"Choose if cloned sites should discourage search engine indexing\";i:9;s:50:\"Seamless interface integration with Multisite core\";i:10;s:75:\"Built for high performance–built to manage the entire CampusPress network\";}s:7:\"version\";s:5:\"1.7.7\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:31:\"Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:43:\"https://premium.wpmudev.org/project/cloner/\";s:9:\"thumbnail\";s:73:\"https://premium.wpmudev.org/wp-content/uploads/2014/08/Cloner-280x158.png\";s:16:\"thumbnail_square\";s:73:\"https://premium.wpmudev.org/wp-content/uploads/2014/08/Cloner-150x150.png\";s:15:\"thumbnail_large\";s:65:\"https://premium.wpmudev.org/wp-content/uploads/2014/08/Cloner.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/5chvs4now5\";s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:24:\"settings.php?page=cloner\";s:7:\"package\";i:0;s:11:\"screenshots\";a:3:{i:0;a:2:{s:3:\"url\";s:101:\"https://premium.wpmudev.org/wp-content/projects/910773/screenshots/2071559748_cloner-site-735x470.jpg\";s:4:\"desc\";s:37:\"Add and clone sites from the toolbar.\";}i:1;a:2:{s:3:\"url\";s:106:\"https://premium.wpmudev.org/wp-content/projects/910773/screenshots/1297035309_cloner-overwrite-735x470.jpg\";s:4:\"desc\";s:20:\"One-click overwrite.\";}i:2;a:2:{s:3:\"url\";s:87:\"https://premium.wpmudev.org/wp-content/projects/910773/screenshots/792304960_cloner.gif\";s:4:\"desc\";s:43:\"Cloner makes fast work of site duplication.\";}}s:6:\"_order\";i:25;}i:694503;a:26:{s:2:\"id\";i:694503;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:8:\"Slide In\";s:8:\"released\";i:1363569320;s:7:\"updated\";i:1530081402;s:9:\"downloads\";s:5:\"45614\";s:10:\"popularity\";s:4:\"3668\";s:17:\"short_description\";s:91:\"Marketing that grabs your visitors\' attention and converts them to your product or service.\";s:8:\"features\";a:13:{i:0;s:47:\"Promote products without using annoying pop-ups\";i:1;s:38:\"Grow your subscriber and mailing lists\";i:2;s:26:\"MailChimp list integration\";i:3;s:45:\"Display a custom message at the end of a post\";i:4;s:33:\"Show messages based on conditions\";i:5;s:22:\"Toggle styling control\";i:6;s:45:\"Position to reveal left, right, top or bottom\";i:7;s:21:\"Time delayed messages\";i:8;s:23:\"Built-in social sharing\";i:9;s:32:\"Promote the content on your site\";i:10;s:38:\"Use shortcodes in promotional messages\";i:11;s:31:\"Create a Slide In using widgets\";i:12;s:46:\"Display Slide Ins on MarketPress virtual pages\";}s:7:\"version\";s:3:\"1.2\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:45:\"https://premium.wpmudev.org/project/slide-in/\";s:9:\"thumbnail\";s:76:\"https://premium.wpmudev.org/wp-content/uploads/2013/03/Slide-In1-280x158.png\";s:16:\"thumbnail_square\";s:74:\"https://premium.wpmudev.org/wp-content/uploads/2013/03/Slide-In1-90x90.png\";s:15:\"thumbnail_large\";s:68:\"https://premium.wpmudev.org/wp-content/uploads/2013/03/Slide-In1.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/r2gb86q9c5\";s:13:\"wp_config_url\";s:37:\"edit.php?post_type=slide_in&page=wdsi\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:3:{i:0;a:2:{s:3:\"url\";s:97:\"https://premium.wpmudev.org/wp-content/projects/694503/screenshots/780195422_slide-in-735x470.jpg\";s:4:\"desc\";s:20:\"Slide In looks good.\";}i:1;a:2:{s:3:\"url\";s:106:\"https://premium.wpmudev.org/wp-content/projects/694503/screenshots/484184405_slide-in-settings-735x470.jpg\";s:4:\"desc\";s:41:\"Slide in lets you style to fit your site.\";}i:2;a:2:{s:3:\"url\";s:93:\"https://premium.wpmudev.org/wp-content/projects/694503/screenshots/343159515_time-735x470.jpg\";s:4:\"desc\";s:34:\"Slide has amazing behavior options\";}}s:6:\"_order\";i:26;}i:855335;a:26:{s:2:\"id\";i:855335;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:24:\"Multisite Content Copier\";s:8:\"released\";i:1385407261;s:7:\"updated\";i:1532371471;s:9:\"downloads\";s:5:\"40021\";s:10:\"popularity\";s:4:\"3385\";s:17:\"short_description\";s:82:\"Copy posts, pages, users and even plugins across your WordPress Multisite network.\";s:8:\"features\";a:20:{i:0;s:10:\"Copy posts\";i:1;s:10:\"Copy pages\";i:2;s:10:\"Copy users\";i:3;s:12:\"Copy plugins\";i:4;s:22:\"Copy custom post types\";i:5;s:11:\"Copy images\";i:6;s:30:\"Post to multiple sites at once\";i:7;s:18:\"Create site groups\";i:8;s:25:\"Simple content copy guide\";i:9;s:26:\"Use blog template as group\";i:10;s:21:\"Add copy to new sites\";i:11;s:21:\"Copy to a single site\";i:12;s:18:\"Copy to site group\";i:13;s:17:\"Copy to all sites\";i:14;s:30:\"New Blog Templates integration\";i:15;s:26:\"Copy post from post editor\";i:16;s:13:\"Copy comments\";i:17;s:24:\"Update post created date\";i:18;s:12:\"Copy parents\";i:19;s:24:\"Copy tags and categories\";}s:7:\"version\";s:5:\"1.5.3\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:13:\"Multisite 5.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:61:\"https://premium.wpmudev.org/project/multisite-content-copier/\";s:9:\"thumbnail\";s:91:\"https://premium.wpmudev.org/wp-content/uploads/2013/11/Multisite-Content-Copier-280x158.png\";s:16:\"thumbnail_square\";s:89:\"https://premium.wpmudev.org/wp-content/uploads/2013/11/Multisite-Content-Copier-90x90.png\";s:15:\"thumbnail_large\";s:83:\"https://premium.wpmudev.org/wp-content/uploads/2013/11/Multisite-Content-Copier.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/byvdw1gatb\";s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:31:\"admin.php?page=mcc_network_page\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:103:\"https://premium.wpmudev.org/wp-content/projects/855335/screenshots/147517593_blog-templates-735x470.jpg\";s:4:\"desc\";s:59:\"Multisite Content Copier Integrates with New Blog Templates\";}i:1;a:2:{s:3:\"url\";s:99:\"https://premium.wpmudev.org/wp-content/projects/855335/screenshots/1425474447_post-copy-735x470.jpg\";s:4:\"desc\";s:43:\"Multisite Content Copier Post Editor Module\";}i:2;a:2:{s:3:\"url\";s:101:\"https://premium.wpmudev.org/wp-content/projects/855335/screenshots/1786170909_wizard-copy-735x470.jpg\";s:4:\"desc\";s:31:\"Multisite Content Copier Wizard\";}i:3;a:2:{s:3:\"url\";s:95:\"https://premium.wpmudev.org/wp-content/projects/855335/screenshots/474771918_groups-735x470.jpg\";s:4:\"desc\";s:31:\"Multisite Content Copier Groups\";}}s:6:\"_order\";i:27;}i:240;a:26:{s:2:\"id\";i:240;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:11:\"In Post Ads\";s:8:\"released\";i:1313463023;s:7:\"updated\";i:1530082007;s:9:\"downloads\";s:5:\"38526\";s:10:\"popularity\";s:4:\"2073\";s:17:\"short_description\";s:89:\"Display ads throughout your site’s posts and customize where and how often they appear.\";s:8:\"features\";a:14:{i:0;s:30:\"Choose how many ads to display\";i:1;s:29:\"Assign categories to your ads\";i:2;s:49:\"Insert ads after a specified number of paragraphs\";i:3;s:28:\"Choose the order of your ads\";i:4;s:20:\"Display ads randomly\";i:5;s:20:\"Built-in A/B testing\";i:6;s:41:\"Choose not to show ads to logged in users\";i:7;s:21:\"Style ads with themes\";i:8;s:20:\"Create custom themes\";i:9;s:35:\"Integrate ads with Google analytics\";i:10;s:44:\"Keep posts ad free for a specific time frame\";i:11;s:27:\"Wrap ads in custom messages\";i:12;s:24:\"Set ads to link anywhere\";i:13;s:41:\"Set ads to display on specific post types\";}s:7:\"version\";s:5:\"1.5.2\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:48:\"https://premium.wpmudev.org/project/in-post-ads/\";s:9:\"thumbnail\";s:70:\"https://premium.wpmudev.org/wp-content/uploads/2011/08/ipa-280x158.png\";s:16:\"thumbnail_square\";s:68:\"https://premium.wpmudev.org/wp-content/uploads/2011/08/ipa-90x90.png\";s:15:\"thumbnail_large\";s:62:\"https://premium.wpmudev.org/wp-content/uploads/2011/08/ipa.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/eqrfbynikz\";s:13:\"wp_config_url\";s:43:\"edit.php?post_type=wdca_custom_ad&page=wdca\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:3:{i:0;a:2:{s:3:\"url\";s:103:\"https://premium.wpmudev.org/wp-content/projects/240/screenshots/1324021270_display-settings-735x470.jpg\";s:4:\"desc\";s:13:\"Show settings\";}i:1;a:2:{s:3:\"url\";s:86:\"https://premium.wpmudev.org/wp-content/projects/240/screenshots/903907167_inpostad.jpg\";s:4:\"desc\";s:16:\"Images that work\";}i:2;a:2:{s:3:\"url\";s:97:\"https://premium.wpmudev.org/wp-content/projects/240/screenshots/420652909_a-b-testing-735x470.jpg\";s:4:\"desc\";s:11:\"A/B testing\";}}s:6:\"_order\";i:28;}i:97;a:26:{s:2:\"id\";i:97;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:8:\"Autoblog\";s:8:\"released\";i:1251224787;s:7:\"updated\";i:1532372232;s:9:\"downloads\";s:5:\"77857\";s:10:\"popularity\";s:4:\"7874\";s:17:\"short_description\";s:80:\"Automatically post content from RSS feeds to WordPress, Multisite or BuddyPress.\";s:8:\"features\";a:28:{i:0;s:15:\"Unlimited feeds\";i:1;s:24:\"Publish posts by default\";i:2;s:13:\"Set post date\";i:3;s:12:\"Control tags\";i:4;s:18:\"Control categories\";i:5;s:21:\"Filter import by word\";i:6;s:23:\"Filter import by phrase\";i:7;s:13:\"Manual import\";i:8;s:16:\"Scheduled import\";i:9;s:22:\"Force SSL verification\";i:10;s:18:\"Duplicate override\";i:11;s:16:\"Stats and graphs\";i:12;s:15:\"Daily reporting\";i:13;s:21:\"Force feed validation\";i:14;s:20:\"Append text to posts\";i:15;s:20:\"Link to orignal post\";i:16;s:28:\"Fix and clean Facebook posts\";i:17;s:19:\"Import bare content\";i:18;s:18:\"Import post images\";i:19;s:17:\"Set feature image\";i:20;s:19:\"Set post formatting\";i:21;s:24:\"Open post links in popup\";i:22;s:26:\"Replace author information\";i:23;s:16:\"Strip image tags\";i:24;s:10:\"Auto tweet\";i:25;s:28:\"Create original URL for post\";i:26;s:15:\"WPML compatible\";i:27;s:19:\"YouTube feed import\";}s:7:\"version\";s:5:\"4.1.1\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:45:\"https://premium.wpmudev.org/project/autoblog/\";s:9:\"thumbnail\";s:76:\"https://premium.wpmudev.org/wp-content/uploads/2009/08/Auto-Blog-280x158.png\";s:16:\"thumbnail_square\";s:74:\"https://premium.wpmudev.org/wp-content/uploads/2009/08/Auto-Blog-90x90.png\";s:15:\"thumbnail_large\";s:68:\"https://premium.wpmudev.org/wp-content/uploads/2009/08/Auto-Blog.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/eosb8gtymd\";s:13:\"wp_config_url\";s:29:\"admin.php?page=autoblog_admin\";s:13:\"ms_config_url\";s:29:\"admin.php?page=autoblog_admin\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:102:\"https://premium.wpmudev.org/wp-content/projects/97/screenshots/1513942474_autoblog-reports-735x470.jpg\";s:4:\"desc\";s:16:\"Autoblog reports\";}i:1;a:2:{s:3:\"url\";s:106:\"https://premium.wpmudev.org/wp-content/projects/97/screenshots/1484103646_autoblog-action-menu-735x470.jpg\";s:4:\"desc\";s:20:\"Autoblog action menu\";}i:2;a:2:{s:3:\"url\";s:100:\"https://premium.wpmudev.org/wp-content/projects/97/screenshots/211553225_auto-blog-stats-735x470.jpg\";s:4:\"desc\";s:14:\"Autoblog Stats\";}i:3;a:2:{s:3:\"url\";s:103:\"https://premium.wpmudev.org/wp-content/projects/97/screenshots/1299840192_autoblog-add-feed-735x470.jpg\";s:4:\"desc\";s:14:\"Autoblog feeds\";}}s:6:\"_order\";i:29;}i:938495;a:26:{s:2:\"id\";i:938495;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:17:\"Private Messaging\";s:8:\"released\";i:1421485942;s:7:\"updated\";i:1530082765;s:9:\"downloads\";s:5:\"15062\";s:10:\"popularity\";s:4:\"1167\";s:17:\"short_description\";s:80:\"Private user communication with front end interface and attachment file sharing.\";s:8:\"features\";a:14:{i:0;s:54:\"Limit sending capabilities to specific WordPress roles\";i:1;s:19:\"bbPress Integration\";i:2;s:25:\"Built-in inbox shortcodes\";i:3;s:41:\"Block lists for safe working environments\";i:4;s:21:\"WYSIWYG editor add-on\";i:5;s:30:\"Complete front-end integration\";i:6;s:22:\"Simple compose overlay\";i:7;s:16:\"Fully responsive\";i:8;s:53:\"Know when your message is received with read receipts\";i:9;s:49:\"Receive a notification when you get a new message\";i:10;s:29:\"Optional pop-up notifications\";i:11;s:36:\"Site specific messaging in Multisite\";i:12;s:42:\"Admins can broadcast messages to all users\";i:13;s:26:\"Create group conversations\";}s:7:\"version\";s:7:\"1.0.1.6\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:38:\"WordPress 5.0, Multisite 5.0, bbPress \";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:54:\"https://premium.wpmudev.org/project/private-messaging/\";s:9:\"thumbnail\";s:85:\"https://premium.wpmudev.org/wp-content/uploads/2015/01/Private-Messaging1-280x158.png\";s:16:\"thumbnail_square\";s:83:\"https://premium.wpmudev.org/wp-content/uploads/2015/01/Private-Messaging1-90x90.png\";s:15:\"thumbnail_large\";s:77:\"https://premium.wpmudev.org/wp-content/uploads/2015/01/Private-Messaging1.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/0if0pnu9go\";s:13:\"wp_config_url\";s:25:\"admin.php?page=mm_setting\";s:13:\"ms_config_url\";s:25:\"admin.php?page=mm_setting\";s:7:\"package\";i:0;s:11:\"screenshots\";a:3:{i:0;a:2:{s:3:\"url\";s:103:\"https://premium.wpmudev.org/wp-content/projects/938495/screenshots/1494134949_notifications-735x470.jpg\";s:4:\"desc\";s:31:\"Private Messaging notifications\";}i:1;a:2:{s:3:\"url\";s:101:\"https://premium.wpmudev.org/wp-content/projects/938495/screenshots/1047160296_pm-settings-735x470.jpg\";s:4:\"desc\";s:26:\"Private Messaging settings\";}i:2;a:2:{s:3:\"url\";s:104:\"https://premium.wpmudev.org/wp-content/projects/938495/screenshots/424149609_compose-message-735x470.jpg\";s:4:\"desc\";s:29:\"Private Messaging composition\";}}s:6:\"_order\";i:30;}i:8;a:26:{s:2:\"id\";i:8;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:16:\"Terms of Service\";s:8:\"released\";i:1218159156;s:7:\"updated\";i:1530082270;s:9:\"downloads\";s:5:\"44901\";s:10:\"popularity\";s:4:\"2993\";s:17:\"short_description\";s:75:\"Display terms of service on the signup form and require new users to agree.\";s:8:\"features\";a:8:{i:0;s:20:\"Visual and text edit\";i:1;s:23:\"Adds \"I Agree\" checkbox\";i:2;s:20:\"Multisite compatible\";i:3;s:21:\"BuddyPress compatible\";i:4;s:28:\"Simple shortcode integration\";i:5;s:23:\"Require agree on signup\";i:6;s:25:\"Slow automated splog bots\";i:7;s:38:\"Automatically adjusts to fit any theme\";}s:7:\"version\";s:5:\"1.3.5\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:53:\"https://premium.wpmudev.org/project/terms-of-service/\";s:9:\"thumbnail\";s:84:\"https://premium.wpmudev.org/wp-content/uploads/2008/08/Terms-of-Services-280x158.png\";s:16:\"thumbnail_square\";s:82:\"https://premium.wpmudev.org/wp-content/uploads/2008/08/Terms-of-Services-90x90.png\";s:15:\"thumbnail_large\";s:76:\"https://premium.wpmudev.org/wp-content/uploads/2008/08/Terms-of-Services.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:28:\"settings.php?page=signup-tos\";s:7:\"package\";i:0;s:11:\"screenshots\";a:3:{i:0;a:2:{s:3:\"url\";s:81:\"https://premium.wpmudev.org/wp-content/projects/8/screenshots/963911287_tos-1.png\";s:4:\"desc\";s:23:\"Looks good on any theme\";}i:1;a:2:{s:3:\"url\";s:81:\"https://premium.wpmudev.org/wp-content/projects/8/screenshots/748183635_tos-3.png\";s:4:\"desc\";s:15:\"TOS integration\";}i:2;a:2:{s:3:\"url\";s:81:\"https://premium.wpmudev.org/wp-content/projects/8/screenshots/739591423_tos-2.png\";s:4:\"desc\";s:59:\"Adding your terms of service in the network admin dashboard\";}}s:6:\"_order\";i:31;}i:233;a:26:{s:2:\"id\";i:233;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:12:\"e-Newsletter\";s:8:\"released\";i:1306357182;s:7:\"updated\";i:1530082687;s:9:\"downloads\";s:6:\"129891\";s:10:\"popularity\";s:4:\"3896\";s:17:\"short_description\";s:72:\"Send professional email newsletters and manage subscribers in WordPress.\";s:8:\"features\";a:16:{i:0;s:30:\"7 professional email templates\";i:1;s:42:\"Live preview of your email as you build it\";i:2;s:47:\"Keep constant design by cloning previous emails\";i:3;s:53:\"Segment your subscribers by creating unlimited groups\";i:4;s:42:\"Define a default group for new subscribers\";i:5;s:73:\"Send newsletters to all subscribers, a group or a specific WordPress role\";i:6;s:53:\"View receipts, opens, and bounces for each subscriber\";i:7;s:52:\"Automatically send welcome emails to new subscribers\";i:8;s:43:\"Automatically subscribe new website members\";i:9;s:47:\"Create custom subscribed and unsubscribed pages\";i:10;s:58:\"Easily display a subscribe form with a widget or shortcode\";i:11;s:37:\"Use double opt-in for new subscribers\";i:12;s:19:\"Use SMTP or PHPMail\";i:13;s:51:\"Fully control who can manage newsletters and groups\";i:14;s:57:\"Include subscriber data, such as first name in your email\";i:15;s:0:\"\";}s:7:\"version\";s:7:\"2.7.4.5\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:49:\"https://premium.wpmudev.org/project/e-newsletter/\";s:9:\"thumbnail\";s:80:\"https://premium.wpmudev.org/wp-content/uploads/2011/05/e-newsletter1-280x158.png\";s:16:\"thumbnail_square\";s:78:\"https://premium.wpmudev.org/wp-content/uploads/2011/05/e-newsletter1-90x90.png\";s:15:\"thumbnail_large\";s:72:\"https://premium.wpmudev.org/wp-content/uploads/2011/05/e-newsletter1.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/70a1c8y18j\";s:13:\"wp_config_url\";s:35:\"admin.php?page=newsletters-settings\";s:13:\"ms_config_url\";s:35:\"admin.php?page=newsletters-settings\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:104:\"https://premium.wpmudev.org/wp-content/projects/233/screenshots/1482407985_newsletter-groups-735x470.jpg\";s:4:\"desc\";s:19:\"e-Newsletter groups\";}i:1;a:2:{s:3:\"url\";s:102:\"https://premium.wpmudev.org/wp-content/projects/233/screenshots/151545179_user-permissions-735x470.jpg\";s:4:\"desc\";s:29:\"e-Newsletter user permissions\";}i:2;a:2:{s:3:\"url\";s:97:\"https://premium.wpmudev.org/wp-content/projects/233/screenshots/2001347720_send-email-735x470.jpg\";s:4:\"desc\";s:18:\"e-Newsletter stats\";}i:3;a:2:{s:3:\"url\";s:99:\"https://premium.wpmudev.org/wp-content/projects/233/screenshots/203181561_e-templates-2-735x470.jpg\";s:4:\"desc\";s:22:\"e-Newsletter templates\";}}s:6:\"_order\";i:32;}i:244;a:26:{s:2:\"id\";i:244;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:15:\"Floating Social\";s:8:\"released\";i:1314024379;s:7:\"updated\";i:1529520171;s:9:\"downloads\";s:5:\"69136\";s:10:\"popularity\";s:4:\"3320\";s:17:\"short_description\";s:98:\"Give users a way to quickly share your content with a social share bar that follows as you scroll.\";s:8:\"features\";a:18:{i:0;s:22:\"Smooth button floating\";i:1;s:9:\"Google +1\";i:2;s:13:\"Facebook Like\";i:3;s:10:\"Tweet this\";i:4;s:9:\"Pinterest\";i:5;s:6:\"Buffer\";i:6;s:12:\"Stumble Upon\";i:7;s:13:\"Reddit submit\";i:8;s:11:\"Del.icio.us\";i:9;s:14:\"LinkedIn share\";i:10;s:18:\"Add custom service\";i:11;s:22:\"Share with short links\";i:12;s:28:\"Limit to specific post types\";i:13;s:32:\"Limit to specific posts or pages\";i:14;s:10:\"Responsive\";i:15;s:16:\"Color customizer\";i:16;s:18:\"Simple positioning\";i:17;s:13:\"Easily resize\";}s:7:\"version\";s:5:\"1.7.5\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:52:\"https://premium.wpmudev.org/project/floating-social/\";s:9:\"thumbnail\";s:82:\"https://premium.wpmudev.org/wp-content/uploads/2011/08/Floating-Social-280x158.png\";s:16:\"thumbnail_square\";s:80:\"https://premium.wpmudev.org/wp-content/uploads/2011/08/Floating-Social-90x90.png\";s:15:\"thumbnail_large\";s:74:\"https://premium.wpmudev.org/wp-content/uploads/2011/08/Floating-Social.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/om7ao3whtp\";s:13:\"wp_config_url\";s:29:\"options-general.php?page=wdsb\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:3:{i:0;a:2:{s:3:\"url\";s:108:\"https://premium.wpmudev.org/wp-content/projects/244/screenshots/1006248934_floating-social-front-735x470.jpg\";s:4:\"desc\";s:25:\"Floating Social front end\";}i:1;a:2:{s:3:\"url\";s:108:\"https://premium.wpmudev.org/wp-content/projects/244/screenshots/174455124_floating-social-custom-735x470.jpg\";s:4:\"desc\";s:16:\"Add custom links\";}i:2;a:2:{s:3:\"url\";s:101:\"https://premium.wpmudev.org/wp-content/projects/244/screenshots/648368432_floating-social-735x470.jpg\";s:4:\"desc\";s:30:\"Floating Social built-in links\";}}s:6:\"_order\";i:33;}i:130;a:26:{s:2:\"id\";i:130;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:18:\"New Blog Templates\";s:8:\"released\";i:1271871390;s:7:\"updated\";i:1532371172;s:9:\"downloads\";s:5:\"96423\";s:10:\"popularity\";s:4:\"5192\";s:17:\"short_description\";s:77:\"Build a complete catalog of templates to simplify site creation in Multisite.\";s:8:\"features\";a:16:{i:0;s:27:\"Set any subsite as template\";i:1;s:21:\"Lock template styling\";i:2;s:34:\"Auto populate content on new sites\";i:3;s:28:\"Adjust templates at any time\";i:4;s:19:\"Copy select content\";i:5;s:10:\"Copy pages\";i:6;s:15:\"Copy categories\";i:7;s:15:\"Copy taxonomies\";i:8;s:10:\"Copy menus\";i:9;s:19:\"Copy active plugins\";i:10;s:10:\"Copy users\";i:11;s:16:\"Copy media files\";i:12;s:33:\"Prevent editing of copied content\";i:13;s:25:\"Create multiple templates\";i:14;s:31:\"Arrange templates in categories\";i:15;s:21:\"Browse template demos\";}s:7:\"version\";s:5:\"2.8.6\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:31:\"Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:54:\"https://premium.wpmudev.org/project/new-blog-template/\";s:9:\"thumbnail\";s:84:\"https://premium.wpmudev.org/wp-content/uploads/2010/04/New-Blog-Template-280x158.png\";s:16:\"thumbnail_square\";s:82:\"https://premium.wpmudev.org/wp-content/uploads/2010/04/New-Blog-Template-90x90.png\";s:15:\"thumbnail_large\";s:76:\"https://premium.wpmudev.org/wp-content/uploads/2010/04/New-Blog-Template.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/xhwz9npl3p\";s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:38:\"admin.php?page=blog_templates_settings\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:94:\"https://premium.wpmudev.org/wp-content/projects/130/screenshots/916311353_settings-735x470.jpg\";s:4:\"desc\";s:18:\"Template settings.\";}i:1;a:2:{s:3:\"url\";s:99:\"https://premium.wpmudev.org/wp-content/projects/130/screenshots/265744829_lock-template-735x470.jpg\";s:4:\"desc\";s:23:\"Set template thumbnail.\";}i:2;a:2:{s:3:\"url\";s:102:\"https://premium.wpmudev.org/wp-content/projects/130/screenshots/767709296_template-options-735x470.jpg\";s:4:\"desc\";s:33:\"Offer template options at signup.\";}i:3;a:2:{s:3:\"url\";s:97:\"https://premium.wpmudev.org/wp-content/projects/130/screenshots/1498300582_categories-735x470.jpg\";s:4:\"desc\";s:24:\"Set template categories.\";}}s:6:\"_order\";i:34;}i:216;a:26:{s:2:\"id\";i:216;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:11:\"Google Maps\";s:8:\"released\";i:1302900076;s:7:\"updated\";i:1530081726;s:9:\"downloads\";s:6:\"110361\";s:10:\"popularity\";s:4:\"6917\";s:17:\"short_description\";s:76:\"Easily embed, customize and display Google maps in posts, pages and widgets.\";s:8:\"features\";a:25:{i:0;s:47:\"Easily embed maps using built-in \"Add Map\" Icon\";i:1;s:44:\"Drag and drop a map onto any widgetized area\";i:2;s:31:\"Customize maps to fit your site\";i:3;s:37:\"Add latitude and longitude fieldnames\";i:4;s:22:\"Display in street view\";i:5;s:23:\"Insert custom drop-pins\";i:6;s:22:\"Panorama image overlay\";i:7;s:28:\"Custom CSS to customize maps\";i:8;s:28:\"Extensive BuddyPress support\";i:9;s:34:\"Display visitor\'s current location\";i:10;s:22:\"Create responsive maps\";i:11;s:21:\"Google Places support\";i:12;s:22:\"Map location shortcode\";i:13;s:11:\"KML overlay\";i:14;s:21:\"Disable map scrolling\";i:15;s:23:\"BuddyPress profile maps\";i:16;s:21:\"BuddyPress groups map\";i:17;s:22:\"BuddyPress profile map\";i:18;s:27:\"Geotag posts and activities\";i:19;s:34:\"Marker clustering for cleaner maps\";i:20;s:15:\"Traffic overlay\";i:21;s:30:\"Create and upload custom icons\";i:22;s:13:\"User check-in\";i:23;s:25:\"Hide auto-created markers\";i:24;s:24:\"Integrates with Events +\";}s:7:\"version\";s:5:\"2.9.4\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:65:\"https://premium.wpmudev.org/project/wordpress-google-maps-plugin/\";s:9:\"thumbnail\";s:78:\"https://premium.wpmudev.org/wp-content/uploads/2011/04/Google-Maps-280x158.png\";s:16:\"thumbnail_square\";s:76:\"https://premium.wpmudev.org/wp-content/uploads/2011/04/Google-Maps-90x90.png\";s:15:\"thumbnail_large\";s:70:\"https://premium.wpmudev.org/wp-content/uploads/2011/04/Google-Maps.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/zvnr80tu3a\";s:13:\"wp_config_url\";s:40:\"options-general.php?page=agm_google_maps\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:3:{i:0;a:2:{s:3:\"url\";s:99:\"https://premium.wpmudev.org/wp-content/projects/216/screenshots/1242974277_custom-icons-735x470.jpg\";s:4:\"desc\";s:22:\"Drop custom icon pins.\";}i:1;a:2:{s:3:\"url\";s:98:\"https://premium.wpmudev.org/wp-content/projects/216/screenshots/1901997215_google-maps-735x470.jpg\";s:4:\"desc\";s:27:\"Embed Google Maps anywhere.\";}i:2;a:2:{s:3:\"url\";s:94:\"https://premium.wpmudev.org/wp-content/projects/216/screenshots/1102819731_traffic-735x470.jpg\";s:4:\"desc\";s:27:\"Google Maps traffic overlay\";}}s:6:\"_order\";i:35;}i:261;a:26:{s:2:\"id\";i:261;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:12:\"Pay Per View\";s:8:\"released\";i:1331615032;s:7:\"updated\";i:1530082156;s:9:\"downloads\";s:5:\"36280\";s:10:\"popularity\";s:4:\"1503\";s:17:\"short_description\";s:97:\"Sell individual articles or media content for a one-time payment or offer a subscription service.\";s:8:\"features\";a:20:{i:0;s:17:\"Paywall for posts\";i:1;s:17:\"Paywall for pages\";i:2;s:29:\"Paywall for custom post types\";i:3;s:17:\"Predefine excerpt\";i:4;s:24:\"Pay for site wide access\";i:5;s:13:\"Period passes\";i:6;s:30:\"Recurring subscription options\";i:7;s:25:\"Facebook signup and login\";i:8;s:24:\"Twitter signup and login\";i:9;s:23:\"Google signup and login\";i:10;s:19:\"WordPress.com login\";i:11;s:23:\"PayPal Express checkout\";i:12;s:25:\"Simple styling for PayPal\";i:13;s:22:\"Transaction management\";i:14;s:33:\"Styling adjusts to fit your theme\";i:15;s:30:\"Build paywalls into your theme\";i:16;s:23:\"In-post content paywall\";i:17;s:18:\"Video file paywall\";i:18;s:18:\"Audio file paywall\";i:19;s:13:\"eBook paywall\";}s:7:\"version\";s:5:\"1.4.6\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:49:\"https://premium.wpmudev.org/project/pay-per-view/\";s:9:\"thumbnail\";s:79:\"https://premium.wpmudev.org/wp-content/uploads/2012/03/Pay_per_view-280x158.png\";s:16:\"thumbnail_square\";s:77:\"https://premium.wpmudev.org/wp-content/uploads/2012/03/Pay_per_view-90x90.png\";s:15:\"thumbnail_large\";s:71:\"https://premium.wpmudev.org/wp-content/uploads/2012/03/Pay_per_view.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/8ed8hwxt74\";s:13:\"wp_config_url\";s:27:\"admin.php?page=pay-per-view\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:3:{i:0;a:2:{s:3:\"url\";s:96:\"https://premium.wpmudev.org/wp-content/projects/261/screenshots/1112235748_ppv-video-735x470.jpg\";s:4:\"desc\";s:25:\"Pay Per View custom style\";}i:1;a:2:{s:3:\"url\";s:97:\"https://premium.wpmudev.org/wp-content/projects/261/screenshots/556857987_pay-options-735x470.jpg\";s:4:\"desc\";s:28:\"Pay Per View pricing options\";}i:2;a:2:{s:3:\"url\";s:103:\"https://premium.wpmudev.org/wp-content/projects/261/screenshots/197877362_ppv-login-buttons-735x470.jpg\";s:4:\"desc\";s:27:\"Pay Per View social buttons\";}}s:6:\"_order\";i:36;}i:679182;a:26:{s:2:\"id\";i:679182;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:18:\"Live Stream Widget\";s:8:\"released\";i:1343233298;s:7:\"updated\";i:1530081853;s:9:\"downloads\";s:5:\"28492\";s:10:\"popularity\";s:4:\"1006\";s:17:\"short_description\";s:71:\"Show the latest content from across your network in an animated widget.\";s:8:\"features\";a:12:{i:0;s:25:\"Animated live feed stream\";i:1;s:15:\"Local site feed\";i:2;s:22:\"Network-wide user feed\";i:3;s:11:\"Global feed\";i:4;s:9:\"Post feed\";i:5;s:12:\"Comment feed\";i:6;s:25:\"Title customization field\";i:7;s:17:\"Set a custom size\";i:8;s:23:\"Control animation speed\";i:9;s:22:\"Tag permission control\";i:10;s:27:\"Category permission control\";i:11;s:18:\"Show author avatar\";}s:7:\"version\";s:5:\"1.0.5\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:55:\"https://premium.wpmudev.org/project/live-stream-widget/\";s:9:\"thumbnail\";s:78:\"https://premium.wpmudev.org/wp-content/uploads/2012/07/Live_Stream-280x158.png\";s:16:\"thumbnail_square\";s:76:\"https://premium.wpmudev.org/wp-content/uploads/2012/07/Live_Stream-90x90.png\";s:15:\"thumbnail_large\";s:70:\"https://premium.wpmudev.org/wp-content/uploads/2012/07/Live_Stream.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/5b5eyv2g8b\";s:13:\"wp_config_url\";s:11:\"widgets.php\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:3:{i:0;a:2:{s:3:\"url\";s:95:\"https://premium.wpmudev.org/wp-content/projects/679182/screenshots/277720174_global-735x470.jpg\";s:4:\"desc\";s:25:\"Global feed for Multisite\";}i:1;a:2:{s:3:\"url\";s:108:\"https://premium.wpmudev.org/wp-content/projects/679182/screenshots/2128991645_live-stream-widget-735x470.jpg\";s:4:\"desc\";s:18:\"Live stream widget\";}i:2;a:2:{s:3:\"url\";s:96:\"https://premium.wpmudev.org/wp-content/projects/679182/screenshots/857520243_avatars-735x470.jpg\";s:4:\"desc\";s:12:\"Show avatars\";}}s:6:\"_order\";i:37;}i:99;a:26:{s:2:\"id\";i:99;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:14:\"Domain Mapping\";s:8:\"released\";i:1251831319;s:7:\"updated\";i:-62169984000;s:9:\"downloads\";s:6:\"133242\";s:10:\"popularity\";s:4:\"8544\";s:17:\"short_description\";s:88:\"The professionals\' secret to setting and selling custom URLs across a Multisite network.\";s:8:\"features\";a:27:{i:0;s:24:\"Unique landing page URLs\";i:1;s:22:\"Network cookie sharing\";i:2;s:12:\"Global login\";i:3;s:21:\"Mapped domain manager\";i:4;s:21:\"Health status checker\";i:5;s:30:\"Enable multiple mapped domains\";i:6;s:32:\"Works with global shopping carts\";i:7;s:24:\"Create product sub-sites\";i:8;s:34:\"Create custom mapping instructions\";i:9;s:37:\"limit admin access to original domain\";i:10;s:35:\"limit admin access to mapped domain\";i:11;s:31:\"Restrict login to mapped domain\";i:12;s:33:\"Restrict login to original domain\";i:13;s:22:\"Cross-domain autologin\";i:14;s:32:\"Built-in DNS record verification\";i:15;s:32:\"Propagation check before mapping\";i:16;s:38:\"Force http/https using original domain\";i:17;s:21:\"Set map-excluded urls\";i:18;s:24:\"Integrated domain resale\";i:19;s:21:\"Pro Sites integration\";i:20;s:21:\"Mapping as an upgrade\";i:21;s:16:\"eNom integration\";i:22;s:23:\"End user domain mapping\";i:23;s:30:\"Supports marketplace solutions\";i:24;s:33:\"International domain name mapping\";i:25;s:27:\"Simple guided configuration\";i:26;s:24:\"Multi-Domain integration\";}s:7:\"version\";s:7:\"4.4.3.3\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:31:\"Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:51:\"https://premium.wpmudev.org/project/domain-mapping/\";s:9:\"thumbnail\";s:81:\"https://premium.wpmudev.org/wp-content/uploads/2009/09/Domain-Mapping-280x158.png\";s:16:\"thumbnail_square\";s:79:\"https://premium.wpmudev.org/wp-content/uploads/2009/09/Domain-Mapping-90x90.png\";s:15:\"thumbnail_large\";s:73:\"https://premium.wpmudev.org/wp-content/uploads/2009/09/Domain-Mapping.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/auxkj2o9ov\";s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:39:\"settings.php?page=domainmapping_options\";s:7:\"package\";i:0;s:11:\"screenshots\";a:3:{i:0;a:2:{s:3:\"url\";s:96:\"https://premium.wpmudev.org/wp-content/projects/99/screenshots/1555595599_map-domain-735x470.jpg\";s:4:\"desc\";s:28:\"Domain Mapping configuration\";}i:1;a:2:{s:3:\"url\";s:90:\"https://premium.wpmudev.org/wp-content/projects/99/screenshots/301335887_plugin735x470.jpg\";s:4:\"desc\";s:29:\"Domain Mapping cookie sharing\";}i:2;a:2:{s:3:\"url\";s:102:\"https://premium.wpmudev.org/wp-content/projects/99/screenshots/1863264009_enom-integration-735x470.jpg\";s:4:\"desc\";s:27:\"Domain Mapping sell domains\";}}s:6:\"_order\";i:38;}i:253;a:26:{s:2:\"id\";i:253;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:16:\"Social Marketing\";s:8:\"released\";i:1325785364;s:7:\"updated\";i:1530081536;s:9:\"downloads\";s:5:\"44268\";s:10:\"popularity\";s:4:\"2084\";s:17:\"short_description\";s:71:\"Quickly build a buzz by sharing to Facebook, Twitter, Google+ and more.\";s:8:\"features\";a:12:{i:0;s:19:\"Simple guided setup\";i:1;s:27:\"Offer incentive for a share\";i:2;s:13:\"Facebook like\";i:3;s:14:\"LinkedIn share\";i:4;s:15:\"Post to Twitter\";i:5;s:16:\"Share on Google+\";i:6;s:20:\"Button color options\";i:7;s:16:\"Use theme styles\";i:8;s:16:\"Link to download\";i:9;s:19:\"Shortcode generator\";i:10;s:21:\"Pro Sites integration\";i:11;s:15:\"Multisite ready\";}s:7:\"version\";s:5:\"1.2.4\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:53:\"https://premium.wpmudev.org/project/social-marketing/\";s:9:\"thumbnail\";s:83:\"https://premium.wpmudev.org/wp-content/uploads/2012/01/Social-Marketing-280x158.png\";s:16:\"thumbnail_square\";s:81:\"https://premium.wpmudev.org/wp-content/uploads/2012/01/Social-Marketing-90x90.png\";s:15:\"thumbnail_large\";s:75:\"https://premium.wpmudev.org/wp-content/uploads/2012/01/Social-Marketing.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/pj7nru9au9\";s:13:\"wp_config_url\";s:48:\"edit.php?post_type=social_marketing_ad&page=wdsm\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:105:\"https://premium.wpmudev.org/wp-content/projects/253/screenshots/1154179888_short-gen-socail-2-735x470.jpg\";s:4:\"desc\";s:26:\"Shortcode generator button\";}i:1;a:2:{s:3:\"url\";s:85:\"https://premium.wpmudev.org/wp-content/projects/253/screenshots/809264182_unnamed.jpg\";s:4:\"desc\";s:16:\"Embed your offer\";}i:2;a:2:{s:3:\"url\";s:88:\"https://premium.wpmudev.org/wp-content/projects/253/screenshots/1970464694_unnamed-1.jpg\";s:4:\"desc\";s:21:\"Simple share lightbox\";}i:3;a:2:{s:3:\"url\";s:106:\"https://premium.wpmudev.org/wp-content/projects/253/screenshots/1482501923_custom-style-social-735x470.jpg\";s:4:\"desc\";s:14:\"Custom styling\";}}s:6:\"_order\";i:39;}i:127;a:26:{s:2:\"id\";i:127;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:18:\"Subscribe by Email\";s:8:\"released\";i:1270082008;s:7:\"updated\";i:-62169984000;s:9:\"downloads\";s:5:\"80935\";s:10:\"popularity\";s:4:\"3030\";s:17:\"short_description\";s:69:\"Allow readers to be automatically notified when you post new content.\";s:8:\"features\";a:26:{i:0;s:15:\"Add custom logo\";i:1;s:21:\"Color styling options\";i:2;s:19:\"Give header a title\";i:3;s:27:\"Add subtext and footer text\";i:4;s:28:\"Works with custom post types\";i:5;s:27:\"Include post featured image\";i:6;s:16:\"Unsubscribe link\";i:7;s:16:\"Send immediately\";i:8;s:32:\"Send as a daily or weekly digest\";i:9;s:29:\"Set day weekly digest is sent\";i:10;s:33:\"Limit feed to specific categories\";i:11;s:27:\"Live preview before sending\";i:12;s:15:\"View emails log\";i:13;s:24:\"Email throttling control\";i:14;s:23:\"Trigger emails manually\";i:15;s:17:\"Track email queue\";i:16;s:28:\"Simple subscriber management\";i:17;s:24:\"Manually add subscribers\";i:18;s:30:\"Bulk-add subscribers using CSV\";i:19;s:26:\"Resend confirmation emails\";i:20;s:23:\"Double opt-in available\";i:21;s:33:\"Included widget subscription form\";i:22;s:18:\"Subscriber counter\";i:23;s:35:\"Custom fields for subscription form\";i:24;s:29:\"Preview template in real time\";i:25;s:11:\"auto opt in\";}s:7:\"version\";s:3:\"3.6\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:55:\"https://premium.wpmudev.org/project/subscribe-by-email/\";s:9:\"thumbnail\";s:85:\"https://premium.wpmudev.org/wp-content/uploads/2010/04/Subscribe_by_email-280x158.png\";s:16:\"thumbnail_square\";s:83:\"https://premium.wpmudev.org/wp-content/uploads/2010/04/Subscribe_by_email-90x90.png\";s:15:\"thumbnail_large\";s:77:\"https://premium.wpmudev.org/wp-content/uploads/2010/04/Subscribe_by_email.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/nttkkkm78i\";s:13:\"wp_config_url\";s:27:\"admin.php?page=sbe-settings\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:100:\"https://premium.wpmudev.org/wp-content/projects/127/screenshots/253159570_email-schedule-735x470.jpg\";s:4:\"desc\";s:16:\"Set email digest\";}i:1;a:2:{s:3:\"url\";s:96:\"https://premium.wpmudev.org/wp-content/projects/127/screenshots/758306403_test-email-735x470.jpg\";s:4:\"desc\";s:12:\"Sample email\";}i:2;a:2:{s:3:\"url\";s:97:\"https://premium.wpmudev.org/wp-content/projects/127/screenshots/1508638836_email-logo-735x470.jpg\";s:4:\"desc\";s:8:\"Set logo\";}i:3;a:2:{s:3:\"url\";s:97:\"https://premium.wpmudev.org/wp-content/projects/127/screenshots/1963108342_color-pick-735x470.jpg\";s:4:\"desc\";s:12:\"Color picker\";}}s:6:\"_order\";i:40;}i:247;a:26:{s:2:\"id\";i:247;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:10:\"Comments +\";s:8:\"released\";i:1316996954;s:7:\"updated\";i:1530081165;s:9:\"downloads\";s:5:\"56878\";s:10:\"popularity\";s:4:\"2238\";s:17:\"short_description\";s:89:\"Let readers comment on your site using a Facebook, Twitter, Google+ or WordPress account.\";s:8:\"features\";a:13:{i:0;s:22:\"Comment using Facebook\";i:1;s:21:\"Comment using Google+\";i:2;s:21:\"Comment using Twitter\";i:3;s:27:\"Comment using WordPress.com\";i:4;s:29:\"Shares post to users Facebook\";i:5;s:30:\"Auto tweets post for commenter\";i:6;s:25:\"Custom icon for WordPress\";i:7;s:30:\"Toggle allowed social services\";i:8;s:20:\"Set default provider\";i:9;s:27:\"Pull style from theme hooks\";i:10;s:19:\"12 included add-ons\";i:11;s:33:\"Subscribe commenters to MailChimp\";i:12;s:20:\"Reorder service tabs\";}s:7:\"version\";s:5:\"1.6.9\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:28:\"WordPress 5.0, Multisite 5.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:50:\"https://premium.wpmudev.org/project/comments-plus/\";s:9:\"thumbnail\";s:80:\"https://premium.wpmudev.org/wp-content/uploads/2011/09/Comments_plus-280x158.png\";s:16:\"thumbnail_square\";s:78:\"https://premium.wpmudev.org/wp-content/uploads/2011/09/Comments_plus-90x90.png\";s:15:\"thumbnail_large\";s:72:\"https://premium.wpmudev.org/wp-content/uploads/2011/09/Comments_plus.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/gczg6ax4b9\";s:13:\"wp_config_url\";s:29:\"options-general.php?page=wdcp\";s:13:\"ms_config_url\";s:22:\"settings.php?page=wdcp\";s:7:\"package\";i:0;s:11:\"screenshots\";a:2:{i:0;a:2:{s:3:\"url\";s:100:\"https://premium.wpmudev.org/wp-content/projects/247/screenshots/1844726346_comments-plus-735x470.jpg\";s:4:\"desc\";s:19:\"Comments + frontend\";}i:1;a:2:{s:3:\"url\";s:95:\"https://premium.wpmudev.org/wp-content/projects/247/screenshots/1389157905_facebook-735x470.jpg\";s:4:\"desc\";s:19:\"Comments + facebook\";}}s:6:\"_order\";i:41;}i:242;a:26:{s:2:\"id\";i:242;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:6:\"Status\";s:8:\"released\";i:1314024185;s:7:\"updated\";i:1530081030;s:9:\"downloads\";s:5:\"36165\";s:10:\"popularity\";s:4:\"1177\";s:17:\"short_description\";s:84:\"Quickly share thoughts, links, images and videos with Facebook style status updates.\";s:8:\"features\";a:19:{i:0;s:25:\"Back end dashboard widget\";i:1;s:24:\"Front end status updates\";i:2;s:12:\"Share videos\";i:3;s:12:\"Share images\";i:4;s:11:\"Share links\";i:5;s:16:\"Autofill content\";i:6;s:21:\"Edit autofill content\";i:7;s:15:\"Customize title\";i:8;s:21:\"Customize description\";i:9;s:18:\"Choose a thumbnail\";i:10;s:7:\"Publish\";i:11;s:13:\"Save as draft\";i:12;s:33:\"Require review based on user type\";i:13;s:29:\"Built-in Status Update widget\";i:14;s:16:\"Configure layout\";i:15;s:25:\"Choose default categories\";i:16;s:23:\"Configure video support\";i:17;s:27:\"Auto import external images\";i:18;s:29:\"Auto configure featured image\";}s:7:\"version\";s:5:\"1.8.4\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:28:\"WordPress 5.0, Multisite 5.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:49:\"https://premium.wpmudev.org/project/quick-status/\";s:9:\"thumbnail\";s:73:\"https://premium.wpmudev.org/wp-content/uploads/2011/08/Status-280x158.png\";s:16:\"thumbnail_square\";s:71:\"https://premium.wpmudev.org/wp-content/uploads/2011/08/Status-90x90.png\";s:15:\"thumbnail_large\";s:65:\"https://premium.wpmudev.org/wp-content/uploads/2011/08/Status.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/ly8j3brx78\";s:13:\"wp_config_url\";s:29:\"options-general.php?page=wdqs\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:95:\"https://premium.wpmudev.org/wp-content/projects/242/screenshots/745034179_thumbnail-735x470.jpg\";s:4:\"desc\";s:30:\"Select your favorite thumbnail\";}i:1;a:2:{s:3:\"url\";s:93:\"https://premium.wpmudev.org/wp-content/projects/242/screenshots/24661627_dashboad-735x470.jpg\";s:4:\"desc\";s:16:\"Dashboard widget\";}i:2;a:2:{s:3:\"url\";s:98:\"https://premium.wpmudev.org/wp-content/projects/242/screenshots/1548133401_description-735x470.jpg\";s:4:\"desc\";s:26:\"Customize the description \";}i:3;a:2:{s:3:\"url\";s:91:\"https://premium.wpmudev.org/wp-content/projects/242/screenshots/769520844_title-735x470.jpg\";s:4:\"desc\";s:14:\"Edit the title\";}}s:6:\"_order\";i:42;}i:73;a:26:{s:2:\"id\";i:73;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:21:\"MailChimp Integration\";s:8:\"released\";i:1241054797;s:7:\"updated\";i:1530080927;s:9:\"downloads\";s:5:\"65902\";s:10:\"popularity\";s:4:\"3840\";s:17:\"short_description\";s:69:\"Bring simple subscribe forms and automated user syncing to WordPress.\";s:8:\"features\";a:14:{i:0;s:35:\"Toggle MailChimp list configuration\";i:1;s:45:\"Preload a MailChimp list with WordPress users\";i:2;s:52:\"Automatically subscribe new users to your email list\";i:3;s:30:\"Drag-and-drop subscribe widget\";i:4;s:37:\"Quickly add and build subscribe forms\";i:5;s:24:\"Copy and paste API setup\";i:6;s:29:\"Simple form shortcode builder\";i:7;s:28:\"Advanced webhook integration\";i:8;s:69:\"Add/Delete WordPress users as they Subscribe/Unsubscribe in MailChimp\";i:9;s:49:\"Sync MailChimp subscriber list and site user list\";i:10;s:50:\"One-click importer for simple migration and merger\";i:11;s:33:\"Clean up existing lists on import\";i:12;s:34:\"Perfect for new and existing sites\";i:13;s:74:\"Bonus: Integrates with PopUp Pro and creates elegant Subscribe Form popups\";}s:7:\"version\";s:5:\"1.9.6\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:69:\"https://premium.wpmudev.org/project/mailchimp-newsletter-integration/\";s:9:\"thumbnail\";s:88:\"https://premium.wpmudev.org/wp-content/uploads/2009/04/Mailchimp-Integration-280x158.png\";s:16:\"thumbnail_square\";s:86:\"https://premium.wpmudev.org/wp-content/uploads/2009/04/Mailchimp-Integration-90x90.png\";s:15:\"thumbnail_large\";s:80:\"https://premium.wpmudev.org/wp-content/uploads/2009/04/Mailchimp-Integration.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/l8pbz09bnn\";s:13:\"wp_config_url\";s:34:\"options-general.php?page=mailchimp\";s:13:\"ms_config_url\";s:27:\"settings.php?page=mailchimp\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:114:\"https://premium.wpmudev.org/wp-content/projects/73/screenshots/273092899_mailchimp-integration-1300-settings-1.png\";s:4:\"desc\";s:64:\"Setting up and integrating your MailChimp account with your site\";}i:1;a:2:{s:3:\"url\";s:111:\"https://premium.wpmudev.org/wp-content/projects/73/screenshots/1572540629_mailchimp-integration-1300-widget.png\";s:4:\"desc\";s:42:\"Add a MailChimp optin widget to your site.\";}i:2;a:2:{s:3:\"url\";s:115:\"https://premium.wpmudev.org/wp-content/projects/73/screenshots/155988140_mailchimp-integration-1300-create-list.png\";s:4:\"desc\";s:56:\"Setting up a new list in MailChimp to use with your site\";}i:3;a:2:{s:3:\"url\";s:108:\"https://premium.wpmudev.org/wp-content/projects/73/screenshots/621542836_1221086016_mailchimp dropdown 4.jpg\";s:4:\"desc\";s:47:\"Example of a newsletter created using MailChimp\";}}s:6:\"_order\";i:43;}i:154;a:26:{s:2:\"id\";i:154;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:13:\"Multi-Domains\";s:8:\"released\";i:1283308137;s:7:\"updated\";i:1530080844;s:9:\"downloads\";s:5:\"41153\";s:10:\"popularity\";s:4:\"2457\";s:17:\"short_description\";s:71:\"Offer sites with unlimited and different domain options from Multisite.\";s:8:\"features\";a:12:{i:0;s:32:\"Offer multiple host domain names\";i:1;s:22:\"Add value to Multisite\";i:2;s:29:\"Add domain selector at signup\";i:3;s:27:\"Automatically adds dropdown\";i:4;s:20:\"Single settings page\";i:5;s:33:\"Public – available to all users\";i:6;s:32:\"Private – Super Admin use only\";i:7;s:19:\"Single sign-on sync\";i:8;s:12:\"Global login\";i:9;s:20:\"One-click add/remove\";i:10;s:26:\"Domain Mapping integration\";i:11;s:29:\"New Blog Template integration\";}s:7:\"version\";s:7:\"1.3.4.5\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:31:\"Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:50:\"https://premium.wpmudev.org/project/multi-domains/\";s:9:\"thumbnail\";s:83:\"https://premium.wpmudev.org/wp-content/uploads/2010/09/Multiple_domains-280x158.png\";s:16:\"thumbnail_square\";s:81:\"https://premium.wpmudev.org/wp-content/uploads/2010/09/Multiple_domains-90x90.png\";s:15:\"thumbnail_large\";s:75:\"https://premium.wpmudev.org/wp-content/uploads/2010/09/Multiple_domains.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/3wsqqpd2go\";s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:31:\"settings.php?page=multi-domains\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:94:\"https://premium.wpmudev.org/wp-content/projects/154/screenshots/1477359183_domains-735x470.jpg\";s:4:\"desc\";s:21:\"Simple domain manager\";}i:1;a:2:{s:3:\"url\";s:98:\"https://premium.wpmudev.org/wp-content/projects/154/screenshots/1834796519_multi-domain735x470.jpg\";s:4:\"desc\";s:14:\"Domain example\";}i:2;a:2:{s:3:\"url\";s:98:\"https://premium.wpmudev.org/wp-content/projects/154/screenshots/1940184678_global-logon735x470.jpg\";s:4:\"desc\";s:26:\"Global login Multi-domains\";}i:3;a:2:{s:3:\"url\";s:99:\"https://premium.wpmudev.org/wp-content/projects/154/screenshots/1424538203_users-choose-735x470.jpg\";s:4:\"desc\";s:11:\"Offer users\";}}s:6:\"_order\";i:44;}i:81;a:26:{s:2:\"id\";i:81;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:11:\"Automessage\";s:8:\"released\";i:1244679401;s:7:\"updated\";i:1530080756;s:9:\"downloads\";s:5:\"46530\";s:10:\"popularity\";s:4:\"1929\";s:17:\"short_description\";s:83:\"Welcome new users with custom automated emails when they join your site or network.\";s:8:\"features\";a:11:{i:0;s:41:\"Trigger campaign when new user is created\";i:1;s:43:\"Trigger campaign when a new site is created\";i:2;s:34:\"Send up to 31 days worth of emails\";i:3;s:17:\"6 built-in macros\";i:4;s:46:\"Dynamically personalize names, titles and URLs\";i:5;s:15:\"Pause campaigns\";i:6;s:36:\"Multisite and BuddyPress integration\";i:7;s:39:\"Enhance WordPress Core follow-up emails\";i:8;s:34:\"Perfect for a welcome series email\";i:9;s:23:\"Manually process emails\";i:10;s:29:\"Simply edit and manage emails\";}s:7:\"version\";s:5:\"2.4.5\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:77:\"https://premium.wpmudev.org/project/automatic-follow-up-emails-for-new-users/\";s:9:\"thumbnail\";s:78:\"https://premium.wpmudev.org/wp-content/uploads/2009/06/Automessage-280x158.png\";s:16:\"thumbnail_square\";s:76:\"https://premium.wpmudev.org/wp-content/uploads/2009/06/Automessage-90x90.png\";s:15:\"thumbnail_large\";s:70:\"https://premium.wpmudev.org/wp-content/uploads/2009/06/Automessage.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/5192zwmo51\";s:13:\"wp_config_url\";s:26:\"admin.php?page=automessage\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:87:\"https://premium.wpmudev.org/wp-content/projects/81/screenshots/737118827_auto-email.jpg\";s:4:\"desc\";s:25:\"Automessage email builder\";}i:1;a:2:{s:3:\"url\";s:85:\"https://premium.wpmudev.org/wp-content/projects/81/screenshots/265497821_auto-add.jpg\";s:4:\"desc\";s:12:\"Add new days\";}i:2;a:2:{s:3:\"url\";s:85:\"https://premium.wpmudev.org/wp-content/projects/81/screenshots/19547065_auto-days.jpg\";s:4:\"desc\";s:27:\"Automessage schedule emails\";}i:3;a:2:{s:3:\"url\";s:91:\"https://premium.wpmudev.org/wp-content/projects/81/screenshots/497799197_auto-multisite.jpg\";s:4:\"desc\";s:18:\"Automessage slides\";}}s:6:\"_order\";i:45;}i:231;a:26:{s:2:\"id\";i:231;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:18:\"Post Voting Plugin\";s:8:\"released\";i:1306152297;s:7:\"updated\";i:1530080659;s:9:\"downloads\";s:5:\"34622\";s:10:\"popularity\";s:4:\"1305\";s:17:\"short_description\";s:83:\"Gauge content popularity and bring the power of Digg to your site with user voting.\";s:8:\"features\";a:17:{i:0;s:15:\"Add post voting\";i:1;s:14:\"Visitor voting\";i:2;s:24:\"Prevents multiple voting\";i:3;s:21:\"Prompt users to login\";i:4;s:26:\"Enable voting by post type\";i:5;s:21:\"Set vote box position\";i:6;s:16:\"6 built-in looks\";i:7;s:20:\"Block negative votes\";i:8;s:12:\"Daily voting\";i:9;s:12:\"Show results\";i:10;s:23:\"Five-star rating system\";i:11;s:20:\"Works with any theme\";i:12;s:26:\"Includes shortcode library\";i:13;s:21:\"Top-voted post widget\";i:14;s:13:\"Voting widget\";i:15;s:22:\"Includes template tags\";i:16;s:30:\"Multisite network stats screen\";}s:7:\"version\";s:5:\"2.2.5\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:55:\"https://premium.wpmudev.org/project/post-voting-plugin/\";s:9:\"thumbnail\";s:85:\"https://premium.wpmudev.org/wp-content/uploads/2011/05/Post-Voting-Plugin-280x158.png\";s:16:\"thumbnail_square\";s:83:\"https://premium.wpmudev.org/wp-content/uploads/2011/05/Post-Voting-Plugin-90x90.png\";s:15:\"thumbnail_large\";s:77:\"https://premium.wpmudev.org/wp-content/uploads/2011/05/Post-Voting-Plugin.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/9dq2bonu2j\";s:13:\"wp_config_url\";s:29:\"options-general.php?page=wdpv\";s:13:\"ms_config_url\";s:22:\"settings.php?page=wdpv\";s:7:\"package\";i:0;s:11:\"screenshots\";a:3:{i:0;a:2:{s:3:\"url\";s:100:\"https://premium.wpmudev.org/wp-content/projects/231/screenshots/160947053_vote-post-type-735x470.jpg\";s:4:\"desc\";s:14:\"Post vote type\";}i:1;a:2:{s:3:\"url\";s:96:\"https://premium.wpmudev.org/wp-content/projects/231/screenshots/1659367321_icon-vote-735x470.jpg\";s:4:\"desc\";s:12:\"Voting icons\";}i:2;a:2:{s:3:\"url\";s:93:\"https://premium.wpmudev.org/wp-content/projects/231/screenshots/1803625515_5-star-735x470.jpg\";s:4:\"desc\";s:13:\"5 star system\";}}s:6:\"_order\";i:46;}i:232;a:26:{s:2:\"id\";i:232;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:21:\"BuddyPress Activity +\";s:8:\"released\";i:1306181880;s:7:\"updated\";i:1530080564;s:9:\"downloads\";s:5:\"31984\";s:10:\"popularity\";s:4:\"1533\";s:17:\"short_description\";s:84:\"Let your users share images, videos and links across your BuddyPress social network.\";s:8:\"features\";a:17:{i:0;s:19:\"Works on activation\";i:1;s:20:\"Simple video sharing\";i:2;s:32:\"Share YouTube videos with a link\";i:3;s:30:\"Share Vimeo videos with a link\";i:4;s:12:\"Image upload\";i:5;s:18:\"Share linked image\";i:6;s:17:\"Easy link sharing\";i:7;s:24:\"Auto site title creation\";i:8;s:16:\"Auto description\";i:9;s:16:\"Thumbnail select\";i:10;s:28:\"Three included button styles\";i:11;s:12:\"Legacy style\";i:12;s:12:\"Modern style\";i:13;s:13:\"Rounded style\";i:14;s:18:\"Alignment controls\";i:15;s:16:\"Set oEmbed width\";i:16;s:27:\"Set default image thumbnail\";}s:7:\"version\";s:5:\"1.6.5\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"bp\";s:3:\"url\";s:73:\"https://premium.wpmudev.org/project/media-embeds-for-buddypress-activity/\";s:9:\"thumbnail\";s:77:\"https://premium.wpmudev.org/wp-content/uploads/2011/05/buddyPress-280x158.png\";s:16:\"thumbnail_square\";s:75:\"https://premium.wpmudev.org/wp-content/uploads/2011/05/buddyPress-90x90.png\";s:15:\"thumbnail_large\";s:69:\"https://premium.wpmudev.org/wp-content/uploads/2011/05/buddyPress.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/dq21xpntu8\";s:13:\"wp_config_url\";s:38:\"options-general.php?page=bpfb-settings\";s:13:\"ms_config_url\";s:31:\"settings.php?page=bpfb-settings\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:96:\"https://premium.wpmudev.org/wp-content/projects/232/screenshots/1679863851_link-post-735x470.jpg\";s:4:\"desc\";s:11:\"Share links\";}i:1;a:2:{s:3:\"url\";s:100:\"https://premium.wpmudev.org/wp-content/projects/232/screenshots/1569201850_size-settings-735x470.jpg\";s:4:\"desc\";s:9:\"Set sizes\";}i:2;a:2:{s:3:\"url\";s:97:\"https://premium.wpmudev.org/wp-content/projects/232/screenshots/701966533_share-video-735x470.jpg\";s:4:\"desc\";s:30:\"Share from BuddyPress Activity\";}i:3;a:2:{s:3:\"url\";s:93:\"https://premium.wpmudev.org/wp-content/projects/232/screenshots/1199393604_styles-735x470.jpg\";s:4:\"desc\";s:17:\"3 Built-in Styles\";}}s:6:\"_order\";i:47;}i:679160;a:26:{s:2:\"id\";i:679160;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:15:\"Site Categories\";s:8:\"released\";i:1341351858;s:7:\"updated\";i:1530080489;s:9:\"downloads\";s:5:\"28474\";s:10:\"popularity\";s:4:\"1094\";s:17:\"short_description\";s:71:\"Easily categorize sites on your Multisite network with Site Categories.\";s:8:\"features\";a:18:{i:0;s:21:\"Custom category icons\";i:1;s:20:\"Display site avatars\";i:2;s:17:\"Nested categories\";i:3;s:26:\"Select custom landing page\";i:4;s:19:\"Display pretty URLs\";i:5;s:41:\"Customize user category selection options\";i:6;s:16:\"Category exclude\";i:7;s:26:\"Display as an ordered list\";i:8;s:28:\"Display as an unordered list\";i:9;s:21:\"Accordion list option\";i:10;s:11:\"Grid layout\";i:11;s:13:\"Dropdown menu\";i:12;s:24:\"Show category site count\";i:13;s:25:\"Show category description\";i:14;s:34:\"Add category select to site signup\";i:15;s:36:\"Simple category management interface\";i:16;s:29:\"Category select for each site\";i:17;s:17:\"Site descriptions\";}s:7:\"version\";s:7:\"1.0.9.4\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:13:\"Multisite 5.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:52:\"https://premium.wpmudev.org/project/site-categories/\";s:9:\"thumbnail\";s:82:\"https://premium.wpmudev.org/wp-content/uploads/2012/07/Site_categories-280x158.png\";s:16:\"thumbnail_square\";s:80:\"https://premium.wpmudev.org/wp-content/uploads/2012/07/Site_categories-90x90.png\";s:15:\"thumbnail_large\";s:74:\"https://premium.wpmudev.org/wp-content/uploads/2012/07/Site_categories.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/tvv151c52r\";s:13:\"wp_config_url\";s:43:\"options-general.php?page=bcat_settings_site\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:3:{i:0;a:2:{s:3:\"url\";s:98:\"https://premium.wpmudev.org/wp-content/projects/679160/screenshots/165487965_grid-view-735x470.jpg\";s:4:\"desc\";s:9:\"Grid view\";}i:1;a:2:{s:3:\"url\";s:97:\"https://premium.wpmudev.org/wp-content/projects/679160/screenshots/987132712_settings-735x470.jpg\";s:4:\"desc\";s:22:\"site category settings\";}i:2;a:2:{s:3:\"url\";s:94:\"https://premium.wpmudev.org/wp-content/projects/679160/screenshots/1046693845_site-735x470.jpg\";s:4:\"desc\";s:28:\"Create categories with icons\";}}s:6:\"_order\";i:48;}i:260;a:26:{s:2:\"id\";i:260;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:16:\"Comments Control\";s:8:\"released\";i:1331240170;s:7:\"updated\";i:1530080399;s:9:\"downloads\";s:5:\"16047\";s:10:\"popularity\";s:3:\"427\";s:17:\"short_description\";s:87:\"Eliminate the annoying, ‘You are posting comments too quickly. Slow down.’ message.\";s:8:\"features\";a:9:{i:0;s:62:\"Whitelist an IP address so time between comments doesn\'t apply\";i:1;s:62:\"Give guests from a specific IP address unrestricted commenting\";i:2;s:56:\"Blacklist to prevent comments from a specific IP address\";i:3;s:24:\"Spam fighting technology\";i:4;s:32:\"Automatically  throttle visitors\";i:5;s:36:\"High-speed posting for trusted users\";i:6;s:19:\"Finetune throttling\";i:7;s:21:\"Stop comment trolling\";i:8;s:35:\"Eliminate annoying comment blocking\";}s:7:\"version\";s:7:\"1.0.1.1\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:13:\"Multisite 5.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:53:\"https://premium.wpmudev.org/project/comments-control/\";s:9:\"thumbnail\";s:83:\"https://premium.wpmudev.org/wp-content/uploads/2012/03/Comments-Control-280x158.png\";s:16:\"thumbnail_square\";s:81:\"https://premium.wpmudev.org/wp-content/uploads/2012/03/Comments-Control-90x90.png\";s:15:\"thumbnail_large\";s:75:\"https://premium.wpmudev.org/wp-content/uploads/2012/03/Comments-Control.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:12:\"settings.php\";s:7:\"package\";i:0;s:11:\"screenshots\";a:2:{i:0;a:2:{s:3:\"url\";s:101:\"https://premium.wpmudev.org/wp-content/projects/260/screenshots/607153392_comment-control-735x470.jpg\";s:4:\"desc\";s:31:\"Comment Whitelist and Blacklist\";}i:1;a:2:{s:3:\"url\";s:96:\"https://premium.wpmudev.org/wp-content/projects/260/screenshots/1497607807_slow-down-735x470.jpg\";s:4:\"desc\";s:13:\"Slow Comments\";}}s:6:\"_order\";i:49;}i:679162;a:26:{s:2:\"id\";i:679162;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:12:\"User Reports\";s:8:\"released\";i:1343233230;s:7:\"updated\";i:1530080256;s:9:\"downloads\";s:5:\"24302\";s:10:\"popularity\";s:4:\"1206\";s:17:\"short_description\";s:101:\"Create reports of all user activity in WordPress or across an entire Multisite or BuddyPress network.\";s:8:\"features\";a:0:{}s:7:\"version\";s:3:\"1.1\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:49:\"https://premium.wpmudev.org/project/user-reports/\";s:9:\"thumbnail\";s:79:\"https://premium.wpmudev.org/wp-content/uploads/2012/07/User-Reports-280x158.png\";s:16:\"thumbnail_square\";s:77:\"https://premium.wpmudev.org/wp-content/uploads/2012/07/User-Reports-90x90.png\";s:15:\"thumbnail_large\";s:71:\"https://premium.wpmudev.org/wp-content/uploads/2012/07/User-Reports.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:27:\"users.php?page=user-reports\";s:13:\"ms_config_url\";s:27:\"users.php?page=user-reports\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:94:\"https://premium.wpmudev.org/wp-content/projects/679162/screenshots/1193869101_screenshot 1.png\";s:4:\"desc\";s:45:\"Check it out in use on an Edublogs Test Site!\";}i:1;a:2:{s:3:\"url\";s:93:\"https://premium.wpmudev.org/wp-content/projects/679162/screenshots/174064047_screenshot 2.png\";s:4:\"desc\";s:20:\"Reports Per Username\";}i:2;a:2:{s:3:\"url\";s:94:\"https://premium.wpmudev.org/wp-content/projects/679162/screenshots/1083606219_screenshot 3.png\";s:4:\"desc\";s:19:\"Sample PDF Download\";}i:3;a:2:{s:3:\"url\";s:94:\"https://premium.wpmudev.org/wp-content/projects/679162/screenshots/2025150835_screenshot 4.png\";s:4:\"desc\";s:19:\"Sample CSV Download\";}}s:6:\"_order\";i:50;}i:252;a:26:{s:2:\"id\";i:252;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:20:\"Custom Google Search\";s:8:\"released\";i:1323784797;s:7:\"updated\";i:1530080163;s:9:\"downloads\";s:5:\"30020\";s:10:\"popularity\";s:4:\"1631\";s:17:\"short_description\";s:74:\"Replace the default WordPress search engine with search powered by Google.\";s:8:\"features\";a:6:{i:0;s:51:\"Improve the WordPress built-in search functionality\";i:1;s:61:\"Simple integration between Google Custom Search and WordPress\";i:2;s:40:\"Custom styles makes search look gorgeous\";i:3;s:99:\"Set custom search to search just your own site, or as many sites as you want (great for Multisite!)\";i:4;s:47:\"Built-in widget adds search box to your sidebar\";i:5;s:66:\"Display results on the search page, in a pop-up or in your sidebar\";}s:7:\"version\";s:5:\"1.2.3\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:57:\"https://premium.wpmudev.org/project/custom-google-search/\";s:9:\"thumbnail\";s:87:\"https://premium.wpmudev.org/wp-content/uploads/2011/12/Custom_google_search-280x158.png\";s:16:\"thumbnail_square\";s:85:\"https://premium.wpmudev.org/wp-content/uploads/2011/12/Custom_google_search-90x90.png\";s:15:\"thumbnail_large\";s:79:\"https://premium.wpmudev.org/wp-content/uploads/2011/12/Custom_google_search.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/95fn8l46xq\";s:13:\"wp_config_url\";s:54:\"options-general.php?page=custom-google-search-settings\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:2:{i:0;a:2:{s:3:\"url\";s:86:\"https://premium.wpmudev.org/wp-content/projects/252/screenshots/964283647_custom51.jpg\";s:4:\"desc\";s:33:\"Custom Google Search custom51.jpg\";}i:1;a:2:{s:3:\"url\";s:87:\"https://premium.wpmudev.org/wp-content/projects/252/screenshots/2094159767_custom52.jpg\";s:4:\"desc\";s:34:\"Custom Google Search custom52.jpg \";}}s:6:\"_order\";i:51;}i:175;a:26:{s:2:\"id\";i:175;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:18:\"Add Existing Users\";s:8:\"released\";i:1298565937;s:7:\"updated\";i:1530080049;s:9:\"downloads\";s:5:\"21238\";s:10:\"popularity\";s:3:\"753\";s:17:\"short_description\";s:81:\"Quickly bulk add existing users from across an entire network and set user roles.\";s:8:\"features\";a:0:{}s:7:\"version\";s:5:\"1.2.1\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:31:\"Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:55:\"https://premium.wpmudev.org/project/add-existing-users/\";s:9:\"thumbnail\";s:85:\"https://premium.wpmudev.org/wp-content/uploads/2011/02/add-users-1470x940-280x158.png\";s:16:\"thumbnail_square\";s:83:\"https://premium.wpmudev.org/wp-content/uploads/2011/02/add-users-1470x940-90x90.png\";s:15:\"thumbnail_large\";s:77:\"https://premium.wpmudev.org/wp-content/uploads/2011/02/add-users-1470x940.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:33:\"users.php?page=add-existing-users\";s:13:\"ms_config_url\";s:33:\"users.php?page=add-existing-users\";s:7:\"package\";i:0;s:11:\"screenshots\";a:1:{i:0;a:2:{s:3:\"url\";s:89:\"https://premium.wpmudev.org/wp-content/projects/175/screenshots/1502842459_addexist91.jpg\";s:4:\"desc\";s:75:\"Using Add Existing Users panel to bulk add users to a site in batches of 15\";}}s:6:\"_order\";i:52;}i:84;a:26:{s:2:\"id\";i:84;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:12:\"Batch Create\";s:8:\"released\";i:1245727483;s:7:\"updated\";i:1530079975;s:9:\"downloads\";s:5:\"30549\";s:10:\"popularity\";s:4:\"1195\";s:17:\"short_description\";s:94:\"Create hundreds or thousands of sites and users quickly by simply uploading a csv or xls file.\";s:8:\"features\";a:12:{i:0;s:35:\"Batch create new users and/or sites\";i:1;s:33:\"Batch add users to existing sites\";i:2;s:61:\"Create user with site and preset password with a default role\";i:3;s:67:\"Create user with site and auto-generated password with default role\";i:4;s:49:\"Create user without a site with a preset password\";i:5;s:46:\"Add user to an existing site with default role\";i:6;s:28:\"Ability to assign user roles\";i:7;s:44:\"Choice of preset or auto-generated passwords\";i:8;s:47:\"Supports use of both Excel and .csv batch files\";i:9;s:41:\".xls template for creating the batch file\";i:10;s:68:\"Cool status bar to display progress as batch file is being processed\";i:11;s:50:\"Automatic alert if duplicate email address is used\";}s:7:\"version\";s:5:\"1.5.2\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:31:\"Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:49:\"https://premium.wpmudev.org/project/batch-create/\";s:9:\"thumbnail\";s:79:\"https://premium.wpmudev.org/wp-content/uploads/2009/06/Batch-Create-280x158.png\";s:16:\"thumbnail_square\";s:77:\"https://premium.wpmudev.org/wp-content/uploads/2009/06/Batch-Create-90x90.png\";s:15:\"thumbnail_large\";s:71:\"https://premium.wpmudev.org/wp-content/uploads/2009/06/Batch-Create.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/3rrlarvxh5\";s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:35:\"settings.php?page=batch-create-menu\";s:7:\"package\";i:0;s:11:\"screenshots\";a:2:{i:0;a:2:{s:3:\"url\";s:87:\"https://premium.wpmudev.org/wp-content/projects/84/screenshots/1923765840_bcreate91.jpg\";s:4:\"desc\";s:52:\"The Batch Create page in the network admin dashboard\";}i:1;a:2:{s:3:\"url\";s:87:\"https://premium.wpmudev.org/wp-content/projects/84/screenshots/1680189502_bcreate92.jpg\";s:4:\"desc\";s:55:\"The .xls template included with the Batch Create plugin\";}}s:6:\"_order\";i:53;}i:7330;a:26:{s:2:\"id\";i:7330;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:15:\"Pay with a Like\";s:8:\"released\";i:1336386485;s:7:\"updated\";i:1530079820;s:9:\"downloads\";s:5:\"45451\";s:10:\"popularity\";s:4:\"1599\";s:17:\"short_description\";s:86:\"\'Charge\' a social share in Facebook, Twitter, Google+ or LinkedIn to see your content.\";s:8:\"features\";a:21:{i:0;s:13:\"Facebook Like\";i:1;s:5:\"Tweet\";i:2;s:14:\"LinkedIn share\";i:3;s:9:\"Google +1\";i:4;s:18:\"Specific post type\";i:5;s:18:\"Specific page type\";i:6;s:16:\"Automate excerpt\";i:7;s:23:\"Create excerpt manually\";i:8;s:18:\"Custom description\";i:9;s:25:\"Trigger reload when liked\";i:10;s:12:\"Define width\";i:11;s:15:\"Home Page share\";i:12;s:24:\"Protect specific content\";i:13;s:24:\"Set length of validation\";i:14;s:18:\"External page like\";i:15;s:23:\"Vertical button styling\";i:16;s:25:\"Horizontal button styling\";i:17;s:18:\"\'No Count\' buttons\";i:18;s:25:\"Built-in statistics graph\";i:19;s:19:\"Shortcode generator\";i:20;s:9:\"CSS guide\";}s:7:\"version\";s:7:\"2.0.1.5\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:52:\"https://premium.wpmudev.org/project/pay-with-a-like/\";s:9:\"thumbnail\";s:82:\"https://premium.wpmudev.org/wp-content/uploads/2012/05/Pay_With_a_Like-280x158.png\";s:16:\"thumbnail_square\";s:80:\"https://premium.wpmudev.org/wp-content/uploads/2012/05/Pay_With_a_Like-90x90.png\";s:15:\"thumbnail_large\";s:74:\"https://premium.wpmudev.org/wp-content/uploads/2012/05/Pay_With_a_Like.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/9q2wmu1bgb\";s:13:\"wp_config_url\";s:40:\"options-general.php?page=pay-with-a-like\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:3:{i:0;a:2:{s:3:\"url\";s:96:\"https://premium.wpmudev.org/wp-content/projects/7330/screenshots/1697677008_position-735x470.jpg\";s:4:\"desc\";s:15:\"Button position\";}i:1;a:2:{s:3:\"url\";s:96:\"https://premium.wpmudev.org/wp-content/projects/7330/screenshots/244278692_front-end-735x470.jpg\";s:4:\"desc\";s:24:\"Frontend Pay with a Like\";}i:2;a:2:{s:3:\"url\";s:97:\"https://premium.wpmudev.org/wp-content/projects/7330/screenshots/939964884_pay-button-735x470.jpg\";s:4:\"desc\";s:13:\"Button select\";}}s:6:\"_order\";i:54;}i:226;a:26:{s:2:\"id\";i:226;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:19:\"Recent Custom Posts\";s:8:\"released\";i:1305119703;s:7:\"updated\";i:1530079739;s:9:\"downloads\";s:5:\"24333\";s:10:\"popularity\";s:4:\"1097\";s:17:\"short_description\";s:90:\"Display a list of recent posts from any custom post type on the widget areas of your site.\";s:8:\"features\";a:0:{}s:7:\"version\";s:5:\"2.1.2\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:68:\"https://premium.wpmudev.org/project/recent-custom-posts-type-widget/\";s:9:\"thumbnail\";s:95:\"https://premium.wpmudev.org/wp-content/uploads/2011/05/recent-custom-posts-1470x940-280x158.png\";s:16:\"thumbnail_square\";s:93:\"https://premium.wpmudev.org/wp-content/uploads/2011/05/recent-custom-posts-1470x940-90x90.png\";s:15:\"thumbnail_large\";s:87:\"https://premium.wpmudev.org/wp-content/uploads/2011/05/recent-custom-posts-1470x940.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:11:\"widgets.php\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:2:{i:0;a:2:{s:3:\"url\";s:88:\"https://premium.wpmudev.org/wp-content/projects/226/screenshots/908227789_post-types.png\";s:4:\"desc\";s:33:\"Display your recent custom posts.\";}i:1;a:2:{s:3:\"url\";s:104:\"https://premium.wpmudev.org/wp-content/projects/226/screenshots/352874945_recent-custom-posts-widget.png\";s:4:\"desc\";s:27:\"Recent Custom Posts widget.\";}}s:6:\"_order\";i:55;}i:883804;a:26:{s:2:\"id\";i:883804;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:23:\"Multisite Theme Manager\";s:8:\"released\";i:1398440821;s:7:\"updated\";i:1530079623;s:9:\"downloads\";s:5:\"21720\";s:10:\"popularity\";s:4:\"1680\";s:17:\"short_description\";s:63:\"Easily edit, label and manage themes on your Multisite network.\";s:8:\"features\";a:11:{i:0;s:44:\"Create and display custom theme cover images\";i:1;s:37:\"Categorize themes for enhanced search\";i:2;s:33:\"Custom label the Theme page title\";i:3;s:35:\"Give your page a custom description\";i:4;s:43:\"Custom link label for connecting to support\";i:5;s:28:\"Configure test in setup mode\";i:6;s:32:\"Create custom theme page layouts\";i:7;s:37:\"Simple toggle show/hide theme options\";i:8;s:39:\"Export and import custom configurations\";i:9;s:29:\"Rest to original theme layout\";i:10;s:63:\"Theme deprecation system to smoothly delete themes from network\";}s:7:\"version\";s:5:\"1.1.6\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:31:\"Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:60:\"https://premium.wpmudev.org/project/multisite-theme-manager/\";s:9:\"thumbnail\";s:90:\"https://premium.wpmudev.org/wp-content/uploads/2014/04/multisite-theme-manager-280x158.png\";s:16:\"thumbnail_square\";s:88:\"https://premium.wpmudev.org/wp-content/uploads/2014/04/multisite-theme-manager-90x90.png\";s:15:\"thumbnail_large\";s:82:\"https://premium.wpmudev.org/wp-content/uploads/2014/04/multisite-theme-manager.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/1uck73bjld\";s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:45:\"settings.php?page=multisite-theme-manager.php\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:87:\"https://premium.wpmudev.org/wp-content/projects/883804/screenshots/402103829_labels.jpg\";s:4:\"desc\";s:15:\"Edit the labels\";}i:1;a:2:{s:3:\"url\";s:90:\"https://premium.wpmudev.org/wp-content/projects/883804/screenshots/1983084817_prosites.jpg\";s:4:\"desc\";s:20:\"Prosites integration\";}i:2;a:2:{s:3:\"url\";s:94:\"https://premium.wpmudev.org/wp-content/projects/883804/screenshots/1467585434_custom-image.jpg\";s:4:\"desc\";s:14:\"Custome images\";}i:3;a:2:{s:3:\"url\";s:92:\"https://premium.wpmudev.org/wp-content/projects/883804/screenshots/1738167999_categories.jpg\";s:4:\"desc\";s:10:\"Categories\";}}s:6:\"_order\";i:56;}i:39;a:26:{s:2:\"id\";i:39;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:18:\"Multisite Sitemaps\";s:8:\"released\";i:1225423284;s:7:\"updated\";i:1530079546;s:9:\"downloads\";s:5:\"34243\";s:10:\"popularity\";s:4:\"1487\";s:17:\"short_description\";s:57:\"Easily generate sitemaps for Multisite after every post. \";s:8:\"features\";a:0:{}s:7:\"version\";s:3:\"1.1\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:13:\"Multisite 5.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:72:\"https://premium.wpmudev.org/project/sitemaps-and-seo-wordpress-mu-style/\";s:9:\"thumbnail\";s:94:\"https://premium.wpmudev.org/wp-content/uploads/2008/10/multisite-sitemaps-1470x940-280x158.png\";s:16:\"thumbnail_square\";s:92:\"https://premium.wpmudev.org/wp-content/uploads/2008/10/multisite-sitemaps-1470x940-90x90.png\";s:15:\"thumbnail_large\";s:86:\"https://premium.wpmudev.org/wp-content/uploads/2008/10/multisite-sitemaps-1470x940.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:1:{i:0;a:2:{s:3:\"url\";s:106:\"https://premium.wpmudev.org/wp-content/projects/39/screenshots/194055106_simple-sitemaps-for-multisite.jpg\";s:4:\"desc\";s:58:\"Simple Sitemaps for Multisite is quick and easy to set up.\";}}s:6:\"_order\";i:57;}i:852474;a:26:{s:2:\"id\";i:852474;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:14:\"Pretty Plugins\";s:8:\"released\";i:1382364051;s:7:\"updated\";i:1530079472;s:9:\"downloads\";s:5:\"20816\";s:10:\"popularity\";s:4:\"1493\";s:17:\"short_description\";s:85:\"The pretty way to list, sort, manage and even sell plugins on your multisite network.\";s:8:\"features\";a:0:{}s:7:\"version\";s:5:\"1.5.4\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:31:\"Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:51:\"https://premium.wpmudev.org/project/pretty-plugins/\";s:9:\"thumbnail\";s:81:\"https://premium.wpmudev.org/wp-content/uploads/2013/10/pretty-plugins-280x158.png\";s:16:\"thumbnail_square\";s:79:\"https://premium.wpmudev.org/wp-content/uploads/2013/10/pretty-plugins-90x90.png\";s:15:\"thumbnail_large\";s:73:\"https://premium.wpmudev.org/wp-content/uploads/2013/10/pretty-plugins.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/9p7hvzpy4l\";s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:36:\"settings.php?page=pretty-plugins.php\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:94:\"https://premium.wpmudev.org/wp-content/projects/852474/screenshots/1803484141_screenshot-1.png\";s:4:\"desc\";s:44:\"Plugin listings have never looked this good!\";}i:1;a:2:{s:3:\"url\";s:94:\"https://premium.wpmudev.org/wp-content/projects/852474/screenshots/1464813813_screenshot-3.png\";s:4:\"desc\";s:58:\"Access the comprehensive Settings page from the Admin menu\";}i:2;a:2:{s:3:\"url\";s:93:\"https://premium.wpmudev.org/wp-content/projects/852474/screenshots/357225336_screenshot-4.png\";s:4:\"desc\";s:68:\"Customize every aspect of how a site\'s plugin page looks and behaves\";}i:3;a:2:{s:3:\"url\";s:93:\"https://premium.wpmudev.org/wp-content/projects/852474/screenshots/951156237_screenshot-5.png\";s:4:\"desc\";s:75:\"Override any of the settings for a plugin for a truly customized experience\";}}s:6:\"_order\";i:58;}i:114;a:26:{s:2:\"id\";i:114;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:13:\"Add New Users\";s:8:\"released\";i:1260164624;s:7:\"updated\";i:1530079393;s:9:\"downloads\";s:5:\"27079\";s:10:\"popularity\";s:4:\"1363\";s:17:\"short_description\";s:64:\"Quickly and easily add new users to your WordPress site in bulk.\";s:8:\"features\";a:0:{}s:7:\"version\";s:5:\"1.0.8\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:50:\"https://premium.wpmudev.org/project/add-new-users/\";s:9:\"thumbnail\";s:80:\"https://premium.wpmudev.org/wp-content/uploads/2009/12/Add-New-Users-280x158.png\";s:16:\"thumbnail_square\";s:78:\"https://premium.wpmudev.org/wp-content/uploads/2009/12/Add-New-Users-90x90.png\";s:15:\"thumbnail_large\";s:72:\"https://premium.wpmudev.org/wp-content/uploads/2009/12/Add-New-Users.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:28:\"users.php?page=add-new-users\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:1:{i:0;a:2:{s:3:\"url\";s:103:\"https://premium.wpmudev.org/wp-content/projects/114/screenshots/1170609687_add-new-users-screenshot.png\";s:4:\"desc\";s:42:\"Easily add new users to your site in bulk.\";}}s:6:\"_order\";i:59;}i:218;a:26:{s:2:\"id\";i:218;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:19:\"WordPress User Sync\";s:8:\"released\";i:1302578970;s:7:\"updated\";i:-62169984000;s:9:\"downloads\";s:5:\"34899\";s:10:\"popularity\";s:4:\"2448\";s:17:\"short_description\";s:81:\"Sync user accounts and transfer profiles across multiple WordPress installations.\";s:8:\"features\";a:11:{i:0;s:38:\"One user account across multiple sites\";i:1;s:30:\"Manual and automated user sync\";i:2;s:55:\"Instant password and profile updates on connected sites\";i:3;s:33:\"Subsite list and activity manager\";i:4;s:36:\"Overwrite for complete synchronicity\";i:5;s:52:\"Supports backward user compatibility with duplicates\";i:6;s:40:\"Ban users from repopulating when deleted\";i:7;s:19:\"Secure site linking\";i:8;s:23:\"User share and transfer\";i:9;s:33:\"Uninstall plugin database cleanup\";i:10;s:20:\"Simple configuration\";}s:7:\"version\";s:5:\"1.1.6\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:31:\"WordPress 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:67:\"https://premium.wpmudev.org/project/wordpress-user-synchronization/\";s:9:\"thumbnail\";s:87:\"https://premium.wpmudev.org/wp-content/uploads/2011/04/user_synchronization-280x158.png\";s:16:\"thumbnail_square\";s:85:\"https://premium.wpmudev.org/wp-content/uploads/2011/04/user_synchronization-90x90.png\";s:15:\"thumbnail_large\";s:79:\"https://premium.wpmudev.org/wp-content/uploads/2011/04/user_synchronization.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/jy7a3r0bok\";s:13:\"wp_config_url\";s:24:\"admin.php?page=user-sync\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:89:\"https://premium.wpmudev.org/wp-content/projects/218/screenshots/322964715_sync-worked.jpg\";s:4:\"desc\";s:16:\"Sync successful \";}i:1;a:2:{s:3:\"url\";s:92:\"https://premium.wpmudev.org/wp-content/projects/218/screenshots/1891112340_sync-sub-site.jpg\";s:4:\"desc\";s:22:\"Subsite sync selection\";}i:2;a:2:{s:3:\"url\";s:87:\"https://premium.wpmudev.org/wp-content/projects/218/screenshots/250823318_uninstall.jpg\";s:4:\"desc\";s:14:\"Unistal option\";}i:3;a:2:{s:3:\"url\";s:88:\"https://premium.wpmudev.org/wp-content/projects/218/screenshots/1376512556_sync-list.jpg\";s:4:\"desc\";s:13:\"Sync settings\";}}s:6:\"_order\";i:60;}i:256;a:26:{s:2:\"id\";i:256;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:13:\"Login Message\";s:8:\"released\";i:1328689083;s:7:\"updated\";i:1530079238;s:9:\"downloads\";s:5:\"27727\";s:10:\"popularity\";s:4:\"1993\";s:17:\"short_description\";s:86:\"Add a custom message, footer and disable password reset on the WordPress login screen.\";s:8:\"features\";a:6:{i:0;s:55:\"Display a message above the username and password field\";i:1;s:28:\"Show a custom footer message\";i:2;s:56:\"Display messages on every login page across your network\";i:3;s:33:\"Disable the password reset option\";i:4;s:43:\"Custom \'Password reset not allowed message\'\";i:5;s:34:\"Block spammers from password reset\";}s:7:\"version\";s:5:\"1.0.2\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:51:\"https://premium.wpmudev.org/project/log-in-message/\";s:9:\"thumbnail\";s:81:\"https://premium.wpmudev.org/wp-content/uploads/2012/02/log-in-message-280x158.png\";s:16:\"thumbnail_square\";s:79:\"https://premium.wpmudev.org/wp-content/uploads/2012/02/log-in-message-90x90.png\";s:15:\"thumbnail_large\";s:73:\"https://premium.wpmudev.org/wp-content/uploads/2012/02/log-in-message.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:19:\"options-general.php\";s:13:\"ms_config_url\";s:12:\"settings.php\";s:7:\"package\";i:0;s:11:\"screenshots\";a:2:{i:0;a:2:{s:3:\"url\";s:87:\"https://premium.wpmudev.org/wp-content/projects/256/screenshots/1584648252_settings.jpg\";s:4:\"desc\";s:30:\"Settings are easy to configure\";}i:1;a:2:{s:3:\"url\";s:86:\"https://premium.wpmudev.org/wp-content/projects/256/screenshots/1890451717_message.jpg\";s:4:\"desc\";s:34:\"Show a message on the login screen\";}}s:6:\"_order\";i:61;}i:105;a:26:{s:2:\"id\";i:105;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:16:\"Global Site Tags\";s:8:\"released\";i:1253726306;s:7:\"updated\";i:1530079156;s:9:\"downloads\";s:5:\"23757\";s:10:\"popularity\";s:3:\"771\";s:17:\"short_description\";s:99:\"Share a tag cloud of trending topics and popular content from across your entire Multisite network.\";s:8:\"features\";a:11:{i:0;s:28:\"Automate setup on activation\";i:1;s:57:\"Shares trends and popular content from a visual interface\";i:2;s:52:\"Tags link to archive pages for more ways to discover\";i:3;s:41:\"Configure to show only tags you want seen\";i:4;s:21:\"Style-match any theme\";i:5;s:30:\"Display tag cloud network-wide\";i:6;s:91:\"Complete control over display settings – number of tags, number of posts listed and color\";i:7;s:38:\"Built for Multisite from the ground up\";i:8;s:37:\"Paginate for clear, simple navigation\";i:9;s:49:\"Adds only essential code for simplicity and speed\";i:10;s:45:\"Integrates seamlessly with core settings page\";}s:7:\"version\";s:7:\"3.1.0.1\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:31:\"Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:53:\"https://premium.wpmudev.org/project/global-site-tags/\";s:9:\"thumbnail\";s:92:\"https://premium.wpmudev.org/wp-content/uploads/2009/09/global-site-tags-1470x940-280x158.png\";s:16:\"thumbnail_square\";s:90:\"https://premium.wpmudev.org/wp-content/uploads/2009/09/global-site-tags-1470x940-90x90.png\";s:15:\"thumbnail_large\";s:84:\"https://premium.wpmudev.org/wp-content/uploads/2009/09/global-site-tags-1470x940.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:12:\"settings.php\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:85:\"https://premium.wpmudev.org/wp-content/projects/105/screenshots/1899320267_banned.jpg\";s:4:\"desc\";s:16:\"Band tag setting\";}i:1;a:2:{s:3:\"url\";s:86:\"https://premium.wpmudev.org/wp-content/projects/105/screenshots/760096624_settings.jpg\";s:4:\"desc\";s:22:\"Added to site settings\";}i:2;a:2:{s:3:\"url\";s:83:\"https://premium.wpmudev.org/wp-content/projects/105/screenshots/1215646145_list.jpg\";s:4:\"desc\";s:9:\"Post list\";}i:3;a:2:{s:3:\"url\";s:88:\"https://premium.wpmudev.org/wp-content/projects/105/screenshots/1507927670_tag-cloud.jpg\";s:4:\"desc\";s:9:\"Tag cloud\";}}s:6:\"_order\";i:62;}i:108;a:26:{s:2:\"id\";i:108;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:10:\"Simple Ads\";s:8:\"released\";i:1255557857;s:7:\"updated\";i:1530079088;s:9:\"downloads\";s:5:\"29694\";s:10:\"popularity\";s:4:\"1282\";s:17:\"short_description\";s:69:\"Insert ads before and after posts and pages across an entire network.\";s:8:\"features\";a:10:{i:0;s:16:\"Display on posts\";i:1;s:11:\"In-page ads\";i:2;s:23:\"Show ads before content\";i:3;s:20:\"Insert after content\";i:4;s:17:\"Set number of ads\";i:5;s:22:\"Copy and paste ad code\";i:6;s:21:\"Hide ads on main site\";i:7;s:19:\"Built for Multisite\";i:8;s:15:\"Irremovable ads\";i:9;s:21:\"Dashboard integration\";}s:7:\"version\";s:5:\"1.0.6\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:47:\"https://premium.wpmudev.org/project/simple-ads/\";s:9:\"thumbnail\";s:73:\"https://premium.wpmudev.org/wp-content/uploads/2009/10/Simple-280x158.png\";s:16:\"thumbnail_square\";s:71:\"https://premium.wpmudev.org/wp-content/uploads/2009/10/Simple-90x90.png\";s:15:\"thumbnail_large\";s:65:\"https://premium.wpmudev.org/wp-content/uploads/2009/10/Simple.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:36:\"options-general.php?page=advertising\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:2:{i:0;a:2:{s:3:\"url\";s:98:\"https://premium.wpmudev.org/wp-content/projects/108/screenshots/1587293365_simple-show-735x470.jpg\";s:4:\"desc\";s:18:\"Show on main site.\";}i:1;a:2:{s:3:\"url\";s:101:\"https://premium.wpmudev.org/wp-content/projects/108/screenshots/467636039_simple-settings-735x470.jpg\";s:4:\"desc\";s:20:\"Quick configuration.\";}}s:6:\"_order\";i:63;}i:151;a:25:{s:2:\"id\";i:151;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:14:\"Contact Widget\";s:8:\"released\";i:1279318575;s:7:\"updated\";i:1530079033;s:9:\"downloads\";s:5:\"41167\";s:10:\"popularity\";s:4:\"2164\";s:17:\"short_description\";s:96:\"A simple, powerful and easy to use contact form widget to let your visitors easily get in touch.\";s:8:\"features\";a:0:{}s:7:\"version\";s:5:\"2.2.1\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:28:\"WordPress 5.0, Multisite 5.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:51:\"https://premium.wpmudev.org/project/contact-widget/\";s:9:\"thumbnail\";s:73:\"https://premium.wpmudev.org/wp-content/uploads/2010/07/contact-widget.png\";s:16:\"thumbnail_square\";s:81:\"https://premium.wpmudev.org/wp-content/uploads/2010/07/contact-widget-150x150.png\";s:15:\"thumbnail_large\";s:73:\"https://premium.wpmudev.org/wp-content/uploads/2010/07/contact-widget.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/9pe1poud5p\";s:13:\"wp_config_url\";s:11:\"widgets.php\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:6:\"_order\";i:64;}i:101;a:26:{s:2:\"id\";i:101;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:15:\"Blogs Directory\";s:8:\"released\";i:1251942508;s:7:\"updated\";i:1530078946;s:9:\"downloads\";s:5:\"29354\";s:10:\"popularity\";s:3:\"933\";s:17:\"short_description\";s:93:\"Clean, searchable, fully-automated site list and blog directory for Multisite and BuddyPress.\";s:8:\"features\";a:11:{i:0;s:42:\"Add site directory instantly on activation\";i:1;s:30:\"Automated site list management\";i:2;s:26:\"Simple color customization\";i:3;s:75:\"Choose directory display order– alphabetical, recently updated and newest\";i:4;s:32:\"Site search for quick navigation\";i:5;s:32:\"Manage list length with paginate\";i:6;s:52:\"Toggle description display and rename directory page\";i:7;s:31:\"Convenient single-page settings\";i:8;s:47:\"Display blog avatars on site list using Avatars\";i:9;s:35:\"Integrate seamlessly with Pro Sites\";i:10;s:43:\"Built entirely for Multisite and BuddyPress\";}s:7:\"version\";s:7:\"1.2.0.4\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:13:\"Multisite 5.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:52:\"https://premium.wpmudev.org/project/blogs-directory/\";s:9:\"thumbnail\";s:74:\"https://premium.wpmudev.org/wp-content/uploads/2009/09/blogs-directory.png\";s:16:\"thumbnail_square\";s:82:\"https://premium.wpmudev.org/wp-content/uploads/2009/09/blogs-directory-150x150.png\";s:15:\"thumbnail_large\";s:74:\"https://premium.wpmudev.org/wp-content/uploads/2009/09/blogs-directory.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:12:\"settings.php\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:97:\"https://premium.wpmudev.org/wp-content/projects/101/screenshots/1715287928_directory-settings.jpg\";s:4:\"desc\";s:18:\"Directory settings\";}i:1;a:2:{s:3:\"url\";s:100:\"https://premium.wpmudev.org/wp-content/projects/101/screenshots/1787607621_pro-sites-integration.jpg\";s:4:\"desc\";s:21:\"Pro Sites integration\";}i:2;a:2:{s:3:\"url\";s:88:\"https://premium.wpmudev.org/wp-content/projects/101/screenshots/171451168_sites-list.jpg\";s:4:\"desc\";s:10:\"Sites List\";}i:3;a:2:{s:3:\"url\";s:103:\"https://premium.wpmudev.org/wp-content/projects/101/screenshots/923059075_blogs-directory-search[1].png\";s:4:\"desc\";s:0:\"\";}}s:6:\"_order\";i:65;}i:98;a:26:{s:2:\"id\";i:98;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:11:\"Signup Code\";s:8:\"released\";i:1251230601;s:7:\"updated\";i:1530078893;s:9:\"downloads\";s:5:\"25826\";s:10:\"popularity\";s:3:\"666\";s:17:\"short_description\";s:126:\"Build an exclusive network or block fake site and user creation – set a special code to register on your Multisite network. \";s:8:\"features\";a:11:{i:0;s:22:\"One-step configuration\";i:1;s:22:\"Code manage in seconds\";i:2;s:22:\"Block bot registration\";i:3;s:32:\"Protected user and site creation\";i:4;s:14:\"Added security\";i:5;s:46:\"Lite design structure for enhanced performance\";i:6;s:25:\"Simple end-user interface\";i:7;s:22:\"Style match technology\";i:8;s:31:\"Built exclusively for Multisite\";i:9;s:39:\"Third-party theme and plugin compatible\";i:10;s:52:\"Backed by the best WordPress developers in the world\";}s:7:\"version\";s:7:\"1.0.3.3\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:31:\"Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:48:\"https://premium.wpmudev.org/project/signup-code/\";s:9:\"thumbnail\";s:70:\"https://premium.wpmudev.org/wp-content/uploads/2009/08/signup-code.jpg\";s:16:\"thumbnail_square\";s:78:\"https://premium.wpmudev.org/wp-content/uploads/2009/08/signup-code-150x150.jpg\";s:15:\"thumbnail_large\";s:70:\"https://premium.wpmudev.org/wp-content/uploads/2009/08/signup-code.jpg\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:29:\"settings.php?page=signup_code\";s:7:\"package\";i:0;s:11:\"screenshots\";a:3:{i:0;a:2:{s:3:\"url\";s:93:\"https://premium.wpmudev.org/wp-content/projects/98/screenshots/1929876634_signup-location.jpg\";s:4:\"desc\";s:24:\"Signup is under settings\";}i:1;a:2:{s:3:\"url\";s:89:\"https://premium.wpmudev.org/wp-content/projects/98/screenshots/1853913697_signup-page.jpg\";s:4:\"desc\";s:18:\"Signup on frontend\";}i:2;a:2:{s:3:\"url\";s:89:\"https://premium.wpmudev.org/wp-content/projects/98/screenshots/1171581545_create-code.gif\";s:4:\"desc\";s:20:\"Create a signup code\";}}s:6:\"_order\";i:66;}i:87;a:26:{s:2:\"id\";i:87;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:24:\"Global Author Posts Feed\";s:8:\"released\";i:1249588723;s:7:\"updated\";i:1530078797;s:9:\"downloads\";s:5:\"16855\";s:10:\"popularity\";s:3:\"366\";s:17:\"short_description\";s:73:\"Create a global feed of posts, of any author, across a Multisite network.\";s:8:\"features\";a:0:{}s:7:\"version\";s:5:\"3.0.2\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:31:\"Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:68:\"https://premium.wpmudev.org/project/recent-global-author-posts-feed/\";s:9:\"thumbnail\";s:91:\"https://premium.wpmudev.org/wp-content/uploads/2009/08/Global-Author-Posts-Feed-280x158.png\";s:16:\"thumbnail_square\";s:89:\"https://premium.wpmudev.org/wp-content/uploads/2009/08/Global-Author-Posts-Feed-90x90.png\";s:15:\"thumbnail_large\";s:83:\"https://premium.wpmudev.org/wp-content/uploads/2009/08/Global-Author-Posts-Feed.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:2:{i:0;a:2:{s:3:\"url\";s:106:\"https://premium.wpmudev.org/wp-content/projects/87/screenshots/327700665_global-author-posts-feed-link.png\";s:4:\"desc\";s:29:\"Global Author Posts Feed LInk\";}i:1;a:2:{s:3:\"url\";s:106:\"https://premium.wpmudev.org/wp-content/projects/87/screenshots/154015343_global-author-posts-feed-feed.png\";s:4:\"desc\";s:24:\"Global Author Posts Feed\";}}s:6:\"_order\";i:67;}i:88;a:25:{s:2:\"id\";i:88;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:27:\"Global Author Comments Feed\";s:8:\"released\";i:1249588769;s:7:\"updated\";i:1530078698;s:9:\"downloads\";s:5:\"16704\";s:10:\"popularity\";s:3:\"291\";s:17:\"short_description\";s:99:\"Provides a global feed of comments from a single author made across multiple sites on your network.\";s:8:\"features\";a:0:{}s:7:\"version\";s:7:\"1.0.3.3\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:31:\"Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:71:\"https://premium.wpmudev.org/project/recent-global-author-comments-feed/\";s:9:\"thumbnail\";s:79:\"https://premium.wpmudev.org/wp-content/uploads/2009/08/global-comments-feed.jpg\";s:16:\"thumbnail_square\";s:87:\"https://premium.wpmudev.org/wp-content/uploads/2009/08/global-comments-feed-150x150.jpg\";s:15:\"thumbnail_large\";s:79:\"https://premium.wpmudev.org/wp-content/uploads/2009/08/global-comments-feed.jpg\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:6:\"_order\";i:68;}i:85;a:26:{s:2:\"id\";i:85;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:9:\"Ad Widget\";s:8:\"released\";i:1247600526;s:7:\"updated\";i:1530078574;s:9:\"downloads\";s:5:\"29134\";s:10:\"popularity\";s:3:\"661\";s:17:\"short_description\";s:86:\"Simply share ads based on search engine being used, user type and link used to arrive.\";s:8:\"features\";a:11:{i:0;s:55:\"Display ad to visitors – users that are not logged in\";i:1;s:36:\"Give logged in users a special offer\";i:2;s:37:\"Show ad if a user has never commented\";i:3;s:43:\"Display ad if arriving from a search engine\";i:4;s:49:\"Show if user comes to the site by clicking a link\";i:5;s:37:\"Display ad if using Internet Explorer\";i:6;s:30:\"Simple check box configuration\";i:7;s:21:\"Drag-n-drop placement\";i:8;s:27:\"Give your ad widget a title\";i:9;s:22:\"Copy and paste ad code\";i:10;s:34:\"Create special offers for visitors\";}s:7:\"version\";s:3:\"2.2\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:46:\"https://premium.wpmudev.org/project/ad-widget/\";s:9:\"thumbnail\";s:76:\"https://premium.wpmudev.org/wp-content/uploads/2009/07/Ad-Widget-280x158.png\";s:16:\"thumbnail_square\";s:76:\"https://premium.wpmudev.org/wp-content/uploads/2009/07/Ad-Widget-150x150.png\";s:15:\"thumbnail_large\";s:68:\"https://premium.wpmudev.org/wp-content/uploads/2009/07/Ad-Widget.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:11:\"widgets.php\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:2:{i:0;a:2:{s:3:\"url\";s:103:\"https://premium.wpmudev.org/wp-content/projects/85/screenshots/1635561680_ad-widget-options-735x470.jpg\";s:4:\"desc\";s:17:\"Ad widget options\";}i:1;a:2:{s:3:\"url\";s:100:\"https://premium.wpmudev.org/wp-content/projects/85/screenshots/478062789_ad-widget-action735x470.jpg\";s:4:\"desc\";s:19:\"Ad widget in action\";}}s:6:\"_order\";i:69;}i:80;a:26:{s:2:\"id\";i:80;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:23:\"Blog &amp; User Creator\";s:8:\"released\";i:1244584691;s:7:\"updated\";i:1530078450;s:9:\"downloads\";s:5:\"24619\";s:10:\"popularity\";s:3:\"641\";s:17:\"short_description\";s:90:\"Batch create gazillions of blogs and users while setting passwords, urls, titles and more.\";s:8:\"features\";a:9:{i:0;s:58:\"Bulk create new users while adding them as users to a blog\";i:1;s:34:\"Batch add existing users to a blog\";i:2;s:55:\"Mass create new blogs attached to new or existing users\";i:3;s:45:\"Ability to preset passwords for new usernames\";i:4;s:47:\"Option to add yourself as a user to their blogs\";i:5;s:70:\"Ability to add them as a user to the blog used to create their account\";i:6;s:72:\"Users and blogs automatically created and no email verification required\";i:7;s:84:\"Ability to control which users can use each component of the Blog &amp; User Creator\";i:8;s:54:\"Progress bar to show status of blog and user creations\";}s:7:\"version\";s:3:\"2.3\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:31:\"Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:58:\"https://premium.wpmudev.org/project/blog-and-user-creator/\";s:9:\"thumbnail\";s:80:\"https://premium.wpmudev.org/wp-content/uploads/2009/06/blog-and-user-creator.png\";s:16:\"thumbnail_square\";s:88:\"https://premium.wpmudev.org/wp-content/uploads/2009/06/blog-and-user-creator-150x150.png\";s:15:\"thumbnail_large\";s:80:\"https://premium.wpmudev.org/wp-content/uploads/2009/06/blog-and-user-creator.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/mz01h1ogr4\";s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:21:\"settings.php?page=bau\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:111:\"https://premium.wpmudev.org/wp-content/projects/80/screenshots/1294663447_batch user network admin dropdown.png\";s:4:\"desc\";s:53:\"Set up permissions in the Network Admin>Settings Menu\";}i:1;a:2:{s:3:\"url\";s:97:\"https://premium.wpmudev.org/wp-content/projects/80/screenshots/2060962772_site admin dropdown.png\";s:4:\"desc\";s:54:\"Add New Users from the Site Admin Dashbaord>Users menu\";}i:2;a:2:{s:3:\"url\";s:94:\"https://premium.wpmudev.org/wp-content/projects/80/screenshots/1090473440_site admin2 menu.png\";s:4:\"desc\";s:34:\"A better look at the New User menu\";}i:3;a:2:{s:3:\"url\";s:98:\"https://premium.wpmudev.org/wp-content/projects/80/screenshots/39812736_dropdown exisitng user.png\";s:4:\"desc\";s:37:\"Here is where you add existing users!\";}}s:6:\"_order\";i:70;}i:83;a:26:{s:2:\"id\";i:83;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:10:\"Lock Posts\";s:8:\"released\";i:1245453186;s:7:\"updated\";i:1530078271;s:9:\"downloads\";s:5:\"21254\";s:10:\"popularity\";s:3:\"702\";s:17:\"short_description\";s:88:\"Lock any post across your network from being edited by any user – even administrators.\";s:8:\"features\";a:0:{}s:7:\"version\";s:5:\"1.1.7\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:47:\"https://premium.wpmudev.org/project/lock-posts/\";s:9:\"thumbnail\";s:77:\"https://premium.wpmudev.org/wp-content/uploads/2009/06/Lock_posts-280x158.png\";s:16:\"thumbnail_square\";s:75:\"https://premium.wpmudev.org/wp-content/uploads/2009/06/Lock_posts-90x90.png\";s:15:\"thumbnail_large\";s:69:\"https://premium.wpmudev.org/wp-content/uploads/2009/06/Lock_posts.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:3:{i:0;a:2:{s:3:\"url\";s:99:\"https://premium.wpmudev.org/wp-content/projects/83/screenshots/899120426_lock-posts-1150-editor.png\";s:4:\"desc\";s:17:\"Lock Posts editor\";}i:1;a:2:{s:3:\"url\";s:100:\"https://premium.wpmudev.org/wp-content/projects/83/screenshots/1973122334_lock-posts-1150-locked.png\";s:4:\"desc\";s:17:\"Lock Posts locked\";}i:2;a:2:{s:3:\"url\";s:108:\"https://premium.wpmudev.org/wp-content/projects/83/screenshots/1481085692_lock-posts-1150-locked-message.png\";s:4:\"desc\";s:24:\"Lock Post locked message\";}}s:6:\"_order\";i:71;}i:82;a:26:{s:2:\"id\";i:82;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:10:\"Moderation\";s:8:\"released\";i:1245375780;s:7:\"updated\";i:1530078206;s:9:\"downloads\";s:5:\"25018\";s:10:\"popularity\";s:3:\"568\";s:17:\"short_description\";s:70:\"Moderate posts, comments and blogs across an entire Multisite network.\";s:8:\"features\";a:0:{}s:7:\"version\";s:5:\"1.0.9\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:13:\"Multisite 5.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:47:\"https://premium.wpmudev.org/project/moderation/\";s:9:\"thumbnail\";s:78:\"https://premium.wpmudev.org/wp-content/uploads/2009/06/Moderation1-280x158.png\";s:16:\"thumbnail_square\";s:76:\"https://premium.wpmudev.org/wp-content/uploads/2009/06/Moderation1-90x90.png\";s:15:\"thumbnail_large\";s:70:\"https://premium.wpmudev.org/wp-content/uploads/2009/06/Moderation1.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/bdqu4svchg\";s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:12:\"settings.php\";s:7:\"package\";i:0;s:11:\"screenshots\";a:3:{i:0;a:2:{s:3:\"url\";s:98:\"https://premium.wpmudev.org/wp-content/projects/82/screenshots/308875864_network-settings-menu.png\";s:4:\"desc\";s:53:\"Set up permissions in the Network Admin>Settings Menu\";}i:1;a:2:{s:3:\"url\";s:87:\"https://premium.wpmudev.org/wp-content/projects/82/screenshots/674931266_reportpost.png\";s:4:\"desc\";s:105:\"Easy to use links take users straight to report popup to select reasons for reporting and to add comments\";}i:2;a:2:{s:3:\"url\";s:91:\"https://premium.wpmudev.org/wp-content/projects/82/screenshots/1488837867_backendmanage.png\";s:4:\"desc\";s:29:\"Someone reported a Blog Post.\";}}s:6:\"_order\";i:72;}i:75;a:25:{s:2:\"id\";i:75;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:19:\"Recent Global Posts\";s:8:\"released\";i:1244149007;s:7:\"updated\";i:1530078130;s:9:\"downloads\";s:5:\"21585\";s:10:\"popularity\";s:3:\"787\";s:17:\"short_description\";s:92:\"Display a customizable list of recent posts from across your Multisite network on your site.\";s:8:\"features\";a:5:{i:0;s:29:\"Choose how many posts display\";i:1;s:30:\"Add links to the post\'s titles\";i:2;s:15:\"Display avatars\";i:3;s:18:\"Choose avatar size\";i:4;s:58:\"Select the number of characters to display for post titles\";}s:7:\"version\";s:1:\"3\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:31:\"Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:49:\"https://premium.wpmudev.org/project/recent-posts/\";s:9:\"thumbnail\";s:78:\"https://premium.wpmudev.org/wp-content/uploads/2009/06/recent-post-280x158.png\";s:16:\"thumbnail_square\";s:76:\"https://premium.wpmudev.org/wp-content/uploads/2009/06/recent-post-90x90.png\";s:15:\"thumbnail_large\";s:70:\"https://premium.wpmudev.org/wp-content/uploads/2009/06/recent-post.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:6:\"_order\";i:73;}i:77;a:26:{s:2:\"id\";i:77;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:15:\"Update Services\";s:8:\"released\";i:1244427158;s:7:\"updated\";i:1530078070;s:9:\"downloads\";s:5:\"17954\";s:10:\"popularity\";s:3:\"525\";s:17:\"short_description\";s:116:\"Add the ‘Update Services’ box to Multisite and let admins configure what services update when a site is changed.\";s:8:\"features\";a:6:{i:0;s:59:\"Configure default updates services across an entire network\";i:1;s:60:\"Update sub-sites on your network when you publish a new post\";i:2;s:38:\"Greater functionality for super admins\";i:3;s:41:\"Greater control over your user experience\";i:4;s:36:\"Simple configuration and easy to use\";i:5;s:34:\"Easy install and simple management\";}s:7:\"version\";s:7:\"1.0.2.1\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:31:\"Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:52:\"https://premium.wpmudev.org/project/update-services/\";s:9:\"thumbnail\";s:82:\"https://premium.wpmudev.org/wp-content/uploads/2009/06/Update-Services-280x158.png\";s:16:\"thumbnail_square\";s:80:\"https://premium.wpmudev.org/wp-content/uploads/2009/06/Update-Services-90x90.png\";s:15:\"thumbnail_large\";s:74:\"https://premium.wpmudev.org/wp-content/uploads/2009/06/Update-Services.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:12:\"settings.php\";s:7:\"package\";i:0;s:11:\"screenshots\";a:2:{i:0;a:2:{s:3:\"url\";s:90:\"https://premium.wpmudev.org/wp-content/projects/77/screenshots/767776191_site-settings.png\";s:4:\"desc\";s:102:\"http://premium.wpmudev.org/wp-content/projects/77/screenshots/656491207_site%20settings%20dropdown.png\";}i:1;a:2:{s:3:\"url\";s:102:\"https://premium.wpmudev.org/wp-content/projects/77/screenshots/545869531_network settings dropdown.png\";s:4:\"desc\";s:41:\"You can find a menu in the Network Admin!\";}}s:6:\"_order\";i:74;}i:76;a:26:{s:2:\"id\";i:76;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:14:\"Footer Content\";s:8:\"released\";i:1244427134;s:7:\"updated\";i:1530077962;s:9:\"downloads\";s:5:\"28905\";s:10:\"popularity\";s:4:\"1413\";s:17:\"short_description\";s:88:\"Allow administrators to add their own content to the footer of every page on their site.\";s:8:\"features\";a:8:{i:0;s:55:\"Gives sub-site admins the power to update their footers\";i:1;s:35:\"Add any content to sub-site footers\";i:2;s:29:\"Built for WordPress Multisite\";i:3;s:33:\"Integrates with Ultimate Branding\";i:4;s:33:\"Integrates with Google Analytics+\";i:5;s:41:\"Greater control over your user experience\";i:6;s:36:\"Simple configuration and easy to use\";i:7;s:34:\"Easy install and simple management\";}s:7:\"version\";s:7:\"1.0.2.5\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:51:\"https://premium.wpmudev.org/project/footer-content/\";s:9:\"thumbnail\";s:73:\"https://premium.wpmudev.org/wp-content/uploads/2009/06/footer-content.png\";s:16:\"thumbnail_square\";s:81:\"https://premium.wpmudev.org/wp-content/uploads/2009/06/footer-content-150x150.png\";s:15:\"thumbnail_large\";s:73:\"https://premium.wpmudev.org/wp-content/uploads/2009/06/footer-content.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:30:\"themes.php?page=footer-content\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:3:{i:0;a:2:{s:3:\"url\";s:88:\"https://premium.wpmudev.org/wp-content/projects/76/screenshots/491384647_join-footer.jpg\";s:4:\"desc\";s:43:\"Voila! Footer Content for the world to see!\";}i:1;a:2:{s:3:\"url\";s:91:\"https://premium.wpmudev.org/wp-content/projects/76/screenshots/876082709_embed-settings.jpg\";s:4:\"desc\";s:36:\"Only one box to worry about on setup\";}i:2;a:2:{s:3:\"url\";s:91:\"https://premium.wpmudev.org/wp-content/projects/76/screenshots/419487370_footer-content.jpg\";s:4:\"desc\";s:59:\"Footer Content item will show up under your Appearance Menu\";}}s:6:\"_order\";i:75;}i:70;a:26:{s:2:\"id\";i:70;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:24:\"Recent Global Posts Feed\";s:8:\"released\";i:1239666805;s:7:\"updated\";i:1530077825;s:9:\"downloads\";s:5:\"21086\";s:10:\"popularity\";s:3:\"551\";s:17:\"short_description\";s:86:\"Display a global feed of the latest posts from all the sites across an entire network.\";s:8:\"features\";a:8:{i:0;s:81:\"Display global feed of latest posts from across a Multisite or BuddyPress network\";i:1;s:47:\"Creates a Post feed URL for your entire network\";i:2;s:41:\"Provides a simple Global Post Feed widget\";i:3;s:38:\"Built for Multisite from the ground up\";i:4;s:41:\"Greater control over your user experience\";i:5;s:36:\"Simple configuration and easy to use\";i:6;s:34:\"Easy install and simple management\";i:7;s:21:\"Style-match any theme\";}s:7:\"version\";s:5:\"3.1.1\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:31:\"Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:61:\"https://premium.wpmudev.org/project/recent-global-posts-feed/\";s:9:\"thumbnail\";s:83:\"https://premium.wpmudev.org/wp-content/uploads/2009/04/recent-global-posts-feed.jpg\";s:16:\"thumbnail_square\";s:91:\"https://premium.wpmudev.org/wp-content/uploads/2009/04/recent-global-posts-feed-150x150.jpg\";s:15:\"thumbnail_large\";s:83:\"https://premium.wpmudev.org/wp-content/uploads/2009/04/recent-global-posts-feed.jpg\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:11:\"widgets.php\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:2:{i:0;a:2:{s:3:\"url\";s:87:\"https://premium.wpmudev.org/wp-content/projects/70/screenshots/247087876_postfeed81.jpg\";s:4:\"desc\";s:53:\"Recent Global Posts Feed widget configuration options\";}i:1;a:2:{s:3:\"url\";s:88:\"https://premium.wpmudev.org/wp-content/projects/70/screenshots/1102615523_postfeed82.jpg\";s:4:\"desc\";s:56:\"Recent Global Posts Feed widget in the sidebar of a site\";}}s:6:\"_order\";i:76;}i:74;a:26:{s:2:\"id\";i:74;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:25:\"Remove Email Verification\";s:8:\"released\";i:1241641188;s:7:\"updated\";i:1530077761;s:9:\"downloads\";s:5:\"24251\";s:10:\"popularity\";s:4:\"1056\";s:17:\"short_description\";s:84:\"Get users started immediately by removing the need for email verification at signup.\";s:8:\"features\";a:8:{i:0;s:64:\"Removes need for new Multisite accounts to be activated by email\";i:1;s:38:\"Built from the ground up for Multisite\";i:2;s:75:\"Eliminate problems associated with email systems blocking activation emails\";i:3;s:26:\"Eliminate user frustration\";i:4;s:38:\"Streamline Multisite user registration\";i:5;s:26:\"Integrates with Anti-Splog\";i:6;s:45:\"Give users immediate access to their accounts\";i:7;s:0:\"\";}s:7:\"version\";s:5:\"2.4.1\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:13:\"Multisite 5.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:74:\"https://premium.wpmudev.org/project/remove-email-verification-from-signup/\";s:9:\"thumbnail\";s:84:\"https://premium.wpmudev.org/wp-content/uploads/2009/05/remove-email-verification.png\";s:16:\"thumbnail_square\";s:92:\"https://premium.wpmudev.org/wp-content/uploads/2009/05/remove-email-verification-150x150.png\";s:15:\"thumbnail_large\";s:84:\"https://premium.wpmudev.org/wp-content/uploads/2009/05/remove-email-verification.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:3:{i:0;a:2:{s:3:\"url\";s:84:\"https://premium.wpmudev.org/wp-content/projects/74/screenshots/959591636_email83.jpg\";s:4:\"desc\";s:64:\"Example of email verification required to activate a new account\";}i:1;a:2:{s:3:\"url\";s:85:\"https://premium.wpmudev.org/wp-content/projects/74/screenshots/1564974895_email81.jpg\";s:4:\"desc\";s:56:\"Email verificaion removed by the No emal required plugin\";}i:2;a:2:{s:3:\"url\";s:85:\"https://premium.wpmudev.org/wp-content/projects/74/screenshots/1674478043_email82.jpg\";s:4:\"desc\";s:49:\"No emal required plugin in action on Edublogs.org\";}}s:6:\"_order\";i:77;}i:71;a:26:{s:2:\"id\";i:71;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:22:\"Recent Global Comments\";s:8:\"released\";i:1239666809;s:7:\"updated\";i:1530077672;s:9:\"downloads\";s:5:\"18286\";s:10:\"popularity\";s:3:\"463\";s:17:\"short_description\";s:83:\"A global feed of the latest comments from all the sites across your entire network.\";s:8:\"features\";a:7:{i:0;s:62:\"Provides an RSS feed of all comments on your Multisite network\";i:1;s:67:\"Bundled with  simple widget to display your global comment feed URL\";i:2;s:38:\"Built from the ground up for Multisite\";i:3;s:41:\"Greater control over your user experience\";i:4;s:36:\"Simple configuration and easy to use\";i:5;s:34:\"Easy install and simple management\";i:6;s:21:\"Style-match any theme\";}s:7:\"version\";s:7:\"1.0.6.2\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:31:\"Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:64:\"https://premium.wpmudev.org/project/recent-global-comments-feed/\";s:9:\"thumbnail\";s:82:\"https://premium.wpmudev.org/wp-content/uploads/2009/04/Global_comments-280x158.png\";s:16:\"thumbnail_square\";s:80:\"https://premium.wpmudev.org/wp-content/uploads/2009/04/Global_comments-90x90.png\";s:15:\"thumbnail_large\";s:74:\"https://premium.wpmudev.org/wp-content/uploads/2009/04/Global_comments.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:11:\"widgets.php\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:1:{i:0;a:2:{s:3:\"url\";s:109:\"https://premium.wpmudev.org/wp-content/projects/71/screenshots/1251662676_recent global comments dropdown.png\";s:4:\"desc\";s:35:\"Check it out, here it is in action!\";}}s:6:\"_order\";i:78;}i:66;a:26:{s:2:\"id\";i:66;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:26:\"Recent Global Posts Widget\";s:8:\"released\";i:1238113809;s:7:\"updated\";i:1530077605;s:9:\"downloads\";s:5:\"24968\";s:10:\"popularity\";s:4:\"1026\";s:17:\"short_description\";s:106:\"Show recent posts from all the sites across an entire network – hugely powerful, massively configurable.\";s:8:\"features\";a:9:{i:0;s:58:\"Display latest posts from across your network on main site\";i:1;s:50:\"Bundled with simple widget to display latest posts\";i:2;s:66:\"Choice of displaying title and content, title only or content only\";i:3;s:46:\"Option to change the number of posts displayed\";i:4;s:50:\"Set number of title and content characters allowed\";i:5;s:48:\"Option to display avatars and preset avatar size\";i:6;s:25:\"Display custom post types\";i:7;s:41:\"Greater control over your user experience\";i:8;s:36:\"Simple configuration and easy to use\";}s:7:\"version\";s:5:\"3.0.6\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:31:\"Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:63:\"https://premium.wpmudev.org/project/recent-global-posts-widget/\";s:9:\"thumbnail\";s:78:\"https://premium.wpmudev.org/wp-content/uploads/2009/03/recent-posts-widget.png\";s:16:\"thumbnail_square\";s:86:\"https://premium.wpmudev.org/wp-content/uploads/2009/03/recent-posts-widget-150x150.png\";s:15:\"thumbnail_large\";s:78:\"https://premium.wpmudev.org/wp-content/uploads/2009/03/recent-posts-widget.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:11:\"widgets.php\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:2:{i:0;a:2:{s:3:\"url\";s:115:\"https://premium.wpmudev.org/wp-content/projects/66/screenshots/1496126276_recent-global-posts-widget-3050-front.png\";s:4:\"desc\";s:37:\"Recent Global Posts Widget in Sidebar\";}i:1;a:2:{s:3:\"url\";s:124:\"https://premium.wpmudev.org/wp-content/projects/66/screenshots/473606421_recent-global-posts-widget-3050-widget-settings.png\";s:4:\"desc\";s:35:\"Recent Global Posts Widget Settings\";}}s:6:\"_order\";i:79;}i:68;a:26:{s:2:\"id\";i:68;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:9:\"Messaging\";s:8:\"released\";i:1238113861;s:7:\"updated\";i:1530077291;s:9:\"downloads\";s:5:\"29999\";s:10:\"popularity\";s:3:\"918\";s:17:\"short_description\";s:107:\"An internal email, messaging and inbox solution for WordPress with integrated external email notifications.\";s:8:\"features\";a:10:{i:0;s:39:\"Social messaging features for Multisite\";i:1;s:41:\"Send messages to any user on your network\";i:2;s:49:\"Easy to use dashboard inbox for managing messages\";i:3;s:41:\"Sent message box for viewing mail history\";i:4;s:44:\"Turn on email notifications for new messages\";i:5;s:37:\"Ability to disable email notification\";i:6;s:40:\"Customize the message notification email\";i:7;s:41:\"Greater control over your user experience\";i:8;s:36:\"Simple configuration and easy to use\";i:9;s:34:\"Easy install and simple management\";}s:7:\"version\";s:7:\"1.1.6.7\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:28:\"WordPress 5.0, Multisite 5.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:46:\"https://premium.wpmudev.org/project/messaging/\";s:9:\"thumbnail\";s:68:\"https://premium.wpmudev.org/wp-content/uploads/2009/03/messaging.jpg\";s:16:\"thumbnail_square\";s:76:\"https://premium.wpmudev.org/wp-content/uploads/2009/03/messaging-150x150.jpg\";s:15:\"thumbnail_large\";s:68:\"https://premium.wpmudev.org/wp-content/uploads/2009/03/messaging.jpg\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:33:\"admin.php?page=messaging_settings\";s:13:\"ms_config_url\";s:36:\"settings.php?page=messaging_settings\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:84:\"https://premium.wpmudev.org/wp-content/projects/68/screenshots/1484371789_1-menu.jpg\";s:4:\"desc\";s:4:\"Menu\";}i:1;a:2:{s:3:\"url\";s:91:\"https://premium.wpmudev.org/wp-content/projects/68/screenshots/1547777809_2-new-message.jpg\";s:4:\"desc\";s:11:\"New message\";}i:2;a:2:{s:3:\"url\";s:85:\"https://premium.wpmudev.org/wp-content/projects/68/screenshots/1700613015_3-inbox.jpg\";s:4:\"desc\";s:16:\"Message received\";}i:3;a:2:{s:3:\"url\";s:85:\"https://premium.wpmudev.org/wp-content/projects/68/screenshots/1727887901_4-reply.jpg\";s:4:\"desc\";s:5:\"Reply\";}}s:6:\"_order\";i:80;}i:63;a:26:{s:2:\"id\";i:63;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:12:\"Users Widget\";s:8:\"released\";i:1238113688;s:7:\"updated\";i:1530077188;s:9:\"downloads\";s:5:\"19200\";s:10:\"popularity\";s:3:\"404\";s:17:\"short_description\";s:90:\"Display a list of random users and their avatars, from across an entire Multisite network.\";s:8:\"features\";a:0:{}s:7:\"version\";s:7:\"1.0.1.3\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:13:\"Multisite 5.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:49:\"https://premium.wpmudev.org/project/users-widget/\";s:9:\"thumbnail\";s:78:\"https://premium.wpmudev.org/wp-content/uploads/2009/03/User-Widget-280x158.png\";s:16:\"thumbnail_square\";s:76:\"https://premium.wpmudev.org/wp-content/uploads/2009/03/User-Widget-90x90.png\";s:15:\"thumbnail_large\";s:70:\"https://premium.wpmudev.org/wp-content/uploads/2009/03/User-Widget.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:11:\"widgets.php\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:2:{i:0;a:2:{s:3:\"url\";s:86:\"https://premium.wpmudev.org/wp-content/projects/63/screenshots/2051761029_settings.jpg\";s:4:\"desc\";s:42:\"Use a custom configuration in each sidebar\";}i:1;a:2:{s:3:\"url\";s:82:\"https://premium.wpmudev.org/wp-content/projects/63/screenshots/790211576_users.gif\";s:4:\"desc\";s:23:\"Drag\'n\'drop widget area\";}}s:6:\"_order\";i:81;}i:62;a:26:{s:2:\"id\";i:62;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:7:\"Friends\";s:8:\"released\";i:1238113661;s:7:\"updated\";i:1530077043;s:9:\"downloads\";s:5:\"27681\";s:10:\"popularity\";s:3:\"784\";s:17:\"short_description\";s:88:\"Let users friend each other and generally get all social without the bulk of BuddyPress.\";s:8:\"features\";a:6:{i:0;s:31:\"Make WordPress a social network\";i:1;s:34:\"Allow users to \'friend\' each other\";i:2;s:41:\"Add a social network element to Multisite\";i:3;s:33:\"Simple approve and reject friends\";i:4;s:49:\"Integrates with Messaging, Avatars, and Community\";i:5;s:52:\"Display an avatar mosaic of friends on network sites\";}s:7:\"version\";s:5:\"1.3.2\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:28:\"WordPress 5.0, Multisite 5.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:44:\"https://premium.wpmudev.org/project/friends/\";s:9:\"thumbnail\";s:74:\"https://premium.wpmudev.org/wp-content/uploads/2009/03/Friends-280x158.png\";s:16:\"thumbnail_square\";s:72:\"https://premium.wpmudev.org/wp-content/uploads/2009/03/Friends-90x90.png\";s:15:\"thumbnail_large\";s:66:\"https://premium.wpmudev.org/wp-content/uploads/2009/03/Friends.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:30:\"admin.php?page=friend-settings\";s:13:\"ms_config_url\";s:30:\"admin.php?page=friend-settings\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:106:\"https://premium.wpmudev.org/wp-content/projects/62/screenshots/1335412405_friends ‹ cowpat.net —-2.jpg\";s:4:\"desc\";s:17:\"Your Friends List\";}i:1;a:2:{s:3:\"url\";s:105:\"https://premium.wpmudev.org/wp-content/projects/62/screenshots/175249668_friends ‹ cowpat.net —-1.jpg\";s:4:\"desc\";s:33:\"Approve Or Reject Friend Requests\";}i:2;a:2:{s:3:\"url\";s:103:\"https://premium.wpmudev.org/wp-content/projects/62/screenshots/933656206_friends ‹ cowpat.net —.jpg\";s:4:\"desc\";s:12:\"Find Friends\";}i:3;a:2:{s:3:\"url\";s:92:\"https://premium.wpmudev.org/wp-content/projects/62/screenshots/244558160_friends setting.jpg\";s:4:\"desc\";s:16:\"Friends Settings\";}}s:6:\"_order\";i:82;}i:61;a:26:{s:2:\"id\";i:61;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:16:\"Admin Panel Tips\";s:8:\"released\";i:1238113627;s:7:\"updated\";i:1530076965;s:9:\"downloads\";s:5:\"27536\";s:10:\"popularity\";s:4:\"1244\";s:17:\"short_description\";s:84:\"Randomly display helpful tips, promotions or news in the dashboard across a network.\";s:8:\"features\";a:8:{i:0;s:19:\"Display random tips\";i:1;s:46:\"In dashboard of every site across your network\";i:2;s:27:\"Create new admin panel tips\";i:3;s:22:\"Unlimited tip creation\";i:4;s:18:\"Supports HTML code\";i:5;s:36:\"Save and re-use tips with draft mode\";i:6;s:20:\"Multisite compatible\";i:7;s:21:\"BuddyPress compatible\";}s:7:\"version\";s:7:\"1.0.7.7\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:53:\"https://premium.wpmudev.org/project/admin-panel-tips/\";s:9:\"thumbnail\";s:83:\"https://premium.wpmudev.org/wp-content/uploads/2009/03/Admin-Panel-Tips-280x158.png\";s:16:\"thumbnail_square\";s:81:\"https://premium.wpmudev.org/wp-content/uploads/2009/03/Admin-Panel-Tips-90x90.png\";s:15:\"thumbnail_large\";s:75:\"https://premium.wpmudev.org/wp-content/uploads/2009/03/Admin-Panel-Tips.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/lu655zymns\";s:13:\"wp_config_url\";s:36:\"options-general.php?page=manage-tips\";s:13:\"ms_config_url\";s:29:\"settings.php?page=manage-tips\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:84:\"https://premium.wpmudev.org/wp-content/projects/61/screenshots/1787091783_tips81.jpg\";s:4:\"desc\";s:26:\"Editing an admin panel tip\";}i:1;a:2:{s:3:\"url\";s:92:\"https://premium.wpmudev.org/wp-content/projects/61/screenshots/1824893615_adminmessage82.jpg\";s:4:\"desc\";s:50:\"Example of an admin panel tip and an admin message\";}i:2;a:2:{s:3:\"url\";s:84:\"https://premium.wpmudev.org/wp-content/projects/61/screenshots/1143195805_tips83.jpg\";s:4:\"desc\";s:52:\"Admin panel tips list in the network admin dashboard\";}i:3;a:2:{s:3:\"url\";s:84:\"https://premium.wpmudev.org/wp-content/projects/61/screenshots/1202598395_tips85.jpg\";s:4:\"desc\";s:52:\"Users can also choose to hide their admin panel tips\";}}s:6:\"_order\";i:83;}i:60;a:26:{s:2:\"id\";i:60;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:25:\"Select Language at Signup\";s:8:\"released\";i:1238113592;s:7:\"updated\";i:1530076861;s:9:\"downloads\";s:5:\"23334\";s:10:\"popularity\";s:3:\"528\";s:17:\"short_description\";s:69:\"Give new users the ability to select which language to use at signup.\";s:8:\"features\";a:11:{i:0;s:22:\"Adds Language Selector\";i:1;s:20:\"Works out-of-the-box\";i:2;s:35:\"Integrates with WordPress languages\";i:3;s:42:\"Instantly access 50+ built-in translations\";i:4;s:19:\"Built for Multisite\";i:5;s:20:\"Works with any theme\";i:6;s:37:\"Instantly create multilingual network\";i:7;s:31:\"Simple drop-down menu interface\";i:8;s:21:\"Front end integration\";i:9;s:16:\"No settings page\";i:10;s:18:\"Guaranteed updates\";}s:7:\"version\";s:7:\"1.0.5.1\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:13:\"Multisite 5.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:62:\"https://premium.wpmudev.org/project/select-language-at-signup/\";s:9:\"thumbnail\";s:93:\"https://premium.wpmudev.org/wp-content/uploads/2009/03/Select-Language-at-Signup1-280x158.png\";s:16:\"thumbnail_square\";s:91:\"https://premium.wpmudev.org/wp-content/uploads/2009/03/Select-Language-at-Signup1-90x90.png\";s:15:\"thumbnail_large\";s:85:\"https://premium.wpmudev.org/wp-content/uploads/2009/03/Select-Language-at-Signup1.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:12:\"settings.php\";s:7:\"package\";i:0;s:11:\"screenshots\";a:2:{i:0;a:2:{s:3:\"url\";s:92:\"https://premium.wpmudev.org/wp-content/projects/60/screenshots/130162047_slector-735x470.jpg\";s:4:\"desc\";s:13:\"Dropdown menu\";}i:1;a:2:{s:3:\"url\";s:94:\"https://premium.wpmudev.org/wp-content/projects/60/screenshots/1599596328_language-735x470.jpg\";s:4:\"desc\";s:17:\"Activate language\";}}s:6:\"_order\";i:84;}i:106;a:26:{s:2:\"id\";i:106;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:10:\"Affiliates\";s:8:\"released\";i:1253814491;s:7:\"updated\";i:1530076819;s:9:\"downloads\";s:5:\"58550\";s:10:\"popularity\";s:4:\"2014\";s:17:\"short_description\";s:86:\"Let your users become your sales team by receiving payment for referrals that convert.\";s:8:\"features\";a:19:{i:0;s:31:\"Provide users an Affiliate Link\";i:1;s:31:\"Pay users for referring friends\";i:2;s:24:\"Automated payment system\";i:3;s:20:\"Pay only on approval\";i:4;s:19:\"Set payout currency\";i:5;s:17:\"Affiliate banners\";i:6;s:23:\"Classifieds integration\";i:7;s:28:\"Directory plugin integration\";i:8;s:36:\"MarketPress track referral purchases\";i:9;s:33:\"ProSites paid upgrade integration\";i:10;s:29:\"Membership plugin integration\";i:11;s:16:\"Referral manager\";i:12;s:17:\"See unique clicks\";i:13;s:25:\"Manage credits and debits\";i:14;s:30:\"See approved referral payments\";i:15;s:16:\"Manage Referrers\";i:16;s:25:\"Dashboard overview widget\";i:17;s:29:\"Built-in Referral Report page\";i:18;s:24:\"Easy to read stats graph\";}s:7:\"version\";s:7:\"3.1.6.8\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:59:\"https://premium.wpmudev.org/project/wordpress-mu-affiliate/\";s:9:\"thumbnail\";s:77:\"https://premium.wpmudev.org/wp-content/uploads/2009/09/Affiliates-280x158.png\";s:16:\"thumbnail_square\";s:75:\"https://premium.wpmudev.org/wp-content/uploads/2009/09/Affiliates-90x90.png\";s:15:\"thumbnail_large\";s:69:\"https://premium.wpmudev.org/wp-content/uploads/2009/09/Affiliates.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/bc75gn7y8j\";s:13:\"wp_config_url\";s:38:\"admin.php?page=affiliatesadminsettings\";s:13:\"ms_config_url\";s:38:\"admin.php?page=affiliatesadminsettings\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:104:\"https://premium.wpmudev.org/wp-content/projects/106/screenshots/1720849599_affiliate-referal-735x470.jpg\";s:4:\"desc\";s:21:\"More affiliates stats\";}i:1;a:2:{s:3:\"url\";s:103:\"https://premium.wpmudev.org/wp-content/projects/106/screenshots/151211441_affiliate-banners-735x470.jpg\";s:4:\"desc\";s:13:\"Share banners\";}i:2;a:2:{s:3:\"url\";s:107:\"https://premium.wpmudev.org/wp-content/projects/106/screenshots/142965111_affiliates-paypal-link735x470.jpg\";s:4:\"desc\";s:10:\"Add paypal\";}i:3;a:2:{s:3:\"url\";s:103:\"https://premium.wpmudev.org/wp-content/projects/106/screenshots/235701045_affiliate-referal-735x470.jpg\";s:4:\"desc\";s:16:\"Affiliates stats\";}}s:6:\"_order\";i:85;}i:52;a:26:{s:2:\"id\";i:52;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:17:\"Multisite Privacy\";s:8:\"released\";i:1235348137;s:7:\"updated\";i:1530076752;s:9:\"downloads\";s:5:\"42475\";s:10:\"popularity\";s:4:\"1781\";s:17:\"short_description\";s:123:\"Add four more levels of privacy that you control across every sites on an entire network - or allow users to override them.\";s:8:\"features\";a:0:{}s:7:\"version\";s:5:\"1.1.9\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:31:\"Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:78:\"https://premium.wpmudev.org/project/sitewide-privacy-options-for-wordpress-mu/\";s:9:\"thumbnail\";s:76:\"https://premium.wpmudev.org/wp-content/uploads/2009/02/multisite-privacy.jpg\";s:16:\"thumbnail_square\";s:84:\"https://premium.wpmudev.org/wp-content/uploads/2009/02/multisite-privacy-150x150.jpg\";s:15:\"thumbnail_large\";s:76:\"https://premium.wpmudev.org/wp-content/uploads/2009/02/multisite-privacy.jpg\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/p76hy67d7k\";s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:12:\"settings.php\";s:7:\"package\";i:0;s:11:\"screenshots\";a:2:{i:0;a:2:{s:3:\"url\";s:85:\"https://premium.wpmudev.org/wp-content/projects/52/screenshots/465683367_privacy2.png\";s:4:\"desc\";s:94:\"Network wide privacy options available to super admins via Network Admin > Settings > Settings\";}i:1;a:2:{s:3:\"url\";s:85:\"https://premium.wpmudev.org/wp-content/projects/52/screenshots/502317547_privacy3.png\";s:4:\"desc\";s:35:\"Privacy options on individual blogs\";}}s:6:\"_order\";i:86;}i:215;a:26:{s:2:\"id\";i:215;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:25:\"Schedule Selected Content\";s:8:\"released\";i:1300999909;s:7:\"updated\";i:1530076690;s:9:\"downloads\";s:5:\"30642\";s:10:\"popularity\";s:4:\"1332\";s:17:\"short_description\";s:85:\"Make any content available only at scheduled periods using an awesome WYSIWYG button.\";s:8:\"features\";a:0:{}s:7:\"version\";s:5:\"1.2.2\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:54:\"https://premium.wpmudev.org/project/scheduled-content/\";s:9:\"thumbnail\";s:84:\"https://premium.wpmudev.org/wp-content/uploads/2011/03/schedule-selected-content.png\";s:16:\"thumbnail_square\";s:92:\"https://premium.wpmudev.org/wp-content/uploads/2011/03/schedule-selected-content-150x150.png\";s:15:\"thumbnail_large\";s:84:\"https://premium.wpmudev.org/wp-content/uploads/2011/03/schedule-selected-content.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:88:\"https://premium.wpmudev.org/wp-content/projects/215/screenshots/956540033_schedule84.jpg\";s:4:\"desc\";s:86:\"Monthly schedule release of content options using the Schedule Selected Content Plugin\";}i:1;a:2:{s:3:\"url\";s:89:\"https://premium.wpmudev.org/wp-content/projects/215/screenshots/1970053043_schedule83.jpg\";s:4:\"desc\";s:85:\"Weekly schedule release of content options using the Schedule Selected Content Plugin\";}i:2;a:2:{s:3:\"url\";s:88:\"https://premium.wpmudev.org/wp-content/projects/215/screenshots/311748495_schedule82.jpg\";s:4:\"desc\";s:83:\"Example of the shortcuts inserted when you use the Schedule Selected Content Plugin\";}i:3;a:2:{s:3:\"url\";s:89:\"https://premium.wpmudev.org/wp-content/projects/215/screenshots/1542725802_schedule81.jpg\";s:4:\"desc\";s:77:\"How to schedule release of content using the Schedule Selected Content plugin\";}}s:6:\"_order\";i:87;}i:174;a:26:{s:2:\"id\";i:174;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:17:\"A/B Theme Testing\";s:8:\"released\";i:1297121123;s:7:\"updated\";i:1530076614;s:9:\"downloads\";s:5:\"22772\";s:10:\"popularity\";s:3:\"743\";s:17:\"short_description\";s:70:\"Compare two or more themes and with easy Google Analytics A/B testing.\";s:8:\"features\";a:0:{}s:7:\"version\";s:5:\"1.3.2\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:31:\"WordPress 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:53:\"https://premium.wpmudev.org/project/ab-theme-testing/\";s:9:\"thumbnail\";s:79:\"https://premium.wpmudev.org/wp-content/uploads/2011/02/AB_testing_2-280x158.png\";s:16:\"thumbnail_square\";s:77:\"https://premium.wpmudev.org/wp-content/uploads/2011/02/AB_testing_2-90x90.png\";s:15:\"thumbnail_large\";s:71:\"https://premium.wpmudev.org/wp-content/uploads/2011/02/AB_testing_2.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:32:\"themes.php?page=ab_theme_testing\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:3:{i:0;a:2:{s:3:\"url\";s:92:\"https://premium.wpmudev.org/wp-content/projects/174/screenshots/249055291_abthemetesting.png\";s:4:\"desc\";s:53:\"Configuring the AB theme testing plugin is super easy\";}i:1;a:2:{s:3:\"url\";s:86:\"https://premium.wpmudev.org/wp-content/projects/174/screenshots/340935226_goalset2.jpg\";s:4:\"desc\";s:29:\"Our initial analytics results\";}i:2;a:2:{s:3:\"url\";s:96:\"https://premium.wpmudev.org/wp-content/projects/174/screenshots/1561528401_analyticsrestults.png\";s:4:\"desc\";s:21:\"Our analytics results\";}}s:6:\"_order\";i:88;}i:47;a:26:{s:2:\"id\";i:47;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:7:\"Reports\";s:8:\"released\";i:1227206080;s:7:\"updated\";i:1530076550;s:9:\"downloads\";s:5:\"32594\";s:10:\"popularity\";s:4:\"1433\";s:17:\"short_description\";s:74:\"Create and display post and comment activity reports – per site or user.\";s:8:\"features\";a:10:{i:0;s:29:\"View specific user\'s activity\";i:1;s:27:\"Pull site-specific activity\";i:2;s:23:\"Beautiful graph display\";i:3;s:22:\"Track comment activity\";i:4;s:13:\"See hot posts\";i:5;s:31:\"Track activity across a network\";i:6;s:16:\"Simple interface\";i:7;s:33:\"15 day, 30 day and 45 day reports\";i:8;s:31:\"WordPress Dashboard integration\";i:9;s:19:\"Built for Multisite\";}s:7:\"version\";s:5:\"1.0.8\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:44:\"https://premium.wpmudev.org/project/reports/\";s:9:\"thumbnail\";s:74:\"https://premium.wpmudev.org/wp-content/uploads/2008/11/Reports-280x158.png\";s:16:\"thumbnail_square\";s:72:\"https://premium.wpmudev.org/wp-content/uploads/2008/11/Reports-90x90.png\";s:15:\"thumbnail_large\";s:66:\"https://premium.wpmudev.org/wp-content/uploads/2008/11/Reports.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/foxvai5pqs\";s:13:\"wp_config_url\";s:32:\"options-general.php?page=reports\";s:13:\"ms_config_url\";s:25:\"settings.php?page=reports\";s:7:\"package\";i:0;s:11:\"screenshots\";a:3:{i:0;a:2:{s:3:\"url\";s:103:\"https://premium.wpmudev.org/wp-content/projects/47/screenshots/1874553713_report-generation-is-easy.jpg\";s:4:\"desc\";s:25:\"Report generation is easy\";}i:1;a:2:{s:3:\"url\";s:90:\"https://premium.wpmudev.org/wp-content/projects/47/screenshots/2120610696_graph-report.jpg\";s:4:\"desc\";s:20:\"Report in graph form\";}i:2;a:2:{s:3:\"url\";s:100:\"https://premium.wpmudev.org/wp-content/projects/47/screenshots/1786607289_different-report-types.jpg\";s:4:\"desc\";s:22:\"Different report types\";}}s:6:\"_order\";i:89;}i:48;a:26:{s:2:\"id\";i:48;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:13:\"Default Theme\";s:8:\"released\";i:1228240545;s:7:\"updated\";i:1530076513;s:9:\"downloads\";s:5:\"27300\";s:10:\"popularity\";s:4:\"1408\";s:17:\"short_description\";s:62:\"Allows you to easily select a new default theme for new blogs.\";s:8:\"features\";a:0:{}s:7:\"version\";s:5:\"1.0.4\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:13:\"Multisite 5.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:50:\"https://premium.wpmudev.org/project/default-theme/\";s:9:\"thumbnail\";s:80:\"https://premium.wpmudev.org/wp-content/uploads/2008/12/Default-Theme-280x158.png\";s:16:\"thumbnail_square\";s:78:\"https://premium.wpmudev.org/wp-content/uploads/2008/12/Default-Theme-90x90.png\";s:15:\"thumbnail_large\";s:72:\"https://premium.wpmudev.org/wp-content/uploads/2008/12/Default-Theme.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:2:{i:0;a:2:{s:3:\"url\";s:86:\"https://premium.wpmudev.org/wp-content/projects/48/screenshots/605534298_default83.jpg\";s:4:\"desc\";s:82:\"Check out how easy it is to change the default theme with the Default theme plugin\";}i:1;a:2:{s:3:\"url\";s:86:\"https://premium.wpmudev.org/wp-content/projects/48/screenshots/180370360_default82.png\";s:4:\"desc\";s:33:\"Selecting your new default theme \";}}s:6:\"_order\";i:90;}i:40;a:26:{s:2:\"id\";i:40;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:10:\"Ad Sharing\";s:8:\"released\";i:1225762782;s:7:\"updated\";i:1530076451;s:9:\"downloads\";s:5:\"26001\";s:10:\"popularity\";s:3:\"644\";s:17:\"short_description\";s:107:\"Split and share advertising revenue with your Multisite network users using any combination of advertisers.\";s:8:\"features\";a:0:{}s:7:\"version\";s:5:\"1.2.1\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:28:\"WordPress 5.0, Multisite 5.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:47:\"https://premium.wpmudev.org/project/ad-sharing/\";s:9:\"thumbnail\";s:69:\"https://premium.wpmudev.org/wp-content/uploads/2008/11/ad-sharing.png\";s:16:\"thumbnail_square\";s:77:\"https://premium.wpmudev.org/wp-content/uploads/2008/11/ad-sharing-150x150.png\";s:15:\"thumbnail_large\";s:69:\"https://premium.wpmudev.org/wp-content/uploads/2008/11/ad-sharing.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/wh8007chzp\";s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:35:\"settings.php?page=admin-advertising\";s:7:\"package\";i:0;s:11:\"screenshots\";a:2:{i:0;a:2:{s:3:\"url\";s:87:\"https://premium.wpmudev.org/wp-content/projects/40/screenshots/396108779_ad-sharing.png\";s:4:\"desc\";s:40:\"Ad Sharing includes easy to use options.\";}i:1;a:2:{s:3:\"url\";s:96:\"https://premium.wpmudev.org/wp-content/projects/40/screenshots/1830537195_ad-sharing-example.jpg\";s:4:\"desc\";s:53:\"An example of how Ad Sharing could look on your site.\";}}s:6:\"_order\";i:91;}i:43;a:26:{s:2:\"id\";i:43;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:14:\"Login Redirect\";s:8:\"released\";i:1226958216;s:7:\"updated\";i:1530076419;s:9:\"downloads\";s:5:\"40419\";s:10:\"popularity\";s:4:\"2313\";s:17:\"short_description\";s:70:\"Send users to a custom page, post or url after logging into WordPress.\";s:8:\"features\";a:0:{}s:7:\"version\";s:5:\"1.0.9\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:28:\"WordPress 5.0, Multisite 5.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:51:\"https://premium.wpmudev.org/project/login-redirect/\";s:9:\"thumbnail\";s:82:\"https://premium.wpmudev.org/wp-content/uploads/2008/11/Login-Redirect1-280x158.png\";s:16:\"thumbnail_square\";s:80:\"https://premium.wpmudev.org/wp-content/uploads/2008/11/Login-Redirect1-90x90.png\";s:15:\"thumbnail_large\";s:74:\"https://premium.wpmudev.org/wp-content/uploads/2008/11/Login-Redirect1.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:19:\"options-general.php\";s:13:\"ms_config_url\";s:12:\"settings.php\";s:7:\"package\";i:0;s:11:\"screenshots\";a:1:{i:0;a:2:{s:3:\"url\";s:114:\"https://premium.wpmudev.org/wp-content/projects/43/screenshots/667822982_screen shot 2013-09-06 at 10.36.04 am.png\";s:4:\"desc\";s:33:\"General Settings - Login Redirect\";}}s:6:\"_order\";i:92;}i:42;a:26:{s:2:\"id\";i:42;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:15:\"Logout Redirect\";s:8:\"released\";i:1226958212;s:7:\"updated\";i:1530076380;s:9:\"downloads\";s:5:\"34396\";s:10:\"popularity\";s:4:\"1648\";s:17:\"short_description\";s:69:\"Choose which URL users are directed to when logging out of WordPress.\";s:8:\"features\";a:0:{}s:7:\"version\";s:5:\"1.1.4\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:28:\"WordPress 5.0, Multisite 5.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:52:\"https://premium.wpmudev.org/project/logout-redirect/\";s:9:\"thumbnail\";s:83:\"https://premium.wpmudev.org/wp-content/uploads/2008/11/Logout-Redirect1-280x158.png\";s:16:\"thumbnail_square\";s:81:\"https://premium.wpmudev.org/wp-content/uploads/2008/11/Logout-Redirect1-90x90.png\";s:15:\"thumbnail_large\";s:75:\"https://premium.wpmudev.org/wp-content/uploads/2008/11/Logout-Redirect1.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:19:\"options-general.php\";s:13:\"ms_config_url\";s:12:\"settings.php\";s:7:\"package\";i:0;s:11:\"screenshots\";a:3:{i:0;a:2:{s:3:\"url\";s:128:\"https://premium.wpmudev.org/wp-content/projects/42/screenshots/1696630784_network settings ‹ network admin — wordpress-1.jpg\";s:4:\"desc\";s:24:\"Logout Redirect Settings\";}i:1;a:2:{s:3:\"url\";s:85:\"https://premium.wpmudev.org/wp-content/projects/42/screenshots/158141708_logout91.jpg\";s:4:\"desc\";s:43:\"Example of logout redirect plugin in action\";}i:2;a:2:{s:3:\"url\";s:85:\"https://premium.wpmudev.org/wp-content/projects/42/screenshots/937522786_logout92.jpg\";s:4:\"desc\";s:76:\"Adding your logout redirect URL in Settings > General on a WordPress install\";}}s:6:\"_order\";i:93;}i:137;a:26:{s:2:\"id\";i:137;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:12:\"Random Theme\";s:8:\"released\";i:1273530154;s:7:\"updated\";i:1530076320;s:9:\"downloads\";s:5:\"14798\";s:10:\"popularity\";s:3:\"304\";s:17:\"short_description\";s:50:\"Activate a random theme for new Multisite signups.\";s:8:\"features\";a:0:{}s:7:\"version\";s:5:\"1.0.1\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:31:\"Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:59:\"https://premium.wpmudev.org/project/random-theme-on-signup/\";s:9:\"thumbnail\";s:79:\"https://premium.wpmudev.org/wp-content/uploads/2010/05/Random_Theme-280x158.png\";s:16:\"thumbnail_square\";s:77:\"https://premium.wpmudev.org/wp-content/uploads/2010/05/Random_Theme-90x90.png\";s:15:\"thumbnail_large\";s:71:\"https://premium.wpmudev.org/wp-content/uploads/2010/05/Random_Theme.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:3:{i:0;a:2:{s:3:\"url\";s:102:\"https://premium.wpmudev.org/wp-content/projects/137/screenshots/1798096559_network-activate-themes.png\";s:4:\"desc\";s:61:\"The plugin selects randomly from all network activated themes\";}i:1;a:2:{s:3:\"url\";s:94:\"https://premium.wpmudev.org/wp-content/projects/137/screenshots/654986195_multisite-signup.png\";s:4:\"desc\";s:56:\"After signup the user will have a random theme activated\";}i:2;a:2:{s:3:\"url\";s:86:\"https://premium.wpmudev.org/wp-content/projects/137/screenshots/141334239_random81.jpg\";s:4:\"desc\";s:50:\"Example of Random Theme Plugin on signup in action\";}}s:6:\"_order\";i:94;}i:30;a:26:{s:2:\"id\";i:30;s:4:\"paid\";s:4:\"free\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:12:\"Post Indexer\";s:8:\"released\";i:1219175191;s:7:\"updated\";i:1530076206;s:9:\"downloads\";s:5:\"43653\";s:10:\"popularity\";s:4:\"1950\";s:17:\"short_description\";s:66:\"Supercharge how content is shared and managed across your network.\";s:8:\"features\";a:16:{i:0;s:36:\"Make global content sharing possible\";i:1;s:48:\"Compile posts from across a network in one place\";i:2;s:23:\"Index custom post types\";i:3;s:37:\"Choose specific post types to include\";i:4;s:38:\"Post index content from specific sites\";i:5;s:55:\"Remove posts from global index after set amount of time\";i:6;s:38:\"Manually trigger network index rebuild\";i:7;s:25:\"Index sites one-at-a-time\";i:8;s:39:\"Index posts that were already published\";i:9;s:26:\"Built-in statistics viewer\";i:10;s:19:\"Easy-to-read graphs\";i:11;s:13:\"Debug logging\";i:12;s:31:\"\'Most Indexed Sites\' quick view\";i:13;s:35:\"\'Recently Indexed Posts\' quick view\";i:14;s:25:\"Post Indexer summary view\";i:15;s:26:\"Individual site statistics\";}s:7:\"version\";s:7:\"3.0.6.4\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:31:\"Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:49:\"https://premium.wpmudev.org/project/post-indexer/\";s:9:\"thumbnail\";s:79:\"https://premium.wpmudev.org/wp-content/uploads/2008/08/Post-Indexer-280x158.png\";s:16:\"thumbnail_square\";s:77:\"https://premium.wpmudev.org/wp-content/uploads/2008/08/Post-Indexer-90x90.png\";s:15:\"thumbnail_large\";s:71:\"https://premium.wpmudev.org/wp-content/uploads/2008/08/Post-Indexer.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/jmqheicn8o\";s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:29:\"settings.php?page=postindexer\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:109:\"https://premium.wpmudev.org/wp-content/projects/30/screenshots/2073698709_post-indexer-post-types-735x470.jpg\";s:4:\"desc\";s:28:\"Post Indexer global settings\";}i:1;a:2:{s:3:\"url\";s:109:\"https://premium.wpmudev.org/wp-content/projects/30/screenshots/2095679108_post-indexer-processing-735x470.jpg\";s:4:\"desc\";s:35:\"Post Indexer processing information\";}i:2;a:2:{s:3:\"url\";s:95:\"https://premium.wpmudev.org/wp-content/projects/30/screenshots/24151849_build-index-735x470.jpg\";s:4:\"desc\";s:29:\"Post Indexer rebuild per site\";}i:3;a:2:{s:3:\"url\";s:104:\"https://premium.wpmudev.org/wp-content/projects/30/screenshots/1603563002_post-indexer-stats-735x470.jpg\";s:4:\"desc\";s:23:\"Post Indexer statistics\";}}s:6:\"_order\";i:95;}i:28;a:25:{s:2:\"id\";i:28;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:15:\"Recent Comments\";s:8:\"released\";i:1219174915;s:7:\"updated\";i:1530076102;s:9:\"downloads\";s:5:\"16798\";s:10:\"popularity\";s:3:\"284\";s:17:\"short_description\";s:85:\"Display a list of recent comments from across your entire network on your front page.\";s:8:\"features\";a:0:{}s:7:\"version\";s:7:\"1.0.2.1\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:31:\"Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:52:\"https://premium.wpmudev.org/project/recent-comments/\";s:9:\"thumbnail\";s:74:\"https://premium.wpmudev.org/wp-content/uploads/2008/08/recent-comments.png\";s:16:\"thumbnail_square\";s:82:\"https://premium.wpmudev.org/wp-content/uploads/2008/08/recent-comments-150x150.png\";s:15:\"thumbnail_large\";s:74:\"https://premium.wpmudev.org/wp-content/uploads/2008/08/recent-comments.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:6:\"_order\";i:96;}i:35;a:26:{s:2:\"id\";i:35;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:12:\"Set Password\";s:8:\"released\";i:1219361323;s:7:\"updated\";i:1530076017;s:9:\"downloads\";s:5:\"30515\";s:10:\"popularity\";s:3:\"926\";s:17:\"short_description\";s:59:\"Give users the option of choosing their password at signup.\";s:8:\"features\";a:0:{}s:7:\"version\";s:7:\"1.1.2.3\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:13:\"Multisite 5.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:79:\"https://premium.wpmudev.org/project/set-password-on-wordpress-mu-blog-creation/\";s:9:\"thumbnail\";s:79:\"https://premium.wpmudev.org/wp-content/uploads/2008/08/Set-Password-280x158.png\";s:16:\"thumbnail_square\";s:77:\"https://premium.wpmudev.org/wp-content/uploads/2008/08/Set-Password-90x90.png\";s:15:\"thumbnail_large\";s:71:\"https://premium.wpmudev.org/wp-content/uploads/2008/08/Set-Password.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:2:{i:0;a:2:{s:3:\"url\";s:88:\"https://premium.wpmudev.org/wp-content/projects/35/screenshots/1804411960_password81.jpg\";s:4:\"desc\";s:90:\"Using Set Password plugin to provide an option for your users to create their own password\";}i:1;a:2:{s:3:\"url\";s:87:\"https://premium.wpmudev.org/wp-content/projects/35/screenshots/428939833_password82.jpg\";s:4:\"desc\";s:70:\"Example of Set Password plugin being used on Edublogs.org sign up page\";}}s:6:\"_order\";i:97;}i:12;a:26:{s:2:\"id\";i:12;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:15:\"Content Monitor\";s:8:\"released\";i:1218159572;s:7:\"updated\";i:1530075760;s:9:\"downloads\";s:5:\"21851\";s:10:\"popularity\";s:3:\"529\";s:17:\"short_description\";s:93:\"Monitor your entire network for set words you define and get an email whenever they are used.\";s:8:\"features\";a:0:{}s:7:\"version\";s:3:\"1.4\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:31:\"Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:52:\"https://premium.wpmudev.org/project/content-monitor/\";s:9:\"thumbnail\";s:74:\"https://premium.wpmudev.org/wp-content/uploads/2008/08/content-monitor.png\";s:16:\"thumbnail_square\";s:82:\"https://premium.wpmudev.org/wp-content/uploads/2008/08/content-monitor-150x150.png\";s:15:\"thumbnail_large\";s:74:\"https://premium.wpmudev.org/wp-content/uploads/2008/08/content-monitor.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:33:\"settings.php?page=content-monitor\";s:7:\"package\";i:0;s:11:\"screenshots\";a:2:{i:0;a:2:{s:3:\"url\";s:90:\"https://premium.wpmudev.org/wp-content/projects/12/screenshots/209220516_save-settings.jpg\";s:4:\"desc\";s:11:\"Quick setup\";}i:1;a:2:{s:3:\"url\";s:95:\"https://premium.wpmudev.org/wp-content/projects/12/screenshots/404389055_email-notification.jpg\";s:4:\"desc\";s:40:\"Email notification links to page or post\";}}s:6:\"_order\";i:98;}i:109;a:26:{s:2:\"id\";i:109;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:25:\"BuddyPress Group Calendar\";s:8:\"released\";i:1256068286;s:7:\"updated\";i:1530075674;s:9:\"downloads\";s:5:\"32743\";s:10:\"popularity\";s:3:\"907\";s:17:\"short_description\";s:87:\"Maintain, update and share upcoming group events with brilliant calendar functionality.\";s:8:\"features\";a:0:{}s:7:\"version\";s:5:\"1.4.9\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"bp\";s:3:\"url\";s:62:\"https://premium.wpmudev.org/project/buddypress-group-calendar/\";s:9:\"thumbnail\";s:84:\"https://premium.wpmudev.org/wp-content/uploads/2009/10/buddypress-group-calendar.png\";s:16:\"thumbnail_square\";s:92:\"https://premium.wpmudev.org/wp-content/uploads/2009/10/buddypress-group-calendar-150x150.png\";s:15:\"thumbnail_large\";s:84:\"https://premium.wpmudev.org/wp-content/uploads/2009/10/buddypress-group-calendar.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/mok90vvbki\";s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:88:\"https://premium.wpmudev.org/wp-content/projects/109/screenshots/1516397415_bpgroup81.jpg\";s:4:\"desc\";s:35:\"BuddyPress Group Calendar in action\";}i:1;a:2:{s:3:\"url\";s:87:\"https://premium.wpmudev.org/wp-content/projects/109/screenshots/288335300_bpgroup82.jpg\";s:4:\"desc\";s:51:\"Group calendar settings options for the Group admin\";}i:2;a:2:{s:3:\"url\";s:88:\"https://premium.wpmudev.org/wp-content/projects/109/screenshots/1608023671_bpgroup64.jpg\";s:4:\"desc\";s:39:\"Widgets options for BuddyPress Calendar\";}i:3;a:2:{s:3:\"url\";s:88:\"https://premium.wpmudev.org/wp-content/projects/109/screenshots/1329979795_bpgroup72.jpg\";s:4:\"desc\";s:65:\"Example of how the map feature works on BuddyPress Group Calendar\";}}s:6:\"_order\";i:99;}i:110;a:26:{s:2:\"id\";i:110;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:22:\"BuddyPress Group Email\";s:8:\"released\";i:1258494967;s:7:\"updated\";i:1530075577;s:9:\"downloads\";s:5:\"22771\";s:10:\"popularity\";s:3:\"688\";s:17:\"short_description\";s:101:\"Give BuddyPress group admins or moderators a simple way to send emails to all the members in a group.\";s:8:\"features\";a:0:{}s:7:\"version\";s:5:\"1.0.8\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"bp\";s:3:\"url\";s:59:\"https://premium.wpmudev.org/project/buddypress-group-email/\";s:9:\"thumbnail\";s:81:\"https://premium.wpmudev.org/wp-content/uploads/2009/11/buddypress-group-email.png\";s:16:\"thumbnail_square\";s:89:\"https://premium.wpmudev.org/wp-content/uploads/2009/11/buddypress-group-email-150x150.png\";s:15:\"thumbnail_large\";s:81:\"https://premium.wpmudev.org/wp-content/uploads/2009/11/buddypress-group-email.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:3:{i:0;a:2:{s:3:\"url\";s:91:\"https://premium.wpmudev.org/wp-content/projects/110/screenshots/1907142132_bpgroupemail.png\";s:4:\"desc\";s:41:\"BuddyPress Group Email with Default Theme\";}i:1;a:2:{s:3:\"url\";s:91:\"https://premium.wpmudev.org/wp-content/projects/110/screenshots/1645744860_groiupemail2.png\";s:4:\"desc\";s:46:\"BuddyPress Group email on the default BP theme\";}i:2;a:2:{s:3:\"url\";s:94:\"https://premium.wpmudev.org/wp-content/projects/110/screenshots/1017606204_groupemaillarge.png\";s:4:\"desc\";s:32:\"BuddyPress Group Email In Action\";}}s:6:\"_order\";i:100;}i:113;a:26:{s:2:\"id\";i:113;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:23:\"BuddyPress Hide Widgets\";s:8:\"released\";i:1258572076;s:7:\"updated\";i:1530075451;s:9:\"downloads\";s:5:\"17262\";s:10:\"popularity\";s:3:\"315\";s:17:\"short_description\";s:90:\"Set specific BuddyPress widgets to be available for use only on your network\'s main site. \";s:8:\"features\";a:0:{}s:7:\"version\";s:5:\"1.0.5\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"bp\";s:3:\"url\";s:60:\"https://premium.wpmudev.org/project/buddypress-hide-widgets/\";s:9:\"thumbnail\";s:82:\"https://premium.wpmudev.org/wp-content/uploads/2009/11/buddypress-hide-widgets.jpg\";s:16:\"thumbnail_square\";s:90:\"https://premium.wpmudev.org/wp-content/uploads/2009/11/buddypress-hide-widgets-150x150.jpg\";s:15:\"thumbnail_large\";s:82:\"https://premium.wpmudev.org/wp-content/uploads/2009/11/buddypress-hide-widgets.jpg\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:26:\"admin.php?page=bp-settings\";s:13:\"ms_config_url\";s:26:\"admin.php?page=bp-settings\";s:7:\"package\";i:0;s:11:\"screenshots\";a:2:{i:0;a:2:{s:3:\"url\";s:120:\"https://premium.wpmudev.org/wp-content/projects/113/screenshots/1057080507_buddypress-hide-widgets-1050-menu-network.png\";s:4:\"desc\";s:28:\"BuddyPress Hide Widgets Menu\";}i:1;a:2:{s:3:\"url\";s:116:\"https://premium.wpmudev.org/wp-content/projects/113/screenshots/1319212702_buddypress-hide-widgets-1050-settings.png\";s:4:\"desc\";s:32:\"BuddyPress Hide Widgets Settings\";}}s:6:\"_order\";i:101;}i:16;a:26:{s:2:\"id\";i:16;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:22:\"Dashboard Widget Order\";s:8:\"released\";i:1218159891;s:7:\"updated\";i:1530075300;s:9:\"downloads\";s:5:\"24081\";s:10:\"popularity\";s:3:\"854\";s:17:\"short_description\";s:80:\"Easily customize the order dashboard widgets display for users across Multisite.\";s:8:\"features\";a:10:{i:0;s:17:\"Set default order\";i:1;s:17:\"Simple clean code\";i:2;s:13:\"Cut and paste\";i:3;s:23:\"Rest order network-wide\";i:4;s:33:\"Customize dashboards network wide\";i:5;s:21:\"Built-in instructions\";i:6;s:22:\"No added control panel\";i:7;s:18:\"Order core widgets\";i:8;s:20:\"Order custom widgets\";i:9;s:19:\"Built for Multisite\";}s:7:\"version\";s:7:\"2.0.4.2\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:13:\"Multisite 5.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:59:\"https://premium.wpmudev.org/project/dashboard-widget-order/\";s:9:\"thumbnail\";s:89:\"https://premium.wpmudev.org/wp-content/uploads/2008/08/Dashboard-Widget-Order-280x158.png\";s:16:\"thumbnail_square\";s:87:\"https://premium.wpmudev.org/wp-content/uploads/2008/08/Dashboard-Widget-Order-90x90.png\";s:15:\"thumbnail_large\";s:81:\"https://premium.wpmudev.org/wp-content/uploads/2008/08/Dashboard-Widget-Order.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:2:{i:0;a:2:{s:3:\"url\";s:95:\"https://premium.wpmudev.org/wp-content/projects/16/screenshots/1506523733_order-php-735x470.jpg\";s:4:\"desc\";s:15:\"Order PHP files\";}i:1;a:2:{s:3:\"url\";s:90:\"https://premium.wpmudev.org/wp-content/projects/16/screenshots/2040039489_order-wigets.jpg\";s:4:\"desc\";s:23:\"customize configuration\";}}s:6:\"_order\";i:102;}i:104;a:26:{s:2:\"id\";i:104;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:20:\"Set Blog Description\";s:8:\"released\";i:1251947341;s:7:\"updated\";i:1530075188;s:9:\"downloads\";s:5:\"21005\";s:10:\"popularity\";s:3:\"632\";s:17:\"short_description\";s:79:\"Let users set a custom tagline when creating a new site on a Multisite network.\";s:8:\"features\";a:0:{}s:7:\"version\";s:3:\"1.1\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:13:\"Multisite 5.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:74:\"https://premium.wpmudev.org/project/set-blog-description-on-blog-creation/\";s:9:\"thumbnail\";s:79:\"https://premium.wpmudev.org/wp-content/uploads/2009/09/set-blog-description.jpg\";s:16:\"thumbnail_square\";s:87:\"https://premium.wpmudev.org/wp-content/uploads/2009/09/set-blog-description-150x150.jpg\";s:15:\"thumbnail_large\";s:79:\"https://premium.wpmudev.org/wp-content/uploads/2009/09/set-blog-description.jpg\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:2:{i:0;a:2:{s:3:\"url\";s:87:\"https://premium.wpmudev.org/wp-content/projects/104/screenshots/551245762_tagline81.jpg\";s:4:\"desc\";s:108:\"Check out how easy it is to let users add their own tagline on sign up using the Set Blog Description plugin\";}i:1;a:2:{s:3:\"url\";s:87:\"https://premium.wpmudev.org/wp-content/projects/104/screenshots/835016866_tagline82.jpg\";s:4:\"desc\";s:70:\"Option to add tagline on sign up using the Set Blog Description plugin\";}}s:6:\"_order\";i:103;}i:15;a:26:{s:2:\"id\";i:15;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:15:\"Dashboard Feeds\";s:8:\"released\";i:1218159888;s:7:\"updated\";i:1530075100;s:9:\"downloads\";s:5:\"26853\";s:10:\"popularity\";s:4:\"1696\";s:17:\"short_description\";s:94:\"Replace the WordPress news feeds in the dashboard with custom content relevant for your users.\";s:8:\"features\";a:0:{}s:7:\"version\";s:7:\"2.0.4.5\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:52:\"https://premium.wpmudev.org/project/dashboard-feeds/\";s:9:\"thumbnail\";s:74:\"https://premium.wpmudev.org/wp-content/uploads/2008/08/dashboard-feeds.png\";s:16:\"thumbnail_square\";s:82:\"https://premium.wpmudev.org/wp-content/uploads/2008/08/dashboard-feeds-150x150.png\";s:15:\"thumbnail_large\";s:74:\"https://premium.wpmudev.org/wp-content/uploads/2008/08/dashboard-feeds.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:40:\"options-general.php?page=dashboard-feeds\";s:13:\"ms_config_url\";s:33:\"settings.php?page=dashboard-feeds\";s:7:\"package\";i:0;s:11:\"screenshots\";a:3:{i:0;a:2:{s:3:\"url\";s:92:\"https://premium.wpmudev.org/wp-content/projects/15/screenshots/1451056508_configelements.png\";s:4:\"desc\";s:80:\"Simple to configure, we\'ll help you in the forums if you have any trouble at all\";}i:1;a:2:{s:3:\"url\";s:87:\"https://premium.wpmudev.org/wp-content/projects/15/screenshots/1812976462_dashfeed1.gif\";s:4:\"desc\";s:27:\"Replace this feed with ease\";}i:2;a:2:{s:3:\"url\";s:85:\"https://premium.wpmudev.org/wp-content/projects/15/screenshots/81434829_dashfeed2.gif\";s:4:\"desc\";s:17:\"And this one too!\";}}s:6:\"_order\";i:104;}i:11;a:26:{s:2:\"id\";i:11;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:17:\"Comment Form Text\";s:8:\"released\";i:1218159477;s:7:\"updated\";i:1529542586;s:9:\"downloads\";s:5:\"18376\";s:10:\"popularity\";s:3:\"339\";s:17:\"short_description\";s:90:\"Add a custom message or call-to-action to the comments form on every site in your network.\";s:8:\"features\";a:0:{}s:7:\"version\";s:5:\"1.0.2\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:13:\"Multisite 5.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:54:\"https://premium.wpmudev.org/project/comment-form-text/\";s:9:\"thumbnail\";s:84:\"https://premium.wpmudev.org/wp-content/uploads/2008/08/Comment-Form-Text-280x158.png\";s:16:\"thumbnail_square\";s:82:\"https://premium.wpmudev.org/wp-content/uploads/2008/08/Comment-Form-Text-90x90.png\";s:15:\"thumbnail_large\";s:76:\"https://premium.wpmudev.org/wp-content/uploads/2008/08/Comment-Form-Text.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:2:{i:0;a:2:{s:3:\"url\";s:86:\"https://premium.wpmudev.org/wp-content/projects/11/screenshots/1111934264_avatar61.jpg\";s:4:\"desc\";s:50:\"Comment form with WPMU DEV avatars plugin in place\";}i:1;a:2:{s:3:\"url\";s:88:\"https://premium.wpmudev.org/wp-content/projects/11/screenshots/602334258_commenttext.png\";s:4:\"desc\";s:32:\"The plugin in action on Edublogs\";}}s:6:\"_order\";i:105;}i:10;a:26:{s:2:\"id\";i:10;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:7:\"Avatars\";s:8:\"released\";i:1218159419;s:7:\"updated\";i:1529542169;s:9:\"downloads\";s:5:\"42644\";s:10:\"popularity\";s:4:\"1209\";s:17:\"short_description\";s:71:\"Control both site and user avatars on your WordPress Multisite network.\";s:8:\"features\";a:11:{i:0;s:33:\"Both user and site avatar options\";i:1;s:38:\"Choose perfect trim and crop on upload\";i:2;s:56:\"Quickly enhance site design with included Avatars widget\";i:3;s:32:\"End-user setup and configuration\";i:4;s:71:\"Isolated avatar image directory for simplified Media Library navigation\";i:5;s:44:\"High level branding and user self-expression\";i:6;s:40:\"Fully WordPress and Multisite compatible\";i:7;s:43:\"Settings UI integrates flawlessly with Core\";i:8;s:54:\"Comment avatar code included with every WPMU DEV theme\";i:9;s:73:\"Instant avatar display with every WPMU DEV user and blog directory plugin\";i:10;s:78:\"High-quality code foundation for easy third-party theme and plugin integration\";}s:7:\"version\";s:5:\"4.1.8\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:13:\"Multisite 5.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:44:\"https://premium.wpmudev.org/project/avatars/\";s:9:\"thumbnail\";s:66:\"https://premium.wpmudev.org/wp-content/uploads/2008/08/avatars.jpg\";s:16:\"thumbnail_square\";s:74:\"https://premium.wpmudev.org/wp-content/uploads/2008/08/avatars-150x150.jpg\";s:15:\"thumbnail_large\";s:66:\"https://premium.wpmudev.org/wp-content/uploads/2008/08/avatars.jpg\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:84:\"https://premium.wpmudev.org/wp-content/projects/10/screenshots/2135206480_widget.jpg\";s:4:\"desc\";s:18:\"Site avatar widget\";}i:1;a:2:{s:3:\"url\";s:88:\"https://premium.wpmudev.org/wp-content/projects/10/screenshots/1751616828_crop-image.jpg\";s:4:\"desc\";s:20:\"Crop and trim image \";}i:2;a:2:{s:3:\"url\";s:88:\"https://premium.wpmudev.org/wp-content/projects/10/screenshots/568615562_site-avatar.jpg\";s:4:\"desc\";s:41:\"Site avatar settings added under settings\";}i:3;a:2:{s:3:\"url\";s:89:\"https://premium.wpmudev.org/wp-content/projects/10/screenshots/2099615029_user-avater.jpg\";s:4:\"desc\";s:36:\"Allows users to add personal avatars\";}}s:6:\"_order\";i:106;}i:9;a:26:{s:2:\"id\";i:9;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:6:\"Invite\";s:8:\"released\";i:1218159216;s:7:\"updated\";i:1529541915;s:9:\"downloads\";s:5:\"28190\";s:10:\"popularity\";s:3:\"774\";s:17:\"short_description\";s:114:\"Give your users a way to invite their friends and colleagues to check out their blog and sign up for your network.\";s:8:\"features\";a:0:{}s:7:\"version\";s:7:\"1.1.3.1\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:31:\"Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:43:\"https://premium.wpmudev.org/project/invite/\";s:9:\"thumbnail\";s:65:\"https://premium.wpmudev.org/wp-content/uploads/2008/08/invite.png\";s:16:\"thumbnail_square\";s:73:\"https://premium.wpmudev.org/wp-content/uploads/2008/08/invite-150x150.png\";s:15:\"thumbnail_large\";s:65:\"https://premium.wpmudev.org/wp-content/uploads/2008/08/invite.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:33:\"settings.php?page=invite_settings\";s:7:\"package\";i:0;s:11:\"screenshots\";a:3:{i:0;a:2:{s:3:\"url\";s:102:\"https://premium.wpmudev.org/wp-content/projects/9/screenshots/1481440053_easily-configure-settings.jpg\";s:4:\"desc\";s:50:\"Configuring the email is a snap for Administrators\";}i:1;a:2:{s:3:\"url\";s:92:\"https://premium.wpmudev.org/wp-content/projects/9/screenshots/1292052628_sending-invites.jpg\";s:4:\"desc\";s:38:\"Sending the invite is a snap for users\";}i:2;a:2:{s:3:\"url\";s:96:\"https://premium.wpmudev.org/wp-content/projects/9/screenshots/1866562637_invitation-received.jpg\";s:4:\"desc\";s:31:\"This is what invitees will see.\";}}s:6:\"_order\";i:107;}i:7;a:26:{s:2:\"id\";i:7;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:17:\"Mass Email Sender\";s:8:\"released\";i:1218159012;s:7:\"updated\";i:1529541821;s:9:\"downloads\";s:5:\"28602\";s:10:\"popularity\";s:3:\"792\";s:17:\"short_description\";s:83:\"Send emails to every user on a Multisite network and allow users to opt in and out.\";s:8:\"features\";a:0:{}s:7:\"version\";s:5:\"1.7.2\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:31:\"Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:54:\"https://premium.wpmudev.org/project/mass-email-sender/\";s:9:\"thumbnail\";s:85:\"https://premium.wpmudev.org/wp-content/uploads/2008/08/Mass-Email-Sender1-280x158.png\";s:16:\"thumbnail_square\";s:83:\"https://premium.wpmudev.org/wp-content/uploads/2008/08/Mass-Email-Sender1-90x90.png\";s:15:\"thumbnail_large\";s:77:\"https://premium.wpmudev.org/wp-content/uploads/2008/08/Mass-Email-Sender1.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:29:\"settings.php?page=mass-mailer\";s:7:\"package\";i:0;s:11:\"screenshots\";a:2:{i:0;a:2:{s:3:\"url\";s:88:\"https://premium.wpmudev.org/wp-content/projects/7/screenshots/2061446280_screenshot1.png\";s:4:\"desc\";s:30:\"Composing Email - Super Easy !\";}i:1;a:2:{s:3:\"url\";s:87:\"https://premium.wpmudev.org/wp-content/projects/7/screenshots/714134936_screenshot2.png\";s:4:\"desc\";s:17:\"Sent like a Zap !\";}}s:6:\"_order\";i:108;}i:6;a:26:{s:2:\"id\";i:6;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:9:\"Admin Ads\";s:8:\"released\";i:1218158895;s:7:\"updated\";i:1529539834;s:9:\"downloads\";s:5:\"27542\";s:10:\"popularity\";s:3:\"907\";s:17:\"short_description\";s:73:\"Display an ad in the dashboard of all the sites across an entire network.\";s:8:\"features\";a:7:{i:0;s:23:\"Display in dashboard ad\";i:1;s:17:\"Show network wide\";i:2;s:21:\"Hassle-free interface\";i:3;s:22:\"Copy and paste ad code\";i:4;s:13:\"Supports HTML\";i:5;s:20:\"Multisite compatible\";i:6;s:22:\"BuddyPress integration\";}s:7:\"version\";s:7:\"1.1.0.2\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:31:\"Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:46:\"https://premium.wpmudev.org/project/admin-ads/\";s:9:\"thumbnail\";s:79:\"https://premium.wpmudev.org/wp-content/uploads/2008/08/admin-things-280x158.png\";s:16:\"thumbnail_square\";s:77:\"https://premium.wpmudev.org/wp-content/uploads/2008/08/admin-things-90x90.png\";s:15:\"thumbnail_large\";s:71:\"https://premium.wpmudev.org/wp-content/uploads/2008/08/admin-things.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:27:\"settings.php?page=admin-ads\";s:7:\"package\";i:0;s:11:\"screenshots\";a:2:{i:0;a:2:{s:3:\"url\";s:101:\"https://premium.wpmudev.org/wp-content/projects/6/screenshots/548432863_dashboard-display-735x470.jpg\";s:4:\"desc\";s:21:\"Display network wide.\";}i:1;a:2:{s:3:\"url\";s:94:\"https://premium.wpmudev.org/wp-content/projects/6/screenshots/1469749191_admin-pic-735x470.jpg\";s:4:\"desc\";s:20:\"Copy and paste copy.\";}}s:6:\"_order\";i:109;}i:176;a:26:{s:2:\"id\";i:176;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:16:\"Password Protect\";s:8:\"released\";i:1300469555;s:7:\"updated\";i:1529539517;s:9:\"downloads\";s:5:\"26649\";s:10:\"popularity\";s:4:\"1764\";s:17:\"short_description\";s:88:\"Hide content in any post or page behind a password, without a complex membership system.\";s:8:\"features\";a:0:{}s:7:\"version\";s:3:\"1.1\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:46:\"WordPress 5.0, Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:70:\"https://premium.wpmudev.org/project/password-protect-selected-content/\";s:9:\"thumbnail\";s:83:\"https://premium.wpmudev.org/wp-content/uploads/2011/03/Password-Protect-280x158.png\";s:16:\"thumbnail_square\";s:81:\"https://premium.wpmudev.org/wp-content/uploads/2011/03/Password-Protect-90x90.png\";s:15:\"thumbnail_large\";s:75:\"https://premium.wpmudev.org/wp-content/uploads/2011/03/Password-Protect.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/6p148d8il2\";s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:93:\"https://premium.wpmudev.org/wp-content/projects/176/screenshots/1713692475_after-password.png\";s:4:\"desc\";s:55:\"A video is revealed after the password has been entered\";}i:1;a:2:{s:3:\"url\";s:102:\"https://premium.wpmudev.org/wp-content/projects/176/screenshots/199470639_password-protected-video.png\";s:4:\"desc\";s:26:\"A password protected video\";}i:2;a:2:{s:3:\"url\";s:107:\"https://premium.wpmudev.org/wp-content/projects/176/screenshots/1091835128_password-protected-shortcode.png\";s:4:\"desc\";s:39:\"The code that Password Protect produces\";}i:3;a:2:{s:3:\"url\";s:104:\"https://premium.wpmudev.org/wp-content/projects/176/screenshots/816370946_protecting-with-a-password.png\";s:4:\"desc\";s:19:\"Entering a password\";}}s:6:\"_order\";i:110;}i:4;a:26:{s:2:\"id\";i:4;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:13:\"Blog Activity\";s:8:\"released\";i:1218158739;s:7:\"updated\";i:1529527819;s:9:\"downloads\";s:5:\"22834\";s:10:\"popularity\";s:3:\"777\";s:17:\"short_description\";s:73:\"See blog updates, posts and comments for your entire network at a glance.\";s:8:\"features\";a:0:{}s:7:\"version\";s:5:\"1.1.6\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:31:\"Multisite 5.0, BuddyPress 4.1.0\";s:8:\"requires\";s:2:\"ms\";s:3:\"url\";s:50:\"https://premium.wpmudev.org/project/blog-activity/\";s:9:\"thumbnail\";s:72:\"https://premium.wpmudev.org/wp-content/uploads/2008/08/blog-activity.png\";s:16:\"thumbnail_square\";s:80:\"https://premium.wpmudev.org/wp-content/uploads/2008/08/blog-activity-150x150.png\";s:15:\"thumbnail_large\";s:72:\"https://premium.wpmudev.org/wp-content/uploads/2008/08/blog-activity.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:36:\"settings.php?page=blog_activity_main\";s:7:\"package\";i:0;s:11:\"screenshots\";a:1:{i:0;a:2:{s:3:\"url\";s:90:\"https://premium.wpmudev.org/wp-content/projects/4/screenshots/1815067004_blog-activity.jpg\";s:4:\"desc\";s:49:\"Blog Activity page in the network admin dashboard\";}}s:6:\"_order\";i:111;}i:938297;a:25:{s:2:\"id\";i:938297;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:5:\"theme\";s:4:\"name\";s:7:\"Upfront\";s:8:\"released\";i:1421106646;s:7:\"updated\";i:1524768151;s:9:\"downloads\";s:6:\"121516\";s:10:\"popularity\";s:0:\"\";s:17:\"short_description\";s:145:\"A versatile and infinitely customizable drag-and-drop WordPress theme platform for use with any child theme in the growing Upfront theme library.\";s:8:\"features\";a:0:{}s:7:\"version\";s:5:\"1.9.4\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:28:\"WordPress 5.0, Multisite 5.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:55:\"https://premium.wpmudev.org/?post_type=project&p=938297\";s:9:\"thumbnail\";s:74:\"https://premium.wpmudev.org/wp-content/uploads/2015/01/upfront-280x158.jpg\";s:16:\"thumbnail_square\";s:72:\"https://premium.wpmudev.org/wp-content/uploads/2015/01/upfront-90x90.jpg\";s:15:\"thumbnail_large\";s:66:\"https://premium.wpmudev.org/wp-content/uploads/2015/01/upfront.jpg\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:6:\"_order\";i:112;}}s:11:\"plugin_tags\";a:7:{i:489;a:3:{s:4:\"name\";s:31:\"BuddyPress Plugins &amp; Themes\";s:5:\"count\";i:74;s:4:\"pids\";a:74:{i:0;s:3:\"232\";i:1;s:3:\"110\";i:2;s:3:\"109\";i:3;s:3:\"113\";i:4;s:3:\"144\";i:5;s:3:\"167\";i:6;s:3:\"249\";i:7;s:2:\"49\";i:8;s:3:\"154\";i:9;s:4:\"9135\";i:10;s:2:\"99\";i:11;s:3:\"106\";i:12;s:6:\"679841\";i:13;s:3:\"257\";i:14;s:3:\"253\";i:15;s:3:\"233\";i:16;s:3:\"130\";i:17;s:2:\"39\";i:18;s:3:\"226\";i:19;s:2:\"84\";i:20;s:3:\"252\";i:21;s:3:\"244\";i:22;s:6:\"679182\";i:23;s:3:\"240\";i:24;s:3:\"163\";i:25;s:3:\"175\";i:26;s:3:\"114\";i:27;s:3:\"105\";i:28;s:2:\"87\";i:29;s:2:\"52\";i:30;s:2:\"51\";i:31;s:2:\"80\";i:32;s:3:\"216\";i:33;s:3:\"123\";i:34;s:6:\"679162\";i:35;s:3:\"127\";i:36;s:3:\"231\";i:37;s:4:\"7330\";i:38;s:3:\"261\";i:39;s:2:\"71\";i:40;s:2:\"88\";i:41;s:3:\"256\";i:42;s:3:\"108\";i:43;s:3:\"174\";i:44;s:2:\"81\";i:45;s:3:\"151\";i:46;s:3:\"101\";i:47;s:2:\"98\";i:48;s:2:\"85\";i:49;s:2:\"77\";i:50;s:2:\"76\";i:51;s:2:\"75\";i:52;s:2:\"70\";i:53;s:2:\"66\";i:54;s:3:\"248\";i:55;s:2:\"61\";i:56;s:2:\"60\";i:57;s:2:\"63\";i:58;s:3:\"215\";i:59;s:2:\"73\";i:60;s:2:\"47\";i:61;s:3:\"137\";i:62;s:3:\"120\";i:63;s:1:\"8\";i:64;s:2:\"12\";i:65;s:2:\"30\";i:66;s:2:\"16\";i:67;s:1:\"9\";i:68;s:1:\"7\";i:69;s:1:\"6\";i:70;s:3:\"176\";i:71;s:1:\"4\";i:72;s:6:\"694503\";i:73;s:7:\"1003656\";}}i:29;a:3:{s:4:\"name\";s:15:\"Build Community\";s:5:\"count\";i:37;s:4:\"pids\";a:37:{i:0;s:6:\"679162\";i:1;s:6:\"679182\";i:2;s:3:\"247\";i:3;s:1:\"9\";i:4;s:2:\"62\";i:5;s:2:\"68\";i:6;s:3:\"242\";i:7;s:1:\"7\";i:8;s:3:\"110\";i:9;s:3:\"232\";i:10;s:2:\"10\";i:11;s:3:\"249\";i:12;s:3:\"127\";i:13;s:2:\"49\";i:14;s:3:\"101\";i:15;s:3:\"231\";i:16;s:2:\"63\";i:17;s:3:\"260\";i:18;s:2:\"75\";i:19;s:3:\"105\";i:20;s:3:\"130\";i:21;s:2:\"52\";i:22;s:2:\"82\";i:23;s:3:\"175\";i:24;s:3:\"226\";i:25;s:2:\"71\";i:26;s:2:\"66\";i:27;s:2:\"84\";i:28;s:2:\"70\";i:29;s:3:\"215\";i:30;s:3:\"120\";i:31;s:1:\"8\";i:32;s:2:\"12\";i:33;s:3:\"109\";i:34;s:3:\"113\";i:35;s:1:\"4\";i:36;s:6:\"679160\";}}i:32;a:3:{s:4:\"name\";s:26:\"WordPress Business Plugins\";s:5:\"count\";i:33;s:4:\"pids\";a:33:{i:0;s:7:\"1107020\";i:1;s:3:\"167\";i:2;s:6:\"913071\";i:3;s:3:\"144\";i:4;s:3:\"249\";i:5;s:6:\"679841\";i:6;s:6:\"912971\";i:7;s:4:\"9135\";i:8;s:4:\"7330\";i:9;s:2:\"49\";i:10;s:3:\"261\";i:11;s:3:\"106\";i:12;s:2:\"97\";i:13;s:3:\"216\";i:14;s:3:\"163\";i:15;s:3:\"253\";i:16;s:3:\"123\";i:17;s:3:\"240\";i:18;s:2:\"99\";i:19;s:3:\"218\";i:20;s:3:\"108\";i:21;s:2:\"98\";i:22;s:3:\"248\";i:23;s:2:\"73\";i:24;s:2:\"85\";i:25;s:2:\"47\";i:26;s:2:\"40\";i:27;s:1:\"8\";i:28;s:1:\"6\";i:29;s:6:\"679160\";i:30;s:6:\"694503\";i:31;s:7:\"1003656\";i:32;s:7:\"2097296\";}}i:498;a:3:{s:4:\"name\";s:27:\"WordPress Marketing Plugins\";s:5:\"count\";i:21;s:4:\"pids\";a:21:{i:0;s:7:\"1107020\";i:1;s:3:\"123\";i:2;s:6:\"694503\";i:3;s:3:\"253\";i:4;s:7:\"1003656\";i:5;s:3:\"167\";i:6;s:3:\"233\";i:7;s:6:\"910520\";i:8;s:3:\"244\";i:9;s:4:\"7330\";i:10;s:3:\"247\";i:11;s:3:\"240\";i:12;s:3:\"127\";i:13;s:3:\"108\";i:14;s:2:\"40\";i:15;s:2:\"85\";i:16;s:2:\"73\";i:17;s:2:\"76\";i:18;s:1:\"7\";i:19;s:1:\"9\";i:20;s:7:\"2097296\";}}i:16;a:3:{s:4:\"name\";s:27:\"WordPress Multisite Plugins\";s:5:\"count\";i:99;s:4:\"pids\";a:99:{i:0;s:6:\"912164\";i:1;s:7:\"1081721\";i:2;s:7:\"1081723\";i:3;s:3:\"167\";i:4;s:3:\"257\";i:5;s:6:\"913071\";i:6;s:7:\"1107020\";i:7;s:2:\"49\";i:8;s:6:\"910241\";i:9;s:6:\"910773\";i:10;s:6:\"855335\";i:11;s:6:\"852474\";i:12;s:3:\"144\";i:13;s:3:\"101\";i:14;s:3:\"120\";i:15;s:3:\"154\";i:16;s:3:\"130\";i:17;s:2:\"84\";i:18;s:3:\"249\";i:19;s:2:\"99\";i:20;s:2:\"97\";i:21;s:4:\"9135\";i:22;s:3:\"106\";i:23;s:2:\"39\";i:24;s:2:\"52\";i:25;s:6:\"910520\";i:26;s:2:\"51\";i:27;s:3:\"248\";i:28;s:3:\"105\";i:29;s:3:\"233\";i:30;s:3:\"163\";i:31;s:3:\"226\";i:32;s:3:\"114\";i:33;s:3:\"231\";i:34;s:3:\"175\";i:35;s:3:\"260\";i:36;s:4:\"7330\";i:37;s:3:\"108\";i:38;s:3:\"253\";i:39;s:6:\"679162\";i:40;s:3:\"261\";i:41;s:3:\"247\";i:42;s:3:\"244\";i:43;s:6:\"679841\";i:44;s:2:\"80\";i:45;s:2:\"60\";i:46;s:3:\"123\";i:47;s:2:\"87\";i:48;s:2:\"66\";i:49;s:3:\"240\";i:50;s:3:\"242\";i:51;s:3:\"216\";i:52;s:2:\"88\";i:53;s:3:\"252\";i:54;s:3:\"127\";i:55;s:2:\"68\";i:56;s:6:\"679182\";i:57;s:2:\"48\";i:58;s:3:\"256\";i:59;s:1:\"7\";i:60;s:2:\"98\";i:61;s:2:\"61\";i:62;s:2:\"63\";i:63;s:3:\"137\";i:64;s:2:\"62\";i:65;s:2:\"10\";i:66;s:1:\"9\";i:67;s:2:\"85\";i:68;s:3:\"104\";i:69;s:3:\"176\";i:70;s:2:\"83\";i:71;s:2:\"82\";i:72;s:2:\"76\";i:73;s:2:\"35\";i:74;s:2:\"36\";i:75;s:6:\"679160\";i:76;s:2:\"75\";i:77;s:2:\"12\";i:78;s:2:\"40\";i:79;s:1:\"6\";i:80;s:1:\"8\";i:81;s:2:\"74\";i:82;s:2:\"71\";i:83;s:2:\"70\";i:84;s:2:\"73\";i:85;s:2:\"47\";i:86;s:2:\"43\";i:87;s:2:\"42\";i:88;s:2:\"28\";i:89;s:1:\"4\";i:90;s:2:\"30\";i:91;s:3:\"215\";i:92;s:3:\"174\";i:93;s:2:\"16\";i:94;s:2:\"15\";i:95;s:2:\"11\";i:96;s:6:\"694503\";i:97;s:6:\"883804\";i:98;s:7:\"1003656\";}}i:31;a:3:{s:4:\"name\";s:28:\"WordPress Publishing Plugins\";s:5:\"count\";i:41;s:4:\"pids\";a:41:{i:0;s:6:\"912164\";i:1;s:3:\"163\";i:2;s:3:\"261\";i:3;s:6:\"855335\";i:4;s:3:\"247\";i:5;s:3:\"244\";i:6;s:4:\"7330\";i:7;s:2:\"40\";i:8;s:3:\"253\";i:9;s:2:\"85\";i:10;s:6:\"679160\";i:11;s:3:\"231\";i:12;s:3:\"174\";i:13;s:2:\"12\";i:14;s:6:\"694503\";i:15;s:3:\"108\";i:16;s:3:\"252\";i:17;s:3:\"215\";i:18;s:3:\"226\";i:19;s:3:\"240\";i:20;s:2:\"82\";i:21;s:3:\"167\";i:22;s:3:\"176\";i:23;s:3:\"127\";i:24;s:3:\"249\";i:25;s:3:\"216\";i:26;s:3:\"257\";i:27;s:3:\"130\";i:28;s:3:\"242\";i:29;s:3:\"123\";i:30;s:3:\"218\";i:31;s:3:\"105\";i:32;s:3:\"151\";i:33;s:2:\"88\";i:34;s:2:\"87\";i:35;s:2:\"76\";i:36;s:2:\"73\";i:37;s:1:\"6\";i:38;s:7:\"1003656\";i:39;s:6:\"910520\";i:40;s:6:\"910773\";}}i:50;a:3:{s:4:\"name\";s:21:\"WordPress SEO Plugins\";s:5:\"count\";i:21;s:4:\"pids\";a:21:{i:0;s:7:\"1107020\";i:1;s:3:\"167\";i:2;s:7:\"1081721\";i:3;s:6:\"910520\";i:4;s:4:\"9135\";i:5;s:4:\"7330\";i:6;s:3:\"244\";i:7;s:3:\"253\";i:8;s:2:\"39\";i:9;s:3:\"261\";i:10;s:2:\"97\";i:11;s:3:\"231\";i:12;s:3:\"106\";i:13;s:2:\"84\";i:14;s:2:\"80\";i:15;s:2:\"76\";i:16;s:2:\"71\";i:17;s:2:\"70\";i:18;s:2:\"51\";i:19;s:3:\"174\";i:20;s:2:\"11\";}}}s:11:\"free_notice\";N;s:13:\"single_notice\";N;s:11:\"full_notice\";a:3:{s:4:\"time\";i:1509947375;s:3:\"msg\";s:270:\"<strong>We\'ve pushed all-new updates to The Hub!</strong><br />What\'s The Hub? Only the best way to manage all your sites in one place! Login to your WPMU DEV account to check out the new features. <a href=\"https://premium.wpmudev.org/hub/my-websites/\">Go to The Hub</a>\";s:6:\"author\";i:164650;}}", "no");
INSERT INTO `wp_options` VALUES("149895", "classic-editor-replace", "replace", "yes");
INSERT INTO `wp_options` VALUES("135730", "wdp_un_updates_available", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("135741", "wdp_un_refresh_remote_flag", "0", "no");
INSERT INTO `wp_options` VALUES("135746", "wdp_un_membership_data", "a:2:{s:10:\"membership\";s:4:\"full\";s:21:\"membership_full_level\";s:4:\"gold\";}", "no");
INSERT INTO `wp_options` VALUES("135747", "wdp_un_last_run_sync", "a:3:{s:4:\"time\";i:1544546110;s:4:\"hash\";s:32:\"5821fad79c10d5f3cadaf9b3fb108d37\";s:5:\"fails\";i:0;}", "no");
INSERT INTO `wp_options` VALUES("106489", "wdp_un_redirected_v4", "1", "no");
INSERT INTO `wp_options` VALUES("106485", "wdp_un_limit_to_user", "a:1:{i:0;i:5;}", "no");
INSERT INTO `wp_options` VALUES("106511", "wp-smush-version", "3.0.1", "no");
INSERT INTO `wp_options` VALUES("106512", "wp-smush-skip-redirect", "1", "no");
INSERT INTO `wp_options` VALUES("106517", "wp_smush_api_auth", "a:1:{s:40:\"01fe25754d5af8a23eb704780feec4313ceea4a9\";a:2:{s:8:\"validity\";s:5:\"valid\";s:9:\"timestamp\";d:1544520224;}}", "no");
INSERT INTO `wp_options` VALUES("106518", "dir_smush_stats", "a:2:{s:9:\"dir_smush\";a:2:{s:5:\"total\";s:1:\"0\";s:9:\"optimised\";i:0;}s:14:\"combined_stats\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("106519", "wp-smush-hide_smush_welcome", "1", "no");
INSERT INTO `wp_options` VALUES("106522", "wp-smush-keep_exif", "0", "no");
INSERT INTO `wp_options` VALUES("106528", "wp-smush-image_sizes", "a:9:{i:0;s:9:\"thumbnail\";i:1;s:6:\"medium\";i:2;s:5:\"large\";i:3;s:6:\"custom\";i:4;s:14:\"post-thumbnail\";i:5;s:6:\"header\";i:6;s:6:\"slider\";i:7;s:7:\"columns\";i:8;s:12:\"medium_large\";}", "no");
INSERT INTO `wp_options` VALUES("106529", "wp-smush-resize_sizes", "a:2:{s:5:\"width\";i:2048;s:6:\"height\";i:2048;}", "no");
INSERT INTO `wp_options` VALUES("106837", "wphb_version", "1.9.3", "no");
INSERT INTO `wp_options` VALUES("153530", "wphb-gzip-data", "a:3:{s:4:\"HTML\";b:1;s:10:\"JavaScript\";b:1;s:3:\"CSS\";b:1;}", "no");
INSERT INTO `wp_options` VALUES("106858", "wphb-quick-setup", "a:1:{s:8:\"finished\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("154668", "wphb-stop-report", "1", "no");
INSERT INTO `wp_options` VALUES("154669", "wphb-last-report", "O:8:\"stdClass\":4:{s:4:\"code\";i:200;s:7:\"message\";s:0:\"\";s:4:\"data\";O:8:\"stdClass\":9:{s:2:\"id\";s:7:\"2461072\";s:4:\"time\";s:10:\"1544208804\";s:3:\"url\";s:34:\"https://www.econolodgeloon.com/wp/\";s:5:\"score\";i:79;s:11:\"score_class\";s:1:\"b\";s:5:\"title\";s:69:\"White Mountains NH Motel Hotel | Swimming Pool | Loon Mountain Skiing\";s:13:\"response_code\";i:200;s:10:\"page_stats\";O:8:\"stdClass\":13:{s:16:\"cssResponseBytes\";s:5:\"98757\";s:18:\"flashResponseBytes\";N;s:17:\"htmlResponseBytes\";s:5:\"33866\";s:18:\"imageResponseBytes\";s:6:\"557997\";s:23:\"javascriptResponseBytes\";s:6:\"143967\";s:18:\"numberCssResources\";i:6;s:11:\"numberHosts\";i:1;s:17:\"numberJsResources\";i:7;s:15:\"numberResources\";i:29;s:21:\"numberStaticResources\";i:11;s:18:\"otherResponseBytes\";s:5:\"92482\";s:17:\"textResponseBytes\";N;s:17:\"totalRequestBytes\";s:4:\"2870\";}s:11:\"rule_result\";O:8:\"stdClass\":10:{s:30:\"MainResourceServerResponseTime\";O:8:\"stdClass\":8:{s:5:\"label\";s:28:\"Improve server response time\";s:4:\"type\";s:6:\"server\";s:3:\"tip\";s:1743:\"<p>Page generation time longer than the recommended 200ms maximum will lower your score here. Much of your page generation time has to do with your hosting provider, but there are a number of steps you can take yourself to improve this score.</p>\n<h5>Recommendations:</h5>\n<ol>\n    <li>If your server response time hasn\'t decreased after enabling Hummingbird Page Caching, it\'s likely because your homepage hasn’t been cached yet. Run another test and it this should fix itself.</li>\n    <li>Usually your installed WordPress plugins have the greatest impact on your page generation time. Some are horribly inefficient, and some are just resource intensive. Test the performance impact of your plugins using a plugin like <a target=\"_blank\" href=\"https://wordpress.org/plugins/query-monitor/\">Query Monitor</a>, then remove the worst offenders, or replace them with a suitable alternative.</li>\n</ol>\n<br>\n<h5>Advanced Recommendations:</h5>\n<ol>\n    <li>Confirm with your host that you are running at least PHP 5.6 and <a target=\"_blank\" href=\"http://php.net/manual/en/intro.opcache.php\">OPcache</a> is enabled in your site\'s PHP configuration.</li>\n    <li>Install and configure an <a target=\"_blank\" href=\"https://codex.wordpress.org/Class_Reference/WP_Object_Cache#Persistent_Cache_Plugins\">object caching plugin</a> on your site (Redis or Memcached recommended).</li>\n    <li>Ask your host if they support PHP7 or HHVM to help your PHP execute faster.</li>\n</ol>\n<p>Note that many of the major <a target=\"_blank\" href=\"http://hostingreviews.io/web-hosting/managed-wordpress\">managed WordPress hosting</a> providers provide full page caching, object caching, and more modern and optimised PHP configurations as part of their offerings.</p>\";s:6:\"impact\";d:17.190000000000001278976924368180334568023681640625;s:12:\"impact_score\";i:32;s:18:\"impact_score_class\";s:1:\"d\";s:7:\"summary\";s:50:\"In our test, your server responded in 1.9 seconds.\";s:9:\"urlblocks\";a:1:{i:0;O:8:\"stdClass\":1:{s:6:\"header\";s:273:\"There are many factors that can slow down your server response time. <a href=\"https://developers.google.com/speed/docs/insights/Server\" target=\"_blank\">Please read our recommendations</a> to learn how you can monitor and measure where your server is spending the most time.\";}}}s:22:\"LeverageBrowserCaching\";O:8:\"stdClass\":8:{s:5:\"label\";s:24:\"Leverage browser caching\";s:4:\"type\";s:9:\"resources\";s:3:\"tip\";s:1171:\"<p>WP Hummingbird is the fastest, simplest way to improve this score! You can use it to quickly enable the recommended caching headers for each media type.</p><p><a class=\"wpdui-btn wpdui-btn--full wpdui-btn--brand\" href=\"https://www.econolodgeloon.com/wp/wp-admin/admin.php?page=wphb-caching\"><span class=\"wpdui-fi wpdui-fi-wordpress\"></span>Configure Browser Caching</a></p>\n<p>Unfortunately there is no way to control the caching headers for external resources included from another domain. If a file from a different domain is in the BENCHMARKS list above it is likely being added by a plugin or your theme. It is VERY common for JavaScript or CSS for 3rd party services like analytics, ad networks, etc to purposely have cache periods lower than the recommended, lowering your score. You can:</p>\n<ol>\n    <li>Deactivate plugins one by one to find the culprit, then remove or find a comparable substitute.</li>\n    <li>Ignore this recommendation and continue using the plugin/theme or service despite the affect it may have on your score. The value of certain services may be worth the minimal impact that one script has on your overall performance score.</li>\n</ol>\";s:6:\"impact\";d:5.5;s:12:\"impact_score\";i:78;s:18:\"impact_score_class\";s:1:\"b\";s:7:\"summary\";s:188:\"Setting an expiry date or a maximum age in the HTTP headers for static resources instructs the browser to load previously downloaded resources from local disk rather than over the network.\";s:9:\"urlblocks\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"header\";s:166:\"<a href=\"https://developers.google.com/speed/docs/insights/LeverageBrowserCaching\" target=\"_blank\">Leverage browser caching</a> for the following cacheable resources:\";s:4:\"urls\";a:11:{i:0;s:115:\"https://www.econolodgeloon.com/wp/wp-content/themes/tempera/images/nivoslider/arrows.png (expiration not specified)\";i:1;s:116:\"https://www.econolodgeloon.com/wp/wp-content/themes/tempera/images/nivoslider/loading.gif (expiration not specified)\";i:2;s:114:\"https://www.econolodgeloon.com/wp/wp-content/themes/tempera/images/socials/Facebook.png (expiration not specified)\";i:3;s:96:\"https://www.econolodgeloon.com/wp/wp-content/themes/tempera/style.css (expiration not specified)\";i:4;s:109:\"https://www.econolodgeloon.com/wp/wp-content/uploads/econolodgewebsitebanner-2.jpg (expiration not specified)\";i:5;s:107:\"https://www.econolodgeloon.com/wp/wp-content/uploads/slidechairsmountainview.jpg (expiration not specified)\";i:6;s:101:\"https://www.econolodgeloon.com/wp/wp-content/uploads/slidefrontandsign.jpg (expiration not specified)\";i:7;s:104:\"https://www.econolodgeloon.com/wp/wp-content/uploads/slidegazeboandchairs.jpg (expiration not specified)\";i:8;s:99:\"https://www.econolodgeloon.com/wp/wp-content/uploads/slideguestrooms.jpg (expiration not specified)\";i:9;s:103:\"https://www.econolodgeloon.com/wp/wp-content/uploads/slidehottubandpool1.jpg (expiration not specified)\";i:10;s:110:\"https://www.econolodgeloon.com/wp/wp-content/uploads/virtualtouricon-econolodge.jpg (expiration not specified)\";}}}}s:31:\"MinimizeRenderBlockingResources\";O:8:\"stdClass\":8:{s:5:\"label\";s:32:\"Remove render blocking resources\";s:4:\"type\";s:9:\"resources\";s:3:\"tip\";s:1078:\"<p>WP Hummingbird helps you move blocking JavaScript to your footer, and combine and compress blocking CSS in your header. Use WP Hummingbird to:</p>\n<ol>\n    <li>Move as many compatible scripts as possible to your footer.</li>\n    <li>Optimise your CSS by combining and minifying as many compatible files as possible.</li>\n    <li>Then run a new test to check what impact it makes on your score.</li>\n</ol>\n<p><a class=\"wpdui-btn wpdui-btn--full wpdui-btn--brand\" href=\"https://www.econolodgeloon.com/wp/wp-admin/admin.php?page=wphb-minification\"><span class=\"wpdui-fi wpdui-fi-wordpress\"></span>Configure Script Deferring</a></p>\n<p><strong>Note that it can be very hard to get a perfect score for this rule.</strong> Some plugins and themes due to their design may not be able to handle their scripts deferred to the footer without breaking, so will have to be left in their original position. And often combining and minifying all CSS files will not completely remove their impact on your score. Just try multiple combinations to improve this score as much as possible.</p>\n\";s:6:\"impact\";i:2;s:12:\"impact_score\";i:92;s:18:\"impact_score_class\";s:1:\"b\";s:7:\"summary\";s:83:\"Your page has 1 blocking CSS resources. This causes a delay in rendering your page.\";s:9:\"urlblocks\";a:2:{i:0;O:8:\"stdClass\":1:{s:6:\"header\";s:247:\"None of the above-the-fold content on your page could be rendered without waiting for the following resources to load. Try to defer or asynchronously load blocking resources, or inline the critical portions of those resources directly in the HTML.\";}i:1;O:8:\"stdClass\":2:{s:6:\"header\";s:139:\"<a href=\"https://developers.google.com/speed/docs/insights/OptimizeCSSDelivery\" target=\"_blank\">Optimize CSS Delivery</a> of the following:\";s:4:\"urls\";a:1:{i:0;s:119:\"https://www.econolodgeloon.com/wp/wp-includes/css/dist/block-library/style.min.css?ver=5ac9cdff8784c7e7b5334f7411e0faa4\";}}}}s:9:\"MinifyCss\";O:8:\"stdClass\":8:{s:5:\"label\";s:10:\"Minify CSS\";s:4:\"type\";s:8:\"resource\";s:3:\"tip\";s:299:\"<p>WP Hummingbird is the fastest, simplest way to minify your CSS files!</p><p><a class=\"wpdui-btn wpdui-btn--full wpdui-btn--brand\" href=\"https://www.econolodgeloon.com/wp/wp-admin/admin.php?page=wphb-minification\"><span class=\"wpdui-fi wpdui-fi-wordpress\"></span>Minify with WP Hummingbird</a></p>\";s:6:\"impact\";d:0.32779999999999998028243908265721984207630157470703125;s:12:\"impact_score\";i:99;s:18:\"impact_score_class\";s:1:\"b\";s:7:\"summary\";s:86:\"Compacting CSS code can save many bytes of data and speed up download and parse times.\";s:9:\"urlblocks\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"header\";s:182:\"<a href=\"https://developers.google.com/speed/docs/insights/MinifyResources\" target=\"_blank\">Minify CSS</a> for the following resources to reduce their size by 3.2KiB (24% reduction).\";s:4:\"urls\";a:3:{i:0;s:132:\"Minifying https://www.econolodgeloon.com/wp/wp-content/themes/tempera/style.css could save 2.8KiB (24% reduction) after compression.\";i:1;s:154:\"Minifying https://www.econolodgeloon.com/wp/wp-content/themes/tempera/styles/style-mobile.css?ver=1.7.0 could save 283B (15% reduction) after compression.\";i:2;s:149:\"Minifying https://www.econolodgeloon.com/wp/wp-content/themes/tempera-nocopyrt/style.css?ver=1.7.0 could save 156B (73% reduction) after compression.\";}}}}s:16:\"MinifyJavaScript\";O:8:\"stdClass\":8:{s:5:\"label\";s:17:\"Minify JavaScript\";s:4:\"type\";s:8:\"resource\";s:3:\"tip\";s:868:\"<p>WP Hummingbird is the fastest, simplest way to minify your JavaScript files!</p><p><a class=\"wpdui-btn wpdui-btn--full wpdui-btn--brand\" href=\"https://www.econolodgeloon.com/wp/wp-admin/admin.php?page=wphb-minification\"><span class=\"wpdui-fi wpdui-fi-wordpress\"></span>Minify with WP Hummingbird</a></p>\n<p>Unfortunately there is no way to minify JavaScript included from another domain. If a file from a different domain is in the BENCHMARKS list above it is likely being added by a plugin or your theme. You can:</p>\n<ol>\n    <li>Deactivate plugins one by one to find the culprit, then remove or find a comparable substitute.</li>\n    <li>Ignore this recommendation and continue using the plugin/theme despite the affect it may have on your score. This may be a perfectly valid option for some JavaScript files for services you just can\'t live without.</li>\n</ol>\";s:6:\"impact\";d:0.1171999999999999986233234494648058898746967315673828125;s:12:\"impact_score\";i:100;s:18:\"impact_score_class\";s:1:\"a\";s:7:\"summary\";s:109:\"Compacting JavaScript code can save many bytes of data and speed up downloading, parsing, and execution time.\";s:9:\"urlblocks\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"header\";s:189:\"<a href=\"https://developers.google.com/speed/docs/insights/MinifyResources\" target=\"_blank\">Minify JavaScript</a> for the following resources to reduce their size by 1.1KiB (35% reduction).\";s:4:\"urls\";a:2:{i:0;s:145:\"Minifying https://www.econolodgeloon.com/wp/wp-content/themes/tempera/js/frontend.js?ver=1.7.0 could save 720B (30% reduction) after compression.\";i:1;s:141:\"Minifying https://www.econolodgeloon.com/wp/wp-content/themes/tempera/js/ajax.js?ver=1.7.0 could save 452B (51% reduction) after compression.\";}}}}s:14:\"OptimizeImages\";O:8:\"stdClass\":8:{s:5:\"label\";s:15:\"Optimize images\";s:4:\"type\";s:8:\"resource\";s:3:\"tip\";s:973:\"<p>Images were found on your site that can be optimized to reduce their file size with little to no impact on visual quality.</p>\n<ol>\n    <li><p><a target=\"_blank\" href=\"https://premium.wpmudev.org/project/wp-smush-pro/\">WP Smush Pro</a> is the simplest way to optimize uploaded images with lossless or lossy compression and remove unused image information (i.e. metadata, geo tags).</p><p><a class=\"wpdui-btn wpdui-btn--full wpdui-btn--brand\" href=\"https://www.econolodgeloon.com/wp/wp-admin/admin.php?page=smush\"><span class=\"wpdui-fi wpdui-fi-wordpress\"></span>Configure WP Smush Pro</a></p></li>\n    <li>If any images in the list above recommend “Compressing and resizing”, that means their dimensions are scaled down in your content compared to the actual file dimensions. You can crop or scale those images using the <a href=\"https://www.econolodgeloon.com/wp/wp-admin/upload.php\">WordPress image editor</a> to match the embedded size in your content.</li>\n</ol>\";s:6:\"impact\";d:0.06350000000000000088817841970012523233890533447265625;s:12:\"impact_score\";i:100;s:18:\"impact_score_class\";s:1:\"a\";s:7:\"summary\";s:71:\"Properly formatting and compressing images can save many bytes of data.\";s:9:\"urlblocks\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"header\";s:170:\"<a href=\"https://developers.google.com/speed/docs/insights/OptimizeImages\" target=\"_blank\">Optimize the following images</a> to reduce their size by 635B (30% reduction).\";s:4:\"urls\";a:2:{i:0;s:133:\"Compressing https://www.econolodgeloon.com/wp/wp-content/themes/tempera/images/nivoslider/arrows.png could save 467B (33% reduction).\";i:1;s:132:\"Compressing https://www.econolodgeloon.com/wp/wp-content/themes/tempera/images/socials/Facebook.png could save 168B (24% reduction).\";}}}}s:24:\"PrioritizeVisibleContent\";O:8:\"stdClass\":7:{s:5:\"label\";s:26:\"Prioritize visible content\";s:4:\"type\";s:7:\"content\";s:3:\"tip\";s:792:\"<p>This score is very hard to improve unless you have custom-coded your theme and plugins with these optimizations in mind from the beginning. However the vast majority of WordPress sites are not built that way. Luckily the overall impact on your score from this rule is usually small.</p>\n<h5>Recommendations:</h5>\n<ol>\n    <li>Sometimes following the \"Remove render-blocking resources\" recommendations can improve this score as a side effect, so try that first.</li>\n    <li>Try switching to a different theme to see if it improves your score.</li>\n    <li>Ignore this recommendation and continue using your theme despite the affect it may have on your overall score. This is a perfectly valid option, sometimes there is an unavoidable tradeoff between features and performance.</li>\n</ol>\n\";s:6:\"impact\";i:0;s:12:\"impact_score\";i:100;s:18:\"impact_score_class\";s:1:\"a\";s:7:\"summary\";s:209:\"You have the above-the-fold content properly prioritized. Learn more about <a href=\"https://developers.google.com/speed/docs/insights/PrioritizeVisibleContent\" target=\"_blank\">prioritizing visible content</a>.\";}s:21:\"EnableGzipCompression\";O:8:\"stdClass\":7:{s:5:\"label\";s:18:\"Enable compression\";s:4:\"type\";s:6:\"server\";s:3:\"tip\";s:913:\"<p>WP Hummingbird is the fastest, simplest way to improve this score! You can use it to enable GZIP compression for all compressible resources.</p><p><a class=\"wpdui-btn wpdui-btn--full wpdui-btn--brand\" href=\"https://www.econolodgeloon.com/wp/wp-admin/admin.php?page=wphb-gzip\"><span class=\"wpdui-fi wpdui-fi-wordpress\"></span>Configure GZIP Compression</a></p>\n<p>Unfortunately there is no way to compress external resources included from another domain. If a file from a different domain is in the BENCHMARKS list above it is likely being added by a plugin or your theme. You can:</p>\n<ol>\n    <li>Deactivate plugins one by one to find the culprit, then remove or find a comparable substitute.</li>\n    <li>Ignore this recommendation and continue using the plugin/theme despite the affect it may have on your score. This may be a perfectly valid option for some services you just can\'t live without.</li>\n</ol>\";s:6:\"impact\";i:0;s:12:\"impact_score\";i:100;s:18:\"impact_score_class\";s:1:\"a\";s:7:\"summary\";s:166:\"You have compression enabled. Learn more about <a href=\"https://developers.google.com/speed/docs/insights/EnableCompression\" target=\"_blank\">enabling compression</a>.\";}s:25:\"AvoidLandingPageRedirects\";O:8:\"stdClass\":7:{s:5:\"label\";s:28:\"Avoid landing page redirects\";s:4:\"type\";s:6:\"server\";s:3:\"tip\";s:556:\"<p>If you have a redirect leading to a different subdomain, you may need to <a target=\"_blank\" href=\"https://codex.wordpress.org/Changing_The_Site_URL\">update the site_url and home_url options</a> of your site to match your preference. Redirects can also be caused by a plugin, or your theme. Disabling plugins one at a time can help you find the culprit. They can also be caused by a rule in your htaccess file or hosting control panel.</p><p>If you are unsure where the redirect is coming from speak to your host to see if they can resolve the issue.</p>\";s:6:\"impact\";i:0;s:12:\"impact_score\";i:100;s:18:\"impact_score_class\";s:1:\"a\";s:7:\"summary\";s:172:\"Your page has no redirects. Learn more about <a href=\"https://developers.google.com/speed/docs/insights/AvoidRedirects\" target=\"_blank\">avoiding landing page redirects</a>.\";}s:10:\"MinifyHTML\";O:8:\"stdClass\":7:{s:5:\"label\";s:11:\"Minify HTML\";s:4:\"type\";s:7:\"content\";s:3:\"tip\";s:306:\"<p>Unfortunately there isn\'t currently a reliable way to minify HTML via a WordPress plugin or commonly installed server modules. Luckily this generally has minimal, if any impact on your overall score.</p>\n<p><strong>Stay tuned as we are working on adding this feature to WP Hummingbird soon!</strong></p>\";s:6:\"impact\";i:0;s:12:\"impact_score\";i:100;s:18:\"impact_score_class\";s:1:\"a\";s:7:\"summary\";s:151:\"Your HTML is minified. Learn more about <a href=\"https://developers.google.com/speed/docs/insights/MinifyResources\" target=\"_blank\">minifying HTML</a>.\";}}}s:5:\"error\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("155194", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2018-12-11 16:47:01\";s:7:\"Version\";s:6:\"1.2.52\";s:9:\"VersionWP\";s:3:\"5.0\";s:9:\"VersionDB\";s:7:\"10.1.36\";s:10:\"VersionPHP\";s:6:\"5.6.38\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:10:\"econolodge\";s:4:\"Hash\";s:35:\"723466409e890c2d4743_20181211164701\";s:8:\"NameHash\";s:46:\"econolodge_723466409e890c2d4743_20181211164701\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:48:\"/home/econolodge/public_html/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:47:\"https://www.econolodgeloon.com/wp/wp-snapshots/\";s:8:\"ScanFile\";s:56:\"econolodge_723466409e890c2d4743_20181211164701_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":19:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:31:\"/home/econolodge/public_html/wp\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2018-12-11 16:47:01\";s:7:\"Version\";s:6:\"1.2.52\";s:9:\"VersionWP\";s:3:\"5.0\";s:9:\"VersionDB\";s:7:\"10.1.36\";s:10:\"VersionPHP\";s:6:\"5.6.38\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:10:\"econolodge\";s:4:\"Hash\";s:35:\"723466409e890c2d4743_20181211164701\";s:8:\"NameHash\";s:46:\"econolodge_723466409e890c2d4743_20181211164701\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:48:\"/home/econolodge/public_html/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:47:\"https://www.econolodgeloon.com/wp/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";r:22;s:9:\"Installer\";O:13:\"DUP_Installer\":9:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:20:\"dGVdUm1Ie3BlU31FIUAj\";s:10:\"\0*\0Package\";r:58;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:10:\"\0*\0Package\";r:58;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:40:\"/home/econolodge/public_html/wp/wp-admin\";i:1;s:50:\"/home/econolodge/public_html/wp/wp-content/uploads\";i:2;s:52:\"/home/econolodge/public_html/wp/wp-content/languages\";i:3;s:50:\"/home/econolodge/public_html/wp/wp-content/plugins\";i:4;s:49:\"/home/econolodge/public_html/wp/wp-content/themes\";i:5;s:43:\"/home/econolodge/public_html/wp/wp-includes\";}}s:9:\"Installer\";r:80;s:8:\"Database\";r:90;}", "yes");
INSERT INTO `wp_options` VALUES("152176", "duplicator_exe_safe_mode", "0", "yes");
INSERT INTO `wp_options` VALUES("135735", "wdp_un_farm133_themes", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("136541", "wordfence_installed", "1", "yes");
INSERT INTO `wp_options` VALUES("136381", "wd_hardener_settings", "a:11:{s:2:\"id\";s:20:\"wd_hardener_settings\";s:6:\"issues\";a:9:{i:0;s:17:\"disable_trackback\";i:1;s:9:\"db_prefix\";i:2;s:19:\"disable_file_editor\";i:3;s:10:\"hide_error\";i:4;s:12:\"security_key\";i:5;s:19:\"protect-information\";i:6;s:20:\"prevent-php-executed\";i:7;s:14:\"login-duration\";i:8;s:15:\"disable_xml_rpc\";}s:5:\"fixed\";a:3:{i:0;s:10:\"wp_version\";i:1;s:11:\"php_version\";i:2;s:12:\"change_admin\";}s:6:\"ignore\";a:0:{}s:17:\"last_status_check\";i:1544545496;s:12:\"notification\";b:1;s:8:\"receipts\";a:0:{}s:4:\"data\";a:0:{}s:18:\"exclude_file_paths\";a:0:{}s:12:\"new_htconfig\";a:0:{}s:13:\"active_server\";s:6:\"apache\";}", "no");
INSERT INTO `wp_options` VALUES("108348", "ossdl_off_cdn_url", "http://67.23.236.217/~windriftmotel", "yes");
INSERT INTO `wp_options` VALUES("108349", "ossdl_off_include_dirs", "wp-content,wp-includes", "yes");
INSERT INTO `wp_options` VALUES("108350", "ossdl_off_exclude", ".php", "yes");
INSERT INTO `wp_options` VALUES("108351", "ossdl_cname", "", "yes");
INSERT INTO `wp_options` VALUES("108354", "wp_super_cache_index_detected", "3", "no");
INSERT INTO `wp_options` VALUES("106923", "wphb-last-report-score", "a:1:{s:5:\"score\";i:63;}", "no");
INSERT INTO `wp_options` VALUES("136360", "wphb-caching-data", "a:4:{s:10:\"javascript\";b:0;s:3:\"css\";b:0;s:5:\"media\";b:0;s:6:\"images\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("108355", "wpsupercache_start", "1498343066", "yes");
INSERT INTO `wp_options` VALUES("108356", "wpsupercache_count", "0", "yes");
INSERT INTO `wp_options` VALUES("107299", "smush_global_stats", "a:9:{s:11:\"size_before\";i:89485383;s:10:\"size_after\";i:46048457;s:7:\"percent\";d:48.5;s:5:\"human\";s:7:\"41.4 MB\";s:5:\"bytes\";i:43436926;s:12:\"total_images\";i:1785;s:12:\"resize_count\";i:0;s:14:\"resize_savings\";i:0;s:18:\"conversion_savings\";i:6124;}", "no");
INSERT INTO `wp_options` VALUES("107637", "wphb_styles_collection", "a:13:{s:25:\"advanced-floating-content\";a:6:{s:6:\"handle\";s:25:\"advanced-floating-content\";s:3:\"src\";s:133:\"http://67.23.236.217/~windriftmotel/wp-content/plugins/advanced-floating-content-lite/public/css/advanced-floating-content-public.css\";s:4:\"deps\";a:0:{}s:3:\"ver\";s:5:\"1.0.0\";s:4:\"args\";s:3:\"all\";s:5:\"extra\";a:0:{}}s:12:\"bwg_frontend\";a:6:{s:6:\"handle\";s:12:\"bwg_frontend\";s:3:\"src\";s:89:\"http://67.23.236.217/~windriftmotel/wp-content/plugins/photo-gallery/css/bwg_frontend.css\";s:4:\"deps\";a:0:{}s:3:\"ver\";s:6:\"1.3.45\";s:4:\"args\";s:3:\"all\";s:5:\"extra\";a:0:{}}s:16:\"bwg_font-awesome\";a:6:{s:6:\"handle\";s:16:\"bwg_font-awesome\";s:3:\"src\";s:102:\"http://67.23.236.217/~windriftmotel/wp-content/plugins/photo-gallery/css/font-awesome/font-awesome.css\";s:4:\"deps\";a:0:{}s:3:\"ver\";s:5:\"4.6.3\";s:4:\"args\";s:3:\"all\";s:5:\"extra\";a:0:{}}s:20:\"bwg_mCustomScrollbar\";a:6:{s:6:\"handle\";s:20:\"bwg_mCustomScrollbar\";s:3:\"src\";s:100:\"http://67.23.236.217/~windriftmotel/wp-content/plugins/photo-gallery/css/jquery.mCustomScrollbar.css\";s:4:\"deps\";a:0:{}s:3:\"ver\";s:6:\"1.3.45\";s:4:\"args\";s:3:\"all\";s:5:\"extra\";a:0:{}}s:14:\"bwg_sumoselect\";a:6:{s:6:\"handle\";s:14:\"bwg_sumoselect\";s:3:\"src\";s:87:\"http://67.23.236.217/~windriftmotel/wp-content/plugins/photo-gallery/css/sumoselect.css\";s:4:\"deps\";a:0:{}s:3:\"ver\";s:5:\"3.0.2\";s:4:\"args\";s:3:\"all\";s:5:\"extra\";a:0:{}}s:8:\"slb_core\";a:6:{s:6:\"handle\";s:8:\"slb_core\";s:3:\"src\";s:54:\"/wp-content/plugins/simple-lightbox/client/css/app.css\";s:4:\"deps\";a:0:{}s:3:\"ver\";s:5:\"2.6.0\";s:4:\"args\";s:3:\"all\";s:5:\"extra\";a:0:{}}s:13:\"tempera-fonts\";a:6:{s:6:\"handle\";s:13:\"tempera-fonts\";s:3:\"src\";s:81:\"http://67.23.236.217/~windriftmotel/wp-content/themes/tempera/fonts/fontfaces.css\";s:4:\"deps\";a:0:{}s:3:\"ver\";s:5:\"1.6.2\";s:4:\"args\";s:3:\"all\";s:5:\"extra\";a:0:{}}s:13:\"tempera-style\";a:6:{s:6:\"handle\";s:13:\"tempera-style\";s:3:\"src\";s:80:\"http://67.23.236.217/~windriftmotel/wp-content/themes/tempera-nocopyrt/style.css\";s:4:\"deps\";a:0:{}s:3:\"ver\";s:5:\"1.6.2\";s:4:\"args\";s:3:\"all\";s:5:\"extra\";a:0:{}}s:14:\"addthis_output\";a:6:{s:6:\"handle\";s:14:\"addthis_output\";s:3:\"src\";s:77:\"http://67.23.236.217/~windriftmotel/wp-content/plugins/addthis/css/output.css\";s:4:\"deps\";a:0:{}s:3:\"ver\";b:0;s:4:\"args\";s:3:\"all\";s:5:\"extra\";a:0:{}}s:9:\"dashicons\";a:6:{s:6:\"handle\";s:9:\"dashicons\";s:3:\"src\";s:34:\"/wp-includes/css/dashicons.min.css\";s:4:\"deps\";a:0:{}s:3:\"ver\";b:0;s:4:\"args\";N;s:5:\"extra\";a:0:{}}s:9:\"admin-bar\";a:6:{s:6:\"handle\";s:9:\"admin-bar\";s:3:\"src\";s:34:\"/wp-includes/css/admin-bar.min.css\";s:4:\"deps\";a:1:{i:0;s:9:\"dashicons\";}s:3:\"ver\";b:0;s:4:\"args\";N;s:5:\"extra\";a:2:{s:3:\"rtl\";s:7:\"replace\";s:6:\"suffix\";s:4:\".min\";}}s:16:\"wordfenceAJAXcss\";a:6:{s:6:\"handle\";s:16:\"wordfenceAJAXcss\";s:3:\"src\";s:85:\"http://67.23.236.217/~windriftmotel/wp-content/plugins/wordfence/css/wordfenceBox.css\";s:4:\"deps\";a:0:{}s:3:\"ver\";s:6:\"6.3.20\";s:4:\"args\";s:3:\"all\";s:5:\"extra\";a:0:{}}s:18:\"yoast-seo-adminbar\";a:6:{s:6:\"handle\";s:18:\"yoast-seo-adminbar\";s:3:\"src\";s:98:\"http://67.23.236.217/~windriftmotel/wp-content/plugins/wordpress-seo/css/dist/adminbar-561.min.css\";s:4:\"deps\";a:0:{}s:3:\"ver\";s:5:\"5.6.1\";s:4:\"args\";s:3:\"all\";s:5:\"extra\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("107638", "wphb_scripts_collection", "a:22:{s:11:\"jquery-core\";a:6:{s:6:\"handle\";s:11:\"jquery-core\";s:3:\"src\";s:32:\"/wp-includes/js/jquery/jquery.js\";s:4:\"deps\";a:0:{}s:3:\"ver\";s:6:\"1.12.4\";s:4:\"args\";N;s:5:\"extra\";a:0:{}}s:14:\"jquery-migrate\";a:6:{s:6:\"handle\";s:14:\"jquery-migrate\";s:3:\"src\";s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";s:4:\"deps\";a:0:{}s:3:\"ver\";s:5:\"1.4.1\";s:4:\"args\";N;s:5:\"extra\";a:0:{}}s:16:\"cryout_ajax_more\";a:6:{s:6:\"handle\";s:16:\"cryout_ajax_more\";s:3:\"src\";s:72:\"http://67.23.236.217/~windriftmotel/wp-content/themes/tempera/js/ajax.js\";s:4:\"deps\";a:1:{i:0;s:6:\"jquery\";}s:3:\"ver\";s:5:\"1.6.2\";s:4:\"args\";N;s:5:\"extra\";a:2:{s:5:\"group\";i:1;s:4:\"data\";s:262:\"var cryout_ajax_more = {\"page_number_next\":\"2\",\"page_number_max\":\"0\",\"page_link_model\":\"http:\\/\\/67.23.236.217\\/~windriftmotel\\/page\\/9999999\\/\",\"load_more_str\":\"More Posts\",\"content_css_selector\":\"#content\",\"pagination_css_selector\":\".pagination, .navigation\"};\";}}s:25:\"advanced-floating-content\";a:6:{s:6:\"handle\";s:25:\"advanced-floating-content\";s:3:\"src\";s:131:\"http://67.23.236.217/~windriftmotel/wp-content/plugins/advanced-floating-content-lite/public/js/advanced-floating-content-public.js\";s:4:\"deps\";a:1:{i:0;s:6:\"jquery\";}s:3:\"ver\";s:5:\"1.0.0\";s:4:\"args\";N;s:5:\"extra\";a:0:{}}s:12:\"bwg_frontend\";a:6:{s:6:\"handle\";s:12:\"bwg_frontend\";s:3:\"src\";s:87:\"http://67.23.236.217/~windriftmotel/wp-content/plugins/photo-gallery/js/bwg_frontend.js\";s:4:\"deps\";a:1:{i:0;s:6:\"jquery\";}s:3:\"ver\";s:6:\"1.3.45\";s:4:\"args\";N;s:5:\"extra\";a:0:{}}s:14:\"bwg_sumoselect\";a:6:{s:6:\"handle\";s:14:\"bwg_sumoselect\";s:3:\"src\";s:96:\"http://67.23.236.217/~windriftmotel/wp-content/plugins/photo-gallery/js/jquery.sumoselect.min.js\";s:4:\"deps\";a:1:{i:0;s:6:\"jquery\";}s:3:\"ver\";s:5:\"3.0.2\";s:4:\"args\";N;s:5:\"extra\";a:1:{s:4:\"data\";s:76:\"var bwg_objectsL10n = {\"bwg_select_tag\":\"Select Tag\",\"bwg_search\":\"Search\"};\";}}s:17:\"bwg_jquery_mobile\";a:6:{s:6:\"handle\";s:17:\"bwg_jquery_mobile\";s:3:\"src\";s:88:\"http://67.23.236.217/~windriftmotel/wp-content/plugins/photo-gallery/js/jquery.mobile.js\";s:4:\"deps\";a:1:{i:0;s:6:\"jquery\";}s:3:\"ver\";s:6:\"1.3.45\";s:4:\"args\";N;s:5:\"extra\";a:0:{}}s:20:\"bwg_mCustomScrollbar\";a:6:{s:6:\"handle\";s:20:\"bwg_mCustomScrollbar\";s:3:\"src\";s:109:\"http://67.23.236.217/~windriftmotel/wp-content/plugins/photo-gallery/js/jquery.mCustomScrollbar.concat.min.js\";s:4:\"deps\";a:1:{i:0;s:6:\"jquery\";}s:3:\"ver\";s:6:\"1.3.45\";s:4:\"args\";N;s:5:\"extra\";a:0:{}}s:17:\"jquery-fullscreen\";a:6:{s:6:\"handle\";s:17:\"jquery-fullscreen\";s:3:\"src\";s:98:\"http://67.23.236.217/~windriftmotel/wp-content/plugins/photo-gallery/js/jquery.fullscreen-0.4.1.js\";s:4:\"deps\";a:1:{i:0;s:6:\"jquery\";}s:3:\"ver\";s:5:\"0.4.1\";s:4:\"args\";N;s:5:\"extra\";a:0:{}}s:15:\"bwg_gallery_box\";a:6:{s:6:\"handle\";s:15:\"bwg_gallery_box\";s:3:\"src\";s:90:\"http://67.23.236.217/~windriftmotel/wp-content/plugins/photo-gallery/js/bwg_gallery_box.js\";s:4:\"deps\";a:1:{i:0;s:6:\"jquery\";}s:3:\"ver\";s:6:\"1.3.45\";s:4:\"args\";N;s:5:\"extra\";a:1:{s:4:\"data\";s:188:\"var bwg_objectL10n = {\"bwg_field_required\":\"field is required.\",\"bwg_mail_validation\":\"This is not a valid email address.\",\"bwg_search_result\":\"There are no images matching your search.\"};\";}}s:16:\"tempera-frontend\";a:6:{s:6:\"handle\";s:16:\"tempera-frontend\";s:3:\"src\";s:76:\"http://67.23.236.217/~windriftmotel/wp-content/themes/tempera/js/frontend.js\";s:4:\"deps\";a:1:{i:0;s:6:\"jquery\";}s:3:\"ver\";s:5:\"1.6.2\";s:4:\"args\";N;s:5:\"extra\";a:2:{s:5:\"group\";i:1;s:4:\"data\";s:52:\"var tempera_settings = {\"mobile\":\"1\",\"fitvids\":\"1\"};\";}}s:18:\"tempera-nivoslider\";a:6:{s:6:\"handle\";s:18:\"tempera-nivoslider\";s:3:\"src\";s:83:\"http://67.23.236.217/~windriftmotel/wp-content/themes/tempera/js/nivo.slider.min.js\";s:4:\"deps\";a:1:{i:0;s:6:\"jquery\";}s:3:\"ver\";s:5:\"1.6.2\";s:4:\"args\";N;s:5:\"extra\";a:1:{s:5:\"group\";i:1;}}s:8:\"wp-embed\";a:6:{s:6:\"handle\";s:8:\"wp-embed\";s:3:\"src\";s:31:\"/wp-includes/js/wp-embed.min.js\";s:4:\"deps\";a:0:{}s:3:\"ver\";b:0;s:4:\"args\";N;s:5:\"extra\";a:0:{}}s:9:\"admin-bar\";a:6:{s:6:\"handle\";s:9:\"admin-bar\";s:3:\"src\";s:32:\"/wp-includes/js/admin-bar.min.js\";s:4:\"deps\";a:0:{}s:3:\"ver\";b:0;s:4:\"args\";i:1;s:5:\"extra\";a:0:{}}s:15:\"wordfenceAJAXjs\";a:6:{s:6:\"handle\";s:15:\"wordfenceAJAXjs\";s:3:\"src\";s:88:\"http://67.23.236.217/~windriftmotel/wp-content/plugins/wordfence/js/admin.ajaxWatcher.js\";s:4:\"deps\";a:1:{i:0;s:6:\"jquery\";}s:3:\"ver\";s:6:\"6.3.20\";s:4:\"args\";N;s:5:\"extra\";a:0:{}}s:8:\"slb_core\";a:6:{s:6:\"handle\";s:8:\"slb_core\";s:3:\"src\";s:62:\"/wp-content/plugins/simple-lightbox/client/js/prod/lib.core.js\";s:4:\"deps\";a:1:{i:0;s:6:\"jquery\";}s:3:\"ver\";s:5:\"2.6.0\";s:4:\"args\";N;s:5:\"extra\";a:1:{s:5:\"group\";i:1;}}s:8:\"slb_view\";a:6:{s:6:\"handle\";s:8:\"slb_view\";s:3:\"src\";s:62:\"/wp-content/plugins/simple-lightbox/client/js/prod/lib.view.js\";s:4:\"deps\";a:1:{i:0;s:8:\"slb_core\";}s:3:\"ver\";s:5:\"2.6.0\";s:4:\"args\";N;s:5:\"extra\";a:1:{s:5:\"group\";i:1;}}s:27:\"slb-asset-slb_baseline-base\";a:6:{s:6:\"handle\";s:27:\"slb-asset-slb_baseline-base\";s:3:\"src\";s:69:\"/wp-content/plugins/simple-lightbox/themes/baseline/js/prod/client.js\";s:4:\"deps\";a:0:{}s:3:\"ver\";s:5:\"2.6.0\";s:4:\"args\";N;s:5:\"extra\";a:1:{s:5:\"group\";i:1;}}s:26:\"slb-asset-slb_default-base\";a:6:{s:6:\"handle\";s:26:\"slb-asset-slb_default-base\";s:3:\"src\";s:68:\"/wp-content/plugins/simple-lightbox/themes/default/js/prod/client.js\";s:4:\"deps\";a:0:{}s:3:\"ver\";s:5:\"2.6.0\";s:4:\"args\";N;s:5:\"extra\";a:1:{s:5:\"group\";i:1;}}s:19:\"slb-asset-item-base\";a:6:{s:6:\"handle\";s:19:\"slb-asset-item-base\";s:3:\"src\";s:74:\"/wp-content/plugins/simple-lightbox/template-tags/item/js/prod/tag.item.js\";s:4:\"deps\";a:0:{}s:3:\"ver\";s:5:\"2.6.0\";s:4:\"args\";N;s:5:\"extra\";a:1:{s:5:\"group\";i:1;}}s:17:\"slb-asset-ui-base\";a:6:{s:6:\"handle\";s:17:\"slb-asset-ui-base\";s:3:\"src\";s:70:\"/wp-content/plugins/simple-lightbox/template-tags/ui/js/prod/tag.ui.js\";s:4:\"deps\";a:0:{}s:3:\"ver\";s:5:\"2.6.0\";s:4:\"args\";N;s:5:\"extra\";a:1:{s:5:\"group\";i:1;}}s:20:\"slb-asset-image-base\";a:6:{s:6:\"handle\";s:20:\"slb-asset-image-base\";s:3:\"src\";s:83:\"/wp-content/plugins/simple-lightbox/content-handlers/image/js/prod/handler.image.js\";s:4:\"deps\";a:0:{}s:3:\"ver\";s:5:\"2.6.0\";s:4:\"args\";N;s:5:\"extra\";a:1:{s:5:\"group\";i:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("107643", "wphb-minification-errors", "a:2:{s:7:\"scripts\";a:4:{s:6:\"jquery\";a:3:{s:4:\"code\";s:9:\"empty-url\";s:5:\"error\";s:64:\"This file has not a linked URL, it will not be combined/minified\";s:7:\"disable\";a:2:{i:0;s:6:\"minify\";i:1;s:7:\"combine\";}}s:18:\"tempera-nivoslider\";a:3:{s:4:\"code\";s:13:\"empty-content\";s:5:\"error\";s:32:\"It looks like this file is empty\";s:7:\"disable\";a:0:{}}s:16:\"tempera-frontend\";a:3:{s:4:\"code\";s:13:\"empty-content\";s:5:\"error\";s:32:\"It looks like this file is empty\";s:7:\"disable\";a:0:{}}s:16:\"cryout_ajax_more\";a:3:{s:4:\"code\";s:13:\"empty-content\";s:5:\"error\";s:32:\"It looks like this file is empty\";s:7:\"disable\";a:0:{}}}s:6:\"styles\";a:1:{s:13:\"tempera-style\";a:3:{s:4:\"code\";s:18:\"import-not-allowed\";s:5:\"error\";s:47:\"@import directive is not allowed in stylesheets\";s:7:\"disable\";a:2:{i:0;s:6:\"minify\";i:1;s:7:\"combine\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("136448", "wds-model-service-seo-progress", "", "yes");
INSERT INTO `wp_options` VALUES("136449", "wds-model-service-seo-service-result", "a:6:{s:5:\"start\";i:0;s:3:\"end\";i:1524016474;s:4:\"sync\";i:1524016474;s:5:\"total\";i:0;s:10:\"percentage\";i:0;s:6:\"issues\";a:3:{s:8:\"previous\";a:0:{}s:8:\"messages\";a:1:{i:0;s:90:\"Your SEO crawl has timed out due to an unknown error. Please try again or contact support.\";}s:6:\"issues\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("136450", "wds-model-service-seo-service-last_runtime", "1524016474", "yes");
INSERT INTO `wp_options` VALUES("134732", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("119397", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("121104", "wp-smush-install-type", "new", "no");
INSERT INTO `wp_options` VALUES("134554", "wdp_un_hub_nonce", "1544208801.71", "no");
INSERT INTO `wp_options` VALUES("125879", "ossdl_off_blog_url", "http://67.23.236.217/~windriftmotel", "yes");
INSERT INTO `wp_options` VALUES("131330", "wpseo_license_server_version", "2", "yes");
INSERT INTO `wp_options` VALUES("132406", "wdp_un_autoupdate_schedule", "a:486:{i:0;i:119;i:1;i:119;i:2;i:119;i:3;i:119;i:4;i:119;i:5;i:119;i:6;i:119;i:7;i:119;i:8;i:119;i:9;i:119;i:10;i:119;i:11;i:119;i:12;i:119;i:13;i:119;i:14;i:119;i:15;i:119;i:16;i:119;i:17;i:119;i:18;i:119;i:19;i:119;i:20;i:119;i:21;i:119;i:22;i:119;i:23;i:119;i:24;i:119;i:25;i:119;i:26;i:119;i:27;i:119;i:28;i:119;i:29;i:119;i:30;i:119;i:31;i:119;i:32;i:119;i:33;i:119;i:34;i:119;i:35;i:119;i:36;i:119;i:37;i:119;i:38;i:119;i:39;i:119;i:40;i:119;i:41;i:119;i:42;i:119;i:43;i:119;i:44;i:119;i:45;i:119;i:46;i:119;i:47;i:119;i:48;i:119;i:49;i:119;i:50;i:119;i:51;i:119;i:52;i:119;i:53;i:119;i:54;i:119;i:55;i:119;i:56;i:119;i:57;i:119;i:58;i:119;i:59;i:119;i:60;i:119;i:61;i:119;i:62;i:119;i:63;i:119;i:64;i:119;i:65;i:119;i:66;i:119;i:67;i:119;i:68;i:119;i:69;i:119;i:70;i:119;i:71;i:119;i:72;i:119;i:73;i:119;i:74;i:119;i:75;i:119;i:76;i:119;i:77;i:119;i:78;i:119;i:79;i:119;i:80;i:119;i:81;i:119;i:82;i:119;i:83;i:119;i:84;i:119;i:85;i:119;i:86;i:119;i:87;i:119;i:88;i:119;i:89;i:119;i:90;i:119;i:91;i:119;i:92;i:119;i:93;i:119;i:94;i:119;i:95;i:119;i:96;i:119;i:97;i:119;i:98;i:119;i:99;i:119;i:100;i:119;i:101;i:119;i:102;i:119;i:103;i:119;i:104;i:119;i:105;i:119;i:106;i:119;i:107;i:119;i:108;i:119;i:109;i:119;i:110;i:119;i:111;i:119;i:112;i:119;i:113;i:119;i:114;i:119;i:115;i:119;i:116;i:119;i:117;i:119;i:118;i:119;i:119;i:119;i:120;i:119;i:121;i:119;i:122;i:119;i:123;i:119;i:124;i:119;i:125;i:119;i:126;i:119;i:127;i:119;i:128;i:119;i:129;i:119;i:130;i:119;i:131;i:119;i:132;i:119;i:133;i:119;i:134;i:119;i:135;i:119;i:136;i:119;i:137;i:119;i:138;i:119;i:139;i:119;i:140;i:119;i:141;i:119;i:142;i:119;i:143;i:119;i:144;i:119;i:145;i:119;i:146;i:119;i:147;i:119;i:148;i:119;i:149;i:119;i:150;i:119;i:151;i:119;i:152;i:119;i:153;i:119;i:154;i:119;i:155;i:119;i:156;i:119;i:157;i:119;i:158;i:119;i:159;i:119;i:160;i:119;i:161;i:119;i:162;i:119;i:163;i:119;i:164;i:119;i:165;i:119;i:166;i:119;i:167;i:119;i:168;i:119;i:169;i:119;i:170;i:119;i:171;i:119;i:172;i:119;i:173;i:119;i:174;i:119;i:175;i:119;i:176;i:119;i:177;i:119;i:178;i:119;i:179;i:119;i:180;i:119;i:181;i:119;i:182;i:119;i:183;i:119;i:184;i:119;i:185;i:119;i:186;i:119;i:187;i:119;i:188;i:119;i:189;i:119;i:190;i:119;i:191;i:119;i:192;i:119;i:193;i:119;i:194;i:119;i:195;i:119;i:196;i:119;i:197;i:119;i:198;i:119;i:199;i:119;i:200;i:119;i:201;i:119;i:202;i:119;i:203;i:119;i:204;i:119;i:205;i:119;i:206;i:119;i:207;i:119;i:208;i:119;i:209;i:119;i:210;i:119;i:211;i:119;i:212;i:119;i:213;i:119;i:214;i:119;i:215;i:119;i:216;i:119;i:217;i:119;i:218;i:119;i:219;i:119;i:220;i:119;i:221;i:119;i:222;i:119;i:223;i:119;i:224;i:119;i:225;i:119;i:226;i:119;i:227;i:119;i:228;i:119;i:229;i:119;i:230;i:119;i:231;i:119;i:232;i:119;i:233;i:119;i:234;i:119;i:235;i:119;i:236;i:119;i:237;i:119;i:238;i:119;i:239;i:119;i:240;i:119;i:241;i:119;i:242;i:119;i:243;i:119;i:244;i:119;i:245;i:119;i:246;i:119;i:247;i:119;i:248;i:119;i:249;i:119;i:250;i:119;i:251;i:119;i:252;i:119;i:253;i:119;i:254;i:119;i:255;i:119;i:256;i:119;i:257;i:119;i:258;i:119;i:259;i:119;i:260;i:119;i:261;i:119;i:262;i:119;i:263;i:119;i:264;i:119;i:265;i:119;i:266;i:119;i:267;i:119;i:268;i:119;i:269;i:119;i:270;i:119;i:271;i:119;i:272;i:119;i:273;i:119;i:274;i:119;i:275;i:119;i:276;i:119;i:277;i:119;i:278;i:119;i:279;i:119;i:280;i:119;i:281;i:119;i:282;i:119;i:283;i:119;i:284;i:119;i:285;i:119;i:286;i:119;i:287;i:119;i:288;i:119;i:289;i:119;i:290;i:119;i:291;i:119;i:292;i:119;i:293;i:119;i:294;i:119;i:295;i:119;i:296;i:119;i:297;i:119;i:298;i:119;i:299;i:119;i:300;i:119;i:301;i:119;i:302;i:119;i:303;i:119;i:304;i:119;i:305;i:119;i:306;i:119;i:307;i:119;i:308;i:119;i:309;i:119;i:310;i:119;i:311;i:119;i:312;i:119;i:313;i:119;i:314;i:119;i:315;i:119;i:316;i:119;i:317;i:119;i:318;i:119;i:319;i:119;i:320;i:119;i:321;i:119;i:322;i:119;i:323;i:119;i:324;i:119;i:325;i:119;i:326;i:119;i:327;i:119;i:328;i:119;i:329;i:119;i:330;i:119;i:331;i:119;i:332;i:119;i:333;i:119;i:334;i:119;i:335;i:119;i:336;i:119;i:337;i:119;i:338;i:119;i:339;i:119;i:340;i:119;i:341;i:119;i:342;i:119;i:343;i:119;i:344;i:119;i:345;i:119;i:346;i:119;i:347;i:119;i:348;i:119;i:349;i:119;i:350;i:119;i:351;i:119;i:352;i:119;i:353;i:119;i:354;i:119;i:355;i:119;i:356;i:119;i:357;i:119;i:358;i:119;i:359;i:119;i:360;i:119;i:361;i:119;i:362;i:119;i:363;i:119;i:364;i:119;i:365;i:119;i:366;i:119;i:367;i:119;i:368;i:119;i:369;i:119;i:370;i:119;i:371;i:119;i:372;i:119;i:373;i:119;i:374;i:119;i:375;i:119;i:376;i:119;i:377;i:119;i:378;i:119;i:379;i:119;i:380;i:119;i:381;i:119;i:382;i:119;i:383;i:119;i:384;i:119;i:385;i:119;i:386;i:119;i:387;i:119;i:388;i:119;i:389;i:119;i:390;i:119;i:391;i:119;i:392;i:119;i:393;i:119;i:394;i:119;i:395;i:119;i:396;i:119;i:397;i:119;i:398;i:119;i:399;i:119;i:400;i:119;i:401;i:119;i:402;i:119;i:403;i:119;i:404;i:119;i:405;i:119;i:406;i:119;i:407;i:119;i:408;i:119;i:409;i:119;i:410;i:119;i:411;i:119;i:412;i:119;i:413;i:119;i:414;i:119;i:415;i:119;i:416;i:119;i:417;i:119;i:418;i:119;i:419;i:119;i:420;i:119;i:421;i:119;i:422;i:119;i:423;i:119;i:424;i:119;i:425;i:119;i:426;i:119;i:427;i:119;i:428;i:119;i:429;i:119;i:430;i:119;i:431;i:119;i:432;i:119;i:433;i:119;i:434;i:119;i:435;i:119;i:436;i:119;i:437;i:119;i:438;i:119;i:439;i:119;i:440;i:119;i:441;i:119;i:442;i:119;i:443;i:119;i:444;i:119;i:445;i:119;i:446;i:119;i:447;i:119;i:448;i:119;i:449;i:119;i:450;i:119;i:451;i:119;i:452;i:119;i:453;i:119;i:454;i:119;i:455;i:119;i:456;i:119;i:457;i:119;i:458;i:119;i:459;i:119;i:460;i:119;i:461;i:119;i:462;i:119;i:463;i:119;i:464;i:119;i:465;i:119;i:466;i:119;i:467;i:119;i:468;i:119;i:469;i:119;i:470;i:119;i:471;i:119;i:472;i:119;i:473;i:119;i:474;i:119;i:475;i:119;i:476;i:119;i:477;i:119;i:478;i:119;i:479;i:119;i:480;i:119;i:481;i:119;i:482;i:119;i:483;i:119;i:484;i:119;i:485;i:119;}", "no");
INSERT INTO `wp_options` VALUES("135792", "wdp_un_refresh_profile_flag", "0", "no");
INSERT INTO `wp_options` VALUES("136124", "wpseo-gsc", "a:1:{s:7:\"profile\";s:34:\"https://www.econolodgeloon.com/wp/\";}", "yes");
INSERT INTO `wp_options` VALUES("136127", "wpseo_gsc_issues_counts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("152495", "wpseo_gsc_last_fetch", "1539464276", "no");
INSERT INTO `wp_options` VALUES("136342", "wd_db_version", "2.0", "no");
INSERT INTO `wp_options` VALUES("136343", "defenderLockoutNeedUpdateLog", "1", "no");
INSERT INTO `wp_options` VALUES("140158", "smush_option", "a:1:{s:7:\"version\";s:5:\"3.0.1\";}", "yes");
INSERT INTO `wp_options` VALUES("136355", "wpmudev_snapshot", "a:4:{s:5:\"items\";a:0:{}s:6:\"config\";a:8:{s:11:\"segmentSize\";i:1000;s:11:\"memoryLimit\";s:4:\"256M\";s:14:\"errorReporting\";a:3:{i:1;a:2:{s:4:\"stop\";b:1;s:3:\"log\";b:1;}i:2;a:1:{s:3:\"log\";b:1;}i:8;a:1:{s:3:\"log\";b:1;}}s:10:\"zipLibrary\";s:10:\"ZipArchive\";s:14:\"absoluteFolder\";b:0;s:12:\"backupFolder\";s:9:\"snapshots\";s:11:\"tables_last\";a:0:{}s:4:\"full\";a:4:{s:6:\"active\";b:0;s:9:\"frequency\";b:0;s:13:\"schedule_time\";b:0;s:10:\"secret-key\";b:0;}}s:12:\"destinations\";a:1:{s:5:\"local\";a:2:{s:4:\"name\";s:14:\"Local Snapshot\";s:4:\"type\";s:5:\"local\";}}s:7:\"version\";s:7:\"3.1.9.2\";}", "yes");
INSERT INTO `wp_options` VALUES("136860", "wd_audit_settings", "a:8:{s:7:\"enabled\";b:0;s:9:\"frequency\";s:1:\"7\";s:3:\"day\";s:6:\"sunday\";s:4:\"time\";s:4:\"0:00\";s:12:\"notification\";b:1;s:8:\"receipts\";a:0:{}s:5:\"dummy\";a:0:{}s:14:\"lastReportSent\";i:1544370231;}", "no");
INSERT INTO `wp_options` VALUES("155057", "_transient_timeout_feed_mod_ed19c82afc485f0c670fda1dff039e68", "1544525462", "no");
INSERT INTO `wp_options` VALUES("155058", "_transient_feed_mod_ed19c82afc485f0c670fda1dff039e68", "1544482262", "no");
INSERT INTO `wp_options` VALUES("136083", "new_admin_email", "info@touristmarketing.com", "yes");
INSERT INTO `wp_options` VALUES("154607", "wp_page_for_privacy_policy", "0", "yes");
INSERT INTO `wp_options` VALUES("154608", "show_comments_cookies_opt_in", "0", "yes");
INSERT INTO `wp_options` VALUES("154615", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:57:\"https://downloads.wordpress.org/release/wordpress-5.0.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:57:\"https://downloads.wordpress.org/release/wordpress-5.0.zip\";s:10:\"no_content\";s:68:\"https://downloads.wordpress.org/release/wordpress-5.0-no-content.zip\";s:11:\"new_bundled\";s:69:\"https://downloads.wordpress.org/release/wordpress-5.0-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:3:\"5.0\";s:7:\"version\";s:3:\"5.0\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.0\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1544546062;s:15:\"version_checked\";s:3:\"5.0\";s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("152182", "_transient_timeout_wpseo_link_table_inaccessible", "1570983012", "no");
INSERT INTO `wp_options` VALUES("152183", "_transient_wpseo_link_table_inaccessible", "0", "no");
INSERT INTO `wp_options` VALUES("152184", "_transient_timeout_wpseo_meta_table_inaccessible", "1570983012", "no");
INSERT INTO `wp_options` VALUES("152185", "_transient_wpseo_meta_table_inaccessible", "0", "no");
INSERT INTO `wp_options` VALUES("155104", "_transient_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9", "1544541032", "no");
INSERT INTO `wp_options` VALUES("155102", "_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "1544584232", "no");
INSERT INTO `wp_options` VALUES("155103", "_transient_timeout_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9", "1544584232", "no");
INSERT INTO `wp_options` VALUES("154949", "_site_transient_timeout_available_translations", "1544479539", "no");
INSERT INTO `wp_options` VALUES("154950", "_site_transient_available_translations", "a:114:{s:2:\"af\";a:8:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-04 14:53:20\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/5.0/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-08 00:58:19\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/5.0/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:5:\"4.7.7\";s:7:\"updated\";s:19:\"2017-01-26 15:42:35\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.7/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"as\";a:8:{s:8:\"language\";s:2:\"as\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-22 18:59:07\";s:12:\"english_name\";s:8:\"Assamese\";s:11:\"native_name\";s:21:\"অসমীয়া\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/as.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"as\";i:2;s:3:\"asm\";i:3;s:3:\"asm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:0:\"\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-12 20:34:31\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-06 00:09:27\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"bel\";a:8:{s:8:\"language\";s:3:\"bel\";s:7:\"version\";s:5:\"4.9.5\";s:7:\"updated\";s:19:\"2018-04-04 08:43:29\";s:12:\"english_name\";s:10:\"Belarusian\";s:11:\"native_name\";s:29:\"Беларуская мова\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.5/bel.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"be\";i:2;s:3:\"bel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Працягнуць\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-05 11:20:36\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.0/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Напред\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:5:\"4.8.6\";s:7:\"updated\";s:19:\"2017-10-01 12:57:10\";s:12:\"english_name\";s:7:\"Bengali\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.8.6/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:23:\"এগিয়ে চল.\";}}s:2:\"bo\";a:8:{s:8:\"language\";s:2:\"bo\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-10 09:07:39\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/5.0/bo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"མུ་མཐུད།\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-04 20:20:28\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-07 16:11:33\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/5.0/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-02 17:25:51\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:5:\"4.9.8\";s:7:\"updated\";s:19:\"2018-10-28 17:08:36\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.9.8/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-06 17:01:33\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/5.0/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"4.9.7\";s:7:\"updated\";s:19:\"2018-07-06 08:46:24\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.9.7/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsæt\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-05 17:02:13\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/5.0/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-05 17:04:22\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.0/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-04 07:25:05\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/5.0/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-04 07:23:42\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.0/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:3:\"dzo\";a:8:{s:8:\"language\";s:3:\"dzo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-06-29 08:59:03\";s:12:\"english_name\";s:8:\"Dzongkha\";s:11:\"native_name\";s:18:\"རྫོང་ཁ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"dz\";i:2;s:3:\"dzo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:0:\"\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"4.9.8\";s:7:\"updated\";s:19:\"2018-11-27 15:33:27\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.9.8/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-11-30 21:09:16\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.0/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-10 07:52:38\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.0/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-10 12:55:26\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.0/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-10 14:53:14\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.0/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-11-30 21:08:59\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.0/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-03 20:07:23\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/5.0/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-07 18:38:30\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.0/es_MX.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-06 12:47:45\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.0/es_VE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CR\";a:8:{s:8:\"language\";s:5:\"es_CR\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-06 21:26:01\";s:12:\"english_name\";s:20:\"Spanish (Costa Rica)\";s:11:\"native_name\";s:22:\"Español de Costa Rica\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.0/es_CR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:5:\"4.9.2\";s:7:\"updated\";s:19:\"2017-11-15 23:17:08\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.9.2/es_CO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:5:\"4.9.2\";s:7:\"updated\";s:19:\"2017-11-15 15:03:42\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.9.2/es_GT.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-09 09:36:22\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/es_PE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-04 12:38:49\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.0/es_CL.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-05 21:26:56\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.0/es_AR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-10 10:16:04\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.0/es_ES.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:9:\"5.0-beta3\";s:7:\"updated\";s:19:\"2018-11-28 16:04:33\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.0-beta3/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:5:\"4.9.2\";s:7:\"updated\";s:19:\"2017-12-09 21:12:23\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.9.2/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"4.9.8\";s:7:\"updated\";s:19:\"2018-10-04 08:05:41\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.9.8/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-05 17:32:29\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/5.0/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-07 11:01:03\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.0/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"4.9.8\";s:7:\"updated\";s:19:\"2018-11-08 18:24:55\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.9.8/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:5:\"4.9.5\";s:7:\"updated\";s:19:\"2018-01-31 11:16:06\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.9.5/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:3:\"fur\";a:8:{s:8:\"language\";s:3:\"fur\";s:7:\"version\";s:5:\"4.8.6\";s:7:\"updated\";s:19:\"2018-01-29 17:32:35\";s:12:\"english_name\";s:8:\"Friulian\";s:11:\"native_name\";s:8:\"Friulian\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.8.6/fur.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"fur\";i:3;s:3:\"fur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-08-23 17:41:37\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-01 01:55:30\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.0/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"gu\";a:8:{s:8:\"language\";s:2:\"gu\";s:7:\"version\";s:5:\"4.9.8\";s:7:\"updated\";s:19:\"2018-09-14 12:33:48\";s:12:\"english_name\";s:8:\"Gujarati\";s:11:\"native_name\";s:21:\"ગુજરાતી\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.9.8/gu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gu\";i:2;s:3:\"guj\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:31:\"ચાલુ રાખવું\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4.2/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"4.9.8\";s:7:\"updated\";s:19:\"2018-12-09 10:32:06\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.9.8/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"המשך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"4.9.7\";s:7:\"updated\";s:19:\"2018-06-17 09:33:44\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.9.7/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"जारी\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-08 14:24:52\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/5.0/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-09 13:59:19\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.0/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Folytatás\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-03 16:21:10\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"4.9.8\";s:7:\"updated\";s:19:\"2018-07-28 13:16:13\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.9.8/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:6:\"4.7.11\";s:7:\"updated\";s:19:\"2018-09-20 11:13:37\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.7.11/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-08 07:14:52\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.0/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-10 05:25:01\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/5.0/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"続ける\";}}s:5:\"jv_ID\";a:8:{s:8:\"language\";s:5:\"jv_ID\";s:7:\"version\";s:5:\"4.9.5\";s:7:\"updated\";s:19:\"2018-03-24 13:53:29\";s:12:\"english_name\";s:8:\"Javanese\";s:11:\"native_name\";s:9:\"Basa Jawa\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.9.5/jv_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"jv\";i:2;s:3:\"jav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Nerusaké\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:5:\"4.9.8\";s:7:\"updated\";s:19:\"2018-11-02 06:28:35\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.9.8/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:3:\"kab\";a:8:{s:8:\"language\";s:3:\"kab\";s:7:\"version\";s:5:\"4.9.8\";s:7:\"updated\";s:19:\"2018-09-21 14:15:57\";s:12:\"english_name\";s:6:\"Kabyle\";s:11:\"native_name\";s:9:\"Taqbaylit\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.8/kab.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"kab\";i:3;s:3:\"kab\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Kemmel\";}}s:2:\"kk\";a:8:{s:8:\"language\";s:2:\"kk\";s:7:\"version\";s:5:\"4.9.5\";s:7:\"updated\";s:19:\"2018-03-12 08:08:32\";s:12:\"english_name\";s:6:\"Kazakh\";s:11:\"native_name\";s:19:\"Қазақ тілі\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.9.5/kk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kk\";i:2;s:3:\"kaz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Жалғастыру\";}}s:2:\"km\";a:8:{s:8:\"language\";s:2:\"km\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-07 02:07:59\";s:12:\"english_name\";s:5:\"Khmer\";s:11:\"native_name\";s:27:\"ភាសាខ្មែរ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/km.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"km\";i:2;s:3:\"khm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"បន្ត\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"4.9.8\";s:7:\"updated\";s:19:\"2018-11-22 02:28:45\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.9.8/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:3:\"ckb\";a:8:{s:8:\"language\";s:3:\"ckb\";s:7:\"version\";s:5:\"4.9.8\";s:7:\"updated\";s:19:\"2018-10-28 17:12:13\";s:12:\"english_name\";s:16:\"Kurdish (Sorani)\";s:11:\"native_name\";s:13:\"كوردی‎\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.8/ckb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ku\";i:3;s:3:\"ckb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"به‌رده‌وام به‌\";}}s:2:\"lo\";a:8:{s:8:\"language\";s:2:\"lo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 09:59:23\";s:12:\"english_name\";s:3:\"Lao\";s:11:\"native_name\";s:21:\"ພາສາລາວ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lo\";i:2;s:3:\"lao\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"ຕໍ່​ໄປ\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-07 15:00:16\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.0/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:2:\"lv\";a:8:{s:8:\"language\";s:2:\"lv\";s:7:\"version\";s:5:\"4.7.7\";s:7:\"updated\";s:19:\"2017-03-17 20:40:40\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:16:\"Latviešu valoda\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.7/lv.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lv\";i:2;s:3:\"lav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Turpināt\";}}s:5:\"mk_MK\";a:8:{s:8:\"language\";s:5:\"mk_MK\";s:7:\"version\";s:5:\"4.7.7\";s:7:\"updated\";s:19:\"2017-01-26 15:54:41\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.7/mk_MK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}}s:5:\"ml_IN\";a:8:{s:8:\"language\";s:5:\"ml_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:43:32\";s:12:\"english_name\";s:9:\"Malayalam\";s:11:\"native_name\";s:18:\"മലയാളം\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ml_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ml\";i:2;s:3:\"mal\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"തുടരുക\";}}s:2:\"mn\";a:8:{s:8:\"language\";s:2:\"mn\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-12 07:29:35\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:12:\"Монгол\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/mn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mn\";i:2;s:3:\"mon\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"Үргэлжлүүлэх\";}}s:2:\"mr\";a:8:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:5:\"4.8.6\";s:7:\"updated\";s:19:\"2018-02-13 07:38:55\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.8.6/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:5:\"4.9.8\";s:7:\"updated\";s:19:\"2018-08-30 20:27:25\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.9.8/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.1.20\";s:7:\"updated\";s:19:\"2015-03-26 15:57:42\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.1.20/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ဆောင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-08 03:19:05\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.0/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"ne_NP\";a:8:{s:8:\"language\";s:5:\"ne_NP\";s:7:\"version\";s:5:\"4.9.5\";s:7:\"updated\";s:19:\"2018-03-27 10:30:26\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:18:\"नेपाली\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.9.5/ne_NP.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ne\";i:2;s:3:\"nep\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:43:\"जारी राख्नुहोस्\";}}s:5:\"nl_BE\";a:8:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-04 07:59:37\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.0/nl_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-10 11:35:13\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.0/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:9:\"5.0-beta3\";s:7:\"updated\";s:19:\"2018-11-19 14:03:19\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:75:\"https://downloads.wordpress.org/translation/core/5.0-beta3/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-03 11:36:24\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.0/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:5:\"4.8.3\";s:7:\"updated\";s:19:\"2017-08-25 10:03:08\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.8.3/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pa_IN\";a:8:{s:8:\"language\";s:5:\"pa_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-16 05:19:43\";s:12:\"english_name\";s:7:\"Punjabi\";s:11:\"native_name\";s:18:\"ਪੰਜਾਬੀ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pa\";i:2;s:3:\"pan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ਜਾਰੀ ਰੱਖੋ\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-10 12:42:18\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.0/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.1.20\";s:7:\"updated\";s:19:\"2015-03-29 22:19:48\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1.20/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"دوام ورکړه\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-06 20:17:01\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.0/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"4.9.8\";s:7:\"updated\";s:19:\"2018-12-07 01:11:27\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.9.8/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:10:\"pt_PT_ao90\";a:8:{s:8:\"language\";s:10:\"pt_PT_ao90\";s:7:\"version\";s:5:\"4.9.5\";s:7:\"updated\";s:19:\"2018-03-09 09:30:48\";s:12:\"english_name\";s:27:\"Portuguese (Portugal, AO90)\";s:11:\"native_name\";s:17:\"Português (AO90)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/4.9.5/pt_PT_ao90.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"rhg\";a:8:{s:8:\"language\";s:3:\"rhg\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-16 13:03:18\";s:12:\"english_name\";s:8:\"Rohingya\";s:11:\"native_name\";s:8:\"Ruáinga\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"rhg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:0:\"\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-09 14:01:19\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.0/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-09 13:05:03\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.0/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:3:\"sah\";a:8:{s:8:\"language\";s:3:\"sah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-21 02:06:41\";s:12:\"english_name\";s:5:\"Sakha\";s:11:\"native_name\";s:14:\"Сахалыы\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"sah\";i:3;s:3:\"sah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Салҕаа\";}}s:5:\"si_LK\";a:8:{s:8:\"language\";s:5:\"si_LK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 06:00:52\";s:12:\"english_name\";s:7:\"Sinhala\";s:11:\"native_name\";s:15:\"සිංහල\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"si\";i:2;s:3:\"sin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:44:\"දිගටම කරගෙන යන්න\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-10 14:20:23\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.0/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:3:\"skr\";a:8:{s:8:\"language\";s:3:\"skr\";s:7:\"version\";s:9:\"5.0-beta3\";s:7:\"updated\";s:19:\"2018-11-16 03:41:29\";s:12:\"english_name\";s:7:\"Saraiki\";s:11:\"native_name\";s:14:\"سرائیکی\";s:7:\"package\";s:66:\"https://downloads.wordpress.org/translation/core/5.0-beta3/skr.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"skr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"جاری رکھو\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"4.9.2\";s:7:\"updated\";s:19:\"2018-01-04 13:33:13\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.9.2/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Nadaljuj\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-10 07:29:36\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/5.0/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-10 13:17:13\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.0/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-10 13:41:04\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.0/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:3:\"szl\";a:8:{s:8:\"language\";s:3:\"szl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-24 19:58:14\";s:12:\"english_name\";s:8:\"Silesian\";s:11:\"native_name\";s:17:\"Ślōnskŏ gŏdka\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"szl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:13:\"Kōntynuować\";}}s:5:\"ta_IN\";a:8:{s:8:\"language\";s:5:\"ta_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:22:47\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"தொடரவும்\";}}s:2:\"te\";a:8:{s:8:\"language\";s:2:\"te\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:47:39\";s:12:\"english_name\";s:6:\"Telugu\";s:11:\"native_name\";s:18:\"తెలుగు\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/te.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"te\";i:2;s:3:\"tel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"కొనసాగించు\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:5:\"4.9.5\";s:7:\"updated\";s:19:\"2018-03-02 17:08:41\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.9.5/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-30 02:38:08\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-06 22:56:16\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.0/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"tt_RU\";a:8:{s:8:\"language\";s:5:\"tt_RU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-20 20:20:50\";s:12:\"english_name\";s:5:\"Tatar\";s:11:\"native_name\";s:19:\"Татар теле\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tt\";i:2;s:3:\"tat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"дәвам итү\";}}s:3:\"tah\";a:8:{s:8:\"language\";s:3:\"tah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-06 18:39:39\";s:12:\"english_name\";s:8:\"Tahitian\";s:11:\"native_name\";s:10:\"Reo Tahiti\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ty\";i:2;s:3:\"tah\";i:3;s:3:\"tah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:0:\"\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:5:\"4.9.5\";s:7:\"updated\";s:19:\"2018-04-12 12:31:53\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:16:\"ئۇيغۇرچە\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.9.5/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-09 12:27:23\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/5.0/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"ur\";a:8:{s:8:\"language\";s:2:\"ur\";s:7:\"version\";s:5:\"4.9.8\";s:7:\"updated\";s:19:\"2018-12-03 09:18:37\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:8:\"اردو\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.9.8/ur.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ur\";i:2;s:3:\"urd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"جاری رکھیں\";}}s:5:\"uz_UZ\";a:8:{s:8:\"language\";s:5:\"uz_UZ\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-01 17:45:22\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:11:\"O‘zbekcha\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.0/uz_UZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uz\";i:2;s:3:\"uzb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Davom etish\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-08 02:52:12\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/5.0/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:3:\"5.0\";s:7:\"updated\";s:19:\"2018-12-10 09:42:42\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.0/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_HK\";a:8:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"4.9.5\";s:7:\"updated\";s:19:\"2018-04-09 00:56:52\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:16:\"香港中文版	\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.9.5/zh_HK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"4.9.2\";s:7:\"updated\";s:19:\"2017-11-17 22:20:52\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.9.2/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}}", "no");
INSERT INTO `wp_options` VALUES("140978", "wdfscanignore", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("154308", "rewrite_rules", "a:89:{s:19:\"sitemap_index\\.xml$\";s:19:\"index.php?sitemap=1\";s:31:\"([^/]+?)-sitemap([0-9]+)?\\.xml$\";s:51:\"index.php?sitemap=$matches[1]&sitemap_n=$matches[2]\";s:24:\"([a-z]+)?-?sitemap\\.xsl$\";s:25:\"index.php?xsl=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `wp_options` VALUES("152189", "_site_transient_update_themes", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1544546063;s:7:\"checked\";a:3:{s:16:\"tempera-nocopyrt\";s:3:\"0.1\";s:7:\"tempera\";s:5:\"1.7.0\";s:14:\"twentynineteen\";s:3:\"1.0\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("152224", "smush-directory-path-hash-updated", "1", "yes");
INSERT INTO `wp_options` VALUES("155122", "_transient_timeout_plugin_slugs", "1544632512", "no");
INSERT INTO `wp_options` VALUES("155123", "_transient_plugin_slugs", "a:14:{i:0;s:60:\"advanced-floating-content-lite/advanced-floating-content.php\";i:1;s:47:\"cryout-theme-settings/cryout-theme-settings.php\";i:2;s:27:\"wp-defender/wp-defender.php\";i:3;s:25:\"duplicator/duplicator.php\";i:4;s:33:\"wp-hummingbird/wp-hummingbird.php\";i:5;s:24:\"simple-lightbox/main.php\";i:6;s:25:\"wp-smush-pro/wp-smush.php\";i:7;s:21:\"snapshot/snapshot.php\";i:8;s:53:\"velvet-blues-update-urls/velvet-blues-update-urls.php\";i:9;s:23:\"wordfence/wordfence.php\";i:10;s:40:\"wpmudev-updates/update-notifications.php\";i:11;s:27:\"wp-super-cache/wp-cache.php\";i:12;s:43:\"wp-updates-settings/wp-updates-settings.php\";i:13;s:24:\"wordpress-seo/wp-seo.php\";}", "no");
INSERT INTO `wp_options` VALUES("155192", "snapshot_ajax_backup_run", "", "no");
INSERT INTO `wp_options` VALUES("155181", "duplicator_settings", "a:10:{s:7:\"version\";s:6:\"1.2.52\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:20:\"storage_htaccess_off\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("150840", "supercache_stats", "a:3:{s:9:\"generated\";i:1544210389;s:10:\"supercache\";a:5:{s:7:\"expired\";i:0;s:6:\"cached\";i:0;s:5:\"fsize\";i:0;s:11:\"cached_list\";a:0:{}s:12:\"expired_list\";a:0:{}}s:7:\"wpcache\";a:5:{s:7:\"expired\";i:0;s:6:\"cached\";i:0;s:5:\"fsize\";i:0;s:11:\"cached_list\";a:0:{}s:12:\"expired_list\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("140930", "cleanchecksum", "s:508065:\"a:3099:{s:32:\"5769b4024bf185b65cca19905a4c19c1\";s:61:\"/home/econolodge/public_html/wp/wp-content/advanced-cache.php\";s:32:\"44da4d3f124f07aa3263935d699d7dea\";s:98:\"/home/econolodge/public_html/wp/wp-content/plugins/cryout-theme-settings/cryout-theme-settings.php\";s:32:\"0c225ea684f304d25f6263cbe4fb4303\";s:86:\"/home/econolodge/public_html/wp/wp-content/plugins/cryout-theme-settings/inc/extra.php\";s:32:\"3221c4063ffb82759f1517626014d2da\";s:87:\"/home/econolodge/public_html/wp/wp-content/plugins/cryout-theme-settings/inc/mantra.php\";s:32:\"2c7742d6d0923742703825635082ef56\";s:88:\"/home/econolodge/public_html/wp/wp-content/plugins/cryout-theme-settings/inc/nirvana.php\";s:32:\"d9ebbac77031965a3b4566422af2bba8\";s:89:\"/home/econolodge/public_html/wp/wp-content/plugins/cryout-theme-settings/inc/parabola.php\";s:32:\"eeb7285f9c3353d4d1f793efa228956f\";s:89:\"/home/econolodge/public_html/wp/wp-content/plugins/cryout-theme-settings/inc/settings.php\";s:32:\"9a0a6afe3f2b4f3a0fec039fc3119303\";s:88:\"/home/econolodge/public_html/wp/wp-content/plugins/cryout-theme-settings/inc/tempera.php\";s:32:\"a6848f1c0433b769216aef4589e06573\";s:74:\"/home/econolodge/public_html/wp/wp-content/plugins/gotmls/images/index.php\";s:32:\"17a08c2a1f6f3d1adb33f7d8fb985e16\";s:67:\"/home/econolodge/public_html/wp/wp-content/plugins/gotmls/index.php\";s:32:\"dd3ae9c38cc1655c5eb9471fdf9b6162\";s:77:\"/home/econolodge/public_html/wp/wp-content/plugins/gotmls/safe-load/index.php\";s:32:\"299ea44dd3d62091df25f641d56fcf17\";s:79:\"/home/econolodge/public_html/wp/wp-content/plugins/gotmls/safe-load/session.php\";s:32:\"50ff79ed2487ec3ee476cc7ce864f8f2\";s:77:\"/home/econolodge/public_html/wp/wp-content/plugins/gotmls/safe-load/trace.php\";s:32:\"0bd9290011bb57d7585ab0e942a8d467\";s:80:\"/home/econolodge/public_html/wp/wp-content/plugins/gotmls/safe-load/wp-login.php\";s:32:\"ffed418fc84dd205a382128b79de3c49\";s:83:\"/home/econolodge/public_html/wp/wp-content/plugins/gotmls/safe-load/wp-settings.php\";s:32:\"96137494913a1f730a592e8932af394e\";s:60:\"/home/econolodge/public_html/wp/wp-content/plugins/index.php\";s:32:\"407e45b48934e4a928a4b5893a27a8fe\";s:81:\"/home/econolodge/public_html/wp/wp-content/plugins/simple-lightbox/controller.php\";s:32:\"e7ac9f83007ab3286e01534b3fed4e1e\";s:80:\"/home/econolodge/public_html/wp/wp-content/plugins/simple-lightbox/functions.php\";s:32:\"f93790d0426e6bce8e692fe470a149c1\";s:91:\"/home/econolodge/public_html/wp/wp-content/plugins/simple-lightbox/includes/class.admin.php\";s:32:\"15eddbe862cc9c2693e7df297ee4d219\";s:98:\"/home/econolodge/public_html/wp/wp-content/plugins/simple-lightbox/includes/class.admin_action.php\";s:32:\"7ea9d4b97aed25e11f47e14040ded324\";s:96:\"/home/econolodge/public_html/wp/wp-content/plugins/simple-lightbox/includes/class.admin_menu.php\";s:32:\"282d984c04911e8314f1197c79cab313\";s:96:\"/home/econolodge/public_html/wp/wp-content/plugins/simple-lightbox/includes/class.admin_page.php\";s:32:\"4e2fa10b2219e0fe7fbd5dd960da7c2a\";s:99:\"/home/econolodge/public_html/wp/wp-content/plugins/simple-lightbox/includes/class.admin_section.php\";s:32:\"acce993078080a4d24625ab5703a4635\";s:96:\"/home/econolodge/public_html/wp/wp-content/plugins/simple-lightbox/includes/class.admin_view.php\";s:32:\"2186542dc50947325a753709cdeb51cd\";s:90:\"/home/econolodge/public_html/wp/wp-content/plugins/simple-lightbox/includes/class.base.php\";s:32:\"993c0c993221d925c7eb1f629506450e\";s:101:\"/home/econolodge/public_html/wp/wp-content/plugins/simple-lightbox/includes/class.base_collection.php\";s:32:\"11cd35d4df63d9b2ba364df48f28b0f4\";s:97:\"/home/econolodge/public_html/wp/wp-content/plugins/simple-lightbox/includes/class.base_object.php\";s:32:\"e4f837a6b9649b7fcf514a64da6ff66c\";s:107:\"/home/econolodge/public_html/wp/wp-content/plugins/simple-lightbox/includes/class.collection_controller.php\";s:32:\"ff4713913df0496647a3c4d8d3f6c670\";s:95:\"/home/econolodge/public_html/wp/wp-content/plugins/simple-lightbox/includes/class.component.php\";s:32:\"0fa74dc89f6cb6c75f181dc61dc38959\";s:101:\"/home/econolodge/public_html/wp/wp-content/plugins/simple-lightbox/includes/class.content_handler.php\";s:32:\"03ad91ba475ea13af34b38c882e8a464\";s:102:\"/home/econolodge/public_html/wp/wp-content/plugins/simple-lightbox/includes/class.content_handlers.php\";s:32:\"049fe126159edfdf51b5221e1b0fb8b5\";s:91:\"/home/econolodge/public_html/wp/wp-content/plugins/simple-lightbox/includes/class.field.php\";s:32:\"720197ce18acc8c5c68758601bac63cc\";s:96:\"/home/econolodge/public_html/wp/wp-content/plugins/simple-lightbox/includes/class.field_base.php\";s:32:\"27d9838d351c72f21a74bee80495c271\";s:102:\"/home/econolodge/public_html/wp/wp-content/plugins/simple-lightbox/includes/class.field_collection.php\";s:32:\"24e26b1db86f8ab18a0788f6adde2d9c\";s:96:\"/home/econolodge/public_html/wp/wp-content/plugins/simple-lightbox/includes/class.field_type.php\";s:32:\"979b36989d8fd6afdab1e6d6e6d8f905\";s:92:\"/home/econolodge/public_html/wp/wp-content/plugins/simple-lightbox/includes/class.fields.php\";s:32:\"586bfd376317be1cb6e2269296373d9e\";s:92:\"/home/econolodge/public_html/wp/wp-content/plugins/simple-lightbox/includes/class.option.php\";s:32:\"120f0f17856311ef46538fd735e9054c\";s:93:\"/home/econolodge/public_html/wp/wp-content/plugins/simple-lightbox/includes/class.options.php\";s:32:\"46b05270ce30b535abe646b684f26ee6\";s:98:\"/home/econolodge/public_html/wp/wp-content/plugins/simple-lightbox/includes/class.template_tag.php\";s:32:\"56d7fe1739cf355ba7a7d2ef83953b43\";s:99:\"/home/econolodge/public_html/wp/wp-content/plugins/simple-lightbox/includes/class.template_tags.php\";s:32:\"0b759981330263eb7395a06a3d348708\";s:91:\"/home/econolodge/public_html/wp/wp-content/plugins/simple-lightbox/includes/class.theme.php\";s:32:\"9972640bc8443b924b5501bbd45834d9\";s:92:\"/home/econolodge/public_html/wp/wp-content/plugins/simple-lightbox/includes/class.themes.php\";s:32:\"75d34bf539d39418e3d5dfdddcaef60a\";s:95:\"/home/econolodge/public_html/wp/wp-content/plugins/simple-lightbox/includes/class.utilities.php\";s:32:\"f33c71d2034eb6af52ad96bb0af043b7\";s:75:\"/home/econolodge/public_html/wp/wp-content/plugins/simple-lightbox/load.php\";s:32:\"130cf4c875b3d648c51a6c697741477f\";s:75:\"/home/econolodge/public_html/wp/wp-content/plugins/simple-lightbox/main.php\";s:32:\"3ede74d374bdff7ec15694cb34aa8aac\";s:98:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Controller/Full/Admin.php\";s:32:\"2d0e6604391e052251528a7109c92d3b\";s:97:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Controller/Full/Ajax.php\";s:32:\"2f842be2e79de151fe7e4d6957105a58\";s:97:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Controller/Full/Cron.php\";s:32:\"282543c8e8abc80fdf92be9144140d48\";s:96:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Controller/Full/Hub.php\";s:32:\"30bd4f0cc81209ffcce0205ad78fb629\";s:96:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Controller/Full/Log.php\";s:32:\"981be6c7e9d3d56bc66cb9b0308c6f0a\";s:101:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Controller/Full/Reporter.php\";s:32:\"30bbe6e7c864db501edd9e18a7399192\";s:92:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Controller/Full.php\";s:32:\"8e81e7f2047322464c862fae4a00e3bc\";s:86:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Exception.php\";s:32:\"8d9f6a833df87ad140259e560a0f6e00\";s:90:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Helper/Backup.php\";s:32:\"d27b1b1c8b9ec771f2ae58d5fa3f5fdf\";s:89:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Helper/Debug.php\";s:32:\"5097ae8ee98431099b7b6418afa68465\";s:86:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Helper/Fs.php\";s:32:\"24cd23f5b4af73b43c756b0acf1ac666\";s:90:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Helper/Locker.php\";s:32:\"faaf9b6625b74986d696899a61743594\";s:87:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Helper/Log.php\";s:32:\"5d0fd0f358f4698099bb72aeb96637fa\";s:90:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Helper/Logger.php\";s:32:\"9bfbe5a16c143eaddc9de965bea9769a\";s:92:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Helper/Recovery.php\";s:32:\"b9cd481a6ac7faeadc9d8cb8bc47b0a8\";s:91:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Helper/Restore.php\";s:32:\"ad11ba626e6ca1e3ca0464bf61e7bc72\";s:91:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Helper/Session.php\";s:32:\"7f159902ae73bd23e9a44295d96e107d\";s:90:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Helper/String.php\";s:32:\"aae1e5e845089e18d305a72757e9b26f\";s:90:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Helper/System.php\";s:32:\"d719c2fd247e3df2c855a57a19c04581\";s:86:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Helper/UI.php\";s:32:\"1832d0c331c053e65b6b3a5b295acbed\";s:91:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Helper/Utility.php\";s:32:\"81451b1baefd2e60de39991d73407a93\";s:96:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Helper/Zip/Abstract.php\";s:32:\"6745e41a6b8f29df20f8e5e43045b84c\";s:95:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Helper/Zip/Archive.php\";s:32:\"2a9f553d9c329ba138b212cdd33eaef2\";s:94:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Helper/Zip/Pclzip.php\";s:32:\"6ec003c859d9485904b8e1c3bd1c4c3a\";s:87:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Helper/Zip.php\";s:32:\"c9e1e3850a865cb6db3994d1450871ec\";s:91:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Bflister.php\";s:32:\"43a6c55280ff4c7be6aca349d2b74e2f\";s:98:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Database/Backup.php\";s:32:\"d90062bcb86f421beca743d3f3fb0523\";s:91:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Database.php\";s:32:\"15621f212ed554160a42568b72ffd75f\";s:102:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/Factory.php\";s:32:\"54c9a10d88bdd32a2feb3b335f72d7f9\";s:145:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/authentication/signable.interface.php\";s:32:\"2b4a36941dd921b3127d598408180d67\";s:150:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/authentication/signature_v2query.class.php\";s:32:\"4013c075b043766f6901823e9216d59d\";s:149:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/authentication/signature_v3json.class.php\";s:32:\"d6b04901f2cc44c01492dd0dc9993a17\";s:150:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/authentication/signature_v3query.class.php\";s:32:\"8b75c679995ab19b5d886672b397ce89\";s:149:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/authentication/signature_v4json.class.php\";s:32:\"caa39b836b7ca2fe005b534aabefad1b\";s:150:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/authentication/signature_v4query.class.php\";s:32:\"6a842778250b6008d536fa3d5390819a\";s:142:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/authentication/signer.abstract.php\";s:32:\"e2b3df86471be23860383be5f7835dce\";s:122:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/config.inc.php\";s:32:\"aedc1c44d0b3c725f554bb8d14af2886\";s:151:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/extensions/dynamodbsessionhandler.class.php\";s:32:\"fc20a89f391846412e0052a5354e2b12\";s:144:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/extensions/s3browserupload.class.php\";s:32:\"aa9e3a3be1c7a587ac59c4043790d1bb\";s:144:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/extensions/s3streamwrapper.class.php\";s:32:\"f0fa11f331556f51a2bda42e150e71b1\";s:140:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/lib/cachecore/cacheapc.class.php\";s:32:\"4568d1b01f0eb03ed8fcf9e334208d71\";s:141:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/lib/cachecore/cachecore.class.php\";s:32:\"44c7b8ed72c8636cdc89696c697eba20\";s:141:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/lib/cachecore/cachefile.class.php\";s:32:\"850e514a78d08e6d24835ac6a5ef461a\";s:139:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/lib/cachecore/cachemc.class.php\";s:32:\"eb94b32c6b80b51c9f595d1438c01032\";s:140:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/lib/cachecore/cachepdo.class.php\";s:32:\"4a20a77ee0eee33e0b17481c50714b18\";s:143:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/lib/cachecore/cachexcache.class.php\";s:32:\"a6bc1784c23a4f3ddc10da3eb33fa73e\";s:146:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/lib/cachecore/icachecore.interface.php\";s:32:\"b7090bfe5480a7e33976832b64c81e60\";s:138:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/lib/dom/ArrayToDOMDocument.php\";s:32:\"c97bb91a9e5e55ac3789686d6e2a7857\";s:134:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/lib/dom/Transmogrifier.php\";s:32:\"2490045a26e8bd5e44daac828d5ae5ba\";s:143:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/lib/requestcore/_tests/AllTests.php\";s:32:\"640b8161ed16d9a9ba8383806af10064\";s:145:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/lib/requestcore/requestcore.class.php\";s:32:\"a8fb0c7dc6ace135dbe591316f6bceb3\";s:131:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/lib/yaml/lib/sfYaml.php\";s:32:\"b45542f71602f49f86033aef349b17fa\";s:137:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/lib/yaml/lib/sfYamlDumper.php\";s:32:\"3d207514fb68eb86c3a07bdef57f6ab1\";s:137:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/lib/yaml/lib/sfYamlInline.php\";s:32:\"117037e7989299094c9d80a610ee489b\";s:137:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/lib/yaml/lib/sfYamlParser.php\";s:32:\"4b82c4213c9739397441945a35809689\";s:121:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/sdk.class.php\";s:32:\"1e01afc3c28094b96d750e637840ae9f\";s:129:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/services/as.class.php\";s:32:\"ed9e0b56b16f29939a8d8aa0f2bfb724\";s:141:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/services/cloudformation.class.php\";s:32:\"781fc2f9cd1afbe276f5bbd4466290cd\";s:137:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/services/cloudfront.class.php\";s:32:\"0814f3635905a96cdcca6a07af547692\";s:138:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/services/cloudsearch.class.php\";s:32:\"a0e6872507fe8c5f1f39d4e9afbd9d7e\";s:137:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/services/cloudwatch.class.php\";s:32:\"2ee5e87638065cba5f571a456ec696df\";s:135:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/services/dynamodb.class.php\";s:32:\"47fdafe0f20b616d6e5932e96b9e6357\";s:130:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/services/ec2.class.php\";s:32:\"ab770ef2c53e77897bfe6ed763e85cf9\";s:138:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/services/elasticache.class.php\";s:32:\"b2fc716d8befc3ebae7168d5be9d7f22\";s:143:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/services/elasticbeanstalk.class.php\";s:32:\"e7104541ac7be4f3453339f0fdd15a79\";s:130:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/services/elb.class.php\";s:32:\"e03ce6b9c79d46899b0628e07196ce81\";s:130:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/services/emr.class.php\";s:32:\"215aeaf95aa230e53ca46e7d77e55733\";s:130:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/services/iam.class.php\";s:32:\"8f9076ade5f0e94796eb761c6dc1f1db\";s:139:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/services/importexport.class.php\";s:32:\"b02203357111f7ef5db9995ca03a2f68\";s:130:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/services/rds.class.php\";s:32:\"7127b5fc1ea584f113815327b30695fc\";s:129:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/services/s3.class.php\";s:32:\"f23d397b0d2918134aff0580a0fe78e4\";s:130:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/services/sdb.class.php\";s:32:\"4937f199ba894eb2ff39ec5dce0914a5\";s:130:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/services/ses.class.php\";s:32:\"9761c289ee05c4ebdde6d1ff73199c7f\";s:130:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/services/sns.class.php\";s:32:\"1e54a9ac513e5d4ce3bd6139ddb0503d\";s:130:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/services/sqs.class.php\";s:32:\"b7617cf31c03904dc5a487c1a627490c\";s:141:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/services/storagegateway.class.php\";s:32:\"ae916c69702e08c08b9cc9069cab5ed6\";s:130:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/services/sts.class.php\";s:32:\"8e073f72b8f6fa1ba8902cf48e8266ae\";s:130:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/services/swf.class.php\";s:32:\"35862a282c22d57d6bb472c4d1116fea\";s:133:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/utilities/array.class.php\";s:32:\"c731744753efa77d754127cfa9db2018\";s:140:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/utilities/batchrequest.class.php\";s:32:\"d2884c5f0c6bc95748e2b92001bf24ca\";s:139:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/utilities/complextype.class.php\";s:32:\"34c8687c62271d105873d6aad4bf1034\";s:138:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/utilities/credential.class.php\";s:32:\"f388baf28cedb29b567cd8bc8a849a46\";s:139:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/utilities/credentials.class.php\";s:32:\"8c53794fd906b45cbdcdd8054fc85b43\";s:138:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/utilities/gzipdecode.class.php\";s:32:\"e30bdedbf295821519dc9fd694556075\";s:138:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/utilities/hadoopbase.class.php\";s:32:\"7fa74bfaa777655375aa803b4cb9b3cd\";s:143:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/utilities/hadoopbootstrap.class.php\";s:32:\"37ad3193743acf08d43b55ba9e8f6d7d\";s:138:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/utilities/hadoopstep.class.php\";s:32:\"ed9732436e8027efde30881f71bf21d8\";s:132:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/utilities/info.class.php\";s:32:\"b063bd71c7cfded3cf16128c198bf3d9\";s:132:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/utilities/json.class.php\";s:32:\"7ed14529debe0b74303df6bbdd79768e\";s:136:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/utilities/manifest.class.php\";s:32:\"f5ae408f14e9a4c309f705166c649c9b\";s:137:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/utilities/mimetypes.class.php\";s:32:\"4170ad4da74e0795f2b03d58772cae9e\";s:134:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/utilities/policy.class.php\";s:32:\"b586bbcfc604c9afc058f08431608cd8\";s:135:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/utilities/request.class.php\";s:32:\"3ff202b922aaac53cd802a1fd092aa6b\";s:136:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/utilities/response.class.php\";s:32:\"80afff1939f7fc22c9a1530637ed8fa5\";s:137:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/utilities/simplexml.class.php\";s:32:\"8a6d946682989455a65207cbe8b7239c\";s:141:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/utilities/stacktemplate.class.php\";s:32:\"157ac225551cce81324f36c97d5c8f0e\";s:138:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/utilities/stepconfig.class.php\";s:32:\"af0f4ab8afc39e2d3aa8b56b8f64e883\";s:137:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/AWSSDKforPHP/utilities/utilities.class.php\";s:32:\"bdbd7a6ab5e8a72a3c3c55003a655d33\";s:104:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/aws/index.php\";s:32:\"7f41b2043e0e236330d455fe6c1ba9da\";s:123:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/Dropbox/API.php\";s:32:\"2d50f27a00163c199ee20b28188b0ca7\";s:139:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/Dropbox/Exception/Forbidden.php\";s:32:\"e381fd11bd5ecfd6e939c702aabc1454\";s:138:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/Dropbox/Exception/NotFound.php\";s:32:\"2bda424f7c680dcf0ee74e35c118f45b\";s:139:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/Dropbox/Exception/OverQuota.php\";s:32:\"72c26cdabc295edc8b4aa36b3f989138\";s:142:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/Dropbox/Exception/RequestToken.php\";s:32:\"619d1c74167a6e11c214772fea2cdddb\";s:129:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/Dropbox/Exception.php\";s:32:\"22ba6525bd1eb57e0b01179bc82dc30b\";s:142:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/Dropbox/OAuth/Consumer/Dropbox.php\";s:32:\"2a1abf28f737500daca22a26b43decd9\";s:130:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/Dropbox/OAuth/Curl.php\";s:32:\"87d36b49912394705aea1b005d17a63b\";s:130:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/Dropbox/OAuth/PEAR.php\";s:32:\"a99e7b8bc3d872d2920cf15c9133501c\";s:129:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/Dropbox/OAuth/PHP.php\";s:32:\"8c0b2296c02a4ba098f6be0248bc7e0c\";s:135:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/Dropbox/OAuth/Wordpress.php\";s:32:\"a814e088be04db92142a6f157acef953\";s:130:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/Dropbox/OAuth/Zend.php\";s:32:\"87e2afe24d2d792b09d8c00c98fc15e9\";s:125:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/Dropbox/OAuth.php\";s:32:\"785ba6fce620f8472033ea5f591a2686\";s:128:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/Dropbox/autoload.php\";s:32:\"87addfde952bbdb73384ce728383deda\";s:171:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/PEAR_Includes/HTTP/OAuth/Consumer/Exception/InvalidResponse.php\";s:32:\"b44af4e89bde38452c2ce82fca2fe802\";s:153:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/PEAR_Includes/HTTP/OAuth/Consumer/Request.php\";s:32:\"bcf349206dcda4b1425f3cd3f06ce141\";s:154:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/PEAR_Includes/HTTP/OAuth/Consumer/Response.php\";s:32:\"ba9dd455e66b0e3d9c37bd87bb6edfbb\";s:145:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/PEAR_Includes/HTTP/OAuth/Consumer.php\";s:32:\"31f7dc7fd4d387d372035071cf3c09a7\";s:161:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/PEAR_Includes/HTTP/OAuth/Exception/NotImplemented.php\";s:32:\"e68649eebec8e6d9d182c4386c41aab2\";s:146:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/PEAR_Includes/HTTP/OAuth/Exception.php\";s:32:\"1f56037980f1f6a2966c98fa9c9b3b2b\";s:144:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/PEAR_Includes/HTTP/OAuth/Message.php\";s:32:\"c6ff2e5befab439c05e3b433def9b0c8\";s:170:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/PEAR_Includes/HTTP/OAuth/Provider/Exception/InvalidRequest.php\";s:32:\"7fc20b6185d02d01b5b73ad1541e1b76\";s:155:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/PEAR_Includes/HTTP/OAuth/Provider/Exception.php\";s:32:\"1de75f513951431a1b1f39069ca2abdb\";s:153:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/PEAR_Includes/HTTP/OAuth/Provider/Request.php\";s:32:\"a8a5091ba16375a85aafbc1cb6970f31\";s:154:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/PEAR_Includes/HTTP/OAuth/Provider/Response.php\";s:32:\"42a214f933542858a9f5325ece072fcd\";s:153:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/PEAR_Includes/HTTP/OAuth/Signature/Common.php\";s:32:\"7a2039157512ddbcdb727ee06b63952a\";s:156:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/PEAR_Includes/HTTP/OAuth/Signature/HMAC/SHA1.php\";s:32:\"e55b6442a00699066a6e015153f5a696\";s:156:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/PEAR_Includes/HTTP/OAuth/Signature/PLAINTEXT.php\";s:32:\"371718c9237ffd70aca150341b39b446\";s:155:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/PEAR_Includes/HTTP/OAuth/Signature/RSA/SHA1.php\";s:32:\"0bff28a4e1e423865356035f90b4c90d\";s:146:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/PEAR_Includes/HTTP/OAuth/Signature.php\";s:32:\"b888d372bf53f67e2b945eefe571b1b1\";s:161:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/PEAR_Includes/HTTP/OAuth/Store/Consumer/CacheLite.php\";s:32:\"4059256f775d900acfdd3bef241aa007\";s:161:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/PEAR_Includes/HTTP/OAuth/Store/Consumer/Interface.php\";s:32:\"7d47285b083d5dcde3c256b67efe8782\";s:147:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/PEAR_Includes/HTTP/OAuth/Store/Data.php\";s:32:\"285c2428d3cd5f33f50a7bfdf1f153d9\";s:136:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/PEAR_Includes/HTTP/OAuth.php\";s:32:\"134bcc523783bb92a1dcca68528934b3\";s:152:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/PEAR_Includes/HTTP/Request2/Adapter/Curl.php\";s:32:\"76fe4de5739a227dd718514561293a48\";s:152:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/PEAR_Includes/HTTP/Request2/Adapter/Mock.php\";s:32:\"4d12995416d2d210159960b8be21ce13\";s:154:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/PEAR_Includes/HTTP/Request2/Adapter/Socket.php\";s:32:\"ad960bec545338716128a7d2682c8363\";s:147:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/PEAR_Includes/HTTP/Request2/Adapter.php\";s:32:\"88bca86278b570e760d1b4bece6ebbb0\";s:149:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/PEAR_Includes/HTTP/Request2/CookieJar.php\";s:32:\"9b85c5d3c1fe554b143bed19600e7c7b\";s:149:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/PEAR_Includes/HTTP/Request2/Exception.php\";s:32:\"f73c63fdfe7688aed25445619e3facc4\";s:153:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/PEAR_Includes/HTTP/Request2/MultipartBody.php\";s:32:\"ca49ef3c68a3a8504315c190725ad14d\";s:152:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/PEAR_Includes/HTTP/Request2/Observer/Log.php\";s:32:\"51ad347f9667fe6bac99453150a176e5\";s:148:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/PEAR_Includes/HTTP/Request2/Response.php\";s:32:\"d4c8ecefc0bfa33b80d376876af47f0b\";s:139:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/PEAR_Includes/HTTP/Request2.php\";s:32:\"1aac7e0a5743d95472da53bfda4d0b39\";s:134:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/PEAR_Includes/Net/URL2.php\";s:32:\"bc5ad62ce11a960fb48b25816d2962ce\";s:140:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/includes/PEAR_Includes/PEAR/Exception.php\";s:32:\"826d16bd358a2a92de03cacf41c232ba\";s:108:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/index.php\";s:32:\"bfb0fdfa3aebcee856271f0782dc448d\";s:118:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/autoload.php\";s:32:\"b4c8ed3bd2d7ac02ee5a64f72d9f7260\";s:136:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/composer/autoload_classmap.php\";s:32:\"a134f0e4bb2f205f1f4de67fd8636318\";s:133:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/composer/autoload_files.php\";s:32:\"38d960f9ce2de78f864a458fe2bb9170\";s:132:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/composer/autoload_psr4.php\";s:32:\"05cbdcafab7239cfbd10781cf728e253\";s:132:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/composer/autoload_real.php\";s:32:\"a9a778d33a08ef3a83798709d98d7a7e\";s:134:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/composer/autoload_static.php\";s:32:\"489b7d81c79daac47934dc1d1f2c7b5a\";s:138:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/guzzle/src/Client.php\";s:32:\"cd98f11f5981d3daae8718e93d40a5ef\";s:147:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/guzzle/src/ClientInterface.php\";s:32:\"0ec3fe6eaea1bfb0cd31de41b6f4a228\";s:148:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/guzzle/src/Cookie/CookieJar.php\";s:32:\"37a263ba6795bb739c65ab39f5c3ffa8\";s:157:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/guzzle/src/Cookie/CookieJarInterface.php\";s:32:\"9edd3920eacc2114ee5270f1c749ef9d\";s:152:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/guzzle/src/Cookie/FileCookieJar.php\";s:32:\"2bfad92f6de3f1915242824b3039ffa1\";s:155:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/guzzle/src/Cookie/SessionCookieJar.php\";s:32:\"ff8e8d972f68334d466fdcd48483775a\";s:148:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/guzzle/src/Cookie/SetCookie.php\";s:32:\"c0e004a5a935dc9396552fc1b3cc9d3b\";s:162:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/guzzle/src/Exception/BadResponseException.php\";s:32:\"df4d101a311ca602614101d52a586abf\";s:157:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/guzzle/src/Exception/ClientException.php\";s:32:\"ff76744672c0a5005894f7f94fc2f2fe\";s:158:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/guzzle/src/Exception/ConnectException.php\";s:32:\"31215b34a0914f39e4b25a77c91daac2\";s:157:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/guzzle/src/Exception/GuzzleException.php\";s:32:\"39ab66cad50fd83ebd82a5f0c9ef8d02\";s:158:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/guzzle/src/Exception/RequestException.php\";s:32:\"e6e8fdfc7010e2e98f556794e13879f2\";s:155:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/guzzle/src/Exception/SeekException.php\";s:32:\"464145419ab4aeeded386d61b102b79f\";s:157:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/guzzle/src/Exception/ServerException.php\";s:32:\"6238b6f42b160c0141a0bb20f29847ec\";s:167:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/guzzle/src/Exception/TooManyRedirectsException.php\";s:32:\"1ae6543b42cf5610bf37cb9548069779\";s:159:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/guzzle/src/Exception/TransferException.php\";s:32:\"234796bd82367a50c9a84e4bc55e30cf\";s:151:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/guzzle/src/Handler/CurlFactory.php\";s:32:\"7d49d9b5027613260d5e1ff6fe6e5100\";s:160:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/guzzle/src/Handler/CurlFactoryInterface.php\";s:32:\"d4f87052d80c7d93c499b95081697f8d\";s:151:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/guzzle/src/Handler/CurlHandler.php\";s:32:\"5eab86d80d29944ed67cfd56b3a184b7\";s:156:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/guzzle/src/Handler/CurlMultiHandler.php\";s:32:\"17834a7e5d9c13ddd1eaee288238e242\";s:150:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/guzzle/src/Handler/EasyHandle.php\";s:32:\"2fcf0c97901928beed47bb5487437503\";s:151:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/guzzle/src/Handler/MockHandler.php\";s:32:\"0cb714799cdb2610976a9dff83d7ecd9\";s:145:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/guzzle/src/Handler/Proxy.php\";s:32:\"8e9254edf275a1549f0459f4e9b78ff6\";s:153:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/guzzle/src/Handler/StreamHandler.php\";s:32:\"c404e8229831d51799715049ee922a5a\";s:144:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/guzzle/src/HandlerStack.php\";s:32:\"ca3567bfe88dae7317c11abcafc44c08\";s:148:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/guzzle/src/MessageFormatter.php\";s:32:\"1037fc71e9a3d383408cc10de037b6c8\";s:142:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/guzzle/src/Middleware.php\";s:32:\"efd1902d04f3c53cba8162aee141089c\";s:136:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/guzzle/src/Pool.php\";s:32:\"eaef1f4d931e35f7a598c3c64f5f5968\";s:153:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/guzzle/src/PrepareBodyMiddleware.php\";s:32:\"7d2dd67001f5ad9656c9812367d4393a\";s:150:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/guzzle/src/RedirectMiddleware.php\";s:32:\"fcee95fd5bc6708d7274bc01ced25745\";s:146:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/guzzle/src/RequestOptions.php\";s:32:\"c1dcd264022b3d9e71a2b1a94755dc9a\";s:147:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/guzzle/src/RetryMiddleware.php\";s:32:\"d3181f41c4ccb45e11c0f3cf076d93c3\";s:145:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/guzzle/src/TransferStats.php\";s:32:\"4d61fa1a5e2bbb4df20091501698b6ef\";s:143:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/guzzle/src/UriTemplate.php\";s:32:\"c33c320c9760d34b316593cefc975ec0\";s:141:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/guzzle/src/functions.php\";s:32:\"ccb32d40a9b5d5ec4b186f9b80f9ec0c\";s:149:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/guzzle/src/functions_include.php\";s:32:\"c60bbca3d34f24ce999f1606bf4af3b7\";s:152:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/promises/src/AggregateException.php\";s:32:\"d766b6609b46e502b3ce82d968054e6a\";s:155:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/promises/src/CancellationException.php\";s:32:\"5a686f0dec39962ab376321932db2503\";s:143:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/promises/src/Coroutine.php\";s:32:\"095126a2e3655c542baaf41abff14f93\";s:145:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/promises/src/EachPromise.php\";s:32:\"061992af1d0e64ca2ee1691d222ca847\";s:150:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/promises/src/FulfilledPromise.php\";s:32:\"92ebe730a0c0d39add91772c60959a61\";s:141:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/promises/src/Promise.php\";s:32:\"70ac68b2a34e3c190e831526243394ac\";s:150:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/promises/src/PromiseInterface.php\";s:32:\"2eafed4efc69af77e2d95b6c4769046d\";s:151:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/promises/src/PromisorInterface.php\";s:32:\"05059f0bec57babd73b8131a96f26492\";s:149:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/promises/src/RejectedPromise.php\";s:32:\"664aad3dbf01c8844df3b414d8352c0f\";s:152:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/promises/src/RejectionException.php\";s:32:\"7302d5dafb120a629376e228ac413481\";s:143:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/promises/src/TaskQueue.php\";s:32:\"0caf85100cc017ff46afaf73bd32268d\";s:152:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/promises/src/TaskQueueInterface.php\";s:32:\"bef795afbd9d0120cc9c3e37f589bc8c\";s:143:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/promises/src/functions.php\";s:32:\"9cd8bfeadee4ee8dbddbea9212bce5d0\";s:151:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/promises/src/functions_include.php\";s:32:\"4737e721ede861c94df3169f193df905\";s:142:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/psr7/src/AppendStream.php\";s:32:\"1cdf99e3e9bfcbe2028aaf4453a59d1a\";s:142:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/psr7/src/BufferStream.php\";s:32:\"54a0089edfdc3556dc2c1058ef7e10d4\";s:143:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/psr7/src/CachingStream.php\";s:32:\"b656f9b81920f605664ed6dff6e5dd66\";s:144:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/psr7/src/DroppingStream.php\";s:32:\"1ca01a595f5f3754a009c9908da13756\";s:138:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/psr7/src/FnStream.php\";s:32:\"3d69484c57e065c0eb993109c6e6109c\";s:143:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/psr7/src/InflateStream.php\";s:32:\"b678ac5ae59252b8127060fd0bfeae1e\";s:144:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/psr7/src/LazyOpenStream.php\";s:32:\"e87704de06462d9c7898c3df56629090\";s:141:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/psr7/src/LimitStream.php\";s:32:\"38238583bb996b251963f77f98d44930\";s:142:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/psr7/src/MessageTrait.php\";s:32:\"9400c6ae6268fe0923c5032097dbaa7c\";s:145:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/psr7/src/MultipartStream.php\";s:32:\"a8332fea3e3029fffc9055276223924c\";s:142:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/psr7/src/NoSeekStream.php\";s:32:\"e2e674b1667159e60dc2103074839b25\";s:140:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/psr7/src/PumpStream.php\";s:32:\"6dcdbc81d3e570c887dcb6c3028d7b60\";s:137:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/psr7/src/Request.php\";s:32:\"12ef986e3633cea3c7ddffcf2ccadb4a\";s:138:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/psr7/src/Response.php\";s:32:\"55246045b893409fc0f001008da17a6b\";s:143:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/psr7/src/ServerRequest.php\";s:32:\"8889d969da168dd4448d71b1bfb1b2e6\";s:136:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/psr7/src/Stream.php\";s:32:\"4aa79ea1cdd00f0265aa34de38e26fb5\";s:150:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/psr7/src/StreamDecoratorTrait.php\";s:32:\"0788cf6b053deac4c95a24fc4ef7114e\";s:143:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/psr7/src/StreamWrapper.php\";s:32:\"d3914091c8ae17f746aff4a1ee093a0c\";s:142:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/psr7/src/UploadedFile.php\";s:32:\"edc7fa75b6bd21adefc6cd0f65603162\";s:133:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/psr7/src/Uri.php\";s:32:\"fcbdc07f56da6b7912f96ee79193459c\";s:143:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/psr7/src/UriNormalizer.php\";s:32:\"0ebb389554233ec1018ca128b014f024\";s:141:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/psr7/src/UriResolver.php\";s:32:\"709fba580fa57ed18ee0d81760926d68\";s:139:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/psr7/src/functions.php\";s:32:\"9ea0345a8d817edf4c62267b41fb6456\";s:147:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/guzzlehttp/psr7/src/functions_include.php\";s:32:\"bbbf53fc9a738cc450d13c94349d4a2e\";s:183:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Authentication/DropboxAuthHelper.php\";s:32:\"39d94fe358fcc464d3b7f98abe46a83c\";s:178:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Authentication/OAuth2Client.php\";s:32:\"7077bbb2a6687ac5c1891bb966cc0d80\";s:158:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Dropbox.php\";s:32:\"3a9f3a805e1260d2c0c43f25afe8aef4\";s:161:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/DropboxApp.php\";s:32:\"7ba0983530b79f9f9f3075e830728f61\";s:164:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/DropboxClient.php\";s:32:\"7c0580ec4834c84a6d9dc67800b7a958\";s:162:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/DropboxFile.php\";s:32:\"2fcb82a7bd3f85ba2008167da552564f\";s:165:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/DropboxRequest.php\";s:32:\"8c9ecab3dafd389da5ad2efa35de6e17\";s:166:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/DropboxResponse.php\";s:32:\"2c341b18f42662c5c6af67e59bb92a6f\";s:172:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/DropboxResponseToFile.php\";s:32:\"adc63353f258a132379a08a3f838f934\";s:184:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Exceptions/DropboxClientException.php\";s:32:\"c32f2d1b1cf2654f4275035f28559aff\";s:187:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Http/Clients/DropboxGuzzleHttpClient.php\";s:32:\"dbbcfeebd8f9addb992c047b05fbdf7d\";s:188:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Http/Clients/DropboxHttpClientFactory.php\";s:32:\"28a9b5422f3e325b3076f79b244c07ea\";s:190:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Http/Clients/DropboxHttpClientInterface.php\";s:32:\"66ee6ccbda07be7f8f743eb119648411\";s:174:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Http/DropboxRawResponse.php\";s:32:\"513e9f80145c65e7bb80c8d32ea10a1c\";s:176:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Http/RequestBodyInterface.php\";s:32:\"5b28850ff655d2548e2b86c9069f5cac\";s:178:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Http/RequestBodyJsonEncoded.php\";s:32:\"3fd8de8f9fdfdb17d40dd8956bb02d24\";s:173:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Http/RequestBodyStream.php\";s:32:\"a76c10e49450be8bf840cb9c9eba2da1\";s:169:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Models/AccessToken.php\";s:32:\"e9d893d0b3e7f7bc937d3d7f9a00837b\";s:165:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Models/Account.php\";s:32:\"e8a701df61219e27898f069bac4a8fb6\";s:169:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Models/AccountList.php\";s:32:\"28c35ec85155dfcc9a4ccbe8391df16b\";s:167:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Models/BaseModel.php\";s:32:\"d44e6e1b1f046e17280ee913f58bb5f1\";s:171:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Models/CopyReference.php\";s:32:\"f6e17186cf6d91af4b4cdeb224af6aea\";s:173:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Models/DeletedMetadata.php\";s:32:\"e6fec46522a11072d486f2bb695c349c\";s:162:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Models/File.php\";s:32:\"67674379ead3f19e2b669f23b748842e\";s:170:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Models/FileMetadata.php\";s:32:\"11b380fd6ba251cbfee1e466cf6ee299\";s:173:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Models/FileSharingInfo.php\";s:32:\"4ee513829ed9a3d78251bdbdfc735ce8\";s:172:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Models/FolderMetadata.php\";s:32:\"d032f715182942fc3394c5481611f44e\";s:175:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Models/FolderSharingInfo.php\";s:32:\"4cec57586f607e6744e77e863fb885e5\";s:167:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Models/MediaInfo.php\";s:32:\"8a6615463212469a55c2eb6e38d0de69\";s:171:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Models/MediaMetadata.php\";s:32:\"2c38b68d75f7d9c00e56266be9559445\";s:176:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Models/MetadataCollection.php\";s:32:\"f5c0580a0ba04638d7958ae8e36d2b3a\";s:173:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Models/ModelCollection.php\";s:32:\"5b667ff5ac0ae5b57213bbfb6c9e3cba\";s:170:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Models/ModelFactory.php\";s:32:\"a9e2c5f37be50b358bd1dc08bb70735e\";s:172:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Models/ModelInterface.php\";s:32:\"e2d534ea6c128676e9b22ed0169ab586\";s:171:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Models/PhotoMetadata.php\";s:32:\"3e2ed068745fc4932573f9d81a298105\";s:170:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Models/SearchResult.php\";s:32:\"fdd31d5273a364f15d969b17c1c7b9a9\";s:171:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Models/SearchResults.php\";s:32:\"c5d25bbc6064bfa4bc4e18738932d5da\";s:171:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Models/TemporaryLink.php\";s:32:\"682e70ddb6d46a4c7c13c395f9824f31\";s:167:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Models/Thumbnail.php\";s:32:\"c65a033c4359a5bad07e3e570201fa16\";s:171:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Models/VideoMetadata.php\";s:32:\"c97f567d4b601451e491495b7190509f\";s:187:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Security/McryptRandomStringGenerator.php\";s:32:\"b6084ad8542281df4f208881294196e8\";s:188:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Security/OpenSslRandomStringGenerator.php\";s:32:\"49035d0b2d53a07929adb8a896746a98\";s:188:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Security/RandomStringGeneratorFactory.php\";s:32:\"01157e7918728c3c6466c01eba5539d2\";s:190:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Security/RandomStringGeneratorInterface.php\";s:32:\"600c915539df5e0ae27003333fc027bc\";s:186:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Security/RandomStringGeneratorTrait.php\";s:32:\"2069c5ee5883b17ff731e0ca89952308\";s:183:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Store/PersistentDataStoreFactory.php\";s:32:\"9571fadf84edad95a43152e425e6428d\";s:185:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Store/PersistentDataStoreInterface.php\";s:32:\"c8d894944d32d914e766aba3af5cd907\";s:183:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/src/Dropbox/Store/SessionPersistentDataStore.php\";s:32:\"13180264811755222e4afcf780db7795\";s:156:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/kunalvarma05/dropbox-php-sdk/tests/DropboxTest.php\";s:32:\"4fe744d3c413f9483008dadbbe5e68db\";s:147:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/psr/http-message/src/MessageInterface.php\";s:32:\"7a7ec70975295bd2f84a93839410dbd4\";s:147:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/psr/http-message/src/RequestInterface.php\";s:32:\"6024834543ba6d4e406523d185947f94\";s:148:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/psr/http-message/src/ResponseInterface.php\";s:32:\"7aaa3b3986a054b0bd83ac668a913f23\";s:153:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/psr/http-message/src/ServerRequestInterface.php\";s:32:\"df860d7e1796e35040e2b85386765c1d\";s:146:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/psr/http-message/src/StreamInterface.php\";s:32:\"e196134c29b8d8298d61e43f9763bd68\";s:152:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/psr/http-message/src/UploadedFileInterface.php\";s:32:\"c227031798a61285f7e0ca5ffd093d8d\";s:143:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/psr/http-message/src/UriInterface.php\";s:32:\"7d4c6bd1a515137286ca1346833be891\";s:170:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/tightenco/collect/src/Illuminate/Contracts/Support/Arrayable.php\";s:32:\"7d4fdf13272ed6315587fdd43ba4c572\";s:169:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/tightenco/collect/src/Illuminate/Contracts/Support/Jsonable.php\";s:32:\"05066bd6a03afa9570a9c4df3df1d0f9\";s:154:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/tightenco/collect/src/Illuminate/Support/Arr.php\";s:32:\"237ed3bf1e1238ab87018dee5a8692c3\";s:161:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/tightenco/collect/src/Illuminate/Support/Collection.php\";s:32:\"a3dc3961b8050002aad44d3a908e6079\";s:177:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/tightenco/collect/src/Illuminate/Support/HigherOrderCollectionProxy.php\";s:32:\"b35128c5e27818a93bb4abd1c7241adb\";s:167:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/tightenco/collect/src/Illuminate/Support/Traits/Macroable.php\";s:32:\"e3582c96445dd7831775d4acc0f97aab\";s:158:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/tightenco/collect/src/Illuminate/Support/helpers.php\";s:32:\"52399ce52bf95312d6f8aaea086f9203\";s:163:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/tightenco/collect/tests/Support/SupportCollectionTest.php\";s:32:\"dafa8463e7859128f4c074fbb3acdfc7\";s:143:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/dropbox/vendor/tightenco/collect/tests/bootstrap.php\";s:32:\"b3ba12eb396df1d91bdbd4d7979f6870\";s:104:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/ftp/index.php\";s:32:\"e7295174f8358671ecfec2c07e44f064\";s:124:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/ftp/phpseclib1.0.10/Crypt/AES.php\";s:32:\"4567ce61a2af8a10a4210339bbfc3566\";s:125:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/ftp/phpseclib1.0.10/Crypt/Base.php\";s:32:\"3508e4f29cf8814a0193a172daffc8d8\";s:129:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/ftp/phpseclib1.0.10/Crypt/Blowfish.php\";s:32:\"2c604bfb98d6a5bf644101dab6e2e607\";s:124:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/ftp/phpseclib1.0.10/Crypt/DES.php\";s:32:\"9c2d99218fddb965250ea53b471ac5ac\";s:125:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/ftp/phpseclib1.0.10/Crypt/Hash.php\";s:32:\"0315d4d25c6fdeb4450aa0657d33173d\";s:124:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/ftp/phpseclib1.0.10/Crypt/RC2.php\";s:32:\"857a58940f9b7b7123f07af77148a422\";s:124:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/ftp/phpseclib1.0.10/Crypt/RC4.php\";s:32:\"e81d34d9ab539bc7d43856492827b4c4\";s:124:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/ftp/phpseclib1.0.10/Crypt/RSA.php\";s:32:\"b271c3f25b623d045e3b45e08a690c3c\";s:127:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/ftp/phpseclib1.0.10/Crypt/Random.php\";s:32:\"f48fab2903062f8639c7fb12103c7a54\";s:129:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/ftp/phpseclib1.0.10/Crypt/Rijndael.php\";s:32:\"fd9fbe2bdd297085ebb5b20c15a345dd\";s:130:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/ftp/phpseclib1.0.10/Crypt/TripleDES.php\";s:32:\"e38b81f6bcf10831df25ada6ad48fba1\";s:128:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/ftp/phpseclib1.0.10/Crypt/Twofish.php\";s:32:\"0bcb8aa78e4f4115eb8ff8202561eaba\";s:124:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/ftp/phpseclib1.0.10/File/ANSI.php\";s:32:\"0478c4474cd3bf2418ff2c91d7f06157\";s:124:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/ftp/phpseclib1.0.10/File/ASN1.php\";s:32:\"41a59f0d09a14ad483cbf6b80204a95b\";s:124:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/ftp/phpseclib1.0.10/File/X509.php\";s:32:\"52b32859911313bba9d30797472f1c94\";s:130:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/ftp/phpseclib1.0.10/Math/BigInteger.php\";s:32:\"0ed5b273971438b4d7ed04220e7cbbb9\";s:122:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/ftp/phpseclib1.0.10/Net/SCP.php\";s:32:\"507d0083234ae7753de721f8483a40c6\";s:130:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/ftp/phpseclib1.0.10/Net/SFTP/Stream.php\";s:32:\"28511439faffefa8add5d1f760f14ae9\";s:123:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/ftp/phpseclib1.0.10/Net/SFTP.php\";s:32:\"6ce8f192faec350b04985d307112630c\";s:123:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/ftp/phpseclib1.0.10/Net/SSH1.php\";s:32:\"ef7f7865d793cf8ee86d7051347cdc3a\";s:123:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/ftp/phpseclib1.0.10/Net/SSH2.php\";s:32:\"e3715b9b0b8c2841688a6c92acb59bc6\";s:131:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/ftp/phpseclib1.0.10/System/SSH/Agent.php\";s:32:\"9245e44009e5fbcd72b3fa7464db6e95\";s:131:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/ftp/phpseclib1.0.10/System/SSH_Agent.php\";s:32:\"4e3b01dacb7069f606ae6149ee49f04b\";s:124:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/ftp/phpseclib1.0.10/bootstrap.php\";s:32:\"6e877b29be2d775b57bfd7cbccb75dce\";s:128:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Auth/Abstract.php\";s:32:\"7f3ab28fd1be1199e82a4426d10fc636\";s:131:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Auth/AppIdentity.php\";s:32:\"acdd2e8b9f3a619a4876e793e010902d\";s:140:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Auth/AssertionCredentials.php\";s:32:\"34402717061a099125be67c73ed37f9f\";s:129:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Auth/Exception.php\";s:32:\"ebd45472e50e3df6a8a05e875b2d38b7\";s:131:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Auth/LoginTicket.php\";s:32:\"9e65edb60fe3701c6e6fa23ff341b39c\";s:126:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Auth/OAuth2.php\";s:32:\"0fa48c503b3c2475eba519dc1532b230\";s:126:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Auth/Simple.php\";s:32:\"95563bee4150b88028566da4ffb07e13\";s:129:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Cache/Abstract.php\";s:32:\"1ee25c94efd31919867a68e37a1e8b2a\";s:124:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Cache/Apc.php\";s:32:\"d3c57e5285cf685b92cc4687dd988858\";s:130:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Cache/Exception.php\";s:32:\"85a440dd88e340380d292a366e34a8ae\";s:125:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Cache/File.php\";s:32:\"e799e44320088271ffeb1c17c162ea5c\";s:129:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Cache/Memcache.php\";s:32:\"7550327aa96cd4a8c19b83ffdc372439\";s:125:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Cache/Null.php\";s:32:\"af8597594e66b91f6e0fda4f957a8bc9\";s:121:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Client.php\";s:32:\"7fd2a7372cff0423a23c1c501a935a99\";s:125:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Collection.php\";s:32:\"cda8ed0e198c4f87f8f1f5bd43ef9aba\";s:121:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Config.php\";s:32:\"2b6ec8b04d14b19a36f9347c4e7ba7ac\";s:124:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Exception.php\";s:32:\"12ee4a8dd49008d1aaa5952b7e9eeab9\";s:125:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Http/Batch.php\";s:32:\"eedf3cf98c288fdddd2d2403e8e8dae5\";s:131:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Http/CacheParser.php\";s:32:\"464f5a217fe4ca778de86ab3ef81b36e\";s:135:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Http/MediaFileUpload.php\";s:32:\"1bcc4f36e23fa9cc2f7e606a33c518af\";s:124:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Http/REST.php\";s:32:\"b6810089c013bc4cb06ab0281881ae4c\";s:127:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Http/Request.php\";s:32:\"66e3684ac9619b174b7cdb27c9c18b4c\";s:126:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/IO/Abstract.php\";s:32:\"e330014608c3393ef32dc9eb4ed2b50b\";s:122:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/IO/Curl.php\";s:32:\"c17e494037c8d9763f62a8908f8cbe06\";s:127:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/IO/Exception.php\";s:32:\"cafc32b3f32f24d745116953cf0dc5c2\";s:124:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/IO/Stream.php\";s:32:\"b8fdb8754d3dfb042228a3c12abe06bc\";s:120:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Model.php\";s:32:\"7c86e268213c098d13eae6851b14adb9\";s:138:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/AdExchangeBuyer.php\";s:32:\"2610c56f3c5020a4a611a016afcd1e09\";s:139:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/AdExchangeSeller.php\";s:32:\"808dd6b95ee1e0a50037e73e1d83189f\";s:130:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/AdSense.php\";s:32:\"5f928dcf35cf9a19841ee00cf3c69c5e\";s:134:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/AdSenseHost.php\";s:32:\"b5f54f9ff446166d950cfe3b2a2d40a0\";s:128:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Admin.php\";s:32:\"710cea1f103f0ccb42f3772dfdeeed59\";s:132:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Analytics.php\";s:32:\"36cb78b04701e3e2460d3c3103bcb1f8\";s:139:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/AndroidPublisher.php\";s:32:\"fcc15c19866c06ebf26047671109ad6a\";s:131:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/AppState.php\";s:32:\"e5616782c4532ac53994960e72b54359\";s:135:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Appsactivity.php\";s:32:\"9e3e36cfe3b1be56bdcbc5e75177dd38\";s:128:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Audit.php\";s:32:\"5ae6acbbfb529dd7d1d940162a1b8065\";s:133:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Autoscaler.php\";s:32:\"e36cd3b239d5c3c69f65fbdf8e506749\";s:131:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Bigquery.php\";s:32:\"9cb252579b254b0e7cb1f9ceb906672f\";s:130:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Blogger.php\";s:32:\"5053154594e96c67c726be086e046de5\";s:128:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Books.php\";s:32:\"32baa97e798b03fd03b7f7b6203ea02d\";s:131:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Calendar.php\";s:32:\"c4523599dc599b603f27ae205021f359\";s:132:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/CivicInfo.php\";s:32:\"408d160fd81d22f2738564d91bddfe10\";s:138:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Cloudmonitoring.php\";s:32:\"44f035747959f5344f28afbdb9e34252\";s:130:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Compute.php\";s:32:\"ce95007a9759c0e90f70cc3e146f6a9f\";s:133:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Coordinate.php\";s:32:\"25eee8fcd64dbfced03bb1b94843cd80\";s:135:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Customsearch.php\";s:32:\"d2d3e73855f9d184549937aaa9b84192\";s:132:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Datastore.php\";s:32:\"8ce3688a8d9220b5a29b7a6a384eb174\";s:135:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Dfareporting.php\";s:32:\"26af53255019b8e00498b9b7ffbb5520\";s:132:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Directory.php\";s:32:\"bcb7930bd23d8e29598fc893b5fa5e85\";s:126:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Dns.php\";s:32:\"883b948b42e7274280d9c9a5f85d5b76\";s:144:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/DoubleClickBidManager.php\";s:32:\"f9e81dc3282e27dac40c03c1ef9d8cd8\";s:140:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Doubleclicksearch.php\";s:32:\"3df9d3e124cc58a4d30f33d21cd45f42\";s:128:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Drive.php\";s:32:\"871c3acd653206e979a8e4fc60385b5d\";s:132:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Exception.php\";s:32:\"2b012ce21082977088fc304fa699cf6d\";s:131:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Freebase.php\";s:32:\"124a341de394414d0f3d2de1e741a132\";s:135:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Fusiontables.php\";s:32:\"ca7ff876f15e1fede7bc0e31574c5f7c\";s:128:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Games.php\";s:32:\"3e0a34ffccf74b62e48757c563bb1691\";s:138:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/GamesManagement.php\";s:32:\"6bf71896e5539445d2f245ca4e446832\";s:131:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Genomics.php\";s:32:\"9d27d98776d3c9cd0401657cf6a65926\";s:128:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Gmail.php\";s:32:\"f0adbc4815b1ce315dffccea69bebd17\";s:138:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/GroupsMigration.php\";s:32:\"d5b86335b30fe8534770373db683aab9\";s:137:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Groupssettings.php\";s:32:\"84dcc294d9a4436809447804b1334eb6\";s:138:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/IdentityToolkit.php\";s:32:\"b7a9bb80076972755251ca724e86a723\";s:132:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Licensing.php\";s:32:\"969b318f29717ae9c9ad5693877e8e1d\";s:130:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Manager.php\";s:32:\"c6855f7d6a6b6a4eb93923e1a27f7d34\";s:133:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/MapsEngine.php\";s:32:\"d8923fbe7a0ac440cdee4c05d0b260d7\";s:129:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Mirror.php\";s:32:\"e8101a139453f13468136b60ca7436e9\";s:129:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Oauth2.php\";s:32:\"3b77507ded4d1e4c7340a3e604375b56\";s:128:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Orkut.php\";s:32:\"7ec55e9d2e3ea2754352cf8c2aa33381\";s:138:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Pagespeedonline.php\";s:32:\"275dbc9cf54c1a65b46ec99ebfe50626\";s:127:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Plus.php\";s:32:\"a555d5b1a966d61403e9026b66a2e422\";s:134:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/PlusDomains.php\";s:32:\"0a848843101368980c4036a9d1098989\";s:133:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Prediction.php\";s:32:\"a6b9a7dad2a608caaf2cc4309815bc5b\";s:129:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Pubsub.php\";s:32:\"d4a0c35a7f48e5986dc2eef7129ee6c9\";s:133:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/QPXExpress.php\";s:32:\"e7a2be0e5d97aec458babc768b312f35\";s:134:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Replicapool.php\";s:32:\"07ea6954206a07960432af2cf0ae17cf\";s:130:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Reports.php\";s:32:\"8d152b17f3808a46731c6d003a7de319\";s:131:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Reseller.php\";s:32:\"539b9b3d971d0c552d2d46389430c5d5\";s:131:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Resource.php\";s:32:\"12a2b8fd69d7dc678ba43ef9249cec39\";s:136:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Resourceviews.php\";s:32:\"2248d7bc6bba68d8a668cd96b94e2493\";s:131:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/SQLAdmin.php\";s:32:\"8878ed7c18c97fce9664cdc4e3da547c\";s:138:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/ShoppingContent.php\";s:32:\"4ac1c395cb751789ea93dbb3c02063e4\";s:139:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/SiteVerification.php\";s:32:\"f4f240f7d8edff81dea315f86a1fa7ee\";s:131:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Spectrum.php\";s:32:\"8d9208a7571fef5a5d99a3a1ea99ae45\";s:130:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Storage.php\";s:32:\"8a687be4c99f275ea10f17e2194c2726\";s:132:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Taskqueue.php\";s:32:\"97bff2b08cde606c5d92441602b1033a\";s:128:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Tasks.php\";s:32:\"7842fff833a724dd5ecb67e144d11654\";s:132:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Translate.php\";s:32:\"d62ef33f913b8b20bede1745cc6180ae\";s:135:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Urlshortener.php\";s:32:\"656f2c62f83905742930e05bc635f802\";s:131:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/Webfonts.php\";s:32:\"c05ad6a4e8d64a1a4cccf5e7a19958b0\";s:130:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/YouTube.php\";s:32:\"1e43c87087dbe7fe5c2e2e9243621f03\";s:139:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service/YouTubeAnalytics.php\";s:32:\"723c99361674817583c126f497d30c18\";s:122:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Service.php\";s:32:\"42e85f2e1c5d3d551719a12ecf93c1b3\";s:130:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Signer/Abstract.php\";s:32:\"fca92d9f86df28c15fc36c2885f24cb3\";s:125:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Signer/P12.php\";s:32:\"aed23befb64ddd2a08a7de6fbb4e8ab4\";s:132:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Utils/URITemplate.php\";s:32:\"4ca69a56b5d23e3c8a5a98933b29e188\";s:120:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Utils.php\";s:32:\"45d667b3f3100026de9cdbd9396066ae\";s:132:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Verifier/Abstract.php\";s:32:\"bdddf17776e1dc696b0d6944624524ea\";s:127:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/Google/Verifier/Pem.php\";s:32:\"fd52292cbe6f0c2a28b06e507897b4ed\";s:113:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination/google-drive/index.php\";s:32:\"135a911636b4bd43a7058734853dca28\";s:94:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Destination.php\";s:32:\"01c8b7d5ab3206507d3c9619a304f3f1\";s:97:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Fileset/Config.php\";s:32:\"d57dd697aa196055b01dab9c5eebac7f\";s:95:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Fileset/Full.php\";s:32:\"b8513b63fd81c29543c49ba8517a7ed2\";s:99:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Fileset/Htaccess.php\";s:32:\"a0410ee2e6a86cbf5394c5797d417851\";s:96:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Fileset/Media.php\";s:32:\"9c65034c4ff797f45682953200d88d18\";s:100:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Fileset/Muplugins.php\";s:32:\"d13bfed4549fd43ec8c769a9a2feb9ae\";s:95:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Fileset/Null.php\";s:32:\"6c77af0cbdb7f90468bb40ce9374d5cf\";s:98:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Fileset/Plugins.php\";s:32:\"355cfbdf78a372a7eeecced3aa56cd9f\";s:97:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Fileset/Themes.php\";s:32:\"e4185512fcf90de1c2d9dcaeca0a5899\";s:90:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Fileset.php\";s:32:\"7e6eb8dadf852360d55fe75336a5cda1\";s:96:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Full/Abstract.php\";s:32:\"9c9733cd7dfb07931eec1507e3dc290f\";s:94:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Full/Backup.php\";s:32:\"f4b06d2a56ffec9e4d0b674b55b60871\";s:93:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Full/Error.php\";s:32:\"68fda3f975d2540fe225ecbf9bde58ee\";s:93:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Full/Local.php\";s:32:\"79caf45a3e092018dde2dc0c8937819b\";s:98:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Full/Remote/Api.php\";s:32:\"136a4571c1d8824b93066824c39ffe0a\";s:99:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Full/Remote/Help.php\";s:32:\"e091bc2265b6a251a6da482a858afd1b\";s:98:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Full/Remote/Key.php\";s:32:\"d7432de26f381b57a03975f574123dc5\";s:104:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Full/Remote/Signature.php\";s:32:\"28030fcd98e49fd3190aa0efdd930fb9\";s:102:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Full/Remote/Storage.php\";s:32:\"2c04ee0bf9cf19ebe031b246fa9f99a2\";s:94:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Full/Remote.php\";s:32:\"d28442f9364a72fe0c262a89e2941ff0\";s:87:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Full.php\";s:32:\"f1be0a5af5eed83c2388d21857070327\";s:91:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Manifest.php\";s:32:\"90a5706daabcaeed858ee8d540ba9de9\";s:87:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Post.php\";s:32:\"6014e1a6763d92035577b05229525d54\";s:98:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Queue/Bhfileset.php\";s:32:\"9e76e9a83055e04ac321910512f43c77\";s:96:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Queue/Fileset.php\";s:32:\"cfff623775c0ca905705512c872d36bd\";s:97:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Queue/Tableset.php\";s:32:\"d3efbaf6885a3fdc8ab976642317380f\";s:88:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Queue.php\";s:32:\"562aabfe52079125cb90822d8dab2ff7\";s:90:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Request.php\";s:32:\"6430591c77837512dea02fabc9254028\";s:98:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Storage/Session.php\";s:32:\"59fd4f91d7a394d2f58686021b4863d2\";s:99:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Storage/Sitemeta.php\";s:32:\"94eb91b0f34171740d939dded40a71af\";s:90:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Storage.php\";s:32:\"7163d45cc45c5f0cb35c8b588a4ebe19\";s:87:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Time.php\";s:32:\"339a56271fe0a2deb1f76eac3f1797f2\";s:92:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/Model/Transient.php\";s:32:\"1cbb8a1594a6403ea6c0bc48a41c30d0\";s:101:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/View/Destination/Listing.php\";s:32:\"68bd3482631ba13db72df5d6208ef29d\";s:95:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/View/Form/Recovery.php\";s:32:\"f660762bfd97ec26ddff8e9f9644256e\";s:93:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/View/Full/Backup.php\";s:32:\"a1f717853a52919301444437cd1093c3\";s:95:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/View/Metabox/Admin.php\";s:32:\"1fe4195790cb889eeb80bb3803acdbb7\";s:90:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/View/Settings.php\";s:32:\"cfa7c123f2539b8223d9286bbba89a2c\";s:96:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/View/Table/Archives.php\";s:32:\"90502cc607a57d26cbb604abf2c2380c\";s:99:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/View/Table/FullBackups.php\";s:32:\"00a501695d73a719367359f5438304ed\";s:93:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/View/Table/Items.php\";s:32:\"6f6dd69af4c94177b9b0f7df66065831\";s:90:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/Snapshot/View/Template.php\";s:32:\"6708d04cd264374f88ba70ff6e792e2d\";s:111:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/lib/WPMUDEV/Dashboard/wpmudev-dash-notification.php\";s:32:\"1c0b131f3d92038501b8948c23d6cdd1\";s:77:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/new-ui-tester.php\";s:32:\"0494d92d56b2bb8af49db2193e8ab099\";s:81:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/snapshot-recovery.php\";s:32:\"db372c6eff46d8b845e2ce27b3d73d7f\";s:72:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/snapshot.php\";s:32:\"92bb18ae6bbb4f76de6eeed8f2e98b3d\";s:73:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/uninstall.php\";s:32:\"9bd254a5f080002a1f27c0b120b3bede\";s:100:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/boxes/dashboard/widget-backups.php\";s:32:\"98fc2912da40a7cd2ae7ca424de8a3d4\";s:105:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/boxes/dashboard/widget-destinations.php\";s:32:\"a84821d2d46833b2b00aefb49f1e35e9\";s:102:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/boxes/dashboard/widget-snapshots.php\";s:32:\"863d1d1db8ea5e9e2dec759c1ea55abd\";s:99:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/boxes/dashboard/widget-status.php\";s:32:\"0dfc71f01d2bded273a68cf6d4e468df\";s:100:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/boxes/dashboard/widget-try-pro.php\";s:32:\"8d6e9bc7d32e0d19a6728f593e003864\";s:102:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/boxes/destinations/widget-amazon.php\";s:32:\"54ac2bedf04ffef7640f96f179426d19\";s:103:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/boxes/destinations/widget-dropbox.php\";s:32:\"6e2c757415f84f706bbb6ef80616a9e5\";s:102:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/boxes/destinations/widget-google.php\";s:32:\"7b3895f9fb8f5201db2d6822fc110a19\";s:101:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/boxes/destinations/widget-local.php\";s:32:\"a02e92b084147640c7007f4332102c1b\";s:100:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/boxes/destinations/widget-sftp.php\";s:32:\"5eb2361d57bd94b0c3d89c65c5f0b487\";s:97:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/boxes/managed-backups-start.php\";s:32:\"3da1c829a498442bada0afdfe3841a9f\";s:96:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/boxes/modals/popup-dynamic.php\";s:32:\"d0560074c1cdb041fd0da4c12a3f3197\";s:97:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/boxes/modals/popup-snapshot.php\";s:32:\"675bbe1f9c46610c71ff773639733367\";s:96:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/boxes/modals/popup-warning.php\";s:32:\"84c644d11103301003f8df6fee708fb9\";s:96:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/boxes/modals/popup-welcome.php\";s:32:\"633553548b5d68e00f8ef0ad01f74c15\";s:91:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/boxes/snapshots-start.php\";s:32:\"f1d1595fc06e3c7aac086255fd1b6f75\";s:111:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/boxes/widget-notification-managed-backups.php\";s:32:\"572d5647d8a4c8b06391ba1acaa13159\";s:83:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/common/footer.php\";s:32:\"6aa2b285aa81dc7378ade0e852221817\";s:94:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/common/requirements-test.php\";s:32:\"0483d4609f1138e4ffceffdb87e58255\";s:79:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/dashboard.php\";s:32:\"87ae0620e9abf3bfa70b590563797e70\";s:90:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/destinations/add/aws.php\";s:32:\"766588e14002fd2cea554a5d5159e071\";s:100:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/destinations/add/dropbox-error.php\";s:32:\"339b395dca8fd373434e5b63a8c29ae8\";s:94:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/destinations/add/dropbox.php\";s:32:\"fd7390687c9c74abe9b0fd15c5dadb59\";s:90:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/destinations/add/ftp.php\";s:32:\"7320e1c0375231055b6320a3fb0310fa\";s:99:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/destinations/add/google-drive.php\";s:32:\"d1e30fa6694f4324b36f691e9a627afc\";s:92:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/destinations/add/index.php\";s:32:\"4fdb332380ff8e97bf4681d307b08a7b\";s:92:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/destinations/add/local.php\";s:32:\"8be9f6e0ca8439a868212cd164d2cfa7\";s:116:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/destinations/partials/dropbox-destination-list.php\";s:32:\"5ba3d54106dff14a5c51fd5af832a198\";s:112:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/destinations/partials/ftp-destination-list.php\";s:32:\"441eeaf976e6c5e053796aba63a1e0bd\";s:121:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/destinations/partials/google-drive-destination-list.php\";s:32:\"f94300b4c0d1e3438146a16fc6908063\";s:114:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/destinations/partials/local-destination-list.php\";s:32:\"2398ea18e3dc84a21279be8a9d45cf8d\";s:111:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/destinations/partials/s3-destination-list.php\";s:32:\"44a8777fe1c7cc518b5ce261bf5cc59c\";s:82:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/destinations.php\";s:32:\"2ab9138e4ad0af3af8656ca7cacd714e\";s:76:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/import.php\";s:32:\"595e912d388b9232307634951ded4986\";s:94:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/managed-backups/activate.php\";s:32:\"6076303317f4c91bfc101fd9d704cfb0\";s:97:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/managed-backups/get-started.php\";s:32:\"e29a2885ba5e157c86a865f0ea25633b\";s:96:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/managed-backups/new-backup.php\";s:32:\"90703d48fc2183e17da7439d3e767aa1\";s:117:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/managed-backups/partials/create-backup-progress.php\";s:32:\"9eaf43fd27f96ddd5df4f23383af3bdf\";s:101:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/managed-backups/partials/filter.php\";s:32:\"04d54bb10103ca4e6d23ca7ede97cc90\";s:118:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/managed-backups/partials/restore-backup-progress.php\";s:32:\"6196c1c1d16b8ee003ada3ee096448b9\";s:93:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/managed-backups/restore.php\";s:32:\"696fe48a302d2a405a2a4576b6eb2c59\";s:85:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/managed_backups.php\";s:32:\"805626e70de071b41bb7240703da71aa\";s:78:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/settings.php\";s:32:\"8a67b1bca8866ffb6cd0fcd1fb294ca1\";s:84:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/snapshots/item.php\";s:32:\"2c3ded1e65ff7ab7b3c24494df682ed3\";s:113:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/snapshots/partials/create-snapshot-progress.php\";s:32:\"43cd626e582514752fb28f29b88f0353\";s:95:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/snapshots/partials/filter.php\";s:32:\"3cb4b8748582e47a6627d9442d7b083c\";s:114:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/snapshots/partials/restore-snapshot-progress.php\";s:32:\"9ac38407f43e52bec390d4c31789b428\";s:87:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/snapshots/restore.php\";s:32:\"c4b807e0806c6391cc2e35327ca14f8d\";s:88:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/snapshots/snapshot.php\";s:32:\"debce5b7bf249809a3c6a76289076d12\";s:79:\"/home/econolodge/public_html/wp/wp-content/plugins/snapshot/views/snapshots.php\";s:32:\"b7e164b89056255670c58077752c43d8\";s:72:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/admin.php\";s:32:\"d5f44327e24d830166284162ae3a08c3\";s:73:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/backup.php\";s:32:\"f136e93965eb1860ef8fd968bdcc54f0\";s:84:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/central/bootstrap.php\";s:32:\"92179d900c24a9e1e0f723bfdc370cfd\";s:112:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/central/classes/class-automatic-upgrader-skin.php\";s:32:\"90a904209c21e3722813b5174247854d\";s:83:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/central/commands.php\";s:32:\"c2ef6f5521631f51938f8d0ec542b18d\";s:83:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/central/listener.php\";s:32:\"f3f1300f8dbb58ff8e40d321d11b967e\";s:92:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/central/modules/analytics.php\";s:32:\"e65553e20d0c149e9f31be884696661c\";s:91:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/central/modules/comments.php\";s:32:\"5fa012cd762d2988ae3a7d675ae1a7b0\";s:87:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/central/modules/core.php\";s:32:\"8fe4017f8548286398d046e1c827f005\";s:89:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/central/modules/plugin.php\";s:32:\"a144f93b4e4c3425cf7b3bbea19f2315\";s:88:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/central/modules/posts.php\";s:32:\"a82250d32b0a59743b793097309c4499\";s:90:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/central/modules/updates.php\";s:32:\"77bd762789d948c7ec3a8c126a5081f0\";s:88:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/central/modules/users.php\";s:32:\"e1f44d8e38102cadef2d84dd55b91271\";s:84:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/class-updraftplus.php\";s:32:\"29975a0735b64c0ebe78f0c0e1d9cd6b\";s:76:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/class-zip.php\";s:32:\"553815eba31cd56484233a23eb1b92f3\";s:82:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/example-decrypt.php\";s:32:\"9a032f6babfa3d9ba82b15cb31985988\";s:88:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Dropbox2/API.php\";s:32:\"d7559e24f9c961662aec196fb76e9f97\";s:94:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Dropbox2/Exception.php\";s:32:\"9811c4b7188d5399633fb940b3dcb1d4\";s:116:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Dropbox2/OAuth/Consumer/ConsumerAbstract.php\";s:32:\"9c9f5241599280468f5a5efd872670f5\";s:104:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Dropbox2/OAuth/Consumer/Curl.php\";s:32:\"f073eb791f9771f4465754e60dd2aea7\";s:109:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Dropbox2/OAuth/Consumer/WordPress.php\";s:32:\"8a2804a52b29d90528e253a04f99675c\";s:108:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Dropbox2/OAuth/Storage/Encrypter.php\";s:32:\"1057e362be03b3a5efdd5cd011a2e339\";s:115:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Dropbox2/OAuth/Storage/StorageInterface.php\";s:32:\"71832ced53058394b7ebb398d68021f9\";s:108:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Dropbox2/OAuth/Storage/WordPress.php\";s:32:\"5da872170e33938931a41c5670bd3d16\";s:96:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Auth/Abstract.php\";s:32:\"650aab096ac077d5a54dd230989202bc\";s:99:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Auth/AppIdentity.php\";s:32:\"327ca7d376613dd1cfa7a25d891cdebc\";s:108:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Auth/AssertionCredentials.php\";s:32:\"cb48a5d14cede8ca98088e58732972a6\";s:101:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Auth/ComputeEngine.php\";s:32:\"285e85ef412b20a11296f3eb4372b6a6\";s:97:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Auth/Exception.php\";s:32:\"21b72be75cf2f8e1ef2933618ed30a63\";s:99:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Auth/LoginTicket.php\";s:32:\"3b7a2a4ef2f4348ceb8397c984774099\";s:94:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Auth/OAuth2.php\";s:32:\"10e0e45068bc781833ab5822b1da36fc\";s:94:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Auth/Simple.php\";s:32:\"99e51011a700c21dbe8c5d2739e3777f\";s:97:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Cache/Abstract.php\";s:32:\"4a595e56a6c419ebad142a4ac7b15ef3\";s:92:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Cache/Apc.php\";s:32:\"8055f872cb2a7695c3e04f78ab047166\";s:98:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Cache/Exception.php\";s:32:\"56c084ec51850e7e6c3ca324d319f154\";s:93:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Cache/File.php\";s:32:\"965391ca4735f4e4f6de8fcbef7d722b\";s:97:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Cache/Memcache.php\";s:32:\"b888f3d054704638fdcd278cd9abc68b\";s:93:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Cache/Null.php\";s:32:\"9212a23f9b6dca48c76f4192b1f605f1\";s:89:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Client.php\";s:32:\"847913baf9f5e93678ce354df394d671\";s:93:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Collection.php\";s:32:\"6c85f1215738a2eef9b0d5a19c524d5d\";s:89:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Config.php\";s:32:\"318afca9f008d35a174bfd9dadc02ff2\";s:92:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Exception.php\";s:32:\"93eb9f356b6b4cbcf6fdbc1926dbde88\";s:93:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Http/Batch.php\";s:32:\"77c516c34f54d37c132074b16824f278\";s:99:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Http/CacheParser.php\";s:32:\"1637b7676d802930acec9eef5508ee95\";s:103:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Http/MediaFileUpload.php\";s:32:\"bbf5b9ee5255e4228a9f9e6650964a7d\";s:92:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Http/REST.php\";s:32:\"99779c816397c32cd026d230cc3bde64\";s:95:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Http/Request.php\";s:32:\"f03b8a519e4a20823f603f2432722038\";s:94:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/IO/Abstract.php\";s:32:\"08b23cad6ad06623802d945808d5c90f\";s:90:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/IO/Curl.php\";s:32:\"989937d4b02d8ebca1ba18957d0fdf36\";s:95:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/IO/Exception.php\";s:32:\"8d866e1b07045c9a8bbf3c9840deef20\";s:92:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/IO/Stream.php\";s:32:\"7263a9a9bfa2d9feec395d8e88e07129\";s:98:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Logger/Abstract.php\";s:32:\"c3be97c23fc050aba291a37c7ceb3072\";s:99:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Logger/Exception.php\";s:32:\"d781f6385fb2f17017daccc640f17d7f\";s:94:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Logger/File.php\";s:32:\"9dc7ed69671ec82b201e33aafbb9adf4\";s:94:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Logger/Null.php\";s:32:\"921dd7b30ccf807b5ca636b2cb077dcb\";s:93:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Logger/Psr.php\";s:32:\"47d6fda05780f9bba9f3cdc5b98a789f\";s:88:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Model.php\";s:32:\"c90c3336e1c307a5214c9f6cb0658444\";s:96:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Service/Audit.php\";s:32:\"5522ef4cba1318d67f9e3b73a8a7efa9\";s:100:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Service/Container.php\";s:32:\"067d86be76b8c6885a58f186d1cf5fc5\";s:100:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Service/Datastore.php\";s:32:\"fdd8f45902247f155dd2c16a3b7b9c4e\";s:100:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Service/Directory.php\";s:32:\"3cb9f9a83c6ad210072aee97ab14e28d\";s:94:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Service/Dns.php\";s:32:\"0c174136e26fd506f03692518748b001\";s:96:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Service/Drive.php\";s:32:\"80af63452d5180e64af33796ce8e19fa\";s:100:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Service/Exception.php\";s:32:\"3df47de71191face9a2f1b3c029c8079\";s:106:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Service/GroupsMigration.php\";s:32:\"1c0a2db814d38b47cf78d1a075176d65\";s:105:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Service/Groupssettings.php\";s:32:\"2ea2da8b3d519e656548bb3f17f4a9d4\";s:106:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Service/IdentityToolkit.php\";s:32:\"bc432f6299c81f0872f2ec81418181e9\";s:100:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Service/Licensing.php\";s:32:\"be2acce0a8414072be51889047581179\";s:98:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Service/Logging.php\";s:32:\"497962957934ad4d671663a4ce9e160b\";s:97:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Service/Oauth2.php\";s:32:\"ea16a9fa61b89d84425519f29cee2d4b\";s:98:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Service/Reports.php\";s:32:\"50f1215e28d002284eb56934becbfeca\";s:99:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Service/Resource.php\";s:32:\"71564e2b5896d613de5ffbee9286c57f\";s:104:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Service/Resourceviews.php\";s:32:\"6861ae08e93b782effce5e7ec97dd7e0\";s:98:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Service/Storage.php\";s:32:\"9525b0dff3459a0b5b17597300d6bf1b\";s:96:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Service/Tasks.php\";s:32:\"c6a3edb979750d99b8581b4fc7f74e2c\";s:90:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Service.php\";s:32:\"ae819136b6bf530bccee81f993f45793\";s:98:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Signer/Abstract.php\";s:32:\"85915452e42b8636181ceacd7c8b38e9\";s:93:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Signer/P12.php\";s:32:\"62349c381de5f609914249dfd1245ad5\";s:97:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Task/Exception.php\";s:32:\"fd80f21d711c8b658815cc53e88a340b\";s:97:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Task/Retryable.php\";s:32:\"0efd7b612285a2c35a2a84ff2f441e66\";s:94:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Task/Runner.php\";s:32:\"bffda0decadf98ad09d77a67bb28fa98\";s:100:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Utils/URITemplate.php\";s:32:\"cabb63968b2b820423f4a0252afd1d61\";s:88:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Utils.php\";s:32:\"1d71ba9df985da107ad727908a8a4ecb\";s:100:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Verifier/Abstract.php\";s:32:\"f5ff23db55e103b5e2db99d42a8040fe\";s:95:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/Verifier/Pem.php\";s:32:\"f80bcbaa4f9fef432445fc39415321c0\";s:91:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/Google/autoload.php\";s:32:\"14958c9938ebec687a669e83c7e29a09\";s:78:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/S3.php\";s:32:\"8786f95cb98315a95c70a8faeed8ac6a\";s:84:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/S3compat.php\";s:32:\"95a414091afd20cf9298b340e7346a6b\";s:96:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/class-backup-history.php\";s:32:\"9c40095378d9d08948a78921a6c88f46\";s:90:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/class-commands.php\";s:32:\"d892866f88a0fefd5e09e89f950662f1\";s:98:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/class-database-utility.php\";s:32:\"521f70675ec2601421d1bccf40aeb8cd\";s:104:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/class-manipulation-functions.php\";s:32:\"81cf165fb0349099b92f084628011883\";s:100:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/class-partialfileservlet.php\";s:32:\"dccb845a0ea459baf6d4f161d036d749\";s:91:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/class-semaphore.php\";s:32:\"365307aed57e1d5843034159dac9709d\";s:87:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/class-udrpc.php\";s:32:\"28b567aae826261ba7d00df2cc814aaf\";s:104:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/class-updraft-dashboard-news.php\";s:32:\"ba8187865866f435043450e603f6ecf2\";s:117:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/class-updraftcentral-updraftplus-commands.php\";s:32:\"f47f6e270287a5fded8d92b0aacc3aa0\";s:104:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/class-updraftplus-encryption.php\";s:32:\"c3294195b7f913bd95c028b2412bfa3e\";s:98:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/class-wpadmin-commands.php\";s:32:\"c0f6c3cff29889b1239071d57e8be04f\";s:97:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/cloudfiles/cloudfiles.php\";s:32:\"767f8f21116528aa69e59b3a68d75aa7\";s:108:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/cloudfiles/cloudfiles_exceptions.php\";s:32:\"26a3ab67b1ebbf4b6443febf2ec4b526\";s:102:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/cloudfiles/cloudfiles_http.php\";s:32:\"7fbcf8165f3052393bd938bb876ed471\";s:94:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/deprecated-actions.php\";s:32:\"89be3fee2ef6aeb328200e6076050857\";s:85:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/ftp.class.php\";s:32:\"2043a7b1437a58a939a0359b4a81940f\";s:93:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/google-extensions.php\";s:32:\"2f01cb9c11bf6a0b3896445d4c0d4c0b\";s:91:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/updraft-notices.php\";s:32:\"0d9d9b2a3321b5020bf1e5245111c026\";s:90:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/updraftcentral.php\";s:32:\"fbc973e5d473cf2a533da9ca937444c8\";s:93:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/updraftplus-clone.php\";s:32:\"a54c38c5f4f66be5e3b6e5dc5bd3e656\";s:93:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/updraftplus-login.php\";s:32:\"09e9968c513c7f49730a0595fb8d63c0\";s:95:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/updraftplus-notices.php\";s:32:\"17204161f17b2632da1b14d050b2fa2c\";s:88:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/includes/updraftvault.php\";s:32:\"309e3befa3d883e07862ba1cb04d87a3\";s:96:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/methods/addon-not-yet-present.php\";s:32:\"6b39329968c8cefc6ec54913a0c25608\";s:80:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/methods/azure.php\";s:32:\"917e8da055c59d1a7aa9d75da6909a98\";s:84:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/methods/backblaze.php\";s:32:\"b2803299e3b9acb7c5bbc4309dbe8ef9\";s:88:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/methods/backup-module.php\";s:32:\"bb5331a2d67eb2ebe96a0739f8953ec7\";s:89:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/methods/cloudfiles-new.php\";s:32:\"10122fd8a8cda285c001d80d67bf0953\";s:85:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/methods/cloudfiles.php\";s:32:\"360b682ed29081a26e9230133825aea8\";s:87:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/methods/dreamobjects.php\";s:32:\"833f831f7de85eaf75cf47c2de112946\";s:82:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/methods/dropbox.php\";s:32:\"b03c5cf202155b3d11dc70f35aa481d6\";s:80:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/methods/email.php\";s:32:\"df848e685bfcbadf7d3abcbf0fe72438\";s:78:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/methods/ftp.php\";s:32:\"e7d4ba1727ae1e1e801e687af1f278a2\";s:86:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/methods/googlecloud.php\";s:32:\"c7d943aaa42835df3fee24c00a8ae64f\";s:86:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/methods/googledrive.php\";s:32:\"d22ebf2463d7d657823f1b3a3de0195e\";s:87:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/methods/insufficient.php\";s:32:\"121facd9c0506bb874aafe7252fad911\";s:83:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/methods/onedrive.php\";s:32:\"b1f8e7e3049bd97abb092a1aade21de7\";s:89:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/methods/openstack-base.php\";s:32:\"4ccdcded69d8c09297387b7615fd61af\";s:84:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/methods/openstack.php\";s:32:\"e2d1d3f213267c4b826cbe30ced28e09\";s:85:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/methods/openstack2.php\";s:32:\"02e27f618715361912ddb74d8f963a81\";s:77:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/methods/s3.php\";s:32:\"0de9ce0483a58f6e5a9a135d40e6aa60\";s:84:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/methods/s3generic.php\";s:32:\"02008158830b7417b4f6e9ab490fb0b6\";s:79:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/methods/sftp.php\";s:32:\"94b075f387b5ce3d6c17afd4b0c31f9a\";s:83:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/methods/template.php\";s:32:\"9567b4737cda4728fde2f901435d5886\";s:87:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/methods/updraftvault.php\";s:32:\"a923a796820ce30b912bb8bc98fe3bcd\";s:81:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/methods/webdav.php\";s:32:\"9f9cb73715e9429d1a4dbe71b0c90aa1\";s:74:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/options.php\";s:32:\"20df5240649cb339c43d116dda85a9de\";s:75:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/restorer.php\";s:32:\"e229007bf6a980c6b49ab7f54bcb5bf6\";s:109:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/templates/wp-admin/advanced/advanced-tools.php\";s:32:\"834a4ad74b1528094c841a58778c3e21\";s:110:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/templates/wp-admin/advanced/export-settings.php\";s:32:\"b3d28753ed50d939477f72585aa0c27b\";s:105:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/templates/wp-admin/advanced/lock-admin.php\";s:32:\"628a7e4b2c80732869921319bb510226\";s:109:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/templates/wp-admin/advanced/search-replace.php\";s:32:\"3ad0b81298a5cf5dfa2eadac5ed27ede\";s:104:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/templates/wp-admin/advanced/site-info.php\";s:32:\"29fb4bd2614f74c94b5699ac5f7a6463\";s:105:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/templates/wp-admin/advanced/tools-menu.php\";s:32:\"279bcff6812ab32c55ba38afdba14f7b\";s:105:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/templates/wp-admin/advanced/total-size.php\";s:32:\"9f07662946c77c84b102957b388e0a26\";s:109:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/templates/wp-admin/advanced/updraftcentral.php\";s:32:\"78d75183b5c5cd604a0f43ec0633743b\";s:108:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/templates/wp-admin/advanced/wipe-settings.php\";s:32:\"2fff0cde37d2a4688d1df059a9246f2b\";s:107:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/templates/wp-admin/notices/bottom-notice.php\";s:32:\"68bb8471f6d25bdcfb027b6df76f3aca\";s:111:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/templates/wp-admin/notices/horizontal-notice.php\";s:32:\"860669acad0eddd735bfdd19d6fe5c7c\";s:106:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/templates/wp-admin/notices/report-plain.php\";s:32:\"2ce66653aeefd74c2d49279b9076bbe5\";s:100:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/templates/wp-admin/notices/report.php\";s:32:\"69f0af5074153250d957d48c9fcb312e\";s:120:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/templates/wp-admin/notices/thanks-for-using-main-dash.php\";s:32:\"e6e4cee7de0b3fc8997fa9962285b66f\";s:120:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/templates/wp-admin/settings/delete-and-restore-modals.php\";s:32:\"ed8c5b309b776bc3214f4965a4eb51dc\";s:120:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/templates/wp-admin/settings/downloading-and-restoring.php\";s:32:\"66ced0781613bdfe0b83262c4088b0e0\";s:117:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/templates/wp-admin/settings/existing-backups-table.php\";s:32:\"db45986a12819d88f43a4718eceda812\";s:108:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/templates/wp-admin/settings/form-contents.php\";s:32:\"e4582bd010ddbc1677a2dd57d041ee66\";s:101:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/templates/wp-admin/settings/header.php\";s:32:\"fc7aa8475edb0219aff9cd69fc1d1de9\";s:105:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/templates/wp-admin/settings/tab-addons.php\";s:32:\"36039eec123de4f9511765598a22bbf9\";s:102:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/templates/wp-admin/settings/tab-bar.php\";s:32:\"8e1274aeabed4ebab1359275651d6575\";s:105:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/templates/wp-admin/settings/tab-status.php\";s:32:\"6db775975122eb9db32266670bb3ca24\";s:117:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/templates/wp-admin/settings/updraftcentral-connect.php\";s:32:\"fcd034c27723dc5390c15dfc7b1011e7\";s:115:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/templates/wp-admin/settings/upload-backups-modal.php\";s:32:\"a0fd9fb5c496dcdd22f79f7538e54d2b\";s:78:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/updraftplus.php\";s:32:\"48cfc90f1265a9d5170062e500d86bfd\";s:82:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/vendor/autoload.php\";s:32:\"b9ad6d1f241e766cd73761ec985843d2\";s:108:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/vendor/aws/aws-sdk-php/src/Aws/Common/Aws.php\";s:32:\"c11afaf45daf193c51cb7befe463f5d6\";s:126:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/vendor/aws/aws-sdk-php/src/Aws/Common/Client/AbstractClient.php\";s:32:\"b5549e525d4119198840bb2b34e79c67\";s:130:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/vendor/aws/aws-sdk-php/src/Aws/Common/Client/AwsClientInterface.php\";s:32:\"11cd9b87c4d9f0241ca71cf0d2d7293f\";s:125:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/vendor/aws/aws-sdk-php/src/Aws/Common/Client/ClientBuilder.php\";s:32:\"f5c71745baaae8f46fe37a4f3d4bbd9a\";s:125:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/vendor/aws/aws-sdk-php/src/Aws/Common/Client/DefaultClient.php\";s:32:\"fa88950bb0efaf957f4b8ee10753062b\";s:137:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/vendor/aws/aws-sdk-php/src/Aws/Common/Client/ExpiredCredentialsChecker.php\";s:32:\"18150232988131e9f21e4724cfc35bbf\";s:134:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/vendor/aws/aws-sdk-php/src/Aws/Common/Client/ThrottlingErrorChecker.php\";s:32:\"db13af3fbec0f198c0120bd0690e935d\";s:130:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/vendor/aws/aws-sdk-php/src/Aws/Common/Client/UploadBodyListener.php\";s:32:\"98501807352bf33024e31b7fc6217c93\";s:129:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/vendor/aws/aws-sdk-php/src/Aws/Common/Client/UserAgentListener.php\";s:32:\"640e0b6993bd8faaa3e154dc988d02e3\";s:128:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/vendor/aws/aws-sdk-php/src/Aws/Common/Command/AwsQueryVisitor.php\";s:32:\"6bef8308125e047c4be353e04c067367\";s:124:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/vendor/aws/aws-sdk-php/src/Aws/Common/Command/JsonCommand.php\";s:32:\"47f1c01448de7d6c09671907bef5a5bc\";s:125:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/vendor/aws/aws-sdk-php/src/Aws/Common/Command/QueryCommand.php\";s:32:\"457a7a69d3575bf45afc227ca0fd3948\";s:139:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/vendor/aws/aws-sdk-php/src/Aws/Common/Command/XmlResponseLocationVisitor.php\";s:32:\"bce6a394352ce1162ed5d5a814a921e9\";s:145:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/vendor/aws/aws-sdk-php/src/Aws/Common/Credentials/AbstractCredentialsDecorator.php\";s:32:\"6b235c74969a4c6808d7cff23bc93df7\";s:147:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/vendor/aws/aws-sdk-php/src/Aws/Common/Credentials/AbstractRefreshableCredentials.php\";s:32:\"3b6c2d61dbacea5a25d8e8477cf1d2c7\";s:137:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/vendor/aws/aws-sdk-php/src/Aws/Common/Credentials/CacheableCredentials.php\";s:32:\"dc038b73d9ca995536bc03e80b615a4e\";s:128:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/vendor/aws/aws-sdk-php/src/Aws/Common/Credentials/Credentials.php\";s:32:\"93e9ebe9c22c382ea50b36951b978583\";s:137:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/vendor/aws/aws-sdk-php/src/Aws/Common/Credentials/CredentialsInterface.php\";s:32:\"a72c382e6050484406ff0813d6879c4e\";s:132:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/vendor/aws/aws-sdk-php/src/Aws/Common/Credentials/NullCredentials.php\";s:32:\"d1a055b46efc21e46ccc4ca731ffe7ad\";s:154:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/vendor/aws/aws-sdk-php/src/Aws/Common/Credentials/RefreshableInstanceProfileCredentials.php\";s:32:\"1d4f805497108daf7835894f1605a367\";s:123:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/vendor/aws/aws-sdk-php/src/Aws/Common/Enum/ClientOptions.php\";s:32:\"87412bee81bce129eacaedb580fcd464\";s:120:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/vendor/aws/aws-sdk-php/src/Aws/Common/Enum/DateFormat.php\";s:32:\"d715d775feb1ebcf144857c05f2b2b11\";s:116:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/vendor/aws/aws-sdk-php/src/Aws/Common/Enum/Region.php\";s:32:\"b92da9494098f83d94080c96979a3c06\";s:114:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/vendor/aws/aws-sdk-php/src/Aws/Common/Enum/Size.php\";s:32:\"0701abe5acc45f6e9a897631b8b4cec2\";s:114:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/vendor/aws/aws-sdk-php/src/Aws/Common/Enum/Time.php\";s:32:\"0342531432bbafbfcf4cdb04156f8ebd\";s:118:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/vendor/aws/aws-sdk-php/src/Aws/Common/Enum/UaString.php\";s:32:\"6006719ac2eecfb5183d776634f2b2a5\";s:109:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/vendor/aws/aws-sdk-php/src/Aws/Common/Enum.php\";s:32:\"b5e48ce90ddfd2b397fe1dfbabd2d3ca\";s:136:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/vendor/aws/aws-sdk-php/src/Aws/Common/Exception/AwsExceptionInterface.php\";s:32:\"752cafcafecfd520e6ccfe01210a17c7\";s:137:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/vendor/aws/aws-sdk-php/src/Aws/Common/Exception/BadMethodCallException.php\";s:32:\"1b1e3665960ce4fb9043df5c58553dd6\";s:130:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/vendor/aws/aws-sdk-php/src/Aws/Common/Exception/DomainException.php\";s:32:\"ed60e5bba6ad952a2619613e194fb73c\";s:140:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/vendor/aws/aws-sdk-php/src/Aws/Common/Exception/ExceptionFactoryInterface.php\";s:32:\"2ca2ab488369e279da53a7b903fd557e\";s:132:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/vendor/aws/aws-sdk-php/src/Aws/Common/Exception/ExceptionListener.php\";s:32:\"992185ed8296289a27b1b6497f306643\";s:150:\"/home/econolodge/public_html/wp/wp-content/plugins/updraftplus/vendor/aws/aws-sdk-php/src/Aws/Common/Exception/InstanceProfileCredentialsException.php\";s:32:\"6400656e6a65bd523e37158ed71bd4c7\";s:139:\"/home/econolodge/public_html/