/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2020-12-03 19:16:09 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_bwg_album` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `description` mediumtext NOT NULL,
  `preview_image` mediumtext NOT NULL,
  `random_preview_image` mediumtext NOT NULL,
  `order` bigint(20) NOT NULL,
  `author` bigint(20) NOT NULL,
  `published` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_bwg_album_gallery` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `album_id` bigint(20) NOT NULL,
  `is_album` tinyint(1) NOT NULL,
  `alb_gal_id` bigint(20) NOT NULL,
  `order` bigint(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_bwg_gallery` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `description` mediumtext NOT NULL,
  `page_link` mediumtext NOT NULL,
  `preview_image` mediumtext NOT NULL,
  `random_preview_image` mediumtext NOT NULL,
  `order` bigint(20) NOT NULL,
  `author` bigint(20) NOT NULL,
  `published` tinyint(1) NOT NULL,
  `gallery_type` varchar(32) NOT NULL,
  `gallery_source` varchar(256) NOT NULL,
  `autogallery_image_number` int(4) NOT NULL,
  `update_flag` varchar(32) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_bwg_image` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `gallery_id` bigint(20) NOT NULL,
  `slug` longtext NOT NULL,
  `filename` varchar(255) NOT NULL,
  `image_url` mediumtext NOT NULL,
  `thumb_url` mediumtext NOT NULL,
  `description` mediumtext NOT NULL,
  `alt` mediumtext NOT NULL,
  `date` varchar(128) NOT NULL,
  `size` varchar(128) NOT NULL,
  `filetype` varchar(128) NOT NULL,
  `resolution` varchar(128) NOT NULL,
  `author` bigint(20) NOT NULL,
  `order` bigint(20) NOT NULL,
  `published` tinyint(1) NOT NULL,
  `comment_count` bigint(20) NOT NULL,
  `avg_rating` float NOT NULL,
  `rate_count` bigint(20) NOT NULL,
  `hit_count` bigint(20) NOT NULL,
  `redirect_url` varchar(255) NOT NULL,
  `pricelist_id` int(16) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=37 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_bwg_image_comment` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `image_id` bigint(20) NOT NULL,
  `name` varchar(255) NOT NULL,
  `date` varchar(64) NOT NULL,
  `comment` mediumtext NOT NULL,
  `url` mediumtext NOT NULL,
  `mail` mediumtext NOT NULL,
  `published` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_bwg_image_rate` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `image_id` bigint(20) NOT NULL,
  `rate` float NOT NULL,
  `ip` varchar(64) NOT NULL,
  `date` varchar(64) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_bwg_image_tag` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `tag_id` bigint(20) NOT NULL,
  `image_id` bigint(20) NOT NULL,
  `gallery_id` bigint(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_bwg_option` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `images_directory` mediumtext NOT NULL,
  `masonry` varchar(255) NOT NULL,
  `mosaic` varchar(255) NOT NULL,
  `resizable_mosaic` tinyint(1) NOT NULL,
  `mosaic_total_width` int(4) NOT NULL,
  `image_column_number` int(4) NOT NULL,
  `images_per_page` int(4) NOT NULL,
  `thumb_width` int(4) NOT NULL,
  `thumb_height` int(4) NOT NULL,
  `upload_thumb_width` int(4) NOT NULL,
  `upload_thumb_height` int(4) NOT NULL,
  `image_enable_page` tinyint(1) NOT NULL,
  `image_title_show_hover` varchar(20) NOT NULL,
  `album_column_number` int(4) NOT NULL,
  `albums_per_page` int(4) NOT NULL,
  `album_title_show_hover` varchar(8) NOT NULL,
  `album_thumb_width` int(4) NOT NULL,
  `album_thumb_height` int(4) NOT NULL,
  `album_enable_page` tinyint(1) NOT NULL,
  `extended_album_height` int(4) NOT NULL,
  `extended_album_description_enable` tinyint(1) NOT NULL,
  `image_browser_width` int(4) NOT NULL,
  `image_browser_title_enable` tinyint(1) NOT NULL,
  `image_browser_description_enable` tinyint(1) NOT NULL,
  `blog_style_width` int(4) NOT NULL,
  `blog_style_title_enable` tinyint(1) NOT NULL,
  `blog_style_images_per_page` int(4) NOT NULL,
  `blog_style_enable_page` tinyint(1) NOT NULL,
  `slideshow_type` varchar(16) NOT NULL,
  `slideshow_interval` int(4) NOT NULL,
  `slideshow_width` int(4) NOT NULL,
  `slideshow_height` int(4) NOT NULL,
  `slideshow_enable_autoplay` tinyint(1) NOT NULL,
  `slideshow_enable_shuffle` tinyint(1) NOT NULL,
  `slideshow_enable_ctrl` tinyint(1) NOT NULL,
  `slideshow_enable_filmstrip` tinyint(1) NOT NULL,
  `slideshow_filmstrip_height` int(4) NOT NULL,
  `slideshow_enable_title` tinyint(1) NOT NULL,
  `slideshow_title_position` varchar(16) NOT NULL,
  `slideshow_enable_description` tinyint(1) NOT NULL,
  `slideshow_description_position` varchar(16) NOT NULL,
  `slideshow_enable_music` tinyint(1) NOT NULL,
  `slideshow_audio_url` varchar(255) NOT NULL,
  `popup_width` int(4) NOT NULL,
  `popup_height` int(4) NOT NULL,
  `popup_type` varchar(16) NOT NULL,
  `popup_interval` int(4) NOT NULL,
  `popup_enable_filmstrip` tinyint(1) NOT NULL,
  `popup_filmstrip_height` int(4) NOT NULL,
  `popup_enable_ctrl_btn` tinyint(1) NOT NULL,
  `popup_enable_fullscreen` tinyint(1) NOT NULL,
  `popup_enable_info` tinyint(1) NOT NULL,
  `popup_info_always_show` tinyint(1) NOT NULL,
  `popup_enable_rate` tinyint(1) NOT NULL,
  `popup_enable_comment` tinyint(1) NOT NULL,
  `popup_enable_email` tinyint(1) NOT NULL,
  `popup_enable_captcha` tinyint(1) NOT NULL,
  `popup_enable_download` tinyint(1) NOT NULL,
  `popup_enable_fullsize_image` tinyint(1) NOT NULL,
  `popup_enable_facebook` tinyint(1) NOT NULL,
  `popup_enable_twitter` tinyint(1) NOT NULL,
  `popup_enable_google` tinyint(1) NOT NULL,
  `watermark_type` varchar(8) NOT NULL,
  `watermark_position` varchar(16) NOT NULL,
  `watermark_width` int(4) NOT NULL,
  `watermark_height` int(4) NOT NULL,
  `watermark_url` mediumtext NOT NULL,
  `watermark_text` mediumtext NOT NULL,
  `watermark_link` mediumtext NOT NULL,
  `watermark_font_size` int(4) NOT NULL,
  `watermark_font` varchar(16) NOT NULL,
  `watermark_color` varchar(8) NOT NULL,
  `watermark_opacity` int(4) NOT NULL,
  `built_in_watermark_type` varchar(16) NOT NULL,
  `built_in_watermark_position` varchar(16) NOT NULL,
  `built_in_watermark_size` int(4) NOT NULL,
  `built_in_watermark_url` mediumtext NOT NULL,
  `built_in_watermark_text` mediumtext NOT NULL,
  `built_in_watermark_font_size` int(4) NOT NULL,
  `built_in_watermark_font` varchar(16) NOT NULL,
  `built_in_watermark_color` varchar(8) NOT NULL,
  `built_in_watermark_opacity` int(4) NOT NULL,
  `image_right_click` tinyint(1) NOT NULL,
  `popup_fullscreen` tinyint(1) NOT NULL,
  `gallery_role` tinyint(1) NOT NULL,
  `album_role` tinyint(1) NOT NULL,
  `image_role` tinyint(1) NOT NULL,
  `popup_autoplay` tinyint(1) NOT NULL,
  `album_view_type` varchar(16) NOT NULL,
  `popup_enable_pinterest` tinyint(1) NOT NULL,
  `popup_enable_tumblr` tinyint(1) NOT NULL,
  `show_search_box` tinyint(1) NOT NULL,
  `search_box_width` int(4) NOT NULL,
  `preload_images` tinyint(1) NOT NULL,
  `preload_images_count` int(4) NOT NULL,
  `thumb_click_action` varchar(16) NOT NULL,
  `thumb_link_target` tinyint(1) NOT NULL,
  `comment_moderation` tinyint(1) NOT NULL,
  `popup_hit_counter` tinyint(1) NOT NULL,
  `enable_ML_import` tinyint(1) NOT NULL,
  `showthumbs_name` tinyint(1) NOT NULL,
  `show_album_name` tinyint(1) NOT NULL,
  `show_image_counts` tinyint(1) NOT NULL,
  `upload_img_width` int(4) NOT NULL,
  `upload_img_height` int(4) NOT NULL,
  `play_icon` tinyint(1) NOT NULL,
  `show_masonry_thumb_description` tinyint(1) NOT NULL,
  `slideshow_title_full_width` tinyint(1) NOT NULL,
  `popup_info_full_width` tinyint(1) NOT NULL,
  `show_sort_images` tinyint(1) NOT NULL,
  `autoupdate_interval` int(4) NOT NULL,
  `instagram_access_token` varchar(128) NOT NULL DEFAULT '',
  `description_tb` tinyint(1) NOT NULL,
  `enable_seo` tinyint(1) NOT NULL,
  `autohide_lightbox_navigation` tinyint(1) NOT NULL,
  `autohide_slideshow_navigation` tinyint(1) NOT NULL,
  `read_metadata` tinyint(1) NOT NULL,
  `enable_loop` tinyint(1) NOT NULL DEFAULT 1,
  `enable_addthis` tinyint(1) NOT NULL DEFAULT 0,
  `addthis_profile_id` varchar(32) NOT NULL DEFAULT '',
  `carousel_width` int(4) NOT NULL DEFAULT 300,
  `carousel_height` int(4) NOT NULL DEFAULT 300,
  `carousel_interval` int(4) NOT NULL DEFAULT 5,
  `carousel_image_column_number` int(4) NOT NULL DEFAULT 5,
  `carousel_image_par` varchar(32) NOT NULL DEFAULT '0.75',
  `carousel_enable_autoplay` tinyint(1) NOT NULL DEFAULT 0,
  `carousel_enable_title` tinyint(1) NOT NULL DEFAULT 0,
  `carousel_r_width` int(4) NOT NULL DEFAULT 800,
  `carousel_fit_containerWidth` tinyint(1) NOT NULL DEFAULT 1,
  `carousel_prev_next_butt` tinyint(1) NOT NULL DEFAULT 1,
  `carousel_play_pause_butt` tinyint(1) NOT NULL DEFAULT 1,
  `permissions` varchar(20) NOT NULL DEFAULT 'manage_options',
  `facebook_app_id` varchar(64) NOT NULL DEFAULT '',
  `facebook_app_secret` varchar(64) NOT NULL DEFAULT '',
  `show_tag_box` tinyint(1) NOT NULL DEFAULT 0,
  `show_hide_custom_post` tinyint(1) NOT NULL DEFAULT 0,
  `show_hide_post_meta` tinyint(1) NOT NULL DEFAULT 0,
  `placeholder` varchar(32) NOT NULL DEFAULT '',
  `ecommerce_icon_show_hover` varchar(32) NOT NULL DEFAULT '0',
  `popup_enable_ecommerce` tinyint(1) NOT NULL DEFAULT 0,
  `slideshow_effect_duration` int(4) NOT NULL DEFAULT 1,
  `popup_effect_duration` int(4) NOT NULL DEFAULT 1,
  `use_inline_stiles_and_scripts` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_bwg_shortcode` (
  `id` bigint(20) NOT NULL,
  `tagtext` mediumtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_bwg_theme` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `default_theme` tinyint(1) NOT NULL,
  `options` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_defender_audit_log` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` int(11) NOT NULL,
  `event_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `site_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(11) NOT NULL,
  `context` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ip` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `msg` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `blog_id` int(11) NOT NULL,
  `synced` int(11) NOT NULL,
  `ttl` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_defender_email_log` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` int(11) NOT NULL,
  `source` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `to` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_defender_lockout` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ip` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(16) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lockout_message` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `release_time` int(11) DEFAULT NULL,
  `lock_time` int(11) DEFAULT NULL,
  `lock_time_404` int(11) DEFAULT NULL,
  `attempt` int(11) DEFAULT NULL,
  `attempt_404` int(11) DEFAULT NULL,
  `meta` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1188 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_defender_lockout_log` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `log` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date` int(11) DEFAULT NULL,
  `type` varchar(16) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `blog_id` int(11) DEFAULT NULL,
  `tried` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=527 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_defender_scan` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `percent` float NOT NULL,
  `total_tasks` tinyint(4) NOT NULL,
  `task_checkpoint` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_start` datetime NOT NULL,
  `date_end` datetime NOT NULL,
  `is_automation` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_defender_scan_item` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `raw_data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_easy_gallery` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `slug` varchar(30) NOT NULL,
  `description` text NOT NULL,
  `thumbnail` longtext NOT NULL,
  `thumbwidth` int(11) DEFAULT NULL,
  `thumbheight` int(11) DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_easy_gallery_images` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `gid` int(11) NOT NULL,
  `imagePath` longtext NOT NULL,
  `title` varchar(50) NOT NULL,
  `description` longtext NOT NULL,
  `sortOrder` int(11) NOT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=MyISAM AUTO_INCREMENT=295 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_ngg_album` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `previewpic` bigint(20) NOT NULL DEFAULT 0,
  `albumdesc` mediumtext DEFAULT NULL,
  `sortorder` longtext NOT NULL,
  `pageid` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_ngg_gallery` (
  `gid` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `path` mediumtext DEFAULT NULL,
  `title` mediumtext DEFAULT NULL,
  `galdesc` mediumtext DEFAULT NULL,
  `pageid` bigint(20) NOT NULL DEFAULT 0,
  `previewpic` bigint(20) NOT NULL DEFAULT 0,
  `author` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`gid`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_ngg_pictures` (
  `pid` bigint(20) NOT NULL AUTO_INCREMENT,
  `image_slug` varchar(255) NOT NULL,
  `post_id` bigint(20) NOT NULL DEFAULT 0,
  `galleryid` bigint(20) NOT NULL DEFAULT 0,
  `filename` varchar(255) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `alttext` mediumtext DEFAULT NULL,
  `imagedate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `exclude` tinyint(4) DEFAULT 0,
  `sortorder` bigint(20) NOT NULL DEFAULT 0,
  `meta_data` longtext DEFAULT NULL,
  PRIMARY KEY (`pid`),
  KEY `post_id` (`post_id`)
) ENGINE=MyISAM AUTO_INCREMENT=23 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) DEFAULT NULL,
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=263742 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=13362 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `post_name` (`post_name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3491 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_redirects` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `url_from` varchar(256) NOT NULL DEFAULT '',
  `url_to` varchar(256) NOT NULL DEFAULT '',
  `status` varchar(12) NOT NULL DEFAULT '301',
  `type` varchar(12) NOT NULL DEFAULT 'url',
  `count` mediumint(9) NOT NULL DEFAULT 0,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_smush_dir_images` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `path` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `resize` varchar(55) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lossy` varchar(55) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `error` varchar(55) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image_size` int(10) unsigned DEFAULT NULL,
  `orig_size` int(10) unsigned DEFAULT NULL,
  `file_time` int(10) unsigned DEFAULT NULL,
  `last_scan` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `meta` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `path_hash` char(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `path_hash` (`path_hash`),
  KEY `image_size` (`image_size`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_tm_taskmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `task_id` bigint(20) NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `task_id` (`task_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_tm_tasks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `type` varchar(300) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class_identifier` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT '0',
  `attempts` int(11) DEFAULT 0,
  `description` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `time_created` timestamp NOT NULL DEFAULT current_timestamp(),
  `last_locked_at` bigint(20) DEFAULT 0,
  `status` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=262 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfBlockedIPLog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `countryCode` varchar(2) NOT NULL,
  `blockCount` int(10) unsigned NOT NULL DEFAULT 0,
  `unixday` int(10) unsigned NOT NULL,
  `blockType` varchar(50) NOT NULL DEFAULT 'generic',
  PRIMARY KEY (`IP`,`unixday`,`blockType`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfBlocks7` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(10) unsigned NOT NULL DEFAULT 0,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint(20) NOT NULL,
  `reason` varchar(255) NOT NULL,
  `lastAttempt` int(10) unsigned DEFAULT 0,
  `blockedHits` int(10) unsigned DEFAULT 0,
  `expiration` bigint(20) unsigned NOT NULL DEFAULT 0,
  `parameters` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `IP` (`IP`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB AUTO_INCREMENT=423 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfConfig` (
  `name` varchar(100) NOT NULL,
  `val` longblob DEFAULT NULL,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfCrawlers` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `patternSig` binary(16) NOT NULL,
  `status` char(8) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  `PTR` varchar(255) DEFAULT '',
  PRIMARY KEY (`IP`,`patternSig`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_wfFileChanges` (
  `filenameHash` char(64) NOT NULL,
  `file` varchar(1000) NOT NULL,
  `md5` char(32) NOT NULL,
  PRIMARY KEY (`filenameHash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfFileMods` (
  `filenameMD5` binary(16) NOT NULL,
  `filename` varchar(1000) NOT NULL,
  `knownFile` tinyint(3) unsigned NOT NULL,
  `oldMD5` binary(16) NOT NULL,
  `newMD5` binary(16) NOT NULL,
  `SHAC` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `stoppedOnSignature` varchar(255) NOT NULL DEFAULT '',
  `stoppedOnPosition` int(10) unsigned NOT NULL DEFAULT 0,
  `isSafeFile` varchar(1) NOT NULL DEFAULT '?',
  PRIMARY KEY (`filenameMD5`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfHits` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attackLogTime` double(17,6) unsigned NOT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `jsRun` tinyint(4) DEFAULT 0,
  `statusCode` int(11) NOT NULL DEFAULT 0,
  `isGoogle` tinyint(4) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `newVisit` tinyint(3) unsigned NOT NULL,
  `URL` text DEFAULT NULL,
  `referer` text DEFAULT NULL,
  `UA` text DEFAULT NULL,
  `action` varchar(64) NOT NULL DEFAULT '',
  `actionDescription` text DEFAULT NULL,
  `actionData` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`IP`,`ctime`),
  KEY `attackLogTime` (`attackLogTime`)
) ENGINE=MyISAM AUTO_INCREMENT=724081 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_wfHoover` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `owner` text DEFAULT NULL,
  `host` text DEFAULT NULL,
  `path` text DEFAULT NULL,
  `hostKey` varbinary(124) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k2` (`hostKey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfIssues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text DEFAULT NULL,
  `data` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=MyISAM AUTO_INCREMENT=1760 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfKnownFileList` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7451 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfLiveTrafficHuman` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `identifier` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `expiration` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`,`identifier`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfLocs` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int(10) unsigned NOT NULL,
  `failed` tinyint(3) unsigned NOT NULL,
  `city` varchar(255) DEFAULT '',
  `region` varchar(255) DEFAULT '',
  `countryName` varchar(255) DEFAULT '',
  `countryCode` char(2) DEFAULT '',
  `lat` float(10,7) DEFAULT 0.0000000,
  `lon` float(10,7) DEFAULT 0.0000000,
  PRIMARY KEY (`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfLogins` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hitID` int(11) DEFAULT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `fail` tinyint(3) unsigned NOT NULL,
  `action` varchar(40) NOT NULL,
  `username` varchar(255) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `UA` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`IP`,`fail`),
  KEY `hitID` (`hitID`)
) ENGINE=MyISAM AUTO_INCREMENT=21094 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfNotifications` (
  `id` varchar(32) NOT NULL DEFAULT '',
  `new` tinyint(3) unsigned NOT NULL DEFAULT 1,
  `category` varchar(255) NOT NULL,
  `priority` int(11) NOT NULL DEFAULT 1000,
  `ctime` int(10) unsigned NOT NULL,
  `html` text NOT NULL,
  `links` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfPendingIssues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text DEFAULT NULL,
  `data` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfReverseCache` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `host` varchar(255) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_wfSNIPCache` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `IP` varchar(45) NOT NULL DEFAULT '',
  `expiration` timestamp NOT NULL DEFAULT current_timestamp(),
  `body` varchar(255) NOT NULL DEFAULT '',
  `count` int(10) unsigned NOT NULL DEFAULT 0,
  `type` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `expiration` (`expiration`),
  KEY `IP` (`IP`),
  KEY `type` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=604 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfStatus` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `ctime` double(17,6) unsigned NOT NULL,
  `level` tinyint(3) unsigned NOT NULL,
  `type` char(5) NOT NULL,
  `msg` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=251208 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfTrafficRates` (
  `eMin` int(10) unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hitType` enum('hit','404') NOT NULL DEFAULT 'hit',
  `hits` int(10) unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`,`hitType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfls_2fa_secrets` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `secret` tinyblob NOT NULL,
  `recovery` blob NOT NULL,
  `ctime` int(10) unsigned NOT NULL,
  `vtime` int(10) unsigned NOT NULL,
  `mode` enum('authenticator') NOT NULL DEFAULT 'authenticator',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfls_settings` (
  `name` varchar(191) NOT NULL DEFAULT '',
  `value` longblob DEFAULT NULL,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_yoast_indexable` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `permalink` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `permalink_hash` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `object_id` int(11) unsigned DEFAULT NULL,
  `object_type` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `object_sub_type` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `author_id` int(11) unsigned DEFAULT NULL,
  `post_parent` int(11) unsigned DEFAULT NULL,
  `title` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `breadcrumb_title` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT 0,
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int(11) unsigned DEFAULT NULL,
  `canonical` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `primary_focus_keyword` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `primary_focus_keyword_score` int(3) DEFAULT NULL,
  `readability_score` int(3) DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT 0,
  `is_robots_noindex` tinyint(1) DEFAULT 0,
  `is_robots_nofollow` tinyint(1) DEFAULT 0,
  `is_robots_noarchive` tinyint(1) DEFAULT 0,
  `is_robots_noimageindex` tinyint(1) DEFAULT 0,
  `is_robots_nosnippet` tinyint(1) DEFAULT 0,
  `twitter_title` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `twitter_image` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `twitter_description` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `twitter_image_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `twitter_image_source` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `open_graph_title` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `open_graph_description` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `open_graph_image` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `open_graph_image_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `open_graph_image_source` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `open_graph_image_meta` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `link_count` int(11) DEFAULT NULL,
  `incoming_link_count` int(11) DEFAULT NULL,
  `prominent_words_version` int(11) unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  `language` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `region` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `schema_page_type` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `schema_article_type` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`)
) ENGINE=MyISAM AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_yoast_indexable_hierarchy` (
  `indexable_id` int(11) unsigned NOT NULL,
  `ancestor_id` int(11) unsigned NOT NULL,
  `depth` int(11) unsigned DEFAULT NULL,
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_yoast_migrations` (
  `version` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  UNIQUE KEY `idx_wp_yoast_migrations_version` (`version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_yoast_primary_term` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` int(11) unsigned NOT NULL,
  `term_id` int(11) unsigned NOT NULL,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_yoast_seo_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_id` bigint(20) unsigned NOT NULL,
  `target_post_id` bigint(20) unsigned NOT NULL,
  `type` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL,
  `indexable_id` int(11) unsigned DEFAULT NULL,
  `target_indexable_id` int(11) unsigned DEFAULT NULL,
  `height` int(11) unsigned DEFAULT NULL,
  `width` int(11) unsigned DEFAULT NULL,
  `size` int(11) unsigned DEFAULT NULL,
  `language` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `region` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=6860 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_yoast_seo_meta` (
  `object_id` bigint(20) unsigned NOT NULL,
  `internal_link_count` int(10) unsigned DEFAULT NULL,
  `incoming_link_count` int(10) unsigned DEFAULT NULL,
  UNIQUE KEY `object_id` (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


/* INSERT TABLE DATA: wp_bwg_gallery */
INSERT INTO `wp_bwg_gallery` VALUES("1", "Guest Rooms", "guest-rooms", "", "", "", "/thumb/room34towardocean.jpg", "1", "1", "1", "", "", "0", "");
INSERT INTO `wp_bwg_gallery` VALUES("2", "Location Amenities", "location-amenities", "", "", "", "/thumb/motelexterior.jpg", "2", "1", "1", "", "", "0", "");

/* INSERT TABLE DATA: wp_bwg_image */
INSERT INTO `wp_bwg_image` VALUES("1", "1", "Guest Room Baths  ", "Guest Room Bath", "/Guest Room Bath.jpg", "/thumb/Guest Room Bath.jpg", "Guest Room Baths Are Freshly Remodeled In All Rooms", "Guest Room Baths  ", "20 May 2015, 20:08", "446 KB", "JPG", "787 x 1200 px", "1", "21", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("2", "1", "King Efficiency Room     ", "room7deck", "/room7deck.jpg", "/thumb/room7deck.jpg", "Located directly on the beach with oceanfront deck and 100% view of Front Beach and the harbor. One king size bed, sleeps 2. This room includes A/C, cable TV, Wi-Fi, hairdryer, coffee maker, microwave, refrigerator, stove, and sink.", "King Efficiency Room     ", "20 May 2015, 20:07", "272 KB", "JPG", "800 x 517 px", "1", "20", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("3", "1", "King Efficiency Room            ", "room7fromcorner", "/room7fromcorner.jpg", "/thumb/room7fromcorner.jpg", "Located directly on the beach with oceanfront deck and 100% view of Front Beach and the harbor. One king size bed, sleeps 2. This room includes A/C, cable TV, Wi-Fi, hairdryer, coffee maker, microwave, refrigerator, stove, and sink.", "King Efficiency Room            ", "20 May 2015, 20:07", "348 KB", "JPG", "800 x 533 px", "1", "19", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("5", "1", "King Efficiency Room              ", "room7reversed", "/room7reversed.jpg", "/thumb/room7reversed.jpg", "Located directly on the beach with oceanfront deck and 100% view of Front Beach and the harbor. One king size bed, sleeps 2. This room includes A/C, cable TV, Wi-Fi, hairdryer, coffee maker, microwave, refrigerator, stove, and sink.\n", "King Efficiency Room              ", "20 May 2015, 20:07", "327 KB", "JPG", "800 x 467 px", "1", "18", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("6", "1", "King Efficiency Room            ", "room7towater", "/room7towater.jpg", "/thumb/room7towater.jpg", "Located directly on the beach with oceanfront deck and 100% view of Front Beach and the harbor. One king size bed, sleeps 2. This room includes A/C, cable TV, Wi-Fi, hairdryer, coffee maker, microwave, refrigerator, stove, and sink.\n\n", "King Efficiency Room            ", "20 May 2015, 20:07", "296 KB", "JPG", "800 x 460 px", "1", "17", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("7", "1", "Standard Efficiency Suite            ", "room20deck", "/room20deck.jpg", "/thumb/room20deck.jpg", "Located directly on the beach with oceanfront deck and 100% view of Front Beach and the harbor. Two full size beds and a day bed, sleeps 5. This room includes A/C, cable TV, Wi-Fi, hairdryer, coffee maker, microwave, refrigerator, stove, and sink.", "Standard Efficiency Suite            ", "20 May 2015, 20:08", "330 KB", "JPG", "800 x 497 px", "1", "16", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("8", "1", "Standard Efficiency Suite              ", "room20towardkitchen", "/room20towardkitchen.jpg", "/thumb/room20towardkitchen.jpg", "Located directly on the beach with oceanfront deck and 100% view of Front Beach and the harbor. Two full size beds and a day bed, sleeps 5. This room includes A/C, cable TV, Wi-Fi, hairdryer, coffee maker, microwave, refrigerator, stove, and sink.\n", "Standard Efficiency Suite              ", "20 May 2015, 20:08", "293 KB", "JPG", "800 x 472 px", "1", "15", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("9", "1", "Standard Efficiency Suite            ", "room20towater", "/room20towater.jpg", "/thumb/room20towater.jpg", "Located directly on the beach with oceanfront deck and 100% view of Front Beach and the harbor. Two full size beds and a day bed, sleeps 5. This room includes A/C, cable TV, Wi-Fi, hairdryer, coffee maker, microwave, refrigerator, stove, and sink.", "Standard Efficiency Suite            ", "20 May 2015, 20:08", "298 KB", "JPG", "800 x 486 px", "1", "14", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("10", "1", "Queen Room             ", "room23", "/room23.jpg", "/thumb/room23.jpg", "Located directly on the beach with oceanfront deck and 100% view of Front Beach and the harbor. One queen size bed, sleeps 2. This room includes A/C, cable TV, Wi-Fi, coffee maker, microwave, in-room refrigerator and hairdryer.", "Queen Room             ", "20 May 2015, 20:08", "326 KB", "JPG", "800 x 473 px", "1", "13", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("11", "1", "Queen Room             ", "room23deck", "/room23deck.jpg", "/thumb/room23deck.jpg", "Located directly on the beach with oceanfront deck and 100% view of Front Beach and the harbor. One queen size bed, sleeps 2. This room includes A/C, cable TV, Wi-Fi, coffee maker, microwave, in-room refrigerator and hairdryer.", "Queen Room             ", "20 May 2015, 20:08", "281 KB", "JPG", "800 x 533 px", "1", "12", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("12", "1", "Queen Room              ", "room23reversed", "/room23reversed.jpg", "/thumb/room23reversed.jpg", "Located directly on the beach with oceanfront deck and 100% view of Front Beach and the harbor. One queen size bed, sleeps 2. This room includes A/C, cable TV, Wi-Fi, coffee maker, microwave, in-room refrigerator and hairdryer.", "Queen Room              ", "20 May 2015, 20:08", "333 KB", "JPG", "800 x 495 px", "1", "11", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("13", "1", "Standard Room             ", "room26", "/room26.jpg", "/thumb/room26.jpg", "Located directly on the beach with oceanfront deck and 100% view of Front Beach and the harbor. Two full size beds, sleeps 4. This room includes A/C, cable TV, Wi-Fi, coffee maker, microwave, in-room refrigerator and hairdryer.", "Standard Room             ", "20 May 2015, 20:07", "285 KB", "JPG", "800 x 462 px", "1", "10", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("14", "1", "Standard Room              ", "room26deck", "/room26deck.jpg", "/thumb/room26deck.jpg", "Located directly on the beach with oceanfront deck and 100% view of Front Beach and the harbor. Two full size beds, sleeps 4. This room includes A/C, cable TV, Wi-Fi, coffee maker, microwave, in-room refrigerator and hairdryer.\n", "Standard Room              ", "20 May 2015, 20:07", "289 KB", "JPG", "800 x 528 px", "1", "9", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("15", "1", "Standard Room             ", "room26hdr", "/room26hdr.jpg", "/thumb/room26hdr.jpg", "Located directly on the beach with oceanfront deck and 100% view of Front Beach and the harbor. Two full size beds, sleeps 4. This room includes A/C, cable TV, Wi-Fi, coffee maker, microwave, in-room refrigerator and hairdryer.", "Standard Room             ", "20 May 2015, 20:07", "332 KB", "JPG", "800 x 493 px", "1", "8", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("16", "1", "Queen Efficiency                  ", "room28deck", "/room28deck.jpg", "/thumb/room28deck.jpg", "Located directly on the beach with oceanfront deck and 100% view of Front Beach and the harbor. One queen size bed, sleeps 2. This room includes A/C, cable TV, Wi-Fi, hairdryer, coffee maker, microwave, refrigerator, stove, and sink.\n", "Queen Efficiency                  ", "20 May 2015, 20:07", "322 KB", "JPG", "800 x 533 px", "1", "7", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("17", "1", "Queen Efficiency                  ", "room28hdr", "/room28hdr.jpg", "/thumb/room28hdr.jpg", "Located directly on the beach with oceanfront deck and 100% view of Front Beach and the harbor. One queen size bed, sleeps 2. This room includes A/C, cable TV, Wi-Fi, hairdryer, coffee maker, microwave, refrigerator, stove, and sink.\n", "Queen Efficiency                  ", "20 May 2015, 20:07", "377 KB", "JPG", "800 x 533 px", "1", "6", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("18", "1", "Queen Efficiency                ", "room28reversed", "/room28reversed.jpg", "/thumb/room28reversed.jpg", "Located directly on the beach with oceanfront deck and 100% view of Front Beach and the harbor. One queen size bed, sleeps 2. This room includes A/C, cable TV, Wi-Fi, hairdryer, coffee maker, microwave, refrigerator, stove, and sink.\n", "Queen Efficiency                ", "20 May 2015, 20:07", "276 KB", "JPG", "800 x 475 px", "1", "5", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("19", "1", "Queen Efficiency                ", "room28reversedfromslider", "/room28reversedfromslider.jpg", "/thumb/room28reversedfromslider.jpg", "Located directly on the beach with oceanfront deck and 100% view of Front Beach and the harbor. One queen size bed, sleeps 2. This room includes A/C, cable TV, Wi-Fi, hairdryer, coffee maker, microwave, refrigerator, stove, and sink.", "Queen Efficiency                ", "20 May 2015, 20:07", "333 KB", "JPG", "800 x 533 px", "1", "4", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("20", "1", "King Room with Pull Out Sofa      ", "room34deck", "/room34deck.jpg", "/thumb/room34deck.jpg", "Located directly on the beach with oceanfront deck and 100% view of Front Beach and the harbor. One king size bed, and single pull-out, sleeps 3. This room includes A/C, cable TV, Wi-Fi, coffee maker, microwave, in-room refrigerator and hairdryer.\n", "King Room with Pull Out Sofa      ", "20 May 2015, 20:07", "306 KB", "JPG", "800 x 533 px", "1", "3", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("22", "1", "King Room with Pull Out Sofa             ", "room34reverse", "/room34reverse.jpg", "/thumb/room34reverse.jpg", "Located directly on the beach with oceanfront deck and 100% view of Front Beach and the harbor. One king size bed, and single pull-out, sleeps 3. This room includes A/C, cable TV, Wi-Fi, coffee maker, microwave, in-room refrigerator and hairdryer.\n", "King Room with Pull Out Sofa             ", "20 May 2015, 20:07", "248 KB", "JPG", "800 x 455 px", "1", "2", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("23", "1", "King Room with Pull Out Sofa                  ", "room34towardocean", "/room34towardocean.jpg", "/thumb/room34towardocean.jpg", "Located directly on the beach with oceanfront deck and 100% view of Front Beach and the harbor. One king size bed, and single pull-out, sleeps 3. This room includes A/C, cable TV,  Wi-Fi, coffee maker, microwave, in-room refrigerator and hairdryer.\n", "King Room with Pull Out Sofa                  ", "20 May 2015, 20:07", "311 KB", "JPG", "800 x 490 px", "1", "1", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("24", "1", "Sitting Areas Street Side  ", "sittingareafrontside", "/sittingareafrontside.jpg", "/thumb/sittingareafrontside.jpg", "Enjoy Breezes and Sun From Both Sides, The Ocean Side And Beach Street Side", "Sitting Areas Street Side  ", "20 May 2015, 20:07", "472 KB", "JPG", "800 x 615 px", "1", "22", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("36", "2", "Rockport Is A Beautiful, Welcoming Town To Visit", "rockportsign800px", "/rockportsign800px.jpg", "/thumb/rockportsign800px.jpg", "", "Rockport Is A Beautiful, Welcoming Town To Visit", "20 May 2015, 23:52", "67 KB", "JPG", "781 x 347 px", "1", "10", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("26", "2", "Welcome To Captains Bounty On The Beach      ", "motelexterior", "/motelexterior.jpg", "/thumb/motelexterior.jpg", "", "Welcome To Captains Bounty On The Beach      ", "20 May 2015, 21:31", "266 KB", "JPG", "800 x 362 px", "1", "1", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("27", "2", "View Of Our Ocean Front Decks ", "motelfrombeach", "/motelfrombeach.jpg", "/thumb/motelfrombeach.jpg", "", "View Of Our Ocean Front Decks ", "20 May 2015, 21:31", "338 KB", "JPG", "800 x 536 px", "1", "9", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("28", "2", "Another View Of Captains Bounty    ", "motelnorthside", "/motelnorthside.jpg", "/thumb/motelnorthside.jpg", "", "Another View Of Captains Bounty    ", "20 May 2015, 21:31", "314 KB", "JPG", "800 x 445 px", "1", "8", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("29", "2", "An Adjacent Stone Garden Overlooks The Beach       ", "motelsidegardenstones", "/motelsidegardenstones.jpg", "/thumb/motelsidegardenstones.jpg", "", "An Adjacent Stone Garden Overlooks The Beach       ", "20 May 2015, 21:31", "427 KB", "JPG", "800 x 533 px", "1", "7", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("31", "2", "Shops &amp; Restaurants On Bearskin Neck  - A Short Walk Away   ", "bearskinneck", "/bearskinneck.jpg", "/thumb/bearskinneck.jpg", "", "Shops &amp; Restaurants On Bearskin Neck  - A Short Walk Away   ", "20 May 2015, 21:37", "765 KB", "JPG", "1200 x 800 px", "1", "6", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("32", "2", "Shops In The Village At Dock Square - A Short Walk Away    ", "docksquareshop", "/docksquareshop.jpg", "/thumb/docksquareshop.jpg", "", "Shops In The Village At Dock Square - A Short Walk Away    ", "20 May 2015, 21:37", "668 KB", "JPG", "1200 x 800 px", "1", "5", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("33", "2", "Front Beach Is Right Here! We Are Directly On The Beach   ", "frontbeach", "/frontbeach.jpg", "/thumb/frontbeach.jpg", "", "Front Beach Is Right Here! We Are Directly On The Beach   ", "20 May 2015, 21:38", "632 KB", "JPG", "1200 x 800 px", "1", "3", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("34", "2", "All Rooms Have Beachfront Decks  ", "room20deck", "/room20deck.jpg", "/thumb/room20deck.jpg", "", "All Rooms Have Beachfront Decks  ", "20 May 2015, 20:08", "330 KB", "JPG", "800 x 497 px", "1", "2", "1", "0", "0", "0", "0", "", "0");
INSERT INTO `wp_bwg_image` VALUES("35", "2", "Wake To A Beautiful Sunrise  ", "balconysunrise", "/balconysunrise.jpg", "/thumb/balconysunrise.jpg", "", "Wake To A Beautiful Sunrise  ", "20 May 2015, 23:52", "226 KB", "JPG", "1023 x 633 px", "1", "4", "1", "0", "0", "0", "0", "", "0");

/* INSERT TABLE DATA: wp_bwg_option */
INSERT INTO `wp_bwg_option` VALUES("1", "wp-content/uploads", "vertical", "vertical", "0", "100", "5", "30", "180", "90", "300", "300", "1", "none", "5", "30", "hover", "120", "90", "1", "150", "1", "800", "1", "1", "800", "1", "5", "1", "fade", "5", "800", "500", "0", "0", "1", "1", "90", "0", "top-right", "0", "bottom-right", "0", "", "800", "500", "fade", "5", "1", "70", "1", "1", "1", "0", "0", "1", "0", "0", "0", "0", "1", "1", "1", "none", "bottom-left", "90", "90", "http://www.captainsbountymotorinn.com/wp-content/plugins/photo-gallery/images/watermark.png", "web-dorado.com", "https://web-dorado.com", "20", "arial", "FFFFFF", "30", "none", "middle-center", "15", "http://www.captainsbountymotorinn.com/wp-content/plugins/photo-gallery/images/watermark.png", "web-dorado.com", "20", "arial", "FFFFFF", "30", "0", "0", "0", "0", "0", "0", "thumbnail", "0", "0", "0", "180", "0", "10", "open_lightbox", "1", "0", "0", "0", "0", "0", "0", "1200", "1200", "1", "0", "0", "0", "0", "30", "0", "0", "1", "1", "1", "1", "1", "0", "", "300", "300", "5", "5", "0.75", "0", "0", "800", "1", "1", "1", "manage_options", "", "", "0", "0", "0", "", "0", "0", "1", "1", "0");

/* INSERT TABLE DATA: wp_bwg_shortcode */
INSERT INTO `wp_bwg_shortcode` VALUES("1", " gallery_type=\"thumbnails\" theme_id=\"1\" gallery_id=\"1\" sort_by=\"order\" order_by=\"asc\" show_search_box=\"0\" show_sort_images=\"0\" search_box_width=\"180\" image_column_number=\"5\" images_per_page=\"30\" image_title=\"hover\" image_enable_page=\"1\" thumb_width=\"180\" thumb_height=\"90\" thumb_click_action=\"undefined\" thumb_link_target=\"undefined\" popup_fullscreen=\"0\" popup_autoplay=\"0\" popup_width=\"800\" popup_height=\"500\" popup_effect=\"fade\" popup_interval=\"5\" popup_enable_filmstrip=\"1\" popup_filmstrip_height=\"70\" popup_enable_ctrl_btn=\"1\" popup_enable_fullscreen=\"1\" popup_enable_info=\"1\" popup_info_always_show=\"1\" popup_info_full_width=\"0\" popup_enable_rate=\"0\" popup_enable_comment=\"1\" popup_hit_counter=\"0\" popup_enable_facebook=\"1\" popup_enable_twitter=\"1\" popup_enable_google=\"1\" popup_enable_pinterest=\"0\" popup_enable_tumblr=\"0\" watermark_type=\"none\" watermark_link=\"https%3A%2F%2Fweb-dorado.com\"");
INSERT INTO `wp_bwg_shortcode` VALUES("2", " gallery_type=\"thumbnails\" theme_id=\"1\" gallery_id=\"2\" sort_by=\"order\" order_by=\"asc\" show_search_box=\"0\" show_sort_images=\"0\" search_box_width=\"180\" image_column_number=\"5\" images_per_page=\"30\" image_title=\"none\" image_enable_page=\"1\" thumb_width=\"180\" thumb_height=\"90\" thumb_click_action=\"undefined\" thumb_link_target=\"undefined\" popup_fullscreen=\"0\" popup_autoplay=\"0\" popup_width=\"800\" popup_height=\"500\" popup_effect=\"fade\" popup_interval=\"5\" popup_enable_filmstrip=\"1\" popup_filmstrip_height=\"70\" popup_enable_ctrl_btn=\"1\" popup_enable_fullscreen=\"1\" popup_enable_info=\"1\" popup_info_always_show=\"1\" popup_info_full_width=\"0\" popup_enable_rate=\"0\" popup_enable_comment=\"1\" popup_hit_counter=\"0\" popup_enable_facebook=\"1\" popup_enable_twitter=\"1\" popup_enable_google=\"1\" popup_enable_pinterest=\"0\" popup_enable_tumblr=\"0\" watermark_type=\"none\" watermark_link=\"https%3A%2F%2Fweb-dorado.com\"");

/* INSERT TABLE DATA: wp_bwg_theme */
INSERT INTO `wp_bwg_theme` VALUES("1", "Theme 1", "1", "{\"thumb_margin\":\"4\",\"thumb_padding\":\"0\",\"thumb_border_radius\":\"0\",\"thumb_border_width\":\"0\",\"thumb_border_style\":\"none\",\"thumb_border_color\":\"CCCCCC\",\"thumb_bg_color\":\"FFFFFF\",\"thumbs_bg_color\":\"FFFFFF\",\"thumb_bg_transparent\":\"0\",\"thumb_box_shadow\":\"0px 0px 0px #888888\",\"thumb_transparent\":\"100\",\"thumb_align\":\"center\",\"thumb_hover_effect\":\"scale\",\"thumb_hover_effect_value\":\"1.1\",\"thumb_transition\":\"1\",\"thumb_title_font_color\":\"CCCCCC\",\"thumb_title_font_style\":\"segoe ui\",\"thumb_title_pos\":\"bottom\",\"thumb_title_font_size\":\"16\",\"thumb_title_font_weight\":\"bold\",\"thumb_title_margin\":\"2px\",\"thumb_title_shadow\":\"0px 0px 0px #888888\",\"page_nav_position\":\"bottom\",\"page_nav_align\":\"center\",\"page_nav_number\":\"0\",\"page_nav_font_size\":\"12\",\"page_nav_font_style\":\"segoe ui\",\"page_nav_font_color\":\"666666\",\"page_nav_font_weight\":\"bold\",\"page_nav_border_width\":\"1\",\"page_nav_border_style\":\"solid\",\"page_nav_border_color\":\"E3E3E3\",\"page_nav_border_radius\":\"0\",\"page_nav_margin\":\"0\",\"page_nav_padding\":\"3px 6px\",\"page_nav_button_bg_color\":\"FFFFFF\",\"page_nav_button_bg_transparent\":\"100\",\"page_nav_box_shadow\":\"0\",\"page_nav_button_transition\":\"1\",\"page_nav_button_text\":\"0\",\"lightbox_overlay_bg_color\":\"000000\",\"lightbox_overlay_bg_transparent\":\"70\",\"lightbox_bg_color\":\"000000\",\"lightbox_ctrl_btn_pos\":\"bottom\",\"lightbox_ctrl_btn_align\":\"center\",\"lightbox_ctrl_btn_height\":\"20\",\"lightbox_ctrl_btn_margin_top\":\"10\",\"lightbox_ctrl_btn_margin_left\":\"7\",\"lightbox_ctrl_btn_transparent\":\"100\",\"lightbox_ctrl_btn_color\":\"FFFFFF\",\"lightbox_toggle_btn_height\":\"14\",\"lightbox_toggle_btn_width\":\"100\",\"lightbox_ctrl_cont_bg_color\":\"000000\",\"lightbox_ctrl_cont_transparent\":\"65\",\"lightbox_ctrl_cont_border_radius\":\"4\",\"lightbox_close_btn_transparent\":\"100\",\"lightbox_close_btn_bg_color\":\"000000\",\"lightbox_close_btn_border_width\":\"2\",\"lightbox_close_btn_border_radius\":\"16px\",\"lightbox_close_btn_border_style\":\"none\",\"lightbox_close_btn_border_color\":\"FFFFFF\",\"lightbox_close_btn_box_shadow\":\"0\",\"lightbox_close_btn_color\":\"FFFFFF\",\"lightbox_close_btn_size\":\"10\",\"lightbox_close_btn_width\":\"20\",\"lightbox_close_btn_height\":\"20\",\"lightbox_close_btn_top\":\"-10\",\"lightbox_close_btn_right\":\"-10\",\"lightbox_close_btn_full_color\":\"FFFFFF\",\"lightbox_rl_btn_bg_color\":\"000000\",\"lightbox_rl_btn_transparent\":\"80\",\"lightbox_rl_btn_border_radius\":\"20px\",\"lightbox_rl_btn_border_width\":\"0\",\"lightbox_rl_btn_border_style\":\"none\",\"lightbox_rl_btn_border_color\":\"FFFFFF\",\"lightbox_rl_btn_box_shadow\":\"\",\"lightbox_rl_btn_color\":\"FFFFFF\",\"lightbox_rl_btn_height\":\"40\",\"lightbox_rl_btn_width\":\"40\",\"lightbox_rl_btn_size\":\"20\",\"lightbox_close_rl_btn_hover_color\":\"CCCCCC\",\"lightbox_comment_pos\":\"left\",\"lightbox_comment_width\":\"400\",\"lightbox_comment_bg_color\":\"000000\",\"lightbox_comment_font_color\":\"CCCCCC\",\"lightbox_comment_font_style\":\"segoe ui\",\"lightbox_comment_font_size\":\"12\",\"lightbox_comment_button_bg_color\":\"616161\",\"lightbox_comment_button_border_color\":\"666666\",\"lightbox_comment_button_border_width\":\"1\",\"lightbox_comment_button_border_style\":\"none\",\"lightbox_comment_button_border_radius\":\"3px\",\"lightbox_comment_button_padding\":\"3px 10px\",\"lightbox_comment_input_bg_color\":\"333333\",\"lightbox_comment_input_border_color\":\"666666\",\"lightbox_comment_input_border_width\":\"1\",\"lightbox_comment_input_border_style\":\"none\",\"lightbox_comment_input_border_radius\":\"0\",\"lightbox_comment_input_padding\":\"2px\",\"lightbox_comment_separator_width\":\"1\",\"lightbox_comment_separator_style\":\"solid\",\"lightbox_comment_separator_color\":\"383838\",\"lightbox_comment_author_font_size\":\"14\",\"lightbox_comment_date_font_size\":\"10\",\"lightbox_comment_body_font_size\":\"12\",\"lightbox_comment_share_button_color\":\"CCCCCC\",\"lightbox_filmstrip_pos\":\"top\",\"lightbox_filmstrip_rl_bg_color\":\"3B3B3B\",\"lightbox_filmstrip_rl_btn_size\":\"20\",\"lightbox_filmstrip_rl_btn_color\":\"FFFFFF\",\"lightbox_filmstrip_thumb_margin\":\"0 1px\",\"lightbox_filmstrip_thumb_border_width\":\"1\",\"lightbox_filmstrip_thumb_border_style\":\"solid\",\"lightbox_filmstrip_thumb_border_color\":\"000000\",\"lightbox_filmstrip_thumb_border_radius\":\"0\",\"lightbox_filmstrip_thumb_deactive_transparent\":\"80\",\"lightbox_filmstrip_thumb_active_border_width\":\"0\",\"lightbox_filmstrip_thumb_active_border_color\":\"FFFFFF\",\"lightbox_rl_btn_style\":\"fa-chevron\",\"album_compact_back_font_color\":\"000000\",\"album_compact_back_font_style\":\"segoe ui\",\"album_compact_back_font_size\":\"16\",\"album_compact_back_font_weight\":\"bold\",\"album_compact_back_padding\":\"0\",\"album_compact_title_font_color\":\"CCCCCC\",\"album_compact_title_font_style\":\"segoe ui\",\"album_compact_thumb_title_pos\":\"bottom\",\"album_compact_title_font_size\":\"16\",\"album_compact_title_font_weight\":\"bold\",\"album_compact_title_margin\":\"2px\",\"album_compact_title_shadow\":\"0px 0px 0px #888888\",\"album_compact_thumb_margin\":\"4\",\"album_compact_thumb_padding\":\"0\",\"album_compact_thumb_border_radius\":\"0\",\"album_compact_thumb_border_width\":\"0\",\"album_compact_thumb_border_style\":\"none\",\"album_compact_thumb_border_color\":\"CCCCCC\",\"album_compact_thumb_bg_color\":\"FFFFFF\",\"album_compact_thumbs_bg_color\":\"FFFFFF\",\"album_compact_thumb_bg_transparent\":\"0\",\"album_compact_thumb_box_shadow\":\"0px 0px 0px #888888\",\"album_compact_thumb_transparent\":\"100\",\"album_compact_thumb_align\":\"center\",\"album_compact_thumb_hover_effect\":\"scale\",\"album_compact_thumb_hover_effect_value\":\"1.1\",\"album_compact_thumb_transition\":\"0\",\"album_extended_thumb_margin\":\"2\",\"album_extended_thumb_padding\":\"0\",\"album_extended_thumb_border_radius\":\"0\",\"album_extended_thumb_border_width\":\"0\",\"album_extended_thumb_border_style\":\"none\",\"album_extended_thumb_border_color\":\"CCCCCC\",\"album_extended_thumb_bg_color\":\"FFFFFF\",\"album_extended_thumbs_bg_color\":\"FFFFFF\",\"album_extended_thumb_bg_transparent\":\"0\",\"album_extended_thumb_box_shadow\":\"\",\"album_extended_thumb_transparent\":\"100\",\"album_extended_thumb_align\":\"left\",\"album_extended_thumb_hover_effect\":\"scale\",\"album_extended_thumb_hover_effect_value\":\"1.1\",\"album_extended_thumb_transition\":\"0\",\"album_extended_back_font_color\":\"000000\",\"album_extended_back_font_style\":\"segoe ui\",\"album_extended_back_font_size\":\"20\",\"album_extended_back_font_weight\":\"bold\",\"album_extended_back_padding\":\"0\",\"album_extended_div_bg_color\":\"FFFFFF\",\"album_extended_div_bg_transparent\":\"0\",\"album_extended_div_border_radius\":\"0 0 0 0\",\"album_extended_div_margin\":\"0 0 5px 0\",\"album_extended_div_padding\":\"10\",\"album_extended_div_separator_width\":\"1\",\"album_extended_div_separator_style\":\"solid\",\"album_extended_div_separator_color\":\"E0E0E0\",\"album_extended_thumb_div_bg_color\":\"FFFFFF\",\"album_extended_thumb_div_border_radius\":\"0\",\"album_extended_thumb_div_border_width\":\"1\",\"album_extended_thumb_div_border_style\":\"solid\",\"album_extended_thumb_div_border_color\":\"E8E8E8\",\"album_extended_thumb_div_padding\":\"5px\",\"album_extended_text_div_bg_color\":\"FFFFFF\",\"album_extended_text_div_border_radius\":\"0\",\"album_extended_text_div_border_width\":\"1\",\"album_extended_text_div_border_style\":\"solid\",\"album_extended_text_div_border_color\":\"E8E8E8\",\"album_extended_text_div_padding\":\"5px\",\"album_extended_title_span_border_width\":\"1\",\"album_extended_title_span_border_style\":\"none\",\"album_extended_title_span_border_color\":\"CCCCCC\",\"album_extended_title_font_color\":\"000000\",\"album_extended_title_font_style\":\"segoe ui\",\"album_extended_title_font_size\":\"16\",\"album_extended_title_font_weight\":\"bold\",\"album_extended_title_margin_bottom\":\"2\",\"album_extended_title_padding\":\"2px\",\"album_extended_desc_span_border_width\":\"1\",\"album_extended_desc_span_border_style\":\"none\",\"album_extended_desc_span_border_color\":\"CCCCCC\",\"album_extended_desc_font_color\":\"000000\",\"album_extended_desc_font_style\":\"segoe ui\",\"album_extended_desc_font_size\":\"14\",\"album_extended_desc_font_weight\":\"normal\",\"album_extended_desc_padding\":\"2px\",\"album_extended_desc_more_color\":\"F2D22E\",\"album_extended_desc_more_size\":\"12\",\"masonry_thumb_padding\":\"4\",\"masonry_thumb_border_radius\":\"0\",\"masonry_thumb_border_width\":\"0\",\"masonry_thumb_border_style\":\"none\",\"masonry_thumb_border_color\":\"CCCCCC\",\"masonry_thumbs_bg_color\":\"FFFFFF\",\"masonry_thumb_bg_transparent\":\"0\",\"masonry_thumb_transparent\":\"100\",\"masonry_thumb_align\":\"center\",\"masonry_thumb_hover_effect\":\"scale\",\"masonry_thumb_hover_effect_value\":\"1.1\",\"masonry_thumb_transition\":\"0\",\"mosaic_thumb_padding\":\"4\",\"mosaic_thumb_border_radius\":\"0\",\"mosaic_thumb_border_width\":\"0\",\"mosaic_thumb_border_style\":\"none\",\"mosaic_thumb_border_color\":\"CCCCCC\",\"mosaic_thumbs_bg_color\":\"FFFFFF\",\"mosaic_thumb_bg_transparent\":\"0\",\"mosaic_thumb_transparent\":\"100\",\"mosaic_thumb_align\":\"center\",\"mosaic_thumb_hover_effect\":\"scale\",\"mosaic_thumb_hover_effect_value\":\"1.1\",\"mosaic_thumb_title_font_color\":\"CCCCCC\",\"mosaic_thumb_title_font_style\":\"segoe ui\",\"mosaic_thumb_title_font_size\":\"16\",\"mosaic_thumb_title_font_weight\":\"bold\",\"mosaic_thumb_title_margin\":\"2px\",\"mosaic_thumb_title_shadow\":\"0px 0px 0px #888888\",\"slideshow_cont_bg_color\":\"000000\",\"slideshow_close_btn_transparent\":\"100\",\"slideshow_rl_btn_bg_color\":\"000000\",\"slideshow_rl_btn_border_radius\":\"20px\",\"slideshow_rl_btn_border_width\":\"0\",\"slideshow_rl_btn_border_style\":\"none\",\"slideshow_rl_btn_border_color\":\"FFFFFF\",\"slideshow_rl_btn_box_shadow\":\"0px 0px 0px #000000\",\"slideshow_rl_btn_color\":\"FFFFFF\",\"slideshow_rl_btn_height\":\"40\",\"slideshow_rl_btn_size\":\"20\",\"slideshow_rl_btn_width\":\"40\",\"slideshow_close_rl_btn_hover_color\":\"CCCCCC\",\"slideshow_filmstrip_pos\":\"top\",\"slideshow_filmstrip_thumb_border_width\":\"1\",\"slideshow_filmstrip_thumb_border_style\":\"solid\",\"slideshow_filmstrip_thumb_border_color\":\"000000\",\"slideshow_filmstrip_thumb_border_radius\":\"0\",\"slideshow_filmstrip_thumb_margin\":\"0 1px\",\"slideshow_filmstrip_thumb_active_border_width\":\"0\",\"slideshow_filmstrip_thumb_active_border_color\":\"FFFFFF\",\"slideshow_filmstrip_thumb_deactive_transparent\":\"80\",\"slideshow_filmstrip_rl_bg_color\":\"3B3B3B\",\"slideshow_filmstrip_rl_btn_color\":\"FFFFFF\",\"slideshow_filmstrip_rl_btn_size\":\"20\",\"slideshow_title_font_size\":\"16\",\"slideshow_title_font\":\"segoe ui\",\"slideshow_title_color\":\"FFFFFF\",\"slideshow_title_opacity\":\"70\",\"slideshow_title_border_radius\":\"5px\",\"slideshow_title_background_color\":\"000000\",\"slideshow_title_padding\":\"0 0 0 0\",\"slideshow_description_font_size\":\"14\",\"slideshow_description_font\":\"segoe ui\",\"slideshow_description_color\":\"FFFFFF\",\"slideshow_description_opacity\":\"70\",\"slideshow_description_border_radius\":\"0\",\"slideshow_description_background_color\":\"000000\",\"slideshow_description_padding\":\"5px 10px 5px 10px\",\"slideshow_dots_width\":\"12\",\"slideshow_dots_height\":\"12\",\"slideshow_dots_border_radius\":\"5px\",\"slideshow_dots_background_color\":\"F2D22E\",\"slideshow_dots_margin\":\"3\",\"slideshow_dots_active_background_color\":\"FFFFFF\",\"slideshow_dots_active_border_width\":\"1\",\"slideshow_dots_active_border_color\":\"000000\",\"slideshow_play_pause_btn_size\":\"60\",\"slideshow_rl_btn_style\":\"fa-chevron\",\"blog_style_margin\":\"2px\",\"blog_style_padding\":\"0\",\"blog_style_border_radius\":\"0\",\"blog_style_border_width\":\"1\",\"blog_style_border_style\":\"solid\",\"blog_style_border_color\":\"F5F5F5\",\"blog_style_bg_color\":\"FFFFFF\",\"blog_style_box_shadow\":\"\",\"blog_style_transparent\":\"80\",\"blog_style_align\":\"center\",\"blog_style_share_buttons_bg_color\":\"FFFFFF\",\"blog_style_share_buttons_margin\":\"5px auto 10px auto\",\"blog_style_share_buttons_border_radius\":\"0\",\"blog_style_share_buttons_border_width\":\"0\",\"blog_style_share_buttons_border_style\":\"none\",\"blog_style_share_buttons_border_color\":\"000000\",\"blog_style_share_buttons_align\":\"right\",\"blog_style_img_font_size\":\"16\",\"blog_style_img_font_family\":\"segoe ui\",\"blog_style_img_font_color\":\"000000\",\"blog_style_share_buttons_color\":\"B3AFAF\",\"blog_style_share_buttons_bg_transparent\":\"0\",\"blog_style_share_buttons_font_size\":\"20\",\"image_browser_margin\":\"2px auto\",\"image_browser_padding\":\"4px\",\"image_browser_border_radius\":\"0\",\"image_browser_border_width\":\"1\",\"image_browser_border_style\":\"none\",\"image_browser_border_color\":\"F5F5F5\",\"image_browser_bg_color\":\"EBEBEB\",\"image_browser_box_shadow\":\"\",\"image_browser_transparent\":\"80\",\"image_browser_align\":\"center\",\"image_browser_image_description_margin\":\"0px 5px 0px 5px\",\"image_browser_image_description_padding\":\"8px 8px 8px 8px\",\"image_browser_image_description_border_radius\":\"0\",\"image_browser_image_description_border_width\":\"1\",\"image_browser_image_description_border_style\":\"none\",\"image_browser_image_description_border_color\":\"FFFFFF\",\"image_browser_image_description_bg_color\":\"EBEBEB\",\"image_browser_image_description_align\":\"center\",\"image_browser_img_font_size\":\"15\",\"image_browser_img_font_family\":\"segoe ui\",\"image_browser_img_font_color\":\"000000\",\"image_browser_full_padding\":\"4px\",\"image_browser_full_border_radius\":\"0\",\"image_browser_full_border_width\":\"2\",\"image_browser_full_border_style\":\"none\",\"image_browser_full_border_color\":\"F7F7F7\",\"image_browser_full_bg_color\":\"F5F5F5\",\"image_browser_full_transparent\":\"90\",\"lightbox_info_pos\":\"top\",\"lightbox_info_align\":\"right\",\"lightbox_info_bg_color\":\"000000\",\"lightbox_info_bg_transparent\":\"70\",\"lightbox_info_border_width\":\"1\",\"lightbox_info_border_style\":\"none\",\"lightbox_info_border_color\":\"000000\",\"lightbox_info_border_radius\":\"5px\",\"lightbox_info_padding\":\"5px\",\"lightbox_info_margin\":\"15px\",\"lightbox_title_color\":\"FFFFFF\",\"lightbox_title_font_style\":\"segoe ui\",\"lightbox_title_font_weight\":\"bold\",\"lightbox_title_font_size\":\"18\",\"lightbox_description_color\":\"FFFFFF\",\"lightbox_description_font_style\":\"segoe ui\",\"lightbox_description_font_weight\":\"normal\",\"lightbox_description_font_size\":\"14\",\"lightbox_rate_pos\":\"bottom\",\"lightbox_rate_align\":\"right\",\"lightbox_rate_icon\":\"star\",\"lightbox_rate_color\":\"F9D062\",\"lightbox_rate_size\":\"20\",\"lightbox_rate_stars_count\":\"5\",\"lightbox_rate_padding\":\"15px\",\"lightbox_rate_hover_color\":\"F7B50E\",\"lightbox_hit_pos\":\"bottom\",\"lightbox_hit_align\":\"left\",\"lightbox_hit_bg_color\":\"000000\",\"lightbox_hit_bg_transparent\":\"70\",\"lightbox_hit_border_width\":\"1\",\"lightbox_hit_border_style\":\"none\",\"lightbox_hit_border_color\":\"000000\",\"lightbox_hit_border_radius\":\"5px\",\"lightbox_hit_padding\":\"5px\",\"lightbox_hit_margin\":\"0 5px\",\"lightbox_hit_color\":\"FFFFFF\",\"lightbox_hit_font_style\":\"segoe ui\",\"lightbox_hit_font_weight\":\"normal\",\"lightbox_hit_font_size\":\"14\",\"masonry_description_font_size\":\"12\",\"masonry_description_color\":\"CCCCCC\",\"masonry_description_font_style\":\"segoe ui\",\"album_masonry_back_font_color\":\"000000\",\"album_masonry_back_font_style\":\"segoe ui\",\"album_masonry_back_font_size\":\"16\",\"album_masonry_back_font_weight\":\"bold\",\"album_masonry_back_padding\":\"0\",\"album_masonry_title_font_color\":\"CCCCCC\",\"album_masonry_title_font_style\":\"segoe ui\",\"album_masonry_thumb_title_pos\":\"bottom\",\"album_masonry_title_font_size\":\"16\",\"album_masonry_title_font_weight\":\"bold\",\"album_masonry_title_margin\":\"2px\",\"album_masonry_title_shadow\":\"0px 0px 0px #888888\",\"album_masonry_thumb_margin\":\"4\",\"album_masonry_thumb_padding\":\"0\",\"album_masonry_thumb_border_radius\":\"0\",\"album_masonry_thumb_border_width\":\"0\",\"album_masonry_thumb_border_style\":\"none\",\"album_masonry_thumb_border_color\":\"CCCCCC\",\"album_masonry_thumb_bg_color\":\"FFFFFF\",\"album_masonry_thumbs_bg_color\":\"FFFFFF\",\"album_masonry_thumb_bg_transparent\":\"0\",\"album_masonry_thumb_box_shadow\":\"0px 0px 0px #888888\",\"album_masonry_thumb_transparent\":\"100\",\"album_masonry_thumb_align\":\"center\",\"album_masonry_thumb_hover_effect\":\"scale\",\"album_masonry_thumb_hover_effect_value\":\"1.1\",\"album_masonry_thumb_transition\":\"0\",\"carousel_cont_bg_color\":\"000000\",\"carousel_cont_btn_transparent\":\"0\",\"carousel_close_btn_transparent\":\"100\",\"carousel_rl_btn_bg_color\":\"000000\",\"carousel_rl_btn_border_radius\":\"20px\",\"carousel_rl_btn_border_width\":\"0\",\"carousel_rl_btn_border_style\":\"none\",\"carousel_rl_btn_border_color\":\"FFFFFF\",\"carousel_rl_btn_color\":\"FFFFFF\",\"carousel_rl_btn_height\":\"40\",\"carousel_rl_btn_size\":\"20\",\"carousel_play_pause_btn_size\":\"20\",\"carousel_rl_btn_width\":\"40\",\"carousel_close_rl_btn_hover_color\":\"CCCCCC\",\"carousel_rl_btn_style\":\"fa-chevron\",\"carousel_mergin_bottom\":\"0.5\",\"carousel_font_family\":\"Arial\",\"carousel_feature_border_width\":\"2\",\"carousel_feature_border_style\":\"solid\",\"carousel_feature_border_color\":\"5D204F\",\"carousel_caption_background_color\":\"000000\",\"carousel_caption_bottom\":\"0\",\"carousel_caption_p_mergin\":\"0\",\"carousel_caption_p_pedding\":\"5\",\"carousel_caption_p_font_weight\":\"bold\",\"carousel_caption_p_font_size\":\"14\",\"carousel_caption_p_color\":\"white\",\"carousel_title_opacity\":\"100\",\"carousel_title_border_radius\":\"5px\",\"mosaic_thumb_transition\":\"1\"}");
INSERT INTO `wp_bwg_theme` VALUES("2", "Theme 2", "0", "{\"thumb_margin\":\"4\",\"thumb_padding\":\"4\",\"thumb_border_radius\":\"0\",\"thumb_border_width\":\"5\",\"thumb_border_style\":\"none\",\"thumb_border_color\":\"FFFFFF\",\"thumb_bg_color\":\"E8E8E8\",\"thumbs_bg_color\":\"FFFFFF\",\"thumb_bg_transparent\":\"0\",\"thumb_box_shadow\":\"0px 0px 0px #888888\",\"thumb_transparent\":\"100\",\"thumb_align\":\"center\",\"thumb_hover_effect\":\"rotate\",\"thumb_hover_effect_value\":\"2deg\",\"thumb_transition\":\"1\",\"thumb_title_font_color\":\"CCCCCC\",\"thumb_title_font_style\":\"segoe ui\",\"thumb_title_pos\":\"bottom\",\"thumb_title_font_size\":\"16\",\"thumb_title_font_weight\":\"bold\",\"thumb_title_margin\":\"5px\",\"thumb_title_shadow\":\"\",\"page_nav_position\":\"bottom\",\"page_nav_align\":\"center\",\"page_nav_number\":\"0\",\"page_nav_font_size\":\"12\",\"page_nav_font_style\":\"segoe ui\",\"page_nav_font_color\":\"666666\",\"page_nav_font_weight\":\"bold\",\"page_nav_border_width\":\"1\",\"page_nav_border_style\":\"none\",\"page_nav_border_color\":\"E3E3E3\",\"page_nav_border_radius\":\"0\",\"page_nav_margin\":\"0\",\"page_nav_padding\":\"3px 6px\",\"page_nav_button_bg_color\":\"FCFCFC\",\"page_nav_button_bg_transparent\":\"100\",\"page_nav_box_shadow\":\"0\",\"page_nav_button_transition\":\"1\",\"page_nav_button_text\":\"0\",\"lightbox_overlay_bg_color\":\"000000\",\"lightbox_overlay_bg_transparent\":\"70\",\"lightbox_bg_color\":\"000000\",\"lightbox_ctrl_btn_pos\":\"bottom\",\"lightbox_ctrl_btn_align\":\"center\",\"lightbox_ctrl_btn_height\":\"20\",\"lightbox_ctrl_btn_margin_top\":\"10\",\"lightbox_ctrl_btn_margin_left\":\"7\",\"lightbox_ctrl_btn_transparent\":\"80\",\"lightbox_ctrl_btn_color\":\"FFFFFF\",\"lightbox_toggle_btn_height\":\"14\",\"lightbox_toggle_btn_width\":\"100\",\"lightbox_ctrl_cont_bg_color\":\"000000\",\"lightbox_ctrl_cont_transparent\":\"80\",\"lightbox_ctrl_cont_border_radius\":\"4\",\"lightbox_close_btn_transparent\":\"95\",\"lightbox_close_btn_bg_color\":\"000000\",\"lightbox_close_btn_border_width\":\"0\",\"lightbox_close_btn_border_radius\":\"16px\",\"lightbox_close_btn_border_style\":\"none\",\"lightbox_close_btn_border_color\":\"FFFFFF\",\"lightbox_close_btn_box_shadow\":\"\",\"lightbox_close_btn_color\":\"FFFFFF\",\"lightbox_close_btn_size\":\"10\",\"lightbox_close_btn_width\":\"20\",\"lightbox_close_btn_height\":\"20\",\"lightbox_close_btn_top\":\"-10\",\"lightbox_close_btn_right\":\"-10\",\"lightbox_close_btn_full_color\":\"FFFFFF\",\"lightbox_rl_btn_bg_color\":\"000000\",\"lightbox_rl_btn_transparent\":\"80\",\"lightbox_rl_btn_border_radius\":\"20px\",\"lightbox_rl_btn_border_width\":\"2\",\"lightbox_rl_btn_border_style\":\"none\",\"lightbox_rl_btn_border_color\":\"FFFFFF\",\"lightbox_rl_btn_box_shadow\":\"\",\"lightbox_rl_btn_color\":\"FFFFFF\",\"lightbox_rl_btn_height\":\"40\",\"lightbox_rl_btn_width\":\"40\",\"lightbox_rl_btn_size\":\"20\",\"lightbox_close_rl_btn_hover_color\":\"FFFFFF\",\"lightbox_comment_pos\":\"left\",\"lightbox_comment_width\":\"400\",\"lightbox_comment_bg_color\":\"000000\",\"lightbox_comment_font_color\":\"CCCCCC\",\"lightbox_comment_font_style\":\"arial\",\"lightbox_comment_font_size\":\"12\",\"lightbox_comment_button_bg_color\":\"333333\",\"lightbox_comment_button_border_color\":\"666666\",\"lightbox_comment_button_border_width\":\"1\",\"lightbox_comment_button_border_style\":\"none\",\"lightbox_comment_button_border_radius\":\"3px\",\"lightbox_comment_button_padding\":\"3px 10px\",\"lightbox_comment_input_bg_color\":\"333333\",\"lightbox_comment_input_border_color\":\"666666\",\"lightbox_comment_input_border_width\":\"1\",\"lightbox_comment_input_border_style\":\"none\",\"lightbox_comment_input_border_radius\":\"0\",\"lightbox_comment_input_padding\":\"3px\",\"lightbox_comment_separator_width\":\"1\",\"lightbox_comment_separator_style\":\"solid\",\"lightbox_comment_separator_color\":\"2B2B2B\",\"lightbox_comment_author_font_size\":\"14\",\"lightbox_comment_date_font_size\":\"10\",\"lightbox_comment_body_font_size\":\"12\",\"lightbox_comment_share_button_color\":\"FFFFFF\",\"lightbox_filmstrip_pos\":\"top\",\"lightbox_filmstrip_rl_bg_color\":\"2B2B2B\",\"lightbox_filmstrip_rl_btn_size\":\"20\",\"lightbox_filmstrip_rl_btn_color\":\"FFFFFF\",\"lightbox_filmstrip_thumb_margin\":\"0 1px\",\"lightbox_filmstrip_thumb_border_width\":\"1\",\"lightbox_filmstrip_thumb_border_style\":\"none\",\"lightbox_filmstrip_thumb_border_color\":\"000000\",\"lightbox_filmstrip_thumb_border_radius\":\"0\",\"lightbox_filmstrip_thumb_deactive_transparent\":\"80\",\"lightbox_filmstrip_thumb_active_border_width\":\"0\",\"lightbox_filmstrip_thumb_active_border_color\":\"FFFFFF\",\"lightbox_rl_btn_style\":\"fa-chevron\",\"album_compact_back_font_color\":\"000000\",\"album_compact_back_font_style\":\"segoe ui\",\"album_compact_back_font_size\":\"14\",\"album_compact_back_font_weight\":\"normal\",\"album_compact_back_padding\":\"0\",\"album_compact_title_font_color\":\"CCCCCC\",\"album_compact_title_font_style\":\"segoe ui\",\"album_compact_thumb_title_pos\":\"bottom\",\"album_compact_title_font_size\":\"16\",\"album_compact_title_font_weight\":\"bold\",\"album_compact_title_margin\":\"5px\",\"album_compact_title_shadow\":\"\",\"album_compact_thumb_margin\":\"4\",\"album_compact_thumb_padding\":\"4\",\"album_compact_thumb_border_radius\":\"0\",\"album_compact_thumb_border_width\":\"1\",\"album_compact_thumb_border_style\":\"none\",\"album_compact_thumb_border_color\":\"000000\",\"album_compact_thumb_bg_color\":\"E8E8E8\",\"album_compact_thumbs_bg_color\":\"FFFFFF\",\"album_compact_thumb_bg_transparent\":\"100\",\"album_compact_thumb_box_shadow\":\"\",\"album_compact_thumb_transparent\":\"100\",\"album_compact_thumb_align\":\"center\",\"album_compact_thumb_hover_effect\":\"rotate\",\"album_compact_thumb_hover_effect_value\":\"2deg\",\"album_compact_thumb_transition\":\"1\",\"album_extended_thumb_margin\":\"2\",\"album_extended_thumb_padding\":\"4\",\"album_extended_thumb_border_radius\":\"0\",\"album_extended_thumb_border_width\":\"4\",\"album_extended_thumb_border_style\":\"none\",\"album_extended_thumb_border_color\":\"E8E8E8\",\"album_extended_thumb_bg_color\":\"E8E8E8\",\"album_extended_thumbs_bg_color\":\"FFFFFF\",\"album_extended_thumb_bg_transparent\":\"100\",\"album_extended_thumb_box_shadow\":\"\",\"album_extended_thumb_transparent\":\"100\",\"album_extended_thumb_align\":\"left\",\"album_extended_thumb_hover_effect\":\"rotate\",\"album_extended_thumb_hover_effect_value\":\"2deg\",\"album_extended_thumb_transition\":\"0\",\"album_extended_back_font_color\":\"000000\",\"album_extended_back_font_style\":\"segoe ui\",\"album_extended_back_font_size\":\"16\",\"album_extended_back_font_weight\":\"bold\",\"album_extended_back_padding\":\"0\",\"album_extended_div_bg_color\":\"FFFFFF\",\"album_extended_div_bg_transparent\":\"0\",\"album_extended_div_border_radius\":\"0\",\"album_extended_div_margin\":\"0 0 5px 0\",\"album_extended_div_padding\":\"10\",\"album_extended_div_separator_width\":\"1\",\"album_extended_div_separator_style\":\"none\",\"album_extended_div_separator_color\":\"CCCCCC\",\"album_extended_thumb_div_bg_color\":\"FFFFFF\",\"album_extended_thumb_div_border_radius\":\"0\",\"album_extended_thumb_div_border_width\":\"0\",\"album_extended_thumb_div_border_style\":\"none\",\"album_extended_thumb_div_border_color\":\"CCCCCC\",\"album_extended_thumb_div_padding\":\"0\",\"album_extended_text_div_bg_color\":\"FFFFFF\",\"album_extended_text_div_border_radius\":\"0\",\"album_extended_text_div_border_width\":\"1\",\"album_extended_text_div_border_style\":\"none\",\"album_extended_text_div_border_color\":\"CCCCCC\",\"album_extended_text_div_padding\":\"5px\",\"album_extended_title_span_border_width\":\"1\",\"album_extended_title_span_border_style\":\"none\",\"album_extended_title_span_border_color\":\"CCCCCC\",\"album_extended_title_font_color\":\"000000\",\"album_extended_title_font_style\":\"segoe ui\",\"album_extended_title_font_size\":\"16\",\"album_extended_title_font_weight\":\"bold\",\"album_extended_title_margin_bottom\":\"2\",\"album_extended_title_padding\":\"2px\",\"album_extended_desc_span_border_width\":\"1\",\"album_extended_desc_span_border_style\":\"none\",\"album_extended_desc_span_border_color\":\"CCCCCC\",\"album_extended_desc_font_color\":\"000000\",\"album_extended_desc_font_style\":\"segoe ui\",\"album_extended_desc_font_size\":\"14\",\"album_extended_desc_font_weight\":\"normal\",\"album_extended_desc_padding\":\"2px\",\"album_extended_desc_more_color\":\"FFC933\",\"album_extended_desc_more_size\":\"12\",\"masonry_thumb_padding\":\"4\",\"masonry_thumb_border_radius\":\"2px\",\"masonry_thumb_border_width\":\"1\",\"masonry_thumb_border_style\":\"none\",\"masonry_thumb_border_color\":\"CCCCCC\",\"masonry_thumbs_bg_color\":\"FFFFFF\",\"masonry_thumb_bg_transparent\":\"0\",\"masonry_thumb_transparent\":\"80\",\"masonry_thumb_align\":\"center\",\"masonry_thumb_hover_effect\":\"rotate\",\"masonry_thumb_hover_effect_value\":\"2deg\",\"masonry_thumb_transition\":\"0\",\"mosaic_thumb_padding\":\"4\",\"mosaic_thumb_border_radius\":\"2px\",\"mosaic_thumb_border_width\":\"1\",\"mosaic_thumb_border_style\":\"none\",\"mosaic_thumb_border_color\":\"CCCCCC\",\"mosaic_thumbs_bg_color\":\"FFFFFF\",\"mosaic_thumb_bg_transparent\":\"0\",\"mosaic_thumb_transparent\":\"80\",\"mosaic_thumb_align\":\"center\",\"mosaic_thumb_hover_effect\":\"rotate\",\"mosaic_thumb_hover_effect_value\":\"2deg\",\"mosaic_thumb_title_font_color\":\"CCCCCC\",\"mosaic_thumb_title_font_style\":\"segoe ui\",\"mosaic_thumb_title_font_size\":\"16\",\"mosaic_thumb_title_font_weight\":\"bold\",\"mosaic_thumb_title_margin\":\"2px\",\"mosaic_thumb_title_shadow\":\"0px 0px 0px #888888\",\"slideshow_cont_bg_color\":\"000000\",\"slideshow_close_btn_transparent\":\"100\",\"slideshow_rl_btn_bg_color\":\"000000\",\"slideshow_rl_btn_border_radius\":\"20px\",\"slideshow_rl_btn_border_width\":\"0\",\"slideshow_rl_btn_border_style\":\"none\",\"slideshow_rl_btn_border_color\":\"FFFFFF\",\"slideshow_rl_btn_box_shadow\":\"\",\"slideshow_rl_btn_color\":\"FFFFFF\",\"slideshow_rl_btn_height\":\"40\",\"slideshow_rl_btn_size\":\"20\",\"slideshow_rl_btn_width\":\"40\",\"slideshow_close_rl_btn_hover_color\":\"DBDBDB\",\"slideshow_filmstrip_pos\":\"bottom\",\"slideshow_filmstrip_thumb_border_width\":\"1\",\"slideshow_filmstrip_thumb_border_style\":\"none\",\"slideshow_filmstrip_thumb_border_color\":\"000000\",\"slideshow_filmstrip_thumb_border_radius\":\"0\",\"slideshow_filmstrip_thumb_margin\":\"0 1px\",\"slideshow_filmstrip_thumb_active_border_width\":\"0\",\"slideshow_filmstrip_thumb_active_border_color\":\"FFFFFF\",\"slideshow_filmstrip_thumb_deactive_transparent\":\"80\",\"slideshow_filmstrip_rl_bg_color\":\"303030\",\"slideshow_filmstrip_rl_btn_color\":\"FFFFFF\",\"slideshow_filmstrip_rl_btn_size\":\"20\",\"slideshow_title_font_size\":\"16\",\"slideshow_title_font\":\"segoe ui\",\"slideshow_title_color\":\"FFFFFF\",\"slideshow_title_opacity\":\"70\",\"slideshow_title_border_radius\":\"5px\",\"slideshow_title_background_color\":\"000000\",\"slideshow_title_padding\":\"5px 10px 5px 10px\",\"slideshow_description_font_size\":\"14\",\"slideshow_description_font\":\"segoe ui\",\"slideshow_description_color\":\"FFFFFF\",\"slideshow_description_opacity\":\"70\",\"slideshow_description_border_radius\":\"0\",\"slideshow_description_background_color\":\"000000\",\"slideshow_description_padding\":\"5px 10px 5px 10px\",\"slideshow_dots_width\":\"10\",\"slideshow_dots_height\":\"10\",\"slideshow_dots_border_radius\":\"10px\",\"slideshow_dots_background_color\":\"292929\",\"slideshow_dots_margin\":\"1\",\"slideshow_dots_active_background_color\":\"292929\",\"slideshow_dots_active_border_width\":\"2\",\"slideshow_dots_active_border_color\":\"FFC933\",\"slideshow_play_pause_btn_size\":\"60\",\"slideshow_rl_btn_style\":\"fa-chevron\",\"blog_style_margin\":\"2px\",\"blog_style_padding\":\"4px\",\"blog_style_border_radius\":\"0\",\"blog_style_border_width\":\"1\",\"blog_style_border_style\":\"none\",\"blog_style_border_color\":\"CCCCCC\",\"blog_style_bg_color\":\"E8E8E8\",\"blog_style_box_shadow\":\"\",\"blog_style_transparent\":\"70\",\"blog_style_align\":\"center\",\"blog_style_share_buttons_bg_color\":\"FFFFFF\",\"blog_style_share_buttons_margin\":\"5px auto 10px auto\",\"blog_style_share_buttons_border_radius\":\"0\",\"blog_style_share_buttons_border_width\":\"0\",\"blog_style_share_buttons_border_style\":\"none\",\"blog_style_share_buttons_border_color\":\"000000\",\"blog_style_share_buttons_align\":\"right\",\"blog_style_img_font_size\":\"16\",\"blog_style_img_font_family\":\"segoe ui\",\"blog_style_img_font_color\":\"000000\",\"blog_style_share_buttons_color\":\"A1A1A1\",\"blog_style_share_buttons_bg_transparent\":\"0\",\"blog_style_share_buttons_font_size\":\"20\",\"image_browser_margin\":\"2px auto\",\"image_browser_padding\":\"4px\",\"image_browser_border_radius\":\"2px\",\"image_browser_border_width\":\"1\",\"image_browser_border_style\":\"none\",\"image_browser_border_color\":\"E8E8E8\",\"image_browser_bg_color\":\"E8E8E8\",\"image_browser_box_shadow\":\"\",\"image_browser_transparent\":\"80\",\"image_browser_align\":\"center\",\"image_browser_image_description_margin\":\"24px 0px 0px 0px\",\"image_browser_image_description_padding\":\"8px 8px 8px 8px\",\"image_browser_image_description_border_radius\":\"0\",\"image_browser_image_description_border_width\":\"1\",\"image_browser_image_description_border_style\":\"none\",\"image_browser_image_description_border_color\":\"FFFFFF\",\"image_browser_image_description_bg_color\":\"E8E8E8\",\"image_browser_image_description_align\":\"center\",\"image_browser_img_font_size\":\"14\",\"image_browser_img_font_family\":\"segoe ui\",\"image_browser_img_font_color\":\"000000\",\"image_browser_full_padding\":\"4px\",\"image_browser_full_border_radius\":\"0\",\"image_browser_full_border_width\":\"1\",\"image_browser_full_border_style\":\"solid\",\"image_browser_full_border_color\":\"EDEDED\",\"image_browser_full_bg_color\":\"FFFFFF\",\"image_browser_full_transparent\":\"90\",\"lightbox_info_pos\":\"top\",\"lightbox_info_align\":\"right\",\"lightbox_info_bg_color\":\"000000\",\"lightbox_info_bg_transparent\":\"70\",\"lightbox_info_border_width\":\"1\",\"lightbox_info_border_style\":\"none\",\"lightbox_info_border_color\":\"000000\",\"lightbox_info_border_radius\":\"5px\",\"lightbox_info_padding\":\"5px\",\"lightbox_info_margin\":\"15px\",\"lightbox_title_color\":\"FFFFFF\",\"lightbox_title_font_style\":\"segoe ui\",\"lightbox_title_font_weight\":\"bold\",\"lightbox_title_font_size\":\"18\",\"lightbox_description_color\":\"FFFFFF\",\"lightbox_description_font_style\":\"segoe ui\",\"lightbox_description_font_weight\":\"normal\",\"lightbox_description_font_size\":\"14\",\"lightbox_rate_pos\":\"bottom\",\"lightbox_rate_align\":\"right\",\"lightbox_rate_icon\":\"star\",\"lightbox_rate_color\":\"F9D062\",\"lightbox_rate_size\":\"20\",\"lightbox_rate_stars_count\":\"5\",\"lightbox_rate_padding\":\"15px\",\"lightbox_rate_hover_color\":\"F7B50E\",\"lightbox_hit_pos\":\"bottom\",\"lightbox_hit_align\":\"left\",\"lightbox_hit_bg_color\":\"000000\",\"lightbox_hit_bg_transparent\":\"70\",\"lightbox_hit_border_width\":\"1\",\"lightbox_hit_border_style\":\"none\",\"lightbox_hit_border_color\":\"000000\",\"lightbox_hit_border_radius\":\"5px\",\"lightbox_hit_padding\":\"5px\",\"lightbox_hit_margin\":\"0 5px\",\"lightbox_hit_color\":\"FFFFFF\",\"lightbox_hit_font_style\":\"segoe ui\",\"lightbox_hit_font_weight\":\"normal\",\"lightbox_hit_font_size\":\"14\",\"masonry_description_font_size\":\"12\",\"masonry_description_color\":\"CCCCCC\",\"masonry_description_font_style\":\"segoe ui\",\"album_masonry_back_font_color\":\"000000\",\"album_masonry_back_font_style\":\"segoe ui\",\"album_masonry_back_font_size\":\"14\",\"album_masonry_back_font_weight\":\"normal\",\"album_masonry_back_padding\":\"0\",\"album_masonry_title_font_color\":\"CCCCCC\",\"album_masonry_title_font_style\":\"segoe ui\",\"album_masonry_thumb_title_pos\":\"bottom\",\"album_masonry_title_font_size\":\"16\",\"album_masonry_title_font_weight\":\"bold\",\"album_masonry_title_margin\":\"5px\",\"album_masonry_title_shadow\":\"\",\"album_masonry_thumb_margin\":\"4\",\"album_masonry_thumb_padding\":\"4\",\"album_masonry_thumb_border_radius\":\"0\",\"album_masonry_thumb_border_width\":\"1\",\"album_masonry_thumb_border_style\":\"none\",\"album_masonry_thumb_border_color\":\"000000\",\"album_masonry_thumb_bg_color\":\"E8E8E8\",\"album_masonry_thumbs_bg_color\":\"FFFFFF\",\"album_masonry_thumb_bg_transparent\":\"100\",\"album_masonry_thumb_box_shadow\":\"\",\"album_masonry_thumb_transparent\":\"100\",\"album_masonry_thumb_align\":\"center\",\"album_masonry_thumb_hover_effect\":\"rotate\",\"album_masonry_thumb_hover_effect_value\":\"2deg\",\"album_masonry_thumb_transition\":\"1\",\"carousel_cont_bg_color\":\"000000\",\"carousel_cont_btn_transparent\":\"0\",\"carousel_close_btn_transparent\":\"100\",\"carousel_rl_btn_bg_color\":\"000000\",\"carousel_rl_btn_border_radius\":\"20px\",\"carousel_rl_btn_border_width\":\"0\",\"carousel_rl_btn_border_style\":\"none\",\"carousel_rl_btn_border_color\":\"FFFFFF\",\"carousel_rl_btn_color\":\"FFFFFF\",\"carousel_rl_btn_height\":\"40\",\"carousel_rl_btn_size\":\"20\",\"carousel_play_pause_btn_size\":\"20\",\"carousel_rl_btn_width\":\"40\",\"carousel_close_rl_btn_hover_color\":\"CCCCCC\",\"carousel_rl_btn_style\":\"fa-chevron\",\"carousel_mergin_bottom\":\"0.5\",\"carousel_font_family\":\"Arial\",\"carousel_feature_border_width\":\"2\",\"carousel_feature_border_style\":\"solid\",\"carousel_feature_border_color\":\"5D204F\",\"carousel_caption_background_color\":\"000000\",\"carousel_caption_bottom\":\"0\",\"carousel_caption_p_mergin\":\"0\",\"carousel_caption_p_pedding\":\"5\",\"carousel_caption_p_font_weight\":\"bold\",\"carousel_caption_p_font_size\":\"14\",\"carousel_caption_p_color\":\"white\",\"carousel_title_opacity\":\"100\",\"carousel_title_border_radius\":\"5px\",\"mosaic_thumb_transition\":\"1\"}");

/* INSERT TABLE DATA: wp_defender_lockout */
INSERT INTO `wp_defender_lockout` VALUES("1", "192.34.62.252", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("2", "128.199.22.146", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("3", "165.22.89.96", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("4", "73.234.27.226", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("5", "159.89.48.56", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("6", "51.89.204.170", "normal", "", "0", "0", "0", "0", "5", "{\"nf\":[1606246635,1606258249,1606430844,1606796897,1606902964]}");
INSERT INTO `wp_defender_lockout` VALUES("7", "51.254.118.224", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("8", "192.95.30.59", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("9", "208.64.115.10", "normal", "", "0", "0", "0", "0", "2", "{\"nf\":[1606247281,1606247283]}");
INSERT INTO `wp_defender_lockout` VALUES("10", "162.208.51.46", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("11", "82.223.104.73", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("12", "67.225.140.63", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("13", "62.210.113.228", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("14", "198.57.179.233", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("15", "51.91.123.235", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("16", "39.99.54.47", "normal", "", "0", "0", "0", "0", "2", "{\"nf\":[1606249324,1606592360]}");
INSERT INTO `wp_defender_lockout` VALUES("17", "18.221.227.81", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("18", "13.66.139.51", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("19", "192.34.61.86", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("20", "176.31.123.203", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("21", "212.86.109.31", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("22", "185.209.20.147", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("23", "45.132.107.248", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("24", "85.209.89.217", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("25", "85.209.89.216", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("26", "85.209.89.224", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("27", "111.89.169.113", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("28", "203.127.92.151", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("29", "193.124.188.188", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("30", "185.125.219.13", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("31", "194.67.207.94", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("32", "185.5.249.185", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("33", "37.97.4.238", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("34", "138.128.13.83", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("35", "104.196.140.128", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("36", "148.72.211.177", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("37", "41.93.82.7", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("38", "91.134.201.164", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("39", "157.230.118.118", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("40", "154.12.163.150", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("41", "92.204.128.148", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("42", "144.173.113.31", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("43", "185.75.90.36", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("44", "158.69.248.120", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("45", "198.12.250.116", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("46", "51.38.187.198", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("47", "35.224.1.87", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("48", "80.253.244.42", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("49", "3.6.71.62", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("50", "205.169.39.141", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606257534]}");
INSERT INTO `wp_defender_lockout` VALUES("51", "196.50.13.218", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("52", "104.248.172.238", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("53", "45.92.247.34", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("54", "178.128.68.121", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("55", "128.199.152.154", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("56", "149.28.164.108", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("57", "139.99.148.4", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("58", "193.128.111.41", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("59", "13.66.139.108", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("60", "51.91.80.176", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("61", "47.244.166.23", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("62", "92.222.76.0", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("63", "112.78.3.130", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("64", "51.38.187.226", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("65", "67.205.129.197", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("66", "178.62.101.107", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("67", "178.62.252.206", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("68", "157.245.42.253", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("69", "70.88.133.182", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("70", "196.18.1.221", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("71", "165.227.61.152", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("72", "37.187.129.227", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("73", "72.167.226.88", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("74", "139.99.69.189", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("75", "35.202.232.139", "normal", "", "0", "0", "0", "0", "2", "{\"nf\":[1606265945,1606288904]}");
INSERT INTO `wp_defender_lockout` VALUES("76", "161.35.36.90", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("77", "23.228.109.146", "normal", "", "0", "0", "0", "0", "10", "{\"nf\":[1606266725,1606359238,1606474310,1606534107,1606616924,1606703751,1606790344,1606879592,1606964418,1607009352]}");
INSERT INTO `wp_defender_lockout` VALUES("78", "121.201.59.134", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("79", "185.224.132.45", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("80", "185.241.52.68", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("81", "185.203.240.129", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("82", "77.220.215.153", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("83", "85.209.89.241", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("84", "85.209.89.205", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("85", "193.124.188.83", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("86", "194.67.210.77", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("87", "193.124.190.18", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("88", "194.67.207.9", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("89", "193.124.191.92", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("90", "157.245.37.203", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("91", "51.91.127.200", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("92", "35.202.25.83", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("93", "51.83.41.131", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("94", "212.85.69.14", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("95", "52.188.20.172", "normal", "You have been locked out due to too many attempts to access a file that doesn\'t exist.", "1606351404", "0", "1606351104", "0", "49", "{\"nf\":[1606399109,1606399121,1606399134,1606399158,1606399174,1606399191,1606399199,1606399223],\"login\":[]}");
INSERT INTO `wp_defender_lockout` VALUES("96", "145.239.211.242", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("97", "104.236.61.133", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("98", "104.248.61.198", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("99", "54.244.59.102", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("100", "54.218.45.235", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("101", "52.13.16.182", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("102", "184.168.152.176", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("103", "108.167.133.25", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606274942]}");
INSERT INTO `wp_defender_lockout` VALUES("104", "198.71.238.8", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("105", "198.71.238.8", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("106", "160.153.154.29", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("107", "160.153.154.29", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("108", "192.111.135.210", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("109", "103.237.147.16", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606274968]}");
INSERT INTO `wp_defender_lockout` VALUES("110", "103.237.147.16", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606274968]}");
INSERT INTO `wp_defender_lockout` VALUES("111", "183.91.78.211", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("112", "183.91.78.211", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("113", "173.201.196.63", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("114", "173.201.196.63", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("115", "166.62.37.69", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("116", "91.93.127.34", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606275248]}");
INSERT INTO `wp_defender_lockout` VALUES("117", "173.201.196.146", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606275272]}");
INSERT INTO `wp_defender_lockout` VALUES("118", "50.63.196.28", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606275379]}");
INSERT INTO `wp_defender_lockout` VALUES("119", "23.100.232.233", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("120", "107.180.121.22", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("121", "134.209.58.167", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("122", "39.104.208.50", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("123", "52.38.178.69", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("124", "66.249.64.1", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("125", "104.192.0.122", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606402366]}");
INSERT INTO `wp_defender_lockout` VALUES("126", "138.68.80.235", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("127", "131.220.6.152", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("128", "142.93.99.56", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("129", "35.189.223.35", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("130", "165.22.40.128", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("131", "157.55.39.189", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("132", "64.227.27.221", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("133", "95.107.164.12", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606286482]}");
INSERT INTO `wp_defender_lockout` VALUES("134", "178.128.158.86", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("135", "81.111.214.118", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("136", "94.153.224.202", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("137", "193.106.30.100", "normal", "", "0", "0", "0", "0", "11", "{\"nf\":[1606287200,1606341312,1606390934,1606429404,1606493374,1606590359,1606633117,1606650483,1606681282,1606780062,1606824844]}");
INSERT INTO `wp_defender_lockout` VALUES("138", "54.37.21.211", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("139", "198.211.117.96", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("140", "207.46.13.9", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("141", "51.75.142.24", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("142", "89.248.171.187", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("143", "188.165.228.82", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("144", "107.77.70.88", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("145", "107.77.223.214", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("146", "204.15.110.165", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606290208]}");
INSERT INTO `wp_defender_lockout` VALUES("147", "178.62.33.71", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("148", "159.89.123.66", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("149", "157.230.243.22", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("150", "167.99.78.164", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("151", "66.246.224.12", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("152", "122.15.66.219", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("153", "163.172.42.173", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("154", "83.139.0.16", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("155", "51.79.85.154", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("156", "114.119.158.58", "normal", "", "0", "0", "0", "0", "2", "{\"nf\":[1606294585,1606771135]}");
INSERT INTO `wp_defender_lockout` VALUES("157", "51.38.211.30", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("158", "107.189.10.27", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606543657]}");
INSERT INTO `wp_defender_lockout` VALUES("159", "157.230.96.179", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("160", "107.180.88.41", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("161", "188.165.239.119", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("162", "66.249.64.9", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("163", "173.249.52.86", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("164", "54.37.17.21", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("165", "35.243.252.220", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("166", "188.166.233.216", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("167", "223.88.196.245", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606298304]}");
INSERT INTO `wp_defender_lockout` VALUES("168", "34.80.37.211", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("169", "67.225.241.126", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("170", "165.227.86.14", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("171", "13.94.245.44", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("172", "49.255.35.114", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("173", "158.69.250.210", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("174", "140.82.26.13", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("175", "87.233.227.232", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("176", "67.205.31.50", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("177", "139.59.146.28", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("178", "15.161.33.29", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("179", "78.142.211.53", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("180", "116.202.244.246", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("181", "116.202.101.142", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("182", "216.144.248.186", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("183", "8.210.146.161", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("184", "139.59.180.212", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("185", "52.177.121.220", "normal", "", "0", "0", "0", "0", "12", "{\"nf\":[1606306225,1606505630,1606508581,1606517193,1606735454,1606735461,1606884638,1606884658,1606891462,1606891471,1606903107,1606903139]}");
INSERT INTO `wp_defender_lockout` VALUES("186", "128.199.115.160", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("187", "34.90.25.58", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("188", "66.249.70.11", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("189", "66.249.70.25", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("190", "66.249.64.13", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("191", "34.70.198.5", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("192", "35.194.119.129", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("193", "66.249.64.31", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("194", "104.248.29.200", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("195", "162.214.113.163", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("196", "157.230.11.154", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("197", "165.227.186.67", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("198", "34.72.142.113", "normal", "", "0", "0", "0", "0", "2", "{\"nf\":[1606309808,1606309808]}");
INSERT INTO `wp_defender_lockout` VALUES("199", "185.138.241.179", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("200", "34.106.199.158", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("201", "54.36.148.96", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("202", "13.89.34.56", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("203", "24.218.103.2", "normal", "", "0", "0", "0", "0", "2", "{\"nf\":[1606311288,1606311289]}");
INSERT INTO `wp_defender_lockout` VALUES("204", "23.29.80.56", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("205", "34.94.246.254", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("206", "178.62.100.17", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("207", "41.98.115.132", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606313796]}");
INSERT INTO `wp_defender_lockout` VALUES("208", "206.189.85.88", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("209", "35.247.42.6", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("210", "42.236.10.123", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("211", "62.210.185.4", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("212", "54.36.148.31", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("213", "98.179.174.19", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("214", "35.196.54.126", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("215", "200.194.198.74", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("216", "118.217.181.116", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("217", "162.144.52.59", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("218", "69.163.197.8", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("219", "192.99.149.195", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("220", "34.64.79.191", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("221", "185.66.233.61", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("222", "68.9.94.227", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("223", "51.89.21.1", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("224", "132.177.213.206", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("225", "34.125.63.10", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("226", "47.92.241.24", "normal", "", "0", "0", "0", "0", "3", "{\"nf\":[1606323415,1606351759,1606705486]}");
INSERT INTO `wp_defender_lockout` VALUES("227", "114.119.149.222", "normal", "", "0", "0", "0", "0", "2", "{\"nf\":[1606441815,1606862280]}");
INSERT INTO `wp_defender_lockout` VALUES("228", "114.6.41.72", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("229", "176.235.216.155", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("230", "51.75.53.141", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("231", "128.199.244.150", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("232", "49.49.236.179", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606326441]}");
INSERT INTO `wp_defender_lockout` VALUES("233", "134.209.67.45", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("234", "96.252.118.140", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("235", "164.132.38.166", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("236", "35.230.162.59", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("237", "165.22.23.23", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("238", "185.220.100.252", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("239", "142.4.4.229", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("240", "72.93.224.107", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("241", "167.114.152.170", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("242", "34.215.41.89", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("243", "51.195.137.237", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("244", "66.249.64.11", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("245", "35.198.137.137", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("246", "192.95.30.65", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("247", "129.204.121.109", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("248", "173.236.255.123", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("249", "35.231.149.63", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("250", "161.35.232.103", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("251", "45.119.212.93", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("252", "37.59.141.40", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("253", "149.202.93.136", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("254", "165.22.35.21", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("255", "139.59.43.196", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("256", "114.119.133.165", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606335613]}");
INSERT INTO `wp_defender_lockout` VALUES("257", "104.131.57.95", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("258", "141.101.25.191", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("259", "3.237.196.181", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("260", "109.24.144.155", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("261", "147.135.211.127", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("262", "100.26.152.203", "blocked", "You have been locked out due to too many attempts to access a file that doesn\'t exist.", "1606338491", "0", "1606338191", "0", "20", "{\"nf\":[1606338174,1606338175,1606338176,1606338177,1606338178,1606338179,1606338180,1606338180,1606338181,1606338182,1606338183,1606338184,1606338185,1606338186,1606338187,1606338187,1606338188,1606338189,1606338190,1606338191]}");
INSERT INTO `wp_defender_lockout` VALUES("263", "87.237.238.185", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("264", "95.216.145.1", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606339530]}");
INSERT INTO `wp_defender_lockout` VALUES("265", "178.128.226.161", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("266", "34.68.114.57", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("267", "54.36.148.6", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("268", "37.139.11.239", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("269", "76.19.139.243", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("270", "39.101.1.61", "normal", "", "0", "0", "0", "0", "4", "{\"nf\":[1606341395,1606380394,1606388829,1606388871]}");
INSERT INTO `wp_defender_lockout` VALUES("271", "93.113.111.193", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("272", "165.22.53.233", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("273", "167.99.131.238", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("274", "37.187.91.7", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("275", "114.119.140.169", "normal", "", "0", "0", "0", "0", "3", "{\"nf\":[1606347486,1606532337,1606844772]}");
INSERT INTO `wp_defender_lockout` VALUES("276", "207.244.250.95", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("277", "34.74.170.184", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("278", "206.81.16.252", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("279", "194.33.45.161", "normal", "", "0", "0", "0", "0", "5", "{\"nf\":[1606871541,1606871560,1606871571,1606871580,1607021134]}");
INSERT INTO `wp_defender_lockout` VALUES("280", "34.71.174.184", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("281", "64.225.67.97", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("282", "52.237.198.242", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("283", "178.128.208.38", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("284", "27.155.46.72", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("285", "218.86.22.17", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606352204]}");
INSERT INTO `wp_defender_lockout` VALUES("286", "191.234.176.158", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("287", "151.80.45.51", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("288", "138.99.216.112", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606353583]}");
INSERT INTO `wp_defender_lockout` VALUES("289", "137.59.110.53", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("290", "68.183.184.7", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("291", "47.106.201.134", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("292", "68.9.110.41", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("293", "185.81.99.110", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("294", "196.41.122.94", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("295", "167.172.185.137", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("296", "40.88.21.235", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("297", "52.12.76.193", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("298", "34.221.181.108", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("299", "54.68.40.102", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("300", "216.10.251.112", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("301", "114.119.153.72", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("302", "196.77.114.43", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606362058]}");
INSERT INTO `wp_defender_lockout` VALUES("303", "176.31.182.56", "normal", "", "0", "0", "0", "0", "3", "{\"nf\":[1606362487,1606362500,1606362509]}");
INSERT INTO `wp_defender_lockout` VALUES("304", "185.191.171.6", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606362630]}");
INSERT INTO `wp_defender_lockout` VALUES("305", "104.248.201.153", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("306", "188.166.60.138", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("307", "134.122.120.74", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("308", "52.36.245.40", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("309", "134.122.94.113", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("310", "167.71.53.185", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("311", "167.71.234.29", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("312", "145.239.142.148", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("313", "61.244.70.248", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("314", "148.72.210.140", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("315", "35.231.240.33", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("316", "51.91.76.214", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("317", "35.204.172.12", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("318", "193.70.89.118", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("319", "198.27.67.87", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("320", "31.220.3.147", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606376440]}");
INSERT INTO `wp_defender_lockout` VALUES("321", "128.199.223.178", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("322", "35.224.216.78", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("323", "185.220.100.245", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("324", "167.71.104.1", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("325", "157.230.221.194", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("326", "117.211.209.243", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("327", "142.93.152.19", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("328", "35.166.200.255", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("329", "77.88.5.99", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("330", "103.16.130.215", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("331", "13.54.157.115", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("332", "141.85.216.231", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("333", "51.178.17.214", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("334", "213.149.103.132", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("335", "178.62.89.14", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("336", "188.165.210.14", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("337", "54.38.65.69", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("338", "138.197.213.160", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("339", "134.209.232.100", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("340", "107.6.62.213", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("341", "174.138.30.233", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("342", "178.128.247.84", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("343", "192.99.8.102", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("344", "72.249.190.230", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("345", "113.163.94.90", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606390080]}");
INSERT INTO `wp_defender_lockout` VALUES("346", "159.65.228.105", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("347", "13.70.199.80", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("348", "206.189.113.210", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("349", "159.203.114.189", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("350", "163.172.32.190", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("351", "104.236.203.29", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("352", "66.249.70.27", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("353", "66.249.64.3", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("354", "51.68.213.75", "normal", "", "0", "0", "0", "0", "5", "{\"nf\":[1606394328,1606394340,1606394351,1606394368,1606394380]}");
INSERT INTO `wp_defender_lockout` VALUES("355", "94.23.70.195", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("356", "46.101.132.88", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("357", "34.68.97.70", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("358", "37.187.113.197", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("359", "206.189.231.196", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("360", "104.214.79.46", "normal", "", "0", "0", "0", "0", "17", "{\"nf\":[1606397890,1606397900,1606397908,1606397916,1606397924,1606397933,1606397947,1606397954,1606397965,1606397969,1606397978,1606771673,1606771707,1606795582,1606795596,1606919272,1606919280]}");
INSERT INTO `wp_defender_lockout` VALUES("361", "37.9.13.155", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("362", "91.82.40.118", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("363", "88.198.242.184", "normal", "", "0", "0", "0", "0", "3", "{\"nf\":[1606407305,1606844923,1606911889]}");
INSERT INTO `wp_defender_lockout` VALUES("364", "121.239.199.21", "normal", "", "0", "0", "0", "0", "27", "{\"nf\":[1606407549,1606407560,1606407577,1606407579,1606407583,1606407598,1606407603,1606469106,1606469115,1606469119,1606515751,1606515756,1606515760,1606515762,1606515764,1606515770,1606515774,1606582770,1606582780,1606582797,1606582801,1606582806,1606830045,1606830080,1606830084,1606830087,1606830091]}");
INSERT INTO `wp_defender_lockout` VALUES("365", "114.119.145.233", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606528388]}");
INSERT INTO `wp_defender_lockout` VALUES("366", "35.243.206.211", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("367", "13.66.255.156", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("368", "81.24.247.58", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("369", "81.24.247.58", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606413771]}");
INSERT INTO `wp_defender_lockout` VALUES("370", "168.151.132.240", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("371", "192.227.171.45", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606416616]}");
INSERT INTO `wp_defender_lockout` VALUES("372", "114.119.140.238", "normal", "", "0", "0", "0", "0", "3", "{\"nf\":[1606416803,1606642993,1606919216]}");
INSERT INTO `wp_defender_lockout` VALUES("373", "114.119.142.43", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606643527]}");
INSERT INTO `wp_defender_lockout` VALUES("374", "88.80.36.226", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606419810]}");
INSERT INTO `wp_defender_lockout` VALUES("375", "13.74.252.234", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("376", "194.201.253.190", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("377", "103.146.202.150", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("378", "176.124.231.76", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("379", "145.239.29.217", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("380", "185.191.171.42", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("381", "202.93.231.96", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606426608]}");
INSERT INTO `wp_defender_lockout` VALUES("382", "114.119.137.3", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("383", "206.81.7.54", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("384", "178.62.9.122", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("385", "89.252.191.172", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("386", "114.119.133.224", "normal", "", "0", "0", "0", "0", "2", "{\"nf\":[1606430348,1606664179]}");
INSERT INTO `wp_defender_lockout` VALUES("387", "188.166.38.40", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("388", "37.187.167.55", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("389", "192.99.212.104", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("390", "51.91.99.233", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("391", "52.237.118.225", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("392", "178.62.50.212", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("393", "137.74.206.80", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("394", "35.204.152.99", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("395", "159.89.51.228", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("396", "103.55.33.21", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("397", "3.81.18.44", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("398", "5.9.156.30", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("399", "34.75.14.45", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("400", "159.89.119.127", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("401", "67.207.93.184", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("402", "40.77.188.168", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("403", "34.219.31.15", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("404", "52.37.61.236", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("405", "139.59.25.238", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("406", "80.82.68.173", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("407", "142.93.153.126", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("408", "188.166.20.141", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("409", "34.211.48.4", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("410", "165.22.121.12", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("411", "80.90.82.70", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("412", "34.94.247.253", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("413", "202.0.103.51", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("414", "124.158.12.202", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("415", "110.164.208.125", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606456570]}");
INSERT INTO `wp_defender_lockout` VALUES("416", "134.122.28.82", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("417", "138.197.179.94", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("418", "46.101.117.167", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("419", "188.165.246.50", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("420", "198.211.98.90", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("421", "64.227.0.234", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("422", "52.252.137.130", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606461379]}");
INSERT INTO `wp_defender_lockout` VALUES("423", "37.187.135.130", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("424", "159.65.239.34", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("425", "62.210.204.182", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("426", "208.113.182.33", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("427", "104.248.158.98", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("428", "188.165.239.211", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("429", "134.209.157.198", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("430", "54.203.64.202", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606467301]}");
INSERT INTO `wp_defender_lockout` VALUES("431", "192.99.11.48", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("432", "198.71.234.6", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("433", "110.229.218.64", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("434", "185.112.33.46", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("435", "178.62.110.145", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("436", "50.63.165.245", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606472458]}");
INSERT INTO `wp_defender_lockout` VALUES("437", "160.153.154.5", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606472469]}");
INSERT INTO `wp_defender_lockout` VALUES("438", "198.71.239.11", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606472481]}");
INSERT INTO `wp_defender_lockout` VALUES("439", "184.168.46.200", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606472504]}");
INSERT INTO `wp_defender_lockout` VALUES("440", "103.97.100.15", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606472517]}");
INSERT INTO `wp_defender_lockout` VALUES("441", "51.38.50.235", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606472570]}");
INSERT INTO `wp_defender_lockout` VALUES("442", "91.134.206.89", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606472570]}");
INSERT INTO `wp_defender_lockout` VALUES("443", "163.172.7.97", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606472573]}");
INSERT INTO `wp_defender_lockout` VALUES("444", "160.153.156.130", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606472583]}");
INSERT INTO `wp_defender_lockout` VALUES("445", "198.71.239.49", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606472594]}");
INSERT INTO `wp_defender_lockout` VALUES("446", "109.228.23.89", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606472599]}");
INSERT INTO `wp_defender_lockout` VALUES("447", "37.247.107.75", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606472617]}");
INSERT INTO `wp_defender_lockout` VALUES("448", "107.180.120.52", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606472650]}");
INSERT INTO `wp_defender_lockout` VALUES("449", "134.122.80.217", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("450", "5.135.15.241", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606472676]}");
INSERT INTO `wp_defender_lockout` VALUES("451", "207.46.13.201", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("452", "165.22.138.106", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("453", "34.222.50.223", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("454", "45.142.28.234", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("455", "39.98.49.33", "normal", "", "0", "0", "0", "0", "4", "{\"nf\":[1606475460,1606475461,1606475461,1606475464]}");
INSERT INTO `wp_defender_lockout` VALUES("456", "167.71.202.93", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("457", "142.93.57.0", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("458", "66.249.70.7", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("459", "51.77.140.110", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("460", "144.76.25.174", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("461", "162.144.51.3", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("462", "85.169.54.125", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("463", "157.230.187.39", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("464", "66.249.70.9", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("465", "66.249.70.29", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("466", "93.114.184.8", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("467", "161.35.194.6", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("468", "103.104.52.185", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606482314]}");
INSERT INTO `wp_defender_lockout` VALUES("469", "107.180.227.163", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("470", "40.73.77.193", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("471", "103.214.68.136", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606483834]}");
INSERT INTO `wp_defender_lockout` VALUES("472", "93.125.75.19", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("473", "192.99.31.122", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("474", "54.214.99.185", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("475", "128.199.210.138", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("476", "155.8.28.146", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("477", "134.209.147.203", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("478", "139.99.196.183", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("479", "194.153.113.13", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("480", "15.207.178.134", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("481", "24.2.177.20", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("482", "149.56.108.216", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("483", "162.247.74.204", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606494028]}");
INSERT INTO `wp_defender_lockout` VALUES("484", "100.26.135.239", "blocked", "You have been locked out due to too many attempts to access a file that doesn\'t exist.", "1606512252", "0", "1606511952", "0", "20", "{\"nf\":[1606511932,1606511933,1606511934,1606511935,1606511936,1606511937,1606511939,1606511940,1606511941,1606511942,1606511943,1606511944,1606511945,1606511946,1606511947,1606511948,1606511949,1606511950,1606511951,1606511952]}");
INSERT INTO `wp_defender_lockout` VALUES("485", "81.7.148.194", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("486", "51.195.47.79", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("487", "157.245.106.153", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("488", "177.137.58.131", "normal", "", "0", "0", "0", "2", "0", "{\"login\":[1606495666,1606495666]}");
INSERT INTO `wp_defender_lockout` VALUES("489", "205.204.73.33", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("490", "139.59.174.107", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("491", "192.99.10.26", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("492", "177.66.146.148", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("493", "13.66.139.18", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("494", "174.196.198.183", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("495", "159.203.176.82", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("496", "118.69.173.199", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("497", "165.227.201.25", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("498", "163.172.42.123", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("499", "101.99.15.57", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("500", "159.203.37.43", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("501", "185.12.45.118", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("502", "103.27.239.185", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("503", "174.196.196.141", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("504", "167.172.115.176", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("505", "128.199.212.194", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("506", "129.213.213.245", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("507", "54.36.149.50", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("508", "139.59.61.144", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("509", "157.230.164.216", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("510", "5.188.62.147", "normal", "", "0", "0", "0", "0", "2", "{\"nf\":[1606510159,1606836598]}");
INSERT INTO `wp_defender_lockout` VALUES("511", "35.229.73.121", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("512", "111.92.240.206", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("513", "192.99.7.106", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("514", "185.253.218.243", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("515", "54.89.76.78", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("516", "68.183.64.176", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("517", "167.172.200.70", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("518", "206.189.121.29", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("519", "51.79.157.254", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("520", "167.99.90.240", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("521", "5.135.72.184", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("522", "36.68.222.227", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("523", "51.68.5.179", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("524", "104.236.120.31", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("525", "34.73.10.30", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("526", "47.99.196.234", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606517918]}");
INSERT INTO `wp_defender_lockout` VALUES("527", "117.52.74.20", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("528", "34.75.252.243", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("529", "212.7.204.176", "blocked", "You have been locked out due to too many attempts to access a file that doesn\'t exist.", "1606561363", "0", "1606561063", "0", "40", "{\"nf\":[1606561041,1606561042,1606561043,1606561044,1606561046,1606561047,1606561048,1606561049,1606561050,1606561051,1606561053,1606561054,1606561055,1606561056,1606561057,1606561058,1606561060,1606561061,1606561062,1606561063],\"login\":[]}");
INSERT INTO `wp_defender_lockout` VALUES("530", "198.54.126.74", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("531", "42.236.10.81", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("532", "35.200.60.134", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606529382]}");
INSERT INTO `wp_defender_lockout` VALUES("533", "121.78.246.82", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606531071]}");
INSERT INTO `wp_defender_lockout` VALUES("534", "52.32.71.168", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("535", "34.217.78.64", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("536", "54.70.79.131", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("537", "188.132.179.34", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("538", "52.34.57.211", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("539", "122.179.40.219", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606539252]}");
INSERT INTO `wp_defender_lockout` VALUES("540", "185.117.215.9", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606541895]}");
INSERT INTO `wp_defender_lockout` VALUES("541", "199.188.200.45", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("542", "73.47.48.235", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("543", "185.2.4.138", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("544", "209.17.96.138", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("545", "39.98.242.185", "normal", "", "0", "0", "0", "0", "5", "{\"nf\":[1606554326,1606581046,1606720735,1606952400,1606952401]}");
INSERT INTO `wp_defender_lockout` VALUES("546", "104.222.46.156", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("547", "52.12.8.236", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("548", "162.144.18.17", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606556949]}");
INSERT INTO `wp_defender_lockout` VALUES("549", "101.21.146.37", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606558304]}");
INSERT INTO `wp_defender_lockout` VALUES("550", "52.167.173.198", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("551", "54.36.148.140", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("552", "40.77.167.21", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("553", "78.85.194.229", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606566139]}");
INSERT INTO `wp_defender_lockout` VALUES("554", "39.98.74.86", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606567907]}");
INSERT INTO `wp_defender_lockout` VALUES("555", "95.217.207.28", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("556", "154.121.58.162", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606569638]}");
INSERT INTO `wp_defender_lockout` VALUES("557", "40.77.167.29", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("558", "198.50.243.165", "blocked", "You have been locked out due to too many attempts to access a file that doesn\'t exist.", "1607020212", "0", "1607019912", "0", "40", "{\"nf\":[1607019888,1607019889,1607019891,1607019893,1607019894,1607019895,1607019896,1607019898,1607019899,1607019901,1607019902,1607019903,1607019904,1607019906,1607019907,1607019908,1607019909,1607019910,1607019911,1607019912],\"login\":[]}");
INSERT INTO `wp_defender_lockout` VALUES("559", "59.52.102.29", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("560", "74.208.200.107", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("561", "73.114.253.149", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("562", "75.97.150.69", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("563", "54.36.148.134", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("564", "67.189.151.25", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("565", "35.237.229.226", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("566", "76.28.19.164", "normal", "", "0", "0", "0", "0", "2", "{\"nf\":[1606598163,1606598164]}");
INSERT INTO `wp_defender_lockout` VALUES("567", "119.161.99.187", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606599573]}");
INSERT INTO `wp_defender_lockout` VALUES("568", "101.21.148.193", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("569", "76.24.179.210", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("570", "104.196.176.192", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("571", "32.208.179.165", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("572", "64.223.227.47", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("573", "101.132.129.91", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606614767]}");
INSERT INTO `wp_defender_lockout` VALUES("574", "73.35.211.1", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("575", "73.149.222.204", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("576", "171.96.155.84", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606618378]}");
INSERT INTO `wp_defender_lockout` VALUES("577", "62.210.84.82", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("578", "159.224.255.154", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("579", "50.116.208.160", "normal", "", "0", "0", "0", "0", "2", "{\"nf\":[1606624221,1606624237]}");
INSERT INTO `wp_defender_lockout` VALUES("580", "34.217.80.158", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("581", "128.199.167.82", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("582", "207.46.13.42", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("583", "138.197.162.136", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("584", "51.15.39.200", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("585", "136.144.155.82", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("586", "20.56.233.132", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("587", "188.166.247.234", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("588", "88.80.35.61", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606649473]}");
INSERT INTO `wp_defender_lockout` VALUES("589", "14.241.233.22", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606650856]}");
INSERT INTO `wp_defender_lockout` VALUES("590", "94.21.100.195", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("591", "120.78.180.36", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606655927]}");
INSERT INTO `wp_defender_lockout` VALUES("592", "66.160.140.184", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606658453]}");
INSERT INTO `wp_defender_lockout` VALUES("593", "108.7.229.123", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("594", "93.90.193.51", "normal", "", "0", "0", "0", "0", "3", "{\"nf\":[1606660484,1606689348,1606689361]}");
INSERT INTO `wp_defender_lockout` VALUES("595", "185.166.131.147", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("596", "34.100.66.178", "normal", "", "0", "0", "0", "0", "2", "{\"nf\":[1606664538,1606664552]}");
INSERT INTO `wp_defender_lockout` VALUES("597", "109.70.100.31", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("598", "69.160.2.215", "normal", "", "0", "0", "0", "2", "0", "{\"login\":[1606668310,1606668310]}");
INSERT INTO `wp_defender_lockout` VALUES("599", "205.169.39.217", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606670426]}");
INSERT INTO `wp_defender_lockout` VALUES("600", "51.89.204.20", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606673954]}");
INSERT INTO `wp_defender_lockout` VALUES("601", "176.194.51.129", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("602", "158.69.158.101", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("603", "172.56.22.22", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("604", "45.76.156.73", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("605", "95.215.55.110", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606685857]}");
INSERT INTO `wp_defender_lockout` VALUES("606", "220.161.31.70", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("607", "107.77.226.32", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("608", "46.119.172.173", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("609", "204.93.157.55", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606690005]}");
INSERT INTO `wp_defender_lockout` VALUES("610", "161.35.83.224", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("611", "72.224.33.107", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("612", "188.165.194.99", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("613", "42.236.10.82", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("614", "181.149.233.44", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("615", "54.36.148.93", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("616", "65.52.179.163", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("617", "178.128.230.35", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("618", "51.255.64.58", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("619", "73.89.27.88", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("620", "37.187.129.23", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("621", "139.59.76.99", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("622", "71.174.117.232", "normal", "", "0", "0", "0", "0", "2", "{\"nf\":[1606699647,1606699648]}");
INSERT INTO `wp_defender_lockout` VALUES("623", "13.66.139.40", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("624", "47.52.239.42", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("625", "158.69.128.56", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("626", "177.52.160.16", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("627", "73.61.19.30", "normal", "", "0", "0", "0", "0", "2", "{\"nf\":[1606701061,1606701062]}");
INSERT INTO `wp_defender_lockout` VALUES("628", "110.136.219.180", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606702650]}");
INSERT INTO `wp_defender_lockout` VALUES("629", "34.95.148.137", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("630", "46.101.146.6", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("631", "18.237.81.173", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("632", "34.214.33.177", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("633", "199.249.230.147", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606708621]}");
INSERT INTO `wp_defender_lockout` VALUES("634", "157.55.39.239", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("635", "104.244.72.239", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606710253]}");
INSERT INTO `wp_defender_lockout` VALUES("636", "54.190.165.196", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("637", "164.90.181.196", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("638", "193.70.81.132", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("639", "34.75.79.5", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("640", "149.129.75.209", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606711680]}");
INSERT INTO `wp_defender_lockout` VALUES("641", "24.63.25.165", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("642", "103.198.69.53", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("643", "54.39.22.135", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("644", "159.89.126.252", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("645", "161.35.37.74", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("646", "200.121.128.64", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("647", "167.71.209.115", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("648", "157.245.164.4", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("649", "162.144.66.89", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("650", "54.39.16.153", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("651", "134.122.72.53", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("652", "161.35.165.80", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("653", "54.36.148.80", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("654", "159.203.122.57", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("655", "192.99.4.179", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("656", "35.187.254.230", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("657", "162.214.93.122", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("658", "165.22.67.110", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("659", "186.234.80.70", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("660", "91.204.72.77", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("661", "34.87.148.251", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("662", "14.191.160.141", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606723375]}");
INSERT INTO `wp_defender_lockout` VALUES("663", "103.147.10.222", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("664", "198.54.126.122", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("665", "221.132.27.148", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("666", "54.36.181.100", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("667", "198.199.122.68", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("668", "165.227.127.49", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("669", "192.99.151.125", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("670", "54.162.102.36", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606763744]}");
INSERT INTO `wp_defender_lockout` VALUES("671", "107.180.109.51", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("672", "93.114.86.226", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("673", "161.35.154.24", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("674", "35.195.86.207", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("675", "45.15.26.63", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("676", "198.211.115.226", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("677", "167.172.215.83", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("678", "162.213.255.44", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606732585]}");
INSERT INTO `wp_defender_lockout` VALUES("679", "142.93.99.114", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("680", "67.48.50.126", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("681", "112.133.232.14", "normal", "", "0", "0", "0", "0", "2", "{\"nf\":[1606734286,1606739669]}");
INSERT INTO `wp_defender_lockout` VALUES("682", "157.55.39.255", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("683", "54.38.253.1", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("684", "165.22.33.47", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("685", "116.202.100.112", "normal", "", "0", "0", "0", "0", "2", "{\"nf\":[1606735460,1606735462]}");
INSERT INTO `wp_defender_lockout` VALUES("686", "66.249.66.134", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("687", "162.0.232.160", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("688", "104.131.191.194", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("689", "66.249.66.140", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("690", "46.101.120.8", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("691", "207.46.13.132", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("692", "66.249.66.93", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("693", "66.249.66.74", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("694", "172.56.23.252", "normal", "", "0", "0", "0", "0", "2", "{\"nf\":[1606738980,1606738981]}");
INSERT INTO `wp_defender_lockout` VALUES("695", "79.137.39.102", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("696", "14.225.5.247", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("697", "149.129.52.21", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("698", "72.167.190.51", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("699", "52.38.203.10", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("700", "40.77.189.52", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("701", "173.249.16.129", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("702", "128.199.10.90", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("703", "34.74.229.138", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("704", "162.213.255.98", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("705", "112.196.72.188", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("706", "117.29.251.36", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("707", "51.79.111.220", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("708", "66.70.160.187", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("709", "196.44.176.55", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("710", "46.38.249.170", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("711", "51.89.235.195", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("712", "82.165.242.94", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("713", "14.200.1.238", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("714", "68.183.87.153", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("715", "223.205.229.27", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606750276]}");
INSERT INTO `wp_defender_lockout` VALUES("716", "134.122.46.215", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("717", "37.59.47.61", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("718", "165.227.129.197", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("719", "128.199.133.8", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("720", "198.54.125.232", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("721", "45.41.161.0", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("722", "149.56.19.4", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("723", "129.232.245.42", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("724", "35.242.214.242", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("725", "165.22.209.132", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("726", "185.59.44.23", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("727", "199.188.206.2", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("728", "35.235.96.109", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("729", "165.22.211.55", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("730", "185.9.158.220", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("731", "178.32.62.253", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("732", "45.40.166.167", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606759397]}");
INSERT INTO `wp_defender_lockout` VALUES("733", "67.213.82.137", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("734", "50.63.196.157", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606759550]}");
INSERT INTO `wp_defender_lockout` VALUES("735", "184.168.193.196", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("736", "160.153.147.135", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606759888]}");
INSERT INTO `wp_defender_lockout` VALUES("737", "151.1.181.79", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606759987]}");
INSERT INTO `wp_defender_lockout` VALUES("738", "192.254.75.166", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606759997]}");
INSERT INTO `wp_defender_lockout` VALUES("739", "50.63.194.57", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606760049]}");
INSERT INTO `wp_defender_lockout` VALUES("740", "68.183.41.140", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("741", "103.23.22.244", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("742", "68.183.68.148", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("743", "208.113.181.161", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("744", "35.236.18.113", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("745", "91.195.80.8", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("746", "213.159.213.137", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("747", "167.71.102.17", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("748", "157.230.248.89", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("749", "157.55.39.181", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("750", "13.66.139.109", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("751", "51.178.83.144", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("752", "31.47.55.138", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("753", "73.89.209.205", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("754", "138.197.146.132", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("755", "79.124.76.160", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("756", "108.86.179.233", "normal", "", "0", "0", "0", "0", "2", "{\"nf\":[1606768888,1606768890]}");
INSERT INTO `wp_defender_lockout` VALUES("757", "67.205.38.108", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("758", "148.66.129.116", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("759", "128.199.111.241", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("760", "80.211.139.155", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("761", "198.54.114.76", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("762", "206.189.43.143", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("763", "157.245.220.153", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("764", "107.180.229.15", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("765", "188.166.227.64", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("766", "164.90.238.53", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("767", "134.249.116.78", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("768", "128.199.123.216", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("769", "139.59.153.133", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("770", "179.52.254.207", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606776498]}");
INSERT INTO `wp_defender_lockout` VALUES("771", "167.172.56.36", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("772", "64.227.39.77", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("773", "144.202.54.121", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("774", "66.7.223.202", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("775", "142.93.18.203", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("776", "3.236.98.157", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("777", "40.77.167.6", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("778", "157.245.243.14", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("779", "82.65.86.43", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("780", "40.77.167.30", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("781", "146.115.83.174", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("782", "31.170.166.110", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606781328]}");
INSERT INTO `wp_defender_lockout` VALUES("783", "192.241.199.202", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("784", "51.75.144.239", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("785", "185.220.100.243", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("786", "5.39.82.14", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("787", "209.97.183.28", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("788", "199.244.88.132", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("789", "68.65.121.177", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("790", "139.59.86.47", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("791", "34.73.237.110", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("792", "192.64.112.100", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("793", "165.225.38.242", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("794", "104.237.141.93", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("795", "71.88.46.96", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("796", "24.62.4.137", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("797", "40.77.167.4", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("798", "158.69.254.105", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("799", "175.208.191.37", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("800", "73.108.233.123", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606791519]}");
INSERT INTO `wp_defender_lockout` VALUES("801", "45.55.61.114", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("802", "14.232.70.50", "normal", "", "0", "0", "0", "2", "0", "{\"login\":[1606792747,1606792747]}");
INSERT INTO `wp_defender_lockout` VALUES("803", "68.65.122.102", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("804", "162.241.62.67", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("805", "157.245.5.133", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("806", "108.161.129.83", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606794530]}");
INSERT INTO `wp_defender_lockout` VALUES("807", "108.161.129.83", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("808", "51.91.157.255", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("809", "91.121.89.189", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("810", "157.55.39.72", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("811", "159.203.44.244", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("812", "34.221.12.142", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("813", "86.107.43.63", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("814", "5.135.177.5", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("815", "13.66.139.132", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("816", "13.114.19.126", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("817", "188.166.234.253", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("818", "103.74.123.158", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("819", "74.208.47.193", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("820", "173.236.242.79", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("821", "167.71.114.223", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("822", "188.166.63.76", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("823", "188.165.211.23", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("824", "159.89.99.68", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("825", "94.232.175.210", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("826", "199.188.200.86", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("827", "37.187.53.168", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("828", "151.106.35.50", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("829", "35.214.194.143", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("830", "201.234.119.228", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("831", "167.172.144.31", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("832", "23.101.123.2", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("833", "77.88.5.147", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("834", "104.236.45.171", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("835", "198.54.114.53", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("836", "163.172.50.9", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("837", "45.55.65.221", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("838", "134.209.179.57", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("839", "91.121.184.52", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("840", "45.13.254.223", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("841", "42.236.10.110", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("842", "129.146.99.134", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("843", "223.88.196.216", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606816624]}");
INSERT INTO `wp_defender_lockout` VALUES("844", "54.36.148.36", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("845", "18.222.42.40", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("846", "73.238.246.210", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("847", "185.138.42.74", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606822359]}");
INSERT INTO `wp_defender_lockout` VALUES("848", "192.227.209.212", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606827048]}");
INSERT INTO `wp_defender_lockout` VALUES("849", "85.140.38.114", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606827384]}");
INSERT INTO `wp_defender_lockout` VALUES("850", "97.74.236.194", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("851", "34.71.250.100", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("852", "110.170.163.67", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("853", "3.126.231.187", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("854", "192.145.233.45", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("855", "199.188.204.134", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("856", "178.128.224.50", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("857", "42.201.184.63", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606833345]}");
INSERT INTO `wp_defender_lockout` VALUES("858", "35.221.1.227", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("859", "51.75.146.127", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("860", "103.89.84.202", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("861", "173.231.58.250", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("862", "80.77.123.218", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("863", "3.131.65.98", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("864", "204.148.29.122", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("865", "13.66.139.104", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("866", "134.209.176.202", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("867", "35.182.65.92", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("868", "207.180.206.148", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("869", "212.44.113.16", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("870", "118.126.91.70", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("871", "161.35.161.13", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("872", "40.77.190.51", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("873", "209.97.167.137", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("874", "70.39.233.211", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("875", "91.134.248.230", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("876", "134.122.70.55", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("877", "209.17.97.90", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("878", "209.17.97.18", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("879", "142.93.70.155", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("880", "195.38.168.118", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("881", "134.19.188.27", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("882", "40.77.188.217", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("883", "13.211.97.210", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("884", "157.245.91.33", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("885", "89.144.12.17", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606846171]}");
INSERT INTO `wp_defender_lockout` VALUES("886", "192.155.86.73", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("887", "31.220.1.233", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606847015]}");
INSERT INTO `wp_defender_lockout` VALUES("888", "35.240.234.239", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("889", "91.205.16.70", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("890", "34.73.181.4", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("891", "3.129.85.136", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("892", "45.119.84.149", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("893", "188.165.208.7", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("894", "170.78.75.127", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("895", "46.101.254.193", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("896", "193.218.151.167", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("897", "85.209.48.112", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("898", "157.230.38.130", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("899", "143.110.137.82", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("900", "13.66.139.28", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("901", "206.189.136.172", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("902", "142.93.34.169", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("903", "54.37.198.243", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("904", "104.248.142.60", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("905", "212.48.74.238", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("906", "71.85.131.183", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("907", "35.235.99.26", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("908", "5.187.6.45", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("909", "104.131.62.234", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606855430]}");
INSERT INTO `wp_defender_lockout` VALUES("910", "40.77.190.24", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("911", "116.203.127.75", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("912", "13.66.139.19", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("913", "90.156.128.165", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("914", "159.65.158.16", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("915", "51.81.0.103", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("916", "188.166.56.218", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("917", "45.32.163.148", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("918", "35.198.14.201", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("919", "159.89.48.237", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("920", "45.32.174.90", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("921", "83.150.215.180", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("922", "62.171.188.175", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("923", "54.251.232.145", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("924", "178.128.36.26", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("925", "72.215.233.44", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("926", "159.65.65.170", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("927", "189.139.101.68", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("928", "172.58.237.100", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("929", "138.68.45.164", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("930", "87.117.225.81", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("931", "190.6.81.217", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("932", "35.236.84.186", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("933", "46.235.14.11", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("934", "46.105.243.22", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("935", "68.189.252.19", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("936", "173.231.59.215", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606868470]}");
INSERT INTO `wp_defender_lockout` VALUES("937", "32.215.217.137", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("938", "51.68.172.59", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("939", "218.86.22.178", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606869566]}");
INSERT INTO `wp_defender_lockout` VALUES("940", "159.89.45.133", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606869844]}");
INSERT INTO `wp_defender_lockout` VALUES("941", "40.77.189.66", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("942", "113.172.150.149", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606870359]}");
INSERT INTO `wp_defender_lockout` VALUES("943", "91.234.194.113", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("944", "54.237.138.7", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("945", "164.90.206.250", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("946", "51.210.219.11", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("947", "159.89.183.168", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("948", "23.254.176.124", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("949", "159.65.151.8", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("950", "35.201.5.248", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("951", "51.68.137.174", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("952", "35.239.161.106", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("953", "45.76.76.175", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("954", "80.251.219.111", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("955", "193.187.119.203", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("956", "185.2.4.44", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("957", "95.217.207.247", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("958", "34.202.129.247", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("959", "159.65.3.164", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("960", "128.199.118.130", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("961", "144.202.92.85", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("962", "222.252.28.110", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606882043]}");
INSERT INTO `wp_defender_lockout` VALUES("963", "67.227.228.177", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("964", "195.154.207.19", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("965", "195.154.174.135", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("966", "167.71.139.95", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("967", "125.166.6.187", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("968", "185.2.4.135", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("969", "67.225.202.102", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("970", "52.188.153.36", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("971", "34.216.128.152", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("972", "18.215.67.229", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("973", "142.93.180.113", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("974", "103.85.228.243", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("975", "120.79.139.196", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("976", "35.190.142.20", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("977", "18.197.193.89", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("978", "5.102.173.71", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606888250]}");
INSERT INTO `wp_defender_lockout` VALUES("979", "178.128.51.162", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("980", "165.22.95.39", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("981", "141.136.41.119", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606889364]}");
INSERT INTO `wp_defender_lockout` VALUES("982", "167.71.111.16", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("983", "54.77.63.84", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("984", "159.89.116.255", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("985", "132.145.242.131", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("986", "15.207.39.186", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("987", "45.120.136.87", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("988", "185.220.101.137", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606892782]}");
INSERT INTO `wp_defender_lockout` VALUES("989", "111.118.223.185", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("990", "207.244.250.48", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("991", "62.116.165.86", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("992", "13.66.139.36", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("993", "35.244.65.49", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("994", "51.210.243.196", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606895966]}");
INSERT INTO `wp_defender_lockout` VALUES("995", "202.92.4.129", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("996", "167.172.167.250", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("997", "47.96.93.135", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("998", "134.209.123.101", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("999", "185.155.96.239", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1000", "186.234.80.77", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1001", "13.234.97.21", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1002", "136.243.15.169", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1003", "35.235.127.27", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1004", "185.2.4.29", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1005", "35.198.195.1", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1006", "198.46.141.66", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1007", "64.225.44.22", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1008", "139.180.171.254", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1009", "159.65.128.164", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1010", "31.124.254.159", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1011", "104.248.186.42", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1012", "185.8.10.230", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1013", "91.234.195.123", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1014", "52.64.124.109", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1015", "13.66.139.83", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1016", "35.244.120.253", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1017", "162.241.114.56", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1018", "51.178.136.52", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1019", "78.85.165.131", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606908726]}");
INSERT INTO `wp_defender_lockout` VALUES("1020", "172.81.116.79", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1021", "109.108.136.103", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1022", "3.216.216.246", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1023", "157.245.38.189", "normal", "", "0", "0", "0", "0", "2", "{\"nf\":[1606910829,1606910830]}");
INSERT INTO `wp_defender_lockout` VALUES("1024", "202.5.16.47", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1025", "84.17.46.218", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1026", "173.231.213.19", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1027", "35.209.122.0", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1028", "139.155.88.164", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1029", "148.72.232.107", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1030", "35.187.66.122", "normal", "", "0", "0", "0", "0", "4", "{\"nf\":[1606920597,1606920600,1606920600,1606920614]}");
INSERT INTO `wp_defender_lockout` VALUES("1031", "160.153.154.1", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606922609]}");
INSERT INTO `wp_defender_lockout` VALUES("1032", "106.12.71.7", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1033", "177.85.177.2", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606923682]}");
INSERT INTO `wp_defender_lockout` VALUES("1034", "67.205.12.218", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1035", "198.199.77.52", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1036", "34.95.201.234", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1037", "62.171.152.24", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1038", "47.241.17.164", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1039", "165.22.192.120", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1040", "167.172.57.1", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1041", "209.126.12.142", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1042", "40.117.233.252", "normal", "", "0", "0", "0", "0", "2", "{\"nf\":[1606929511,1606929521]}");
INSERT INTO `wp_defender_lockout` VALUES("1043", "77.222.61.77", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1044", "161.97.85.189", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606929953]}");
INSERT INTO `wp_defender_lockout` VALUES("1045", "142.93.73.89", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1046", "93.113.111.100", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1047", "149.56.142.1", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1048", "20.37.50.97", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1049", "82.165.48.181", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1050", "67.205.149.57", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1051", "159.203.241.101", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1052", "94.23.30.216", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1053", "3.24.79.109", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1054", "185.147.49.151", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1055", "89.46.110.235", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1056", "108.61.216.246", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1057", "71.183.210.207", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1058", "139.59.40.233", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1059", "113.161.196.105", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606937443]}");
INSERT INTO `wp_defender_lockout` VALUES("1060", "165.225.39.113", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1061", "173.212.219.223", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1062", "45.77.167.199", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1063", "32.213.24.125", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1064", "91.195.52.237", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1065", "159.89.1.19", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1066", "51.79.159.176", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1067", "77.68.121.212", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1068", "37.59.54.36", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1069", "134.122.69.140", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1070", "167.71.56.158", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1071", "77.68.114.44", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1072", "167.71.63.47", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1073", "138.68.233.112", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1074", "209.97.180.47", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1075", "176.31.101.224", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1076", "64.227.53.63", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1077", "54.38.65.127", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1078", "94.177.181.123", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1079", "64.227.1.139", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1080", "167.71.83.38", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1081", "185.79.156.183", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1082", "185.220.101.203", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606949156]}");
INSERT INTO `wp_defender_lockout` VALUES("1083", "167.99.12.47", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1084", "185.220.100.247", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1085", "159.89.140.0", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1086", "167.172.30.208", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1087", "136.243.78.3", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1088", "51.158.187.57", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1089", "91.205.172.116", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606953777]}");
INSERT INTO `wp_defender_lockout` VALUES("1090", "157.245.207.60", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1091", "34.75.13.163", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1092", "112.165.89.170", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1093", "63.142.54.90", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1094", "211.20.181.113", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1095", "84.38.184.216", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1096", "213.230.71.0", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1097", "219.93.110.60", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1098", "197.237.246.42", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1099", "183.88.224.150", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1100", "187.188.177.78", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1101", "195.62.16.111", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1102", "216.183.222.135", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1103", "200.159.1.218", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1104", "189.114.67.195", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1105", "189.59.5.49", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1106", "113.190.36.2", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1107", "59.125.248.139", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1108", "176.10.144.190", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1109", "37.204.108.240", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1110", "89.216.102.123", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1111", "64.202.185.77", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1112", "198.50.227.75", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1113", "138.91.154.178", "normal", "", "0", "0", "0", "0", "3", "{\"nf\":[1606957121,1606968723,1606968749]}");
INSERT INTO `wp_defender_lockout` VALUES("1114", "157.245.206.244", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1115", "62.210.75.68", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1116", "103.1.184.245", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1117", "3.25.30.128", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1118", "24.177.244.105", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1119", "54.152.72.57", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1120", "42.236.10.116", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1121", "106.75.246.84", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1122", "206.189.184.16", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1123", "91.231.179.65", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1124", "58.87.125.65", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1125", "78.40.224.223", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1126", "195.154.185.170", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1127", "103.111.30.40", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1128", "118.193.35.169", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1129", "145.239.11.53", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1130", "5.9.70.117", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606965919]}");
INSERT INTO `wp_defender_lockout` VALUES("1131", "62.210.209.245", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1132", "46.105.100.82", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1133", "142.93.35.169", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1134", "107.77.83.16", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1135", "107.77.206.181", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1136", "24.194.189.53", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1137", "178.128.84.200", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1138", "54.186.202.139", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1139", "212.227.174.234", "normal", "", "0", "0", "0", "0", "2", "{\"nf\":[1606970621,1606970633]}");
INSERT INTO `wp_defender_lockout` VALUES("1140", "13.66.139.2", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1141", "199.231.185.108", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1142", "94.76.1.171", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1606973387]}");
INSERT INTO `wp_defender_lockout` VALUES("1143", "207.244.253.64", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1144", "31.24.128.55", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1145", "35.199.2.5", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1146", "3.105.103.30", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1147", "40.77.191.18", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1148", "91.204.46.106", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1149", "192.64.116.62", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1150", "51.158.153.217", "normal", "", "0", "0", "0", "0", "2", "{\"nf\":[1606981336,1606981337]}");
INSERT INTO `wp_defender_lockout` VALUES("1151", "138.246.253.24", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1152", "195.154.237.166", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1153", "37.187.252.148", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1154", "207.47.61.9", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1155", "18.191.47.74", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1156", "104.198.172.68", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1157", "193.112.248.186", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1158", "104.207.151.59", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1159", "18.237.198.186", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1606994395]}");
INSERT INTO `wp_defender_lockout` VALUES("1160", "178.63.79.232", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1161", "52.152.170.230", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1162", "3.94.181.25", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1163", "47.75.74.103", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1164", "47.91.222.124", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1165", "113.160.54.78", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1166", "92.53.118.39", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1167", "139.59.75.162", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1168", "139.59.80.157", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1169", "138.0.92.31", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1607006875]}");
INSERT INTO `wp_defender_lockout` VALUES("1170", "5.39.87.36", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1171", "171.244.32.185", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1607009225]}");
INSERT INTO `wp_defender_lockout` VALUES("1172", "35.220.149.235", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1173", "129.213.203.59", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1174", "162.221.185.250", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1175", "85.208.98.17", "normal", "", "0", "0", "0", "0", "2", "{\"nf\":[1607014220,1607014229]}");
INSERT INTO `wp_defender_lockout` VALUES("1176", "85.208.98.16", "normal", "", "0", "0", "0", "0", "2", "{\"nf\":[1607014222,1607014228]}");
INSERT INTO `wp_defender_lockout` VALUES("1177", "85.208.98.23", "normal", "", "0", "0", "0", "0", "1", "{\"nf\":[1607014234]}");
INSERT INTO `wp_defender_lockout` VALUES("1178", "85.128.142.227", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1179", "37.187.171.203", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1180", "142.4.24.73", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1181", "13.66.139.150", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1182", "99.79.12.226", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1183", "72.185.68.219", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1184", "217.182.175.206", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1185", "111.202.101.117", "normal", "", "0", "0", "0", "0", "0", "[]");
INSERT INTO `wp_defender_lockout` VALUES("1186", "147.91.111.100", "normal", "", "0", "0", "0", "1", "0", "{\"login\":[1607022158]}");
INSERT INTO `wp_defender_lockout` VALUES("1187", "62.210.149.60", "normal", "", "0", "0", "0", "0", "2", "{\"nf\":[1607022234,1607022249]}");

/* INSERT TABLE DATA: wp_defender_lockout_log */
INSERT INTO `wp_defender_lockout_log` VALUES("1", "Request for file /wp-content/plugins/cherry-plugin/admin/import-export/199877.php which doesn\'t exist", "51.89.204.170", "1606246635", "404_error", "python-requests/2.24.0", "1", "/wp-content/plugins/cherry-plugin/admin/import-export/199877.php");
INSERT INTO `wp_defender_lockout_log` VALUES("2", "Request for file /snowmobile.html which doesn\'t exist", "208.64.115.10", "1606247281", "404_error", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36", "1", "/snowmobile.html");
INSERT INTO `wp_defender_lockout_log` VALUES("3", "Request for file /wp/wp-content/uploads/subscribe-animated-gif-150.gif which doesn\'t exist", "208.64.115.10", "1606247283", "404_error", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36", "1", "/wp/wp-content/uploads/subscribe-animated-gif-150.gif");
INSERT INTO `wp_defender_lockout_log` VALUES("4", "Request for file /data/admin/allowurl.txt which doesn\'t exist", "39.99.54.47", "1606249324", "404_error", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:48.0) Gecko/20100101 Firefox/48.0", "1", "/data/admin/allowurl.txt");
INSERT INTO `wp_defender_lockout_log` VALUES("5", "Request for file /snowmobile.html which doesn\'t exist", "205.169.39.141", "1606257534", "404_error", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.61 Safari/537.36", "1", "/snowmobile.html");
INSERT INTO `wp_defender_lockout_log` VALUES("6", "Request for file /wp-content/plugins/apikey/cursed.php which doesn\'t exist", "51.89.204.170", "1606258249", "404_error", "python-requests/2.24.0", "1", "/wp-content/plugins/apikey/cursed.php");
INSERT INTO `wp_defender_lockout_log` VALUES("7", "Request for file /.env which doesn\'t exist", "35.202.232.139", "1606265945", "404_error", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1", "/.env");
INSERT INTO `wp_defender_lockout_log` VALUES("8", "Request for file /wp-content/plugins/advanced_file_manager_5/php/connector.minimal.php which doesn\'t exist", "23.228.109.146", "1606266725", "404_error", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2896.3 Safari/537.36", "1", "/wp-content/plugins/advanced_file_manager_5/php/connector.minimal.php");
INSERT INTO `wp_defender_lockout_log` VALUES("9", "Request for file /vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php which doesn\'t exist", "52.188.20.172", "1606271013", "404_error", "python-requests/2.24.0", "1", "/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("10", "Request for file /api/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php which doesn\'t exist", "52.188.20.172", "1606271023", "404_error", "python-requests/2.24.0", "1", "/api/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("11", "Request for file /laravel/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php which doesn\'t exist", "52.188.20.172", "1606271074", "404_error", "python-requests/2.24.0", "1", "/laravel/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("12", "Request for file /modules/autoupgrade/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php which doesn\'t exist", "52.188.20.172", "1606271102", "404_error", "python-requests/2.24.0", "1", "/modules/autoupgrade/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("13", "Request for file /sites/all/libraries/mailchimp/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php which doesn\'t exist", "52.188.20.172", "1606271131", "404_error", "python-requests/2.24.0", "1", "/sites/all/libraries/mailchimp/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("14", "Request for file /test/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php which doesn\'t exist", "52.188.20.172", "1606271149", "404_error", "python-requests/2.24.0", "1", "/test/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("15", "Request for file /admin/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php which doesn\'t exist", "52.188.20.172", "1606271180", "404_error", "python-requests/2.24.0", "1", "/admin/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("16", "Request for file /composer/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php which doesn\'t exist", "52.188.20.172", "1606271207", "404_error", "python-requests/2.24.0", "1", "/composer/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("17", "Request for file /modules/ps_facetedsearch/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php which doesn\'t exist", "52.188.20.172", "1606271208", "404_error", "python-requests/2.24.0", "1", "/modules/ps_facetedsearch/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("18", "Request for file /payment/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php which doesn\'t exist", "52.188.20.172", "1606271225", "404_error", "python-requests/2.24.0", "1", "/payment/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("19", "Request for file /concrete/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php which doesn\'t exist", "52.188.20.172", "1606271242", "404_error", "python-requests/2.24.0", "1", "/concrete/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("20", "Request for file /accounts/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php which doesn\'t exist", "52.188.20.172", "1606271250", "404_error", "python-requests/2.24.0", "1", "/accounts/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("21", "Request for file /blog/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php which doesn\'t exist", "52.188.20.172", "1606271255", "404_error", "python-requests/2.24.0", "1", "/blog/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("22", "Request for file /system/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php which doesn\'t exist", "52.188.20.172", "1606271258", "404_error", "python-requests/2.24.0", "1", "/system/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("23", "Request for file /modules/gamification/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php which doesn\'t exist", "52.188.20.172", "1606271278", "404_error", "python-requests/2.24.0", "1", "/modules/gamification/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("24", "Request for file /public/enjoy/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php which doesn\'t exist", "52.188.20.172", "1606271292", "404_error", "python-requests/2.24.0", "1", "/public/enjoy/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("25", "Request for file /shop/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php which doesn\'t exist", "52.188.20.172", "1606271305", "404_error", "python-requests/2.24.0", "1", "/shop/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("26", "Request for file /player/AutoPost/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php which doesn\'t exist", "52.188.20.172", "1606271325", "404_error", "python-requests/2.24.0", "1", "/player/AutoPost/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("27", "Request for file /gr/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php which doesn\'t exist", "52.188.20.172", "1606271365", "404_error", "python-requests/2.24.0", "1", "/gr/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("28", "Request for file /site/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php which doesn\'t exist", "52.188.20.172", "1606271400", "404_error", "python-requests/2.24.0", "1", "/site/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("29", "Request for file /wp-content/plugins/jekyll-exporter/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php which doesn\'t exist", "52.188.20.172", "1606271433", "404_error", "python-requests/2.24.0", "1", "/wp-content/plugins/jekyll-exporter/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("30", "Request for file /OLD/wp-admin/ which doesn\'t exist", "108.167.133.25", "1606274942", "404_error", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36", "1", "/OLD/wp-admin/");
INSERT INTO `wp_defender_lockout_log` VALUES("31", "Failed login attempt with username admin", "103.237.147.16", "1606274968", "auth_fail", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("32", "Failed login attempt with username admin", "103.237.147.16", "1606274968", "auth_fail", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("33", "Failed login attempt with username econolodgeloon", "91.93.127.34", "1606275248", "auth_fail", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36", "1", "econolodgeloon");
INSERT INTO `wp_defender_lockout_log` VALUES("34", "Failed login attempt with username admin", "91.93.127.34", "1606275248", "auth_fail", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("35", "Failed login attempt with username admin", "173.201.196.146", "1606275272", "auth_fail", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("36", "Failed login attempt with username econolodgeloon", "173.201.196.146", "1606275272", "auth_fail", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36", "1", "econolodgeloon");
INSERT INTO `wp_defender_lockout_log` VALUES("37", "Failed login attempt with username econolodgeloon", "50.63.196.28", "1606275379", "auth_fail", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36", "1", "econolodgeloon");
INSERT INTO `wp_defender_lockout_log` VALUES("38", "Failed login attempt with username admin", "50.63.196.28", "1606275379", "auth_fail", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("39", "Failed login attempt with username admin", "95.107.164.12", "1606286482", "auth_fail", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:63.0) Gecko/20100101 Firefox/63.0", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("40", "Request for file /wp-content/uploads/index.php which doesn\'t exist", "193.106.30.100", "1606287200", "404_error", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:67.0) Gecko/20100101 Firefox/67.0", "1", "/wp-content/uploads/index.php");
INSERT INTO `wp_defender_lockout_log` VALUES("41", "Request for file /.env which doesn\'t exist", "35.202.232.139", "1606288904", "404_error", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1", "/.env");
INSERT INTO `wp_defender_lockout_log` VALUES("42", "Request for file /.env which doesn\'t exist", "204.15.110.165", "1606290208", "404_error", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1", "/.env");
INSERT INTO `wp_defender_lockout_log` VALUES("43", "Request for file /wp-content/uploads/frontoutsidewideview-150x150.jpg which doesn\'t exist", "114.119.158.58", "1606294585", "404_error", "Mozilla/5.0 (Linux; Android 7.0;) AppleWebKit/537.36 (KHTML, like Gecko) Mobile Safari/537.36 (compatible; PetalBot;+https://aspiegel.com/petalbot)", "1", "/wp-content/uploads/frontoutsidewideview-150x150.jpg");
INSERT INTO `wp_defender_lockout_log` VALUES("44", "Request for file /google-analytics.com which doesn\'t exist", "223.88.196.245", "1606298304", "404_error", "Apache-HttpClient/4.2.5 (java 1.5)", "1", "/google-analytics.com");
INSERT INTO `wp_defender_lockout_log` VALUES("45", "Request for file /wp-content/plugins/ioptimization/IOptimize.php?rchk which doesn\'t exist", "52.177.121.220", "1606306225", "404_error", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1", "/wp-content/plugins/ioptimization/IOptimize.php?rchk");
INSERT INTO `wp_defender_lockout_log` VALUES("46", "Request for file /.env which doesn\'t exist", "34.72.142.113", "1606309808", "404_error", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1", "/.env");
INSERT INTO `wp_defender_lockout_log` VALUES("47", "Request for file /.env which doesn\'t exist", "34.72.142.113", "1606309808", "404_error", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1", "/.env");
INSERT INTO `wp_defender_lockout_log` VALUES("48", "Request for file /snowmobile.html which doesn\'t exist", "24.218.103.2", "1606311288", "404_error", "Mozilla/5.0 (iPhone; CPU iPhone OS 14_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/14.0.1 Mobile/15E148 Safari/604.1", "1", "/snowmobile.html");
INSERT INTO `wp_defender_lockout_log` VALUES("49", "Request for file /wp/wp-content/uploads/subscribe-animated-gif-150.gif which doesn\'t exist", "24.218.103.2", "1606311289", "404_error", "Mozilla/5.0 (iPhone; CPU iPhone OS 14_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/14.0.1 Mobile/15E148 Safari/604.1", "1", "/wp/wp-content/uploads/subscribe-animated-gif-150.gif");
INSERT INTO `wp_defender_lockout_log` VALUES("50", "Failed login attempt with username admin", "41.98.115.132", "1606313796", "auth_fail", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:63.0) Gecko/20100101 Firefox/63.0", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("51", "Request for file /utility/convert/source/d7.2_x1.5/readme.txt which doesn\'t exist", "47.92.241.24", "1606323415", "404_error", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:48.0) Gecko/20100101 Firefox/48.0", "1", "/utility/convert/source/d7.2_x1.5/readme.txt");
INSERT INTO `wp_defender_lockout_log` VALUES("52", "Failed login attempt with username admin", "49.49.236.179", "1606326441", "auth_fail", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.110 Safari/537.36", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("53", "Request for file /christmastree.html which doesn\'t exist", "114.119.133.165", "1606335613", "404_error", "Mozilla/5.0 (Linux; Android 7.0;) AppleWebKit/537.36 (KHTML, like Gecko) Mobile Safari/537.36 (compatible; PetalBot;+https://aspiegel.com/petalbot)", "1", "/christmastree.html");
INSERT INTO `wp_defender_lockout_log` VALUES("54", "Request for file /blog/ which doesn\'t exist", "100.26.152.203", "1606338174", "404_error", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/blog/");
INSERT INTO `wp_defender_lockout_log` VALUES("55", "Request for file /wordpress/ which doesn\'t exist", "100.26.152.203", "1606338175", "404_error", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/wordpress/");
INSERT INTO `wp_defender_lockout_log` VALUES("56", "Request for file /new/ which doesn\'t exist", "100.26.152.203", "1606338176", "404_error", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/new/");
INSERT INTO `wp_defender_lockout_log` VALUES("57", "Request for file /old/ which doesn\'t exist", "100.26.152.203", "1606338177", "404_error", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/old/");
INSERT INTO `wp_defender_lockout_log` VALUES("58", "Request for file /test/ which doesn\'t exist", "100.26.152.203", "1606338178", "404_error", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/test/");
INSERT INTO `wp_defender_lockout_log` VALUES("59", "Request for file /main/ which doesn\'t exist", "100.26.152.203", "1606338179", "404_error", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/main/");
INSERT INTO `wp_defender_lockout_log` VALUES("60", "Request for file /site/ which doesn\'t exist", "100.26.152.203", "1606338180", "404_error", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/site/");
INSERT INTO `wp_defender_lockout_log` VALUES("61", "Request for file /backup/ which doesn\'t exist", "100.26.152.203", "1606338180", "404_error", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/backup/");
INSERT INTO `wp_defender_lockout_log` VALUES("62", "Request for file /demo/ which doesn\'t exist", "100.26.152.203", "1606338181", "404_error", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/demo/");
INSERT INTO `wp_defender_lockout_log` VALUES("63", "Request for file /home/ which doesn\'t exist", "100.26.152.203", "1606338182", "404_error", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/home/");
INSERT INTO `wp_defender_lockout_log` VALUES("64", "Request for file /tmp/ which doesn\'t exist", "100.26.152.203", "1606338183", "404_error", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/tmp/");
INSERT INTO `wp_defender_lockout_log` VALUES("65", "Request for file /cms/ which doesn\'t exist", "100.26.152.203", "1606338184", "404_error", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/cms/");
INSERT INTO `wp_defender_lockout_log` VALUES("66", "Request for file /dev/ which doesn\'t exist", "100.26.152.203", "1606338185", "404_error", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/dev/");
INSERT INTO `wp_defender_lockout_log` VALUES("67", "Request for file /old-wp/ which doesn\'t exist", "100.26.152.203", "1606338186", "404_error", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/old-wp/");
INSERT INTO `wp_defender_lockout_log` VALUES("68", "Request for file /web/ which doesn\'t exist", "100.26.152.203", "1606338187", "404_error", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/web/");
INSERT INTO `wp_defender_lockout_log` VALUES("69", "Request for file /old-site/ which doesn\'t exist", "100.26.152.203", "1606338187", "404_error", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/old-site/");
INSERT INTO `wp_defender_lockout_log` VALUES("70", "Request for file /temp/ which doesn\'t exist", "100.26.152.203", "1606338188", "404_error", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/temp/");
INSERT INTO `wp_defender_lockout_log` VALUES("71", "Request for file /2018/ which doesn\'t exist", "100.26.152.203", "1606338189", "404_error", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/2018/");
INSERT INTO `wp_defender_lockout_log` VALUES("72", "Request for file /2019/ which doesn\'t exist", "100.26.152.203", "1606338190", "404_error", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/2019/");
INSERT INTO `wp_defender_lockout_log` VALUES("73", "Request for file /bk/ which doesn\'t exist", "100.26.152.203", "1606338191", "404_error", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/bk/");
INSERT INTO `wp_defender_lockout_log` VALUES("74", "Lockout occurred:  Too many 404 requests for /bk/", "100.26.152.203", "1606338191", "404_lockout", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/bk/");
INSERT INTO `wp_defender_lockout_log` VALUES("75", "Failed login attempt with username admin", "95.216.145.1", "1606339530", "auth_fail", "Mozilla/5.0 (X11; Linux x86_64; rv:60.0) Gecko/20100101 Firefox/60.0", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("76", "Request for file /cache.php which doesn\'t exist", "193.106.30.100", "1606341312", "404_error", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:67.0) Gecko/20100101 Firefox/67.0", "1", "/cache.php");
INSERT INTO `wp_defender_lockout_log` VALUES("77", "Request for file /router.php which doesn\'t exist", "39.101.1.61", "1606341395", "404_error", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:48.0) Gecko/20100101 Firefox/48.0", "1", "/router.php");
INSERT INTO `wp_defender_lockout_log` VALUES("78", "Request for file /images/homeimage6.jpg which doesn\'t exist", "114.119.140.169", "1606347486", "404_error", "Mozilla/5.0 (Linux; Android 7.0;) AppleWebKit/537.36 (KHTML, like Gecko) Mobile Safari/537.36 (compatible; PetalBot;+https://aspiegel.com/petalbot)", "1", "/images/homeimage6.jpg");
INSERT INTO `wp_defender_lockout_log` VALUES("79", "Request for file /vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php which doesn\'t exist", "52.188.20.172", "1606350937", "404_error", "python-requests/2.24.0", "1", "/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("80", "Request for file /api/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php which doesn\'t exist", "52.188.20.172", "1606350950", "404_error", "python-requests/2.24.0", "1", "/api/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("81", "Request for file /laravel/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php which doesn\'t exist", "52.188.20.172", "1606350962", "404_error", "python-requests/2.24.0", "1", "/laravel/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("82", "Request for file /modules/autoupgrade/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php which doesn\'t exist", "52.188.20.172", "1606350970", "404_error", "python-requests/2.24.0", "1", "/modules/autoupgrade/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("83", "Request for file /sites/all/libraries/mailchimp/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php which doesn\'t exist", "52.188.20.172", "1606350972", "404_error", "python-requests/2.24.0", "1", "/sites/all/libraries/mailchimp/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("84", "Request for file /test/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php which doesn\'t exist", "52.188.20.172", "1606350974", "404_error", "python-requests/2.24.0", "1", "/test/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("85", "Request for file /admin/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php which doesn\'t exist", "52.188.20.172", "1606350978", "404_error", "python-requests/2.24.0", "1", "/admin/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("86", "Request for file /composer/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php which doesn\'t exist", "52.188.20.172", "1606350995", "404_error", "python-requests/2.24.0", "1", "/composer/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("87", "Request for file /modules/ps_facetedsearch/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php which doesn\'t exist", "52.188.20.172", "1606351016", "404_error", "python-requests/2.24.0", "1", "/modules/ps_facetedsearch/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("88", "Request for file /payment/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php which doesn\'t exist", "52.188.20.172", "1606351027", "404_error", "python-requests/2.24.0", "1", "/payment/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("89", "Request for file /concrete/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php which doesn\'t exist", "52.188.20.172", "1606351032", "404_error", "python-requests/2.24.0", "1", "/concrete/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("90", "Request for file /accounts/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php which doesn\'t exist", "52.188.20.172", "1606351043", "404_error", "python-requests/2.24.0", "1", "/accounts/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("91", "Request for file /blog/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php which doesn\'t exist", "52.188.20.172", "1606351058", "404_error", "python-requests/2.24.0", "1", "/blog/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("92", "Request for file /system/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php which doesn\'t exist", "52.188.20.172", "1606351075", "404_error", "python-requests/2.24.0", "1", "/system/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("93", "Request for file /modules/gamification/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php which doesn\'t exist", "52.188.20.172", "1606351080", "404_error", "python-requests/2.24.0", "1", "/modules/gamification/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("94", "Request for file /public/enjoy/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php which doesn\'t exist", "52.188.20.172", "1606351083", "404_error", "python-requests/2.24.0", "1", "/public/enjoy/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("95", "Request for file /shop/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php which doesn\'t exist", "52.188.20.172", "1606351084", "404_error", "python-requests/2.24.0", "1", "/shop/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("96", "Request for file /player/AutoPost/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php which doesn\'t exist", "52.188.20.172", "1606351090", "404_error", "python-requests/2.24.0", "1", "/player/AutoPost/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("97", "Request for file /gr/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php which doesn\'t exist", "52.188.20.172", "1606351100", "404_error", "python-requests/2.24.0", "1", "/gr/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("98", "Request for file /site/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php which doesn\'t exist", "52.188.20.172", "1606351104", "404_error", "python-requests/2.24.0", "1", "/site/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("99", "Lockout occurred:  Too many 404 requests for /site/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php", "52.188.20.172", "1606351104", "404_lockout", "python-requests/2.24.0", "1", "/site/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php");
INSERT INTO `wp_defender_lockout_log` VALUES("100", "Request for file /e/data/js/ajax.js which doesn\'t exist", "47.92.241.24", "1606351759", "404_error", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:48.0) Gecko/20100101 Firefox/48.0", "1", "/e/data/js/ajax.js");
INSERT INTO `wp_defender_lockout_log` VALUES("101", "Request for file /pc/20/ which doesn\'t exist", "218.86.22.17", "1606352204", "404_error", "Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.2)", "1", "/pc/20/");
INSERT INTO `wp_defender_lockout_log` VALUES("102", "Request for file /backup.sql which doesn\'t exist", "138.99.216.112", "1606353583", "404_error", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.121 Safari/537.36", "1", "/backup.sql");
INSERT INTO `wp_defender_lockout_log` VALUES("103", "Request for file /phpinfo.php which doesn\'t exist", "138.99.216.112", "1606353583", "404_error", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.121 Safari/537.36", "1", "/phpinfo.php");
INSERT INTO `wp_defender_lockout_log` VALUES("104", "Request for file /.env which doesn\'t exist", "138.99.216.112", "1606353583", "404_error", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.121 Safari/537.36", "1", "/.env");
INSERT INTO `wp_defender_lockout_log` VALUES("105", "Request for file /c99.php which doesn\'t exist", "138.99.216.112", "1606353583", "404_error", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.121 Safari/537.36", "1", "/c99.php");
INSERT INTO `wp_defender_lockout_log` VALUES("106", "Request for file /config.php which doesn\'t exist", "138.99.216.112", "1606353583", "404_error", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.121 Safari/537.36", "1", "/config.php");
INSERT INTO `wp_defender_lockout_log` VALUES("107", "Request for file /.git/HEAD which doesn\'t exist", "138.99.216.112", "1606353583", "404_error", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.121 Safari/537.36", "1", "/.git/HEAD");
INSERT INTO `wp_defender_lockout_log` VALUES("108", "Request for file /wp-content/themes/WPLocalPlaces/style.css which doesn\'t exist", "23.228.109.146", "1606359238", "404_error", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2896.3 Safari/537.36", "1", "/wp-content/themes/WPLocalPlaces/style.css");
INSERT INTO `wp_defender_lockout_log` VALUES("109", "Failed login attempt with username admin", "196.77.114.43", "1606362058", "auth_fail", "Opera/9.80 (Windows NT 6.1) Presto/2.12.388 Version/12.12", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("110", "Request for file /wp-content/plugins/superstorefinder-wp/js/docs.js which doesn\'t exist", "176.31.182.56", "1606362487", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_5) AppleWeb            Kit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36", "1", "/wp-content/plugins/superstorefinder-wp/js/docs.js");
INSERT INTO `wp_defender_lockout_log` VALUES("111", "Request for file /wp-content/plugins/superlogoshowcase-wp/js/docs.js which doesn\'t exist", "176.31.182.56", "1606362500", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_5) AppleWeb            Kit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36", "1", "/wp-content/plugins/superlogoshowcase-wp/js/docs.js");
INSERT INTO `wp_defender_lockout_log` VALUES("112", "Request for file /wp-content/plugins/super-interactive-maps/js/docs.js which doesn\'t exist", "176.31.182.56", "1606362509", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_5) AppleWeb            Kit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36", "1", "/wp-content/plugins/super-interactive-maps/js/docs.js");
INSERT INTO `wp_defender_lockout_log` VALUES("113", "Request for file /snowmobile.html which doesn\'t exist", "185.191.171.6", "1606362630", "404_error", "Mozilla/5.0 (compatible; SemrushBot/7~bl; +http://www.semrush.com/bot.html)", "1", "/snowmobile.html");
INSERT INTO `wp_defender_lockout_log` VALUES("114", "Failed login attempt with username admin", "31.220.3.147", "1606376440", "auth_fail", "Mozilla/5.0 (iPad; CPU OS 12_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.0 Mobile/15E148 Safari/604.1", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("115", "Request for file /xxxss which doesn\'t exist", "39.101.1.61", "1606380394", "404_error", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:48.0) Gecko/20100101 Firefox/48.0", "1", "/xxxss");
INSERT INTO `wp_defender_lockout_log` VALUES("116", "Request for file /css/album.css which doesn\'t exist", "39.101.1.61", "1606388829", "404_error", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:48.0) Gecko/20100101 Firefox/48.0", "1", "/css/album.css");
INSERT INTO `wp_defender_lockout_log` VALUES("117", "Request for file /e/admin/ which doesn\'t exist", "39.101.1.61", "1606388871", "404_error", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:48.0) Gecko/20100101 Firefox/48.0", "1", "/e/admin/");
INSERT INTO `wp_defender_lockout_log` VALUES("118", "Failed login attempt with username admin", "113.163.94.90", "1606390080", "auth_fail", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.110 Safari/537.36", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("119", "Request for file /wp-includes/modules.php which doesn\'t exist", "193.106.30.100", "1606390934", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.14; rv:68.0) Gecko/20100101 Firefox/68.0", "1", "/wp-includes/modules.php");
INSERT INTO `wp_defender_lockout_log` VALUES("120", "Request for file /timthumb.php?src=http://picasa.com.shresthadipak.com.np/kontol.php which doesn\'t exist", "51.68.213.75", "1606394328", "404_error", "Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:28.0) Gecko/20100101 Firefox/28.0", "1", "/timthumb.php?src=http://picasa.com.shresthadipak.com.np/kontol.php");
INSERT INTO `wp_defender_lockout_log` VALUES("121", "Request for file /thumb.php?src=http://picasa.com.shresthadipak.com.np/kontol.php which doesn\'t exist", "51.68.213.75", "1606394340", "404_error", "Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:28.0) Gecko/20100101 Firefox/28.0", "1", "/thumb.php?src=http://picasa.com.shresthadipak.com.np/kontol.php");
INSERT INTO `wp_defender_lockout_log` VALUES("122", "Request for file /tim.php?src=http://picasa.com.shresthadipak.com.np/kontol.php which doesn\'t exist", "51.68.213.75", "1606394351", "404_error", "Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:28.0) Gecko/20100101 Firefox/28.0", "1", "/tim.php?src=http://picasa.com.shresthadipak.com.np/kontol.php");
INSERT INTO `wp_defender_lockout_log` VALUES("123", "Request for file /admin/timthumb.php?src=http://picasa.com.shresthadipak.com.np/kontol.php which doesn\'t exist", "51.68.213.75", "1606394368", "404_error", "Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:28.0) Gecko/20100101 Firefox/28.0", "1", "/admin/timthumb.php?src=http://picasa.com.shresthadipak.com.np/kontol.php");
INSERT INTO `wp_defender_lockout_log` VALUES("124", "Request for file /admin/thumb.php?src=http://picasa.com.shresthadipak.com.np/kontol.php which doesn\'t exist", "51.68.213.75", "1606394380", "404_error", "Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:28.0) Gecko/20100101 Firefox/28.0", "1", "/admin/thumb.php?src=http://picasa.com.shresthadipak.com.np/kontol.php");
INSERT INTO `wp_defender_lockout_log` VALUES("125", "Request for file /wp-content/plugins/ioptimization/IOptimize.php?rchk which doesn\'t exist", "104.214.79.46", "1606397890", "404_error", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1", "/wp-content/plugins/ioptimization/IOptimize.php?rchk");
INSERT INTO `wp_defender_lockout_log` VALUES("126", "Request for file /wp/wp-content/plugins/ioptimization/IOptimize.php?rchk which doesn\'t exist", "104.214.79.46", "1606397900", "404_error", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1", "/wp/wp-content/plugins/ioptimization/IOptimize.php?rchk");
INSERT INTO `wp_defender_lockout_log` VALUES("127", "Request for file /wordpress/wp-content/plugins/ioptimization/IOptimize.php?rchk which doesn\'t exist", "104.214.79.46", "1606397908", "404_error", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1", "/wordpress/wp-content/plugins/ioptimization/IOptimize.php?rchk");
INSERT INTO `wp_defender_lockout_log` VALUES("128", "Request for file /old/wp-content/plugins/ioptimization/IOptimize.php?rchk which doesn\'t exist", "104.214.79.46", "1606397916", "404_error", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1", "/old/wp-content/plugins/ioptimization/IOptimize.php?rchk");
INSERT INTO `wp_defender_lockout_log` VALUES("129", "Request for file /new/wp-content/plugins/ioptimization/IOptimize.php?rchk which doesn\'t exist", "104.214.79.46", "1606397924", "404_error", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1", "/new/wp-content/plugins/ioptimization/IOptimize.php?rchk");
INSERT INTO `wp_defender_lockout_log` VALUES("130", "Request for file /blog/wp-content/plugins/ioptimization/IOptimize.php?rchk which doesn\'t exist", "104.214.79.46", "1606397933", "404_error", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1", "/blog/wp-content/plugins/ioptimization/IOptimize.php?rchk");
INSERT INTO `wp_defender_lockout_log` VALUES("131", "Request for file /test/wp-content/plugins/ioptimization/IOptimize.php?rchk which doesn\'t exist", "104.214.79.46", "1606397947", "404_error", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1", "/test/wp-content/plugins/ioptimization/IOptimize.php?rchk");
INSERT INTO `wp_defender_lockout_log` VALUES("132", "Request for file /demo/wp-content/plugins/ioptimization/IOptimize.php?rchk which doesn\'t exist", "104.214.79.46", "1606397954", "404_error", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1", "/demo/wp-content/plugins/ioptimization/IOptimize.php?rchk");
INSERT INTO `wp_defender_lockout_log` VALUES("133", "Request for file /admin/wp-content/plugins/ioptimization/IOptimize.php?rchk which doesn\'t exist", "104.214.79.46", "1606397965", "404_error", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1", "/admin/wp-content/plugins/ioptimization/IOptimize.php?rchk");
INSERT INTO `wp_defender_lockout_log` VALUES("134", "Request for file /2020/wp-content/plugins/ioptimization/IOptimize.php?rchk which doesn\'t exist", "104.214.79.46", "1606397969", "404_error", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1", "/2020/wp-content/plugins/ioptimization/IOptimize.php?rchk");
INSERT INTO `wp_defender_lockout_log` VALUES("135", "Request for file /2019/wp-content/plugins/ioptimization/IOptimize.php?rchk which doesn\'t exist", "104.214.79.46", "1606397978", "404_error", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1", "/2019/wp-content/plugins/ioptimization/IOptimize.php?rchk");
INSERT INTO `wp_defender_lockout_log` VALUES("136", "Request for file /.env which doesn\'t exist", "52.188.20.172", "1606399109", "404_error", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1", "/.env");
INSERT INTO `wp_defender_lockout_log` VALUES("137", "Request for file /api/.env which doesn\'t exist", "52.188.20.172", "1606399121", "404_error", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1", "/api/.env");
INSERT INTO `wp_defender_lockout_log` VALUES("138", "Request for file /laravel/.env which doesn\'t exist", "52.188.20.172", "1606399134", "404_error", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1", "/laravel/.env");
INSERT INTO `wp_defender_lockout_log` VALUES("139", "Request for file /test/.env which doesn\'t exist", "52.188.20.172", "1606399158", "404_error", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1", "/test/.env");
INSERT INTO `wp_defender_lockout_log` VALUES("140", "Request for file /admin/.env which doesn\'t exist", "52.188.20.172", "1606399174", "404_error", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1", "/admin/.env");
INSERT INTO `wp_defender_lockout_log` VALUES("141", "Request for file /vendor/.env which doesn\'t exist", "52.188.20.172", "1606399191", "404_error", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1", "/vendor/.env");
INSERT INTO `wp_defender_lockout_log` VALUES("142", "Request for file /sites/.env which doesn\'t exist", "52.188.20.172", "1606399199", "404_error", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1", "/sites/.env");
INSERT INTO `wp_defender_lockout_log` VALUES("143", "Request for file /blog/.env which doesn\'t exist", "52.188.20.172", "1606399223", "404_error", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1", "/blog/.env");
INSERT INTO `wp_defender_lockout_log` VALUES("144", "Request for file /.env which doesn\'t exist", "104.192.0.122", "1606402366", "404_error", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1", "/.env");
INSERT INTO `wp_defender_lockout_log` VALUES("145", "Request for file /wp-content/plugins/ubh/up.php which doesn\'t exist", "88.198.242.184", "1606407305", "404_error", "Apache/2.4.34 (Ubuntu) OpenSSL/1.1.1 (internal dummy connection)", "1", "/wp-content/plugins/ubh/up.php");
INSERT INTO `wp_defender_lockout_log` VALUES("146", "Request for file /fonts.googleapis.com which doesn\'t exist", "121.239.199.21", "1606407549", "404_error", "Apache-HttpClient/4.2.5 (java 1.5)", "1", "/fonts.googleapis.com");
INSERT INTO `wp_defender_lockout_log` VALUES("147", "Request for file /s.gravatar.com which doesn\'t exist", "121.239.199.21", "1606407560", "404_error", "Apache-HttpClient/4.2.5 (java 1.5)", "1", "/s.gravatar.com");
INSERT INTO `wp_defender_lockout_log` VALUES("148", "Request for file /fonts.gstatic.com which doesn\'t exist", "121.239.199.21", "1606407577", "404_error", "Apache-HttpClient/4.2.5 (java 1.5)", "1", "/fonts.gstatic.com");
INSERT INTO `wp_defender_lockout_log` VALUES("149", "Request for file /youtube.com which doesn\'t exist", "121.239.199.21", "1606407579", "404_error", "Apache-HttpClient/4.2.5 (java 1.5)", "1", "/youtube.com");
INSERT INTO `wp_defender_lockout_log` VALUES("150", "Request for file /google-analytics.com which doesn\'t exist", "121.239.199.21", "1606407583", "404_error", "Apache-HttpClient/4.2.5 (java 1.5)", "1", "/google-analytics.com");
INSERT INTO `wp_defender_lockout_log` VALUES("151", "Request for file /ajax.googleapis.com which doesn\'t exist", "121.239.199.21", "1606407598", "404_error", "Apache-HttpClient/4.2.5 (java 1.5)", "1", "/ajax.googleapis.com");
INSERT INTO `wp_defender_lockout_log` VALUES("152", "Request for file /ssl.google-analytics.com which doesn\'t exist", "121.239.199.21", "1606407603", "404_error", "Apache-HttpClient/4.2.5 (java 1.5)", "1", "/ssl.google-analytics.com");
INSERT INTO `wp_defender_lockout_log` VALUES("153", "Request for file /blog/xmlrpc.php which doesn\'t exist", "81.24.247.58", "1606413771", "404_error", "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10.6; fr; rv:1.9.2.8) Gecko/20100722 Firefox/3.6.8", "1", "/blog/xmlrpc.php");
INSERT INTO `wp_defender_lockout_log` VALUES("154", "Request for file /contact.html which doesn\'t exist", "192.227.171.45", "1606416616", "404_error", "Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2910.78 Safari/537.36", "1", "/contact.html");
INSERT INTO `wp_defender_lockout_log` VALUES("155", "Request for file /white-mountains-nh-inn-suites-specials-and-packages which doesn\'t exist", "114.119.140.238", "1606416803", "404_error", "Mozilla/5.0 (Linux; Android 7.0;) AppleWebKit/537.36 (KHTML, like Gecko) Mobile Safari/537.36 (compatible; PetalBot;+https://aspiegel.com/petalbot)", "1", "/white-mountains-nh-inn-suites-specials-and-packages");
INSERT INTO `wp_defender_lockout_log` VALUES("156", "Request for file /installer-backup.php which doesn\'t exist", "88.80.36.226", "1606419810", "404_error", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36", "1", "/installer-backup.php");
INSERT INTO `wp_defender_lockout_log` VALUES("157", "Failed login attempt with username admin", "202.93.231.96", "1606426608", "auth_fail", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.77 Safari/537.36", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("158", "Request for file /1.php which doesn\'t exist", "193.106.30.100", "1606429404", "404_error", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36", "1", "/1.php");
INSERT INTO `wp_defender_lockout_log` VALUES("159", "Request for file /reservations.html which doesn\'t exist", "114.119.133.224", "1606430348", "404_error", "Mozilla/5.0 (Linux; Android 7.0;) AppleWebKit/537.36 (KHTML, like Gecko) Mobile Safari/537.36 (compatible; PetalBot;+https://aspiegel.com/petalbot)", "1", "/reservations.html");
INSERT INTO `wp_defender_lockout_log` VALUES("160", "Request for file /.env which doesn\'t exist", "51.89.204.170", "1606430844", "404_error", "python-requests/2.24.0", "1", "/.env");
INSERT INTO `wp_defender_lockout_log` VALUES("161", "Request for file /700px/housebackroom.jpg which doesn\'t exist", "114.119.149.222", "1606441815", "404_error", "Mozilla/5.0 (Linux; Android 7.0;) AppleWebKit/537.36 (KHTML, like Gecko) Mobile Safari/537.36 (compatible; PetalBot;+https://aspiegel.com/petalbot)", "1", "/700px/housebackroom.jpg");
INSERT INTO `wp_defender_lockout_log` VALUES("162", "Failed login attempt with username admin", "110.164.208.125", "1606456570", "auth_fail", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:63.0) Gecko/20100101 Firefox/63.0", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("163", "Request for file /vendor/phpunit/phpunit/phpunit.xsd which doesn\'t exist", "52.252.137.130", "1606461379", "404_error", "Mozilla/5.0 (X11; Linux x86_64; rv:52.0) Gecko/20100101 Firefox/52.0", "1", "/vendor/phpunit/phpunit/phpunit.xsd");
INSERT INTO `wp_defender_lockout_log` VALUES("164", "Request for file /ads.txt which doesn\'t exist", "54.203.64.202", "1606467301", "404_error", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko; compatible; BW/1.1; bit.ly/2W6Px8S) Chrome/84.0.4147.105 Safari/537.36", "1", "/ads.txt");
INSERT INTO `wp_defender_lockout_log` VALUES("165", "Request for file /google-analytics.com which doesn\'t exist", "121.239.199.21", "1606469106", "404_error", "Apache-HttpClient/4.2.5 (java 1.5)", "1", "/google-analytics.com");
INSERT INTO `wp_defender_lockout_log` VALUES("166", "Request for file /javascript:void which doesn\'t exist", "121.239.199.21", "1606469115", "404_error", "Apache-HttpClient/4.2.5 (java 1.5)", "1", "/javascript:void");
INSERT INTO `wp_defender_lockout_log` VALUES("167", "Request for file /apis.google.com which doesn\'t exist", "121.239.199.21", "1606469119", "404_error", "Apache-HttpClient/4.2.5 (java 1.5)", "1", "/apis.google.com");
INSERT INTO `wp_defender_lockout_log` VALUES("168", "Request for file /wp-config.php~ which doesn\'t exist", "50.63.165.245", "1606472458", "404_error", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36", "1", "/wp-config.php~");
INSERT INTO `wp_defender_lockout_log` VALUES("169", "Request for file /well-known.zip which doesn\'t exist", "160.153.154.5", "1606472469", "404_error", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36", "1", "/well-known.zip");
INSERT INTO `wp_defender_lockout_log` VALUES("170", "Request for file /wp-config.php.bak which doesn\'t exist", "198.71.239.11", "1606472481", "404_error", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36", "1", "/wp-config.php.bak");
INSERT INTO `wp_defender_lockout_log` VALUES("171", "Request for file /wp-config.php.resetwp_bak which doesn\'t exist", "184.168.46.200", "1606472504", "404_error", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36", "1", "/wp-config.php.resetwp_bak");
INSERT INTO `wp_defender_lockout_log` VALUES("172", "Request for file /wp-config.php.orig which doesn\'t exist", "103.97.100.15", "1606472517", "404_error", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36", "1", "/wp-config.php.orig");
INSERT INTO `wp_defender_lockout_log` VALUES("173", "Request for file /1.txt which doesn\'t exist", "91.134.206.89", "1606472570", "404_error", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36", "1", "/1.txt");
INSERT INTO `wp_defender_lockout_log` VALUES("174", "Request for file /wordpress.zip which doesn\'t exist", "51.38.50.235", "1606472570", "404_error", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36", "1", "/wordpress.zip");
INSERT INTO `wp_defender_lockout_log` VALUES("175", "Request for file /wp-config.php.save which doesn\'t exist", "163.172.7.97", "1606472573", "404_error", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36", "1", "/wp-config.php.save");
INSERT INTO `wp_defender_lockout_log` VALUES("176", "Request for file /public_html.zip which doesn\'t exist", "160.153.156.130", "1606472583", "404_error", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36", "1", "/public_html.zip");
INSERT INTO `wp_defender_lockout_log` VALUES("177", "Request for file /.well-known.zip which doesn\'t exist", "198.71.239.49", "1606472594", "404_error", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36", "1", "/.well-known.zip");
INSERT INTO `wp_defender_lockout_log` VALUES("178", "Request for file /1.txt which doesn\'t exist", "109.228.23.89", "1606472599", "404_error", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36", "1", "/1.txt");
INSERT INTO `wp_defender_lockout_log` VALUES("179", "Request for file /cgi-bin.zip which doesn\'t exist", "37.247.107.75", "1606472617", "404_error", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36", "1", "/cgi-bin.zip");
INSERT INTO `wp_defender_lockout_log` VALUES("180", "Request for file /econolodgeloon.zip which doesn\'t exist", "107.180.120.52", "1606472650", "404_error", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36", "1", "/econolodgeloon.zip");
INSERT INTO `wp_defender_lockout_log` VALUES("181", "Request for file /econolodgeloon.com.zip which doesn\'t exist", "5.135.15.241", "1606472676", "404_error", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36", "1", "/econolodgeloon.com.zip");
INSERT INTO `wp_defender_lockout_log` VALUES("182", "Request for file /wp-content/plugins/advanced_file_manager_5/php/connector.minimal.php which doesn\'t exist", "23.228.109.146", "1606474310", "404_error", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2896.3 Safari/537.36", "1", "/wp-content/plugins/advanced_file_manager_5/php/connector.minimal.php");
INSERT INTO `wp_defender_lockout_log` VALUES("183", "Request for file /demo/js/common.js which doesn\'t exist", "39.98.49.33", "1606475460", "404_error", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:48.0) Gecko/20100101 Firefox/48.0", "1", "/demo/js/common.js");
INSERT INTO `wp_defender_lockout_log` VALUES("184", "Request for file /data/admin/allowurl.txt which doesn\'t exist", "39.98.49.33", "1606475461", "404_error", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:48.0) Gecko/20100101 Firefox/48.0", "1", "/data/admin/allowurl.txt");
INSERT INTO `wp_defender_lockout_log` VALUES("185", "Request for file /css/album.css which doesn\'t exist", "39.98.49.33", "1606475461", "404_error", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:48.0) Gecko/20100101 Firefox/48.0", "1", "/css/album.css");
INSERT INTO `wp_defender_lockout_log` VALUES("186", "Request for file /xxxss which doesn\'t exist", "39.98.49.33", "1606475464", "404_error", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:48.0) Gecko/20100101 Firefox/48.0", "1", "/xxxss");
INSERT INTO `wp_defender_lockout_log` VALUES("187", "Failed login attempt with username admin", "103.104.52.185", "1606482314", "auth_fail", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:63.0) Gecko/20100101 Firefox/63.0", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("188", "Request for file /admin/login.php which doesn\'t exist", "103.214.68.136", "1606483834", "404_error", NULL, "1", "/admin/login.php");
INSERT INTO `wp_defender_lockout_log` VALUES("189", "Request for file /dede/login.php which doesn\'t exist", "103.214.68.136", "1606483834", "404_error", NULL, "1", "/dede/login.php");
INSERT INTO `wp_defender_lockout_log` VALUES("190", "Request for file /wp-info.php which doesn\'t exist", "193.106.30.100", "1606493374", "404_error", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36", "1", "/wp-info.php");
INSERT INTO `wp_defender_lockout_log` VALUES("191", "Failed login attempt with username econolodgeloon", "162.247.74.204", "1606494028", "auth_fail", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36", "1", "econolodgeloon");
INSERT INTO `wp_defender_lockout_log` VALUES("192", "Failed login attempt with username admin", "177.137.58.131", "1606495666", "auth_fail", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.77 Safari/537.36", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("193", "Failed login attempt with username admin", "177.137.58.131", "1606495666", "auth_fail", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.77 Safari/537.36", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("194", "Request for file /wp-content/plugins/ioptimization/IOptimize.php?rchk which doesn\'t exist", "52.177.121.220", "1606505630", "404_error", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1", "/wp-content/plugins/ioptimization/IOptimize.php?rchk");
INSERT INTO `wp_defender_lockout_log` VALUES("195", "Request for file /wp-content/plugins/ioptimization/IOptimize.php?rchk which doesn\'t exist", "52.177.121.220", "1606508581", "404_error", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1", "/wp-content/plugins/ioptimization/IOptimize.php?rchk");
INSERT INTO `wp_defender_lockout_log` VALUES("196", "Request for file /wp-content/index-uploads.php which doesn\'t exist", "5.188.62.147", "1606510159", "404_error", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2227.1 Safari/537.36", "1", "/wp-content/index-uploads.php");
INSERT INTO `wp_defender_lockout_log` VALUES("197", "Request for file /blog/ which doesn\'t exist", "100.26.135.239", "1606511932", "404_error", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/blog/");
INSERT INTO `wp_defender_lockout_log` VALUES("198", "Request for file /wordpress/ which doesn\'t exist", "100.26.135.239", "1606511933", "404_error", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/wordpress/");
INSERT INTO `wp_defender_lockout_log` VALUES("199", "Request for file /new/ which doesn\'t exist", "100.26.135.239", "1606511934", "404_error", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/new/");
INSERT INTO `wp_defender_lockout_log` VALUES("200", "Request for file /old/ which doesn\'t exist", "100.26.135.239", "1606511935", "404_error", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/old/");
INSERT INTO `wp_defender_lockout_log` VALUES("201", "Request for file /test/ which doesn\'t exist", "100.26.135.239", "1606511936", "404_error", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/test/");
INSERT INTO `wp_defender_lockout_log` VALUES("202", "Request for file /main/ which doesn\'t exist", "100.26.135.239", "1606511937", "404_error", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/main/");
INSERT INTO `wp_defender_lockout_log` VALUES("203", "Request for file /site/ which doesn\'t exist", "100.26.135.239", "1606511939", "404_error", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/site/");
INSERT INTO `wp_defender_lockout_log` VALUES("204", "Request for file /backup/ which doesn\'t exist", "100.26.135.239", "1606511940", "404_error", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/backup/");
INSERT INTO `wp_defender_lockout_log` VALUES("205", "Request for file /demo/ which doesn\'t exist", "100.26.135.239", "1606511941", "404_error", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/demo/");
INSERT INTO `wp_defender_lockout_log` VALUES("206", "Request for file /home/ which doesn\'t exist", "100.26.135.239", "1606511942", "404_error", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/home/");
INSERT INTO `wp_defender_lockout_log` VALUES("207", "Request for file /tmp/ which doesn\'t exist", "100.26.135.239", "1606511943", "404_error", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/tmp/");
INSERT INTO `wp_defender_lockout_log` VALUES("208", "Request for file /cms/ which doesn\'t exist", "100.26.135.239", "1606511944", "404_error", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/cms/");
INSERT INTO `wp_defender_lockout_log` VALUES("209", "Request for file /dev/ which doesn\'t exist", "100.26.135.239", "1606511945", "404_error", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/dev/");
INSERT INTO `wp_defender_lockout_log` VALUES("210", "Request for file /old-wp/ which doesn\'t exist", "100.26.135.239", "1606511946", "404_error", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/old-wp/");
INSERT INTO `wp_defender_lockout_log` VALUES("211", "Request for file /web/ which doesn\'t exist", "100.26.135.239", "1606511947", "404_error", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/web/");
INSERT INTO `wp_defender_lockout_log` VALUES("212", "Request for file /old-site/ which doesn\'t exist", "100.26.135.239", "1606511948", "404_error", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/old-site/");
INSERT INTO `wp_defender_lockout_log` VALUES("213", "Request for file /temp/ which doesn\'t exist", "100.26.135.239", "1606511949", "404_error", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/temp/");
INSERT INTO `wp_defender_lockout_log` VALUES("214", "Request for file /2018/ which doesn\'t exist", "100.26.135.239", "1606511950", "404_error", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/2018/");
INSERT INTO `wp_defender_lockout_log` VALUES("215", "Request for file /2019/ which doesn\'t exist", "100.26.135.239", "1606511951", "404_error", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/2019/");
INSERT INTO `wp_defender_lockout_log` VALUES("216", "Request for file /bk/ which doesn\'t exist", "100.26.135.239", "1606511952", "404_error", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/bk/");
INSERT INTO `wp_defender_lockout_log` VALUES("217", "Lockout occurred:  Too many 404 requests for /bk/", "100.26.135.239", "1606511952", "404_lockout", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1", "/bk/");
INSERT INTO `wp_defender_lockout_log` VALUES("218", "Request for file /fonts.googleapis.com which doesn\'t exist", "121.239.199.21", "1606515751", "404_error", "Apache-HttpClient/4.2.5 (java 1.5)", "1", "/fonts.googleapis.com");
INSERT INTO `wp_defender_lockout_log` VALUES("219", "Request for file /s.gravatar.com which doesn\'t exist", "121.239.199.21", "1606515756", "404_error", "Apache-HttpClient/4.2.5 (java 1.5)", "1", "/s.gravatar.com");
INSERT INTO `wp_defender_lockout_log` VALUES("220", "Request for file /fonts.gstatic.com which doesn\'t exist", "121.239.199.21", "1606515760", "404_error", "Apache-HttpClient/4.2.5 (java 1.5)", "1", "/fonts.gstatic.com");
INSERT INTO `wp_defender_lockout_log` VALUES("221", "Request for file /youtube.com which doesn\'t exist", "121.239.199.21", "1606515762", "404_error", "Apache-HttpClient/4.2.5 (java 1.5)", "1", "/youtube.com");
INSERT INTO `wp_defender_lockout_log` VALUES("222", "Request for file /google-analytics.com which doesn\'t exist", "121.239.199.21", "1606515764", "404_error", "Apache-HttpClient/4.2.5 (java 1.5)", "1", "/google-analytics.com");
INSERT INTO `wp_defender_lockout_log` VALUES("223", "Request for file /ajax.googleapis.com which doesn\'t exist", "121.239.199.21", "1606515770", "404_error", "Apache-HttpClient/4.2.5 (java 1.5)", "1", "/ajax.googleapis.com");
INSERT INTO `wp_defender_lockout_log` VALUES("224", "Request for file /ssl.google-analytics.com which doesn\'t exist", "121.239.199.21", "1606515774", "404_error", "Apache-HttpClient/4.2.5 (java 1.5)", "1", "/ssl.google-analytics.com");
INSERT INTO `wp_defender_lockout_log` VALUES("225", "Request for file /wp-content/plugins/ioptimization/IOptimize.php?rchk which doesn\'t exist", "52.177.121.220", "1606517193", "404_error", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1", "/wp-content/plugins/ioptimization/IOptimize.php?rchk");
INSERT INTO `wp_defender_lockout_log` VALUES("226", "Request for file /1689/login.php which doesn\'t exist", "47.99.196.234", "1606517918", "404_error", NULL, "1", "/1689/login.php");
INSERT INTO `wp_defender_lockout_log` VALUES("227", "Request for file /dede/login.php which doesn\'t exist", "47.99.196.234", "1606517918", "404_error", NULL, "1", "/dede/login.php");
INSERT INTO `wp_defender_lockout_log` VALUES("228", "Request for file /only/login.php which doesn\'t exist", "47.99.196.234", "1606517918", "404_error", NULL, "1", "/only/login.php");
INSERT INTO `wp_defender_lockout_log` VALUES("229", "Request for file /manager/login.php which doesn\'t exist", "47.99.196.234", "1606517918", "404_error", NULL, "1", "/manager/login.php");
INSERT INTO `wp_defender_lockout_log` VALUES("230", "Request for file /xixi/login.php which doesn\'t exist", "47.99.196.234", "1606517918", "404_error", NULL, "1", "/xixi/login.php");
INSERT INTO `wp_defender_lockout_log` VALUES("231", "Request for file /dedea/login.php which doesn\'t exist", "47.99.196.234", "1606517918", "404_error", NULL, "1", "/dedea/login.php");
INSERT INTO `wp_defender_lockout_log` VALUES("232", "Request for file /cct/login.php which doesn\'t exist", "47.99.196.234", "1606517918", "404_error", NULL, "1", "/cct/login.php");
INSERT INTO `wp_defender_lockout_log` VALUES("233", "Request for file /cms/login.php which doesn\'t exist", "47.99.196.234", "1606517918", "404_error", NULL, "1", "/cms/login.php");
INSERT INTO `wp_defender_lockout_log` VALUES("234", "Request for file /htadmin/login.php which doesn\'t exist", "47.99.196.234", "1606517918", "404_error", NULL, "1", "/htadmin/login.php");
INSERT INTO `wp_defender_lockout_log` VALUES("235", "Request for file /dede123/login.php which doesn\'t exist", "47.99.196.234", "1606517918", "404_error", NULL, "1", "/dede123/login.php");
INSERT INTO `wp_defender_lockout_log` VALUES("236", "Request for file /manage/login.php which doesn\'t exist", "47.99.196.234", "1606517918", "404_error", NULL, "1", "/manage/login.php");
INSERT INTO `wp_defender_lockout_log` VALUES("237", "Request for file /seo/login.php which doesn\'t exist", "47.99.196.234", "1606517918", "404_error", NULL, "1", "/seo/login.php");
INSERT INTO `wp_defender_lockout_log` VALUES("238", "Request for file /houtai/login.php which doesn\'t exist", "47.99.196.234", "1606517918", "404_error", NULL, "1", "/houtai/login.php");
INSERT INTO `wp_defender_lockout_log` VALUES("239", "Request for file /chen/login.php which doesn\'t exist", "47.99.196.234", "1606517918", "404_error", NULL, "1", "/chen/login.php");
INSERT INTO `wp_defender_lockout_log` VALUES("240", "Request for file /tdcq/login.php which doesn\'t exist", "47.99.196.234", "1606517918", "404_error", NULL, "1", "/tdcq/login.php");
INSERT INTO `wp_defender_lockout_log` VALUES("241", "Request for file /jian/login.php which doesn\'t exist", "47.99.196.234", "1606517918", "404_error", NULL, "1", "/jian/login.php");
INSERT INTO `wp_defender_lockout_log` VALUES("242", "Request for file /888/login.php which doesn\'t exist", "47.99.196.234", "1606517918", "404_error", NULL, "1", "/888/login.php");
INSERT INTO `wp_defender_lockout_log` VALUES("243", "Request for file /cfwb/login.php which doesn\'t exist", "47.99.196.234", "1606517918", "404_error", NULL, "1", "/cfwb/login.php");
INSERT INTO `wp_defender_lockout_log` VALUES("244", "Request for file /shen/login.php which doesn\'t exist", "47.99.196.234", "1606517918", "404_error", NULL, "1", "/shen/login.php");
INSERT INTO `wp_defender_lockout_log` VALUES("245", "Request for file /qili_admin/login.php which doesn\'t exist", "47.99.196.234", "1606517918", "404_error", NULL, "1", "/qili_admin/login.php");
INSERT INTO `wp_defender_lockout_log` VALUES("246", "Request for file /admin001/login.php which doesn\'t exist", "47.99.196.234", "1606517918", "404_error", NULL, "1", "/admin001/login.php");
INSERT INTO `wp_defender_lockout_log` VALUES("247", "Request for file /admindede888/login.php which doesn\'t exist", "47.99.196.234", "1606517918", "404_error", NULL, "1", "/admindede888/login.php");
INSERT INTO `wp_defender_lockout_log` VALUES("248", "Request for file /cg/login.php which doesn\'t exist", "47.99.196.234", "1606517918", "404_error", NULL, "1", "/cg/login.php");
INSERT INTO `wp_defender_lockout_log` VALUES("249", "Request for file /dedecms/login.php which doesn\'t exist", "47.99.196.234", "1606517918", "404_error", NULL, "1", "/dedecms/login.php");
INSERT INTO `wp_defender_lockout_log` VALUES("250", "Request for file /facai/login.php which doesn\'t exist", "47.99.196.234", "1606517918", "404_error", NULL, "1", "/facai/login.php");
INSERT INTO `wp_defender_lockout_log` VALUES("251", "Request for file /DesktopModules/TelerikWebUI/RadEditorProvider/Telerik.Web.UI.DialogHandler.aspx which doesn\'t exist", "212.7.204.176", "1606527440", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/DesktopModules/TelerikWebUI/RadEditorProvider/Telerik.Web.UI.DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("252", "Request for file /Providers/HtmlEditorProviders/Telerik/Telerik.Web.UI.DialogHandler.aspx which doesn\'t exist", "212.7.204.176", "1606527441", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/Providers/HtmlEditorProviders/Telerik/Telerik.Web.UI.DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("253", "Request for file /DesktopModules/Admin/RadEditorProvider/DialogHandler.aspx which doesn\'t exist", "212.7.204.176", "1606527442", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/DesktopModules/Admin/RadEditorProvider/DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("254", "Request for file /DesktopModules/dnnWerk.RadEditorProvider/DialogHandler.aspx which doesn\'t exist", "212.7.204.176", "1606527443", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/DesktopModules/dnnWerk.RadEditorProvider/DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("255", "Request for file /common/admin/Jobs2/Telerik.Web.UI.DialogHandler.aspx which doesn\'t exist", "212.7.204.176", "1606527444", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/common/admin/Jobs2/Telerik.Web.UI.DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("256", "Request for file /Telerik.Web.UI.DialogHandler.aspx which doesn\'t exist", "212.7.204.176", "1606527445", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/Telerik.Web.UI.DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("257", "Request for file /Components/General/Admin/UserControl/Telerik.Web.UI.DialogHandler.aspx which doesn\'t exist", "212.7.204.176", "1606527446", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/Components/General/Admin/UserControl/Telerik.Web.UI.DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("258", "Request for file /_controls/responsive/Telerik.Web.UI.DialogHandler.aspx which doesn\'t exist", "212.7.204.176", "1606527448", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/_controls/responsive/Telerik.Web.UI.DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("259", "Request for file /common/admin/PhotoGallery2/Telerik.Web.UI.DialogHandler.aspx which doesn\'t exist", "212.7.204.176", "1606527449", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/common/admin/PhotoGallery2/Telerik.Web.UI.DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("260", "Request for file /dashboard/UserControl/CMS/Page/Telerik.Web.UI.DialogHandler.aspx which doesn\'t exist", "212.7.204.176", "1606527450", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/dashboard/UserControl/CMS/Page/Telerik.Web.UI.DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("261", "Request for file /cms/portlets/Telerik.Web.UI.DialogHandler.aspx which doesn\'t exist", "212.7.204.176", "1606527451", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/cms/portlets/Telerik.Web.UI.DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("262", "Request for file /common/admin/Calendar/Telerik.Web.UI.DialogHandler.aspx which doesn\'t exist", "212.7.204.176", "1606527452", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/common/admin/Calendar/Telerik.Web.UI.DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("263", "Request for file /AsiCommon/Controls/ContentManagement/ContentDesigner/Telerik.Web.UI.DialogHandler.aspx which doesn\'t exist", "212.7.204.176", "1606527453", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/AsiCommon/Controls/ContentManagement/ContentDesigner/Telerik.Web.UI.DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("264", "Request for file /DesktopModules/TNComments/Telerik.Web.UI.DialogHandler.aspx which doesn\'t exist", "212.7.204.176", "1606527455", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/DesktopModules/TNComments/Telerik.Web.UI.DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("265", "Request for file /Admin/ServerSide/Telerik.Web.UI.DialogHandler.aspx which doesn\'t exist", "212.7.204.176", "1606527456", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/Admin/ServerSide/Telerik.Web.UI.DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("266", "Request for file /Modules/CMS/Telerik.Web.UI.DialogHandler.aspx which doesn\'t exist", "212.7.204.176", "1606527457", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/Modules/CMS/Telerik.Web.UI.DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("267", "Request for file /DesktopModule/UIQuestionControls/UIAskQuestion/Telerik.Web.UI.DialogHandler.aspx which doesn\'t exist", "212.7.204.176", "1606527458", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/DesktopModule/UIQuestionControls/UIAskQuestion/Telerik.Web.UI.DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("268", "Request for file /DesktopModules/News/Telerik.Web.UI.DialogHandler.aspx which doesn\'t exist", "212.7.204.176", "1606527459", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/DesktopModules/News/Telerik.Web.UI.DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("269", "Request for file /DesktopModules/YA.Controls/AngularMain/Telerik.Web.UI.DialogHandler.aspx which doesn\'t exist", "212.7.204.176", "1606527460", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/DesktopModules/YA.Controls/AngularMain/Telerik.Web.UI.DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("270", "Request for file /DesktopModules/Base/EditControls/Telerik.Web.UI.DialogHandler.aspx which doesn\'t exist", "212.7.204.176", "1606527462", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/DesktopModules/Base/EditControls/Telerik.Web.UI.DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("271", "Lockout occurred:  Too many 404 requests for /DesktopModules/Base/EditControls/Telerik.Web.UI.DialogHandler.aspx", "212.7.204.176", "1606527462", "404_lockout", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/DesktopModules/Base/EditControls/Telerik.Web.UI.DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("272", "Request for file /reservations.html which doesn\'t exist", "114.119.145.233", "1606528388", "404_error", "Mozilla/5.0 (Linux; Android 7.0;) AppleWebKit/537.36 (KHTML, like Gecko) Mobile Safari/537.36 (compatible; PetalBot;+https://aspiegel.com/petalbot)", "1", "/reservations.html");
INSERT INTO `wp_defender_lockout_log` VALUES("273", "Request for file /admin/ which doesn\'t exist", "35.200.60.134", "1606529382", "404_error", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0", "1", "/admin/");
INSERT INTO `wp_defender_lockout_log` VALUES("274", "Request for file /admin/ which doesn\'t exist", "121.78.246.82", "1606531071", "404_error", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0", "1", "/admin/");
INSERT INTO `wp_defender_lockout_log` VALUES("275", "Request for file /white-mountains-nh-inn-suites-specials-and-packages which doesn\'t exist", "114.119.140.169", "1606532337", "404_error", "Mozilla/5.0 (Linux; Android 7.0;) AppleWebKit/537.36 (KHTML, like Gecko) Mobile Safari/537.36 (compatible; PetalBot;+https://aspiegel.com/petalbot)", "1", "/white-mountains-nh-inn-suites-specials-and-packages");
INSERT INTO `wp_defender_lockout_log` VALUES("276", "Request for file /wp-content/themes/DailyDeal/style.css which doesn\'t exist", "23.228.109.146", "1606534107", "404_error", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2896.3 Safari/537.36", "1", "/wp-content/themes/DailyDeal/style.css");
INSERT INTO `wp_defender_lockout_log` VALUES("277", "Failed login attempt with username admin", "122.179.40.219", "1606539252", "auth_fail", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.77 Safari/537.36", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("278", "Failed login attempt with username admin", "185.117.215.9", "1606541895", "auth_fail", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Ubuntu Chromium/69.0.3497.81 Chrome/69.0.3497.81 Safari/537.36", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("279", "Failed login attempt with username econolodgeloon", "107.189.10.27", "1606543657", "auth_fail", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.106 Safari/537.36", "1", "econolodgeloon");
INSERT INTO `wp_defender_lockout_log` VALUES("280", "Request for file /public/js/wind.js which doesn\'t exist", "39.98.242.185", "1606554326", "404_error", "Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; Win64; x64; Trident/5.0)", "1", "/public/js/wind.js");
INSERT INTO `wp_defender_lockout_log` VALUES("281", "Request for file /wordpress/wp-admin/ which doesn\'t exist", "162.144.18.17", "1606556949", "404_error", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36", "1", "/wordpress/wp-admin/");
INSERT INTO `wp_defender_lockout_log` VALUES("282", "Request for file /public/router.php which doesn\'t exist", "101.21.146.37", "1606558304", "404_error", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:48.0) Gecko/20100101 Firefox/48.0", "1", "/public/router.php");
INSERT INTO `wp_defender_lockout_log` VALUES("283", "Request for file /DesktopModules/TelerikWebUI/RadEditorProvider/Telerik.Web.UI.DialogHandler.aspx which doesn\'t exist", "212.7.204.176", "1606561041", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/DesktopModules/TelerikWebUI/RadEditorProvider/Telerik.Web.UI.DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("284", "Request for file /Providers/HtmlEditorProviders/Telerik/Telerik.Web.UI.DialogHandler.aspx which doesn\'t exist", "212.7.204.176", "1606561042", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/Providers/HtmlEditorProviders/Telerik/Telerik.Web.UI.DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("285", "Request for file /DesktopModules/Admin/RadEditorProvider/DialogHandler.aspx which doesn\'t exist", "212.7.204.176", "1606561043", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/DesktopModules/Admin/RadEditorProvider/DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("286", "Request for file /DesktopModules/dnnWerk.RadEditorProvider/DialogHandler.aspx which doesn\'t exist", "212.7.204.176", "1606561044", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/DesktopModules/dnnWerk.RadEditorProvider/DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("287", "Request for file /common/admin/Jobs2/Telerik.Web.UI.DialogHandler.aspx which doesn\'t exist", "212.7.204.176", "1606561046", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/common/admin/Jobs2/Telerik.Web.UI.DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("288", "Request for file /Telerik.Web.UI.DialogHandler.aspx which doesn\'t exist", "212.7.204.176", "1606561047", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/Telerik.Web.UI.DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("289", "Request for file /Components/General/Admin/UserControl/Telerik.Web.UI.DialogHandler.aspx which doesn\'t exist", "212.7.204.176", "1606561048", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/Components/General/Admin/UserControl/Telerik.Web.UI.DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("290", "Request for file /_controls/responsive/Telerik.Web.UI.DialogHandler.aspx which doesn\'t exist", "212.7.204.176", "1606561049", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/_controls/responsive/Telerik.Web.UI.DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("291", "Request for file /common/admin/PhotoGallery2/Telerik.Web.UI.DialogHandler.aspx which doesn\'t exist", "212.7.204.176", "1606561050", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/common/admin/PhotoGallery2/Telerik.Web.UI.DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("292", "Request for file /dashboard/UserControl/CMS/Page/Telerik.Web.UI.DialogHandler.aspx which doesn\'t exist", "212.7.204.176", "1606561051", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/dashboard/UserControl/CMS/Page/Telerik.Web.UI.DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("293", "Request for file /cms/portlets/Telerik.Web.UI.DialogHandler.aspx which doesn\'t exist", "212.7.204.176", "1606561053", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/cms/portlets/Telerik.Web.UI.DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("294", "Request for file /common/admin/Calendar/Telerik.Web.UI.DialogHandler.aspx which doesn\'t exist", "212.7.204.176", "1606561054", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/common/admin/Calendar/Telerik.Web.UI.DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("295", "Request for file /AsiCommon/Controls/ContentManagement/ContentDesigner/Telerik.Web.UI.DialogHandler.aspx which doesn\'t exist", "212.7.204.176", "1606561055", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/AsiCommon/Controls/ContentManagement/ContentDesigner/Telerik.Web.UI.DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("296", "Request for file /DesktopModules/TNComments/Telerik.Web.UI.DialogHandler.aspx which doesn\'t exist", "212.7.204.176", "1606561056", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/DesktopModules/TNComments/Telerik.Web.UI.DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("297", "Request for file /Admin/ServerSide/Telerik.Web.UI.DialogHandler.aspx which doesn\'t exist", "212.7.204.176", "1606561057", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/Admin/ServerSide/Telerik.Web.UI.DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("298", "Request for file /Modules/CMS/Telerik.Web.UI.DialogHandler.aspx which doesn\'t exist", "212.7.204.176", "1606561058", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/Modules/CMS/Telerik.Web.UI.DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("299", "Request for file /DesktopModule/UIQuestionControls/UIAskQuestion/Telerik.Web.UI.DialogHandler.aspx which doesn\'t exist", "212.7.204.176", "1606561060", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/DesktopModule/UIQuestionControls/UIAskQuestion/Telerik.Web.UI.DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("300", "Request for file /DesktopModules/News/Telerik.Web.UI.DialogHandler.aspx which doesn\'t exist", "212.7.204.176", "1606561061", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/DesktopModules/News/Telerik.Web.UI.DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("301", "Request for file /DesktopModules/YA.Controls/AngularMain/Telerik.Web.UI.DialogHandler.aspx which doesn\'t exist", "212.7.204.176", "1606561062", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/DesktopModules/YA.Controls/AngularMain/Telerik.Web.UI.DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("302", "Request for file /DesktopModules/Base/EditControls/Telerik.Web.UI.DialogHandler.aspx which doesn\'t exist", "212.7.204.176", "1606561063", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/DesktopModules/Base/EditControls/Telerik.Web.UI.DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("303", "Lockout occurred:  Too many 404 requests for /DesktopModules/Base/EditControls/Telerik.Web.UI.DialogHandler.aspx", "212.7.204.176", "1606561063", "404_lockout", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1", "/DesktopModules/Base/EditControls/Telerik.Web.UI.DialogHandler.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("304", "Request for file /installer.php which doesn\'t exist", "78.85.194.229", "1606566139", "404_error", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36", "1", "/installer.php");
INSERT INTO `wp_defender_lockout_log` VALUES("305", "Request for file /data/admin/allowurl.txt which doesn\'t exist", "39.98.74.86", "1606567907", "404_error", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:48.0) Gecko/20100101 Firefox/48.0", "1", "/data/admin/allowurl.txt");
INSERT INTO `wp_defender_lockout_log` VALUES("306", "Failed login attempt with username admin", "154.121.58.162", "1606569638", "auth_fail", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.0.2 Safari/605.1.15", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("307", "Request for file /wp-includes/css/modules.php which doesn\'t exist", "198.50.243.165", "1606571604", "404_error", "python-requests/2.23.0", "1", "/wp-includes/css/modules.php");
INSERT INTO `wp_defender_lockout_log` VALUES("308", "Request for file /shell.php which doesn\'t exist", "198.50.243.165", "1606571607", "404_error", "python-requests/2.23.0", "1", "/shell.php");
INSERT INTO `wp_defender_lockout_log` VALUES("309", "Request for file /wso.php which doesn\'t exist", "198.50.243.165", "1606571609", "404_error", "python-requests/2.23.0", "1", "/wso.php");
INSERT INTO `wp_defender_lockout_log` VALUES("310", "Request for file /up.php which doesn\'t exist", "198.50.243.165", "1606571611", "404_error", "python-requests/2.23.0", "1", "/up.php");
INSERT INTO `wp_defender_lockout_log` VALUES("311", "Request for file /upload.php which doesn\'t exist", "198.50.243.165", "1606571612", "404_error", "python-requests/2.23.0", "1", "/upload.php");
INSERT INTO `wp_defender_lockout_log` VALUES("312", "Request for file /wp-content/uploads/2020/11/ which doesn\'t exist", "198.50.243.165", "1606571615", "404_error", "python-requests/2.23.0", "1", "/wp-content/uploads/2020/11/");
INSERT INTO `wp_defender_lockout_log` VALUES("313", "Request for file /wp-includes/users.php which doesn\'t exist", "198.50.243.165", "1606571619", "404_error", "python-requests/2.23.0", "1", "/wp-includes/users.php");
INSERT INTO `wp_defender_lockout_log` VALUES("314", "Request for file /wp-content/plugins/upspy/ which doesn\'t exist", "198.50.243.165", "1606571623", "404_error", "python-requests/2.23.0", "1", "/wp-content/plugins/upspy/");
INSERT INTO `wp_defender_lockout_log` VALUES("315", "Request for file /wp-content/plugins/ubh/ which doesn\'t exist", "198.50.243.165", "1606571626", "404_error", "python-requests/2.23.0", "1", "/wp-content/plugins/ubh/");
INSERT INTO `wp_defender_lockout_log` VALUES("316", "Request for file /wp-content/plugins/vwcleanerplugin/bump.php?cache which doesn\'t exist", "198.50.243.165", "1606571628", "404_error", "python-requests/2.23.0", "1", "/wp-content/plugins/vwcleanerplugin/bump.php?cache");
INSERT INTO `wp_defender_lockout_log` VALUES("317", "Request for file /wp-content/plugins/three-column-screen-layout/firewall.php which doesn\'t exist", "198.50.243.165", "1606571631", "404_error", "python-requests/2.23.0", "1", "/wp-content/plugins/three-column-screen-layout/firewall.php");
INSERT INTO `wp_defender_lockout_log` VALUES("318", "Request for file /wp-content/plugins/html404/index.html which doesn\'t exist", "198.50.243.165", "1606571633", "404_error", "python-requests/2.23.0", "1", "/wp-content/plugins/html404/index.html");
INSERT INTO `wp_defender_lockout_log` VALUES("319", "Request for file /olux.php which doesn\'t exist", "198.50.243.165", "1606571639", "404_error", "python-requests/2.23.0", "1", "/olux.php");
INSERT INTO `wp_defender_lockout_log` VALUES("320", "Request for file /indoxploit.php which doesn\'t exist", "198.50.243.165", "1606571643", "404_error", "python-requests/2.23.0", "1", "/indoxploit.php");
INSERT INTO `wp_defender_lockout_log` VALUES("321", "Request for file /wp-info.php which doesn\'t exist", "198.50.243.165", "1606571648", "404_error", "python-requests/2.23.0", "1", "/wp-info.php");
INSERT INTO `wp_defender_lockout_log` VALUES("322", "Request for file /wp-content/vuln.php which doesn\'t exist", "198.50.243.165", "1606571650", "404_error", "python-requests/2.23.0", "1", "/wp-content/vuln.php");
INSERT INTO `wp_defender_lockout_log` VALUES("323", "Request for file /cloudxv3.php which doesn\'t exist", "198.50.243.165", "1606571652", "404_error", "python-requests/2.23.0", "1", "/cloudxv3.php");
INSERT INTO `wp_defender_lockout_log` VALUES("324", "Request for file /wp-content/themes/gaukingo/db.php which doesn\'t exist", "198.50.243.165", "1606571654", "404_error", "python-requests/2.23.0", "1", "/wp-content/themes/gaukingo/db.php");
INSERT INTO `wp_defender_lockout_log` VALUES("325", "Request for file /wp-content/plugins/three-column-screen-layout/db.php which doesn\'t exist", "198.50.243.165", "1606571655", "404_error", "python-requests/2.23.0", "1", "/wp-content/plugins/three-column-screen-layout/db.php");
INSERT INTO `wp_defender_lockout_log` VALUES("326", "Request for file /wp-content/plugins/wp-db-ajax-made/wp-ajax.php which doesn\'t exist", "198.50.243.165", "1606571657", "404_error", "python-requests/2.23.0", "1", "/wp-content/plugins/wp-db-ajax-made/wp-ajax.php");
INSERT INTO `wp_defender_lockout_log` VALUES("327", "Lockout occurred:  Too many 404 requests for /wp-content/plugins/wp-db-ajax-made/wp-ajax.php", "198.50.243.165", "1606571657", "404_lockout", "python-requests/2.23.0", "1", "/wp-content/plugins/wp-db-ajax-made/wp-ajax.php");
INSERT INTO `wp_defender_lockout_log` VALUES("328", "Request for file /public/router.php which doesn\'t exist", "39.98.242.185", "1606581046", "404_error", NULL, "1", "/public/router.php");
INSERT INTO `wp_defender_lockout_log` VALUES("329", "Request for file /fonts.googleapis.com which doesn\'t exist", "121.239.199.21", "1606582770", "404_error", "Apache-HttpClient/4.2.5 (java 1.5)", "1", "/fonts.googleapis.com");
INSERT INTO `wp_defender_lockout_log` VALUES("330", "Request for file /s.gravatar.com which doesn\'t exist", "121.239.199.21", "1606582780", "404_error", "Apache-HttpClient/4.2.5 (java 1.5)", "1", "/s.gravatar.com");
INSERT INTO `wp_defender_lockout_log` VALUES("331", "Request for file /fonts.gstatic.com which doesn\'t exist", "121.239.199.21", "1606582797", "404_error", "Apache-HttpClient/4.2.5 (java 1.5)", "1", "/fonts.gstatic.com");
INSERT INTO `wp_defender_lockout_log` VALUES("332", "Request for file /youtube.com which doesn\'t exist", "121.239.199.21", "1606582801", "404_error", "Apache-HttpClient/4.2.5 (java 1.5)", "1", "/youtube.com");
INSERT INTO `wp_defender_lockout_log` VALUES("333", "Request for file /google-analytics.com which doesn\'t exist", "121.239.199.21", "1606582806", "404_error", "Apache-HttpClient/4.2.5 (java 1.5)", "1", "/google-analytics.com");
INSERT INTO `wp_defender_lockout_log` VALUES("334", "Request for file /cache.php which doesn\'t exist", "193.106.30.100", "1606590359", "404_error", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.157 Safari/537.36", "1", "/cache.php");
INSERT INTO `wp_defender_lockout_log` VALUES("335", "Request for file /data/admin/allowurl.txt which doesn\'t exist", "39.99.54.47", "1606592360", "404_error", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:48.0) Gecko/20100101 Firefox/48.0", "1", "/data/admin/allowurl.txt");
INSERT INTO `wp_defender_lockout_log` VALUES("336", "Request for file /snowmobile.html which doesn\'t exist", "76.28.19.164", "1606598163", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/14.0.1 Safari/605.1.15", "1", "/snowmobile.html");
INSERT INTO `wp_defender_lockout_log` VALUES("337", "Request for file /wp/wp-content/uploads/subscribe-animated-gif-150.gif which doesn\'t exist", "76.28.19.164", "1606598164", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/14.0.1 Safari/605.1.15", "1", "/wp/wp-content/uploads/subscribe-animated-gif-150.gif");
INSERT INTO `wp_defender_lockout_log` VALUES("338", "Failed login attempt with username admin", "119.161.99.187", "1606599573", "auth_fail", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.110 Safari/537.36", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("339", "Request for file /index.asp../1.php which doesn\'t exist", "101.132.129.91", "1606614767", "404_error", "Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; Win64; x64; Trident/5.0)", "1", "/index.asp../1.php");
INSERT INTO `wp_defender_lockout_log` VALUES("340", "Request for file /wp-content/plugins/advanced_file_manager_5/php/connector.minimal.php which doesn\'t exist", "23.228.109.146", "1606616924", "404_error", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2896.3 Safari/537.36", "1", "/wp-content/plugins/advanced_file_manager_5/php/connector.minimal.php");
INSERT INTO `wp_defender_lockout_log` VALUES("341", "Failed login attempt with username admin", "171.96.155.84", "1606618378", "auth_fail", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.0.2 Safari/605.1.15", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("342", "Request for file /ads.txt which doesn\'t exist", "50.116.208.160", "1606624221", "404_error", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2228.0 Safari/537.36", "1", "/ads.txt");
INSERT INTO `wp_defender_lockout_log` VALUES("343", "Request for file /ads.txt which doesn\'t exist", "50.116.208.160", "1606624237", "404_error", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2228.0 Safari/537.36", "1", "/ads.txt");
INSERT INTO `wp_defender_lockout_log` VALUES("344", "Request for file /wp-includes/LICENSE.php which doesn\'t exist", "193.106.30.100", "1606633117", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.14; rv:68.0) Gecko/20100101 Firefox/68.0", "1", "/wp-includes/LICENSE.php");
INSERT INTO `wp_defender_lockout_log` VALUES("345", "Request for file /700px/housebackroom.jpg which doesn\'t exist", "114.119.140.238", "1606642993", "404_error", "Mozilla/5.0 (Linux; Android 7.0;) AppleWebKit/537.36 (KHTML, like Gecko) Mobile Safari/537.36 (compatible; PetalBot;+https://aspiegel.com/petalbot)", "1", "/700px/housebackroom.jpg");
INSERT INTO `wp_defender_lockout_log` VALUES("346", "Request for file /Package/polarexpress.jpg which doesn\'t exist", "114.119.142.43", "1606643527", "404_error", "Mozilla/5.0 (Linux; Android 7.0;) AppleWebKit/537.36 (KHTML, like Gecko) Mobile Safari/537.36 (compatible; PetalBot;+https://aspiegel.com/petalbot)", "1", "/Package/polarexpress.jpg");
INSERT INTO `wp_defender_lockout_log` VALUES("347", "Request for file /installer-backup.php which doesn\'t exist", "88.80.35.61", "1606649473", "404_error", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36", "1", "/installer-backup.php");
INSERT INTO `wp_defender_lockout_log` VALUES("348", "Request for file /wp-content/plugins/akismet/akismet.php which doesn\'t exist", "193.106.30.100", "1606650483", "404_error", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:67.0) Gecko/20100101 Firefox/67.0", "1", "/wp-content/plugins/akismet/akismet.php");
INSERT INTO `wp_defender_lockout_log` VALUES("349", "Failed login attempt with username admin", "14.241.233.22", "1606650856", "auth_fail", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.0.2 Safari/605.1.15", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("350", "Request for file /template/default/common/common.css which doesn\'t exist", "120.78.180.36", "1606655927", "404_error", "Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; Win64; x64; Trident/5.0)", "1", "/template/default/common/common.css");
INSERT INTO `wp_defender_lockout_log` VALUES("351", "Request for file /wp/yarmouth-ma-cape-cod-motel-virtual-tour/ which doesn\'t exist", "66.160.140.184", "1606658453", "404_error", "The Knowledge AI", "1", "/wp/yarmouth-ma-cape-cod-motel-virtual-tour/");
INSERT INTO `wp_defender_lockout_log` VALUES("352", "Request for file /wp-content/plugins/wp-file-manager/readme.txt which doesn\'t exist", "93.90.193.51", "1606660484", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.14; rv:79.0) Gecko/20100101 Firefox/79.0", "1", "/wp-content/plugins/wp-file-manager/readme.txt");
INSERT INTO `wp_defender_lockout_log` VALUES("353", "Request for file /white-mountains-nh-inn-suites-specials-and-packages/ which doesn\'t exist", "114.119.133.224", "1606664179", "404_error", "Mozilla/5.0 (Linux; Android 7.0;) AppleWebKit/537.36 (KHTML, like Gecko) Mobile Safari/537.36 (compatible; PetalBot;+https://aspiegel.com/petalbot)", "1", "/white-mountains-nh-inn-suites-specials-and-packages/");
INSERT INTO `wp_defender_lockout_log` VALUES("354", "Request for file /snowmobile.html which doesn\'t exist", "34.100.66.178", "1606664538", "404_error", "Mozilla/5.0 (X11; Linux i686; rv:68.0) Gecko/20100101 Firefox/68.0", "1", "/snowmobile.html");
INSERT INTO `wp_defender_lockout_log` VALUES("355", "Request for file /wp/wp-content/uploads/subscribe-animated-gif-150.gif which doesn\'t exist", "34.100.66.178", "1606664552", "404_error", "Mozilla/5.0 (X11; Linux i686; rv:68.0) Gecko/20100101 Firefox/68.0", "1", "/wp/wp-content/uploads/subscribe-animated-gif-150.gif");
INSERT INTO `wp_defender_lockout_log` VALUES("356", "Failed login attempt with username admin", "69.160.2.215", "1606668310", "auth_fail", "Opera/9.80 (Windows NT 6.1) Presto/2.12.388 Version/12.12", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("357", "Failed login attempt with username admin", "69.160.2.215", "1606668310", "auth_fail", "Opera/9.80 (Windows NT 6.1) Presto/2.12.388 Version/12.12", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("358", "Request for file /snowmobile.html which doesn\'t exist", "205.169.39.217", "1606670426", "404_error", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.61 Safari/537.36", "1", "/snowmobile.html");
INSERT INTO `wp_defender_lockout_log` VALUES("359", "Request for file /.env which doesn\'t exist", "51.89.204.20", "1606673954", "404_error", "python-requests/2.25.0", "1", "/.env");
INSERT INTO `wp_defender_lockout_log` VALUES("360", "Request for file /cache.php which doesn\'t exist", "193.106.30.100", "1606681282", "404_error", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36", "1", "/cache.php");
INSERT INTO `wp_defender_lockout_log` VALUES("361", "Request for file /wp-content/plugins/augmented-reality/css/ar_front.css which doesn\'t exist", "95.215.55.110", "1606685857", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2748.63 Safari/537.36", "1", "/wp-content/plugins/augmented-reality/css/ar_front.css");
INSERT INTO `wp_defender_lockout_log` VALUES("362", "Request for file /wp-includes/css/css.php which doesn\'t exist", "93.90.193.51", "1606689348", "404_error", "python-requests/2.25.0", "1", "/wp-includes/css/css.php");
INSERT INTO `wp_defender_lockout_log` VALUES("363", "Request for file /wp-includes/fonts/css.php which doesn\'t exist", "93.90.193.51", "1606689361", "404_error", "python-requests/2.25.0", "1", "/wp-includes/fonts/css.php");
INSERT INTO `wp_defender_lockout_log` VALUES("364", "Request for file /adminer.php which doesn\'t exist", "204.93.157.55", "1606690005", "404_error", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0", "1", "/adminer.php");
INSERT INTO `wp_defender_lockout_log` VALUES("365", "Request for file /snowmobile.html which doesn\'t exist", "71.174.117.232", "1606699647", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/14.0.1 Safari/605.1.15", "1", "/snowmobile.html");
INSERT INTO `wp_defender_lockout_log` VALUES("366", "Request for file /wp/wp-content/uploads/subscribe-animated-gif-150.gif which doesn\'t exist", "71.174.117.232", "1606699648", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/14.0.1 Safari/605.1.15", "1", "/wp/wp-content/uploads/subscribe-animated-gif-150.gif");
INSERT INTO `wp_defender_lockout_log` VALUES("367", "Request for file /snowmobile.html which doesn\'t exist", "73.61.19.30", "1606701061", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.3 Safari/605.1.15", "1", "/snowmobile.html");
INSERT INTO `wp_defender_lockout_log` VALUES("368", "Request for file /wp/wp-content/uploads/subscribe-animated-gif-150.gif which doesn\'t exist", "73.61.19.30", "1606701062", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.3 Safari/605.1.15", "1", "/wp/wp-content/uploads/subscribe-animated-gif-150.gif");
INSERT INTO `wp_defender_lockout_log` VALUES("369", "Failed login attempt with username admin", "110.136.219.180", "1606702650", "auth_fail", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.0.2 Safari/605.1.15", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("370", "Request for file /wp-content/plugins/wp-file-manager/lib/php/connector.minimal.php which doesn\'t exist", "23.228.109.146", "1606703751", "404_error", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2896.3 Safari/537.36", "1", "/wp-content/plugins/wp-file-manager/lib/php/connector.minimal.php");
INSERT INTO `wp_defender_lockout_log` VALUES("371", "Request for file /e/data/js/ajax.js which doesn\'t exist", "47.92.241.24", "1606705486", "404_error", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:48.0) Gecko/20100101 Firefox/48.0", "1", "/e/data/js/ajax.js");
INSERT INTO `wp_defender_lockout_log` VALUES("372", "Failed login attempt with username admin", "199.249.230.147", "1606708621", "auth_fail", "Mozilla/5.0 (Windows NT 6.3; Win64; x64; rv:61.0) Gecko/20100101 Firefox/61.0", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("373", "Failed login attempt with username econolodgeloon", "104.244.72.239", "1606710253", "auth_fail", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36", "1", "econolodgeloon");
INSERT INTO `wp_defender_lockout_log` VALUES("374", "Request for file /old/wp-admin/ which doesn\'t exist", "149.129.75.209", "1606711680", "404_error", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36", "1", "/old/wp-admin/");
INSERT INTO `wp_defender_lockout_log` VALUES("375", "Request for file /js/common.js which doesn\'t exist", "39.98.242.185", "1606720735", "404_error", "Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; Win64; x64; Trident/5.0)", "1", "/js/common.js");
INSERT INTO `wp_defender_lockout_log` VALUES("376", "Failed login attempt with username admin", "14.191.160.141", "1606723375", "auth_fail", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.77 Safari/537.36", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("377", "Failed login attempt with username NoneNone", "162.213.255.44", "1606732585", "auth_fail", "Mozilla/5.0 (Android 8.0.0; Mobile; rv:68.0) Gecko/68.0 Firefox/68.0 wp-android/16.1", "1", "NoneNone");
INSERT INTO `wp_defender_lockout_log` VALUES("378", "Request for file /https:/www.econolodgeloon.com/white-mountains-nh-lincoln-loon-motel-contact-information/ which doesn\'t exist", "112.133.232.14", "1606734286", "404_error", NULL, "1", "/https:/www.econolodgeloon.com/white-mountains-nh-lincoln-loon-motel-contact-information/");
INSERT INTO `wp_defender_lockout_log` VALUES("379", "Request for file /wp-includes/css/css.php which doesn\'t exist", "52.177.121.220", "1606735454", "404_error", "python-requests/2.24.0", "1", "/wp-includes/css/css.php");
INSERT INTO `wp_defender_lockout_log` VALUES("380", "Request for file /wordpress/wp-admin/install.php?step=1 which doesn\'t exist", "116.202.100.112", "1606735460", "404_error", "Mozilla/5.0 (X11; Linux x86_64; rv:52.0) Gecko/20100101 Firefox/52.0", "1", "/wordpress/wp-admin/install.php?step=1");
INSERT INTO `wp_defender_lockout_log` VALUES("381", "Request for file /wp-includes/fonts/css.php which doesn\'t exist", "52.177.121.220", "1606735461", "404_error", "python-requests/2.24.0", "1", "/wp-includes/fonts/css.php");
INSERT INTO `wp_defender_lockout_log` VALUES("382", "Request for file /old/wp-admin/install.php?step=1 which doesn\'t exist", "116.202.100.112", "1606735462", "404_error", "Mozilla/5.0 (X11; Linux x86_64; rv:52.0) Gecko/20100101 Firefox/52.0", "1", "/old/wp-admin/install.php?step=1");
INSERT INTO `wp_defender_lockout_log` VALUES("383", "Request for file /snowmobile.html which doesn\'t exist", "172.56.23.252", "1606738980", "404_error", "Mozilla/5.0 (iPhone; CPU iPhone OS 13_7 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.2 Mobile/15E148 Safari/604.1", "1", "/snowmobile.html");
INSERT INTO `wp_defender_lockout_log` VALUES("384", "Request for file /wp/wp-content/uploads/subscribe-animated-gif-150.gif which doesn\'t exist", "172.56.23.252", "1606738981", "404_error", "Mozilla/5.0 (iPhone; CPU iPhone OS 13_7 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.2 Mobile/15E148 Safari/604.1", "1", "/wp/wp-content/uploads/subscribe-animated-gif-150.gif");
INSERT INTO `wp_defender_lockout_log` VALUES("385", "Request for file /https:/www.econolodgeloon.com/white-mountains-nh-lincoln-loon-motel-contact-information/ which doesn\'t exist", "112.133.232.14", "1606739669", "404_error", NULL, "1", "/https:/www.econolodgeloon.com/white-mountains-nh-lincoln-loon-motel-contact-information/");
INSERT INTO `wp_defender_lockout_log` VALUES("386", "Failed login attempt with username admin", "223.205.229.27", "1606750276", "auth_fail", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.110 Safari/537.36", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("387", "Failed login attempt with username admin", "45.40.166.167", "1606759397", "auth_fail", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("388", "Failed login attempt with username econolodgeloon", "45.40.166.167", "1606759397", "auth_fail", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36", "1", "econolodgeloon");
INSERT INTO `wp_defender_lockout_log` VALUES("389", "Failed login attempt with username admin", "50.63.196.157", "1606759550", "auth_fail", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("390", "Failed login attempt with username econolodgeloon", "50.63.196.157", "1606759550", "auth_fail", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36", "1", "econolodgeloon");
INSERT INTO `wp_defender_lockout_log` VALUES("391", "Failed login attempt with username econolodgeloon", "160.153.147.135", "1606759888", "auth_fail", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36", "1", "econolodgeloon");
INSERT INTO `wp_defender_lockout_log` VALUES("392", "Failed login attempt with username econolodgeloon", "160.153.147.135", "1606759888", "auth_fail", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36", "1", "econolodgeloon");
INSERT INTO `wp_defender_lockout_log` VALUES("393", "Failed login attempt with username econolodgeloon", "151.1.181.79", "1606759986", "auth_fail", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36", "1", "econolodgeloon");
INSERT INTO `wp_defender_lockout_log` VALUES("394", "Failed login attempt with username admin", "151.1.181.79", "1606759987", "auth_fail", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("395", "Failed login attempt with username admin", "192.254.75.166", "1606759997", "auth_fail", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("396", "Failed login attempt with username admin", "192.254.75.166", "1606759997", "auth_fail", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("397", "Failed login attempt with username econolodgeloon", "50.63.194.57", "1606760049", "auth_fail", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36", "1", "econolodgeloon");
INSERT INTO `wp_defender_lockout_log` VALUES("398", "Failed login attempt with username admin", "50.63.194.57", "1606760049", "auth_fail", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("399", "Request for file /ads.txt which doesn\'t exist", "54.162.102.36", "1606763744", "404_error", "MixnodeCache/1.8(+https://cache.mixnode.com/)", "1", "/ads.txt");
INSERT INTO `wp_defender_lockout_log` VALUES("400", "Request for file /#website which doesn\'t exist", "108.86.179.233", "1606768888", "404_error", "Mozilla/4.0 (compatible; Win32; WinHttp.WinHttpRequest.5)", "1", "/#website");
INSERT INTO `wp_defender_lockout_log` VALUES("401", "Request for file /#webpage which doesn\'t exist", "108.86.179.233", "1606768890", "404_error", "Mozilla/4.0 (compatible; Win32; WinHttp.WinHttpRequest.5)", "1", "/#webpage");
INSERT INTO `wp_defender_lockout_log` VALUES("402", "Request for file /snowmobile.html which doesn\'t exist", "114.119.158.58", "1606771135", "404_error", "Mozilla/5.0 (Linux; Android 7.0;) AppleWebKit/537.36 (KHTML, like Gecko) Mobile Safari/537.36 (compatible; PetalBot;+https://aspiegel.com/petalbot)", "1", "/snowmobile.html");
INSERT INTO `wp_defender_lockout_log` VALUES("403", "Request for file /wp-includes/css/css.php which doesn\'t exist", "104.214.79.46", "1606771673", "404_error", "python-requests/2.24.0", "1", "/wp-includes/css/css.php");
INSERT INTO `wp_defender_lockout_log` VALUES("404", "Request for file /wp-includes/fonts/css.php which doesn\'t exist", "104.214.79.46", "1606771707", "404_error", "python-requests/2.24.0", "1", "/wp-includes/fonts/css.php");
INSERT INTO `wp_defender_lockout_log` VALUES("405", "Failed login attempt with username admin", "179.52.254.207", "1606776498", "auth_fail", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.110 Safari/537.36", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("406", "Request for file /cli/garbagecron.php which doesn\'t exist", "193.106.30.100", "1606780062", "404_error", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36", "1", "/cli/garbagecron.php");
INSERT INTO `wp_defender_lockout_log` VALUES("407", "Failed login attempt with username NoneNone", "31.170.166.110", "1606781328", "auth_fail", "Mozilla/5.0 (Linux; Android 8.0.0; FIG-LX3 Build/HUAWEIFIG-LX3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Mobile Safari/537.36 wp-android/16.1", "1", "NoneNone");
INSERT INTO `wp_defender_lockout_log` VALUES("408", "Request for file /components/com_acym/index.html which doesn\'t exist", "23.228.109.146", "1606790344", "404_error", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2896.3 Safari/537.36", "1", "/components/com_acym/index.html");
INSERT INTO `wp_defender_lockout_log` VALUES("409", "Request for file /snowmobile.html which doesn\'t exist", "73.108.233.123", "1606791519", "404_error", "Mozilla/5.0 (iPhone; CPU iPhone OS 13_7 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.2 Mobile/15E148 Safari/604.1", "1", "/snowmobile.html");
INSERT INTO `wp_defender_lockout_log` VALUES("410", "Failed login attempt with username admin", "14.232.70.50", "1606792747", "auth_fail", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.0.2 Safari/605.1.15", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("411", "Failed login attempt with username admin", "14.232.70.50", "1606792747", "auth_fail", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.0.2 Safari/605.1.15", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("412", "Request for file /contact which doesn\'t exist", "108.161.129.83", "1606794530", "404_error", "Embarcadero URI Client/1.0", "1", "/contact");
INSERT INTO `wp_defender_lockout_log` VALUES("413", "Request for file /wp-includes/css/css.php which doesn\'t exist", "104.214.79.46", "1606795582", "404_error", "python-requests/2.24.0", "1", "/wp-includes/css/css.php");
INSERT INTO `wp_defender_lockout_log` VALUES("414", "Request for file /wp-includes/fonts/css.php which doesn\'t exist", "104.214.79.46", "1606795596", "404_error", "python-requests/2.24.0", "1", "/wp-includes/fonts/css.php");
INSERT INTO `wp_defender_lockout_log` VALUES("415", "Request for file /wp-content/plugins/wp-engine-module/king.php which doesn\'t exist", "51.89.204.170", "1606796897", "404_error", "python-requests/2.24.0", "1", "/wp-content/plugins/wp-engine-module/king.php");
INSERT INTO `wp_defender_lockout_log` VALUES("416", "Request for file /google-analytics.com which doesn\'t exist", "223.88.196.216", "1606816624", "404_error", "Apache-HttpClient/4.2.5 (java 1.5)", "1", "/google-analytics.com");
INSERT INTO `wp_defender_lockout_log` VALUES("417", "Failed login attempt with username NoneNone", "185.138.42.74", "1606822359", "auth_fail", "Mozilla/5.0 (Linux; Android 4.4.2; de-de; SAMSUNG GT-I9195 Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Version/1.5 Chrome/28.0.1500.94 Mobile Safari/537.36 wp-android/16.1", "1", "NoneNone");
INSERT INTO `wp_defender_lockout_log` VALUES("418", "Request for file /language/en-GB/en-GB.localise.php which doesn\'t exist", "193.106.30.100", "1606824844", "404_error", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:67.0) Gecko/20100101 Firefox/67.0", "1", "/language/en-GB/en-GB.localise.php");
INSERT INTO `wp_defender_lockout_log` VALUES("419", "Request for file /contact.html which doesn\'t exist", "192.227.209.212", "1606827048", "404_error", "Mozilla/5.0 (compatible; MSIE 8.0; Windows NT 5.1; WOW64; Trident/4.0)", "1", "/contact.html");
INSERT INTO `wp_defender_lockout_log` VALUES("420", "Request for file /installer.php which doesn\'t exist", "85.140.38.114", "1606827384", "404_error", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36", "1", "/installer.php");
INSERT INTO `wp_defender_lockout_log` VALUES("421", "Request for file /fonts.googleapis.com which doesn\'t exist", "121.239.199.21", "1606830045", "404_error", "Apache-HttpClient/4.2.5 (java 1.5)", "1", "/fonts.googleapis.com");
INSERT INTO `wp_defender_lockout_log` VALUES("422", "Request for file /s.gravatar.com which doesn\'t exist", "121.239.199.21", "1606830080", "404_error", "Apache-HttpClient/4.2.5 (java 1.5)", "1", "/s.gravatar.com");
INSERT INTO `wp_defender_lockout_log` VALUES("423", "Request for file /fonts.gstatic.com which doesn\'t exist", "121.239.199.21", "1606830084", "404_error", "Apache-HttpClient/4.2.5 (java 1.5)", "1", "/fonts.gstatic.com");
INSERT INTO `wp_defender_lockout_log` VALUES("424", "Request for file /youtube.com which doesn\'t exist", "121.239.199.21", "1606830087", "404_error", "Apache-HttpClient/4.2.5 (java 1.5)", "1", "/youtube.com");
INSERT INTO `wp_defender_lockout_log` VALUES("425", "Request for file /google-analytics.com which doesn\'t exist", "121.239.199.21", "1606830091", "404_error", "Apache-HttpClient/4.2.5 (java 1.5)", "1", "/google-analytics.com");
INSERT INTO `wp_defender_lockout_log` VALUES("426", "Failed login attempt with username admin", "42.201.184.63", "1606833345", "auth_fail", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.110 Safari/537.36", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("427", "Request for file /wp-admin/admin-uploads.php which doesn\'t exist", "5.188.62.147", "1606836598", "404_error", "Mozilla/5.0 (Windows NT 6.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2227.1 Safari/537.36", "1", "/wp-admin/admin-uploads.php");
INSERT INTO `wp_defender_lockout_log` VALUES("428", "Request for file /images/homeimage6.jpg which doesn\'t exist", "114.119.140.169", "1606844772", "404_error", "Mozilla/5.0 (Linux; Android 7.0;) AppleWebKit/537.36 (KHTML, like Gecko) Mobile Safari/537.36 (compatible; PetalBot;+https://aspiegel.com/petalbot)", "1", "/images/homeimage6.jpg");
INSERT INTO `wp_defender_lockout_log` VALUES("429", "Request for file /wordpress/wp-admin/setup-config.php?step=1 which doesn\'t exist", "88.198.242.184", "1606844923", "404_error", "Apache/2.4.34 (Ubuntu) OpenSSL/1.1.1 (internal dummy connection)", "1", "/wordpress/wp-admin/setup-config.php?step=1");
INSERT INTO `wp_defender_lockout_log` VALUES("430", "Failed login attempt with username admin", "89.144.12.17", "1606846171", "auth_fail", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:62.0) Gecko/20100101 Firefox/62.0", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("431", "Failed login attempt with username admin", "31.220.1.233", "1606847015", "auth_fail", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.92 Safari/537.36", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("432", "Failed login attempt with username NoneNone", "104.131.62.234", "1606855430", "auth_fail", "Mozilla/5.0 (Linux; Android 8.1.0; SM-J260T1 Build/M1AJQ) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Mobile Safari/537.36 wp-android/16.1", "1", "NoneNone");
INSERT INTO `wp_defender_lockout_log` VALUES("433", "Request for file /reservations.html which doesn\'t exist", "114.119.149.222", "1606862280", "404_error", "Mozilla/5.0 (Linux; Android 7.0;) AppleWebKit/537.36 (KHTML, like Gecko) Mobile Safari/537.36 (compatible; PetalBot;+https://aspiegel.com/petalbot)", "1", "/reservations.html");
INSERT INTO `wp_defender_lockout_log` VALUES("434", "Request for file /snowmobile.html which doesn\'t exist", "173.231.59.215", "1606868470", "404_error", "Mozilla/5.0 (compatible; Adsbot/3.1)", "1", "/snowmobile.html");
INSERT INTO `wp_defender_lockout_log` VALUES("435", "Request for file /app/lottery which doesn\'t exist", "218.86.22.178", "1606869566", "404_error", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36", "1", "/app/lottery");
INSERT INTO `wp_defender_lockout_log` VALUES("436", "Request for file /rooms.html which doesn\'t exist", "159.89.45.133", "1606869844", "404_error", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/63.0.3239.132 Safari/537.36 (compatible; PoliteCrawl.v2.0)", "1", "/rooms.html");
INSERT INTO `wp_defender_lockout_log` VALUES("437", "Failed login attempt with username admin", "113.172.150.149", "1606870359", "auth_fail", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.77 Safari/537.36", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("438", "Request for file /wp-content/plugins/apikey/apikey.php?test=hello which doesn\'t exist", "194.33.45.161", "1606871541", "404_error", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1", "/wp-content/plugins/apikey/apikey.php?test=hello");
INSERT INTO `wp_defender_lockout_log` VALUES("439", "Request for file /plugins/content/apismtp/apismtp.php?test=hello which doesn\'t exist", "194.33.45.161", "1606871560", "404_error", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1", "/plugins/content/apismtp/apismtp.php?test=hello");
INSERT INTO `wp_defender_lockout_log` VALUES("440", "Request for file /wp-content/plugins/apikey/apikey.php.suspected?test=hello which doesn\'t exist", "194.33.45.161", "1606871571", "404_error", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1", "/wp-content/plugins/apikey/apikey.php.suspected?test=hello");
INSERT INTO `wp_defender_lockout_log` VALUES("441", "Request for file /plugins/content/apismtp/apismtp.php.suspected?test=hello which doesn\'t exist", "194.33.45.161", "1606871580", "404_error", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1", "/plugins/content/apismtp/apismtp.php.suspected?test=hello");
INSERT INTO `wp_defender_lockout_log` VALUES("442", "Request for file /components/com_acym/acym.php which doesn\'t exist", "23.228.109.146", "1606879592", "404_error", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2896.3 Safari/537.36", "1", "/components/com_acym/acym.php");
INSERT INTO `wp_defender_lockout_log` VALUES("443", "Failed login attempt with username admin", "222.252.28.110", "1606882043", "auth_fail", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.0.2 Safari/605.1.15", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("444", "Request for file /wp-includes/css/css.php which doesn\'t exist", "52.177.121.220", "1606884638", "404_error", "python-requests/2.24.0", "1", "/wp-includes/css/css.php");
INSERT INTO `wp_defender_lockout_log` VALUES("445", "Request for file /wp-includes/fonts/css.php which doesn\'t exist", "52.177.121.220", "1606884658", "404_error", "python-requests/2.24.0", "1", "/wp-includes/fonts/css.php");
INSERT INTO `wp_defender_lockout_log` VALUES("446", "Request for file /4bedroomhouse.html which doesn\'t exist", "5.102.173.71", "1606888250", "404_error", "Mozilla/5.0 (compatible; MojeekBot/0.10; +https://www.mojeek.com/bot.html)", "1", "/4bedroomhouse.html");
INSERT INTO `wp_defender_lockout_log` VALUES("447", "Failed login attempt with username NoneNone", "141.136.41.119", "1606889364", "auth_fail", "Mozilla/5.0 (Linux; Android 7.0; SM-G610M Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Mobile Safari/537.36 wp-android/16.1", "1", "NoneNone");
INSERT INTO `wp_defender_lockout_log` VALUES("448", "Request for file /wp-includes/css/css.php which doesn\'t exist", "52.177.121.220", "1606891462", "404_error", "python-requests/2.24.0", "1", "/wp-includes/css/css.php");
INSERT INTO `wp_defender_lockout_log` VALUES("449", "Request for file /wp-includes/fonts/css.php which doesn\'t exist", "52.177.121.220", "1606891471", "404_error", "python-requests/2.24.0", "1", "/wp-includes/fonts/css.php");
INSERT INTO `wp_defender_lockout_log` VALUES("450", "Failed login attempt with username admin", "185.220.101.137", "1606892782", "auth_fail", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.106 Safari/537.36", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("451", "Failed login attempt with username econolodgeloon", "51.210.243.196", "1606895966", "auth_fail", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.99 Safari/537.36", "1", "econolodgeloon");
INSERT INTO `wp_defender_lockout_log` VALUES("452", "Request for file /wp-content/plugins/wp-engine-module/king.php which doesn\'t exist", "51.89.204.170", "1606902964", "404_error", "python-requests/2.24.0", "1", "/wp-content/plugins/wp-engine-module/king.php");
INSERT INTO `wp_defender_lockout_log` VALUES("453", "Request for file /wp-includes/css/css.php which doesn\'t exist", "52.177.121.220", "1606903107", "404_error", "python-requests/2.24.0", "1", "/wp-includes/css/css.php");
INSERT INTO `wp_defender_lockout_log` VALUES("454", "Request for file /wp-includes/fonts/css.php which doesn\'t exist", "52.177.121.220", "1606903139", "404_error", "python-requests/2.24.0", "1", "/wp-includes/fonts/css.php");
INSERT INTO `wp_defender_lockout_log` VALUES("455", "Request for file /installer-backup.php which doesn\'t exist", "78.85.165.131", "1606908726", "404_error", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36", "1", "/installer-backup.php");
INSERT INTO `wp_defender_lockout_log` VALUES("456", "Request for file /wp-content/plugins/ultimate-member/assets/js/um-modal.js which doesn\'t exist", "157.245.38.189", "1606910829", "404_error", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.125 Safari/537.36", "1", "/wp-content/plugins/ultimate-member/assets/js/um-modal.js");
INSERT INTO `wp_defender_lockout_log` VALUES("457", "Request for file /wp-content/plugins/ti-woocommerce-wishlist/assets/js/public.js which doesn\'t exist", "157.245.38.189", "1606910830", "404_error", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.125 Safari/537.36", "1", "/wp-content/plugins/ti-woocommerce-wishlist/assets/js/public.js");
INSERT INTO `wp_defender_lockout_log` VALUES("458", "Request for file /wp-content/plugins/ubh/up.php which doesn\'t exist", "88.198.242.184", "1606911889", "404_error", "Apache/2.4.34 (Ubuntu) OpenSSL/1.1.1 (internal dummy connection)", "1", "/wp-content/plugins/ubh/up.php");
INSERT INTO `wp_defender_lockout_log` VALUES("459", "Request for file /wp-content/uploads/frontoutsidewideview-150x150.jpg which doesn\'t exist", "114.119.140.238", "1606919216", "404_error", "Mozilla/5.0 (Linux; Android 7.0;) AppleWebKit/537.36 (KHTML, like Gecko) Mobile Safari/537.36 (compatible; PetalBot;+https://aspiegel.com/petalbot)", "1", "/wp-content/uploads/frontoutsidewideview-150x150.jpg");
INSERT INTO `wp_defender_lockout_log` VALUES("460", "Request for file /wp-includes/css/css.php which doesn\'t exist", "104.214.79.46", "1606919272", "404_error", "python-requests/2.24.0", "1", "/wp-includes/css/css.php");
INSERT INTO `wp_defender_lockout_log` VALUES("461", "Request for file /wp-includes/fonts/css.php which doesn\'t exist", "104.214.79.46", "1606919280", "404_error", "python-requests/2.24.0", "1", "/wp-includes/fonts/css.php");
INSERT INTO `wp_defender_lockout_log` VALUES("462", "Request for file /a which doesn\'t exist", "35.187.66.122", "1606920597", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:52.0) Gecko/20100101 Firefox/52.0", "1", "/a");
INSERT INTO `wp_defender_lockout_log` VALUES("463", "Request for file /a which doesn\'t exist", "35.187.66.122", "1606920600", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:52.0) Gecko/20100101 Firefox/52.0", "1", "/a");
INSERT INTO `wp_defender_lockout_log` VALUES("464", "Request for file /wp/yarmouth-ma-cape-cod-motel-virtual-tour/ which doesn\'t exist", "35.187.66.122", "1606920600", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:52.0) Gecko/20100101 Firefox/52.0", "1", "/wp/yarmouth-ma-cape-cod-motel-virtual-tour/");
INSERT INTO `wp_defender_lockout_log` VALUES("465", "Request for file /magento_version which doesn\'t exist", "35.187.66.122", "1606920614", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:52.0) Gecko/20100101 Firefox/52.0", "1", "/magento_version");
INSERT INTO `wp_defender_lockout_log` VALUES("466", "Request for file /util/login.aspx which doesn\'t exist", "35.187.66.122", "1606920614", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:52.0) Gecko/20100101 Firefox/52.0", "1", "/util/login.aspx");
INSERT INTO `wp_defender_lockout_log` VALUES("467", "Request for file /install.php which doesn\'t exist", "35.187.66.122", "1606920614", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:52.0) Gecko/20100101 Firefox/52.0", "1", "/install.php");
INSERT INTO `wp_defender_lockout_log` VALUES("468", "Request for file /installer-backup.php which doesn\'t exist", "160.153.154.1", "1606922609", "404_error", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.77 Safari/537.36", "1", "/installer-backup.php");
INSERT INTO `wp_defender_lockout_log` VALUES("469", "Request for file /installer.php which doesn\'t exist", "160.153.154.1", "1606922609", "404_error", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.77 Safari/537.36", "1", "/installer.php");
INSERT INTO `wp_defender_lockout_log` VALUES("470", "Failed login attempt with username admin", "177.85.177.2", "1606923682", "auth_fail", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.77 Safari/537.36", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("471", "Request for file /config.bak.php which doesn\'t exist", "40.117.233.252", "1606929511", "404_error", "python-requests/2.25.0", "1", "/config.bak.php");
INSERT INTO `wp_defender_lockout_log` VALUES("472", "Request for file /config.bak.php which doesn\'t exist", "40.117.233.252", "1606929521", "404_error", "python-requests/2.25.0", "1", "/config.bak.php");
INSERT INTO `wp_defender_lockout_log` VALUES("473", "Failed login attempt with username NoneNone", "161.97.85.189", "1606929953", "auth_fail", "Mozilla/5.0 (Linux; Android 9; SAMSUNG SM-G965U) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/10.2 Chrome/71.0.3578.99 Mobile Safari/537.36 wp-android/16.1", "1", "NoneNone");
INSERT INTO `wp_defender_lockout_log` VALUES("474", "Failed login attempt with username admin", "113.161.196.105", "1606937443", "auth_fail", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.77 Safari/537.36", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("475", "Failed login attempt with username econolodgeloon", "185.220.101.203", "1606949156", "auth_fail", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.106 Safari/537.36", "1", "econolodgeloon");
INSERT INTO `wp_defender_lockout_log` VALUES("476", "Request for file /manage/login.php which doesn\'t exist", "39.98.242.185", "1606952399", "404_error", NULL, "1", "/manage/login.php");
INSERT INTO `wp_defender_lockout_log` VALUES("477", "Request for file /htadmin/login.php which doesn\'t exist", "39.98.242.185", "1606952399", "404_error", NULL, "1", "/htadmin/login.php");
INSERT INTO `wp_defender_lockout_log` VALUES("478", "Request for file /dede/login.php which doesn\'t exist", "39.98.242.185", "1606952399", "404_error", NULL, "1", "/dede/login.php");
INSERT INTO `wp_defender_lockout_log` VALUES("479", "Request for file /admin/login.php which doesn\'t exist", "39.98.242.185", "1606952400", "404_error", NULL, "1", "/admin/login.php");
INSERT INTO `wp_defender_lockout_log` VALUES("480", "Request for file /admindede/login.php which doesn\'t exist", "39.98.242.185", "1606952401", "404_error", NULL, "1", "/admindede/login.php");
INSERT INTO `wp_defender_lockout_log` VALUES("481", "Failed login attempt with username admin", "91.205.172.116", "1606953776", "auth_fail", "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10.6; fr; rv:1.9.2.8) Gecko/20100722 Firefox/3.6.8", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("482", "Request for file /blog/xmlrpc.php which doesn\'t exist", "91.205.172.116", "1606953777", "404_error", "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10.6; fr; rv:1.9.2.8) Gecko/20100722 Firefox/3.6.8", "1", "/blog/xmlrpc.php");
INSERT INTO `wp_defender_lockout_log` VALUES("483", "Request for file /wp-content/plugins/easy-wp-smtp/ which doesn\'t exist", "138.91.154.178", "1606957121", "404_error", "python-requests/2.25.0", "1", "/wp-content/plugins/easy-wp-smtp/");
INSERT INTO `wp_defender_lockout_log` VALUES("484", "Request for file /wp-content/plugins/k_administrator/assets/php/connector.minimal.php which doesn\'t exist", "23.228.109.146", "1606964418", "404_error", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2896.3 Safari/537.36", "1", "/wp-content/plugins/k_administrator/assets/php/connector.minimal.php");
INSERT INTO `wp_defender_lockout_log` VALUES("485", "Request for file /rooms.html which doesn\'t exist", "5.9.70.117", "1606965919", "404_error", "Mozilla/5.0 (compatible; MJ12bot/v1.4.8; http://mj12bot.com/)", "1", "/rooms.html");
INSERT INTO `wp_defender_lockout_log` VALUES("486", "Request for file /wp-includes/css/css.php which doesn\'t exist", "138.91.154.178", "1606968723", "404_error", "python-requests/2.25.0", "1", "/wp-includes/css/css.php");
INSERT INTO `wp_defender_lockout_log` VALUES("487", "Request for file /wp-includes/fonts/css.php which doesn\'t exist", "138.91.154.178", "1606968749", "404_error", "python-requests/2.25.0", "1", "/wp-includes/fonts/css.php");
INSERT INTO `wp_defender_lockout_log` VALUES("488", "Request for file /wp-includes/css/css.php which doesn\'t exist", "212.227.174.234", "1606970621", "404_error", "python-requests/2.25.0", "1", "/wp-includes/css/css.php");
INSERT INTO `wp_defender_lockout_log` VALUES("489", "Request for file /wp-includes/fonts/css.php which doesn\'t exist", "212.227.174.234", "1606970633", "404_error", "python-requests/2.25.0", "1", "/wp-includes/fonts/css.php");
INSERT INTO `wp_defender_lockout_log` VALUES("490", "Failed login attempt with username admin", "94.76.1.171", "1606973387", "auth_fail", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:63.0) Gecko/20100101 Firefox/63.0", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("491", "Request for file /wp-content/plugins/ultimate-member/assets/js/um-modal.js which doesn\'t exist", "51.158.153.217", "1606981336", "404_error", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.125 Safari/537.36", "1", "/wp-content/plugins/ultimate-member/assets/js/um-modal.js");
INSERT INTO `wp_defender_lockout_log` VALUES("492", "Request for file /wp-content/plugins/ti-woocommerce-wishlist/assets/js/public.js which doesn\'t exist", "51.158.153.217", "1606981337", "404_error", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.125 Safari/537.36", "1", "/wp-content/plugins/ti-woocommerce-wishlist/assets/js/public.js");
INSERT INTO `wp_defender_lockout_log` VALUES("493", "Request for file /asset-manifest.json which doesn\'t exist", "18.237.198.186", "1606994395", "404_error", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3694.0 Safari/537.36 Chrome-Lighthouse", "1", "/asset-manifest.json");
INSERT INTO `wp_defender_lockout_log` VALUES("494", "Failed login attempt with username admin", "138.0.92.31", "1607006875", "auth_fail", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.110 Safari/537.36", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("495", "Failed login attempt with username NoneNone", "171.244.32.185", "1607009225", "auth_fail", "Mozilla/5.0 (Linux; Android 7.0; SM-G570M Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.91 Mobile Safari/537.36 wp-android/16.1", "1", "NoneNone");
INSERT INTO `wp_defender_lockout_log` VALUES("496", "Request for file /wp-content/themes/MoneyTheme/uploads/upload.php which doesn\'t exist", "23.228.109.146", "1607009352", "404_error", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2896.3 Safari/537.36", "1", "/wp-content/themes/MoneyTheme/uploads/upload.php");
INSERT INTO `wp_defender_lockout_log` VALUES("497", "Request for file /rooms.html which doesn\'t exist", "85.208.98.17", "1607014220", "404_error", "Mozilla/5.0 (compatible; SemrushBot-BA; +http://www.semrush.com/bot.html)", "1", "/rooms.html");
INSERT INTO `wp_defender_lockout_log` VALUES("498", "Request for file /reservations.html which doesn\'t exist", "85.208.98.16", "1607014222", "404_error", "Mozilla/5.0 (compatible; SemrushBot-BA; +http://www.semrush.com/bot.html)", "1", "/reservations.html");
INSERT INTO `wp_defender_lockout_log` VALUES("499", "Request for file /reservations.html which doesn\'t exist", "85.208.98.16", "1607014228", "404_error", "Mozilla/5.0 (compatible; SemrushBot-BA; +http://www.semrush.com/bot.html)", "1", "/reservations.html");
INSERT INTO `wp_defender_lockout_log` VALUES("500", "Request for file /reservations.html which doesn\'t exist", "85.208.98.17", "1607014229", "404_error", "Mozilla/5.0 (compatible; SemrushBot-BA; +http://www.semrush.com/bot.html)", "1", "/reservations.html");
INSERT INTO `wp_defender_lockout_log` VALUES("501", "Request for file /rooms.html which doesn\'t exist", "85.208.98.23", "1607014234", "404_error", "Mozilla/5.0 (compatible; SemrushBot-BA; +http://www.semrush.com/bot.html)", "1", "/rooms.html");
INSERT INTO `wp_defender_lockout_log` VALUES("502", "Request for file /wp-includes/css/modules.php which doesn\'t exist", "198.50.243.165", "1607019888", "404_error", "python-requests/2.23.0", "1", "/wp-includes/css/modules.php");
INSERT INTO `wp_defender_lockout_log` VALUES("503", "Request for file /wso.php which doesn\'t exist", "198.50.243.165", "1607019889", "404_error", "python-requests/2.23.0", "1", "/wso.php");
INSERT INTO `wp_defender_lockout_log` VALUES("504", "Request for file /wp-content/plugins/upspy/ which doesn\'t exist", "198.50.243.165", "1607019891", "404_error", "python-requests/2.23.0", "1", "/wp-content/plugins/upspy/");
INSERT INTO `wp_defender_lockout_log` VALUES("505", "Request for file /wp-content/plugins/ubh/ which doesn\'t exist", "198.50.243.165", "1607019893", "404_error", "python-requests/2.23.0", "1", "/wp-content/plugins/ubh/");
INSERT INTO `wp_defender_lockout_log` VALUES("506", "Request for file /wp-content/plugins/vwcleanerplugin/bump.php?cache which doesn\'t exist", "198.50.243.165", "1607019894", "404_error", "python-requests/2.23.0", "1", "/wp-content/plugins/vwcleanerplugin/bump.php?cache");
INSERT INTO `wp_defender_lockout_log` VALUES("507", "Request for file /wp-content/plugins/xichang/x.php?xi which doesn\'t exist", "198.50.243.165", "1607019895", "404_error", "python-requests/2.23.0", "1", "/wp-content/plugins/xichang/x.php?xi");
INSERT INTO `wp_defender_lockout_log` VALUES("508", "Request for file /wp-content/plugins/html404/index.html which doesn\'t exist", "198.50.243.165", "1607019896", "404_error", "python-requests/2.23.0", "1", "/wp-content/plugins/html404/index.html");
INSERT INTO `wp_defender_lockout_log` VALUES("509", "Request for file /olux.php which doesn\'t exist", "198.50.243.165", "1607019898", "404_error", "python-requests/2.23.0", "1", "/olux.php");
INSERT INTO `wp_defender_lockout_log` VALUES("510", "Request for file /indoxploit.php which doesn\'t exist", "198.50.243.165", "1607019899", "404_error", "python-requests/2.23.0", "1", "/indoxploit.php");
INSERT INTO `wp_defender_lockout_log` VALUES("511", "Request for file /up.php which doesn\'t exist", "198.50.243.165", "1607019901", "404_error", "python-requests/2.23.0", "1", "/up.php");
INSERT INTO `wp_defender_lockout_log` VALUES("512", "Request for file /upload.php which doesn\'t exist", "198.50.243.165", "1607019902", "404_error", "python-requests/2.23.0", "1", "/upload.php");
INSERT INTO `wp_defender_lockout_log` VALUES("513", "Request for file /wp-content/uploads/2020/12/ which doesn\'t exist", "198.50.243.165", "1607019903", "404_error", "python-requests/2.23.0", "1", "/wp-content/uploads/2020/12/");
INSERT INTO `wp_defender_lockout_log` VALUES("514", "Request for file /shell.php which doesn\'t exist", "198.50.243.165", "1607019904", "404_error", "python-requests/2.23.0", "1", "/shell.php");
INSERT INTO `wp_defender_lockout_log` VALUES("515", "Request for file /wp-info.php which doesn\'t exist", "198.50.243.165", "1607019906", "404_error", "python-requests/2.23.0", "1", "/wp-info.php");
INSERT INTO `wp_defender_lockout_log` VALUES("516", "Request for file /wp-content/vuln.php which doesn\'t exist", "198.50.243.165", "1607019907", "404_error", "python-requests/2.23.0", "1", "/wp-content/vuln.php");
INSERT INTO `wp_defender_lockout_log` VALUES("517", "Request for file /upel.php which doesn\'t exist", "198.50.243.165", "1607019908", "404_error", "python-requests/2.23.0", "1", "/upel.php");
INSERT INTO `wp_defender_lockout_log` VALUES("518", "Request for file /wp-content/plugins/ppus/up.php which doesn\'t exist", "198.50.243.165", "1607019909", "404_error", "python-requests/2.23.0", "1", "/wp-content/plugins/ppus/up.php");
INSERT INTO `wp_defender_lockout_log` VALUES("519", "Request for file /098.php which doesn\'t exist", "198.50.243.165", "1607019910", "404_error", "python-requests/2.23.0", "1", "/098.php");
INSERT INTO `wp_defender_lockout_log` VALUES("520", "Request for file /V5.php which doesn\'t exist", "198.50.243.165", "1607019911", "404_error", "python-requests/2.23.0", "1", "/V5.php");
INSERT INTO `wp_defender_lockout_log` VALUES("521", "Request for file /new_license.php which doesn\'t exist", "198.50.243.165", "1607019912", "404_error", "python-requests/2.23.0", "1", "/new_license.php");
INSERT INTO `wp_defender_lockout_log` VALUES("522", "Lockout occurred:  Too many 404 requests for /new_license.php", "198.50.243.165", "1607019912", "404_lockout", "python-requests/2.23.0", "1", "/new_license.php");
INSERT INTO `wp_defender_lockout_log` VALUES("523", "Request for file /wp-content/plugins/advanced_file_manager_5/filemanager.php which doesn\'t exist", "194.33.45.161", "1607021134", "404_error", "python-requests/2.9.1", "1", "/wp-content/plugins/advanced_file_manager_5/filemanager.php");
INSERT INTO `wp_defender_lockout_log` VALUES("524", "Failed login attempt with username admin", "147.91.111.100", "1607022158", "auth_fail", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.77 Safari/537.36", "1", "admin");
INSERT INTO `wp_defender_lockout_log` VALUES("525", "Request for file /snowmobile.html which doesn\'t exist", "62.210.149.60", "1607022234", "404_error", "Mozilla/5.0 (compatible; Barkrowler/0.9; +https://babbar.tech/crawler)", "1", "/snowmobile.html");
INSERT INTO `wp_defender_lockout_log` VALUES("526", "Request for file /christmastree.html which doesn\'t exist", "62.210.149.60", "1607022249", "404_error", "Mozilla/5.0 (compatible; Barkrowler/0.9; +https://babbar.tech/crawler)", "1", "/christmastree.html");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "econolodge", "723466409e890c2d4743_20181211164701", "100", "2018-12-11 16:47:30", "econolodge", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2018-12-11 16:47:01\";s:7:\"Version\";s:6:\"1.2.52\";s:9:\"VersionWP\";s:3:\"5.0\";s:9:\"VersionDB\";s:7:\"10.1.36\";s:10:\"VersionPHP\";s:6:\"5.6.38\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:10:\"econolodge\";s:4:\"Hash\";s:35:\"723466409e890c2d4743_20181211164701\";s:8:\"NameHash\";s:46:\"econolodge_723466409e890c2d4743_20181211164701\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:48:\"/home/econolodge/public_html/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:47:\"https://www.econolodgeloon.com/wp/wp-snapshots/\";s:8:\"ScanFile\";s:56:\"econolodge_723466409e890c2d4743_20181211164701_scan.json\";s:7:\"Runtime\";s:10:\"33.28 sec.\";s:7:\"ExeSize\";s:8:\"514.15KB\";s:7:\"ZipSize\";s:7:\"91.54MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:10:\"econolodge\";s:7:\"Archive\";O:11:\"DUP_Archive\":19:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:58:\"econolodge_723466409e890c2d4743_20181211164701_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:31:\"/home/econolodge/public_html/wp\";s:4:\"Size\";i:95983069;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:40:\"/home/econolodge/public_html/wp/wp-admin\";i:1;s:50:\"/home/econolodge/public_html/wp/wp-content/uploads\";i:2;s:52:\"/home/econolodge/public_html/wp/wp-content/languages\";i:3;s:50:\"/home/econolodge/public_html/wp/wp-content/plugins\";i:4;s:49:\"/home/econolodge/public_html/wp/wp-content/themes\";i:5;s:43:\"/home/econolodge/public_html/wp/wp-includes\";}}s:9:\"Installer\";O:13:\"DUP_Installer\":9:{s:4:\"File\";s:60:\"econolodge_723466409e890c2d4743_20181211164701_installer.php\";s:4:\"Size\";i:526485;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:20:\"dGVdUm1Ie3BlU31FIUAj\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:6224101;s:4:\"File\";s:59:\"econolodge_723466409e890c2d4743_20181211164701_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:108:\"/home/econolodge/public_html/wp/wp-snapshots/tmp/econolodge_723466409e890c2d4743_20181211164701_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `wp_duplicator_packages` VALUES("2", "econolodgebackup12_3_20", "80a9c9bf9fdcf1a03310_20201203191535", "23", "2020-12-03 19:16:09", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2020-12-03 19:15:35\";s:7:\"Version\";s:6:\"1.3.40\";s:9:\"VersionWP\";s:5:\"5.5.3\";s:9:\"VersionDB\";s:7:\"10.3.27\";s:10:\"VersionPHP\";s:6:\"7.2.34\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:2;s:4:\"Name\";s:23:\"econolodgebackup12_3_20\";s:4:\"Hash\";s:35:\"80a9c9bf9fdcf1a03310_20201203191535\";s:8:\"NameHash\";s:59:\"econolodgebackup12_3_20_80a9c9bf9fdcf1a03310_20201203191535\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:69:\"econolodgebackup12_3_20_80a9c9bf9fdcf1a03310_20201203191535_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"22.8\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":21:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:71:\"econolodgebackup12_3_20_80a9c9bf9fdcf1a03310_20201203191535_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:28:\"/home/econolodge/public_html\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":5:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":6:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2020-12-03 19:15:35\";s:7:\"Version\";s:6:\"1.3.40\";s:9:\"VersionWP\";s:5:\"5.5.3\";s:9:\"VersionDB\";s:7:\"10.3.27\";s:10:\"VersionPHP\";s:6:\"7.2.34\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:23:\"econolodgebackup12_3_20\";s:4:\"Hash\";s:35:\"80a9c9bf9fdcf1a03310_20201203191535\";s:8:\"NameHash\";s:59:\"econolodgebackup12_3_20_80a9c9bf9fdcf1a03310_20201203191535\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";s:73:\"econolodgebackup12_3_20_80a9c9bf9fdcf1a03310_20201203191535_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:20:\"dGVdUm1Ie3BlU31FIUAj\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:61;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:72:\"econolodgebackup12_3_20_80a9c9bf9fdcf1a03310_20201203191535_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":15:{s:9:\"buildMode\";N;s:13:\"collationList\";a:0:{}s:17:\"isTablesUpperCase\";N;s:15:\"isNameUpperCase\";N;s:4:\"name\";N;s:15:\"tablesBaseCount\";N;s:16:\"tablesFinalCount\";N;s:14:\"tablesRowCount\";N;s:16:\"tablesSizeOnDisk\";N;s:18:\"varLowerCaseTables\";i:0;s:7:\"version\";N;s:14:\"versionComment\";N;s:18:\"tableWiseRowCounts\";a:17:{s:12:\"wp_bwg_album\";s:1:\"0\";s:20:\"wp_bwg_album_gallery\";s:1:\"0\";s:14:\"wp_bwg_gallery\";s:1:\"2\";s:12:\"wp_bwg_image\";s:2:\"32\";s:20:\"wp_bwg_image_comment\";s:1:\"0\";s:17:\"wp_bwg_image_rate\";s:1:\"0\";s:16:\"wp_bwg_image_tag\";s:1:\"0\";s:13:\"wp_bwg_option\";s:1:\"1\";s:16:\"wp_bwg_shortcode\";s:1:\"2\";s:12:\"wp_bwg_theme\";s:1:\"2\";s:14:\"wp_commentmeta\";s:1:\"0\";s:11:\"wp_comments\";s:1:\"0\";s:21:\"wp_defender_audit_log\";s:1:\"0\";s:21:\"wp_defender_email_log\";s:1:\"0\";s:19:\"wp_defender_lockout\";s:4:\"1187\";s:23:\"wp_defender_lockout_log\";s:3:\"526\";s:16:\"wp_defender_scan\";s:1:\"0\";}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:118:\"/home/econolodge/public_html/wp-snapshots/tmp/econolodgebackup12_3_20_80a9c9bf9fdcf1a03310_20201203191535_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:61;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:37:\"/home/econolodge/public_html/wp-admin\";i:1;s:47:\"/home/econolodge/public_html/wp-content/uploads\";i:2;s:49:\"/home/econolodge/public_html/wp-content/languages\";i:3;s:46:\"/home/econolodge/public_html/wp-content/themes\";i:4;s:40:\"/home/econolodge/public_html/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:28:\"/home/econolodge/public_html\";i:1;s:39:\"/home/econolodge/public_html/wp-content\";}}s:9:\"Installer\";r:82;s:8:\"Database\";r:96;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_easy_gallery */
INSERT INTO `wp_easy_gallery` VALUES("16", "Captain Bounty Rooms", "captainbountyrooms", "", "", "300", "175");

/* INSERT TABLE DATA: wp_ngg_gallery */
INSERT INTO `wp_ngg_gallery` VALUES("1", "boscobel-mansion-rooms", "boscobel-mansion-rooms", "wp-content/gallery/boscobel-mansion-rooms", "Boscobel Mansion Rooms", "", "0", "0", "1");

/* INSERT TABLE DATA: wp_ngg_pictures */
INSERT INTO `wp_ngg_pictures` VALUES("1", "bocobel-room-1", "0", "1", "boscobel1.jpg", "", "Bocobel Room 1", "2014-02-27 20:55:38", "0", "0", "eyJ3aWR0aCI6NzAwLCJoZWlnaHQiOjQ2NSwiZnVsbCI6eyJ3aWR0aCI6NzAwLCJoZWlnaHQiOjQ2NX0sInRodW1ibmFpbCI6eyJ3aWR0aCI6MTIwLCJoZWlnaHQiOjkwLCJmaWxlbmFtZSI6InRodW1ic19ib3Njb2JlbDEuanBnIiwiZ2VuZXJhdGVkIjoiMC43MzM4NTAwMCAxMzkzNTM0NTM4In0sImFwZXJ0dXJlIjpmYWxzZSwiY3JlZGl0IjpmYWxzZSwiY2FtZXJhIjpmYWxzZSwiY2FwdGlvbiI6ZmFsc2UsImNyZWF0ZWRfdGltZXN0YW1wIjpmYWxzZSwiY29weXJpZ2h0IjpmYWxzZSwiZm9jYWxfbGVuZ3RoIjpmYWxzZSwiaXNvIjpmYWxzZSwic2h1dHRlcl9zcGVlZCI6ZmFsc2UsImZsYXNoIjpmYWxzZSwidGl0bGUiOmZhbHNlLCJrZXl3b3JkcyI6ZmFsc2UsInNhdmVkIjp0cnVlLCJuZ2cwZHluLTIwMHgyMDB4OTAtMDBmMHcwMTBjMDEwcjExMGYxMTByMDEwdDAzanBnIjp7IndpZHRoIjoxOTgsImhlaWdodCI6MTMyLCJmaWxlbmFtZSI6ImJvc2NvYmVsMS1uZ2dpZDAxMS1uZ2cwZHluLTIwMHgyMDB4OTAtMDBmMHcwMTBjMDEwcjExMGYxMTByMDEwdDAzanBnLmpwZyIsImdlbmVyYXRlZCI6IjAuMjk0NzY2MDAgMTM5MzUzOTUzNyJ9fQ==");
INSERT INTO `wp_ngg_pictures` VALUES("2", "boscobel-room-2-sitting-area", "0", "1", "boscobel2sit_copy.jpg", " ", "Boscobel Room 2 Sitting Area", "2014-02-27 20:56:38", "0", "0", "a:17:{s:5:\"width\";i:700;s:6:\"height\";i:977;s:4:\"full\";a:2:{s:5:\"width\";i:700;s:6:\"height\";i:977;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:28:\"thumbs_boscobel2sit_copy.jpg\";s:9:\"generated\";s:21:\"0.81888000 1393534598\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");
INSERT INTO `wp_ngg_pictures` VALUES("3", "boscobel2b", "0", "1", "boscobel2b.jpg", " ", "boscobel2b", "2014-02-27 20:56:38", "0", "0", "a:17:{s:5:\"width\";i:377;s:6:\"height\";i:650;s:4:\"full\";a:2:{s:5:\"width\";i:377;s:6:\"height\";i:650;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:21:\"thumbs_boscobel2b.jpg\";s:9:\"generated\";s:21:\"0.89606800 1393534598\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");
INSERT INTO `wp_ngg_pictures` VALUES("4", "boscobel3", "0", "1", "boscobel3.jpg", " ", "boscobel3", "2014-02-27 20:56:41", "0", "0", "a:17:{s:5:\"width\";i:700;s:6:\"height\";i:454;s:4:\"full\";a:2:{s:5:\"width\";i:700;s:6:\"height\";i:454;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:20:\"thumbs_boscobel3.jpg\";s:9:\"generated\";s:21:\"0.28556100 1393534601\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");
INSERT INTO `wp_ngg_pictures` VALUES("5", "boscobel3a_copy", "0", "1", "boscobel3a_copy.jpg", " ", "boscobel3a_copy", "2014-02-27 20:56:41", "0", "0", "a:17:{s:5:\"width\";i:418;s:6:\"height\";i:600;s:4:\"full\";a:2:{s:5:\"width\";i:418;s:6:\"height\";i:600;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:26:\"thumbs_boscobel3a_copy.jpg\";s:9:\"generated\";s:21:\"0.70641600 1393534601\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");
INSERT INTO `wp_ngg_pictures` VALUES("6", "boscobel3a", "0", "1", "boscobel3a.jpg", " ", "boscobel3a", "2014-02-27 20:56:41", "0", "0", "a:17:{s:5:\"width\";i:292;s:6:\"height\";i:400;s:4:\"full\";a:2:{s:5:\"width\";i:292;s:6:\"height\";i:400;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:21:\"thumbs_boscobel3a.jpg\";s:9:\"generated\";s:21:\"0.92983300 1393534601\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");
INSERT INTO `wp_ngg_pictures` VALUES("7", "boscobel2sit", "0", "1", "boscobel2sit.jpg", " ", "boscobel2sit", "2014-02-27 20:56:42", "0", "0", "a:17:{s:5:\"width\";i:324;s:6:\"height\";i:400;s:4:\"full\";a:2:{s:5:\"width\";i:324;s:6:\"height\";i:400;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:23:\"thumbs_boscobel2sit.jpg\";s:9:\"generated\";s:21:\"0.66840700 1393534602\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");
INSERT INTO `wp_ngg_pictures` VALUES("8", "boscobel3bath_copy", "0", "1", "boscobel3bath_copy.jpg", " ", "boscobel3bath_copy", "2014-02-27 20:56:43", "0", "0", "a:17:{s:5:\"width\";i:418;s:6:\"height\";i:600;s:4:\"full\";a:2:{s:5:\"width\";i:418;s:6:\"height\";i:600;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:29:\"thumbs_boscobel3bath_copy.jpg\";s:9:\"generated\";s:21:\"0.34080900 1393534603\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");
INSERT INTO `wp_ngg_pictures` VALUES("9", "boscobel3bath", "0", "1", "boscobel3bath.jpg", " ", "boscobel3bath", "2014-02-27 20:56:44", "0", "0", "a:17:{s:5:\"width\";i:279;s:6:\"height\";i:400;s:4:\"full\";a:2:{s:5:\"width\";i:279;s:6:\"height\";i:400;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:24:\"thumbs_boscobel3bath.jpg\";s:9:\"generated\";s:21:\"0.56111100 1393534604\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");
INSERT INTO `wp_ngg_pictures` VALUES("10", "boscobel4", "0", "1", "boscobel4.jpg", " ", "boscobel4", "2014-02-27 20:56:46", "0", "0", "a:17:{s:5:\"width\";i:700;s:6:\"height\";i:401;s:4:\"full\";a:2:{s:5:\"width\";i:700;s:6:\"height\";i:401;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:20:\"thumbs_boscobel4.jpg\";s:9:\"generated\";s:21:\"0.14617400 1393534606\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");
INSERT INTO `wp_ngg_pictures` VALUES("11", "boscobel4a", "0", "1", "boscobel4a.jpg", " ", "boscobel4a", "2014-02-27 20:56:47", "0", "0", "a:17:{s:5:\"width\";i:700;s:6:\"height\";i:429;s:4:\"full\";a:2:{s:5:\"width\";i:700;s:6:\"height\";i:429;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:21:\"thumbs_boscobel4a.jpg\";s:9:\"generated\";s:21:\"0.45744800 1393534607\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");
INSERT INTO `wp_ngg_pictures` VALUES("12", "boscobel4bath_copy", "0", "1", "boscobel4bath_copy.jpg", " ", "boscobel4bath_copy", "2014-02-27 20:56:49", "0", "0", "a:17:{s:5:\"width\";i:700;s:6:\"height\";i:1299;s:4:\"full\";a:2:{s:5:\"width\";i:700;s:6:\"height\";i:1299;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:29:\"thumbs_boscobel4bath_copy.jpg\";s:9:\"generated\";s:21:\"0.53150200 1393534609\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");
INSERT INTO `wp_ngg_pictures` VALUES("13", "boscobel4bath", "0", "1", "boscobel4bath.jpg", " ", "boscobel4bath", "2014-02-27 20:56:50", "0", "0", "a:17:{s:5:\"width\";i:251;s:6:\"height\";i:400;s:4:\"full\";a:2:{s:5:\"width\";i:251;s:6:\"height\";i:400;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:24:\"thumbs_boscobel4bath.jpg\";s:9:\"generated\";s:21:\"0.57713900 1393534610\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");
INSERT INTO `wp_ngg_pictures` VALUES("14", "boscobel5", "0", "1", "boscobel5.jpg", " ", "boscobel5", "2014-02-27 20:56:51", "0", "0", "a:17:{s:5:\"width\";i:700;s:6:\"height\";i:434;s:4:\"full\";a:2:{s:5:\"width\";i:700;s:6:\"height\";i:434;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:20:\"thumbs_boscobel5.jpg\";s:9:\"generated\";s:21:\"0.79187200 1393534611\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");
INSERT INTO `wp_ngg_pictures` VALUES("15", "boscobel5a", "0", "1", "boscobel5a.jpg", " ", "boscobel5a", "2014-02-27 20:56:52", "0", "0", "a:17:{s:5:\"width\";i:700;s:6:\"height\";i:468;s:4:\"full\";a:2:{s:5:\"width\";i:700;s:6:\"height\";i:468;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:21:\"thumbs_boscobel5a.jpg\";s:9:\"generated\";s:21:\"0.10513500 1393534613\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");
INSERT INTO `wp_ngg_pictures` VALUES("16", "boscobel5bath", "0", "1", "boscobel5bath.jpg", " ", "boscobel5bath", "2014-02-27 20:56:54", "0", "0", "a:17:{s:5:\"width\";i:341;s:6:\"height\";i:500;s:4:\"full\";a:2:{s:5:\"width\";i:341;s:6:\"height\";i:500;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:24:\"thumbs_boscobel5bath.jpg\";s:9:\"generated\";s:21:\"0.34781200 1393534614\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");
INSERT INTO `wp_ngg_pictures` VALUES("17", "boscobel6", "0", "1", "boscobel6.jpg", " ", "boscobel6", "2014-02-27 20:56:55", "0", "0", "a:17:{s:5:\"width\";i:700;s:6:\"height\";i:411;s:4:\"full\";a:2:{s:5:\"width\";i:700;s:6:\"height\";i:411;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:20:\"thumbs_boscobel6.jpg\";s:9:\"generated\";s:21:\"0.58743100 1393534615\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");
INSERT INTO `wp_ngg_pictures` VALUES("18", "boscobel6bath", "0", "1", "boscobel6bath.jpg", " ", "boscobel6bath", "2014-02-27 20:56:56", "0", "0", "a:17:{s:5:\"width\";i:334;s:6:\"height\";i:550;s:4:\"full\";a:2:{s:5:\"width\";i:334;s:6:\"height\";i:550;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:24:\"thumbs_boscobel6bath.jpg\";s:9:\"generated\";s:21:\"0.71017000 1393534616\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");
INSERT INTO `wp_ngg_pictures` VALUES("19", "boscobel8", "0", "1", "boscobel8.jpg", " ", "boscobel8", "2014-02-27 20:57:08", "0", "0", "a:17:{s:5:\"width\";i:700;s:6:\"height\";i:431;s:4:\"full\";a:2:{s:5:\"width\";i:700;s:6:\"height\";i:431;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:20:\"thumbs_boscobel8.jpg\";s:9:\"generated\";s:21:\"0.04488000 1393534629\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");
INSERT INTO `wp_ngg_pictures` VALUES("20", "boscobel10", "0", "1", "boscobel10.jpg", " ", "boscobel10", "2014-02-27 20:57:10", "0", "0", "a:17:{s:5:\"width\";i:700;s:6:\"height\";i:484;s:4:\"full\";a:2:{s:5:\"width\";i:700;s:6:\"height\";i:484;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:21:\"thumbs_boscobel10.jpg\";s:9:\"generated\";s:21:\"0.75061200 1393534630\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");
INSERT INTO `wp_ngg_pictures` VALUES("21", "boscobel10b", "0", "1", "boscobel10b.jpg", " ", "boscobel10b", "2014-02-27 20:57:11", "0", "0", "a:17:{s:5:\"width\";i:700;s:6:\"height\";i:464;s:4:\"full\";a:2:{s:5:\"width\";i:700;s:6:\"height\";i:464;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:22:\"thumbs_boscobel10b.jpg\";s:9:\"generated\";s:21:\"0.97819200 1393534631\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");
INSERT INTO `wp_ngg_pictures` VALUES("22", "boscobel10c", "0", "1", "boscobel10c.jpg", " ", "boscobel10c", "2014-02-27 20:57:13", "0", "0", "a:17:{s:5:\"width\";i:700;s:6:\"height\";i:462;s:4:\"full\";a:2:{s:5:\"width\";i:700;s:6:\"height\";i:462;}s:9:\"thumbnail\";a:4:{s:5:\"width\";i:120;s:6:\"height\";i:90;s:8:\"filename\";s:22:\"thumbs_boscobel10c.jpg\";s:9:\"generated\";s:21:\"0.25917900 1393534633\";}s:8:\"aperture\";b:0;s:6:\"credit\";b:0;s:6:\"camera\";b:0;s:7:\"caption\";b:0;s:17:\"created_timestamp\";b:0;s:9:\"copyright\";b:0;s:12:\"focal_length\";b:0;s:3:\"iso\";b:0;s:13:\"shutter_speed\";b:0;s:5:\"flash\";b:0;s:5:\"title\";b:0;s:8:\"keywords\";b:0;s:5:\"saved\";b:1;}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "https://www.econolodgeloon.com/", "yes");
INSERT INTO `wp_options` VALUES("2", "blogname", "", "yes");
INSERT INTO `wp_options` VALUES("3", "blogdescription", "", "yes");
INSERT INTO `wp_options` VALUES("4", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("5", "admin_email", "info@touristmarketing.com", "yes");
INSERT INTO `wp_options` VALUES("6", "start_of_week", "0", "yes");
INSERT INTO `wp_options` VALUES("7", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("8", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("9", "require_name_email", "", "yes");
INSERT INTO `wp_options` VALUES("10", "comments_notify", "", "yes");
INSERT INTO `wp_options` VALUES("11", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("12", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("13", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("17", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("18", "default_comment_status", "closed", "yes");
INSERT INTO `wp_options` VALUES("19", "default_ping_status", "closed", "yes");
INSERT INTO `wp_options` VALUES("20", "default_pingback_flag", "", "yes");
INSERT INTO `wp_options` VALUES("21", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("22", "date_format", "F j, Y", "yes");
INSERT INTO `wp_options` VALUES("23", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("24", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("28", "comment_moderation", "", "yes");
INSERT INTO `wp_options` VALUES("29", "moderation_notify", "", "yes");
INSERT INTO `wp_options` VALUES("30", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("32", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("33", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("34", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("35", "active_plugins", "a:15:{i:0;s:60:\"advanced-floating-content-lite/advanced-floating-content.php\";i:1;s:33:\"classic-editor/classic-editor.php\";i:2;s:47:\"cryout-theme-settings/cryout-theme-settings.php\";i:3;s:25:\"duplicator/duplicator.php\";i:4;s:29:\"simple-cache/simple-cache.php\";i:5;s:24:\"simple-lightbox/main.php\";i:6;s:21:\"snapshot/snapshot.php\";i:8;s:23:\"wordfence/wordfence.php\";i:9;s:24:\"wordpress-seo/wp-seo.php\";i:10;s:27:\"wp-defender/wp-defender.php\";i:11;s:33:\"wp-hummingbird/wp-hummingbird.php\";i:12;s:27:\"wp-optimize/wp-optimize.php\";i:13;s:25:\"wp-smush-pro/wp-smush.php\";i:14;s:43:\"wp-updates-settings/wp-updates-settings.php\";i:15;s:40:\"wpmudev-updates/update-notifications.php\";}", "yes");
INSERT INTO `wp_options` VALUES("36", "home", "https://www.econolodgeloon.com/", "yes");
INSERT INTO `wp_options` VALUES("37", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("38", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("40", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("41", "gmt_offset", "", "yes");
INSERT INTO `wp_options` VALUES("42", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("43", "recently_edited", "a:5:{i:0;s:104:\"/home/econolodge/public_html/wp/wp-content/plugins/velvet-blues-update-urls/velvet-blues-update-urls.php\";i:1;s:97:\"/home/econolodge/public_html/wp/wp/wp-content/plugins/wp-updates-settings/wp-updates-settings.php\";i:2;s:70:\"/home/econolodge/public_html/wp/wp/wp-content/themes/tempera/style.css\";i:3;s:79:\"/home/econolodge/public_html/wp/wp/wp-content/themes/tempera-nocopyrt/style.css\";i:4;s:109:\"/var/hsphere/local/home/captain/captainsbountymotorinn.com/wp-content/plugins/photo-gallery/photo-gallery.php\";}", "no");
INSERT INTO `wp_options` VALUES("44", "template", "tempera", "yes");
INSERT INTO `wp_options` VALUES("45", "stylesheet", "tempera-nocopyrt", "yes");
INSERT INTO `wp_options` VALUES("263356", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wp_options` VALUES("48", "comment_registration", "", "yes");
INSERT INTO `wp_options` VALUES("49", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("50", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("51", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("52", "db_version", "48748", "yes");
INSERT INTO `wp_options` VALUES("53", "uploads_use_yearmonth_folders", "", "yes");
INSERT INTO `wp_options` VALUES("54", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("55", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("56", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("57", "show_on_front", "posts", "yes");
INSERT INTO `wp_options` VALUES("58", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("59", "show_avatars", "", "yes");
INSERT INTO `wp_options` VALUES("60", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("61", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("62", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("63", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("64", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("65", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("66", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("67", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("68", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("69", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("70", "image_default_link_type", "", "yes");
INSERT INTO `wp_options` VALUES("71", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("72", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("73", "close_comments_for_old_posts", "", "yes");
INSERT INTO `wp_options` VALUES("74", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("75", "thread_comments", "", "yes");
INSERT INTO `wp_options` VALUES("76", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("77", "page_comments", "", "yes");
INSERT INTO `wp_options` VALUES("78", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("79", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("80", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("81", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("82", "widget_categories", "a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("83", "widget_text", "a:3:{i:2;a:4:{s:5:\"title\";s:61:\"Sign Up For Our Newsletter! Receive Updates & Special Offers!\";s:4:\"text\";s:856:\"<p style=\"text-align:center\"><a href=\"https://www.econolodgeloon.com/wp/yarmouth-ma-cape-cod-motel-virtual-tour/\"><img src=\"https://www.econolodgeloon.com/wp/wp-content/uploads/subscribe-animated-gif-150.gif\" width=““150”” height=““80”” border=\"0\" /></a><form action=\"http://touristmarketingservices.com/sendy/subscribe\" method=\"POST\" accept-charset=\"utf-8\">\r\n	<label for=\"name\">Name</label><br/>\r\n	<input type=\"text\" name=\"name\" id=\"name\"/>\r\n	<br/>\r\n	<label for=\"email\">Email</label><br/>\r\n	<input type=\"email\" name=\"email\" id=\"email\"/><br/>\r\n	<div style=\"display:none;\">\r\n	<label for=\"hp\">HP</label><br/>\r\n	<input type=\"text\" name=\"hp\" id=\"hp\"/>\r\n	</div>\r\n	<input type=\"hidden\" name=\"list\" value=\"0bl9FX86PKwQ8i76367h892OOA\"/>\r\n	<input type=\"hidden\" name=\"subform\" value=\"yes\"/>\r\n	<input type=\"submit\" name=\"submit\" id=\"submit\"/>\r\n</form>\";s:6:\"filter\";b:0;s:6:\"visual\";b:0;}i:3;a:3:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("84", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("85", "uninstall_plugins", "a:8:{s:57:\"rk-responsive-contact-form/rk-responsive-contact-form.php\";s:25:\"rk_contact_form_uninstall\";s:20:\"worker/functions.php\";s:13:\"mwp_uninstall\";s:30:\"lightbox-plus/lightboxplus.php\";s:12:\"UninstallLBP\";s:40:\"wpmudev-updates/update-notifications.php\";a:2:{i:0;s:17:\"WPMUDEV_Dashboard\";i:1;s:16:\"uninstall_plugin\";}s:25:\"adminimize/adminimize.php\";s:24:\"_mw_adminimize_uninstall\";s:33:\"classic-editor/classic-editor.php\";a:2:{i:0;s:14:\"Classic_Editor\";i:1;s:9:\"uninstall\";}s:27:\"wp-super-cache/wp-cache.php\";s:22:\"wpsupercache_uninstall\";s:27:\"wp-optimize/wp-optimize.php\";s:21:\"wpo_uninstall_actions\";}", "no");
INSERT INTO `wp_options` VALUES("86", "timezone_string", "America/New_York", "yes");
INSERT INTO `wp_options` VALUES("87", "page_for_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("88", "page_on_front", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("90", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("91", "initial_db_version", "25824", "yes");
INSERT INTO `wp_options` VALUES("92", "wp_user_roles", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:90:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:24:\"NextGEN Gallery overview\";b:1;s:19:\"NextGEN Use TinyMCE\";b:1;s:21:\"NextGEN Upload images\";b:1;s:22:\"NextGEN Manage gallery\";b:1;s:19:\"NextGEN Manage tags\";b:1;s:29:\"NextGEN Manage others gallery\";b:1;s:18:\"NextGEN Edit album\";b:1;s:20:\"NextGEN Change style\";b:1;s:22:\"NextGEN Change options\";b:1;s:24:\"NextGEN Attach Interface\";b:1;s:22:\"tablepress_edit_tables\";b:1;s:24:\"tablepress_delete_tables\";b:1;s:22:\"tablepress_list_tables\";b:1;s:21:\"tablepress_add_tables\";b:1;s:22:\"tablepress_copy_tables\";b:1;s:24:\"tablepress_import_tables\";b:1;s:24:\"tablepress_export_tables\";b:1;s:32:\"tablepress_access_options_screen\";b:1;s:30:\"tablepress_access_about_screen\";b:1;s:29:\"tablepress_import_tables_wptr\";b:1;s:23:\"tablepress_edit_options\";b:1;s:22:\"manage_snapshots_items\";b:1;s:29:\"manage_snapshots_destinations\";b:1;s:25:\"manage_snapshots_settings\";b:1;s:23:\"manage_snapshots_import\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:44:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:22:\"tablepress_edit_tables\";b:1;s:24:\"tablepress_delete_tables\";b:1;s:22:\"tablepress_list_tables\";b:1;s:21:\"tablepress_add_tables\";b:1;s:22:\"tablepress_copy_tables\";b:1;s:24:\"tablepress_import_tables\";b:1;s:24:\"tablepress_export_tables\";b:1;s:32:\"tablepress_access_options_screen\";b:1;s:30:\"tablepress_access_about_screen\";b:1;s:15:\"wpseo_bulk_edit\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:19:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:22:\"tablepress_edit_tables\";b:1;s:24:\"tablepress_delete_tables\";b:1;s:22:\"tablepress_list_tables\";b:1;s:21:\"tablepress_add_tables\";b:1;s:22:\"tablepress_copy_tables\";b:1;s:24:\"tablepress_import_tables\";b:1;s:24:\"tablepress_export_tables\";b:1;s:32:\"tablepress_access_options_screen\";b:1;s:30:\"tablepress_access_about_screen\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:47:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:22:\"tablepress_edit_tables\";b:1;s:24:\"tablepress_delete_tables\";b:1;s:22:\"tablepress_list_tables\";b:1;s:21:\"tablepress_add_tables\";b:1;s:22:\"tablepress_copy_tables\";b:1;s:24:\"tablepress_import_tables\";b:1;s:24:\"tablepress_export_tables\";b:1;s:32:\"tablepress_access_options_screen\";b:1;s:30:\"tablepress_access_about_screen\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:45:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:22:\"tablepress_edit_tables\";b:1;s:24:\"tablepress_delete_tables\";b:1;s:22:\"tablepress_list_tables\";b:1;s:21:\"tablepress_add_tables\";b:1;s:22:\"tablepress_copy_tables\";b:1;s:24:\"tablepress_import_tables\";b:1;s:24:\"tablepress_export_tables\";b:1;s:32:\"tablepress_access_options_screen\";b:1;s:30:\"tablepress_access_about_screen\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("94", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("95", "widget_recent-posts", "a:2:{s:12:\"_multiwidget\";i:1;i:1;a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("96", "widget_recent-comments", "a:2:{s:12:\"_multiwidget\";i:1;i:1;a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("97", "widget_archives", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("98", "widget_meta", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("99", "sidebars_widgets", "a:12:{s:19:\"wp_inactive_widgets\";a:1:{i:0;s:8:\"search-2\";}s:16:\"left-widget-area\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}s:17:\"right-widget-area\";a:2:{i:0;s:6:\"text-2\";i:1;s:6:\"text-3\";}s:24:\"first-footer-widget-area\";a:0:{}s:25:\"second-footer-widget-area\";a:0:{}s:24:\"third-footer-widget-area\";a:0:{}s:25:\"fourth-footer-widget-area\";a:0:{}s:25:\"above-content-widget-area\";a:0:{}s:25:\"below-content-widget-area\";a:0:{}s:18:\"header-widget-area\";a:0:{}s:30:\"presentation-page-columns-area\";a:2:{i:0;s:16:\"columns_widget-2\";i:1;s:16:\"columns_widget-3\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("32012", "wpseo_social", "a:19:{s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:19:\"og_default_image_id\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:21:\"og_frontpage_image_id\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:7:\"twitter\";b:0;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:7:\"summary\";s:11:\"youtube_url\";s:0:\"\";s:13:\"wikipedia_url\";s:0:\"\";s:10:\"fbadminapp\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("2822", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:25:\"info@touristmarketing.com\";s:7:\"version\";s:5:\"5.4.4\";s:9:\"timestamp\";i:1604108649;}", "no");
INSERT INTO `wp_options` VALUES("150", "theme_mods_twentythirteen", "a:1:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1393278602;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}}}}", "yes");
INSERT INTO `wp_options` VALUES("151", "current_theme", "Tempera Child (no copyright link)", "yes");
INSERT INTO `wp_options` VALUES("152", "theme_mods_stay-wpcom", "a:11:{i:0;b:0;s:16:\"header_textcolor\";s:5:\"blank\";s:16:\"background_color\";s:6:\"fdfde3\";s:16:\"background_image\";s:0:\"\";s:17:\"background_repeat\";s:6:\"repeat\";s:21:\"background_position_x\";s:4:\"left\";s:21:\"background_attachment\";s:5:\"fixed\";s:16:\"stay_home_slider\";a:6:{i:1;s:1:\"8\";i:2;s:1:\"0\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";}s:17:\"stay_social_links\";a:7:{s:7:\"twitter\";s:0:\"\";s:8:\"facebook\";s:0:\"\";s:7:\"youtube\";s:0:\"\";s:11:\"google_plus\";s:0:\"\";s:9:\"pinterest\";s:0:\"\";s:5:\"vimeo\";s:0:\"\";s:5:\"email\";s:0:\"\";}s:18:\"nav_menu_locations\";a:0:{}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1393293452;s:4:\"data\";a:9:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:4:{i:0;s:8:\"search-2\";i:1;s:10:\"archives-2\";i:2;s:12:\"categories-2\";i:3;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}s:9:\"sidebar-4\";a:0:{}s:9:\"sidebar-5\";a:0:{}s:9:\"sidebar-6\";a:0:{}s:9:\"sidebar-7\";a:0:{}s:9:\"sidebar-8\";a:0:{}}}}", "yes");
INSERT INTO `wp_options` VALUES("153", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("43909", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("110", "dashboard_widget_options", "a:4:{s:25:\"dashboard_recent_comments\";a:1:{s:5:\"items\";i:5;}s:24:\"dashboard_incoming_links\";a:5:{s:4:\"home\";s:33:\"http://barharbormanorhouse.com/wp\";s:4:\"link\";s:109:\"http://blogsearch.google.com/blogsearch?scoring=d&partner=wordpress&q=link:http://barharbormanorhouse.com/wp/\";s:3:\"url\";s:142:\"http://blogsearch.google.com/blogsearch_feeds?scoring=d&ie=utf-8&num=10&output=rss&partner=wordpress&q=link:http://barharbormanorhouse.com/wp/\";s:5:\"items\";i:10;s:9:\"show_date\";b:0;}s:17:\"dashboard_primary\";a:7:{s:4:\"link\";s:26:\"http://wordpress.org/news/\";s:3:\"url\";s:31:\"http://wordpress.org/news/feed/\";s:5:\"title\";s:14:\"WordPress Blog\";s:5:\"items\";i:2;s:12:\"show_summary\";i:1;s:11:\"show_author\";i:0;s:9:\"show_date\";i:1;}s:19:\"dashboard_secondary\";a:7:{s:4:\"link\";s:28:\"http://planet.wordpress.org/\";s:3:\"url\";s:33:\"http://planet.wordpress.org/feed/\";s:5:\"title\";s:20:\"Other WordPress News\";s:5:\"items\";i:5;s:12:\"show_summary\";i:0;s:11:\"show_author\";i:0;s:9:\"show_date\";i:0;}}", "yes");
INSERT INTO `wp_options` VALUES("320", "wp_ngg_pictures_8", "76", "yes");
INSERT INTO `wp_options` VALUES("321", "wp_ngg_pictures_9", "77", "yes");
INSERT INTO `wp_options` VALUES("322", "wp_ngg_pictures_10", "78", "yes");
INSERT INTO `wp_options` VALUES("323", "wp_ngg_pictures_11", "79", "yes");
INSERT INTO `wp_options` VALUES("324", "wp_ngg_pictures_12", "80", "yes");
INSERT INTO `wp_options` VALUES("325", "wp_ngg_pictures_13", "81", "yes");
INSERT INTO `wp_options` VALUES("326", "wp_ngg_pictures_14", "82", "yes");
INSERT INTO `wp_options` VALUES("327", "wp_ngg_pictures_15", "83", "yes");
INSERT INTO `wp_options` VALUES("328", "wp_ngg_pictures_16", "84", "yes");
INSERT INTO `wp_options` VALUES("329", "wp_ngg_pictures_17", "85", "yes");
INSERT INTO `wp_options` VALUES("330", "wp_ngg_pictures_18", "86", "yes");
INSERT INTO `wp_options` VALUES("331", "wp_ngg_pictures_19", "87", "yes");
INSERT INTO `wp_options` VALUES("332", "wp_ngg_pictures_20", "88", "yes");
INSERT INTO `wp_options` VALUES("333", "wp_ngg_pictures_21", "89", "yes");
INSERT INTO `wp_options` VALUES("334", "wp_ngg_pictures_22", "90", "yes");
INSERT INTO `wp_options` VALUES("292", "wp_flash_img_show", "a:1:{s:7:\"default\";a:7:{s:10:\"pic_number\";s:1:\"4\";s:10:\"autogetimg\";s:0:\"\";s:18:\"autogetimg_page_id\";i:0;s:23:\"autogetimg_page_descend\";s:0:\"\";s:25:\"autogetimg_page_shortcode\";s:4:\"true\";s:3:\"pic\";a:4:{i:1;a:3:{s:3:\"url\";s:84:\"http://barharbormanorhouse.com/wp/wp-content/plugins/wp-flash-img-show/images/01.jpg\";s:4:\"link\";s:16:\"http://xwjie.com\";s:11:\"description\";s:10:\"XWJie Home\";}i:2;a:3:{s:3:\"url\";s:84:\"http://barharbormanorhouse.com/wp/wp-content/plugins/wp-flash-img-show/images/02.jpg\";s:4:\"link\";s:24:\"http://xwjie.com/project\";s:11:\"description\";s:12:\"ore no imoto\";}i:3;a:3:{s:3:\"url\";s:84:\"http://barharbormanorhouse.com/wp/wp-content/plugins/wp-flash-img-show/images/03.jpg\";s:4:\"link\";s:26:\"http://xwjie.com/guestbook\";s:11:\"description\";s:10:\"some fruit\";}i:4;a:3:{s:3:\"url\";s:84:\"http://barharbormanorhouse.com/wp/wp-content/plugins/wp-flash-img-show/images/04.jpg\";s:4:\"link\";s:22:\"http://xwjie.com/about\";s:11:\"description\";s:12:\"strawberries\";}}s:6:\"option\";a:32:{s:29:\"wp_flash_img_show_roundcorner\";s:2:\"10\";s:30:\"wp_flash_img_show_autoplaytime\";s:1:\"3\";s:33:\"wp_flash_img_show_isheightquality\";s:4:\"true\";s:28:\"wp_flash_img_show_windowopen\";s:6:\"_blank\";s:30:\"wp_flash_img_show_btnsetmargin\";s:13:\"auto 5 5 auto\";s:29:\"wp_flash_img_show_btndistance\";s:2:\"20\";s:30:\"wp_flash_img_show_titlebgcolor\";s:8:\"0xff6600\";s:30:\"wp_flash_img_show_titlebgalpha\";s:4:\"0.75\";s:32:\"wp_flash_img_show_titletextcolor\";s:8:\"0xffffff\";s:27:\"wp_flash_img_show_titlefont\";s:6:\"TAHOMA\";s:35:\"wp_flash_img_show_titlemoveduration\";s:1:\"1\";s:26:\"wp_flash_img_show_btnalpha\";s:3:\"0.7\";s:30:\"wp_flash_img_show_btntextcolor\";s:8:\"0xffffff\";s:33:\"wp_flash_img_show_btndefaultcolor\";s:8:\"0x1B3433\";s:31:\"wp_flash_img_show_btnhovercolor\";s:8:\"0xff9900\";s:31:\"wp_flash_img_show_btnfocuscolor\";s:8:\"0xff6600\";s:32:\"wp_flash_img_show_changimagemode\";s:5:\"click\";s:27:\"wp_flash_img_show_isshowbtn\";s:4:\"true\";s:29:\"wp_flash_img_show_isshowtitle\";s:4:\"true\";s:27:\"wp_flash_img_show_scalemode\";s:7:\"noBorde\";s:27:\"wp_flash_img_show_transform\";s:5:\"alpha\";s:29:\"wp_flash_img_show_isshowabout\";s:4:\"true\";s:29:\"wp_flash_img_show_btnfontsize\";s:2:\"10\";s:26:\"wp_flash_img_show_btnwidth\";s:2:\"16\";s:27:\"wp_flash_img_show_btnheight\";s:2:\"16\";s:31:\"wp_flash_img_show_titlelocation\";s:3:\"top\";s:32:\"wp_flash_img_show_titlepositiony\";s:3:\"100\";s:31:\"wp_flash_img_show_titlebgheight\";s:2:\"24\";s:32:\"wp_flash_img_show_titletextalign\";s:6:\"center\";s:31:\"wp_flash_img_show_titlefontsize\";s:2:\"12\";s:23:\"wp_flash_img_show_width\";s:3:\"400\";s:24:\"wp_flash_img_show_height\";s:3:\"250\";}}}", "yes");
INSERT INTO `wp_options` VALUES("293", "wp_flash_img_show_info", "a:1:{s:7:\"version\";s:3:\"1.4\";}", "yes");
INSERT INTO `wp_options` VALUES("316", "wp_ngg_pictures_4", "72", "yes");
INSERT INTO `wp_options` VALUES("299", "photocrati_auto_update_admin_update_list", "", "yes");
INSERT INTO `wp_options` VALUES("300", "photocrati_auto_update_admin_check_date", "", "yes");
INSERT INTO `wp_options` VALUES("301", "ngg_db_version", "1.8.1", "yes");
INSERT INTO `wp_options` VALUES("302", "ngg_options", "a:88:{s:22:\"router_param_separator\";s:2:\"--\";s:19:\"router_param_prefix\";s:0:\"\";s:17:\"router_param_slug\";s:9:\"nggallery\";s:11:\"gallerypath\";s:19:\"wp-content/gallery/\";s:11:\"wpmuCSSfile\";s:13:\"nggallery.css\";s:9:\"wpmuStyle\";b:0;s:9:\"wpmuRoles\";b:0;s:16:\"wpmuImportFolder\";b:0;s:13:\"wpmuZipUpload\";b:0;s:17:\"datamapper_driver\";s:22:\"custom_post_datamapper\";s:21:\"gallerystorage_driver\";s:25:\"ngglegacy_gallery_storage\";s:20:\"maximum_entity_count\";i:500;s:9:\"deleteImg\";b:1;s:9:\"swfUpload\";b:1;s:13:\"usePermalinks\";b:0;s:13:\"permalinkSlug\";s:9:\"nggallery\";s:14:\"graphicLibrary\";s:2:\"gd\";s:14:\"imageMagickDir\";s:15:\"/usr/local/bin/\";s:11:\"useMediaRSS\";b:0;s:10:\"usePicLens\";b:0;s:12:\"activateTags\";i:0;s:10:\"appendType\";s:4:\"tags\";s:9:\"maxImages\";i:7;s:14:\"relatedHeading\";s:24:\"<h3>Related Images:</h3>\";s:10:\"thumbwidth\";i:120;s:11:\"thumbheight\";i:90;s:8:\"thumbfix\";b:1;s:12:\"thumbquality\";i:100;s:8:\"imgWidth\";i:800;s:9:\"imgHeight\";i:600;s:10:\"imgQuality\";i:100;s:9:\"imgBackup\";b:1;s:13:\"imgAutoResize\";b:0;s:9:\"galImages\";s:2:\"20\";s:17:\"galPagedGalleries\";i:0;s:10:\"galColumns\";i:0;s:12:\"galShowSlide\";b:1;s:12:\"galTextSlide\";s:16:\"[Show slideshow]\";s:14:\"galTextGallery\";s:17:\"[Show thumbnails]\";s:12:\"galShowOrder\";s:7:\"gallery\";s:7:\"galSort\";s:9:\"sortorder\";s:10:\"galSortDir\";s:3:\"ASC\";s:10:\"galNoPages\";b:1;s:13:\"galImgBrowser\";i:0;s:12:\"galHiddenImg\";i:0;s:10:\"galAjaxNav\";i:0;s:11:\"thumbEffect\";s:8:\"fancybox\";s:9:\"thumbCode\";s:41:\"class=\"ngg-fancybox\" rel=\"%GALLERY_NAME%\"\";s:18:\"thumbEffectContext\";s:14:\"nextgen_images\";s:5:\"wmPos\";s:8:\"botRight\";s:6:\"wmXpos\";i:5;s:6:\"wmYpos\";i:5;s:6:\"wmType\";i:0;s:6:\"wmPath\";s:0:\"\";s:6:\"wmFont\";s:9:\"arial.ttf\";s:6:\"wmSize\";i:10;s:6:\"wmText\";s:0:\"\";s:7:\"wmColor\";s:6:\"000000\";s:8:\"wmOpaque\";s:3:\"100\";s:8:\"enableIR\";i:0;s:7:\"slideFx\";s:4:\"fade\";s:5:\"irURL\";s:0:\"\";s:12:\"irXHTMLvalid\";i:0;s:7:\"irAudio\";s:0:\"\";s:7:\"irWidth\";i:600;s:8:\"irHeight\";i:400;s:9:\"irShuffle\";b:1;s:17:\"irLinkfromdisplay\";b:1;s:16:\"irShownavigation\";i:0;s:11:\"irShowicons\";i:0;s:11:\"irWatermark\";i:0;s:13:\"irOverstretch\";s:4:\"True\";s:12:\"irRotatetime\";i:10;s:12:\"irTransition\";s:6:\"random\";s:10:\"irKenburns\";i:0;s:11:\"irBackcolor\";s:6:\"000000\";s:12:\"irFrontcolor\";s:6:\"FFFFFF\";s:12:\"irLightcolor\";s:6:\"CC0000\";s:13:\"irScreencolor\";s:6:\"000000\";s:11:\"activateCSS\";i:1;s:7:\"CSSfile\";s:13:\"nggallery.css\";s:20:\"mvc_template_dirname\";s:10:\"/templates\";s:18:\"mvc_static_dirname\";s:7:\"/static\";s:23:\"dynamic_stylesheet_slug\";s:12:\"nextgen-dcss\";s:31:\"frame_communication_option_name\";s:14:\"X-Frame-Events\";s:22:\"dynamic_thumbnail_slug\";s:13:\"nextgen-image\";s:16:\"pope_module_list\";a:36:{s:18:\"photocrati-nextgen\";s:25:\"photocrati-nextgen|2.0.40\";s:13:\"photocrati-fs\";s:17:\"photocrati-fs|0.2\";s:21:\"photocrati-validation\";s:25:\"photocrati-validation|0.1\";s:17:\"photocrati-router\";s:21:\"photocrati-router|0.4\";s:28:\"photocrati-wordpress_routing\";s:32:\"photocrati-wordpress_routing|0.3\";s:19:\"photocrati-security\";s:23:\"photocrati-security|0.2\";s:14:\"photocrati-lzw\";s:18:\"photocrati-lzw|0.1\";s:27:\"photocrati-nextgen_settings\";s:31:\"photocrati-nextgen_settings|0.3\";s:14:\"photocrati-mvc\";s:18:\"photocrati-mvc|0.4\";s:15:\"photocrati-ajax\";s:19:\"photocrati-ajax|0.5\";s:29:\"photocrati-dynamic_stylesheet\";s:33:\"photocrati-dynamic_stylesheet|0.3\";s:30:\"photocrati-frame_communication\";s:34:\"photocrati-frame_communication|0.3\";s:21:\"photocrati-datamapper\";s:25:\"photocrati-datamapper|0.4\";s:25:\"photocrati-nextgen-legacy\";s:29:\"photocrati-nextgen-legacy|0.3\";s:23:\"photocrati-nextgen-data\";s:27:\"photocrati-nextgen-data|0.4\";s:29:\"photocrati-dynamic_thumbnails\";s:33:\"photocrati-dynamic_thumbnails|0.4\";s:24:\"photocrati-nextgen_admin\";s:28:\"photocrati-nextgen_admin|0.5\";s:34:\"photocrati-nextgen_addgallery_page\";s:38:\"photocrati-nextgen_addgallery_page|0.3\";s:29:\"photocrati-nextgen_pagination\";s:33:\"photocrati-nextgen_pagination|0.1\";s:26:\"photocrati-simple_html_dom\";s:30:\"photocrati-simple_html_dom|1.5\";s:34:\"photocrati-nextgen_gallery_display\";s:38:\"photocrati-nextgen_gallery_display|0.7\";s:25:\"photocrati-attach_to_post\";s:29:\"photocrati-attach_to_post|0.8\";s:32:\"photocrati-nextgen_other_options\";s:36:\"photocrati-nextgen_other_options|0.5\";s:30:\"photocrati-nextgen_pro_upgrade\";s:34:\"photocrati-nextgen_pro_upgrade|0.1\";s:19:\"photocrati-mediarss\";s:23:\"photocrati-mediarss|0.2\";s:16:\"photocrati-cache\";s:20:\"photocrati-cache|0.2\";s:19:\"photocrati-lightbox\";s:23:\"photocrati-lightbox|0.5\";s:30:\"photocrati-nextgen_basic_album\";s:34:\"photocrati-nextgen_basic_album|0.5\";s:34:\"photocrati-nextgen_basic_templates\";s:38:\"photocrati-nextgen_basic_templates|0.2\";s:32:\"photocrati-nextgen_basic_gallery\";s:36:\"photocrati-nextgen_basic_gallery|0.7\";s:37:\"photocrati-nextgen_basic_imagebrowser\";s:41:\"photocrati-nextgen_basic_imagebrowser|0.5\";s:34:\"photocrati-nextgen_basic_singlepic\";s:38:\"photocrati-nextgen_basic_singlepic|0.5\";s:33:\"photocrati-nextgen_basic_tagcloud\";s:37:\"photocrati-nextgen_basic_tagcloud|0.5\";s:17:\"photocrati-widget\";s:21:\"photocrati-widget|0.3\";s:29:\"photocrati-third_party_compat\";s:33:\"photocrati-third_party_compat|0.1\";s:25:\"photocrati-nextgen_xmlrpc\";s:29:\"photocrati-nextgen_xmlrpc|0.2\";}s:11:\"installDate\";i:1393534653;}", "yes");
INSERT INTO `wp_options` VALUES("312", "wp_ngg_gallery_1", "68", "yes");
INSERT INTO `wp_options` VALUES("313", "wp_ngg_pictures_1", "69", "yes");
INSERT INTO `wp_options` VALUES("314", "wp_ngg_pictures_2", "70", "yes");
INSERT INTO `wp_options` VALUES("315", "wp_ngg_pictures_3", "71", "yes");
INSERT INTO `wp_options` VALUES("287", "widget_creativeclans_slideshow_version", "1.3.4", "yes");
INSERT INTO `wp_options` VALUES("146", "db_upgraded", "", "yes");
INSERT INTO `wp_options` VALUES("159", "recently_activated", "a:1:{s:53:\"velvet-blues-update-urls/velvet-blues-update-urls.php\";i:1607020765;}", "yes");
INSERT INTO `wp_options` VALUES("41890", "jqlb_show_download", "0", "yes");
INSERT INTO `wp_options` VALUES("41891", "jqlb_navbarOnTop", "0", "yes");
INSERT INTO `wp_options` VALUES("41892", "jqlb_resize_speed", "400", "yes");
INSERT INTO `wp_options` VALUES("188", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("189", "wrksettings", "a:1:{s:7:\"dataown\";i:77005;}", "yes");
INSERT INTO `wp_options` VALUES("193", "theme_mods_tempera", "a:10:{i:0;b:0;s:16:\"background_color\";s:6:\"fdfde3\";s:16:\"background_image\";s:0:\"\";s:17:\"background_repeat\";s:6:\"repeat\";s:21:\"background_position_x\";s:4:\"left\";s:21:\"background_attachment\";s:5:\"fixed\";s:18:\"nav_menu_locations\";a:3:{s:7:\"primary\";i:0;s:3:\"top\";i:0;s:6:\"footer\";i:0;}s:12:\"header_image\";s:71:\"http://barharbormanorhouse.com/wp/wp-content/uploads/2014/02/banner.jpg\";s:17:\"header_image_data\";O:8:\"stdClass\":5:{s:13:\"attachment_id\";i:10;s:3:\"url\";s:71:\"http://barharbormanorhouse.com/wp/wp-content/uploads/2014/02/banner.jpg\";s:13:\"thumbnail_url\";s:71:\"http://barharbormanorhouse.com/wp/wp-content/uploads/2014/02/banner.jpg\";s:6:\"height\";i:120;s:5:\"width\";i:1150;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1427764308;s:4:\"data\";a:11:{s:19:\"wp_inactive_widgets\";a:4:{i:0;s:6:\"text-2\";i:1;s:6:\"text-3\";i:2;s:16:\"columns_widget-2\";i:3;s:16:\"columns_widget-3\";}s:16:\"left-widget-area\";a:4:{i:0;s:8:\"search-2\";i:1;s:10:\"archives-2\";i:2;s:12:\"categories-2\";i:3;s:6:\"meta-2\";}s:17:\"right-widget-area\";a:0:{}s:24:\"first-footer-widget-area\";a:0:{}s:25:\"second-footer-widget-area\";a:0:{}s:24:\"third-footer-widget-area\";a:0:{}s:25:\"fourth-footer-widget-area\";a:0:{}s:25:\"above-content-widget-area\";a:0:{}s:25:\"below-content-widget-area\";a:0:{}s:18:\"header-widget-area\";a:0:{}s:30:\"presentation-page-columns-area\";a:0:{}}}}", "yes");
INSERT INTO `wp_options` VALUES("19009", "WPLANG", "", "yes");
INSERT INTO `wp_options` VALUES("198", "tempera_settings", "a:225:{s:12:\"tempera_side\";s:4:\"2cSr\";s:17:\"tempera_sidewidth\";i:900;s:15:\"tempera_sidebar\";i:250;s:22:\"tempera_magazinelayout\";s:7:\"Disable\";s:14:\"tempera_mobile\";s:6:\"Enable\";s:12:\"tempera_zoom\";i:1;s:15:\"tempera_hheight\";i:200;s:15:\"tempera_hcenter\";i:1;s:14:\"tempera_hratio\";i:1;s:18:\"tempera_siteheader\";s:26:\"Site Title and Description\";s:18:\"tempera_logoupload\";s:0:\"\";s:23:\"tempera_headermargintop\";i:5;s:24:\"tempera_headermarginleft\";i:0;s:15:\"tempera_favicon\";s:0:\"\";s:25:\"tempera_headerwidgetwidth\";s:3:\"33%\";s:17:\"tempera_frontpage\";s:6:\"Enable\";s:18:\"tempera_frontposts\";s:7:\"Disable\";s:23:\"tempera_frontpostscount\";i:10;s:24:\"tempera_frontpostsperrow\";i:2;s:22:\"tempera_frontmoreposts\";s:10:\"More Posts\";s:21:\"tempera_fpsliderwidth\";i:1150;s:22:\"tempera_fpsliderheight\";i:450;s:20:\"tempera_fpslideranim\";s:4:\"fade\";s:20:\"tempera_fpslidertime\";i:750;s:21:\"tempera_fpsliderpause\";i:4500;s:19:\"tempera_fpslidernav\";s:7:\"Numbers\";s:22:\"tempera_fpsliderarrows\";s:16:\"Visible on Hover\";s:27:\"tempera_fpslider_bordersize\";i:0;s:26:\"tempera_fpslider_topmargin\";i:0;s:17:\"tempera_slideType\";s:13:\"Custom Slides\";s:22:\"tempera_slideShortcode\";s:0:\"\";s:21:\"tempera_slideSpecific\";s:0:\"\";s:18:\"tempera_slideCateg\";s:0:\"\";s:19:\"tempera_slideNumber\";i:5;s:18:\"tempera_sliderimg1\";s:71:\"https://www.econolodgeloon.com/wp-content/uploads/slidefrontandsign.jpg\";s:20:\"tempera_slidertitle1\";s:0:\"\";s:19:\"tempera_slidertext1\";s:188:\"Welcome to the Econo Lodge Inn &amp; Suites in Lincoln, NH. We are in the Loon, Franconia Notch area, near dozens of attractions, skiing, shops, hiking and much more. We are open all year.\";s:19:\"tempera_sliderlink1\";s:0:\"\";s:18:\"tempera_sliderimg2\";s:73:\"https://www.econolodgeloon.com/wp-content/uploads/slidehottubandpool1.jpg\";s:20:\"tempera_slidertitle2\";s:0:\"\";s:19:\"tempera_slidertext2\";s:159:\"Enjoy our large indoor heated pool and hot tub all year! This is a great White Mountains NH Location for relaxing, hiking, attractions, skiing or any activity.\";s:19:\"tempera_sliderlink2\";s:0:\"\";s:18:\"tempera_sliderimg3\";s:74:\"https://www.econolodgeloon.com/wp-content/uploads/slidegazeboandchairs.jpg\";s:20:\"tempera_slidertitle3\";s:0:\"\";s:19:\"tempera_slidertext3\";s:174:\"Enjoy mountain views and easy access to a wide variety of year round attractions.We offer beautiful, newly renovated guest rooms, Jacuzzi rooms, cottages and a vacation home.\";s:19:\"tempera_sliderlink3\";s:0:\"\";s:18:\"tempera_sliderimg4\";s:69:\"https://www.econolodgeloon.com/wp-content/uploads/slideguestrooms.jpg\";s:20:\"tempera_slidertitle4\";s:0:\"\";s:19:\"tempera_slidertext4\";s:93:\"We offer beautiful, newly renovated guest rooms, Jacuzzi rooms, cottages and a vacation home.\";s:19:\"tempera_sliderlink4\";s:0:\"\";s:18:\"tempera_sliderimg5\";s:77:\"https://www.econolodgeloon.com/wp-content/uploads/slidechairsmountainview.jpg\";s:20:\"tempera_slidertitle5\";s:0:\"\";s:19:\"tempera_slidertext5\";s:38:\"Relax And Enjoy. We Are Open All Year.\";s:19:\"tempera_sliderlink5\";s:0:\"\";s:18:\"tempera_columnType\";s:8:\"Disabled\";s:22:\"tempera_columnSpecific\";s:0:\"\";s:19:\"tempera_columnCateg\";s:0:\"\";s:20:\"tempera_columnNumber\";i:3;s:18:\"tempera_coldisplay\";i:0;s:17:\"tempera_nrcolumns\";i:3;s:22:\"tempera_colimageheight\";i:201;s:21:\"tempera_colimagewidth\";i:318;s:22:\"tempera_columnreadmore\";s:9:\"Read more\";s:18:\"tempera_fronttext1\";s:96:\"Econolodge Inn &amp; Suites • A Lincoln NH Lodging Near White Mountains Attractions And Skiing\";s:18:\"tempera_fronttext3\";s:1171:\"Spectacular mountain location and superb amenities make the EconoLodge Inn &amp; Suites of Lincoln, NH the very best choice for your lodging in the White Mountains Region. We are centrally located among all major White Mountain attractions. The best value for your hard-earned dollar is here. We are a AAA approved family motel conveniently located just off I-93 at Exit 33!<br> \r\n\r\n<p style=\"text-align:center\"><a href=\"https://www.econolodgeloon.com/loon-mountain-nh-hotel-motel-virtual-video-tour/\"><img src=\"https://www.econolodgeloon.com/wp-content/uploads/virtualtouricon-econolodge.jpg\" width=\"“226”\" height=\"“137”\" border=\"0\" /></a><br> \r\n\r\n<p style=\"text-align:left\">Start your day off with hot coffee, cocoa, juice, egg and sausage sandwiches, waffles, pastries, cereals and more! Our deluxe continental breakfast is complimentary every day of your stay! Enjoy a copy of our complimentary USA Today newspaper and don’t hesitate to ask our friendly staff for information on area events and happenings!  For those wishing to check their e-mail accounts or weather conditions, bring your laptop and enjoy complimentary Wi-Fi that stretches to every room!\";s:18:\"tempera_fronttext2\";s:112:\"Great Lincoln White Mountains NH Family Motel Amenities • Swimming Pool, Sauna, Breakfast &amp; Great Location\";s:18:\"tempera_fronttext4\";s:508:\"End your long day full of activities in our muscle-relaxing Jacuzzi and hot Sauna, or take a swim in our warm heated indoor pool.  We offer Double Bed Rooms, King Bed Rooms, Jacuzzi Rooms and Suites, and all featuring our expansive amenity offerings such as Cable TV, Free Local Calls, Micro Fridges in every room  and on site Guest Laundry Facilities. At the EconoLodge Inn &amp; Suites, we combine warm mountain hospitality with high, brand name standards. Call 800-762-7275 today and we’ll see you soon!\";s:16:\"tempera_fontsize\";s:4:\"16px\";s:18:\"tempera_fontfamily\";s:10:\"Droid Sans\";s:18:\"tempera_googlefont\";s:0:\"\";s:20:\"tempera_headfontsize\";s:4:\"24px\";s:17:\"tempera_fonttitle\";s:10:\"Droid Sans\";s:23:\"tempera_googlefonttitle\";s:0:\"\";s:20:\"tempera_sidefontsize\";s:4:\"18px\";s:16:\"tempera_fontside\";s:15:\"Open Sans Light\";s:22:\"tempera_googlefontside\";s:0:\"\";s:21:\"tempera_sitetitlesize\";s:4:\"38px\";s:21:\"tempera_sitetitlefont\";s:25:\"Yanone Kaffeesatz Regular\";s:27:\"tempera_sitetitlegooglefont\";s:0:\"\";s:20:\"tempera_menufontsize\";s:4:\"14px\";s:16:\"tempera_menufont\";s:6:\"Ubuntu\";s:22:\"tempera_menugooglefont\";s:0:\"\";s:24:\"tempera_headingsfontsize\";s:3:\"70%\";s:20:\"tempera_headingsfont\";s:10:\"Droid Sans\";s:26:\"tempera_headingsgooglefont\";s:0:\"\";s:17:\"tempera_textalign\";s:7:\"Default\";s:22:\"tempera_paragraphspace\";s:5:\"1.0em\";s:17:\"tempera_parindent\";s:3:\"0px\";s:22:\"tempera_headingsindent\";s:7:\"Disable\";s:18:\"tempera_lineheight\";s:3:\"1.7\";s:17:\"tempera_wordspace\";s:7:\"Default\";s:21:\"tempera_uppercasetext\";i:0;s:23:\"tempera_backcolorheader\";s:0:\"\";s:21:\"tempera_backcolormain\";s:7:\"#ffffff\";s:24:\"tempera_backcolorfooterw\";s:0:\"\";s:23:\"tempera_backcolorfooter\";s:7:\"#F7F7F7\";s:23:\"tempera_contentcolortxt\";s:7:\"#444444\";s:28:\"tempera_contentcolortxtlight\";s:7:\"#999999\";s:22:\"tempera_footercolortxt\";s:7:\"#AAAAAA\";s:20:\"tempera_accentcolora\";s:7:\"#1693A5\";s:20:\"tempera_accentcolorb\";s:7:\"#D6341D\";s:20:\"tempera_accentcolorc\";s:7:\"#EEEEEE\";s:20:\"tempera_accentcolord\";s:7:\"#CCCCCC\";s:20:\"tempera_accentcolore\";s:7:\"#F7F7F7\";s:21:\"tempera_descriptionbg\";s:0:\"\";s:18:\"tempera_titlecolor\";s:7:\"#1693A5\";s:24:\"tempera_descriptioncolor\";s:7:\"#999999\";s:26:\"tempera_menucolorbgdefault\";s:7:\"#da0025\";s:27:\"tempera_menucolortxtdefault\";s:7:\"#ffffff\";s:29:\"tempera_submenucolorbgdefault\";s:7:\"#8f3927\";s:30:\"tempera_submenucolortxtdefault\";s:7:\"#ffffff\";s:26:\"tempera_submenucolorshadow\";s:0:\"\";s:21:\"tempera_topbarcolorbg\";s:7:\"#000000\";s:23:\"tempera_topmenucolortxt\";s:7:\"#CCCCCC\";s:28:\"tempera_topmenucolortxthover\";s:7:\"#EEEEEE\";s:22:\"tempera_contentcolorbg\";s:7:\"#FFFFFF\";s:28:\"tempera_contentcolortxttitle\";s:7:\"#444444\";s:33:\"tempera_contentcolortxttitlehover\";s:7:\"#000000\";s:31:\"tempera_contentcolortxtheadings\";s:7:\"#444444\";s:23:\"tempera_fronttitlecolor\";s:7:\"#444444\";s:27:\"tempera_fpsliderbordercolor\";s:7:\"#ffffff\";s:28:\"tempera_fpslidercaptioncolor\";s:7:\"#ffffff\";s:25:\"tempera_fpslidercaptionbg\";s:7:\"#000000\";s:14:\"tempera_sidebg\";s:0:\"\";s:19:\"tempera_sidetitlebg\";s:7:\"#F7F7F7\";s:15:\"tempera_sidetxt\";s:7:\"#333333\";s:20:\"tempera_sidetitletxt\";s:7:\"#666666\";s:16:\"tempera_widgetbg\";s:0:\"\";s:21:\"tempera_widgettitlebg\";s:7:\"#F7F7F7\";s:17:\"tempera_widgettxt\";s:7:\"#333333\";s:22:\"tempera_widgettitletxt\";s:7:\"#666666\";s:21:\"tempera_linkcolortext\";s:7:\"#1693A5\";s:22:\"tempera_linkcolorhover\";s:7:\"#D6341D\";s:21:\"tempera_linkcolorside\";s:0:\"\";s:26:\"tempera_linkcolorsidehover\";s:0:\"\";s:23:\"tempera_linkcolorwooter\";s:0:\"\";s:28:\"tempera_linkcolorwooterhover\";s:0:\"\";s:23:\"tempera_linkcolorfooter\";s:0:\"\";s:28:\"tempera_linkcolorfooterhover\";s:0:\"\";s:22:\"tempera_metacoloricons\";s:7:\"#CCCCCC\";s:22:\"tempera_metacolorlinks\";s:7:\"#666666\";s:27:\"tempera_metacolorlinkshover\";s:0:\"\";s:21:\"tempera_socialcolorbg\";s:7:\"#1693A5\";s:26:\"tempera_socialcolorbghover\";s:7:\"#D6341D\";s:15:\"tempera_caption\";s:12:\"caption-dark\";s:14:\"tempera_topbar\";s:4:\"Hide\";s:19:\"tempera_topbarwidth\";s:10:\"Site width\";s:19:\"tempera_breadcrumbs\";s:7:\"Disable\";s:18:\"tempera_pagination\";s:7:\"Disable\";s:17:\"tempera_menualign\";s:6:\"center\";s:24:\"tempera_contentmargintop\";i:2;s:22:\"tempera_contentpadding\";i:30;s:19:\"tempera_image_style\";s:18:\"tempera-image-none\";s:19:\"tempera_contentlist\";s:4:\"Show\";s:17:\"tempera_pagetitle\";s:4:\"Hide\";s:18:\"tempera_categtitle\";s:4:\"Hide\";s:14:\"tempera_tables\";s:7:\"Disable\";s:15:\"tempera_backtop\";s:6:\"Enable\";s:15:\"tempera_metapos\";s:6:\"Bottom\";s:19:\"tempera_single_show\";a:6:{s:6:\"author\";i:1;s:4:\"date\";i:1;s:8:\"category\";i:1;s:3:\"tag\";i:1;s:8:\"bookmark\";i:1;s:4:\"time\";i:0;}s:15:\"tempera_comtext\";s:4:\"Show\";s:17:\"tempera_comclosed\";s:15:\"Hide everywhere\";s:14:\"tempera_comoff\";s:4:\"Show\";s:19:\"tempera_excerpthome\";s:7:\"Excerpt\";s:21:\"tempera_excerptsticky\";s:9:\"Full Post\";s:22:\"tempera_excerptarchive\";s:7:\"Excerpt\";s:20:\"tempera_excerptwords\";i:50;s:19:\"tempera_excerptdots\";s:3:\"…\";s:19:\"tempera_excerptcont\";s:16:\"Continue reading\";s:13:\"tempera_fpost\";s:6:\"Enable\";s:17:\"tempera_fpostlink\";i:1;s:13:\"tempera_fauto\";s:6:\"Enable\";s:14:\"tempera_falign\";s:4:\"Left\";s:14:\"tempera_fwidth\";i:250;s:15:\"tempera_fheight\";i:150;s:13:\"tempera_fcrop\";i:1;s:15:\"tempera_fheader\";s:7:\"Disable\";s:15:\"tempera_social1\";s:8:\"Facebook\";s:15:\"tempera_social2\";s:32:\"https://www.facebook.com/ELNH032\";s:22:\"tempera_social_target1\";i:1;s:21:\"tempera_social_title1\";s:8:\"Facebook\";s:15:\"tempera_social3\";s:8:\"Facebook\";s:15:\"tempera_social4\";s:0:\"\";s:21:\"tempera_social_title3\";s:0:\"\";s:15:\"tempera_social5\";s:3:\"RSS\";s:15:\"tempera_social6\";s:0:\"\";s:21:\"tempera_social_title5\";s:0:\"\";s:15:\"tempera_social7\";s:7:\"AboutMe\";s:15:\"tempera_social8\";s:0:\"\";s:21:\"tempera_social_title7\";s:0:\"\";s:15:\"tempera_social9\";s:7:\"AboutMe\";s:16:\"tempera_social10\";s:0:\"\";s:21:\"tempera_social_title9\";s:0:\"\";s:23:\"tempera_socialsdisplay5\";i:1;s:16:\"tempera_iecompat\";i:0;s:26:\"tempera_current_admin_menu\";i:5;s:17:\"tempera_postboxes\";s:5:\"Array\";s:15:\"tempera_fitvids\";i:1;s:19:\"tempera_editorstyle\";i:1;s:17:\"tempera_copyright\";s:131:\"<b>Econolodge Inn &amp; Suites Loon Mountain Area • 381 US Route 3 • Lincoln, New Hampshire 03251 • Toll Free: 1-800-762-7275\";s:17:\"tempera_customcss\";s:467:\"/* Tempera Custom CSS */ \r\n\r\n.footermenu, .footermenu + span {\r\ndisplay: table !important; float: none !important; margin: 0 auto !important;\r\n} \r\n\r\n#branding #header-container { position: relative; }\r\n#branding #bg_image + #header-container { position: absolute; } \r\n\r\n/* Tempera Custom CSS */\r\n#access {\r\ndisplay: block;\r\nfloat: left;\r\nmargin: 1px auto 0;\r\nwidth:100%;\r\n}\r\n\r\n#main {\r\nclear: both;\r\npadding: 0px;\r\nmargin-top: 2px;\r\n} \r\n\r\n#access { margin-top: 2px; }\";s:16:\"tempera_customjs\";s:0:\"\";s:14:\"tempera_submit\";s:12:\"Save Changes\";s:22:\"tempera_social_target3\";s:1:\"0\";s:22:\"tempera_social_target5\";s:1:\"0\";s:22:\"tempera_social_target7\";s:1:\"0\";s:22:\"tempera_social_target9\";s:1:\"0\";s:23:\"tempera_socialsdisplay0\";s:1:\"0\";s:23:\"tempera_socialsdisplay1\";s:1:\"0\";s:23:\"tempera_socialsdisplay2\";s:1:\"0\";s:23:\"tempera_socialsdisplay3\";s:1:\"0\";s:23:\"tempera_socialsdisplay4\";s:1:\"0\";s:17:\"tempera_searchbar\";a:3:{s:3:\"top\";i:0;s:4:\"main\";i:0;s:6:\"footer\";i:0;}s:17:\"tempera_blog_show\";a:6:{s:6:\"author\";i:0;s:4:\"date\";i:0;s:4:\"time\";i:0;s:8:\"category\";i:0;s:3:\"tag\";i:0;s:8:\"comments\";i:0;}s:10:\"tempera_db\";s:0:\"\";s:16:\"tempera_hcontain\";s:0:\"\";s:23:\"tempera_fronthideheader\";s:0:\"\";s:21:\"tempera_fronthidemenu\";s:0:\"\";s:23:\"tempera_fronthidewidget\";s:0:\"\";s:23:\"tempera_fronthidefooter\";s:0:\"\";s:21:\"tempera_fronthideback\";s:0:\"\";s:19:\"tempera_letterspace\";s:0:\"\";s:20:\"tempera_colorschemes\";s:0:\"\";s:13:\"tempera_title\";s:0:\"\";s:19:\"tempera_excerpttags\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("136120", "wpseo-gsc-refresh_token", "1/4deINKlJQFS7M6A-qXXwD0jfZXr-93LZqinxneE0de4nL_HMfW4D5UvzRIiUtRFG", "yes");
INSERT INTO `wp_options` VALUES("136121", "wpseo-gsc-access_token", "a:5:{s:13:\"refresh_token\";s:66:\"1/4deINKlJQFS7M6A-qXXwD0jfZXr-93LZqinxneE0de4nL_HMfW4D5UvzRIiUtRFG\";s:12:\"access_token\";s:132:\"ya29.Gl01BgQyIzHfaACEc4hLUl7eV7y7Zqn4DGSTc2J1wANc0fAhrCCiogRVJxZljPvO8H3QLRU2TeF50l11rtQtjtMlY88H2W_3mXn9qou3-HiYXmDH_2_02jhr5FpSDoA\";s:7:\"expires\";d:1539453474;s:10:\"expires_in\";i:3600;s:7:\"created\";i:1539464274;}", "yes");
INSERT INTO `wp_options` VALUES("251", "theme_mods_tempera-nocopyrt", "a:10:{i:0;b:0;s:16:\"background_color\";s:6:\"ededed\";s:16:\"background_image\";s:0:\"\";s:17:\"background_repeat\";s:6:\"repeat\";s:21:\"background_position_x\";s:4:\"left\";s:21:\"background_attachment\";s:5:\"fixed\";s:18:\"nav_menu_locations\";a:3:{s:7:\"primary\";i:2;s:3:\"top\";i:0;s:6:\"footer\";i:2;}s:18:\"custom_css_post_id\";i:-1;s:12:\"header_image\";s:72:\"https://www.econolodgeloon.com/wp-content/uploads/econolodgebanner-2.jpg\";s:17:\"header_image_data\";O:8:\"stdClass\":5:{s:13:\"attachment_id\";i:3412;s:3:\"url\";s:72:\"https://www.econolodgeloon.com/wp-content/uploads/econolodgebanner-2.jpg\";s:13:\"thumbnail_url\";s:72:\"https://www.econolodgeloon.com/wp-content/uploads/econolodgebanner-2.jpg\";s:6:\"height\";i:200;s:5:\"width\";i:1150;}}", "yes");
INSERT INTO `wp_options` VALUES("288", "widget_creativeclans_slideshow", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("317", "wp_ngg_pictures_5", "73", "yes");
INSERT INTO `wp_options` VALUES("318", "wp_ngg_pictures_6", "74", "yes");
INSERT INTO `wp_options` VALUES("319", "wp_ngg_pictures_7", "75", "yes");
INSERT INTO `wp_options` VALUES("482", "easy_gallery_db_version", "1.1", "yes");
INSERT INTO `wp_options` VALUES("483", "wp_easy_gallery_defaults", "a:9:{s:7:\"version\";s:5:\"3.6.2\";s:15:\"thumbnail_width\";s:4:\"auto\";s:16:\"thumbnail_height\";s:4:\"auto\";s:12:\"hide_overlay\";s:5:\"false\";s:11:\"hide_social\";s:5:\"false\";s:12:\"custom_style\";s:0:\"\";s:17:\"use_default_style\";s:4:\"true\";s:13:\"editor_access\";s:5:\"false\";i:1;a:7:{s:15:\"thumbnail_width\";s:3:\"300\";s:16:\"thumbnail_height\";s:3:\"175\";s:12:\"hide_overlay\";s:5:\"false\";s:11:\"hide_social\";s:4:\"true\";s:13:\"editor_access\";s:5:\"false\";s:12:\"custom_style\";s:0:\"\";s:17:\"use_default_style\";s:4:\"true\";}}", "yes");
INSERT INTO `wp_options` VALUES("504", "emediagallery_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("380", "ngg_cache_971b618ce72727d7647d3b957ba5714b", "1393539540", "yes");
INSERT INTO `wp_options` VALUES("417", "displayed_gallery_rendering_35bfe32ef7743fcf97c7e531364010a1", "1393543433", "yes");
INSERT INTO `wp_options` VALUES("420", "displayed_gallery_rendering_9b6abeaaa054b494e314dbc388cc0205", "1393543455", "yes");
INSERT INTO `wp_options` VALUES("423", "displayed_gallery_rendering_d99291efc4a27d160232225a91945883", "1393543455", "yes");
INSERT INTO `wp_options` VALUES("508", "portfolio_slideshow_options", "a:30:{s:4:\"size\";s:9:\"thumbnail\";s:5:\"trans\";s:4:\"fade\";s:5:\"speed\";s:3:\"600\";s:10:\"showtitles\";s:4:\"true\";s:8:\"showcaps\";s:4:\"true\";s:8:\"showdesc\";s:4:\"true\";s:10:\"allowfluid\";s:4:\"true\";s:7:\"timeout\";s:4:\"4000\";s:8:\"autoplay\";s:4:\"true\";s:10:\"showloader\";s:4:\"true\";s:4:\"loop\";s:4:\"true\";s:5:\"click\";s:7:\"advance\";s:12:\"click_target\";s:6:\"_blank\";s:6:\"navpos\";s:3:\"top\";s:8:\"pagerpos\";s:3:\"top\";s:6:\"jquery\";s:2:\"wp\";s:5:\"cycle\";s:4:\"true\";s:5:\"debug\";s:4:\"true\";s:7:\"version\";s:5:\"1.5.1\";s:8:\"centered\";s:5:\"false\";s:6:\"random\";s:5:\"false\";s:16:\"exclude_featured\";s:5:\"false\";s:8:\"showhash\";s:5:\"false\";s:12:\"togglethumbs\";s:5:\"false\";s:8:\"showplay\";s:5:\"false\";s:8:\"showinfo\";s:5:\"false\";s:10:\"touchswipe\";s:5:\"false\";s:11:\"keyboardnav\";s:5:\"false\";s:8:\"carousel\";s:5:\"false\";s:8:\"fancybox\";s:5:\"false\";}", "yes");
INSERT INTO `wp_options` VALUES("470", "emg-notifier-cache", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<notifier>\n<latest>1.3.1.3</latest>\n\n\n<updateinstruct>\n<![CDATA[\n\n<h3>Update instructions for version 1.3.0.0 and below</h3>\n			<p style=\"color:#F00;\"><strong>ATTENTION! Do not uninstall from wordpress dashboard, follow the instructions below.</strong></p>\n		    <ol>\n			<li><strong>Please note:</strong> make a <strong>backup</strong> of the Plugin inside your WordPress installation folder <strong>/wp-content/plugins/easy-media-gallery/</strong></li>\n		    <li>Make sure you have sent an email to <strong>update@ghozylab.com</strong> for request the latest updates link download. Login to your email and re-download the plugin that we send to you.</li>\n		    <li>Extract the zip\'s contents, within the unzipped folder you will see a file named <strong>easy-media-gallery.zip</strong> – this is the plugin itself, and after you have all the new files upload them using FTP to the <strong>/wp-content/plugins/easy-media-gallery/</strong> folder overwriting the old ones (this is why it\'s important to backup any changes you\'ve made to the plugin files).</li>\n		    <li>If you didn\'t make any changes to the plugin files, you are free to overwrite them with the new ones without the risk of losing plugin settings, pages, posts, etc, and backwards compatibility is guaranteed.</li></ol>\n<br />\n<h3>Update instructions for version 1.3.1.1 and above</h3>\n<ol>\n<li>Make sure you have sent an email to <strong>update@ghozylab.com</strong> for request the latest updates link download. Login to your email and re-download the plugin that we send to you.</li>\n<li>Check your junk/spam/bulk mail folder. Download the ZIP package and Unzip it, within the unzipped folder you will see a file named <strong>easy-media-gallery.zip</strong> – this is the plugin itself.</li>\n<li>From wordpress left panel  click Easy Media > Settings > Miscellaneous > then switch ON <strong>Keep data when uninstall/update</strong> option.</li>\n<li>From wordpress left panel  click plugins > installed plugins > then Deactivate Easy media gallery, after that click Delete.</li>\n<li>Click plugins again, then click Add New > Upload > then upload the file that you extracted before (<strong>easy-media-gallery.zip</strong>). Please wait a moment, you should see a message stating that the plugin was installed successfully, after the plugin has installed click on activate the plugin.</li>\n<li>Finally, click Easy Media > Settings and click <strong>Save Changes</strong>.</li>\n</ol>\n\n<p>You can follow the steps above from this video : <a target=\"_blank\" href=\"http://www.youtube.com/watch?v=sj-eEgtDwFA\">How to Update Easy Media Gallery</a></p>\n\n]]>\n</updateinstruct>\n\n<changelog>\n<![CDATA[\n\n<h4><strong>v1.3.1.3</strong> Add New Features 3/20/2013</h4>\n            <ol>\n			<li><span style=\"font-weight:bold; color:#F00;\">NEW</span> : Soundcloud and Reverbnation Embed</li>\n            <li><span style=\"font-weight:bold; color:#F00;\">NEW</span> : Use information of each image (Gallery Option). This option allow you to use different title and description for each image.Learn more <a target=\"_blank\" href=\"http://youtu.be/BWmWAPb_z90\"> HERE</a></li>\n            <li><span style=\"font-weight:bold; color:#F00;\">NEW</span> : Keep Data Option, this option will keep all plugin data and settings before you uninstall for update this plugin. So you no need to update with complicated way. Learn more <a target=\"_blank\" href=\"http://youtu.be/sj-eEgtDwFA\"> HERE</a></li>\n			<li>Removed the use of PHP function getimagesize()</li>	\n<li>Replace file_get_contents() PHP function with cURL</li>\n			<li>Fixed: Remove HTML tag on social media content</li>\n		    <li>Update tutorials</li>\n            <li>Many other code clean and optimization</li>															\n            </ol>\n		\n<h4><strong>v1.3.0.0</strong> Forward-Compatibility Upgrade 3/11/2013</h4>\n            <ol>\n	    <li>Fixed: PHP warning in the tinymce-dlg.php file</li>\n            <li>Fixed: Hover effect not works on several themes</li>\n            <li>Fixed: Only display 10 media, although we have determined more than 10. Now you can put unlimited media</li>\n            <li>Fixed: Title was given wrong position by CSS</li>\n            <li>Added jQuery 1.9 compatibility (will be required for WordPress 3.6)</li>\n            <li>Fixed: Theme\'s that set image heights affected the media image dimensions.</li>	\n            <li>Updated Timthumb (Note: there was no security risk with the previous version)</li>	\n            <li>Add Dasboard Share Button</li>															\n            </ol>			\n					\n<h4><strong>v1.0.0.0</strong> Release 03/03/2013</h4>\n 			<ol>	\n            <li>This is the launch version. No changes yet.</li>															\n            </ol>\n]]>\n</changelog>\n</notifier>", "yes");
INSERT INTO `wp_options` VALUES("471", "emg-notifier-cache-last-updated", "1393625360", "yes");
INSERT INTO `wp_options` VALUES("42173", "worker_migration_version", "2", "yes");
INSERT INTO `wp_options` VALUES("711", "widget_columns_widget", "a:3:{i:2;a:5:{s:5:\"image\";s:0:\"\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:0:\"\";s:4:\"link\";s:0:\"\";s:5:\"blank\";N;}i:3;a:5:{s:5:\"image\";s:65:\"http://barharbormanorhouse.com/wp/wp-content/uploads/registry.gif\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:0:\"\";s:4:\"link\";s:30:\"http://www.selectregistry.com/\";s:5:\"blank\";s:1:\"1\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("755", "mwp_backup_tasks", "a:1:{s:10:\"Backup Now\";a:2:{s:9:\"task_args\";a:9:{s:4:\"what\";s:4:\"full\";s:15:\"optimize_tables\";b:0;s:7:\"exclude\";a:0:{}s:7:\"include\";a:0:{}s:13:\"del_host_file\";b:0;s:12:\"disable_comp\";i:0;s:5:\"limit\";s:1:\"3\";s:18:\"compression_method\";i:0;s:12:\"account_info\";a:0:{}}s:12:\"task_results\";a:1:{i:0;a:4:{s:4:\"size\";s:5:\"136MB\";s:8:\"duration\";s:6:\"49.79s\";s:6:\"server\";a:2:{s:9:\"file_path\";s:140:\"/home/econolodge/public_html/wp/wp/wp-content/managewp/backups/theterninn.com-wp_manual_full_2015-07-25_9c6763f17d129ddd3bb53c3b9ca4248e.zip\";s:8:\"file_url\";s:144:\"http://67.23.236.217/~windriftmotel/wp/wp-content/managewp/backups/theterninn.com-wp_manual_full_2015-07-25_9c6763f17d129ddd3bb53c3b9ca4248e.zip\";}s:4:\"time\";i:1437850739;}}}}", "yes");
INSERT INTO `wp_options` VALUES("978", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("41886", "jqlb_help_text", "", "yes");
INSERT INTO `wp_options` VALUES("41887", "jqlb_automate", "1", "yes");
INSERT INTO `wp_options` VALUES("41888", "jqlb_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("41889", "jqlb_resize_on_demand", "0", "yes");
INSERT INTO `wp_options` VALUES("19530", "auth_key", "DPBwoam|Shf5NVmKg8)X8plL}??Vgw]|63$(>[aciXg6Yd!GI].|468p56<@e8og", "yes");
INSERT INTO `wp_options` VALUES("19531", "auth_salt", "nY?w3DFsG^.J>!FHJ86i6T6wS7q{:fzoKzp:v::8?7#`jU_Z[9^v!_3Mox0am}T,", "yes");
INSERT INTO `wp_options` VALUES("19532", "logged_in_key", "P@&2!|h]i1~,Ih6grp%z{-$=.OJiC+99{6Z^)X9h5mm6{?G dyy` vH,2t35&xVe", "yes");
INSERT INTO `wp_options` VALUES("19533", "logged_in_salt", "P^V%5^$>2hxeB_/2kr7O4kmXtu){_TfY?},Z.pN{rMYzu[TT%}Lr!TyO3a5QlwcS", "yes");
INSERT INTO `wp_options` VALUES("19534", "nonce_key", "y6%3~RJqML[<U`BJLNe.b*,/fiTKId$TGNv*^I_W?(tqn=t1M;;Q%iV6r3b[XdQ@", "yes");
INSERT INTO `wp_options` VALUES("19535", "nonce_salt", "9WPh)2(^xDkaZCgKxHr$1 {uE5rF}H)zkoUPOa6(yyk23(yYD/K5/3kCGbf,~8mo", "yes");
INSERT INTO `wp_options` VALUES("36598", "wd_bwg_version", "1.3.45", "no");
INSERT INTO `wp_options` VALUES("36599", "wd_bwg_theme_version", "1.0.0", "no");
INSERT INTO `wp_options` VALUES("19622", "tablepress_plugin_options", "{\"plugin_options_db_version\":29,\"table_scheme_db_version\":3,\"prev_tablepress_version\":\"1.4\",\"tablepress_version\":\"1.5.1\",\"first_activation\":1415785312,\"message_plugin_update\":true,\"message_plugin_update_content\":\"<info>This update includes several new features, enhancements, and bugfixes. Updating is recommended.<\\/info>\",\"message_donation_nag\":true,\"use_custom_css\":true,\"use_custom_css_file\":true,\"custom_css\":\".tablepress-id-2 .column-1 {\\n\\twidth: 250px;\\n}\\n\\n.tablepress-id-2 .column-2 {\\n\\twidth: 400px;\\n}\",\"custom_css_minified\":\".tablepress-id-2 .column-1{width:250px}.tablepress-id-2 .column-2{width:400px}\",\"custom_css_version\":9}", "yes");
INSERT INTO `wp_options` VALUES("19623", "tablepress_tables", "{\"last_id\":2,\"table_post\":{\"1\":825,\"2\":848}}", "yes");
INSERT INTO `wp_options` VALUES("32011", "wpseo_titles", "a:67:{s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-pipe\";s:16:\"title-home-wpseo\";s:69:\"White Mountains NH Motel Hotel | Swimming Pool | Loon Mountain Skiing\";s:18:\"title-author-wpseo\";s:41:\"%%name%%, Author at %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:63:\"You searched for %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:35:\"Page not found %%sep%% %%sitename%%\";s:19:\"metadesc-home-wpseo\";s:373:\"Econo Lodge Loon Inn & Suites is a White Mountains New Hampshire Motel with an indoor swimming pool in a convenient location. We offer newly renovated beautiful guest rooms, Jacuzzi rooms and suites and are near White Mountains NH attractions, skiing, golf, hiking and much more. Our family motel is a great vacation or getaway lodging for your White Mountains NH vacation.\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:53:\"The post %%POSTLINK%% appeared first on %%BLOGLINK%%.\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:18:\"disable-attachment\";b:1;s:23:\"is-media-purge-relevant\";b:0;s:20:\"breadcrumbs-404crumb\";s:25:\"Error 404: Page not found\";s:29:\"breadcrumbs-display-blog-page\";b:0;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:12:\"Archives for\";s:18:\"breadcrumbs-enable\";b:0;s:16:\"breadcrumbs-home\";s:4:\"Home\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:16:\"You searched for\";s:15:\"breadcrumbs-sep\";s:2:\"»\";s:12:\"website_name\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:11:\"person_logo\";s:0:\"\";s:14:\"person_logo_id\";i:0;s:22:\"alternate_website_name\";s:0:\"\";s:12:\"company_logo\";s:74:\"https://www.econolodgeloon.com/wp/wp-content/uploads/signsiloforbanner.jpg\";s:15:\"company_logo_id\";i:0;s:12:\"company_name\";s:24:\"Econo Lodge Inn & Suites\";s:17:\"company_or_person\";s:7:\"company\";s:25:\"company_or_person_user_id\";b:0;s:17:\"stripcategorybase\";b:0;s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:23:\"display-metabox-pt-post\";b:1;s:23:\"post_types-post-maintax\";i:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:23:\"post_types-page-maintax\";i:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:29:\"post_types-attachment-maintax\";i:0;s:18:\"title-tax-category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:1;s:20:\"noindex-tax-category\";b:0;s:18:\"title-tax-post_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:1;s:20:\"noindex-tax-post_tag\";b:0;s:21:\"title-tax-post_format\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:0;s:23:\"noindex-tax-post_format\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("19680", "widget_pages", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("19681", "widget_calendar", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("19682", "widget_tag_cloud", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("19683", "widget_nav_menu", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("19684", "widget_mmb_widget", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("32009", "wpseo", "a:42:{s:8:\"tracking\";b:0;s:22:\"license_server_version\";s:1:\"2\";s:15:\"ms_defaults_set\";b:0;s:40:\"ignore_search_engines_discouraged_notice\";b:0;s:19:\"indexing_first_time\";b:1;s:16:\"indexing_started\";b:0;s:15:\"indexing_reason\";s:0:\"\";s:29:\"indexables_indexing_completed\";b:0;s:7:\"version\";s:4:\"15.4\";s:16:\"previous_version\";s:4:\"15.3\";s:20:\"disableadvanced_meta\";b:1;s:30:\"enable_headless_rest_endpoints\";b:1;s:17:\"ryte_indexability\";b:1;s:11:\"baiduverify\";s:0:\"\";s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";b:0;s:16:\"environment_type\";s:0:\"\";s:23:\"content_analysis_active\";b:1;s:23:\"keyword_analysis_active\";b:1;s:21:\"enable_admin_bar_menu\";b:1;s:26:\"enable_cornerstone_content\";b:1;s:18:\"enable_xml_sitemap\";b:1;s:24:\"enable_text_link_counter\";b:1;s:22:\"show_onboarding_notice\";b:0;s:18:\"first_activated_on\";i:1475013214;s:13:\"myyoast-oauth\";b:0;s:26:\"semrush_integration_active\";b:1;s:14:\"semrush_tokens\";a:0:{}s:20:\"semrush_country_code\";s:2:\"us\";s:19:\"permalink_structure\";s:12:\"/%postname%/\";s:8:\"home_url\";s:30:\"https://www.econolodgeloon.com\";s:18:\"dynamic_permalinks\";b:0;s:17:\"category_base_url\";s:0:\"\";s:12:\"tag_base_url\";s:0:\"\";s:21:\"custom_taxonomy_slugs\";a:0:{}s:29:\"enable_enhanced_slack_sharing\";b:1;s:25:\"zapier_integration_active\";b:1;s:19:\"zapier_subscription\";a:0:{}s:14:\"zapier_api_key\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("36672", "manage-multiple-blogs", "a:2:{s:5:\"blogs\";a:0:{}s:12:\"current_blog\";a:1:{s:4:\"type\";N;}}", "yes");
INSERT INTO `wp_options` VALUES("36663", "widget_bwp_gallery_slideshow", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("36664", "widget_bwp_gallery", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("46215", "eps_redirects_redirects", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("46216", "eps_redirects_404s", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("46217", "eps_redirects_import-export", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("53739", "wordfence_syncAttackDataAttempts", "0", "no");
INSERT INTO `wp_options` VALUES("53597", "updraftplus_dismisseddashnotice", "1561764304", "yes");
INSERT INTO `wp_options` VALUES("46168", "bwg_admin_notice", "a:3:{s:15:\"two_week_review\";a:3:{s:5:\"start\";s:9:\"4/29/2016\";s:3:\"int\";i:14;s:9:\"dismissed\";i:1;}s:16:\"one_week_support\";a:3:{s:5:\"start\";s:10:\"12/23/2015\";s:3:\"int\";i:7;s:9:\"dismissed\";i:1;}s:15:\"ecommerce_promo\";a:3:{s:5:\"start\";s:9:\"2/26/2016\";s:3:\"int\";i:3;s:9:\"dismissed\";i:1;}}", "yes");
INSERT INTO `wp_options` VALUES("46203", "site_icon", "0", "yes");
INSERT INTO `wp_options` VALUES("46204", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("46205", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("46212", "eps_redirects_version", "2.3.0", "yes");
INSERT INTO `wp_options` VALUES("46233", "slb_version", "2.8.1", "yes");
INSERT INTO `wp_options` VALUES("46234", "slb_options", "a:27:{s:7:\"enabled\";b:1;s:12:\"enabled_home\";b:1;s:12:\"enabled_post\";b:1;s:12:\"enabled_page\";b:1;s:15:\"enabled_archive\";b:1;s:14:\"enabled_widget\";b:0;s:12:\"enabled_menu\";b:0;s:11:\"group_links\";b:1;s:10:\"group_post\";b:1;s:13:\"group_gallery\";b:0;s:12:\"group_widget\";b:0;s:10:\"group_menu\";b:0;s:10:\"ui_autofit\";b:1;s:10:\"ui_animate\";b:1;s:19:\"slideshow_autostart\";b:1;s:18:\"slideshow_duration\";s:1:\"4\";s:10:\"group_loop\";b:1;s:18:\"ui_overlay_opacity\";s:3:\"0.8\";s:16:\"ui_title_default\";b:0;s:11:\"txt_loading\";s:7:\"Loading\";s:9:\"txt_close\";s:5:\"Close\";s:12:\"txt_nav_next\";s:4:\"Next\";s:12:\"txt_nav_prev\";s:8:\"Previous\";s:19:\"txt_slideshow_start\";s:15:\"Start slideshow\";s:18:\"txt_slideshow_stop\";s:14:\"Stop slideshow\";s:16:\"txt_group_status\";s:25:\"Item %current% of %total%\";s:13:\"theme_default\";s:11:\"slb_default\";}", "yes");
INSERT INTO `wp_options` VALUES("48294", "tc_theme_options", "a:170:{s:14:\"tc_logo_upload\";N;s:14:\"tc_logo_resize\";b:1;s:21:\"tc_sticky_logo_upload\";N;s:13:\"tc_fav_upload\";N;s:7:\"tc_skin\";s:9:\"blue3.css\";s:14:\"tc_skin_random\";b:0;s:8:\"tc_fonts\";s:19:\"_g_fjalla_cantarell\";s:17:\"tc_body_font_size\";i:15;s:6:\"tc_rss\";s:48:\"http://67.23.236.217/~windriftmotel/wp/feed/rss/\";s:8:\"tc_email\";N;s:10:\"tc_twitter\";N;s:11:\"tc_facebook\";N;s:9:\"tc_google\";N;s:12:\"tc_instagram\";N;s:9:\"tc_tumblr\";N;s:9:\"tc_flickr\";N;s:12:\"tc_wordpress\";N;s:10:\"tc_youtube\";N;s:12:\"tc_pinterest\";N;s:9:\"tc_github\";N;s:11:\"tc_dribbble\";N;s:11:\"tc_linkedin\";N;s:18:\"tc_show_title_icon\";b:1;s:23:\"tc_show_page_title_icon\";b:0;s:23:\"tc_show_post_title_icon\";b:0;s:26:\"tc_show_archive_title_icon\";b:1;s:28:\"tc_show_post_list_title_icon\";b:0;s:27:\"tc_show_sidebar_widget_icon\";b:1;s:26:\"tc_show_footer_widget_icon\";b:1;s:14:\"tc_link_scroll\";b:0;s:20:\"tc_link_hover_effect\";b:1;s:17:\"tc_ext_link_style\";b:0;s:18:\"tc_ext_link_target\";b:0;s:11:\"tc_fancybox\";b:1;s:21:\"tc_fancybox_autoscale\";b:1;s:17:\"tc_retina_support\";b:0;s:23:\"tc_display_slide_loader\";b:0;s:20:\"tc_center_slider_img\";b:1;s:13:\"tc_center_img\";b:1;s:16:\"tc_block_reorder\";b:1;s:19:\"tc_show_author_info\";b:1;s:15:\"tc_smoothscroll\";b:1;s:16:\"tc_header_layout\";s:4:\"left\";s:13:\"tc_top_border\";b:1;s:15:\"tc_show_tagline\";b:1;s:19:\"tc_social_in_header\";b:1;s:23:\"tc_display_boxed_navbar\";b:0;s:16:\"tc_sticky_header\";b:1;s:22:\"tc_sticky_show_tagline\";b:0;s:25:\"tc_sticky_show_title_logo\";b:1;s:27:\"tc_sticky_shrink_title_logo\";b:1;s:19:\"tc_sticky_show_menu\";b:1;s:31:\"tc_sticky_transparent_on_scroll\";b:1;s:17:\"tc_sticky_z_index\";i:100;s:22:\"tc_display_second_menu\";b:0;s:13:\"tc_menu_style\";s:5:\"aside\";s:39:\"tc_menu_resp_dropdown_limit_to_viewport\";b:0;s:21:\"tc_display_menu_label\";b:0;s:16:\"tc_menu_position\";s:15:\"pull-menu-right\";s:23:\"tc_second_menu_position\";s:14:\"pull-menu-left\";s:12:\"tc_menu_type\";s:5:\"hover\";s:27:\"tc_menu_submenu_fade_effect\";b:1;s:32:\"tc_menu_submenu_item_move_effect\";b:1;s:27:\"tc_second_menu_resp_setting\";s:12:\"in-sn-before\";s:17:\"tc_hide_all_menus\";b:0;s:23:\"tc_blog_restrict_by_cat\";a:0:{}s:15:\"tc_front_layout\";s:1:\"f\";s:15:\"tc_front_slider\";s:4:\"demo\";s:22:\"tc_posts_slider_number\";i:1;s:24:\"tc_posts_slider_stickies\";b:0;s:21:\"tc_posts_slider_title\";b:1;s:20:\"tc_posts_slider_text\";b:1;s:20:\"tc_posts_slider_link\";s:3:\"cta\";s:27:\"tc_posts_slider_button_text\";s:17:\"Read more &raquo;\";s:15:\"tc_slider_width\";b:1;s:15:\"tc_slider_delay\";i:5000;s:24:\"tc_slider_default_height\";i:500;s:34:\"tc_slider_default_height_apply_all\";b:1;s:33:\"tc_slider_change_default_img_size\";b:0;s:22:\"tc_show_featured_pages\";i:1;s:26:\"tc_show_featured_pages_img\";b:1;s:28:\"tc_featured_page_button_text\";s:17:\"Read more &raquo;\";s:20:\"tc_featured_page_one\";N;s:20:\"tc_featured_page_two\";N;s:22:\"tc_featured_page_three\";N;s:20:\"tc_featured_text_one\";N;s:20:\"tc_featured_text_two\";N;s:22:\"tc_featured_text_three\";N;s:24:\"tc_sidebar_global_layout\";s:1:\"l\";s:23:\"tc_sidebar_force_layout\";b:0;s:22:\"tc_sidebar_post_layout\";s:1:\"l\";s:19:\"tc_post_list_length\";s:7:\"excerpt\";s:22:\"tc_sidebar_page_layout\";s:1:\"l\";s:22:\"tc_comment_show_bubble\";b:1;s:23:\"tc_comment_bubble_shape\";s:7:\"default\";s:28:\"tc_comment_bubble_color_type\";s:4:\"skin\";s:23:\"tc_comment_bubble_color\";s:7:\"#27CDA5\";s:16:\"tc_page_comments\";b:0;s:16:\"tc_post_comments\";b:1;s:20:\"tc_show_comment_list\";b:1;s:13:\"tc_breadcrumb\";b:1;s:23:\"tc_show_breadcrumb_home\";b:0;s:27:\"tc_show_breadcrumb_in_pages\";b:1;s:34:\"tc_show_breadcrumb_in_single_posts\";b:1;s:32:\"tc_show_breadcrumb_in_post_lists\";b:1;s:18:\"tc_show_post_metas\";b:1;s:20:\"tc_post_metas_design\";s:10:\"no-buttons\";s:23:\"tc_show_post_metas_home\";b:0;s:30:\"tc_show_post_metas_single_post\";b:1;s:29:\"tc_show_post_metas_post_lists\";b:1;s:29:\"tc_show_post_metas_categories\";b:1;s:23:\"tc_show_post_metas_tags\";b:1;s:35:\"tc_show_post_metas_publication_date\";b:1;s:25:\"tc_show_post_metas_author\";b:1;s:30:\"tc_show_post_metas_update_date\";b:0;s:32:\"tc_post_metas_update_date_format\";s:4:\"days\";s:36:\"tc_post_metas_update_notice_in_title\";b:0;s:36:\"tc_post_metas_update_notice_interval\";i:10;s:32:\"tc_post_metas_update_notice_text\";s:18:\"Recently updated !\";s:34:\"tc_post_metas_update_notice_format\";s:13:\"label-default\";s:27:\"tc_post_list_excerpt_length\";i:50;s:23:\"tc_post_list_show_thumb\";b:1;s:36:\"tc_post_list_use_attachment_as_thumb\";b:1;s:26:\"tc_post_list_default_thumb\";N;s:24:\"tc_post_list_thumb_shape\";s:7:\"rounded\";s:25:\"tc_post_list_thumb_height\";i:250;s:27:\"tc_post_list_thumb_position\";s:5:\"right\";s:28:\"tc_post_list_thumb_alternate\";b:1;s:12:\"tc_cat_title\";s:0:\"\";s:12:\"tc_tag_title\";s:0:\"\";s:15:\"tc_author_title\";s:0:\"\";s:15:\"tc_search_title\";s:20:\"Search Results for :\";s:17:\"tc_post_list_grid\";s:4:\"grid\";s:15:\"tc_grid_columns\";s:1:\"3\";s:23:\"tc_grid_expand_featured\";b:1;s:15:\"tc_grid_in_blog\";b:1;s:18:\"tc_grid_in_archive\";b:1;s:17:\"tc_grid_in_search\";b:1;s:14:\"tc_grid_shadow\";b:1;s:21:\"tc_grid_bottom_border\";b:1;s:13:\"tc_grid_icons\";b:1;s:17:\"tc_grid_num_words\";i:10;s:20:\"tc_grid_thumb_height\";i:350;s:29:\"tc_single_post_thumb_location\";s:4:\"hide\";s:27:\"tc_single_post_thumb_height\";i:250;s:17:\"tc_enable_gallery\";b:1;s:19:\"tc_gallery_fancybox\";b:1;s:16:\"tc_gallery_style\";b:1;s:17:\"tc_enable_dropcap\";b:0;s:19:\"tc_dropcap_minwords\";i:50;s:17:\"tc_dropcap_design\";s:11:\"skin-shadow\";s:15:\"tc_post_dropcap\";b:0;s:15:\"tc_page_dropcap\";b:0;s:23:\"tc_show_post_navigation\";b:1;s:28:\"tc_show_post_navigation_page\";b:0;s:30:\"tc_show_post_navigation_single\";b:1;s:31:\"tc_show_post_navigation_archive\";b:1;s:25:\"tc_social_in_left-sidebar\";b:0;s:26:\"tc_social_in_right-sidebar\";b:0;s:26:\"tc_social_in_sidebar_title\";s:12:\"Social links\";s:19:\"tc_social_in_footer\";b:1;s:16:\"tc_sticky_footer\";b:1;s:19:\"tc_show_back_to_top\";b:1;s:13:\"tc_custom_css\";N;s:16:\"tc_minified_skin\";b:1;s:17:\"tc_img_smart_load\";b:0;s:21:\"tc_display_front_help\";b:1;s:3:\"ver\";s:6:\"3.4.15\";s:18:\"last_update_notice\";a:2:{s:7:\"version\";s:6:\"3.4.15\";s:13:\"display_count\";i:0;}s:8:\"defaults\";a:168:{s:14:\"tc_logo_upload\";N;s:14:\"tc_logo_resize\";b:1;s:21:\"tc_sticky_logo_upload\";N;s:13:\"tc_fav_upload\";N;s:7:\"tc_skin\";s:9:\"blue3.css\";s:14:\"tc_skin_random\";b:0;s:8:\"tc_fonts\";s:19:\"_g_fjalla_cantarell\";s:17:\"tc_body_font_size\";i:15;s:6:\"tc_rss\";s:48:\"http://67.23.236.217/~windriftmotel/wp/feed/rss/\";s:8:\"tc_email\";N;s:10:\"tc_twitter\";N;s:11:\"tc_facebook\";N;s:9:\"tc_google\";N;s:12:\"tc_instagram\";N;s:9:\"tc_tumblr\";N;s:9:\"tc_flickr\";N;s:12:\"tc_wordpress\";N;s:10:\"tc_youtube\";N;s:12:\"tc_pinterest\";N;s:9:\"tc_github\";N;s:11:\"tc_dribbble\";N;s:11:\"tc_linkedin\";N;s:18:\"tc_show_title_icon\";b:1;s:23:\"tc_show_page_title_icon\";b:0;s:23:\"tc_show_post_title_icon\";b:0;s:26:\"tc_show_archive_title_icon\";b:1;s:28:\"tc_show_post_list_title_icon\";b:0;s:27:\"tc_show_sidebar_widget_icon\";b:1;s:26:\"tc_show_footer_widget_icon\";b:1;s:14:\"tc_link_scroll\";b:0;s:20:\"tc_link_hover_effect\";b:1;s:17:\"tc_ext_link_style\";b:0;s:18:\"tc_ext_link_target\";b:0;s:11:\"tc_fancybox\";b:1;s:21:\"tc_fancybox_autoscale\";b:1;s:17:\"tc_retina_support\";b:0;s:23:\"tc_display_slide_loader\";b:0;s:20:\"tc_center_slider_img\";b:1;s:13:\"tc_center_img\";b:1;s:16:\"tc_block_reorder\";b:1;s:19:\"tc_show_author_info\";b:1;s:15:\"tc_smoothscroll\";b:1;s:16:\"tc_header_layout\";s:4:\"left\";s:13:\"tc_top_border\";b:1;s:15:\"tc_show_tagline\";b:1;s:19:\"tc_social_in_header\";b:1;s:23:\"tc_display_boxed_navbar\";b:0;s:16:\"tc_sticky_header\";b:1;s:22:\"tc_sticky_show_tagline\";b:0;s:25:\"tc_sticky_show_title_logo\";b:1;s:27:\"tc_sticky_shrink_title_logo\";b:1;s:19:\"tc_sticky_show_menu\";b:1;s:31:\"tc_sticky_transparent_on_scroll\";b:1;s:17:\"tc_sticky_z_index\";i:100;s:22:\"tc_display_second_menu\";b:0;s:13:\"tc_menu_style\";s:5:\"aside\";s:39:\"tc_menu_resp_dropdown_limit_to_viewport\";b:0;s:21:\"tc_display_menu_label\";b:0;s:16:\"tc_menu_position\";s:15:\"pull-menu-right\";s:23:\"tc_second_menu_position\";s:14:\"pull-menu-left\";s:12:\"tc_menu_type\";s:5:\"hover\";s:27:\"tc_menu_submenu_fade_effect\";b:1;s:32:\"tc_menu_submenu_item_move_effect\";b:1;s:27:\"tc_second_menu_resp_setting\";s:12:\"in-sn-before\";s:17:\"tc_hide_all_menus\";b:0;s:23:\"tc_blog_restrict_by_cat\";a:0:{}s:15:\"tc_front_layout\";s:1:\"f\";s:15:\"tc_front_slider\";s:4:\"demo\";s:22:\"tc_posts_slider_number\";i:1;s:24:\"tc_posts_slider_stickies\";b:0;s:21:\"tc_posts_slider_title\";b:1;s:20:\"tc_posts_slider_text\";b:1;s:20:\"tc_posts_slider_link\";s:3:\"cta\";s:27:\"tc_posts_slider_button_text\";s:17:\"Read more &raquo;\";s:15:\"tc_slider_width\";b:1;s:15:\"tc_slider_delay\";i:5000;s:24:\"tc_slider_default_height\";i:500;s:34:\"tc_slider_default_height_apply_all\";b:1;s:33:\"tc_slider_change_default_img_size\";b:0;s:22:\"tc_show_featured_pages\";i:1;s:26:\"tc_show_featured_pages_img\";b:1;s:28:\"tc_featured_page_button_text\";s:17:\"Read more &raquo;\";s:20:\"tc_featured_page_one\";N;s:20:\"tc_featured_page_two\";N;s:22:\"tc_featured_page_three\";N;s:20:\"tc_featured_text_one\";N;s:20:\"tc_featured_text_two\";N;s:22:\"tc_featured_text_three\";N;s:24:\"tc_sidebar_global_layout\";s:1:\"l\";s:23:\"tc_sidebar_force_layout\";b:0;s:22:\"tc_sidebar_post_layout\";s:1:\"l\";s:19:\"tc_post_list_length\";s:7:\"excerpt\";s:22:\"tc_sidebar_page_layout\";s:1:\"l\";s:22:\"tc_comment_show_bubble\";b:1;s:23:\"tc_comment_bubble_shape\";s:7:\"default\";s:28:\"tc_comment_bubble_color_type\";s:4:\"skin\";s:23:\"tc_comment_bubble_color\";s:7:\"#27CDA5\";s:16:\"tc_page_comments\";b:0;s:16:\"tc_post_comments\";b:1;s:20:\"tc_show_comment_list\";b:1;s:13:\"tc_breadcrumb\";b:1;s:23:\"tc_show_breadcrumb_home\";b:0;s:27:\"tc_show_breadcrumb_in_pages\";b:1;s:34:\"tc_show_breadcrumb_in_single_posts\";b:1;s:32:\"tc_show_breadcrumb_in_post_lists\";b:1;s:18:\"tc_show_post_metas\";b:1;s:20:\"tc_post_metas_design\";s:10:\"no-buttons\";s:23:\"tc_show_post_metas_home\";b:0;s:30:\"tc_show_post_metas_single_post\";b:1;s:29:\"tc_show_post_metas_post_lists\";b:1;s:29:\"tc_show_post_metas_categories\";b:1;s:23:\"tc_show_post_metas_tags\";b:1;s:35:\"tc_show_post_metas_publication_date\";b:1;s:25:\"tc_show_post_metas_author\";b:1;s:30:\"tc_show_post_metas_update_date\";b:0;s:32:\"tc_post_metas_update_date_format\";s:4:\"days\";s:36:\"tc_post_metas_update_notice_in_title\";b:0;s:36:\"tc_post_metas_update_notice_interval\";i:10;s:32:\"tc_post_metas_update_notice_text\";s:18:\"Recently updated !\";s:34:\"tc_post_metas_update_notice_format\";s:13:\"label-default\";s:27:\"tc_post_list_excerpt_length\";i:50;s:23:\"tc_post_list_show_thumb\";b:1;s:36:\"tc_post_list_use_attachment_as_thumb\";b:1;s:26:\"tc_post_list_default_thumb\";N;s:24:\"tc_post_list_thumb_shape\";s:7:\"rounded\";s:25:\"tc_post_list_thumb_height\";i:250;s:27:\"tc_post_list_thumb_position\";s:5:\"right\";s:28:\"tc_post_list_thumb_alternate\";b:1;s:12:\"tc_cat_title\";s:0:\"\";s:12:\"tc_tag_title\";s:0:\"\";s:15:\"tc_author_title\";s:0:\"\";s:15:\"tc_search_title\";s:20:\"Search Results for :\";s:17:\"tc_post_list_grid\";s:4:\"grid\";s:15:\"tc_grid_columns\";s:1:\"3\";s:23:\"tc_grid_expand_featured\";b:1;s:15:\"tc_grid_in_blog\";b:1;s:18:\"tc_grid_in_archive\";b:1;s:17:\"tc_grid_in_search\";b:1;s:14:\"tc_grid_shadow\";b:1;s:21:\"tc_grid_bottom_border\";b:1;s:13:\"tc_grid_icons\";b:1;s:17:\"tc_grid_num_words\";i:10;s:20:\"tc_grid_thumb_height\";i:350;s:29:\"tc_single_post_thumb_location\";s:4:\"hide\";s:27:\"tc_single_post_thumb_height\";i:250;s:17:\"tc_enable_gallery\";b:1;s:19:\"tc_gallery_fancybox\";b:1;s:16:\"tc_gallery_style\";b:1;s:17:\"tc_enable_dropcap\";b:0;s:19:\"tc_dropcap_minwords\";i:50;s:17:\"tc_dropcap_design\";s:11:\"skin-shadow\";s:15:\"tc_post_dropcap\";b:0;s:15:\"tc_page_dropcap\";b:0;s:23:\"tc_show_post_navigation\";b:1;s:28:\"tc_show_post_navigation_page\";b:0;s:30:\"tc_show_post_navigation_single\";b:1;s:31:\"tc_show_post_navigation_archive\";b:1;s:25:\"tc_social_in_left-sidebar\";b:0;s:26:\"tc_social_in_right-sidebar\";b:0;s:26:\"tc_social_in_sidebar_title\";s:12:\"Social links\";s:19:\"tc_social_in_footer\";b:1;s:16:\"tc_sticky_footer\";b:1;s:19:\"tc_show_back_to_top\";b:1;s:13:\"tc_custom_css\";N;s:16:\"tc_minified_skin\";b:1;s:17:\"tc_img_smart_load\";b:0;s:21:\"tc_display_front_help\";b:1;s:3:\"ver\";s:6:\"3.4.15\";}}", "yes");
INSERT INTO `wp_options` VALUES("48133", "wordfence_version", "7.4.14", "yes");
INSERT INTO `wp_options` VALUES("47198", "yslo_wpus_options", "a:8:{s:20:\"notification_updates\";s:1:\"1\";s:12:\"menu_updates\";s:1:\"1\";s:13:\"minor_updates\";s:1:\"1\";s:14:\"plugin_updates\";s:1:\"1\";s:13:\"theme_updates\";s:1:\"1\";s:19:\"translation_updates\";s:1:\"1\";s:27:\"auto_core_update_send_email\";s:1:\"1\";s:7:\"version\";s:5:\"1.1.4\";}", "yes");
INSERT INTO `wp_options` VALUES("85694", "hefo", "a:74:{s:4:\"head\";s:521:\"<meta name=\"google-site-verification\" content=\"nSThvu54-pCCW64-2IBcCSTmtqSnUr4wM5yvvrz9c9U\" />\r\n\r\n<script>\r\n  (function(i,s,o,g,r,a,m){i[\'GoogleAnalyticsObject\']=r;i[r]=i[r]||function(){\r\n  (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),\r\n  m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)\r\n  })(window,document,\'script\',\'https://www.google-analytics.com/analytics.js\',\'ga\');\r\n\r\n  ga(\'create\', \'UA-96076322-1\', \'auto\');\r\n  ga(\'send\', \'pageview\');\r\n\r\n</script>\";s:9:\"head_home\";s:0:\"\";s:4:\"body\";s:0:\"\";s:11:\"mobile_body\";s:0:\"\";s:6:\"footer\";s:0:\"\";s:13:\"mobile_footer\";s:0:\"\";s:13:\"generic_tag_1\";s:0:\"\";s:9:\"generic_1\";s:0:\"\";s:16:\"mobile_generic_1\";s:0:\"\";s:13:\"generic_tag_2\";s:0:\"\";s:9:\"generic_2\";s:0:\"\";s:16:\"mobile_generic_2\";s:0:\"\";s:13:\"generic_tag_3\";s:0:\"\";s:9:\"generic_3\";s:0:\"\";s:16:\"mobile_generic_3\";s:0:\"\";s:13:\"generic_tag_4\";s:0:\"\";s:9:\"generic_4\";s:0:\"\";s:16:\"mobile_generic_4\";s:0:\"\";s:6:\"before\";s:0:\"\";s:13:\"mobile_before\";s:0:\"\";s:5:\"after\";s:0:\"\";s:12:\"mobile_after\";s:0:\"\";s:14:\"excerpt_before\";s:0:\"\";s:13:\"excerpt_after\";s:0:\"\";s:11:\"inner_pos_1\";s:5:\"after\";s:11:\"inner_tag_1\";s:0:\"\";s:12:\"inner_skip_1\";s:1:\"0\";s:11:\"inner_alt_1\";s:0:\"\";s:7:\"inner_1\";s:0:\"\";s:14:\"mobile_inner_1\";s:0:\"\";s:11:\"inner_pos_2\";s:5:\"after\";s:11:\"inner_tag_2\";s:0:\"\";s:12:\"inner_skip_2\";s:1:\"0\";s:11:\"inner_alt_2\";s:0:\"\";s:7:\"inner_2\";s:0:\"\";s:14:\"mobile_inner_2\";s:0:\"\";s:11:\"inner_pos_3\";s:5:\"after\";s:11:\"inner_tag_3\";s:0:\"\";s:12:\"inner_skip_3\";s:1:\"0\";s:11:\"inner_alt_3\";s:0:\"\";s:7:\"inner_3\";s:0:\"\";s:14:\"mobile_inner_3\";s:0:\"\";s:11:\"page_before\";s:0:\"\";s:18:\"mobile_page_before\";s:0:\"\";s:10:\"page_after\";s:0:\"\";s:17:\"mobile_page_after\";s:0:\"\";s:9:\"fb_app_id\";s:0:\"\";s:7:\"og_type\";s:0:\"\";s:12:\"og_type_home\";s:0:\"\";s:16:\"og_image_default\";s:0:\"\";s:8:\"amp_head\";s:0:\"\";s:7:\"amp_css\";s:0:\"\";s:15:\"amp_post_before\";s:0:\"\";s:14:\"amp_post_after\";s:0:\"\";s:10:\"amp_footer\";s:0:\"\";s:9:\"snippet_1\";s:0:\"\";s:9:\"snippet_2\";s:0:\"\";s:9:\"snippet_3\";s:0:\"\";s:9:\"snippet_4\";s:0:\"\";s:9:\"snippet_5\";s:0:\"\";s:32:\"bbp_template_before_single_forum\";s:0:\"\";s:39:\"mobile_bbp_template_before_single_forum\";s:0:\"\";s:32:\"bbp_template_before_single_topic\";s:0:\"\";s:39:\"mobile_bbp_template_before_single_topic\";s:0:\"\";s:31:\"bbp_template_after_single_topic\";s:0:\"\";s:38:\"mobile_bbp_template_after_single_topic\";s:0:\"\";s:30:\"bbp_theme_before_reply_content\";s:0:\"\";s:37:\"mobile_bbp_theme_before_reply_content\";s:0:\"\";s:29:\"bbp_theme_after_reply_content\";s:0:\"\";s:36:\"mobile_bbp_theme_after_reply_content\";s:0:\"\";s:18:\"mobile_user_agents\";s:42:\"phone\r\niphone\r\nipod\r\nandroid.+mobile\r\nxoom\";s:5:\"notes\";s:0:\"\";s:25:\"mobile_user_agents_parsed\";s:38:\"phone|iphone|ipod|android.+mobile|xoom\";s:20:\"script_async_handles\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("51674", "GOTMLS_scan_log/97.96.91.241/1459185081.5386", "a:2:{s:8:\"settings\";a:14:{s:12:\"msg_position\";a:4:{i:0;s:4:\"80px\";i:1;s:4:\"40px\";i:2;s:5:\"400px\";i:3;s:5:\"600px\";}s:10:\"menu_group\";i:0;s:9:\"scan_what\";i:2;s:10:\"scan_depth\";i:-1;s:11:\"exclude_ext\";a:24:{i:0;s:3:\"png\";i:1;s:3:\"jpg\";i:2;s:4:\"jpeg\";i:3;s:3:\"gif\";i:4;s:3:\"bmp\";i:5;s:3:\"tif\";i:6;s:4:\"tiff\";i:7;s:3:\"psd\";i:8;s:3:\"fla\";i:9;s:3:\"flv\";i:10;s:3:\"mov\";i:11;s:3:\"mp3\";i:12;s:3:\"exe\";i:13;s:3:\"zip\";i:14;s:3:\"pdf\";i:15;s:3:\"css\";i:16;s:3:\"pot\";i:17;s:2:\"po\";i:18;s:2:\"mo\";i:19;s:2:\"so\";i:20;s:3:\"doc\";i:21;s:4:\"docx\";i:22;s:3:\"svg\";i:23;s:3:\"ttf\";}s:12:\"check_custom\";s:0:\"\";s:11:\"exclude_dir\";a:0:{}s:8:\"user_can\";s:16:\"activate_plugins\";s:14:\"quarantine_dir\";b:0;s:10:\"dont_check\";a:0:{}s:10:\"scan_level\";i:3;s:23:\"auto_UPDATE_definitions\";i:1;s:15:\"skip_quarantine\";i:0;s:5:\"check\";a:6:{i:0;s:8:\"htaccess\";i:1;s:8:\"timthumb\";i:2;s:8:\"backdoor\";i:3;s:5:\"known\";i:4;s:7:\"wp_core\";i:5;s:9:\"potential\";}}s:4:\"scan\";a:7:{s:3:\"dir\";s:31:\"/home/econolodge/public_html/wp\";s:5:\"start\";i:1459185115;s:4:\"type\";s:13:\"Complete Scan\";s:9:\"microtime\";d:321;s:7:\"percent\";i:-1;s:11:\"last_threat\";d:1459185436.5287048816680908203125;s:6:\"finish\";i:1459185436;}}", "yes");
INSERT INTO `wp_options` VALUES("49281", "GOTMLS_scan_log/97.96.91.241/1456326986.1898", "a:2:{s:8:\"settings\";a:14:{s:12:\"msg_position\";a:4:{i:0;s:4:\"80px\";i:1;s:4:\"40px\";i:2;s:5:\"400px\";i:3;s:5:\"600px\";}s:10:\"menu_group\";i:0;s:9:\"scan_what\";i:2;s:10:\"scan_depth\";i:-1;s:11:\"exclude_ext\";a:24:{i:0;s:3:\"png\";i:1;s:3:\"jpg\";i:2;s:4:\"jpeg\";i:3;s:3:\"gif\";i:4;s:3:\"bmp\";i:5;s:3:\"tif\";i:6;s:4:\"tiff\";i:7;s:3:\"psd\";i:8;s:3:\"fla\";i:9;s:3:\"flv\";i:10;s:3:\"mov\";i:11;s:3:\"mp3\";i:12;s:3:\"exe\";i:13;s:3:\"zip\";i:14;s:3:\"pdf\";i:15;s:3:\"css\";i:16;s:3:\"pot\";i:17;s:2:\"po\";i:18;s:2:\"mo\";i:19;s:2:\"so\";i:20;s:3:\"doc\";i:21;s:4:\"docx\";i:22;s:3:\"svg\";i:23;s:3:\"ttf\";}s:12:\"check_custom\";s:0:\"\";s:11:\"exclude_dir\";a:0:{}s:8:\"user_can\";s:16:\"activate_plugins\";s:14:\"quarantine_dir\";b:0;s:10:\"dont_check\";a:0:{}s:10:\"scan_level\";i:4;s:5:\"check\";a:6:{i:0;s:8:\"htaccess\";i:1;s:8:\"timthumb\";i:2;s:8:\"backdoor\";i:3;s:5:\"known\";i:4;s:7:\"wp_core\";i:5;s:9:\"potential\";}s:23:\"auto_UPDATE_definitions\";i:1;s:15:\"skip_quarantine\";i:0;}s:4:\"scan\";a:7:{s:3:\"dir\";s:34:\"/home/econolodge/public_html/wp/wp\";s:5:\"start\";i:1456326989;s:4:\"type\";s:13:\"Complete Scan\";s:9:\"microtime\";d:9838;s:7:\"percent\";i:-1;s:11:\"last_threat\";d:1456336810.854792118072509765625;s:6:\"finish\";i:1456336827;}}", "yes");
INSERT INTO `wp_options` VALUES("49336", "GOTMLS_scan_log/97.96.91.241/1456348071.775", "a:2:{s:8:\"settings\";a:14:{s:12:\"msg_position\";a:4:{i:0;s:4:\"80px\";i:1;s:4:\"40px\";i:2;s:5:\"400px\";i:3;s:5:\"600px\";}s:10:\"menu_group\";i:0;s:9:\"scan_what\";i:2;s:10:\"scan_depth\";i:-1;s:11:\"exclude_ext\";a:24:{i:0;s:3:\"png\";i:1;s:3:\"jpg\";i:2;s:4:\"jpeg\";i:3;s:3:\"gif\";i:4;s:3:\"bmp\";i:5;s:3:\"tif\";i:6;s:4:\"tiff\";i:7;s:3:\"psd\";i:8;s:3:\"fla\";i:9;s:3:\"flv\";i:10;s:3:\"mov\";i:11;s:3:\"mp3\";i:12;s:3:\"exe\";i:13;s:3:\"zip\";i:14;s:3:\"pdf\";i:15;s:3:\"css\";i:16;s:3:\"pot\";i:17;s:2:\"po\";i:18;s:2:\"mo\";i:19;s:2:\"so\";i:20;s:3:\"doc\";i:21;s:4:\"docx\";i:22;s:3:\"svg\";i:23;s:3:\"ttf\";}s:12:\"check_custom\";s:0:\"\";s:11:\"exclude_dir\";a:0:{}s:8:\"user_can\";s:16:\"activate_plugins\";s:14:\"quarantine_dir\";b:0;s:10:\"dont_check\";a:0:{}s:10:\"scan_level\";i:4;s:5:\"check\";a:6:{i:0;s:8:\"htaccess\";i:1;s:8:\"timthumb\";i:2;s:8:\"backdoor\";i:3;s:5:\"known\";i:4;s:7:\"wp_core\";i:5;s:9:\"potential\";}s:23:\"auto_UPDATE_definitions\";i:1;s:15:\"skip_quarantine\";i:0;}s:4:\"scan\";a:7:{s:3:\"dir\";s:34:\"/home/econolodge/public_html/wp/wp\";s:5:\"start\";i:1456348076;s:4:\"type\";s:13:\"Complete Scan\";s:9:\"microtime\";d:562;s:7:\"percent\";i:-1;s:11:\"last_threat\";d:1456348551.7786099910736083984375;s:6:\"finish\";i:1456348638;}}", "yes");
INSERT INTO `wp_options` VALUES("50264", "updraftplus-addons_siteid", "33f88a58b30cd969fe86bf03a2ae6fcc", "yes");
INSERT INTO `wp_options` VALUES("50265", "updraft_retain_extrarules", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("50266", "updraft_email", "", "yes");
INSERT INTO `wp_options` VALUES("50267", "updraft_report_warningsonly", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("50268", "updraft_report_wholebackup", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("50269", "updraft_extradbs", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("50270", "updraft_include_more_path", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("50271", "updraft_interval", "weekly", "yes");
INSERT INTO `wp_options` VALUES("50272", "updraft_retain", "1", "yes");
INSERT INTO `wp_options` VALUES("50273", "updraft_interval_database", "weekly", "yes");
INSERT INTO `wp_options` VALUES("50274", "updraft_retain_db", "1", "yes");
INSERT INTO `wp_options` VALUES("50275", "updraft_s3", "a:3:{s:9:\"accesskey\";s:0:\"\";s:9:\"secretkey\";s:0:\"\";s:4:\"path\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("50276", "updraft_cloudfiles", "a:5:{s:7:\"authurl\";s:35:\"https://auth.api.rackspacecloud.com\";s:6:\"region\";s:0:\"\";s:4:\"user\";s:0:\"\";s:6:\"apikey\";s:0:\"\";s:4:\"path\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("50277", "updraft_googledrive", "a:3:{s:8:\"clientid\";s:0:\"\";s:6:\"secret\";s:0:\"\";s:6:\"folder\";s:11:\"UpdraftPlus\";}", "yes");
INSERT INTO `wp_options` VALUES("50278", "updraft_ftp", "a:5:{s:4:\"host\";s:0:\"\";s:4:\"user\";s:0:\"\";s:4:\"pass\";s:0:\"\";s:4:\"path\";s:0:\"\";s:7:\"passive\";s:1:\"1\";}", "yes");
INSERT INTO `wp_options` VALUES("50279", "updraft_s3generic", "a:4:{s:8:\"endpoint\";s:0:\"\";s:9:\"accesskey\";s:0:\"\";s:9:\"secretkey\";s:0:\"\";s:4:\"path\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("50280", "updraft_dreamobjects", "a:4:{s:8:\"endpoint\";s:26:\"objects-us-west-1.dream.io\";s:9:\"accesskey\";s:0:\"\";s:9:\"secretkey\";s:0:\"\";s:4:\"path\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("50281", "updraft_include_plugins", "1", "yes");
INSERT INTO `wp_options` VALUES("50282", "updraft_include_themes", "1", "yes");
INSERT INTO `wp_options` VALUES("50283", "updraft_include_uploads", "1", "yes");
INSERT INTO `wp_options` VALUES("50284", "updraft_include_uploads_exclude", "backup*,*backups,backwpup*,wp-clone", "yes");
INSERT INTO `wp_options` VALUES("50285", "updraft_include_others", "1", "yes");
INSERT INTO `wp_options` VALUES("50286", "updraft_include_others_exclude", "upgrade,cache,updraft,backup*,*backups,mysql.sql,debug.log", "yes");
INSERT INTO `wp_options` VALUES("50287", "updraft_split_every", "400", "yes");
INSERT INTO `wp_options` VALUES("50288", "updraft_delete_local", "1", "yes");
INSERT INTO `wp_options` VALUES("50289", "updraft_dir", "updraft", "yes");
INSERT INTO `wp_options` VALUES("50290", "updraft_service", "", "yes");
INSERT INTO `wp_options` VALUES("50291", "updraft_debug_mode", "0", "yes");
INSERT INTO `wp_options` VALUES("50292", "updraft_ssl_useservercerts", "0", "yes");
INSERT INTO `wp_options` VALUES("50293", "updraft_ssl_disableverify", "0", "yes");
INSERT INTO `wp_options` VALUES("50294", "updraft_ssl_nossl", "0", "yes");
INSERT INTO `wp_options` VALUES("50305", "updraft_backup_history", "a:1:{i:1494961815;a:15:{s:7:\"plugins\";a:1:{i:0;s:64:\"backup_2017-05-16-1510_wwwtheterninncom_732f27edac8f-plugins.zip\";}s:12:\"plugins-size\";i:21077762;s:6:\"themes\";a:1:{i:0;s:63:\"backup_2017-05-16-1510_wwwtheterninncom_732f27edac8f-themes.zip\";}s:11:\"themes-size\";i:3579448;s:7:\"uploads\";a:1:{i:0;s:64:\"backup_2017-05-16-1510_wwwtheterninncom_732f27edac8f-uploads.zip\";}s:12:\"uploads-size\";i:161713797;s:6:\"others\";a:1:{i:0;s:63:\"backup_2017-05-16-1510_wwwtheterninncom_732f27edac8f-others.zip\";}s:11:\"others-size\";i:357292;s:2:\"db\";s:58:\"backup_2017-05-16-1510_wwwtheterninncom_732f27edac8f-db.gz\";s:7:\"db-size\";i:1335732;s:9:\"checksums\";a:2:{s:4:\"sha1\";a:5:{s:8:\"plugins0\";s:40:\"ad6a5e19b27e4a2d912244400907e29e4ab17a51\";s:7:\"themes0\";s:40:\"dfa605cc694bd70b850438fb3250e884efea9a86\";s:8:\"uploads0\";s:40:\"44c2ef9ee11e2b7ac4eeded0a00f0ecbd292e27e\";s:7:\"others0\";s:40:\"d0e1634d108fd73afbfc10621c597a3fb7648fa1\";s:3:\"db0\";s:40:\"c699967fa6c015210feae13d392711933988a6d4\";}s:6:\"sha256\";a:5:{s:8:\"plugins0\";s:64:\"9a2dcdc69f84fcc4b3e1e53468f74cc89ff50108d1993b5fa6edc8a5d695a3ad\";s:7:\"themes0\";s:64:\"de71a7b1d7a5ed6af61df15a8185dce1ad7b2c80c455537f909b158039687c3c\";s:8:\"uploads0\";s:64:\"9f424c2eff5de2721b07ee495f9a93745b9465316f707a82d54019b1d09b58ac\";s:7:\"others0\";s:64:\"d681ab9483aea64bb4acc5396ed66f65b6eba83bf1fe8d7e573fb7a76dc4a56b\";s:3:\"db0\";s:64:\"c4cee0c0e4f2ea37e1e2bdbb2c127b890c16837826e6331fddcd2babf3bb42d6\";}}s:5:\"nonce\";s:12:\"732f27edac8f\";s:7:\"service\";a:1:{i:0;s:0:\"\";}s:18:\"created_by_version\";s:6:\"1.13.1\";s:12:\"is_multisite\";b:0;}}", "yes");
INSERT INTO `wp_options` VALUES("50296", "updraft_lastmessage", "The backup apparently succeeded and is now complete (May 16 15:11:07)", "yes");
INSERT INTO `wp_options` VALUES("50297", "updraftplus_unlocked_fd", "1", "yes");
INSERT INTO `wp_options` VALUES("50298", "updraftplus_last_lock_time_fd", "2017-05-16 19:10:15", "yes");
INSERT INTO `wp_options` VALUES("50299", "updraftplus_semaphore_fd", "0", "yes");
INSERT INTO `wp_options` VALUES("50300", "updraft_last_scheduled_fd", "1494961815", "yes");
INSERT INTO `wp_options` VALUES("50302", "updraftplus_unlocked_", "1", "yes");
INSERT INTO `wp_options` VALUES("50303", "updraftplus_last_lock_time_", "2016-03-08 19:12:15", "yes");
INSERT INTO `wp_options` VALUES("50304", "updraftplus_semaphore_", "0", "yes");
INSERT INTO `wp_options` VALUES("50306", "updraft_last_backup", "a:5:{s:11:\"backup_time\";i:1494961815;s:12:\"backup_array\";a:11:{s:7:\"plugins\";a:1:{i:0;s:64:\"backup_2017-05-16-1510_wwwtheterninncom_732f27edac8f-plugins.zip\";}s:12:\"plugins-size\";i:21077762;s:6:\"themes\";a:1:{i:0;s:63:\"backup_2017-05-16-1510_wwwtheterninncom_732f27edac8f-themes.zip\";}s:11:\"themes-size\";i:3579448;s:7:\"uploads\";a:1:{i:0;s:64:\"backup_2017-05-16-1510_wwwtheterninncom_732f27edac8f-uploads.zip\";}s:12:\"uploads-size\";i:161713797;s:6:\"others\";a:1:{i:0;s:63:\"backup_2017-05-16-1510_wwwtheterninncom_732f27edac8f-others.zip\";}s:11:\"others-size\";i:357292;s:2:\"db\";s:58:\"backup_2017-05-16-1510_wwwtheterninncom_732f27edac8f-db.gz\";s:7:\"db-size\";i:1335732;s:9:\"checksums\";a:2:{s:4:\"sha1\";a:5:{s:8:\"plugins0\";s:40:\"ad6a5e19b27e4a2d912244400907e29e4ab17a51\";s:7:\"themes0\";s:40:\"dfa605cc694bd70b850438fb3250e884efea9a86\";s:8:\"uploads0\";s:40:\"44c2ef9ee11e2b7ac4eeded0a00f0ecbd292e27e\";s:7:\"others0\";s:40:\"d0e1634d108fd73afbfc10621c597a3fb7648fa1\";s:3:\"db0\";s:40:\"c699967fa6c015210feae13d392711933988a6d4\";}s:6:\"sha256\";a:5:{s:8:\"plugins0\";s:64:\"9a2dcdc69f84fcc4b3e1e53468f74cc89ff50108d1993b5fa6edc8a5d695a3ad\";s:7:\"themes0\";s:64:\"de71a7b1d7a5ed6af61df15a8185dce1ad7b2c80c455537f909b158039687c3c\";s:8:\"uploads0\";s:64:\"9f424c2eff5de2721b07ee495f9a93745b9465316f707a82d54019b1d09b58ac\";s:7:\"others0\";s:64:\"d681ab9483aea64bb4acc5396ed66f65b6eba83bf1fe8d7e573fb7a76dc4a56b\";s:3:\"db0\";s:64:\"c4cee0c0e4f2ea37e1e2bdbb2c127b890c16837826e6331fddcd2babf3bb42d6\";}}}s:7:\"success\";i:1;s:6:\"errors\";a:0:{}s:12:\"backup_nonce\";s:12:\"732f27edac8f\";}", "yes");
INSERT INTO `wp_options` VALUES("50945", "GOTMLS_scan_log/97.96.91.241/1458248375.5256", "a:2:{s:8:\"settings\";a:14:{s:12:\"msg_position\";a:4:{i:0;s:4:\"80px\";i:1;s:4:\"40px\";i:2;s:5:\"400px\";i:3;s:5:\"600px\";}s:10:\"menu_group\";i:0;s:9:\"scan_what\";i:2;s:10:\"scan_depth\";i:-1;s:11:\"exclude_ext\";a:24:{i:0;s:3:\"png\";i:1;s:3:\"jpg\";i:2;s:4:\"jpeg\";i:3;s:3:\"gif\";i:4;s:3:\"bmp\";i:5;s:3:\"tif\";i:6;s:4:\"tiff\";i:7;s:3:\"psd\";i:8;s:3:\"fla\";i:9;s:3:\"flv\";i:10;s:3:\"mov\";i:11;s:3:\"mp3\";i:12;s:3:\"exe\";i:13;s:3:\"zip\";i:14;s:3:\"pdf\";i:15;s:3:\"css\";i:16;s:3:\"pot\";i:17;s:2:\"po\";i:18;s:2:\"mo\";i:19;s:2:\"so\";i:20;s:3:\"doc\";i:21;s:4:\"docx\";i:22;s:3:\"svg\";i:23;s:3:\"ttf\";}s:12:\"check_custom\";s:0:\"\";s:11:\"exclude_dir\";a:0:{}s:8:\"user_can\";s:16:\"activate_plugins\";s:14:\"quarantine_dir\";b:0;s:10:\"dont_check\";a:0:{}s:10:\"scan_level\";i:3;s:23:\"auto_UPDATE_definitions\";i:1;s:15:\"skip_quarantine\";i:0;s:5:\"check\";a:6:{i:0;s:8:\"htaccess\";i:1;s:8:\"timthumb\";i:2;s:8:\"backdoor\";i:3;s:5:\"known\";i:4;s:7:\"wp_core\";i:5;s:9:\"potential\";}}s:4:\"scan\";a:7:{s:3:\"dir\";s:31:\"/home/econolodge/public_html/wp\";s:5:\"start\";i:1458248376;s:4:\"type\";s:13:\"Complete Scan\";s:9:\"microtime\";d:211;s:7:\"percent\";i:-1;s:11:\"last_threat\";d:1458248587.5224850177764892578125;s:6:\"finish\";i:1458248587;}}", "yes");
INSERT INTO `wp_options` VALUES("137918", "wpseo_flush_rewrite", "1", "yes");
INSERT INTO `wp_options` VALUES("70861", "GOTMLS_Installation_Keys", "s:89:\"a:1:{s:32:\"87b6fce418c674318ece22250c5ee861\";s:35:\"http://67.23.236.217/~windriftmotel\";}\";", "yes");
INSERT INTO `wp_options` VALUES("53009", "GOTMLS_scan_log/97.96.91.241/1460489586.9378", "a:2:{s:8:\"settings\";a:14:{s:12:\"msg_position\";a:4:{i:0;s:4:\"80px\";i:1;s:4:\"40px\";i:2;s:5:\"400px\";i:3;s:5:\"600px\";}s:10:\"menu_group\";i:0;s:9:\"scan_what\";i:2;s:10:\"scan_depth\";i:-1;s:11:\"exclude_ext\";a:24:{i:0;s:3:\"png\";i:1;s:3:\"jpg\";i:2;s:4:\"jpeg\";i:3;s:3:\"gif\";i:4;s:3:\"bmp\";i:5;s:3:\"tif\";i:6;s:4:\"tiff\";i:7;s:3:\"psd\";i:8;s:3:\"fla\";i:9;s:3:\"flv\";i:10;s:3:\"mov\";i:11;s:3:\"mp3\";i:12;s:3:\"exe\";i:13;s:3:\"zip\";i:14;s:3:\"pdf\";i:15;s:3:\"css\";i:16;s:3:\"pot\";i:17;s:2:\"po\";i:18;s:2:\"mo\";i:19;s:2:\"so\";i:20;s:3:\"doc\";i:21;s:4:\"docx\";i:22;s:3:\"svg\";i:23;s:3:\"ttf\";}s:12:\"check_custom\";s:0:\"\";s:11:\"exclude_dir\";a:0:{}s:8:\"user_can\";s:16:\"activate_plugins\";s:14:\"quarantine_dir\";b:0;s:10:\"dont_check\";a:0:{}s:10:\"scan_level\";i:3;s:23:\"auto_UPDATE_definitions\";i:1;s:15:\"skip_quarantine\";i:0;s:5:\"check\";a:6:{i:0;s:8:\"htaccess\";i:1;s:8:\"timthumb\";i:2;s:8:\"backdoor\";i:3;s:5:\"known\";i:4;s:7:\"wp_core\";i:5;s:9:\"potential\";}}s:4:\"scan\";a:7:{s:3:\"dir\";s:31:\"/home/econolodge/public_html/wp\";s:5:\"start\";i:1460489608;s:4:\"type\";s:13:\"Complete Scan\";s:9:\"microtime\";d:30;s:7:\"percent\";i:-1;s:11:\"last_threat\";d:1460489638.31558990478515625;s:6:\"finish\";i:1460489638;}}", "yes");
INSERT INTO `wp_options` VALUES("54508", "addthis_shared_settings", "a:20:{s:25:\"addthis_anonymous_profile\";s:35:\"wp-d2a5e08fcef0522ac12578fdf3a6c2cf\";s:28:\"addthis_asynchronous_loading\";b:1;s:24:\"addthis_per_post_enabled\";b:1;s:15:\"addthis_profile\";s:0:\"\";s:15:\"addthis_rate_us\";s:0:\"\";s:28:\"credential_validation_status\";i:0;s:8:\"wpfooter\";b:1;s:23:\"addthis_plugin_controls\";s:9:\"WordPress\";s:19:\"addthis_environment\";s:0:\"\";s:24:\"addthis_twitter_template\";s:0:\"\";s:13:\"addthis_bitly\";b:0;s:18:\"addthis_share_json\";s:0:\"\";s:19:\"addthis_layers_json\";s:0:\"\";s:16:\"data_ga_property\";s:0:\"\";s:16:\"addthis_language\";s:0:\"\";s:9:\"atversion\";i:300;s:19:\"addthis_append_data\";b:1;s:18:\"addthis_addressbar\";b:0;s:11:\"addthis_508\";s:0:\"\";s:19:\"addthis_config_json\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("134726", "wphb-notice-uptime-info-show", "yes", "no");
INSERT INTO `wp_options` VALUES("48134", "wordfenceActivated", "1", "yes");
INSERT INTO `wp_options` VALUES("48135", "wf_plugin_act_error", "", "yes");
INSERT INTO `wp_options` VALUES("49278", "GOTMLS_nonce_array", "a:19:{s:32:\"20b460efa5f61c66d21e93ed57b9bdda\";d:1456325680.394898891448974609375;s:32:\"d8bb626d15ca0e9f190aefd5282a4776\";d:1456325738.7575490474700927734375;s:32:\"04b85cf0c25471ba2be0c37c650d3b2d\";d:1456325745.937386035919189453125;s:32:\"88aafa95f42b09aa5ea5da9a69089d89\";d:1456325753.526546001434326171875;s:32:\"8a6b5d498d31f2c1adb67ddba72afa4f\";d:1456325763.0546610355377197265625;s:32:\"0f1d628f22ffebb9d1156fdba0423c3d\";d:1456326986.1897990703582763671875;s:32:\"eb1cd231d80413d0a7485a4b67d0a8da\";d:1456348059.3610680103302001953125;s:32:\"393bd5c9a05815bc4f3977baa5fd331b\";d:1456348071.775024890899658203125;s:32:\"e27d7d7f389b73c4bb0a22dbeaea73e5\";d:1456853984.5440580844879150390625;s:32:\"f703e4b8a44a2d72e8f63689cfe88aae\";d:1458247919.76504993438720703125;s:32:\"43045fc632e70e16960f6aa5e797bf84\";d:1458247921.5751860141754150390625;s:32:\"a9533841c2b6f37e472aeeccf6c51287\";d:1458248371.4258739948272705078125;s:32:\"84646919ccb01fae10502a695eb9b440\";d:1458248375.5255920886993408203125;s:32:\"f6dfef083bf61997860edfbc2f532813\";d:1459185081.53864192962646484375;s:32:\"2e286274df3de67519088d4f9e6c1060\";d:1460489586.9377939701080322265625;s:32:\"49dfaf0e31b1d54a3f4f4e8b3c108e02\";d:410487;s:32:\"be237e9f046c2602b94aba9cb7159b8e\";d:410777;s:32:\"a24c8d9bba4441319fa3819caa58c6e6\";d:413247;s:32:\"0c71b64a4b1bf4f0ba5f76d896b05c24\";d:413562;}", "yes");
INSERT INTO `wp_options` VALUES("48143", "mainwp_child_legacy", "", "no");
INSERT INTO `wp_options` VALUES("48144", "mainwp_child_auth", "a:2:{i:5;s:32:\"741bb7cde327b4d3a5c8a2df59e691ec\";s:4:\"last\";i:1452897682;}", "no");
INSERT INTO `wp_options` VALUES("48146", "mainwp_child_uniqueId", "", "no");
INSERT INTO `wp_options` VALUES("48147", "mainwp_child_onetime_htaccess", "", "no");
INSERT INTO `wp_options` VALUES("48148", "mainwp_child_htaccess_set", "", "no");
INSERT INTO `wp_options` VALUES("48149", "mainwp_child_fix_htaccess", "", "no");
INSERT INTO `wp_options` VALUES("48150", "mainwp_child_pubkey", "", "no");
INSERT INTO `wp_options` VALUES("48151", "mainwp_child_server", "", "no");
INSERT INTO `wp_options` VALUES("48152", "mainwp_child_nonce", "", "no");
INSERT INTO `wp_options` VALUES("48153", "mainwp_child_nossl", "", "no");
INSERT INTO `wp_options` VALUES("48154", "mainwp_child_nossl_key", "", "no");
INSERT INTO `wp_options` VALUES("48155", "mainwp_child_remove_wp_version", "", "no");
INSERT INTO `wp_options` VALUES("48156", "mainwp_child_remove_rsd", "", "no");
INSERT INTO `wp_options` VALUES("48157", "mainwp_child_remove_wlw", "", "no");
INSERT INTO `wp_options` VALUES("48158", "mainwp_child_remove_core_updates", "", "no");
INSERT INTO `wp_options` VALUES("48159", "mainwp_child_remove_plugin_updates", "", "no");
INSERT INTO `wp_options` VALUES("48160", "mainwp_child_remove_theme_updates", "", "no");
INSERT INTO `wp_options` VALUES("48161", "mainwp_child_remove_php_reporting", "", "no");
INSERT INTO `wp_options` VALUES("48162", "mainwp_child_remove_scripts_version", "", "no");
INSERT INTO `wp_options` VALUES("48163", "mainwp_child_remove_styles_version", "", "no");
INSERT INTO `wp_options` VALUES("48164", "mainwp_child_remove_readme", "", "no");
INSERT INTO `wp_options` VALUES("48165", "heatMapEnabled", "", "no");
INSERT INTO `wp_options` VALUES("48166", "mainwp_child_clone_sites", "", "no");
INSERT INTO `wp_options` VALUES("48167", "mainwp_child_pluginDir", "", "no");
INSERT INTO `wp_options` VALUES("48168", "mainwp_premium_updates", "", "no");
INSERT INTO `wp_options` VALUES("48169", "mainwp_child_activated_once", "1", "no");
INSERT INTO `wp_options` VALUES("48170", "mainwp_maintenance_opt_alert_404", "", "no");
INSERT INTO `wp_options` VALUES("48171", "mainwp_maintenance_opt_alert_404_email", "", "no");
INSERT INTO `wp_options` VALUES("48174", "mainwp_temp_clone_plugins", "", "no");
INSERT INTO `wp_options` VALUES("48175", "mainwp_temp_clone_themes", "", "no");
INSERT INTO `wp_options` VALUES("48176", "mainwp_child_click_data", "", "no");
INSERT INTO `wp_options` VALUES("48177", "mainwp_child_clone_from_server_last_folder", "", "no");
INSERT INTO `wp_options` VALUES("48178", "mainwp_child_clone_permalink", "", "no");
INSERT INTO `wp_options` VALUES("48179", "mainwp_child_restore_permalink", "", "no");
INSERT INTO `wp_options` VALUES("48180", "mainwp_keyword_links_htaccess_set", "", "no");
INSERT INTO `wp_options` VALUES("48181", "mainwp_kwl_options", "", "no");
INSERT INTO `wp_options` VALUES("48182", "mainwp_kwl_keyword_links", "", "no");
INSERT INTO `wp_options` VALUES("48183", "mainwp_kwl_click_statistic_data", "", "no");
INSERT INTO `wp_options` VALUES("48184", "mainwp_kwl_statistic_data_", "", "no");
INSERT INTO `wp_options` VALUES("48185", "mainwp_kwl_enable_statistic", "", "no");
INSERT INTO `wp_options` VALUES("48186", "mainwpKeywordLinks", "", "no");
INSERT INTO `wp_options` VALUES("48187", "mainwp_branding_plugin_header", "", "no");
INSERT INTO `wp_options` VALUES("48199", "mainwp_branding_disable_wp_branding", "", "no");
INSERT INTO `wp_options` VALUES("48204", "mainwp_child_update_version", "1.3", "yes");
INSERT INTO `wp_options` VALUES("48205", "mainwp_child_plugin_version", "3.0", "yes");
INSERT INTO `wp_options` VALUES("48206", "mainwp_child_branding_disconnected", "yes", "yes");
INSERT INTO `wp_options` VALUES("48291", "theme_mods_customizr", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:3:{s:7:\"primary\";i:2;s:3:\"top\";i:0;s:6:\"footer\";i:2;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1452976082;s:4:\"data\";a:7:{s:19:\"wp_inactive_widgets\";a:1:{i:0;s:8:\"search-2\";}s:4:\"left\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}s:5:\"right\";a:2:{i:0;s:6:\"text-2\";i:1;s:6:\"text-3\";}s:10:\"footer_one\";a:0:{}s:10:\"footer_two\";a:0:{}s:12:\"footer_three\";a:0:{}s:18:\"orphaned_widgets_1\";a:0:{}}}}", "yes");
INSERT INTO `wp_options` VALUES("49277", "GOTMLS_settings_array", "a:14:{s:12:\"msg_position\";a:4:{i:0;s:4:\"80px\";i:1;s:4:\"40px\";i:2;s:5:\"400px\";i:3;s:5:\"600px\";}s:10:\"menu_group\";i:0;s:9:\"scan_what\";i:2;s:10:\"scan_depth\";i:-1;s:11:\"exclude_ext\";a:24:{i:0;s:3:\"png\";i:1;s:3:\"jpg\";i:2;s:4:\"jpeg\";i:3;s:3:\"gif\";i:4;s:3:\"bmp\";i:5;s:3:\"tif\";i:6;s:4:\"tiff\";i:7;s:3:\"psd\";i:8;s:3:\"fla\";i:9;s:3:\"flv\";i:10;s:3:\"mov\";i:11;s:3:\"mp3\";i:12;s:3:\"exe\";i:13;s:3:\"zip\";i:14;s:3:\"pdf\";i:15;s:3:\"css\";i:16;s:3:\"pot\";i:17;s:2:\"po\";i:18;s:2:\"mo\";i:19;s:2:\"so\";i:20;s:3:\"doc\";i:21;s:4:\"docx\";i:22;s:3:\"svg\";i:23;s:3:\"ttf\";}s:12:\"check_custom\";s:0:\"\";s:11:\"exclude_dir\";a:0:{}s:8:\"user_can\";s:16:\"activate_plugins\";s:14:\"quarantine_dir\";b:0;s:10:\"dont_check\";a:0:{}s:10:\"scan_level\";i:3;s:23:\"auto_UPDATE_definitions\";i:1;s:15:\"skip_quarantine\";i:0;s:5:\"check\";a:5:{i:0;s:8:\"htaccess\";i:1;s:8:\"timthumb\";i:2;s:8:\"backdoor\";i:3;s:5:\"known\";i:4;s:7:\"wp_core\";}}", "yes");
INSERT INTO `wp_options` VALUES("54509", "addthis_sharing_buttons_settings", "a:54:{s:5:\"above\";s:13:\"large_toolbox\";s:17:\"above_chosen_list\";s:0:\"\";s:19:\"above_auto_services\";b:1;s:17:\"above_custom_more\";s:0:\"\";s:22:\"above_custom_preferred\";s:0:\"\";s:21:\"above_custom_services\";s:0:\"\";s:17:\"above_custom_size\";s:0:\"\";s:19:\"above_custom_string\";s:0:\"\";s:21:\"addthis_above_enabled\";b:0;s:18:\"addthis_aftertitle\";b:0;s:22:\"addthis_beforecomments\";b:0;s:21:\"addthis_below_enabled\";b:0;s:21:\"addthis_sidebar_count\";s:1:\"5\";s:23:\"addthis_sidebar_enabled\";b:0;s:24:\"addthis_sidebar_position\";s:4:\"left\";s:30:\"addthis_mobile_toolbar_enabled\";b:0;s:43:\"addthis_mobile_toolbar_numPreferredServices\";s:1:\"4\";s:31:\"addthis_mobile_toolbar_position\";s:6:\"bottom\";s:29:\"addthis_mobile_toolbar_counts\";b:1;s:23:\"atversion_update_status\";i:0;s:5:\"below\";s:13:\"large_toolbox\";s:17:\"below_chosen_list\";s:0:\"\";s:19:\"below_auto_services\";b:1;s:17:\"below_custom_more\";s:0:\"\";s:22:\"below_custom_preferred\";s:0:\"\";s:21:\"below_custom_services\";s:0:\"\";s:17:\"below_custom_size\";s:0:\"\";s:19:\"below_custom_string\";s:0:\"\";s:8:\"location\";s:5:\"below\";s:5:\"style\";s:11:\"fb_tw_p1_sc\";s:7:\"toolbox\";s:0:\"\";s:25:\"addthis_above_showon_home\";b:1;s:26:\"addthis_above_showon_posts\";b:1;s:26:\"addthis_above_showon_pages\";b:1;s:29:\"addthis_above_showon_archives\";b:1;s:31:\"addthis_above_showon_categories\";b:1;s:29:\"addthis_above_showon_excerpts\";b:1;s:25:\"addthis_below_showon_home\";b:1;s:26:\"addthis_below_showon_posts\";b:1;s:26:\"addthis_below_showon_pages\";b:1;s:29:\"addthis_below_showon_archives\";b:1;s:31:\"addthis_below_showon_categories\";b:1;s:29:\"addthis_below_showon_excerpts\";b:1;s:27:\"addthis_sidebar_showon_home\";b:1;s:28:\"addthis_sidebar_showon_posts\";b:1;s:28:\"addthis_sidebar_showon_pages\";b:1;s:31:\"addthis_sidebar_showon_archives\";b:1;s:33:\"addthis_sidebar_showon_categories\";b:1;s:34:\"addthis_mobile_toolbar_showon_home\";b:1;s:35:\"addthis_mobile_toolbar_showon_posts\";b:1;s:35:\"addthis_mobile_toolbar_showon_pages\";b:1;s:38:\"addthis_mobile_toolbar_showon_archives\";b:1;s:40:\"addthis_mobile_toolbar_showon_categories\";b:1;s:22:\"addthis_plugin_version\";s:5:\"5.3.5\";}", "yes");
INSERT INTO `wp_options` VALUES("86765", "updraft_dropbox", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("84384", "mwp_openssl_parameters", "a:2:{s:4:\"time\";i:1522950017;s:7:\"working\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("84385", "mwp_incremental_update_active", "", "yes");
INSERT INTO `wp_options` VALUES("83813", "fresh_site", "0", "yes");
INSERT INTO `wp_options` VALUES("54511", "widget_addthis-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("83550", "GOTMLS_definitions_blob", "YTo5OntzOjc6IndwX2NvcmUiO2E6MTp7czo1OiI=LjcuMiI7YToxMzEwOntzOjEwOiIvaW5kZXgucGhwIjtzOjM2OiJiNjFiMjUzMDNiZTBmNTczYTZiOTQ=NmQ1Y2JlM2E1Yk8=MTgiO3M6MTI6Ii9saWNlbnNlLnR4dCI7czozODoiMGQwNDM=YzhiMTc2YzUyNWE2ZmNlOWNlZmRmOGUxMDZPMTk5MzUiO3M6MTY6Ii93cC1hY3RpdmF=ZS5waHAiO3M6Mzc6IjdiYTM4YjNjMmM5ZjY4NDhmYmRhZmY5NGIwYTE4MmI=TzU=NDciO3M6MTk6Ii93cC1hZG1pbi9hYm91dC5waHAiO3M6Mzg6ImM1ODE4ZDY2N2Y5N2Y=MGY2N2VjMWJiMWJlZDcxZjNhTzE4MzgyIjtzOjI=OiIvd3AtYWRtaW4vYWRtaW4tYWpheC5waHAiO3M6Mzc6ImE=ODQ1NGM5ZTY=NjEzYTU1ODA2MWI=OWE2NmNmYjExTzM3OTkiO3M6MjY6Ii93cC1hZG1pbi9hZG1pbi1mb29=ZXIucGhwIjtzOjM3OiIzN2FkMTJlOTVlYzQ3YmYxZTZhMTI4ZWI4ZDZlOTk1OE8yNzg3IjtzOjI5OiIvd3AtYWRtaW4vYWRtaW4tZnVuY3Rpb25zLnBocCI7czozNjoiYWYwYjQ2ZWFmYjI=ZTM3MzNhODgzOTgzNmQyNTYxNDZPNDA1IjtzOjI2OiIvd3AtYWRtaW4vYWRtaW4taGVhZGVyLnBocCI7czozNzoiNzQxZDgxODIxMDM5YjFmNzdmNTI1OGI5MjNkMzhmOTJPNzMzNyI7czoyNDoiL3dwLWFkbWluL2FkbWluLXBvc3QucGhwIjtzOjM3OiIxNjNlY2M1YjczYjQwY2UwMmJhNDE4YTNlZGVlMmM2OE8xNjg2IjtzOjE5OiIvd3AtYWRtaW4vYWRtaW4ucGhwIjtzOjM4OiI=NTBjN2MyYWZhMTI2ODRmMjhmZjk3NmNhZGUxMTk4NU8xMDMzOCI7czoyNjoiL3dwLWFkbWluL2FzeW5jLXVwbG9hZC5waHAiO3M6Mzc6IjMyMDQ4MWM2ODM=NDQyYmZkNzdjM2M4YmM5NTM=OGJmTzQyMTUiO3M6MjE6Ii93cC1hZG1pbi9jb21tZW5=LnBocCI7czozODoiZDc4ZmY4MmQ2ZmUyY2NhNmIwNmNmMzZkNzhhNTgxZGNPMTA=NTkiO3M6MjE6Ii93cC1hZG1pbi9jcmVkaXRzLnBocCI7czozNzoiYmI5ZGM5NjJlMTNhZmMzNzg5YjBkMThhM2M2Y2YxZjdPNDc=NCI7czoyNzoiL3dwLWFkbWluL2Nzcy9hYm91dC1ydGwuY3NzIjtzOjM3OiI5ZjY4ODEyNDM3ZTE4Y2M1YjI3YjQ4YWRlMDFlNjMxOU84Nzk2IjtzOjMxOiIvd3AtYWRtaW4vY3NzL2Fib3V=LXJ=bC5taW4uY3NzIjtzOjM3OiJjYWQ=MzgzODRkNjhkMTczMjlmYzEzN2RjNGU3MGY2Zk82MjQxIjtzOjIzOiIvd3AtYWRtaW4vY3NzL2Fib3V=LmNzcyI7czozNzoiMDU4YTVjOTRhMTY2MTMyMDRiOGI5ODNiZTAzYjE2YzZPODc5OSI7czoyNzoiL3dwLWFkbWluL2Nzcy9hYm91dC5taW4uY3NzIjtzOjM3OiJjMzIxMjlmMzhhNjEwYWZlYjVkYWI4NGNjMmI=MmU=Y=82MjQ=IjtzOjMyOiIvd3AtYWRtaW4vY3NzL2FkbWluLW1lbnUtcnRsLmNzcyI7czozODoiNGRmNmFmOGQyNzRjOWM4NGYwMDk5NWM=YjA2Yjg2NjhPMTk2ODgiO3M6MzY6Ii93cC1hZG1pbi9jc3MvYWRtaW4tbWVudS1ydGwubWluLmNzcyI7czozODoiNzgzNGY3NTZkZjdiY2Q5YjYxNThjYWJlZmUxMGZlYjVPMTYwMDciO3M6Mjg6Ii93cC1hZG1pbi9jc3MvYWRtaW4tbWVudS5jc3MiO3M6Mzg6IjVlMTM=OTE2MWE4NTgzOWJlMDI=NDg4YTUwZGU5NWIzTzE5Njc=IjtzOjMyOiIvd3AtYWRtaW4vY3NzL2FkbWluLW1lbnUubWluLmNzcyI7czozODoiMTA1NmYzMjcyZWJlODNmMTNkNWQzZjg2YTgyYTc3ZjRPMTU5OTMiO3M6MzQ6Ii93cC1hZG1pbi9jc3MvY29sb3ItcGlja2VyLXJ=bC5jc3MiO3M6Mzc6ImY4NzVmZmFkNTU1M2Q2NjJiZWVhOTdlNjNlYzI=YmJmTzI1NDIiO3M6Mzg6Ii93cC1hZG1pbi9jc3MvY29sb3ItcGlja2VyLXJ=bC5taW4uY3NzIjtzOjM3OiI2OTk2YmE5NGY=YjM=Zjc2NjY3M2FlODc5ZTRhNDJkNU8yMTQ3IjtzOjMwOiIvd3AtYWRtaW4vY3NzL2NvbG9yLXBpY2tlci5jc3MiO3M6Mzc6IjEyYjYwZDk=Zjk4MjZkNDAyZTY2YzJlOTE5NGFhODBiTzI1MzkiO3M6MzQ6Ii93cC1hZG1pbi9jc3MvY29sb3ItcGlja2VyLm1pbi5jc3MiO3M6Mzc6IjljN2Y=YWRjMGNkMWZlMWExNWU4OWZmNDA4MmY=YjdjTzIxNDQiO3M6NDA6Ii93cC1hZG1pbi9jc3MvY29sb3JzL2JsdWUvY29sb3JzLXJ=bC5jc3MiO3M6Mzg6ImQ2OTQ4OWQyNjMyMmQwMWQzYjI4NGE2YjcxYTY1ZjlhTzEzMTcwIjtzOjQ=OiIvd3AtYWRtaW4vY3NzL2NvbG9ycy9ibHVlL2NvbG9ycy1ydGwubWluLmNzcyI7czozODoiZDc2ZTNmOTkzZjk2MjMyNmU2YTIzMzZkYjc1ZDNmZDZPMTE=MzgiO3M6MzY6Ii93cC1hZG1pbi9jc3MvY29sb3JzL2JsdWUvY29sb3JzLmNzcyI7czozODoiOGIyOTg4MWNkOGEwMjRhZjFjODkwZjY4OTg5M2U1MGJPMTMxNzIiO3M6NDA6Ii93cC1hZG1pbi9jc3MvY29sb3JzL2JsdWUvY29sb3JzLm1pbi5jc3MiO3M6Mzg6IjgzNTIyOGY=MzdiNzZjYjQzMzZmZDJkYjE4NDFhOTg=TzExNDQwIjtzOjM3OiIvd3AtYWRtaW4vY3NzL2NvbG9ycy9ibHVlL2NvbG9ycy5zY3NzIjtzOjM2OiJkOWQwMzU=OWQ3OTQ4NDY3MmMyOTE=NWFhZDU5NGRiM=8yNDkiO3M6NDI6Ii93cC1hZG1pbi9jc3MvY29sb3JzL2NvZmZlZS9jb2xvcnMtcnRsLmNzcyI7czozODoiNzRkYWI2MTJiNjI2NDdlZWFjNTYxMDJkOWZkZWQ=OTZPMTMxOTQiO3M6NDY6Ii93cC1hZG1pbi9jc3MvY29sb3JzL2NvZmZlZS9jb2xvcnMtcnRsLm1pbi5jc3MiO3M6Mzg6ImY4NjdmZDdhZGNjZDFlY2RmNzY=NzM5MDUzYTZlYzJhTzExNDczIjtzOjM4OiIvd3AtYWRtaW4vY3NzL2NvbG9ycy9jb2ZmZWUvY29sb3JzLmNzcyI7czozODoiMmJkODNjNDNhZWQ2MGMxNzVhMGY4YzVkMjczODYzOWJPMTMxOTYiO3M6NDI6Ii93cC1hZG1pbi9jc3MvY29sb3JzL2NvZmZlZS9jb2xvcnMubWluLmNzcyI7czozODoiYTU4NWQ=ZWIzMjMzMmQ5MGIyM2Y3OTIzMTJiYzRkOGFPMTE=NzUiO3M6Mzk6Ii93cC1hZG1pbi9jc3MvY29sb3JzL2NvZmZlZS9jb2xvcnMuc2NzcyI7czozNjoiMzk3ZTM4MjBiMjdhMjM=MzMwYzk1ZTA1MjUwZjYxY2VPMTM1IjtzOjQ1OiIvd3AtYWRtaW4vY3NzL2NvbG9ycy9lY3RvcGxhc2=vY29sb3JzLXJ=bC5jc3MiO3M6Mzg6IjA5M2RjY2UxNTg4YzNiOGNjNGI=MGZjMzExOTc=NDEyTzEzMTk=IjtzOjQ5OiIvd3AtYWRtaW4vY3NzL2NvbG9ycy9lY3RvcGxhc2=vY29sb3JzLXJ=bC5taW4uY3NzIjtzOjM4OiIxZTVhZTg5MGE=OWFmNGQwNjlhNGY3MzJkODViMWRlM=8xMTQ3MyI7czo=MToiL3dwLWFkbWluL2Nzcy9jb2xvcnMvZWN=b3BsYXNtL2NvbG9ycy5jc3MiO3M6Mzg6ImIyMWYzMjk1M2FkMTY3NDI=ZTk5OTdjOGZmNTMzMGFlTzEzMTk2IjtzOjQ1OiIvd3AtYWRtaW4vY3NzL2NvbG9ycy9lY3RvcGxhc2=vY29sb3JzLm1pbi5jc3MiO3M6Mzg6IjNjMTIxODYyYTBiYTViM2JkNDg5ZDQyOGNjOTI2NjI=TzExNDc1IjtzOjQyOiIvd3AtYWRtaW4vY3NzL2NvbG9ycy9lY3RvcGxhc2=vY29sb3JzLnNjc3MiO3M6MzY6Ijk=MDE3MWQxMzkyYmQ4MDcxMTIyYTkwNWQxMmI5MTk1TzE1NyI7czo=MToiL3dwLWFkbWluL2Nzcy9jb2xvcnMvbGlnaHQvY29sb3JzLXJ=bC5jc3MiO3M6Mzg6ImY2MGUwZWI=N2Y4MWJiYzYzM2ExOWIxOWU2Y2Y2ZjdiTzEzODI1IjtzOjQ1OiIvd3AtYWRtaW4vY3NzL2NvbG9ycy9saWdodC9jb2xvcnMtcnRsLm1pbi5jc3MiO3M6Mzg6ImQxMmM2MzIxYzI5MDVhNzIwODFlMDdkMWYzNjk2NTMyTzExODYzIjtzOjM3OiIvd3AtYWRtaW4vY3NzL2NvbG9ycy9saWdodC9jb2xvcnMuY3NzIjtzOjM4OiJiMGEyZTQxY2M4ZTRmYzFkMjBiNTE5MjNjYzE=MTJiNk8xMzgyNyI7czo=MToiL3dwLWFkbWluL2Nzcy9jb2xvcnMvbGlnaHQvY29sb3JzLm1pbi5jc3MiO3M6Mzg6IjRjMjk5ZmE=MjQxMTFmNWMwOGExOTY1MDExY2VjMjEwTzExODY1IjtzOjM4OiIvd3AtYWRtaW4vY3NzL2NvbG9ycy9saWdodC9jb2xvcnMuc2NzcyI7czozNzoiNDgwYjliZDY=N2U1YjMyM2VmODhkNjNjZTU1ZTFkNmZPMTExOSI7czo=NDoiL3dwLWFkbWluL2Nzcy9jb2xvcnMvbWlkbmlnaHQvY29sb3JzLXJ=bC5jc3MiO3M6Mzg6Ijk1Mjc5MTRkZWU2M2E4OWNmNzI=NzNmYjIzYmYwNjNmTzEzMTk=IjtzOjQ4OiIvd3AtYWRtaW4vY3NzL2NvbG9ycy9taWRuaWdodC9jb2xvcnMtcnRsLm1pbi5jc3MiO3M6Mzg6ImVjYjE2OGFjODgxYjE5NzQzODZkNjcyMjAxODU4OWRmTzExNDczIjtzOjQwOiIvd3AtYWRtaW4vY3NzL2NvbG9ycy9taWRuaWdodC9jb2xvcnMuY3NzIjtzOjM4OiIwNjU3NTA4YjE=YzA2MzU2NGYwMDAxODc4ZWE4OGQwN=8xMzE5NiI7czo=NDoiL3dwLWFkbWluL2Nzcy9jb2xvcnMvbWlkbmlnaHQvY29sb3JzLm1pbi5jc3MiO3M6Mzg6ImVjNjc4ZjE5ZTE2ODFhZTNjZmM2Y2MxNWQxYjBhMTI4TzExNDc1IjtzOjQxOiIvd3AtYWRtaW4vY3NzL2NvbG9ycy9taWRuaWdodC9jb2xvcnMuc2NzcyI7czozNjoiMjZkYzhkYWFmMGM=N2M=NDU3YjhiYzIxNDVmNDg2MzRPMTA2IjtzOjQxOiIvd3AtYWRtaW4vY3NzL2NvbG9ycy9vY2Vhbi9jb2xvcnMtcnRsLmNzcyI7czozODoiMGQ4NjhmZTc3YzU1YWE4MDg2ODE1NTQxYTVmZWJkZjVPMTMxOTQiO3M6NDU6Ii93cC1hZG1pbi9jc3MvY29sb3JzL29jZWFuL2NvbG9ycy1ydGwubWluLmNzcyI7czozODoiZTZjNmNjYmY5ZDMzMjQ5ODczMjRlZDI4MDJhNjk1ZGVPMTE=NzMiO3M6Mzc6Ii93cC1hZG1pbi9jc3MvY29sb3JzL29jZWFuL2NvbG9ycy5jc3MiO3M6Mzg6IjNhNTFhMzk1NDgzZDc3NzU3YzllMWQyMzY2NTE=MTdiTzEzMTk2IjtzOjQxOiIvd3AtYWRtaW4vY3NzL2NvbG9ycy9vY2Vhbi9jb2xvcnMubWluLmNzcyI7czozODoiNmRlZjYzMWRjZTEwODRjZDVlNDdlYzIzNjk5N2FjNzZPMTE=NzUiO3M6Mzg6Ii93cC1hZG1pbi9jc3MvY29sb3JzL29jZWFuL2NvbG9ycy5zY3NzIjtzOjM2OiIxYTdjNWJmZDlmYWY3ZjZjYzc3Y2Q5YjE2NjA2MjU2OE8xNTciO3M6NDM6Ii93cC1hZG1pbi9jc3MvY29sb3JzL3N1bnJpc2UvY29sb3JzLXJ=bC5jc3MiO3M6Mzg6ImQxZWU=NmM5NWMxZmVlNTgxNjY1MmVlMTIwYTcwZjZiTzEzMTk=IjtzOjQ3OiIvd3AtYWRtaW4vY3NzL2NvbG9ycy9zdW5yaXNlL2NvbG9ycy1ydGwubWluLmNzcyI7czozODoiYzI3MTgwNTIwMjdlOWQ2NGY2NWZkY2M2ODMzNjhhZjdPMTE=NzMiO3M6Mzk6Ii93cC1hZG1pbi9jc3MvY29sb3JzL3N1bnJpc2UvY29sb3JzLmNzcyI7czozODoiMzZkYTMxMDI5MDE=ZDVjYmEyZTFkNmIyYzNjOTQ5MDNPMTMxOTYiO3M6NDM6Ii93cC1hZG1pbi9jc3MvY29sb3JzL3N1bnJpc2UvY29sb3JzLm1pbi5jc3MiO3M6Mzg6ImUxNTk2MmI5ZDc1OGNhMmM1OTkxNjNmZjYwYzZkNTI4TzExNDc1IjtzOjQwOiIvd3AtYWRtaW4vY3NzL2NvbG9ycy9zdW5yaXNlL2NvbG9ycy5zY3NzIjtzOjM2OiI1NjkyODcxYThhN2ExOTE=ZWUwOTY4ZGRmOTkyM2RlY=8xNjYiO3M6MzI6Ii93cC1hZG1pbi9jc3MvY29sb3JzL19hZG1pbi5zY3NzIjtzOjM4OiJiZDIwOTRlOWRjMzIwOWU4Mzk=NzZlYmEwMGZmNTgzOE8xMTgyMyI7czozMzoiL3dwLWFkbWluL2Nzcy9jb2xvcnMvX21peGlucy5zY3NzIjtzOjM3OiIxZjVhNTJiMzFjZjVhYmE2MTNhYTg=NWYyZGI3YWM5Zk8xNDUyIjtzOjM2OiIvd3AtYWRtaW4vY3NzL2NvbG9ycy9fdmFyaWFibGVzLnNjc3MiO3M6Mzc6IjNhYjUwMTA5NmIxYTA5MTk3MmQ4NGM4NWIyODQxMzVhTzE4NTQiO3M6Mjg6Ii93cC1hZG1pbi9jc3MvY29tbW9uLXJ=bC5jc3MiO3M6Mzg6Ijg2Y2NmNTZiYmY3NDc4ZWYwNmIyYmYxMmU5M2JkYzNjTzY5NjA1IjtzOjMyOiIvd3AtYWRtaW4vY3NzL2NvbW1vbi1ydGwubWluLmNzcyI7czozODoiNTdkMWQyMzFkODRkMTZlMTA2OGY2YWY4MjE5YzE2YmJPNTMyMDMiO3M6MjQ6Ii93cC1hZG1pbi9jc3MvY29tbW9uLmNzcyI7czozODoiYjE5OTJiNmRlMzYwMGY4MmI4OTNhYTYxMjNmMjk3MmRPNjk1OTQiO3M6Mjg6Ii93cC1hZG1pbi9jc3MvY29tbW9uLm1pbi5jc3MiO3M6Mzg6IjE5NzgzYzBjOGM4MjI1YjNmYzMxZWEwNGU3N2VlNTBhTzUzMTkzIjtzOjQwOiIvd3AtYWRtaW4vY3NzL2N1c3RvbWl6ZS1jb25=cm9scy1ydGwuY3NzIjtzOjM4OiI5Y2EyZjk3Yjk3ZjMzZTA3MjgxNDc3Mjk=OGFkMDUxYU8=NTA5OSI7czo=NDoiL3dwLWFkbWluL2Nzcy9jdXN=b21pemUtY29udHJvbHMtcnRsLm1pbi5jc3MiO3M6Mzg6ImNkZjVmNGJiMDQ5ZjYzZDBjMTAyZWVmZTEwNjU5NWU1TzM3NTY1IjtzOjM2OiIvd3AtYWRtaW4vY3NzL2N1c3RvbWl6ZS1jb25=cm9scy5jc3MiO3M6Mzg6IjMxOGM=OWYxNGQ5ZjkyZjYyYmI=NTY=MWNiM2Y5ZWI1TzQ1MDcyIjtzOjQwOiIvd3AtYWRtaW4vY3NzL2N1c3RvbWl6ZS1jb25=cm9scy5taW4uY3NzIjtzOjM4OiIxZDg2MzJlOThkYWYwNzE4ZDFiMDk5OGI=MzJkNDhjY=8zNzUzOSI7czo=MToiL3dwLWFkbWluL2Nzcy9jdXN=b21pemUtbmF2LW1lbnVzLXJ=bC5jc3MiO3M6Mzg6ImJmMzNmZTFlNDZkMDhlMzYyZWEwOGE5Y2ZmOWM=MjhhTzIxODA1IjtzOjQ1OiIvd3AtYWRtaW4vY3NzL2N1c3RvbWl6ZS1uYXYtbWVudXMtcnRsLm1pbi5jc3MiO3M6Mzg6IjBhY2E1ZmM5NTdkN2Q2NWI3ZGM5MDg5NjdkZjhkMmMxTzE3NjgxIjtzOjM3OiIvd3AtYWRtaW4vY3NzL2N1c3RvbWl6ZS1uYXYtbWVudXMuY3NzIjtzOjM4OiIzYjFhNTRiMGVmMWU=ZmVlYmQ1NzdjMjY4ZjNiN2I1Nk8yMTc5MCI7czo=MToiL3dwLWFkbWluL2Nzcy9jdXN=b21pemUtbmF2LW1lbnVzLm1pbi5jc3MiO3M6Mzg6IjUwMzkyYTk1NGE5NTFlNDYxNzczNTViZTQ=YzIxOTE=TzE3NjY2IjtzOjM5OiIvd3AtYWRtaW4vY3NzL2N1c3RvbWl6ZS13aWRnZXRzLXJ=bC5jc3MiO3M6Mzg6IjdkZDJhNzlkMjg1ZTYwN2JlMWFjMzE1MzRmYThjNmYxTzExNjg4IjtzOjQzOiIvd3AtYWRtaW4vY3NzL2N1c3RvbWl6ZS13aWRnZXRzLXJ=bC5taW4uY3NzIjtzOjM3OiJiYzYwMzVlYmNjMjg2Mzk5YWU4MGM2MzkzMzU2MmZhYU85NTAyIjtzOjM1OiIvd3AtYWRtaW4vY3NzL2N1c3RvbWl6ZS13aWRnZXRzLmNzcyI7czozODoiNDlmMGFkNjNhOTBkNmNmMzE=NmFlZjVmNzA1MzYxYWRPMTE2ODUiO3M6Mzk6Ii93cC1hZG1pbi9jc3MvY3VzdG9taXplLXdpZGdldHMubWluLmNzcyI7czozNzoiYjhhYmY4NTMzYjllOGVkMzUxZTZmMzJiMmIyZTQ5YzhPOTQ5OSI7czozMToiL3dwLWFkbWluL2Nzcy9kYXNoYm9hcmQtcnRsLmNzcyI7czozODoiZDNjM2ZjYzlmODE=ZDU1ZDQwZjYxMWJmNTY4MGUwYjZPMjA1NDIiO3M6MzU6Ii93cC1hZG1pbi9jc3MvZGFzaGJvYXJkLXJ=bC5taW4uY3NzIjtzOjM4OiI4NWQ1NGJiMzQzYTMxYjYyMGExYWYyZDQyOWZjNTQzNk8xNjE2NyI7czoyNzoiL3dwLWFkbWluL2Nzcy9kYXNoYm9hcmQuY3NzIjtzOjM4OiJlZGU=MGE=YTJjMThiZWU4YjkzYzAxZjdlNTUyNDVhOE8yMDU=MyI7czozMToiL3dwLWFkbWluL2Nzcy9kYXNoYm9hcmQubWluLmNzcyI7czozODoiMTUxZGZlOThmZTgxY2YzMDNkZGQ1MTIyOGFjNmYzZDBPMTYxNjciO3M6Mzg6Ii93cC1hZG1pbi9jc3MvZGVwcmVjYXRlZC1tZWRpYS1ydGwuY3NzIjtzOjM3OiIwNzFkYjc4NDQ5ZTUyYjVhOGU=Zjc=ODgxZjQ1Y2E3Nk82NTA=IjtzOjQyOiIvd3AtYWRtaW4vY3NzL2RlcHJlY2F=ZWQtbWVkaWEtcnRsLm1pbi5jc3MiO3M6Mzc6ImFjNWJjMDJiNzEwZTM1MTE1Y2FkY2E5NjAzMDg1NjBjTzUzMjIiO3M6MzQ6Ii93cC1hZG1pbi9jc3MvZGVwcmVjYXRlZC1tZWRpYS5jc3MiO3M6Mzc6IjIyNTdmNTJhOTJkNzgxNzE5NWM3ZWE5NjU5MzQ1ZWMwTzY1MDQiO3M6Mzg6Ii93cC1hZG1pbi9jc3MvZGVwcmVjYXRlZC1tZWRpYS5taW4uY3NzIjtzOjM3OiJiMWNjODAzMGViOWE4MDZmMmZhM2E=YWVlY2RhYzg3Y=81MzIyIjtzOjI2OiIvd3AtYWRtaW4vY3NzL2VkaXQtcnRsLmNzcyI7czozODoiNmY=OGVmNmE=NTM5M2VmZGZkZmJlOGY4ZWQ2YTI1MDZPMjg1ODEiO3M6MzA6Ii93cC1hZG1pbi9jc3MvZWRpdC1ydGwubWluLmNzcyI7czozODoiYTcyYmQzMmYzZDIxYzNmY2RhMzg1YWYzZThiZmY1ZTNPMjI=NjciO3M6MjI6Ii93cC1hZG1pbi9jc3MvZWRpdC5jc3MiO3M6Mzg6IjA5MDJlZGIxYjMzZTYyZGYzYjg5ZTQyZWUwZmI5Mjg=TzI4NTc=IjtzOjI2OiIvd3AtYWRtaW4vY3NzL2VkaXQubWluLmNzcyI7czozODoiMzZiZWJhNDlkZGQ3MDM2NTcwNGU2OGI2NjQxY2FiNjNPMjI=NjAiO3M6MzI6Ii93cC1hZG1pbi9jc3MvZmFyYnRhc3RpYy1ydGwuY3NzIjtzOjM2OiIxMThmMTE4OWZmYmI3MWUwMTQ=MDIxMjFiNTQ1NmJjMk82MTIiO3M6MzY6Ii93cC1hZG1pbi9jc3MvZmFyYnRhc3RpYy1ydGwubWluLmNzcyI7czozNjoiMWE4ODRjMDk2MzdhNDdhZjMwMGM3ZTZjMzA1N2RkYzJPNTAzIjtzOjI4OiIvd3AtYWRtaW4vY3NzL2ZhcmJ=YXN=aWMuY3NzIjtzOjM2OiJmOWUzMzgyOWI4ZmFlZDdkN2JiZWY4NDNmYjY4MzI1NU82MTEiO3M6MzI6Ii93cC1hZG1pbi9jc3MvZmFyYnRhc3RpYy5taW4uY3NzIjtzOjM2OiIzMDk5Njk4MWMxMjliZDMzMWI1Y2RiYjg4YTJmYTIzYk81MDIiO3M6Mjc6Ii93cC1hZG1pbi9jc3MvZm9ybXMtcnRsLmNzcyI7czozODoiMTk1ZjU1ZjYzNDRhZjZhYjQ=ODNkZTQwZmNhZjZkNDZPMjU3MDIiO3M6MzE6Ii93cC1hZG1pbi9jc3MvZm9ybXMtcnRsLm1pbi5jc3MiO3M6Mzg6IjdlZTRjNGE1ODIwNDI=MDlkMTMyNDM1NDI3MWRkMzNhTzE5NTgwIjtzOjIzOiIvd3AtYWRtaW4vY3NzL2Zvcm1zLmNzcyI7czozODoiNzBmYTY=M2Q3MTM3MGNiYWFmZTk3NGFkOWNhMDQ1NjlPMjU2OTAiO3M6Mjc6Ii93cC1hZG1pbi9jc3MvZm9ybXMubWluLmNzcyI7czozODoiZWNiMWZjZjlmZDE1M2JlOTYxYTI5N2I5MWQ1ZGJmZTVPMTk1NzEiO3M6MjQ6Ii93cC1hZG1pbi9jc3MvaWUtcnRsLmNzcyI7czozODoiMTJlMzc5OWYwMDdkMTg3NmIxMjgzNWQwZTVlZjJmNTJPMTIwMDkiO3M6Mjg6Ii93cC1hZG1pbi9jc3MvaWUtcnRsLm1pbi5jc3MiO3M6Mzg6IjI5NjI4ZjI=MGNlYjM5NmVmMGI1NmRhMTljZjMwZjhjTzEwMTk1IjtzOjIwOiIvd3AtYWRtaW4vY3NzL2llLmNzcyI7czozODoiYTg2YmM5M2NiZGRiMWEyYjQ=ZmIzMGE=NmY2NmE4YWRPMTIwMDIiO3M6MjQ6Ii93cC1hZG1pbi9jc3MvaWUubWluLmNzcyI7czozODoiM2FkMTBlMTViNTM2ZDI=Njk4OGU=MTA3MzcyMTkyYWRPMTAxODkiO3M6Mjk6Ii93cC1hZG1pbi9jc3MvaW5zdGFsbC1ydGwuY3NzIjtzOjM3OiI5YzlmMjg2MzI4MzgxNDZlYTViMWY5ZGU5YWMyODljOE83Mzk=IjtzOjMzOiIvd3AtYWRtaW4vY3NzL2luc3RhbGwtcnRsLm1pbi5jc3MiO3M6Mzc6Ijk3ZTRkNWM2M2E=YmQzYTRmMDczYmJhNWRjYWI4Y2E2TzU5NjciO3M6MjU6Ii93cC1hZG1pbi9jc3MvaW5zdGFsbC5jc3MiO3M6Mzc6ImI1YWFjODQyODNhYTcxODNjMzBhMjU1MjdlZGQzMTUyTzczOTMiO3M6Mjk6Ii93cC1hZG1pbi9jc3MvaW5zdGFsbC5taW4uY3NzIjtzOjM3OiJlOTU4MDZlNzRkMDkzOTBhYmMzZGM3YjgwOTRjZGVlYU81OTY2IjtzOjI2OiIvd3AtYWRtaW4vY3NzL2wxMG4tcnRsLmNzcyI7czozNzoiNjliMDUyN2JlNWIzYWEyYzE2NDRmZTVmYzFjMzRhZmFPMzY5MiI7czozMDoiL3dwLWFkbWluL2Nzcy9sMTBuLXJ=bC5taW4uY3NzIjtzOjM3OiIzOTVlYmJiMDFmMDQ5OWRjNzkzMjNkOWU=NmJmOTljOU8yNDI2IjtzOjIyOiIvd3AtYWRtaW4vY3NzL2wxMG4uY3NzIjtzOjM3OiJiNWM=YjhmODUwMjlmYjdjODRmMDcxOWY3MmIyODBhZE8zNjg5IjtzOjI2OiIvd3AtYWRtaW4vY3NzL2wxMG4ubWluLmNzcyI7czozNzoiNTVkNmI1N2Q4MDIwZDk4MWRkMTJlMzMwOGM2ZDMyNmVPMjQyMyI7czozMzoiL3dwLWFkbWluL2Nzcy9saXN=LXRhYmxlcy1ydGwuY3NzIjtzOjM4OiI3NDZiMjNjZDk1NWEwYjcxMDdmNTdiODNiYjQyZWFhOE8=MDM5MCI7czozNzoiL3dwLWFkbWluL2Nzcy9saXN=LXRhYmxlcy1ydGwubWluLmNzcyI7czozODoiNzAzYTZhMjA4NTMxNDA3NDI1NjRjMTk3NzgzZDc1NzRPMzIzOTIiO3M6Mjk6Ii93cC1hZG1pbi9jc3MvbGlzdC1=YWJsZXMuY3NzIjtzOjM4OiI=MmQxNzE=OWM4YmZkZDdiZWJhYjBmNTMwOTFhNTQwYU8=MDM2MSI7czozMzoiL3dwLWFkbWluL2Nzcy9saXN=LXRhYmxlcy5taW4uY3NzIjtzOjM4OiIxOTc5YTAzZTczZGUyYmZlOGFhOTBhYWQ5ZmZkNjA3M=8zMjM2NiI7czoyNzoiL3dwLWFkbWluL2Nzcy9sb2dpbi1ydGwuY3NzIjtzOjM3OiI5NGZjNGIxYjNiNTA2ZmFlOTVlNjVjMDFlYzgwNjBhZE8=MTYwIjtzOjMxOiIvd3AtYWRtaW4vY3NzL2xvZ2luLXJ=bC5taW4uY3NzIjtzOjM4OiIyNzMwZTkzM2M3YTFhMzQyYTIxNmE4OGI1OTA5MDkyMk8yNTQyOCI7czoyMzoiL3dwLWFkbWluL2Nzcy9sb2dpbi5jc3MiO3M6Mzc6ImU5OGFhMWYxZDE=ZmQ=ZmQyYjgwZDQ1Njk=OGI2MjYyTzQxNDgiO3M6Mjc6Ii93cC1hZG1pbi9jc3MvbG9naW4ubWluLmNzcyI7czozODoiNTk4NmExNjgwNTM4YWM4ZTgzZDIxNzAyN2Q1NzU=M2ZPMjU=MTIiO3M6Mjc6Ii93cC1hZG1pbi9jc3MvbWVkaWEtcnRsLmNzcyI7czozODoiZDVmYmJjODAxNTViNTQxNGYyYTRkYTljODUyYmI5YzBPMjQxNTkiO3M6MzE6Ii93cC1hZG1pbi9jc3MvbWVkaWEtcnRsLm1pbi5jc3MiO3M6Mzg6ImRlMDgwOWYyYzk2NzVkMDlmZTRmNDhiNjE3YTdlNmExTzE5NTI=IjtzOjIzOiIvd3AtYWRtaW4vY3NzL21lZGlhLmNzcyI7czozODoiNDhiYWJjOTgxY2YwZjQzOWE3NjkyODZkNmE3MGZkNDhPMjQxNTciO3M6Mjc6Ii93cC1hZG1pbi9jc3MvbWVkaWEubWluLmNzcyI7czozODoiMzFiYjlkNzY3ZGM2NjA4ODNjYmU=ZjEzOWQ=YTE1OTRPMTk1MjMiO3M6MzE6Ii93cC1hZG1pbi9jc3MvbmF2LW1lbnVzLXJ=bC5jc3MiO3M6Mzg6IjYzYWY2NGJhODlmNzY4ZTQ=OGJhYjg3ZWUwY2I5NGRhTzE1ODYyIjtzOjM1OiIvd3AtYWRtaW4vY3NzL25hdi1tZW51cy1ydGwubWluLmNzcyI7czozODoiOTg1YjMzYzNhNDQ2OTFjMGU1OWIzYjQwZGQ1ZGY2MTFPMTI1MjEiO3M6Mjc6Ii93cC1hZG1pbi9jc3MvbmF2LW1lbnVzLmNzcyI7czozODoiNWZjNmFiOTQ1ZTI4YzNlYzEwMThkMjczNTlmYzZmZTBPMTU4MzUiO3M6MzE6Ii93cC1hZG1pbi9jc3MvbmF2LW1lbnVzLm1pbi5jc3MiO3M6Mzg6ImYyMzZmOTUzZDczMmZmZWE4MTg3NGYyMzIyNDZhNDI3TzEyNDk=IjtzOjM5OiIvd3AtYWRtaW4vY3NzL3ByZXNzLXRoaXMtZWRpdG9yLXJ=bC5jc3MiO3M6Mzc6IjQ2NGRhODQ4OTgwNDc2Y2QzN2RlMWMwZDc5NjRjMWU=TzEzNjgiO3M6NDM6Ii93cC1hZG1pbi9jc3MvcHJlc3MtdGhpcy1lZGl=b3ItcnRsLm1pbi5jc3MiO3M6MzY6IjE=M2RhNGU5NzlmZDg2ZTAwMmZiYTZjZGEzMzhjZjdjTzc4MyI7czozNToiL3dwLWFkbWluL2Nzcy9wcmVzcy1=aGlzLWVkaXRvci5jc3MiO3M6Mzc6ImIwMTk=MTQ2MzcyMWE5ZTNkMzZkNGI=ZGMzNzgxYzY2TzEzNjciO3M6Mzk6Ii93cC1hZG1pbi9jc3MvcHJlc3MtdGhpcy1lZGl=b3IubWluLmNzcyI7czozNjoiMmNmMzM=NGNiNzM3ZWM2MjI1MzI1OTZhYzIxY2I4NWZPNzgyIjtzOjMyOiIvd3AtYWRtaW4vY3NzL3ByZXNzLXRoaXMtcnRsLmNzcyI7czozODoiZGUwNWU5MmUzOWRkN2M1NDg4N2U5YWZmMDU5MjhhZTJPMzQ=NDEiO3M6MzY6Ii93cC1hZG1pbi9jc3MvcHJlc3MtdGhpcy1ydGwubWluLmNzcyI7czozODoiZDRjNDE1NWZmZjY2OTQ1ZWYzNjdmODFiOWYwMDdmMjNPMjcxOTEiO3M6Mjg6Ii93cC1hZG1pbi9jc3MvcHJlc3MtdGhpcy5jc3MiO3M6Mzg6IjY3MGQwN2IzNzlmNWJmYWQwOGUwNjI1ZWVjNDY5OWJjTzM=NDIzIjtzOjMyOiIvd3AtYWRtaW4vY3NzL3ByZXNzLXRoaXMubWluLmNzcyI7czozODoiMDFhZTk5NDZlN2E3YTA4YzMyZjEyNjFkMDMxYzAzMjBPMjcxNzMiO3M6MzE6Ii93cC1hZG1pbi9jc3MvcmV2aXNpb25zLXJ=bC5jc3MiO3M6Mzg6ImQyYmI5MWE1ZTE3NTE4MmZkOThiOTI=MjMyNDViODg2TzEwNTg2IjtzOjM1OiIvd3AtYWRtaW4vY3NzL3JldmlzaW9ucy1ydGwubWluLmNzcyI7czozNzoiMDExNGM3OWQ4OWQzZTBlZGQxNGQ3MTFjODY4ZDRmZDdPODY5OCI7czoyNzoiL3dwLWFkbWluL2Nzcy9yZXZpc2lvbnMuY3NzIjtzOjM4OiIyMzExODg3YTFlMTdiOTQyZGU2MTdiYTcwYmFlZGEzNk8xMDU3MSI7czozMToiL3dwLWFkbWluL2Nzcy9yZXZpc2lvbnMubWluLmNzcyI7czozNzoiN2RiNTMwNGVjMjA2NzdjNDZiYmNiZDdiOWU5ZmEzNTBPODY4MyI7czozMToiL3dwLWFkbWluL2Nzcy9zaXRlLWljb24tcnRsLmNzcyI7czozNzoiMDZmYTIwNjI5MDBlYzliOTU2MTQwMzYyNTA1MGM5MzlPMTA1MyI7czozNToiL3dwLWFkbWluL2Nzcy9zaXRlLWljb24tcnRsLm1pbi5jc3MiO3M6MzY6IjUyMTg5ZThmMTg2MjAwMWI3YmQxZjVmMGVkNzFkMzBhTzczOCI7czoyNzoiL3dwLWFkbWluL2Nzcy9zaXRlLWljb24uY3NzIjtzOjM3OiIwMmYzN2M5NTU1MmRjN2NkYTVlMmNhM2M=ZWY2YWMyME8xMDUxIjtzOjMxOiIvd3AtYWRtaW4vY3NzL3NpdGUtaWNvbi5taW4uY3NzIjtzOjM2OiI2NmE1MzM2Mjg=ZGI2ZGM5ODc=NzY=ZmE4NTQ4YTQ3MU83MzYiO3M6Mjg6Ii93cC1hZG1pbi9jc3MvdGhlbWVzLXJ=bC5jc3MiO3M6Mzg6ImI4NDVlMjgwNDQ4N2EyYzVhNGI2NDkzOGE2YzQzMWUxTzQxNTg4IjtzOjMyOiIvd3AtYWRtaW4vY3NzL3RoZW1lcy1ydGwubWluLmNzcyI7czozODoiNDZjN2VlZjk3MDQ=NTg4NDMyNGMwMzVmNzM5Y2E2M2FPMzI4MjkiO3M6MjQ6Ii93cC1hZG1pbi9jc3MvdGhlbWVzLmNzcyI7czozODoiYzFhYmI3YzEyZDRlNTQwNjFlMDExY2EyNWM1MjRlZDhPNDE1NzEiO3M6Mjg6Ii93cC1hZG1pbi9jc3MvdGhlbWVzLm1pbi5jc3MiO3M6Mzg6IjY4ZWIwMmM2ZGMwNDM2NDYxODZiNTlhMzYwNTU5ZjBmTzMyODE3IjtzOjI5OiIvd3AtYWRtaW4vY3NzL3dpZGdldHMtcnRsLmNzcyI7czozODoiNTIyMjIyODIzMjlmMWUyYmE4N2Q5ZGY1NTZiOWRhNTFPMTA5MzEiO3M6MzM6Ii93cC1hZG1pbi9jc3Mvd2lkZ2V=cy1ydGwubWluLmNzcyI7czozNzoiNTZkY2M4Mzg4YTY3ZWVhNWEzNDJkYzAwNDkxODY3ZTRPODcwMCI7czoyNToiL3dwLWFkbWluL2Nzcy93aWRnZXRzLmNzcyI7czozODoiNTNiZmEwMDRiOGVjNWVkMDczNDhiOWZmM2U3OWFmNTVPMTA5MzMiO3M6Mjk6Ii93cC1hZG1pbi9jc3Mvd2lkZ2V=cy5taW4uY3NzIjtzOjM3OiJmZWViMTBiYWViMjliMDkxZjVkOWNkNmJlY2NjMGMxNk84NzAwIjtzOjMwOiIvd3AtYWRtaW4vY3NzL3dwLWFkbWluLXJ=bC5jc3MiO3M6MzY6Ijc=ZjlkY2Y1YWI4YzkyZjY2NjZmZjUyYzY5OTg3M2M4TzQyMSI7czozNDoiL3dwLWFkbWluL2Nzcy93cC1hZG1pbi1ydGwubWluLmNzcyI7czozNjoiMDZkZDlhYWVhMjJhZDhjMTM3MjI=NzAxOTZjNWFhYjRPNDc3IjtzOjI2OiIvd3AtYWRtaW4vY3NzL3dwLWFkbWluLmNzcyI7czozNjoiYmZlNGJkOTAzNTAwMThhYmM3YzkyMTBiZmI5ZDJhNWJPMzY1IjtzOjMwOiIvd3AtYWRtaW4vY3NzL3dwLWFkbWluLm1pbi5jc3MiO3M6MzY6ImEyZTJmNjc2MjZlZDZmOWJlY2E1MzA2YzFhMTZhYmJhTzQyMSI7czozMToiL3dwLWFkbWluL2N1c3RvbS1iYWNrZ3JvdW5kLnBocCI7czozODoiMjM4OTU5MWUzNzk3YTdlODAxNjBiZWFmZGMxYWEwNGVPMTk5NzMiO3M6Mjc6Ii93cC1hZG1pbi9jdXN=b2=taGVhZGVyLnBocCI7czozODoiMTM3ZmU5YzE=MzBhOThlMzYxZmM=NmQ3ZTYwNmYwOWVPNDQ4MzAiO3M6MjM6Ii93cC1hZG1pbi9jdXN=b21pemUucGhwIjtzOjM3OiI1MzI=Y2ZhM2FmOTA3NWE2MjAyYzkyY2QzZDM=NDRjOU83MzkxIjtzOjI3OiIvd3AtYWRtaW4vZWRpdC1jb21tZW5=cy5waHAiO3M6Mzg6ImNkMWJmODhjM2E=NTNlYzRkZGI4NTA1MjI5YWE1NGYxTzEzNzczIjtzOjMyOiIvd3AtYWRtaW4vZWRpdC1mb3JtLWFkdmFuY2VkLnBocCI7czozODoiOTJlNWYxNDVkMGE1YjM2N2UxMWJhNDA=NmI2MzgwNDBPMzI1MDIiO3M6MzE6Ii93cC1hZG1pbi9lZGl=LWZvcm=tY29tbWVudC5waHAiO3M6Mzc6IjMxYWQwMWIyYmE2NWE=YTJlNjMxZTQyMmIyNTgxNTgwTzczMjUiO3M6Mjg6Ii93cC1hZG1pbi9lZGl=LWxpbmstZm9ybS5waHAiO3M6Mzc6IjkwNjk5MDViMDUxNWI=MTYzYzM1MTVlOTg1ZjAyZWE=TzU5ODAiO3M6Mjc6Ii93cC1hZG1pbi9lZGl=LXRhZy1mb3JtLnBocCI7czozNzoiZWI2NGRkZTQ=NzNhMTMxNDI=ZGEzOGFkNTk2NThmMDhPODY4MCI7czoyMzoiL3dwLWFkbWluL2VkaXQtdGFncy5waHAiO3M6Mzg6IjgyZWIzOWUwNjJjZjQzY2Y1YzllNWYzZGZlN2NiY2Y=TzE5OTkxIjtzOjE4OiIvd3AtYWRtaW4vZWRpdC5waHAiO3M6Mzg6IjU1MzczNDQ5Y2MyMzIwYzU3ODAzZjFmNWI1MmI5Y2U5TzE1Njc3IjtzOjIwOiIvd3AtYWRtaW4vZXhwb3J=LnBocCI7czozODoiOWZlZmMyZGZhZmFjY2Y=NjQ=ZGEwMDRiYzVkYjBjZmVPMTA3MDkiO3M6MjI6Ii93cC1hZG1pbi9mcmVlZG9tcy5waHAiO3M6Mzc6IjhiYzNiNTczY2ZiYWRjMzY3MTQ4ZmM=NDM5YWJkNzIzTzM=MDgiO3M6MzY6Ii93cC1hZG1pbi9pbWFnZXMvYWxpZ24tY2VudGVyLTJ4LnBuZyI7czozNjoiOWViZWIyMmRmMzcyODczNTA=MmE=YTM3YTE=OTY2MTFPMTQ3IjtzOjMzOiIvd3AtYWRtaW4vaW1hZ2VzL2FsaWduLWNlbnRlci5wbmciO3M6MzY6IjA5ZDkxYWRkYjZiNTM=NzllNjhjNjQ1OTMxZDk2NThlTzU=NiI7czozNDoiL3dwLWFkbWluL2ltYWdlcy9hbGlnbi1sZWZ=LTJ4LnBuZyI7czozNjoiNjk4NTM4YjE=ZmI5ODM5YWVjZDAxZDVlOTdjNjYzMTZPMTQzIjtzOjMxOiIvd3AtYWRtaW4vaW1hZ2VzL2FsaWduLWxlZnQucG5nIjtzOjM2OiI1Y2ZkNzkzMGNmZmE2NDEyZjc1YWYyNmYyZTY4OWVkNE81NTQiO3M6MzQ6Ii93cC1hZG1pbi9pbWFnZXMvYWxpZ24tbm9uZS=yeC5wbmciO3M6MzY6ImY4NTg=Mzk5MDUyOTViZDcwNWIwOWIyZGJhMzQxOGJkTzEyMSI7czozMToiL3dwLWFkbWluL2ltYWdlcy9hbGlnbi1ub25lLnBuZyI7czozNjoiZjFhZDY1NzE2NDMyYTBhMWRhNzU5MWE1YzJmMTBkMDRPNDE3IjtzOjM1OiIvd3AtYWRtaW4vaW1hZ2VzL2FsaWduLXJpZ2h=LTJ4LnBuZyI7czozNjoiNjg4MzAyNmNiZDNlNzJiYTVkYTM2YzU3YzYwZmMwNzhPMTQyIjtzOjMyOiIvd3AtYWRtaW4vaW1hZ2VzL2FsaWduLXJpZ2h=LnBuZyI7czozNjoiNDJkOGYzZTI4NzRmNjUyM2QzNmM=MDNhNTAyYjIyNzZPNTA5IjtzOjMwOiIvd3AtYWRtaW4vaW1hZ2VzL2Fycm93cy=yeC5wbmciO3M6MzY6Ijk3MjA1MWYwODYwMTdkY2VmMTc5NjQ2MjIzMzY4NDBiTzg2MyI7czoyNzoiL3dwLWFkbWluL2ltYWdlcy9hcnJvd3MucG5nIjtzOjM2OiI3ZmRhNzY5MjAxMjRmMDNlODhkMWRmZDkzZTAzYmY1OU8yNDMiO3M6MzI6Ii93cC1hZG1pbi9pbWFnZXMvYnJvd3Nlci1ydGwucG5nIjtzOjM4OiI=NDIyOTFkOWQzYTA=MWU=MWFhZWZlYmZiZjI1Y2M5ZE8=MDE3MCI7czoyODoiL3dwLWFkbWluL2ltYWdlcy9icm93c2VyLnBuZyI7czozODoiYzFiMmY5YzI5ZWI1NGIxZjVjMDI4NDYyOTUyNGZlNDZPNDA2MjYiO3M6MzM6Ii93cC1hZG1pbi9pbWFnZXMvYnViYmxlX2JnLTJ4LmdpZiI7czozNjoiMTY1MjNkNWJmOWVmZDhjYTNiOTJlNzYzMWVkZmM1MTNPNTA3IjtzOjMwOiIvd3AtYWRtaW4vaW1hZ2VzL2J1YmJsZV9iZy5naWYiO3M6MzY6IjNkMmNiM2Y3YmFhNjI4YzllNTFhMzI2MzU2ZTcyMDM4TzM5OCI7czo=MzoiL3dwLWFkbWluL2ltYWdlcy9jb21tZW5=LWdyZXktYnViYmxlLTJ4LnBuZyI7czozNjoiOWQ1NDU5ZDNjNTlkMzJiNjAyNzMyYzBkZjU2ZDgzYmZPMjU4IjtzOjQwOiIvd3AtYWRtaW4vaW1hZ2VzL2NvbW1lbnQtZ3JleS1idWJibGUucG5nIjtzOjM2OiI4ZjU5MTI4ZjJhMjdiNDg5YjBhOTc=YzBiNmIyMTA=Nk8xMTQiO3M6MzU6Ii93cC1hZG1pbi9pbWFnZXMvZGF=ZS1idXR=b24tMnguZ2lmIjtzOjM2OiIyOTUyOTMyYzI=NmJmOTgyODQyOTM2MTY=M2E4YmI2M=85OTYiO3M6MzI6Ii93cC1hZG1pbi9pbWFnZXMvZGF=ZS1idXR=b24uZ2lmIjtzOjM2OiI5NzlkOGUyZTA4YWFkYTQ5ODE5NTU2OTUwZWM=OGZmNk8=MDAiO3M6Mjg6Ii93cC1hZG1pbi9pbWFnZXMvZ2VuZXJpYy5wbmciO3M6MzY6ImY4OGUxYjk1ZmYyNzhhNWIyMzFmMzkzODBiMjExZWQwTzcxOSI7czozMToiL3dwLWFkbWluL2ltYWdlcy9pY29uczMyLTJ4LnBuZyI7czozODoiYjUyNWE=MmFmOTA4ZmFmY2Y4Y2MwNzY3OWFiNGZhYmJPMjE3NzAiO3M6MzQ6Ii93cC1hZG1pbi9pbWFnZXMvaWNvbnMzMi12cy=yeC5wbmciO3M6Mzg6ImExMmEzMDM=ZmY=NzM=NDY5NzA5MjY1YTgzNjk3ZDIyTzIxMzk2IjtzOjMxOiIvd3AtYWRtaW4vaW1hZ2VzL2ljb25zMzItdnMucG5nIjtzOjM3OiIwNTJjZDY1MDJhMDVlN2QzZjE3YjNlNzZhNWIxNTU2Nk84MDA3IjtzOjI4OiIvd3AtYWRtaW4vaW1hZ2VzL2ljb25zMzIucG5nIjtzOjM3OiJkMWRiYWM1YmU3NmQzOTg1MWNlNzRhYTEzNGNjMWFlYU84MDIzIjtzOjM3OiIvd3AtYWRtaW4vaW1hZ2VzL2ltZ2VkaXQtaWNvbnMtMngucG5nIjtzOjM3OiIyY2UzZWUyNzgzYTMzNjU1YTZiZGZkOWRjM2NjZTE3NE83NjY=IjtzOjM=OiIvd3AtYWRtaW4vaW1hZ2VzL2ltZ2VkaXQtaWNvbnMucG5nIjtzOjM3OiI=YmQ1NWMzMjBiOWZkOWQ4MTI3ZGE5NDc4OTY5M2I=Zk8=MDU1IjtzOjI4OiIvd3AtYWRtaW4vaW1hZ2VzL2xpc3QtMngucG5nIjtzOjM3OiI2OGQ1YmIxMzQ5NTNjMjMyMTdmZGQzNjk4MjY3OWEwY=8xNTIzIjtzOjI1OiIvd3AtYWRtaW4vaW1hZ2VzL2xpc3QucG5nIjtzOjM3OiIxZTEyM2U5NmJkMmExY2UyYzBkM2IzMDVkMTUzZjFjM=8xMDAzIjtzOjI4OiIvd3AtYWRtaW4vaW1hZ2VzL2xvYWRpbmcuZ2lmIjtzOjM3OiIyZDViOTJiNjE2NzRjODUwYmZmMDBjZWNhZjA4NjRlY=8yMjU=IjtzOjI3OiIvd3AtYWRtaW4vaW1hZ2VzL21hcmtlci5wbmciO3M6MzY6IjMzMTNkYzJhNGYzMjJmZDQzMzQ5MzI5Y2ZkZTgxOTFlTzM2MCI7czoyNToiL3dwLWFkbWluL2ltYWdlcy9tYXNrLnBuZyI7czozNzoiZmNmNjkzNjc3ZWE4MjJlNmQyNGFmN2IyZTRhOThlOTlPMjAwMSI7czozNjoiL3dwLWFkbWluL2ltYWdlcy9tZWRpYS1idXR=b24tMngucG5nIjtzOjM2OiIyM2RiNTc=OWU1MWQ4NTEwNWNiOGQwM2ZjODEzMDVjOU84NTAiO3M6Mzk6Ii93cC1hZG1pbi9pbWFnZXMvbWVkaWEtYnV=dG9uLWltYWdlLmdpZiI7czozNjoiN2VhMmM5YzE1N2MzOGVkYjQwYjFjZTYyZDU3MmQ1YjNPMjAwIjtzOjM5OiIvd3AtYWRtaW4vaW1hZ2VzL21lZGlhLWJ1dHRvbi1tdXNpYy5naWYiO3M6MzY6ImVmZjU1ZGYzN2YzMjVjNWFhZTJmMDJlNGQ5MTNkZTk1TzIwNiI7czozOToiL3dwLWFkbWluL2ltYWdlcy9tZWRpYS1idXR=b24tb3RoZXIuZ2lmIjtzOjM2OiI4YmM2YjQ2YmM3MGM3YzE5MThkY2U2MmM=ZmUzMjI5Y=8yNDgiO3M6Mzk6Ii93cC1hZG1pbi9pbWFnZXMvbWVkaWEtYnV=dG9uLXZpZGVvLmdpZiI7czozNjoiYWJhYWMzZGZkODFmYmY3MmU1NzhmMTM=NTFlYWU3ZDBPMTMzIjtzOjMzOiIvd3AtYWRtaW4vaW1hZ2VzL21lZGlhLWJ1dHRvbi5wbmciO3M6MzY6ImIyYjZjM2UzMzYwNTQwNzBlODkyN2E1ZTc5NjVmM2NlTzMyMyI7czoyODoiL3dwLWFkbWluL2ltYWdlcy9tZW51LTJ4LnBuZyI7czozODoiNmE=N2ZmZjVmZWUyZjk3YmJmM2VhZjVlM2IyNDgyZDNPMTI2NzIiO3M6MzE6Ii93cC1hZG1pbi9pbWFnZXMvbWVudS12cy=yeC5wbmciO3M6Mzg6IjRhYTg1YTBjNTkzY2Y3NjljNzE4NTkxMWFlODQ2MmY4TzEyNDUzIjtzOjI4OiIvd3AtYWRtaW4vaW1hZ2VzL21lbnUtdnMucG5nIjtzOjM3OiI3MTk5ODBmMjRjZjAyYzBjNWZhNTNiMzEyZmVmNDVhY=81MDg2IjtzOjI1OiIvd3AtYWRtaW4vaW1hZ2VzL21lbnUucG5nIjtzOjM3OiJlMTBkODEzOTIzMGYxZjhiNjRmMzU5NjAwOThmOGNmZk81MDM5IjtzOjIzOiIvd3AtYWRtaW4vaW1hZ2VzL25vLnBuZyI7czozNjoiYzg2YmJmMWM2NGM5MjRmOTlmZGM5ZjU2MzdmMGMwOGJPNzU1IjtzOjM2OiIvd3AtYWRtaW4vaW1hZ2VzL3Bvc3QtZm9ybWF=cy12cy5wbmciO3M6Mzc6ImE2OGY1M2E2NmM5M2Y=NDg1Y2E5YWNhZmFmZmM4MWU2TzI=NTAiO3M6MzM6Ii93cC1hZG1pbi9pbWFnZXMvcG9zdC1mb3JtYXRzLnBuZyI7czozNzoiZGM=YmZmZTFkMTAwOTNlNGQ5MjUzM2E4ZDYwY2JhMDdPMjE1NyI7czozODoiL3dwLWFkbWluL2ltYWdlcy9wb3N=LWZvcm1hdHMzMi12cy5wbmciO3M6Mzc6ImI3NzQyZTQ1YjZhZGVhMzU=N2E1NGUxYWYzZmU3NjFjTzUxMTEiO3M6MzU6Ii93cC1hZG1pbi9pbWFnZXMvcG9zdC1mb3JtYXRzMzIucG5nIjtzOjM3OiI1NzU5N2U4ZjRmOTJmODdiZjAyYjVmNGM4OTZiNDUzYk81MTQyIjtzOjMwOiIvd3AtYWRtaW4vaW1hZ2VzL3Jlc2l6ZS=yeC5naWYiO3M6MzY6ImY1ZTExODY1M2Y4OTI2MDY2ODJlZTljNTFkMGFiYTk5TzIzNCI7czozNDoiL3dwLWFkbWluL2ltYWdlcy9yZXNpemUtcnRsLTJ4LmdpZiI7czozNjoiZjdjOTllZTc=MDE=ZmU5MjU=MTAxMjMwM2FhYWRjN2RPMjMzIjtzOjMxOiIvd3AtYWRtaW4vaW1hZ2VzL3Jlc2l6ZS1ydGwuZ2lmIjtzOjM2OiJkYjkyMTcxOTYzMTNjOTVhNTlkNDM2MDFkYTE5YzUxZE8xNDkiO3M6Mjc6Ii93cC1hZG1pbi9pbWFnZXMvcmVzaXplLmdpZiI7czozNToiM2ZiYTE1NDRkZjI=ZjQwZGRlNTg3NmM4YzBhZWM=NjFPNzAiO3M6MjM6Ii93cC1hZG1pbi9pbWFnZXMvc2UucG5nIjtzOjM2OiJkNmM4OTQ=MmMzNjBiZDFlMDhkYTJlN2QxNTI3MzczYU8xMjAiO3M6Mjg6Ii93cC1hZG1pbi9pbWFnZXMvc29ydC=yeC5naWYiO3M6MzU6IjE4NmU1MTI2N2ZjYTVkMjBiMjMwYzcyZDlhODk4M2VlTzk3IjtzOjI1OiIvd3AtYWRtaW4vaW1hZ2VzL3NvcnQuZ2lmIjtzOjM1OiIyZThhY2I4ZGVlOTliZmJjYjYxYmQ=NmM=ODZhOTk1ZE81NSI7czozMToiL3dwLWFkbWluL2ltYWdlcy9zcGlubmVyLTJ4LmdpZiI7czozNzoiNWMxMzcxYmNiNDM5Mjk2ODY=Nzg1MmE5YzlkZjVkNmNPODUzNiI7czoyODoiL3dwLWFkbWluL2ltYWdlcy9zcGlubmVyLmdpZiI7czozNzoiYjBhM2RkZTMzMTYzN2UyN2FhNjQ3NmQ=NzY=ODE4NzFPNDE2MiI7czoyOToiL3dwLWFkbWluL2ltYWdlcy9zdGFycy=yeC5wbmciO3M6Mzc6ImY1ZWE=MTk=YTc5YzIzZTY1M2IyNGQwYzY1MDMyZTVlTzEyNTciO3M6MjY6Ii93cC1hZG1pbi9pbWFnZXMvc3RhcnMucG5nIjtzOjM2OiI1YmFjZTAxZjk5OTAzZTNjZjU2YmIyN2JkMmVjMjg5MU85MjQiO3M6MzI6Ii93cC1hZG1pbi9pbWFnZXMvdy1sb2dvLWJsdWUucG5nIjtzOjM3OiJmZDViNGViMDU3MDZhMmYwNWY3MDdmZTA3N2FlMTAzME8zMTEzIjtzOjMzOiIvd3AtYWRtaW4vaW1hZ2VzL3ctbG9nby13aGl=ZS5wbmciO3M6Mzc6IjZlYTZjY2VlNGEwMTc2ZGJhMjdlYmI3OWFjMTc1Yzg1TzUzOTUiO3M6MjY6Ii93cC1hZG1pbi9pbWFnZXMvd2hlZWwucG5nIjtzOjM3OiI=NTMwYmQyMDcxMzA2ZGJiYzYxYTU5MjU1NmI5NThhME82MDQ3IjtzOjQxOiIvd3AtYWRtaW4vaW1hZ2VzL3dvcmRwcmVzcy1sb2dvLXdoaXRlLnN2ZyI7czozNzoiMTliZGQ5NzE1MGZiNDNhYTg2MmQ1MzUwMGM=NGU2ZjdPMTYzOSI7czozNToiL3dwLWFkbWluL2ltYWdlcy93b3JkcHJlc3MtbG9nby5wbmciO3M6Mzc6ImM2YjBmOTc5YjllNjZmYzMzOGY=Y2IzODUzYTU2MDhhTzI=ODAiO3M6MzU6Ii93cC1hZG1pbi9pbWFnZXMvd29yZHByZXNzLWxvZ28uc3ZnIjtzOjM3OiJmMzRlZjYyNTkzNjRmN2VmMGNjZjY3Y2QxZGRkYzk3ME8xNTIxIjtzOjM2OiIvd3AtYWRtaW4vaW1hZ2VzL3dwc3Bpbl9saWdodC=yeC5naWYiO3M6Mzc6IjdkZWYzM2FhZDk1OWNkMjg5ZDQ5ZGRmMmE=MWYwNzZkTzkxMzMiO3M6MzM6Ii93cC1hZG1pbi9pbWFnZXMvd3BzcGluX2xpZ2h=LmdpZiI7czozNzoiZGQ=ZTZkZDI2OGE3MGNlNGMxYzUxNDNiMWE=MDkyZGRPMjIwOSI7czoyNzoiL3dwLWFkbWluL2ltYWdlcy94aXQtMnguZ2lmIjtzOjM2OiI4ZmIwNzI5YzU=MWNiZGM=NjA5ZmFmM2Y=YWQwMmZjN=84MjUiO3M6MjQ6Ii93cC1hZG1pbi9pbWFnZXMveGl=LmdpZiI7czozNjoiZTUwMTI5MDJhMzU4ZmJiOTYwMzFhY2RjZjA=OGQ3Y2FPMTgxIjtzOjI=OiIvd3AtYWRtaW4vaW1hZ2VzL3llcy5wbmciO3M6MzY6ImM=MmJmODE=YTIzN2RjODk5NzBkNzE1YWU4NTE2YjEzTzUzOSI7czoyMDoiL3dwLWFkbWluL2ltcG9ydC5waHAiO3M6Mzc6ImYzZWUxZWYxNWE5YTYyMDIxNzA1OWE4NTNkNzI4ZDdlTzcxOTQiO3M6MzY6Ii93cC1hZG1pbi9pbmNsdWRlcy9hZG1pbi1maWx=ZXJzLnBocCI7czozNzoiYmZlOWJiMGQ4ZDZkN2NiNzE3Y2YzZTdiODI5ZmE1NzJPNTE5MCI7czoyODoiL3dwLWFkbWluL2luY2x1ZGVzL2FkbWluLnBocCI7czozNzoiNWM3YjBjOGM3YWNkNjk1MDhkOGYxOWMzYzYxYTcxYzBPMjk=OCI7czozNToiL3dwLWFkbWluL2luY2x1ZGVzL2FqYXgtYWN=aW9ucy5waHAiO3M6Mzk6ImY5ZjkxZjhlNzI=ZTk2ZGUwNjBiM2IwNmJmMDEwNTIwTzExMTE4MSI7czozMToiL3dwLWFkbWluL2luY2x1ZGVzL2Jvb2ttYXJrLnBocCI7czozNzoiMTI1ZTU5MTRkZDExZTQwZGM1NWMyZTFkY2VlOGVmZjdPOTA3OCI7czo1MjoiL3dwLWFkbWluL2luY2x1ZGVzL2NsYXNzLWF1dG9tYXRpYy11cGdyYWRlci1za2luLnBocCI7czozNzoiZjNkMTllZTRjODU3MjZiMGYyNGNkZDFmMzZjNDE=ZjlPMzE1MyI7czo1NDoiL3dwLWFkbWluL2luY2x1ZGVzL2NsYXNzLWJ1bGstcGx1Z2luLXVwZ3JhZGVyLXNraW4ucGhwIjtzOjM3OiJhM2RlNWZjOTcxNzA3YjhkOTU1YjU3MjQxZTI2MzY1MU8xOTE1IjtzOjUzOiIvd3AtYWRtaW4vaW5jbHVkZXMvY2xhc3MtYnVsay1=aGVtZS11cGdyYWRlci1za2luLnBocCI7czozNzoiMWViMTQxNGM2MzJlMGJiYmI2NDdiYTQwYTQ2ZGMxMWFPMTk1OSI7czo=NzoiL3dwLWFkbWluL2luY2x1ZGVzL2NsYXNzLWJ1bGstdXBncmFkZXItc2tpbi5waHAiO3M6Mzc6IjJhNmY2MzdjODgwYWJjM2RiOGIzM2Y1N2JmNWQ1OTQ3TzUyNDQiO3M6NDI6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy1jb3JlLXVwZ3JhZGVyLnBocCI7czozODoiMzIyMzhmOWIxOTIzMmJmYjRiYjRiYmQ5Zjg1NGRhOWVPMTM=MDAiO3M6NDk6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy1maWxlLXVwbG9hZC11cGdyYWRlci5waHAiO3M6Mzc6IjhmMTYxY2Q1MzliNjBlZmQ2Yzg3ZGM3MTZhN2M3N2Q4TzMzNDciO3M6Mzc6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy1mdHAtcHVyZS5waHAiO3M6Mzc6IjQyZTQ2MjE3NDViZGUwNDUxMjgwM2U4NzAyZGIxMTUyTzUzOTkiO3M6NDA6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy1mdHAtc29ja2V=cy5waHAiO3M6Mzc6IjA3NmNhODM5ZTg1NTJiNDVhM2VlZjU1OGFhMmIxOTk2Tzg=NDgiO3M6MzI6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy1mdHAucGhwIjtzOjM4OiJjOWJlZDEyNjVmOWVmYWUzNzM2NDk5NzI2YTdhMWIyZU8yNzA5NyI7czo1NjoiL3dwLWFkbWluL2luY2x1ZGVzL2NsYXNzLWxhbmd1YWdlLXBhY2stdXBncmFkZXItc2tpbi5waHAiO3M6Mzc6ImUzZTkyZjI=NmZhYjAxMDY5MTc=MDZhOGIxYjczMzk1TzIyNDEiO3M6NTE6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy1sYW5ndWFnZS1wYWNrLXVwZ3JhZGVyLnBocCI7czozODoiMjhmZjhkZGIzYzQ4ZDEwNmM3YmMwNWNhNWViYzhiZTVPMTExNTMiO3M6MzU6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy1wY2x6aXAucGhwIjtzOjM5OiI1OWM3MDFkMDk4OTZjZjg1OTY4OWRjZjQ1NzU5NzA4NE8xOTU3OTUiO3M6NTA6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy1wbHVnaW4taW5zdGFsbGVyLXNraW4ucGhwIjtzOjM3OiJkODBlZDc1MzM3ZGI5NGQyMjA=N2MyOGNjMTkyMDNkNk8zOTY4IjtzOjQ5OiIvd3AtYWRtaW4vaW5jbHVkZXMvY2xhc3MtcGx1Z2luLXVwZ3JhZGVyLXNraW4ucGhwIjtzOjM3OiI1ZGY5OGY5NDI3ZTNjNTRkZDg2NTBiZDIyNzUxZTUxZU8yNTYxIjtzOjQ=OiIvd3AtYWRtaW4vaW5jbHVkZXMvY2xhc3MtcGx1Z2luLXVwZ3JhZGVyLnBocCI7czozODoiZDZjOGZhYjA2MzAzZjk4NTcwOGE4YTI3MDc4MWEwMjRPMTQ3NTIiO3M6NDk6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy1=aGVtZS1pbnN=YWxsZXItc2tpbi5waHAiO3M6Mzc6IjQ5NjRlYmRkZTdjYTBjNjE1MTc2OGZjZGU2ZjM4OTUzTzM4ODgiO3M6NDg6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy1=aGVtZS11cGdyYWRlci1za2luLnBocCI7czozNzoiZjNmNmNkN2M3MGZjMGUxMGUzMGI4ODVlNjA=YzVjODBPMzI2NCI7czo=MzoiL3dwLWFkbWluL2luY2x1ZGVzL2NsYXNzLXRoZW1lLXVwZ3JhZGVyLnBocCI7czozODoiMTZmNDQ=Y2RlMzA5YmMyN2UxMzg3YmJmNzc1ZjczNjFPMTk1NjkiO3M6NTQ6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy13YWxrZXItY2F=ZWdvcnktY2hlY2tsaXN=LnBocCI7czozNzoiYzU=YTVmZmE5MzY1YjQ3MWYzODRhODVmMzUwZjFmMWJPNDE5NCI7czo1NDoiL3dwLWFkbWluL2luY2x1ZGVzL2NsYXNzLXdhbGtlci1uYXYtbWVudS1jaGVja2xpc3QucGhwIjtzOjM3OiJiYzE4YWIxOWQ1ZjUwZTkzYjQ3ZmYwY2IwZWM=NmViZk8=OTI2IjtzOjQ5OiIvd3AtYWRtaW4vaW5jbHVkZXMvY2xhc3Mtd2Fsa2VyLW5hdi1tZW51LWVkaXQucGhwIjtzOjM4OiI4NjIxODcwOGVkYmRkYzliODE1M2UzNTA5ODJjYjMwMU8xMTE4MyI7czo1MDoiL3dwLWFkbWluL2luY2x1ZGVzL2NsYXNzLXdwLWFqYXgtdXBncmFkZXItc2tpbi5waHAiO3M6Mzc6ImE5NDVmNDMyNzdlN2U1MDc1OGQxN2E4MTlhOWU5ZGQ3TzMxODUiO3M6NDk6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy13cC1hdXRvbWF=aWMtdXBkYXRlci5waHAiO3M6Mzg6IjgxMDk3ZjZmM2RhNzJmNDJhNTIzODIyYTZmZjdiMmE2TzM=MjMwIjtzOjUxOiIvd3AtYWRtaW4vaW5jbHVkZXMvY2xhc3Mtd3AtY29tbWVudHMtbGlzdC1=YWJsZS5waHAiO3M6Mzg6ImYyZTQzMjVhZjg2MzdjMWEwZTUwNDYwNzBkNjBlYzViTzI1NTUxIjtzOjQ3OiIvd3AtYWRtaW4vaW5jbHVkZXMvY2xhc3Mtd3AtZmlsZXN5c3RlbS1iYXNlLnBocCI7czozODoiMzFhOTAzMGEwNzg1M2Y=MGU5NmQ4NzNkZGRkNDAxYzlPMjMwMjAiO3M6NDk6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy13cC1maWxlc3lzdGVtLWRpcmVjdC5waHAiO3M6Mzg6IjU=NzgyOGY=M2VlYWUwMDY4YzAwZGJmZmU5OGMwM2ZkTzExNzk1IjtzOjQ5OiIvd3AtYWRtaW4vaW5jbHVkZXMvY2xhc3Mtd3AtZmlsZXN5c3RlbS1mdHBleHQucGhwIjtzOjM4OiJiZmIzMTAzNGUyN2U=MTI3NzMxNmRjZGIyZWRhZGZhN=8xNDA1NyI7czo1MzoiL3dwLWFkbWluL2luY2x1ZGVzL2NsYXNzLXdwLWZpbGVzeXN=ZW=tZnRwc29ja2V=cy5waHAiO3M6Mzg6Ijk1MGIyZjQ2MGU4NzAyYzJjMDQ4ZWU4YzAwMjE4ZjZiTzExMTM1IjtzOjQ3OiIvd3AtYWRtaW4vaW5jbHVkZXMvY2xhc3Mtd3AtZmlsZXN5c3RlbS1zc2gyLnBocCI7czozODoiZTJkYjYwNjBjODczYmNjYzIwY2E=NDFhMDVlZDk4YzlPMTU1NzIiO3M6NDA6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy13cC1pbXBvcnRlci5waHAiO3M6Mzc6IjJjNzdmNWNkZTQwOTVmZWFjYWM5ZDcyZjRhNTMwNTNiTzcyNzYiO3M6NDk6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy13cC1pbnRlcm5hbC1wb2ludGVycy5waHAiO3M6Mzc6ImUzYmU=OTg3OWU=ZTc=OTgyMzUzOWUyMzQxMTNkNmNlTzQzMTkiO3M6NDg6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy13cC1saW5rcy1saXN=LXRhYmxlLnBocCI7czozNzoiNmU4NDc4ZDJiMjllZmRjY2RmNmJlYWI4OWQzNjVmNzlPNzgzMiI7czo=OToiL3dwLWFkbWluL2luY2x1ZGVzL2NsYXNzLXdwLWxpc3QtdGFibGUtY29tcGF=LnBocCI7czozNzoiYzU5ODIyZTI5NGIzMzQ5NTA1NGE=ZmFmNDM5MTk1MjhPMTEwOSI7czo=MjoiL3dwLWFkbWluL2luY2x1ZGVzL2NsYXNzLXdwLWxpc3QtdGFibGUucGhwIjtzOjM4OiJmYzhkYjE5YmE5NTY1YzYyMjc4OTZiNjQ1MTdhNzQxYU8zODQzNyI7czo=ODoiL3dwLWFkbWluL2luY2x1ZGVzL2NsYXNzLXdwLW1lZGlhLWxpc3QtdGFibGUucGhwIjtzOjM4OiI=MzAzMzgzN2U=NmI5NzVmZmNmYTg=OGM5OGY4MzhlNU8yMjY4NiI7czo1MToiL3dwLWFkbWluL2luY2x1ZGVzL2NsYXNzLXdwLW1zLXNpdGVzLWxpc3QtdGFibGUucGhwIjtzOjM4OiIwM2U4MDc1MDkxNTZlZTBmMmMxOTJhOTVmMTllYjM2YU8xNTU5NyI7czo1MjoiL3dwLWFkbWluL2luY2x1ZGVzL2NsYXNzLXdwLW1zLXRoZW1lcy1saXN=LXRhYmxlLnBocCI7czozODoiNzE4NjdiYTQwYTAyOTNjYWU5N2UzNDI3ZjljMjkxYTRPMTk5OTEiO3M6NTE6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy13cC1tcy11c2Vycy1saXN=LXRhYmxlLnBocCI7czozODoiNWM5OGIwNjVkMDdlNmU2NTEzY2RhMTc5YjUwNzBhMjlPMTI1OTEiO3M6NTc6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy13cC1wbHVnaW4taW5zdGFsbC1saXN=LXRhYmxlLnBocCI7czozODoiMGE=ZmY5MThiZTc5OWZhNTI3ZWQ5ZjRmYjA5YzBlNzNPMTgxOTUiO3M6NTA6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy13cC1wbHVnaW5zLWxpc3QtdGFibGUucGhwIjtzOjM4OiIyYTc4NjBmMWYyNTdmMzVhN2I1OTQzNmE=OWEyYzAxM=8zMjU3NSI7czo1NjoiL3dwLWFkbWluL2luY2x1ZGVzL2NsYXNzLXdwLXBvc3QtY29tbWVudHMtbGlzdC1=YWJsZS5waHAiO3M6Mzc6IjVjMzRmODVhMDVlZWUzMDVlYWMyNjU=ZTVkMjVlNTQ=TzE=NzIiO3M6NDg6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy13cC1wb3N=cy1saXN=LXRhYmxlLnBocCI7czozODoiNWU1ZmU=YjVmYTUxZmQyOTFhZWQ5MzM1MDQ=NTFkNjNPNTE5MDgiO3M6NDI6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy13cC1wcmVzcy1=aGlzLnBocCI7czozODoiMjA2ZDcxODU=NjYwNTgxZGFkN2M3NGQ1YzM=MDlhOWNPNDk5MTIiO3M6Mzg6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy13cC1zY3JlZW4ucGhwIjtzOjM4OiI2OWFmMTgzMDYyMzJmZTRmMDMyNDkwZDEzZjBiZGFmM=8zNDQxNyI7czo=MToiL3dwLWFkbWluL2luY2x1ZGVzL2NsYXNzLXdwLXNpdGUtaWNvbi5waHAiO3M6Mzc6ImQ1ZTg4M2YzMTFhZTljODc1ODIyZGU3MTIxOGM3Y2NjTzYyMTQiO3M6NDg6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy13cC1=ZXJtcy1saXN=LXRhYmxlLnBocCI7czozODoiNGY=YTllYmI1ZjNiNGUwYjBjZjViMTBmMzgwMzJiY2FPMTc4NjAiO3M6NTY6Ii93cC1hZG1pbi9pbmNsdWRlcy9jbGFzcy13cC1=aGVtZS1pbnN=YWxsLWxpc3QtdGFibGUucGhwIjtzOjM4OiI2MTE=NTI1YzdhOTJjMTc5ZmMzNDNlYTJhYmMyMmMyY=8xNDU4MyI7czo=OToiL3dwLWFkbWluL2luY2x1ZGVzL2NsYXNzLXdwLXRoZW1lcy1saXN=LXRhYmxlLnBocCI7czozNzoiNmZhMmFjN2M=ZGVjNjkyYTZkOTFlZDIzMTcyZmU1MzhPOTM4NiI7czo=NToiL3dwLWFkbWluL2luY2x1ZGVzL2NsYXNzLXdwLXVwZ3JhZGVyLXNraW4ucGhwIjtzOjM3OiIyNzg3MzYwZDRmOGM1NjVlOTM5MGNlMTg1N2Y=MDFhNk81MjI4IjtzOjQ2OiIvd3AtYWRtaW4vaW5jbHVkZXMvY2xhc3Mtd3AtdXBncmFkZXItc2tpbnMucGhwIjtzOjM3OiJlYjNmMTUxZmMwYTg=ODVhZTFjYjFlOGNiOWViNzY1NU8xNDU2IjtzOjQwOiIvd3AtYWRtaW4vaW5jbHVkZXMvY2xhc3Mtd3AtdXBncmFkZXIucGhwIjtzOjM4OiIyMmEyMTIwM2VjMDIyYjYzNzkwMjkwM2FiZDliOTk5M=8zMzU5NyI7czo=ODoiL3dwLWFkbWluL2luY2x1ZGVzL2NsYXNzLXdwLXVzZXJzLWxpc3QtdGFibGUucGhwIjtzOjM4OiI4YjlkNGM2NjA3ZWU3N2RlYTUzMTI1ZmE4MTFkMDc3ZU8xNTk=MSI7czozMDoiL3dwLWFkbWluL2luY2x1ZGVzL2NvbW1lbnQucGhwIjtzOjM3OiJkMDk3ZWU4Y2YxMTJhODRmZmEzZTk5OTVhM2Y5MGQ1OE81NzI2IjtzOjQwOiIvd3AtYWRtaW4vaW5jbHVkZXMvY29udGluZW5=cy1jaXRpZXMucGhwIjtzOjM4OiI=NDhiNzEyZTRmNDJiZWIwMGMzNjEyOTkwYWE3NjY4Nk8xOTQ5OSI7czozMDoiL3dwLWFkbWluL2luY2x1ZGVzL2NyZWRpdHMucGhwIjtzOjM3OiI3ZDU=NmExYTJhYzljODkwYWE5ZmQ2OGNjYTRiMjIxZE8xOTM2IjtzOjMyOiIvd3AtYWRtaW4vaW5jbHVkZXMvZGFzaGJvYXJkLnBocCI7czozODoiNjYxMWFkOGMyMTRmN2M4NmJkMTljZjdiOTgyZjM1MDRPNTI5NzciO3M6MzM6Ii93cC1hZG1pbi9pbmNsdWRlcy9kZXByZWNhdGVkLnBocCI7czozODoiZDVkYjFkMzAxYjcyZTYzZTU1MjI3ZGY5MTRjYzFjNThPMzU3MjEiO3M6NDA6Ii93cC1hZG1pbi9pbmNsdWRlcy9lZGl=LXRhZy1tZXNzYWdlcy5waHAiO3M6Mzc6ImVkODcyYWFlMDViYzc5ZmRlNmM4NjRlZGFkZjc3YzgxTzE=MTEiO3M6Mjk6Ii93cC1hZG1pbi9pbmNsdWRlcy9leHBvcnQucGhwIjtzOjM4OiI3NTgzMDQ3Yjg4M2M5NjVjODIxMjJmNjQ5MDk=MDY1ZE8yMjk2NSI7czoyNzoiL3dwLWFkbWluL2luY2x1ZGVzL2ZpbGUucGhwIjtzOjM4OiIzZjU5YjEwMjI=M2Y=YzUyNDZjYThlZmViM2U4ZGM2Mk81MjA4MiI7czozMzoiL3dwLWFkbWluL2luY2x1ZGVzL2ltYWdlLWVkaXQucGhwIjtzOjM4OiI4NDY4MTZmMjY=ZWFhZmRiY2I5ZDIyYTg=NmJhM2Q5Y=8zMzE4OCI7czoyODoiL3dwLWFkbWluL2luY2x1ZGVzL2ltYWdlLnBocCI7czozODoiN2Q=ZmIzMWI=NjRlZDMzZDgyZWY1ZGI5NzcyMjdjNzZPMjE2NjUiO3M6Mjk6Ii93cC1hZG1pbi9pbmNsdWRlcy9pbXBvcnQucGhwIjtzOjM3OiJhNDgxYTY5ZmJlMzIxYzk1ZTAxOWIxODQxZDRhMjQ2N=82MTU2IjtzOjMzOiIvd3AtYWRtaW4vaW5jbHVkZXMvbGlzdC1=YWJsZS5waHAiO3M6Mzc6IjRlN2MyOGNjYThhMzQ2MjUyMWQ3MWQwNjg1YjJmMzZmTzI2NDgiO3M6Mjg6Ii93cC1hZG1pbi9pbmNsdWRlcy9tZWRpYS5waHAiO3M6Mzk6IjdkMjcwNjc5ZWQyODRlODdkZDY3M2FiMDFhNDZmMjhlTzEwMzMxMSI7czoyNzoiL3dwLWFkbWluL2luY2x1ZGVzL21lbnUucGhwIjtzOjM3OiJhMTZjMzI4NzkxNzE2Y2NlNmQwMzJiOTMzZjRjOTM3Nk84NzE1IjtzOjMzOiIvd3AtYWRtaW4vaW5jbHVkZXMvbWV=YS1ib3hlcy5waHAiO3M6Mzg6IjJmYTc1Mzc=NzJkM2Y2M2YwZGY1OGM2OTgyNzdjN2Q1TzUwNzA2IjtzOjI3OiIvd3AtYWRtaW4vaW5jbHVkZXMvbWlzYy5waHAiO3M6Mzg6IjUzY2VhM2E3MGU1ZDJmMDgzZjA3Y2IyMWMyNzBiYjFhTzI2NDEyIjtzOjM5OiIvd3AtYWRtaW4vaW5jbHVkZXMvbXMtYWRtaW4tZmlsdGVycy5waHAiO3M6Mzc6IjUxMzcxNmMwMTgzOWNkMTRlMTg3MDY2YzNiMTkxZjgwTzEyODkiO3M6MzY6Ii93cC1hZG1pbi9pbmNsdWRlcy9tcy1kZXByZWNhdGVkLnBocCI7czozNzoiYmEyMDAyODZjZDZmNmQ4OWRmOWE2ZmMyYjVhYjgyNGRPMjg3OCI7czoyNToiL3dwLWFkbWluL2luY2x1ZGVzL21zLnBocCI7czozODoiYTk=ZGFjMTFmYTI4ZGE1YjhjZjNkYWJkYjZjMmY=OTFPMzg5NjEiO3M6MzE6Ii93cC1hZG1pbi9pbmNsdWRlcy9uYXYtbWVudS5waHAiO3M6Mzg6IjNjMjZkZmFmNmVlNzVhZTkyYzc1YzgzNGY5NDJiOTlmTzQyMjIyIjtzOjMwOiIvd3AtYWRtaW4vaW5jbHVkZXMvbmV=d29yay5waHAiO3M6Mzg6ImVjMjEyNjU2ODhlOTk1ZjZlMzY5MDRkNzE3ZjhmNzhkTzIzNjM5IjtzOjI3OiIvd3AtYWRtaW4vaW5jbHVkZXMvbm9vcC5waHAiO3M6Mzc6ImQ1NGJkMDk4ZTk2NGYyZDRiMGFkYTY4YmMxMmZiNGFkTzEwODMiO3M6MzA6Ii93cC1hZG1pbi9pbmNsdWRlcy9vcHRpb25zLnBocCI7czozNzoiNGUwYjMxMTUzYmFmMGNlNDNhNWRlNDJhNWFkOWUwNjBPNDE=OSI7czozNzoiL3dwLWFkbWluL2luY2x1ZGVzL3BsdWdpbi1pbnN=YWxsLnBocCI7czozODoiZmRjYmZkNDhjMzQ=MDAzOGYyNTBjYWNhMmFkMGIxZjFPMzExNzQiO3M6Mjk6Ii93cC1hZG1pbi9pbmNsdWRlcy9wbHVnaW4ucGhwIjtzOjM4OiJjZWVkMWIzNmYxOTYzOTAyNjNiYzc1MGMyNzYyZmMxMk82NTcwMyI7czoyNzoiL3dwLWFkbWluL2luY2x1ZGVzL3Bvc3QucGhwIjtzOjM4OiI4NmZjYzgyODAyYzg5ZDAwNDAyOWM1YmYzZDQ2MTZiME81OTYxMiI7czozMToiL3dwLWFkbWluL2luY2x1ZGVzL3JldmlzaW9uLnBocCI7czozODoiNWQ4MGMxNmJiYTk3Mjk5ZGJjYzdiNWZjY2Y3MTU4OTFPMTQ5MzYiO3M6Mjk6Ii93cC1hZG1pbi9pbmNsdWRlcy9zY2hlbWEucGhwIjtzOjM4OiI4ODk5MGNkMTM=YzUzOTM3MjQxZjBlN2VkYjc1MzIwOU8zNjg4OCI7czoyOToiL3dwLWFkbWluL2luY2x1ZGVzL3NjcmVlbi5waHAiO3M6Mzc6IjhlMTk3YTAwODEyMzg4NmM3ZjgxMGYzYjgwMjFmYTBjTzYxNDgiO3M6MzE6Ii93cC1hZG1pbi9pbmNsdWRlcy9=YXhvbm9teS5waHAiO3M6Mzc6IjM2MmYzMWI3M2Y=NjJjZWRjOGFhZmYxZmQ3MzBkYjViTzc3MjciO3M6MzE6Ii93cC1hZG1pbi9pbmNsdWRlcy9=ZW1wbGF=ZS5waHAiO3M6Mzg6IjhmZGNjOTFjMjMzY2U1ZTBhNTczNDZiMTE5M2U4Njc=Tzc4MDkyIjtzOjM2OiIvd3AtYWRtaW4vaW5jbHVkZXMvdGhlbWUtaW5zdGFsbC5waHAiO3M6Mzc6ImY1YTQ2M2YwM2RlOWEzZWRmNTMwOTUyZGNiMTliNWVlTzYyNzYiO3M6Mjg6Ii93cC1hZG1pbi9pbmNsdWRlcy9=aGVtZS5waHAiO3M6Mzg6ImUyMzUzZmUwMWNkYTJmZDY=Njc1N2FmNmYyZmFjOTk5TzI3NTgzIjtzOjQyOiIvd3AtYWRtaW4vaW5jbHVkZXMvdHJhbnNsYXRpb24taW5zdGFsbC5waHAiO3M6Mzc6IjA5YzA1YTcxNmQ=ZTg=NWZmYmYwMzgyMTA2ZmJiNmVlTzg1MzUiO3M6MzQ6Ii93cC1hZG1pbi9pbmNsdWRlcy91cGRhdGUtY29yZS5waHAiO3M6Mzg6IjcyNDIwZTYxNjQ1NmI=YjNlYmM4NTc5MzFkNTJhYThkTzUyMzA4IjtzOjI5OiIvd3AtYWRtaW4vaW5jbHVkZXMvdXBkYXRlLnBocCI7czozODoiZWNkYjJmM2M3ZjUxZTM5MmVlZDIyYjA4OTkzMmEzOTVPMjU4OTEiO3M6MzA6Ii93cC1hZG1pbi9pbmNsdWRlcy91cGdyYWRlLnBocCI7czozODoiMjU4OGQ5YjdmOGRiZjE2NWUzNzViZGJmZGEyOGI4ZmVPOTQ=NTYiO3M6Mjc6Ii93cC1hZG1pbi9pbmNsdWRlcy91c2VyLnBocCI7czozODoiNGJhOWNlMWMxNmQ2NTVhYjNlZGI=MTJkNmI2Zjg4MzlPMTc=MDQiO3M6MzA6Ii93cC1hZG1pbi9pbmNsdWRlcy93aWRnZXRzLnBocCI7czozNzoiODljYjRmZDk4NDdiNTNiZDMwYjIxNmQwZjVkNjI3MzhPOTQ5NCI7czoxOToiL3dwLWFkbWluL2luZGV4LnBocCI7czozNzoiMGRkZjg4NjYyMTA4YWY5NDFmMGU=YjQzYzk2ZDM=NWFPNjE5NiI7czoyODoiL3dwLWFkbWluL2luc3RhbGwtaGVscGVyLnBocCI7czozNzoiNjQ1NmIyNjBhYTlkZWNlOWIzMDQzMTI2MGNkYjFhNmNPNTc1MCI7czoyMToiL3dwLWFkbWluL2luc3RhbGwucGhwIjtzOjM4OiJhYTkwODIyM2EwY2Q1MDFhMjYyOTcyMzJlZjk4YzkxZk8xNjQ1OSI7czoyNToiL3dwLWFkbWluL2pzL2FjY29yZGlvbi5qcyI7czozNzoiZWYzZmUzM2Q=Y2UxMmZlNTI1NGU1YWYxMDI1Y2U3MGFPMjkxOCI7czoyOToiL3dwLWFkbWluL2pzL2FjY29yZGlvbi5taW4uanMiO3M6MzY6IjIyNmJjMTQ5ZmM3YTFkMmQ1NmU=NTMwZDNiNjg1ZTU4TzgzNSI7czoyNzoiL3dwLWFkbWluL2pzL2Jvb2ttYXJrbGV=LmpzIjtzOjM3OiI5NWM5ZWYzNWI3NmFmMmFjZWFmOWQ2YzU5NThlOGQ=M=8zOTU3IjtzOjMxOiIvd3AtYWRtaW4vanMvYm9va21hcmtsZXQubWluLmpzIjtzOjM3OiJhOTFjZDk1YmFlYjY2ZDQ4NzNkYmU=MjRiNzU5NzBjM=8yMDU1IjtzOjI4OiIvd3AtYWRtaW4vanMvY29sb3ItcGlja2VyLmpzIjtzOjM3OiIwNWM3ZjY3NTZhZWFjM2YyY2Y3ZDI3NmFmNjg4MTgyNk81NDcxIjtzOjMyOiIvd3AtYWRtaW4vanMvY29sb3ItcGlja2VyLm1pbi5qcyI7czozNzoiMmUzYTFmMmEwYWMyOTkwNjBkM2M4NTNlNjFkMDAyYjBPMzEwNCI7czoyMzoiL3dwLWFkbWluL2pzL2NvbW1lbnQuanMiO3M6Mzc6ImQ5ZTNkYjAwZGNjNmVmNGQ=YzAzZmY=NTVkY2I5YzU1TzIwMzQiO3M6Mjc6Ii93cC1hZG1pbi9qcy9jb21tZW5=Lm1pbi5qcyI7czozNzoiOGYzNjAzZWQwZDc3YzRhMWFlOGY4MmRiZDMxNTllZDlPMTI=NyI7czoyMjoiL3dwLWFkbWluL2pzL2NvbW1vbi5qcyI7czozODoiMzBlNDQ=OWFhNTQ=ZTE2NDhkMjNlZDdjMmQxYTU=MjNPMjc4NDgiO3M6MjY6Ii93cC1hZG1pbi9qcy9jb21tb24ubWluLmpzIjtzOjM4OiJhZGMyZTI1NDZkZWI=OGQxNTY=ZjUzOTI2NTBkMmEwNU8xMzgwMCI7czozMzoiL3dwLWFkbWluL2pzL2N1c3RvbS1iYWNrZ3JvdW5kLmpzIjtzOjM3OiJmNGNlZmY2MGU2MzA=NjI=NTQ=M2JjNTVlZTdiYWJhOU8yMjAwIjtzOjM3OiIvd3AtYWRtaW4vanMvY3VzdG9tLWJhY2tncm91bmQubWluLmpzIjtzOjM3OiIzNTFmMmVlZjFkNTAzM2Q2OGU4OTgyZWE4NjE2N2UzZk8xMTQ4IjtzOjI5OiIvd3AtYWRtaW4vanMvY3VzdG9tLWhlYWRlci5qcyI7czozNzoiMzJiMzAwNTg4N2E=Y2I2MDZmZWNjMDljNzU2NjA1YmJPMTUwMiI7czozNDoiL3dwLWFkbWluL2pzL2N1c3RvbWl6ZS1jb25=cm9scy5qcyI7czozOToiNTYyZThhOTA2N2E2Mjc4OWFjZTBlMjFhMWNiMTJlZmRPMTY=MTg=IjtzOjM4OiIvd3AtYWRtaW4vanMvY3VzdG9taXplLWNvbnRyb2xzLm1pbi5qcyI7czozODoiMGU5Zjc=NjQ3ODNkYjhlZWMwYTM2Mjk3OTE=NDg1NzVPNjQwNDMiO3M6MzU6Ii93cC1hZG1pbi9qcy9jdXN=b21pemUtbmF2LW1lbnVzLmpzIjtzOjM4OiI5YjZmZDM5MDBhMmRkODhjNGRlMGU=NjU1ZjM2MmNiM=85NzgxNiI7czozOToiL3dwLWFkbWluL2pzL2N1c3RvbWl6ZS1uYXYtbWVudXMubWluLmpzIjtzOjM4OiI2NzZmNTU5YzI=ZGNjODY5MTg2OWU4NmJlM2NmNzJjME8=MzU3NCI7czozMzoiL3dwLWFkbWluL2pzL2N1c3RvbWl6ZS13aWRnZXRzLmpzIjtzOjM4OiJkYTA4ZDNlODhlZTY1MjU1MTFkYTBjYTE1MThmZWYwOE82ODM4MSI7czozNzoiL3dwLWFkbWluL2pzL2N1c3RvbWl6ZS13aWRnZXRzLm1pbi5qcyI7czozODoiMDZlMWI5YThiODkyYzcwZTFjODVkNmU3MWE4MTgwNDJPMjc4NTYiO3M6MjU6Ii93cC1hZG1pbi9qcy9kYXNoYm9hcmQuanMiO3M6Mzc6ImU2YWVlMTVhZTdjYmMzOWM=MWUwY2FhMmU5M2VmNjM1TzU3OTAiO3M6Mjk6Ii93cC1hZG1pbi9qcy9kYXNoYm9hcmQubWluLmpzIjtzOjM3OiIwZGMxMzNlMjhkMTllZDZhZTE4NzAyYTU4YTMzNTE4ME8zMjE4IjtzOjI5OiIvd3AtYWRtaW4vanMvZWRpdC1jb21tZW5=cy5qcyI7czozODoiZWFiY2MwYzVlN2Q3YTQzN2I2MTRmYWI=MDg5YTY4MTBPMjc1MDEiO3M6MzM6Ii93cC1hZG1pbi9qcy9lZGl=LWNvbW1lbnRzLm1pbi5qcyI7czozODoiYTIxOWEwYjI3NjIyNWJiM2JhY2FjOGMyY2IzNzc2YjRPMTQ2ODYiO3M6Mjk6Ii93cC1hZG1pbi9qcy9lZGl=b3ItZXhwYW5kLmpzIjtzOjM4OiJjN2Q4ZTI=ZjRjMjA4MTA4YjdjYWYyZGY4OGQ5YjU=YU8zMzQwMyI7czozMzoiL3dwLWFkbWluL2pzL2VkaXRvci1leHBhbmQubWluLmpzIjtzOjM4OiI=NTAwMDM=YTI2ZDczYjczN2Y3NjFhZGNjN2VmNWM3OU8xMzUxOCI7czoyMjoiL3dwLWFkbWluL2pzL2VkaXRvci5qcyI7czozODoiN2Q5MDAxYWEyNDVlNjAwNDI3MGIwMzg5YTk=NWRmODhPMTIwMDAiO3M6MjY6Ii93cC1hZG1pbi9qcy9lZGl=b3IubWluLmpzIjtzOjM3OiIwYmE4ZDdmYTIwZTg2ZjYwYjA2MTc2YzcyMTMwYmM=ZE82NDkzIjtzOjI2OiIvd3AtYWRtaW4vanMvZmFyYnRhc3RpYy5qcyI7czozNzoiYTczYWYzNTRhMDMyNDE3MTVkODY5OGZlZWEzNDBiOTJPNzY4OSI7czoyMzoiL3dwLWFkbWluL2pzL2dhbGxlcnkuanMiO3M6Mzc6Ijc4Y2ZhOTY1MDZiZjM5NjVjMThhZmE2ZGU1YjVhYmI2TzU1NTAiO3M6Mjc6Ii93cC1hZG1pbi9qcy9nYWxsZXJ5Lm1pbi5qcyI7czozNzoiNGU3YjI1ZTliYzMzNzRjZjM5MWQ1YTY1MjY1MWEyNzdPMzgxNSI7czoyNjoiL3dwLWFkbWluL2pzL2ltYWdlLWVkaXQuanMiO3M6Mzg6IjE2YTNjYjI2Y2IwODE=YTIzMWQ1OGIzOGM5N2RmODE=TzE3NzE3IjtzOjMwOiIvd3AtYWRtaW4vanMvaW1hZ2UtZWRpdC5taW4uanMiO3M6Mzc6IjUzMjg2ZDAwM2UzZTE5ZWFjYzI2OTI2Zjc2YzBkN2RmTzk2ODciO3M6MzI6Ii93cC1hZG1pbi9qcy9pbmxpbmUtZWRpdC1wb3N=LmpzIjtzOjM4OiJiOTIwYjI1OTkxMGZkYTMxODdkNzY2OWQzMzQ=YmJlNU8xMTM=NSI7czozNjoiL3dwLWFkbWluL2pzL2lubGluZS1lZGl=LXBvc3QubWluLmpzIjtzOjM3OiIxYzc2Y2JiYjE=NjA4NjU2NTg1MjNjYWE4NmYwNWNiYU83MTc1IjtzOjMxOiIvd3AtYWRtaW4vanMvaW5saW5lLWVkaXQtdGF4LmpzIjtzOjM3OiJlYzU4MThjNDUyMzg=NjFjYmNlMWZlZTE4NzIzNjQ5ME83NDc4IjtzOjM1OiIvd3AtYWRtaW4vanMvaW5saW5lLWVkaXQtdGF4Lm1pbi5qcyI7czozNzoiZGRlOTEyN2RlNGMyOTk1ZmM=MzRiMjAwZjBkZDYxNWJPMjc1NSI7czoyNDoiL3dwLWFkbWluL2pzL2lyaXMubWluLmpzIjtzOjM4OiI=NTA3NjA2NGZkY2JmY2Y5ZjVjODk5NmUxMGFjNGJjOU8yMzYwOCI7czozMjoiL3dwLWFkbWluL2pzL2xhbmd1YWdlLWNob29zZXIuanMiO3M6MzY6IjA5ZTIwMTUwYzc1NjFkMDMzMGQ3MTU4Zjc=NGFiYjRhTzYyNSI7czozNjoiL3dwLWFkbWluL2pzL2xhbmd1YWdlLWNob29zZXIubWluLmpzIjtzOjM2OiIxZDY4MjIzODRhNzEwOTBjNzRhZGQxMDZlNDQ2ODU4MU8zNzQiO3M6MjA6Ii93cC1hZG1pbi9qcy9saW5rLmpzIjtzOjM3OiIxYzg2NzVkY2QwMzVjZmIzNzRmNjdiZmNiZjExN2E4Y=8yMjQ3IjtzOjI=OiIvd3AtYWRtaW4vanMvbGluay5taW4uanMiO3M6Mzc6ImY5ZmY=Njk=OTMzMDAxOTMzYmRlYzJjMTMzYjIyNTJkTzE2NDYiO3M6Mjk6Ii93cC1hZG1pbi9qcy9tZWRpYS1nYWxsZXJ5LmpzIjtzOjM3OiJkMDgwOTA=ODg3NGQyMzRlMzVhYmFlNjVkYzE3NzEwYU8xMTc5IjtzOjMzOiIvd3AtYWRtaW4vanMvbWVkaWEtZ2FsbGVyeS5taW4uanMiO3M6MzY6IjMyOTZkMWZhMjBkMjkyYjAwMmJiYTEwNDkwZjFiYTZlTzUzNyI7czoyODoiL3dwLWFkbWluL2pzL21lZGlhLXVwbG9hZC5qcyI7czozNzoiOTRiNDY=ZTliNGVjNmI1NDU=ODZhZjc5NWYyNDAxNmRPMTk4NCI7czozMjoiL3dwLWFkbWluL2pzL21lZGlhLXVwbG9hZC5taW4uanMiO3M6Mzc6ImYzMjAxNzRlZDYzZGUyNzUyNjRkY2Y1NDMwYzMwOWRjTzExNTMiO3M6MjE6Ii93cC1hZG1pbi9qcy9tZWRpYS5qcyI7czozNzoiOWRkZDRkNzYyZDgwNWIyYzVlYTQ1ODUxNWNjNWUyMTdPMjk3NSI7czoyNToiL3dwLWFkbWluL2pzL21lZGlhLm1pbi5qcyI7czozNzoiOWJlNjNhZGJhZjVhNWFjZmRiZmRkNTU1ZGMxOTc3N2RPMTg3NCI7czoyNDoiL3dwLWFkbWluL2pzL25hdi1tZW51LmpzIjtzOjM4OiJmNWFlOWU3OGI=N2M1MDk2YjEwYWZlYjBlMWU5NTFlNU8=MTU3NCI7czoyODoiL3dwLWFkbWluL2pzL25hdi1tZW51Lm1pbi5qcyI7czozODoiMDMwZGYxZjg1NTA5ODNlZWI2ZjM=ZmY=NmJmZDhkN2JPMjA5ODMiO3M6Mzk6Ii93cC1hZG1pbi9qcy9wYXNzd29yZC1zdHJlbmd=aC1tZXRlci5qcyI7czozNzoiMjg=NzU3NmVjNDUyOTNhYjk2ZGMwMDMwOTc=ZTI2MjlPMjQwNyI7czo=MzoiL3dwLWFkbWluL2pzL3Bhc3N3b3JkLXN=cmVuZ3RoLW1ldGVyLm1pbi5qcyI7czozNjoiMWFhYTc=YTI=YWVmOTgyYjgyNDk4NzE3YzFkMWU2ZDFPNzg=IjtzOjMwOiIvd3AtYWRtaW4vanMvcGx1Z2luLWluc3RhbGwuanMiO3M6Mzc6ImI2MDZjZjJiYTA2MzUzYjBlMzgzZTM2YjRiZDE5YTMwTzYyNjYiO3M6MzQ6Ii93cC1hZG1pbi9qcy9wbHVnaW4taW5zdGFsbC5taW4uanMiO3M6Mzc6IjQ2YWMwMzg3NTI=NWUyNGEwZDFiZTQ4OWI2Y2I=YzJmTzIzMjEiO3M6MjA6Ii93cC1hZG1pbi9qcy9wb3N=LmpzIjtzOjM4OiI=MTBmZDk5YTBhY2EwMmRjZjZhYmRhOGI5ODIyMmQ5OU8zNzQwOSI7czoyNDoiL3dwLWFkbWluL2pzL3Bvc3QubWluLmpzIjtzOjM4OiJlZGU1ZjdlODQzMWRiZWI3OTBlOGNmOTY2NTE5MjE3MU8xODM3OSI7czoyMzoiL3dwLWFkbWluL2pzL3Bvc3Rib3guanMiO3M6Mzg6ImUzZGZjM2I3MWZlZmM4YzZlYjgyZGY1NGUzNDYwYjUzTzExOTA4IjtzOjI3OiIvd3AtYWRtaW4vanMvcG9zdGJveC5taW4uanMiO3M6Mzc6ImRkZmUyN2Y=ZWZhZTczN2I4MDBiYWQ5NmVkOGEwOTY5TzQxOTIiO3M6MjY6Ii93cC1hZG1pbi9qcy9wcmVzcy1=aGlzLmpzIjtzOjM4OiJmMjQ4ZjMwYThhN2Q3ODJkNGUzODk2MmM4ZjBlNjMyOU8yNTc3NCI7czozMDoiL3dwLWFkbWluL2pzL3ByZXNzLXRoaXMubWluLmpzIjtzOjM4OiJjZWVjMDI1ZDQ3MTA1ODFjOGEwOTg2ODYwYzhkZmFjOU8xMTQ2MiI7czoyNToiL3dwLWFkbWluL2pzL3JldmlzaW9ucy5qcyI7czozODoiNGViODI=Yjc1ZDNlNGQ2MmJkYzgwYTZkMmE3OWEzNzdPMzM2NzkiO3M6Mjk6Ii93cC1hZG1pbi9qcy9yZXZpc2lvbnMubWluLmpzIjtzOjM4OiIxODlhNGQ4NDM=OWZlMWY=ZGZhMGVjNDhjODJlZmIwNE8xNzg3NiI7czozNDoiL3dwLWFkbWluL2pzL3NldC1wb3N=LXRodW1ibmFpbC5qcyI7czozNjoiMmI1MTUzNTc2ZDFlZWU=MDAyZmI3ZWQ5ZTU4MzEyNTFPNzc3IjtzOjM4OiIvd3AtYWRtaW4vanMvc2V=LXBvc3QtdGh1bWJuYWlsLm1pbi5qcyI7czozNjoiOGJjNWNhMTJmYTM4YTYwN2Q1YWYyMTgxMzExYjdhNWJPNTI1IjtzOjI3OiIvd3AtYWRtaW4vanMvc3ZnLXBhaW5=ZXIuanMiO3M6Mzc6Ijg3ZGNmYmU5N2Y5MDJmYTc3Y2M=YTk4ODljODI3YWZjTzU=ODQiO3M6MzE6Ii93cC1hZG1pbi9qcy9zdmctcGFpbnRlci5taW4uanMiO3M6Mzc6ImE3OWFjYTU2MWE1Yjg3YjYyYTcxMGIwNTI2YThlNGJkTzI=MTAiO3M6MjQ6Ii93cC1hZG1pbi9qcy9=YWdzLWJveC5qcyI7czozNzoiMjI=MDk2MDViNjRiMzM=Y2I5M2Y3N2UyNDZlMzVmZjVPNjg=MiI7czoyODoiL3dwLWFkbWluL2pzL3RhZ3MtYm94Lm1pbi5qcyI7czozNzoiYjFhNjIzMzkxYTZlNDVlMjM3Yzg4NDk2M2MzZDg2YzVPMzE1MSI7czoyODoiL3dwLWFkbWluL2pzL3RhZ3Mtc3VnZ2VzdC5qcyI7czozNzoiOGJlNzQwNGY=NzIzODY5MGQyNjYxZWYwYzFiMDM=ODFPNTE=OCI7czozMjoiL3dwLWFkbWluL2pzL3RhZ3Mtc3VnZ2VzdC5taW4uanMiO3M6Mzc6IjUwMjNmNjZmYTk4MDQxNGU1MTc3ZTlhNmIyOWFmZjI2TzIxMzkiO3M6MjA6Ii93cC1hZG1pbi9qcy9=YWdzLmpzIjtzOjM3OiI=Y2M2NDI2NmYxYjM1YTg2YzYzY2MxYjJjNDJmNzMwNk8yNTkyIjtzOjI=OiIvd3AtYWRtaW4vanMvdGFncy5taW4uanMiO3M6Mzc6IjRlYzJhZTY2MzYwYWEwZWRjNzIyNzRlYTcxODgzMDlhTzE1NzMiO3M6MjE6Ii93cC1hZG1pbi9qcy9=aGVtZS5qcyI7czozODoiZWNmYjU1ZGRkN2IyZjczNDBlZTUwMTE5NWY2MzZhZmJPNTE4MjgiO3M6MjU6Ii93cC1hZG1pbi9qcy9=aGVtZS5taW4uanMiO3M6Mzg6IjY=Y2ZlNmQyOTE2YzliMjkyNjQ=MTRhNTVmNzllMDM4TzI1MzMxIjtzOjIzOiIvd3AtYWRtaW4vanMvdXBkYXRlcy5qcyI7czozODoiNDgwYTk2ODNhODdlYjMyMGQzM2Q1ZjYwMzBlYWQ2ZjZPNzg2OTIiO3M6Mjc6Ii93cC1hZG1pbi9qcy91cGRhdGVzLm1pbi5qcyI7czozODoiM2U5OTUwOGQ3YjhjNDYzNjJmOTlkY2NkMWRjZjk2M2NPMzQzNDMiO3M6Mjg6Ii93cC1hZG1pbi9qcy91c2VyLXByb2ZpbGUuanMiO3M6Mzg6ImM1Zjk1ZThmOWNlZDNkMDZkMTM3ZWM3ZjVhMTJkZTVhTzEyMDg2IjtzOjMyOiIvd3AtYWRtaW4vanMvdXNlci1wcm9maWxlLm1pbi5qcyI7czozNzoiYzRhNjY=ZWVjOWZlOTcyZmZhNGY1OGE5OTMyYTZiYTFPNjIyNCI7czoyODoiL3dwLWFkbWluL2pzL3VzZXItc3VnZ2VzdC5qcyI7czozNzoiMWUzMzI5MDgwN2ZhOGIyODI5ZGRiMDM=N2QwYTkzMDVPMTA3MCI7czozMjoiL3dwLWFkbWluL2pzL3VzZXItc3VnZ2VzdC5taW4uanMiO3M6MzY6ImUwODk1NDVjZDdmY2RlNWM3Y2Q3MGRlM2E3MDEzOWUxTzY3OSI7czoyMzoiL3dwLWFkbWluL2pzL3dpZGdldHMuanMiO3M6Mzg6ImRiMWZlOGU=ZTJkMjhiMzQ5MzMxNzBlNzY1MWQ5YzNlTzE3MTM4IjtzOjI3OiIvd3AtYWRtaW4vanMvd2lkZ2V=cy5taW4uanMiO3M6Mzg6IjBjYzc1MWFjYmQ5ZDQwY2ZlMjVmMGE1NTIwODk5MzI2TzEwMDA=IjtzOjI2OiIvd3AtYWRtaW4vanMvd29yZC1jb3VudC5qcyI7czozNzoiNzcxNzEwOWY4Nzk3YTFiNmNmZmNhY2NkMmY2OTE4MWZPNzc1OCI7czozMDoiL3dwLWFkbWluL2pzL3dvcmQtY291bnQubWluLmpzIjtzOjM3OiI5OTdmNTA1ZmM5ZDI=YTI3ZTQ5Mzk2NDE=NTBlOTZhNE8xNTA4IjtzOjM=OiIvd3AtYWRtaW4vanMvd3AtZnVsbHNjcmVlbi1zdHViLmpzIjtzOjM2OiI5Njg1MjhjYjMyNTQ3MWViMDAxZmQ4NTc4YTg2MjVlNU82ODQiO3M6Mzg6Ii93cC1hZG1pbi9qcy93cC1mdWxsc2NyZWVuLXN=dWIubWluLmpzIjtzOjM2OiI3MDBhOTRlOTkzNGM3YjQxOWRmYTY3OTBiMWRjNGEzNU8zMzEiO3M6MTk6Ii93cC1hZG1pbi9qcy94Zm4uanMiO3M6MzY6ImUyZDZlZWNiZDc3NGFmMWUyYmIxYTE2ZWMxMTcyODZiTzYyOCI7czoyMzoiL3dwLWFkbWluL2pzL3hmbi5taW4uanMiO3M6MzY6IjY2YjIyN2NhMjhmNDFmMmUwNjE1YjA=YTM5MGQ1ZTA=TzQ=MSI7czoyMjoiL3dwLWFkbWluL2xpbmstYWRkLnBocCI7czozNjoiYTBlZTBlYWFiN2M2ZjMyMTcxYjAyMTU=MDljYWEyZmNPNzAwIjtzOjI2OiIvd3AtYWRtaW4vbGluay1tYW5hZ2VyLnBocCI7czozNzoiMDU4Mjc4NTZkYmRiYWY5ODI=ZTI4ZGYwMzMzOTk3NTBPMzg2NyI7czoyOToiL3dwLWFkbWluL2xpbmstcGFyc2Utb3BtbC5waHAiO3M6Mzc6IjU4NDM2YTVhZjZmMzE4MzUyYmY1OTZhYjhhM2Y=OTYyTzI=MDEiO3M6MTg6Ii93cC1hZG1pbi9saW5rLnBocCI7czozNzoiNmU=MTczZmQ=M2EyYTAxYjM1MDljODBlZTk4NGQyMmJPMjYyNSI7czoyNjoiL3dwLWFkbWluL2xvYWQtc2NyaXB=cy5waHAiO3M6Mzc6ImZhNDM1NGVmOWU3MjlhMDY1YmE=ZGI4OTQzOTYyNzA1TzIxOTciO3M6MjU6Ii93cC1hZG1pbi9sb2FkLXN=eWxlcy5waHAiO3M6Mzc6IjJiOTRhYTcyYTZlMjgzZWY3ZWM=MDFiNDUxN2I5ZGE=TzI4ODEiO3M6MjY6Ii93cC1hZG1pbi9tYWludC9yZXBhaXIucGhwIjtzOjM3OiJlMTgwYTNiYjE3Yjg5NmUxY2RjY2YzMzc5OTViZmUyZk83MTczIjtzOjIzOiIvd3AtYWRtaW4vbWVkaWEtbmV3LnBocCI7czozNzoiODM2ZjkyMDhjNjU2ODJhYWI3NjgxOTA5ZDlhODBhYmRPMzA5NyI7czoyNjoiL3dwLWFkbWluL21lZGlhLXVwbG9hZC5waHAiO3M6Mzc6IjJjMjI3MjA5MTA2YjJjMmQxYTg5NWUxYzFhYjIzM2YyTzMzMjAiO3M6MTk6Ii93cC1hZG1pbi9tZWRpYS5waHAiO3M6Mzc6ImNlZjIwMWU=Yzk3N2M5MDhjODY5YzYzNTAzYzI5MWQxTzUyMDMiO3M6MjU6Ii93cC1hZG1pbi9tZW51LWhlYWRlci5waHAiO3M6Mzc6IjY1NjEzY2MzNDYyZjkwZjZhYmEzZDFlNzdmMmUzNjk4TzkyMzgiO3M6MTg6Ii93cC1hZG1pbi9tZW51LnBocCI7czozODoiYjU3MjcwZTkzNzMzM2E4OWJmYzlkOWE3YzQ3ZGExMDdPMTI4NzIiO3M6MjQ6Ii93cC1hZG1pbi9tb2RlcmF=aW9uLnBocCI7czozNjoiNTQxMjQyYTI5MzgwNTk1MmEwZTIyMjM=ZjA5ZDZmYTlPMzIwIjtzOjIyOiIvd3AtYWRtaW4vbXMtYWRtaW4ucGhwIjtzOjM2OiI5YTA1YjQ5NzQwZGZjZGFmNDUxNjg1MWI2MjM2MDZlNE8yMTEiO3M6Mjg6Ii93cC1hZG1pbi9tcy1kZWxldGUtc2l=ZS5waHAiO3M6Mzc6ImU2YWEyMDNkNjVmNDdjMTFhMGQ3ZDJhMjUxNDhjNzRmTzM5OTMiO3M6MjE6Ii93cC1hZG1pbi9tcy1lZGl=LnBocCI7czozNjoiMTZkNDJmZjYxN2M=YTYxNmMzYmQ5NGJhMTAzYTQ1ODJPMjMxIjtzOjI=OiIvd3AtYWRtaW4vbXMtb3B=aW9ucy5waHAiO3M6MzY6ImEyMWQyNzhlMDBjYTdkY2NmZTNhODFkNGUzODZhZmE5TzIzNiI7czoyMjoiL3dwLWFkbWluL21zLXNpdGVzLnBocCI7czozNjoiNWQxODYyMjRlYmY=ZGRkMGYxNzE5YzllZjRiODA=NjhPMjI4IjtzOjIzOiIvd3AtYWRtaW4vbXMtdGhlbWVzLnBocCI7czozNjoiNTIxY2I5NGI5NTAxY2EyNGJjNDk1YTMxYzY2OTI1ZDhPMjMwIjtzOjMyOiIvd3AtYWRtaW4vbXMtdXBncmFkZS1uZXR3b3JrLnBocCI7czozNjoiN2NiNDkyMjYwZjIyZWU1MzgxNmQ5NmJlMzg2OGJlNmRPMjMyIjtzOjIyOiIvd3AtYWRtaW4vbXMtdXNlcnMucGhwIjtzOjM2OiI=ODIzYzg2NjdiMjNjYTgzYjMxYmY5MDkzNjQ3ZTVhMk8yMjgiO3M6MjI6Ii93cC1hZG1pbi9teS1zaXRlcy5waHAiO3M6Mzc6IjM2OGMwOTJmNDQwZTQ4ODA5YTg5MTFlMzYyODMyZDQzTzQ=MjEiO3M6MjM6Ii93cC1hZG1pbi9uYXYtbWVudXMucGhwIjtzOjM4OiIzZGUwY2I1NTFmNjViYTFjMzExZTM=NmFhZGI=OGYxNE8=MDY4NiI7czoyMToiL3dwLWFkbWluL25ldHdvcmsucGhwIjtzOjM3OiI2ZDVmNDFkNmI5MTc3ZDIxMWQ=MjBhYTZhZjNkMzM1OE81Mjk4IjtzOjI3OiIvd3AtYWRtaW4vbmV=d29yay9hYm91dC5waHAiO3M6MzY6IjM2ZmQ2NjcxYTU=OTNjYzhjNTQwNTYyMWQ5NmRlYTdjTzI2MyI7czoyNzoiL3dwLWFkbWluL25ldHdvcmsvYWRtaW4ucGhwIjtzOjM3OiI=OGYxZmUzMzcwZjlkNzEzYjAyNzY1NWI2Nzg1ZTY5NE8xMDMzIjtzOjI5OiIvd3AtYWRtaW4vbmV=d29yay9jcmVkaXRzLnBocCI7czozNjoiYTFiZTU=MjUzZTcyYWNkOTZjZTYzMTcxMjdlNWE1YzBPMjY3IjtzOjI2OiIvd3AtYWRtaW4vbmV=d29yay9lZGl=LnBocCI7czozNjoiOTRiMmEyNGExZmM5ODgzMjQ2ZmMxMDNmMjI4MTg5MzBPODU1IjtzOjMwOiIvd3AtYWRtaW4vbmV=d29yay9mcmVlZG9tcy5waHAiO3M6MzY6ImUxYWYzOWU5NDIzOWE5NDQ=NDBhYjI5MjUzOTNhZTYwTzI2OSI7czoyNzoiL3dwLWFkbWluL25ldHdvcmsvaW5kZXgucGhwIjtzOjM3OiIyZjEyMGVkNmY2NDQ1NzhiNTE3OTA5MzQ4NzU4MDc5NE8yODAyIjtzOjI2OiIvd3AtYWRtaW4vbmV=d29yay9tZW51LnBocCI7czozNzoiYjU5ZTU2ZGZlMDAzYjk=OGVjNzNjMGU5MWYzM2YwMmRPNDEyMSI7czozNToiL3dwLWFkbWluL25ldHdvcmsvcGx1Z2luLWVkaXRvci5waHAiO3M6MzY6IjY1OGNmNjRiNzdkNDM1NTU1YWUyMTdhNWJiYjE1MzZhTzI3OSI7czozNjoiL3dwLWFkbWluL25ldHdvcmsvcGx1Z2luLWluc3RhbGwucGhwIjtzOjM2OiIxMzJhNmM5ZDZlMmNjNjhkNjUwZTJmY2E5YTAxNWVkMk8zOTAiO3M6Mjk6Ii93cC1hZG1pbi9uZXR3b3JrL3BsdWdpbnMucGhwIjtzOjM2OiJlNGY3Y2RmY2FkZGM=NjkzZmUwYmNjMzliYjU1ZDY4YU8yNjciO3M6Mjk6Ii93cC1hZG1pbi9uZXR3b3JrL3Byb2ZpbGUucGhwIjtzOjM2OiI2ODc=MTU3ZmRhMTgxYmMyODY2ZmQ4NjBkOTMzNzZiOU8yNzIiO3M6MzA6Ii93cC1hZG1pbi9uZXR3b3JrL3NldHRpbmdzLnBocCI7czozODoiY2I4N2JhMzAwMWU=NDdmYWNkZDQ1NjA5YzdmMTVhZGRPMTg=NjAiO3M6Mjc6Ii93cC1hZG1pbi9uZXR3b3JrL3NldHVwLnBocCI7czozNjoiY2U3NGU=M2QyNGQ5YzM2Y2Q1NzllOTMyZWU5NGIxNTJPMjY1IjtzOjMxOiIvd3AtYWRtaW4vbmV=d29yay9zaXRlLWluZm8ucGhwIjtzOjM3OiJjMmVkMTJlNzc4MmJiYjY2NmY5NWEyN2I3Y2NmOTNjNU84NjgwIjtzOjMwOiIvd3AtYWRtaW4vbmV=d29yay9zaXRlLW5ldy5waHAiO3M6Mzc6ImVhY2UzNTZkYTc3ZDRiNTRkZDQyOTkxMGViYzk3MzQ4Tzg5ODciO3M6MzU6Ii93cC1hZG1pbi9uZXR3b3JrL3NpdGUtc2V=dGluZ3MucGhwIjtzOjM3OiJkODI2NTAxMGE5ZGUyMDNiZTkzODc4NTBiYjA1OTU5ME83MTkwIjtzOjMzOiIvd3AtYWRtaW4vbmV=d29yay9zaXRlLXRoZW1lcy5waHAiO3M6Mzc6IjllZWM4OTk1ZDBjY2U=NWU3ZWE1MmZmY2ZiN2NiMTliTzgwNzIiO3M6MzI6Ii93cC1hZG1pbi9uZXR3b3JrL3NpdGUtdXNlcnMucGhwIjtzOjM4OiI5NDVmMGNlNzE3ODM4Yjg3M2UzNTIzOWJjZTI4NzZmOU8xMjYwMyI7czoyNzoiL3dwLWFkbWluL25ldHdvcmsvc2l=ZXMucGhwIjtzOjM4OiI=MWI4YWZiZWMyMzM1OTgxZTliMTFjODBkZmQ2N2I=ME8xMDkwNiI7czozNDoiL3dwLWFkbWluL25ldHdvcmsvdGhlbWUtZWRpdG9yLnBocCI7czozNjoiNWUxODI5YmYxNzk=Y2UwNmM1YWQ3N2I3ZTJkMTcxNDJPMjc3IjtzOjM1OiIvd3AtYWRtaW4vbmV=d29yay9=aGVtZS1pbnN=YWxsLnBocCI7czozNjoiNjI5NzA=ZTQxZmM2NzAxNzhhNDIyNmIzMjNiNmE5ZWNPMzg3IjtzOjI4OiIvd3AtYWRtaW4vbmV=d29yay9=aGVtZXMucGhwIjtzOjM4OiI4ZjBmMTQ1NzVkNTY=MDMyMWYzOTNhOGMxYjcyM2YxZk8xMTY1MiI7czozMzoiL3dwLWFkbWluL25ldHdvcmsvdXBkYXRlLWNvcmUucGhwIjtzOjM2OiI5NWI3ZDQ3ZWQ3MTM=OTEyMjcwZjhkMzA1OTEwMGU4Y=8yNzEiO3M6Mjg6Ii93cC1hZG1pbi9uZXR3b3JrL3VwZGF=ZS5waHAiO3M6MzY6ImZjYTYxMTBiZDJmM2ZiZDlmMjQ3NTQwNjc3ZmNmMWFjTzQ1OCI7czoyOToiL3dwLWFkbWluL25ldHdvcmsvdXBncmFkZS5waHAiO3M6Mzc6ImY1MjMzZWU5OTBjNTBhYWRlN2M=ZTNhYjliNGZlNTI=TzQ2NTUiO3M6MzE6Ii93cC1hZG1pbi9uZXR3b3JrL3VzZXItZWRpdC5waHAiO3M6MzY6IjAzMGJiNmFkM2YxYzYxNGY3ZjFhYTdmZDI3Yjc5NTA5TzI3MSI7czozMDoiL3dwLWFkbWluL25ldHdvcmsvdXNlci1uZXcucGhwIjtzOjM3OiJkZjdhMGVkY2I3OTk=NTgxNDMwMzc5ZGI1NmQ4ZDUzYk8=Nzk2IjtzOjI3OiIvd3AtYWRtaW4vbmV=d29yay91c2Vycy5waHAiO3M6Mzc6IjQ1OGE2MmVkYTA1ODVjYWExYzE5OWM=NTIwMmVjNjMxTzg2NTQiO3M6MzI6Ii93cC1hZG1pbi9vcHRpb25zLWRpc2N1c3Npb24ucGhwIjtzOjM4OiI4ZjNkNGQ=NTg2Y2RkNzgxODg=YzQ2ZmNjYjUwZTVkYk8xNDM5NyI7czoyOToiL3dwLWFkbWluL29wdGlvbnMtZ2VuZXJhbC5waHAiO3M6Mzg6IjBlOTY5MDIzYTA3NzgzOTMwYmE=MmJiNzY1NjQ5YTZjTzE1MjA2IjtzOjI2OiIvd3AtYWRtaW4vb3B=aW9ucy1oZWFkLnBocCI7czozNjoiOWE2MTZlN2RkNDY4ZDFjMjQ5OWI5MDYwMGU3MTBkYTVPNDg4IjtzOjI3OiIvd3AtYWRtaW4vb3B=aW9ucy1tZWRpYS5waHAiO3M6Mzc6IjQ4YjM3MTdjYWJkYmNjZGU1OTEzNmM=ZjVjMGM=YzYwTzU4ODgiO3M6MzE6Ii93cC1hZG1pbi9vcHRpb25zLXBlcm1hbGluay5waHAiO3M6Mzg6ImIzOTllM2YxNmZmYmFkOTc4ZDdkZWM2N2FkZjY2ZWIwTzE1MDI5IjtzOjI5OiIvd3AtYWRtaW4vb3B=aW9ucy1yZWFkaW5nLnBocCI7czozNzoiMjQwYmIwZGIxOGM1NmE1OWQ=ODczNjUzZGZmZDU1Y2ZPODM1NSI7czoyOToiL3dwLWFkbWluL29wdGlvbnMtd3JpdGluZy5waHAiO3M6Mzc6IjZkODE1NWExOTViNmNjMGViNDI4N2M2ZmM4ZjE2YzIwTzgwOTIiO3M6MjE6Ii93cC1hZG1pbi9vcHRpb25zLnBocCI7czozODoiNWQzMmU2NWExZmUwOGRhOGMwMTZkNzIwNmNkMmZjODVPMTE1NzUiO3M6Mjc6Ii93cC1hZG1pbi9wbHVnaW4tZWRpdG9yLnBocCI7czozODoiMDExN2FiMTY4ZjM3NjM2ZTE3OTBiNGVjMTZhNDI=NjlPMTIyNTkiO3M6Mjg6Ii93cC1hZG1pbi9wbHVnaW4taW5zdGFsbC5waHAiO3M6Mzc6ImU3ZDA1YzY2MDdhYjRlZTcyODQ4ZTkyOGQ5MWE4NjM=TzYxNTQiO3M6MjE6Ii93cC1hZG1pbi9wbHVnaW5zLnBocCI7czozODoiYmVjOTIyNTZiNWRhNjU5YjE1NjdkOGE5YjI5NDZiM2NPMjE3MjAiO3M6MjI6Ii93cC1hZG1pbi9wb3N=LW5ldy5waHAiO3M6Mzc6ImM5NjQ4MjFiNTc4NDkwNTE1OWY2MzA=NWZlNTk4M2JiTzI3NDAiO3M6MTg6Ii93cC1hZG1pbi9wb3N=LnBocCI7czozNzoiMjMwN2MyMzY2NGQwYzQ3NWExMmM2MDEwZjI2NGI5MjZPODE1OSI7czoyNDoiL3dwLWFkbWluL3ByZXNzLXRoaXMucGhwIjtzOjM2OiIxZDU5ZTc1MzI=MGFjNjMxM2VkNjg1YjM=ZjlkNTBmYU82MzUiO3M6MjE6Ii93cC1hZG1pbi9wcm9maWxlLnBocCI7czozNjoiOTE4NGU1M2Y5NmJhZGUzZTdhZTdjZGE5ZWRkZjdhMjZPMjk2IjtzOjIyOiIvd3AtYWRtaW4vcmV2aXNpb24ucGhwIjtzOjM3OiI3YzcyNzVhOTQ4MzMzOGQxMTljNDY4MTFkY2IzMWUxN=81MDM5IjtzOjI2OiIvd3AtYWRtaW4vc2V=dXAtY29uZmlnLnBocCI7czozODoiNzcxN2M2ZmRmNmY1NDg4YmY5MDA4ODg5ZGU4ZWY4MzFPMTQ4ODciO3M6MTg6Ii93cC1hZG1pbi9=ZXJtLnBocCI7czozNzoiMzhjMzhhYzlhMWNkNDc=ZTUyOGUwNDJkODMwMmViMDBPMjA1OSI7czoyNjoiL3dwLWFkbWluL3RoZW1lLWVkaXRvci5waHAiO3M6Mzg6IjY=Njk3ZGEwMDNmZjlmNzZjMDQxMDJmZDcwYTc4ZWI3TzExNTcxIjtzOjI3OiIvd3AtYWRtaW4vdGhlbWUtaW5zdGFsbC5waHAiO3M6Mzg6ImQyM2M=NzZlMTk4N2E1Mjk4YTdlMjZlZWJiMjZjZGIyTzE=NTU3IjtzOjIwOiIvd3AtYWRtaW4vdGhlbWVzLnBocCI7czozODoiZmFmNzIxNWZjZDdiYjI1YTZiYmYxODljOWY1MjkwZDNPMjA4MDgiO3M6MTk6Ii93cC1hZG1pbi9=b29scy5waHAiO3M6Mzc6IjBjMTM4ZjM5ZDFiMDcxMWFiOTIxYzYwZjNiNDdlMzE1TzU1MDciO3M6MjU6Ii93cC1hZG1pbi91cGRhdGUtY29yZS5waHAiO3M6Mzg6ImQ3NDY=MWUzMDlmYWQxN2RkNGYyMzY4OTA4N2U3MGViTzMwODgzIjtzOjIwOiIvd3AtYWRtaW4vdXBkYXRlLnBocCI7czozODoiNjk1OTUxZjE=NGZiODMzYzQxMGJkZjQwYWRkZTFhOTlPMTAzNTIiO3M6MzE6Ii93cC1hZG1pbi91cGdyYWRlLWZ1bmN=aW9ucy5waHAiO3M6MzY6IjY4MDcwZGU=MTczNmU1N2Y4NzU3NjQ4YTgwYjljYmJiTzM=MCI7czoyMToiL3dwLWFkbWluL3VwZ3JhZGUucGhwIjtzOjM3OiJiMmVmZGQwMDNhZWFjZDQ5ZWE4MzI1ZmM5MjMwMDBjM=8=NTEyIjtzOjIwOiIvd3AtYWRtaW4vdXBsb2FkLnBocCI7czozODoiNGRmN2Y2MTQwYzQ3NjNhMGJlODkyODNiNzlkYjY3M2JPMTMwODEiO3M6MjM6Ii93cC1hZG1pbi91c2VyLWVkaXQucGhwIjtzOjM4OiJhOTliYTE4NGM1YmVlYjA3NjNmMmJiZDFlYzA=MDY3MU8yNjUxNyI7czoyMjoiL3dwLWFkbWluL3VzZXItbmV3LnBocCI7czozODoiYWU2OWZiMjUyY2E2NjE1NzEzNjM=ODMyZTc2MmI5MWJPMjA4MDMiO3M6MjQ6Ii93cC1hZG1pbi91c2VyL2Fib3V=LnBocCI7czozNjoiOTllYzAwZGE4ZDkxNGI=ZWZkMjA5OGEzZTQ=ZWJlMmRPMjc1IjtzOjI=OiIvd3AtYWRtaW4vdXNlci9hZG1pbi5waHAiO3M6MzY6IjcwMmQ1MjIwYzcwNDU2NDU2ZmU5ZmM4Y2MwOGNjNTI=Tzg=MiI7czoyNjoiL3dwLWFkbWluL3VzZXIvY3JlZGl=cy5waHAiO3M6MzY6ImQ5MjBiNGZiMWJlMmMyYzc4MDA4MWQ1YjRiN2RlNTVhTzI3OSI7czoyNzoiL3dwLWFkbWluL3VzZXIvZnJlZWRvbXMucGhwIjtzOjM2OiIxYmE2Y2JiOWUyYTlkM2RlYjM=ODk5NzQ5MmVkNjkyZU8yODEiO3M6MjQ6Ii93cC1hZG1pbi91c2VyL2luZGV4LnBocCI7czozNjoiYzhmZDk4ZjdmZGQ1MmQ3OGJkYWRmNzRlNjIwNzg5ZmFPMjY5IjtzOjIzOiIvd3AtYWRtaW4vdXNlci9tZW51LnBocCI7czozNjoiYTUyOWUzZDNjMmJiODY2NzFmYjljYzExNDVjZjcwZWVPNzAwIjtzOjI2OiIvd3AtYWRtaW4vdXNlci9wcm9maWxlLnBocCI7czozNjoiYjlmYTE3YTk4MTExOTU4MDAwNzlkZGE=YjEyNjJkMDNPMjcwIjtzOjI4OiIvd3AtYWRtaW4vdXNlci91c2VyLWVkaXQucGhwIjtzOjM2OiIyYTdhNzVhMzYzYjBmODhmMGI2ZDA5NGE5MWVmNjVlYU8yNjgiO3M6MTk6Ii93cC1hZG1pbi91c2Vycy5waHAiO3M6Mzg6ImVmYjI3MjEyZmQ1YmI4NDA3MWEzMzA2NmIzM2M=OGFhTzE4MzA=IjtzOjIxOiIvd3AtYWRtaW4vd2lkZ2V=cy5waHAiO3M6Mzg6IjRlNWNlMGFlOWRkOWEzZWRmNTA4ZDBiMTU5MTk2YmNjTzE4MTc1IjtzOjE5OiIvd3AtYmxvZy1oZWFkZXIucGhwIjtzOjM2OiJlZGFkNzQ2MTRkNmQzZmEyMjUyYzNkNzRmZjAzN2FjN=8zNjQiO3M6MjE6Ii93cC1jb21tZW5=cy1wb3N=LnBocCI7czozNzoiZTU=Y2FlNzBiNzI1MmMzMmMxZjljMGM4YzFhN2QxYTRPMTYyNyI7czoxMjoiL3dwLWNyb24ucGhwIjtzOjM3OiJmMjgyNDJmNTc2NmQ2NTI1Yjk=OWYzNzY4MTMyMzZkM=8zMjg2IjtzOjI2OiIvd3AtaW5jbHVkZXMvYWRtaW4tYmFyLnBocCI7czozODoiNTBkN2I2NGE2YmQ3MzU1MGU4NDUyOWMxOGM4ZDJmZDFPMjcyNTQiO3M6MjQ6Ii93cC1pbmNsdWRlcy9hdG9tbGliLnBocCI7czozODoiODNjZjcwN2I=MTc4NTc1YWJiY2RmNjZkNWU2NGFkMmFPMTEzNTYiO3M6MzI6Ii93cC1pbmNsdWRlcy9hdXRob3ItdGVtcGxhdGUucGhwIjtzOjM4OiIxYTM3OWUzZjNjNzZkMjkzNjkyOWNiZjBjNDdhODQ4Mk8xNTUyMyI7czozNDoiL3dwLWluY2x1ZGVzL2Jvb2ttYXJrLXRlbXBsYXRlLnBocCI7czozODoiYjQ2NzViNmM2NzUwMDQwOThiYTA4YzM1MzUyMmVhODFPMTE2OTkiO3M6MjU6Ii93cC1pbmNsdWRlcy9ib29rbWFyay5waHAiO3M6Mzg6IjY5OTYyMTM1NGExZTZjMTkwYjI=MjhkMGMyNTQwYmNkTzEzNjY=IjtzOjIyOiIvd3AtaW5jbHVkZXMvY2FjaGUucGhwIjtzOjM4OiI5MTNkNWRmMGFlODJiZjcxYjgwZGFlM2EyMWQ3MTJjNk8yMjA1OCI7czoyNjoiL3dwLWluY2x1ZGVzL2Nhbm9uaWNhbC5waHAiO3M6Mzg6IjI=MjQ1YTMzMTcwYWI3ODYyMmNmNmJhOWNlYjU1YTllTzI2OTAyIjtzOjI5OiIvd3AtaW5jbHVkZXMvY2FwYWJpbGl=aWVzLnBocCI7czozODoiMzk3ZmUyODAzYjM2ZTE5MmZkZTU5MWNjNzUxY2VhYjBPMjM2MDEiO3M6MzQ6Ii93cC1pbmNsdWRlcy9jYXRlZ29yeS1=ZW1wbGF=ZS5waHAiO3M6Mzg6ImRlYWQ3YjgzMmM3N2ViYmI5NDhjYTcyMjczNjJlZDJkTzQ4NDkzIjtzOjI1OiIvd3AtaW5jbHVkZXMvY2F=ZWdvcnkucGhwIjtzOjM4OiI2NWY=NDU2ZGI=OThjNzc4NGY1ZTMxYzg3ZjkwMWM2YU8xMTk5NSI7czozOToiL3dwLWluY2x1ZGVzL2NlcnRpZmljYXRlcy9jYS1idW5kbGUuY3J=IjtzOjM5OiJkZDFjN2JkZWJkZmM=MTFlYjhhMzM2ZTNkNzU4NjkyY=8yNzk1NjQiO3M6Mjc6Ii93cC1pbmNsdWRlcy9jbGFzcy1mZWVkLnBocCI7czozNjoiY2MyOTI=NmJhNmJmMzM1YzIwYTIxMmIzZjczMjQ1YjZPNTIyIjtzOjI3OiIvd3AtaW5jbHVkZXMvY2xhc3MtaHR=cC5waHAiO3M6Mzg6ImIxYzUzODM3YjIzNWJmNzEwOTJhMTViZTE5ZTIwODIxTzM1NzQ4IjtzOjI2OiIvd3AtaW5jbHVkZXMvY2xhc3MtSVhSLnBocCI7czozNzoiMzJhYzc2YmVhMjMwNzAyMjg1MmIyZjdhNjJjNjBjMmJPMjU3MyI7czoyNzoiL3dwLWluY2x1ZGVzL2NsYXNzLWpzb24ucGhwIjtzOjM4OiI4MDhhNDI3YmEwNzY=M2Q=ZGVhZjRkZmRjZjQxOGU2ZE8=MDQ3MiI7czoyOToiL3dwLWluY2x1ZGVzL2NsYXNzLW9lbWJlZC5waHAiO3M6Mzg6IjNjNWE4ZWVhMDAwNmU=Y2FjMWEwMGUwODU4OTk4ZDY1TzI5MDQxIjtzOjI5OiIvd3AtaW5jbHVkZXMvY2xhc3MtcGhwYXNzLnBocCI7czozNzoiMDMxOTFhMjEwY2NiZWE1NGNiMDdkZWRmZWRiN2NjNDJPNzMxNyI7czozMjoiL3dwLWluY2x1ZGVzL2NsYXNzLXBocG1haWxlci5waHAiO3M6Mzk6IjNlZmY5ZWQ=YjZjYWRmOTkwYjRmMjM4ZWQ5MWM1YWRlTzE=Njc4NCI7czoyNzoiL3dwLWluY2x1ZGVzL2NsYXNzLXBvcDMucGhwIjtzOjM4OiIxNTRiNTQ1MWM4YTkzYTRmMjFhNzQwNTRiZTk2MWQ3OU8yMDkxOSI7czozMToiL3dwLWluY2x1ZGVzL2NsYXNzLXJlcXVlc3RzLnBocCI7czozODoiMzk2NWFjYTExODFiMmZiNmVjNzU2MTdhYjRkNDIyM2NPMjk3OTAiO3M6MzI6Ii93cC1pbmNsdWRlcy9jbGFzcy1zaW1wbGVwaWUucGhwIjtzOjM4OiIwZGJlZjM5NGE5MTEyN2YwNjhhYzhmZGQ1ODdkNDg5NU84OTI2NCI7czoyNzoiL3dwLWluY2x1ZGVzL2NsYXNzLXNtdHAucGhwIjtzOjM4OiIxMmM2MmIyMjA3NWEzYzRiNzRlYmM4YWIzYTk4ZDI5NU8zOTQ3OCI7czoyOToiL3dwLWluY2x1ZGVzL2NsYXNzLXNub29weS5waHAiO3M6Mzg6IjczYjA1Y2RlYzU4NTlmZjZlZGNmYmNkMjJlYmQwOTYwTzM3Nzg1IjtzOjQ3OiIvd3AtaW5jbHVkZXMvY2xhc3Mtd2Fsa2VyLWNhdGVnb3J5LWRyb3Bkb3duLnBocCI7czozNzoiMDk5MWRmYjZlNmZmNzk3Njg=ZGQyNTYwMmNhZGM5NmRPMjE1NiI7czozODoiL3dwLWluY2x1ZGVzL2NsYXNzLXdhbGtlci1jYXRlZ29yeS5waHAiO3M6Mzc6IjM5NWMzM2ZlNjU=NDdiM2ExODcyYTA4N2Y2MGUzZDRhTzY3NTMiO3M6Mzc6Ii93cC1pbmNsdWRlcy9jbGFzcy13YWxrZXItY29tbWVudC5waHAiO3M6Mzg6Ijk1MmYwNzI4NjM5MDQxNTE1YzFiOGY4OGY3ZWE1MzE2TzExMzcwIjtzOjM4OiIvd3AtaW5jbHVkZXMvY2xhc3Mtd2Fsa2VyLW5hdi1tZW51LnBocCI7czozNzoiMTUwMWVlNGVlNTcxNWIzYjhiZWI5ZWU5NjQ5ODEwM2FPNzg2MCI7czo=MzoiL3dwLWluY2x1ZGVzL2NsYXNzLXdhbGtlci1wYWdlLWRyb3Bkb3duLnBocCI7czozNzoiNDcwMWJjN2M=NmUwOTk3OWZhODIwODI5NTdiYWI=ZjRPMjMzNiI7czozNDoiL3dwLWluY2x1ZGVzL2NsYXNzLXdhbGtlci1wYWdlLnBocCI7czozNzoiMDRiM2VkNGI2YzlhZjliMmY4NGU2MGUyNzdkZjU=NjhPNTgyMSI7czozNToiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLWFkbWluLWJhci5waHAiO3M6Mzg6IjM5YzlkZmQ=ODZiOGYxZDhkMDk=NjhjZjA4NTdiODljTzE2ODIxIjtzOjM5OiIvd3AtaW5jbHVkZXMvY2xhc3Mtd3AtYWpheC1yZXNwb25zZS5waHAiO3M6Mzc6IjIxNWExNjlkMTQ2YjlkODk=ZjY3ODdhNGY3MTc3ZGZlTzUwNDMiO3M6Mzk6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1jb21tZW5=LXF1ZXJ5LnBocCI7czozODoiYTIwMWY1NzhjZTMwOGY1YTE2MTQ4MjhjNDcwYzE5NzRPNDIzNTMiO3M6MzM6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1jb21tZW5=LnBocCI7czozNzoiMmM2N2M1ZDU=NmQ3YzQzYjljMWI2MDQyNjc5YThjYjJPOTQzOSI7czo=MzoiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLWN1c3RvbWl6ZS1jb25=cm9sLnBocCI7czozODoiNjU4MmU5YmU5YTFhMjk1ZDNjODJmMGUxOWY=ZmNjYjBPMjIwMzIiO3M6NDM6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1jdXN=b21pemUtbWFuYWdlci5waHAiO3M6Mzk6ImNhYWEyNTM2NzIxMGNiZThjZmEwMmIxNzU2YWMwODU2TzE=MjgxNCI7czo=NToiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLWN1c3RvbWl6ZS1uYXYtbWVudXMucGhwIjtzOjM4OiIxMjRjZjU=MzQ4OTQ1NDMyZmYwZGM=MGU5NTdhZTZiZE8=OTYxMSI7czo=MToiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLWN1c3RvbWl6ZS1wYW5lbC5waHAiO3M6Mzc6ImYxOGYzMTViODFkOTJjYjY1M2E4MmQ5MDJlNDJkZWU=Tzk2MDMiO3M6NDM6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1jdXN=b21pemUtc2VjdGlvbi5waHAiO3M6Mzg6ImU3NmZhODQ4NGZjMTIwMTE5ZjM5MmQzOTdmNjNhMDgxTzEwMTY2IjtzOjQzOiIvd3AtaW5jbHVkZXMvY2xhc3Mtd3AtY3VzdG9taXplLXNldHRpbmcucGhwIjtzOjM4OiI1ZGU3MjE1OGZlYTIyZDZiYjEzOTIyY2RkOWMzOTBmOU8yNzYwNCI7czo=MzoiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLWN1c3RvbWl6ZS13aWRnZXRzLnBocCI7czozODoiNDhhMTMxYzhhNDFmMDEyNDVlMTFhNjlhYWY3ZjcwYTNPNjUyMzYiO3M6MzY6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1kZXBlbmRlbmN5LnBocCI7czozNzoiMWQwOTk2NWNhNmI4ODI=ZDQ4NDZiNjNmNDY3NDllOWJPMTY4MyI7czozMjoiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLWVkaXRvci5waHAiO3M6Mzg6ImFjMDJiMDA5YjhmODZiZWEwNTFhYTFhM2ZhZGQyMzFiTzU=MDY2IjtzOjMxOiIvd3AtaW5jbHVkZXMvY2xhc3Mtd3AtZW1iZWQucGhwIjtzOjM4OiI1Y2ZhZWIyOTYzZTQ4ZDYyOTJlMDE3Mjc2ZTA=ZTRhY=8xMjA4NSI7czozMToiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLWVycm9yLnBocCI7czozNzoiMzFjYjBiNTRlNTI4MzA5YmQ4ZTc1Nzk4MTQ4YTM4MDZPNDY2NCI7czo=NjoiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLWZlZWQtY2FjaGUtdHJhbnNpZW5=LnBocCI7czozNzoiYWFmNzJkMzNmM2NkMWZjN2FiYTFiZDk1YTliMDExMjJPMjcwOCI7czozNjoiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLWZlZWQtY2FjaGUucGhwIjtzOjM2OiJhZDYyOTMwNGVlNTYxYWQ1MTY=MjNkZTQ3OGZkM2RhYk83NjQiO3M6MzA6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1ob29rLnBocCI7czozODoiZmFmYjhjZTNjMTQ5OThlYmUwMGJjMDhjOWEyZTMxMzhPMTQ=NjAiO3M6Mzc6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1odHRwLWNvb2tpZS5waHAiO3M6Mzc6ImRlZjE4N2JmNjU5ZWVlMmVhOTczZmFjYTg4ZWQ=NmQ4TzY1NTEiO3M6MzU6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1odHRwLWN1cmwucGhwIjtzOjM4OiJlNDEwNTFhZGMwNDdjMTIzNGE4OTUyYzM5OTFjNDFlYU8xMTczMSI7czozOToiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLWh=dHAtZW5jb2RpbmcucGhwIjtzOjM3OiI2YmQ2MTA2Yjk3ZTY2MmVhMzdlNTY4ZGE1ZTIzM2NjME82NDQ=IjtzOjQxOiIvd3AtaW5jbHVkZXMvY2xhc3Mtd3AtaHR=cC1peHItY2xpZW5=LnBocCI7czozNzoiYzFkNWM2M2YwYzZmNjE1YWQ4M2I2Y2ZlOTZiZDExZWNPMzI1MCI7czozNjoiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLWh=dHAtcHJveHkucGhwIjtzOjM3OiJjMDNkODk5YWJhZTc=ZDFhN2JhMzM4Mjk3NjA1YmIxY=81OTU3IjtzOjQ1OiIvd3AtaW5jbHVkZXMvY2xhc3Mtd3AtaHR=cC1yZXF1ZXN=cy1ob29rcy5waHAiO3M6Mzc6IjZmMWNkYTlmMTlmOTA4YTRkODQ=MGE=NjA1N2YyZDhjTzE4ODciO3M6NDg6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1odHRwLXJlcXVlc3RzLXJlc3BvbnNlLnBocCI7czozNzoiNzNlYTdiMmM2OWQzN2IzOWE1Y2FhZmM=N2FjZjI2ODJPNDUyNiI7czozOToiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLWh=dHAtcmVzcG9uc2UucGhwIjtzOjM3OiJjYjE=NWY=ZjAzNzdmNjA5MGFlYzQyM2QzYzExMWI=NU8zMDk=IjtzOjM4OiIvd3AtaW5jbHVkZXMvY2xhc3Mtd3AtaHR=cC1zdHJlYW1zLnBocCI7czozODoiZGFiYTVmNWU2Y2Y2NjVlZDMxMTA5NjYxYjNkNzk1ZThPMTQ5NDgiO3M6NDE6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1pbWFnZS1lZGl=b3ItZ2QucGhwIjtzOjM4OiI5M2IxYTBhMTEwY2VhYmZhMGVkZWE4MDQzNjQwYWI1ME8xMzE3OSI7czo=NjoiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLWltYWdlLWVkaXRvci1pbWFnaWNrLnBocCI7czozODoiYjdmY2E4YzY4ODM2ZTQzMDczZjg3OTRkNmNiYTcyYTRPMjE3MDkiO3M6Mzg6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1pbWFnZS1lZGl=b3IucGhwIjtzOjM4OiJjZWVkMjYxNWY=NGQ1OTdhOGYyYzczM2RkNmEzYTQ2Zk8xMjAxOSI7czozNToiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLWxpc3QtdXRpbC5waHAiO3M6Mzc6ImJlMWEzOWMxZjU=NTFiZTBiMTk2OWJlNDk5OWM1YmEwTzY=ODciO3M6NDE6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1sb2NhbGUtc3dpdGNoZXIucGhwIjtzOjM3OiJlY2EwMmM5NjNkMzA=ODFmYzExNWMzMTM1YWIwYzE4Mk81MTM5IjtzOjMyOiIvd3AtaW5jbHVkZXMvY2xhc3Mtd3AtbG9jYWxlLnBocCI7czozODoiZDg2YmFiNjhkNGQ3Nzg3MWZmM2ZkYzNiOGE2NTBmNDJPMTQ3MzkiO3M6NDE6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1tYXRjaGVzbWFwcmVnZXgucGhwIjtzOjM3OiI1OTQzZDVhNGYyM2M2MmVkZTkzOTY2ZDQ4ZTY5NDY2NU8xOTEzIjtzOjM2OiIvd3AtaW5jbHVkZXMvY2xhc3Mtd3AtbWV=YS1xdWVyeS5waHAiO3M6Mzg6IjFlODQwNGU5Y2UzNmFjMjE5N2RhYWRlZTdkYzQxODcwTzIyNjk1IjtzOjQ1OiIvd3AtaW5jbHVkZXMvY2xhc3Mtd3AtbWV=YWRhdGEtbGF6eWxvYWRlci5waHAiO3M6Mzc6ImI3Y2JmOTkxMWQ=NjkwYTEyYzliMzFmN2NjZWY4MWE1TzU=OTIiO3M6Mzk6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1uZXR3b3JrLXF1ZXJ5LnBocCI7czozODoiN2NkYzc4NDg5M2RhM2ZlOTIzOGIzODczNTI5OTdhZWVPMTY5OTgiO3M6MzM6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1uZXR3b3JrLnBocCI7czozODoiY2MzZWQxZDJlMmM=N2ZiOWM=ZWZhODQ3NjhjMmRhNzVPMTA3MDMiO3M6NDM6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1vZW1iZWQtY29udHJvbGxlci5waHAiO3M6Mzc6IjM5M2U5ZWMwZWQ=MDRmMzgxOTQzYzJmMjZkNzZlMzQ1TzIwODciO3M6MzU6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1wb3N=LXR5cGUucGhwIjtzOjM4OiIzYzgzYzc3ODc=Y2E4YmE2Yzc2ZjVmZjk=M2I5ZDVjNE8xODIwMSI7czozMDoiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLXBvc3QucGhwIjtzOjM3OiIyNzczNzY3N2U2YzRmN2I2ZTNiZmMxMzI2NGVkMzUzZk81ODQ4IjtzOjMxOiIvd3AtaW5jbHVkZXMvY2xhc3Mtd3AtcXVlcnkucGhwIjtzOjM5OiJjNmZkYWNjMjUzYmEzYzZhZWVjMjZjNzgwYWY3MWFkOE8xMjIzNjgiO3M6MzM6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1yZXdyaXRlLnBocCI7czozODoiNzBhZjU2ZjI4MDA=ZWQ2MmYzMzMzYjQ3NmM=MjQwM2FPNjAxMjUiO3M6MzA6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1yb2xlLnBocCI7czozNzoiNWU2ZDY5MDIwYmQxMmFlYjg3NGZmNjRlNzRiMjc5MGNPMjcyOCI7czozMToiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLXJvbGVzLnBocCI7czozNzoiNTFlMTFkOTliMTRhM2I4NWMyZGIxZWU4NWU1NGJlNzVPNjU3NCI7czo=MDoiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLXNlc3Npb24tdG9rZW5zLnBocCI7czozNzoiNjY4NDQyYzhiNTgzMzNmM2E5NDA3ODNiY2Y4OGMwMWZPNzUxMSI7czo=MDoiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLXNpbXBsZXBpZS1maWxlLnBocCI7czozNzoiYzdlYTY4N2Q3Njk4MDVjMDRmYzY4YmYyMzc2YjhhNWZPMjI5MSI7czo=OToiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLXNpbXBsZXBpZS1zYW5pdGl6ZS1rc2VzLnBocCI7czozNzoiNjM1NTFjNWU1YTgwYjY5NDVkNjE=YzFiYzQ5OTQ5YThPMTc5MyI7czozNjoiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLXNpdGUtcXVlcnkucGhwIjtzOjM4OiI3NDgwNWVkNzUwMjY=Njk=ZDA1ZjQ3ZTdlMzE1OWRlZE8yMTk4NyI7czozMDoiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLXNpdGUucGhwIjtzOjM3OiJkYmY1YTc2ZDAyMmRkY2RhMDA=NDUyYmYyNDE5ZGE2Zk83NTcyIjtzOjM1OiIvd3AtaW5jbHVkZXMvY2xhc3Mtd3AtdGF4LXF1ZXJ5LnBocCI7czozODoiZGE=MmUwYWQxM2UxNTdjNTY1ZTAyMzI4MzcwNWEzMzlPMTk2NzciO3M6MzQ6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1=YXhvbm9teS5waHAiO3M6Mzc6IjlmMmZmOWE5ZmUyNjdkZjFmZDJlYTQ4MjFiMzA4NTJkTzk3MDciO3M6MzY6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1=ZXJtLXF1ZXJ5LnBocCI7czozODoiNjkwNTIwYTFjZDcyYTY1ZDI4MTM1Y2I=M2RhODNjNjVPMzI3NDQiO3M6MzA6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1=ZXJtLnBocCI7czozNzoiNWJhNzBiYWRkMDEyN2MxNGRmY2RlZWQ2NzM5NmFkNThPNTQxNiI7czo1MToiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLXRleHQtZGlmZi1yZW5kZXJlci1pbmxpbmUucGhwIjtzOjM2OiI5OTQ=ODZhOTkyNTViNWIxMTBkOTU1MWJiZjc2M2ZjN=83MTIiO3M6NTA6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC1=ZXh=LWRpZmYtcmVuZGVyZXItdGFibGUucGhwIjtzOjM4OiIzNWY3ZDAzMzk5MjdhNzBiNzA2NDc5YWI1OThmMGFiOU8xNDA2NiI7czozMToiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLXRoZW1lLnBocCI7czozODoiMTIwMTI=Mjc4NjJiNjVkOTQxODUwNTBjZTlkMWM2ZWFPNDczMjMiO3M6NTA6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC11c2VyLW1ldGEtc2Vzc2lvbi1=b2tlbnMucGhwIjtzOjM3OiJhYWY5OTZlNGQ3ODZjODAyOWZhYzNmMTlhZGRlMTg=OU8zMDY3IjtzOjM2OiIvd3AtaW5jbHVkZXMvY2xhc3Mtd3AtdXNlci1xdWVyeS5waHAiO3M6Mzg6ImE4YWNmMmM4OWVkYjliYTVkNmViOTEyYjdjNGI=MTFjTzI5ODY4IjtzOjMwOiIvd3AtaW5jbHVkZXMvY2xhc3Mtd3AtdXNlci5waHAiO3M6Mzg6ImFhNWNmZGE4NzY4MzYzYzI4YWUyYjcxZWIyMzc3NWMyTzE5NjE=IjtzOjMyOiIvd3AtaW5jbHVkZXMvY2xhc3Mtd3Atd2Fsa2VyLnBocCI7czozODoiM2E1NzczOGZjNzY4MTg2ZjhjZGUzN2UxMmRiZWNjNjFPMTIzNjgiO3M6NDA6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC13aWRnZXQtZmFjdG9yeS5waHAiO3M6Mzc6ImYyYTY3NWJiN2I=ZGZjZDJhNDgzMzM1YjAzZDk4OWRlTzM5MDAiO3M6MzI6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC13aWRnZXQucGhwIjtzOjM4OiJhYjBiNzY1YTM5YWY2NDRmNDFkN2M3NzBkOGM4MzVmY=8xODE4OSI7czozOToiL3dwLWluY2x1ZGVzL2NsYXNzLXdwLXhtbHJwYy1zZXJ2ZXIucGhwIjtzOjM5OiJiM2IzZDgwNWU=NGNjMDE5ZmUzOWNjODA=YWFjYTk1Zk8xOTkzMTIiO3M6MjU6Ii93cC1pbmNsdWRlcy9jbGFzcy13cC5waHAiO3M6Mzg6IjFhNGZmYTMzMWE5YjhiNjc4NDkwMjE3YzlmNTM4M2RjTzI=MTM2IjtzOjM4OiIvd3AtaW5jbHVkZXMvY2xhc3Mud3AtZGVwZW5kZW5jaWVzLnBocCI7czozODoiNTg1Nzc2MWJkZWRhOWZjZmExYmJkYTkzNGE3YWZiYmJPMTE1NDciO3M6MzM6Ii93cC1pbmNsdWRlcy9jbGFzcy53cC1zY3JpcHRzLnBocCI7czozODoiOWFlM2Y2MzRkMWVmYjJmOTU4Mjg=OTEyYmM3YzViOTdPMTQ2ODEiO3M6MzI6Ii93cC1pbmNsdWRlcy9jbGFzcy53cC1zdHlsZXMucGhwIjtzOjM4OiI4MjU1ZGUzYTMwMGFmMTUyYzc4NDY4NjExZGJmMzYwNE8xMDE3NSI7czozMzoiL3dwLWluY2x1ZGVzL2NvbW1lbnQtdGVtcGxhdGUucGhwIjtzOjM4OiJlM2U5ZjA3MmE1NzQ=NmVlOGEzZWI=Y2ViNTk4NmQ2Mk84NzIzNCI7czoyNDoiL3dwLWluY2x1ZGVzL2NvbW1lbnQucGhwIjtzOjM5OiJhYTE5NWZiZDQ3YTI=YjZiZTg=ZWQ=MGI4MmRjZjU2M=8xMDIwMDIiO3M6MjM6Ii93cC1pbmNsdWRlcy9jb21wYXQucGhwIjtzOjM4OiJkODg4MTE1ZTEwMjQwNzcwYjk1ZjZiZTFhMzQ1OGIwMU8xNzE5NSI7czoyMToiL3dwLWluY2x1ZGVzL2Nyb24ucGhwIjtzOjM4OiI4NjQ4YTY=YzMxZDNlMmQ2NzI=MjI=NzcwZjYyOGU1Nk8xNTk=MSI7czozNDoiL3dwLWluY2x1ZGVzL2Nzcy9hZG1pbi1iYXItcnRsLmNzcyI7czozODoiNTBkY2I3NjI2NDdhNDkyZTQ3NjllYTA5NDdiNTAyNDhPMjU2NTkiO3M6Mzg6Ii93cC1pbmNsdWRlcy9jc3MvYWRtaW4tYmFyLXJ=bC5taW4uY3NzIjtzOjM4OiIxZmRmOWZlYWQ3NTdjZGE=NmY1M2YzYjc5YjU1ZmU=N=8yMDU5MSI7czozMDoiL3dwLWluY2x1ZGVzL2Nzcy9hZG1pbi1iYXIuY3NzIjtzOjM4OiJhMmMwNWFlYjFjMTFmMDZhOGIzYzFiYzg4ODg3MTRmOU8yNTY1MyI7czozNDoiL3dwLWluY2x1ZGVzL2Nzcy9hZG1pbi1iYXIubWluLmNzcyI7czozODoiMTgxYTBkZTRmMWM=MjUyYWViYjQ3ZjIyMDRmMGMxMTlPMjA1ODAiO3M6MzI6Ii93cC1pbmNsdWRlcy9jc3MvYnV=dG9ucy1ydGwuY3NzIjtzOjM3OiIxOGNhYzYwZDVkMzFlMzdjMzA3MDgxNzUwNGM2MmFmM=85NzA4IjtzOjM2OiIvd3AtaW5jbHVkZXMvY3NzL2J1dHRvbnMtcnRsLm1pbi5jc3MiO3M6Mzc6IjA=MjAzZDIxYmNjMjBmM2MzMDkxNDZlMjJkYjkyMzMyTzYzNjAiO3M6Mjg6Ii93cC1pbmNsdWRlcy9jc3MvYnV=dG9ucy5jc3MiO3M6Mzc6IjVlNGIyZjFkNDIzYzczZTg2Y2M4NzA1NDZhMzg=M2EzTzk3MDkiO3M6MzI6Ii93cC1pbmNsdWRlcy9jc3MvYnV=dG9ucy5taW4uY3NzIjtzOjM3OiJmYTAzNTE2NjYzYjEwZmI5NjU=YWY=ZTY4MGNjYzQyYk82MzYxIjtzOjQyOiIvd3AtaW5jbHVkZXMvY3NzL2N1c3RvbWl6ZS1wcmV2aWV3LXJ=bC5jc3MiO3M6Mzc6IjUxNDk1MmI4MWM2ZGJlZjE5YjYyYjA=MGU3NjQ4NGY5TzY=OTciO3M6NDY6Ii93cC1pbmNsdWRlcy9jc3MvY3VzdG9taXplLXByZXZpZXctcnRsLm1pbi5jc3MiO3M6Mzc6ImNjY2I5MWE3OWJkMWExYjE=YmRhZDc2OWQzYjA=ZmYyTzUxODgiO3M6Mzg6Ii93cC1pbmNsdWRlcy9jc3MvY3VzdG9taXplLXByZXZpZXcuY3NzIjtzOjM3OiJhNWEwNTJjODg2OWI5ZjMwMjQwNWIwNjliMWFhMDYxM=82NDkyIjtzOjQyOiIvd3AtaW5jbHVkZXMvY3NzL2N1c3RvbWl6ZS1wcmV2aWV3Lm1pbi5jc3MiO3M6Mzc6IjY5YmZjODhlM2YzZDQ2ZjExNmRhODE4NTg4ZTFjOTU4TzUxODMiO3M6MzA6Ii93cC1pbmNsdWRlcy9jc3MvZGFzaGljb25zLmNzcyI7czozODoiY2JkNzgzMDNmMGFiOTliY2Y=NDcwNTc1YjBmOGE3ZWFPNDg4NTUiO3M6MzQ6Ii93cC1pbmNsdWRlcy9jc3MvZGFzaGljb25zLm1pbi5jc3MiO3M6Mzg6ImNmM2MwZThmMjZmZTIwMjVhMGYyMjEzOGZmZTMwZDUzTzQ2MzY=IjtzOjMxOiIvd3AtaW5jbHVkZXMvY3NzL2VkaXRvci1ydGwuY3NzIjtzOjM4OiI2NjkyMTExNGI4M2EyZTczN2U2OWYyODQ3YjRjOWNmM=8zNDIxMyI7czozNToiL3dwLWluY2x1ZGVzL2Nzcy9lZGl=b3ItcnRsLm1pbi5jc3MiO3M6Mzg6IjlmZTNlNmJhN2ViODQ5ZjgzZjk5ZDRjMTU3YTkzNTFmTzI4MTE3IjtzOjI3OiIvd3AtaW5jbHVkZXMvY3NzL2VkaXRvci5jc3MiO3M6Mzg6ImU5N2I=MzlkOWYwYzYzOGU4OGQ4YTRjYzIxODIzMDI1TzM=MjA4IjtzOjMxOiIvd3AtaW5jbHVkZXMvY3NzL2VkaXRvci5taW4uY3NzIjtzOjM4OiJkNWIwM2Y1Y2ExMzYwNTM3OWI2YzU2NWViZmE1NTU3ME8yODExMSI7czo=MToiL3dwLWluY2x1ZGVzL2Nzcy9qcXVlcnktdWktZGlhbG9nLXJ=bC5jc3MiO3M6Mzc6IjEwOTM5ZmY2YTM2MjlmYmE4MGUzMGUyZTdjNTI2OTAxTzYyMzAiO3M6NDU6Ii93cC1pbmNsdWRlcy9jc3MvanF1ZXJ5LXVpLWRpYWxvZy1ydGwubWluLmNzcyI7czozNzoiZGUxYzJlODQxZDUyOTkxY2M3MzhmNGIwMjlhNGYyNDlPNDc5OSI7czozNzoiL3dwLWluY2x1ZGVzL2Nzcy9qcXVlcnktdWktZGlhbG9nLmNzcyI7czozNzoiYTAzNDdiYTY=NzZhYzZiNjQ2ZDE=NTY5Nzk3MGU4MWNPNjIyNiI7czo=MToiL3dwLWluY2x1ZGVzL2Nzcy9qcXVlcnktdWktZGlhbG9nLm1pbi5jc3MiO3M6Mzc6ImRhZTE4ODQ1Y2ZjM2MyMTFjNWM2ZGU5MjQwMWIyYWQ1TzQ3OTYiO3M6MzY6Ii93cC1pbmNsdWRlcy9jc3MvbWVkaWEtdmlld3MtcnRsLmNzcyI7czozODoiMGY1YjRkYzY=OWY1ZDIyMTgwNjdhOGMzN2U3YzFiYWJPNTAwNjkiO3M6NDA6Ii93cC1pbmNsdWRlcy9jc3MvbWVkaWEtdmlld3MtcnRsLm1pbi5jc3MiO3M6Mzg6IjQ3MzE=MzQ2NzA5MzIyOGQ4MzRkZjY2MTMwOTA=NTU4TzQxODI=IjtzOjMyOiIvd3AtaW5jbHVkZXMvY3NzL21lZGlhLXZpZXdzLmNzcyI7czozODoiMjUxZGRkNzA1NDMzYzIwN2RhYzRkYzkwYjAxYWJiZTNPNTAwNzEiO3M6MzY6Ii93cC1pbmNsdWRlcy9jc3MvbWVkaWEtdmlld3MubWluLmNzcyI7czozODoiMmExYWIzODYyOWQ2ZjEwMTc4YTBkMjAwZTdlZGFhZDFPNDE4MjYiO3M6Mzg6Ii93cC1pbmNsdWRlcy9jc3Mvd3AtYXV=aC1jaGVjay1ydGwuY3NzIjtzOjM3OiJjY2VlZmE5NjljYmZmNGJjYWNmYTNhMzlmZjQ4MjE=Y=8yNTk=IjtzOjQyOiIvd3AtaW5jbHVkZXMvY3NzL3dwLWF1dGgtY2hlY2stcnRsLm1pbi5jc3MiO3M6Mzc6IjViYmU=YzJlY2I1NDE5NTJjYTQwODY4M2U3OWZiYjE=TzE5NzYiO3M6MzQ6Ii93cC1pbmNsdWRlcy9jc3Mvd3AtYXV=aC1jaGVjay5jc3MiO3M6Mzc6Ijg1NzUyY2E4Yzg5OWFlZTMyOTdlODc=NzlmZDUxOTk=TzI1OTIiO3M6Mzg6Ii93cC1pbmNsdWRlcy9jc3Mvd3AtYXV=aC1jaGVjay5taW4uY3NzIjtzOjM3OiJkMWY5NGY5YTkzZjgzYjdkYzRkOTI=ZjA=ODQyZDI5NE8xOTc=IjtzOjQxOiIvd3AtaW5jbHVkZXMvY3NzL3dwLWVtYmVkLXRlbXBsYXRlLWllLmNzcyI7czozNzoiZWViNzI5MzY5ZWYzMDlkODllZDBiYzcxMjBhYWNhZGZPMTQ3NyI7czo=NToiL3dwLWluY2x1ZGVzL2Nzcy93cC1lbWJlZC1=ZW1wbGF=ZS1pZS5taW4uY3NzIjtzOjM3OiIxYWVjM2NhYzc3NTZlOWI=MDViY2JmMGFkMzljNzc3Mk8xNDM4IjtzOjM4OiIvd3AtaW5jbHVkZXMvY3NzL3dwLWVtYmVkLXRlbXBsYXRlLmNzcyI7czozNzoiYzAxOTUyODA=Y2Q3MTdjOTZhZmUxMGU5Njg5YmJkMzJPODMzMiI7czo=MjoiL3dwLWluY2x1ZGVzL2Nzcy93cC1lbWJlZC1=ZW1wbGF=ZS5taW4uY3NzIjtzOjM3OiI=MzMzODZkZTRhNjRiOWNhNmQ3NGUxNDc1NmJkYWZmNk83MjAwIjtzOjM1OiIvd3AtaW5jbHVkZXMvY3NzL3dwLXBvaW5=ZXItcnRsLmNzcyI7czozNzoiOGJiMGJlZjkwMzRjNTE=ZjExNGUwNWZmOWZjNjM4NDBPMzg3OCI7czozOToiL3dwLWluY2x1ZGVzL2Nzcy93cC1wb2ludGVyLXJ=bC5taW4uY3NzIjtzOjM3OiI=NTZlMTBmMjU2MWU2NWYyYjc2YzE5ODViNjU3ZWJkYk8zMDYzIjtzOjMxOiIvd3AtaW5jbHVkZXMvY3NzL3dwLXBvaW5=ZXIuY3NzIjtzOjM3OiI4MmVlYWU=YzY4Mjg4ZDI4Yzg4MDllZjlmYjFiYzNlYU8zODczIjtzOjM1OiIvd3AtaW5jbHVkZXMvY3NzL3dwLXBvaW5=ZXIubWluLmNzcyI7czozNzoiN2U5ZmQ3ODI2MDJlYWQwZGRkOTFlY2JlNjAwYmIwNzhPMzA1OCI7czo3MDoiL3dwLWluY2x1ZGVzL2N1c3RvbWl6ZS9jbGFzcy13cC1jdXN=b21pemUtYmFja2dyb3VuZC1pbWFnZS1jb25=cm9sLnBocCI7czozNzoiNzAwZmNmODdmYTE1MGYwNjFmOTA5ZGQxNzQ3Y2NlMzNPMTE3OCI7czo3MDoiL3dwLWluY2x1ZGVzL2N1c3RvbWl6ZS9jbGFzcy13cC1jdXN=b21pemUtYmFja2dyb3VuZC1pbWFnZS1zZXR=aW5nLnBocCI7czozNjoiMjlkOTQwODc3NDk=ZmU2YTEyMzIzM2I=MTNlMzlkNTdPNTA4IjtzOjczOiIvd3AtaW5jbHVkZXMvY3VzdG9taXplL2NsYXNzLXdwLWN1c3RvbWl6ZS1iYWNrZ3JvdW5kLXBvc2l=aW9uLWNvbnRyb2wucGhwIjtzOjM3OiIwYTVkOTMzMzNjNGMxMjI4YzliMGE4NzBlOGFhNDhmZk8yODY=IjtzOjU5OiIvd3AtaW5jbHVkZXMvY3VzdG9taXplL2NsYXNzLXdwLWN1c3RvbWl6ZS1jb2xvci1jb25=cm9sLnBocCI7czozNzoiN2VmNzAwMDAzOTEwZmQxYzI2OTU2Mzk3ODI3NTkzOTBPMjgyMiI7czo2NzoiL3dwLWluY2x1ZGVzL2N1c3RvbWl6ZS9jbGFzcy13cC1jdXN=b21pemUtY3JvcHBlZC1pbWFnZS1jb25=cm9sLnBocCI7czozNzoiMTg4ZTViNTcyNzIyZjE2NmVjZjY=OWRlOTlhOTlmNzRPMTU5MyI7czo2NDoiL3dwLWluY2x1ZGVzL2N1c3RvbWl6ZS9jbGFzcy13cC1jdXN=b21pemUtY3VzdG9tLWNzcy1zZXR=aW5nLnBocCI7czozODoiNDZmYWFkMDMxMjk1ZWNmYjAwNWFjY2VhYTY5NjY1MTZPMTA1NTgiO3M6NjA6Ii93cC1pbmNsdWRlcy9jdXN=b21pemUvY2xhc3Mtd3AtY3VzdG9taXplLWZpbHRlci1zZXR=aW5nLnBocCI7czozNjoiYzhjMjYwNTY3NmZkM2U=MWIzYTIyMGUyMjRiMTFmZjdPNjA3IjtzOjY2OiIvd3AtaW5jbHVkZXMvY3VzdG9taXplL2NsYXNzLXdwLWN1c3RvbWl6ZS1oZWFkZXItaW1hZ2UtY29udHJvbC5waHAiO3M6Mzc6IjJiZTMyZGIxYzVmZTY4ZDVmZGQ=ZDBiM2Q3YjlkMGY5TzcyMDUiO3M6NjY6Ii93cC1pbmNsdWRlcy9jdXN=b21pemUvY2xhc3Mtd3AtY3VzdG9taXplLWhlYWRlci1pbWFnZS1zZXR=aW5nLnBocCI7czozNzoiMzNhN2E2Y2YwYzcwZmNhYzE4MDI=N2M5NzM5MjMwYTRPMTU5MCI7czo1OToiL3dwLWluY2x1ZGVzL2N1c3RvbWl6ZS9jbGFzcy13cC1jdXN=b21pemUtaW1hZ2UtY29udHJvbC5waHAiO3M6Mzc6IjU1NjliNDE=NjgwZTJkYzljMDIwMWI4NGY2ZWU=YmYzTzE3MzciO3M6NTk6Ii93cC1pbmNsdWRlcy9jdXN=b21pemUvY2xhc3Mtd3AtY3VzdG9taXplLW1lZGlhLWNvbnRyb2wucGhwIjtzOjM3OiI3MmQ5NzQ5ZDZhMmI=OTcxMzhlZTg2MzZlMWYwOTA5ZE83NTAzIjtzOjcxOiIvd3AtaW5jbHVkZXMvY3VzdG9taXplL2NsYXNzLXdwLWN1c3RvbWl6ZS1uYXYtbWVudS1hdXRvLWFkZC1jb25=cm9sLnBocCI7czozNzoiMGFiM2I3OTBmNjVhNmRhYzY=ZDUzNWFlMzk4MTM5MzBPMTAwNSI7czo2MjoiL3dwLWluY2x1ZGVzL2N1c3RvbWl6ZS9jbGFzcy13cC1jdXN=b21pemUtbmF2LW1lbnUtY29udHJvbC5waHAiO3M6Mzc6IjE5YzRjNThlOTFjNmNlYmZmMDZjOWIzY2QxMzZjMjQ4TzI5MzkiO3M6Njc6Ii93cC1pbmNsdWRlcy9jdXN=b21pemUvY2xhc3Mtd3AtY3VzdG9taXplLW5hdi1tZW51LWl=ZW=tY29udHJvbC5waHAiO3M6Mzc6ImZiNmVkNTdmNjRjYTUwNTc1OWZmNWRkMDE5MWFkMzMyTzY1NDUiO3M6Njc6Ii93cC1pbmNsdWRlcy9jdXN=b21pemUvY2xhc3Mtd3AtY3VzdG9taXplLW5hdi1tZW51LWl=ZW=tc2V=dGluZy5waHAiO3M6Mzg6ImE3NGI2OTQ3NmRhZDUwMGM2YTgzNzdhMjY=MWEzZjhhTzI2OTQ=IjtzOjcxOiIvd3AtaW5jbHVkZXMvY3VzdG9taXplL2NsYXNzLXdwLWN1c3RvbWl6ZS1uYXYtbWVudS1sb2NhdGlvbi1jb25=cm9sLnBocCI7czozNzoiMjE5MzdhZTdhNmQ=NGU=ODZmM2IxNjI1YjFhOWViM2ZPMTg3OSI7czo2NzoiL3dwLWluY2x1ZGVzL2N1c3RvbWl6ZS9jbGFzcy13cC1jdXN=b21pemUtbmF2LW1lbnUtbmFtZS1jb25=cm9sLnBocCI7czozNjoiN2JlODYwZDk5NmQzNWY5MzM3NTRhODk=YzhhNTA4MzNPOTkzIjtzOjYyOiIvd3AtaW5jbHVkZXMvY3VzdG9taXplL2NsYXNzLXdwLWN1c3RvbWl6ZS1uYXYtbWVudS1zZWN=aW9uLnBocCI7czozNjoiODA1Y2MzOTM=MjcwMGQ2ODcxYzcyNzU=NjQ2ZmI3NDBPNzQ3IjtzOjYyOiIvd3AtaW5jbHVkZXMvY3VzdG9taXplL2NsYXNzLXdwLWN1c3RvbWl6ZS1uYXYtbWVudS1zZXR=aW5nLnBocCI7czozODoiNzhmZWJmNjhhMTBlM2ZjZmU5ZDdhNTNmNTEyNjE3OGZPMTkxNDUiO3M6NjE6Ii93cC1pbmNsdWRlcy9jdXN=b21pemUvY2xhc3Mtd3AtY3VzdG9taXplLW5hdi1tZW51cy1wYW5lbC5waHAiO3M6Mzc6IjExYmM5YTc1ZWMzYTUxMjY5MzgyODQ5ZmMyOTI1Mzg=TzI5MDQiO3M6NjI6Ii93cC1pbmNsdWRlcy9jdXN=b21pemUvY2xhc3Mtd3AtY3VzdG9taXplLW5ldy1tZW51LWNvbnRyb2wucGhwIjtzOjM2OiI1YjhiYzYyMTgyZjViNjQxNWJhYzBkMWQ1YTRjYjRjZE83MDgiO3M6NjI6Ii93cC1pbmNsdWRlcy9jdXN=b21pemUvY2xhc3Mtd3AtY3VzdG9taXplLW5ldy1tZW51LXNlY3Rpb24ucGhwIjtzOjM2OiJlOGQ=ZmM2NDQyM2I3Zjk1YzdhZTBhNGE4N2VkODg2ZE85NjUiO3M6NTM6Ii93cC1pbmNsdWRlcy9jdXN=b21pemUvY2xhc3Mtd3AtY3VzdG9taXplLXBhcnRpYWwucGhwIjtzOjM3OiIyNTg3NzdhMjU5OTBiOTI=MGNiYTkxMTAwYWUxZWI3NU85MTgwIjtzOjYzOiIvd3AtaW5jbHVkZXMvY3VzdG9taXplL2NsYXNzLXdwLWN1c3RvbWl6ZS1zZWxlY3RpdmUtcmVmcmVzaC5waHAiO3M6Mzg6IjkwYjlhZmMzM2I1NzZjODJjODA3N2RiZjJhMGQxZWQyTzEzNTIwIjtzOjYxOiIvd3AtaW5jbHVkZXMvY3VzdG9taXplL2NsYXNzLXdwLWN1c3RvbWl6ZS1zaWRlYmFyLXNlY3Rpb24ucGhwIjtzOjM3OiIyMTU=MmI2MzYxY2ViMjQ2YWZiOGE=YjFlY2M=ZDJlYk8xMTAzIjtzOjYzOiIvd3AtaW5jbHVkZXMvY3VzdG9taXplL2NsYXNzLXdwLWN1c3RvbWl6ZS1zaXRlLWljb24tY29udHJvbC5waHAiO3M6Mzc6ImRmODUwYjM=ZDY2NzQxZmZkNDVkYjljZTQ3YzAzY2UxTzMyNzgiO3M6NTk6Ii93cC1pbmNsdWRlcy9jdXN=b21pemUvY2xhc3Mtd3AtY3VzdG9taXplLXRoZW1lLWNvbnRyb2wucGhwIjtzOjM3OiI5MjI1ZmMxNDlmOWQ3NGE5YjI1ZmM5MGViMmMyZjJjME8zMDU1IjtzOjYwOiIvd3AtaW5jbHVkZXMvY3VzdG9taXplL2NsYXNzLXdwLWN1c3RvbWl6ZS1=aGVtZXMtc2VjdGlvbi5waHAiO3M6Mzc6IjJlZWYxNDFjYThhNjljZmZjOGQ1MWVlZTMxMjI=MTU2TzI4MDgiO3M6NjA6Ii93cC1pbmNsdWRlcy9jdXN=b21pemUvY2xhc3Mtd3AtY3VzdG9taXplLXVwbG9hZC1jb25=cm9sLnBocCI7czozNjoiNGFlYmE3ZDhjMzQ2ZjcxZTc5YzViZWE5NzI=MDkzN2JPOTc3IjtzOjY1OiIvd3AtaW5jbHVkZXMvY3VzdG9taXplL2NsYXNzLXdwLXdpZGdldC1hcmVhLWN1c3RvbWl6ZS1jb25=cm9sLnBocCI7czozNzoiZDk=MWZmOGVkMmNiMTAxMWUxMDJmNGY3ZGY=MzI5ZmZPMTgxMSI7czo2NToiL3dwLWluY2x1ZGVzL2N1c3RvbWl6ZS9jbGFzcy13cC13aWRnZXQtZm9ybS1jdXN=b21pemUtY29udHJvbC5waHAiO3M6Mzc6Ijg4N2ZkMDFiZDRlYmEyZDBlY2M=MTcwZDAwN2Q4OGE5TzE5NzMiO3M6MjE6Ii93cC1pbmNsdWRlcy9kYXRlLnBocCI7czozODoiMTIyMDQ4ODVlYzA=MDZjOWRlZGMzMzNkNzMxYTcyZTJPMzUzMzMiO3M6MzQ6Ii93cC1pbmNsdWRlcy9kZWZhdWx=LWNvbnN=YW5=cy5waHAiO3M6Mzc6IjRiZmYwYjk1NmYxMjY4ZTI5YmIxM2QzNzVmZGFmMDUzTzk=ODkiO3M6MzI6Ii93cC1pbmNsdWRlcy9kZWZhdWx=LWZpbHRlcnMucGhwIjtzOjM4OiI=NTQ5NzM3NTVkMWVmOTk4MjIzNmMwZTAwNDg4YjVmYU8yNTIyMCI7czozMjoiL3dwLWluY2x1ZGVzL2RlZmF1bHQtd2lkZ2V=cy5waHAiO3M6Mzc6IjEyYTk=ZjY5NTRiODMwZmMyYTAwZGE2OGZhMjk2N2JiTzE1MDQiO3M6Mjc6Ii93cC1pbmNsdWRlcy9kZXByZWNhdGVkLnBocCI7czozOToiZWE=YzE4YjAwNzJhNjY4ZDQ=ODk=OTU3NGRiMWI5NjVPMTExNDkzIjtzOjMxOiIvd3AtaW5jbHVkZXMvZW1iZWQtdGVtcGxhdGUucGhwIjtzOjM2OiI4ODBjMGYzZWJkZWY=NTU2NGE3YjNiMTUzNmZmMjEyYU8zNDQiO3M6MjI6Ii93cC1pbmNsdWRlcy9lbWJlZC5waHAiO3M6Mzg6ImFiYzJlNjcwY2Q=ZmY2MTVhMzkxYTFkNTA2ZTRiYmFiTzQzNjM4IjtzOjM1OiIvd3AtaW5jbHVkZXMvZmVlZC1hdG9tLWNvbW1lbnRzLnBocCI7czozNzoiMmVmYTkwZjU3MzA4ZWJjMGE=ZjZmOTUwNzUxNzkzZGNPNTM1MCI7czoyNjoiL3dwLWluY2x1ZGVzL2ZlZWQtYXRvbS5waHAiO3M6Mzc6ImRhYzEwMTAwMTRlMjJjN2QzNWIzN2RjMDQzN2VmY2UzTzMwODMiO3M6MjU6Ii93cC1pbmNsdWRlcy9mZWVkLXJkZi5waHAiO3M6Mzc6IjdjMTU5NzY=NjRmZTk4OWE2MTM2YmVhZWRkMjdkZTlhTzI2NzAiO3M6MjU6Ii93cC1pbmNsdWRlcy9mZWVkLXJzcy5waHAiO3M6Mzc6IjRkYzczM2Q3M2ZkOWViYzgxMGEwNjdjMTJlMGU=MjBkTzEyNDYiO3M6MzU6Ii93cC1pbmNsdWRlcy9mZWVkLXJzczItY29tbWVudHMucGhwIjtzOjM3OiJjMWZiNzdhYjUyYzA5ZWQ1ZWFkMzJmYzU4MjRkMTdkOU8=MDU3IjtzOjI2OiIvd3AtaW5jbHVkZXMvZmVlZC1yc3MyLnBocCI7czozNzoiYTQwOTY3MWU1NGNiN2Y5YzMwMGI3Y2U4NmQ3MWFjZTdPMzgxMSI7czoyMToiL3dwLWluY2x1ZGVzL2ZlZWQucGhwIjtzOjM4OiI4Yjk1MDdmY2Y5ODVmMWE4MjljYjZhOTk1OWNjODAxN=8xOTUyNSI7czozMjoiL3dwLWluY2x1ZGVzL2ZvbnRzL2Rhc2hpY29ucy5lb3QiO3M6Mzg6IjMwZTQxMGM3MTVjNjIxNWZhN2ZhYTFjOTc5YjY=ODBjTzIyNDQ5IjtzOjMyOiIvd3AtaW5jbHVkZXMvZm9udHMvZGFzaGljb25zLnN2ZyI7czozODoiNzgwZTY5NjhjZDBlMzc4YjFmNzcyM2Q4OWZhNTlhYjVPOTU5MTYiO3M6MzI6Ii93cC1pbmNsdWRlcy9mb25=cy9kYXNoaWNvbnMudHRmIjtzOjM4OiI4ZmVhMWZjZTQ2YmFmZTQ2OWJhMmYxMDFmZGM1ODNlMk8=MTcyOCI7czozMzoiL3dwLWluY2x1ZGVzL2ZvbnRzL2Rhc2hpY29ucy53b2ZmIjtzOjM4OiIwYzFjMWFkNDFjMDI1ZjcyNTkyYmNhODIwZTA3M2JlY=8yNjEyNCI7czoyNzoiL3dwLWluY2x1ZGVzL2Zvcm1hdHRpbmcucGhwIjtzOjM5OiI2Yjc3ZjVkZjZiNGRlNWMyMzVjY2IzMjJhZjZmNjFmZU8xODk3MDMiO3M6MjY6Ii93cC1pbmNsdWRlcy9mdW5jdGlvbnMucGhwIjtzOjM5OiJiNzg=NDU4MDBkMjhmNDlkNzE1YzVlMzRiNTdiMTA1NU8xNzQ4MjUiO3M6Mzc6Ii93cC1pbmNsdWRlcy9mdW5jdGlvbnMud3Atc2NyaXB=cy5waHAiO3M6Mzg6ImZhMGJkODg3NTgzZDg5N2M3ZGRjMGZiMzgxMjU4NTU1TzExNDgxIjtzOjM2OiIvd3AtaW5jbHVkZXMvZnVuY3Rpb25zLndwLXN=eWxlcy5waHAiO3M6Mzc6ImU2NjVlMjRhMTU5MjM4ZTI1YTgwNTcxN2RiMzJmYjk4TzgwODAiO3M6MzM6Ii93cC1pbmNsdWRlcy9nZW5lcmFsLXRlbXBsYXRlLnBocCI7czozOToiOTJhYTVhOTE3YjFhMzBiYzMxMzEyN2YyOGEyMzA=YzhPMTI=OTA4IjtzOjIxOiIvd3AtaW5jbHVkZXMvaHR=cC5waHAiO3M6Mzg6IjU3NjBhNGZhYTk=MTU3MWE5NTYxY2EyYzE2NjE3NGU2TzIyMjEwIjtzOjMxOiIvd3AtaW5jbHVkZXMvSUQzL2dldGlkMy5saWIucGhwIjtzOjM4OiJjNTJkZTc2NDcyMjJmZTRiMjRlMmVhMDQ3NTVmOTliOE8=NDg2MCI7czoyNzoiL3dwLWluY2x1ZGVzL=lEMy9nZXRpZDMucGhwIjtzOjM4OiI5N2JjZDYxODU2ZGY3YWZhNjUzZDQ5MTc3NWVmZGE1Y=82MzYyNyI7czozOToiL3dwLWluY2x1ZGVzL=lEMy9saWNlbnNlLmNvbW1lcmNpYWwudHh=IjtzOjM3OiIwYTNiNjcwODk2ZmM=YTgwNjdhZGIyYzZkOTc4NDE4ZU8xMzA3IjtzOjI4OiIvd3AtaW5jbHVkZXMvSUQzL2xpY2Vuc2UudHh=IjtzOjM3OiIzNWQ5OGFhZGY4ZjdjYzY4NTEzMzY2NTFmN2E2NmI5OE8xMzU2IjtzOjQzOiIvd3AtaW5jbHVkZXMvSUQzL21vZHVsZS5hdWRpby12aWRlby5hc2YucGhwIjtzOjM5OiIyODZiMTk5OWMxNTFiN2JhMDFjZmQ1N2MyNGUxMzRjZk8xMjcwNzciO3M6NDM6Ii93cC1pbmNsdWRlcy9JRDMvbW9kdWxlLmF1ZGlvLXZpZGVvLmZsdi5waHAiO3M6Mzg6IjZiODM=ODY5YjYyYzU3ZmVhOTE4NTFiMTQ2ZGNlM2QzTzI1NDAxIjtzOjQ4OiIvd3AtaW5jbHVkZXMvSUQzL21vZHVsZS5hdWRpby12aWRlby5tYXRyb3NrYS5waHAiO3M6Mzk6IjYzOWFhNWFlODk=YjM5NmEwMGZiNTNmYzgwNjllNzRhTzEwMzU=MSI7czo=OToiL3dwLWluY2x1ZGVzL=lEMy9tb2R1bGUuYXVkaW8tdmlkZW8ucXVpY2t=aW1lLnBocCI7czozOToiMjcyZGZkNmU=YzM5MWYyMDYxMWExMWQ5MjFlNjZlZWJPMTE4NzcxIjtzOjQ=OiIvd3AtaW5jbHVkZXMvSUQzL21vZHVsZS5hdWRpby12aWRlby5yaWZmLnBocCI7czozOToiZWU4MjU=MGYwMjY2NjIxOTdmNzAwMzQ3NGZkOTJkZTJPMTE4OTMzIjtzOjM3OiIvd3AtaW5jbHVkZXMvSUQzL21vZHVsZS5hdWRpby5hYzMucGhwIjtzOjM4OiJlODFjNDUwMGZiNGMzYjIyNGZkMmY5YTc4YmE2NjQyN=8xOTAwOSI7czozNzoiL3dwLWluY2x1ZGVzL=lEMy9tb2R1bGUuYXVkaW8uZHRzLnBocCI7czozODoiZjNlYTU2NjAwN2M5NGMwMzM3MmViNmY=NmM1ZDIwMDFPMTA=NjciO3M6Mzg6Ii93cC1pbmNsdWRlcy9JRDMvbW9kdWxlLmF1ZGlvLmZsYWMucGhwIjtzOjM4OiIwNTUwMDNlYTdjMDM4OGZkNzMxMDcxMTNkM2VkM2JjM=8xODUxNyI7czozNzoiL3dwLWluY2x1ZGVzL=lEMy9tb2R1bGUuYXVkaW8ubXAzLnBocCI7czozODoiZWI4NzI1N2IyZjA1MDdmNGFjNTU5MWQ=MjI2ZGZjODZPOTkxNzciO3M6Mzc6Ii93cC1pbmNsdWRlcy9JRDMvbW9kdWxlLmF1ZGlvLm9nZy5waHAiO3M6Mzg6IjdiZGM4MTNhN2ZhOTVmZWNlZWQ=ZjZkNGIzN2QzYzk3TzM5OTg2IjtzOjM4OiIvd3AtaW5jbHVkZXMvSUQzL21vZHVsZS5=YWcuYXBldGFnLnBocCI7czozODoiMzQ2YzhjMWI5N2NhZWNiYTU1OTJhOTE=NTJmYTM5NDlPMTgzNDQiO3M6Mzc6Ii93cC1pbmNsdWRlcy9JRDMvbW9kdWxlLnRhZy5pZDN2MS5waHAiO3M6Mzg6IjJiMzY4YmU5ZTE5MDUxZDAwY2FjMGU2NzM=MWQwNTFkTzExNTcyIjtzOjM3OiIvd3AtaW5jbHVkZXMvSUQzL21vZHVsZS5=YWcuaWQzdjIucGhwIjtzOjM5OiJmMjYzMDZhMzg1OGFkNDA3NDY3OWQ5NGYyYWVlYWQ=ZU8xNDQ1OTkiO3M6Mzk6Ii93cC1pbmNsdWRlcy9JRDMvbW9kdWxlLnRhZy5seXJpY3MzLnBocCI7czozODoiMTI1NWY5ZmIzMzgwYmE5M2RkMjIzOTgxYjIxODMyZWRPMTEyMzgiO3M6Mjc6Ii93cC1pbmNsdWRlcy9JRDMvcmVhZG1lLnR4dCI7czozODoiOTM5NmRmZTFjNjljOTM4ZWIxN2Y1NjRjNGU1YmFiMThPMjQ2NTIiO3M6NDM6Ii93cC1pbmNsdWRlcy9pbWFnZXMvYWRtaW4tYmFyLXNwcml=ZS=yeC5wbmciO3M6Mzc6ImViNTFhYzEzMTJlYjA2MGI5YmM2MzhmZWY=NmY4MGNhTzM5OTkiO3M6NDA6Ii93cC1pbmNsdWRlcy9pbWFnZXMvYWRtaW4tYmFyLXNwcml=ZS5wbmciO3M6Mzc6IjUzY2YxMWE=MWY5NzNhODA1NzBlMGVjYWM1ZDNmZTVlTzI=NjciO3M6NDU6Ii93cC1pbmNsdWRlcy9pbWFnZXMvYXJyb3ctcG9pbnRlci1ibHVlLTJ4LnBuZyI7czozNzoiMjU2ZGUyMTQxMTA1NzJkZThjNWQzNGI4MzkxMTYzY2ZPMTY2NiI7czo=MjoiL3dwLWluY2x1ZGVzL2ltYWdlcy9hcnJvdy1wb2ludGVyLWJsdWUucG5nIjtzOjM2OiI3NzlmZmM2MmUzY2U4NzJhNGNhYmIyYzM1YmJiMTRmOU83OTMiO3M6Mjk6Ii93cC1pbmNsdWRlcy9pbWFnZXMvYmxhbmsuZ2lmIjtzOjM1OiI=OGJiMmJhYWY=MzUzMTA5ZjdjMjY2NWQ5NmFhMzkwYk8=MyI7czozOToiL3dwLWluY2x1ZGVzL2ltYWdlcy9jcnlzdGFsL2FyY2hpdmUucG5nIjtzOjM3OiI5NjUzY2EwN2ZhZjA4ZTljY2M=OTMwNDEwMjBlNmVlYk8yNDU=IjtzOjM3OiIvd3AtaW5jbHVkZXMvaW1hZ2VzL2NyeXN=YWwvYXVkaW8ucG5nIjtzOjM3OiI5OTZlNTZmMThmM2FjOWNmODlmMzQ3ZDhkNDJkMjM2Yk8yMTg=IjtzOjM2OiIvd3AtaW5jbHVkZXMvaW1hZ2VzL2NyeXN=YWwvY29kZS5wbmciO3M6Mzc6IjE=NjBlZjMxYjJjZmZhZWYxY2IwMTJmNTMxYWUzOTFmTzE2MDQiO3M6Mzk6Ii93cC1pbmNsdWRlcy9pbWFnZXMvY3J5c3RhbC9kZWZhdWx=LnBuZyI7czozNjoiNDFmMjNlMjkyYTJmYmVkYzIxZWNhZTJkMDRmMjliYmFPNDUzIjtzOjQwOiIvd3AtaW5jbHVkZXMvaW1hZ2VzL2NyeXN=YWwvZG9jdW1lbnQucG5nIjtzOjM3OiI3Zjg5Mjc1ZTYzOWE3M2MwZjljNDQ=OGJmOTMzNTQ1Y=8yMDYzIjtzOjQzOiIvd3AtaW5jbHVkZXMvaW1hZ2VzL2NyeXN=YWwvaW5=ZXJhY3RpdmUucG5nIjtzOjM3OiJhZjUyY2Y2ZDYwZjJlZGJhNjA5OTM5YTcwMzA=ZTYwMU8yMjE3IjtzOjM5OiIvd3AtaW5jbHVkZXMvaW1hZ2VzL2NyeXN=YWwvbGljZW5zZS5=eHQiO3M6MzY6ImYwNWRiNTRjNjNlMzY5MTg=NzliNjY1MTkzMGRjZmU3TzE=OSI7czo=MzoiL3dwLWluY2x1ZGVzL2ltYWdlcy9jcnlzdGFsL3NwcmVhZHNoZWV=LnBuZyI7czozNzoiMzU4NjM5ZjhkMGEyMGMzMTgwNTRjYjAxYzc2ZWE=ZWFPMjQwOCI7czozNjoiL3dwLWluY2x1ZGVzL2ltYWdlcy9jcnlzdGFsL3RleHQucG5nIjtzOjM2OiI5MGNjMjBkMWIyYWFmYzIzYmU2NGZmMjUxMWUzNWJiNU82NzAiO3M6Mzc6Ii93cC1pbmNsdWRlcy9pbWFnZXMvY3J5c3RhbC92aWRlby5wbmciO3M6Mzc6Ijk=MDEwZWRiZmQ4ZTZjYTU4OWRhYTRiODNiZjUzZDBiTzEzMzkiO3M6Mzc6Ii93cC1pbmNsdWRlcy9pbWFnZXMvZG93bl9hcnJvdy=yeC5naWYiO3M6MzU6ImEwNzNiOGExZWU5YjI=ODIwMTdmMzYyOGRhNDBhODYxTzg=IjtzOjM=OiIvd3AtaW5jbHVkZXMvaW1hZ2VzL2Rvd25fYXJyb3cuZ2lmIjtzOjM1OiI2NWRjYzg1ZDNhNzVmZjU3NzZmYmUzZGYwMTIyYjdlMk81OSI7czo=NDoiL3dwLWluY2x1ZGVzL2ltYWdlcy9pY29uLXBvaW5=ZXItZmxhZy=yeC5wbmciO3M6Mzc6ImE5ZTVlMWE2MzJmMWIzYjk2MmU=YzQyNmQ1NWFjYzcyTzEzNjkiO3M6NDE6Ii93cC1pbmNsdWRlcy9pbWFnZXMvaWNvbi1wb2ludGVyLWZsYWcucG5nIjtzOjM2OiJiMGQzMmM4N2YyYWQ4YmMyNDU1ZWJmNmE2MDE3MTAyN=83ODMiO3M6Mzc6Ii93cC1pbmNsdWRlcy9pbWFnZXMvbWVkaWEvYXJjaGl2ZS5wbmciO3M6MzY6IjExMzkxNGQyZWVkZmYyNjhmYjAwZGFkM2MzYWM5MTc1TzQxNyI7czozNToiL3dwLWluY2x1ZGVzL2ltYWdlcy9tZWRpYS9hdWRpby5wbmciO3M6MzY6Ijg2NzQ2MTQzNDFmMWJlYzVmZWIyMmViN2U3NWFkZmMwTzM4MiI7czozNDoiL3dwLWluY2x1ZGVzL2ltYWdlcy9tZWRpYS9jb2RlLnBuZyI7czozNjoiMmQ2Zjk2MTMwY2FkNTVjYTkzMTBlZWQ1NTVhOTU1NWZPMjc=IjtzOjM3OiIvd3AtaW5jbHVkZXMvaW1hZ2VzL21lZGlhL2RlZmF1bHQucG5nIjtzOjM2OiIyZGI2YTllNmNkNDlkMjQyOTY2OGNlNDBlMGRlZTc2Mk8xNjgiO3M6Mzg6Ii93cC1pbmNsdWRlcy9pbWFnZXMvbWVkaWEvZG9jdW1lbnQucG5nIjtzOjM2OiI3NmU1MzQ5OTM4ZjZjZTkxNzk5MzE=MzZkZTFjNjRhM=8yMDAiO3M6NDE6Ii93cC1pbmNsdWRlcy9pbWFnZXMvbWVkaWEvaW5=ZXJhY3RpdmUucG5nIjtzOjM2OiI1MmQ3YWNjYjgyYWVmMTdmYzJjM2I=YzU4OTY4ZGM=OE8zMTkiO3M6NDE6Ii93cC1pbmNsdWRlcy9pbWFnZXMvbWVkaWEvc3ByZWFkc2hlZXQucG5nIjtzOjM2OiJmMWMwYTAzNGU=ZjExMmQ2MDA1NGZjZGVjYzg3M2ZiMk8xODgiO3M6MzQ6Ii93cC1pbmNsdWRlcy9pbWFnZXMvbWVkaWEvdGV4dC5wbmciO3M6MzY6IjdhYjk4NzczZTZlNDMwZjcxOGM4OWQ5ZjUxMTk4MDRiTzE4OCI7czozNToiL3dwLWluY2x1ZGVzL2ltYWdlcy9tZWRpYS92aWRlby5wbmciO3M6MzY6IjhkZTBlOWYxNzVlYTY4MTc5YjgxZGRkYjcxYTAxMGY3TzI4MyI7czozMDoiL3dwLWluY2x1ZGVzL2ltYWdlcy9yc3MtMngucG5nIjtzOjM3OiJjNzE3NTk2MTViYTA1MWMxZTZmNTk3ZmQ3MjZhOWQxMU8xMzA2IjtzOjI3OiIvd3AtaW5jbHVkZXMvaW1hZ2VzL3Jzcy5wbmciO3M6MzY6ImE1YjA1YmJmMjhmMjk=YjAyZWZkOTQyYTRlNWFiODA2TzYwOCI7czozOToiL3dwLWluY2x1ZGVzL2ltYWdlcy9zbWlsaWVzL2Zyb3duaWUucG5nIjtzOjM3OiI1MTliZjNkMDA1MWI4NDFlMGNiMDhkYzRmNDgzMWVlZE8xMDA3IjtzOjQyOiIvd3AtaW5jbHVkZXMvaW1hZ2VzL3NtaWxpZXMvaWNvbl9hcnJvdy5naWYiO3M6MzY6ImJmY2FiNTA5MGIxMjgwYmJlNDk1ZGJlYWQ=ZDIyODFmTzE2OSI7czo=NDoiL3dwLWluY2x1ZGVzL2ltYWdlcy9zbWlsaWVzL2ljb25fYmlnZ3Jpbi5naWYiO3M6MzY6ImM3NTk3MDUyZmUyYjE2ZGIzMDdkNmJkMTRlN2I4YzZiTzE3MyI7czo=NToiL3dwLWluY2x1ZGVzL2ltYWdlcy9zbWlsaWVzL2ljb25fY29uZnVzZWQuZ2lmIjtzOjM2OiI3ZmVmYTQ3MzU5NDY1MDA1NWEzNmI5ZTMwNjJjOWE5MU8xNzAiO3M6NDE6Ii93cC1pbmNsdWRlcy9pbWFnZXMvc21pbGllcy9pY29uX2Nvb2wuZ2lmIjtzOjM2OiI5NjQ2N2ViNWFlMThkZmEyMmVhMWMwZmEzZTc=MzgwZU8xNzIiO3M6NDA6Ii93cC1pbmNsdWRlcy9pbWFnZXMvc21pbGllcy9pY29uX2NyeS5naWYiO3M6MzY6IjQ1M2U3YTNmOGJiYjQxNzAwOGYwNmQ1NzZjNDFkMDYwTzQ5MCI7czo=MDoiL3dwLWluY2x1ZGVzL2ltYWdlcy9zbWlsaWVzL2ljb25fZWVrLmdpZiI7czozNjoiYTZjNjVmYTZmZjczOGVmNmM=NmE=ZTgwYTY1ZjdhYTBPMTcwIjtzOjQxOiIvd3AtaW5jbHVkZXMvaW1hZ2VzL3NtaWxpZXMvaWNvbl9ldmlsLmdpZiI7czozNjoiNjNiZjEwMWJkM2Q=Zjc1NjRkM2NmMzE4MjIyMThkMmVPMjQxIjtzOjQ=OiIvd3AtaW5jbHVkZXMvaW1hZ2VzL3NtaWxpZXMvaWNvbl9leGNsYWltLmdpZiI7czozNjoiNWNlMzcxNDU4YzFhMjE=ODU5NWY1ZjNkYWY3YjVmYzhPMjM2IjtzOjQxOiIvd3AtaW5jbHVkZXMvaW1hZ2VzL3NtaWxpZXMvaWNvbl9pZGVhLmdpZiI7czozNjoiYmRiMzIyNmQyNTY4YjhjMWVkZjhmNDUzYjFlODcyZTZPMTc=IjtzOjQwOiIvd3AtaW5jbHVkZXMvaW1hZ2VzL3NtaWxpZXMvaWNvbl9sb2wuZ2lmIjtzOjM2OiJkNGYwNGRjNjVhMzg3Y2E5YjhjMGYyMmNhOGMwZWM4Y=8zMzMiO3M6NDA6Ii93cC1pbmNsdWRlcy9pbWFnZXMvc21pbGllcy9pY29uX21hZC5naWYiO3M6MzY6ImQ3YmUwOGI2Njk2NTFhNjMwODBjZmU3YjkwMDRkMzMwTzE3MiI7czo=NDoiL3dwLWluY2x1ZGVzL2ltYWdlcy9zbWlsaWVzL2ljb25fbXJncmVlbi5naWYiO3M6MzY6ImZkZTllNDRhOGFhZTBlODliZDUyNzc5MmI=Nzc5YWNhTzM=OCI7czo=NDoiL3dwLWluY2x1ZGVzL2ltYWdlcy9zbWlsaWVzL2ljb25fbmV1dHJhbC5naWYiO3M6MzY6IjhhOTVkYmZhYTk5ODA5YjAxNTA2ODdhZTBjYjQ1YWVkTzE2NyI7czo=NToiL3dwLWluY2x1ZGVzL2ltYWdlcy9zbWlsaWVzL2ljb25fcXVlc3Rpb24uZ2lmIjtzOjM2OiJkMjI3NzViMmUzMjY=NTkwNzE=MWY3ODhjMzZkNGU5ZE8yNDciO3M6NDE6Ii93cC1pbmNsdWRlcy9pbWFnZXMvc21pbGllcy9pY29uX3JhenouZ2lmIjtzOjM2OiIxN2NiZTVjYmFkZTJiNGVjM2Q4NWJlNGFjOTQwOWFkZE8xNzUiO3M6NDQ6Ii93cC1pbmNsdWRlcy9pbWFnZXMvc21pbGllcy9pY29uX3JlZGZhY2UuZ2lmIjtzOjM2OiIxYzZkOGIxMDFjODIxNjQxZjk4MzE3NTIyMTM=NjExMk82NTAiO3M6NDU6Ii93cC1pbmNsdWRlcy9pbWFnZXMvc21pbGllcy9pY29uX3JvbGxleWVzLmdpZiI7czozNjoiYWZjOGJiYzY1ZmNiZDJiODJhM2UyYzFhYjQxYTIxNmFPNDg5IjtzOjQwOiIvd3AtaW5jbHVkZXMvaW1hZ2VzL3NtaWxpZXMvaWNvbl9zYWQuZ2lmIjtzOjM2OiIxYTI3M2RiM2MzNGY2YWZiM2ZlZDc1NDE3Y2E1ZTdiNk8xNjciO3M6NDI6Ii93cC1pbmNsdWRlcy9pbWFnZXMvc21pbGllcy9pY29uX3NtaWxlLmdpZiI7czozNjoiYjI5ODQ3MjljM2I2Y2RjMDc1MDhiODhiNWMwYTRkMWVPMTczIjtzOjQ2OiIvd3AtaW5jbHVkZXMvaW1hZ2VzL3NtaWxpZXMvaWNvbl9zdXJwcmlzZWQuZ2lmIjtzOjM2OiIyOTk5NzJiNWNkZDFmMWUwNjkwZGQ5NWU=MDM4YmQ4N=8xNzQiO3M6NDQ6Ii93cC1pbmNsdWRlcy9pbWFnZXMvc21pbGllcy9pY29uX3R3aXN=ZWQuZ2lmIjtzOjM2OiI2MmFiZDUwY2E5MmViMjM4MWE3YzYwZTM1MWY2NGM=Nk8yNDEiO3M6NDE6Ii93cC1pbmNsdWRlcy9pbWFnZXMvc21pbGllcy9pY29uX3dpbmsuZ2lmIjtzOjM2OiJkMDFhNGY4NzA1NWFjMGZjZThhNjY3MzlkODA=MzRiYU8xNjgiO3M6Mzk6Ii93cC1pbmNsdWRlcy9pbWFnZXMvc21pbGllcy9tcmdyZWVuLnBuZyI7czozNzoiMmQzNWMxZTA1ZWIxOTQ5MTA2ZDM=YWRkNmE5ZDlkZGFPMTQ4NiI7czo=MDoiL3dwLWluY2x1ZGVzL2ltYWdlcy9zbWlsaWVzL3JvbGxleWVzLnBuZyI7czozNzoiMjBiZWJlZjAwNTRmODUxMzMyZGY=ZjY2ZGRhMzY5OGRPMTIzMyI7czo=NDoiL3dwLWluY2x1ZGVzL2ltYWdlcy9zbWlsaWVzL3NpbXBsZS1zbWlsZS5wbmciO3M6Mzc6ImU5NGJiMmNmN2JjMjg1MTM4ZWIxNjZiMjAxNzc5NzY4TzEwMDgiO3M6MzQ6Ii93cC1pbmNsdWRlcy9pbWFnZXMvc3Bpbm5lci=yeC5naWYiO3M6Mzc6IjVjMTM3MWJjYjQzOTI5Njg2NDc4NTJhOWM5ZGY1ZDZjTzg1MzYiO3M6MzE6Ii93cC1pbmNsdWRlcy9pbWFnZXMvc3Bpbm5lci5naWYiO3M6Mzc6ImIwYTNkZGUzMzE2MzdlMjdhYTY=NzZkNDc2NDgxODcxTzQxNjIiO3M6Mzk6Ii93cC1pbmNsdWRlcy9pbWFnZXMvdG9nZ2xlLWFycm93LTJ4LnBuZyI7czozNjoiNDZjYWUxY2E1Y2Y4ODNmNGM5MTI=MzQ=NzIxNWVmMTFPMzU=IjtzOjM2OiIvd3AtaW5jbHVkZXMvaW1hZ2VzL3RvZ2dsZS1hcnJvdy5wbmciO3M6MzY6ImRjZGZjZTg3OTc2MWZkZTYxMjNiZWI2NGNlY2YyYWYyTzI4OSI7czo=MToiL3dwLWluY2x1ZGVzL2ltYWdlcy91cGxvYWRlci1pY29ucy=yeC5wbmciO3M6Mzc6ImFkYzFlN2IwMjYyZDgwZTQ=ZjE4YTI4N2MzOTVjYjdlTzM1NDIiO3M6Mzg6Ii93cC1pbmNsdWRlcy9pbWFnZXMvdXBsb2FkZXItaWNvbnMucG5nIjtzOjM3OiJiNDAxMWQ5MzVjMGY=ZGNmMGNmZmMwZjk5ZDZkOTY4ME8xNTU2IjtzOjM1OiIvd3AtaW5jbHVkZXMvaW1hZ2VzL3ctbG9nby1ibHVlLnBuZyI7czozNzoiZmQ1YjRlYjA1NzA2YTJmMDVmNzA3ZmUwNzdhZTEwMzBPMzExMyI7czozOToiL3dwLWluY2x1ZGVzL2ltYWdlcy93bHcvd3AtY29tbWVudHMucG5nIjtzOjM3OiI=Y2MyMzY1ZDA=NTBkZWRlYzMwY2VjMmU3M2E4YTFkNE8xMzczIjtzOjM1OiIvd3AtaW5jbHVkZXMvaW1hZ2VzL3dsdy93cC1pY29uLnBuZyI7czozNjoiMzExZDA5OGVjYTlhODkzNzA4NzczMzRiMWI4Zjk5MmFPNjY=IjtzOjQwOiIvd3AtaW5jbHVkZXMvaW1hZ2VzL3dsdy93cC13YXRlcm1hcmsucG5nIjtzOjM3OiIzYjlhODc3NTRkNmRkY2FkNDQ3Yzg5Nzc4ZTkzYzU=NE8yMzc2IjtzOjM=OiIvd3AtaW5jbHVkZXMvaW1hZ2VzL3dwaWNvbnMtMngucG5nIjtzOjM4OiJjM2U3NmVkNzU2YzQwNTZmYTkyNDlhOTQ=ZjY2N2UzN=8xNDkzMSI7czozMToiL3dwLWluY2x1ZGVzL2ltYWdlcy93cGljb25zLnBuZyI7czozNzoiNjQ1M2ZjZjg3NTcxOGQ5MTU2MGY1ZmFlZGNlMzYxZjRPNzA4NiI7czozMzoiL3dwLWluY2x1ZGVzL2ltYWdlcy93cHNwaW4tMnguZ2lmIjtzOjM3OiI3ZGVmMzNhYWQ5NTljZDI4OWQ=OWRkZjJhNDFmMDc2ZE85MTMzIjtzOjMwOiIvd3AtaW5jbHVkZXMvaW1hZ2VzL3dwc3Bpbi5naWYiO3M6Mzc6ImRkNGU2ZGQyNjhhNzBjZTRjMWM1MTQzYjFhNDA5MmRkTzIyMDkiO3M6MzA6Ii93cC1pbmNsdWRlcy9pbWFnZXMveGl=LTJ4LmdpZiI7czozNjoiOGZiMDcyOWM1NDFjYmRjNDYwOWZhZjNmNGFkMDJmYzdPODI1IjtzOjI3OiIvd3AtaW5jbHVkZXMvaW1hZ2VzL3hpdC5naWYiO3M6MzY6ImU1MDEyOTAyYTM1OGZiYjk2MDMxYWNkY2YwNDhkN2NhTzE4MSI7czozNzoiL3dwLWluY2x1ZGVzL=lYUi9jbGFzcy1JWFItYmFzZTY=LnBocCI7czozNjoiZWUyYTM2ZDYwNmQ1MDhhZjQ=YjY1NGU2MTc2NTk5YmJPNDE=IjtzOjM3OiIvd3AtaW5jbHVkZXMvSVhSL2NsYXNzLUlYUi1jbGllbnQucGhwIjtzOjM3OiI1MWM=YTM=YmNlNDFjZmIyNWRkYThlNzU4NTBlNTk1MU8=NjQzIjtzOjQ2OiIvd3AtaW5jbHVkZXMvSVhSL2NsYXNzLUlYUi1jbGllbnRtdWx=aWNhbGwucGhwIjtzOjM2OiJhZjEwOTAzMzQwYjhlYmMzNTNhNTA1MGE1ZmFjZTk5ME85NjMiO3M6MzU6Ii93cC1pbmNsdWRlcy9JWFIvY2xhc3MtSVhSLWRhdGUucGhwIjtzOjM3OiI4YWNhMGUzZGZmMjczZDYzMmVkOGE3ODYxY2ExNjk2N=8xNjc5IjtzOjM2OiIvd3AtaW5jbHVkZXMvSVhSL2NsYXNzLUlYUi1lcnJvci5waHAiO3M6MzY6IjY3MzYyMmFjOTVlZDc1NWMyNzMzYmNiMmFkOWM2MjhhTzg1NCI7czo1MDoiL3dwLWluY2x1ZGVzL=lYUi9jbGFzcy1JWFItaW5=cm9zcGVjdGlvbnNlcnZlci5waHAiO3M6Mzc6IjMyNTU2MWJlNzdlNDNjZjg=OTc3OTE3MDg2NGYzNzJkTzUzMjMiO3M6Mzg6Ii93cC1pbmNsdWRlcy9JWFIvY2xhc3MtSVhSLW1lc3NhZ2UucGhwIjtzOjM3OiI3NzJhYjY3YmNjYjA2ODI1NDRhYjBiNmQ3MmY=MTIyY=84MDExIjtzOjM4OiIvd3AtaW5jbHVkZXMvSVhSL2NsYXNzLUlYUi1yZXF1ZXN=LnBocCI7czozNjoiMjU3MDJlM2M4ZDUzYzdhMWVhOTlkNDdhMzFjZmEyMDRPOTI3IjtzOjM3OiIvd3AtaW5jbHVkZXMvSVhSL2NsYXNzLUlYUi1zZXJ2ZXIucGhwIjtzOjM3OiI5MWYzNzdhZjVjMTQ3ODU=OTgzZTlmY2EzYWE3ZmYxOU82OTMwIjtzOjM2OiIvd3AtaW5jbHVkZXMvSVhSL2NsYXNzLUlYUi12YWx1ZS5waHAiO3M6Mzc6IjAzOTI5ZDY2ZmIzZWE4MzU2Y2NkZjg2YTAwNjZlODBjTzM3OTAiO3M6Mjg6Ii93cC1pbmNsdWRlcy9qcy9hZG1pbi1iYXIuanMiO3M6Mzg6ImQ5N2ExODk5YTdmNjQxZTY5MzkyOGY1YTQ3YzMzZGU=TzExODA5IjtzOjMyOiIvd3AtaW5jbHVkZXMvanMvYWRtaW4tYmFyLm1pbi5qcyI7czozNzoiYjJlNzMzZjBjMTE3ZTMwYWM4OTc=ZGNjNjlhYjExZDhPNzE4OCI7czoyNzoiL3dwLWluY2x1ZGVzL2pzL2F1dG9zYXZlLmpzIjtzOjM4OiI2Y2ZhYzQyMjQ2YTA=YzlmMzdmMGEwZTVmMDQ3NGVlNE8xNjM5NCI7czozMToiL3dwLWluY2x1ZGVzL2pzL2F1dG9zYXZlLm1pbi5qcyI7czozNzoiYzIzNjZiN2RlNzAyN2QwOTY2MWVjZGRlMGM4ZDEwMjVPNTY=NiI7czozMToiL3dwLWluY2x1ZGVzL2pzL2JhY2tib25lLm1pbi5qcyI7czozODoiOTI2M2RkYmU1MmY4NWU3YmUxMzMwMWFjMjY4ODljOGVPMjMzMTgiO3M6MzA6Ii93cC1pbmNsdWRlcy9qcy9jb2xvcnBpY2tlci5qcyI7czozODoiZjAxMDE3Y2E1NjIwNjdmNDg=MGViMmI2Zjk5ZjJkYWZPMjkwODMiO3M6MzQ6Ii93cC1pbmNsdWRlcy9qcy9jb2xvcnBpY2tlci5taW4uanMiO3M6Mzg6ImUxODYyMDlkYzQxYTU5ZjJmYjYyN2MyNGU2NDA3MTJkTzE2Njc1IjtzOjMyOiIvd3AtaW5jbHVkZXMvanMvY29tbWVudC1yZXBseS5qcyI7czozNzoiMTRlYWM3NGVhNGQ4YWVjYTA4ZThlZjhkNTRkNDI2MDBPMjY4NSI7czozNjoiL3dwLWluY2x1ZGVzL2pzL2NvbW1lbnQtcmVwbHkubWluLmpzIjtzOjM3OiI1NmJjMjcyNmQ4MjkyMDdiZmE4MDJmOTU3YWFjMDc5MU8xMDc4IjtzOjMyOiIvd3AtaW5jbHVkZXMvanMvY3JvcC9jcm9wcGVyLmNzcyI7czozNzoiNmI3OTM1MGJmNDZlMGY2OTJhNGQxYjI4MDdlZDAzOTlPMjk=OSI7czozMToiL3dwLWluY2x1ZGVzL2pzL2Nyb3AvY3JvcHBlci5qcyI7czozODoiMWQ5N2IyOTZkOTE4NDgyZTEyNzNjNTZmYmZmNmE4ZTJPMTY=ODUiO3M6Mzc6Ii93cC1pbmNsdWRlcy9qcy9jcm9wL21hcnF1ZWVIb3Jpei5naWYiO3M6MzY6IjhjY2NhZTljMWViYWZkYjgzYmU2MDJlNGQ=NGM2ZjBhTzI3NyI7czozNjoiL3dwLWluY2x1ZGVzL2pzL2Nyb3AvbWFycXVlZVZlcnQuZ2lmIjtzOjM2OiJhZTlhY2NmMTAwYTRiOTkzMDYzOWFkZmY1MmQ=ZGNjN=8yOTMiO3M6MzM6Ii93cC1pbmNsdWRlcy9qcy9jdXN=b21pemUtYmFzZS5qcyI7czozODoiOGNhZGU5NDViNGE4OWQwNDM3NjJmODBiY2FlZDg3YWFPMjIxNDYiO3M6Mzc6Ii93cC1pbmNsdWRlcy9qcy9jdXN=b21pemUtYmFzZS5taW4uanMiO3M6Mzc6IjEyMDRhNjViZGNhOWI1M2IxMWUyMWIwYTQwMDZmZWQwTzc1NjIiO3M6MzU6Ii93cC1pbmNsdWRlcy9qcy9jdXN=b21pemUtbG9hZGVyLmpzIjtzOjM3OiIzNzM1ODk1Y2U=YmMxMDYxYjAzM2IwMGRkYWRjMjJkZU83NTc1IjtzOjM5OiIvd3AtaW5jbHVkZXMvanMvY3VzdG9taXplLWxvYWRlci5taW4uanMiO3M6Mzc6IjA3ZmZiYWMzZjJiYTk4YmU4MDQ=NDA3OGJmNDc4ZTA2TzM=NjEiO3M6MzU6Ii93cC1pbmNsdWRlcy9qcy9jdXN=b21pemUtbW9kZWxzLmpzIjtzOjM3OiIzYTc5OWI3NDdkMWNjOTlmNDQwZWM=NjMwYTMyZTA=ME81ODczIjtzOjM5OiIvd3AtaW5jbHVkZXMvanMvY3VzdG9taXplLW1vZGVscy5taW4uanMiO3M6Mzc6ImU3MTVlYTY4MDZjOWZkYjk=YWE=ZDU2ODEyZGQwMjE3TzM=NTkiO3M6NDY6Ii93cC1pbmNsdWRlcy9qcy9jdXN=b21pemUtcHJldmlldy1uYXYtbWVudXMuanMiO3M6Mzg6IjIwNzM5OWE=MDc=YzllZjA2NmM1ODM=YzA3ZTQzZjA4TzE=NzI=IjtzOjUwOiIvd3AtaW5jbHVkZXMvanMvY3VzdG9taXplLXByZXZpZXctbmF2LW1lbnVzLm1pbi5qcyI7czozNzoiNTI2OTUyZTdhODdhMzM5YjI3NmY1ZGNmYzk2YzUxNzZPNTA1MCI7czo=NDoiL3dwLWluY2x1ZGVzL2pzL2N1c3RvbWl6ZS1wcmV2aWV3LXdpZGdldHMuanMiO3M6Mzg6IjQzNjA5M2VkZWMzMjBjOWY5ZGE3NmNlZTAzZGViM2FjTzE5MzAzIjtzOjQ4OiIvd3AtaW5jbHVkZXMvanMvY3VzdG9taXplLXByZXZpZXctd2lkZ2V=cy5taW4uanMiO3M6Mzc6IjViNDBhZGU3MmE=ZTZhZGQ=ZWMyMTQ3YTU4ODU5YTRiTzc2NTkiO3M6MzY6Ii93cC1pbmNsdWRlcy9qcy9jdXN=b21pemUtcHJldmlldy5qcyI7czozODoiMjA2YzAwMGEzZDBjNTk4ZWM=NzFhZjU4Njg=ZjQzZTFPMjU4ODYiO3M6NDA6Ii93cC1pbmNsdWRlcy9qcy9jdXN=b21pemUtcHJldmlldy5taW4uanMiO3M6Mzg6ImI5ZjYyNjQzYzJiZDIwOWZmZDI4YzY2NWQxNmM3ZDNmTzEwMDQ5IjtzOjQ2OiIvd3AtaW5jbHVkZXMvanMvY3VzdG9taXplLXNlbGVjdGl2ZS1yZWZyZXNoLmpzIjtzOjM4OiI4MmViYTkzYjdhOWIwNWE1NmFjZmRlZDJkM2NlNjVlNU8zMjIwOCI7czo1MDoiL3dwLWluY2x1ZGVzL2pzL2N1c3RvbWl6ZS1zZWxlY3RpdmUtcmVmcmVzaC5taW4uanMiO3M6Mzg6IjlmOTkxMjAzNzBiNzA=ZTZjN2Q=MGY5YTU3MDVlODIzTzEwNTgyIjtzOjM=OiIvd3AtaW5jbHVkZXMvanMvY3VzdG9taXplLXZpZXdzLmpzIjtzOjM3OiI1YWJlYTdiNmQ5YTI1NTZmYjhjYmZjZDNmOGQxYzBmZk81NDI2IjtzOjM4OiIvd3AtaW5jbHVkZXMvanMvY3VzdG9taXplLXZpZXdzLm1pbi5qcyI7czozNzoiYzVmMGFiYjczZTY4N2ZhZWJjOWJmMjI1YTFlMDgyNGVPMjkzOSI7czoyODoiL3dwLWluY2x1ZGVzL2pzL2hlYXJ=YmVhdC5qcyI7czozODoiNDcxNDQwMGQ1NGI5NmEyYzM4MGIyNDUzMDBhNWJlNWFPMjAwNzciO3M6MzI6Ii93cC1pbmNsdWRlcy9qcy9oZWFydGJlYXQubWluLmpzIjtzOjM3OiIxMjZjYzRkMWUzNWI3NGVkYjUyNWIwNmUzNzg4ZTBmMk81NDgzIjtzOjMwOiIvd3AtaW5jbHVkZXMvanMvaG92ZXJJbnRlbnQuanMiO3M6Mzc6ImNhYjM1OThiNDM4YTllNjM5ODRmMWM2ZTlkZDc5YjAxTzQ5NDkiO3M6MzQ6Ii93cC1pbmNsdWRlcy9qcy9ob3ZlckludGVudC5taW4uanMiO3M6Mzc6ImNhNTAwYWRlODU=YzMxNDE3ZmFmNTc2MmUzMWI5ZDAwTzExMTUiO3M6MzU6Ii93cC1pbmNsdWRlcy9qcy9pbWFnZXNsb2FkZWQubWluLmpzIjtzOjM3OiJkMGMyYzBkN2UzNzY1MmU2NjY1N2M4YzhkNjM3NjQ=Mk83OTk=IjtzOjQ3OiIvd3AtaW5jbHVkZXMvanMvaW1nYXJlYXNlbGVjdC9ib3JkZXItYW5pbS1oLmdpZiI7czozNjoiNWFjM2M=MmNjODZlNzQ1YTVlMzZiNjdiNGM3MGExMzRPMTc4IjtzOjQ3OiIvd3AtaW5jbHVkZXMvanMvaW1nYXJlYXNlbGVjdC9ib3JkZXItYW5pbS12LmdpZiI7czozNjoiMjBjOTdhMjE5OTNjZjEzN2VhZDlmZGJlY2JjNDJhYThPMTc4IjtzOjQ3OiIvd3AtaW5jbHVkZXMvanMvaW1nYXJlYXNlbGVjdC9pbWdhcmVhc2VsZWN=LmNzcyI7czozNjoiN2QyOGNhZDkyODI5YjNkNjMzYTA4N2I1ZjNiNTk1YWZPNzkwIjtzOjUzOiIvd3AtaW5jbHVkZXMvanMvaW1nYXJlYXNlbGVjdC9qcXVlcnkuaW1nYXJlYXNlbGVjdC5qcyI7czozODoiN2EwZTFiZmM=MjkyNTI1MzBjZmI4MzE4ZjUzYTU5ODZPMzgxMzMiO3M6NTc6Ii93cC1pbmNsdWRlcy9qcy9pbWdhcmVhc2VsZWN=L2pxdWVyeS5pbWdhcmVhc2VsZWN=Lm1pbi5qcyI7czozNzoiMjVmNDJlMDQ5ZTY1ZWUxNmQ=NDI3OTk3NTU3MjQwMjVPOTg4NyI7czozMToiL3dwLWluY2x1ZGVzL2pzL2pjcm9wL=pjcm9wLmdpZiI7czozNjoiNWE4YmZkMzc2NTEzMDViZGFmYmNmMmNkNTFiMDI1NGJPMzIzIjtzOjQyOiIvd3AtaW5jbHVkZXMvanMvamNyb3AvanF1ZXJ5Lkpjcm9wLm1pbi5jc3MiO3M6Mzc6IjU2Y2M5ZWEyMDFkYzJmNGI5MTBlNzhiZmFjYWM5MjExTzIxMjQiO3M6NDE6Ii93cC1pbmNsdWRlcy9qcy9qY3JvcC9qcXVlcnkuSmNyb3AubWluLmpzIjtzOjM4OiIyZjYxYWI5ODRjMTc3Mjc1YzcxZTM=ZmYxYTE3YzEwMk8xNTg5MyI7czo=MDoiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS9qcXVlcnktbWlncmF=ZS5qcyI7czozODoiNmM1N2I3NjI1ODlmMTNlYTViMzU3OWNhNWU2YzM2OWJPMjM=OTciO3M6NDQ6Ii93cC1pbmNsdWRlcy9qcy9qcXVlcnkvanF1ZXJ5LW1pZ3JhdGUubWluLmpzIjtzOjM4OiI3MTIxOTk=ZWVjNTMyMGZiZTY1ODY=NjNiZjk2NTFjMk8xMDA1NiI7czo=MjoiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS9qcXVlcnkuY29sb3IubWluLmpzIjtzOjM3OiJmZjJkYjhkYmYxNDVjZTQ3ZjMxNzgxZWVmMzNlNzY=YU85Mjk1IjtzOjM3OiIvd3AtaW5jbHVkZXMvanMvanF1ZXJ5L2pxdWVyeS5mb3JtLmpzIjtzOjM4OiJlNWFmZDhlNDFkMmVjMjJjMTk5MzJiMDY4Y2Q5MGE3MU8=MTcxOSI7czo=MToiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS9qcXVlcnkuZm9ybS5taW4uanMiO3M6Mzg6ImRiYzM4MDg=NzNkZWYwMGZjZTQ1ZmU1NjRkYzcyZGNiTzE=NzIwIjtzOjQwOiIvd3AtaW5jbHVkZXMvanMvanF1ZXJ5L2pxdWVyeS5ob3RrZXlzLmpzIjtzOjM3OiJlMjk=ODNhOGNhMjZhMGRkOGIwZDExNDZjNmIwYTZlOU81NjEyIjtzOjQ=OiIvd3AtaW5jbHVkZXMvanMvanF1ZXJ5L2pxdWVyeS5ob3RrZXlzLm1pbi5qcyI7czozNzoiZTM1MzIxN2Q=NTU1YWI1YzYyYjM2N2JlNjg4OTgxM2RPMTc5MyI7czozMjoiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS9qcXVlcnkuanMiO3M6Mzg6Ijg2MTBmMDNmZTc3NjQwZGVlOGM=Y2M5MjRlMDYwZjEyTzk3MTg=IjtzOjQ=OiIvd3AtaW5jbHVkZXMvanMvanF1ZXJ5L2pxdWVyeS5tYXNvbnJ5Lm1pbi5qcyI7czozNzoiY2QwZWIzNDA2MDk2ZmY4MDI2NmU3YzlkN2Q=MTkxODZPMTgxOSI7czozODoiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS9qcXVlcnkucXVlcnkuanMiO3M6Mzc6IjNiY2M1ODdhZjJjN2IwMWZjNmZiYzljMDc3MDUwMTQzTzM3ODUiO3M6NDE6Ii93cC1pbmNsdWRlcy9qcy9qcXVlcnkvanF1ZXJ5LnNjaGVkdWxlLmpzIjtzOjM3OiIwNDI2YjM5NzU=YWE2YmM3NjZkODllYTRjNDFiYmQwNk8zNDU3IjtzOjQ5OiIvd3AtaW5jbHVkZXMvanMvanF1ZXJ5L2pxdWVyeS5zZXJpYWxpemUtb2JqZWN=LmpzIjtzOjM2OiJkMTVjMjlhMThkOWZmYThiOWI=YWU4NmMzYzBjZmEyMk83ODMiO3M6NDY6Ii93cC1pbmNsdWRlcy9qcy9qcXVlcnkvanF1ZXJ5LnRhYmxlLWhvdGtleXMuanMiO3M6Mzc6ImE3MDZlYWQ2OTQyMzFlNzRmZDY3NTBiMTY3MDU4MGE1TzM3MzAiO3M6NTA6Ii93cC1pbmNsdWRlcy9qcy9qcXVlcnkvanF1ZXJ5LnRhYmxlLWhvdGtleXMubWluLmpzIjtzOjM3OiJlNTZmODE2NzZmMTk5ZGI3YmY5MzdlNjlhNjQ5MDlmYU8yMjk1IjtzOjQ3OiIvd3AtaW5jbHVkZXMvanMvanF1ZXJ5L2pxdWVyeS51aS5=b3VjaC1wdW5jaC5qcyI7czozNzoiNGNjODZkMTAwM2M=NTEzNGQ2ODM4ZjEzZTM4ODVkYjFPMTE3OSI7czozMzoiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS9zdWdnZXN=LmpzIjtzOjM3OiIzYTI=NzQ1NjkxNDVkNTFlY2FiZjdmYzRmYjA3ODk4Mk82OTkxIjtzOjM3OiIvd3AtaW5jbHVkZXMvanMvanF1ZXJ5L3N1Z2dlc3QubWluLmpzIjtzOjM3OiI3MzExMDc1YzJiNDExYjI5OWM5NGUzNmUyZTNiYWI4OU8yOTkzIjtzOjQyOiIvd3AtaW5jbHVkZXMvanMvanF1ZXJ5L3VpL2FjY29yZGlvbi5taW4uanMiO3M6Mzc6IjMzNGMyZmZiMGIwODZmZmMwZjZmMTkyZWExMjBmM2MyTzg1ODQiO3M6NDU6Ii93cC1pbmNsdWRlcy9qcy9qcXVlcnkvdWkvYXV=b2NvbXBsZXRlLm1pbi5qcyI7czozNzoiZDBmZjNlYmE2MjU4NjUxNzczYzNhNWNjOTA5ZWZkZTZPODI4MyI7czozOToiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS91aS9idXR=b24ubWluLmpzIjtzOjM3OiIyY2U5OWUxZWQwOGRmMzUxZTZhNThlYjRiNmJjYmZhOU83MjM2IjtzOjM3OiIvd3AtaW5jbHVkZXMvanMvanF1ZXJ5L3VpL2NvcmUubWluLmpzIjtzOjM3OiI5Y2U=ZTE1NzQ=ODQ4N2Q=ZWZlMGNhNTM4ZjY1NmE3MU8=MDAwIjtzOjQzOiIvd3AtaW5jbHVkZXMvanMvanF1ZXJ5L3VpL2RhdGVwaWNrZXIubWluLmpzIjtzOjM4OiJjZmI2M2RjMThmZGU1M2ZlZjRkNGZkYzE5ZGRmZGNkNk8zNjUwOCI7czozOToiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS91aS9kaWFsb2cubWluLmpzIjtzOjM4OiIzZWNkOTU5MGFhYzc3ODUxNGY=ZTY5OTc1ZWQ5MWE2Mk8xMjEzOSI7czo=MjoiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS91aS9kcmFnZ2FibGUubWluLmpzIjtzOjM4OiI=NDNjMjc3Nzg5YmFmNjljNDkwMDE5ZDU5YzFiMzZlZE8xODkwNSI7czo=MjoiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS91aS9kcm9wcGFibGUubWluLmpzIjtzOjM3OiJkZWJmNTIyNGM=MTYyODg3ZDFhNmUzMTk4ZWQ5NTNkOE82MjY3IjtzOjQ1OiIvd3AtaW5jbHVkZXMvanMvanF1ZXJ5L3VpL2VmZmVjdC1ibGluZC5taW4uanMiO3M6Mzc6ImFkZGJlMDlmMTczYzRmMWJkODZkNDFhYzVmM2I=ZjRjTzExMzkiO3M6NDY6Ii93cC1pbmNsdWRlcy9qcy9qcXVlcnkvdWkvZWZmZWN=LWJvdW5jZS5taW4uanMiO3M6Mzc6IjRiYzRjOTc5MjRiZWE=YmY3YjA=ZDdiNDZmZjRmNjRjTzEyNDciO3M6NDQ6Ii93cC1pbmNsdWRlcy9qcy9qcXVlcnkvdWkvZWZmZWN=LWNsaXAubWluLmpzIjtzOjM2OiJjNzkzOTQ1N2U4YWIyMzFiOTUxNzEzNDc1YTA1NjE3M=85MTgiO3M6NDQ6Ii93cC1pbmNsdWRlcy9qcy9qcXVlcnkvdWkvZWZmZWN=LWRyb3AubWluLmpzIjtzOjM2OiI1N2ZlNTYwODg3Y2FjN2E1YjI1OTgxODg=NjMyOTBlOE85OTciO3M6NDc6Ii93cC1pbmNsdWRlcy9qcy9qcXVlcnkvdWkvZWZmZWN=LWV4cGxvZGUubWluLmpzIjtzOjM3OiJjMGRmNjI1Y2NhNDE4Y2ZkODAzYTExNTE=YTNkZDFlNk8xMTc2IjtzOjQ=OiIvd3AtaW5jbHVkZXMvanMvanF1ZXJ5L3VpL2VmZmVjdC1mYWRlLm1pbi5qcyI7czozNjoiOWY2ZmQ2NGY=ZjVmZjU4OTNiN2I3MmEyMzUyNDZkMGNPNTE1IjtzOjQ=OiIvd3AtaW5jbHVkZXMvanMvanF1ZXJ5L3VpL2VmZmVjdC1mb2xkLm1pbi5qcyI7czozNzoiOGQzNjVlYzFiM2E3ZWU4MmY5M2M5YWZkNDQxZTQ1NmNPMTAzMCI7czo=OToiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS91aS9lZmZlY3QtaGlnaGxpZ2h=Lm1pbi5qcyI7czozNjoiOTVlOGViZTYyYWRmMTg3ZmI=YzNiODRlYjViZWY4MjFPNzg5IjtzOjQ=OiIvd3AtaW5jbHVkZXMvanMvanF1ZXJ5L3VpL2VmZmVjdC1wdWZmLm1pbi5qcyI7czozNjoiZmU=OTZkNmM5ZDYzYmM=Nzg1NDA4NGM4YjNmYzIwZDZPNzgzIjtzOjQ3OiIvd3AtaW5jbHVkZXMvanMvanF1ZXJ5L3VpL2VmZmVjdC1wdWxzYXRlLm1pbi5qcyI7czozNjoiYmY4MzZmMjA1MzA=NDAxMTVhMmE4NDg3Y2E3MDIxYzVPNzk4IjtzOjQ1OiIvd3AtaW5jbHVkZXMvanMvanF1ZXJ5L3VpL2VmZmVjdC1zY2FsZS5taW4uanMiO3M6Mzc6ImQ1N2QwODMwNjUyYzI5YzNlMGUzMDFiMDJiNmRiNzU=TzExMjIiO3M6NDU6Ii93cC1pbmNsdWRlcy9qcy9qcXVlcnkvdWkvZWZmZWN=LXNoYWtlLm1pbi5qcyI7czozNzoiMjYwY2JhZmNiY2VkYzIzMzQ4YTM3MWNiODAwODMxMTJPMTEwMSI7czo=NDoiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS91aS9lZmZlY3Qtc2l6ZS5taW4uanMiO3M6Mzc6ImIwMGUzZGZkNmVlYmNjZDVlYTlhZWIzMjkzZDg1YTI1TzMzNTEiO3M6NDU6Ii93cC1pbmNsdWRlcy9qcy9qcXVlcnkvdWkvZWZmZWN=LXNsaWRlLm1pbi5qcyI7czozNjoiZmEyMzQ3NWZiMDFjOGY=ZDU2ZGE5OGNhMGMxMTc5YjVPOTYyIjtzOjQ4OiIvd3AtaW5jbHVkZXMvanMvanF1ZXJ5L3VpL2VmZmVjdC1=cmFuc2Zlci5taW4uanMiO3M6MzY6IjA3ZTViMGRlYTgwMDc3N2RkMjEwODc4OGI1NmVmOTBiTzg1NyI7czozOToiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS91aS9lZmZlY3QubWluLmpzIjtzOjM4OiIzZjcxNjFjZjEzOWQ1YTJjNWU2ZDM=ZTFjMDAyNmY5ZE8xMzQyMCI7czozNzoiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS91aS9tZW51Lm1pbi5qcyI7czozNzoiYzkxY2ZmZjUwNzE1NDQxMjk1ZmU3NDYzYmI1ZDM4OTRPOTYwMCI7czozODoiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS91aS9tb3VzZS5taW4uanMiO3M6Mzc6IjgyODM1YTg5NjBkZGQ3MzAyMDM4OWRiZmE=NWMzOWEwTzMxNDgiO3M6NDE6Ii93cC1pbmNsdWRlcy9qcy9qcXVlcnkvdWkvcG9zaXRpb24ubWluLmpzIjtzOjM3OiIxYzRhMTNlZGVjMTk1ODgxN2U4MzQzM2FlYWE=MmY2Mk82NTI3IjtzOjQ=OiIvd3AtaW5jbHVkZXMvanMvanF1ZXJ5L3VpL3Byb2dyZXNzYmFyLm1pbi5qcyI7czozNzoiYjk=ZDcxZGE1NGQ5YjQ=MTNmZmE=YzdkNzkyMjY5YzVPMjQ3MiI7czo=MjoiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS91aS9yZXNpemFibGUubWluLmpzIjtzOjM4OiJhNTAwMTAzMjE3N2M=OTJjZjBmZjdjODZiYzAxMTY5Zk8xODQyNiI7czo=MzoiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS91aS9zZWxlY3RhYmxlLm1pbi5qcyI7czozNzoiYjYzMmFkZDE5MWVjYWU5MmU2YTdiNmI5NzIxMmE2NDBPNDI1OCI7czo=MzoiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS91aS9zZWxlY3RtZW51Lm1pbi5qcyI7czozNzoiY2I3ZGI=Y2JhYTMyOGUzOTVhNjgwYzc4NjkyMjM2ZjBPODM4NCI7czozOToiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS91aS9zbGlkZXIubWluLmpzIjtzOjM4OiI5NDA4ZWZlMmNlNWE2YjQzNjRmMzRjYmRhMDJmODE=Yk8xMDk4NyI7czo=MToiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS91aS9zb3J=YWJsZS5taW4uanMiO3M6Mzg6IjI4OTZlOTBjYzE3ZTlhYmMxNjBlZDk2YmI4NmIwN2UzTzI=ODk5IjtzOjQwOiIvd3AtaW5jbHVkZXMvanMvanF1ZXJ5L3VpL3NwaW5uZXIubWluLmpzIjtzOjM3OiIzYWNmMzJkYTYxMmJmMzUyMjFjMDkzOTQ4NTY1OTFkY=83MTA=IjtzOjM3OiIvd3AtaW5jbHVkZXMvanMvanF1ZXJ5L3VpL3RhYnMubWluLmpzIjtzOjM4OiI1MzMwYzgzNDI1YWIxYjhmNjdjZTYzZjc=MTQyN2FkYk8xMjExMCI7czo=MDoiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS91aS9=b29sdGlwLm1pbi5qcyI7czozNzoiNDQzZjY4NjkwZDg=ZWVlNDJjZjMwMTkwNzEzNDA3MzBPNTcwNSI7czozOToiL3dwLWluY2x1ZGVzL2pzL2pxdWVyeS91aS93aWRnZXQubWluLmpzIjtzOjM3OiI4Y2Y3ZjM2YmJkNzliYzA2NjRiNjExM2Y3YTc4MzdmZU82OTA4IjtzOjI=OiIvd3AtaW5jbHVkZXMvanMvanNvbjIuanMiO3M6Mzg6IjczYTFkNzdiNGU4MjdjNDUwNjFmNGZhYjA=MTAzMGE5TzE4NDIyIjtzOjI4OiIvd3AtaW5jbHVkZXMvanMvanNvbjIubWluLmpzIjtzOjM3OiIzNWQ4OTlhODE5ODYxNzNmNDRmOWJiZTY4NmNjNTgzY=8zMTMzIjtzOjMwOiIvd3AtaW5jbHVkZXMvanMvbWFzb25yeS5taW4uanMiO3M6Mzg6IjU=MjBiNjUxNmMxNDI=NWI1MDRlNzI=MGE4MzEwZjJjTzI4OTU=IjtzOjI3OiIvd3AtaW5jbHVkZXMvanMvbWNlLXZpZXcuanMiO3M6Mzg6IjEzNDg3NTkwMWM=YWVlYzlkZDRkNzkxODI4ZTYzNWExTzI=NDU1IjtzOjMxOiIvd3AtaW5jbHVkZXMvanMvbWNlLXZpZXcubWluLmpzIjtzOjM3OiIyNmE2NGI1ODU3ZjFmYTk4MTY3ODU2YWMzOWIwYTI2OE85MTgzIjtzOjM1OiIvd3AtaW5jbHVkZXMvanMvbWVkaWEtYXVkaW92aWRlby5qcyI7czozODoiZjI1NjUwM2NhYTZiYzIzYjQ=YzgyZTNmNDZiNmIyM2JPMjI=MjMiO3M6Mzk6Ii93cC1pbmNsdWRlcy9qcy9tZWRpYS1hdWRpb3ZpZGVvLm1pbi5qcyI7czozODoiZjA5MzEwMGQ1MzlmMDNiNWQxZDMxZjFlNzQwMjliNDRPMTI4ODMiO3M6MzE6Ii93cC1pbmNsdWRlcy9qcy9tZWRpYS1lZGl=b3IuanMiO3M6Mzg6IjRjNjlhMTU5OWJkNjg2OGEzMWNkNDNiN2Y4OTk5NjRkTzI5ODY4IjtzOjM1OiIvd3AtaW5jbHVkZXMvanMvbWVkaWEtZWRpdG9yLm1pbi5qcyI7czozODoiNzljZjUxYmFlMjU5M2I3YWMyN2I3Mzc4OWU=MzY=NmRPMTA5MDUiO3M6Mjk6Ii93cC1pbmNsdWRlcy9qcy9tZWRpYS1ncmlkLmpzIjtzOjM4OiI4NDZiYmYyZTNhY2MxNTZjZTRkNmRlYjc3MmM3MDNiM=8yMzYyNCI7czozMzoiL3dwLWluY2x1ZGVzL2pzL21lZGlhLWdyaWQubWluLmpzIjtzOjM4OiI3NmZlNjg4NjE2NTQ2NTM=OTFlYzhhNjhjZWIyZGE=Y=8xMzM5OCI7czozMToiL3dwLWluY2x1ZGVzL2pzL21lZGlhLW1vZGVscy5qcyI7czozODoiOWRiZDczOTVmYWMwZjZmMTA2NWJkNTIzMWQxNDk=MWZPNDExNzUiO3M6MzU6Ii93cC1pbmNsdWRlcy9qcy9tZWRpYS1tb2RlbHMubWluLmpzIjtzOjM4OiJlZWQ5ODEzYmFkNTkyZDQyODdiZTBlYjBlYmI2ODQ5N=8xMzcwNSI7czozMDoiL3dwLWluY2x1ZGVzL2pzL21lZGlhLXZpZXdzLmpzIjtzOjM5OiI2ZmFkMDk1YzZmMjk1MTMxODQ=YWZiZmIwODk5NTZkM=8yMjk5ODgiO3M6MzQ6Ii93cC1pbmNsdWRlcy9qcy9tZWRpYS12aWV3cy5taW4uanMiO3M6Mzk6ImU1MDFiZTkxZjgyY2JkYTU3MDU4MmQwMGNlNDNjMDU=TzEwNDQwOSI7czo=MzoiL3dwLWluY2x1ZGVzL2pzL21lZGlhZWxlbWVudC9iYWNrZ3JvdW5kLnBuZyI7czozNjoiNzAzYzY1OWU=YmY1NjNhMDVjNjMzOGExNzI3ZTAwNmNPMTY2IjtzOjQwOiIvd3AtaW5jbHVkZXMvanMvbWVkaWFlbGVtZW5=L2JpZ3BsYXkucG5nIjtzOjM3OiI3MTY=MzZmYjNkZjBkMjllNmIzN2RkNjJkOTUyNjc2YU8zMDAxIjtzOjQwOiIvd3AtaW5jbHVkZXMvanMvbWVkaWFlbGVtZW5=L2JpZ3BsYXkuc3ZnIjtzOjM3OiI3NDZjM2FmN2ExNDVhMDkyMzlhMzZlNWVmNjFjZmVhME8xMDI5IjtzOjQxOiIvd3AtaW5jbHVkZXMvanMvbWVkaWFlbGVtZW5=L2NvbnRyb2xzLnBuZyI7czozNzoiMjRhMDIyN2ZiZGQzYWNmZDg2ZmYwM2ZjM2ZjNmM4YTRPMTg5MiI7czo=MToiL3dwLWluY2x1ZGVzL2pzL21lZGlhZWxlbWVudC9jb25=cm9scy5zdmciO3M6Mzg6IjQwZjU2ZjVhNzM2ZGE=ZWZmZWI3OTBjZWRiOGE1MmYwTzEwMzQ=IjtzOjUwOiIvd3AtaW5jbHVkZXMvanMvbWVkaWFlbGVtZW5=L2ZsYXNobWVkaWFlbGVtZW5=LnN3ZiI7czozOToiMmVmZTFmYWJmZWEwNDQzMmYwOTBlY2IzMTUzYjEwYTFPMTMwMDU=IjtzOjQ2OiIvd3AtaW5jbHVkZXMvanMvbWVkaWFlbGVtZW5=L2Zyb29nYWxvb3AubWluLmpzIjtzOjM3OiIyYTg3NDJjMGFjMWNkYmVjMjNiZTQ=YTdkNGU5YTNjOU8xNzY5IjtzOjQ=OiIvd3AtaW5jbHVkZXMvanMvbWVkaWFlbGVtZW5=L2p1bXBmb3J3YXJkLnBuZyI7czozNzoiMTVlMWFjOGNiYWNjMmVmZGYxYWMyNjc3ZGU=OGEyNTNPMTU2MyI7czo=MDoiL3dwLWluY2x1ZGVzL2pzL21lZGlhZWxlbWVudC9sb2FkaW5nLmdpZiI7czozNzoiNzZiMzI2ZjRkNDQyMjIxMjZmZWUyMTA3NjU5NWJlZjVPNjIyNCI7czo1OToiL3dwLWluY2x1ZGVzL2pzL21lZGlhZWxlbWVudC9tZWRpYWVsZW1lbnQtYW5kLXBsYXllci5taW4uanMiO3M6Mzg6Ijg5NzBlNmU2NzJhMWQzMTJjOGQ4ZWY=NzFmZmI3ZDVmTzgyNjI1IjtzOjU1OiIvd3AtaW5jbHVkZXMvanMvbWVkaWFlbGVtZW5=L21lZGlhZWxlbWVudHBsYXllci5taW4uY3NzIjtzOjM4OiIwNjg3ZTMzZTg=YTg2MGMzM2EzYTg4NTE5M2E2ZDkzN=8yMDQzMSI7czo1NjoiL3dwLWluY2x1ZGVzL2pzL21lZGlhZWxlbWVudC9zaWx2ZXJsaWdodG1lZGlhZWxlbWVudC54YXAiO3M6Mzg6ImQwZTQ=ZmQ2ZWNlYmNhNDZmMzZkNzM=YjMwMTJhYTJjTzEyNDU5IjtzOjQxOiIvd3AtaW5jbHVkZXMvanMvbWVkaWFlbGVtZW5=L3NraXBiYWNrLnBuZyI7czozNzoiY2Q2ZGM4MzBlYjQ1YjNhNWE5NmJiYzkzNmZmNTQ4NDZPNDI=NSI7czo=ODoiL3dwLWluY2x1ZGVzL2pzL21lZGlhZWxlbWVudC93cC1tZWRpYWVsZW1lbnQuY3NzIjtzOjM3OiIwMGY4ZWIzN2Q=ODczYWZmMzM1NTliZTFhYjNhNWRhME81Mjc2IjtzOjQ3OiIvd3AtaW5jbHVkZXMvanMvbWVkaWFlbGVtZW5=L3dwLW1lZGlhZWxlbWVudC5qcyI7czozNzoiMWQ4ODljOTlmMDRhMzk1NzNkNGJlNWIzNDZjNjI3MmZPMTUzNSI7czo1MjoiL3dwLWluY2x1ZGVzL2pzL21lZGlhZWxlbWVudC93cC1tZWRpYWVsZW1lbnQubWluLmNzcyI7czozNzoiNzRjYTA4NGY2NzkxYWY=NTUyN2JlNGI1MzE5MDk1MTJPNDQ3NyI7czo1MToiL3dwLWluY2x1ZGVzL2pzL21lZGlhZWxlbWVudC93cC1tZWRpYWVsZW1lbnQubWluLmpzIjtzOjM2OiI4ZTdhNDQwNWQzNTEzOWY2Mjg3MWE1Mzk1MTY2NzlhMU83OTYiO3M6NDM6Ii93cC1pbmNsdWRlcy9qcy9tZWRpYWVsZW1lbnQvd3AtcGxheWxpc3QuanMiO3M6Mzc6ImFhZjc3Zjc=ODFmNDE5ZjVmOGM=NmFlMzM4ODIwNDQzTzQ3MTciO3M6NDc6Ii93cC1pbmNsdWRlcy9qcy9tZWRpYWVsZW1lbnQvd3AtcGxheWxpc3QubWluLmpzIjtzOjM3OiIyNjQ1NjNlOTRlMmQxNmIxMDY2YmQ=MTNlYmM1OTJkZU8zMzU=IjtzOjM2OiIvd3AtaW5jbHVkZXMvanMvcGx1cGxvYWQvaGFuZGxlcnMuanMiO3M6Mzg6IjA2ZTRkNjRlMDk5NDY2ZWFhMzE4NWYxODUwODg=ODIxTzE2MjU2IjtzOjQwOiIvd3AtaW5jbHVkZXMvanMvcGx1cGxvYWQvaGFuZGxlcnMubWluLmpzIjtzOjM4OiIzZWE=MGFiN2MyN2I3NWQyMGMzZGEyMmYwOTdkNjYxNE8xMDY4MSI7czozNjoiL3dwLWluY2x1ZGVzL2pzL3BsdXBsb2FkL2xpY2Vuc2UudHh=IjtzOjM4OiI3NTE=MTkyNjBhYTk1NDQ5OWY3YWJhYWJhYTg4MmJiZU8xNzk4NyI7czo=MzoiL3dwLWluY2x1ZGVzL2pzL3BsdXBsb2FkL3BsdXBsb2FkLmZsYXNoLnN3ZiI7czozODoiMzcwZDc2OGU=NTUyNGY=N2ZiZDI5ODg5NzRkM2Q3NmNPMjk1NzAiO3M6NDU6Ii93cC1pbmNsdWRlcy9qcy9wbHVwbG9hZC9wbHVwbG9hZC5mdWxsLm1pbi5qcyI7czozOToiNGE=MzFmYjQwNDliMjQ1NjZkMjdjMTJlMjc5M2Q4MThPMTEzMDgxIjtzOjQ5OiIvd3AtaW5jbHVkZXMvanMvcGx1cGxvYWQvcGx1cGxvYWQuc2lsdmVybGlnaHQueGFwIjtzOjM4OiI3NDcxMDBjMTg1Y2YzM2Y2NTg4OTMwYTU5NDFkNjJmN=82MzExOCI7czozOToiL3dwLWluY2x1ZGVzL2pzL3BsdXBsb2FkL3dwLXBsdXBsb2FkLmpzIjtzOjM4OiIyYjZmMGNjNTRlMzgxZmQ1MmYzYTM3MjZlMDljMWQwN=8xMjcxNCI7czo=MzoiL3dwLWluY2x1ZGVzL2pzL3BsdXBsb2FkL3dwLXBsdXBsb2FkLm1pbi5qcyI7czozNzoiN2M3NGEwZjg2NmM1ZGZkMWRjOWE=NTQ3NDY1MWY2ZWZPNDkyMCI7czoyODoiL3dwLWluY2x1ZGVzL2pzL3F1aWNrdGFncy5qcyI7czozODoiNDgxZTkwNGRkNzA2ZjUxYWY=YmYyZmFhNDA3MDE2NWJPMjE2OTYiO3M6MzI6Ii93cC1pbmNsdWRlcy9qcy9xdWlja3RhZ3MubWluLmpzIjtzOjM4OiI2YTM2NWMyZmNkNTI1NjZhZTlmZDNkYjlhMjhjNjczZE8xMDc2MSI7czoyODoiL3dwLWluY2x1ZGVzL2pzL3Nob3J=Y29kZS5qcyI7czozODoiZmM4Y2I1ODBlMGVkYzVjZGExYTU1MDc=N2QwZGU2YzlPMTAzNjYiO3M6MzI6Ii93cC1pbmNsdWRlcy9qcy9zaG9ydGNvZGUubWluLmpzIjtzOjM3OiJiMzQyZDU2YTkwYjA5YWRmYWQ2ZDk1YTQ3MTdjMGIyNE8yNTc3IjtzOjI4OiIvd3AtaW5jbHVkZXMvanMvc3dmb2JqZWN=LmpzIjtzOjM4OiI5ZmZkYmEyY2ZmNDk3ZDcwMTY4NDY1N2UzMjk4NzFmNU8xMDIzMSI7czozNzoiL3dwLWluY2x1ZGVzL2pzL3N3ZnVwbG9hZC9oYW5kbGVycy5qcyI7czozODoiMTRiMmQwNGZkYjg1YmMxZjE3MWNmM2RmYjI5ODdkY2FPMTI2NTUiO3M6NDE6Ii93cC1pbmNsdWRlcy9qcy9zd2Z1cGxvYWQvaGFuZGxlcnMubWluLmpzIjtzOjM3OiI5NjU5MmM2YjNmYWQ1ODBjZTA=ZTEyYmMzMDQ3ZWYzYk84ODY3IjtzOjM3OiIvd3AtaW5jbHVkZXMvanMvc3dmdXBsb2FkL2xpY2Vuc2UudHh=IjtzOjM3OiJjYmUwNWJiMDYwYzg1ZTA3ODgyZGMwNmZmNzUxNTc3YU8xNTQwIjtzOjU=OiIvd3AtaW5jbHVkZXMvanMvc3dmdXBsb2FkL3BsdWdpbnMvc3dmdXBsb2FkLmNvb2tpZXMuanMiO3M6Mzc6IjdmYTU3ZWMwMGRkYTg4ZGQ2YjVjMjAzN2NjYjRkNWNmTzE1NzIiO3M6NTI6Ii93cC1pbmNsdWRlcy9qcy9zd2Z1cGxvYWQvcGx1Z2lucy9zd2Z1cGxvYWQucXVldWUuanMiO3M6Mzc6Ijk5NTM1MjJmYmQ=YTFiMDJiYmY2MzVhOTJkNzZjZDhmTzMzODMiO3M6NTI6Ii93cC1pbmNsdWRlcy9qcy9zd2Z1cGxvYWQvcGx1Z2lucy9zd2Z1cGxvYWQuc3BlZWQuanMiO3M6Mzg6IjQxNWEzNzg3ODQ2YmI2YzJkNzQ1NjAyYzJhZmI3M2FjTzEyMjM=IjtzOjU2OiIvd3AtaW5jbHVkZXMvanMvc3dmdXBsb2FkL3BsdWdpbnMvc3dmdXBsb2FkLnN3Zm9iamVjdC5qcyI7czozNzoiY2NiNTE1NzFhNzU2MzdkYjA4NTQ1Y2FhZjJlZDllNzNPMzkyNiI7czozODoiL3dwLWluY2x1ZGVzL2pzL3N3ZnVwbG9hZC9zd2Z1cGxvYWQuanMiO3M6Mzg6IjZjZDM3MGJmZDRkODZjNDRhYzE1NWZkOTEzZTk3MWFjTzM3NjkwIjtzOjM5OiIvd3AtaW5jbHVkZXMvanMvc3dmdXBsb2FkL3N3ZnVwbG9hZC5zd2YiO3M6Mzg6ImJkNWEyNWYyMzU4OTY1MmNhNDcyZDQxZmUxNDg=ZjBjTzEzMTMzIjtzOjQ1OiIvd3AtaW5jbHVkZXMvanMvdGhpY2tib3gvbG9hZGluZ=FuaW1hdGlvbi5naWYiO3M6Mzg6ImNlMjI2ODAzMGRkMjE1MWI2M2NkZjRmZmMyZjYyNmJhTzE1MjM4IjtzOjQwOiIvd3AtaW5jbHVkZXMvanMvdGhpY2tib3gvbWFjRkZCZ=hhY2sucG5nIjtzOjM1OiIxODkyMTdjOGIwNjdlZjg2YWRkNzU3OTIyYzJmNzViNE85NCI7czozNzoiL3dwLWluY2x1ZGVzL2pzL3RoaWNrYm94L3RoaWNrYm94LmNzcyI7czozNzoiODA1YWExNTBhMzkxZTQ=ZTMyNDVmMjVlYTgzYmRmY2JPMjY1NSI7czozNjoiL3dwLWluY2x1ZGVzL2pzL3RoaWNrYm94L3RoaWNrYm94LmpzIjtzOjM4OiJkNWQyNDhhODczMDc1NDU4N2I=MjI=YzJkOWFkMzZjN=8xMzE2MyI7czo=NDoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvbGFuZ3Mvd3AtbGFuZ3MtZW4uanMiO3M6Mzg6IjA4Zjg2NjlmNzQ1M2IxNzU2M2E2MmU2YmJiMzc2MTM3TzE1NTk5IjtzOjM1OiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9saWNlbnNlLnR4dCI7czozODoiMDQ1ZDA=ZTE3NDIyZDk5ZTMzOGRhNzViOWM3NDliN2NPMjY=MjciO3M6NDk6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3BsdWdpbnMvY2hhcm1hcC9wbHVnaW4uanMiO3M6Mzg6ImQ5OTVhZWFlZjgxOTdjMjNjYjFlMTRlM2E=NzliYzAwTzExNTM2IjtzOjUzOiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9wbHVnaW5zL2NoYXJtYXAvcGx1Z2luLm1pbi5qcyI7czozNzoiYmM1YThjYzIxM2JiM2ZlNTFiNTY3M2I2NGRkOWQ=MDhPODE5OSI7czo1MzoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvcGx1Z2lucy9jb2xvcnBpY2tlci9wbHVnaW4uanMiO3M6Mzc6IjIyNTM4YzQ5ZjUyNDA1MGJkODMwMGI=NDUyNmFiYzJhTzI=NTAiO3M6NTc6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3BsdWdpbnMvY29sb3JwaWNrZXIvcGx1Z2luLm1pbi5qcyI7czozNzoiMTU4MWJiMDIyODZmNTRiNGZiMGNjZTUyZDJlZjYxYzdPMTIyMiI7czo1NToiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvcGx1Z2lucy9jb21wYXQzeC9jc3MvZGlhbG9nLmNzcyI7czozNzoiZTUzMTMxNjhmYjJiNjU3YTRiZDJmNWUwNmI5MzFhMjJPODAzMCI7czo1MDoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvcGx1Z2lucy9jb21wYXQzeC9wbHVnaW4uanMiO3M6Mzc6IjUyMTBjYzkxMzUzNDZkY2MxNWM5MjU4ZWFlNTU4NjhhTzgyODAiO3M6NTQ6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3BsdWdpbnMvY29tcGF=M3gvcGx1Z2luLm1pbi5qcyI7czozNzoiNTc5OGUzZDJmYjAxODBhOTE3OWI4YmQ3Y2Y3MjhlYWVPMzk4NyI7czo1NjoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvcGx1Z2lucy9kaXJlY3Rpb25hbGl=eS9wbHVnaW4uanMiO3M6Mzc6IjVmMjEzODViMWY=NTEzNTY4ZDYxMWQ1OTUwNDBkMTQxTzE=NjUiO3M6NjA6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3BsdWdpbnMvZGlyZWN=aW9uYWxpdHkvcGx1Z2luLm1pbi5qcyI7czozNjoiNjBkZTU3MjUzY2E5MTQzYTZmMWU=YWZmMTBmYzM5ZDJPNzI2IjtzOjUyOiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9wbHVnaW5zL2Z1bGxzY3JlZW4vcGx1Z2luLmpzIjtzOjM3OiJhZTk4M2I5YTdhOGQwYWQ=M2NhZDVlZjVhZDg1YzFhYk8zNTg3IjtzOjU2OiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9wbHVnaW5zL2Z1bGxzY3JlZW4vcGx1Z2luLm1pbi5qcyI7czozNzoiYmExYWQ=YmM=M2UyYWE=MzY2MTMwN2E1NTk5YjQ4YzVPMTY4MCI7czo=NDoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvcGx1Z2lucy9oci9wbHVnaW4uanMiO3M6MzY6IjQyOGM5ZmI=N2E3YjgzZmEwNDQwYTE1ODg2ZDBiMTFhTzY=OCI7czo=ODoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvcGx1Z2lucy9oci9wbHVnaW4ubWluLmpzIjtzOjM2OiI1YzIzMjU1YWQyZDExZGIzZjcyYzMzYjY=OWYxMzg5YU8zMjIiO3M6NDc6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3BsdWdpbnMvaW1hZ2UvcGx1Z2luLmpzIjtzOjM4OiI=NTg=YWY5YmE4YzQzOTYwNGU=MTk5MTY4MTc2YTdiN=8xNjQ1NSI7czo1MToiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvcGx1Z2lucy9pbWFnZS9wbHVnaW4ubWluLmpzIjtzOjM3OiI1NTA2NWI=ZDkwMDY5MmQ=MzA4ZDk3ZTc5YTBmYTAyM=84NDIxIjtzOjQ3OiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9wbHVnaW5zL2xpc3RzL3BsdWdpbi5qcyI7czozODoiZWJiMDNlOTUxYmI4N2Y=YWE2OWExMzI4ZGEwODI1MjJPMjMxNjgiO3M6NTE6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3BsdWdpbnMvbGlzdHMvcGx1Z2luLm1pbi5qcyI7czozNzoiYzU2NDY3NDRlZGU3MDJiNjY4ZmIzMTQ1NjliMzdhNTFPOTcwNSI7czo1MzoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvcGx1Z2lucy9tZWRpYS9tb3hpZXBsYXllci5zd2YiO3M6Mzg6IjRlNTlkMzRlZmIyZGEwYjlhMDMzNTk2YTg1ZTRiMWVmTzIwMDE3IjtzOjQ3OiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9wbHVnaW5zL21lZGlhL3BsdWdpbi5qcyI7czozODoiMDk2NmRhNDg3NDliNmUwODkwMTRhMzc4MmMzMjk5OTlPMjIyOTgiO3M6NTE6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3BsdWdpbnMvbWVkaWEvcGx1Z2luLm1pbi5qcyI7czozODoiYjE1YjBmZWRmNDA=MzY5NjQ4MjJkNGMyMjVlMzZiZGJPMTE2OTYiO3M6NDc6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3BsdWdpbnMvcGFzdGUvcGx1Z2luLmpzIjtzOjM4OiI2YTY1ZjM=NWM5MmUxYjNiMmM1MmUzMjNhNzM5YTAzZk81MjE4NCI7czo1MToiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvcGx1Z2lucy9wYXN=ZS9wbHVnaW4ubWluLmpzIjtzOjM4OiI2OWE2NTkyNzQ2NmRhYjgzNGY1ZDQ4YzI4YzhjMjNiYk8xNzU2MyI7czo1MDoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvcGx1Z2lucy9=YWJmb2N1cy9wbHVnaW4uanMiO3M6Mzc6IjZhNWQ3ODRjMmFjMmNlNWY2NGUwOTY4YzM1NDkyZjAzTzI1MDUiO3M6NTQ6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3BsdWdpbnMvdGFiZm9jdXMvcGx1Z2luLm1pbi5qcyI7czozNzoiZjE5N2NkOTNiMjgyMTA5MjNlMzU5MGM=NDM4ZWI4OTZPMTI3MCI7czo1MToiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvcGx1Z2lucy9=ZXh=Y29sb3IvcGx1Z2luLmpzIjtzOjM3OiI1MjcyYTk5NTE2YzQ2Nzc3MWVmMzA3NjQyMmJlYjE4Zk83MTg5IjtzOjU1OiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9wbHVnaW5zL3RleHRjb2xvci9wbHVnaW4ubWluLmpzIjtzOjM3OiI2OGM5OWI5Y2VhY2Y5MWI=ZTNjM2I=NzFiYTM=OWNmMk8=MTQ1IjtzOjUxOiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9wbHVnaW5zL3dvcmRwcmVzcy9wbHVnaW4uanMiO3M6Mzg6ImRiNzYyNjk1ZmQ1YThkNzY5YjZhNjAwMjQ1MWRiMmJjTzI5MTE2IjtzOjU1OiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9wbHVnaW5zL3dvcmRwcmVzcy9wbHVnaW4ubWluLmpzIjtzOjM4OiIyMGMyYWM2ZGM2NTQ2NDE5MjQ1NjYwNmRhZTA2ZWFlNE8xNDg4MSI7czo1NDoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvcGx1Z2lucy93cGF1dG9yZXNpemUvcGx1Z2luLmpzIjtzOjM3OiI2NDBjYmMwMDU4NjM4YzRmYjA=MDAzNzBkYmNmMjVhM=81OTY2IjtzOjU4OiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9wbHVnaW5zL3dwYXV=b3Jlc2l6ZS9wbHVnaW4ubWluLmpzIjtzOjM3OiI4NjA3ZTg3ZGNiYjM1MWQwNjdkMWE1NDQ4NWU4YTM1N=8yMzk5IjtzOjUxOiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9wbHVnaW5zL3dwZGlhbG9ncy9wbHVnaW4uanMiO3M6Mzc6IjA2ZjdhZWNiNWJkZmEyODczOWVlYTBhNDk4ZDE1YTgxTzI=MzYiO3M6NTU6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3BsdWdpbnMvd3BkaWFsb2dzL3BsdWdpbi5taW4uanMiO3M6Mzc6ImVhZmJiMTQ3ODk4MWUzMzc5ODFkMjg3NDc=ZTI=MGI4TzEzNDUiO3M6NTM6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3BsdWdpbnMvd3BlZGl=aW1hZ2UvcGx1Z2luLmpzIjtzOjM4OiI=NzM4YjgyNjFhZThiMTFkYTcxZDEwYmU1NmMyNTgwN=8zMTA2MyI7czo1NzoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvcGx1Z2lucy93cGVkaXRpbWFnZS9wbHVnaW4ubWluLmpzIjtzOjM4OiJlYWEyMDg4NTFiNjYwODU2MjA3NzljYmYzZDMwZmVmYk8xNTA=NSI7czo=OToiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvcGx1Z2lucy93cGVtYmVkL3BsdWdpbi5qcyI7czozNjoiY2YzODJhZjU1MjJmYTlhMGJiM2YwNDkyMjVkZTE=ZWZPNDQ=IjtzOjUzOiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9wbHVnaW5zL3dwZW1iZWQvcGx1Z2luLm1pbi5qcyI7czozNjoiN2VjNDViY2JlOTkyYzc=YzA5NWE3NWJiMmQyY2YwZmZPMjgwIjtzOjQ5OiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9wbHVnaW5zL3dwZW1vamkvcGx1Z2luLmpzIjtzOjM3OiJmNzdhNjEzMWMxNTA2NTNkZGZhMTdhNTY4YTE5NjJkME8zNTQ2IjtzOjUzOiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9wbHVnaW5zL3dwZW1vamkvcGx1Z2luLm1pbi5qcyI7czozNzoiYzZjYzJjZTQ4NDJjZjM=NDk=YjIwODU1NDE4ZWM3ZWVPMTU2NCI7czo1MToiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvcGx1Z2lucy93cGdhbGxlcnkvcGx1Z2luLmpzIjtzOjM3OiI5ZDQ4MzQ1MDQ=ZTYxMTFmYmViOWQyZmI=NDRkNWM=OU8zMTgwIjtzOjU1OiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9wbHVnaW5zL3dwZ2FsbGVyeS9wbHVnaW4ubWluLmpzIjtzOjM3OiIwNGZiMzc2MDhlZjk=ZjlhNzQ3OTAxYjJmOThiNGZjZU8xNjYxIjtzOjQ4OiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9wbHVnaW5zL3dwbGluay9wbHVnaW4uanMiO3M6Mzg6IjViZDZkOWRjZGZhNjQzMDlhNGY=NzRlM2MxMDNjODdkTzE3NzU2IjtzOjUyOiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9wbHVnaW5zL3dwbGluay9wbHVnaW4ubWluLmpzIjtzOjM3OiI5YTY1YzZmNjk3OWVmNzA=MDFiMGI5MTliMDJlODNlY=84ODgwIjtzOjU1OiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9wbHVnaW5zL3dwdGV4dHBhdHRlcm4vcGx1Z2luLmpzIjtzOjM3OiJiYmUzMTEwOWJiNGEyOTU1YWM3M2MwYjBhYzFlOGQ4Y=84ODA2IjtzOjU5OiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9wbHVnaW5zL3dwdGV4dHBhdHRlcm4vcGx1Z2luLm1pbi5qcyI7czozNzoiYTkyZTQ1NjllOTI=NTA3NzZmMThlMGJiNmRkYWUxYjFPMzE2MiI7czo=ODoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvcGx1Z2lucy93cHZpZXcvcGx1Z2luLmpzIjtzOjM3OiIyNzM2MjMyNTZiYTM5ZWEyMmQ3NzA2ZTk=ZmE3YTcwNk81NjYzIjtzOjUyOiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9wbHVnaW5zL3dwdmlldy9wbHVnaW4ubWluLmpzIjtzOjM3OiIzNmNiY2JiMmY2MjViYjcyNmRmY2NkM2Y1YjQ3ZjI1M=8yNzAxIjtzOjYyOiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9za2lucy9saWdodGdyYXkvY29udGVudC5pbmxpbmUubWluLmNzcyI7czozNzoiOTY1MWMxMDgzOGE3N2ZiNGNjYTkwMGI=N2Q5ZDMzMWNPMjY3NiI7czo1NToiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2Uvc2tpbnMvbGlnaHRncmF5L2NvbnRlbnQubWluLmNzcyI7czozNzoiYTEyMDdiNDMyMTI3ZGRjMGMzODNhY2ZiNzExYjVhNzhPMzA5MSI7czo1NToiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2Uvc2tpbnMvbGlnaHRncmF5L2ZvbnRzL3JlYWRtZS5tZCI7czozNToiN2EwZjY=ODAwY2YzOGIyYmU4ZDNkYzQ1NDBlYzMxZGRPNjciO3M6NjM6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3NraW5zL2xpZ2h=Z3JheS9mb25=cy9=aW55bWNlLXNtYWxsLmVvdCI7czozNzoiMTJkMjZjMjg1YjcxZDc5MGY=YjBjOTQ=MjNlZjFmOTlPOTQ5MiI7czo2NDoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2Uvc2tpbnMvbGlnaHRncmF5L2ZvbnRzL3RpbnltY2Utc21hbGwuanNvbiI7czozODoiZmNmMWFiMGJiYWQ3ZDViZTExNWNhYzlmZmIzNjBhMmJPNDAyNzMiO3M6NjM6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3NraW5zL2xpZ2h=Z3JheS9mb25=cy9=aW55bWNlLXNtYWxsLnN2ZyI7czozODoiYTJhMWY3MzJjYzM=NzY=YzY4NGVkNTIxYzZmMzMyN2NPMjQ3MjciO3M6NjM6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3NraW5zL2xpZ2h=Z3JheS9mb25=cy9=aW55bWNlLXNtYWxsLnR=ZiI7czozNzoiMjg4MDY5NDBjNjQ3Y2Y2NzFiZWJmNGFlMDYzMGU1NzBPOTMwNCI7czo2NDoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2Uvc2tpbnMvbGlnaHRncmF5L2ZvbnRzL3RpbnltY2Utc21hbGwud29mZiI7czozNzoiN2UwYzg4ZjAyZGNhZjJmNzhjOTBiNGRjNzgyN2I3MDlPOTM4MCI7czo1NzoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2Uvc2tpbnMvbGlnaHRncmF5L2ZvbnRzL3RpbnltY2UuZW9=IjtzOjM4OiIyNDAzMTAwNjdhZmIzM2RmNjA2MzlkN2ZkMWZhMTMyZU8xNzI5MiI7czo1ODoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2Uvc2tpbnMvbGlnaHRncmF5L2ZvbnRzL3RpbnltY2UuanNvbiI7czozODoiODk5ZWZlMjJkNzlkZDBkNjc1YzEwNmEyNDJlMTg4NThPODc2NTQiO3M6NTc6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3NraW5zL2xpZ2h=Z3JheS9mb25=cy9=aW55bWNlLnN2ZyI7czozODoiZWRlODA4ZjZmMDQ2MDQ2ODFiMjVmODQzMDY5ZGUzNzlPNDUyMjYiO3M6NTc6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3NraW5zL2xpZ2h=Z3JheS9mb25=cy9=aW55bWNlLnR=ZiI7czozODoiMWZiMjUwYzNiOWJjMzRmZDUzY2Q4ODMwNzBlM2RmZmRPMTcxMjgiO3M6NTg6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3NraW5zL2xpZ2h=Z3JheS9mb25=cy9=aW55bWNlLndvZmYiO3M6Mzg6IjZiMGMzNzU=YjFjZDFmOTA1NjZlMTc=MDk4ZmFlOGY4TzE3MjA=IjtzOjU=OiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9za2lucy9saWdodGdyYXkvaW1nL2FuY2hvci5naWYiO3M6MzU6ImFiZDM2MTM1NzE4MDBmZGNjODkxMTgxZDVmMzRmODQwTzUzIjtzOjU=OiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9za2lucy9saWdodGdyYXkvaW1nL2xvYWRlci5naWYiO3M6Mzc6IjM5NGJhZmMzY2M=ZGZiM2EwZWU=OGMxZjU=NjY5NTM5TzI2MDgiO3M6NTQ6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3NraW5zL2xpZ2h=Z3JheS9pbWcvb2JqZWN=LmdpZiI7czozNjoiZjM3MjY=NTBkNzQ1N2Q3NTBhMmY=ZDk=NDFjN2VlMjBPMTUyIjtzOjUzOiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9za2lucy9saWdodGdyYXkvaW1nL3RyYW5zLmdpZiI7czozNToiMTJiZjllMTkzNzQ5MjBkZTMxNDZhNjQ3NzVmNDZhNWVPNDMiO3M6NTY6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3NraW5zL2xpZ2h=Z3JheS9za2luLmllNy5taW4uY3NzIjtzOjM4OiIxYWI2OGEwYzk1ZjI1MDE4OTMyM2I5ODZhNzA3ZjcwYU8zMzIwMSI7czo1MjoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2Uvc2tpbnMvbGlnaHRncmF5L3NraW4ubWluLmNzcyI7czozODoiMzY1ZGM1NTZiOTcwYWJmZTI4NDBlODE3MTg2Y2RmNDJPMzUzMjEiO3M6NTY6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3NraW5zL3dvcmRwcmVzcy9pbWFnZXMvYXVkaW8ucG5nIjtzOjM2OiIzNzdlMjFlNmRmZTAwMDhlZjdjNmQ=ZmQyMjA4NzcwYk8=MTIiO3M6NjQ6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3NraW5zL3dvcmRwcmVzcy9pbWFnZXMvZGFzaGljb24tZWRpdC5wbmciO3M6MzY6Ijc4NTJkZTA5YWM1OWI1NTg5ZWQ=ZGJkZGE=ZTRkZWU2TzM2OCI7czo2MjoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2Uvc2tpbnMvd29yZHByZXNzL2ltYWdlcy9kYXNoaWNvbi1uby5wbmciO3M6MzY6IjUyZDBjMDhmZTQ1YWNhM2Y2NjJlODFjNzM4ZjVlMjA5TzMzOSI7czo1OToiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2Uvc2tpbnMvd29yZHByZXNzL2ltYWdlcy9lbWJlZGRlZC5wbmciO3M6Mzc6ImY1OGRhYWEwNzBkZDRlYTIxYmQ2NzkwZjdlYzM2ZTIyTzgxNzciO3M6NjE6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3NraW5zL3dvcmRwcmVzcy9pbWFnZXMvZ2FsbGVyeS=yeC5wbmciO3M6MzY6IjFlY2FlZTMxZWMwMjlkZWQwZTE4ZjU3Njk1OGE1MjE=TzQ=NyI7czo1ODoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2Uvc2tpbnMvd29yZHByZXNzL2ltYWdlcy9nYWxsZXJ5LnBuZyI7czozNjoiYTEwNjVmYjE5ZjhjMTA1MDc3ZjliNDUwMTA1NWRiMzRPMzc5IjtzOjU4OiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9za2lucy93b3JkcHJlc3MvaW1hZ2VzL21vcmUtMngucG5nIjtzOjM2OiI2YzJjZDcwYjFjODk3MmNmMjViODVlMWU3OGE1MjUxZU82MDMiO3M6NTU6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3NraW5zL3dvcmRwcmVzcy9pbWFnZXMvbW9yZS5wbmciO3M6MzY6ImZjYjdiY2Q=MGFiYzBhNmQwMDNiZmMwZmNiYWJlNjdhTzQxNCI7czo2MzoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2Uvc2tpbnMvd29yZHByZXNzL2ltYWdlcy9wYWdlYnJlYWstMngucG5nIjtzOjM2OiI3YmNlMzZiZjIzNTU1MTNhZjc5MTdjMTkzZTIzZWJkNk84MzUiO3M6NjA6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3NraW5zL3dvcmRwcmVzcy9pbWFnZXMvcGFnZWJyZWFrLnBuZyI7czozNzoiZTQ=OWUzZGE2ZGM1MWY4NWZjNGM1NzExNzlkZDkzNDhPMTE=MCI7czo2NToiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2Uvc2tpbnMvd29yZHByZXNzL2ltYWdlcy9wbGF5bGlzdC1hdWRpby5wbmciO3M6MzY6IjU1MmNmYjNhMjlhYzAxYTBkODhiMDQyMmM1NTE3MTU5TzQ=MCI7czo2NToiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2Uvc2tpbnMvd29yZHByZXNzL2ltYWdlcy9wbGF5bGlzdC12aWRlby5wbmciO3M6MzY6ImE1NmM3YTU2MzY2MDc3NmQ1YTQyMWM3MzBiOGRjZmQ2TzI5MCI7czo1NjoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2Uvc2tpbnMvd29yZHByZXNzL2ltYWdlcy92aWRlby5wbmciO3M6MzY6ImQwYzJiNmY3YTA=MmE5M2QwZDdhYmIxZTgzMzM2YWMxTzM2MyI7czo1NDoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2Uvc2tpbnMvd29yZHByZXNzL3dwLWNvbnRlbnQuY3NzIjtzOjM3OiI3ODUzMmI1ZjFmZWRhOTE3Y2EzMWRjMTI=MTIyMDM2YU84MDM2IjtzOjQ2OiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9=aGVtZXMvaW5saXRlL3RoZW1lLmpzIjtzOjM4OiJmYjE=Njk4YTM2MGQ1YTNkNzg1NzM5NzEwNGZjNTU2Y=8=NTA3OSI7czo1MDoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvdGhlbWVzL2lubGl=ZS9=aGVtZS5taW4uanMiO3M6Mzg6ImNjODhmMzM2OTk5Mzk3ZDM4M2I1ZmE=MzQyOTRhMjU4TzE2MzMxIjtzOjQ2OiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS9=aGVtZXMvbW9kZXJuL3RoZW1lLmpzIjtzOjM4OiJkNTAyYTZhYzI4YmI=OGE3ZDkxYTg5YmE5YjU3MTBjME8yMzAzMSI7czo1MDoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvdGhlbWVzL21vZGVybi9=aGVtZS5taW4uanMiO3M6Mzc6ImUzYjdjZWMyOGNhZDVjYWE1ZmNiY2MyYTE1Y2ViYWU3Tzk5MzQiO3M6Mzg6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3RpbnltY2UubWluLmpzIjtzOjM5OiJiYjE2NTIwYTAyMWFlMTcwYTcwMTk2NzVmMmY1ZjgxZk8zODUwODEiO3M6NDE6Ii93cC1pbmNsdWRlcy9qcy9=aW55bWNlL3RpbnlfbWNlX3BvcHVwLmpzIjtzOjM4OiJkYmU2MjA4MjQyMmI3NWQ4OWVjYjk4MzQwOWVjOTY2ZE8xNTA5MSI7czo=OToiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvdXRpbHMvZWRpdGFibGVfc2VsZWN=cy5qcyI7czozNzoiZWI2NDJhMGFiYTdhODY2NmE3YjE=NzIyMzBmY2IzNzRPMTk4MyI7czo=MzoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvdXRpbHMvZm9ybV91dGlscy5qcyI7czozNzoiZjljNjEzNTQzODNmNWE1MGE5YTc3YjkwMmRmZGFlN2ZPNTc5MiI7czozOToiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2UvdXRpbHMvbWN=YWJzLmpzIjtzOjM3OiJiOWI1MGRkYmUwN2M3NTRhNmI2NTZiMGZkYWRhMzUwME8zOTQwIjtzOjQxOiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS91dGlscy92YWxpZGF=ZS5qcyI7czozNzoiYzQyYjUxNjBiZGJlZmQxMjkzZDc2YjMwNTIwNzU3ZjRPNTg1MCI7czo=MDoiL3dwLWluY2x1ZGVzL2pzL3RpbnltY2Uvd3AtdGlueW1jZS5qcy5neiI7czozOToiOWIzN2VlYTQ3MjE3MWRiZTUyYWNlYjkwOWI4MWMyOTJPMTcxODQ4IjtzOjM4OiIvd3AtaW5jbHVkZXMvanMvdGlueW1jZS93cC1=aW55bWNlLnBocCI7czozNzoiOGE2MjBhYjgxZGM3MzA3ZjcwNzJiMWQzMTI5MjQ4NzZPMTEyNiI7czoyNjoiL3dwLWluY2x1ZGVzL2pzL3R3LXNhY2suanMiO3M6Mzc6ImI5ODlhNWJkODRmNmViY2JjMTM5M2VjMDAzZTZlOTkxTzQ5NjkiO3M6MzA6Ii93cC1pbmNsdWRlcy9qcy9=dy1zYWNrLm1pbi5qcyI7czozNzoiYmM=NDg3MTk=ZTFmODgxMjZiOGE1MDBhZDQ3ZTY4ODlPMzI4MyI7czoyNjoiL3dwLWluY2x1ZGVzL2pzL3R3ZW1vamkuanMiO3M6Mzg6ImJlMmY2YjgwZDAzMDc4NTdhODNkMGIxN2I5ZjI=ZDJkTzI1MDk4IjtzOjMwOiIvd3AtaW5jbHVkZXMvanMvdHdlbW9qaS5taW4uanMiO3M6Mzc6IjQ2N2VmNTRiZmYxMDg1MWEwNDA2NGVlYmM5ODM3ZDUyTzg1MDYiO3M6MzM6Ii93cC1pbmNsdWRlcy9qcy91bmRlcnNjb3JlLm1pbi5qcyI7czozODoiNmEzYTQzNGExMzYwY2M3NDQzNDFlOTdkZTkxNzdiYzZPMTY=MTAiO3M6MjQ6Ii93cC1pbmNsdWRlcy9qcy91dGlscy5qcyI7czozNzoiMTllYTBkYTIxM2VkYTljN2JjNDM2MGYxZDRjMThiM2NPNDUyMCI7czoyODoiL3dwLWluY2x1ZGVzL2pzL3V=aWxzLm1pbi5qcyI7czozNzoiZjZlM2Q1NzIxN2RlNDFmYTMyNDMzMzExNTU=NTJiYjFPMTgyNSI7czoyNjoiL3dwLWluY2x1ZGVzL2pzL3dwLWExMXkuanMiO3M6Mzc6IjIwMWE3MjAyMjczNzgyODAwODFmNjc4MDlkNzgxYWIyTzIxODgiO3M6MzA6Ii93cC1pbmNsdWRlcy9qcy93cC1hMTF5Lm1pbi5qcyI7czozNjoiZmFkZDc=NmNkZGRhYWZiOTk3OGNiYWIyZTRlNDU4MGZPNjI1IjtzOjM1OiIvd3AtaW5jbHVkZXMvanMvd3AtYWpheC1yZXNwb25zZS5qcyI7czozNzoiYzQwNGQyZWJhYjI5YTc2ZTVhNGVlZjBhMjNjM2ViMTBPMzEzNSI7czozOToiL3dwLWluY2x1ZGVzL2pzL3dwLWFqYXgtcmVzcG9uc2UubWluLmpzIjtzOjM3OiJkMzc=OTdkOGFjOWNjOTFlYWNjOTFiNzZjYmZmMzBjY=8yMDgxIjtzOjI1OiIvd3AtaW5jbHVkZXMvanMvd3AtYXBpLmpzIjtzOjM4OiI=Y2NhMTUwMGU2MWJkNDBhYmU3YjU=M2ZkNzZhNWEwNk8=MDk=OCI7czoyOToiL3dwLWluY2x1ZGVzL2pzL3dwLWFwaS5taW4uanMiO3M6Mzg6IjE=NmIxNGU4Yzc5MzVkOGJkMTRlYjUyMWZiNjE2YTVlTzEyNzYxIjtzOjMyOiIvd3AtaW5jbHVkZXMvanMvd3AtYXV=aC1jaGVjay5qcyI7czozNzoiOTk1MDBkZDU=YWRjNzY3NjllMWE3OThhOTcyNWQ3NjVPMzMwNiI7czozNjoiL3dwLWluY2x1ZGVzL2pzL3dwLWF1dGgtY2hlY2subWluLmpzIjtzOjM3OiI5OWM5N2E3ZDZhZDllMWJhMDZiYmQ3NmYyOWVjYWFkNk8xNzgzIjtzOjMwOiIvd3AtaW5jbHVkZXMvanMvd3AtYmFja2JvbmUuanMiO3M6Mzg6ImZmMDhhOTFlYmE3ZjRmYjk1YmU3ZDVlYjRhMDcyZDc2TzEwNDI3IjtzOjM=OiIvd3AtaW5jbHVkZXMvanMvd3AtYmFja2JvbmUubWluLmpzIjtzOjM3OiJiOTc4ZDNjMjBhMjVjYTFkMzZjMTY4OGMyOThjODIzOU8zMDIwIjtzOjM1OiIvd3AtaW5jbHVkZXMvanMvd3AtY3VzdG9tLWhlYWRlci5qcyI7czozODoiNmU2MjU1MWQ1MzVkYzNiMDA3ODcwZTg5Zjg4MWVlMjFPMTAyMjAiO3M6Mzk6Ii93cC1pbmNsdWRlcy9qcy93cC1jdXN=b2=taGVhZGVyLm1pbi5qcyI7czozNzoiODAyYmVlMGU1ZjYwMDQ4M2UwMjQ3ZjU5YjNiMzI5YjRPNDQ2MiI7czozNjoiL3dwLWluY2x1ZGVzL2pzL3dwLWVtYmVkLXRlbXBsYXRlLmpzIjtzOjM3OiJkNmMzZmIwNDlmNjU3OTI4ZWFjMmNkOWM3ZWVmNjkyNU82MTkwIjtzOjQwOiIvd3AtaW5jbHVkZXMvanMvd3AtZW1iZWQtdGVtcGxhdGUubWluLmpzIjtzOjM3OiJjMDVkNjc4YTgxOTdhNzJjNGE=NGJmNTQwMDE3Mjc4YU8zMTE3IjtzOjI3OiIvd3AtaW5jbHVkZXMvanMvd3AtZW1iZWQuanMiO3M6Mzc6ImI4ZDk=YTY2NDhjN2E3MGMwNDk2MjU3YmIyNjk5NTk5TzMxMTkiO3M6MzE6Ii93cC1pbmNsdWRlcy9qcy93cC1lbWJlZC5taW4uanMiO3M6Mzc6IjVhMDNmOTdjYzQ3OWI5ZjVkN2VmZGFjY2VjMzFiYzE3TzEzOTgiO3M6MzQ6Ii93cC1pbmNsdWRlcy9qcy93cC1lbW9qaS1sb2FkZXIuanMiO3M6Mzc6IjFlMzQ3OTdjYjQxNjllMDUzZTZkNTI2Mjk=OTIxZDY2TzUwNTAiO3M6Mzg6Ii93cC1pbmNsdWRlcy9qcy93cC1lbW9qaS1sb2FkZXIubWluLmpzIjtzOjM3OiJmM2VjMjE5MDRjYzBjZjVkODk5ZjI5ZTM1YjBiNDYxMk8xNzQwIjtzOjM5OiIvd3AtaW5jbHVkZXMvanMvd3AtZW1vamktcmVsZWFzZS5taW4uanMiO3M6Mzg6ImNiNjI4NGI3MGRhMDNhNDM=NjgyNDRiZTdlYWZhMzYyTzExNDE=IjtzOjI3OiIvd3AtaW5jbHVkZXMvanMvd3AtZW1vamkuanMiO3M6Mzc6ImRkYzQ5YWQwZTRiMTQ2Y2M4ZmY3M2Q5NzZmMTI5OGJiTzY3NjAiO3M6MzE6Ii93cC1pbmNsdWRlcy9qcy93cC1lbW9qaS5taW4uanMiO3M6Mzc6IjFhY2RkMGNkNTIzNjk1YmQ5MjBjY2M=MThiMDY3OGM5TzI4MjQiO3M6MzY6Ii93cC1pbmNsdWRlcy9qcy93cC1saXN=LXJldmlzaW9ucy5qcyI7czozNjoiNDc1MTBkNzU2MGQyMmE5NzRjOGMwZWVjNmUyNGJjYmRPOTE=IjtzOjQwOiIvd3AtaW5jbHVkZXMvanMvd3AtbGlzdC1yZXZpc2lvbnMubWluLmpzIjtzOjM2OiJkMjUyZjQzMWQ=MDBiNjk2ZTI1Y2E5ZmVjOWExMTEzZU81NjkiO3M6Mjc6Ii93cC1pbmNsdWRlcy9qcy93cC1saXN=cy5qcyI7czozODoiYTNhZDRmMDgwYmQ2MWRhMmI5ZjJmOTM5MGIxNTMzZDFPMjUyMzUiO3M6MzE6Ii93cC1pbmNsdWRlcy9qcy93cC1saXN=cy5taW4uanMiO3M6Mzc6IjdkZjE4YjQyY2JkNWNiYWE1MDY3YzA2ZjU3YWE4NzZiTzc=MTMiO3M6Mjk6Ii93cC1pbmNsdWRlcy9qcy93cC1wb2ludGVyLmpzIjtzOjM3OiIzNWNiOGIzODBiYmQxZjJlYWE3MjNhYzQ5YmE1ZjNmME82NjA5IjtzOjMzOiIvd3AtaW5jbHVkZXMvanMvd3AtcG9pbnRlci5taW4uanMiO3M6Mzc6IjM2OGY5ODdjNjQ=ZDcwNTgwMDk3ZTQ4MDY2Yzk5MDgyTzM2MzkiO3M6MjY6Ii93cC1pbmNsdWRlcy9qcy93cC11dGlsLmpzIjtzOjM3OiI5MWMzMjI3NTBiYzgwZjFjYWNmZDRmOTkxZTY1YTQxNU8zOTAwIjtzOjMwOiIvd3AtaW5jbHVkZXMvanMvd3AtdXRpbC5taW4uanMiO3M6Mzc6IjgzMTE4YWE5MzliNTgzMmRkNGUxY2FkOGIxODYwMTJjTzEwNDYiO3M6Mjc6Ii93cC1pbmNsdWRlcy9qcy93cGRpYWxvZy5qcyI7czozNjoiNzJlODM5NWZkNDRkNDAzOTAwOWM1Mzk2ODg4ZmE2YmFPNDM1IjtzOjMxOiIvd3AtaW5jbHVkZXMvanMvd3BkaWFsb2cubWluLmpzIjtzOjM2OiJkMjJkOWZhNWJiMDBiYTA2NjcwODBkYTg=NmM=YTFiZU8yMzciO3M6MjU6Ii93cC1pbmNsdWRlcy9qcy93cGxpbmsuanMiO3M6Mzg6ImY5NTU4NDA3NjNjZWMwNTA2NGFmNjhjMzUwNWZjOThhTzIwNTU1IjtzOjI5OiIvd3AtaW5jbHVkZXMvanMvd3BsaW5rLm1pbi5qcyI7czozODoiNTliNGI=NmZmZTE=NjM3MWFhZTlmY2M1MGM3ZTE5MzBPMTEwNDkiO3M6MzE6Ii93cC1pbmNsdWRlcy9qcy96eGN2Ym4tYXN5bmMuanMiO3M6MzY6Ijk3YTc5ZTk2YTgxNWIyMDAxMzkzNTYwNTVkNzUyMzMzTzUwMiI7czozNToiL3dwLWluY2x1ZGVzL2pzL3p4Y3Zibi1hc3luYy5taW4uanMiO3M6MzY6IjMxOTZlOWI2MWY3MDM5MDllMTM5Y2U3ZTA=OWE3ZmZkTzMyNCI7czoyOToiL3dwLWluY2x1ZGVzL2pzL3p4Y3Zibi5taW4uanMiO3M6Mzk6ImExNGNkNTExM2JkMGQ1NzU2M2MxYTliNjNjYWUwNWY4TzY5ODcyOCI7czoyMToiL3dwLWluY2x1ZGVzL2tzZXMucGhwIjtzOjM4OiJhNWI=NzIzMDRlNjc5MWE2ODk4OThiMzUzY2E3ZGRjOU81MDExNiI7czoyMToiL3dwLWluY2x1ZGVzL2wxMG4ucGhwIjtzOjM4OiI2ODY=Y2NjYTdkMWExZmQ4MTVmNTQ=MmM3NmE=ZjczZE8=MzEzMCI7czozMDoiL3dwLWluY2x1ZGVzL2xpbmstdGVtcGxhdGUucGhwIjtzOjM5OiI1OTJhYmE2NzBkZGMyNTA4YjRlOTljNjY5M2RiYzM=OU8xMzUwMDgiO3M6MjE6Ii93cC1pbmNsdWRlcy9sb2FkLnBocCI7czozODoiYzdmM2Q1M2Q4NTRiMmM=OWI4ZDFiZmU1YTFiMmRkZjlPMzEzOTQiO3M6MjM6Ii93cC1pbmNsdWRlcy9sb2NhbGUucGhwIjtzOjM2OiI1ZmFjM2YzZTZlNTllMmJhNzgxNTQ2ZTBlMjg3ZjFhZU8xNDEiO3M6MzE6Ii93cC1pbmNsdWRlcy9tZWRpYS1=ZW1wbGF=ZS5waHAiO3M6Mzg6IjM=NjM3OTViNGQwMDY=MzZlMDU3NWNlZGVhNjE=NjZjTzQ1OTgwIjtzOjIyOiIvd3AtaW5jbHVkZXMvbWVkaWEucGhwIjtzOjM5OiI4NGQzMjk1NDZiOWIxNjI3NjI5NmVlOGY4ZDQxNTgyM=8xMzM5NTIiO3M6MjE6Ii93cC1pbmNsdWRlcy9tZXRhLnBocCI7czozODoiNTZkYTg3ODNmN2EzZGFjYmM=YjA=YzRkNzc4NjdkYTNPMzczMjEiO3M6MjU6Ii93cC1pbmNsdWRlcy9tcy1ibG9ncy5waHAiO3M6Mzg6IjhmMWY2NTYyMjEzNTRjNzBjYjljM2Q2MmMyZWU3MjI4TzM3MTg=IjtzOjM3OiIvd3AtaW5jbHVkZXMvbXMtZGVmYXVsdC1jb25zdGFudHMucGhwIjtzOjM3OiJiNGUyZDQ=MWJlZDNmZDU5MjQ2ZjlkOGQ=ZGY3Njk3N=8=NzU2IjtzOjM1OiIvd3AtaW5jbHVkZXMvbXMtZGVmYXVsdC1maWx=ZXJzLnBocCI7czozNzoiYzU2NmI1NzIyZWYzNGNkYmU3NWNiMGU4OTI4MGMwNjlPNDQ2OSI7czozMDoiL3dwLWluY2x1ZGVzL21zLWRlcHJlY2F=ZWQucGhwIjtzOjM4OiJkY2YwYTQ1Njc3NjhjNzRmMmY1MDM4ZWJlZTQ5NjdiY=8xNDY5MSI7czoyNToiL3dwLWluY2x1ZGVzL21zLWZpbGVzLnBocCI7czozNzoiNmU1MTkyZTllM2JmYmViZWRjMTNjNjJkYjFmOWEwMTNPMjYyMCI7czoyOToiL3dwLWluY2x1ZGVzL21zLWZ1bmN=aW9ucy5waHAiO3M6Mzg6ImI=NmYyZTYyN2VkMTBlYmFjZGE1YmViOTNkNzg=OGY2Tzc4NzI2IjtzOjI=OiIvd3AtaW5jbHVkZXMvbXMtbG9hZC5waHAiO3M6Mzg6IjZlY2VlOTk3ZGMzNDY=NzQzOWM5Nzg2MjdjYWU=ZjNkTzE5ODQ4IjtzOjI4OiIvd3AtaW5jbHVkZXMvbXMtc2V=dGluZ3MucGhwIjtzOjM3OiIzZmMxN2Q=ZjlhNzgyNjZlNDFjYzYyNjFlMmU4MDE4OE8zNDIxIjtzOjM=OiIvd3AtaW5jbHVkZXMvbmF2LW1lbnUtdGVtcGxhdGUucGhwIjtzOjM4OiI3ZDc2ODMzYWNhYTRkMzhiZTQxNjBiMGQwZjA2MGYzOE8yMDMyMyI7czoyNToiL3dwLWluY2x1ZGVzL25hdi1tZW51LnBocCI7czozODoiMWQwMDZiZGUwMmJlMTUxNjNlZDQ4MGZlMzg5ZjQ3NzhPMzIzMzAiO3M6MjM6Ii93cC1pbmNsdWRlcy9vcHRpb24ucGhwIjtzOjM4OiJhZmJjYjlmMTk3YTRhM2FjYmVjZTQyNzMyODdmZWE2Nk82Mzc4NyI7czozNzoiL3dwLWluY2x1ZGVzL3BsdWdnYWJsZS1kZXByZWNhdGVkLnBocCI7czozNzoiZTQ2M2IxODc2NGY5YTkwMGNjZmU3ZWI3MzU2YTEyYzNPNjI2MiI7czoyNjoiL3dwLWluY2x1ZGVzL3BsdWdnYWJsZS5waHAiO3M6Mzg6IjE4YTA4MjM3M2YxMTM=ZWFlZjJiMmZkNTg1Nzg2OTc3Tzg2NDM1IjtzOjIzOiIvd3AtaW5jbHVkZXMvcGx1Z2luLnBocCI7czozODoiN2FmNWRiNDZhOTc4YWM5MTNmODQ4MjEwOGQ=ZWM=YTJPMzEyODIiO3M6Mjc6Ii93cC1pbmNsdWRlcy9wb21vL2VudHJ5LnBocCI7czozNzoiZWQ5ZDgxMWVmMGNiMTNiZGMwZmE2MGI4MzE=YzhkNjFPMjg4NyI7czoyNDoiL3dwLWluY2x1ZGVzL3BvbW8vbW8ucGhwIjtzOjM3OiIxYWU5Nzk=Y2U5Y2E4NDU1MmU1ZTdhMzMyZjE2OGY2NU84NDYyIjtzOjI=OiIvd3AtaW5jbHVkZXMvcG9tby9wby5waHAiO3M6Mzg6IjBhZDgwNTNiMTlmYzIzNTYxNWUxNTY5Yjk3N2M2ZmM2TzEzMjE5IjtzOjI5OiIvd3AtaW5jbHVkZXMvcG9tby9zdHJlYW1zLnBocCI7czozNzoiYmVhYzczYTE3Y2M=MWQyZDEzOGQzYzY5ZjE5NjcwODBPNTk=OCI7czozNDoiL3dwLWluY2x1ZGVzL3BvbW8vdHJhbnNsYXRpb25zLnBocCI7czozNzoiZDFmMzFiNTRmOTM4YzJlNTM2MWE5NTQyZmRiNTUyMTBPODc3OSI7czoyOToiL3dwLWluY2x1ZGVzL3Bvc3QtZm9ybWF=cy5waHAiO3M6Mzc6IjgyNGFlMjUyZjFkNjkzNGMxNzJhNTEyOTNlMWJjZmRkTzY5NTEiO3M6MzA6Ii93cC1pbmNsdWRlcy9wb3N=LXRlbXBsYXRlLnBocCI7czozODoiYzY5Yjc3YmFlYTg5NmZkM2FjNGRjYWEzZWE2NDI3YTVPNTgzNTMiO3M6NDA6Ii93cC1pbmNsdWRlcy9wb3N=LXRodW1ibmFpbC1=ZW1wbGF=ZS5waHAiO3M6Mzc6ImNkMGQyZmNmMjJkMmQ4YTZlMDhhYzM3NTlmZmQzYmJjTzgxMDQiO3M6MjE6Ii93cC1pbmNsdWRlcy9wb3N=LnBocCI7czozOToiNGYzZGExNTJhYmFhYzZjMTQ1NjYxOWEyZDA3OTZkMTdPMjExMjIzIjtzOjIyOiIvd3AtaW5jbHVkZXMvcXVlcnkucGhwIjtzOjM4OiIzMTg2YTU5YWY1YzA5M2YwNGNkZDhlM2FiYTVjODFkZk8yMzQ3NCI7czo=ODoiL3dwLWluY2x1ZGVzL3JhbmRvbV9jb21wYXQvYnl=ZV9zYWZlX3N=cmluZ3MucGhwIjtzOjM3OiJmYzc1YzE4Yzk1ZDk3NGE5ZmRiMWIxMDFmNjZmNzk2OU81NjUxIjtzOjQyOiIvd3AtaW5jbHVkZXMvcmFuZG9tX2NvbXBhdC9jYXN=X3RvX2ludC5waHAiO3M6Mzc6ImZhNWY3Njc=NWFjMmQ2M2I5NDY2ZjEzMGQzNWM3ZmIxTzI=NjEiO3M6NDU6Ii93cC1pbmNsdWRlcy9yYW5kb21fY29tcGF=L2Vycm9yX3BvbHlmaWxsLnBocCI7czozNzoiYzI1OTU=ZTU3ZTFhZTMyNzIyZmE2Yzg=MGE1NTY1OGNPMTUzMyI7czozNzoiL3dwLWluY2x1ZGVzL3JhbmRvbV9jb21wYXQvcmFuZG9tLnBocCI7czozNzoiODc4NTk1ZTkxZWYxNDc3YzhjMzE1YjA4NWY3MzMxOWFPNzY5NCI7czo1NDoiL3dwLWluY2x1ZGVzL3JhbmRvbV9jb21wYXQvcmFuZG9tX2J5dGVzX2NvbV9kb3RuZXQucGhwIjtzOjM3OiIxZTY1NzJiZGUzNGM1NmNiYzQ3Mzc=NzIxY2UxOWVkZU8yNTQwIjtzOjU1OiIvd3AtaW5jbHVkZXMvcmFuZG9tX2NvbXBhdC9yYW5kb21fYnl=ZXNfZGV2X3VyYW5kb2=ucGhwIjtzOjM3OiI1MDNjMjFjYjNkYjAyZGVkNjZlMDFmZjg2MTQ=NjhiY=8=NTQzIjtzOjUzOiIvd3AtaW5jbHVkZXMvcmFuZG9tX2NvbXBhdC9yYW5kb21fYnl=ZXNfbGlic29kaXVtLnBocCI7czozNzoiODE4Yzg4YTRmODY2ZDQxN2ZhZGI3ZDE5MDdmN2FiM2VPMjU3NiI7czo2MDoiL3dwLWluY2x1ZGVzL3JhbmRvbV9jb21wYXQvcmFuZG9tX2J5dGVzX2xpYnNvZGl1bV9sZWdhY3kucGhwIjtzOjM3OiJmNDdlNDY5YTljMmRkZWU1MjZjYTM2MmM4N2UxODU1MU8yNTc2IjtzOjUwOiIvd3AtaW5jbHVkZXMvcmFuZG9tX2NvbXBhdC9yYW5kb21fYnl=ZXNfbWNyeXB=LnBocCI7czozNzoiMjU2Y2Y=ZTkzMTJmNzNjNTgwNmM4YjI5MTY3N2QyNjlPMjMwNiI7czo1MToiL3dwLWluY2x1ZGVzL3JhbmRvbV9jb21wYXQvcmFuZG9tX2J5dGVzX29wZW5zc2wucGhwIjtzOjM3OiJiMzY5NTY=YmZmYzc2ZDgyNDQ5NTI3OTMwYjYzOGRiYU8yNTc=IjtzOjQxOiIvd3AtaW5jbHVkZXMvcmFuZG9tX2NvbXBhdC9yYW5kb21faW5=LnBocCI7czozNzoiOTBlNmRhZjg1ZDZkMGQ2OTU2NjkyYmQ=OTAzM2VkMzhPNTY5NyI7czozOToiL3dwLWluY2x1ZGVzL3JlZ2lzdHJhdGlvbi1mdW5jdGlvbnMucGhwIjtzOjM2OiIxYzRiNjljYTRjZDliODUzODcxNGIyNDgzZDBlNTk5NU8xNzgiO3M6Mjk6Ii93cC1pbmNsdWRlcy9yZWdpc3RyYXRpb24ucGhwIjtzOjM2OiJkNGYzOWU5ODMzNjZlYTVjMWIzZmQ=NjQ=YjE5YWUwNk8xNzgiO3M6MzA6Ii93cC1pbmNsdWRlcy9SZXF1ZXN=cy9BdXRoLnBocCI7czozNjoiMzE5N2QyNTI5ZGQ5NTdiMmFjYzM5NDRmNWJmY2Q2NGFPODEwIjtzOjM2OiIvd3AtaW5jbHVkZXMvUmVxdWVzdHMvQXV=aC9CYXNpYy5waHAiO3M6Mzc6IjY3ZmRkODc4Y2M4NGRmMTUwOTM=NTVkNjA5NmIyMTQzTzE5NDEiO3M6MzI6Ii93cC1pbmNsdWRlcy9SZXF1ZXN=cy9Db29raWUucGhwIjtzOjM4OiJkMTlkNDNhZmU5OWJjNTI4ODEzMjJiOTI3OTYwYTRkM=8xMjg1NCI7czozNjoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=Nvb2tpZS9KYXIucGhwIjtzOjM3OiJlOTMwMGM1ZmIxZjUyNjcwYTBiNTIyMzRkOTVjOTUxME8zODE4IjtzOjM1OiIvd3AtaW5jbHVkZXMvUmVxdWVzdHMvRXhjZXB=aW9uLnBocCI7czozNzoiODc5YmFjOWVmYTE4MDA4NWFiMzNlOTBlMWFjYzUyNDlPMTAyNiI7czo=MDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLnBocCI7czozNzoiZThkNWZjNjhiM2M2ZmExNWU=NTI2YzE2MTE3MmRhZTVPMTQxOSI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzMwNC5waHAiO3M6MzY6ImQzM2I=NjM=Y2U=MTEzZGI=OWVmOWRkZGVkZjc1NGFiTzM5MCI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzMwNS5waHAiO3M6MzY6IjU4ZjhmNzAwOTA=YmViZTYyZjYwYTExYzJjZmJhYjI2TzM4MiI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzMwNi5waHAiO3M6MzY6IjU3NzM3YTA3MWZhMTc1NGU1MGRiNmFkY2M5ZjI1ODc1TzM5MSI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQwMC5waHAiO3M6MzY6IjUxZTU2ZTg3OGNiYjU2NGFiODUyYzk3OGZiMzVmY2QwTzM4NyI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQwMS5waHAiO3M6MzY6IjNiMmFiODBlYjljYmZkODdiYWEyM2ZjMTY=OGU5OTQwTzM5MCI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQwMi5waHAiO3M6MzY6IjYwZjg1OWQ1NTE1MGRhMGIwYTdhOTU5YWM5ZjM=N2Q2TzQwMiI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQwMy5waHAiO3M6MzY6ImJjZDE2MGU4ZjcwZGM3NmZmYmJmNmIzM2I3ZmUzMWRmTzM4MSI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQwNC5waHAiO3M6MzY6IjFlZDQxNmNjNjMxMTgzNTkwMDg1Nzk3M2Y4OTIzYzRkTzM4MSI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQwNS5waHAiO3M6MzY6ImRkMzhkMTgyZGU2ZDIxYjJkMmFjMThiMzgxYWRmOTdmTzQwOCI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQwNi5waHAiO3M6MzY6IjRiYzhjYjZjZWY2ODhjNzI5ZWRjMzk5MDIyMDAwNmFjTzM5NiI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQwNy5waHAiO3M6MzY6ImMyYzgxN2U5ZjVkODc2OGJiZGU=ZDY2YTI2ZTZjNmI1TzQ=MSI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQwOC5waHAiO3M6MzY6IjQwM2UzMTY=ODQ=OTU4YzUxNDRmOThlY2M4Yjc3Njg5TzM5OSI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQwOS5waHAiO3M6MzY6Ijk5NWExZGM=NjllNjdlMmEzZDBiOGY5YmViZmVhOWI2TzM3OCI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQxMC5waHAiO3M6MzY6IjcxYmU=ZjM=MzdkZmJhZGRhNTJmMzg1ODIxODRlMTliTzM2NiI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQxMS5waHAiO3M6MzY6IjI3YTU1MmExZTQxNjBjNGRmNjFiMmVjYTVhNjA=Nzk2TzM5OSI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQxMi5waHAiO3M6MzY6IjI1Yjg4NDQ5ZGNiN2ExYTgzZGQ5MDYzNzhhYTU1NmM3TzQxMSI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQxMy5waHAiO3M6MzY6ImU5OTYzY2MxNWRjOTkwNTliN2Q5ZmY1ODRjMTdiZmQ4TzQyNiI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQxNC5waHAiO3M6MzY6ImJjYTY1ZDU1ZTI=MDllZjZhNTI5MWVkOGU2YTEyMzY4TzQxNyI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQxNS5waHAiO3M6MzY6IjAyNThjYzBmYjA1NDYyZWE4ZjExY2NhZWEzNGE1NWMzTzQyMCI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQxNi5waHAiO3M6MzY6ImY5MzE4MjRlMzllMzk2MTdjOWFhYzY2MTgwNDQ3OGY4TzQ=NyI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQxNy5waHAiO3M6MzY6IjQyNzAwMjZhMWI4ZTY4NGY1ZWMwNjM1YzQ3MjAxYzIzTzQwOCI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQxOC5waHAiO3M6MzY6IjRhMjFiYWUyOThmMWM5ZmVkYTViMGU5M2ZlMzQ4YWYzTzQ3OCI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQyOC5waHAiO3M6MzY6IjlhOTdiYjAzNjlmNzAxNDJlNGU1N2RhNzVlYWU3NDJhTzUwNSI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQyOS5waHAiO3M6MzY6IjUzZjBkZDI1N2MwNDQ2MmVjM2EwNWE2NDg1YjM4ZmNjTzU=OSI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzQzMS5waHAiO3M6MzY6ImUwZTM3MzdjNjIyNDE3Y2EwOGQ1ZDE5MzNjMTQ4OWQ5TzUzNSI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzUwMC5waHAiO3M6MzY6ImMwYWZhOWM2NmI2ZDgzMGEwOTQ4MTVmMjEyNGRmZmRhTzQxNyI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzUwMS5waHAiO3M6MzY6IjY1MGNkYWI4MzAzNGYyMmQzZmU4MDNmNWQ3OTFhODM1TzM5OSI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzUwMi5waHAiO3M6MzY6IjdjYzgzYTZjODBjZjdhZjlkNTIxN2IxN2ZiNDdmZjY5TzM4NyI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzUwMy5waHAiO3M6MzY6IjM5MDZmNzUyMDg2MWMzOWY=M2Y=NjAwMGQ=NTU1NGI=TzQxMSI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzUwNC5waHAiO3M6MzY6IjAyZDc2ZDhjY2NhYTQ=NjI5MzIwMTExMjkwOGEyYWE1TzM5OSI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzUwNS5waHAiO3M6MzY6IjhlNWQ=MTA5MDUzMzAzZTY1YjJmNDM2NGMxYWMxMmRlTzQzMiI7czo=NDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQLzUxMS5waHAiO3M6MzY6IjAzNzU2ZTlhNGUzYzRiNzdmOGQwOWJiOTkxOGZkMTQwTzUzNSI7czo=ODoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL=V4Y2VwdGlvbi9IVFRQL1Vua25vd24ucGhwIjtzOjM2OiJkYTY=NmMwMmUxYWI4MWI2MzJhZjQxZmJjZjBhNTdhY=84NjciO3M6NDU6Ii93cC1pbmNsdWRlcy9SZXF1ZXN=cy9FeGNlcHRpb24vVHJhbnNwb3J=LnBocCI7czozNToiYWJiYjZjZjhkYTdhZThlYTIwNGEwMTE4YWI1ZWQxMDFPNzQiO3M6NTA6Ii93cC1pbmNsdWRlcy9SZXF1ZXN=cy9FeGNlcHRpb24vVHJhbnNwb3J=L2NVUkwucGhwIjtzOjM2OiI4NTM2NTRjZDY3MmExYTliM2EwOWFmMDc3ODM3ZGZlMU85MTgiO3M6MzI6Ii93cC1pbmNsdWRlcy9SZXF1ZXN=cy9Ib29rZXIucGhwIjtzOjM2OiIwZjA4YzU=MDE=MjVhOTYxNWJkMTllMmYzNGE1ZTEwN=83MDgiO3M6MzE6Ii93cC1pbmNsdWRlcy9SZXF1ZXN=cy9Ib29rcy5waHAiO3M6Mzc6IjJjMTVhMGE1MjBiOWE4OTc2Nzc4YTE2OWNlZWJkOTE5TzEzOTkiO3M6Mzc6Ii93cC1pbmNsdWRlcy9SZXF1ZXN=cy9JRE5BRW5jb2Rlci5waHAiO3M6Mzg6ImQ3N2RhZGEyMzJmMDA3OWIxNDEyZTBkMDUwYjRkOGIxTzExMzI1IjtzOjMwOiIvd3AtaW5jbHVkZXMvUmVxdWVzdHMvSVB2Ni5waHAiO3M6Mzc6ImE1ZGY=Yjg4NGU4YTA3ZTgxNzAzZjFhYzZiNmU1NGIxTzQ5MjciO3M6Mjk6Ii93cC1pbmNsdWRlcy9SZXF1ZXN=cy9JUkkucGhwIjtzOjM4OiIxODM1MDgzMjVkODM5YzdiZjI3ZGI1ZjkwOTYwMGU1OE8yODQ2NyI7czozMToiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL1Byb3h5LnBocCI7czozNjoiYjU=MDZiMTAzN2I1MDBkN2QzNzRiODVjMmE4Nzk5NDdPODEzIjtzOjM2OiIvd3AtaW5jbHVkZXMvUmVxdWVzdHMvUHJveHkvSFRUUC5waHAiO3M6Mzc6ImZmZDBlNjJmMzJkYjA1YmRiZGE2YmNhNDA3ZDdmMDI5TzM=NzEiO3M6MzQ6Ii93cC1pbmNsdWRlcy9SZXF1ZXN=cy9SZXNwb25zZS5waHAiO3M6Mzc6IjExY2U3MDg2YmJiN2FlNTJlNmFiYjdjNGZkMjcwYjQ3TzI1MDUiO3M6NDI6Ii93cC1pbmNsdWRlcy9SZXF1ZXN=cy9SZXNwb25zZS9IZWFkZXJzLnBocCI7czozNzoiMWFkN2MzODJkMmI2OGYxOTQxMmRhN2Y=M2U2M2E5NjBPMjEyNSI7czozMzoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL1Nlc3Npb24ucGhwIjtzOjM3OiIzN2Y4Y2FkZDg2ZmNiZmNlOTYwMmI1YmNmNjdkNmM4ZU83MTUzIjtzOjI5OiIvd3AtaW5jbHVkZXMvUmVxdWVzdHMvU1NMLnBocCI7czozNzoiMjY1MDY3ZWIyNzQxMzZhYzI4YmUzMDBiMzc1NDBjNGZPNDAyMiI7czozNToiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL1RyYW5zcG9ydC5waHAiO3M6Mzc6IjAxOWM5OTNiY2U2YmVkMTc4YmFmNGI1YzU2NmNjNjE3TzEyMjAiO3M6NDA6Ii93cC1pbmNsdWRlcy9SZXF1ZXN=cy9UcmFuc3BvcnQvY1VSTC5waHAiO3M6Mzg6IjBlZTQ4MDFkMDhkYTM4MzcxMjEzNjE2MDQzNWFlMGQxTzE1MzI1IjtzOjQ1OiIvd3AtaW5jbHVkZXMvUmVxdWVzdHMvVHJhbnNwb3J=L2Zzb2Nrb3Blbi5waHAiO3M6Mzg6IjFkMjFlZTRhNGY2MGFkMWFmYzQ4ZjExODQ4M2ZiNzNmTzEyNDM2IjtzOjU5OiIvd3AtaW5jbHVkZXMvUmVxdWVzdHMvVXRpbGl=eS9DYXNlSW5zZW5zaXRpdmVEaWN=aW9uYXJ5LnBocCI7czozNzoiYjVmMDNhYzhjNzUyYjM=YjllNzI2ZjA=ZDU=ODMyN2FPMTk5MyI7czo1MDoiL3dwLWluY2x1ZGVzL1JlcXVlc3RzL1V=aWxpdHkvRmlsdGVyZWRJdGVyYXRvci5waHAiO3M6MzY6IjEwZjlhMmQ5NjE4ZWQ2NzhiNzI1NDFhYTllMDU3OWQzTzgyOSI7czoyNToiL3dwLWluY2x1ZGVzL3Jlc3QtYXBpLnBocCI7czozODoiZmFmMjA3YjJjYmI=MDA1N2MyYjY4ZDg1YjliNmY2NWNPMzQ5NTciO3M6NDc6Ii93cC1pbmNsdWRlcy9yZXN=LWFwaS9jbGFzcy13cC1yZXN=LXJlcXVlc3QucGhwIjtzOjM4OiI=ZmJjNjAwMzE1OTMxNTlmNzA=Yzk5ZDhjM2RiZGUxZE8yNDc2MCI7czo=ODoiL3dwLWluY2x1ZGVzL3Jlc3QtYXBpL2NsYXNzLXdwLXJlc3QtcmVzcG9uc2UucGhwIjtzOjM3OiIwODc5NmQwY2RhNjM2YzZhMjRiY2ViYmI3M2VmMmM5OE83NjMzIjtzOjQ2OiIvd3AtaW5jbHVkZXMvcmVzdC1hcGkvY2xhc3Mtd3AtcmVzdC1zZXJ2ZXIucGhwIjtzOjM4OiI3MzAxYTM=MTM3NTU3ZWY5MDU1ZmYwOWZjZTk5ODlkNE8zNzUxNSI7czo3MjoiL3dwLWluY2x1ZGVzL3Jlc3QtYXBpL2VuZHBvaW5=cy9jbGFzcy13cC1yZXN=LWF=dGFjaG1lbnRzLWNvbnRyb2xsZXIucGhwIjtzOjM4OiI=OGE1NDk3M2NmYTIzOTEyNDVlMDViOWQyOWI3ZGMzYU8yMzYxOSI7czo2OToiL3dwLWluY2x1ZGVzL3Jlc3QtYXBpL2VuZHBvaW5=cy9jbGFzcy13cC1yZXN=LWNvbW1lbnRzLWNvbnRyb2xsZXIucGhwIjtzOjM4OiJiNGViZjEyMWQ1MDJmNDBmMmJmMzlkYzY2ODI5MzBjOU81MzY2MiI7czo2MDoiL3dwLWluY2x1ZGVzL3Jlc3QtYXBpL2VuZHBvaW5=cy9jbGFzcy13cC1yZXN=LWNvbnRyb2xsZXIucGhwIjtzOjM4OiJlNTM3YTI1MDE4ZjQ1NTZhNGEzYTczZTYwZmM3ZTQwOU8xODA3MCI7czo3NDoiL3dwLWluY2x1ZGVzL3Jlc3QtYXBpL2VuZHBvaW5=cy9jbGFzcy13cC1yZXN=LXBvc3Qtc3RhdHVzZXMtY29udHJvbGxlci5waHAiO3M6Mzc6IjdkNDhiYzRhMzhmM2NmMjkxOTc3NDdlNzE3N2I5YTI1TzkzMDMiO3M6NzE6Ii93cC1pbmNsdWRlcy9yZXN=LWFwaS9lbmRwb2ludHMvY2xhc3Mtd3AtcmVzdC1wb3N=LXR5cGVzLWNvbnRyb2xsZXIucGhwIjtzOjM3OiIwMWM3MmI4ODVkNDYyOGY1Mjg4Y2QwNjRmODQxOWE=Mk84NzM=IjtzOjY2OiIvd3AtaW5jbHVkZXMvcmVzdC1hcGkvZW5kcG9pbnRzL2NsYXNzLXdwLXJlc3QtcG9zdHMtY29udHJvbGxlci5waHAiO3M6Mzg6ImIwOWIwNjk=NDEyNDAwYjVkNTA4OTBiMWM5OTM1YjRjTzcxNDIyIjtzOjcwOiIvd3AtaW5jbHVkZXMvcmVzdC1hcGkvZW5kcG9pbnRzL2NsYXNzLXdwLXJlc3QtcmV2aXNpb25zLWNvbnRyb2xsZXIucGhwIjtzOjM4OiI1MWFhZmExOTdhZDY5NWRlMmM=ZWNlYjc=OTE2NzdhZk8xNzIyMCI7czo2OToiL3dwLWluY2x1ZGVzL3Jlc3QtYXBpL2VuZHBvaW5=cy9jbGFzcy13cC1yZXN=LXNldHRpbmdzLWNvbnRyb2xsZXIucGhwIjtzOjM3OiIwOGE3ZGQyMmE=MzM3MDY4MzRlZTkyNjhhOThkOGM5NU85MzA=IjtzOjcxOiIvd3AtaW5jbHVkZXMvcmVzdC1hcGkvZW5kcG9pbnRzL2NsYXNzLXdwLXJlc3QtdGF4b25vbWllcy1jb25=cm9sbGVyLnBocCI7czozODoiZjEwOWIxNWVhN2RhYjExMWUwOThkNTAzYTc2YjRkMzBPMTAxMDkiO3M6NjY6Ii93cC1pbmNsdWRlcy9yZXN=LWFwaS9lbmRwb2ludHMvY2xhc3Mtd3AtcmVzdC1=ZXJtcy1jb25=cm9sbGVyLnBocCI7czozODoiOWQ4ZjkyNzRiZTU5NmZkZWYwMDM4Y2M1MjY1YzE4NzZPMzA=MDQiO3M6NjY6Ii93cC1pbmNsdWRlcy9yZXN=LWFwaS9lbmRwb2ludHMvY2xhc3Mtd3AtcmVzdC11c2Vycy1jb25=cm9sbGVyLnBocCI7czozODoiZmJkMDNmYzY4MTFkYjFhNWViYjY2ZGI=OGRkNmY2NzNPNDM2MjEiO3M6NjY6Ii93cC1pbmNsdWRlcy9yZXN=LWFwaS9maWVsZHMvY2xhc3Mtd3AtcmVzdC1jb21tZW5=LW1ldGEtZmllbGRzLnBocCI7czozNjoiNDE=YTNkNmE3NTNmYWE5OTRkNzlhNDc4ZGU5MzdlNGFPNzQzIjtzOjU4OiIvd3AtaW5jbHVkZXMvcmVzdC1hcGkvZmllbGRzL2NsYXNzLXdwLXJlc3QtbWV=YS1maWVsZHMucGhwIjtzOjM4OiJhMDE3YThiMzlkNWViMzI3MjIwMDViZDhjZDk3YzFmM=8xMzQ2MCI7czo2MzoiL3dwLWluY2x1ZGVzL3Jlc3QtYXBpL2ZpZWxkcy9jbGFzcy13cC1yZXN=LXBvc3QtbWV=YS1maWVsZHMucGhwIjtzOjM3OiIwZmI=OGNjOGY4MGNlZTUyNjM3NjVkYmM=NDkxNWY1OE8xMDk4IjtzOjYzOiIvd3AtaW5jbHVkZXMvcmVzdC1hcGkvZmllbGRzL2NsYXNzLXdwLXJlc3QtdGVybS1tZXRhLWZpZWxkcy5waHAiO3M6Mzc6ImY3Y2Y1OGE1ZWNlODg5YzE3MjJkZTdmMDkyMzY=ZjY4TzEwOTYiO3M6NjM6Ii93cC1pbmNsdWRlcy9yZXN=LWFwaS9maWVsZHMvY2xhc3Mtd3AtcmVzdC11c2VyLW1ldGEtZmllbGRzLnBocCI7czozNjoiZmQ4MDY=MGFhMzE1ODk2M2NkNTU=YmUzNTg=YWFmMGVPNzE2IjtzOjI1OiIvd3AtaW5jbHVkZXMvcmV2aXNpb24ucGhwIjtzOjM4OiJhNjRhYWM1NzU4NTZjZGUzMmZlZjc1NGZiYThkZjIwZU8yMTMwNSI7czoyNDoiL3dwLWluY2x1ZGVzL3Jld3JpdGUucGhwIjtzOjM4OiI3ZmRiMWU=OWVmY2FkNTkyMTdkMDJiNTg=OWYyMzdiMk8xNzIxNSI7czozMDoiL3dwLWluY2x1ZGVzL3Jzcy1mdW5jdGlvbnMucGhwIjtzOjM2OiIxOWZmMWZhZTMxZmQyZDAzMzhjNzYwMWJjYjRiYWY1OE8xOTEiO3M6MjA6Ii93cC1pbmNsdWRlcy9yc3MucGhwIjtzOjM4OiJjMjFkNmQ4NmU3NWJlZjAwZmE2YzRhMGVjNWUxY2EzYk8yMzIwOCI7czozMDoiL3dwLWluY2x1ZGVzL3NjcmlwdC1sb2FkZXIucGhwIjtzOjM4OiJjODcwMTNhY2E1ZjlmYjZjNzM3MTEyODhlYjgzMTU2MU82NTUwNiI7czoyNDoiL3dwLWluY2x1ZGVzL3Nlc3Npb24ucGhwIjtzOjM2OiJkOTQ1NjFjZWEwYzVjMTNhNjA5YjljZGU1YTc2MzVkNE8yNDIiO3M6Mjc6Ii93cC1pbmNsdWRlcy9zaG9ydGNvZGVzLnBocCI7czozODoiZmUyZjU5NjYwOGEyMGUzNGZlZDA=NWUxOTA2NWU4MTlPMjA3MDYiO3M6MzM6Ii93cC1pbmNsdWRlcy9TaW1wbGVQaWUvQXV=aG9yLnBocCI7czozNzoiMzQ4MDcxZWQxMDVmZjA=MThiMjU5NjRlNzcxYmEzMzFPMzU5MiI7czozMjoiL3dwLWluY2x1ZGVzL1NpbXBsZVBpZS9DYWNoZS5waHAiO3M6Mzc6Ijc5ZmM5MDE3YTIzYTgzNmY=ZDBmNjhmNzc2NGNhNzM=TzQyOTYiO3M6Mzc6Ii93cC1pbmNsdWRlcy9TaW1wbGVQaWUvQ2FjaGUvQmFzZS5waHAiO3M6Mzc6Ijk=NDNlZGExODliYmQ5MzI1ZDBjOWMwNDVkMjM3YzZhTzM=NTIiO3M6MzU6Ii93cC1pbmNsdWRlcy9TaW1wbGVQaWUvQ2FjaGUvREIucGhwIjtzOjM3OiIwNjU5YmYwODRmNTVhMzAzZjU5MjJlZGM2MmJjZmJmNk8=NzI2IjtzOjM3OiIvd3AtaW5jbHVkZXMvU2ltcGxlUGllL=NhY2hlL=ZpbGUucGhwIjtzOjM3OiJhMzNkYmIwNTQwZWNjMjljYzY=MjViMTQxMDA5NTNkMU8=NDI=IjtzOjQxOiIvd3AtaW5jbHVkZXMvU2ltcGxlUGllL=NhY2hlL=1lbWNhY2hlLnBocCI7czozNzoiZjY5ZDRhNTViMmExMTY4NTMxNTM1MTA3YWI4NDNmYjZPNTE=MSI7czozODoiL3dwLWluY2x1ZGVzL1NpbXBsZVBpZS9DYWNoZS9NeVNRTC5waHAiO3M6Mzg6ImU4OTExZWNlMTVkZjQyY2E=Mzk5MWE=OGQ1Nzg1Njg3TzEyMjgwIjtzOjM=OiIvd3AtaW5jbHVkZXMvU2ltcGxlUGllL=NhcHRpb24ucGhwIjtzOjM3OiJiZGJhYmNkY2NhNDI2YTRkYWRmNjY3NWJjNGM=ZWJlOU8=NTEwIjtzOjM1OiIvd3AtaW5jbHVkZXMvU2ltcGxlUGllL=NhdGVnb3J5LnBocCI7czozNzoiYmE3ZWM4Y2MzZjEzZDRmMjdmMmUwYWRjYWY2NGJiMmFPMzcwNyI7czo=NzoiL3dwLWluY2x1ZGVzL1NpbXBsZVBpZS9Db25=ZW5=L1R5cGUvU25pZmZlci5waHAiO3M6Mzc6IjdjNzJjM2YzNjk4NTU1NjJkOTZjNzdlY2UxYzdkYjMzTzgxMzciO3M6MzY6Ii93cC1pbmNsdWRlcy9TaW1wbGVQaWUvQ29weXJpZ2h=LnBocCI7czozNzoiYmQ3ZmJmNjhiOTU=YTlkNTA5NTVjYzgwOGRiN2NiNmFPMzM2NyI7czozMToiL3dwLWluY2x1ZGVzL1NpbXBsZVBpZS9Db3JlLnBocCI7czozNzoiYTRhZTE5YTkyM2I4OTBmMmRjZjdlMmQ=MTVmZDFhZDJPMjI2OCI7czozMzoiL3dwLWluY2x1ZGVzL1NpbXBsZVBpZS9DcmVkaXQucGhwIjtzOjM3OiIwMzg1ZTRhMTRkZTc4YzhiMmExNjdmM2UwYWVhMTk3Y=8zNzIxIjtzOjQ3OiIvd3AtaW5jbHVkZXMvU2ltcGxlUGllL=RlY29kZS9IVE1ML=VudGl=aWVzLnBocCI7czozODoiNDU5NzVlMmZjZjBkNDI4NjkxYTU1YTIzOTQyNTJmNjFPMTczMjEiO3M6MzY6Ii93cC1pbmNsdWRlcy9TaW1wbGVQaWUvRW5jbG9zdXJlLnBocCI7czozODoiMTIyZTg2MWY=MmViNmUwMWNlOGQ=YjBmMTFmYjczNWRPMjc=ODciO3M6MzY6Ii93cC1pbmNsdWRlcy9TaW1wbGVQaWUvRXhjZXB=aW9uLnBocCI7czozNzoiMDk=YmZkNzYyNjljOWZjYzNjNWNkYThmMDVkMDUzMzVPMjE4NyI7czozMToiL3dwLWluY2x1ZGVzL1NpbXBsZVBpZS9GaWxlLnBocCI7czozNzoiYWViYTA4YWQ2YjU1ODczNmVhMGFhZjJiZWIyOTI1YjdPOTY3OCI7czozNToiL3dwLWluY2x1ZGVzL1NpbXBsZVBpZS9nemRlY29kZS5waHAiO3M6Mzc6ImM1MzhlMmJjMGU4NjYxOTdkYjYxNmMxNzg=MTEzNGQ=Tzg1NzIiO3M6Mzg6Ii93cC1pbmNsdWRlcy9TaW1wbGVQaWUvSFRUUC9QYXJzZXIucGhwIjtzOjM4OiI1NzI1YzdkMGZiMzQ3ZjFjMDhkZjM2OTBhNThmMzYwOU8xMDg4MiI7czozMDoiL3dwLWluY2x1ZGVzL1NpbXBsZVBpZS9JUkkucGhwIjtzOjM4OiI2ZTE2ZmYyMGQzZTY4NjkyY2YzYjYxN2I4NzVmMzZmNU8yODM1OSI7czozMToiL3dwLWluY2x1ZGVzL1NpbXBsZVBpZS9JdGVtLnBocCI7czozODoiMTA=NTEwZTIyMWZhMDg=MzdhZWMwMDhlNjMzY2RjYTdPOTgyOTkiO3M6MzQ6Ii93cC1pbmNsdWRlcy9TaW1wbGVQaWUvTG9jYXRvci5waHAiO3M6Mzg6IjgwNzNhNGM2ZGExYmIzM2I4Nzc1NzY2NjVlZjVlYWI1TzExMTg1IjtzOjMxOiIvd3AtaW5jbHVkZXMvU2ltcGxlUGllL=1pc2MucGhwIjtzOjM4OiJjZWNkZTY3OWM2MmRkNTAyMDdkOGQyNWVjZTFhNGI4OU81MTU1MCI7czozNToiL3dwLWluY2x1ZGVzL1NpbXBsZVBpZS9OZXQvSVB2Ni5waHAiO3M6Mzc6ImE1NDY3OTBlMjE2YWJkZDk4MDE3OTU5NDlmYjZiNDBmTzc1NzYiO3M6Mzc6Ii93cC1pbmNsdWRlcy9TaW1wbGVQaWUvUGFyc2UvRGF=ZS5waHAiO3M6Mzg6ImVlODJkMmU3MGRjOGFmYzZiOTY1MTBkMmI5Y2ZmNDVlTzE5NzAxIjtzOjMzOiIvd3AtaW5jbHVkZXMvU2ltcGxlUGllL1BhcnNlci5waHAiO3M6Mzg6IjUyYmIyZWU=NjJlN2U=MTRhNzdlZmRjN2ViZjUyYmNjTzExODUxIjtzOjMzOiIvd3AtaW5jbHVkZXMvU2ltcGxlUGllL1JhdGluZy5waHAiO3M6Mzc6IjNkNzAxM2E=NmQwOWM3NGIwZWUzZDhhZjYxNzQxMmZiTzM=NTEiO3M6MzU6Ii93cC1pbmNsdWRlcy9TaW1wbGVQaWUvUmVnaXN=cnkucGhwIjtzOjM3OiIxY2M4YTJlNmMwYjVkZDMxNzYzOThkNjQwMGYwZDliOE81OTkxIjtzOjM4OiIvd3AtaW5jbHVkZXMvU2ltcGxlUGllL1Jlc3RyaWN=aW9uLnBocCI7czozNzoiMmExOTFlNzE2ODExNjQxODgxNzM4ODExM2JkNTc5MTRPMzgwMCI7czozNToiL3dwLWluY2x1ZGVzL1NpbXBsZVBpZS9TYW5pdGl6ZS5waHAiO3M6Mzg6IjQyZDhiOGMwY2Y=NmI1ZDhhNTExZTBhZTQ4Yjg4Zjc1TzE1Njk4IjtzOjMzOiIvd3AtaW5jbHVkZXMvU2ltcGxlUGllL1NvdXJjZS5waHAiO3M6Mzg6IjhlODNiYjFkZTNlMDE4ZjA1MzdiYjMyYThjOTYxN2ZmTzIwNTM5IjtzOjQ5OiIvd3AtaW5jbHVkZXMvU2ltcGxlUGllL1hNTC9EZWNsYXJhdGlvbi9QYXJzZXIucGhwIjtzOjM3OiI4ZmIxZGE3MDI4YzM4NWJiOWQ=MjAzYzlmNjczMjM2Mk83MTQ5IjtzOjI1OiIvd3AtaW5jbHVkZXMvdGF4b25vbXkucGhwIjtzOjM5OiIyM2YwNjQ=YjczZDZiNWM=OTNiNzQ3ZGZiYmFlMjAyM=8xNDk4NjkiO3M6MzI6Ii93cC1pbmNsdWRlcy9=ZW1wbGF=ZS1sb2FkZXIucGhwIjtzOjM3OiJhNzQ1MDI=ZjQ1ZjAxODc=MTQ3OWJkY2Y1NTE4ZjU5Yk8yODk2IjtzOjI1OiIvd3AtaW5jbHVkZXMvdGVtcGxhdGUucGhwIjtzOjM4OiJjMTc4ZTQ2ZmFiYTA1YmQ1NjgyMWNhNzgwOTcwMzU2OE8xOTMxOCI7czoyNjoiL3dwLWluY2x1ZGVzL1RleHQvRGlmZi5waHAiO3M6Mzg6IjZjNzBkNTllOWU5YTZlOWJkMTE1Mzc3MTkzMTNlMzJhTzEyOTUwIjtzOjQwOiIvd3AtaW5jbHVkZXMvVGV4dC9EaWZmL=VuZ2luZS9uYXRpdmUucGhwIjtzOjM4OiJlNWFkMjcyYTE4ODIxMjEyYmVlM2MzZGYyYWU4NzgwZU8xNTg=MCI7czozOToiL3dwLWluY2x1ZGVzL1RleHQvRGlmZi9FbmdpbmUvc2hlbGwucGhwIjtzOjM3OiI3NWFiNDFkYzkxY2Q3ZTRhYWE1ZTc=YTVmOWU2ZWViYU81MTcwIjtzOjQwOiIvd3AtaW5jbHVkZXMvVGV4dC9EaWZmL=VuZ2luZS9zdHJpbmcucGhwIjtzOjM3OiIzYTExYjE5MzNkMTdmYzRkYTljMzAwMGNhY2VmNjkyOU84MzU=IjtzOjM5OiIvd3AtaW5jbHVkZXMvVGV4dC9EaWZmL=VuZ2luZS94ZGlmZi5waHAiO3M6Mzc6ImQ2YjkxZmM4NjI4YTBjMDQ3NGFkNTgzODlhNDc1ODE1TzIyMTAiO3M6MzU6Ii93cC1pbmNsdWRlcy9UZXh=L=RpZmYvUmVuZGVyZXIucGhwIjtzOjM3OiJmYzg3MjBkZjQzMzBiNTBmNTkzNzRmZGM=MGQ5NDc1M=82ODEzIjtzOjQyOiIvd3AtaW5jbHVkZXMvVGV4dC9EaWZmL1JlbmRlcmVyL2lubGluZS5waHAiO3M6Mzc6Ijg4MGFlNTZlMzViMTUwYjRiMmM3ZTlkOTQyMjdlODFlTzU1MzUiO3M6Mzg6Ii93cC1pbmNsdWRlcy9=aGVtZS1jb21wYXQvY29tbWVudHMucGhwIjtzOjM3OiIxODIyYmE5ZjYyZTRiZjNkNTEwYTdlNDMwNmU2N2Q=Yk8yMTEyIjtzOjM5OiIvd3AtaW5jbHVkZXMvdGhlbWUtY29tcGF=L2VtYmVkLTQwNC5waHAiO3M6MzY6IjhmYWIyNTAwMGZhZmVlNjk5ZmI=ZTc2ODcxZWQwMmY=Tzk3MCI7czo=MzoiL3dwLWluY2x1ZGVzL3RoZW1lLWNvbXBhdC9lbWJlZC1jb25=ZW5=LnBocCI7czozNzoiOGQ1NmI2OGMzODgzZGY4OWRjODEzYjJlYWZhMjkwMWNPMzE5OCI7czozNToiL3dwLWluY2x1ZGVzL3RoZW1lLWNvbXBhdC9lbWJlZC5waHAiO3M6MzY6IjcyYjY=Yzg5YmY=NWYyNzYwYzYxMzNmN2EzZGQzNjQ5TzQ3OSI7czo=MjoiL3dwLWluY2x1ZGVzL3RoZW1lLWNvbXBhdC9mb29=ZXItZW1iZWQucGhwIjtzOjM2OiIxNjg=MWNmNTVhZGMwNGFiODRmMjJlOTMyYjk2MTk2YU8=MzgiO3M6MzY6Ii93cC1pbmNsdWRlcy9=aGVtZS1jb21wYXQvZm9vdGVyLnBocCI7czozNzoiOGM1ZmY4NzNkYzMwOThhNWU=NmNjYmJmOTA5YzM3N2VPMTA1OSI7czo=MjoiL3dwLWluY2x1ZGVzL3RoZW1lLWNvbXBhdC9oZWFkZXItZW1iZWQucGhwIjtzOjM2OiI2Nzk2MmJhMmM4Nzg4MjlkMjY4MTc3NjZkMjU4ZGNjME83MDQiO3M6MzY6Ii93cC1pbmNsdWRlcy9=aGVtZS1jb21wYXQvaGVhZGVyLnBocCI7czozNzoiMzA=YzQwYmJhMWRkMjU4NzBhMGJjZWZmZWZjMjUwMjRPMTg5MyI7czozNzoiL3dwLWluY2x1ZGVzL3RoZW1lLWNvbXBhdC9zaWRlYmFyLnBocCI7czozNzoiODA4N2YzNzMwNGFkODZmZjE3NDhiNDQ=NmM5YTJjMGFPNDA2MCI7czoyMjoiL3dwLWluY2x1ZGVzL3RoZW1lLnBocCI7czozODoiMzQwOGQ5YzE4Zjk=YzI5MGM5MjI4NDEzM2E2MTllYjRPOTU3MjAiO3M6MjM6Ii93cC1pbmNsdWRlcy91cGRhdGUucGhwIjtzOjM4OiIxYmI3YWU5MTUxNTIwZTNlYzhhZjc5MGIzOTE2OGRhMU8yMzYyMSI7czoyMToiL3dwLWluY2x1ZGVzL3VzZXIucGhwIjtzOjM4OiI3NTMwZWI4ODZlZGI=YTFjYzQ4OGYxMmQ1ODJmMTRlNE84NTMxOSI7czoyMToiL3dwLWluY2x1ZGVzL3ZhcnMucGhwIjtzOjM3OiJjZGQxOTM5ZWZjYTJkNWJhZDdlOWVjOGQ=YTgyY2Y4ME81MzI2IjtzOjI=OiIvd3AtaW5jbHVkZXMvd2lkZ2V=cy5waHAiO3M6Mzg6IjI5ZGI4ZjE5MGFkYTcyM2FlNjIzNDhlZjIyNzlkYmUyTzQ4MDk=IjtzOjQ5OiIvd3AtaW5jbHVkZXMvd2lkZ2V=cy9jbGFzcy13cC1uYXYtbWVudS13aWRnZXQucGhwIjtzOjM3OiJhZmJmMTlhZDAxNGRjNjAyMzkyMGU=NGExMDFjNDQ=MU81Mzg=IjtzOjQ5OiIvd3AtaW5jbHVkZXMvd2lkZ2V=cy9jbGFzcy13cC13aWRnZXQtYXJjaGl2ZXMucGhwIjtzOjM3OiJhY2ZkY2ZkMTAzMDFhMDU3MTIyNWVjMzE=NWUyNDFkMk81MTk5IjtzOjQ5OiIvd3AtaW5jbHVkZXMvd2lkZ2V=cy9jbGFzcy13cC13aWRnZXQtY2FsZW5kYXIucGhwIjtzOjM3OiJkNjMxZmU4ZWNkODQxZGE4MTg=NTU3MjY2ZmY2M2FkZE8yOTQ2IjtzOjUxOiIvd3AtaW5jbHVkZXMvd2lkZ2V=cy9jbGFzcy13cC13aWRnZXQtY2F=ZWdvcmllcy5waHAiO3M6Mzc6ImNhZmQ1ZjEyZTQ5YjE5Zjg3M2UyYWMyNmMyZDEyZDI2TzU2NzIiO3M6NDY6Ii93cC1pbmNsdWRlcy93aWRnZXRzL2NsYXNzLXdwLXdpZGdldC1saW5rcy5waHAiO3M6Mzc6Ijk4NWY1YzZmOGE=MGY2N2Y3M2RiMTUzMmY1ZWVlYzUzTzY5ODMiO3M6NDU6Ii93cC1pbmNsdWRlcy93aWRnZXRzL2NsYXNzLXdwLXdpZGdldC1tZXRhLnBocCI7czozNzoiZjc4YWU5MzRjNmYxOTIxYWU2ZGU4NGE=NDU3NGMzNTVPMzUwNiI7czo=NjoiL3dwLWluY2x1ZGVzL3dpZGdldHMvY2xhc3Mtd3Atd2lkZ2V=LXBhZ2VzLnBocCI7czozNzoiOGY2MGRmMWY1NzgzYTA=OTgwZTk=YjE5YjAyN2E2MzJPNDc5NSI7czo1NjoiL3dwLWluY2x1ZGVzL3dpZGdldHMvY2xhc3Mtd3Atd2lkZ2V=LXJlY2VudC1jb21tZW5=cy5waHAiO3M6Mzc6IjBiZWZlMTA3NjI4ZjYwZDk1NTIzNTg1N2IzYTYwZjdhTzU4MDUiO3M6NTM6Ii93cC1pbmNsdWRlcy93aWRnZXRzL2NsYXNzLXdwLXdpZGdldC1yZWNlbnQtcG9zdHMucGhwIjtzOjM3OiJmZDYyYzdmMTJmNGYwMTg3MTYzNzM2MDUzZTZkZTMzY=8=ODI=IjtzOjQ=OiIvd3AtaW5jbHVkZXMvd2lkZ2V=cy9jbGFzcy13cC13aWRnZXQtcnNzLnBocCI7czozNzoiOTk1Y2U3MTM1OWRlYWRlMzAxMmI1MGQ4NjA=OTllMjdPMzc=OSI7czo=NzoiL3dwLWluY2x1ZGVzL3dpZGdldHMvY2xhc3Mtd3Atd2lkZ2V=LXNlYXJjaC5waHAiO3M6Mzc6ImUwNTZhNmViN2VhM2QwNjZlNWUzZTdmYjkyMzI4ZDFiTzI2NjIiO3M6NTA6Ii93cC1pbmNsdWRlcy93aWRnZXRzL2NsYXNzLXdwLXdpZGdldC1=YWctY2xvdWQucGhwIjtzOjM3OiI=OGY2NDY5MzA3YmU2Y2Y5ODg3ZGUxYjRlMzZjNmM2OE81MDU2IjtzOjQ1OiIvd3AtaW5jbHVkZXMvd2lkZ2V=cy9jbGFzcy13cC13aWRnZXQtdGV4dC5waHAiO3M6Mzc6IjllZWQ2NjYyNjI2ZWQzZGVjMDdkOWJiMTgwZGM5NTZlTzQxMTgiO3M6Mjg6Ii93cC1pbmNsdWRlcy93bHdtYW5pZmVzdC54bWwiO3M6Mzc6ImRmZDQ5MGI2ZjM4M2VhMDJhMjY5MDMxZmYwNWU4ODk2TzEwNDUiO3M6MjI6Ii93cC1pbmNsdWRlcy93cC1kYi5waHAiO3M6Mzg6IjkzMThkZGU5ODMwZWQ3YzAyZTQ2MzU2Y2E3NjNiNTgzTzk1NTEzIjtzOjI=OiIvd3AtaW5jbHVkZXMvd3AtZGlmZi5waHAiO3M6MzY6ImI4ZDJhMmYyZjM=OTQzYjY4NGI3ZTAyNTBkMzQyYzJlTzY2MSI7czoxODoiL3dwLWxpbmtzLW9wbWwucGhwIjtzOjM3OiI1NWY1ZWVkYTRmNjQyNzEzMjJkMjQ5YzE=Njg1YzE2Mk8yNDIyIjtzOjEyOiIvd3AtbG9hZC5waHAiO3M6Mzc6IjBjOWY=NDExOGRhZTM4NGU=NTQ3MjMzMTg=OTJhZjRmTzMzMDEiO3M6MTM6Ii93cC1sb2dpbi5waHAiO3M6Mzg6ImQ5ZjMwZDM1MzU5ZmYxYjg4NjViMmQ5NjExNDZmMjJmTzMzOTM5IjtzOjEyOiIvd3AtbWFpbC5waHAiO3M6Mzc6IjhkNmM5ZTRkYWI3Njk3YTA=NGEyMmE5NmNkNzg3MDY4TzgwNDgiO3M6MTY6Ii93cC1zZXR=aW5ncy5waHAiO3M6Mzg6IjAyNzQ3YmNjNjlkODM5YzY5OTE5YzMyMzFkNmY4YjMzTzE2MjUwIjtzOjE=OiIvd3Atc2lnbnVwLnBocCI7czozODoiNDk2YTY2MjlmMmFmZDllODI3NGExODBjYjVjYTBlZjFPMjk4OTYiO3M6MTc6Ii93cC1=cmFja2JhY2sucGhwIjtzOjM3OiIyNTNjYjYzNjM2NWJmZDk5YWYxZTczNDYyMjg2NDM3Zk8=NTEzIjtzOjExOiIveG1scnBjLnBocCI7czozNzoiNmM1M2UyZmYwNzYyODBjNWNmYzQxMGEzYzYzMmM3ODVPMzA2NSI7fX1zOjg6IndwX2xvZ2luIjthOjE6e3M6MzY6ImJydXRlIGZvcmNlIHBvc3NpYmxlIG9uIHdwLWxvZ2luLnBocCI7YToyOntpOjA7czo1OiJENE9BQiI7aToxO3M6MTc1OiIvLio_cmVxdWlyZVwoWyBcdF=qZGlybmFtZVwoX19GSUxFX19cKVsgXHRdKlwuWyBcdF=qWyInXVwvd3BcLWxvYWRcLnBocFsiJ11bIFx=XSpcKTsoPyFcL1wvMjAxMy=wNC=yNCBETyBOT1QgUkVNT1ZFIFRISVMgUkVRVUlSRUQgTElORSlbXlxuXSooW1xyXG4gXHRdKlwkX1NFU1NJT=5cW1teO1=rOykqL2lzIjt9fXM6ODoidGltdGh1bWIiO2E6MTp7czoyOToib3V=ZGF=ZWQgdmVyc2lvbnMgb2YgVGltVGh1bWIiO2E6Mjp7aTowO3M6NToiSDFRSkUiO2k6MTtzOjYwOiIvLitUaW1UaHVtYi4rZGVmaW5lXHMqXChbXHMnIl=rVkVSU=lPTltccyciXSssW1xzJyJdKzFcLi4rL3MiO319czo5OiJ3aGl=ZWxpc3QiO2E6Mjp7czozOiJwaHAiO2E6Mjg6e2k6MDtzOjU6IkZBOEhkIjtzOjM4OiI1ODczY2QxY2VhNjEwODIwMmQyMTM=N2YwMWYwNGRjZk84MTcyOCI7czo1OiJENzU5cCI7czozOToiMDEzNjM3MjhjODQzZmY5M2U5NmI2OTgzY2UzOGViYTZPMTk1NjE4IjtzOjU6IkQ1QTgzIjtzOjM4OiJkNWYzYzljYWZmMTRkNTdjODYwOGQ3OGRiMDA5NGJlME83MzY=MyI7czo1OiJENzVEOSI7czozODoiNTdhZjQ5ODE4YmJiOTQ5ZGMwYWM2Mzg2NzM4NjU1YmJPMjU4NTIiO3M6NToiRDdKRDkiO3M6Mzg6ImQ=OTQwNDI2MGQ3OWE=Y2MzNzU1YzAwZjU1ZGUyMDg5TzI1NjYyIjtzOjU6IkQ4VjhBIjtzOjM3OiI4NjYxZmUyYmZhNTk5NWY1NDZhMzMwNDdlOTAzODU2Y=8xMTM2IjtzOjU6IkRJQ=ZDIjtzOjM4OiI4MTI1ZDQyYzRiZTU=M2Y4NzRlYTVmNmExYjViZGU1NU8yNTg5NCI7czo1OiJESUNGRCI7czozOToiZWRkYjVmZGE3NGQ=MWRiZGFjMDE4MTY3NTM2ZDhkNTNPMjMxMzM4IjtzOjU6IkRJQ=ZFIjtzOjM4OiJjMTVhNGQ1YzM4MzQ=NGI5NWQyODU1OWY4MzQ4MTExZE8yMjU4OCI7czo1OiJFMVIydiI7czozODoiZTIwODM5YzU1OWE2NmM3Y2Y2Mjg2NTNiYTI=ODRlYWVPMjYzOTUiO3M6NToiRTFSMngiO3M6Mzg6ImYzMzgyZWMxNWMwMzBiZDMyZTI5M2ZhZjM=OTdlMjUzTzExMjI2IjtzOjU6IkUyMzBDIjtzOjM3OiIyOGE5MmY=NjQ5OGQzMmI5YTc=YzU4NDdmNzVjOTEyZU83Mzk5IjtzOjU6IkUyMzBDIjtzOjM3OiJmMDBhYWYwMWZmMDJkNTc1NmMyNjdiY2Y5MjBlNGMyOE8xNTQwIjtzOjU6IkUyQU1mIjtzOjM4OiI1N2M2NDdkOTNmYmQ=Nzg2OGI4N2I5MjFiZWU2M2FmOE8yNjM3NiI7czo1OiJFNUVEbyI7czozOToiOGUyYWY=ODg2ZGM4MWE1ZDkyODk4NjViYmI4MTNlZDFPMTk1NjE3IjtzOjU6IkU1SU5QIjtzOjM3OiJmODBkOWVmNGI3YmZkOWVmNTQyZDkwODdhMWRiMmFlOU8yMDEwIjtzOjU6IkU3RU12IjtzOjM4OiI1ZjkyN2YzYTk3MzIxOGQwN2U=M2VhMWM2OWZjMDMzMU8yNjc3NiI7czo1OiJFQTY2bCI7czozODoiYTViMWE3M2UwYzQyOTg5NTA3NTBhOGJjZDk2MjdlYWZPMjY4MTEiO3M6NToiRUNDRTAiO3M6Mzc6IjY=OTQ=ZTIyNTExM2JlMTgzOTRkNWJjMDFmYjNiNTM3Tzc1MzAiO3M6NToiRUNDRTMiO3M6Mzg6Ijk3ZTQzOGQ2YzljNjRhMjAyYjkzMDc4NmQyNzYyMDViTzYyNDU4IjtzOjU6IkVDQ=UzIjtzOjM4OiI2N2VjMWIxNTNjYzNmM2UzNmZiZWU1OTAyOWE5M2Q=YU8yNTkxNCI7czo1OiJFQ=pLRiI7czozNzoiODM2NjU3ZGJhNWNiMjI5MDAwMDI=NDc3NjYwZTlkZGZPODM2OSI7czo1OiJGNDM3MyI7czozODoiZjYwMDc5ZmVjMGU1ZDRkNjdlNDlhZGEzMzZkYWFmOTJPMjY4MTAiO3M6NToiRjQzNzQiO3M6Mzk6IjAzYjIxZmZjOWM3OWNmYjYyNDc5MGIwYmE=ODQ2OTFjTzMyMDMzMiI7czo1OiJGNUxNYiI7czozODoiNWU2ODU1Y2YwMmM=YWEwYWNjODcwMGY3ZjYxM2RmMDBPNjAxNjMiO3M6NToiRjZGSmUiO3M6Mzc6IjcxY2QxNjQ4MGFkZDIwZjUxNmY=MWNmMDQ1NzVmYjE4TzE4ODQiO3M6NToiRjlBOXQiO3M6Mzk6IjgzNGQyMmY4YjY4YTJjNWMwMTg2NmE=M2ViMjRlZmM=TzE5NTcwMiI7czo1OiJGQThIZCI7fXM6MjoianMiO2E6MzQ6e2k6MDtzOjU6IkY5QUFCIjtzOjM3OiI1NTRiYzc2YzcwMzUxMTg3ZjRjZTA1ZGRjMDEyYWFlZE8=Nzc2IjtzOjU6IkQ2NjdYIjtzOjM3OiI5YTljMTI1ODE=Yjk3MTU5ODJkMjQ2YTFlZTc4MDg=Zk81MzQ1IjtzOjU6IkQ2NjdYIjtzOjM4OiJlMzZhMDg2MTIzNzU2NDEyMjkzMjMxYWVhZDE3ZjI=Zk8zNzYyOSI7czo1OiJENzVBSCI7czozNzoiYTM4YWM1MjY2OTI=OTM4YTRmZjU1MTQzNjljNmI=MGRPNDY3NCI7czo1OiJENzVBSiI7czozNzoiMTA=M2ExZDdkODRlZTU2Zjg4MzFhNjBjZGZjNWRjMjhPNzA3NyI7czo1OiJENzVEUyI7czozODoiNmVjMTUwYjc5ODdjYWFlZjk4YjU5Yzg3YjlmNDcxYmVPMTE4NDIiO3M6NToiRTFSMm4iO3M6Mzg6IjYxNDdjY2VlN2FlZjlkYzBjNmViMTBkOGQ3YjMxMWY5TzcwODgzIjtzOjU6IkUxUjJ3IjtzOjM3OiJiYTMyOTM5NzBlMTNiMDNhMmVhOTJmNWI2YjViZjU=NE8zMzc3IjtzOjU6IkUyMk5xIjtzOjM3OiI2M2IwYWVkOWIwMmY4NzlhNmUwMjk1ZmJlYTdkYjg1NE8=NzAyIjtzOjU6IkUyMzBEIjtzOjM3OiJlZjQxODhjYjBiNjBhNzIwMTdmNGM4YTFlODQwYWIxZU8yOTUwIjtzOjU6IkUyNDlMIjtzOjM3OiJmYjhiZjY3ODVlNTVlOWUzOWJlYTU1MjYzNWM=MmE2NE8zMjcwIjtzOjU6IkUyNjBDIjtzOjM5OiJhY2IzMzMyOWI5ZWY4YWFiZDhiZDczMTQyNjgwM2U=ZU8yMzI=ODIiO3M6NToiRTI2MEUiO3M6Mzg6IjZjZWI2NDc1OTI1ODhiY2Y=NjNiZWZkOTQwOGUyN2FkTzEyMDI1IjtzOjU6IkUyNjBIIjtzOjM3OiI1YTMxODI3N2ZlZGY=OTFhMDMwMWUxNzdhOWVmMTBiM=8=OTA4IjtzOjU6IkUyNjBKIjtzOjM4OiJkYmMzODA4NDczZGVmMDBmY2U=NWZlNTY=ZGM3MmRjYk8xNDcyMCI7czo1OiJFMjYwSyI7czozNzoiYjk4OWE1YmQ4NGY2ZWJjYmMxMzkzZWMwMDNlNmU5OTFPNDk2OSI7czo1OiJFMjdFRyI7czozODoiMDMwYjgzODkzNzZhNDJmZjNkYTE4NmJmNjU4MDYyMTdPMTY1MzEiO3M6NToiRTI5RDIiO3M6Mzc6ImRlZjI1N2RiYjBhYjgwNWM=OTk2ZmQ4YWJiMWE2YjQ5TzY3MTciO3M6NToiRTJINW4iO3M6Mzg6Ijc=ZDkwMzA=OTY4M2U1YmJlYTljY2I3NTQ=YTQyYmNhTzE3NDEzIjtzOjU6IkU1RURxIjtzOjM4OiI2MDNiZDE=Mjk5ZjYxYTczMjliMmQzNTNiMmI1NmMyZk8zNzY4OSI7czo1OiJFNUVEcCI7czozNzoiMDQyNmIzOTc1NGFhNmJjNzY2ZDg5ZWE=YzQxYmJkMDZPMzQ1NyI7czo1OiJFNUVEeCI7czozODoiZWFkYzU4MzI1MTNkNTY3MDg4NGE5NzVjNmRlMTBmMDFPMTk2MTUiO3M6NToiRTdVTUEiO3M6Mzg6IjM4ZGJjYzkyNTUyOTM2ODgxMmY1YzJmYmNiMzg5NjE2TzE=OTY1IjtzOjU6IkU3VU1CIjtzOjM3OiJhMWMxODIyN2U2ZTkzNzk4YzQ5M2FlZDk2ZWU2Y2M4NE8zMjY3IjtzOjU6IkU3VU1CIjtzOjM3OiIwNzgzODhhNjQzMWFhNWIwODM4YTg3MzJkMTg3ZmUyOU84OTEzIjtzOjU6IkU4QUFwIjtzOjM3OiJmM2IxYjI4NDI=MzZmN2EzMTFiMzllNGVmNGI=N2Y1OU8=MzUyIjtzOjU6IkU4QkJVIjtzOjM3OiJkNzA5NDA2MTlhOTlkNTU1MTE2MTY3ZDRmYjM5Y2ExNU8=Mzk3IjtzOjU6IkU5Q=x4IjtzOjM4OiJjYmRiZmM5MTg=ZDI4YWM1NWY4M2MwYjBkZjQwZmQ=M=83OTQxNCI7czo1OiJFOUc4aiI7czozODoiZWYzYWU5MDE=NTI1Y2Y4MTE4N2FmYWE2MWJjYTczN2VPMzc2OTEiO3M6NToiRUNDRTEiO3M6Mzg6ImY=NDhjNTkzYzI=MmQxMzRlOTczM2E4NGM3YTRkMjZjTzE1MjQ4IjtzOjU6IkVDSDlYIjtzOjM5OiI1MWJiYTBkNTMzM2RlNGZkYTA5NTRmNTFlYTM1NWE1ME8xMDY3OTciO3M6NToiRjJBOFUiO3M6Mzg6IjY5MmY4ZTg2MWJhZmEzMWZiZjFiMzgwNWI=YjBkN2QzTzE1MDE2IjtzOjU6IkY=NkloIjtzOjM4OiJkODQyMzNkZDI5MzcxN2YwYTA3YjU1OGIyZmUzOGY1Nk8xNTA1MyI7czo1OiJGOUFBQiI7fX1zOjg6ImZpcmV3YWxsIjthOjM6e3M6OToiUmV2U2xpZGVyIjthOjc6e2k6MDtzOjU6IkdCS=ZyIjtpOjE7czozNjoiUmV2b2x1dGlvbiBTbGlkZXIgRXhwbG9pdCBQcm9=ZWN=aW9uIjtpOjI7czo=MTM6IlRoaXMgcHJvdGVjdGlvbiBpcyBhdXRvbWF=aWNhbGx5IGFjdGl2YXRlZCBiZWNhdXNlIG9mIHRoZSB3aWRlc3ByZWFkIGF=dGFja3Mgb24gV29yZFByZXNzIHRoYXQgaGF2ZSBhZmZlY3RlZCBzbyBtYW55IHNpdGVzLiBJdCBpcyBzdGlsbCByZWNvbW1lbmRlZCB=aGF=IHlvdSBtYWtlIHN1cmUgdG8gdXBncmFkZSBhbnkgb2xkZXIgdmVyc2lvbnMgb2YgdGhlIFJldm9sdXRpb24gU2xpZGVyIHBsdWdpbiwgZXNwZWNpYWxseSB=aG9zZSBpbmNsdWRlZCBpbiB=aGVtZXMgdGhhdCB3aWxsIG5vdCB1cGRhdGUgYXV=b21hdGljYWxseS4gRXZlbiBpZiB5b3UgZG9uJ3QgdGhpbmsgeW91IGhhdmUgUmV2b2x1dGlvbiBTbGlkZXIgb24geW91ciBzaXRlIGl=IGRvZW4ndCBodXJ=IHRvIGhhdmUgdGhpcyBwcm9=ZWN=aW9uIGVuYWJsZWQuIjtpOjM7czo2OiJTRVJWRVIiO2k6NDtzOjIwOiIvXC9hZG1pbi1hamF4XC5waHAvaSI7aTo1O3M6NzoiUkVRVUVTVCI7aTo2O3M6MTE5OiIvXCZpbWc9W15cJl=qKD88IVwucG5nKSg_PCFcLmpwZykoPzwhXC5qcGVnKSg_PCFcLmdpZikoPzwhXC5ibXApKD88IVwudGlmKSg_PCFcLnRpZmYpKD88IVwucHNkKSg_PCFcLnN2ZykoPzwhXC5pY28pXCYvaSI7fXM6OToiVHJhdmVyc2FsIjthOjU6e2k6MDtzOjU6IkdCS=M4IjtpOjE7czozMDoiRGlyZWN=b3J5IFRyYXZlcnNhbCBQcm9=ZWN=aW9uIjtpOjI7czoyMTY6IlRoaXMgcHJvdGVjdGlvbiBpcyBhdXRvbWF=aWNhbGx5IGFjdGl2YXRlZCBiZWNhdXNlIHRoaXMgdHlwZSBvZiBhdHRhY2sgaXMgcXVpdGUgY29tbW9uLiBUaGlzIHByb3RlY3Rpb24gY2FuIHByZXZlbnQgaGFja2VycyBmcm9tIGFjY2Vzc2luZyBzZWN1cmUgZmlsZXMgaW4gcGFyZW5=IGRpcmVjdG9yaWVzIChvciB1c2VyJ3MgZm9sZGVycyBvdXRzaWRlIHRoZSBzaXRlX3Jvb3QpLiI7aTozO3M6NzoiUkVRVUVTVCI7aTo=O3M6MjI6Ii89W1xzXC9dKihcLlwufGV=YylcLy8iO31zOjk6IlVwbG9hZFBIUCI7YTo1OntpOjA7czo1OiJHQ=9BVCI7aToxO3M6MjY6IlVwbG9hZCBQSFAgRmlsZSBQcm9=ZWN=aW9uIjtpOjI7czoxNzc6IlRoaXMgcHJvdGVjdGlvbiBpcyBhdXRvbWF=aWNhbGx5IGFjdGl2YXRlZCBiZWNhdXNlIHRoaXMgdHlwZSBvZiBhdHRhY2sgaXMgZXh=cmVtZWx5IGRhbmdlcm91cy4gVGhpcyBwcm9=ZWN=aW9uIGNhbiBwcmV2ZW5=IGhhY2tlcnMgZnJvbSB1cGxvYWRpbmcgbWFsaWNpb3VzIGNvZGUgdmlhIHdlYiBzY3JpcHRzLiI7aTozO3M6NToiRklMRVMiO2k6NDtzOjIwOiIvbmFtZT1bXlwmXSpcLnBocFwmLyI7fX1zOjg6Imh=YWNjZXNzIjthOjE=OntzOjI4OiJleGNlc2l2ZSBzcGFjZXMgaW4gLmh=YWNjZXNzIjthOjI6e2k6MDtzOjU6IkVBODdwIjtpOjE7czozMToiL1tcclxuXSsoW1x=IF17MzB9fFtcdF17MTB9KS4qLyI7fXM6MjY6ImV4Y2VzaXZlIHRhYnMgaW4gLmh=YWNjZXNzIjthOjI6e2k6MDtzOjU6IkVBODhTIjtpOjE7czozMjoiL14oW1x=IF17MzB9fFtcdF17MTB9KS4qW1xyXG5dKy8iO31zOjIyOiJSZXdyaXRlUnVsZSBtb2JpbGUgMzAyIjthOjI6e2k6MDtzOjU6IkQ=NUU5IjtpOjE7czoxMzg6Ii9SZXdyaXRlRW5naW5lIG9uLis_UmV3cml=ZVJ1bGUgXF5bXChdP1wuXCpbXCldP1wkIGh=dHA6XC9cLyhtb2JpbGUtLis_fC4rP2NvdW5=KGVyKT9cLnBocHwuKz9cP2g9WzAtOV=rKSBcWyhMXCwpP1IoPVswLTldezN9KT8oXCxMKT9cXS9zaSI7fXM6MjY6InBocF92YWx1ZSBhdXRvX2FwcGVuZF9maWxlIjthOjI6e2k6MDtzOjU6IkQzQzZGIjtpOjE7czozMToiL3BocF92YWx1ZSBhdXRvX2FwcGVuZF9maWxlIC4rLyI7fXM6NDc6IlRhZ2VkIFJld3JpdGVDb25kIEhUVFBfUkVGRVJFUiBSZXdyaXRlUnVsZSBIVFRQIjthOjI6e2k6MDtzOjU6IkQzSjZ3IjtpOjE7czoxNjc6Ii9cI1thLXpBLVowLTldK1wjLis_UmV3cml=ZUVuZ2luZSBvbltcclxuIFx=XStSZXdyaXRlQ29uZCBcJVx7SFRUUF9SRUZFUkVSXH=uKz9SZXdyaXRlUnVsZSBcXlwoXC5cKlwpXCQgaHR=cDpcL1wvLis_IFxbKExcLCk_Uj1bMC=5XXszfShcLEwpP1xdLis_XCNcL1thLXpBLVowLTldK1wjL3NpIjt9czoyNzoiRXJyb3JEb2N1bWVudCA=MDQgd3BwcG=ucGhwIjthOjI6e2k6MDtzOjU6IkRCSTYwIjtpOjE7czozMjoiL=Vycm9yRG9jdW1lbnQgNDA=IC4rd3BwcG1cLnBocC8iO31zOjU1OiJSZXdyaXRlQ29uZCBVU=VSX=FHRU5UIFJFRkVSRVIgUmV3cml=ZVJ1bGUgc3RhcnRpbmcucGhwIjthOjI6e2k6MDtzOjU6IkU4SDl2IjtpOjE7czo5MToiLyhSZXdyaXRlQ29uZCBcJVx7SFRUUF8oVVNFUl9BR=VOVHxSRUZFUkVSKVx9LitbXHJcbl=rKStSZXdyaXRlUnVsZS4rP1wvc3RhcnRpbmdcLnBocFw_LisvaSI7fXM6NDg6IlJld3JpdGVDb25kIEhUVFBfVVNFUl9BR=VOVCBSZXdyaXRlUnVsZSBodHRwIC5ydSI7YToyOntpOjA7czo1OiJGM1JCVyI7aToxO3M6MTA3OiIvKFJld3JpdGVFbmdpbmUgb25ccyspPyhSZXdyaXRlQ29uZCAuKj9IVFRQKFw6fF9BQ=NFUFR8X1VTRVJfQUdFTlQpLipccyspK1Jld3JpdGVSdWxlLio_IGh=dHAuKz9cLnJ1LipccyovaSI7fXM6NDk6IlJld3JpdGVDb25kIEhUVFBfVVNFUl9BR=VOVCBSZXdyaXRlUnVsZSBodHRwIC5waHAiO2E6Mjp7aTowO3M6NToiRjJPODAiO2k6MTtzOjk3OiIvKFJld3JpdGVDb25kIFwlXHtIVFRQX1VTRVJfQUdFTlRcfSAuK1xzKykrUmV3cml=ZVJ1bGUgXF5cJCBodHRwOlwvXC8uKz8obW9ieTI=XC5jb218XC5waHBcPykuKy9pIjt9czo3OToiUmV3cml=ZUVuZ2luZSBPbiBSZXdyaXRlQmFzZSBSZXdyaXRlQ29uZCBSZXdyaXRlUnVsZSBpbmRleC5waHAgcGFzc2luZyB2YXJpYWJsZSI7YToyOntpOjA7czo1OiJFQ=U4UyI7aToxO3M6MTc3OiIvUmV3cml=ZUVuZ2luZSBPblxzK1Jld3JpdGVCYXNlIFwvKFthLXowLTlcX1wtXSspXC9ccytSZXdyaXRlUnVsZSBcXmluZGV4W15cXV=rXF1ccysoUmV3cml=ZUNvbmQgLitccyspK1Jld3JpdGVSdWxlIFxeXChcLlwqXClcJCBcL1wxXC9pbmRleFwucGhwXD9bYS16MC=5XF9cLV=rPVwkMSBcW1teXF1dK1xdL2kiO31zOjY=OiJSZXdyaXRlRW5naW5lIG9uIFJld3JpdGVDb25kIEhUVFBfVVNFUl9BR=VOVCBSZXdyaXRlUnVsZSBodHRwIElQIjthOjI6e2k6MDtzOjU6Ikc5SkFZIjtpOjE7czoxOTM6Ii8oUmV3cml=ZUVuZ2luZSBvblxzKyk_KFJld3JpdGVDb25kIFwlXHsoUkVRVUVTVF9VUkl8SFRUUF9SRUZFUkVSfEhUVFBfVVNFUl9BR=VOVClcfSg_ISBmYXZpY29uXC5pY28gXFspLitccyspK1Jld3JpdGVSdWxlIC4qIGh=dHA6XC9cLyg_ITEyN1wufFwlXHsoSFRUUF9IT1NUfFJFTU9URV9BRERSKVx9fHdpa2lwZWRpYVwub3JnKS4qL2kiO31zOjQyOiJSZXdyaXRlRW5naW5lIG9uIFVOQ=9ORElUSU9OQUwgUmV3cml=ZVJ1bGUiO2E6Mjp7aTowO3M6NToiSDJLQUsiO2k6MTtzOjc2OiIvUmV3cml=ZVJ1bGUgXF5bXlxzXStccysuKz8oPzwhKGluZGV4XFx8bWluaWZ5KSlcLnBocFw_W149XSs9W1wkXCVce1xcXSsuKy9pIjt9czoxMDk6IlJld3JpdGVDb25kIEVOVjpSRURJUkVDVF9TVEFUVVMgUmV3cml=ZVJ1bGUgUmV3cml=ZUNvbmQgUkVGRVJFUi9VU=VSX=FHRU5UIGdvb2dsZS95YWhvby9iaW5nIFJld3JpdGVSdWxlIC5waHAiO2E6Mjp7aTowO3M6NToiRzE=Qk=iO2k6MTtzOjI2MzoiL1Jld3JpdGVDb25kXHMrXCVce=VOVlw6UkVESVJFQ1RfU1RBVFVTXH1ccysyMDBccytSZXdyaXRlUnVsZVtcXlwtXHNdK1xbW15cXV=rXF1ccysoUmV3cml=ZUNvbmRccytcJVx7SFRUUF8oUkVGRVJFUnxVU=VSX=FHRU5UKVx9XHMrXCgoKGdvb2dsZXx5YWhvb3xtc258YW9sfGJpbmcpKFx8fFwpKSkrKFxzK1xbW15cXV=rXF=pKlxzKykrUmV3cml=ZVJ1bGVccytcXlwoW15cKV=rXClcJFxzK1thLXpfXC=wLTldK1wucGhwXD9cJDFccytbXlxdXStbXF1cc1=rL2kiO31zOjIxOiJEaXJlY3RvcnlJbmRleCAhaW5kZXgiO2E6Mjp7aTowO3M6NToiRzU=RDciO2k6MTtzOjczOiIvKD88PURpcmVjdG9yeUluZGV4ICkoPyFpbmRleC5odG1sIHxpbmRleC5odG=gKSguKz8pKD89W15cL11pbmRleFwucGhwKS9pIjt9fXM6OToicG9=ZW5=aWFsIjthOjE1OntzOjQ6ImV2YWwiO2E6Mjp7aTowO3M6NToiRUFQTHEiO2k6MTtzOjM1OiIvW15hLXpcLyciXWV2YWxcKFteXCldK1snIlxzXCk7XSsvaSI7fXM6OToiYXV=aF9wYXNzIjthOjI6e2k6MDtzOjU6IkgxTjlZIjtpOjE7czoyMToiL1wkYXV=aF9wYXNzXHMqPS4rOy9pIjt9czoyMToiZG9jdW1lbnQud3JpdGUgaWZyYW1lIjthOjI6e2k6MDtzOjU6IkgxUEFPIjtpOjE7czo1MjoiL2RvY3VtZW5=XC53cml=ZVwoKFsnIl=pPGlmcmFtZSAuKzxcL2lmcmFtZT5cMVwpOyovaSI7fXM6MTU6InByZWdfcmVwbGFjZSAvZSI7YToyOntpOjA7czo1OiJHODVGMiI7aToxO3M6NDc6Ii9wcmVnX3JlcGxhY2VccypcKC4rW1wvXCNcfF1baV=qZVtpXSpbJyJdLitcKS9pIjt9czoyMDoiZXhlYyBzeXN=ZW=gcGFzc3RocnUiO2E6Mjp7aTowO3M6NToiRUFQTGciO2k6MTtzOjUxOiIvPFw_Lis_ZXhlY1woLis_c3lzdGVtXCguKz9wYXNzdGhydVwoLitmd3JpdGVcKC4rL3MiO31zOjI5OiJFeHRlcm5hbCBSZWRpcmVjdCBSZXdyaXRlUnVsZSI7YToyOntpOjA7czo1OiJGMVVJWiI7aToxO3M6NDI6Ii9SZXdyaXRlUnVsZSBbXiBdKyBodHRwXDpcL1wvKD8hMTI3XC4pLiovaSI7fXM6MzU6Im5vIGVycm9yX3JlcG9ydGluZyBsb25nIGxpbmVzIGFsb25lIjthOjI6e2k6MDtzOjU6IkgyUzhqIjtpOjE7czo3NDoiLzxcP1tcc2hwXSpcQD9lcnJvcl9yZXBvcnRpbmdcKDBcKTsuKz9bYS16MC=5XC9cLVw9JyJcLl17MjAwMH=uKj8oJHxcPz4pL2kiO31zOjIyOiJwcm9=ZWN=ZWQgYnkgY29weXJpZ2h=IjthOjI6e2k6MDtzOjU6IkQ4TUN3IjtpOjE7czoxMzY6Ii9cL1wqIFRoaXMgZmlsZSBpcyBwcm9=ZWN=ZWQgYnkgY29weXJpZ2h=IGxhdyBhbmQgcHJvdmlkZWQgdW5kZXIgbGljZW5zZS4gUmV2ZXJzZSBlbmdpbmVlcmluZyBvZiB=aGlzIGZpbGUgaXMgc3RyaWN=bHkgcHJvaGliaXRlZC4gXCpcLy8iO31zOjE5OiJhIHNwYW4gY29sb3IgRjFFRkU=IjthOjI6e2k6MDtzOjU6IkQ4UkFQIjtpOjE7czoxMTg6Ii9cPGEgW15cPl=rXD5cPHNwYW4gc3R5bGU9ImNvbG9yXDpcI=YxRUZFNDsiXD4oLis_KVw8XC9zcGFuXD5cPFwvYVw-XDxzcGFuIHN=eWxlPSJjb2xvclw6XCNGMUVGRTQ7Ilw-KC4rPylcPFwvc3Bhblw-L2kiO31zOjE3OiJWYXJpYWJsZSBGdW5jdGlvbiI7YToyOntpOjA7czo1OiJFODU2TCI7aToxO3M6Njc6Ii8oPCFcZClcJFtcJFx7XSpbYS16XC1cXzAtOV=rW1x9IFx=XSooXFtbXlxdXStcXVsgXHRdKikqXCguKj9cKVw7L2kiO31zOjExOiJUYWdnZWQgQ29kZSI7YToyOntpOjA7czo1OiJFNExNRyI7aToxO3M6MjQ6Ii9cIyhcdyspXCMuKz9cI1wvXDFcIy9pcyI7fXM6MTU6ImNyZWF=ZV9mdW5jdGlvbiI7YToyOntpOjA7czo1OiJHMU1GZSI7aToxO3M6Nzg6Ii8oXCRbYS16XzAtOV=rWz1cc1xAXSspP2NyZWF=ZV9mdW5jdGlvblwoW14sXSssW1xzXCRcLlxbXF1hLXpfMC=5XStbXHNcKV=rOyovaSI7fXM6NDM6ImZ1bmN=aW9uIGFkZF9hY3Rpb24gd3BfZW5xdWV1ZV9zY3JpcHQganNvbjIiO2E6Mjp7aTowO3M6NToiRjExNHYiO2k6MTtzOjE3OiIvanNvbjJcLm1pblwuanMvaSI7fXM6NDc6IlJld3JpdGVDb25kIEhUVFBfVVNFUl9BR=VOVCBSZXdyaXRlUnVsZSBodHRwIElQIjthOjI6e2k6MDtzOjU6IkYyNzdoIjtpOjE7czo4NDoiLyhSZXdyaXRlQ29uZCBcJVx7SFRUUF9VU=VSX=FHRU5UXH=gLitccyspK1Jld3JpdGVSdWxlIFxeLipcJCBodHRwOlwvXC8oPyExMjdcLikuKi9pIjt9czoxMjoidGl=bGUgaGFja2VkIjthOjI6e2k6MDtzOjU6IkgyUzhtIjtpOjE7czoyNzoiLzx=aXRsZT5bXjxdKmhhY2tbM2VdW3JkXS9pIjt9fXM6ODoiYmFja2Rvb3IiO2E6ODU6e3M6MjE6InNoZWxsIHN5c3RlbSBwYXNzdGhydSI7YToyOntpOjA7czo1OiJEOERKOSI7aToxO3M6OTk6Ii9cPFw_KC4rPykoc2hlbGx8YXV=aHApKC4rPyllcnJvcl9yZXBvcnRpbmdcKDBcKSguKz8pc2V=X3RpbWVfbGltaXRcKDBcKSguKz8paW5pX3NldFwoLitmb3BlblwoLisvcyI7fXM6MTg6ImF1dGhfcGFzcyBGaWxlc=1hbiI7YToyOntpOjA7czo1OiJIMTZHdCI7aToxO3M6MjA=OiIvPFw_W3BoXHNdK2lmW1xzXChdK2lzc2V=XHMqXChccypcJF8oUkVRVUVTfEdFfFBPUylUXFsoWyciXSkoW2Etel8wLTldKylcMlteXHtdK1x7XHMqc3dpdGNoIFwoXCRfXDFUXFtcMlwzXDJcXS4rP2RlZmF1bHQ6W15cfV=rW1x9XHNdK2RpZVwoW15cfV=rW1x9XHNdK2lmW1xzXChdK1wkd3BkYlwtPmdldF92YXJcKC4rP2V4aXQ7W1x9XHNdKygkfFw_PikvaXMiO31zOjI2OiJHRVRkb19yZW1vdmUgc2FmZV9tb2RlIGVuZCI7YToyOntpOjA7czo1OiJDQ1VMMyI7aToxO3M6MTE=OiIvaWZcKFwkX=dFVFxbJ2RvJ1xdPT=icmVtb3ZlIlwpXHtcbnVubGlua1woZ2V=Y3dkXChcKVwuXCRfU=VSVkVSXFsiU=NSSVBUX=5BTUUiXF1cKTsuK3NhZmVfbW9kZS4rZWxzZS4rJ1wuXCRlbmQ7L3MiO31zOjQwOiJzZXRfZXJyb3JfaGFuZGxlciBldmFsIGZpbGVfZ2V=X2NvbnRlbnRzIjthOjI6e2k6MDtzOjU6IkY5UzlXIjtpOjE7czoxMjQ6Ii8oZXJyb3JfcmVwb3J=aW5nXCguKz98c2V=X2Vycm9yX2hhbmRsZXJcKC4rPykqZXZhbFwoW15cKV=qPyhcJHJlcXVlc3R8c3RycmV2XCgpW15cKV=qP2ZpbGVfZ2V=X2NvbnRlbnRzXCgnW14nXSsnW1wpXHNdKzsvaXMiO31zOjIwOiJHRVRfZGwgc2FmZV9tb2RlIGVuZCI7YToyOntpOjA7czo1OiJFQ1NFViI7aToxO3M6MTAwOiIvPFw_W3BoXHNdK2lmXChpc3NldFwoXCRfR=VUXFtbJyJdZGxbIiddXF1cKS4rP3NhZmVfbW9kZS4rP1w_Pihccyo8XC9kaXY-XHMqPFwvYm9keT5ccyo8XC9odG1sPik_L2lzIjt9czoxMDoidW5zZXQgc2VsZiI7YToyOntpOjA7czo1OiJIMlNKaiI7aToxO3M6MzQyOiIvKFwkW2Etel8wLTldKylccyo9XHMqX19GSUxFX18uK3Vuc2V=XChccypcMVtcKVxzXSo7XHMqfDxcP1tcc2hwXSooXEA_Y2htb2RcKFteXCldK1wpO1xzKikqaWZbXHNcKFwhXSsoaXNzZXR8ZW1wdHkpW1xzXChdK1wkXyhSRVFVRVNUfEdFVHxQT1NUfENPT=tJRSlbXlx7XStbXHtcc1=qKFwkW2Etel8wLTlce1x9XSspXHMqPS4rP21rZGlyW1xzXCgiJ1wuXC9dK1w1W1wpO1xzXStmb3JlYWNoLis_XHtbXlx9XStcfVxzKihpZltcc1woXCFdK2lzX2RpclteXCldK1wpK1tce1xzXEBdKm1rZGlyW1xzXChdK1teXCldK1wpKztbXHNcfV=qKSsuKj8odW5saW5rXChbXlwpXStcKTtccyopKygkfFw_PikvaXMiO31zOjIzOiJjbGVhcnN=YXRjYWNoZSBoZXJlIGRpZSI7YToyOntpOjA7czo1OiJENUVBNSI7aToxO3M6MTQyOiIvPFw_KHBocCk_WyBcdFxyXG5dKyhpZlwoaXNzZXRcKFwkX=dFVFxbWyciXVswLTlhLXpBLVpdK1snIl1cXVwpXClbIFx=XHJcbl=qXHtbIFx=XHJcbl=rKT9jbGVhcnN=YXRjYWNoZS4raGVyZTtbIFx=XHJcbl=rZGllO1tcfSBcdFxyXG5dK1w_Pi9zIjt9czoyMToia2V5c3BhdCB2aWFncmEgY2lhbGlzIjthOjI6e2k6MDtzOjU6IkQxT=4zIjtpOjE7czoxMjA6Ii9lcnJvcl9yZXBvcnRpbmdcKDBcKTtbIFx=XHJcbl=rXCRrZXlzcGF=Wz=gXHRdK2FycmF5XChbIFx=XHJcbl=qKFsnIl=odmlhZ3JhfGFtb3hpY2lsbGlufGNpYWxpcylbJyJdWyBcdFxyXG4sXSspezJ9LisvcyI7fXM6MTg6ImV2YWwgUkVRVUVTVCBhbG9uZSI7YToyOntpOjA7czo1OiJGNFBMUCI7aToxO3M6MTYyOiIvPFw_W3BoXHNdKygoXCRbYS16XF8wLTldKylccyo9XHMqXCRfKFJFUVVFU3xHRXxQT1MpVFteO1=rO1xzKik_XEA_ZXZhbChbXChccypcQF=rc3RyaXBzbGFzaGVzKT9bXChccypcQF=rKFwyfFwkXyhSRVFVRVN8R=V8UE9TKVRccyooXFtbXlxdXStcXVxzKikrKVtcKTtcc1=rXD8-L2kiO31zOjMzOiJhdXRoX3Bhc3MgRmlsZXNNYW4gc2FmZV9tb2RlIGV2YWwiO2E6Mjp7aTowO3M6NToiSDE2QlAiO2k6MTtzOjc3OiIvXDxcPyg_PS4qXCRhdXRoX3Bhc3MpKD89LipGaWxlc=1hbikoPz=uKnNhZmVfbW9kZSkoPz=uKihldmFsfG5ldHN=YXQpXCgpLisvcyI7fXM6MTg6ImV2YWwgYmFzZTY=X2RlY29kZSI7YToyOntpOjA7czo1OiJHOFVOciI7aToxO3M6MzAyOiIvKFxAPygoZXJyb3JfcmVwb3J=aW5nfGluaV8oc2V=fHJlc3RvcmUpKVwoW15cKV=qXCl8XCRbYS16XF8wLTldK1xzKj1ccypbXjtdKyk7XHMqKSooaWZbXChcc1=raXNzZXRcKFwkXyhQT1N8R=V8UkVRVUVTKVRcW1teXCldK1tcKVxzXSspPyhlY2hvXHMqKT8oKFwkW2Etel8wLTldKylccyo9XHMqXEA_YmFzZTY=X2RlY29kZVwoW147XSs7XHMqXEA_KGV2YWxcKC4qXDl8XDlccypcKFxzKlwkXyhQT1N8R=V8UkVRVUVTKVQpfFxAP2V2YWxcKFteO1=qYmFzZTY=X2RlY29kZVwoKVteXCldKlwpKztccyoocmV=dXJuW147XSo7KSovaSI7fXM6NTE6InNlc3Npb25fc3RhcnQgZXJyb3JfcmVwb3J=aW5nIHNldF9=aW1lX2xpbWl=IGZvb3RlciI7YToyOntpOjA7czo1OiJENEpNaCI7aToxO3M6MTIwOiIvXDxcP3BocFtcclxuIFx=XStzZXNzaW9uX3N=YXJ=XChcKTtbXHJcbiBcdF=rZXJyb3JfcmVwb3J=aW5nXCgwXCk7W1xyXG4gXHRdK3NldF9=aW1lX2xpbWl=XCguKz88XD8gZWNobyBcJGZvb3RlcjtcPz4vaXMiO31zOjE4OiJmdW5jdGlvbiBCU1NWIGV2YWwiO2E6Mjp7aTowO3M6NToiRDROQ=MiO2k6MTtzOjY5OiIvKFwvXCouKj9cKlwvW1xyXG4gXHRdKikqZnVuY3Rpb24gQlNTVlwoLitldmFsXChCU1NWXCguKz9bXCldK1s7XSovaXMiO31zOjIzOiJGaWxlc=1hbiBwcmVnX3JlcGxhY2UgLiI7YToyOntpOjA7czo1OiJFQ=ZIcyI7aToxO3M6MjQ2OiIvPFw_W3BoXHNdKihcL1wqLis_XCpcL1xzKikqKFwkW2EtelxfMC=5XStccyo9W147XSs7XHMqKSpcJFthLXpcXzAtOV=rXHMqPVtccyInXSpGWyInXC5cc1=qaVsiJ1wuXHNdKmxbIidcLlxzXSplWyInXC5cc1=qc1siJ1wuXHNdKk1bIidcLlxzXSphWyInXC5cc1=qblsiJ1xzXSo7KFxzKlwkW2EtelxfMC=5XStccyo9W147XSs7KSpccyooXCRbYS16XF8wLTldK3xwcmVnX3JlcGxhY2UpXChbXlwpXSpbXCk7XHNdKygkfFw_PikvaXMiO31zOjI1OiJmdW5jdGlvbiBBcnJheSBwcmludCBleGl=IjthOjI6e2k6MDtzOjU6IkgyN=FzIjtpOjE7czo1ODM6Ii88XD9bcGhcc1=rKFwkW19cLVw-XC5hLXowLTlce1xbJyJcXVx9XStccyo9W147XSs7XHMqKSooKGZ1bmN=aW9uXHMrW2Etel8wLTldK1woLio_XClccypceyhcJFtePV=rPVxzKlsnIl17Mn=pP3xmb3JbXHMoXStbXlx7XStce1teXH1dK1x9Lio_fChyZXR1cm58Z2xvYmFsKVxzKyhcJFx7W15cfV=rXH=rKT9bXjtdKjt8XCRcey4rP1x9XHMqXCguKj9cKSs7fFwkXHsuKz9cfVxzKj1ccyphcnJheVwoKChbYS16XzAtOV=rXCguKj9cKSssXHMqKStbYS16XzAtOV=rXCguKj8pP1wpKzt8aWZccypcKC4qP1wpK1xzKlx7fGVsc2VbXHNce1=qfFwkW19cLVw-XC5hLXowLTlce1xbJyJcXVx9XStbXHNcLl=qPShccypjaHJcKC4qP1wpK3woLis_XF4pezUsfXxbXjtdK1xeXHMqXGQrKVteO1=qO3xleGl=XCguKj9cKSs7fChcJChce1thLXpfMC=5XStcKC4rP1wpXH=oXHMqXFtbXlxdXSpcXSspKnxjb25=ZW5=fHVybClbXHNcK1wuO1x9PD5cLl=qKSs9XHMqKFtcQFwkXHtdKlthLXpfMC=5XH1dKyhcKC4rP1wpfFxbLis_XF=pKVx9Kjt8Zm9yZWFjaC4rP1xzK2FzXHMrW15cKV=rW15ce1=rXHspWztcc1x9XSopezUwLH=oJHxcPz4pL2kiO31zOjMzOiJtZDV=YWdnZWQgZXZhbCB2YXJpYWJsZSBmdW5jdGlvbnMiO2E6Mjp7aTowO3M6NToiRjk2SzEiO2k6MTtzOjcyOiIvKChcJFthLXpcXzAtOV=rKVxzKj1ccypbXjtdKztccyopK1xAP2V2YWxcKFteO1=qXDJccypcKFteXCldKltcKVxzXSs7L2kiO31zOjI5OiJpZiBpc3NldCBSRVFVRVNUIGV2YWwgUkVRVUVTVCI7YToyOntpOjA7czo1OiJGN1VEUCI7aToxO3M6MjI5OiIvaWZbXHNcKF=raXNzZXRbXHNcKF=rXCRfKFJFUVVFU3xHRXxQT1MpVChcKFteXCldKlwpK3xcW1teXF1dKlxdK3xce1teXH1dKlx9KykqW15ce1=rW1x7XHNdK2V2YWxbXHNcKF=rKFthLXpfMC=5XStcKFxzKikqXCRfKFJFUVVFU3xHRXxQT1MpVChcKFteXCldKlwpK3xcW1teXF1dKlxdK3xce1teXH1dKlx9KykqW1xzXCk7XSsoKGRpZXxleGl=fGVjaG98cHJpbnQpW147XSo7XHMqKSpcfVs7XHNdKy9pIjt9czoxNDoiR=xPQkFMUyAwIGV2YWwiO2E6Mjp7aTowO3M6NToiRDU5TUsiO2k6MTtzOjc2OiIvKFwkKEdMT=JBTFNcW1snIl=pKlswb=9dK1snIlxdXD1cLiBcdF=rW147XSs7W1xyXG4gXHRdKikrZXZhbFwoLitbXCldK1s7XSovIjt9czozMjoiZXJyb3JfcmVwb3J=aW5nIHBhc3N3b3JkIGV4aXQgbWUiO2E6Mjp7aTowO3M6NToiRDVCQmsiO2k6MTtzOjE3MjoiLzxcPyhwaHApP1tcclxuIFx=XSplcnJvcl9yZXBvcnRpbmdcKDBcKTtbXHJcbiBcdF=qXC9cL=lmIHRoZXJlIGlzIGFuIGVycm9yLCB3ZSdsbCBzaG93IGl=LCBrXD9bXHJcbiBcdF=qXCRwYXNzd29yZFs9IFx=XSsuKyA6LVwpW1xyXG4gXHRdKmV4aXRcKFwpO1tcclxuIFx=XSpcPz5cLlwkbWVcLi9pcyI7fXM6Mjg6InBocCBTdGFydGluZyBjYWxscyBjOTlzaGV4aXQiO2E6Mjp7aTowO3M6NToiRDVESDciO2k6MTtzOjEwNjoiLzxcPyhwaHApKltcclxuIFx=XStcL1wvU3RhcnRpbmcgY2FsbHMuK2NoZGlyXChcJGxhc3RkaXJcKVs7XHJcbiBcdF=rW2EtejAtOV=rZXhpdFwoXClbO1xyXG4gXHRdKihcPz4pKi9pcyI7fXM6MzU6ImlmIGlzc2V=IFJFUVVFU1QgZm9yZWFjaCBhcnJheSBldmFsIjthOjI6e2k6MDtzOjU6IkczTjAxIjtpOjE7czoxNTk6Ii9pZltcc1woXSsoW2Etel8wLTldK1xzKlwoXHMqKSpcJF8oUkVRVUVTfEdFfFBPUylUXFtbXlx7XStce1xzKihcJFthLXpfMC=5XStccyo9W147XSs7XHMqfC4qP2ZvcmVhY2hcKGFycmF5Lio_KSpbXHNcQF=qKHN5c3RlbXxldmFsKVwoLitccyooZXhpdFteO1=qO1xzKikqXH=vaSI7fXM6MjA6InBocCBwYXNzd29yZCBoZ19leGl=IjthOjI6e2k6MDtzOjU6IkQ4SjdlIjtpOjE7czo=ODoiLzxcPyhwaHApPyhccykrXCRwYXNzd29yZCguKz8paGdfZXhpdFwoXCk7KC4rKS9zIjt9czo3MjoiaWYgZW1wdHkgU=VSVkVSIEhUVFBfVVNFUl9BR=VOVCBzZXRfdGltZV9saW1pdCBtb3ZlX3VwbG9hZGVkX2ZpbGUgcmV=dXJuIjthOjI6e2k6MDtzOjU6Ikc4R=JUIjtpOjE7czozMDM6Ii8oPGh=bWwuKj88Ym9keT5ccyopPzxcP1twaF=qXHMqKChwcmludHxlY2hvKVteO1=qO1xzKnxcL1wqW15cKl=qKFwqW15cKlwvXSopK1wvXHMqKSppZltcc1woXCFdKyhcQD9pc191cGxvYWRlZF9maWxlfGVtcHR5XChcJF9TRVJWRVJcW1siJ11IVFRQX1VTRVJfQUdFTlRbIiddXF1bXClcc1=rKC4rPylzZXRfdGltZV9saW1pdCkuKz9tb3ZlX3VwbG9hZGVkX2ZpbGUuKyhyZXR1cm4gXCRbYS16XzAtOV=rfHRvdWNoXHMqKFwvXCouKj9cKlwvXHMqKSpcKFteO1=rKTtbXHNcfV=rKCR8XD8-KFxzKjxcLyhib2R5fGh=bWwpPikqKS9pcyI7fXM6MzU6ImVycm9yX3JlcG9ydGluZyBpbmlfc2V=IHVubGluayBGSUxFIjthOjI6e2k6MDtzOjU6IkgyRjlqIjtpOjE7czozMDA6Ii9cQD9lcnJvcl9yZXBvcnRpbmdcKDBcKTtccyooaW5pX3NldFwoLitcQD91bmxpbmtcKF9fRklMRV9fXCk7fChpZltcc1woXCFdKyhpc3NldFwofGZpbGVfZXhpc3RzXCgpP1xzKlwkXyhTRVJWRVJ8UkVRVUVTVHxHRVR8UE9TVHxGSUxFUylcW1teXF1dK1xdK1teXCldKlwpW1wpXHNce1=qKGVjaG9bXjtdKztccyopKikrXEA_Y29weVwoKFtcc1wsXSpcJF9GSUxFUyhcW1teXF1dK1xdKykrKStbXClcc1=rO1tcc1x9XStcPz5ccyooPChmb3JtfGlucHV=KVtePl=rPlxzKikrPFwvZm9ybT5ccyooPFw_W3BoXHNdK1x9Kyk_KS9pcyI7fXM6MzE6InBocCBpZiBtZDUgUkVRVUVTVCBldmFsIFJFUVVFU1QiO2E6Mjp7aTowO3M6NToiRUJSTnUiO2k6MTtzOjE1NjoiLzxcP1twaFxzXSsoXCRbYS16XF8wLTldK1xzKj1ccyouKz87XHMqKSppZlwoXChtZDVcKFwkX1JFUVVFU1RcWy4rP2V2YWxcKFwkW2EtelxfMC=5XStcKFwkX1JFUVVFU1RcWy4qPztcfVx9XD8-KDxmb3JtW14-XSooPlxzKjxpbnB1dFtePl=qKSs-XHMqPFwvZm9ybT4pPy9zIjt9czozMzoiL2F1dGhfcGFzcyBsb3ZlIHNldF9lcnJvcl9oYW5kbGVyIjthOjI6e2k6MDtzOjU6IkRBTTlyIjtpOjE7czo5MzoiL1w8XD8oPz=uKlwkYXV=aF9wYXNzKSg_PS4qbG92ZUxvZ2luKSg_PS4qbG92ZXNldGNvb2tpZSkoPz=uKnNldF9lcnJvcl9oYW5kbGVyXCgpLisoXD9cPikqL2lzIjt9czo=OToiZnVuY3Rpb24gZ3ppbmZsYXRlIGJhc2U2NF9kZWNvZGUgZm9yIGNociBvcmQgZXZhbCI7YToyOntpOjA7czo1OiJGOFZHeCI7aToxO3M6MjIxOiIvKGZ1bmN=aW9uXHMrKFthLXpfMC=5XSspXHMqXChccyooXCRbYS16XzAtOV=rKVtcKVxzXHtdK1wzWz1cc1=rZ3ppbmZsYXRlXChiYXNlNjRfZGVjb2RlXCguK1tcKTtcc1=rKT9mb3JbXHNcKF=rLis_XHtccyooXCRbYS16XzAtOV=rKVtcLlxzXSo9W1xAXHNdKmNoclwoW147XStbO1xzXH1dKyhyZXR1cm5bXjtdKls7XH1cc1=rKT9ldmFsXCgoXDJcKHxcNClbXlwpXSpbXClcc1=rOyovaSI7fXM6MTg6Ii9mdW5jdGlvbiB4IGV2YWwgeCI7YToyOntpOjA7czo1OiJHNzFDNCI7aToxO3M6MTUxOiIvKGlmXHMqXChbXlx7XStce1xzKik_ZnVuY3Rpb25ccysoW2Etel8wLTldKylccypcKFteXHtdK1x7XHMqKFwkW2Etel8wLTldK1xzKj1bXjtdKztccyopKlxAPyhhc3NlcnR8ZXZhbClcKC4rP1wyXChcJF8oUkVRVUVTfEdFfFBPUylUXFsuKz9cKTtbXHNcfV=qL2lzIjt9czoxMToiaW5jbHVkZSBHRVQiO2E6Mjp7aTowO3M6NToiSDJBSzciO2k6MTtzOjI5MzoiLygoXCRbMC=5X2Etel=rKVxzKj1ccyooWyInXSkoW2EtelwvX1wtMC=5XC5dKlxceFthLWYwLTldezJ9KStbXlwzXSo_XDM7KT9bXEBcc1=qKGluY2x1ZGV8cmVxdWlyZSkoX29uY2UpP1tcc1woXSooXC9cKlteXCpdKihcKlteXCpcL1=qKStcL1xzKikqW1woXHNdKigoWyInXSkoW2EtelwvX1wtMC=5XC5dKlxceFthLWYwLTldezJ9KStbXlwxMF=qP1wxMHxcMnxcJF8oPyFSRVFVRVNUXFsndGFyZ2V=J1xdOykoUE9TfFJFUVVFU3xHRSlUXHMqKFxbW15cXV=rXF1ccyp8XHtbXlx9XStcfVxzKikrKVtcc1wpXSo7L2kiO31zOjIyOiJldmFsIGFycmF5X3BvcCBSRVFVRVNUIjthOjI6e2k6MDtzOjU6IkRCTTk1IjtpOjE7czo2MzoiL2V2YWxcKFtcdGEtel8wLTkgXChdKmFycmF5X3BvcFwoXCRfKEdFfFBPU3xSRVFVRVMpVFtcKV=rWztdKi9pIjt9czo=MjoiaWYgaXNzZXQgUkVRVUVTVCBldmFsIG9yIGZpbGVfcHV=X2NvbnRlbnRzIjthOjI6e2k6MDtzOjU6IkgxR=NnIjtpOjE7czozNzE6Ii88XD9bcGhcc1=rKGZ1bmN=aW9uIChbYS16XzAtOV=rKVwoW15ce1=rW1x7XHNdKy4rcmV=dXJuW147XSo7W31cc1=rKT9pZltcc1woXStpc3NldFtcc1woXStcJF8oUkVRVUVTfEdFfFBPUylUKFxzKlxbW15cXV=rXF=pK1tcKVxzXHtdKyhcJFthLXpfXC=wLTldK1xzKj1ccyouKz87XHMqKSooKChoZWFkZXJ8dW5saW5rKVwoW147XStbO1xzXSspezIsfVtcfVxzXSplbHNlW1x7XHNdKyhcJFthLXpfXC=wLTldK1xzKj1ccyouKz87XHMqKSooKFwkW2Etel9cLTAtOV=rXHMqPVxzKik_XEA_KGV2YWx8XDIpXCguKz9cKTtccyopezIsfXxmaWxlX3B1dF9jb25=ZW5=c1woW14sXSssXHMqYmFzZTY=X2RlY29kZVwoLis_XCk7KVtcfVxzXSooXD8-fCQpL2lzIjt9czoyMzoiaWYgZm9yIHVuc2V=IHdwX3dwIGZvcm=iO2E6Mjp7aTowO3M6NToiRThHQlAiO2k6MTtzOjEyNDoiLyhcJHdwW19dK3dwWyBcdF=qPVteO1=rO1tcclxuIFx=XSopKihpZnxmb3J8dW5zZXQpWyBcdF=qXChcJHdwW19dK3dwW147XSs7Lis_XD8-PGZvcm=uKz9uYW1lPVsnIl13cFtfXSt3cFsnIl=uKz88XC9mb3JtPi9pcyI7fXM6Mjg6ImFzc2VydCBIZXggNjRlbmNvZGVkVGV4dCBIZXgiO2E6Mjp7aTowO3M6NToiRjUyREUiO2k6MTtzOjI5NDoiLyhhc3NlcnRfb3B=aW9uc1woLis_XCk7XHMqfGZ1bmN=aW9uIFthLXpfMC=5XStcKFteXCldKltcKVxzXHtdKy4rP3JldHVyblteO1=qWztcfVxzXSt8XCQoY29sb3J8YXV=aHxwYXNzfGRlZmF1bHR8X18pW19cLVw-XC5hLXowLTldKlxzKj=uKz87XHMqKSooKChcJFthLXpfMC=5XSspXHMqPS4qP1wkXDJ8KFwkW2Etel8wLTldKylccyo9Lio_XDUpLipccyopKmFzc2VydFwoXHMqKCIoXFx4WzAtOUEtRl1bMC=5QS1GXSkrJ1tcL2EtelxfMC=5XD1dKycoXFx4WzAtOUEtRl1bMC=5QS1GXSkrInxcNilbXClcc1=rOy9pIjt9czoyNDoid2ViIHNoZWxsIGZvcGVuIHBhc3N=aHJ1IjthOjI6e2k6MDtzOjU6IkUyNjRxIjtpOjE7czo2OToiL14uKz9lcnJvcl9yZXBvcnRpbmdcKC4rP3dlYlsgXHRdKnNoZWxsLis_Zm9wZW5cKC4rP3Bhc3N=aHJ1XCguKz8kL2lzIjt9czo1NzoicGhwIGlmIGlzX2RpciBmaWxlX2dldF9jb25=ZW5=cyBpZiBmaWxlX3B1dF9jb25=ZW5=cyBlY2hvIjthOjI6e2k6MDtzOjU6Ikc3RDBXIjtpOjE7czozNDU6Ii88XD9bcGhcc1=rKFwvXC9bXlxuXSpbXHJcbl=rfFwkW2Etel8wLTldK1xzKj1bXjtdKjtccyp8ZXJyb3JfcmVwb3J=aW5nXChbXjtdKztccyopKy4rPyhpbmNsdWRlW147XSp3cC1jbGFzcy1oZWFkZXJzLnBocC4rP3xpZltcKFxzXStpc19kaXJbXlx7XStceyhccypcJFthLXpfMC=5XStccyo9ZmlsZV98W15cfV=rXH1ccyopZ2V=XyhhbGxfZGlyc1woLis_fGNvbnRlbnRzXChbXjtdKjtccypcJFthLXpfMC=5XStccyo9W147XSo7XHMqKGlmW1woXHNdKyk_KSlmaWxlX3B1dF9jb25=ZW5=c1woLis_KCh=b3VjaFwoLit8ZWNob1teO1=qO1xzKnxcfShccyplbHNlW1xzXHtdKyk_KVxzKikrKCR8XD8-KS9pcyI7fXM6NTM6InZhciBmdW5jdGlvbnMgcmV=dXJuIG5ldyBSZWN1cnNpdmVBcnJheUl=ZXJhdG9yIGFycmF5IjthOjI6e2k6MDtzOjU6IkUyNjZjIjtpOjE7czoxOTE6Ii8oXCRbYS16XF8wLTldK1tcdCA9XSsiW2EtelxfXC1cXDAtOV=qIjtbXHJcbiBcdF=qKSsoKFwkW2EtelxfMC=5XStbXHQgPV=rKT9cJFthLXpcXzAtOV=rXCgrLis_W1wpXSs7W1xyXG4gXHRdKikrLityZXR1cm5bIFx=XStuZXdbIFx=XStSZWN1cnNpdmVBcnJheUl=ZXJhdG9yW1woIFx=XSthcnJheS4rP1tcKSBcdF=rO1tcfV=rL2lzIjt9czo3NjoiZGlzcGxheV9lcnJvcnMgZmlsZV9nZXRfY29udGVudHMgX1JFUVVFU1QgZmlsZW5hbWUgdXBkYXRlX2NvZGUgZndyaXRlIHVubGluayI7YToyOntpOjA7czo1OiJHOE1KNCI7aToxO3M6MTUzOiIvXi4rPyhlcnJvcl9yZXBvcnRpbmdcKDBcKXxkaXNwbGF5X2Vycm9ycykuKz8oZmlsZV9nZXRfY29udGVudHNcKFteO1=qfHVybGRlY29kZVwoKVwkXyhQT3xSRVFVRSlTVFxbWyInXWZbaWxlXSpuYW1lW3NdP1siJ11cXS4rP2Z3cml=ZVwoLis_dW5saW5rXCguKyQvaXMiO31zOjUxOiJkaXNwbGF5X2Vycm9ycyBjcmVhdGVfd3BfdXNlciBSRVFVRVNUIGZ3cml=ZSB1bmxpbmsiO2E6Mjp7aTowO3M6NToiRTJGOWIiO2k6MTtzOjc5OiIvXi4rP2Rpc3BsYXlfZXJyb3JzLis_Y3JlYXRlX3dwX3VzZXJcKFwkX1JFUVVFU1RcWy4rP2Z3cml=ZVwoLis_dW5saW5rXCguKz8kL2lzIjt9czoxNzoicGhwIGNsYXNzIHZpYVdvcm=iO2E6Mjp7aTowO3M6NToiRjc=RWUiO2k6MTtzOjI1MjoiLzxcP1twaFxzXSsoXC9cKi4qP1wqXC9ccyopKihjbGFzcyB2aWFXb3JtXHMqXHsuKz9md3JpdGVcKC4rP2ZpbGVfZ2V=X2NvbnRlbnRzXCguKz91bmxpbmtcKC4rP2Jhc2U2NF9lbmNvZGVcKC4rPyk_ZmlsZV9wdXRfY29udGVudHNcKFteLF=rLFxzKmJhc2U2NF9kZWNvZGVcKChcQD9maWxlX2dldF9jb25=ZW5=c1woLit8W15cKV=rW1wpO1xzXStlY2hvW1xzXChdK2ZpbGVfZ2V=X2NvbnRlbnRzXChbXlwpXStbXCk7XHNdKygkfFw_PikpL2lzIjt9czo=MjoiaWYgaXNzZXQgUkVRVUVTVCBGSUxFIHN=cmlwc2xhc2hlcyBSRVFVRVNUIjthOjI6e2k6MDtzOjU6Ikc2OEMzIjtpOjE7czoyODI6Ii9pZltcc1woXStpc3NldFtcc1woXStcJF8oR=V8UE9TfFJFUVVFUylUKFxzKlxbW15cXV=qXF=rfFxzKlx7W15cfV=qXH=rKStbXHNcKVx7XSsoKFwkW2Etel8wLTldKylccyo9XHMqXCRfKEdFfFBPU3xSRVFVRVMpVChccypcW1teXF1dKlxdK3xccypce1teXH1dKlx9KykrW147XSpbO1xzXSopKihhc3NlcnR8ZXZhbHxcJFthLXpfMC=5XSspXHMqXCgrc3RyaXBzbGFzaGVzXChcJF8oR=V8UE9TfFJFUVVFUylUKFxzKlxbW15cXV=qXF=rfFxzKlx7W15cfV=qXH=rKStbXHNcKV=rO1tcfVxzXSovaSI7fXM6ODE6ImVycm9yX3JlcG9ydGluZyBldmFsIGN1cmxfaW5pdCBmaWxlX2dldF9jb25=ZW5=cyBmaWxlX3B1dF9jb25=ZW5=cyBpbmNsdWRlIHVubGluayI7YToyOntpOjA7czo1OiJFNUVEWiI7aToxO3M6MjAxOiIvXCRbYS16XF8wLTldK1s9XHNdK19fRklMRV9fO1xzKlwkW2EtelxfMC=5XStbXHM9XVteO117MjAwMH=uKj9lcnJvcl9yZXBvcnRpbmdcKC4rP2V2YWxcKC4rPyhjdXJsX2luaXR8ZmlsZV9nZXRfY29udGVudHMpLis_ZmlsZV9wdXRfY29udGVudHNcKC4rP2luY2x1ZGUuKj91bmxpbmtcKC4qP1wpO1xzKlx9XHMqZWxzZVxzKlx7W15cfV=rW1x9XSsvaXMiO31zOjU2OiJpZiBpc3NldCBQT1NUIGZpbGVfZ2V=X2NvbnRlbnRzIGZvcGVuIGZ3cml=ZSBmY2xvc2UgZXhpdCI7YToyOntpOjA7czo1OiJFNUlObyI7aToxO3M6MjkyOiIvKFwkYXV=aF9wYXNzWz1cc1=rLis_KT8oaWZbXHNdKlwoW1xzXSppc3NldFtcc1=qXChbXHNdKlwkXyhSRVFVRVN8R=V8UE9TKVRcWy4rP2ZpbGVfZ2V=X2NvbnRlbnRzXChfX=ZJTEVfXy4rP2ZvcGVuXCguKz9md3JpdGVcKC4qP2ZjbG9zZVwoLio_ZXhpdDtbXHNcfV=qKSsoaWZbXHNdKlwoW1xzXSppc3NldFtcc1=qXChbXHNdKlwkXyhSRVFVRVN8R=V8UE9TKVRcW1teXHtdK1tcc1x7XStpZltcc1=qXChbXHNdKmZpbGVfZXhpc3RzW1xzXSpcKFteXHtdK1tcc1x7XStbXlx9XStbXH1dW15cfV=qW1x9XSk_L2lzIjt9czo2MDoicGF=aCBpZiBmaWxlX2V4aXN=cyBpc193cml=YWJsZSBpZiBmdW5jdGlvbl9leGlzdHMgV3JpdGVEYXRhIjthOjI6e2k6MDtzOjU6IkU1RkN2IjtpOjE7czoxMzk6Ii9cJHBhdGhbPVxzXSsuK1tcc1=qaWZbXHNdKlwoXCFmaWxlX2V4aXN=c1woLis_aXNfd3JpdGFibGVcKFteXCldKltcKVxzXHtdK2lmW1xzXSpcKGZ1bmN=aW9uX2V4aXN=c1woLis_V3JpdGVEYXRhLis_V3JpdGVEYXRhXChcKTtbXHNcfV=rL2kiO31zOjUyOiJhdXRoX3Bhc3MgY29weSBGSUxFUyBleGVjIHBhc3N=aHJ1IHN5c3RlbSBzaGVsbF9leGVjIjthOjI6e2k6MDtzOjU6IkY=REgxIjtpOjE7czoxMjE6Ii88XD8oPz=uKlwkKG1kNXxhdXRoKV9wYXNzXHMqPSkoPz=uKmNvcHlcKFwkXyhQT1NUfEZJTEVTKVxbKSg_PS4qZXhlY1woKSg_PS4qcGFzc3RocnUpKD89LipzeXN=ZW=pKD89LipzaGVsbF9leGVjXCgpLisvaXMiO31zOjg4OiJwaHAgc2V=X3RpbWVfbGltaXQgZmlsZV9nZXRfY29udGVudHMgUkVRVUVTVCBmaWxlX2dldF9jb25=ZW5=cyBGSUxFUyBmb3BlbiBSRVFVRVNUZndyaXRlIjthOjI6e2k6MDtzOjU6IkU1SU5BIjtpOjE7czoxNTQ6Ii88XD8ocGhwKT8uKz9zZXRfdGltZV9saW1pdFwoLis_ZmlsZV9nZXRfY29udGVudHNcKFwkXyhSRVFVRVN8R=V8UE9TKVQuKz9maWxlX2dldF9jb25=ZW5=c1woXCRfRklMRVNcWy4rP2ZvcGVuXChcJF8oUkVRVUVTfEdFfFBPUylULis_ZndyaXRlXCguKz8oXD9cPikvaXMiO31zOjE=MDoiZXJyb3JfcmVwb3J=aW5nIGZ1bmN=aW9uIGVycm9yXzQwNCB=dHBfcmVxdWVzdF9jdXN=b2=gZ2V=SXAgZ2V=VXNlcmFnZW5=IGNvbnZlcnRJcFRvU3RyaW5nIGh=dHBfYnVpbGRfcXVlcnkgZmlsZV9nZXRfY29udGVudHMgZndyaXRlIGxvbmcyaXAiO2E6Mjp7aTowO3M6NToiRjdWOWgiO2k6MTtzOjIxMjoiLzxcPy4rP2Vycm9yX3JlcG9ydGluZ1woKD89Lis_Z2V=W19dKklwXCgpKD89Lis_ZnVuY3Rpb24gZXJyb3JfNDA=XCgpKCg_PS4rP3N=cmVhbV9jb25=ZXh=X2NyZWF=ZVwoKXwoPz=uKz9yZXF1ZXN=X2N1c3RvbVwoKSkoPz=uKz9odHRwX2J1aWxkX3F1ZXJ5XCgpKD89Lis_ZmlsZV9nZXRfY29udGVudHNcKCkoPz=uKz9oZWFkZXJcKCkoPz=uKz9sb25nMmlwXCgpLisvaXMiO31zOjQ1OiJpZiBmdW5jdGlvbl9leGlzdHMgZnVuY3Rpb24gdmFyaWFibGUgZnVuY3Rpb24iO2E6Mjp7aTowO3M6NToiRzM5S=YiO2k6MTtzOjMxMjoiLyhcL1wqW15cKl=qKFwqW15cKlwvXSopK1wvXHMqKSooXCRbYS16XzAtOV=rKFxzKlxbW15cXV=rXF=rKSpbXC5cc1=qPVteO1=rO1xzKikqaWZbXChcc1whXStmdW5jdGlvbl9leGlzdHNbXChcc1=rKFsnIl=pKC4rPylcNVtcKVxzXStce1xzKmZ1bmN=aW9uXHMqXDZccypcKC4rP3JldHVybi4qPztbXHNcfV=rKChcJFthLXpfMC=5XSspXHMqPVxzKihjcmVhdGVfZnVuY3Rpb25ccypcKFteLF=rLFxzKik_XDZcKFteO1=rWztcfVxzXSspKyhccyooXCRbYS16XzAtOV=rXHMqPVxzKik_XCRbYS16XzAtOV=rXChbXjtdK1siJ1wpO1x9XHNdKykrL2lzIjt9czo=NjoicGVybCB1c2UgSU86OlNvY2tldCBzY2FuX2RpciB1bmFtZSBzeXN=ZW=gZXhlYyI7YToyOntpOjA7czo1OiJFOFM3ZSI7aToxO3M6NzQ6Ii9cI1whXC91c3JcL2JpblwvcGVybC4rP3NjYW5fZGlyXCguKz91bmFtZVwoLis_c3lzdGVtXCguKz9maWxlbWFuYWdlci4rL2lzIjt9czo2MToiZnVuY3Rpb24gWF9pcCBYX21hY3JvcyBlcnJvcl8=MDQgaHR=cF9yZXF1ZXN=IGZ3cml=ZSBGVU5DVElPTiI7YToyOntpOjA7czo1OiJFOUg5NSI7aToxO3M6MTE2OiIvXDxcPy4rP19pcFwoKC4rP2Z1bmN=aW9uIFthLXowLTldK19tYWNyb3NcKCl7NH=uKz9mdW5jdGlvbiBlcnJvcl8=MDRcKC4rP2h=dHBfcmVxdWVzdC4rP2Z3cml=ZVwoLis_X19GVU5DVElPTl9fLisvcyI7fXM6MzE6ImlmIGlzc2V=IGV2YWwgVmFyaWFibGUgZnVuY3Rpb24iO2E6Mjp7aTowO3M6NToiRzRDRUQiO2k6MTtzOjI1NzoiLyhcQD9=b3VjaFwoLipcKSs7XHMqKSooXCRbYS16XzAtOVx7XCRcfV=rKFxzKlxbW15cXV=rXF=pKlxzKj1bXjtdKztccyopKmlmW1xzXChcIV=raXNzZXRbXHNcKF=rXCRbYS16XzAtOVx7XCRcfV=rKFxzKlxbW15cXV=rXF=pKltcKVxzXHtdKy4qP1xzKihcJFthLXpfMC=5XHtcJFx9XSsoXHMqXFtbXlxdXStcXSkqXHMqPVxzKik_XEA_ZXZhbFwoLio_XCRbYS16XzAtOVx7XCRcfV=rKFxzKlxbW15cXV=rXF=pKlxzKlwoLio_XCkrO1s7XH1cc1=qL2kiO31zOjU3OiJlcnJvcl9yZXBvcnRpbmcgZXhlYyBzeXN=ZW=gcGFzc3RocnUgZm9wZW4gUkVRVUVTVCBmd3JpdGUiO2E6Mjp7aTowO3M6NToiRjQ3NTUiO2k6MTtzOjIzNjoiLzxcPy4rPyhzZXRfdGltZV9saW1pdFwoMHxlcnJvcl9yZXBvcnRpbmdcKDB8ZXhwbG9kZVwoWyciXXdwLWNvbnRlbnQpKD89Lis_dW5saW5rXHMqXCgpKD89Lis_cGFzc3RocnVccypcKCkoPz=uKz9zeXN=ZW1ccypcKCkoPz=uKz9leGVjXHMqXCgpKCg_PS4rP2N1cmxfaW5pdFxzKlwoKSg_PS4rP2ZpbGVfZ2V=X2NvbnRlbnRzXHMqXCgpfCg_PS4rP3JlYWRkaXJccypcKCkpKD89Lis_ZndyaXRlXHMqXCgpLisvaXMiO31zOjg3OiJpbmlfc2V=IG9iX3N=YXJ=IHJlZ2lzdGVyX3NodXRkb3duX2Z1bmN=aW9uIGlmIEhUVFBfVVNFUl9BR=VOVCBmaWxlX2dldF9jb25=ZW5=cyByZXR1cm4iO2E6Mjp7aTowO3M6NToiRjVLN2oiO2k6MTtzOjI3NjoiL1xAP2luaV9zZXRcKC4rXHMrKFxAP29iX3N=YXJ=XChbIiddKC4rPylbJyJdXCk7XHMrXEA_cmVnaXN=ZXJfc2h1dGRvd25fZnVuY3Rpb25cKC4rXHMrKGZ1bmN=aW9uIFwyXChcJFthLXpcXzAtOV=rW1wpXHNce1=raWYuKz9IVFRQX1VTRVJfQUdFTlQuK1tcKVxzXHtdKy4rP2ZpbGVfZ2V=X2NvbnRlbnRzLitccypyZXR1cm5bXjtdKjtbXHNcfV=rKT98KFwkW2EtelxfMC=5XSspXHMqPVxzKmJhc2U2NF9kZWNvZGVcKC4rXHMqZWNoby4rP2ZpbGVfZ2V=X2NvbnRlbnRzXChcNC4rKS9pIjt9czozODoiaWYgQ=9PS=lFIGd6aW5mbGF=ZSBiYXNlNjRfZGVjb2RlIGV2YWwiO2E6Mjp7aTowO3M6NToiRjRMRDgiO2k6MTtzOjI=NzoiL2lmXHMqXCguKz9cKFwkX=NPT=tJRS4rP1tce1xzXSooXCRbYS16XzAtOV=rKVxzKj=uKj9iYXNlNjRfZGVjb2RlXCgoLis_ZXZhbFwoXDFcKS4rfFteO1=rWztcc1=rKFwkW2Etel8wLTldKylccyo9W147XStbO1xzXSsoZmlsZV9wdXRfY29udGVudHNcKFwzLis_XDFbXjtdK1s7XHNdK3xlY2hvW1woXHNdK1snIl1cXHguKz9bJyJdW1wpO1xzXSsoaW5jbHVkZXx1bmxpbmspW1woXHNdK1wzW1wpO1xzXSspezMsfS4rKVtcc1x9XSovaSI7fXM6MjE6ImlmIGlzc2V=IFJFUVVFU1QgZXZhbCI7YToyOntpOjA7czo1OiJHMUg4UiI7aToxO3M6MjcyOiIvKChcJFtfYS16MC=5XStccyo9W147XSs7XHMqKSppZltcc1woXStpc3NldFtcKFxzXStcJF8oUkVRVUVTfEdFfFBPUylUXFtbXlxdXStcXVtcKVxzXStce1xzKihcJFtfXC5hLXowLTldK1s9XHNdK1wkXyhSRVFVRVN8R=V8UE9TKVRcW1teXF1dK1xdWztcc1=rKSsoKFwkW19hLXowLTldK1s9XHNdKyk_KGV2YWx8ZmlsZV9wdXRfY29udGVudHN8Zm9wZW58ZndyaXRlfGZjbG9zZSlcKFteXCldK1wpO1xzKikrKChlY2hvfGV4aXQpW15cO1=qO1xzKikqXH1ccyooZWxzZSk_KSsvaSI7fXM6MzU6ImlmIGlzc2V=IGJhc2U2NF9kZWNvZGUgUkVRVUVTVCBldmFsIjthOjI6e2k6MDtzOjU6IkY=U=RWIjtpOjE7czozMDg6Ii88XD9bcGhcc1=rKChcQD8oaWdub3JlX3VzZXJfYWJvcnR8c2V=X3RpbWVfbGltaXQpXCh8XCRbX1wuYS16MC=5XStccyo9KVteO1=rWztcc1=rKSppZltcKFxzXCFdKyhpc3NldHxlbXB=eSlbXChcc1=rXCRfKFJFUVVFU3xHRXxQT1MpVFxbLitbXHNce1=rKFwkW19cLmEtejAtOV=rKVxzKj1ccyooYmFzZTY=X2RlY29kZXxcJFthLXpfMC=5XSspXHMqXCgrXHMqXCRfKFJFUVVFU3xHRXxQT1MpVFxbW15cXV=rXF1bXCk7XHNdK1xAP2V2YWxcKFw2XCk7XHMqXH=oXHMqZWxzZVtcc1x7XStlY2hvICJbXiJdKlsiO1xzXH1dKyk_KCR8XD8-KS9pIjt9czo1Njoic2V=X3RpbWVfbGltaXQgdW5saW5rIGJhc2U2NF9kZWNvZGUgZndyaXRlIGV4ZWMgcGFzc3RocnUiO2E6Mjp7aTowO3M6NToiRTlQNzMiO2k6MTtzOjk5OiIvPFw_KHBocCk_Lis_c2V=X3RpbWVfbGltaXRcKDBcKS4rP3VubGlua1woLis_YmFzZTY=X2RlY29kZVwoLis_ZndyaXRlXCguKz9leGVjXCguKz9wYXNzdGhydVwoLisvaXMiO31zOjM=OiJtb3ZlX3VwbG9hZGVkX2ZpbGUgX=ZJTEVTIF9fRklMRV9fIjthOjI6e2k6MDtzOjU6IkgxOEdmIjtpOjE7czoyNjA6Ii88XD9bcGhcc1=rKChcJFthLXpfMC=5XSspXHMqPVxzKlwkX=ZJTEVTXFtbXjtdKztccyooXCRbYS16XzAtOV=rKVxzKj1bXjtdKztccyppZltcc1woXStmaWxlX2V4aXN=c1tcc1woJyJcLlwvXStcM1tcc1woJyJcKVxzXSt1bmxpbmtbXHNcKCciXC5cLyldK1wzKT8uKj8obW92ZV91cGxvYWRlZF9maWxlW1xzXChdKyhcJF9GSUxFU1xbW14sXStbLFxzXStfX=ZJTEVfX3xcMil8c3lzdGVtXChbJyJdbXYgWyciXVwuXCRfRklMRVNcWykuKj8oJHxcPz4pL2lzIjt9czo1ODoicGhwIGlmIGlzc2V=IFJFUVVFU1QgZXZhbCBmaWxlX3B1dF9jb25=ZW5=cyBpbmNsdWRlIHVubGluayI7YToyOntpOjA7czo1OiJIMk9IUSI7aToxO3M6NDc3OiIvPFw_W3BoXHNdKyhcQD8oaWdub3JlX3VzZXJfYWJvcnR8c2V=X3RpbWVfbGltaXR8ZXJyb3JfcmVwb3J=aW5nKVwoLio_XCk7XHMqKSooXCRbYS16XzAtOV=rXHMqPS4rPztccyopKih=cnlccyp8aWZbXHNcKFwhXSsoZW1wdHl8c3RybGVufGlzc2V=KVwoXCRfKFJFUVVFU3xHRXxQT1MpVFteXHtdKylcey4qPyhcJFthLXpfMC=5XSspXHMqPS4rPyhjKHUpcmxfW15cKV=rfChlKXZhbFwoKVw3XCkuKz9maWxlXy4oXDl8XDEwKXRfY29udGVudHNbXCggXSsoW1wkYS16XzAtOVxbJyJcXVwuXSspLis_KGVjaG9bXHNcKF=rXDEyfGluY2x1ZGUoX29uY2UpP1tcKFxzXStcMTIuKz91bmxpbmtbXChcc1=rXDEyfGN1cmxfaW5pdFwoLis_Y3VybF9zZXRvcHRcKFteLF=rLFxzKkNVUkxPUFRfVVJMWyxcc1=rXDEyfFx9XHMqY2F=Y2hccypcKFxzKkV4Y2VwdGlvblxzKlwkW2Etel8wLTldK1tcKVxzXSpce1teXH1dKlx9XHMqKS4qPyhcPz58JCkvaXMiO31zOjQzOiJwaHAgY2hkaXIgUkVRVUVTVCBnZXRjd2QgbW92ZV91cGxvYWRlZF9maWxlIjthOjI6e2k6MDtzOjU6IkgzMkNzIjtpOjE7czoyNjk6Ii88XD8qLis_KGNoZGlyW1woXHNdK1wkXyhSRVFVRVN8UE9TfEdFKVRcW3xlcnJvcl9yZXBvcnRpbmdbXChcc1=rMC4rP1tnc11ldF8odGltZV9saW1pdFtcKFxzXSswfG1hZ2ljX3F1b3Rlcy4rP2hhY2tlW3JkXSkpLis_KFwkW2Etel8wLTldKylbPVxzXEBdK2dldGN3ZFtcc1woXSsuKz8oY29weXxtb3ZlX3VwbG9hZGVkX2ZpbGUpW1xzXChdKyguKz91bmxpbmtbXHNcKF=rLis_c2NhbmRpcltcc1woXStcNHxcJF9GSUxFU1xbW14sXStbLFxzXStcMykuKz8oXD8-fCQpL2lzIjt9czozNzoicGhwIGNyZWF=ZV9mdW5jdGlvbiBWYXJpYWJsZSBmdW5jdGlvbiI7YToyOntpOjA7czo1OiJIMUhBWiI7aToxO3M6MjM2OiIvPFw_W3BoXHNdKihcL1wqKFteXCpdKlwqW15cL1=pKlteXCpdKlwqXC9ccyp8XC9cLy4qXHMqKSooKFwkW2Etel9cLTAtOV=rKVxzKj=uKztccyp8aWZccypcKFteXHtdK1x7XHMqKSsoKFwkW2Etel9cLTAtOV=rKVxzKj1ccyopP2NyZWF=ZV9mdW5jdGlvblwoW14sXSssXHMqKFw=W147XSs7W1xzXEBdKlw2XCh8IihcXChbMC=5XXsyLDN9fHhbMC=5YS1mXXsyfSkpKyIpW15cKV=qW1wpO1xzXH1dKygkfFw_PikvaSI7fXM6NDg6InBocCBhcnJheSBmb3JlYWNoIGFycmF5IGV2YWwgQXJyYXkgRnVuY3Rpb24gUE9TVCI7YToyOntpOjA7czo1OiJFQVVOcCI7aToxO3M6MTIxOiIvPFw_W3BoXSpccysoXCRbYS16XC1cXzAtOV=rKVs9XHNdK2FycmF5XChbXjtdKztccypmb3JlYWNoW1xzXChdK1wxLis_ZXZhbFtcc1woXStcMVxbW15cXV=rXF=rW1woXHNdK1wkX1BPU1RcW1wxLis_XD8-L2lzIjt9czo3NzoiZndyaXRlIHVubGluayBldmFsIGNobW9kIFBPU1QgcGhwaW5mbyBtb3ZlX3VwbG9hZGVkX2ZpbGUgZXhlYyBzeXN=ZW=gcGFzc3RocnUiO2E6Mjp7aTowO3M6NToiRUI3RXQiO2k6MTtzOjE1MzoiLzxcPy4rP2Vycm9yX3JlcG9ydGluZ1woMFwpLis_ZndyaXRlXCguKz91bmxpbmtcKC4rP2V2YWxcKC4rP2NobW9kXChcJF9QT1NUXFsuKz9waHBpbmZvXCguKz9tb3ZlX3VwbG9hZGVkX2ZpbGVcKCguKz8oZXhlY1wofHN5c3RlbVwofHBhc3N=aHJ1XCgpKXszfS4rL2lzIjt9czoyOToicG9zdCBzdHJ=b3VwcGVyIGlmIGlzc2V=IGV2YWwiO2E6Mjp7aTowO3M6NToiRkIzQmUiO2k6MTtzOjE4NzoiLygoXCRbYS16XzAtOV=rKVxzKj1bXjtdKztccyopKyhcJFtfYS16MC=5XStccyo9XHMqKFwkW2Etel8wLTldK3xzdHJ=by4uLmVyKVxzKlwoKFtcc1wuXSpcJFthLXpfMC=5XStccypcW1xkK1xdKStbXCk7XHNdKykraWZbXChcc1=raXNzZXRccypcKFteXCldK1tcKVxzXStce1xzKmV2YWxccypcKFteXCldK1tcKTtcc1=rXH=vaSI7fXM6MzQ6ImlmIGlzc2V=IFJFUVVFU1QgVmFyaWFibGUgRnVuY3Rpb24iO2E6Mjp7aTowO3M6NToiRzlSTm8iO2k6MTtzOjI=NDoiL2lmW1xzXChcIV=rKGlzc2V=fGVtcHR5KVtcc1woXStcJF8oUkVRVUVTVHxHRVR8UE9TVHxDT=9LSUUpLitbXHtcc1=qKFwkW2Etel8wLTlce1x9XStccyo9XHMqKCdbXiddKid8IlteIl=qInxcJClbXjtdKlsnIjtcKVxzXSopKihcJFthLXpfMC=5XStccyo9XHMqKT9cQD8oXCQoPyFkZWxldGVfc2VydmljZSlbYS16XzAtOV=rKShccypcW1teXF1dKlxdKSpzKlwoLio_W1wpXSs7W1x9XHNdKihlbHNlXHMqXHtbXn1dK1x9KT8vaSI7fXM6NjU6ImlmIGFycmF5X2tleXMgR=VUIGZpbGVfZ2V=X2NvbnRlbnRzIGlmIHVubGluayBmb3BlbiBmd3JpdGUgZmNsb3NlIjthOjI6e2k6MDtzOjU6Ikc2QkMwIjtpOjE7czoyOTM6Ii8oXEA_KGlnbm9yZV91c2VyX2Fib3J=fGluaV9zZXR8c2V=X3RpbWVfbGltaXR8ZXJyb3JfcmVwb3J=aW5nKVwoLio_XCk7XHMqfFwkW2Etel8wLTldK1xzKj1bXjtdKztccyopKigoKGlmXHMqXCh8ZWxzZSlbXlx7XSpce1xzKik_ZnVuY3Rpb25ccysuKz9yZXR1cm5bXjtdKjtbXHNcfV=rKSsoKFwkW2Etel8wLTldK1xzKj1ccyopP1wkW2Etel8wLTldK1woW147XStbIidcKTtcfVxzXSopKy4rPyhmKG9wZW58d3JpdGV8Y2xvc2UpXCguKz8pezMsfWluY2x1ZGVcKC4qP1wpO1xzKnVubGlua1woLio_XCk7XHMqL2lzIjt9czo=MToiaWYgYXJyYXlfa2V5cyBHRVQgZXZhbCBiYXNlNjRfZGVjb2RlIGV4aXQiO2E6Mjp7aTowO3M6NToiRUNGRkYiO2k6MTtzOjIxOToiLzxcP1twaFxzXSooXEA_ZXJyb3JfcmVwb3J=aW5nXCgwXCk7XHMqKT9pZltcKFxzXSthcnJheV9rZXlzXChcJF9HRVQuK1xzKygoPFw_W3BoXHNdKik_XCRbYS16XF8wLTldK1tcc1x7XCRdK1xAP2V2YWxcKGJhc2U2NF9kZWNvZGVcKFsnIl1bYS16XF9cL1wrXD=wLTldK1snIl1bXClcfVx7XCRcc1=rZXhpdFwoW1wpXH1cc1=rXCZccypcJFthLXpcXzAtOV=rWztcc1x9XStcPz4pKy9pIjt9czozOToiYmFzZTY=X2RlY29kZSBmdW5jdGlvbiBjdXJsIHJldHVybiBleGl=IjthOjI6e2k6MDtzOjU6IkVDRkpWIjtpOjE7czoxOTg6Ii88XD9bcGhcc1=qKFwvXCouKz9cKlwvXHMqKSooXCRbYS16XF8wLTldK1xzKj1ccypiYXNlNjRfZGVjb2RlXChbXjtdK1tcKTtcc1=qKStmdW5jdGlvblxzKyhbYS16XF8wLTldKylccypcKFteXHtdK1tce1xzXSsoKFwkW2EtelxfMC=5XStbXHMqPV=rKT9jdXJsX1teO1=rO1xzKikrcmV=dXJuIC4rXDNcKC4rZXhpdDtbXH1cc1=rKCR8XD8-KS9pcyI7fXM6NDA6InBocCBpZiBpc3NldCBHRVQgZWNobyBpZiBQT1NUIGNvcHkgRklMRVMiO2E6Mjp7aTowO3M6NToiRzNJQ=wiO2k6MTtzOjU5MjoiLzxcP1twaFxzXSooZWNob1teO1=qO1xzKnxlcnJvcl9yZXBvcnRpbmdcKDBcKTtccyp8XC9cKi4qP1wqXC9ccyooXCRbYS16XzAtOV=rXHMqPVteO1=rO1xzKnxcL1wvW15cbl=qXHMqKSsoaWZbXHNcKF=raXNzZXRcKFwkXyhSRVFVRVN8R=V8UE9TKVRcW1teXF1dK1xdKVteXCldKltcKVxzXHtdKyhcJFthLXpfMC=5XStccyo9XHMqXCRfW2Etel8wLTldK1xbW15cXV=rXF=7XHMqKSsoXCRbYS16XzAtOV=rXHMqPVxzKlwkW2Etel8wLTldK1woW15cKV=rXCkrO1xzKikrLio_XDNbXlx7XStbXlx9XStcfVxzKihcPz5ccyo8XD9bcGhcc1=qKT8pKmlmW1xzXChdK2lzc2V=XChcJF8oUkVRVUVTfEdFfFBPUylUW15cKV=rW1wpXHNce1=rKChlY2hvfHByaW5=fFwkW2EtelxfMC=5XStccyo9KVteO1=rO1xzKikraWZbXHNcKF=rXCRfKFJFUVVFU3xHRXxQT1MpVFteXCldK1tcKVxzXHtdK2lmW1xzXChdK1xAP2NvcHlcKChbXHNcLF=qXCRfRklMRVMoXFtbXlxdXStcXSkrKStbXClcc1=rXHtbXlx9XSsoW1x9XHNdKyhlbHNlW1xzXHtdK1teXH1dKyk_KSsoXD8-XHMqKDwodGl=bGU-aGFja2VkLmJ5W15cbl=qfFwvW2Etel=rPilccyopKnwkKS9pcyI7fXM6NTE6ImlmIGlzc2V=IEZJTEVTfFJFUVVFU1QgbW92ZV91cGxvYWRlZF9maWxlIGVsc2UgZWNobyI7YToyOntpOjA7czo1OiJGMlJCbCI7aToxO3M6NTA5OiIvPFw_W3BoXHNdKygoXCRbYS16XF8wLTldK1xzKj18c2V=X3RpbWVfbGltaXRcKHxpbmlfc2V=XCgpW147XStbO1xzXSspKigoW2EtelxfMC=5XSspXChbXjtdK1s7XHNcfV=rKT8oaWZbXChcc1=rc3Vic3RyW1woXHNdK1teXHtdK1tcc1x7XSsoXCRbYS16XF8wLTldK1xzKj1bXjtdK1s7XHNcfV=rKSspPyhpZltcKFxzXSsoaXNzZXRbXChcc1=rKT9cJF8oRklMRVN8UkVRVUVTVHxQT1NUfEdFVClbXlwpXSpbXClcc1x7XSsoXCRbYS16XzAtOV=rXHMqPVteO1=rO1xzKikqKSsoXEB8aWZbXChcc1=rKSptb3ZlX3VwbG9hZGVkX2ZpbGVcKFteO1=rKFs7XHNcfV=rKGVsc2VbXHtcc1=rfChlY2hvfGV4aXQpW147XSpbO1xzXH1dKykqKSsoZnVuY3Rpb25ccytcNFwoW147XStbO1xzXH1dKyhcJFthLXpcXzAtOV=rXHMqPVteO1=rWztcc1x9XSspKmlmW1woXHNdK1teXHtdK1tcc1x7XSsoXEB8aWZbXChcc1=rKSpta2RpclwoW147XStbO1xzXH1dK3JldHVyblteO1=rWztcc1x9XSspPyhcPz58JCkvaSI7fXM6NTM6ImV4ZWMgc3lzdGVtIHBhc3N=aHJ1IGZ3cml=ZSBWYXJpYWJsZSBGdW5jdGlvbiBSRVFVRVNUIjthOjI6e2k6MDtzOjU6IkY3UE1SIjtpOjE7czoyMTY6Ii88XD9bcGhcc1=rKChcJFthLXpfMC=5XSspXHMqPVxzKihbYS16XzAtOV=rXChccyopXCRfKFJFUVVFU3xHRXxQT1MpVFxbLioocGFzc3RocnV8ZXhlY3xzeXN=ZW18XCRbYS16XzAtOV=rKVwoW1xzIl=qXDJ8Lis_ZXhlY1woLis_c3lzdGVtXCguKz9wYXNzdGhydVwoLis_ZndyaXRlXCguKz9cQD9cJFthLXpfMC=5XStcKFwkXyhSRVFVRVN8R=V8UE9TKVQpLis_KCR8XD8-KS9pcyI7fXM6NTU6InBocCBWYXJzIEFycmF5IGJhc2U2NF9kZWNvZGUgZnVuY3Rpb24gVmFyaWFibGUgRnVuY3Rpb24iO2E6Mjp7aTowO3M6NToiRzVENlMiO2k6MTtzOjI3NToiLyhcJFthLXpfMC=5XStccyo9W147XStbO1xzXSspKihcJFtcJFx7XSpbYS16XzAtOV=rXH=qKFxzKlxbW15cXV=rXF18XHMqXHtbXlx9XStcfSkqKVxzKj1ccyphcnJheVtcKFxzXStiYXNlNjRfZGVjb2RlXCguKz9mdW5jdGlvbiAoW2Etel8wLTldKylccypcKC4rP1wyXHMqKFxbW15cXV=rXF1ccyopKlwoLisoXCRbXCRce1=qW2Etel8wLTldK1x9KihccypcW1teXF1dK1xdfFxzKlx7W15cfV=rXH=pKilccyo9XDRcKC4rPyhlY2hvfGRpZXxwcmludClbXHNcKF=qXDZbXjtdKjsvaXMiO31zOjM2OiJpZiByZW5hbWUgb3IgZmlsZV9wdXRfY29udGVudHMgdG91Y2giO2E6Mjp7aTowO3M6NToiRjJORTYiO2k6MTtzOjkxOiIvPFw_Lis_Y29weVwoX19GSUxFX18sLis_ZmlsZV9wdXRfY29udGVudHNcKC4rP3VubGlua1woLis_aGVhZGVyXCgiTG9jYXRpb246IGh=dHA6XC9cLy4rL2lzIjt9czozMzoiaHRtbCBoZWFkIHVuemlwIEZJTEVTIHVubGluayBmb3JtIjthOjI6e2k6MDtzOjU6IkcyUUNCIjtpOjE7czoyMzA6Ii9ePGh=bWw-XHMqPGhlYWQ-Lis_KGZpbGVwZXJtc1xzKlwoLis_KHBvc2l4X2dldFtwd3Vncl=raWRccypcKC4rPyl7Mix9bW92ZV91cGxvYWRlZF9maWxlXHMqXCguKz9mcHV=c1xzKlwoLis_dW5saW5rXHMqXCguKz9leGVjXHMqXCguKz9ccypyZWFkZGlyXCguKz9cP3x1bnppcFwoXCRfRklMRVNcWy4rP3VubGlua1woXCQuK1w_PlxzKjxcL2Zvcm=pPlxzKjxcL2JvZHk-XHMqPFwvaHRtbD5ccyokL2lzIjt9czo4OToiY3VybF9pbml=IGhlYWRlciBMb2NhdGlvbiByZXR1cm4gcHJlZ19yZXBsYWNlX2NhbGxiYWNrIGNyZWF=ZV9mdW5jdGlvbiByZXR1cm4gUkVNT1RFX=FERFIiO2E6Mjp7aTowO3M6NToiRUNUMmUiO2k6MTtzOjE=NjoiLzxcPy4rP2N1cmxfaW5pdFwoLis_aGVhZGVyW1woIidcc1=rTG9jYXRpb246Lis_cmV=dXJuIHByZWdfcmVwbGFjZV9jYWxsYmFja1woLis_Y3JlYXRlX2Z1bmN=aW9uXCguKz9yZXR1cm4gXCRfU=VSVkVSXFtbIiddUkVNT1RFX=FERFIuKyhcPz58JCkvaXMiO31zOjgxOiJwaHAgYmFzZTY=X2RlY29kZSBmaWxlX3B1dF9jb25=ZW5=cyB1bmxpbmsgZnVuY3Rpb25fZXhpc3RzIEhleCBjYWxsX3VzZXJfZnVuYyBIZXgiO2E6Mjp7aTowO3M6NToiRjE2MHEiO2k6MTtzOjM1NjoiLzxcP1twaFxzXSsoXCRce1teXH1dK1tcfVxzXSsoXFtbXlxdXStbXF1cc1x9XSspKj1bXjtdK1s7XHNdKyhcQD8oXCRbYS16XzAtOV=rXHMqPXxkZWZpbmVcKHxzZXNzaW9uX3N=YXJ=XCh8ZXJyb3JfcmVwb3J=aW5nXCh8aW5pX3NldFwofHNldF9=aW1lX2xpbWl=XCh8c2V=X21hZ2ljX3F1b3Rlc19ydW5=aW1lXCgpW147XStbO1xzXSt8aWZcKFteXHtdK1tce1xzXStbXlx9XStbXH1cc1=rKSopKyhbXjtdK1s7XHNdKyk_LitmaWxlX3B1dF9jb25=ZW5=c1woLis_YmFzZTY=X2RlY29kZVwoLis_dW5saW5rXCguKz9mdW5jdGlvbl9leGlzdHNcKFsnIl1cXHguKz9jYWxsX3VzZXJfZnVuY1woWyciXVxceC4rPygkfFw_PikvaXMiO31zOjUzOiJwaHAgZnVuY3Rpb24gZmlsZV9nZXRfY29udGVudHMgZndyaXRlIHVubGluayBfX=ZJTEVfXyI7YToyOntpOjA7czo1OiJHNDZLSyI7aToxO3M6MTU=OiIvPFw_W3BoXHNdKyhcJFthLXpfMC=5XStccyo9W147XSs7XHMqKSpmdW5jdGlvbiAoW2Etel8wLTldKylcKC4rZmlsZV9nZXRfY29udGVudHNcKC4rZm9wZW5cKC4rZndyaXRlXCguK2ZjbG9zZVwoLitcMlwoLit1bmxpbmtcKF9fRklMRV9fXCk7XHMqKCR8XD8-XHMqKS9pIjt9czo1NToiaHRtbCBib2R5IHBocCBvcGVuZGlyIHJlYWRkaXIgIWZpbGVfZXhpc3RzIGZvcGVuIGZ3cml=ZSI7YToyOntpOjA7czo1OiJGMkRKViI7aToxO3M6MjIxOiIvKDwoXCF8XC8pPyhkb2N=eXBlfGh=bWx8aGVhZHxtZXRhfHRpdGxlfGJvZHkpW14-XSo-W2Etel8wLTlcc1=qKXsyLH=8XD9bcGhcc1=rXCRbYS16XF8wLTldK1xzKj1ccyonPFw_W3BoXHNdKy4rP29wZW5kaXJcKC4rP3JlYWRkaXJcKC4rPyhcIWZpbGVfZXhpc3RzXCguKz9mb3BlblwoLis_ZndyaXRlXCguKz8pezMsfVw_PlxzKig8XC8oaHRtbHxib2R5KVtePl=qPlxzKil7Mix9JC9pcyI7fXM6Njg6InBocCBmdW5jdGlvbiBkaWUgc2V=Y29va2llIGlmIGVtcHR5IGlmIGlzc2V=IGZvcm=gbW92ZV91cGxvYWRlZF9maWxlIjthOjI6e2k6MDtzOjU6Ikc5Mkp3IjtpOjE7czo2MDE6Ii88XD9bcGhcc1=rKChcJFthLXpfMC=5XSspXHMqPVteO1=rO1xzKikqKGlmW1woXHNdKyhcMnxcIWVtcHR5W1woXHNdKylbXlx7XStce1xzKigoKChcJFthLXpfMC=5XSspXHMqPVxzKik_KFwyXCguKj9cKSt8XCRfKFJFUVVFU3xHRXxQT1MpVFteO1=rKTtccyp8aWZbXChcc1whXSsoaXNzZXRbXChcc1=rLis_XCkrXHMrW2Etel8wLTldK3xcOFteXH1dKikpKStbXH1cc1=qfGZ1bmN=aW9uIFthLXpfMC=5XStcKFteXHtdK1x7XHMqKGRpZVwoLis_XCk7XHMqfChcJF9DT=9LSUUuKz87XHMqfHNldGNvb2tpZVwoLis_XCk7XHMqKXsyfSlcfVxzKikrKFtcc1x7XSooXCRbYS16XzAtOV=rKVxzKj1ccypcJF8oUkVRVUVTVHxHRVR8UE9TVHxGSUxFKVteO1=rO1tcc1x9XSopKihcPz5ccyp8ZWNob1tcc1woXSooWyciXSkpKDwoZm9ybXxpbnB1dClbXj5dKj5bYS16XDowLTlcc1=qKSs8XC9mb3JtPihccyo8XD9bcGhcc1=rfFsnIl=7XHMqKShcJFthLXpfMC=5XStccyo9W147XSs7XHMqfGlmW1xzXChdKykqKG1vdmVfdXBsb2FkZWRfZmlsZVwoW15cO1=rfChcJFthLXpfMC=5XSspXHMqPVxzKlwkW2Etel8wLTldK1xzKlwoLio_XCkpO1tcc1x9XSooJHxcPz4pL2kiO31zOjEyOToicGhwIHNldF9=aW1lX2xpbWl=IGluaV9zZXQgZXJyb3JfcmVwb3J=aW5nIGlmIGFycmF5X2tleV9leGlzdHMgSFRUUF9VU=VSX=FHRU5UIHNlYXJjaC1=cmFja2VyLmNvbSBwcmVnX21hdGNoIGdvb2dsZSBiaW5nIG9iX3N=YXJ=IjthOjI6e2k6MDtzOjU6IkYzSktoIjtpOjE7czoyMzA6Ii88XD9bcGhcc1=rLio_c2V=X3RpbWVfbGltaXRcKC4rP2luaV9zZXRcKC4rP2Vycm9yX3JlcG9ydGluZ1woLis_aWZbXChcIVxzXSthcnJheV9rZXlfZXhpc3RzXChbIiddSFRUUF9VU=VSX=FHRU5ULis_aHR=cDpcL1wvc2VhcmNoLXRyYWNrZXJcLmNvbVwvaW5cLmNnaVw_Lis_KHByZWdfbWF=Y2hcKFsiJ11cLyhbXlwvXSpnb29nbGV8W15cL1=qYmluZyl7Mn=uKz8pezJ9Lis_b2Jfc3RhcnRcKC4rL2lzIjt9czo3MjoiYmFzZTY=X2RlY29kZSBmaWxlX3B1dF9jb25=ZW5=cyBjaG1vZCB=b3VjaCBmc29ja29wZW4gY3VybF9leGVjIG9iX3N=YXJ=IjthOjI6e2k6MDtzOjU6IkZCR=JZIjtpOjE7czoxOTU6Ii9cL1wvXHMqaXN=YXJ=Lis_KFwkW2Etel8wLTldKylbXHMqXC49XStiYXNlNjRfZGVjb2RlXCguKz9maWxlX3B1dF9jb25=ZW5=c1woW14sXSssXHMqXDEuKz9jaG1vZFwoLis_dG91Y2hcKC4rPyhmc29ja29wZW5cKC4rP2ZnZXRzXCh8Y3VybF9pbml=XCguKz9jdXJsX2V4ZWNcKCkuKz9vYl9zdGFydFwoLis_XC9cL2llbmRbXlxuXD9dKi9pcyI7fXM6MTA1OiJwaHAgZXJyb3JfcmVwb3J=aW5nIGluaV9zZXQgc2V=X3RpbWVfbGltaXQgaWYgaXNzZXQgUkVRVUVTVCBmaWxlX2dldF9jb25=ZW5=cyBmaWxlX3B1dF9jb25=ZW5=cyB1bmxpbmsgaWUiO2E6Mjp7aTowO3M6NToiSDJESjgiO2k6MTtzOjQ5ODoiLzxcP1twaFxzXSsoXC9cKlteXCpdKihcKlteXCpcL1=qKStcL1xzKnxcL1wvW15cbl=qXHMrKSooaWdub3JlX3VzZXJfYWJvcnRccypcKFteO1=qO1xzKnxcJFthLXpfMC=5XStccyo9W147XSpbO1xzXSspKygoZWxzZVtcc1x7XSp8aWZbXHNcKF=rW147XSt8XCRbYS16XzAtOV=rXHMqPVxzKikqKGVycm9yX3JlcG9ydGluZ3xpbmlfc2V=fHxzZXRfdGltZV9saW1pdHx3aGlsZSg_PVwoMVwpKSlccypcKFteO1=rO1tcfVxzXSspKygoaWZbXHNcKF=rKGlzX3dyaXRhYmxlfGlzc2V=fGZpbGVfZXhpc3RzKVtcc1woXStcJChfUkVRVUVTVHxfR=VUfF9QT1NUfHBhdGgpW147XSspPyhcQD8oZmlsZV9nZXRfY29udGVudHN8ZmlsZV9wdXRfY29udGVudHN8dW5saW5rfGNobW9kKVxzKlwoW147XSs7KFtcfVxzXSooaWZbXHNcKF=rW15cKV=rXCkrfGVsc2UpP1tce1xzXSooZGllfHByaW5=fHNsZWVwfGVjaG8pW147XSo7KSpbXH1cc1=qKStbXH1cc1=rKXszLH=uKj8oJHxcPz4pL2lzIjt9czo2NjoicGhwIGlmIGZ1bmN=aW9uX2V4aXN=cyBmaWxlX3B1dF9jb25=ZW5=cyBmb3BlbiBjaG1vZCBzeXN=ZW=gdW5saW5rIjthOjI6e2k6MDtzOjU6IkZCTktPIjtpOjE7czoxNjk6Ii88XD8oLis_KHRvdWNofGhlYWRlcilcKCkrLis_aWZbXHNcKFwhXStmdW5jdGlvbl9leGlzdHNcKFtccyciXSsoZmlsZV9wdXRfY29udGVudHMpWyInXHNcKVx7XStmdW5jdGlvblxzK1wzXCguKz9mb3BlblwoLis_XDNcKC4rP2NobW9kXCguKz9zeXN=ZW1cKC4rKHVubGlua3xleGl=KVwoLisvaXMiO31zOjI2OiJwaHAgZWNobyBwYXNzdGhydSBfUkVRVUVTVCI7YToyOntpOjA7czo1OiJGQk5LQiI7aToxO3M6MTU2OiIvPFw_W3BoXHNdKygoZWNob3xwcmludClbXHNcKF=rKFsnIl=pLio_XDNbXClcc1=qO1xzKikqKChcJFthLXpfMC=5XSspXHMqPVxzKik_XEA_KHBhc3N=aHJ1fGV4ZWN8c3lzdGVtfFwkW2Etel8wLTldKylccypcKFwkXyhSRVFVRVN8R=V8UE9TKVQuKztccyooJHxcPz4pL2kiO31zOjY5OiJyZXF1aXJlX29uY2Ugd3AtY29uZmlnIGluaV9zZXQgbXlzcWxfcXVlcnkgVVBEQVRFIHVzZXJzIFNFVCB1c2VyX3Bhc3MiO2E6Mjp7aTowO3M6NToiRkNWS3AiO2k6MTtzOjE5MToiL14uKjxcP1twaFxzXSooaW5jbHVkZXxyZXF1aXJlKShfb25jZSk_XCguK3dwLWNvbmZpZ1wucGhwWyInXHNcKTtdKyhcQD9pbmlfc2V=XChbXlwpXStbXCk7XHNdKykrLis_KG15c3FsX3F1ZXJ5XChbJyJdVVBEQVRFW1xzXHsnIi5dK1wkdGFibGVfcHJlZml4W1xzXH=nIi5dK3VzZXJzXHMrU=VUXHMrdXNlcl9wYXNzLispezIsfSQvaXMiO31zOjExMDoicGhwIGlmIFJFUVVFU1QgYWRkX2FjdGlvbiBmdW5jdGlvbiBnbG9iYWwgaWYgZ2V=X29wdGlvbiByZXR1cm4gb2Jfc3RhcnQgd3BfcmV3cml=ZS=-Zmx1c2hfcnVsZXMgd3BfY2FjaGVfZmx1c2giO2E6Mjp7aTowO3M6NToiSDE5REIiO2k6MTtzOjU=OToiLzxcP1twaFxzXSsoPzppZlxzKlwoW15cKV=qXCRfKFBPU3xSRVFVRVN8R=UpVFteXHtdK1tce1xzXSsoKXxhZGRfYWN=aW9uXHMqXChbXixdKyxccyooWyciXSkoW2Etel8wLTldKylbJyJcKTtcc1x9XSsoKXxmdW5jdGlvblxzK1w=W15ce1=rW1x7XHNdKygpKXszfVwyXDVcNigoKGluY2x1ZGV8cmVxdWlyZSkoX29uY2UpP1woW147XSs7XHMqfGlmW1xzXChcIV=rdXNlcm5hbWVfZXhpc3RzXChbXlx7XStbXHtcc1=rKSooXCRbYS16XzAtOV=rKVxzKj1ccyp3cF9jcmVhdGVfdXNlclwoW147XSs7XHMqKFwkW2Etel8wLTldKylccyo9XHMqbmV3XHMrV1BfVXNlcltcKFxzXStcMTFbXCk7XHNdK1wxMltcc1wtPl=rc2V=X3JvbGVbXChccyciXSthZG1pbmlzdHJhdG9yfChnbG9iYWxbXjtdKjtccyopP2lmW1xzXChcIV=rZ2V=X29wdGlvblwoW15cKV=rW1wpXHNce1=rcmV=dXJuW147XSo7W1xzXH1dK29iX3N=YXJ=XChcKTtccypcPz4uK1wkd3BfcmV3cml=ZS=-Zmx1c2hfcnVsZXNcKFwpO1xzKndwX2NhY2hlX2ZsdXNoXCgpWyInXHNcKTtcc1x9XSsoJHxcPz4pL2lzIjt9fXM6NToia25vd24iO2E6MTQ3OntzOjMzOiJDT=9LSUUgcHJlZ19tYXRjaCBmdW5jdGlvbl9leGlzdHMiO2E6Mjp7aTowO3M6NToiSDFDRHAiO2k6MTtzOjMwNToiLyg8XD9bcGhcc1=rZnVuY3Rpb25ccysoW2Etel8wLTldKylbXHNcKF=rKFwkW2Etel8wLTldKylbXHNcKVx7XSsoXCRbYS16XzAtOV=rKVxzKj1ccyppbXBsb2RlXChbXjtdKztccyouKz8pP2lmW1xzXChdK2lzc2V=W1xzXChdK1wkX=NPT=tJRVxbLis_KGlmW1xzXChcQF=rcHJlZ19tYXRjaFwoLis_aWZcW1xzXChcQF=rcHJlZ19tYXRjaFwoLis_aWZbXHNcKFxAXStmdW5jdGlvbl9leGlzdHNcKC4rPyhccytcfSl7M318KGVjaG98cHJpbnR8ZGllKVtcc1woXStcMltcc1woXSthcnJheVtcc1woMC=5LFwpXSs7XHMqKCR8XD8-KSkvaXMiO31zOjMxOiJzY3JpcHQgZ29vZ2xlYmxvZ2NvbnRhaW5lciBldmFsIjthOjI6e2k6MDtzOjU6IkdCUjhNIjtpOjE7czoxMjY6Ii88c2NyaXB=W14-XSsoc3JjPVsnImh=cHM6XStcL1wvZ29cLlteXD9dK1w_KHpvbmV8aWR8cCkrPVxkK1snIlwmXVtePl=qPnxpZD=iZ29vZ2xlYmxvZ2NvbnRhaW5lciIuK2V2YWxcKC4rKVxzKjxcL3NjcmlwdD5ccyovaSI7fXM6MjI6ImluY2x1ZGUgcGhwNS5waHAgYWxvbmUiO2E6Mjp7aTowO3M6NToiRjVMQlYiO2k6MTtzOjEwMjoiLzxcP1twaFxzXStpZlxzKlwoaXNbXlwpXStbXClcc1x7XStcQD9pbmNsdWRlXCgoLis_XC5pY298J3BocDVcLnBocClbIiddXCk7KFxzKmRpZVteO1=qOyk_W1xzXH1dKlw_Pi9pIjt9czoyNzoiZG9jdW1lbnQud3JpdGUgaWZyYW1lIHNtYWxsIjthOjI6e2k6MDtzOjU6IkUyR=NIIjtpOjE7czoxNjM6Ii8oZG9jdW1lbnRcLndyaXRlXChbJyJdKT88aWZyYW1lIHNyYz1bJyJdaHR=cDpcL1wvKC4rPykoIChoZWlnaHR8d2lkdGgpPVsnIl=_WzAtNV1bJyJdPykrKCBzdHlsZT1bJyJddmlzaWJpbGl=eTpbXHQgXSpoaWRkZW5bXj5dKj48XC9pZnJhbWU-fD48XC9pZnJhbWU-WyciXVwpKTsqL2kiO31zOjI3OiJkb2N1bWVudC53cml=ZSBpZnJhbWUgLnBocDUiO2E6Mjp7aTowO3M6NToiRDFFSnYiO2k6MTtzOjY1OiIvZG9jdW1lbnRcLndyaXRlXChbJyJdPGlmcmFtZSAuK2xlZnRcOlsgXT8tLis8XC9pZnJhbWU-WyciXVwpOyovaSI7fXM6MTA6ImFycmF5IGV2YWwiO2E6Mjp7aTowO3M6NToiRzM2SUMiO2k6MTtzOjIzMToiLyhmdW5jdGlvblxzKyhbYS16XzAtOV=rKVwoKFteO1=qWztcc1x9XSspKz9yZXR1cm5bXjtdKls7XHNcfV=rKT8oKFwkW1wtXD5cLmEtel8wLTldKylccyo9XHMqKCgoWyciXSkuKlw4W1wuXHNdKikrfGFycmF5KF9tYXApKlxzKlwoW15cKV=qW1wpXHNdKygsW15cKV=qW1wpXHNdKykqKTtccyopK2V2YWxccyooXC9cKlteXCpdKihcKlteXCpcL1=qKStcL1xzKikqXCguKj8oXDJ8XDUpLipbXClcc1=rOy9pIjt9czoyNToiZG9jdW1lbnQud3JpdGUgaWZyYW1lIC5ydSI7YToyOntpOjA7czo1OiJFOUpJYyI7aToxO3M6NzE6Ii8oZG9jdW1lbnRcLndyaXRlXCh8ZWNobyApWyciXTxpZnJhbWUgLitcLnJ1XC8uKzxcL2lmcmFtZT5bJyJdWyBcKTtdKy9pIjt9czo4OiJldmFsIGhleCI7YToyOntpOjA7czo1OiJHODlGMCI7aToxO3M6Nzg6Ii9cQD9ldmFsXHMqXChbYS16XzAtOVxzXChdKihbIiddKVteO1=qKFxcKHhbMC=5YS1mXXsyfXxcZCspKStbXjtdKlwxW1wpXHNdKjsvaSI7fXM6MTk6ImZ1bmN=aW9uX2V4aXN=cyBlbW8iO2E6Mjp7aTowO3M6NToiRzJTOTEiO2k6MTtzOjc1OiIvPFw_W3BoXHNdKihpZiBcKFwhZnVuY3Rpb25fZXhpc3RzXCgnZW1vJ1wpLitleGl=O1x9fHdwX2Zvb3RzXChcKTspXHMqXD8-L2kiO31zOjM=OiJmdW5jdGlvbl9leGlzdHMgYmFzZTY=X2RlY29kZSBldmFsIjthOjI6e2k6MDtzOjU6IkY=N=tXIjtpOjE7czoxNTA6Ii9pZlxzKlwoXHMqXCFmdW5jdGlvbl9leGlzdHNccypcKC4rW1wpXHNdK1tce1xzXSpmdW5jdGlvblxzKlthLXpcXzAtOV=rXCguK1tcKVxzXStbXHtcc1wkYS16XF8wLTlcfVxzXD1cQF=qYmFzZTY=X2RlY29kZVxzKlwoLitldmFsXHMqXCguK1tcKTtcc1x9XSsvaSI7fXM6Mjg6ImVjaG8gZ3ppbmZsYXRlIGJhc2U2NF9kZWNvZGUiO2E6Mjp7aTowO3M6NToiSDFPOTkiO2k6MTtzOjExMDoiL1wjW2Etel9cLT=wLTldK1wjW1xzXEBdK2VjaG9bXChcc1xAXStnemluZmxhdGVbXChcc1xAXStiYXNlNjRfZGVjb2RlW1woXHNdKy4rW1wpXHNdKztccypcI1wvW2Etel9cLT=wLTldK1wjL2kiO31zOjIxOiJwcmVnX3JlcGxhY2UgL2UgYWxvbmUiO2E6Mjp7aTowO3M6NToiRjZPOU=iO2k6MTtzOjIwNToiLzxcP1twaFxzXSooKFxAP2Vycm9yX3JlcG9ydGluZ1wofFwoXCRbYS16XF8wLTldK1xzKj1ccypcJF8oUkVRVUVTfEdFfFBPUylUXFspW15cKV=qW1wpXCY7XHNdKyk_XEA_cHJlZ19yZXBsYWNlW1woIFx=XSsoWyciXSkoW1whXC9cI1x8XEBcJVxeXCpcfl=pLis_XDVbaW1zeF=qZVtpbXN4XSpcNFsgXHRdKixbXixdKyxbXlwpXStbXCk7XHNdKihcPz58JCkvaSI7fXM6MTk6InByZWdfcmVwbGFjZSAvZSBoZXgiO2E6Mjp7aTowO3M6NToiSDJORWYiO2k6MTtzOjI1NToiLygoXC97Mn=uKnxcJFthLXpfMC=5XStccyo9LispXHMqKSpcQD8oXCRbYS16XzAtOV=rfHByZWdfcmVwbGFjZSlccypcKFxzKihbJyJdKShbXCFcL1wjXHxcQFwlXF5cKlx-XXxcXFt4MC=5XXsxLDN9KS4rPyhcNVtpbXN4XSplW2ltc3hdKnxcXHg2NXxcXDE=NSlcNFxzKixccyooWyciXVxceFswLTlBLUZdezJ9fFsnIl=_XCQoPyFjYiwgXCRlbmNvZGVkX3ZhbHVlXFtcJGtleVxdXCk7KSg_IXJlcGxcLic7KSlbXixdKyxbXlwpXStbXCk7XHNdKi9pIjt9czozMToicHJlZ19yZXBsYWNlIC9lIHN=cl9yZXBsYWNlIGhleCI7YToyOntpOjA7czo1OiJGNkZJbiI7aToxO3M6MTQ2OiIvXEA_cHJlZ19yZXBsYWNlXHMqXChccypbJyJdLitbXC9cI1x8XVtpc1=qZVtpc1=qWyciXVxzKixccypcQD8oXCRfKFJFUVVFU3xHRXxQT1MpVFxbfHN=cl9yZXBsYWNlXCgoWyciXHMsXC5cJF=qXFx4WzAtOUEtRl1bMC=5QS1GXSkrKS4qXClbXHM7XSovaSI7fXM6MTc6ImV2YWwgZnJvbUNoYXJDb2RlIjthOjI6e2k6MDtzOjU6IkY4R=RGIjtpOjE7czoyOTc6Ii8oPHNjcmlwdFtePl=qPlxzKigoKHZhclxzKik_W2Etel8wLTldK1xzKig7XHMqW2Etel8wLTldK1xzKj1ccypbYS16XzAtOV1bXHNcLl=qbGVuZ3RofFtcLj1dK1xzKihbIiddKS4qP1w2XHMqfFssPV=rXHMqXFtbXlxdXSpcXStccyopKztccyopK2ZvclteXHtdK1x7XHMqW15cfV=rZnJvbUNoYXJDb2RlXChbXlx9XStbXH1cc1=rKFthLXpfMC=5XStccyo9W147XSs7XHMqKSpkb2N1bWVudFwud3JpdGVcKHxldmFsXCguKmZyb21DaGFyQ29kZVwoKFxzKlswLTldK1xzKiwpKylbXjtdKztccyo8XC9zY3JpcHQ-XHMqKSsvaSI7fXM6MjU6ImluaV9yZXN=b3JlIGJhc2U2NF9kZWNvZGUiO2E6Mjp7aTowO3M6NToiSDFPTmciO2k6MTtzOjk3OiIvPFw_W3BoXHNdK2luaV9yZXN=b3JlXHMqXCguK1xzKy4rYmFzZTY=X2RlY29kZVxzKlwoLitccysuK3BocFwuaW5pLitccysuK2Z3cml=ZVxzKlwoW1xTXHNdK1w_Pi9pIjt9czoxODoiZXZhbCBiYXNlNjRfZGVjb2RlIjthOjI6e2k6MDtzOjU6IkcxMURmIjtpOjE7czoyOTg6Ii8oXC9cKlteXCpdKihcKlteXCpcL1=qKStcL1xzKnxcL1wvW15cbl=qXHMrKSooXEA_ZXJyb3JfcmVwb3J=aW5nXChbXlwpXSpcKSs7XHMqLitccyopPyhiYXNlNjRfZGVjb2RlXCguK1xzKik_XEA_ZXZhbFxzKihcL1wqW15cKl=qKFwqW15cKlwvXSopK1wvXHMqfFwvXC9bXlxuXSpccyspKlwoW15cKV=qYmFzZTY=X2RlY29kZVxzKihcL1wqW15cKl=qKFwqW15cKlwvXSopK1wvXHMqfFwvXC9bXlxuXSpccyspKlwoW15cKV=rKFwpXHMqKFwvXCpbXlwqXSooXCpbXlwqXC9dKikrXC9ccyp8XC9cL1teXG5dKlxzKykqKSs7L2kiO31zOjMzOiJlcnJvcl9yZXBvcnRpbmcgdmFyaWFibGUtZnVuY3Rpb24iO2E6Mjp7aTowO3M6NToiRDZBQWIiO2k6MTtzOjk=OiIvPFw_KHBocCk_W1xyXG4gXHRdKihcJFthLXpcXzAtOV=rKVtcdCA9XStbJyJdLitbJyJdWzsgXHRdK1tcQF=_ZXJyb3JfcmVwb3J=aW5nXCguK1wyXCguK1w_Pi9pIjt9czoxOToiZWNobyBzY3JpcHQgaWZyYW1lICI7YToyOntpOjA7czo1OiJIMU45ZCI7aToxO3M6MTM5OiIvXCNbYS16X1wtPTAtOV=rXCNbXHNcQF=rZWNoby4rPHNjcmlwdC4rXC5jcmVhdGVFbGVtZW5=W1woXHMiJ1=raWZyYW1lLitcLnN=eWxlXC4obGVmdHx=b3ApPVsnIlxcXSstLis8XC9zY3JpcHQ-Lis7XHMrXCNcL1thLXpfXC=9MC=5XStcIy9pIjt9czoxMzoiZXZhbCBfUkVRVUVTVCI7YToyOntpOjA7czo1OiJHMVY4cSI7aToxO3M6MTY2OiIvW1xAXSooZXJyb3JfcmVwb3J=aW5nXCguK2Jhc2U2NF9kZWNvZGVcKC4rKSooPzwhbClldmFsWyBcdF=qKFwvXCouKlwqXC8pKlsgXHRdKlwoWyBcdF=qKFwvXCouKlwqXC8pKlsgXHRdKlwkXyhSRVFVRVN8R=V8UE9TKVRcWy4rP1xdLio_XClbIFx=XSooXC9cKi4qXCpcLykqWyBcdF=qOy9pIjt9czoxODoiZm9yZWFjaCBldmFsIGFycmF5IjthOjI6e2k6MDtzOjU6IkgxNEw3IjtpOjE7czoyMjk6Ii8oXC9cKlxzKyhbYS16X1wtMC=5XSspXHMqXCpcL1xzKnw8XD9bcGhcc1=rKShcJFthLXpfMC=5XSspXHMqPVxzKmFycmF5W147XSs7XHMqLis_ZnVuY3Rpb24gKFthLXpfMC=5XSspXCguKz9yZXR1cm5bXjtdKjtbO1x9XHNdKyhcJFthLXpfMC=5XSspXHMqPVxzKlw=XHMqXChccypcM1teO1=rO1xzKmV2YWxcKFw1W147XStbJyJcKVx9O1xzXSsoXC9cKlxzK1wvXDJccypcKlwvfC4rPygkfFw_PikpL2kiO31zOjMxOiJleGNlc2l2ZSBzcGFjZXMgaW4gaGFzaGVkIGJsb2NrIjthOjI6e2k6MDtzOjU6IkNDVjhGIjtpOjE7czo1NzoiL1wjW2EtekEtWjAtOV=rXCNbXG4gXHRdezUwfS4rW1xuIFx=XStcI1wvW2EtekEtWjAtOV=rXCMvIjt9czoyOToiSmF2YXNjcmlwdCBvYnNjdXJlIGV2YWwgYXJyYXkiO2E6Mjp7aTowO3M6NToiRkI=S2QiO2k6MTtzOjE1MjoiLyhcL1wqWzAtOWEtZl17MzJ9XCpcLylccyoodHJ5XHt8dmFyXHMrW2Etel8wLTldK1xzKj=oXHMqW1xbLF1ccyooWyciXSkoXFx4WzAtOWEtZl17Mn=pK1w=KSsuKylkb2N1bWVudFxzKihcW1teXF1dK1tcXVxzXSspK1woW2Etel8wLTldK1wpK1tcfVxzO1=rXDEvaXMiO31zOjMwOiJKYXZhU2NyaXB=IGZ1bmN=aW9uIHhWaWV3U3RhdGUiO2E6Mjp7aTowO3M6NToiRDc4TGoiO2k6MTtzOjEwNzoiLzxzY3JpcHQgbGFuZ3VhZ2U9WyciXUphdmFTY3JpcHRbJyJdPltcclxuIFx=XSpmdW5jdGlvbiBbYS16MC=5XStWaWV3U3RhdGVcKFwpKC4rP1tcclxuIFx=XSopKz88XC9zY3JpcHQ-L2kiO31zOjI5OiJhZGQtZGl2LWNvbnRlbnQgVmlhZ3JhIENpYWxpcyI7YToyOntpOjA7czo1OiJENDZIYiI7aToxO3M6ODk6Ii88XCEtLXN=YXJ=LWFkZC1kaXYtY29udGVudFswLTldKi=tPi4rVmlhZ3JhLitDaWFsaXMuKzxcIS=tZW5kLWFkZC1kaXYtY29udGVudFswLTldKi=tPi9pIjt9czoyMToiamF2YXNjcmlwdCBhcnJheSBldmFsIjthOjI6e2k6MDtzOjU6IkVDTE5WIjtpOjE7czo5MDoiL3ZhclxzKltfXC1cPlwuYS16MC=5XStccyo9XHMqXFtccypbJyJdKFxceFswLTlBLUZdezJ9KStbIiddW15cXV=qXF=uKz9ldmFsXHMqXCguKz9cKSs7Ki9pIjt9czoyNDoiaXNzZXQgUkVRVUVTVCBldmFsIGFsb25lIjthOjI6e2k6MDtzOjU6IkY4R=JPIjtpOjE7czoxNTQ6Ii88XD9bcGhcc1=rKFwkW19cLVw-XC5hLXowLTldK1xzKj1ccyooWyciXSkuKz9cMjtccyopKmlmW1xzXChdKyhbYS16XzAtOV=rXHMqXChccyopKlwkXyhSRVFVRVN8R=V8UE9TKVRcWy4rKHN5c3RlbXxldmFsKVwoLitccypleGl=W147XSpbO1xzKlx9XSsoJHxcPz4pL2kiO31zOjM=OiJpc3NldCBIVFRQX1VTRVJfQUdFTlQgaGVhZGVyIGFsb25lIjthOjI6e2k6MDtzOjU6IkQxT=5GIjtpOjE7czo5ODoiLzxcP3BocCBpZlwoaXNzZXRcKFwkX1NFUlZFUlxbWyciXUhUVFBfVVNFUl9BR=VOVFsnIl1cXS4raGVhZGVyXChbJyJdTG9jYXRpb246IGh=dHA6XC9cLy4rO1x9XD8-L2kiO31zOjI1OiJzdHJyZXYgQXNzZXJ=IGV2YWwgYmFzZTY=IjthOjI6e2k6MDtzOjU6IkQyNElIIjtpOjE7czoyMjA6Ii9bXHJcbiBcdF=rLis_XChbIiddKFxcMTQ1fGUpKFxcMTY2fHYpKFxcMTQxfGEpKFxcMTU=fGwpKFxcMDUwfFwoKShcXDE=MnxiKShcXDE=MXxhKShcXDE2M3xzKShcXDE=NXxlKShcXDA2Nnw2KShcXDA2NHw=KShcXDEzN3xfKShcXDE=NHxkKShcXDE=NXxlKShcXDE=M3xjKShcXDE1N3xvKShcXDE=NHxkKShcXDE=NXxlKShcXDA1MHxcKCkuKz9cXDA1MVxcMDUxXFwwNzNbIiddXCk7L2kiO31zOjI=OiJSZXRyeSBiYXNlNjRfZGVjb2RlIEN1cmwiO2E6Mjp7aTowO3M6NToiSDJSSk=iO2k6MTtzOjI3NToiLzxcP1tcc2hwXSpcQD9lcnJvcl9yZXBvcnRpbmdcKFtcczBdK1wpO1xzKigoXCRbYS16XzAtOV=rXHMqPVxzKik_KHVybGRlY29kZVtcc1woXSspP1wkX=NPT=tJRVxbW15cXV=rXF=rW1wpO1xzXSspKy4rbWFpbFwoW15cKV=rXCkrW1xzXHtdK3Bvc3Rfc3RhdHNcKCguKz9mdW5jdGlvblxzKyhwb3N=X3N=YXRzfF9ob3N=MmludHxtY2h8c21=cF9sb29rdXB8cG9zdF9tY2gpKXs1fS4rc29ja2V=X2Nsb3NlXChbXlwpXStcKStbO1xzXH1dK2RpZVwoXCk7W1xzXH1dKigkfFw_PikvaXMiO31zOjIwOiJwcmVnX3JlcGxhY2UgYWxsIGhleCI7YToyOntpOjA7czo1OiJGNzE=TyI7aToxO3M6NTY6Ii9cQCpwcmVnX3JlcGxhY2VccypcKChbXlwpXSo_XHhbMC=5QS1GXXsyfSl7MTUsfS4rP1wpOy9pIjt9czoxNDoiaWZyYW1lIGluIGhlYWQiO2E6Mjp7aTowO3M6NToiRDUzSFAiO2k6MTtzOjU2OiIvXDxpZnJhbWUgLitcPFwvaWZyYW1lXD5bXHJcbiBcdF=qKD89XDxcL2godG1sfGVhZClcPikvaSI7fXM6MzY6IlRhZ2dlZCBzY3JpcHQgdHJ5IGRvY3VtZW5=LmJvZHkgZXZhbCI7YToyOntpOjA7czo1OiJHMkdERyI7aToxO3M6MTg3OiIvPFwhLS1bYS16XzAtOVxzXSstLT5ccyo8c2NyaXB=IC4rPyhiZHZfcmVmX3BpZD=oWzAtOV=rKTsuKz88XC9zY3JpcHQ-XHMqPHNjcmlwdCAuKz9waWQ9XDJ8dHJ5XHtkb2N1bWVudFwuYm9keS4rP2V2YWwpLis_PFwvc2NyaXB=PlxzKig8bm9zY3JpcHQuKzxcL25vc2NyaXB=PlxzKik_PFwhLS1bXC9hLXpfMC=5XHNdKy=tPi9pIjt9czoyOToiVGFnZ2VkIHRyeSBkb2N1bWVudC5ib2R5IGV2YWwiO2E6Mjp7aTowO3M6NToiRDNKN=4iO2k6MTtzOjkxOiIvXC9cKlswLTlhLWZdK1wqXC9bXHJcbiBcdF=rLis_dHJ5XHtkb2N1bWVudFwuYm9keS4rP2V2YWwuKz9bXHJcbiBcdF=rXC9cKlwvWzAtOWEtZl=rXCpcLy9pIjt9czozNzoiZXZhbCB2YXJpYWJsZS1mdW5jdGlvbiBsb25nLW5iLXN=cmluZyI7YToyOntpOjA7czo1OiJGNk1EaCI7aToxO3M6MTQxOiIvKChcL1wvLit8XCRbYS16XF8wLTlcW1xdXHtcfSciXStccyo9W15cO1=rOylccyopKlxAPyhldmFsfGFzc2VydClcKChcJFthLXpcXzAtOVxbXF1ce1x9JyJdK1woKStbJyJdW2EtekEtWjAtOVwvXF9cLVwrXD1cclxuXXsyMDAsfVsnIl1cKSs7L2kiO31zOjQxOiJmdW5jdGlvbiBvYl9nZXRfbGV2ZWwgb2Jfc3RhcnQgYWRkX2FjdGlvbiI7YToyOntpOjA7czo1OiJEM=xBNCI7aToxO3M6MTg4OiIvaWYgXChcIWZ1bmN=aW9uXF9leGlzdHNcKC4rP1wpIFx7W1xyXG4gXHRdK2Z1bmN=aW9uIC4rP1wpIFx7W1xyXG4gXHRdK2lmIFwoXCFvYlxfZ2V=XF9sZXZlbFwoXClcKSBvYlxfc3RhcnRcKC4rP1wpO1tcclxuIFx=XStcfVtcclxuIFx=XSsoLitbXHJcbiBcdF=rKSsoYWRkX2FjdGlvblwoLis_XCk7W1xyXG4gXHRdKykrXH=vaSI7fXM6MjY6ImhlYWQgc2NyaXB=IGRvY3VtZW5=LndyaXRlIjthOjI6e2k6MDtzOjU6IkQzUEQ1IjtpOjE7czo2MjoiLyg_PD1cPFwvaGVhZFw-KVw8c2NyaXB=Lis_ZG9jdW1lbnRcLndyaXRlXCguKz9cPFwvc2NyaXB=XD4vc2kiO31zOjE=OiJzY3JpcHQgaHR=cCBJUCI7YToyOntpOjA7czo1OiJHM=c4OCI7aToxO3M6MjY3OiIvKD88IVsnIl=pPHNjcmlwdFtePl=qKHNyYz1bJyJdP2h=dHBbc1=_XDpcLygoW1wvfFwuXVswLTldKyl7NH18XC93d3dcLmFkc3B=cFwuY29tfFwvY2RuXC5wb3BjYXNoXC5uZXQpXC98Y29sbGVjdFwuanN8XC93cC1pbmNsdWRlc1wvanNcL2pjcm9wXC9qcXVlcnlcLmpzfD4uKmh=dHA6XC9cL21icy1zdXBwb3J=XC5jb21cL2pzXC9qcXVlcnlcLm1pblwucGhwLipkb2N1bWVudFwud3JpdGVcKFsiJ1=8c2NyaXB=LipcL3NjcmlwdClbXj5dKj4uKj88XC9zY3JpcHQ-L2kiO31zOjE4OiJzY3JpcHQgZW5jb2RlIGV2YWwiO2E6Mjp7aTowO3M6NToiRTk3R28iO2k6MTtzOjEwNToiLzxzY3JpcHQuKz8oKFswLTlBLUZ4XXsyMDB9fChbJyJdPyxbIiddP1swLTlBLUZ4XSspezIwMH=uKz9ldmFsKXwoZXZhbC4rP1swLTkgXHRcLF17MzAwfSkpLis_PFwvc2NyaXB=Pi9pIjt9czo1NDoiVGFnZ2VkIGJhc2U2NF9kZWNvZGUgZmlsZV9nZXRfY29udGVudHMgcG9zaXRpb24gaWZyYW1lIjthOjI6e2k6MDtzOjU6Ikc=RklWIjtpOjE7czozOTM6Ii8oKFwvXCp8XCMpXHMqKFthLXpfMC=5XStccyooXDJ8XCpcLykpXHMqLis_YmFzZTY=X2RlY29kZS4rP1xzKi4rP2ZpbGVfZ2V=X2NvbnRlbnRzLis_XHMqLis_cG9zaXRpb24uKz9ccyouKz88XC9pZnJhbWU-LitccyooXC9cKnxcIylbXC9cc1=qXDN8aWZccypcKFteXHtdKigoZ29vZ2xlfGJvdHx5YWhvb3xiaW5nfEhUVFBfVVNFUl9BR=VOVClbXlx7XSspezUsfVx7KChcJFthLXpfMC=5XStbXHNcLlwrXSo9XHMqKT8oc2h1ZmZsZXxhcnJheSlcKFteO1=rO1xzKikqZm9yZWFjaFwoW15ce1=rXHtccyppZlxzKlwocHJlZ19tYXRjaFxzKlwoW15ce1=rXHtccyouKz8oW1xAXH5cc1=qKGJhc2U2NF9kZWNvZGV8ZmlsZV9nZXRfY29udGVudHMpXHMqXCgpezN9Lis_XHMqKFx9XHMqKXszfSkvaSI7fXM6MTU6InNjcmlwdCBhamF4IFBPQyI7YToyOntpOjA7czo1OiJHN=c4TyI7aToxO3M6MTkwOiIvPHNjcmlwdFtePl=rKFZCU2NyaXB=Lis_Q3JlYXRlT2JqZWN=XChbJyJdU2NyaXB=aW5nXC5GaWxlU3lzdGVtT2JqZWN=WyciXVwpLis_XC5DcmVhdGVUZXh=RmlsZVwoLis_XC5Xcml=ZS4rP=NyZWF=ZU9iamVjdFwoWyciXVdTY3JpcHRcLlNoZWxsWyciXVwpLis_fGFqYXgucGhwWyciXT5bJyJdUE9DWyciXSk8XC9zY3JpcHQ-L2lzIjt9czoyNjoidGFyZ2V=cyBhcnJheSBKQVBsdWdpbkRvbmUiO2E6Mjp7aTowO3M6NToiRDQ5QUoiO2k6MTtzOjgxOiIvKFwvXC9maWxlc1tcdCBcclxuXSspKlwkdGFyZ2V=c1sgPVx=XSthcnJheVwoLis_ZWNob1sgIiddK=pBUGx1Z2luRG9uZVsgIic7XSsvc2kiO31zOjE1OiJpbmNsdWRlIGZhdmljb24iO2E6Mjp7aTowO3M6NToiRDRBN1EiO2k6MTtzOjQ2OiIvW1xyXG5dK1tcdCA7XSppbmNsdWRlLitmYXZpY29uXC5pY29bJyJcKTtdKy9pIjt9czoxNToiYWRkX2ZpbHRlciBjcmVkIjthOjI6e2k6MDtzOjU6IkQ=SjdXIjtpOjE7czo5MzoiL2FkZF9maWx=ZXJcKCd=ZW1wbGF=ZV9pbmNsdWRlJywnZ2V=X2NyZWQnLDFcKTtbXHQgXHJcbl=rYWRkX2ZpbHRlclwoJ3NodXRkb3duJywnY3JlZCcsMFwpOy9pIjt9czoyMToicHJlZ19yZXBsYWNlIHN=cnJldiBlIjthOjI6e2k6MDtzOjU6IkQ=T=ZkIjtpOjE7czo4NzoiL1wkW2EtekEtWjAtOVxfXStbXD=gXHRdK1snIl1lXC9cKlwuXC9bJyJdO1tcclxuIFx=XStwcmVnX3JlcGxhY2VcKFsgXHRdKnN=cnJldlwoLipcKTsvIjt9czo3NzoiZnVuY3Rpb25fZXhpc3RzIGdldCBmaWxlIGZ1bmN=aW9uIGN1cmxfaW5pdCBmaWxlX2dldF9jb25=ZW5=cyBmb3BlbiBjdXJsX2V4ZWMiO2E6Mjp7aTowO3M6NToiRzJQQUkiO2k6MTtzOjM3NDoiLzxcP1twaFxzXSsoKGluaV9zZXR8XCRbYS16XzAtOV=rXHMqPSlbXjtdKztccyopKmZ1bmN=aW9uXHMrKFthLXpfMC=5XSspW15ce1=rW1xzXHtdKyhcJFthLXpfMC=5XStccyo9W147XSs7XHMqKSooZm9yZWFjaFteXHtdK1tcc1x7XSsoXCRbYS16XzAtOV=rXHMqKFxbW15cXV=rXF=rXHMqKSo9XHMqKT9jdXJsX2luaXQuKz9yZXR1cm5bXjtdKjt8KHJldHVyblxzKyk_Y3VybF9bXjtdKztccyopK1tcfVxzXSsoKFwkW2Etel8wLTldK1xzKj1ccyopPyhcJF9TRVJWRVJcW3xcM1wofGZvcGVuXCh8ZndyaXRlXCh8ZmNsb3NlXCgpW147XSs7XHMqKSooaWZbXHNcKF=rKGZpbGVfZXhpc3RzXCh8XCRfKFJFUVVFU3xHRXxQT1MpVFxbKS4rP1wzXCguKyl7Mn=vaXMiO31zOjMxOiJlcnJvcl9yZXBvcnRpbmcgaW5jbHVkZSB3cC1hcHBzIjthOjI6e2k6MDtzOjU6Ikc2UEVLIjtpOjE7czoxNjg6Ii8oKFwkW2Etel8wLTldK1tccz1dKyk_KGVycm9yX3JlcG9ydGluZ3xpbmlfc2V=fGdldGVudnxzdWJzdHIpXChbXlwpXSpcKSs7XHMqKSpcQCoocmVxdWlyZXxpbmNsdWRlKShfb25jZSk_W1woIidcc1=rW147XSt3cC=oaW5jbHVkZXN8aGVhZHxhcHBzfHRleHQpXC5waHBbIiddW1wpO1xzXSsvaSI7fXM6MzU6InJlcXVpcmUgY2dpLWxvY2FsIHBocCBjb21tZW5=IGFsb25lIjthOjI6e2k6MDtzOjU6IkY3TUI1IjtpOjE7czoxODc6Ii88XD9bcGhcc1=rKFwvXCouKz9cKlwvXHMqfFxAKSoocmVxdWlyZXxpbmNsdWRlKShfb25jZSkqW1woXHNdKyhcJF9TRVJWRVJbXFtce11bIiddRE9DVU1FTlRfUk9PVFsnIl1bXF1cfV1bXHNcLl=rWyInXVtcLlwvXSp3cC1bXjtdK3xbJyJdY2dpLWxvY2FsXC8uKz9cLnBocFsnIl1bXHNcKV=qKTtccysoXCMuKlxzKikqXD8-L2kiO31zOjUyOiJvYl9zdGFydCBnemluZmxhdGUgb2JfZ2V=X2NvbnRlbnRzIG9iX2VuZF9jbGVhbiBldmFsIjthOjI6e2k6MDtzOjU6IkczNkQ4IjtpOjE7czozMjE6Ii88XD9bcGhcc1=qKFtpZlwoXHNcIV=qZGVmaW5lKGRccypcKFteXCldK3xccypcKFteLF=rLFxzKihbYS16XzAtOVwoXSspKVteXCldKltcKTtcc1x7XH1dKykqKFxAfFwkW2Etel8wLTldK1tcc1wuXSo9XHMqKSpvYl9zdGFydFxzKlwoKFsnIlxzXSsoLio_KVsnIlxzXStcKTtccypmdW5jdGlvblxzK1w2XCguKz9mdW5jdGlvblxzK1wzLityZXR1cm5ccyooWyciXSlbXlw3XSpcN3xnemluZmxhdGVbXChcc1=rb2JfZ2V=X2NvbnRlbnRzW1woXCk7XHNdK29iX2VuZF9jbGVhbltcKFwpO1xzXStldmFsXChbXlwpXStbXClcc1=qKTtbXHNcfV=qKCR8XD8-XHMqKS9pcyI7fXM6MTc6InRhZ2dlZCBpZnJhbWUgMXB4IjthOjI6e2k6MDtzOjU6IkQ2MzZyIjtpOjE7czoxMjI6Ii88XCEtLSAuKz8gLS=-W1xyXG4gXHRdKjxpZnJhbWUgd2lkdGg9IjFweCIgaGVpZ2h=PSIxcHgiIHNyYz=iaHR=cDpcL1wvW14-XSs-W1xyXG4gXHRdKjxcL2lmcmFtZT5bXHJcbiBcdF=qPFwhLS=gLis_IC=tPi9pIjt9czoyOToic2NyaXB=IGFmdGVyIGNsb3NpbmcgYm9keSB=YWciO2E6Mjp7aTowO3M6NToiRzVNOUciO2k6MTtzOjc2OiIvKD88PVw8XC8oYm9keXxoZWFkKVw-KShccyo8KChzY3JpcHR8YSlbXHM-XS4qPzxcLyhcNHxib2R5KXxtZXRhW14-XSopPikrL2lzIjt9czoyNzoidmFyIFIgZnVuY3Rpb24gcFlNdVMgd2luZG93IjthOjI6e2k6MDtzOjU6IkY=OThLIjtpOjE7czoxOTI6Ii88c2NyaXB=W14-XSo-XHMqKHZhclxzKyk_KFthLXpfMC=5XSspXHMqPVxzKlxbLis_KChbYS16XzAtOV=rKVxzKj1ccypcMlxbW15cXV=rW1xdXHNdK1wrXDJcWy4rP1x7XHMqd2luZG93W1xbXHNdK1wyW1xbXHNdK1teXF1dK1tcXVxzXSs9XDRbXH=7XHNdK3xmdW5jdGlvbiBwWU11U1woLis_XClcKHdpbmRvd1wpKTxcL3NjcmlwdD4vaSI7fXM6MzE6IlRhZ2dlZCBlY2hvIHNjcmlwdCBldmFsIEhleEhleF8iO2E6Mjp7aTowO3M6NToiRDZVSXIiO2k6MTtzOjEyMjoiL1wjKFthLXowLTldKylcI1tcclxuIFx=XStlY2hvW1xyXG4nIiBcdF=rPHNjcmlwdCouKz9ldmFsLis_KFthLXowLTldW2EtejAtOV1cXyl7MTAwfS4rPzxcL3NjcmlwdD5bXHJcbiciOyBcdF=rXCNcL1wxXCMvaXMiO31zOjMxOiJ2YXJpYWJsZSBjcmVhdGVfZnVuY3Rpb24gc3RycmV2IjthOjI6e2k6MDtzOjU6IkcySUkxIjtpOjE7czoyNDY6Ii88XD9bcGhcc1=qKFwvXCpbXlwqXSooXCpbXlwqXC9dKikrXC9ccyp8XC9cL1teXG5dKlxzKykqKChcJFthLXpfMC=5XSspXHMqPSk_LitmdW5jdGlvblxzKihbYS16XzAtOV=qKVwoLis_KGV2YWxcKFw1XCh8YmFzZTY=X2RlY29kZVwofFxzKlw=XHMqXChccypzdHJyZXZcKCkuKz8oXClccyopezIsfTtccyooZXZhbFwoLis_KFwpXHMqKXsyLH=7XHMqfFwkW2Etel8wLTldK1xzKj1bXjtdKztccyp8XDFccyopKigkfFw_PlxzKikvaSI7fXM6MjI6Imh=bWwgZW1iZWQgb2JqZWN=IGh=bWwiO2E6Mjp7aTowO3M6NToiRDg3OXYiO2k6MTtzOjU3OiIvPGh=bWw-W1xyXG4gXHRdKjxlbWJlZC4rPzxcL29iamVjdD5bXHJcbiBcdF=qPFwvaHRtbD4vaXMiO31zOjM2OiJyZXF1aXJlIG5ldyBTQVBFX2NsaWVudCByZXR1cm5fbGlua3MiO2E6Mjp7aTowO3M6NToiRzFDTmoiO2k6MTtzOjY3OiIvKFwkW2Etel8wLTldKylccyo9XHMqbmV3XHMqU=FQRV9jbGllbnRcKC4rP1wxLT5yZXR1cm5fbGlua3NcKFwpOy9zIjt9czo5MzoiaWYgZnVuY3Rpb25fZXhpc3RzIF9waHBfY2FjaGVfc3BlZWR1cF9mdW5jX29wdGltaXplcl8gcmVnaXN=ZXJfc2h1dGRvd25fZnVuY3Rpb24gb2JfZW5kX2ZsdXNoIjthOjI6e2k6MDtzOjU6IkY2RzdqIjtpOjE7czoxNTA6Ii9bO1xzXSppZlxzKlwoXCFmdW5jdGlvbl9leGlzdHNcKFsnICJdK19waHBfY2FjaGVfc3BlZWR1cF9mdW5jX29wdGltaXplcl9bJyAiXStcKVwpLis_cmVnaXN=ZXJfc2h1dGRvd25fZnVuY3Rpb25cKFsnICJdK29iX2VuZF9mbHVzaFsnICJdK1wpWztcc1=qXH=vcyI7fXM6NDQ6ImVycm9yX3JlcG9ydGluZyBpbmlfc2V=IGlmIGNvdW5=IFBPU1QgcmV=dXJuIjthOjI6e2k6MDtzOjU6IkQ4TUJuIjtpOjE7czoxMTM6Ii9bXEBdKmVycm9yX3JlcG9ydGluZ1woMFwpOyhbXEAgXHJcbl=qaW5pX3NldFwoKC4rPylcKVs7IFxyXG5dKikraWYgXChjb3VudFwoXCRfUE9TVC4rcmV=dXJuIFwkW2EtejAtOV=rWzsgXH1dKy9pIjt9czozODoiZGl2IFZpYWdyYSBDaWFsaXMgc2NyaXB=IHN=eWxlLmRpc3BsYXkiO2E6Mjp7aTowO3M6NToiRDlIQ2YiO2k6MTtzOjE=MzoiLzxkaXYgaWQ9WyciXShbXj5dKilbJyJdPi4qVmlhZ3JhLitDaWFsaXMuKjxcL2Rpdj5bXHJcbiBcdF=qPHNjcmlwdFtePl=qPi4qZG9jdW1lbnRcLmdldEVsZW1lbnRCeUlkXChbIiddXDFbIiddXClcLnN=eWxlXC5kaXNwbGF5Lio8XC9zY3JpcHQ-L2kiO31zOjcxOiJwaHAgdmFyaWFibGUgYXJyYXkgYmFzZTY=X2RlY29kZSBmdW5jdGlvbl9leGlzdHMgbnVtZXJpYy1uYW1lZCBmdW5jdGlvbiI7YToyOntpOjA7czo1OiJHNktLbyI7aToxO3M6Mzc1OiIvPFw_W3BoXHNdKyhcL1wqKFteXCpdKlwqW15cL1=pKlteXCpdKlwqXC9ccyp8XC9cL1teXG5dKlxzKykqXCRbYS16XzAtOSciXFtcXVxzXSs9XHMqYXJyYXlcKC4qP2Jhc2U2NF9kZWNvZGVcKC4rP1wpKztccyooaWZccypcKFwhZnVuY3Rpb25fZXhpc3RzXChbIiddX1swLTldK1siJ11bXClcc1=rXHtccyp8XD8-XHMqPFw_W3BoXHNdKykqZnVuY3Rpb24gX1swLTldK1woKC4rPylbXH1cc1=rKFw_PlxzKjxcP1twaFxzXStcQD9cJEdMT=JBTFNccyooXFtbXlxdXSpcXStccyp8XHtbXlx9XSpcfStccyopK1woLisoZXZhbHxcJEdMT=JBTFMoXHMqXFtbXlxdXSpcXStccyp8XHtbXlx9XSpcfSspKylccypcKFteXCldK1tcKTtcfVxzXSspKihcMXwkfFw_PikrL2kiO31zOjMyOiJUYWdnZWQgaWYgZW1wdHkgc2NyaXB=IGV2YWwgZWNobyI7YToyOntpOjA7czo1OiJFMUc4OCI7aToxO3M6MTc3OiIvXCMoW2EtejAtOV=rKVwjW1xyXG4gXHRdK2lmWyBcdF=qXChlbXB=eVwoKFwkW2Etel8wLTldKylcKVwpW1xyXG5ceyBcdF=rXDJbXHJcbiciID1cdF=rPHNjcmlwdC4rPyhldmFsfHNyYz1bXFwnIl=raHR=cCkuKz88XC9zY3JpcHQ-W1xyXG4nIjsgXHRdK2VjaG8gXDJbXHJcbjsgXH1cdF=rXCNcL1wxXCMvaXMiO31zOjQ=OiJ2YXIgSFRUUF9VU=VSX=FHRU5UIGlmIG1hdGNoIHN=cmluZyB2YXIgZWxzZSI7YToyOntpOjA7czo1OiJEQUpIMiI7aToxO3M6MTI2OiIvKFwkW2EtelxfMC=5XSspW1x=ID1dK1wkX1NFUlZFUlxbWyInXUhUVFBfVVNFUl9BR=VOVFsnIl1cXTsuKz9pZiBcKFwkW2EtelxfMC=5XStcKFteLF=rLCBcMVwpXCkgXHtbXlx9XStcfSBlbHNlIFx7W15cfV=rXH=vaXMiO31zOjM=OiJkaXYgcGhwIGVycm9yX3JlcG9ydGluZyBmb3BlbiBodHRwIjthOjI6e2k6MDtzOjU6Ikc4UTdYIjtpOjE7czo4NDoiLzxkaXYgW14-XSo-XHMqPFw_W3BoXHNdK2Vycm9yX3JlcG9ydGluZ1woLis_Zm9wZW5cKFsiJ11odHRwOlwvXC8uKz9cPz5ccyo8XC9kaXY-L2lzIjt9czo2OToiRE9DVU1FTlRfUk9PVCBpZiBmaWxlX2V4aXN=cyBmaWxlX2dldF9jb25=ZW5=cyBnemluZmxhdGUgcHJlZ19yZXBsYWNlIjthOjI6e2k6MDtzOjU6IkdDVkc2IjtpOjE7czozNjI6Ii9cJChbYS16XzAtOV=rKVxzKj1bXjtdKlwkX1NFUlZFUltcc1xbXHtdKyhbIiddKShET=NVTUVOVF9ST=9UfFNDUklQVF9OQU1FKVwyW1xzXF1cfV=rLis_aWZccypcKFxzKmZpbGVfZXhpc3RzXHMqXCguKz9cJChbYS16XzAtOV=rKVxzKj1bXHNcQF=qKGZpbGVfZ2V=X2NvbnRlbnRzXHMqXChccypcJFwxLis_XCQoW2Etel8wLTldKylccyo9W1xzXEBdKmd6aW5mbGF=ZVxzKlwoXHMqXCRcNC4rP3ByZWdfcmVwbGFjZS4rP1wpO1tcfVxzXSt8c2NhbmRpclxzKlwoW147XSs7XHMqZm9yZWFjaFxzKlwoXCRcNC4rZndyaXRlXHMqXChbXjtdKztccypmY2xvc2VccypcKFteO1=rO1tcfVxzXSt1bmxpbmtccypcKFxzKlwkXDFcKTtccyopL2lzIjt9czo1NDoiZnVuY3Rpb24gZm91cm9mb3VyIGFkZF9maWx=ZXIgYWxsX3BsdWdpbnMgZm91cm9mb3VyX3BwIjthOjI6e2k6MDtzOjU6IkRCSE1tIjtpOjE7czo4MToiL2Z1bmN=aW9uIGZvdXJvZm91clwoXCkuK2FkZF9maWx=ZXJcKFsiJ11hbGxfcGx1Z2luc1ssICInXStmb3Vyb2ZvdXJfcHBbIiddXCk7L2lzIjt9czoxNDoicCBwYXlkYXkgbG9hbnMiO2E6Mjp7aTowO3M6NToiRzVCQ=siO2k6MTtzOjQ2OiIvPHBbXj5dKj5ccyouKz9wYXlkYXkgbG9hbi4rP1tcclxuXStccyo8XC9wPi9pIjt9czoyNjoic2NyaXB=IHNyYyBlYXJubW9uZXlkby5jb2=iO2E6Mjp7aTowO3M6NToiRzZIRnMiO2k6MTtzOjE2NToiLyg8KHNjcmlwdHxhKVtePl=rKGhyZWY9WyciXVtmaHRwc2w6XSpcL1wvKHNlY3VyZVwucGF5emEpW14-XSs-XHMqPGltZ1tePl=rKT9zcmM9WyciXVtmaHRwc2w6XSpcL1wvKFw=fG9ubGluZS1zYWxlMjR8ZWFybm1vbmV5ZG98Z2NjYW5hZGF8ZzAwKVwuY28uKz9ccyo8XC9cMj5ccyopKy9pIjt9czo5MjoicGhwIHZhciBhcnJheSB2YXIgdGV4dCBpZiBmdW5jdGlvbl9leGlzdHMgZnVuY3Rpb24gZm9yZWFjaCBjaHIgcmV=dXJuIHZhcmlhYmxlIGZ1bmN=aW9uIHRleHQiO2E6Mjp7aTowO3M6NToiRzRSS3MiO2k6MTtzOjMwMzoiLzxcP1twaFxzXSsoXCRbYS16XzAtOV=rKFxzKlxbW15cXV=rXF=rKSpbXHNcLlwrXC1dKj1ccyooKGFycmF5XCh8XCRceyk_KChbJyJdKS4qP1w2fFwkW2Etel8wLTldKyhccypcW1teXF1dK1xdKykqKVtcLlwsXHNcKVx9XSopKztccyopKygoaWZccypcKFteXHtdK1x7XHMqKT9mdW5jdGlvblteXHtdK1x7LipyZXR1cm5bXjtdKjtbXHNcfV=rKSsoaWZccypcKFteXHtdK1x7XHMqKT8oZWNob3xwcmludHxkaWUpW1xzXChce1=rXCRbYS16XzAtOV=rKFxzKlxbW15cXV=rXF=rKSpccypcKFteO1=qO1tcc1x9XSsoJHxcPz5ccyopL2lzIjt9czozNjoiVGFnZ2VkIGVycm9yX3JlcG9ydGluZyBiYXNlNjRfZGVjb2RlIjthOjI6e2k6MDtzOjU6IkZBOUNiIjtpOjE7czoxODM6Ii8oXC9cKi4rP1wqXC98PFwhLS=uKz8tLT4pXHMqKGlmW1woIFwhXStkZWZpbmVkXChbXlwpXStbXCkgXHtdKy4qP2RlZmluZVwoLis_XCkrO1tcc1x9XSopKigoXEB8XCRbYS16XF8wLTldK1xzKltcLj1dKykqKGVycm9yX3JlcG9ydGluZ3xpbmlfc2V=fG9iX3N=YXJ=KVwoLis_KStiYXNlNjRfZGVjb2RlXCguKz9cMS9pcyI7fXM6NDM6IlRhZ2dlZCBjcmVhdGVFbGVtZW5=IHNjcmlwdCBzcmMgYXBwZW5kQ2hpbGQiO2E6Mjp7aTowO3M6NToiRTJHQnUiO2k6MTtzOjE1MjoiL1wvXCogWzAtOWEtel=rIFwqXC9bXHJcbiBcdF=qLisoW2EtejAtOV=rKVtcdCA9XWRvY3VtZW5=XC5jcmVhdGVFbGVtZW5=XChbJyJdUy4rP1wxXC5zcmNbXHQ9IF=rLis_XC5hcHBlbmRDaGlsZFwoXDFcKS4rP1tcclxuIFx=XSpcL1wqIFswLTlhLXpdKyBcKlwvL2kiO31zOjM3OiJQSFAgVmFycyBDb25jYXQgVmFyaWFibGUgRnVuY3Rpb24gRU5EIjthOjI6e2k6MDtzOjU6IkY1UkJXIjtpOjE7czoyNjQ6Ii88XD9bcGhcc1=rKFwkW2EtelxfMC=5XSsoXHMqXFtbXlxdXStcXSspKlxzKj1bXjtdKztccyopKygoXCRbYS16XF8wLTldKyhccypcW1teXF1dK1xdKykqXHMqPVxzKik_KFwkW2EtelxfMC=5XSsoXHMqXFtbXlxdXStcXSspKnxzdHJfcmVwbGFjZXxjcmVhdGVfZnVuY3Rpb24pXChbXjtdKztccyopKygoXCRbYS16XF8wLTldKyhccypcW1teXF1dK1xdKykqXHMqPVxzKik_XCRbYS16XF8wLTldKyhccypcW1teXF1dK1xdKykqXChbXjtdKztccyopKyhcPz58JCkvaSI7fXM6NjU6ImRpdiBzY3JpcHQgZG9jdW1lbnQgZ2V=RWxlbWVudEJ5SWQgdmlzaWJpbGl=eSBoaWRkZW4gZGlzcGxheSBub25lIjthOjI6e2k6MDtzOjU6IkY1SjdjIjtpOjE7czoyNDg6Ii88ZGl2IGlkPVsnIl=oW2EtelxfMC=5XSspWyciXS4rPzxcL2Rpdj5ccyo8c2NyaXB=W14-XSo-XHMqKChmdW5jdGlvblxzKD8haGlkZW1lc3NhZ2UpKFthLXpcXzAtOV=rKXxpZilbXHNcKF=rW15cKV=qW1wpXHNce1=qKT8oZG9jdW1lbnRcLmdldEVsZW1lbnRCeUlkXChbIiddXDFbIiddXClcLnN=eWxlXC4odmlzaWJpbGl=eXxkaXNwbGF5KVxzKj1ccypbIiddKGhpZGRlbnxub25lKVsiJ1=7XHMqKStbXHNcfV=qPFwvc2NyaXB=Pi9pIjt9czo=NzoiYWRkX2FjdGlvbiB3cF9mb29=ZXIgc2VydmUgZXhhbXBsZV9hZG1pbl9ub3RpY2UiO2E6Mjp7aTowO3M6NToiR=IzQ=wiO2k6MTtzOjE2MzoiLyhhZGRfYWN=aW9uXChccypbJyJdKHdwX2Zvb3Rlcnxpbml=fGFkbWluX25vdGljZXMpWyciXVssXHNdKyhcQD9jcmVhdGVfZnVuY3Rpb25bXHNcKF=rKT9bJyJdKC4rP2Jhc2U2NF9kZWNvZGUuKz98ZXhhbXBsZV9hZG1pbl9ub3RpY2V8c2VydmUpWyciXVtcc1wpXSs7XHMqKXsyLH=vaSI7fXM6NTE6IlBIUCBlcnJvcl9yZXBvcnRpbmcgaWYgIWlzc2V=IHZhcmlhYmxlIGZ1bmN=aW9uIEVORCI7YToyOntpOjA7czo1OiJHM=5NViI7aToxO3M6MTkxOiIvKChlcnJvcl9yZXBvcnRpbmdccypcKHxcJFthLXpfMC=5XStccyo9KVteO1=rO1xzKikqaWZccypcKC4rP1wpK1xzKlx7XHMqKChcJFthLXpfMC=5XSspXHMqPVteO1=rO1xzKikqKChcJFthLXpfMC=5XSspXHMqPStccyopP1w=XHMqXCguKz8oXCRbYS16XzAtOV=rXHMqPVxzKik_XDZccypcKFteXCldKlwpK1tccyciXCk7XSpcfS9pcyI7fXM6NjY6InNjcmlwdCBpZiBuYXZpZ2F=b3IgdXNlckFnZW5=IG1hdGNoIGRvY3VtZW5=IHdyaXRlIHNjcmlwdCBzcmMgaHR=cCI7YToyOntpOjA7czo1OiJFM1FDZCI7aToxO3M6MTQ=OiIvPHNjcmlwdD5bXHRcclxuIF=qaWZbXHQgXChdK25hdmlnYXRvclwudXNlckFnZW5=XC5tYXRjaFwoLis_XHtbXHRcclxuIF=qZG9jdW1lbnRcLndyaXRlXChbIiddPHNjci4rPyBzcmM9WyciXWh=dHAuKz9cKVs7XH=gXHRcclxyXSs8XC9zY3JpcHQ-L2kiO31zOjYxOiJwaHAgZnVuY3Rpb24gQXJyYXkgcmV=dXJuIGJhc2U2NF9kZWNvZGUgcGhwIFZhcmlhYmxlIGZ1bmN=aW9uIjthOjI6e2k6MDtzOjU6IkczSUFhIjtpOjE7czoyMzk6Ii8oZnVuY3Rpb25ccysoW2Etel8wLTldKylccypcKFxzKihcJFthLXpfMC=5XSspW1wpXHNce1=rXDNbPVxzXStnemluZmxhdGVcKGJhc2U2NF9kZWNvZGVcKC4rW1wpO1xzXSspP2ZvclxzKlwoW15ce1=rXHtccyooXCRbYS16XzAtOV=rKShccypcW1teXF1dK1xdKykqW1wuXHNdKj1bXEBcc1=qY2hyXChbXjtdK1s7XHNcfV=rKHJldHVyblteO1=qWztcfVxzXSspP2V2YWxcKChcMlwofFw=KVteXCldKltcKVxzXSs7Ki9pIjt9czoyNToiaW5jbHVkZV9vbmNlIHJzcy1pbmZvLnBocCI7YToyOntpOjA7czo1OiJHMzJJQSI7aToxO3M6MTQ5OiIvKChcJFthLXpfMC=5XSspXHMqPS4rP1wuKGpzfHBuZ3xnaWYpWyciXTtccyooaWZbXHNcKF=rfGlzX3xmaWxlfF9leGlzdHMpezMsfVtcKFxzXStcMltcKVxzXSspP1xAP2luY2x1ZGVfb25jZVwoWyciXHNdKihcMi4qP3xyc3MtaW5mb1wucGhwWyciXSlcKTsvaSI7fXM6MjE6ImlzX2JvdCBfX3ZpYV9jb25=ZW5=KSI7YToyOntpOjA7czo1OiJHOU1CViI7aToxO3M6Mjg3OiIvKHZhclxzKyhbYS16XzAtOV=rKVxzKj1bXjtdKztccyopKihmdW5jdGlvblxzKyhbXlwoXSpjb29raWVbXlwoXSp8W2EtejAtOV17NDF9KVwoW15ce1=qXHsuKj8oKGRvY3VtZW5=LmNvb2tpZVteO1=rKDtccypbJyJdKT98cmV=dXJufGlmXHMqXChkb2N1bWVudFwucmVmZXJyZXJbXlx7XStce1xzKlwyXHMqPSlbXjtdKjtccyooXH1ccyopKykrKXs1LH=oXCgqZnVuY3Rpb25ccyooW1woXCldK3xbYS16MC=5XXs=MX1cKFteXHtdKilccypcey4qP1wpO1xzKlx9W1wpXHNdKlwxMFxzKjtccyopezIsfS9pcyI7fXM6NDE6InNldCB2YXIgc3RyX3JlcGxhY2UgdmFyIHZhcmlhYmxlIGZ1bmN=aW9uIjthOjI6e2k6MDtzOjU6IkY3TUM3IjtpOjE7czozMTc6Ii8oKFwkW2EtelxfMC=5XSsoXHMqXFtbXlxdXStcXSkqKVxzKj1ccypcQD9cJFthLXpcXzAtOV=rKFxzKlxbW15cXV=rXF=rKSpccypcKFxAP1wkXyhSRVFVRVNUfEdFVHxQT1NUfENPT=tJRSkoXHMqXFtbXlxdXStcXSspKlwpO1xzKikrKFwkW2EtelxfMC=5XSt8cHJlZ19yZXBsYWNlKVxzKlwoXHMqKFsnIl=pKFtcIVwvXCNcfFxAXCVcXlwqXH5dKS4rP1w5W2ltc3hdKmVbaW1zeF=qXDhccyosXHMqXDJccyosKChbXCRhLXpcXzAtOV=rKFxzKlxbW15cXV=rXF=pKnwnW14nXSonfCJbXiJdKiIpW1wuXHNdKikrXCkrO1xzKihkaWVcKFteXCldKlwpKzspPy9pIjt9czo2NDoiVGFnZ2VkIGVycm9yX3JlcG9ydGluZyBjdXJsX2luaXQgZmlsZV9nZXRfY29udGVudHMgZndyaXRlIHNjcmlwdCI7YToyOntpOjA7czo1OiJHNUhFNSI7aToxO3M6NDgxOiIvPFw_W3BoXHNdKyhbXEBcL1wjXHNdKihlcnJvcl9yZXBvcnRpbmd8aW5pX3NldHxzZXRfdGltZV9saW1pdHxoZWFkZXIpXHMqXChbXlwpXSpbXCk7XHNdKykqKChbO1xzXSooXCRbYS16XzAtOV=rXHMqPVteO1=rO1xzKnxlbHNlW1xzXHtdKikqaWZccypcKFteO1=rKSsoKGZpbGVfZ2V=X2NvbnRlbnRzXHMqXCh8bWtkaXJccypcKHxjdXJsX1thLXpdK1xzKlwofGRpZVxzKlwofChlY2hvfHByaW5=KVteO1=rO1xzKihyZXR1cm58ZXhpdCkpW15cfV=rXH1ccyopKykrKGVsc2VbXHNce1=qKT8oXCRbYS16XzAtOV=rXHMqPVxzKmZpbGVfZ2V=X2NvbnRlbnRzXChbXjtdKztbXH1cc1=qKSooXC8qKFwkW2Etel8wLTldK1xzKj=pP1tcQFxzXSooZm9wZW58ZndyaXRlfGZjbG9zZSlccypcKFteO1=rO1xzKil7Myx9KChoZWFkZXJ8ZWNob3xwcmludHxpZlxzKlwoW15ce1=rW1x7XHNdKmNobW9kXHMqXCgpW147XSo7W1x9XHNdKykrKCR8XD8-XHMqKS9pIjt9czo3MDoiZmlsZV9leGlzdHMgY3VybF9pbml=IGZpbGVfZ2V=X2NvbnRlbnRzIGZpbGVfcHV=X2NvbnRlbnRzIGluY2x1ZGVfb25jZSI7YToyOntpOjA7czo1OiJIMTU5NiI7aToxO3M6MjMyOiIvKFwkW2Etel8wLTldKylccyo9XHMqLis_KGN1cmxfaW5pdHxmaWxlX2dldF9jb25=ZW5=c1woW1xzJyJdK2h=dHBbc1w6XC9dKykuKz9maWxlX3B1dF9jb25=ZW5=c1woXDEuKz8oaW5jbHVkZV9vbmNlfChcJFthLXpfMC=5XSspXHMqPVxzKm5ld1xzK1thLXpfMC=5XSspXChcMS4qP1wpO1xzKiguKlw=W147XSo7XHMqfFx9XHMqfGVsc2Vccyp8XHtccyp8ZGllW1xzXCgnIl=rW15cKV=qXCkrO1xzKikqL2lzIjt9czozODoibG9uZyBzdHJpbmcgdmFyIGV2YWwgdmFyaWFibGUgZnVuY3Rpb24iO2E6Mjp7aTowO3M6NToiSDI=RmoiO2k6MTtzOjQyNzoiLzwoXD98c2NyaXB=IGxhbmd1YWdlPSlbcGhccyciPl=rKFwkW2Etel8wLTldKyhccypcW1teXF1dK1xdKykqW1xzXC5dKj1ccyooKFsnIl=pW15cNV=rXDV8W147XSspO1xzKnxcL1wvLipccyp8XC9cKlteXCpdKihcKlteXCpcL1=qKStcL1xzKnxmb3IoZWFjaCk_W1xzXChdK1teXHtdK1x7W15cfV=rXH=rW1x9XHNdKykrKFw_PlxzKjxcP1twaFxzXSspKigoKGV2YWx8aWYoW1xzXChcIVxAXStbYS16XzAtOV=rKT8pXHMqXCgpKihcJFtcJFx7XSpbYS16XzAtOV=rW1x9XHNcKV=qKFxbW15cXV=rXF1ccyp8PStccyooXCRbYS16XzAtOV=rfGNyZWF=ZV9mdW5jdGlvbikpKltcKVxzXHs7XH1dKikrXCguKj9bXClcc1x9O1=rKSsoZWNob1teO1=rO1xzKnxcL1wqW15cKl=qKFwqW15cKlwvXSopK1wvXHMqKSooXD8-KC4rJCk_fCR8PFwvc2NyaXB=PikvaSI7fXM6NDE6InBocCB2YXIgZXhwbG9kZSBudW1iZXJzIFZhcmlhYmxlIGZ1bmN=aW9uIjthOjI6e2k6MDtzOjU6IkgyNEZsIjtpOjE7czoyMTg6Ii88XD9bcGhcc1=rKGlmXHMqXCgoW15ce1=rW1x7XHNdKlwkR=xPQkFMU1tce1xbXVsnIl1cXHhbXjtdKztbXH1cc1=qKSsoXD8-XHMqPFw_W3BoXHNdKykpP1wkW2Etel8wLTldK1xzKj1ccyooJy4rPyd8Ii4rPyIpO1xzKi4qP1xzKlwkW2Etel8wLTldK1xzKj1ccypleHBsb2RlXChbXixdK1ssIidcLjAtOVxzXStcKTtccyouKj9cJFthLXpfMC=5XStccypcKC4qP1w_PiguKyQpPy9pIjt9czo5MzoiZnVuY3Rpb24gWCBpZiBmdW5jdGlvbl9leGlzdHMgY3VybF9pbml=IHNwYW1jaGVja3IuY29tIGN1cmxfZXhlYyBjdXJsX2Nsb3NlIGVjaG8gYWRkX2FjdGlvbiBYIjthOjI6e2k6MDtzOjU6Ikc1TDg4IjtpOjE7czo1MzY6Ii8oXC9cKi4qP1wqXC9ccyopKihcPz5ccyo8XD9bcGhcc1=qKT8oaWZccypcKFteXHtdK1x7XHMqZnVuY3Rpb25ccysoW2Etel8wLTldKylcKFteXHtdK1x7XHMqKT9pZltcc1woXCFdK2Z1bmN=aW9uX2V4aXN=c1woXHMqWyciXShbYS16XzAtOV=rKVsnIl1bXHNcKV=rXHtccyooKGZ1bmN=aW9uXHMrXDVcKCk_Lis_KHNwYW1jaGVja3JcLmNvbXxqYXZhdGVybTFcLnB3fFsnIl1qcXVlcnlcLikuKz9jdXJsX2luaXQuKz9jdXJsX2V4ZWMuKz9jdXJsX2Nsb3NlW147XStbO1xzXStlY2hvfGZ1bmN=aW9uXHMrXDVccypcKFteXCldKltcKVxzXStce1xzKihcJFthLXpfMC=5XStccyo9W147XStbO1xzXSspKihpZltcc1woXStcQD8oXCR8Zm9wZW5bXHNcKF=rKVteXHtdK1tce1xzXSopP2VjaG9cKHdwX3JlbW9=ZV9yZXRyaWV2ZV9ib2R5XCh3cF9yZW1vdGVfZ2V=XCgpW147XSs7W1xzXH1dKyhhZGRfYWN=aW9uW15cLF=rXCxccypbJyJdKFw1fFw=KVsnIl1bXHNcKTtdK1x9KT8oXHMqXD8-XHMqPFw_W3BoXSopPyhccypcL1wqLio_XCpcLykqL2lzIjt9czo5NjoiaWYgZnVuY3Rpb25fZXhpc3RzIGZ1bmN=aW9uIGVycm9yX3JlcG9ydGluZyBWYXJpYWJsZSB4RkYgSCogaWYgZmlsZV9leGlzdHMgZXJyb3JfcmVwb3J=aW5nIGVuZGlmIjthOjI6e2k6MDtzOjU6IkU5MkdwIjtpOjE7czoyNzA6Ii9pZlsgXChcIV=rZnVuY3Rpb25fZXhpc3RzXChbICciXSsoLis_KVsgJyJdK1tcKSBcdF=rXDouKz9mdW5jdGlvbiBcMVwoXCkgXHsuKz9lcnJvcl9yZXBvcnRpbmdcKDAuKz8oXCQoW2EtejAtOVxfXSspWyA9XHRdKyIoXFx4WzAtZl17Mn=pKyI7W1x=IFxyXG5dKyhcJChbYS16MC=5XF9dKylbID1cdF=rXCQoW2EtejAtOVxfXSspXCgiSFwqIlwsLis_O1tcdCBcclxuXSspKykraWZbIFwoXCFdK2ZpbGVfZXhpc3RzLis_ZXJyb3JfcmVwb3J=aW5nXChcJC4rP2VuZGlmOy9pcyI7fXM6MTc6ImluY2x1ZGUgSW1hZ2VGaWxlIjthOjI6e2k6MDtzOjU6IkgxMkoxIjtpOjE7czoyNTY6Ii8oPzwhXC9cL1xzezh9KVxAPyhpbmNsdWRlfHJlcXVpcmUpKF9vbmNlKT9bXChcc1=rW2Etel8wLTksXC4nXHMiXC9cLV=rPyg_PCFHRF9TWVNURU1fUExVR=lOX=RJUiBcLiAnXC9pbWFnZXNcLzQwNCkoXC4oZ2lmfGpwZ3xwbmd8Y2J1fGNzc3xbXHMiJ1=rXC93cC1pbmNsdWRlc1wvaW5pdFwucGhwfFtccyInXStcL3dwLWFkbWluXC9pbmNsdWRlc1wvY2xhc3Mtd3AtaXRlcm5hbC11cGdyYWRlXC5waHApfHdwLWphdmFcLnBocClbIidcc1wpXSs7L2kiO31zOjQxOiIvZnVuY3Rpb24gYXJyYXkgVmFyaWFibGUgRnVuY3Rpb24gaWYgZXZhbCI7YToyOntpOjA7czo1OiJHMk5OQyI7aToxO3M6MzU2OiIvKFwvXCpbXlwqXSooXCpbXlwqXC9dKikrXC9ccyopKigoXCRbX1wtPlwuYS16MC=5XSspXHMqPVteO1=rO1xzKihbYS16XzAtOV=rKVwoW15cKV=qXDRbXlwpXSpbXClccztdK1xzKmZ1bmN=aW9uXHMqXDV8ZnVuY3Rpb25ccypbYS16XzAtOV=rKVxzKlwoW15ce1=rXHtccyooXCRbX1wtPlwuYS16MC=5XSspXHMqKFxbW15cXV=rXF=rXHMqKSo9XHMqYXJyYXkoX21hcCk_XHMqXCguKz9cKTtccyooXCRbX1wuYS16MC=5XFsnIlxdXHNdKyg9W147XSpcNlteO1=qO1xzKnxcKC4rP2lmW1xzXChdKlwkW19cLmEtejAtOVxbJyJcXVxzXStcKVxzKlx7KSkrXHMqKHJldHVyblxzKik_ZXZhbFxzKlwoW15cKV=rW1wpXHM7XH1dKy9pcyI7fXM6NDM6IlRhZ2dlZCBlcnJvcl9yZXBvcnRpbmcgSFRUUF9VU=VSX=FHRU5UIGN1cmwiO2E6Mjp7aTowO3M6NToiRzNON2ciO2k6MTtzOjIyMDoiLyhlcnJvcl9yZXBvcnRpbmdccypcKFteO1=rO1xzKnxcJFthLXpfMC=5XStccyo9XHMqYXJyYXlccypcKFteXCldK1wpK1s7XClcc1=qKSppZlxzKlwoW15cKV=rSFRUUF9VU=VSX=FHRU5UKC4rP2h=dHA6XC9cL3wuKz9jdXJsX2luaXQpezIsfS4rPyhcJFthLXpfMC=5XSspP1tccz1dKmN1cmxfZXhlYy4rPyhwcmludHxkaWV8ZWNobylbJyJcc1woXStcM1snIlxzXCk7XH1dK1xzKi9pcyI7fXM6MzA6ImhlYWRlciBMb2NhdGlvbiBodHRwIHNwYWNlLnBocCI7YToyOntpOjA7czo1OiJFOTlEcCI7aToxO3M6NjM6Ii9oZWFkZXJcKFsnIl1Mb2NhdGlvbjogaHR=cDpcL1wvW15cL1=rXC9zcGFjZVwucGhwXD9bXlwpXStcKTsvaSI7fXM6NTA6IkNvcHlyaWdodCBmdW5jdGlvbiBnZXRDb29raWUgZG9jdW1lbnQud3JpdGUgaWZyYW1lIjthOjI6e2k6MDtzOjU6IkY5VUF4IjtpOjE7czo5MToiLyhcL1wqLis_XCpcLylccypmdW5jdGlvblxzKyhbYS16XzAtOV=rKVwoLis_bmF2aWdhdG9yXC51c2VyQWdlbnQuKz88aWZyYW1lIC4rP1wyXCguKz9cMS9pcyI7fXM6Mzc6IkNvcHlyaWdodCBmdW5jdGlvbiBzZXRDb29raWUgZnVuY3Rpb24iO2E6Mjp7aTowO3M6NToiRjFDRm8iO2k6MTtzOjE5NzoiL1wvXCpccypDb3B5cmlnaHQuK1xzKlwqXC9ccyooZnVuY3Rpb24gW3NnXWV=Q29va2llXCguKz9yZXR1cm5bXjtdKls7XH1cc1=rKSpmdW5jdGlvbiAoW2EtejAtOVxfXSspXChcKVtce1xzXSsoW2EtejAtOVxzXD1dK25hdmlnYXRvclwudXNlckFnZW5=Lis_fGZ1bmN=aW9uXHMrKVtzZ11ldENvb2tpZVwoLis_XDJcKFteO1=rWztcfVxzXSsvaXMiO31zOjIxOiJwaHAgaGV4LWVuY29kZWQtbGluZXMiO2E6Mjp7aTowO3M6NToiRjE=SGsiO2k6MTtzOjYwOiIvPFw_W3BoXHNdKyhbXjtdKlx4WzAtOWEtZl17Mn1bXjtdKls7XHNdKyl7OSx9LipccyooXD8-fCQpL2kiO31zOjM1OiJwaHAgYXJyYXkgaHR=cCBtdF9yYW5kIG1ldGEgcmVmcmVzaCI7YToyOntpOjA7czo1OiJFQTJEdiI7aToxO3M6MjAzOiIvPFw_KHBocCk_W1xyXG4gXHRdKlwkW2EtelxfMC=5XStbXHQgPV=rYXJyYXlbIFwoXHJcblx=XSsoWyciXWh=dHAuK1ssIFwpO1xyXG5cdF=rKStcJFthLXpcXzAtOV=rW1x=ID1dK21=X3JhbmRcKC4rWyBcKTtcclxuXHRdKyhcJFthLXpcXzAtOV=rW1x=ID1dKy4rW1xyXG4gXHRdKikrXD8-WyBcclxuXHRdKjxtZXRhICguKz88XD8uKz9cPz4pKi4qPz4vaSI7fXM6NDQ6InBocCBhcnJheSBmdW5jdGlvbiByZXR1cm4gYmFzZTY=X2RlY29kZSBldmFsIjthOjI6e2k6MDtzOjU6IkY3UTBEIjtpOjE7czoyMjU6Ii88XD9bcGhcc1=rXCRbX1wtXD5cLmEtejAtOVx7XFsnIlxdXH1dK1xzKj1ccyphcnJheVwoLis_ZnVuY3Rpb25ccysoW2Etel8wLTldKylcKCguKz87XHMqKSsoKFwkW2Etel8wLTldK1xzKj1ccyopPyhldmFsfFwkW2Etel8wLTldKyhccypcW1teXF1dK1xdKSopXHMqXChccyooXCRfKFJFUVVFU3xHRXxQT1MpVFxbKT9bXlwpXStbXCk7XHNdKyhleGl=fGRpZSlbXjtdKjtccyopKygkfFw_PikvaSI7fXM6NTY6InBocCBpZiBpc3NldCBHTE9CQUxTIHN=cnRvbG93ZXIgU=VSVkVSIGlmIHN=cnN=ciBHTE9CQUxTIjthOjI6e2k6MDtzOjU6IkVBQUVkIjtpOjE7czoyNDE6Ii88XD9bcGhdKlxzK2lmW1woXHNdK1whaXNzZXRbXChcc1=rXCRHTE9CQUxTXFsiXFx4W15cXV=rW1xdXClcc1x7XSsoXCRbYS16XzAtOV=rKVtccz1dK3N=cnRvbG93ZXJbXChcc1=rXCRfU=VSVkVSXFsiXFx4W15cXV=rW1xdXCk7XHNdKygoaWZ8YW5kKVtcKFxzXCFdK3N=cnN=cltcKFxzXStcMVtccywiJ1=rXFx4W15cKV=rW1wpXHNce1=rKStcJEdMT=JBTFNcWyJcXHhbXlxdXStcXVteO1=qO1tcfVxzXSsoXD8-fCQpL2kiO31zOjQyOiJmdW5jdGlvbiByZXR1cm4gZnVuY3Rpb24gVmFyaWFibGUgZnVuY3Rpb24iO2E6Mjp7aTowO3M6NToiRUFLQUIiO2k6MTtzOjIwMjoiLyhmdW5jdGlvblthLXpfMC=5XHNdK1woW15cKV=qW1wpXHNdK1x7XHMqcmV=dXJuW2Etel8wLTlcc1=rXChbXlwpXSpbXClcc1=rOypcfStccyopKyhcJFthLXpfMC=5XStbPVxzXSsoW2Etel8wLTlcc1=rXChbXlwpXSpbXClcc1=rfFsnIl1bXjtdKik7K1xzKikrKFwkW2Etel8wLTldKylbPVxzXStbXjtdK1snIlwpO1=rXHMqXDRccypcKCsuKj9cKTsvaSI7fXM6MTc6ImV2YWwgY2hyIFJFUEVBVEVEIjthOjI6e2k6MDtzOjU6Ikc1Qk5hIjtpOjE7czoyMTI6Ii8oPFw_W3BoXSp8XC9cKlteXCpdKlwqXC8pXHMqKChcJFthLXpfMC=5XSspXHMqPVxzKicpPyguKz9cLlxzKmNoclwoWzAtOV=rXClccypcLil7MjB9LitccyooXDNccyo9XHMqc3RyX3JlcGxhY2VcKCdcI1snLFxzXStcM1wpO1xzKik_KChcJFthLXpfMC=5XSspXHMqPVxzKmNyZWF=ZV9mdW5jdGlvblwoWydccyxdKlwzXCk7XHMqXDdcKFwpOyk_KFw_PlxzKnwkfFwxKS9pIjt9czozNjoiZ2FyYmFnZSBhcm91bmQgZXZhbCBWZXJpYWJsZUZ1bmN=aW9uIjthOjI6e2k6MDtzOjU6Ikc1TjZiIjtpOjE7czoyNDg6Ii88XD9bcGhcc1=rKFwkW2Etel8wLTldK1tcc1wuXSo9KFtcc1wuXSooKFsiJ1=pLis_KD88IV9lKVw=fFwvXCpbXlwqXSooXCpbXlwqXC9dKikrXC98XCRbXCRce1=qW2Etel8wLTldKltcfVxzXSooXFtbXlxdXStcXStccyopKikpKztccyopKygoZXZhbHxpZilccypcKCk_XCRbXCRce1=qW2Etel8wLTldK1tcfVxzXSooXFtbXlxdXStcXVtcc1=qKSpcKC4qPyguKydbXC47XCldKyk_KFxzKicuKydbXC47XCldKykqXHMqKFw_PnwkKS9pIjt9czo1NjoiaWYgZGVmaW5lZCBkZWZpbmUgZnVuY3Rpb24gZ2xvYmFsIGV2YWwgVmFyaWFibGUgRnVuY3Rpb24iO2E6Mjp7aTowO3M6NToiRzFITGYiO2k6MTtzOjE5NzoiL2lmW1woXHNdK1whZGVmaW5lZFwoW15cKV=rW1wpXHNdK1x7XHMqZGVmaW5lXChbXlwpXStbXClcc1=rO1xzKmZ1bmN=aW9uW15cKF=qXChbXlwpXSpbXClcc1=rXHtccypnbG9iYWwgKFwkW147XSspO1xzKiguKz9ccyopK2V2YWxcKFwxKFxbW15cXV=rXF1ccyopKlwoW15cKV=qW1wpXHNdKzsoXHMqcmV=dXJuW147XSo7KT9ccypcfVxzKlx9L2kiO31zOjI1OiJpZnJhbWUgc21hbGwgaGVpZ2h=fHdpZHRoIjthOjI6e2k6MDtzOjU6IkczUzhmIjtpOjE7czoxNTM6Ii8oPHNjcmlwdFtePl=rc3JjPVsnIl=_aHR=cFw6XC9cLyhbYS16XC5cLTAtOV=rKVtePl=qPjxcL3NjcmlwdD4pPzxpZnJhbWUuKj8oXHMqKGhlaWdodHx3aWR=aHxzcmMpPVsnIl=_KFswLTVdWyciXHNdfGh=dHBcOlwvXC8uKz8pKXszfVtePl=qPjxcL2lmcmFtZT4vaSI7fXM6NDk6InBocCBnbG9iYWwgYXJyYXkgZnVuY3Rpb25fZXhpc3RzIHJldHVybiBmb3IgdW5zZXQiO2E6Mjp7aTowO3M6NToiRUM4MU8iO2k6MTtzOjI2MToiL2dsb2JhbCAoXCRbYS16MC=5XF9dKyk7XHMqXDFbXHM9XSthcnJheVwoLis_ZnVuY3Rpb25fZXhpc3RzXChbXlwpXStbXClcc1wmXStcIWZ1bmN=aW9uX2V4aXN=c1woWyciXShbYS16MC=5XF9dKylbJyJdW1wpXHNce1=rZnVuY3Rpb25ccytcMlwoW15cKV=rW1wpXHNce1=rZ2xvYmFsIFwxOy4rP3JldHVyblteO1=qWztcc1x9XStmb3JccypcKFteXCldKltcKTtcfV=rKFx7XHMqW1wkYS16MC=5XF9dK1woW15cKV=rW1wpO1x9XSspP3Vuc2V=XChcMVwpOy9pIjt9czoxMzoiZXZhbCBwYWNrIEhleCI7YToyOntpOjA7czo1OiJGOFREbyI7aToxO3M6MzI1OiIvKFwvXCouKj9cKlwvXHMqfFwkW2Etel8wLTlcWyciXF1cc1=rPVxzKihbJyJdKS4qP1wyO1xzKikqKGlmW1xzXChcIV=rZnVuY3Rpb25fZXhpc3RzW1woXHNdKyhbJyJdKShbYS16XzAtOV=rKVw=W1wpXHNdK1x7XHMqKT8oZnVuY3Rpb25ccysoW2Etel8wLTldKylcKFteXCldKltcKVxzXStce1teXH1dK3BhY2tcKFsnIl1IXCpbJyIsXHNcLjAtOUEtRl=rW1wpO1xzXStyZXR1cm5bXjtdKls7XHNdK1x9Wztcc1=rKT9ldmFsXCgoXDVcKFteXCldKltcKTtcc1x9XSt8XDdcKFteXCldKltcKTtcc1=rfHBhY2tcKFsnIl1IXCpbJyIsXHNcLjAtOUEtRl=rW1wpO1xzXSspL2lzIjt9czo=NzoicGhwIEhUVFBfVVNFUl9BR=VOVCBpZiBoZWFkZXIgTG9jYXRpb24gaHR=cCAucnUiO2E6Mjp7aTowO3M6NToiRzMxTFIiO2k6MTtzOjMxMDoiLzxcP1twaFxzXSooXCRbYS16XzAtOV=rKVxzKj1ccyooYXJyYXlcKFteXCldK1wucnVbJyJdXCkrO1xzKihcJFthLXpfMC=5XSspXHMqPVxzKlwxXFsuKztccyooXCRbYS16XzAtOV=rKVxzKj1bXHNcKF=qcHJlZ19tYXRjaFxzKnxcJF9TRVJWRVJcW1siJ11IVFRQX1VTRVJfQUdFTlRbJyJdXF=7XHMqaWZbXHNcKF=rW1wkYS16XzAtOV=rKVwoLiooXDN8XDEpLipbXClcc1x7XStoZWFkZXJcKFsnIl1Mb2NhdGlvbjpccyooaHR=cDpcL1wvLitcLnJ1XC8uKnxbJyJcLlxzXSt8XDF8XDN8XDQpK1wpO1tcc2RpZVwoXCk7XH1dKihcPz5ccyp8JCkvaSI7fXM6ODQ6InJlcXVpcmVfb25jZSB3cC11cGRhdGUucGhwIFJFTU9URV9BRERSIEhUVFBfVVNFUl9BR=VOVCByZXF1aXJlX29uY2Ugd3AtY2xhc3MucGhwIGRpZSI7YToyOntpOjA7czo1OiJGM=tHciI7aToxO3M6MTk2OiIvPFw_Lis_cmVxdWlyZV9vbmNlW1xzXCgiJ1=rd3AtdXBkYXRlXC5waHBbIidcKTtcc1=rXCRpcCA9IFwkX1NFUlZFUlxbWyInXVJFTU9URV9BRERSWyInXVxdOy4rP1wkX1NFUlZFUlxbWyInXUhUVFBfVVNFUl9BR=VOVFsiJ11cXS4rP3JlcXVpcmVfb25jZVtcc1woIiddK3dwLWNsYXNzXC5waHBbIidcKTtcc1=rZGllXCguKz8oJHxcPz4pL2lzIjt9czozNjoiZXZhbCBkZWNvZGVVUklDb21wb25lbnQgRW5jb2RlZC1=ZXh=IjthOjI6e2k6MDtzOjU6IkYxMTRnIjtpOjE7czoxMTU6Ii8oXC9cKlxzKmh=dHA6XC9cL3d3dy5KU=9OLm9yZ1wvanNvbjJcLmpzLis_KT9ldmFsW1xzXChdK2RlY29kZVVSSUNvbXBvbmVudFtcc1woXStbIiddXCVbXCUwLTlhLXpdK1snIl1bXCk7XHNdKzsvaXMiO31zOjg2OiJmdW5jdGlvbnMgQkROIFNWQiBTQ2sgR=NrIGlmIGNvb2tpZUVuYWJsZWQgR=NrIGVsc2UgU=NrIGlmIGxvYWRlZCBTVkIgYWRkRXZlbnRMaXN=ZW5lciI7YToyOntpOjA7czo1OiJFQ=ZHWiI7aToxO3M6NDMwOiIvZnVuY3Rpb24gQkROXCguKz9mdW5jdGlvbiBTVkJcKC4rP2Z1bmN=aW9uIFNDa1woLis_ZnVuY3Rpb24gR=NrXCguKz9yZXR1cm4gdW5lc2NhcGVcKGRvY3VtZW5=XC5jb29raWVcLnN1YnN=cmluZ1woW15cKV=rW1wpO1xzXH1dK2lmW1xzXChdK25hdmlnYXRvclwuY29va2llRW5hYmxlZFtcKVxzXHtdK2lmW1xzXChcIV=rR=NrXChbXlx7XStce1tcfWVsc2Vce1xzXSpTQ2tcKFteXCldK1tcKTtcc1=raWZbXHNcKF=rZG9jdW1lbnRcLmxvYWRlZFtcKVx7XHNdK1NWQlwoW15cKV=qW1wpO1xzXH1dK2Vsc2VbXHtcc1=raWZbXHNcKF=rd2luZG93XC5hZGRFdmVudExpc3RlbmVyW1wpXHtcc1=rd2luZG93XC5hZGRFdmVudExpc3RlbmVyXChbXlwpXStbXCk7XHNcfV=rZWxzZVtce1xzXSt3aW5kb3dcLmF=dGFjaEV2ZW5=XChbXlwpXStbXCk7XHNcfV=rL2lzIjt9czoxODoiZGl2IHN=eWxlIG9wYWNpdHkwIjthOjI6e2k6MDtzOjU6IkYzOElNIjtpOjE7czo5MzoiL1xzKjxkaXYgc3R5bGU9WyciXVtePl=qb3BhY2l=eVxzKi5ccyowKFteXC5dfFwuWzAtMV=pW14-XSo-XHMqKDxhIC4rPzxcL2E-XHMqKSsuKz88XC9kaXY-L2lzIjt9czo=NDoicGhwIGVycm9yX3JlcG9ydGluZyBMb25nIG1haWwgcHJpbnRfciBTRVJWRVIiO2E6Mjp7aTowO3M6NToiSDIyTUYiO2k6MTtzOjMxNToiLzxcP1twaFxzXSooZXJyb3JfcmVwb3J=aW5nXCguezk5OTksfXwoXCRbYS16XzAtOV=rXHMqPVxzKigxfFwkXyhSRVFVRVN8R=V8UE9TKVQoXHMqXFtbXlxdXStcXSspKyk7XHMqKSsoaWZccypcKFteXCldK1tcKVxzXHtdK2RpZVtcc1woXStbXjtdKztbXHNcfV=qKStpZlxzKlwoW15cKV=rW1wpXHNce1=rd2hpbGVccypcKFteXCldK1tcKVxzXHtdKyltYWlsXHMqXCguKyhwcmludF9yXChcJF9TRVJWRVIuK3xccyplY2hvLitccypcJFthLXpfMC=5XCs7XStbXH1cc1=qKShcPz4oKFxzKltcWzxdaHRtbFtcXT5dKXsyfVteJF=rPFwvaHRtbD4pP3wkKS9pIjt9czo2NzoiaWYgIWZ1bmN=aW9uX2V4aXN=cyBmdW5jdGlvbiBjdXJsIHJldHVybiBmdW5jdGlvbiBpbmNsdWRlIGZ1bmN=aW9ucyI7YToyOntpOjA7czo1OiJFQ==yNCI7aToxO3M6Mjg3OiIvaWZccypcKFxzKlwhZnVuY3Rpb25fZXhpc3RzXChbIiddKFthLXpfMC=5XSspWyciXVwpW1wpXHNce1=qZnVuY3Rpb25ccypcMVwoW15cKV=rXClbXClcc1x7XSsoW15cbl=qY3VybF9bXlxuXStccyspK3JldHVyblteXG5dK1tccytcfV=rZnVuY3Rpb25ccypbYS16XzAtOV=rXChbXlwpXSpcKVtcKVxzXHtdKygoXCRbYS16XzAtOV=rKVxzKj1ccyooW2Etel8wLTldKylcKFteXG5dK1xzKykraW5jbHVkZVtcKFxzXStcNC4rP2Z1bmN=aW9uXHMrXDUuKz8oJHwoPz1mdW5jdGlvbiApfCg_PVw_XD4pKS9pcyI7fXM6NTk6ImlmICFjdXJyZW5=X3VzZXJfY2FuIGFkZF9maWx=ZXIgZnVuY3Rpb24gYSBocmVmIGh=dHAgcmV=dXJuIjthOjI6e2k6MDtzOjU6IkVDTTNSIjtpOjE7czoyNjU6Ii9pZlxzKlwoXHMqXCFjdXJyZW5=X3VzZXJfY2FuXChbXlwpXStbXClcc1x7XSphZGRfZmlsdGVyW1xzKlwoXStbXixdKyxccypbIiddKFthLXpfMC=5XSspWyciXVwpW1wpO1xzXH1dK2Z1bmN=aW9uXHMqXDFcKC4rP2FkZF9maWx=ZXJbXHMqXChdK1teLF=rLFxzKlsiJ1=oW2Etel8wLTldKylbJyJdXClbXCk7XHNcfV=rLityZXR1cm5bXjtdKls7XHNcfV=rZnVuY3Rpb25ccypcMlwoLis_PGEgaHJlZj1bJyJdaHR=cDpcL1wvLityZXR1cm5bXjtdKls7XHNcfV=rL2kiO31zOjU5OiJwaHAgQXJyYXkgZnVuY3Rpb24gcmV=dXJuIGJhc2U2NF9kZWNvZGUgZXZhbCBGdW5jdGlvbiBBcnJheSI7YToyOntpOjA7czo1OiJFQ=41dCI7aToxO3M6MTgzOiIvPFw_W3BoXHNdKyhcJFthLXpcXzAtOV=rXHMqPVteO1=rWztcc1=rKSooXCRbXCRce1=qW2EtelxfMC=5XStcfSooXHMqXFtbXlxdXStcXSkqKVxzKj1ccyphcnJheS4rP2Z1bmN=aW9uIChbYS16XF8wLTldKykuKz9yZXR1cm4gYmFzZTY=X2RlY29kZS4rP2V2YWxcKFxzKlw=W147XStcMlteO1=rWztcc1x9XD8-XSsvaXMiO31zOjM4OiJwaHAgVmFyIEFycmF5IENvbmNhdCBWYXJpYWJsZSBGdW5jdGlvbiI7YToyOntpOjA7czo1OiJHNU43TyI7aToxO3M6MjM1OiIvPFw_W3BoXHNdKyhcL1wvLipbXHNdKykqKChcJFthLXpfMC=5XSspXHMqPVxzKigoJ1teJ1=qKD88IV9lKSd8IlteIl=qInxcJFthLXpfMC=5XSspW1xzXC5dKikrW147XSo7XHMqKSs_KFxAP1wkKFtcJFx7XSpbYS16XzAtOV=rXH=qKFxzKlxbW15cXV=rXF=pKlxzKj1bXHNcQD9cJFx7XSpcJCk_W1wkXHtdKlthLXpfMC=5XStcfSooXHMqXFtbXlxdXStcXSkqXHMqXChbXjtdKztccyopKy4qXHMqKCR8XD8-KS9pIjt9czo2MzoicGhwIGFycmF5IGltcGxvZGUgZnVuY3Rpb24gVmFyIEhleCByZXR1cm4gVmFyaWFibGVGdW5jdGlvbiBldmFsIjthOjI6e2k6MDtzOjU6IkVDUEQyIjtpOjE7czoyODQ6Ii88XD9bcGhcc1=rKFwkW2EtelxfMC=5XSspXHMqPVxzKmFycmF5W147XStbO1xzXSsuKz8oXCRbYS16XF8wLTldKylccyo9XHMqaW1wbG9kZVteO1=rXDFbXjtdK1s7XHNdK2Z1bmN=aW9uIChbYS16XF8wLTldKylcKFteXCldK1tcKVx7XHNdKyhcJFthLXpcXzAtOV=rXHMqPVtccyciXSsoXFx4WzAtOWEtZl17Mn=pK1snIl=7XHMqKStyZXR1cm5bXjtdKz9cJFthLXpcXzAtOV=rKFxzKlxbW15cXV=rXF=pKlwoW147XStbO1x9XHNdK2V2YWxcKFwzXChccypcMlteO1=rWztcc1=rLis_KCR8XD8-KS9pIjt9czo1ODoicGhwIGFycmF5IGlmIFNFUlZFUiBpZiBpc2JvdCBmaWxlX2dldF9jb25=ZW5=cyBoZWFkZXIgaHR=cCI7YToyOntpOjA7czo1OiJGQVZGOSI7aToxO3M6Mjk4OiIvPFw_W3BoXHNdKygoZXJyb3JfcmVwb3J=aW5nfGluaV9zZXQpXHMqXChbXjtdKjtccyopKihcJFthLXpcXzAtOV=rXHMqPVteO1=rWztcc1=rKSsoaWZbXjtdK1wkaXNib3RbXjtdK1s7XH1cc1=rKSsoLis_KFwkW2Etel8wLTldKylccyo9XHMqKGZpbGVfZ2V=X2NvbnRlbnRzfGN1cmxfZXhlYylccypcKFteXH1dK1tcfVxzXSspKygoXCRbYS16XF8wLTldKylccyo9W147XSpcNlteO1=qWztcc1=rKSouKygoXDZ8XDkpW147XStbO1x9XHNdKygoaGVhZGVyfGVjaG98cHJpbnQpW147XStbO1x9XHNdKykrKSsoJHxcPz4pL2lzIjt9czo=MzoicGhwIFJFUVVFU1QgYXJyYXkgUkVRVUVTVCBhcnJheV9maWx=ZXIgZXhpdCI7YToyOntpOjA7czo1OiJFQ1FDcCI7aToxO3M6MTk2OiIvPFw_W3BoXHNdKyhcJFthLXpcXzAtOV=rKVxzKj1ccypcJF8oUkVRVUVTfEdFfFBPUylUXFtbXjtdK1s7XHNdKyhcJFthLXpcXzAtOV=rKVxzKj1ccyphcnJheVwoXCRfKFJFUVVFU3xHRXxQT1MpVFxbW147XStbO1xzXStcJFthLXpcXzAtOV=rXHMqPVxzKmFycmF5X2ZpbHRlclwoXDNbLFxzXSpcMVwpW2RleGl=XChcKTtcc1=qKCR8XD8-KS9pIjt9czo1MDoicGhwIGJhc2U2NF9kZWNvZGUgY3JlYXRlX2Z1bmN=aW9uIFZhcmlhYmxlRmluY3Rpb24iO2E6Mjp7aTowO3M6NToiRjhCSjgiO2k6MTtzOjI1NDoiLzxcPy4rPyhcJFthLXpfMC=5XSspXHMqPVxzKmJhc2U2NF9kZWNvZGVcKC4rPygoXCRbYS16XzAtOV=rKVxzKj1ccyooXEA_KGd6aW5mbGF=ZXxzdHJyZXYpXCgpK1wxLis_KT8oXCRbYS16XzAtOV=rKVxzKj1ccypjcmVhdGVfZnVuY3Rpb25cKFteLF=rWyxcc1=rKFwxfFwzKVteO1=rWztcc1=rXDZcKFteO1=rWztcc1x9XSsoZWxzZVtce1xzXStbXlx9XStbO1xzXH1dK3xlY2hvW1xzXChdKihbJyJdKS4rP1w5Wztcc1x9XSspKigkfFw_PikvaXMiO31zOjQ3OiJwaHAgZnVuY3Rpb24gd3BfZW5xdWV1ZV9zY3JpcHQganNvbjIgYWRkX2FjdGlvbiI7YToyOntpOjA7czo1OiJGQkE3USI7aToxO3M6Mzk1OiIvKFwvXCpbXlwqXSooXCpbXlwqXC9dKikrXC9ccyopKihpZltcc1woXCFdK2Z1bmN=aW9uX2V4aXN=c1woXHMqWyciXShbYS16XzAtOV=rKVsnIl1bXHNcKV=rXHtccyopP2Z1bmN=aW9uXHMrKFthLXpfMC=5XSspXHMqXChbXlx7XStce1xzKigoaWZbXHNcKFwhXStpc3NldFtcKFxzXStbXlwpXStbXHNcKV=rW1x7XHNdKik_KFwkW2Etel8wLTldK1xzKj1bXjtdKztccyopKihcJFthLXpfMC=5XStccyo9XHMqKT9cJFthLXpfMC=5XStccypcKC4qP2Jhc2U2NF9kZWNvZGVcKHwoZWNob3xwcmludClbXHNcKCciXSs8c2NyaXB=Lis_ZnJvbUNoYXJDb2RlXCguKz9kb2N1bWVudFwud3JpdGVcKCkuKz9hZGRfYWN=aW9uXHMqXChbXHMiJ1=qW14sXStbJyJcLFxzXSsoXDR8XDUpWyciXCk7XHNdKy9pcyI7fXM6NjE6InBocCBpZiBmdW5jdGlvbl9leGlzdHMgZnVuY3Rpb24gcmV=dXJuIFZhcmlhYmxlIEZ1bmN=aW9uIGV2YWwiO2E6Mjp7aTowO3M6NToiRjhGNnciO2k6MTtzOjE5NjoiLzxcP1twaFxzXSooKFwvXCouKz9cKlwvXHMqKSooXCRbYS16XF8wLTldKyhcW1teXF1dK1tcXVxzXH1dKykqPVteO1=rWztcc1=rKSsoaWZbXHNcKF=rXCFmdW5jdGlvbl9leGlzdHNcKFteXHtdK1tce1xzXStmdW5jdGlvbiBbXlx7XStbXHtcc1=rKHJldHVybiBcJFthLXpcXzAtOV=rfGV2YWwpXChbXjtdK1s7XH1cc1=rKSspKygkfFw_PikvaSI7fXM6NDM6IkxlZnRvdmVyIEhlYWRlciBpZiBHTE9CQUxTIEhleCBTRVJWRVIgSGV4L2kiO2E6Mjp7aTowO3M6NToiRjE2RGciO2k6MTtzOjE4ODoiLzxcP1twaFxzXStpZlxzKlwoW15ce1=rXCRHTE9CQUxTW1x7XFtdWyciXVxceFteXHtdK1tce1xzXStcJFthLXpcXzAtOV=rKFxbW15cXV=rW1xdXHNcfV=rKSo9W147XStcJF9TRVJWRVJbXHtcW11bJyJdXFx4W147XStbO1xzXStpZlxzKlwoW15ce1=rXCRHTE9CQUxTW1x7XFtdWyciXVxceFteO1=rW1xzXH=7XSooJHxcPz4pL2kiO31zOjUzOiJpZiBIVFRQX1VTRVJfQUdFTlQgYWRkX2FjdGlvbiB3cF9mb29=ZXIgZnVuY3Rpb24gZWNobyI7YToyOntpOjA7czo1OiJGMThGQiI7aToxO3M6MjE1OiIvKFwkW2EtelxfMC=5XSsoXFtbXlxdXStbXF1dKykqXHMqPVxzKmdldF9vcHRpb25cKFteO1=rWztcc1=raWZccypcKFteXHtdK=hUVFBfVVNFUl9BR=VOVFteXHtdK1tce1xzXSthZGRfYWN=aW9uXChbJyJcc1=rd3BfZm9vdGVyWyciXHMsXSsoW2EtelxfMC=5XSspWyciXHNdK1teO1=rWztcc1x9XSspK2Z1bmN=aW9uXHMrXDNbXlx7XStbXHtcc1=rKFteXH1dK1xzKikrXH=vaSI7fXM6MzA6ImRpdiBkaXNwbGF5IG5vbmUgaHJlZiBodHRwIGJ1eSI7YToyOntpOjA7czo1OiJGM=gwViI7aToxO3M6MTI2OiIvPCgoZGl2KXwoYSkpXHMrW14-XSsoZGlzcGxheVtcc1w6XStub25lW14-XSt8KD5ccyo8KGEpXHMrW14-XSopP2hyZWZbPSciXStodHRwW14-XSspezJ9Pi4qP2J1eS4qP1xzKjxcLyhcM3xcNj5ccyo8XC9cMik-XHMqL2kiO31zOjg1OiJDb3B5cmlnaHQgZnVuY3Rpb24gc2V=Q29va2llIHJldHVybiBmdW5jdGlvbiB1c2VyQWdlbnQgc2V=Q29va2llIHdyaXRlIGlmcmFtZSB=b3AgTmVnIjthOjI6e2k6MDtzOjU6IkdDTUQxIjtpOjE7czo=MDY6Ii8oPChzY3JpcHQpW14-XSo-XHMqKT8oXC9cKlxzKkNvcHlyaWdodC4rXHMqXCpcL1xzKnxbYS16XzAtOVxzXSs9W147XSs7XHMqfHNldFRpbWVvdXRcKFteO1=rO1xzKikqKGZ1bmN=aW9uIFtzZ11ldENvb2tpZVwoLis_KChkb2N1bWVudFwuY29va2llPXxyZXR1cm4pW15cfV=rWztcfVxzXSspKykrLis_W3NnXWV=Q29va2llXCguKz9kb2N1bWVudFwud3JpdGVcKFsiJ1=8KHNjcmlwdHxpZnJhbWUpW14-XSsoc3JjPVsnIlwrXHNodHBzXDpdK1wvXC98dG9wOlxzKlwtKSguKz9kb2N1bWVudFwuY29va2llLis_XC5=b1VUQ1N=cmluZ1tcKFwpXH1dK3wuKz9lbmNvZGVVUklDb21wb25lbnRcKGRvY3VtZW5=XC5yZWZlcnJlclwpLis_KFsnIl=pXC9zY3JpcHQ-XDEwKT9bXjtdK1tcKTtcfVxzXSsoPFwvXDI-fCQpL2kiO31zOjE1OiJwaHAgTG9=cyBvZiBIZXgiO2E6Mjp7aTowO3M6NToiSDMxQVQiO2k6MTtzOjI5NzoiL14oPFw_W3BoXHNdKyhmdW5jdGlvbiBiYXNlNjRbXlx7XStce1xzKnJldHVybiBiYXNlNjRbXlx9XStcfVxzKmlmW1xzXChdK2lzc2V=W1xzXChdK1wkXyhSRVFVRVN8R=V8UE9TKVQuKzxib2R5IG9ubG9hZD1bXHMnIlxcXStsb2NhdGlvbltePl=rW148XSs8XC9ib2R5PlxzKjxcL2h=bWw-XHMqPFw_W3BoXHNcfV=rfCguKz9cXHhbMC=5QS1GXXsyfSl7NTIsfSg_PS4qXCkpW15cbl=rKVxzKigkfFw_Pil8XFx4RUZcXHhCQlxceEJGXHMqPFwhRE9DVFlQRS4rP2V2YWxcKC4rPFwvYm9keT5ccyo8XC9odG1sPlxzKiQpL2lzIjt9czo2MToic2NyaXB=IGRvY3VtZW5=IHdyaXRlIGRpdiBhbmNob3Igc2NyaXB=IGRvY3VtZW5=IHdyaXRlIEVORGRpdiI7YToyOntpOjA7czo1OiJHQlI4SyI7aToxO3M6MTg2OiIvPHNjcmlwdFtePl=qPlxzKmRvY3VtZW5=XC53cml=ZVwoWyInXShbXDxkaXZdWyInIFwrXSopezR9W14-XSo-WyInXVwpO1xzKjxcL3NjcmlwdD5ccyooPGEgLis_PFwvYT5ccyopKzxzY3JpcHRbXj5dKj5ccypkb2N1bWVudFwud3JpdGVcKFsiJ1=oW1w8XC9kaXZdWyInIFwrXSopezV9PlsiJ11cKTtccyo8XC9zY3JpcHQ-L2kiO31zOjQzOiJlY2hvIGRpdiBwb3NpdGlvbiBhYnNvbHV=ZSBuZWdhdGl2ZSBhbmNob3JzIjthOjI6e2k6MDtzOjU6IkgxNTlZIjtpOjE7czozNzE6Ii8oPzwhWyciXSk8KGh=bWw-KT9bXHM8XSooKChzY3JpcHQpW14-XSo-XHMqZG9jdW1lbnRcLndyaXRlW1woXHMnIl=rPCk_ZGl2fChzdHlsZSlbXj5dKj5ccypbXC5cI1=oW2Etel9cLTAtOV=rKVtcc1x7XSspKFteXH1cPl=qKGxlZnR8cG9zaXRpb258dG9wfG9wYWNpdHl8ZmlsdGVyfGRpc3BsYXl8dGV4dC1pbmRlbnQpXDpccyooYWxwaGFcKG9wYWNpdHk9MHwwP1wufFwtWzAtOVwuXXszLH18bm9uZXxhYnNvbHV=ZSkpezMsfVtePl=qPlsnIlwpO1xzXSooPFwvXDU-KT8uKj88KCgoW2Itc11bYS16MC=5XSopW14-XSo-Wy5cc1=qPCkqYSAuKz88XC9hKD5bXjxdKjwoXC8oW15kXVthLXowLTldKnxcMTQpKT8pKikrPihccyo8XC8oXDJ8ZGl2PikpKi9pIjt9czo=MToiUEhQIEdhcmJhZ2UgQXJvdW5kIGV2YWwgVmFyaWFibGUgRnVuY3Rpb24iO2E6Mjp7aTowO3M6NToiRjJDSmQiO2k6MTtzOjE1MToiLzxcP1twaFxzXStcJFthLXpcXzAtOV=rXHMqPShccyonLisnW1wpXC5dKykrKFxzKicuK2V2YWxccypcKFwkW1wkXHtdKlthLXpcXzAtOV=rW1x9IFx=XSooXFtbXlxdXStcXVsgXHRdKikqXCguKydbXClcLl=rKShccyonLisnW1wuO1wpXSspK1xzKihcPz58JCkvaSI7fXM6NzY6InN=cmlwc2xhc2hlcyBSRVFVRVNUIGlmIGVjaG8gcmV=dXJuIGZvcGVuIGZ3cml=ZSBmY2xvc2UgZWNobyBmdW5jdGlvbiByZXR1cm4iO2E6Mjp7aTowO3M6NToiRjJFNmQiO2k6MTtzOjMxMjoiLyhceEVGXHhCQlx4QkYpPzxcP1twaFxzXSsoXCRbYS16XF8wLTldK1xzKj1ccyooc3RyaXBzbGFzaGVzW1woXHNdKyk_XCRfKFJFUVVFU3xHRXxQT1MpVFxbWyInXVteO1=qWztcc1=rKSsoaWZbXChcc1=rXCRbXlx7XSpbXHtcc1=rZWNob1xzKlsiJ11bXjtdK1s7XHNdK3JldHVyblteO1=qO1tcc1x9XSspKy4rP2ZvcGVuXCguKz9md3JpdGVcKC4rP2ZjbG9zZVwoW147XSpbO1xzXStlY2hvXHMqWyInXVteO1=rWztcc1=rKGZ1bmN=aW9uLis_W3Jta117Mn1kaXJcKFteO1=rO1tcc1x9XSsocmV=dXJuW147XSo7W1xzXH1dKykqKSsoJHxcPz4pL2lzIjt9czoyNToiVmFyIEhleCBWYXJpYWJsZSBGdW5jdGlvbiI7YToyOntpOjA7czo1OiJHQ1NBZyI7aToxO3M6MTkyOiIvKCgoXCRbYS16XzAtOVxzXC5dKz1bXjtdKztccyopKlwkW2Etel8wLTlcc1wuXSs9KFteO1=qXFxbeDAtOWEtZl17MiwzfSkrW147XSo7XHMqKSspKyhpZlxzKlwoW15ce1=rXHtccyopPygoXCRbYS16XzAtOV=rXHMqPVxzKik_XEA_XCRbYS16XzAtOV=rKFxzKlxbW15cXV=rXF=pKlwoW147XSs7XHMqKStbXH1cc1=qKFwvXC8uKyk_L2kiO31zOjg5OiJpbmlfc2V=IGlmIGlzc2V=IGFycmF5IGJhc2U2NF9kZWNvZGUgZnVuY3Rpb24gcmV=dXJuIGJhc2U2NF9kZWNvZGUgZXZhbCBWYXJpYWJsZSBGdW5jdGlvbiI7YToyOntpOjA7czo1OiJHNFJMUSI7aToxO3M6MzUwOiIvPFw_W3BoXHNdKyhbaWZcc1woXCFcQF=qKGluaV9zZXRccypcKHxlcnJvcl9yZXBvcnRpbmdccypcKHxzZXRfdGltZV9saW1pdFxzKlwofGlzc2V=XHMqXCh8ZGVmaW5lfGdsb2JhbHxcJFtce1wkYS16XzAtOVx9XFtcXCciXF1cc1=rPSlbXjtdKztbXH1cc1=qKSsoZnVuY3Rpb25ccyooW2Etel8wLTldKylccypcKC4rPyhyZXR1cm5ccyooXDR8YmFzZTY=X2RlY29kZSl8XCRbYS16XzAtOV=rXHMqKFxbW15cXV=qXF1ccyopKilcKC4rPykrKD88IVwvXC8sZnVuY3Rpb25cKHJlc3BvbnNlXCkgXHsgKWV2YWxcKC4rP1wpKztbXHNcfTtdKyhcPz5ccyooXCNcIVtcL2Etel9cLTAtOVwrPVxzXXsyMDAsfSQpP3wkKS9pcyI7fXM6NDY6ImNsYXNzIGNvbnN=IHBhY2sgSCogZnVuY3Rpb24gaW5jbHVkZSBuZXcgQ2xhc3MiO2E6Mjp7aTowO3M6NToiRjVROUciO2k6MTtzOjE5MjoiL2NsYXNzXHMrKFthLXpfMC=5XSspXHMqXHsuKz9jb25zdFxzKyhbYS16XzAtOV=rKVxzKj=uKz9zZWxmXDpcOihbYS16XzAtOV=rKVwocGFja1woJ=hcKidbLFxzXStzZWxmXDpcOlwyXCkrLis_ZnVuY3Rpb25ccytcM1woKFwkW2Etel8wLTldKykuKz9cQD8oaW5jbHVkZXxyZXF1aXJlKShfb25jZSk_W147XStcNC4rbmV3XHMrXDE7L2lzIjt9czoxNDoiZXZhbCBzdHJfcm9=MTMiO2E6Mjp7aTowO3M6NToiRjlQQ2wiO2k6MTtzOjE1OToiLyhcL1wvLispP1xzKigoaW5pX3NldFwofGVycm9yX3JlcG9ydGluZ1wofFwkW2Etel8wLTldK1tcc1wuXSo9KVteO1=qO1xzKikqXEA_KGV2YWx8YXNzZXJ=fFwkW2EtelxfMC=5XSsoXHMqXFtbXlxdXStcXSkqKVxzKlwoXHMqc3RyX3JvdDEzXCgnLionXClcKTsoXHMqXDEpPy9pIjt9czozMjoicGhwIEdMT=JBTFMgSGV4IGZ1bmN=aW9uIGlmIGV2YWwiO2E6Mjp7aTowO3M6NToiRzZHQWoiO2k6MTtzOjYwMjoiLzxcP1twaFxzXSooXHMqXCQoR=xPQkFMU3xbXHtcJCciXStbMC=5X1wtYS16XFwnIlwuXStbXH1cc1=rKVtcc1xbXHsnIl=rKFthLXpfMC=5XSspWyInXH1cXVxzXSsoW147XSo7XHMqZ2xvYmFsXHMqXCRcM1teO1=qO1xzKlwkXDNccyo9XHMqXCRHTE9CQUxTW147XSo7XHMqXCQoXDN8XHtbXlx9XSpcfSspXHMqKFxbW15cXV=rW1xdXHNdK3xce1teXH1dK1tcfVxzXSspKyk_PVxzKlsnIl=oXFx4WzAtOWEtZl17MSwyfSkrWyInXTtccyooKGVjaG98cHJpbnQpP1tcc1xAXSpcJChHTE9CQUx8XDMpW147XSs7XHMqfFwkW2Etel8wLTldK1xzKihbXC49XStccypcQD8oTlVMTHwoYXJyYXlbXChcc1=rKT9cJChHTE9CQUx8XDMpW147XSp8XCRbYS16XzAtOV=rKFxbW15cXV=rW1xdXHNdK3xce1teXH1dK1tcfVxzXSspKnxbIiddKykpKztccyp8Z2xvYmFsXHMqXCRbXjtdKztccyp8ZnVuY3Rpb25ccytbMC=5X2Etel=rXHMqXChbXlx7XSt8XHtccyp8XH1ccyp8KGZvcihlYWNoKT98KGVsc2VccyopP2lmKVxzKlwoLis_XCkrXHMqfHJldHVyblteO1=qO1tcc1x9XSspezMwLH=pK2V2YWxcKC4rP1wpKztbXHNcfV=rKGV4aXRbXjtdKjtbXHNcfV=rKT8oJHxcPz4pL2kiO31zOjM2OiJwaHAgaWYgaXNzZXQgUE9TVCBiYXNlNjRfZGVjb2RlIG1haWwiO2E6Mjp7aTowO3M6NToiR=NVS2=iO2k6MTtzOjQ2ODoiLzxcP1twaFxzXSooKFwkKFswLTlfYS16XSspXHMqPVxzKmV4cGxvZGVbXixdKyxccypiYXNlNjRfZGVjb2RlXChbXjtdKztccyp8KChpZnxpc3NldHxmb3JlYWNoKVxzKlwoKStcJF8oUkVRVUVTfEdFfFBPUylUW15cKV=rW1wpXHNce1=rKT8oXCRbMC=5X2Etel=rW1xzXC5dKj1ccypbYS16XzAtOVxzXChdKlwkKFwzfF9SRVFVRVNUfF9HRVR8X1BPU1QpKFteO1=qW1wpO1x9XHNdK2Vsc2VbXHtcc1=qfGVjaG98cHJpbnQpKlteO1=qWztcc1=rKFxzKmV4aXQ7KT98XC9cLy4rXHMqKVtcfVxzXSopKyhcJFswLTlfYS16XStbXHNcLl=qPVxzKiIuKz9cXHJcXG4iO1xzKikqKChcJFthLXpfMC=5XStccyo9XHMqfGlmW1xzXChdK3xlbHNlW15ce1=qW1x7XHNdKykqbWFpbFxzKlwoW147XStbXCk7XHNcfV=qKChpZltcKFxzXSt8ZWxzZSlbXlx7XSpbXHtcc1=rZWNob1teO1=qWztcc1x9XSt8ZXhpdDtccyopKikrKCR8XD8-KS9pIjt9czozMDoid3BfZW5xdWV1ZV9zY3JpcHQgU1dFRVRDQVBUQ=hBIjthOjI6e2k6MDtzOjU6IkY2VUdsIjtpOjE7czo2MDoiL3dwX2VucXVldWVfc2NyaXB=XChbXixdKyxccypbJyJdaHR=cC4rP1NXRUVUQ=FQVENIQVteO1=rOy9pIjt9czozODoicGhwIGNsYXNzIFZhcmlhYmxlIEZ1bmN=aW9ucyBuZXcgQ=xBU1MiO2E6Mjp7aTowO3M6NToiRzlSQkUiO2k6MTtzOjMyMDoiLzxcP1twaFxzXSsoXC9cKi4qP1wqXC9ccyp8ZXJyb3JfcmVwb3J=aW5nXCgwXCk7XHMqfGZ1bmN=aW9uW15cKF=rZG9sbHlbXlx7XStcey4qPyhyZXR1cm58ZGJEZWx=YSlbXjtdKls7XH1cc1=qKSpjbGFzc1xzKyhbYS16XzAtOV=rKVxzKlx7Lis_KChcJFthLXpfMC=5XHsnIlx9XSsoXHMqXFtbXlxdXStcXSkqXHMqPVxzKik_KFwkW2Etel8wLTlce1x9XSsoXHMqXFtbXlxdXStcXSkqfGJhc2U2NF9kZWNvZGVcKHJhd3VybGRlY29kZXxmaWxlX3B1dF9jb25=ZW5=cylccypcKC4qP1tcKVxzXSs7XHMqKXszLH=uKz9uZXdccytcM1teO1=qO1xzKigkfFw_PikvaXMiO31zOjE=OiJ2aXNpdG9yVHJhY2tlciI7YToyOntpOjA7czo1OiJGOU1IbSI7aToxO3M6MTc3OiIvKCg8XCEtLXxcL1wqKXZpc2l=b3JUcmFja2VyKFwqXC98LS=-KSlccyooPFw_W3BoXHNdKy4rP2Jhc2U2NF9kZWNvZGVccypcKC4rP1w_PnwuKz9kb2N1bWVudFwuY3JlYXRlRWxlbWVudFwoWyciXXNjcmlwdFsiJ11cKTtccypbYS16XzAtOV=rXC5zcmNccyo9W1xzJyJdK2h=dHBcOlwvXC8uKz8pXHMqXDEvaXMiO31zOjU4OiJmc29ja29wZW4gZndyaXRlIHdoaWxlIGZlb2YgZmNsb3NlIHByZWdfbWF=Y2ggZ3p1bmNvbXByZXNzIjthOjI6e2k6MDtzOjU6IkZBNUxPIjtpOjE7czoyMzI6Ii8oXCRbYS16XzAtOV=rKVxzKj1ccypcQD9mc29ja29wZW5cKFteO1=rO1xzKmlmW1woXHNdK1wxW1wpXHNdKlx7Lis_ZndyaXRlXChcMVteO1=rO1xzKndoaWxlW1xzXChcIV=rZmVvZlwoXDEuKz9mY2xvc2VcKFwxXCk7XHMqcHJlZ19tYXRjaFwoW14sXSssW14sXSssXHMqKFwkW2Etel8wLTldKylcKTtccyppZltcKFxzXStcMlxbMVxdW1xzXCFdKj=uKz9nenVuY29tcHJlc3NcKFteO1=rO1tcfVxzXSsvaXMiO31zOjIwOiJUYWdnZWQgZXZhbCBmdW5jdGlvbiI7YToyOntpOjA7czo1OiJHM1Q5QSI7aToxO3M6MTI1OiIvKFwvXCpbXlwqXStcKlwvKVxzKihbXHNhLXpfMC=5XD1dKykqWztcc1woXSood2luZG93W1wuXFsiJ1=rXFx4W147XSt8ZnVuY3Rpb25cKFwpLispO1xzKmV2YWxbXChcc1=rW15cKV=rWyciXHNcKFwpO1x9XStcMS9pcyI7fXM6NDQ6InNjcmlwdCB2YXIgaHR=cCBpZiBkb2N1bWVudCB3cml=ZSBzY3JpcHQgc3JjIjthOjI6e2k6MDtzOjU6IkcyQ=l3IjtpOjE7czozNTI6Ii8oPHNjcmlwdFtePl=qPlxzKigodmFyXHMqKT9bYS16XzAtOV=rXHMqPVsnIjtcc1=qKHNldFRpbWVvdXR8ZW5jb2RlVVJJQ29tcG9uZW5=KVwoW15cKV=qWyciXCk7XHNdezIsfSkrKFt2YXJcc1=qKFthLXpfMC=5XSspXHMqPVxzKlsnIl1baGZ=XSt=cFtzXSo6XC9cL1teO1=rO1xzKigodmFyXHMqKT8oW2Etel8wLTldKylccyo9XHMqXDZbXjtdKztccyopKyk_aWZbXlx7XStce1xzKmRvY3VtZW5=XC53cml=ZVwoWyInXTxbc2NyaXB=XHMnIlwrXXs3LH1bXlx9XSpzcmM9WyciXHNcK1=rKFw5fFtmaHRdK3RwW3NdKjpcL1wvLitqcXVlcnlcLihtaW5cLikqcGhwKShbXjtdK1tcfTtcc1=rKSs_PFwvc2NyaXB=PikrL2kiO31zOjQ1OiJmdW5jdGlvbiB1bnNldCB3cF9saXN=X3RhYmxlIGl=ZW1zIGFkZF9hY3Rpb24iO2E6Mjp7aTowO3M6NToiR=FHRUciO2k6MTtzOjQ=MzoiLyhcL1wqW15cKl=qKFwqW15cKlwvXSopK1wvXHMqKSooXCRbXjtdKz1bXjtdKztccyopKihpZltcKFxzXCFdK2Z1bmN=aW9uX2V4aXN=c1tcKFxzJyJdK2luaV9zZXRbJyJcKVx7XHNdKyhcQD9pbmlfc2V=XChbXjtdK1s7XHNdKykrW1xzXH=7XSspKmZ1bmN=aW9uXHMrKFthLXpfMC=5XSspXHMqXChbXlx9XSsocGFja1woWyciXUhcKlsnIixcc1wuMC=5QS1GXCldKztccyppZltcc1woXEBpc19dK2ZpbGVbX2Etel=qW1woXHNdKyhcJFthLXpfMC=5XSspLis_ZmlsZV9nZXRfY29udGVudHNbXHNcKF=rXDguKz9maWxlX3B1dF9jb25=ZW5=c1tcc1woXStcOHx1bnNldFwoXCR3cF9saXN=X3RhYmxlLT5pdGVtc1xbfGZpbGVfZ2V=X2NvbnRlbnRzXChfX=ZJTEVfXy4rP2ZwdXRzXCguKz9zY2FuZGlyXCgpLis_YWRkX2FjdGlvblwoW14sXStbLFxzMC=5XCknIl=rXDZbXjtdKzsvaXMiO31zOjM5OiJwaHAgZXJyb3JfcmVwb3J=aW5nIGZ1bmN=aW9uIGRldGVjdF9jbXMiO2E6Mjp7aTowO3M6NToiRkJCRzAiO2k6MTtzOjE2MDoiLzxcP1twaFxzXSsoXEA_KGVycm9yX3JlcG9ydGluZ3xzZXRfdGltZV9saW1pdHxpbmlfc2V=KVwoLio_MFwpO1xzKikrLio_ZnVuY3Rpb24gKGRldGVjdF9jbXNcKCkuK1wzW147XSs7XHMqKChpZlxzKlwoW15cKV=rfGVsc2UpW15ce1=qW15cfV=rW1x9XHNdKykrKCR8XD8-KS9pcyI7fXM6NTE6ImZ1bmN=aW9uIGdsdWVzX2l=IHNhbml=aXplX2tleSBjYWxsX3VzZXJfZnVuY19hcnJheSI7YToyOntpOjA7czo1OiJGQkk5SyI7aToxO3M6MjkyOiIvKGlmW1xzXChcIV=rZnVuY3Rpb25fZXhpc3RzXChccypbJyJdW2Etel8wLTldK1snIl1bXHNcKV=rXHtccyopP2Z1bmN=aW9uXHMrKFthLXpfMC=5XSspXHMqXChbXlwpXStbXClcc1=rXHtccyooXCRbYS16XzAtOV=rKVxzKj1ccypzYW5pdGl6ZV9rZXlcKFteO1=rO1xzKihcJFthLXpfMC=5XSspXHMqPVxzKmNhbGxfdXNlcl9mdW5jX2FycmF5XChccypcM1teO1=rO1xzKnJldHVyblxzKlw=LitcMlxzKlwoW147XSs7XHMqLitjYWxsX3VzZXJfZnVuY19hcnJheVwoW147XSs7W1x9XHNdKygkfCg_PVw_PikpL2lzIjt9czoxNjoicGhwIGV2YWwgVmFyIEhleCI7YToyOntpOjA7czo1OiJGQktLUiI7aToxO3M6MTE1OiIvPFw_W3BoXHNdKyhAP2V2YWxccypcKFxzKikrKFsnIl=pW1xzXFxdKlwkW2EtelxfMC=5XFtcXVx7XH1ccyciXSs9W1xzXFwnIl=qKFxceFswLTldezJ9KSsuK1wyKFxzKlwpKSs7XHMqKCR8XD8-KS9pIjt9czoyOToiaWYgc3RycG9zIFJFUVVFU1RfVVJJIGluY2x1ZGUiO2E6Mjp7aTowO3M6NToiRkNRRlMiO2k6MTtzOjE=OToiL2lmKFtcc1woXStzdHJbYS16XzAtOV=rKXsyLH1bXHNcKF=rXCRfU=VSVkVSXFtbIiddUkVRVUVTVF9VUklbJyJdXF1ccypcKStbXlwpXStbXClcc1=rXHtbXHNcQF=qKGluY2x1ZGV8cmVxdWlyZSkoX29uY2UpP1teO1=rWztcc1=rKGV4aXRbXHM7XSspP1x9L2kiO31zOjc2OiJlcnJvcl9yZXBvcnRpbmcgaW5pX3NldCBzZXRfdGltZV9saW1pdCBpZ25vcmVfdXNlcl9hYm9ydCBlbHNlaWYgcmVxdWlyZV9vbmNlIjthOjI6e2k6MDtzOjU6IkZDVUxkIjtpOjE7czoyMTk6Ii88XD9bcGhcc1=rKFwvXCpbXlwqXSooXCpbXlwqXC9dKikrXC9ccyp8XC9cL1teXG5dKlxzKykqKChlcnJvcl9yZXBvcnRpbmd8aW5pX3NldHxzZXRfdGltZV9saW1pdHxpZ25vcmVfdXNlcl9hYm9ydClccypcKFteO1=rWztcc1=rKXs1LH=oKGVsc2Vccyp8aWZccypcKCtbXlwpXStbXHNcKV=rKStcQD8ocmVxdWlyZXxpbmNsdWRlKShfb25jZSk_W147XStbO1xzXSspKygkfFw_PikvaSI7fXM6ODM6InBocCBpZiBmdW5jdGlvbl9leGlzdHMgZnVuY3Rpb24gY3VybF9pbml=IHJldHVybiBmdW5jdGlvbiB=cmltIHJldHVybiBiYXNlNjRfZGVjb2RlIjthOjI6e2k6MDtzOjU6IkcxOEZuIjtpOjE7czo=MDU6Ii88XD9bcGhcc1=rKFwkW2Etel8wLTldKylccyo9W147XSs7XHMqaWZccypcKFxzKlwhZnVuY3Rpb25fZXhpc3RzXChbIiddKFthLXpfMC=5XSspWyciXVwpW1wpXHNce1=qZnVuY3Rpb25ccypcMlwoW15cKV=rXClbXClcc1x7XStbXlxuXSpjdXJsX2luaXRcKFwpOy4rP3JldHVyblteO1=rO1tccytcfV=raWZccypcKFxzKlwhZnVuY3Rpb25fZXhpc3RzXChbIiddKFthLXpfMC=5XSspWyciXVwpW1wpXHNce1=qZnVuY3Rpb25ccypcM1woW15cKV=rXClbXClcc1x7XStbXlxuXSp=cmltW147XSs7Lio_cmV=dXJuW147XSs7W1xzK1x9XSsoLio_KGJhc2U2NF9kZWNvZGVbXChcc1=rXDF8XDJcKHxcM1woKVteXCldKltcKVxzXStbXjtdKls7XHNdKyl7Myx9KChlY2hvfHByaW5=KVteO1=rO1xzKikrKCR8XD8-KS9pcyI7fXM6MTI6IlBIUCByZXZlcnNlZCI7YToyOntpOjA7czo1OiJHMjhBciI7aToxO3M6NDE6Ii9eKFxzKlw-XD9ccyopPzsuK1wkKFtwaFxzXSpcP1w8XHMqKT8kL2lzIjt9fX=2", "yes");
INSERT INTO `wp_options` VALUES("70866", "GOTMLS_scan_log/75.67.101.93/1477752431.3519", "a:2:{s:8:\"settings\";a:14:{s:12:\"msg_position\";a:4:{i:0;s:4:\"80px\";i:1;s:4:\"40px\";i:2;s:5:\"400px\";i:3;s:5:\"600px\";}s:10:\"menu_group\";i:0;s:9:\"scan_what\";i:2;s:10:\"scan_depth\";i:-1;s:11:\"exclude_ext\";a:24:{i:0;s:3:\"png\";i:1;s:3:\"jpg\";i:2;s:4:\"jpeg\";i:3;s:3:\"gif\";i:4;s:3:\"bmp\";i:5;s:3:\"tif\";i:6;s:4:\"tiff\";i:7;s:3:\"psd\";i:8;s:3:\"fla\";i:9;s:3:\"flv\";i:10;s:3:\"mov\";i:11;s:3:\"mp3\";i:12;s:3:\"exe\";i:13;s:3:\"zip\";i:14;s:3:\"pdf\";i:15;s:3:\"css\";i:16;s:3:\"pot\";i:17;s:2:\"po\";i:18;s:2:\"mo\";i:19;s:2:\"so\";i:20;s:3:\"doc\";i:21;s:4:\"docx\";i:22;s:3:\"svg\";i:23;s:3:\"ttf\";}s:12:\"check_custom\";s:0:\"\";s:11:\"exclude_dir\";a:0:{}s:8:\"user_can\";s:16:\"activate_plugins\";s:14:\"quarantine_dir\";b:0;s:10:\"dont_check\";a:0:{}s:10:\"scan_level\";i:3;s:23:\"auto_UPDATE_definitions\";i:1;s:15:\"skip_quarantine\";i:0;s:5:\"check\";a:5:{i:0;s:8:\"htaccess\";i:1;s:8:\"timthumb\";i:2;s:8:\"backdoor\";i:3;s:5:\"known\";i:4;s:9:\"potential\";}}s:4:\"scan\";a:7:{s:3:\"dir\";s:31:\"/home/econolodge/public_html/wp\";s:5:\"start\";i:1477752434;s:4:\"type\";s:13:\"Complete Scan\";s:9:\"microtime\";d:1233;s:7:\"percent\";i:-1;s:11:\"last_threat\";d:1477753667.5743958950042724609375;s:6:\"finish\";i:1477753667;}}", "yes");
INSERT INTO `wp_options` VALUES("80223", "wd_bwg_options", "{\"id\":\"1\",\"images_directory\":\"wp-content\\/uploads\",\"masonry\":\"vertical\",\"mosaic\":\"vertical\",\"resizable_mosaic\":\"0\",\"mosaic_total_width\":\"100\",\"image_column_number\":\"5\",\"images_per_page\":\"30\",\"thumb_width\":\"180\",\"thumb_height\":\"90\",\"upload_thumb_width\":\"300\",\"upload_thumb_height\":\"300\",\"image_enable_page\":\"1\",\"image_title_show_hover\":\"none\",\"album_column_number\":\"5\",\"albums_per_page\":\"30\",\"album_title_show_hover\":\"hover\",\"album_thumb_width\":\"120\",\"album_thumb_height\":\"90\",\"album_enable_page\":\"1\",\"extended_album_height\":\"150\",\"extended_album_description_enable\":\"1\",\"image_browser_width\":\"800\",\"image_browser_title_enable\":\"1\",\"image_browser_description_enable\":\"1\",\"blog_style_width\":\"800\",\"blog_style_title_enable\":\"1\",\"blog_style_images_per_page\":\"5\",\"blog_style_enable_page\":\"1\",\"slideshow_type\":\"fade\",\"slideshow_interval\":\"5\",\"slideshow_width\":\"800\",\"slideshow_height\":\"500\",\"slideshow_enable_autoplay\":\"0\",\"slideshow_enable_shuffle\":\"0\",\"slideshow_enable_ctrl\":\"1\",\"slideshow_enable_filmstrip\":\"1\",\"slideshow_filmstrip_height\":\"90\",\"slideshow_enable_title\":\"0\",\"slideshow_title_position\":\"top-right\",\"slideshow_enable_description\":\"0\",\"slideshow_description_position\":\"bottom-right\",\"slideshow_enable_music\":\"0\",\"slideshow_audio_url\":\"\",\"popup_width\":\"800\",\"popup_height\":\"500\",\"popup_type\":\"fade\",\"popup_interval\":\"5\",\"popup_enable_filmstrip\":\"1\",\"popup_filmstrip_height\":\"70\",\"popup_enable_ctrl_btn\":\"1\",\"popup_enable_fullscreen\":\"1\",\"popup_enable_info\":\"1\",\"popup_info_always_show\":\"0\",\"popup_enable_rate\":\"0\",\"popup_enable_comment\":\"1\",\"popup_enable_email\":\"0\",\"popup_enable_captcha\":\"0\",\"popup_enable_download\":\"0\",\"popup_enable_fullsize_image\":\"0\",\"popup_enable_facebook\":\"1\",\"popup_enable_twitter\":\"1\",\"popup_enable_google\":\"1\",\"watermark_type\":\"none\",\"watermark_position\":\"bottom-left\",\"watermark_width\":\"90\",\"watermark_height\":\"90\",\"watermark_url\":\"http:\\/\\/www.captainsbountymotorinn.com\\/wp-content\\/plugins\\/photo-gallery\\/images\\/watermark.png\",\"watermark_text\":\"web-dorado.com\",\"watermark_link\":\"https:\\/\\/web-dorado.com\",\"watermark_font_size\":\"20\",\"watermark_font\":\"arial\",\"watermark_color\":\"FFFFFF\",\"watermark_opacity\":\"30\",\"built_in_watermark_type\":\"none\",\"built_in_watermark_position\":\"middle-center\",\"built_in_watermark_size\":\"15\",\"built_in_watermark_url\":\"http:\\/\\/www.captainsbountymotorinn.com\\/wp-content\\/plugins\\/photo-gallery\\/images\\/watermark.png\",\"built_in_watermark_text\":\"web-dorado.com\",\"built_in_watermark_font_size\":\"20\",\"built_in_watermark_font\":\"arial\",\"built_in_watermark_color\":\"FFFFFF\",\"built_in_watermark_opacity\":\"30\",\"image_right_click\":\"0\",\"popup_fullscreen\":\"0\",\"gallery_role\":\"0\",\"album_role\":\"0\",\"image_role\":\"0\",\"popup_autoplay\":\"0\",\"album_view_type\":\"thumbnail\",\"popup_enable_pinterest\":\"0\",\"popup_enable_tumblr\":\"0\",\"show_search_box\":\"0\",\"search_box_width\":\"180\",\"preload_images\":\"0\",\"preload_images_count\":\"10\",\"thumb_click_action\":\"open_lightbox\",\"thumb_link_target\":\"1\",\"comment_moderation\":\"0\",\"popup_hit_counter\":\"0\",\"enable_ML_import\":\"0\",\"showthumbs_name\":\"0\",\"show_album_name\":\"0\",\"show_image_counts\":\"0\",\"upload_img_width\":\"1200\",\"upload_img_height\":\"1200\",\"play_icon\":\"1\",\"show_masonry_thumb_description\":\"0\",\"slideshow_title_full_width\":\"0\",\"popup_info_full_width\":\"0\",\"show_sort_images\":\"0\",\"autoupdate_interval\":\"30\",\"instagram_access_token\":\"0\",\"description_tb\":\"0\",\"enable_seo\":\"1\",\"autohide_lightbox_navigation\":\"1\",\"autohide_slideshow_navigation\":\"1\",\"read_metadata\":\"1\",\"enable_loop\":\"1\",\"enable_addthis\":\"0\",\"addthis_profile_id\":\"\",\"carousel_width\":\"300\",\"carousel_height\":\"300\",\"carousel_interval\":\"5\",\"carousel_image_column_number\":\"5\",\"carousel_image_par\":\"0.75\",\"carousel_enable_autoplay\":\"0\",\"carousel_enable_title\":\"0\",\"carousel_r_width\":\"800\",\"carousel_fit_containerWidth\":\"1\",\"carousel_prev_next_butt\":\"1\",\"carousel_play_pause_butt\":\"1\",\"permissions\":\"manage_options\",\"facebook_app_id\":\"\",\"facebook_app_secret\":\"\",\"show_tag_box\":\"0\",\"show_hide_custom_post\":\"0\",\"show_hide_post_meta\":\"0\",\"placeholder\":\"\",\"ecommerce_icon_show_hover\":\"0\",\"popup_enable_ecommerce\":\"0\",\"slideshow_effect_duration\":\"1\",\"popup_effect_duration\":\"1\",\"use_inline_stiles_and_scripts\":\"0\"}", "no");
INSERT INTO `wp_options` VALUES("83806", "GOTMLS_scan_log/97.96.91.241/1487690084.7356", "a:2:{s:8:\"settings\";a:14:{s:12:\"msg_position\";a:4:{i:0;s:4:\"80px\";i:1;s:4:\"40px\";i:2;s:5:\"400px\";i:3;s:5:\"600px\";}s:10:\"menu_group\";i:0;s:9:\"scan_what\";i:2;s:10:\"scan_depth\";i:-1;s:11:\"exclude_ext\";a:24:{i:0;s:3:\"png\";i:1;s:3:\"jpg\";i:2;s:4:\"jpeg\";i:3;s:3:\"gif\";i:4;s:3:\"bmp\";i:5;s:3:\"tif\";i:6;s:4:\"tiff\";i:7;s:3:\"psd\";i:8;s:3:\"fla\";i:9;s:3:\"flv\";i:10;s:3:\"mov\";i:11;s:3:\"mp3\";i:12;s:3:\"exe\";i:13;s:3:\"zip\";i:14;s:3:\"pdf\";i:15;s:3:\"css\";i:16;s:3:\"pot\";i:17;s:2:\"po\";i:18;s:2:\"mo\";i:19;s:2:\"so\";i:20;s:3:\"doc\";i:21;s:4:\"docx\";i:22;s:3:\"svg\";i:23;s:3:\"ttf\";}s:12:\"check_custom\";s:0:\"\";s:11:\"exclude_dir\";a:0:{}s:8:\"user_can\";s:16:\"activate_plugins\";s:14:\"quarantine_dir\";b:0;s:10:\"dont_check\";a:0:{}s:10:\"scan_level\";i:3;s:23:\"auto_UPDATE_definitions\";i:1;s:15:\"skip_quarantine\";i:0;s:5:\"check\";a:4:{i:0;s:8:\"htaccess\";i:1;s:8:\"timthumb\";i:2;s:8:\"backdoor\";i:3;s:5:\"known\";}}s:4:\"scan\";a:7:{s:3:\"dir\";s:31:\"/home/econolodge/public_html/wp\";s:5:\"start\";i:1487690087;s:4:\"type\";s:13:\"Complete Scan\";s:9:\"microtime\";d:1199;s:7:\"percent\";i:-1;s:11:\"last_threat\";d:1487691286.29189395904541015625;s:6:\"finish\";i:1487691286;}}", "yes");
INSERT INTO `wp_options` VALUES("71681", "GOTMLS_scan_log/97.96.91.241/1478796357.4855", "a:2:{s:8:\"settings\";a:14:{s:12:\"msg_position\";a:4:{i:0;s:4:\"80px\";i:1;s:4:\"40px\";i:2;s:5:\"400px\";i:3;s:5:\"600px\";}s:10:\"menu_group\";i:0;s:9:\"scan_what\";i:2;s:10:\"scan_depth\";i:-1;s:11:\"exclude_ext\";a:24:{i:0;s:3:\"png\";i:1;s:3:\"jpg\";i:2;s:4:\"jpeg\";i:3;s:3:\"gif\";i:4;s:3:\"bmp\";i:5;s:3:\"tif\";i:6;s:4:\"tiff\";i:7;s:3:\"psd\";i:8;s:3:\"fla\";i:9;s:3:\"flv\";i:10;s:3:\"mov\";i:11;s:3:\"mp3\";i:12;s:3:\"exe\";i:13;s:3:\"zip\";i:14;s:3:\"pdf\";i:15;s:3:\"css\";i:16;s:3:\"pot\";i:17;s:2:\"po\";i:18;s:2:\"mo\";i:19;s:2:\"so\";i:20;s:3:\"doc\";i:21;s:4:\"docx\";i:22;s:3:\"svg\";i:23;s:3:\"ttf\";}s:12:\"check_custom\";s:0:\"\";s:11:\"exclude_dir\";a:0:{}s:8:\"user_can\";s:16:\"activate_plugins\";s:14:\"quarantine_dir\";b:0;s:10:\"dont_check\";a:0:{}s:10:\"scan_level\";i:3;s:23:\"auto_UPDATE_definitions\";i:1;s:15:\"skip_quarantine\";i:0;s:5:\"check\";a:6:{i:0;s:8:\"htaccess\";i:1;s:8:\"timthumb\";i:2;s:8:\"backdoor\";i:3;s:5:\"known\";i:4;s:7:\"wp_core\";i:5;s:9:\"potential\";}}s:4:\"scan\";a:7:{s:3:\"dir\";s:31:\"/home/econolodge/public_html/wp\";s:5:\"start\";i:1478796401;s:4:\"type\";s:13:\"Complete Scan\";s:9:\"microtime\";d:1445;s:7:\"percent\";i:-1;s:11:\"last_threat\";d:1478797846.7572329044342041015625;s:6:\"finish\";i:1478797846;}}", "yes");
INSERT INTO `wp_options` VALUES("64501", "ct_afc_options", "", "yes");
INSERT INTO `wp_options` VALUES("64502", "verified_purchase", "0", "yes");
INSERT INTO `wp_options` VALUES("64503", "ct_afc_installed_date", "1468830162", "yes");
INSERT INTO `wp_options` VALUES("69160", "wordfence_lastSyncAttackData", "1606902964", "no");
INSERT INTO `wp_options` VALUES("89478", "secure_auth_key", "~qaAiCWo8hq_mW4EbeEDb!1{Fww/TcwN_F+z(&s,u=h!0Tr6g5L7i6B!`Nq.8FiS", "no");
INSERT INTO `wp_options` VALUES("89479", "secure_auth_salt", "4[0]O,$MSOn/gz|l*=v^7WH?}JS2F~3Z=>DftFK$vBW*RlqdBW<,2tYt{zeK hI*", "no");
INSERT INTO `wp_options` VALUES("106836", "wphb_settings", "a:40:{s:6:\"minify\";a:18:{s:7:\"enabled\";b:0;s:7:\"use_cdn\";b:0;s:3:\"log\";b:0;s:9:\"file_path\";s:0:\"\";s:11:\"minify_blog\";b:1;s:4:\"view\";s:5:\"basic\";s:4:\"type\";s:6:\"speedy\";s:9:\"do_assets\";a:2:{s:6:\"styles\";b:1;s:7:\"scripts\";b:1;}s:5:\"block\";a:2:{s:7:\"scripts\";a:0:{}s:6:\"styles\";a:0:{}}s:11:\"dont_minify\";a:2:{s:7:\"scripts\";a:0:{}s:6:\"styles\";a:0:{}}s:12:\"dont_combine\";a:2:{s:7:\"scripts\";a:0:{}s:6:\"styles\";a:0:{}}s:8:\"position\";a:2:{s:7:\"scripts\";a:0:{}s:6:\"styles\";a:0:{}}s:5:\"defer\";a:2:{s:7:\"scripts\";a:0:{}s:6:\"styles\";a:0:{}}s:6:\"inline\";a:2:{s:7:\"scripts\";a:0:{}s:6:\"styles\";a:0:{}}s:5:\"nocdn\";a:2:{s:7:\"scripts\";a:0:{}s:6:\"styles\";a:0:{}}s:6:\"minify\";a:2:{s:7:\"scripts\";a:0:{}s:6:\"styles\";a:0:{}}s:7:\"combine\";a:2:{s:7:\"scripts\";a:0:{}s:6:\"styles\";a:0:{}}i:0;s:0:\"\";}s:6:\"uptime\";a:3:{s:7:\"enabled\";b:0;s:13:\"notifications\";a:3:{s:7:\"enabled\";b:0;s:9:\"threshold\";i:0;s:10:\"recipients\";a:0:{}}s:7:\"reports\";a:5:{s:7:\"enabled\";b:0;s:9:\"frequency\";i:7;s:3:\"day\";s:6:\"Sunday\";s:4:\"time\";s:5:\"16:00\";s:10:\"recipients\";a:0:{}}}s:7:\"use_cdn\";b:0;s:14:\"gravatar_cache\";b:0;s:11:\"minify-blog\";b:1;s:10:\"minify-cdn\";b:1;s:5:\"block\";a:2:{s:7:\"scripts\";a:0:{}s:6:\"styles\";a:0:{}}s:11:\"dont_minify\";a:2:{s:7:\"scripts\";a:3:{i:0;s:18:\"tempera-nivoslider\";i:1;s:16:\"tempera-frontend\";i:2;s:16:\"cryout_ajax_more\";}s:6:\"styles\";a:1:{i:0;s:13:\"tempera-style\";}}s:7:\"combine\";a:2:{s:7:\"scripts\";a:0:{}s:6:\"styles\";a:0:{}}s:8:\"position\";a:2:{s:7:\"scripts\";a:0:{}s:6:\"styles\";a:0:{}}s:5:\"defer\";a:2:{s:7:\"scripts\";a:0:{}s:6:\"styles\";a:0:{}}s:18:\"caching_expiry_css\";s:10:\"8d/A691200\";s:25:\"caching_expiry_javascript\";s:10:\"8d/A691200\";s:20:\"caching_expiry_media\";s:10:\"8d/A691200\";s:21:\"caching_expiry_images\";s:10:\"8d/A691200\";s:16:\"cloudflare-email\";s:0:\"\";s:18:\"cloudflare-api-key\";s:0:\"\";s:15:\"cloudflare-zone\";s:0:\"\";s:20:\"cloudflare-zone-name\";s:0:\"\";s:20:\"cloudflare-connected\";b:0;s:15:\"cloudflare-plan\";b:0;s:21:\"cloudflare-page-rules\";a:0:{}s:25:\"cloudflare-caching-expiry\";i:691200;s:19:\"email-notifications\";b:1;s:16:\"email-recipients\";a:0:{}s:15:\"email-frequency\";i:7;s:9:\"email-day\";s:6:\"Sunday\";s:10:\"email-time\";s:4:\"1:22\";s:10:\"minify_cdn\";b:0;s:21:\"wphb-last-sent-report\";i:1503810275;s:8:\"gravatar\";a:1:{s:7:\"enabled\";b:0;}s:10:\"page_cache\";a:8:{s:7:\"enabled\";b:1;s:10:\"cache_blog\";b:1;s:7:\"control\";b:0;s:9:\"detection\";s:4:\"auto\";s:12:\"pages_cached\";i:0;s:12:\"integrations\";a:2:{s:7:\"varnish\";b:0;s:7:\"opcache\";b:0;}s:7:\"preload\";b:0;s:12:\"preload_type\";a:2:{s:9:\"home_page\";b:1;s:8:\"on_clear\";b:1;}}s:10:\"cloudflare\";a:10:{s:7:\"enabled\";b:0;s:9:\"connected\";b:0;s:10:\"last_check\";b:0;s:5:\"email\";s:0:\"\";s:7:\"api_key\";s:0:\"\";s:4:\"zone\";s:0:\"\";s:9:\"zone_name\";s:0:\"\";s:4:\"plan\";b:0;s:10:\"page_rules\";a:0:{}s:12:\"cache_expiry\";i:691200;}s:11:\"performance\";a:6:{s:7:\"reports\";a:9:{s:7:\"enabled\";b:0;s:9:\"frequency\";i:7;s:3:\"day\";s:8:\"Saturday\";s:4:\"time\";s:5:\"17:00\";s:10:\"recipients\";a:0:{}s:4:\"type\";s:7:\"desktop\";s:7:\"metrics\";b:1;s:6:\"audits\";b:1;s:8:\"historic\";b:1;}s:13:\"subsite_tests\";b:0;s:9:\"dismissed\";b:0;s:6:\"widget\";a:4:{s:7:\"desktop\";b:1;s:12:\"show_metrics\";b:1;s:11:\"show_audits\";b:1;s:13:\"show_historic\";b:1;}s:3:\"hub\";a:3:{s:12:\"show_metrics\";b:1;s:11:\"show_audits\";b:1;s:13:\"show_historic\";b:1;}s:10:\"last_score\";i:73;}s:8:\"advanced\";a:10:{s:12:\"query_string\";b:0;s:20:\"query_strings_global\";b:0;s:5:\"emoji\";b:0;s:12:\"emoji_global\";b:0;s:8:\"prefetch\";a:9:{i:0;s:22:\"//fonts.googleapis.com\";i:1;s:19:\"//fonts.gstatic.com\";i:2;s:21:\"//ajax.googleapis.com\";i:3;s:17:\"//apis.google.com\";i:4;s:22:\"//google-analytics.com\";i:5;s:26:\"//www.google-analytics.com\";i:6;s:26:\"//ssl.google-analytics.com\";i:7;s:13:\"//youtube.com\";i:8;s:16:\"//s.gravatar.com\";}s:11:\"db_cleanups\";b:0;s:14:\"cart_fragments\";b:0;s:9:\"lazy_load\";a:4:{s:7:\"enabled\";b:0;s:6:\"method\";s:5:\"click\";s:6:\"button\";a:3:{s:10:\"dimensions\";a:3:{s:6:\"height\";i:0;s:5:\"width\";i:0;s:6:\"radius\";i:0;}s:5:\"color\";a:3:{s:10:\"background\";s:0:\"\";s:6:\"border\";s:0:\"\";s:5:\"hover\";s:0:\"\";}s:9:\"alignment\";a:6:{s:5:\"align\";s:6:\"center\";s:10:\"full_width\";s:2:\"on\";s:4:\"left\";i:0;s:5:\"right\";i:0;s:3:\"top\";i:0;s:6:\"bottom\";i:0;}}s:9:\"threshold\";i:10;}s:12:\"db_frequency\";i:7;s:9:\"db_tables\";a:6:{s:9:\"revisions\";b:1;s:6:\"drafts\";b:1;s:5:\"trash\";b:1;s:4:\"spam\";b:1;s:13:\"trash_comment\";b:1;s:18:\"expired_transients\";b:1;}}s:3:\"rss\";a:2:{s:7:\"enabled\";b:1;s:8:\"duration\";i:3600;}s:7:\"caching\";a:4:{s:10:\"expiry_css\";s:10:\"8d/A691200\";s:17:\"expiry_javascript\";s:10:\"8d/A691200\";s:12:\"expiry_media\";s:10:\"8d/A691200\";s:13:\"expiry_images\";s:10:\"8d/A691200\";}s:10:\"minify_log\";b:0;s:8:\"settings\";a:4:{s:17:\"accessible_colors\";b:0;s:15:\"remove_settings\";b:0;s:11:\"remove_data\";b:0;s:8:\"tracking\";b:0;}s:5:\"redis\";a:1:{s:7:\"enabled\";b:0;}}", "yes");
INSERT INTO `wp_options` VALUES("134611", "wdp_un_profile_data", "a:3:{s:5:\"forum\";a:1:{s:15:\"support_threads\";a:2:{i:0;a:7:{s:5:\"title\";s:47:\"Snapshot restore gives Js browser console error\";s:4:\"link\";s:89:\"https://premium.wpmudev.org/forums/topic/snapshot-restore-gives-js-browser-console-error/\";s:9:\"timestamp\";s:10:\"1549657880\";s:4:\"user\";s:18:\"Konstantinos Xenos\";s:6:\"status\";s:12:\"not_resolved\";s:6:\"unread\";b:1;s:5:\"posts\";i:5;}i:1;a:7:{s:5:\"title\";s:44:\"cURL error 60 SSL problem on non-HTTPS sites\";s:4:\"link\";s:86:\"https://premium.wpmudev.org/forums/topic/curl-error-60-ssl-problem-on-non-https-sites/\";s:9:\"timestamp\";s:10:\"1503588294\";s:4:\"user\";s:5:\"Brian\";s:6:\"status\";s:12:\"not_resolved\";s:6:\"unread\";b:0;s:5:\"posts\";i:4;}}}s:7:\"profile\";a:5:{s:4:\"name\";s:5:\"Brian\";s:9:\"user_name\";s:25:\"info@touristmarketing.com\";s:12:\"member_since\";i:1393735930;s:6:\"avatar\";s:185:\"https://premium.wpmudev.org/avatar/f0e748f879b19591c219ba1266f70f39?s=150&d=https%3A%2F%2Fpremium.wpmudev.org%2Fwp-content%2Fthemes%2Fwpmudev-2015-1%2Fassets%2Fimg%2Favatars%2Ff.png&r=g\";s:5:\"title\";s:4:\"Gold\";}s:6:\"points\";a:4:{s:10:\"rep_points\";i:4;s:7:\"history\";a:5:{i:0;a:7:{s:4:\"type\";s:4:\"hero\";s:9:\"timestamp\";s:10:\"1550770251\";s:6:\"points\";s:1:\"1\";s:11:\"reason_code\";s:14:\"daily_activity\";s:6:\"reason\";s:27:\"You were active on WPMU DEV\";s:9:\"object_id\";N;s:9:\"from_user\";N;}i:1;a:7:{s:4:\"type\";s:3:\"rep\";s:9:\"timestamp\";s:10:\"1550770250\";s:6:\"points\";s:1:\"1\";s:11:\"reason_code\";s:13:\"forum_comment\";s:6:\"reason\";s:195:\"You commented on the discussion <a href=\'https://premium.wpmudev.org/forums/topic/snapshot-restore-gives-js-browser-console-error#post-1378480\'>Snapshot restore gives Js browser console error</a>\";s:9:\"object_id\";s:7:\"3635746\";s:9:\"from_user\";s:1:\"0\";}i:2;a:7:{s:4:\"type\";s:3:\"rep\";s:9:\"timestamp\";s:10:\"1549928061\";s:6:\"points\";s:1:\"1\";s:11:\"reason_code\";s:13:\"forum_comment\";s:6:\"reason\";s:195:\"You commented on the discussion <a href=\'https://premium.wpmudev.org/forums/topic/snapshot-restore-gives-js-browser-console-error#post-1375854\'>Snapshot restore gives Js browser console error</a>\";s:9:\"object_id\";s:7:\"3635740\";s:9:\"from_user\";s:1:\"0\";}i:3;a:7:{s:4:\"type\";s:4:\"hero\";s:9:\"timestamp\";s:10:\"1549928061\";s:6:\"points\";s:1:\"1\";s:11:\"reason_code\";s:14:\"daily_activity\";s:6:\"reason\";s:27:\"You were active on WPMU DEV\";s:9:\"object_id\";N;s:9:\"from_user\";N;}i:4;a:7:{s:4:\"type\";s:3:\"rep\";s:9:\"timestamp\";s:10:\"1503784914\";s:6:\"points\";s:1:\"1\";s:11:\"reason_code\";s:13:\"forum_comment\";s:6:\"reason\";s:189:\"You commented on the discussion <a href=\'https://premium.wpmudev.org/forums/topic/curl-error-60-ssl-problem-on-non-https-sites#post-1273516\'>cURL error 60 SSL problem on non-HTTPS sites</a>\";s:9:\"object_id\";s:7:\"3558847\";s:9:\"from_user\";s:1:\"0\";}}s:11:\"hero_points\";i:56;s:9:\"rep_level\";a:4:{s:4:\"base\";i:0;s:5:\"level\";i:0;s:4:\"name\";s:0:\"\";s:5:\"title\";s:11:\"New Recruit\";}}}", "no");
INSERT INTO `wp_options` VALUES("106440", "wdp_un_remote_access", "", "no");
INSERT INTO `wp_options` VALUES("129072", "wdp_un_refresh_local_flag", "1", "no");
INSERT INTO `wp_options` VALUES("135728", "wdp_un_last_run_updates", "1607013588", "no");
INSERT INTO `wp_options` VALUES("134614", "wdp_un_last_run_profile", "1607024143", "no");
INSERT INTO `wp_options` VALUES("106450", "wdp_un_last_check_upfront", "0", "no");
INSERT INTO `wp_options` VALUES("106451", "wdp_un_last_check_autoupdate", "0", "no");
INSERT INTO `wp_options` VALUES("106452", "wdp_un_staff_notes", "", "no");
INSERT INTO `wp_options` VALUES("106454", "wdp_un_autoupdate_dashboard", "1", "no");
INSERT INTO `wp_options` VALUES("134667", "wdp_un_notifications", "a:1:{i:1509947375;a:6:{s:2:\"id\";i:1509947375;s:7:\"content\";s:270:\"<strong>We\'ve pushed all-new updates to The Hub!</strong><br />What\'s The Hub? Only the best way to manage all your sites in one place! Login to your WPMU DEV account to check out the new features. <a href=\"https://premium.wpmudev.org/hub/my-websites/\">Go to The Hub</a>\";s:9:\"dismissed\";b:0;s:11:\"can_dismiss\";b:1;s:3:\"cta\";s:0:\"\";s:11:\"time_create\";i:1522950037;}}", "no");
INSERT INTO `wp_options` VALUES("134613", "wdp_un_auth_user", "info@touristmarketing.com", "no");
INSERT INTO `wp_options` VALUES("106478", "wpmudev_apikey", "01fe25754d5af8a23eb704780feec4313ceea4a9", "no");
INSERT INTO `wp_options` VALUES("99801", "updraft_combine_jobs_around", "1495566600", "yes");
INSERT INTO `wp_options` VALUES("99966", "cron", "a:32:{i:1607022000;a:1:{s:21:\"wdf_maybe_send_report\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:14:\"thirty_minutes\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1800;}}}i:1607023863;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1607024235;a:1:{s:27:\"snapshot_local_backup_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1607024305;a:1:{s:21:\"wordfence_hourly_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1607024339;a:1:{s:13:\"cleanUpOldLog\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1607025296;a:1:{s:21:\"wordfence_ls_ntp_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1607025532;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1607044065;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1607046623;a:1:{s:15:\"wphb_clear_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1607052889;a:3:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1607054024;a:1:{s:22:\"tweaksSendNotification\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1607054400;a:2:{s:15:\"auditReportCron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:17:\"lockoutReportCron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1607056279;a:1:{s:22:\"wpmudev_scheduled_jobs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1607094278;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1607094719;a:1:{s:19:\"wpseo-reindex-links\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1607097797;a:2:{s:31:\"wpseo_permalink_structure_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:20:\"wpseo_home_url_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1607098180;a:1:{s:23:\"wphb_minify_clear_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1607099206;a:1:{s:13:\"wpseo-reindex\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1607099714;a:1:{s:50:\"snapshot-controller-full-cron-rotate_local_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:35:\"snapshot-controller-full-cron-daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1607103705;a:1:{s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1607106896;a:1:{s:14:\"sc_purge_cache\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:12:\"simple_cache\";s:4:\"args\";a:0:{}s:8:\"interval\";d:86400;}}}i:1607107090;a:1:{s:26:\"wordfence_daily_autoUpdate\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1607107105;a:1:{s:20:\"wordfence_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1607107144;a:1:{s:26:\"wpo_minify_purge_old_cache\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1607107145;a:1:{s:29:\"wpo_smush_clear_backup_images\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1607140200;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"3c3e79092d9a75c299cda24a2115b4ef\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1607140200;}}}}i:1607181799;a:1:{s:18:\"wpseo_onpage_fetch\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1607374800;a:1:{s:31:\"wordfence_email_activity_report\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1607399400;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"3ca66926bc3675576b5693ce8029519f\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1607399400;}}}}i:1607544448;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1607607545;a:1:{s:21:\"wpo_weekly_cron_tasks\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("155188", "snapshot_cron_backup_run", "", "no");
INSERT INTO `wp_options` VALUES("155189", "snapshot-automate-run", "", "no");
INSERT INTO `wp_options` VALUES("99968", "user_hit_count", "a:1:{s:10:\"2018-04-05\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("99971", "mmb_stats_filter", "a:9:{i:0;a:2:{i:0;s:7:\"updates\";i:1;a:3:{s:7:\"plugins\";b:1;s:6:\"themes\";b:1;s:7:\"premium\";b:1;}}i:1;a:2:{i:0;s:11:\"core_update\";i:1;a:1:{s:4:\"core\";b:1;}}i:2;a:2:{i:0;s:5:\"posts\";i:1;a:1:{s:11:\"numberposts\";i:5;}}i:3;a:2:{i:0;s:6:\"drafts\";i:1;a:1:{s:11:\"numberposts\";i:5;}}i:4;a:2:{i:0;s:9:\"scheduled\";i:1;a:1:{s:11:\"numberposts\";i:5;}}i:5;a:1:{i:0;s:11:\"hit_counter\";}i:6;a:2:{i:0;s:8:\"comments\";i:1;a:1:{s:11:\"numberposts\";i:5;}}i:7;a:1:{i:0;s:7:\"backups\";}s:7:\"plugins\";a:1:{s:7:\"cleanup\";a:3:{s:8:\"overhead\";a:0:{}s:9:\"revisions\";a:1:{s:11:\"num_to_keep\";s:3:\"r_5\";}s:4:\"spam\";a:0:{}}}}", "yes");
INSERT INTO `wp_options` VALUES("99979", "wordfence_syncingAttackData", "0", "no");
INSERT INTO `wp_options` VALUES("106840", "wphb-is-cloudflare", "0", "no");
INSERT INTO `wp_options` VALUES("106424", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("106425", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("106426", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("135717", "wdp_un_updates_data", "a:5:{s:8:\"projects\";a:15:{i:119;a:26:{s:2:\"id\";i:119;s:4:\"paid\";s:4:\"free\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:18:\"WPMU DEV Dashboard\";s:8:\"released\";i:1261092923;s:7:\"updated\";i:1606911871;s:9:\"downloads\";s:8:\"10625023\";s:10:\"popularity\";s:6:\"376101\";s:17:\"short_description\";s:80:\"Instant access to brilliant support and one-click plugin and theme installation.\";s:8:\"features\";a:33:{i:0;s:23:\"One-click installations\";i:1;s:36:\"Hub and Hosting Single Sign-On (SSO)\";i:2;s:19:\"Unbranded analytics\";i:3;s:35:\"Dashboard plugin browse and install\";i:4;s:34:\"Dashboard theme browse and install\";i:5;s:21:\"Simply login to setup\";i:6;s:30:\"Integrated badge notifications\";i:7;s:17:\"One-click updates\";i:8;s:28:\"WPMU DEV dashboard news feed\";i:9;s:28:\"Dashboard widget quick links\";i:10;s:25:\"New release notifications\";i:11;s:20:\"Update notifications\";i:12;s:29:\"View recent WPMU DEV activity\";i:13;s:18:\"Membership manager\";i:14;s:34:\"Hide/Remove WPMU DEV hero branding\";i:15;s:18:\"Background updates\";i:16;s:18:\"Hide notifications\";i:17;s:30:\"Limit to Multisite Super Admin\";i:18;s:21:\"See reputation points\";i:19;s:27:\"Built-in conflict avoidance\";i:20;s:39:\"Occasional special membership discounts\";i:21;s:33:\"Participate in WPMU DEV community\";i:22;s:19:\"Access forum search\";i:23;s:22:\"Fast access to Q&amp;A\";i:24;s:39:\"Grant temporary access to support staff\";i:25;s:34:\"Direct links to usage instructions\";i:26;s:35:\"Installed theme version information\";i:27;s:36:\"Installed plugin version information\";i:28;s:22:\"Post support questions\";i:29;s:29:\"System information quick view\";i:30;s:29:\"PHP configuration information\";i:31;s:17:\"MySQL information\";i:32;s:18:\"Server information\";}s:7:\"version\";s:6:\"4.10.6\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:50:\"WordPress 5.5.3, Multisite 5.5.3, BuddyPress 6.4.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:55:\"https://premium.wpmudev.org/project/wpmu-dev-dashboard/\";s:9:\"thumbnail\";s:76:\"https://premium.wpmudev.org/wp-content/uploads/2009/12/Dashboard-280x158.png\";s:16:\"thumbnail_square\";s:74:\"https://premium.wpmudev.org/wp-content/uploads/2009/12/Dashboard-90x90.png\";s:15:\"thumbnail_large\";s:68:\"https://premium.wpmudev.org/wp-content/uploads/2009/12/Dashboard.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/irz1r2ze9m\";s:13:\"wp_config_url\";s:31:\"admin.php?page=wpmudev-settings\";s:13:\"ms_config_url\";s:31:\"admin.php?page=wpmudev-settings\";s:7:\"package\";i:0;s:11:\"screenshots\";a:3:{i:0;a:2:{s:3:\"url\";s:93:\"https://premium.wpmudev.org/wp-content/uploads/projects/119/screenshots/dashboard-support.png\";s:4:\"desc\";s:21:\"Secure support access\";}i:1;a:2:{s:3:\"url\";s:92:\"https://premium.wpmudev.org/wp-content/uploads/projects/119/screenshots/dashboard-access.png\";s:4:\"desc\";s:41:\"Quick access from the WordPress dashboard\";}i:2;a:2:{s:3:\"url\";s:94:\"https://premium.wpmudev.org/wp-content/uploads/projects/119/screenshots/96343734_analitics.png\";s:4:\"desc\";s:19:\"Unbranded Analytics\";}}s:6:\"_order\";i:1;}i:3779636;a:26:{s:2:\"id\";i:3779636;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:14:\"The Hub Client\";s:8:\"released\";i:1597667386;s:7:\"updated\";i:1606987319;s:9:\"downloads\";s:4:\"5903\";s:10:\"popularity\";s:4:\"2174\";s:17:\"short_description\";s:102:\"White label WPMU DEV and give your clients their own Hub experience on your site, with your branding. \";s:8:\"features\";a:7:{i:0;s:30:\"Completely white label The Hub\";i:1;s:31:\"Run entirely on your own domain\";i:2;s:30:\"Control all user access levels\";i:3;s:34:\"Free with your WPMU DEV membership\";i:4;s:39:\"Easy to set up, just install the plugin\";i:5;s:20:\"Use any host (or us)\";i:6;s:51:\"Sell your clients different levels of subscriptions\";}s:7:\"version\";s:5:\"1.0.4\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:0:\"\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:51:\"https://premium.wpmudev.org/project/the-hub-client/\";s:9:\"thumbnail\";s:84:\"https://premium.wpmudev.org/wp-content/uploads/2020/08/gfx-project-thumb-280x158.png\";s:16:\"thumbnail_square\";s:82:\"https://premium.wpmudev.org/wp-content/uploads/2020/08/gfx-project-thumb-90x90.png\";s:15:\"thumbnail_large\";s:76:\"https://premium.wpmudev.org/wp-content/uploads/2020/08/gfx-project-thumb.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:26:\"admin.php?page=wpmudev-hub\";s:13:\"ms_config_url\";s:26:\"admin.php?page=wpmudev-hub\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:88:\"https://premium.wpmudev.org/wp-content/uploads/projects/3779636/screenshots/gfx-hero.png\";s:4:\"desc\";s:0:\"\";}i:1;a:2:{s:3:\"url\";s:90:\"https://premium.wpmudev.org/wp-content/uploads/projects/3779636/screenshots/gfx-styled.png\";s:4:\"desc\";s:0:\"\";}i:2;a:2:{s:3:\"url\";s:95:\"https://premium.wpmudev.org/wp-content/uploads/projects/3779636/screenshots/gfx-user-access.png\";s:4:\"desc\";s:0:\"\";}i:3;a:2:{s:3:\"url\";s:89:\"https://premium.wpmudev.org/wp-content/uploads/projects/3779636/screenshots/gfx-roles.png\";s:4:\"desc\";s:0:\"\";}}s:6:\"_order\";i:2;}i:912164;a:26:{s:2:\"id\";i:912164;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:9:\"Smush Pro\";s:8:\"released\";i:1416874433;s:7:\"updated\";i:1606969073;s:9:\"downloads\";s:7:\"2513718\";s:10:\"popularity\";s:6:\"356113\";s:17:\"short_description\";s:101:\"User\'s choice, award-winning, and benchmark tested – The best image optimizer plugin for WordPress.\";s:8:\"features\";a:28:{i:0;s:31:\"Double savings with Super-Smush\";i:1;s:28:\"Automatic optimize on upload\";i:2;s:20:\"Smush Pro global CDN\";i:3;s:31:\"Compress huge photos up to 32MB\";i:4;s:29:\"Perfect-fit auto image resize\";i:5;s:33:\"Lazy Loading for offscreen images\";i:6;s:29:\"WebP next-gen file conversion\";i:7;s:31:\"PNG to lossy JPEG smart convert\";i:8;s:34:\"One-click compress existing images\";i:9;s:35:\"Retain rights to every file forever\";i:10;s:29:\"Optimize images in any folder\";i:11;s:34:\"Smush or save original image files\";i:12;s:37:\"Multisite global and subsite settings\";i:13;s:42:\"Lossy compression with little quality loss\";i:14;s:28:\"Amazon S3 plugin integration\";i:15;s:26:\"NextGEN Gallery compatible\";i:16;s:18:\"Preserve EXIF data\";i:17;s:27:\"WP Retina 2x plugin support\";i:18;s:22:\"Envira Gallery Support\";i:19;s:28:\"Avada Fusion Builder Support\";i:20;s:26:\"Dedicated smushing servers\";i:21;s:35:\"HTTPS encrypted browsing compatible\";i:22;s:21:\"WPML media compatible\";i:23;s:20:\"Lossless compression\";i:24;s:39:\"Strip unused colors from indexed images\";i:25;s:30:\"Progress and savings reporting\";i:26;s:26:\"Compress individual images\";i:27;s:32:\"Instant asynchronous compression\";}s:7:\"version\";s:5:\"3.8.1\";s:17:\"free_version_slug\";s:23:\"wp-smushit/wp-smush.php\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:65:\"WordPress 5.5.3, Multisite 5.5.3, BuddyPress 6.4.0, Upfront 1.9.4\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:49:\"https://premium.wpmudev.org/project/wp-smush-pro/\";s:9:\"thumbnail\";s:80:\"https://premium.wpmudev.org/wp-content/uploads/2014/11/Smush_2016_02-280x158.png\";s:16:\"thumbnail_square\";s:78:\"https://premium.wpmudev.org/wp-content/uploads/2014/11/Smush_2016_02-90x90.png\";s:15:\"thumbnail_large\";s:72:\"https://premium.wpmudev.org/wp-content/uploads/2014/11/Smush_2016_02.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:20:\"admin.php?page=smush\";s:13:\"ms_config_url\";s:20:\"admin.php?page=smush\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:108:\"https://premium.wpmudev.org/wp-content/uploads/projects/912164/screenshots/1554180963_smush-pro-bulk-new.png\";s:4:\"desc\";s:14:\"Bulk Smush Now\";}i:1;a:2:{s:3:\"url\";s:109:\"https://premium.wpmudev.org/wp-content/uploads/projects/912164/screenshots/918101858_smush-pro-bulk-smush.png\";s:4:\"desc\";s:20:\"Smush Pro Bulk Smush\";}i:2;a:2:{s:3:\"url\";s:107:\"https://premium.wpmudev.org/wp-content/uploads/projects/912164/screenshots/158049080_smush-pro-settings.png\";s:4:\"desc\";s:18:\"Smush Pro Settings\";}i:3;a:2:{s:3:\"url\";s:107:\"https://premium.wpmudev.org/wp-content/uploads/projects/912164/screenshots/665647559_image-zoom-735x470.jpg\";s:4:\"desc\";s:29:\"Smush without loss of quality\";}}s:6:\"_order\";i:3;}i:1081721;a:26:{s:2:\"id\";i:1081721;s:4:\"paid\";s:4:\"full\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:15:\"Hummingbird Pro\";s:8:\"released\";i:1456236462;s:7:\"updated\";i:1605172304;s:9:\"downloads\";s:7:\"1482803\";s:10:\"popularity\";s:6:\"126978\";s:17:\"short_description\";s:56:\"Everything you need to get your site running super fast.\";s:8:\"features\";a:16:{i:0;s:28:\"Generate performance reports\";i:1;s:30:\"Recommended speed improvements\";i:2;s:15:\"Browser caching\";i:3;s:17:\"Full-page caching\";i:4;s:16:\"Gravatar caching\";i:5;s:11:\"RSS caching\";i:6;s:12:\"Minify files\";i:7;s:13:\"Combine files\";i:8;s:17:\"Set load position\";i:9;s:21:\"Included output graph\";i:10;s:25:\"Simple GZIP configuration\";i:11;s:30:\"Advanced Minification controls\";i:12;s:31:\"Bonus: Sync with Uptime monitor\";i:13;s:32:\"Down and slow load notifications\";i:14;s:23:\"Track average pagespeed\";i:15;s:32:\"Better search engine positioning\";}s:7:\"version\";s:3:\"2.7\";s:17:\"free_version_slug\";s:42:\"hummingbird-performance/wp-hummingbird.php\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:47:\"WordPress 5.5.3, Multisite 5.5.3, Upfront 1.9.4\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:51:\"https://premium.wpmudev.org/project/wp-hummingbird/\";s:9:\"thumbnail\";s:78:\"https://premium.wpmudev.org/wp-content/uploads/2016/02/HummingBird-280x158.png\";s:16:\"thumbnail_square\";s:76:\"https://premium.wpmudev.org/wp-content/uploads/2016/02/HummingBird-90x90.png\";s:15:\"thumbnail_large\";s:70:\"https://premium.wpmudev.org/wp-content/uploads/2016/02/HummingBird.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/cdpqnbvssg\";s:13:\"wp_config_url\";s:19:\"admin.php?page=wphb\";s:13:\"ms_config_url\";s:19:\"admin.php?page=wphb\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:119:\"https://premium.wpmudev.org/wp-content/uploads/projects/1081721/screenshots/1355502351_hum-gcompress-compressor-new.png\";s:4:\"desc\";s:5:\"G-zip\";}i:1;a:2:{s:3:\"url\";s:108:\"https://premium.wpmudev.org/wp-content/uploads/projects/1081721/screenshots/1686427142_hum-browser-cache.png\";s:4:\"desc\";s:13:\"Browser Cache\";}i:2;a:2:{s:3:\"url\";s:105:\"https://premium.wpmudev.org/wp-content/uploads/projects/1081721/screenshots/355595470_hum-pro-testing.png\";s:4:\"desc\";s:31:\"Hummingbird Performance Testing\";}i:3;a:2:{s:3:\"url\";s:108:\"https://premium.wpmudev.org/wp-content/uploads/projects/1081721/screenshots/2090545727_hum-inline-minify.png\";s:4:\"desc\";s:13:\"inline minify\";}}s:6:\"_order\";i:4;}i:1081723;a:26:{s:2:\"id\";i:1081723;s:4:\"paid\";s:4:\"full\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:12:\"Defender Pro\";s:8:\"released\";i:1456855142;s:7:\"updated\";i:1606467591;s:9:\"downloads\";s:7:\"1355864\";s:10:\"popularity\";s:6:\"133250\";s:17:\"short_description\";s:104:\"Regular security scans, vulnerability reports, safety recommendations and security tweaks for WordPress.\";s:8:\"features\";a:20:{i:0;s:21:\"Analyze site security\";i:1;s:30:\"Security tweak recommendations\";i:2;s:27:\"Resolve issues with a click\";i:3;s:31:\"Manual and automatic IP lockout\";i:4;s:18:\"Filterable IP logs\";i:5;s:27:\"Scan core files for changes\";i:6;s:25:\"2-Factor Authentification\";i:7;s:24:\"Customize 2-factor email\";i:8;s:19:\"Vulnerability scans\";i:9;s:14:\"Schedule scans\";i:10;s:28:\"Repair/restore changed files\";i:11;s:25:\"Choose file types to scan\";i:12;s:29:\"Skip files based on file size\";i:13;s:21:\"Receive email reports\";i:14;s:21:\"Set report recipients\";i:15;s:27:\"Google blocklist monitoring\";i:16;s:17:\"Automated backups\";i:17;s:20:\"Full website backups\";i:18;s:13:\"Cloud backups\";i:19;s:30:\"Site interactions with logging\";}s:7:\"version\";s:5:\"2.4.3\";s:17:\"free_version_slug\";s:33:\"defender-security/wp-defender.php\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:65:\"WordPress 5.5.3, Multisite 5.5.3, BuddyPress 6.4.0, Upfront 1.9.4\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:48:\"https://premium.wpmudev.org/project/wp-defender/\";s:9:\"thumbnail\";s:75:\"https://premium.wpmudev.org/wp-content/uploads/2016/02/Defender-280x158.png\";s:16:\"thumbnail_square\";s:73:\"https://premium.wpmudev.org/wp-content/uploads/2016/02/Defender-90x90.png\";s:15:\"thumbnail_large\";s:67:\"https://premium.wpmudev.org/wp-content/uploads/2016/02/Defender.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/ps9y7nphu1\";s:13:\"wp_config_url\";s:26:\"admin.php?page=wp-defender\";s:13:\"ms_config_url\";s:26:\"admin.php?page=wp-defender\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:102:\"https://premium.wpmudev.org/wp-content/uploads/projects/1081723/screenshots/675480798_6-ip-lockout.jpg\";s:4:\"desc\";s:10:\"ip-lockout\";}i:1;a:2:{s:3:\"url\";s:102:\"https://premium.wpmudev.org/wp-content/uploads/projects/1081723/screenshots/1734340993_5-blacklist.jpg\";s:4:\"desc\";s:20:\"Blacklist Monitoring\";}i:2;a:2:{s:3:\"url\";s:103:\"https://premium.wpmudev.org/wp-content/uploads/projects/1081723/screenshots/1971221549_4-audit-logs.jpg\";s:4:\"desc\";s:10:\"Audit Logs\";}i:3;a:2:{s:3:\"url\";s:97:\"https://premium.wpmudev.org/wp-content/uploads/projects/1081723/screenshots/1252355198_3-scan.jpg\";s:4:\"desc\";s:12:\"Scan Reports\";}}s:6:\"_order\";i:5;}i:1107020;a:26:{s:2:\"id\";i:1107020;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:10:\"Hustle Pro\";s:8:\"released\";i:1471315160;s:7:\"updated\";i:1605899710;s:9:\"downloads\";s:6:\"228584\";s:10:\"popularity\";s:5:\"22946\";s:17:\"short_description\";s:100:\"Grow your business and audience with this super easy, super slick email opt-in and marketing plugin.\";s:8:\"features\";a:12:{i:0;s:59:\"Pop-ups, slide-ins, widgets, embeds, and after post opt-ins\";i:1;s:35:\"All the social share icons you need\";i:2;s:46:\"Easily customize designs with in built editing\";i:3;s:34:\"Color match your brand, like magic\";i:4;s:64:\"Show your stuff in style with smooth built-in display animations\";i:5;s:223:\"Integrate with your favorite providers including: Aweber, MailChimp, Constant Contacts, Sendy, ActiveCampaign, SendInBlue, Hubspot, Infusionsoft, Mad Mimi, ConvertKit, MailerLite, iContact, GetResponse, and Campaign Monitor\";i:6;s:58:\"Manage who sees your hustle with super powerful conditions\";i:7;s:47:\"Track how many times your material is displayed\";i:8;s:42:\"See submissions straight through WordPress\";i:9;s:55:\"Conversion rates overview to make your clients ecstatic\";i:10;s:36:\"Great default layouts to choose from\";i:11;s:25:\"Easy management dashboard\";}s:7:\"version\";s:5:\"4.3.5\";s:17:\"free_version_slug\";s:27:\"wordpress-popup/popover.php\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:60:\"WordPress 5.5.3, Multisite 5.5.3, BuddyPress 6.4.0, bbPress \";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:43:\"https://premium.wpmudev.org/project/hustle/\";s:9:\"thumbnail\";s:76:\"https://premium.wpmudev.org/wp-content/uploads/2016/08/hustle-01-280x158.png\";s:16:\"thumbnail_square\";s:74:\"https://premium.wpmudev.org/wp-content/uploads/2016/08/hustle-01-90x90.png\";s:15:\"thumbnail_large\";s:68:\"https://premium.wpmudev.org/wp-content/uploads/2016/08/hustle-01.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:21:\"admin.php?page=hustle\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:110:\"https://premium.wpmudev.org/wp-content/uploads/projects/1107020/screenshots/960353611_hustle-social-design.png\";s:4:\"desc\";s:18:\"Hustle Social Bars\";}i:1;a:2:{s:3:\"url\";s:108:\"https://premium.wpmudev.org/wp-content/uploads/projects/1107020/screenshots/1653524749_2-style-options-1.jpg\";s:4:\"desc\";s:21:\"Hustle Layout Options\";}i:2;a:2:{s:3:\"url\";s:109:\"https://premium.wpmudev.org/wp-content/uploads/projects/1107020/screenshots/469638973_premadecolorschemes.png\";s:4:\"desc\";s:20:\"Hustle Color Schemes\";}i:3;a:2:{s:3:\"url\";s:106:\"https://premium.wpmudev.org/wp-content/uploads/projects/1107020/screenshots/938384474_layoutvariations.png\";s:4:\"desc\";s:24:\"Hustle Design Variations\";}}s:6:\"_order\";i:6;}i:2097296;a:26:{s:2:\"id\";i:2097296;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:14:\"Forminator Pro\";s:8:\"released\";i:1519137568;s:7:\"updated\";i:1606157371;s:9:\"downloads\";s:6:\"276738\";s:10:\"popularity\";s:5:\"29215\";s:17:\"short_description\";s:135:\"Drag and drop WordPress form builder plugin with interactive polls and quizzes for increasing user engagement and building a following.\";s:8:\"features\";a:42:{i:0;s:31:\"Responsive fit for every screen\";i:1;s:13:\"Developer API\";i:2;s:15:\"Stripe Payments\";i:3;s:18:\"PayPal integration\";i:4;s:22:\"SCA Compliant Payments\";i:5;s:12:\"Calculations\";i:6;s:16:\"Google ReCAPTCHA\";i:7;s:26:\"Drag-and-drop form builder\";i:8;s:26:\"Forms  for every situation\";i:9;s:15:\"+15 Form blocks\";i:10;s:36:\"Email routing and conditional emails\";i:11;s:17:\"Form pre-populate\";i:12;s:22:\"Toggle styling options\";i:13;s:16:\"Campaign Monitor\";i:14;s:7:\"HubSpot\";i:15;s:14:\"ActiveCampaign\";i:16;s:13:\"Google Sheets\";i:17;s:31:\"Zapier (connects to +1000 apps)\";i:18;s:18:\"Trello Integration\";i:19;s:9:\"MailChimp\";i:20;s:6:\"AWeber\";i:21;s:17:\"Interactive polls\";i:22;s:18:\"Pagination options\";i:23;s:23:\"Collect and track stats\";i:24;s:23:\"No wrong answer quizzes\";i:25;s:21:\"Submissions dashboard\";i:26;s:15:\"Knowledge tests\";i:27;s:12:\"Live preview\";i:28;s:15:\"Knowledge tests\";i:29;s:24:\"Gutenberg block included\";i:30;s:10:\"GDPR ready\";i:31;s:13:\"Hidden fields\";i:32;s:27:\"Customized submission forms\";i:33;s:32:\"Schedule form submission reports\";i:34;s:16:\"Privacy settings\";i:35;s:29:\"Advanced email configurations\";i:36;s:35:\"Custom login and registration forms\";i:37;s:37:\"Instant migration from Contact Form 7\";i:38;s:42:\"Pass form data (variables) to another page\";i:39;s:26:\"Add E-signature form field\";i:40;s:35:\"Multiple file, drag and drop upload\";i:41;s:34:\"Advanced Datepicker field settings\";}s:7:\"version\";s:6:\"1.14.6\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:0:\"\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:51:\"https://premium.wpmudev.org/project/forminator-pro/\";s:9:\"thumbnail\";s:85:\"https://premium.wpmudev.org/wp-content/uploads/2018/02/forminator-feature-280x158.png\";s:16:\"thumbnail_square\";s:83:\"https://premium.wpmudev.org/wp-content/uploads/2018/02/forminator-feature-90x90.png\";s:15:\"thumbnail_large\";s:77:\"https://premium.wpmudev.org/wp-content/uploads/2018/02/forminator-feature.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:25:\"admin.php?page=forminator\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:113:\"https://premium.wpmudev.org/wp-content/uploads/projects/2097296/screenshots/1276807337_forminator-recaptcha-4.gif\";s:4:\"desc\";s:32:\"Forminator ReCAPTCHA Integration\";}i:1;a:2:{s:3:\"url\";s:106:\"https://premium.wpmudev.org/wp-content/uploads/projects/2097296/screenshots/1690180223_forminator-quiz.png\";s:4:\"desc\";s:15:\"Forminator quiz\";}i:2;a:2:{s:3:\"url\";s:109:\"https://premium.wpmudev.org/wp-content/uploads/projects/2097296/screenshots/1437585076_forminator-polls-2.png\";s:4:\"desc\";s:23:\"Forminator Poll results\";}i:3;a:2:{s:3:\"url\";s:105:\"https://premium.wpmudev.org/wp-content/uploads/projects/2097296/screenshots/1414388846_contact-form-5.png\";s:4:\"desc\";s:23:\"Forminator contact form\";}}s:6:\"_order\";i:7;}i:167;a:26:{s:2:\"id\";i:167;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:14:\"SmartCrawl Pro\";s:8:\"released\";i:1298584937;s:7:\"updated\";i:1605954465;s:9:\"downloads\";s:6:\"647487\";s:10:\"popularity\";s:5:\"66497\";s:17:\"short_description\";s:100:\"Boost your PageRank and drive more traffic to your site with little effort and simple configuration.\";s:8:\"features\";a:33:{i:0;s:22:\"Simple guided settings\";i:1;s:30:\"Offer SEO options by user role\";i:2;s:39:\"Direct interaction with Google and Bing\";i:3;s:48:\"Send sitemap updates automatic to search engines\";i:4;s:63:\"Custom post titles and meta descriptions (per custom post type)\";i:5;s:32:\"Title and meta data optimization\";i:6;s:26:\"Automatic sitewide linking\";i:7;s:24:\"Complete Moz integration\";i:8;s:38:\"Multisite and BuddyPress compatibility\";i:9;s:36:\"Process posts and pages individually\";i:10;s:17:\"Process RSS feeds\";i:11;s:31:\"Conduct case sensitive matching\";i:12;s:23:\"Prevent duplicate links\";i:13;s:28:\"Open links in new tab/window\";i:14;s:35:\"Exclude posts or pages from sitemap\";i:15;s:40:\"Exclude custom post types and taxonomies\";i:16;s:27:\"Exclude categories and tags\";i:17;s:41:\"Include or exclude images and stylesheets\";i:18;s:46:\"Include or remove the sitemap dashboard widget\";i:19;s:33:\"Disable automatic sitemap updates\";i:20;s:65:\"Post categories, tags and custom taxonomy title and meta defaults\";i:21;s:17:\"Custom home title\";i:22;s:21:\"Home meta description\";i:23;s:8:\"Keywords\";i:24;s:51:\"Import/export to quickly add SmartCrawl to any site\";i:25;s:39:\"Yoast SEO settings and content importer\";i:26;s:44:\"All in One SEO settings and content importer\";i:27;s:37:\"Main blog archive meta robots options\";i:28;s:29:\"Post and media title defaults\";i:29;s:40:\"Post and media meta description defaults\";i:30;s:53:\"Post categories, tags and custom taxonomy robots tags\";i:31;s:24:\"Author and date archives\";i:32;s:39:\"404 page title and description defaults\";}s:7:\"version\";s:5:\"2.8.4\";s:17:\"free_version_slug\";s:31:\"smartcrawl-seo/wpmu-dev-seo.php\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:65:\"WordPress 5.5.3, Multisite 5.5.3, BuddyPress 6.4.0, Upfront 1.9.4\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:61:\"https://premium.wpmudev.org/project/smartcrawl-wordpress-seo/\";s:9:\"thumbnail\";s:106:\"https://premium.wpmudev.org/wp-content/uploads/2011/02/SEO_Webcrawler_1470_SEO_Webcrawler_1470-280x158.png\";s:16:\"thumbnail_square\";s:104:\"https://premium.wpmudev.org/wp-content/uploads/2011/02/SEO_Webcrawler_1470_SEO_Webcrawler_1470-90x90.png\";s:15:\"thumbnail_large\";s:98:\"https://premium.wpmudev.org/wp-content/uploads/2011/02/SEO_Webcrawler_1470_SEO_Webcrawler_1470.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/w6t8a9mq8j\";s:13:\"wp_config_url\";s:25:\"admin.php?page=wds_wizard\";s:13:\"ms_config_url\";s:25:\"admin.php?page=wds_wizard\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:104:\"https://premium.wpmudev.org/wp-content/uploads/projects/167/screenshots/906662147_smartcrawl-checkup.png\";s:4:\"desc\";s:18:\"SmartCrawl Checkup\";}i:1;a:2:{s:3:\"url\";s:105:\"https://premium.wpmudev.org/wp-content/uploads/projects/167/screenshots/1008740409_smartcrawl-sitemap.png\";s:4:\"desc\";s:18:\"SmartCrawl Sitemap\";}i:2;a:2:{s:3:\"url\";s:109:\"https://premium.wpmudev.org/wp-content/uploads/projects/167/screenshots/1267268902_smartcrawl-autolinking.png\";s:4:\"desc\";s:22:\"SmartCrawl autolinking\";}i:3;a:2:{s:3:\"url\";s:119:\"https://premium.wpmudev.org/wp-content/uploads/projects/167/screenshots/205500292_smartcrawl-readability-compressor.png\";s:4:\"desc\";s:22:\"SmartCrawl Readability\";}}s:6:\"_order\";i:8;}i:3760011;a:26:{s:2:\"id\";i:3760011;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:12:\"Snapshot Pro\";s:8:\"released\";i:1592204194;s:7:\"updated\";i:1606815677;s:9:\"downloads\";s:5:\"44801\";s:10:\"popularity\";s:5:\"23201\";s:17:\"short_description\";s:104:\"Make and schedule incremental backups of your WordPress websites and store them on secure cloud storage.\";s:8:\"features\";a:15:{i:0;s:30:\"10GB of WPMU DEV cloud storage\";i:1;s:32:\"Manage your backups from The Hub\";i:2;s:17:\"Redundant backups\";i:3;s:32:\"Multisite Global file exclusions\";i:4;s:17:\"Scheduled backups\";i:5;s:19:\"Set backup interval\";i:6;s:13:\"Manual backup\";i:7;s:20:\"Multisite compatible\";i:8;s:18:\"Backup entire site\";i:9;s:34:\"Exclude specific files and folders\";i:10;s:22:\"Downloadable log files\";i:11;s:24:\"Simple one-click restore\";i:12;s:31:\"30 backups automatically stored\";i:13;s:15:\"Dynamic scaling\";i:14;s:19:\"Backup zipstreaming\";}s:7:\"version\";s:5:\"4.1.2\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:0:\"\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:45:\"https://premium.wpmudev.org/project/snapshot/\";s:9:\"thumbnail\";s:82:\"https://premium.wpmudev.org/wp-content/uploads/2012/02/Snapshot_plugin-280x158.png\";s:16:\"thumbnail_square\";s:80:\"https://premium.wpmudev.org/wp-content/uploads/2012/02/Snapshot_plugin-90x90.png\";s:15:\"thumbnail_large\";s:74:\"https://premium.wpmudev.org/wp-content/uploads/2012/02/Snapshot_plugin.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:31:\"admin.php?page=snapshot-backups\";s:13:\"ms_config_url\";s:31:\"admin.php?page=snapshot-backups\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:95:\"https://premium.wpmudev.org/wp-content/uploads/projects/3760011/screenshots/Snapshot-4-dash.png\";s:4:\"desc\";s:80:\"Control every aspect of your backups, right down to the time and day they occur.\";}i:1;a:2:{s:3:\"url\";s:104:\"https://premium.wpmudev.org/wp-content/uploads/projects/3760011/screenshots/snapshot4-manage-backups.png\";s:4:\"desc\";s:51:\"Manage your backups from one easy-to-use dashboard.\";}i:2;a:2:{s:3:\"url\";s:107:\"https://premium.wpmudev.org/wp-content/uploads/projects/3760011/screenshots/Snaphot-4-available-backups.png\";s:4:\"desc\";s:35:\"Track the progress of your backups.\";}i:3;a:2:{s:3:\"url\";s:106:\"https://premium.wpmudev.org/wp-content/uploads/projects/3760011/screenshots/Snapshot4-schedule-backups.png\";s:4:\"desc\";s:54:\"Automate the time, day, and frequency of your backups.\";}}s:6:\"_order\";i:9;}i:257;a:26:{s:2:\"id\";i:257;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:12:\"Snapshot Pro\";s:8:\"released\";i:1328745252;s:7:\"updated\";i:1594799224;s:9:\"downloads\";s:6:\"722432\";s:10:\"popularity\";s:5:\"43671\";s:17:\"short_description\";s:96:\"The automated, on-demand time-traveler that snaps and stores backups for one-click restoration. \";s:8:\"features\";a:28:{i:0;s:30:\"10GB of WPMU DEV cloud storage\";i:1;s:22:\"The Hub backup manager\";i:2;s:17:\"Redundant backups\";i:3;s:22:\"Server info quick view\";i:4;s:19:\"Manage memory usage\";i:5;s:32:\"Multisite Global file exclusions\";i:6;s:10:\"ZipArchive\";i:7;s:6:\"PclZip\";i:8;s:35:\"Size segmenting eliminates timeouts\";i:9;s:17:\"Scheduled backups\";i:10;s:19:\"Set backup interval\";i:11;s:13:\"Manual backup\";i:12;s:20:\"Multisite compatible\";i:13;s:18:\"Backup entire site\";i:14;s:19:\"Include media files\";i:15;s:22:\"Exclude specific files\";i:16;s:18:\"Annotate snapshots\";i:17;s:25:\"Set custom backup folders\";i:18;s:22:\"Downloadable log files\";i:19;s:24:\"Simple one-click restore\";i:20;s:26:\"Utilize standard WP tables\";i:21;s:11:\"Mirror sync\";i:22;s:30:\"Set number of backups to store\";i:23;s:34:\"Automatically remove oldest backup\";i:24;s:19:\"Dropbox integration\";i:25;s:21:\"Amazon S3 integration\";i:26;s:24:\"FTP and SFTP integration\";i:27;s:24:\"Google Drive integration\";}s:7:\"version\";s:3:\"3.3\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:65:\"WordPress 5.5.3, Multisite 5.5.3, BuddyPress 6.4.0, Upfront 1.9.4\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:48:\"https://premium.wpmudev.org/project/snapshot-v3/\";s:9:\"thumbnail\";s:82:\"https://premium.wpmudev.org/wp-content/uploads/2012/02/Snapshot_plugin-280x158.png\";s:16:\"thumbnail_square\";s:80:\"https://premium.wpmudev.org/wp-content/uploads/2012/02/Snapshot_plugin-90x90.png\";s:15:\"thumbnail_large\";s:74:\"https://premium.wpmudev.org/wp-content/uploads/2012/02/Snapshot_plugin.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/7x4kcv4j15\";s:13:\"wp_config_url\";s:37:\"admin.php?page=snapshot_pro_dashboard\";s:13:\"ms_config_url\";s:37:\"admin.php?page=snapshot_pro_dashboard\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:102:\"https://premium.wpmudev.org/wp-content/uploads/projects/257/screenshots/1315522110_schedule-backup.jpg\";s:4:\"desc\";s:30:\"Schedule backups with Snapshot\";}i:1;a:2:{s:3:\"url\";s:105:\"https://premium.wpmudev.org/wp-content/uploads/projects/257/screenshots/882714582_destinations-backup.jpg\";s:4:\"desc\";s:20:\"Choose a destination\";}i:2;a:2:{s:3:\"url\";s:99:\"https://premium.wpmudev.org/wp-content/uploads/projects/257/screenshots/905771522_snapshot-dash.jpg\";s:4:\"desc\";s:18:\"Snapshot Dashboard\";}i:3;a:2:{s:3:\"url\";s:102:\"https://premium.wpmudev.org/wp-content/uploads/projects/257/screenshots/1953204640_managed-backups.jpg\";s:4:\"desc\";s:15:\"Managed Backups\";}}s:6:\"_order\";i:10;}i:2175128;a:26:{s:2:\"id\";i:2175128;s:4:\"paid\";s:4:\"full\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:11:\"Shipper Pro\";s:8:\"released\";i:1548285368;s:7:\"updated\";i:1606714677;s:9:\"downloads\";s:5:\"79743\";s:10:\"popularity\";s:5:\"12337\";s:17:\"short_description\";s:146:\"Shipper Pro moves WordPress websites with one-click, from host to host, local to production, development to live, top to bottom without using FTP.\";s:8:\"features\";a:20:{i:0;s:17:\"Import and export\";i:1;s:18:\"No FTP/SFTP needed\";i:2;s:23:\"Secure dedicated server\";i:3;s:16:\"Pre-flight check\";i:4;s:21:\"Zip package migration\";i:5;s:21:\"File find and replace\";i:6;s:21:\"Files-by-file porting\";i:7;s:20:\"Large file detection\";i:8;s:22:\"Move from host to host\";i:9;s:23:\"Push from local to live\";i:10;s:21:\"Detailed Shipper Logs\";i:11;s:26:\"Display system Information\";i:12;s:22:\"Runs in the background\";i:13;s:38:\"Destination server configuration check\";i:14;s:18:\"Package size check\";i:15;s:12:\"Source check\";i:16;s:14:\"Location check\";i:17;s:13:\"Package check\";i:18;s:17:\"Migration Filters\";i:19;s:0:\"\";}s:7:\"version\";s:5:\"1.2.3\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:79:\"WordPress 5.5.3, Multisite 5.5.3, BuddyPress 6.4.0, bbPress , WooCommerce 4.7.1\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:48:\"https://premium.wpmudev.org/project/shipper-pro/\";s:9:\"thumbnail\";s:82:\"https://premium.wpmudev.org/wp-content/uploads/2019/01/Shipper-Feature-280x158.png\";s:16:\"thumbnail_square\";s:80:\"https://premium.wpmudev.org/wp-content/uploads/2019/01/Shipper-Feature-90x90.png\";s:15:\"thumbnail_large\";s:74:\"https://premium.wpmudev.org/wp-content/uploads/2019/01/Shipper-Feature.png\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:22:\"admin.php?page=shipper\";s:13:\"ms_config_url\";s:22:\"admin.php?page=shipper\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:114:\"https://premium.wpmudev.org/wp-content/uploads/projects/2175128/screenshots/1130594245_shipper-getting-started.png\";s:4:\"desc\";s:23:\"Shipper getting started\";}i:1;a:2:{s:3:\"url\";s:117:\"https://premium.wpmudev.org/wp-content/uploads/projects/2175128/screenshots/1631499311_shipper-system information.png\";s:4:\"desc\";s:33:\"Shipper server system information\";}i:2;a:2:{s:3:\"url\";s:110:\"https://premium.wpmudev.org/wp-content/uploads/projects/2175128/screenshots/36952669_shipper-import-export.png\";s:4:\"desc\";s:25:\"Shipper import and export\";}i:3;a:2:{s:3:\"url\";s:116:\"https://premium.wpmudev.org/wp-content/uploads/projects/2175128/screenshots/1684527269_shipper-migration-options.png\";s:4:\"desc\";s:25:\"Shipper migration options\";}}s:6:\"_order\";i:11;}i:9135;a:26:{s:2:\"id\";i:9135;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:10:\"Branda Pro\";s:8:\"released\";i:1339280384;s:7:\"updated\";i:1605174035;s:9:\"downloads\";s:6:\"563630\";s:10:\"popularity\";s:5:\"50743\";s:17:\"short_description\";s:87:\"White label WordPress branding for both the front and back end of your site or network.\";s:8:\"features\";a:43:{i:0;s:25:\"Remove WordPress branding\";i:1;s:21:\"Highlight your design\";i:2;s:32:\"Add custom logo to the Admin Bar\";i:3;s:33:\"Simple WordPress logo replacement\";i:4;s:26:\"Create custom login screen\";i:5;s:28:\"Replace the word \"WordPress\"\";i:6;s:21:\"Simple brand matching\";i:7;s:21:\"Import/Export setting\";i:8;s:26:\"Reorganize Admin Bar menus\";i:9;s:26:\"Set custom Admin Bar menus\";i:10;s:28:\"Add a direct link to support\";i:11;s:16:\"Add help buttons\";i:12;s:29:\"Send system emails using SMTP\";i:13;s:29:\"Remove core Dashboard widgets\";i:14;s:32:\"Hide 3rd-party dashboard widgets\";i:15;s:29:\"Replace the WordPress \'Howdy\'\";i:16;s:28:\"Coming Soon/Maintenance Mode\";i:17;s:30:\"Customize \'Admin Help Content\'\";i:18;s:32:\"Increase site security and speed\";i:19;s:27:\"One plugin for all settings\";i:20;s:25:\"Create a custom admin bar\";i:21;s:24:\"Set \"From\" Email address\";i:22;s:15:\"Multisite ready\";i:23;s:26:\"Customize/add help content\";i:24;s:20:\"Custom global footer\";i:25;s:20:\"Custom global header\";i:26;s:23:\"Custom dashboard footer\";i:27;s:23:\"Rebrand the meta widget\";i:28;s:22:\"Protect site structure\";i:29;s:28:\"Custom DB error landing page\";i:30;s:27:\"Hide \'Permalinks\' menu item\";i:31;s:25:\"Replace WordPress in HTML\";i:32;s:26:\"Replace any word or phrase\";i:33;s:20:\"Set a custom Favicon\";i:34;s:28:\"Easily insert tracking codes\";i:35;s:25:\"Custom Multisite Favicons\";i:36;s:19:\"Customize admin CSS\";i:37;s:21:\"Uses CSS child fields\";i:38;s:22:\"Hide WordPress welcome\";i:39;s:34:\"Add custom dashboard color schemes\";i:40;s:29:\"Display custom admin messages\";i:41;s:30:\"Add Author Boxes to your posts\";i:42;s:31:\"Fully customize your admin menu\";}s:7:\"version\";s:5:\"3.4.1\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:65:\"WordPress 5.5.3, Multisite 5.5.3, BuddyPress 6.4.0, Upfront 1.9.4\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:54:\"https://premium.wpmudev.org/project/ultimate-branding/\";s:9:\"thumbnail\";s:79:\"https://premium.wpmudev.org/wp-content/uploads/2012/06/branda-large-280x158.png\";s:16:\"thumbnail_square\";s:77:\"https://premium.wpmudev.org/wp-content/uploads/2012/06/branda-large-90x90.png\";s:15:\"thumbnail_large\";s:71:\"https://premium.wpmudev.org/wp-content/uploads/2012/06/branda-large.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/v9l5fs1cgs\";s:13:\"wp_config_url\";s:23:\"admin.php?page=branding\";s:13:\"ms_config_url\";s:23:\"admin.php?page=branding\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:104:\"https://premium.wpmudev.org/wp-content/uploads/projects/9135/screenshots/branda-custom-login-screens.png\";s:4:\"desc\";s:27:\"Branda custom login screens\";}i:1;a:2:{s:3:\"url\";s:99:\"https://premium.wpmudev.org/wp-content/uploads/projects/9135/screenshots/branda-email-templates.png\";s:4:\"desc\";s:22:\"Branda email templates\";}i:2;a:2:{s:3:\"url\";s:105:\"https://premium.wpmudev.org/wp-content/uploads/projects/9135/screenshots/branda-feed-dashboard-widget.png\";s:4:\"desc\";s:22:\"Branda dashboard feeds\";}i:3;a:2:{s:3:\"url\";s:90:\"https://premium.wpmudev.org/wp-content/uploads/projects/9135/screenshots/branda-social.png\";s:4:\"desc\";s:27:\"Branda social share options\";}}s:6:\"_order\";i:12;}i:51;a:26:{s:2:\"id\";i:51;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:11:\"Beehive Pro\";s:8:\"released\";i:1235347220;s:7:\"updated\";i:1605786709;s:9:\"downloads\";s:6:\"415147\";s:10:\"popularity\";s:5:\"48140\";s:17:\"short_description\";s:94:\"Customizable Google Analytics dashboards, statistics, and reports for WordPress and Multisite.\";s:8:\"features\";a:18:{i:0;s:29:\"Simple one-click setup wizard\";i:1;s:30:\"Powerful Multisite integration\";i:2;s:39:\"One tracking code for an entire network\";i:3;s:38:\"Individual post/page statistics viewer\";i:4;s:17:\"Customize reports\";i:5;s:20:\"Anonymize IP masking\";i:6;s:26:\"Analytics dashboard widget\";i:7;s:38:\"Google Display Advertising integration\";i:8;s:26:\"Statistics overview screen\";i:9;s:31:\"Limit access based on user role\";i:10;s:28:\"Toggle statistics date range\";i:11;s:35:\"Track visits, page views and trends\";i:12;s:34:\"See visit duration and bounce rate\";i:13;s:41:\"Track top post, pages and referring links\";i:14;s:34:\"World map with visitors by country\";i:15;s:32:\"Graphs for fast visual reference\";i:16;s:23:\"Collect sub-domain data\";i:17;s:21:\"Tracks mapped domains\";}s:7:\"version\";s:5:\"3.3.4\";s:17:\"free_version_slug\";s:17:\"beehive-analytics\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:50:\"WordPress 5.5.3, Multisite 5.5.3, BuddyPress 6.4.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:58:\"https://premium.wpmudev.org/project/beehive-analytics-pro/\";s:9:\"thumbnail\";s:95:\"https://premium.wpmudev.org/wp-content/uploads/2019/10/beehive-featured-placeholder-280x158.png\";s:16:\"thumbnail_square\";s:93:\"https://premium.wpmudev.org/wp-content/uploads/2019/10/beehive-featured-placeholder-90x90.png\";s:15:\"thumbnail_large\";s:87:\"https://premium.wpmudev.org/wp-content/uploads/2019/10/beehive-featured-placeholder.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/iu6g2umvu8\";s:13:\"wp_config_url\";s:31:\"admin.php?page=beehive-settings\";s:13:\"ms_config_url\";s:31:\"admin.php?page=beehive-settings\";s:7:\"package\";i:0;s:11:\"screenshots\";a:4:{i:0;a:2:{s:3:\"url\";s:93:\"https://premium.wpmudev.org/wp-content/uploads/projects/51/screenshots/beehive-comparison.png\";s:4:\"desc\";s:17:\"analytic overview\";}i:1;a:2:{s:3:\"url\";s:89:\"https://premium.wpmudev.org/wp-content/uploads/projects/51/screenshots/beehive-medium.png\";s:4:\"desc\";s:14:\"Beehive medium\";}i:2;a:2:{s:3:\"url\";s:92:\"https://premium.wpmudev.org/wp-content/uploads/projects/51/screenshots/beehive-user-data.png\";s:4:\"desc\";s:23:\"Beehive comparison data\";}i:3;a:2:{s:3:\"url\";s:92:\"https://premium.wpmudev.org/wp-content/uploads/projects/51/screenshots/beehive-user-role.png\";s:4:\"desc\";s:22:\"User roles for beehive\";}}s:6:\"_order\";i:13;}i:248;a:26:{s:2:\"id\";i:248;s:4:\"paid\";s:4:\"full\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:26:\"Integrated Video Tutorials\";s:8:\"released\";i:1318459013;s:7:\"updated\";i:1606119636;s:9:\"downloads\";s:6:\"142411\";s:10:\"popularity\";s:5:\"10033\";s:17:\"short_description\";s:81:\"Complete, quality, always up-to-date list of unbranded WordPress training videos.\";s:8:\"features\";a:23:{i:0;s:20:\"Register your domain\";i:1;s:32:\"+45 included WordPress tutorials\";i:2;s:32:\"Automatically add videos to help\";i:3;s:17:\"Verify connection\";i:4;s:14:\"Hide menu item\";i:5;s:19:\"Customize menu name\";i:6;s:30:\"Give setup permission to users\";i:7;s:32:\"Hide access to individual videos\";i:8;s:17:\"Add custom videos\";i:9;s:14:\"Wistia support\";i:10;s:15:\"YouTube support\";i:11;s:13:\"Vimeo support\";i:12;s:21:\"Shortcode embed codes\";i:13;s:22:\"Customizable playlists\";i:14;s:11:\"Group embed\";i:15;s:15:\"Front end embed\";i:16;s:18:\"Quality production\";i:17;s:25:\"Automatic content updates\";i:18;s:20:\"White label branding\";i:19;s:19:\"Unlimited bandwidth\";i:20;s:15:\"Unlimited plays\";i:21;s:14:\"SSL compatible\";i:22;s:21:\"Multisite integration\";}s:7:\"version\";s:5:\"1.8.3\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:50:\"WordPress 5.5.3, Multisite 5.5.3, BuddyPress 6.4.0\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:62:\"https://premium.wpmudev.org/project/unbranded-video-tutorials/\";s:9:\"thumbnail\";s:94:\"https://premium.wpmudev.org/wp-content/uploads/2011/10/Integration-Video-Tutorials-280x158.png\";s:16:\"thumbnail_square\";s:92:\"https://premium.wpmudev.org/wp-content/uploads/2011/10/Integration-Video-Tutorials-90x90.png\";s:15:\"thumbnail_large\";s:86:\"https://premium.wpmudev.org/wp-content/uploads/2011/10/Integration-Video-Tutorials.png\";s:5:\"video\";s:41:\"//fast.wistia.net/embed/iframe/c5b01yf5xw\";s:13:\"wp_config_url\";s:39:\"options-general.php?page=wpmudev-videos\";s:13:\"ms_config_url\";s:32:\"settings.php?page=wpmudev-videos\";s:7:\"package\";i:0;s:11:\"screenshots\";a:3:{i:0;a:2:{s:3:\"url\";s:108:\"https://premium.wpmudev.org/wp-content/uploads/projects/248/screenshots/843594149_video-settings-735x470.jpg\";s:4:\"desc\";s:10:\"Easy setup\";}i:1;a:2:{s:3:\"url\";s:100:\"https://premium.wpmudev.org/wp-content/uploads/projects/248/screenshots/1005196382_icons-735x470.jpg\";s:4:\"desc\";s:15:\"A ton of videos\";}i:2;a:2:{s:3:\"url\";s:107:\"https://premium.wpmudev.org/wp-content/uploads/projects/248/screenshots/1978520080_video-player-735x470.jpg\";s:4:\"desc\";s:19:\"Videos in dashboard\";}}s:6:\"_order\";i:14;}i:938297;a:25:{s:2:\"id\";i:938297;s:4:\"paid\";s:4:\"paid\";s:4:\"type\";s:5:\"theme\";s:4:\"name\";s:7:\"Upfront\";s:8:\"released\";i:1421124646;s:7:\"updated\";i:1524768151;s:9:\"downloads\";s:6:\"121696\";s:10:\"popularity\";s:4:\"3346\";s:17:\"short_description\";s:145:\"A versatile and infinitely customizable drag-and-drop WordPress theme platform for use with any child theme in the growing Upfront theme library.\";s:8:\"features\";a:0:{}s:7:\"version\";s:5:\"1.9.4\";s:17:\"free_version_slug\";s:0:\"\";s:10:\"autoupdate\";s:1:\"1\";s:6:\"active\";b:1;s:10:\"compatible\";s:32:\"WordPress 5.5.3, Multisite 5.5.3\";s:8:\"requires\";s:2:\"wp\";s:3:\"url\";s:44:\"https://premium.wpmudev.org/project/upfront/\";s:9:\"thumbnail\";s:74:\"https://premium.wpmudev.org/wp-content/uploads/2015/01/upfront-280x158.jpg\";s:16:\"thumbnail_square\";s:72:\"https://premium.wpmudev.org/wp-content/uploads/2015/01/upfront-90x90.jpg\";s:15:\"thumbnail_large\";s:66:\"https://premium.wpmudev.org/wp-content/uploads/2015/01/upfront.jpg\";s:5:\"video\";b:0;s:13:\"wp_config_url\";s:0:\"\";s:13:\"ms_config_url\";s:0:\"\";s:7:\"package\";i:0;s:6:\"_order\";i:15;}}s:11:\"plugin_tags\";a:6:{i:489;a:3:{s:4:\"name\";s:31:\"BuddyPress Plugins &amp; Themes\";s:5:\"count\";i:5;s:4:\"pids\";a:5:{i:0;s:3:\"167\";i:1;s:4:\"9135\";i:2;s:3:\"257\";i:3;s:2:\"51\";i:4;s:3:\"248\";}}i:32;a:3:{s:4:\"name\";s:26:\"WordPress Business Plugins\";s:5:\"count\";i:5;s:4:\"pids\";a:5:{i:0;s:7:\"1107020\";i:1;s:3:\"167\";i:2;s:4:\"9135\";i:3;s:3:\"248\";i:4;s:7:\"2097296\";}}i:498;a:3:{s:4:\"name\";s:27:\"WordPress Marketing Plugins\";s:5:\"count\";i:3;s:4:\"pids\";a:3:{i:0;s:7:\"1107020\";i:1;s:3:\"167\";i:2;s:7:\"2097296\";}}i:16;a:3:{s:4:\"name\";s:27:\"WordPress Multisite Plugins\";s:5:\"count\";i:9;s:4:\"pids\";a:9:{i:0;s:6:\"912164\";i:1;s:7:\"1081721\";i:2;s:7:\"1081723\";i:3;s:3:\"167\";i:4;s:3:\"257\";i:5;s:7:\"1107020\";i:6;s:4:\"9135\";i:7;s:2:\"51\";i:8;s:3:\"248\";}}i:31;a:3:{s:4:\"name\";s:28:\"WordPress Publishing Plugins\";s:5:\"count\";i:3;s:4:\"pids\";a:3:{i:0;s:6:\"912164\";i:1;s:3:\"167\";i:2;s:3:\"257\";}}i:50;a:3:{s:4:\"name\";s:21:\"WordPress SEO Plugins\";s:5:\"count\";i:5;s:4:\"pids\";a:5:{i:0;s:7:\"1107020\";i:1;s:3:\"167\";i:2;s:7:\"1081721\";i:3;s:4:\"9135\";i:4;s:2:\"51\";}}}s:11:\"free_notice\";N;s:13:\"single_notice\";N;s:11:\"full_notice\";a:3:{s:4:\"time\";i:1509947375;s:3:\"msg\";s:270:\"<strong>We\'ve pushed all-new updates to The Hub!</strong><br />What\'s The Hub? Only the best way to manage all your sites in one place! Login to your WPMU DEV account to check out the new features. <a href=\"https://premium.wpmudev.org/hub/my-websites/\">Go to The Hub</a>\";s:6:\"author\";i:164650;}}", "no");
INSERT INTO `wp_options` VALUES("177256", "wordfence_ls_version", "1.0.5", "yes");
INSERT INTO `wp_options` VALUES("196383", "wd_lockdown_settings", "{\"storage_days\":30}", "no");
INSERT INTO `wp_options` VALUES("258038", "wd_login_lockout_settings", "{\"enabled\":true,\"attempt\":5,\"timeframe\":300,\"duration\":300,\"duration_unit\":\"seconds\",\"lockout_type\":\"timeframe\",\"lockout_message\":\"You have been locked out due to too many invalid login attempts.\",\"username_blacklist\":\"\"}", "no");
INSERT INTO `wp_options` VALUES("258039", "wd_notfound_lockout_settings", "{\"enabled\":true,\"attempt\":20,\"timeframe\":300,\"duration\":300,\"duration_unit\":\"seconds\",\"lockout_type\":\"timeframe\",\"blacklist\":\"\",\"whitelist\":\"\",\"lockout_message\":\"You have been locked out due to too many attempts to access a file that doesn\'t exist.\",\"detect_logged\":true}", "no");
INSERT INTO `wp_options` VALUES("258040", "wd_blacklist_lockout_settings", "{\"ip_blacklist\":\"\",\"ip_whitelist\":\"\",\"ip_lockout_message\":\"The administrator has blocked your IP from accessing this website.\",\"country_blacklist\":[\"\"],\"country_whitelist\":[\"\"],\"geodb_path\":\"\"}", "no");
INSERT INTO `wp_options` VALUES("258041", "wd_malware_firewall_notification", "{\"title\":\"Firewall - Notification\",\"slug\":\"firewall-notification\",\"description\":\"Get email when a user or IP is locked out for trying to access your login area.\",\"status\":\"enabled\",\"type\":\"notification\",\"frequency\":\"\",\"day\":\"\",\"day_n\":\"0\",\"time\":\"\",\"in_house_recipients\":[{\"name\":\"Guest\",\"id\":\"0\",\"email\":\"Guest\",\"role\":\"\",\"avatar\":\"https:\\/\\/secure.gravatar.com\\/avatar\\/084e0343a0486ff05530df6c705c8bb4?s=96&d=mm&r=g\",\"status\":\"subscribed\"}],\"out_house_recipients\":[],\"dry_run\":false,\"configs\":{\"login_lockout\":true,\"nf_lockout\":true,\"limit\":\"\",\"threshold\":\"3\",\"cool_off\":\"24\"},\"last_sent\":1606245056,\"est_timestamp\":0,\"next_run\":\"Never\",\"all_subscribers\":[{\"name\":\"Guest\",\"id\":\"0\",\"email\":\"Guest\",\"role\":\"\",\"avatar\":\"https:\\/\\/secure.gravatar.com\\/avatar\\/084e0343a0486ff05530df6c705c8bb4?s=96&d=mm&r=g\",\"status\":\"subscribed\"}]}", "no");
INSERT INTO `wp_options` VALUES("258042", "wd_lockout_report", "{\"title\":\"Firewall - Reporting\",\"slug\":\"firewall-report\",\"description\":\"Configure Defender to automatically email you a lockout report for this website.\",\"status\":\"disabled\",\"type\":\"report\",\"frequency\":\"weekly\",\"day\":\"sunday\",\"day_n\":\"1\",\"time\":\"0:00\",\"in_house_recipients\":[{\"name\":\"Guest\",\"id\":\"0\",\"email\":\"Guest\",\"role\":\"\",\"avatar\":\"https:\\/\\/secure.gravatar.com\\/avatar\\/084e0343a0486ff05530df6c705c8bb4?s=96&d=mm&r=g\",\"status\":\"subscribed\"}],\"out_house_recipients\":[],\"dry_run\":false,\"configs\":[],\"last_sent\":\"1570336256\",\"est_timestamp\":0,\"next_run\":\"Never\",\"all_subscribers\":[{\"name\":\"Guest\",\"id\":\"0\",\"email\":\"Guest\",\"role\":\"\",\"avatar\":\"https:\\/\\/secure.gravatar.com\\/avatar\\/084e0343a0486ff05530df6c705c8bb4?s=96&d=mm&r=g\",\"status\":\"subscribed\"}]}", "no");
INSERT INTO `wp_options` VALUES("197900", "wd_scan_settings", "{\"table\":\"wd_scan_settings\",\"integrity_check\":true,\"scan_malware\":true,\"check_known_vuln\":true,\"filesize\":1,\"annotations\":[]}", "no");
INSERT INTO `wp_options` VALUES("258036", "wd_malware_scanning_notification", "{\"title\":\"Malware Scanning - Notification\",\"slug\":\"malware-notification\",\"description\":\"Get email notifications when Defender has finished manual malware scans.\",\"status\":\"disabled\",\"type\":\"notification\",\"frequency\":\"\",\"day\":\"\",\"day_n\":\"0\",\"time\":\"\",\"in_house_recipients\":[{\"name\":\"Guest\",\"id\":\"0\",\"email\":\"Guest\",\"role\":\"\",\"avatar\":\"https:\\/\\/secure.gravatar.com\\/avatar\\/084e0343a0486ff05530df6c705c8bb4?s=96&d=mm&r=g\",\"status\":\"subscribed\"}],\"out_house_recipients\":[],\"dry_run\":false,\"configs\":{\"always_send\":\"\",\"error_send\":false,\"template\":{\"found\":{\"subject\":\"Scan of {SITE_URL} complete. {ISSUES_COUNT} issues found.\",\"body\":\"Hi {USER_NAME},\\r\\n\\r\\nWP Defender here, reporting back from the front.\\r\\n\\r\\nI\'ve finished scanning {SITE_URL} for vulnerabilities and I found {ISSUES_COUNT} issues that you should take a closer look at!\\r\\n{ISSUES_LIST}\\r\\n\\r\\nStay Safe,\\r\\nWP Defender\\r\\nOfficial WPMU DEV Superhero\"},\"not_found\":{\"subject\":\"Scan of {SITE_URL} complete. {ISSUES_COUNT} issues found.\",\"body\":\"Hi {USER_NAME},\\r\\n\\r\\nWP Defender here, reporting back from the front.\\r\\n\\r\\nI\'ve finished scanning {SITE_URL} for vulnerabilities and I found nothing. Well done for running such a tight ship!\\r\\n\\r\\nKeep up the good work! With regular security scans and a well-hardened installation you\'ll be just fine.\\r\\n\\r\\nStay safe,\\r\\nWP Defender\\r\\nOfficial WPMU DEV Superhero\"},\"error\":{\"subject\":\"Couldn\\u2019t scan {SITE_URL} for vulnerabilities. \",\"body\":\"Hi {USER_NAME},\\r\\n\\r\\nWP Defender here, reporting back from the front.\\r\\n\\r\\nI couldn\\u2019t scan {SITE_URL} for vulnerabilities. Please {follow this link} and check the logs to see what casued the failure.\\r\\n\\r\\nStay Safe,\\r\\nWP Defender\\r\\nOfficial WPMU DEV Superhero\\r\\n\"}}},\"last_sent\":1606245056,\"est_timestamp\":0,\"next_run\":\"Never\",\"all_subscribers\":[{\"name\":\"Guest\",\"id\":\"0\",\"email\":\"Guest\",\"role\":\"\",\"avatar\":\"https:\\/\\/secure.gravatar.com\\/avatar\\/084e0343a0486ff05530df6c705c8bb4?s=96&d=mm&r=g\",\"status\":\"subscribed\"}]}", "no");
INSERT INTO `wp_options` VALUES("197901", "wd_masking_login_settings", "{\"mask_url\":\"\",\"redirect_traffic\":\"off\",\"redirect_traffic_url\":\"\",\"redirect_traffic_page_id\":0,\"enabled\":false}", "no");
INSERT INTO `wp_options` VALUES("197902", "wd_2auth_settings", "{\"enabled\":false,\"lost_phone\":true,\"force_auth\":false,\"force_auth_mess\":\"You are required to setup two-factor authentication to use this site.\",\"user_roles\":{\"0\":\"administrator\",\"1\":\"editor\",\"2\":\"author\",\"3\":\"contributor\",\"5\":\"wpseo_manager\",\"6\":\"wpseo_editor\"},\"force_auth_roles\":[],\"custom_graphic\":false,\"custom_graphic_url\":\"https:\\/\\/www.econolodgeloon.com\\/wp-content\\/plugins\\/wp-defender\\/assets\\/img\\/2factor-disabled.svg\",\"email_subject\":\"Your OTP code\",\"email_sender\":\"admin\",\"email_body\":\"Hi {{display_name}},\\r\\n\\r\\nYour temporary login passcode is {{passcode}}.\\r\\n\\r\\nCopy and paste the passcode into the input field on the login screen to complete logging in.\\r\\n\\r\\nRegards,\\r\\nAdministrator\",\"app_title\":\"\"}", "no");
INSERT INTO `wp_options` VALUES("223296", "wpseo_ryte", "a:2:{s:6:\"status\";i:1;s:10:\"last_fetch\";i:1582989831;}", "yes");
INSERT INTO `wp_options` VALUES("224174", "wdp_un_translation_updates_available", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("217732", "wd_util_server", "a:1:{s:30:\"https://www.econolodgeloon.com\";s:6:\"apache\";}", "no");
INSERT INTO `wp_options` VALUES("241726", "wphb-stop-report", "1", "no");
INSERT INTO `wp_options` VALUES("149895", "classic-editor-replace", "replace", "yes");
INSERT INTO `wp_options` VALUES("135730", "wdp_un_updates_available", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("135741", "wdp_un_refresh_remote_flag", "0", "no");
INSERT INTO `wp_options` VALUES("135746", "wdp_un_membership_data", "a:6:{s:10:\"membership\";s:4:\"full\";s:21:\"membership_full_level\";s:4:\"gold\";s:28:\"membership_excluded_projects\";a:0:{}s:17:\"membership_access\";b:1;s:8:\"services\";a:3:{s:6:\"uptime\";i:0;s:8:\"automate\";i:0;s:7:\"reports\";i:0;}s:11:\"hub_site_id\";s:7:\"1178365\";}", "no");
INSERT INTO `wp_options` VALUES("135747", "wdp_un_last_run_sync", "a:3:{s:4:\"time\";i:1607020802;s:4:\"hash\";s:32:\"ade327b54069feb31494482d80f141a5\";s:5:\"fails\";i:0;}", "no");
INSERT INTO `wp_options` VALUES("106489", "wdp_un_redirected_v4", "1", "no");
INSERT INTO `wp_options` VALUES("106485", "wdp_un_limit_to_user", "a:1:{i:0;i:5;}", "no");
INSERT INTO `wp_options` VALUES("106511", "wp-smush-version", "3.8.1", "no");
INSERT INTO `wp_options` VALUES("106512", "wp-smush-skip-redirect", "1", "no");
INSERT INTO `wp_options` VALUES("106517", "wp_smush_api_auth", "a:1:{s:40:\"01fe25754d5af8a23eb704780feec4313ceea4a9\";a:2:{s:8:\"validity\";s:5:\"valid\";s:9:\"timestamp\";i:1606920615;}}", "no");
INSERT INTO `wp_options` VALUES("106518", "dir_smush_stats", "a:2:{s:9:\"dir_smush\";a:2:{s:5:\"total\";i:0;s:9:\"optimised\";i:0;}s:14:\"combined_stats\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("106522", "wp-smush-keep_exif", "0", "no");
INSERT INTO `wp_options` VALUES("106528", "wp-smush-image_sizes", "a:9:{i:0;s:9:\"thumbnail\";i:1;s:6:\"medium\";i:2;s:5:\"large\";i:3;s:6:\"custom\";i:4;s:14:\"post-thumbnail\";i:5;s:6:\"header\";i:6;s:6:\"slider\";i:7;s:7:\"columns\";i:8;s:12:\"medium_large\";}", "no");
INSERT INTO `wp_options` VALUES("106529", "wp-smush-resize_sizes", "a:2:{s:5:\"width\";i:2048;s:6:\"height\";i:2048;}", "no");
INSERT INTO `wp_options` VALUES("106837", "wphb_version", "2.7.0", "no");
INSERT INTO `wp_options` VALUES("153530", "wphb-gzip-data", "a:3:{s:4:\"HTML\";b:1;s:10:\"JavaScript\";b:1;s:3:\"CSS\";b:1;}", "no");
INSERT INTO `wp_options` VALUES("155194", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2020-12-03 19:15:35\";s:7:\"Version\";s:6:\"1.3.40\";s:9:\"VersionWP\";s:5:\"5.5.3\";s:9:\"VersionDB\";s:7:\"10.3.27\";s:10:\"VersionPHP\";s:6:\"7.2.34\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:23:\"econolodgebackup12_3_20\";s:4:\"Hash\";s:35:\"80a9c9bf9fdcf1a03310_20201203191535\";s:8:\"NameHash\";s:59:\"econolodgebackup12_3_20_80a9c9bf9fdcf1a03310_20201203191535\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:69:\"econolodgebackup12_3_20_80a9c9bf9fdcf1a03310_20201203191535_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":21:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:28:\"/home/econolodge/public_html\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":5:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":6:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2020-12-03 19:15:35\";s:7:\"Version\";s:6:\"1.3.40\";s:9:\"VersionWP\";s:5:\"5.5.3\";s:9:\"VersionDB\";s:7:\"10.3.27\";s:10:\"VersionPHP\";s:6:\"7.2.34\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:23:\"econolodgebackup12_3_20\";s:4:\"Hash\";s:35:\"80a9c9bf9fdcf1a03310_20201203191535\";s:8:\"NameHash\";s:59:\"econolodgebackup12_3_20_80a9c9bf9fdcf1a03310_20201203191535\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:20:\"dGVdUm1Ie3BlU31FIUAj\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:61;}s:8:\"Database\";O:12:\"DUP_Database\":14:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":15:{s:9:\"buildMode\";N;s:13:\"collationList\";a:0:{}s:17:\"isTablesUpperCase\";N;s:15:\"isNameUpperCase\";N;s:4:\"name\";N;s:15:\"tablesBaseCount\";N;s:16:\"tablesFinalCount\";N;s:14:\"tablesRowCount\";N;s:16:\"tablesSizeOnDisk\";N;s:18:\"varLowerCaseTables\";i:0;s:7:\"version\";N;s:14:\"versionComment\";N;s:18:\"tableWiseRowCounts\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:61;s:24:\"\0DUP_Database\0tempDbPath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:61;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:37:\"/home/econolodge/public_html/wp-admin\";i:1;s:47:\"/home/econolodge/public_html/wp-content/uploads\";i:2;s:49:\"/home/econolodge/public_html/wp-content/languages\";i:3;s:46:\"/home/econolodge/public_html/wp-content/themes\";i:4;s:40:\"/home/econolodge/public_html/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:28:\"/home/econolodge/public_html\";i:1;s:39:\"/home/econolodge/public_html/wp-content\";}}s:9:\"Installer\";r:82;s:8:\"Database\";r:96;s:13:\"BuildProgress\";r:126;}", "yes");
INSERT INTO `wp_options` VALUES("152176", "duplicator_exe_safe_mode", "0", "yes");
INSERT INTO `wp_options` VALUES("135735", "wdp_un_farm133_themes", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("136541", "wordfence_installed", "1", "yes");
INSERT INTO `wp_options` VALUES("136381", "wd_hardener_settings", "{\"id\":\"wd_hardener_settings\",\"issues\":[\"disable-trackback\",\"wp-version\",\"disable-file-editor\",\"prevent-enum-users\",\"security-key\",\"protect-information\",\"prevent-php-executed\",\"login-duration\",\"disable-xml-rpc\"],\"fixed\":[\"php-version\",\"replace-admin-username\",\"hide-error\"],\"ignore\":[],\"last_status_check\":1606244352,\"notification\":false,\"notification_repeat\":false,\"receipts\":[],\"data\":{\"head_requests\":{\"https:\\/\\/www.econolodgeloon.com\\/wp-content\\/plugins\\/wp-defender\\/changelog.txt\":{\"ttl\":1582055456,\"data\":{\"date\":\"Mon, 17 Feb 2020 19:50:56 GMT\",\"server\":\"Apache\",\"upgrade\":\"h2,h2c\",\"last-modified\":\"Mon, 27 Jan 2020 21:04:34 GMT\",\"etag\":\"\\\"ae0db6-4633-59d2574502f22-gzip\\\"\",\"accept-ranges\":\"bytes\",\"vary\":\"Accept-Encoding\",\"content-encoding\":\"gzip\",\"content-length\":\"5637\",\"content-type\":\"text\\/plain\",\"response_code\":200}},\"https:\\/\\/www.econolodgeloon.com\\/wp-content\\/uploads\\/wp-defender\\/index.php\":{\"ttl\":1606320401,\"data\":{\"date\":\"Tue, 24 Nov 2020 16:06:41 GMT\",\"server\":\"Apache\",\"upgrade\":\"h2,h2c\",\"content-type\":\"text\\/html; charset=UTF-8\",\"response_code\":200}},\"https:\\/\\/www.econolodgeloon.com\":{\"ttl\":1588704308,\"data\":{\"date\":\"Mon, 04 May 2020 18:45:08 GMT\",\"server\":\"Apache\",\"link\":\"<https:\\/\\/www.econolodgeloon.com\\/wp-json\\/>; rel=\\\"https:\\/\\/api.w.org\\/\\\"\",\"upgrade\":\"h2,h2c\",\"content-type\":\"text\\/html; charset=UTF-8\",\"response_code\":200}},\"http:\\/\\/www.econolodgeloon.com\\/wp-content\\/plugins\\/wp-defender\\/changelog.txt\":{\"ttl\":1582034609,\"data\":{\"date\":\"Mon, 17 Feb 2020 14:03:29 GMT\",\"server\":\"Apache\",\"upgrade\":\"h2,h2c\",\"last-modified\":\"Mon, 27 Jan 2020 21:04:34 GMT\",\"etag\":\"\\\"ae0db6-4633-59d2574502f22-gzip\\\"\",\"accept-ranges\":\"bytes\",\"vary\":\"Accept-Encoding\",\"content-encoding\":\"gzip\",\"content-length\":\"5637\",\"content-type\":\"text\\/plain\",\"response_code\":200}},\"http:\\/\\/www.econolodgeloon.com\":{\"ttl\":1588679797,\"data\":{\"date\":\"Mon, 04 May 2020 11:56:37 GMT\",\"server\":\"Apache\",\"link\":\"<https:\\/\\/www.econolodgeloon.com\\/wp-json\\/>; rel=\\\"https:\\/\\/api.w.org\\/\\\"\",\"upgrade\":\"h2,h2c\",\"content-type\":\"text\\/html; charset=UTF-8\",\"response_code\":200}},\"http:\\/\\/www.econolodgeloon.com\\/wp-content\\/plugins\\/wp-defender\\/languages\\/wpdef-default.pot\":{\"ttl\":1606320580,\"data\":{\"date\":\"Tue, 24 Nov 2020 16:09:40 GMT\",\"server\":\"Apache\",\"upgrade\":\"h2,h2c\",\"last-modified\":\"Mon, 14 Sep 2020 20:07:26 GMT\",\"etag\":\"\\\"e801d9-3865c-5af4b955e2d5e-gzip\\\"\",\"accept-ranges\":\"bytes\",\"vary\":\"Accept-Encoding\",\"content-encoding\":\"gzip\",\"content-length\":\"41703\",\"content-type\":\"application\\/vnd.ms-powerpoint\",\"response_code\":200}},\"https:\\/\\/www.econolodgeloon.com\\/wp-content\\/plugins\\/wp-defender\\/languages\\/wpdef-default.pot\":{\"ttl\":1606312231,\"data\":{\"date\":\"Tue, 24 Nov 2020 13:50:31 GMT\",\"server\":\"Apache\",\"upgrade\":\"h2,h2c\",\"last-modified\":\"Mon, 14 Sep 2020 20:07:26 GMT\",\"etag\":\"\\\"e801d9-3865c-5af4b955e2d5e-gzip\\\"\",\"accept-ranges\":\"bytes\",\"vary\":\"Accept-Encoding\",\"content-encoding\":\"gzip\",\"content-length\":\"41703\",\"content-type\":\"application\\/vnd.ms-powerpoint\",\"response_code\":200}}}},\"exclude_file_paths\":[],\"new_htconfig\":[],\"active_server\":\"apache\",\"last_seen\":1560916428,\"last_sent\":1605758830,\"min_php_version\":\"7.2\",\"stable_php_version\":\"7.3\",\"is_prefix_changed\":false,\"automate\":false}", "no");
INSERT INTO `wp_options` VALUES("108348", "ossdl_off_cdn_url", "http://67.23.236.217/~windriftmotel", "yes");
INSERT INTO `wp_options` VALUES("108349", "ossdl_off_include_dirs", "wp-content,wp-includes", "yes");
INSERT INTO `wp_options` VALUES("108350", "ossdl_off_exclude", ".php", "yes");
INSERT INTO `wp_options` VALUES("108351", "ossdl_cname", "", "yes");
INSERT INTO `wp_options` VALUES("106923", "wphb-last-report-score", "a:1:{s:5:\"score\";i:63;}", "no");
INSERT INTO `wp_options` VALUES("136360", "wphb-caching-data", "a:4:{s:10:\"javascript\";b:0;s:3:\"css\";b:0;s:5:\"media\";b:0;s:6:\"images\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("108355", "wpsupercache_start", "1498343066", "yes");
INSERT INTO `wp_options` VALUES("108356", "wpsupercache_count", "0", "yes");
INSERT INTO `wp_options` VALUES("107299", "smush_global_stats", "a:9:{s:11:\"size_before\";i:89168292;s:10:\"size_after\";i:46101759;s:7:\"percent\";d:48.2999999999999971578290569595992565155029296875;s:5:\"human\";s:7:\"41.1 MB\";s:5:\"bytes\";i:43066533;s:12:\"total_images\";i:1785;s:12:\"resize_count\";i:0;s:14:\"resize_savings\";i:0;s:18:\"conversion_savings\";i:0;}", "no");
INSERT INTO `wp_options` VALUES("107637", "wphb_styles_collection", "a:13:{s:25:\"advanced-floating-content\";a:6:{s:6:\"handle\";s:25:\"advanced-floating-content\";s:3:\"src\";s:133:\"http://67.23.236.217/~windriftmotel/wp-content/plugins/advanced-floating-content-lite/public/css/advanced-floating-content-public.css\";s:4:\"deps\";a:0:{}s:3:\"ver\";s:5:\"1.0.0\";s:4:\"args\";s:3:\"all\";s:5:\"extra\";a:0:{}}s:12:\"bwg_frontend\";a:6:{s:6:\"handle\";s:12:\"bwg_frontend\";s:3:\"src\";s:89:\"http://67.23.236.217/~windriftmotel/wp-content/plugins/photo-gallery/css/bwg_frontend.css\";s:4:\"deps\";a:0:{}s:3:\"ver\";s:6:\"1.3.45\";s:4:\"args\";s:3:\"all\";s:5:\"extra\";a:0:{}}s:16:\"bwg_font-awesome\";a:6:{s:6:\"handle\";s:16:\"bwg_font-awesome\";s:3:\"src\";s:102:\"http://67.23.236.217/~windriftmotel/wp-content/plugins/photo-gallery/css/font-awesome/font-awesome.css\";s:4:\"deps\";a:0:{}s:3:\"ver\";s:5:\"4.6.3\";s:4:\"args\";s:3:\"all\";s:5:\"extra\";a:0:{}}s:20:\"bwg_mCustomScrollbar\";a:6:{s:6:\"handle\";s:20:\"bwg_mCustomScrollbar\";s:3:\"src\";s:100:\"http://67.23.236.217/~windriftmotel/wp-content/plugins/photo-gallery/css/jquery.mCustomScrollbar.css\";s:4:\"deps\";a:0:{}s:3:\"ver\";s:6:\"1.3.45\";s:4:\"args\";s:3:\"all\";s:5:\"extra\";a:0:{}}s:14:\"bwg_sumoselect\";a:6:{s:6:\"handle\";s:14:\"bwg_sumoselect\";s:3:\"src\";s:87:\"http://67.23.236.217/~windriftmotel/wp-content/plugins/photo-gallery/css/sumoselect.css\";s:4:\"deps\";a:0:{}s:3:\"ver\";s:5:\"3.0.2\";s:4:\"args\";s:3:\"all\";s:5:\"extra\";a:0:{}}s:8:\"slb_core\";a:6:{s:6:\"handle\";s:8:\"slb_core\";s:3:\"src\";s:54:\"/wp-content/plugins/simple-lightbox/client/css/app.css\";s:4:\"deps\";a:0:{}s:3:\"ver\";s:5:\"2.6.0\";s:4:\"args\";s:3:\"all\";s:5:\"extra\";a:0:{}}s:13:\"tempera-fonts\";a:6:{s:6:\"handle\";s:13:\"tempera-fonts\";s:3:\"src\";s:81:\"http://67.23.236.217/~windriftmotel/wp-content/themes/tempera/fonts/fontfaces.css\";s:4:\"deps\";a:0:{}s:3:\"ver\";s:5:\"1.6.2\";s:4:\"args\";s:3:\"all\";s:5:\"extra\";a:0:{}}s:13:\"tempera-style\";a:6:{s:6:\"handle\";s:13:\"tempera-style\";s:3:\"src\";s:80:\"http://67.23.236.217/~windriftmotel/wp-content/themes/tempera-nocopyrt/style.css\";s:4:\"deps\";a:0:{}s:3:\"ver\";s:5:\"1.6.2\";s:4:\"args\";s:3:\"all\";s:5:\"extra\";a:0:{}}s:14:\"addthis_output\";a:6:{s:6:\"handle\";s:14:\"addthis_output\";s:3:\"src\";s:77:\"http://67.23.236.217/~windriftmotel/wp-content/plugins/addthis/css/output.css\";s:4:\"deps\";a:0:{}s:3:\"ver\";b:0;s:4:\"args\";s:3:\"all\";s:5:\"extra\";a:0:{}}s:9:\"dashicons\";a:6:{s:6:\"handle\";s:9:\"dashicons\";s:3:\"src\";s:34:\"/wp-includes/css/dashicons.min.css\";s:4:\"deps\";a:0:{}s:3:\"ver\";b:0;s:4:\"args\";N;s:5:\"extra\";a:0:{}}s:9:\"admin-bar\";a:6:{s:6:\"handle\";s:9:\"admin-bar\";s:3:\"src\";s:34:\"/wp-includes/css/admin-bar.min.css\";s:4:\"deps\";a:1:{i:0;s:9:\"dashicons\";}s:3:\"ver\";b:0;s:4:\"args\";N;s:5:\"extra\";a:2:{s:3:\"rtl\";s:7:\"replace\";s:6:\"suffix\";s:4:\".min\";}}s:16:\"wordfenceAJAXcss\";a:6:{s:6:\"handle\";s:16:\"wordfenceAJAXcss\";s:3:\"src\";s:85:\"http://67.23.236.217/~windriftmotel/wp-content/plugins/wordfence/css/wordfenceBox.css\";s:4:\"deps\";a:0:{}s:3:\"ver\";s:6:\"6.3.20\";s:4:\"args\";s:3:\"all\";s:5:\"extra\";a:0:{}}s:18:\"yoast-seo-adminbar\";a:6:{s:6:\"handle\";s:18:\"yoast-seo-adminbar\";s:3:\"src\";s:98:\"http://67.23.236.217/~windriftmotel/wp-content/plugins/wordpress-seo/css/dist/adminbar-561.min.css\";s:4:\"deps\";a:0:{}s:3:\"ver\";s:5:\"5.6.1\";s:4:\"args\";s:3:\"all\";s:5:\"extra\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("107638", "wphb_scripts_collection", "a:22:{s:11:\"jquery-core\";a:6:{s:6:\"handle\";s:11:\"jquery-core\";s:3:\"src\";s:32:\"/wp-includes/js/jquery/jquery.js\";s:4:\"deps\";a:0:{}s:3:\"ver\";s:6:\"1.12.4\";s:4:\"args\";N;s:5:\"extra\";a:0:{}}s:14:\"jquery-migrate\";a:6:{s:6:\"handle\";s:14:\"jquery-migrate\";s:3:\"src\";s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";s:4:\"deps\";a:0:{}s:3:\"ver\";s:5:\"1.4.1\";s:4:\"args\";N;s:5:\"extra\";a:0:{}}s:16:\"cryout_ajax_more\";a:6:{s:6:\"handle\";s:16:\"cryout_ajax_more\";s:3:\"src\";s:72:\"http://67.23.236.217/~windriftmotel/wp-content/themes/tempera/js/ajax.js\";s:4:\"deps\";a:1:{i:0;s:6:\"jquery\";}s:3:\"ver\";s:5:\"1.6.2\";s:4:\"args\";N;s:5:\"extra\";a:2:{s:5:\"group\";i:1;s:4:\"data\";s:262:\"var cryout_ajax_more = {\"page_number_next\":\"2\",\"page_number_max\":\"0\",\"page_link_model\":\"http:\\/\\/67.23.236.217\\/~windriftmotel\\/page\\/9999999\\/\",\"load_more_str\":\"More Posts\",\"content_css_selector\":\"#content\",\"pagination_css_selector\":\".pagination, .navigation\"};\";}}s:25:\"advanced-floating-content\";a:6:{s:6:\"handle\";s:25:\"advanced-floating-content\";s:3:\"src\";s:131:\"http://67.23.236.217/~windriftmotel/wp-content/plugins/advanced-floating-content-lite/public/js/advanced-floating-content-public.js\";s:4:\"deps\";a:1:{i:0;s:6:\"jquery\";}s:3:\"ver\";s:5:\"1.0.0\";s:4:\"args\";N;s:5:\"extra\";a:0:{}}s:12:\"bwg_frontend\";a:6:{s:6:\"handle\";s:12:\"bwg_frontend\";s:3:\"src\";s:87:\"http://67.23.236.217/~windriftmotel/wp-content/plugins/photo-gallery/js/bwg_frontend.js\";s:4:\"deps\";a:1:{i:0;s:6:\"jquery\";}s:3:\"ver\";s:6:\"1.3.45\";s:4:\"args\";N;s:5:\"extra\";a:0:{}}s:14:\"bwg_sumoselect\";a:6:{s:6:\"handle\";s:14:\"bwg_sumoselect\";s:3:\"src\";s:96:\"http://67.23.236.217/~windriftmotel/wp-content/plugins/photo-gallery/js/jquery.sumoselect.min.js\";s:4:\"deps\";a:1:{i:0;s:6:\"jquery\";}s:3:\"ver\";s:5:\"3.0.2\";s:4:\"args\";N;s:5:\"extra\";a:1:{s:4:\"data\";s:76:\"var bwg_objectsL10n = {\"bwg_select_tag\":\"Select Tag\",\"bwg_search\":\"Search\"};\";}}s:17:\"bwg_jquery_mobile\";a:6:{s:6:\"handle\";s:17:\"bwg_jquery_mobile\";s:3:\"src\";s:88:\"http://67.23.236.217/~windriftmotel/wp-content/plugins/photo-gallery/js/jquery.mobile.js\";s:4:\"deps\";a:1:{i:0;s:6:\"jquery\";}s:3:\"ver\";s:6:\"1.3.45\";s:4:\"args\";N;s:5:\"extra\";a:0:{}}s:20:\"bwg_mCustomScrollbar\";a:6:{s:6:\"handle\";s:20:\"bwg_mCustomScrollbar\";s:3:\"src\";s:109:\"http://67.23.236.217/~windriftmotel/wp-content/plugins/photo-gallery/js/jquery.mCustomScrollbar.concat.min.js\";s:4:\"deps\";a:1:{i:0;s:6:\"jquery\";}s:3:\"ver\";s:6:\"1.3.45\";s:4:\"args\";N;s:5:\"extra\";a:0:{}}s:17:\"jquery-fullscreen\";a:6:{s:6:\"handle\";s:17:\"jquery-fullscreen\";s:3:\"src\";s:98:\"http://67.23.236.217/~windriftmotel/wp-content/plugins/photo-gallery/js/jquery.fullscreen-0.4.1.js\";s:4:\"deps\";a:1:{i:0;s:6:\"jquery\";}s:3:\"ver\";s:5:\"0.4.1\";s:4:\"args\";N;s:5:\"extra\";a:0:{}}s:15:\"bwg_gallery_box\";a:6:{s:6:\"handle\";s:15:\"bwg_gallery_box\";s:3:\"src\";s:90:\"http://67.23.236.217/~windriftmotel/wp-content/plugins/photo-gallery/js/bwg_gallery_box.js\";s:4:\"deps\";a:1:{i:0;s:6:\"jquery\";}s:3:\"ver\";s:6:\"1.3.45\";s:4:\"args\";N;s:5:\"extra\";a:1:{s:4:\"data\";s:188:\"var bwg_objectL10n = {\"bwg_field_required\":\"field is required.\",\"bwg_mail_validation\":\"This is not a valid email address.\",\"bwg_search_result\":\"There are no images matching your search.\"};\";}}s:16:\"tempera-frontend\";a:6:{s:6:\"handle\";s:16:\"tempera-frontend\";s:3:\"src\";s:76:\"http://67.23.236.217/~windriftmotel/wp-content/themes/tempera/js/frontend.js\";s:4:\"deps\";a:1:{i:0;s:6:\"jquery\";}s:3:\"ver\";s:5:\"1.6.2\";s:4:\"args\";N;s:5:\"extra\";a:2:{s:5:\"group\";i:1;s:4:\"data\";s:52:\"var tempera_settings = {\"mobile\":\"1\",\"fitvids\":\"1\"};\";}}s:18:\"tempera-nivoslider\";a:6:{s:6:\"handle\";s:18:\"tempera-nivoslider\";s:3:\"src\";s:83:\"http://67.23.236.217/~windriftmotel/wp-content/themes/tempera/js/nivo.slider.min.js\";s:4:\"deps\";a:1:{i:0;s:6:\"jquery\";}s:3:\"ver\";s:5:\"1.6.2\";s:4:\"args\";N;s:5:\"extra\";a:1:{s:5:\"group\";i:1;}}s:8:\"wp-embed\";a:6:{s:6:\"handle\";s:8:\"wp-embed\";s:3:\"src\";s:31:\"/wp-includes/js/wp-embed.min.js\";s:4:\"deps\";a:0:{}s:3:\"ver\";b:0;s:4:\"args\";N;s:5:\"extra\";a:0:{}}s:9:\"admin-bar\";a:6:{s:6:\"handle\";s:9:\"admin-bar\";s:3:\"src\";s:32:\"/wp-includes/js/admin-bar.min.js\";s:4:\"deps\";a:0:{}s:3:\"ver\";b:0;s:4:\"args\";i:1;s:5:\"extra\";a:0:{}}s:15:\"wordfenceAJAXjs\";a:6:{s:6:\"handle\";s:15:\"wordfenceAJAXjs\";s:3:\"src\";s:88:\"http://67.23.236.217/~windriftmotel/wp-content/plugins/wordfence/js/admin.ajaxWatcher.js\";s:4:\"deps\";a:1:{i:0;s:6:\"jquery\";}s:3:\"ver\";s:6:\"6.3.20\";s:4:\"args\";N;s:5:\"extra\";a:0:{}}s:8:\"slb_core\";a:6:{s:6:\"handle\";s:8:\"slb_core\";s:3:\"src\";s:62:\"/wp-content/plugins/simple-lightbox/client/js/prod/lib.core.js\";s:4:\"deps\";a:1:{i:0;s:6:\"jquery\";}s:3:\"ver\";s:5:\"2.6.0\";s:4:\"args\";N;s:5:\"extra\";a:1:{s:5:\"group\";i:1;}}s:8:\"slb_view\";a:6:{s:6:\"handle\";s:8:\"slb_view\";s:3:\"src\";s:62:\"/wp-content/plugins/simple-lightbox/client/js/prod/lib.view.js\";s:4:\"deps\";a:1:{i:0;s:8:\"slb_core\";}s:3:\"ver\";s:5:\"2.6.0\";s:4:\"args\";N;s:5:\"extra\";a:1:{s:5:\"group\";i:1;}}s:27:\"slb-asset-slb_baseline-base\";a:6:{s:6:\"handle\";s:27:\"slb-asset-slb_baseline-base\";s:3:\"src\";s:69:\"/wp-content/plugins/simple-lightbox/themes/baseline/js/prod/client.js\";s:4:\"deps\";a:0:{}s:3:\"ver\";s:5:\"2.6.0\";s:4:\"args\";N;s:5:\"extra\";a:1:{s:5:\"group\";i:1;}}s:26:\"slb-asset-slb_default-base\";a:6:{s:6:\"handle\";s:26:\"slb-asset-slb_default-base\";s:3:\"src\";s:68:\"/wp-content/plugins/simple-lightbox/themes/default/js/prod/client.js\";s:4:\"deps\";a:0:{}s:3:\"ver\";s:5:\"2.6.0\";s:4:\"args\";N;s:5:\"extra\";a:1:{s:5:\"group\";i:1;}}s:19:\"slb-asset-item-base\";a:6:{s:6:\"handle\";s:19:\"slb-asset-item-base\";s:3:\"src\";s:74:\"/wp-content/plugins/simple-lightbox/template-tags/item/js/prod/tag.item.js\";s:4:\"deps\";a:0:{}s:3:\"ver\";s:5:\"2.6.0\";s:4:\"args\";N;s:5:\"extra\";a:1:{s:5:\"group\";i:1;}}s:17:\"slb-asset-ui-base\";a:6:{s:6:\"handle\";s:17:\"slb-asset-ui-base\";s:3:\"src\";s:70:\"/wp-content/plugins/simple-lightbox/template-tags/ui/js/prod/tag.ui.js\";s:4:\"deps\";a:0:{}s:3:\"ver\";s:5:\"2.6.0\";s:4:\"args\";N;s:5:\"extra\";a:1:{s:5:\"group\";i:1;}}s:20:\"slb-asset-image-base\";a:6:{s:6:\"handle\";s:20:\"slb-asset-image-base\";s:3:\"src\";s:83:\"/wp-content/plugins/simple-lightbox/content-handlers/image/js/prod/handler.image.js\";s:4:\"deps\";a:0:{}s:3:\"ver\";s:5:\"2.6.0\";s:4:\"args\";N;s:5:\"extra\";a:1:{s:5:\"group\";i:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("107643", "wphb-minification-errors", "a:2:{s:7:\"scripts\";a:4:{s:6:\"jquery\";a:3:{s:4:\"code\";s:9:\"empty-url\";s:5:\"error\";s:64:\"This file has not a linked URL, it will not be combined/minified\";s:7:\"disable\";a:2:{i:0;s:6:\"minify\";i:1;s:7:\"combine\";}}s:18:\"tempera-nivoslider\";a:3:{s:4:\"code\";s:13:\"empty-content\";s:5:\"error\";s:32:\"It looks like this file is empty\";s:7:\"disable\";a:0:{}}s:16:\"tempera-frontend\";a:3:{s:4:\"code\";s:13:\"empty-content\";s:5:\"error\";s:32:\"It looks like this file is empty\";s:7:\"disable\";a:0:{}}s:16:\"cryout_ajax_more\";a:3:{s:4:\"code\";s:13:\"empty-content\";s:5:\"error\";s:32:\"It looks like this file is empty\";s:7:\"disable\";a:0:{}}}s:6:\"styles\";a:1:{s:13:\"tempera-style\";a:3:{s:4:\"code\";s:18:\"import-not-allowed\";s:5:\"error\";s:47:\"@import directive is not allowed in stylesheets\";s:7:\"disable\";a:2:{i:0;s:6:\"minify\";i:1;s:7:\"combine\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("136448", "wds-model-service-seo-progress", "", "yes");
INSERT INTO `wp_options` VALUES("136449", "wds-model-service-seo-service-result", "a:6:{s:5:\"start\";i:0;s:3:\"end\";i:1524016474;s:4:\"sync\";i:1524016474;s:5:\"total\";i:0;s:10:\"percentage\";i:0;s:6:\"issues\";a:3:{s:8:\"previous\";a:0:{}s:8:\"messages\";a:1:{i:0;s:90:\"Your SEO crawl has timed out due to an unknown error. Please try again or contact support.\";}s:6:\"issues\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("136450", "wds-model-service-seo-service-last_runtime", "1524016474", "yes");
INSERT INTO `wp_options` VALUES("134732", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("119397", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("121104", "wp-smush-install-type", "new", "no");
INSERT INTO `wp_options` VALUES("134554", "wdp_un_hub_nonce", "1606939045.9024", "no");
INSERT INTO `wp_options` VALUES("125879", "ossdl_off_blog_url", "http://67.23.236.217/~windriftmotel", "yes");
INSERT INTO `wp_options` VALUES("132406", "wdp_un_autoupdate_schedule", "a:486:{i:0;i:119;i:1;i:119;i:2;i:119;i:3;i:119;i:4;i:119;i:5;i:119;i:6;i:119;i:7;i:119;i:8;i:119;i:9;i:119;i:10;i:119;i:11;i:119;i:12;i:119;i:13;i:119;i:14;i:119;i:15;i:119;i:16;i:119;i:17;i:119;i:18;i:119;i:19;i:119;i:20;i:119;i:21;i:119;i:22;i:119;i:23;i:119;i:24;i:119;i:25;i:119;i:26;i:119;i:27;i:119;i:28;i:119;i:29;i:119;i:30;i:119;i:31;i:119;i:32;i:119;i:33;i:119;i:34;i:119;i:35;i:119;i:36;i:119;i:37;i:119;i:38;i:119;i:39;i:119;i:40;i:119;i:41;i:119;i:42;i:119;i:43;i:119;i:44;i:119;i:45;i:119;i:46;i:119;i:47;i:119;i:48;i:119;i:49;i:119;i:50;i:119;i:51;i:119;i:52;i:119;i:53;i:119;i:54;i:119;i:55;i:119;i:56;i:119;i:57;i:119;i:58;i:119;i:59;i:119;i:60;i:119;i:61;i:119;i:62;i:119;i:63;i:119;i:64;i:119;i:65;i:119;i:66;i:119;i:67;i:119;i:68;i:119;i:69;i:119;i:70;i:119;i:71;i:119;i:72;i:119;i:73;i:119;i:74;i:119;i:75;i:119;i:76;i:119;i:77;i:119;i:78;i:119;i:79;i:119;i:80;i:119;i:81;i:119;i:82;i:119;i:83;i:119;i:84;i:119;i:85;i:119;i:86;i:119;i:87;i:119;i:88;i:119;i:89;i:119;i:90;i:119;i:91;i:119;i:92;i:119;i:93;i:119;i:94;i:119;i:95;i:119;i:96;i:119;i:97;i:119;i:98;i:119;i:99;i:119;i:100;i:119;i:101;i:119;i:102;i:119;i:103;i:119;i:104;i:119;i:105;i:119;i:106;i:119;i:107;i:119;i:108;i:119;i:109;i:119;i:110;i:119;i:111;i:119;i:112;i:119;i:113;i:119;i:114;i:119;i:115;i:119;i:116;i:119;i:117;i:119;i:118;i:119;i:119;i:119;i:120;i:119;i:121;i:119;i:122;i:119;i:123;i:119;i:124;i:119;i:125;i:119;i:126;i:119;i:127;i:119;i:128;i:119;i:129;i:119;i:130;i:119;i:131;i:119;i:132;i:119;i:133;i:119;i:134;i:119;i:135;i:119;i:136;i:119;i:137;i:119;i:138;i:119;i:139;i:119;i:140;i:119;i:141;i:119;i:142;i:119;i:143;i:119;i:144;i:119;i:145;i:119;i:146;i:119;i:147;i:119;i:148;i:119;i:149;i:119;i:150;i:119;i:151;i:119;i:152;i:119;i:153;i:119;i:154;i:119;i:155;i:119;i:156;i:119;i:157;i:119;i:158;i:119;i:159;i:119;i:160;i:119;i:161;i:119;i:162;i:119;i:163;i:119;i:164;i:119;i:165;i:119;i:166;i:119;i:167;i:119;i:168;i:119;i:169;i:119;i:170;i:119;i:171;i:119;i:172;i:119;i:173;i:119;i:174;i:119;i:175;i:119;i:176;i:119;i:177;i:119;i:178;i:119;i:179;i:119;i:180;i:119;i:181;i:119;i:182;i:119;i:183;i:119;i:184;i:119;i:185;i:119;i:186;i:119;i:187;i:119;i:188;i:119;i:189;i:119;i:190;i:119;i:191;i:119;i:192;i:119;i:193;i:119;i:194;i:119;i:195;i:119;i:196;i:119;i:197;i:119;i:198;i:119;i:199;i:119;i:200;i:119;i:201;i:119;i:202;i:119;i:203;i:119;i:204;i:119;i:205;i:119;i:206;i:119;i:207;i:119;i:208;i:119;i:209;i:119;i:210;i:119;i:211;i:119;i:212;i:119;i:213;i:119;i:214;i:119;i:215;i:119;i:216;i:119;i:217;i:119;i:218;i:119;i:219;i:119;i:220;i:119;i:221;i:119;i:222;i:119;i:223;i:119;i:224;i:119;i:225;i:119;i:226;i:119;i:227;i:119;i:228;i:119;i:229;i:119;i:230;i:119;i:231;i:119;i:232;i:119;i:233;i:119;i:234;i:119;i:235;i:119;i:236;i:119;i:237;i:119;i:238;i:119;i:239;i:119;i:240;i:119;i:241;i:119;i:242;i:119;i:243;i:119;i:244;i:119;i:245;i:119;i:246;i:119;i:247;i:119;i:248;i:119;i:249;i:119;i:250;i:119;i:251;i:119;i:252;i:119;i:253;i:119;i:254;i:119;i:255;i:119;i:256;i:119;i:257;i:119;i:258;i:119;i:259;i:119;i:260;i:119;i:261;i:119;i:262;i:119;i:263;i:119;i:264;i:119;i:265;i:119;i:266;i:119;i:267;i:119;i:268;i:119;i:269;i:119;i:270;i:119;i:271;i:119;i:272;i:119;i:273;i:119;i:274;i:119;i:275;i:119;i:276;i:119;i:277;i:119;i:278;i:119;i:279;i:119;i:280;i:119;i:281;i:119;i:282;i:119;i:283;i:119;i:284;i:119;i:285;i:119;i:286;i:119;i:287;i:119;i:288;i:119;i:289;i:119;i:290;i:119;i:291;i:119;i:292;i:119;i:293;i:119;i:294;i:119;i:295;i:119;i:296;i:119;i:297;i:119;i:298;i:119;i:299;i:119;i:300;i:119;i:301;i:119;i:302;i:119;i:303;i:119;i:304;i:119;i:305;i:119;i:306;i:119;i:307;i:119;i:308;i:119;i:309;i:119;i:310;i:119;i:311;i:119;i:312;i:119;i:313;i:119;i:314;i:119;i:315;i:119;i:316;i:119;i:317;i:119;i:318;i:119;i:319;i:119;i:320;i:119;i:321;i:119;i:322;i:119;i:323;i:119;i:324;i:119;i:325;i:119;i:326;i:119;i:327;i:119;i:328;i:119;i:329;i:119;i:330;i:119;i:331;i:119;i:332;i:119;i:333;i:119;i:334;i:119;i:335;i:119;i:336;i:119;i:337;i:119;i:338;i:119;i:339;i:119;i:340;i:119;i:341;i:119;i:342;i:119;i:343;i:119;i:344;i:119;i:345;i:119;i:346;i:119;i:347;i:119;i:348;i:119;i:349;i:119;i:350;i:119;i:351;i:119;i:352;i:119;i:353;i:119;i:354;i:119;i:355;i:119;i:356;i:119;i:357;i:119;i:358;i:119;i:359;i:119;i:360;i:119;i:361;i:119;i:362;i:119;i:363;i:119;i:364;i:119;i:365;i:119;i:366;i:119;i:367;i:119;i:368;i:119;i:369;i:119;i:370;i:119;i:371;i:119;i:372;i:119;i:373;i:119;i:374;i:119;i:375;i:119;i:376;i:119;i:377;i:119;i:378;i:119;i:379;i:119;i:380;i:119;i:381;i:119;i:382;i:119;i:383;i:119;i:384;i:119;i:385;i:119;i:386;i:119;i:387;i:119;i:388;i:119;i:389;i:119;i:390;i:119;i:391;i:119;i:392;i:119;i:393;i:119;i:394;i:119;i:395;i:119;i:396;i:119;i:397;i:119;i:398;i:119;i:399;i:119;i:400;i:119;i:401;i:119;i:402;i:119;i:403;i:119;i:404;i:119;i:405;i:119;i:406;i:119;i:407;i:119;i:408;i:119;i:409;i:119;i:410;i:119;i:411;i:119;i:412;i:119;i:413;i:119;i:414;i:119;i:415;i:119;i:416;i:119;i:417;i:119;i:418;i:119;i:419;i:119;i:420;i:119;i:421;i:119;i:422;i:119;i:423;i:119;i:424;i:119;i:425;i:119;i:426;i:119;i:427;i:119;i:428;i:119;i:429;i:119;i:430;i:119;i:431;i:119;i:432;i:119;i:433;i:119;i:434;i:119;i:435;i:119;i:436;i:119;i:437;i:119;i:438;i:119;i:439;i:119;i:440;i:119;i:441;i:119;i:442;i:119;i:443;i:119;i:444;i:119;i:445;i:119;i:446;i:119;i:447;i:119;i:448;i:119;i:449;i:119;i:450;i:119;i:451;i:119;i:452;i:119;i:453;i:119;i:454;i:119;i:455;i:119;i:456;i:119;i:457;i:119;i:458;i:119;i:459;i:119;i:460;i:119;i:461;i:119;i:462;i:119;i:463;i:119;i:464;i:119;i:465;i:119;i:466;i:119;i:467;i:119;i:468;i:119;i:469;i:119;i:470;i:119;i:471;i:119;i:472;i:119;i:473;i:119;i:474;i:119;i:475;i:119;i:476;i:119;i:477;i:119;i:478;i:119;i:479;i:119;i:480;i:119;i:481;i:119;i:482;i:119;i:483;i:119;i:484;i:119;i:485;i:119;}", "no");
INSERT INTO `wp_options` VALUES("135792", "wdp_un_refresh_profile_flag", "0", "no");
INSERT INTO `wp_options` VALUES("136124", "wpseo-gsc", "a:1:{s:7:\"profile\";s:34:\"https://www.econolodgeloon.com/wp/\";}", "yes");
INSERT INTO `wp_options` VALUES("136127", "wpseo_gsc_issues_counts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("152495", "wpseo_gsc_last_fetch", "1539464276", "no");
INSERT INTO `wp_options` VALUES("136342", "wd_db_version", "2.4.3", "no");
INSERT INTO `wp_options` VALUES("136343", "defenderLockoutNeedUpdateLog", "1", "no");
INSERT INTO `wp_options` VALUES("136355", "wpmudev_snapshot", "a:5:{s:5:\"items\";a:0:{}s:6:\"config\";a:8:{s:11:\"segmentSize\";i:1000;s:11:\"memoryLimit\";s:4:\"256M\";s:14:\"errorReporting\";a:3:{i:1;a:2:{s:4:\"stop\";b:1;s:3:\"log\";b:1;}i:2;a:1:{s:3:\"log\";b:1;}i:8;a:1:{s:3:\"log\";b:1;}}s:10:\"zipLibrary\";s:10:\"ZipArchive\";s:14:\"absoluteFolder\";b:0;s:12:\"backupFolder\";s:9:\"snapshots\";s:11:\"tables_last\";a:0:{}s:4:\"full\";a:4:{s:6:\"active\";b:0;s:9:\"frequency\";b:0;s:13:\"schedule_time\";b:0;s:10:\"secret-key\";b:0;}}s:12:\"destinations\";a:1:{s:5:\"local\";a:2:{s:4:\"name\";s:14:\"Local Snapshot\";s:4:\"type\";s:5:\"local\";}}s:7:\"version\";s:5:\"3.3.0\";s:16:\"transitioned_sdk\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("136860", "wd_audit_settings", "{\"enabled\":false,\"storage_days\":\"6 months\"}", "no");
INSERT INTO `wp_options` VALUES("258043", "wd_audit_report", "{\"title\":\"Audit Logging - Reporting\",\"slug\":\"audit-report\",\"description\":\"Schedule Defender to automatically email you a summary of all your website events.\",\"status\":\"disabled\",\"type\":\"report\",\"frequency\":\"weekly\",\"day\":\"sunday\",\"day_n\":\"1\",\"time\":\"4:00\",\"in_house_recipients\":[{\"name\":\"Guest\",\"id\":\"0\",\"email\":\"Guest\",\"role\":\"\",\"avatar\":\"https:\\/\\/secure.gravatar.com\\/avatar\\/084e0343a0486ff05530df6c705c8bb4?s=96&d=mm&r=g\",\"status\":\"subscribed\"}],\"out_house_recipients\":[],\"dry_run\":false,\"configs\":[],\"last_sent\":1606245056,\"est_timestamp\":0,\"next_run\":\"Never\",\"all_subscribers\":[{\"name\":\"Guest\",\"id\":\"0\",\"email\":\"Guest\",\"role\":\"\",\"avatar\":\"https:\\/\\/secure.gravatar.com\\/avatar\\/084e0343a0486ff05530df6c705c8bb4?s=96&d=mm&r=g\",\"status\":\"subscribed\"}]}", "no");
INSERT INTO `wp_options` VALUES("136083", "new_admin_email", "info@touristmarketing.com", "yes");
INSERT INTO `wp_options` VALUES("154607", "wp_page_for_privacy_policy", "0", "yes");
INSERT INTO `wp_options` VALUES("154608", "show_comments_cookies_opt_in", "0", "yes");
INSERT INTO `wp_options` VALUES("197899", "defender_last_settings", "a:5:{s:14:\"2.0_1571084019\";a:6:{s:15:\"security_tweaks\";a:3:{s:12:\"notification\";b:0;s:19:\"notification_repeat\";b:0;s:8:\"receipts\";a:0:{}}s:4:\"scan\";a:16:{s:9:\"scan_core\";b:1;s:9:\"scan_vuln\";b:1;s:12:\"scan_content\";b:1;s:10:\"recipients\";a:0:{}s:23:\"recipients_notification\";a:0:{}s:12:\"notification\";b:1;s:6:\"report\";b:0;s:11:\"always_send\";b:0;s:24:\"always_send_notification\";b:0;s:12:\"max_filesize\";i:1;s:13:\"email_subject\";s:57:\"Scan of {SITE_URL} complete. {ISSUES_COUNT} issues found.\";s:15:\"email_has_issue\";s:268:\"Hi {USER_NAME},\r\n\r\nWP Defender here, reporting back from the front.\r\n\r\nI\'ve finished scanning {SITE_URL} for vulnerabilities and I found {ISSUES_COUNT} issues that you should take a closer look at!\r\n{ISSUES_LIST}\r\n\r\nStay Safe,\r\nWP Defender\r\nOfficial WPMU DEV Superhero\";s:12:\"email_all_ok\";s:350:\"Hi {USER_NAME},\r\n\r\nWP Defender here, reporting back from the front.\r\n\r\nI\'ve finished scanning {SITE_URL} for vulnerabilities and I found nothing. Well done for running such a tight ship!\r\n\r\nKeep up the good work! With regular security scans and a well-hardened installation you\'ll be just fine.\r\n\r\nStay safe,\r\nWP Defender\r\nOfficial WPMU DEV Superhero\";s:9:\"frequency\";s:1:\"7\";s:3:\"day\";s:6:\"sunday\";s:4:\"time\";s:4:\"4:00\";}s:9:\"iplockout\";a:38:{s:16:\"login_protection\";b:0;s:30:\"login_protection_login_attempt\";i:5;s:34:\"login_protection_lockout_timeframe\";i:300;s:33:\"login_protection_lockout_duration\";i:300;s:38:\"login_protection_lockout_duration_unit\";s:7:\"seconds\";s:32:\"login_protection_lockout_message\";s:64:\"You have been locked out due to too many invalid login attempts.\";s:28:\"login_protection_lockout_ban\";b:0;s:18:\"username_blacklist\";s:0:\"\";s:10:\"detect_404\";b:0;s:20:\"detect_404_threshold\";i:20;s:20:\"detect_404_timeframe\";i:300;s:27:\"detect_404_lockout_duration\";i:300;s:32:\"detect_404_lockout_duration_unit\";s:7:\"seconds\";s:20:\"detect_404_whitelist\";s:0:\"\";s:20:\"detect_404_blacklist\";s:0:\"\";s:28:\"detect_404_ignored_filetypes\";s:0:\"\";s:30:\"detect_404_filetypes_blacklist\";s:0:\"\";s:26:\"detect_404_lockout_message\";s:86:\"You have been locked out due to too many attempts to access a file that doesn\'t exist.\";s:22:\"detect_404_lockout_ban\";b:0;s:17:\"detect_404_logged\";b:1;s:12:\"ip_blacklist\";a:0:{}s:12:\"ip_whitelist\";a:0:{}s:18:\"ip_lockout_message\";s:66:\"The administrator has blocked your IP from accessing this website.\";s:17:\"country_blacklist\";a:0:{}s:17:\"country_whitelist\";a:0:{}s:26:\"login_lockout_notification\";b:0;s:23:\"ip_lockout_notification\";b:0;s:6:\"report\";b:0;s:16:\"report_frequency\";s:1:\"7\";s:10:\"report_day\";s:6:\"sunday\";s:11:\"report_time\";s:4:\"0:00\";s:8:\"geoIP_db\";s:0:\"\";s:12:\"storage_days\";i:30;s:8:\"receipts\";a:0:{}s:15:\"report_receipts\";a:0:{}s:16:\"cooldown_enabled\";b:0;s:23:\"cooldown_number_lockout\";s:1:\"3\";s:15:\"cooldown_period\";s:2:\"24\";}s:14:\"advanced_tools\";a:2:{s:10:\"two_factor\";a:11:{s:7:\"enabled\";b:0;s:10:\"lost_phone\";b:1;s:10:\"force_auth\";b:0;s:15:\"force_auth_mess\";s:69:\"You are required to setup two-factor authentication to use this site.\";s:10:\"user_roles\";a:6:{i:0;s:13:\"administrator\";i:1;s:6:\"editor\";i:2;s:6:\"author\";i:3;s:11:\"contributor\";i:5;s:13:\"wpseo_manager\";i:6;s:12:\"wpseo_editor\";}s:16:\"force_auth_roles\";a:0:{}s:14:\"custom_graphic\";b:0;s:18:\"custom_graphic_url\";s:93:\"https://www.econolodgeloon.com/wp-content/plugins/wp-defender/assets/img/2factor-disabled.svg\";s:13:\"email_subject\";s:13:\"Your OTP code\";s:12:\"email_sender\";s:5:\"admin\";s:10:\"email_body\";s:210:\"Hi {{display_name}},\r\n\r\nYour temporary login passcode is <strong>{{passcode}}</strong>.\r\n\r\nCopy and paste the passcode into the input field on the login screen to complete logging in.\r\n\r\nRegards,\r\nAdministrator\";}s:10:\"mask_login\";a:4:{s:8:\"mask_url\";s:0:\"\";s:16:\"redirect_traffic\";b:0;s:20:\"redirect_traffic_url\";s:0:\"\";s:7:\"enabled\";b:0;}}s:8:\"settings\";a:5:{s:9:\"translate\";s:7:\"English\";s:14:\"usage_tracking\";b:0;s:14:\"uninstall_data\";s:6:\"remove\";s:18:\"uninstall_settings\";s:5:\"reset\";s:18:\"high_contrast_mode\";b:0;}s:5:\"audit\";a:6:{s:9:\"frequency\";s:1:\"7\";s:3:\"day\";s:6:\"sunday\";s:4:\"time\";s:4:\"0:00\";s:12:\"notification\";b:0;s:8:\"receipts\";a:0:{}s:12:\"storage_days\";s:8:\"6 months\";}}s:16:\"2.2.1_1588622917\";a:6:{s:15:\"security_tweaks\";a:3:{s:12:\"notification\";b:0;s:19:\"notification_repeat\";b:0;s:8:\"receipts\";a:0:{}}s:4:\"scan\";a:17:{s:9:\"scan_core\";b:1;s:9:\"scan_vuln\";b:1;s:12:\"scan_content\";b:1;s:10:\"recipients\";a:0:{}s:23:\"recipients_notification\";a:0:{}s:12:\"notification\";b:0;s:6:\"report\";b:0;s:11:\"always_send\";b:0;s:24:\"always_send_notification\";b:0;s:12:\"max_filesize\";i:1;s:19:\"email_subject_issue\";s:57:\"Scan of {SITE_URL} complete. {ISSUES_COUNT} issues found.\";s:13:\"email_subject\";s:57:\"Scan of {SITE_URL} complete. {ISSUES_COUNT} issues found.\";s:15:\"email_has_issue\";s:268:\"Hi {USER_NAME},\r\n\r\nWP Defender here, reporting back from the front.\r\n\r\nI\'ve finished scanning {SITE_URL} for vulnerabilities and I found {ISSUES_COUNT} issues that you should take a closer look at!\r\n{ISSUES_LIST}\r\n\r\nStay Safe,\r\nWP Defender\r\nOfficial WPMU DEV Superhero\";s:12:\"email_all_ok\";s:350:\"Hi {USER_NAME},\r\n\r\nWP Defender here, reporting back from the front.\r\n\r\nI\'ve finished scanning {SITE_URL} for vulnerabilities and I found nothing. Well done for running such a tight ship!\r\n\r\nKeep up the good work! With regular security scans and a well-hardened installation you\'ll be just fine.\r\n\r\nStay safe,\r\nWP Defender\r\nOfficial WPMU DEV Superhero\";s:9:\"frequency\";s:1:\"7\";s:3:\"day\";s:6:\"sunday\";s:4:\"time\";s:4:\"4:00\";}s:9:\"iplockout\";a:38:{s:16:\"login_protection\";b:0;s:30:\"login_protection_login_attempt\";i:5;s:34:\"login_protection_lockout_timeframe\";i:300;s:33:\"login_protection_lockout_duration\";i:300;s:38:\"login_protection_lockout_duration_unit\";s:7:\"seconds\";s:32:\"login_protection_lockout_message\";s:64:\"You have been locked out due to too many invalid login attempts.\";s:28:\"login_protection_lockout_ban\";b:0;s:18:\"username_blacklist\";s:0:\"\";s:10:\"detect_404\";b:0;s:20:\"detect_404_threshold\";i:20;s:20:\"detect_404_timeframe\";i:300;s:27:\"detect_404_lockout_duration\";i:300;s:32:\"detect_404_lockout_duration_unit\";s:7:\"seconds\";s:20:\"detect_404_whitelist\";s:0:\"\";s:20:\"detect_404_blacklist\";s:0:\"\";s:28:\"detect_404_ignored_filetypes\";s:0:\"\";s:30:\"detect_404_filetypes_blacklist\";s:0:\"\";s:26:\"detect_404_lockout_message\";s:86:\"You have been locked out due to too many attempts to access a file that doesn\'t exist.\";s:22:\"detect_404_lockout_ban\";b:0;s:17:\"detect_404_logged\";b:1;s:12:\"ip_blacklist\";a:0:{}s:12:\"ip_whitelist\";a:0:{}s:18:\"ip_lockout_message\";s:66:\"The administrator has blocked your IP from accessing this website.\";s:17:\"country_blacklist\";a:0:{}s:17:\"country_whitelist\";a:0:{}s:26:\"login_lockout_notification\";b:0;s:23:\"ip_lockout_notification\";b:0;s:6:\"report\";b:0;s:16:\"report_frequency\";s:1:\"7\";s:10:\"report_day\";s:6:\"sunday\";s:11:\"report_time\";s:4:\"0:00\";s:8:\"geoIP_db\";s:0:\"\";s:12:\"storage_days\";i:30;s:8:\"receipts\";a:0:{}s:15:\"report_receipts\";a:0:{}s:16:\"cooldown_enabled\";b:0;s:23:\"cooldown_number_lockout\";s:1:\"3\";s:15:\"cooldown_period\";s:2:\"24\";}s:14:\"advanced_tools\";a:2:{s:10:\"two_factor\";a:11:{s:7:\"enabled\";b:0;s:10:\"lost_phone\";b:1;s:10:\"force_auth\";b:0;s:15:\"force_auth_mess\";s:69:\"You are required to setup two-factor authentication to use this site.\";s:10:\"user_roles\";a:6:{i:0;s:13:\"administrator\";i:1;s:6:\"editor\";i:2;s:6:\"author\";i:3;s:11:\"contributor\";i:4;s:13:\"wpseo_manager\";i:5;s:12:\"wpseo_editor\";}s:16:\"force_auth_roles\";a:0:{}s:14:\"custom_graphic\";b:0;s:18:\"custom_graphic_url\";s:93:\"https://www.econolodgeloon.com/wp-content/plugins/wp-defender/assets/img/2factor-disabled.svg\";s:13:\"email_subject\";s:13:\"Your OTP code\";s:12:\"email_sender\";s:5:\"admin\";s:10:\"email_body\";s:193:\"Hi {{display_name}},\r\n\r\nYour temporary login passcode is {{passcode}}.\r\n\r\nCopy and paste the passcode into the input field on the login screen to complete logging in.\r\n\r\nRegards,\r\nAdministrator\";}s:10:\"mask_login\";a:4:{s:8:\"mask_url\";s:0:\"\";s:16:\"redirect_traffic\";b:0;s:20:\"redirect_traffic_url\";s:0:\"\";s:7:\"enabled\";b:0;}}s:8:\"settings\";a:5:{s:9:\"translate\";s:7:\"English\";s:14:\"usage_tracking\";b:0;s:14:\"uninstall_data\";s:4:\"keep\";s:18:\"uninstall_settings\";s:8:\"preserve\";s:18:\"high_contrast_mode\";b:0;}s:5:\"audit\";a:7:{s:7:\"enabled\";b:0;s:9:\"frequency\";s:1:\"7\";s:3:\"day\";s:6:\"sunday\";s:4:\"time\";s:4:\"0:00\";s:12:\"notification\";b:0;s:8:\"receipts\";a:0:{}s:12:\"storage_days\";s:8:\"6 months\";}}s:16:\"2.2.9_1597091505\";a:8:{s:15:\"security_tweaks\";a:8:{s:6:\"issues\";a:9:{i:0;s:17:\"disable-trackback\";i:1;s:9:\"db-prefix\";i:2;s:19:\"disable-file-editor\";i:3;s:18:\"prevent-enum-users\";i:4;s:12:\"security-key\";i:5;s:19:\"protect-information\";i:6;s:20:\"prevent-php-executed\";i:7;s:14:\"login-duration\";i:8;s:15:\"disable-xml-rpc\";}s:5:\"fixed\";a:4:{i:0;s:10:\"wp-version\";i:1;s:11:\"php-version\";i:2;s:22:\"replace-admin-username\";i:3;s:10:\"hide-error\";}s:6:\"ignore\";a:0:{}s:12:\"notification\";b:0;s:19:\"notification_repeat\";b:0;s:8:\"receipts\";a:0:{}s:4:\"data\";a:0:{}s:8:\"automate\";b:0;}s:4:\"scan\";a:17:{s:9:\"scan_core\";b:1;s:9:\"scan_vuln\";b:1;s:12:\"scan_content\";b:1;s:10:\"recipients\";a:0:{}s:23:\"recipients_notification\";a:0:{}s:12:\"notification\";b:0;s:6:\"report\";b:0;s:11:\"always_send\";b:0;s:24:\"always_send_notification\";b:0;s:12:\"max_filesize\";i:1;s:19:\"email_subject_issue\";s:57:\"Scan of {SITE_URL} complete. {ISSUES_COUNT} issues found.\";s:13:\"email_subject\";s:57:\"Scan of {SITE_URL} complete. {ISSUES_COUNT} issues found.\";s:15:\"email_has_issue\";s:268:\"Hi {USER_NAME},\r\n\r\nWP Defender here, reporting back from the front.\r\n\r\nI\'ve finished scanning {SITE_URL} for vulnerabilities and I found {ISSUES_COUNT} issues that you should take a closer look at!\r\n{ISSUES_LIST}\r\n\r\nStay Safe,\r\nWP Defender\r\nOfficial WPMU DEV Superhero\";s:12:\"email_all_ok\";s:350:\"Hi {USER_NAME},\r\n\r\nWP Defender here, reporting back from the front.\r\n\r\nI\'ve finished scanning {SITE_URL} for vulnerabilities and I found nothing. Well done for running such a tight ship!\r\n\r\nKeep up the good work! With regular security scans and a well-hardened installation you\'ll be just fine.\r\n\r\nStay safe,\r\nWP Defender\r\nOfficial WPMU DEV Superhero\";s:9:\"frequency\";s:1:\"7\";s:3:\"day\";s:6:\"sunday\";s:4:\"time\";s:4:\"4:00\";}s:9:\"iplockout\";a:38:{s:16:\"login_protection\";b:0;s:30:\"login_protection_login_attempt\";i:5;s:34:\"login_protection_lockout_timeframe\";i:300;s:33:\"login_protection_lockout_duration\";i:300;s:38:\"login_protection_lockout_duration_unit\";s:7:\"seconds\";s:32:\"login_protection_lockout_message\";s:64:\"You have been locked out due to too many invalid login attempts.\";s:28:\"login_protection_lockout_ban\";b:0;s:18:\"username_blacklist\";s:0:\"\";s:10:\"detect_404\";b:0;s:20:\"detect_404_threshold\";i:20;s:20:\"detect_404_timeframe\";i:300;s:27:\"detect_404_lockout_duration\";i:300;s:32:\"detect_404_lockout_duration_unit\";s:7:\"seconds\";s:20:\"detect_404_whitelist\";s:0:\"\";s:20:\"detect_404_blacklist\";s:0:\"\";s:28:\"detect_404_ignored_filetypes\";s:0:\"\";s:30:\"detect_404_filetypes_blacklist\";s:0:\"\";s:26:\"detect_404_lockout_message\";s:86:\"You have been locked out due to too many attempts to access a file that doesn\'t exist.\";s:22:\"detect_404_lockout_ban\";b:0;s:17:\"detect_404_logged\";b:1;s:12:\"ip_blacklist\";a:0:{}s:12:\"ip_whitelist\";a:0:{}s:18:\"ip_lockout_message\";s:66:\"The administrator has blocked your IP from accessing this website.\";s:17:\"country_blacklist\";a:0:{}s:17:\"country_whitelist\";a:0:{}s:26:\"login_lockout_notification\";b:0;s:23:\"ip_lockout_notification\";b:0;s:6:\"report\";b:0;s:16:\"report_frequency\";s:1:\"7\";s:10:\"report_day\";s:6:\"sunday\";s:11:\"report_time\";s:4:\"0:00\";s:8:\"geoIP_db\";s:0:\"\";s:12:\"storage_days\";i:30;s:8:\"receipts\";a:0:{}s:15:\"report_receipts\";a:0:{}s:16:\"cooldown_enabled\";b:0;s:23:\"cooldown_number_lockout\";s:1:\"3\";s:15:\"cooldown_period\";s:2:\"24\";}s:5:\"audit\";a:7:{s:7:\"enabled\";b:0;s:9:\"frequency\";s:1:\"7\";s:3:\"day\";s:6:\"sunday\";s:4:\"time\";s:4:\"0:00\";s:12:\"notification\";b:0;s:8:\"receipts\";a:0:{}s:12:\"storage_days\";s:8:\"6 months\";}s:10:\"two_factor\";a:11:{s:7:\"enabled\";b:0;s:10:\"lost_phone\";b:1;s:10:\"force_auth\";b:0;s:15:\"force_auth_mess\";s:69:\"You are required to setup two-factor authentication to use this site.\";s:10:\"user_roles\";a:6:{i:0;s:13:\"administrator\";i:1;s:6:\"editor\";i:2;s:6:\"author\";i:3;s:11:\"contributor\";i:4;s:13:\"wpseo_manager\";i:5;s:12:\"wpseo_editor\";}s:16:\"force_auth_roles\";a:0:{}s:14:\"custom_graphic\";b:0;s:18:\"custom_graphic_url\";s:93:\"https://www.econolodgeloon.com/wp-content/plugins/wp-defender/assets/img/2factor-disabled.svg\";s:13:\"email_subject\";s:13:\"Your OTP code\";s:12:\"email_sender\";s:5:\"admin\";s:10:\"email_body\";s:193:\"Hi {{display_name}},\r\n\r\nYour temporary login passcode is {{passcode}}.\r\n\r\nCopy and paste the passcode into the input field on the login screen to complete logging in.\r\n\r\nRegards,\r\nAdministrator\";}s:10:\"mask_login\";a:4:{s:8:\"mask_url\";s:0:\"\";s:16:\"redirect_traffic\";b:0;s:20:\"redirect_traffic_url\";s:0:\"\";s:7:\"enabled\";b:0;}s:8:\"settings\";a:5:{s:9:\"translate\";s:7:\"English\";s:14:\"usage_tracking\";b:0;s:14:\"uninstall_data\";s:4:\"keep\";s:18:\"uninstall_settings\";s:8:\"preserve\";s:18:\"high_contrast_mode\";b:0;}s:16:\"security_headers\";a:16:{s:9:\"sh_xframe\";b:0;s:14:\"sh_xframe_mode\";s:10:\"sameorigin\";s:14:\"sh_xframe_urls\";s:0:\"\";s:17:\"sh_xss_protection\";b:0;s:22:\"sh_xss_protection_mode\";s:8:\"sanitize\";s:23:\"sh_content_type_options\";b:0;s:28:\"sh_content_type_options_mode\";s:7:\"nosniff\";s:19:\"sh_strict_transport\";b:0;s:12:\"hsts_preload\";i:0;s:17:\"include_subdomain\";i:0;s:19:\"hsts_cache_duration\";s:7:\"30 days\";s:18:\"sh_referrer_policy\";b:0;s:23:\"sh_referrer_policy_mode\";s:24:\"origin-when-cross-origin\";s:17:\"sh_feature_policy\";b:0;s:22:\"sh_feature_policy_mode\";s:4:\"self\";s:22:\"sh_feature_policy_urls\";s:0:\"\";}}s:16:\"2.3.1_1600103602\";a:8:{s:15:\"security_tweaks\";a:8:{s:6:\"issues\";a:9:{i:0;s:17:\"disable-trackback\";i:1;s:10:\"wp-version\";i:2;s:19:\"disable-file-editor\";i:3;s:18:\"prevent-enum-users\";i:4;s:12:\"security-key\";i:5;s:19:\"protect-information\";i:6;s:20:\"prevent-php-executed\";i:7;s:14:\"login-duration\";i:8;s:15:\"disable-xml-rpc\";}s:5:\"fixed\";a:3:{i:0;s:11:\"php-version\";i:1;s:22:\"replace-admin-username\";i:2;s:10:\"hide-error\";}s:6:\"ignore\";a:0:{}s:12:\"notification\";b:0;s:19:\"notification_repeat\";b:0;s:8:\"receipts\";a:0:{}s:4:\"data\";a:0:{}s:8:\"automate\";b:0;}s:4:\"scan\";a:17:{s:9:\"scan_core\";b:1;s:9:\"scan_vuln\";b:1;s:12:\"scan_content\";b:1;s:10:\"recipients\";a:0:{}s:23:\"recipients_notification\";a:0:{}s:12:\"notification\";b:0;s:6:\"report\";b:0;s:11:\"always_send\";b:0;s:24:\"always_send_notification\";b:0;s:12:\"max_filesize\";i:1;s:19:\"email_subject_issue\";s:57:\"Scan of {SITE_URL} complete. {ISSUES_COUNT} issues found.\";s:13:\"email_subject\";s:57:\"Scan of {SITE_URL} complete. {ISSUES_COUNT} issues found.\";s:15:\"email_has_issue\";s:268:\"Hi {USER_NAME},\r\n\r\nWP Defender here, reporting back from the front.\r\n\r\nI\'ve finished scanning {SITE_URL} for vulnerabilities and I found {ISSUES_COUNT} issues that you should take a closer look at!\r\n{ISSUES_LIST}\r\n\r\nStay Safe,\r\nWP Defender\r\nOfficial WPMU DEV Superhero\";s:12:\"email_all_ok\";s:350:\"Hi {USER_NAME},\r\n\r\nWP Defender here, reporting back from the front.\r\n\r\nI\'ve finished scanning {SITE_URL} for vulnerabilities and I found nothing. Well done for running such a tight ship!\r\n\r\nKeep up the good work! With regular security scans and a well-hardened installation you\'ll be just fine.\r\n\r\nStay safe,\r\nWP Defender\r\nOfficial WPMU DEV Superhero\";s:9:\"frequency\";s:1:\"7\";s:3:\"day\";s:6:\"sunday\";s:4:\"time\";s:4:\"4:00\";}s:9:\"iplockout\";a:38:{s:16:\"login_protection\";b:0;s:30:\"login_protection_login_attempt\";i:5;s:34:\"login_protection_lockout_timeframe\";i:300;s:33:\"login_protection_lockout_duration\";i:300;s:38:\"login_protection_lockout_duration_unit\";s:7:\"seconds\";s:32:\"login_protection_lockout_message\";s:64:\"You have been locked out due to too many invalid login attempts.\";s:28:\"login_protection_lockout_ban\";b:0;s:18:\"username_blacklist\";s:0:\"\";s:10:\"detect_404\";b:0;s:20:\"detect_404_threshold\";i:20;s:20:\"detect_404_timeframe\";i:300;s:27:\"detect_404_lockout_duration\";i:300;s:32:\"detect_404_lockout_duration_unit\";s:7:\"seconds\";s:20:\"detect_404_whitelist\";s:0:\"\";s:20:\"detect_404_blacklist\";s:0:\"\";s:28:\"detect_404_ignored_filetypes\";s:0:\"\";s:30:\"detect_404_filetypes_blacklist\";s:0:\"\";s:26:\"detect_404_lockout_message\";s:86:\"You have been locked out due to too many attempts to access a file that doesn\'t exist.\";s:22:\"detect_404_lockout_ban\";b:0;s:17:\"detect_404_logged\";b:1;s:12:\"ip_blacklist\";a:0:{}s:12:\"ip_whitelist\";a:0:{}s:18:\"ip_lockout_message\";s:66:\"The administrator has blocked your IP from accessing this website.\";s:17:\"country_blacklist\";a:0:{}s:17:\"country_whitelist\";a:0:{}s:26:\"login_lockout_notification\";b:0;s:23:\"ip_lockout_notification\";b:0;s:6:\"report\";b:0;s:16:\"report_frequency\";s:1:\"7\";s:10:\"report_day\";s:6:\"sunday\";s:11:\"report_time\";s:4:\"0:00\";s:8:\"geoIP_db\";s:0:\"\";s:12:\"storage_days\";i:30;s:8:\"receipts\";a:0:{}s:15:\"report_receipts\";a:0:{}s:16:\"cooldown_enabled\";b:0;s:23:\"cooldown_number_lockout\";s:1:\"3\";s:15:\"cooldown_period\";s:2:\"24\";}s:5:\"audit\";a:7:{s:7:\"enabled\";b:0;s:9:\"frequency\";s:1:\"7\";s:3:\"day\";s:6:\"sunday\";s:4:\"time\";s:4:\"0:00\";s:12:\"notification\";b:0;s:8:\"receipts\";a:0:{}s:12:\"storage_days\";s:8:\"6 months\";}s:10:\"two_factor\";a:11:{s:7:\"enabled\";b:0;s:10:\"lost_phone\";b:1;s:10:\"force_auth\";b:0;s:15:\"force_auth_mess\";s:69:\"You are required to setup two-factor authentication to use this site.\";s:10:\"user_roles\";a:6:{i:0;s:13:\"administrator\";i:1;s:6:\"editor\";i:2;s:6:\"author\";i:3;s:11:\"contributor\";i:4;s:13:\"wpseo_manager\";i:5;s:12:\"wpseo_editor\";}s:16:\"force_auth_roles\";a:0:{}s:14:\"custom_graphic\";b:0;s:18:\"custom_graphic_url\";s:93:\"https://www.econolodgeloon.com/wp-content/plugins/wp-defender/assets/img/2factor-disabled.svg\";s:13:\"email_subject\";s:13:\"Your OTP code\";s:12:\"email_sender\";s:5:\"admin\";s:10:\"email_body\";s:193:\"Hi {{display_name}},\r\n\r\nYour temporary login passcode is {{passcode}}.\r\n\r\nCopy and paste the passcode into the input field on the login screen to complete logging in.\r\n\r\nRegards,\r\nAdministrator\";}s:10:\"mask_login\";a:4:{s:8:\"mask_url\";s:0:\"\";s:16:\"redirect_traffic\";b:0;s:20:\"redirect_traffic_url\";s:0:\"\";s:7:\"enabled\";b:0;}s:8:\"settings\";a:5:{s:9:\"translate\";s:7:\"English\";s:14:\"usage_tracking\";b:0;s:14:\"uninstall_data\";s:4:\"keep\";s:18:\"uninstall_settings\";s:8:\"preserve\";s:18:\"high_contrast_mode\";b:0;}s:16:\"security_headers\";a:16:{s:9:\"sh_xframe\";b:0;s:14:\"sh_xframe_mode\";s:10:\"sameorigin\";s:14:\"sh_xframe_urls\";s:0:\"\";s:17:\"sh_xss_protection\";b:0;s:22:\"sh_xss_protection_mode\";s:8:\"sanitize\";s:23:\"sh_content_type_options\";b:0;s:28:\"sh_content_type_options_mode\";s:7:\"nosniff\";s:19:\"sh_strict_transport\";b:0;s:12:\"hsts_preload\";i:0;s:17:\"include_subdomain\";i:0;s:19:\"hsts_cache_duration\";s:7:\"30 days\";s:18:\"sh_referrer_policy\";b:0;s:23:\"sh_referrer_policy_mode\";s:24:\"origin-when-cross-origin\";s:17:\"sh_feature_policy\";b:0;s:22:\"sh_feature_policy_mode\";s:4:\"self\";s:22:\"sh_feature_policy_urls\";s:0:\"\";}}s:16:\"2.3.2_1606245056\";a:8:{s:15:\"security_tweaks\";a:18:{s:2:\"id\";s:20:\"wd_hardener_settings\";s:6:\"issues\";a:9:{i:0;s:17:\"disable-trackback\";i:1;s:10:\"wp-version\";i:2;s:19:\"disable-file-editor\";i:3;s:18:\"prevent-enum-users\";i:4;s:12:\"security-key\";i:5;s:19:\"protect-information\";i:6;s:20:\"prevent-php-executed\";i:7;s:14:\"login-duration\";i:8;s:15:\"disable-xml-rpc\";}s:5:\"fixed\";a:3:{i:0;s:11:\"php-version\";i:1;s:22:\"replace-admin-username\";i:2;s:10:\"hide-error\";}s:6:\"ignore\";a:0:{}s:17:\"last_status_check\";i:1606244352;s:12:\"notification\";b:0;s:19:\"notification_repeat\";b:0;s:8:\"receipts\";a:0:{}s:4:\"data\";a:1:{s:13:\"head_requests\";a:7:{s:75:\"https://www.econolodgeloon.com/wp-content/plugins/wp-defender/changelog.txt\";a:2:{s:3:\"ttl\";i:1582055456;s:4:\"data\";a:11:{s:4:\"date\";s:29:\"Mon, 17 Feb 2020 19:50:56 GMT\";s:6:\"server\";s:6:\"Apache\";s:7:\"upgrade\";s:6:\"h2,h2c\";s:13:\"last-modified\";s:29:\"Mon, 27 Jan 2020 21:04:34 GMT\";s:4:\"etag\";s:32:\"\"ae0db6-4633-59d2574502f22-gzip\"\";s:13:\"accept-ranges\";s:5:\"bytes\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:16:\"content-encoding\";s:4:\"gzip\";s:14:\"content-length\";s:4:\"5637\";s:12:\"content-type\";s:10:\"text/plain\";s:13:\"response_code\";i:200;}}s:71:\"https://www.econolodgeloon.com/wp-content/uploads/wp-defender/index.php\";a:2:{s:3:\"ttl\";i:1606320401;s:4:\"data\";a:5:{s:4:\"date\";s:29:\"Tue, 24 Nov 2020 16:06:41 GMT\";s:6:\"server\";s:6:\"Apache\";s:7:\"upgrade\";s:6:\"h2,h2c\";s:12:\"content-type\";s:24:\"text/html; charset=UTF-8\";s:13:\"response_code\";i:200;}}s:30:\"https://www.econolodgeloon.com\";a:2:{s:3:\"ttl\";i:1588704308;s:4:\"data\";a:6:{s:4:\"date\";s:29:\"Mon, 04 May 2020 18:45:08 GMT\";s:6:\"server\";s:6:\"Apache\";s:4:\"link\";s:67:\"<https://www.econolodgeloon.com/wp-json/>; rel=\"https://api.w.org/\"\";s:7:\"upgrade\";s:6:\"h2,h2c\";s:12:\"content-type\";s:24:\"text/html; charset=UTF-8\";s:13:\"response_code\";i:200;}}s:74:\"http://www.econolodgeloon.com/wp-content/plugins/wp-defender/changelog.txt\";a:2:{s:3:\"ttl\";i:1582034609;s:4:\"data\";a:11:{s:4:\"date\";s:29:\"Mon, 17 Feb 2020 14:03:29 GMT\";s:6:\"server\";s:6:\"Apache\";s:7:\"upgrade\";s:6:\"h2,h2c\";s:13:\"last-modified\";s:29:\"Mon, 27 Jan 2020 21:04:34 GMT\";s:4:\"etag\";s:32:\"\"ae0db6-4633-59d2574502f22-gzip\"\";s:13:\"accept-ranges\";s:5:\"bytes\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:16:\"content-encoding\";s:4:\"gzip\";s:14:\"content-length\";s:4:\"5637\";s:12:\"content-type\";s:10:\"text/plain\";s:13:\"response_code\";i:200;}}s:29:\"http://www.econolodgeloon.com\";a:2:{s:3:\"ttl\";i:1588679797;s:4:\"data\";a:6:{s:4:\"date\";s:29:\"Mon, 04 May 2020 11:56:37 GMT\";s:6:\"server\";s:6:\"Apache\";s:4:\"link\";s:67:\"<https://www.econolodgeloon.com/wp-json/>; rel=\"https://api.w.org/\"\";s:7:\"upgrade\";s:6:\"h2,h2c\";s:12:\"content-type\";s:24:\"text/html; charset=UTF-8\";s:13:\"response_code\";i:200;}}s:88:\"http://www.econolodgeloon.com/wp-content/plugins/wp-defender/languages/wpdef-default.pot\";a:2:{s:3:\"ttl\";i:1606320580;s:4:\"data\";a:11:{s:4:\"date\";s:29:\"Tue, 24 Nov 2020 16:09:40 GMT\";s:6:\"server\";s:6:\"Apache\";s:7:\"upgrade\";s:6:\"h2,h2c\";s:13:\"last-modified\";s:29:\"Mon, 14 Sep 2020 20:07:26 GMT\";s:4:\"etag\";s:33:\"\"e801d9-3865c-5af4b955e2d5e-gzip\"\";s:13:\"accept-ranges\";s:5:\"bytes\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:16:\"content-encoding\";s:4:\"gzip\";s:14:\"content-length\";s:5:\"41703\";s:12:\"content-type\";s:29:\"application/vnd.ms-powerpoint\";s:13:\"response_code\";i:200;}}s:89:\"https://www.econolodgeloon.com/wp-content/plugins/wp-defender/languages/wpdef-default.pot\";a:2:{s:3:\"ttl\";i:1606312231;s:4:\"data\";a:11:{s:4:\"date\";s:29:\"Tue, 24 Nov 2020 13:50:31 GMT\";s:6:\"server\";s:6:\"Apache\";s:7:\"upgrade\";s:6:\"h2,h2c\";s:13:\"last-modified\";s:29:\"Mon, 14 Sep 2020 20:07:26 GMT\";s:4:\"etag\";s:33:\"\"e801d9-3865c-5af4b955e2d5e-gzip\"\";s:13:\"accept-ranges\";s:5:\"bytes\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:16:\"content-encoding\";s:4:\"gzip\";s:14:\"content-length\";s:5:\"41703\";s:12:\"content-type\";s:29:\"application/vnd.ms-powerpoint\";s:13:\"response_code\";i:200;}}}}s:18:\"exclude_file_paths\";a:0:{}s:12:\"new_htconfig\";a:0:{}s:13:\"active_server\";s:6:\"apache\";s:9:\"last_seen\";i:1560916428;s:9:\"last_sent\";i:1605758830;s:15:\"min_php_version\";s:3:\"7.2\";s:18:\"stable_php_version\";s:3:\"7.3\";s:17:\"is_prefix_changed\";b:0;s:8:\"automate\";b:0;}s:9:\"iplockout\";a:41:{s:16:\"login_protection\";b:0;s:30:\"login_protection_login_attempt\";i:5;s:34:\"login_protection_lockout_timeframe\";i:300;s:33:\"login_protection_lockout_duration\";i:300;s:38:\"login_protection_lockout_duration_unit\";s:7:\"seconds\";s:32:\"login_protection_lockout_message\";s:64:\"You have been locked out due to too many invalid login attempts.\";s:32:\"login_protection_ban_admin_brute\";b:0;s:28:\"login_protection_lockout_ban\";b:0;s:18:\"username_blacklist\";s:0:\"\";s:10:\"detect_404\";b:0;s:20:\"detect_404_threshold\";i:20;s:20:\"detect_404_timeframe\";i:300;s:27:\"detect_404_lockout_duration\";i:300;s:32:\"detect_404_lockout_duration_unit\";s:7:\"seconds\";s:20:\"detect_404_whitelist\";s:0:\"\";s:20:\"detect_404_blacklist\";s:0:\"\";s:28:\"detect_404_ignored_filetypes\";s:0:\"\";s:30:\"detect_404_filetypes_blacklist\";s:0:\"\";s:26:\"detect_404_lockout_message\";s:86:\"You have been locked out due to too many attempts to access a file that doesn\'t exist.\";s:22:\"detect_404_lockout_ban\";b:0;s:17:\"detect_404_logged\";b:1;s:12:\"ip_blacklist\";a:0:{}s:12:\"ip_whitelist\";a:0:{}s:18:\"ip_lockout_message\";s:66:\"The administrator has blocked your IP from accessing this website.\";s:17:\"country_blacklist\";a:0:{}s:17:\"country_whitelist\";a:0:{}s:26:\"login_lockout_notification\";b:0;s:23:\"ip_lockout_notification\";b:0;s:6:\"report\";b:0;s:16:\"report_frequency\";s:1:\"7\";s:10:\"report_day\";s:6:\"sunday\";s:11:\"report_time\";s:4:\"0:00\";s:8:\"geoIP_db\";s:0:\"\";s:12:\"storage_days\";i:30;s:8:\"receipts\";a:0:{}s:15:\"report_receipts\";a:0:{}s:14:\"lastReportSent\";i:1570336256;s:16:\"cooldown_enabled\";b:0;s:23:\"cooldown_number_lockout\";s:1:\"3\";s:15:\"cooldown_period\";s:2:\"24\";s:5:\"cache\";a:0:{}}s:4:\"scan\";a:17:{s:9:\"scan_core\";b:1;s:9:\"scan_vuln\";b:1;s:12:\"scan_content\";b:1;s:10:\"recipients\";a:0:{}s:23:\"recipients_notification\";a:0:{}s:12:\"notification\";b:0;s:6:\"report\";b:0;s:11:\"always_send\";b:0;s:24:\"always_send_notification\";b:0;s:12:\"max_filesize\";i:1;s:13:\"email_subject\";s:57:\"Scan of {SITE_URL} complete. {ISSUES_COUNT} issues found.\";s:15:\"email_has_issue\";s:268:\"Hi {USER_NAME},\r\n\r\nWP Defender here, reporting back from the front.\r\n\r\nI\'ve finished scanning {SITE_URL} for vulnerabilities and I found {ISSUES_COUNT} issues that you should take a closer look at!\r\n{ISSUES_LIST}\r\n\r\nStay Safe,\r\nWP Defender\r\nOfficial WPMU DEV Superhero\";s:12:\"email_all_ok\";s:350:\"Hi {USER_NAME},\r\n\r\nWP Defender here, reporting back from the front.\r\n\r\nI\'ve finished scanning {SITE_URL} for vulnerabilities and I found nothing. Well done for running such a tight ship!\r\n\r\nKeep up the good work! With regular security scans and a well-hardened installation you\'ll be just fine.\r\n\r\nStay safe,\r\nWP Defender\r\nOfficial WPMU DEV Superhero\";s:9:\"frequency\";s:1:\"7\";s:3:\"day\";s:6:\"sunday\";s:4:\"time\";s:4:\"4:00\";s:16:\"last_report_sent\";s:0:\"\";}s:5:\"audit\";a:0:{}s:10:\"two_factor\";a:12:{s:7:\"enabled\";b:0;s:10:\"lost_phone\";b:1;s:10:\"force_auth\";b:0;s:15:\"force_auth_mess\";s:69:\"You are required to setup two-factor authentication to use this site.\";s:10:\"user_roles\";a:6:{i:0;s:13:\"administrator\";i:1;s:6:\"editor\";i:2;s:6:\"author\";i:3;s:11:\"contributor\";i:5;s:13:\"wpseo_manager\";i:6;s:12:\"wpseo_editor\";}s:16:\"force_auth_roles\";a:0:{}s:14:\"custom_graphic\";b:0;s:18:\"custom_graphic_url\";s:93:\"https://www.econolodgeloon.com/wp-content/plugins/wp-defender/assets/img/2factor-disabled.svg\";s:11:\"is_conflict\";a:0:{}s:13:\"email_subject\";s:13:\"Your OTP code\";s:12:\"email_sender\";s:5:\"admin\";s:10:\"email_body\";s:193:\"Hi {{display_name}},\r\n\r\nYour temporary login passcode is {{passcode}}.\r\n\r\nCopy and paste the passcode into the input field on the login screen to complete logging in.\r\n\r\nRegards,\r\nAdministrator\";}s:10:\"mask_login\";a:5:{s:8:\"mask_url\";s:0:\"\";s:16:\"redirect_traffic\";b:0;s:20:\"redirect_traffic_url\";s:0:\"\";s:7:\"enabled\";b:0;s:4:\"otps\";a:0:{}}s:16:\"security_headers\";a:17:{s:9:\"sh_xframe\";b:0;s:14:\"sh_xframe_mode\";s:10:\"sameorigin\";s:14:\"sh_xframe_urls\";s:0:\"\";s:17:\"sh_xss_protection\";b:0;s:22:\"sh_xss_protection_mode\";s:8:\"sanitize\";s:23:\"sh_content_type_options\";b:0;s:28:\"sh_content_type_options_mode\";s:7:\"nosniff\";s:19:\"sh_strict_transport\";b:0;s:12:\"hsts_preload\";i:0;s:17:\"include_subdomain\";i:0;s:19:\"hsts_cache_duration\";s:7:\"30 days\";s:18:\"sh_referrer_policy\";b:0;s:23:\"sh_referrer_policy_mode\";s:24:\"origin-when-cross-origin\";s:17:\"sh_feature_policy\";b:0;s:22:\"sh_feature_policy_mode\";s:4:\"self\";s:22:\"sh_feature_policy_urls\";s:0:\"\";s:4:\"data\";a:0:{}}s:8:\"settings\";a:0:{}}}", "no");
INSERT INTO `wp_options` VALUES("155566", "sc_simple_cache", "a:9:{s:19:\"enable_page_caching\";b:1;s:13:\"advanced_mode\";b:0;s:31:\"enable_in_memory_object_caching\";b:0;s:23:\"enable_gzip_compression\";b:1;s:15:\"in_memory_cache\";s:9:\"memcached\";s:17:\"page_cache_length\";d:24;s:22:\"page_cache_length_unit\";s:5:\"hours\";s:20:\"cache_exception_urls\";s:0:\"\";s:26:\"enable_url_exemption_regex\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("155568", "wpsupercache_gc_time", "1547494551", "yes");
INSERT INTO `wp_options` VALUES("217285", "wdfscanignore", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("152224", "smush-directory-path-hash-updated", "1", "yes");
INSERT INTO `wp_options` VALUES("155192", "snapshot_ajax_backup_run", "", "no");
INSERT INTO `wp_options` VALUES("155181", "duplicator_settings", "a:17:{s:7:\"version\";s:6:\"1.3.40\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"legacy\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";i:2;s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("150840", "supercache_stats", "a:3:{s:9:\"generated\";i:1544210389;s:10:\"supercache\";a:5:{s:7:\"expired\";i:0;s:6:\"cached\";i:0;s:5:\"fsize\";i:0;s:11:\"cached_list\";a:0:{}s:12:\"expired_list\";a:0:{}}s:7:\"wpcache\";a:5:{s:7:\"expired\";i:0;s:6:\"cached\";i:0;s:5:\"fsize\";i:0;s:11:\"cached_list\";a:0:{}s:12:\"expired_list\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("229820", "_transient_health-check-site-status-result", "{\"good\":\"8\",\"recommended\":\"9\",\"critical\":\"0\"}", "yes");
INSERT INTO `wp_options` VALUES("263424", "_site_transient_update_themes", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1607020823;s:7:\"checked\";a:2:{s:16:\"tempera-nocopyrt\";s:3:\"0.1\";s:7:\"tempera\";s:5:\"1.7.2\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:1:{s:7:\"tempera\";a:6:{s:5:\"theme\";s:7:\"tempera\";s:11:\"new_version\";s:5:\"1.7.2\";s:3:\"url\";s:37:\"https://wordpress.org/themes/tempera/\";s:7:\"package\";s:55:\"https://downloads.wordpress.org/theme/tempera.1.7.2.zip\";s:8:\"requires\";s:3:\"4.2\";s:12:\"requires_php\";b:0;}}s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("263425", "_transient_wpo_get_cache_size", "a:2:{s:4:\"size\";i:0;s:10:\"file_count\";i:0;}", "yes");
INSERT INTO `wp_options` VALUES("263426", "updraft_unlocked_wpo_cache_preloader_creating_tasks", "1", "no");
INSERT INTO `wp_options` VALUES("263427", "updraft_last_lock_time_wpo_cache_preloader_creating_tasks", "2020-12-03 18:40:23", "no");
INSERT INTO `wp_options` VALUES("263428", "updraft_semaphore_wpo_cache_preloader_creating_tasks", "0", "no");
INSERT INTO `wp_options` VALUES("263429", "wp-optimize-is_gzip_compression_enabled", "gzip", "yes");
INSERT INTO `wp_options` VALUES("263430", "_transient_timeout_wpo_minify_get_cached_files", "1607107223", "no");
INSERT INTO `wp_options` VALUES("230690", "duplicator_lite_inst_hash_notice", "1", "yes");
INSERT INTO `wp_options` VALUES("229610", "yoast_migrations_free", "a:1:{s:7:\"version\";s:4:\"15.4\";}", "yes");
INSERT INTO `wp_options` VALUES("230503", "wd_security_headers_settings", "{\"sh_xframe\":false,\"sh_xframe_mode\":\"sameorigin\",\"sh_xframe_urls\":\"\",\"sh_xss_protection\":false,\"sh_xss_protection_mode\":\"sanitize\",\"sh_content_type_options\":false,\"sh_content_type_options_mode\":\"nosniff\",\"sh_strict_transport\":false,\"hsts_preload\":0,\"include_subdomain\":0,\"hsts_cache_duration\":\"30 days\",\"sh_referrer_policy\":false,\"sh_referrer_policy_mode\":\"origin-when-cross-origin\",\"sh_feature_policy\":false,\"sh_feature_policy_mode\":\"self\",\"sh_feature_policy_urls\":\"\"}", "no");
INSERT INTO `wp_options` VALUES("230504", "waf_show_new_feature", "1", "no");
INSERT INTO `wp_options` VALUES("217282", "cleanchecksum", "s:6:\"a:0:{}\";", "no");
INSERT INTO `wp_options` VALUES("217283", "cleanchecksum_expire", "1579618620", "no");
INSERT INTO `wp_options` VALUES("263363", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.5.3.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.5.3.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-5.5.3-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.5.3-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"5.5.3\";s:7:\"version\";s:5:\"5.5.3\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.3\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1607022457;s:15:\"version_checked\";s:5:\"5.5.3\";s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("238064", "duplicator_new_storage_position", "1", "yes");
INSERT INTO `wp_options` VALUES("154559", "wp-smush-cdn_status", "O:8:\"stdClass\":8:{s:5:\"limit\";i:32;s:11:\"cdn_enabled\";b:0;s:7:\"site_id\";s:7:\"1178365\";s:12:\"endpoint_url\";N;s:14:\"bandwidth_plan\";i:10;s:9:\"bandwidth\";N;s:4:\"hits\";N;s:12:\"cache_misses\";N;}", "no");
INSERT INTO `wp_options` VALUES("154560", "wp-smush-settings", "a:24:{s:4:\"auto\";b:1;s:5:\"lossy\";b:1;s:10:\"strip_exif\";b:1;s:6:\"resize\";i:1;s:9:\"detection\";i:1;s:8:\"original\";b:0;s:6:\"backup\";i:0;s:10:\"png_to_jpg\";i:1;s:7:\"nextgen\";b:0;s:2:\"s3\";b:0;s:9:\"gutenberg\";b:0;s:10:\"js_builder\";b:0;s:3:\"cdn\";b:0;s:11:\"auto_resize\";b:0;s:4:\"webp\";b:1;s:5:\"usage\";b:0;s:17:\"accessible_colors\";b:0;s:9:\"keep_data\";b:1;s:9:\"lazy_load\";b:1;s:17:\"background_images\";b:1;s:16:\"rest_api_support\";b:0;s:8:\"webp_mod\";b:1;s:11:\"networkwide\";i:0;s:9:\"keep_exif\";i:0;}", "no");
INSERT INTO `wp_options` VALUES("155182", "duplicator_version_plugin", "1.3.40", "yes");
INSERT INTO `wp_options` VALUES("170601", "wp-smush-last_run_sync", "a:2:{s:4:\"time\";i:1606938615;s:5:\"fails\";i:0;}", "no");
INSERT INTO `wp_options` VALUES("171475", "wpseo_upgrade_history", "a:2:{i:1554231830;a:3:{s:7:\"options\";a:3:{s:5:\"wpseo\";a:20:{s:15:\"ms_defaults_set\";b:0;s:7:\"version\";s:6:\"10.0.1\";s:20:\"disableadvanced_meta\";b:1;s:19:\"onpage_indexability\";b:1;s:11:\"baiduverify\";s:0:\"\";s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";b:0;s:16:\"environment_type\";s:0:\"\";s:23:\"content_analysis_active\";b:1;s:23:\"keyword_analysis_active\";b:1;s:21:\"enable_admin_bar_menu\";b:1;s:26:\"enable_cornerstone_content\";b:1;s:18:\"enable_xml_sitemap\";b:1;s:24:\"enable_text_link_counter\";b:1;s:22:\"show_onboarding_notice\";b:0;s:18:\"first_activated_on\";i:1475013214;s:13:\"myyoast-oauth\";a:2:{s:6:\"config\";a:2:{s:8:\"clientId\";N;s:6:\"secret\";N;}s:13:\"access_tokens\";a:0:{}}}s:12:\"wpseo_social\";a:18:{s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:14:\"plus-publisher\";s:0:\"\";s:7:\"twitter\";b:0;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:7:\"summary\";s:11:\"youtube_url\";s:0:\"\";s:15:\"google_plus_url\";s:0:\"\";s:10:\"fbadminapp\";s:0:\"\";}s:12:\"wpseo_titles\";a:65:{s:10:\"title_test\";i:0;s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-pipe\";s:16:\"title-home-wpseo\";s:69:\"White Mountains NH Motel Hotel | Swimming Pool | Loon Mountain Skiing\";s:18:\"title-author-wpseo\";s:41:\"%%name%%, Author at %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:63:\"You searched for %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:35:\"Page not found %%sep%% %%sitename%%\";s:19:\"metadesc-home-wpseo\";s:373:\"Econo Lodge Loon Inn & Suites is a White Mountains New Hampshire Motel with an indoor swimming pool in a convenient location. We offer newly renovated beautiful guest rooms, Jacuzzi rooms and suites and are near White Mountains NH attractions, skiing, golf, hiking and much more. Our family motel is a great vacation or getaway lodging for your White Mountains NH vacation.\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:53:\"The post %%POSTLINK%% appeared first on %%BLOGLINK%%.\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:18:\"disable-attachment\";b:1;s:23:\"is-media-purge-relevant\";b:0;s:20:\"breadcrumbs-404crumb\";s:25:\"Error 404: Page not found\";s:29:\"breadcrumbs-display-blog-page\";b:0;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:12:\"Archives for\";s:18:\"breadcrumbs-enable\";b:0;s:16:\"breadcrumbs-home\";s:4:\"Home\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:16:\"You searched for\";s:15:\"breadcrumbs-sep\";s:2:\"»\";s:12:\"website_name\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"company_logo\";s:74:\"https://www.econolodgeloon.com/wp/wp-content/uploads/signsiloforbanner.jpg\";s:12:\"company_name\";s:24:\"Econo Lodge Inn & Suites\";s:17:\"company_or_person\";s:7:\"company\";s:17:\"stripcategorybase\";b:0;s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:13:\"showdate-post\";b:0;s:23:\"display-metabox-pt-post\";b:1;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:13:\"showdate-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:19:\"showdate-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:18:\"title-tax-category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:1;s:20:\"noindex-tax-category\";b:0;s:18:\"title-tax-post_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:1;s:20:\"noindex-tax-post_tag\";b:0;s:21:\"title-tax-post_format\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:0;s:23:\"noindex-tax-post_format\";b:0;s:23:\"post_types-post-maintax\";i:0;}}s:11:\"old_version\";s:6:\"10.0.1\";s:11:\"new_version\";s:6:\"10.1.1\";}i:1554312325;a:3:{s:7:\"options\";a:3:{s:5:\"wpseo\";a:20:{s:15:\"ms_defaults_set\";b:0;s:7:\"version\";s:6:\"10.1.2\";s:20:\"disableadvanced_meta\";b:1;s:19:\"onpage_indexability\";b:1;s:11:\"baiduverify\";s:0:\"\";s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";b:0;s:16:\"environment_type\";s:0:\"\";s:23:\"content_analysis_active\";b:1;s:23:\"keyword_analysis_active\";b:1;s:21:\"enable_admin_bar_menu\";b:1;s:26:\"enable_cornerstone_content\";b:1;s:18:\"enable_xml_sitemap\";b:1;s:24:\"enable_text_link_counter\";b:1;s:22:\"show_onboarding_notice\";b:0;s:18:\"first_activated_on\";i:1475013214;s:13:\"myyoast-oauth\";b:0;}s:12:\"wpseo_social\";a:18:{s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:14:\"plus-publisher\";s:0:\"\";s:7:\"twitter\";b:0;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:7:\"summary\";s:11:\"youtube_url\";s:0:\"\";s:15:\"google_plus_url\";s:0:\"\";s:10:\"fbadminapp\";s:0:\"\";}s:12:\"wpseo_titles\";a:65:{s:10:\"title_test\";i:0;s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-pipe\";s:16:\"title-home-wpseo\";s:69:\"White Mountains NH Motel Hotel | Swimming Pool | Loon Mountain Skiing\";s:18:\"title-author-wpseo\";s:41:\"%%name%%, Author at %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:63:\"You searched for %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:35:\"Page not found %%sep%% %%sitename%%\";s:19:\"metadesc-home-wpseo\";s:373:\"Econo Lodge Loon Inn & Suites is a White Mountains New Hampshire Motel with an indoor swimming pool in a convenient location. We offer newly renovated beautiful guest rooms, Jacuzzi rooms and suites and are near White Mountains NH attractions, skiing, golf, hiking and much more. Our family motel is a great vacation or getaway lodging for your White Mountains NH vacation.\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:53:\"The post %%POSTLINK%% appeared first on %%BLOGLINK%%.\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:18:\"disable-attachment\";b:1;s:23:\"is-media-purge-relevant\";b:0;s:20:\"breadcrumbs-404crumb\";s:25:\"Error 404: Page not found\";s:29:\"breadcrumbs-display-blog-page\";b:0;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:12:\"Archives for\";s:18:\"breadcrumbs-enable\";b:0;s:16:\"breadcrumbs-home\";s:4:\"Home\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:16:\"You searched for\";s:15:\"breadcrumbs-sep\";s:2:\"»\";s:12:\"website_name\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"company_logo\";s:74:\"https://www.econolodgeloon.com/wp/wp-content/uploads/signsiloforbanner.jpg\";s:12:\"company_name\";s:24:\"Econo Lodge Inn & Suites\";s:17:\"company_or_person\";s:7:\"company\";s:17:\"stripcategorybase\";b:0;s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:13:\"showdate-post\";b:0;s:23:\"display-metabox-pt-post\";b:1;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:13:\"showdate-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:19:\"showdate-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:18:\"title-tax-category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:1;s:20:\"noindex-tax-category\";b:0;s:18:\"title-tax-post_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:1;s:20:\"noindex-tax-post_tag\";b:0;s:21:\"title-tax-post_format\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:0;s:23:\"noindex-tax-post_format\";b:0;s:23:\"post_types-post-maintax\";i:0;}}s:11:\"old_version\";s:6:\"10.1.1\";s:11:\"new_version\";s:6:\"10.1.2\";}}", "no");
INSERT INTO `wp_options` VALUES("212256", "_transient_timeout_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1578193277", "no");
INSERT INTO `wp_options` VALUES("212272", "admin_email_lifespan", "1622572483", "yes");
INSERT INTO `wp_options` VALUES("212285", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("263277", "_transient_timeout_feed_9bbd59226dc36b9b26cd43f15694c5c3", "1607063689", "no");
INSERT INTO `wp_options` VALUES("263278", "_transient_feed_9bbd59226dc36b9b26cd43f15694c5c3", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"News –  – WordPress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 02 Dec 2020 17:48:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=5.7-alpha-49735\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"The Month in WordPress: November 2020\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://wordpress.org/news/2020/12/the-month-in-wordpress-november-2020/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 02 Dec 2020 09:13:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=9283\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:304:\"November 2020 saw several updates to the WordPress 5.6 release. Read on to follow all the latest news from the WordPress world! WordPress 5.6 updates The Core team released WordPress 5.6 Beta 3 on Nov. 2, Beta 4 on Nov. 12, release candidate 1 on Nov. 17, and release candidate 2 on Dec. 1. You [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Hari Shanker R\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:10892:\"\n<p>November 2020 saw several updates to the WordPress 5.6 release. Read on to follow all the latest news from the WordPress world!</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>WordPress 5.6 updates</h2>\n\n\n\n<p>The Core team released WordPress 5.6 <a href=\"https://wordpress.org/news/2020/11/wordpress-5-6-beta-3/\">Beta 3</a> on Nov. 2, <a href=\"https://wordpress.org/news/2020/11/wordpress-5-6-beta-4/\">Beta 4</a> on Nov. 12, <a href=\"https://wordpress.org/news/2020/11/wordpress-5-6-release-candidate/\">release candidate</a> 1 on Nov. 17, and <a href=\"https://wordpress.org/news/2020/12/wordpress-5-6-release-candidate-2/\">release candidate 2</a> on Dec. 1. You can test the Beta versions and the release candidates by <a href=\"https://wordpress.org/wordpress-5.6-beta2.zip\">downloading them from WordPress.org</a> or by using the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin. Check out the <a href=\"https://make.wordpress.org/core/2020/11/20/wordpress-5-6-field-guide/\">WordPress 5.6 field guide</a> to understand the features of WordPress 5.6 and learn how you can incorporate them into your websites. WordPress 5.6 <a href=\"https://make.wordpress.org/core/5-6/\">will be out by Dec. 9, 2020</a>. </p>\n\n\n\n<p>But our work is never done: You can submit <a href=\"https://make.wordpress.org/core/2020/11/23/wordpress-5-7-whats-on-your-wishlist/\">feature suggestions for WordPress 5.7</a> by Dec. 15.&nbsp;</p>\n\n\n\n<p>Want to contribute to upcoming WordPress releases? Join the WordPress Core dev chats on Wednesdays at 5 a.m. and 8 p.m. UTC in the <a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#core</a> channel on the <a href=\"https://make.wordpress.org/chat/\">Make WordPress Slack</a>, and <a href=\"https://make.wordpress.org/core/tag/dev-chat/\">catch up with recaps</a> on the <a href=\"https://make.wordpress.org/core/\">Core team blog</a>. If you would like to help with WordPress 5.6 outreach, contact the <a href=\"https://make.wordpress.org/marketing/\">WordPress Marketing team</a> on the <a href=\"https://wordpress.slack.com/archives/C0GKJ7TFA\">#marketing</a> channel.</p>\n\n\n\n<h2>Gutenberg 9.3 and 9.4 are out</h2>\n\n\n\n<p>Contributor teams released Gutenberg <a href=\"https://make.wordpress.org/core/2020/11/04/whats-new-in-gutenberg-4-november/\">Version 9.3</a> on Nov. 4 and <a href=\"https://make.wordpress.org/core/2020/11/19/whats-new-in-gutenberg-18-november-2/\">Version 9.4</a> on Nov. 18. Both versions include&nbsp; several improvements to Full Site Editing (FSE) flows, in addition to bug fixes and feature upgrades. Version 9.3 is the first release that isn’t included entirely in WordPress 5.6; the version automatically enables FSE experiments when a block-based theme is active. Version 9.4 introduces some new features like percentage width for button blocks, block variation transformations, social icon support, and font size support for the list block. You can find out more about the Gutenberg roadmap in the <a href=\"https://make.wordpress.org/core/2020/11/02/whats-next-in-gutenberg-november-2020/\">What’s next in Gutenberg blog post</a>.</p>\n\n\n\n<p>Want to get involved in building Gutenberg? Follow <a href=\"https://make.wordpress.org/core/\">the Core team blog</a>, contribute to <a href=\"https://github.com/WordPress/gutenberg/\">Gutenberg on GitHub</a>, and join the <a href=\"https://wordpress.slack.com/archives/C02QB2JS7\">#core-editor</a> channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.</p>\n\n\n\n<h2>Learn WordPress updates</h2>\n\n\n\n<p>WordPress contributor teams are all set to launch <a href=\"https://learn.wordpress.org/\">Learn WordPress</a> in December. Community members can now watch<a href=\"https://learn.wordpress.org/workshops\"> video workshops</a> to learn about various WordPress topics, <a href=\"https://www.meetup.com/learn-wordpress-discussions/\">participate in discussion groups</a>, and use <a href=\"https://learn.wordpress.org/lesson-plans/\">lesson plans</a> for organizing their own workshops. Contributor teams have launched <a href=\"https://make.wordpress.org/community/2020/11/18/quizzes-are-now-live-on-learn-wordpress/\">quizzes</a> and are also working on <a href=\"https://make.wordpress.org/community/2020/11/18/standards-for-learn-wordpress-workshop-content/\">setting standards</a> for workshops.<br></p>\n\n\n\n<p>Want to contribute to Learn WordPress? You can now submit a <a href=\"https://learn.wordpress.org/workshop-presenter-application/\">workshop application</a> (submissions in languages other than English are welcome!), apply to become a <a href=\"https://learn.wordpress.org/discussion-group-leader-application/\">discussion group leader</a>, organize <a href=\"https://make.wordpress.org/community/handbook/virtual-events/organize-learn-wordpress-discussion-groups-for-your-wordpress-meetup/\">discussions for your local WordPress meetup group</a>, or <a href=\"https://make.wordpress.org/training/2020/11/25/high-priority-items-before-learn-wordpress-org-launch-part-2/\">help fix issues with existing lesson plans</a>.</p>\n\n\n\n<h2>WordPress 5.6 Translations and Polyglots survey</h2>\n\n\n\n<p>WordPress 5.6 is ready to be translated and is now at <a href=\"https://make.wordpress.org/polyglots/handbook/glossary/#hard-freeze\">hard string freeze</a>. If you would like to contribute, <a href=\"https://make.wordpress.org/polyglots/2020/11/07/wordpress-5-6-ready-to-be-translated/\">check out these instructions</a> and ensure that <a href=\"https://make.wordpress.org/polyglots/handbook/translating/packaging-localized-wordpress/automated-release-packages/\">your locale is ready for an automated release</a>. The Polyglots team has also kicked off its <a href=\"https://wordpressdotorg.survey.fm/polyglots-translator-research\">translator research survey</a>. Please <a href=\"https://wordpressdotorg.survey.fm/polyglots-translator-research\">participate in the survey</a>, share the <a href=\"https://wordpressdotorg.survey.fm/polyglots-translator-research\">survey link</a> with members of your locale, and help amplify the <a href=\"https://www.facebook.com/WPTranslationDay/posts/1275404086174610\">Facebook</a>, <a href=\"https://twitter.com/TranslateWP/status/1333342595913834496\">Twitter</a>, and <a href=\"https://www.linkedin.com/posts/wptranslationday_makewordpress-wordpress-activity-6739110862650523648-fX8R/\">LinkedIn</a> posts about it.</p>\n\n\n\n<p>Want to help WordPress speak your language? Follow <a href=\"https://make.wordpress.org/polyglots\">the Polyglots team blog</a> and join the <a href=\"https://wordpress.slack.com/archives/C02RP50LK\">#polyglots</a> channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.&nbsp;</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>Further Reading:</h2>\n\n\n\n<ul><li><a href=\"https://www.php.net/releases/8.0/en.php\">PHP 8</a> is out, and WordPress 5.6 <a href=\"https://make.wordpress.org/core/2020/11/23/wordpress-and-php-8-0/\">aims to be &#8220;beta-compatible&#8221; with the latest PHP version</a>.</li><li>Contributor teams have kicked off <a href=\"https://make.wordpress.org/themes/2020/11/18/theme-previews-in-the-time-of-blocks/\">an ongoing discussion on starter content for WordPress themes</a>. Starter content for the <a href=\"http://wp-themes.com/twentytwentyone/\">Twenty Twenty One</a>, <a href=\"http://wp-themes.com/twentytwenty/\">Twenty Twenty</a>, and <a href=\"http://wp-themes.com/twentyseventeen/\">Twenty Seventeen</a> themes are now available.</li><li>The Accessibility team is <a href=\"https://github.com/10degrees/accessibility-statement-plugin\">testing a tool</a> to generate the structure of an accessibility statement for WordPress websites based on <a href=\"https://www.w3.org/WAI/planning/statements/generator/#create\">W3C standards</a>, and it is <a href=\"https://github.com/10degrees/accessibility-statement-plugin/issues\">requesting feedback from the community</a>.</li><li>The <a href=\"https://wordpressfoundation.org/\">WordPress Foundation</a> has published a <a href=\"https://wordpressfoundation.org/2020/open-source-workshops-november-2020-report/\">report on Open Source workshops</a> that were held online in 2020, based on the <a href=\"https://learn.wordpress.org/\">Learn WordPress</a> platform.</li><li>The Docs team is actively <a href=\"https://make.wordpress.org/docs/2020/11/12/follow-up-on-gutenberg-developer-documentation-restructuring-proposal/\">following up</a> on a proposal to <a href=\"https://make.wordpress.org/docs/2020/08/13/plan-proposal-for-a-new-better-structured-gutenberg-developer-documentation/\">restructure the Gutenberg developer documentation</a>.</li><li>The Community team is back with <a href=\"https://make.wordpress.org/community/tag/tuesdaytrainings/\">Tuesday Trainings</a>. The team is <a href=\"https://make.wordpress.org/community/2020/11/16/community-team-goals-for-2021-share-your-suggestions/\">also inviting suggestions on team goals for 2021</a> with a deadline of Dec. 14.</li><li>The Support team is <a href=\"https://make.wordpress.org/support/2020/11/changing-up-the-forum-front-page/\">making changes to the forum page</a> to improve discoverability. </li><li>Two online WordCamps took place in November: <a href=\"https://finland.wordcamp.org/2020/\">WordCamp Finland Online</a> and <a href=\"https://mexico.wordcamp.org/2020/\">WordCamp Mexico Online</a>. You can find Livestream recaps of the events on their websites. Videos will soon be available on WordPress.tv as well.</li><li>The Themes team <a href=\"https://make.wordpress.org/themes/2020/11/11/meeting-notes-tuesday-november-10-2020/\">made some changes to WordPress theme requirements</a>. These include removing updated CSS guidelines and a proposed plan to make WordPress themes accessibility-ready. The team is also <a href=\"https://make.wordpress.org/themes/2020/11/19/feedback-requested-resolution-process-for-issues-found-in-live-themes/\">requesting feedback</a> on the resolution process for issues found in live themes.</li><li>WordPress 5.6 will feature a <a href=\"https://make.wordpress.org/core/2020/11/05/updating-core-jquery-to-version-3-part-2/\">major jQuery change</a>, with the bundled jQuery version being updated to Version 3.5.1 and jQuery Migrate being updated to Version 3.3.2.</li><li>The <a href=\"https://make.wordpress.org/community/tag/wpdiversity/\">Diversity speaker training group</a> of the Community team is requesting feedback on reimagining their work. Please <a href=\"https://make.wordpress.org/community/2020/11/12/input-requested-re-imagining-the-work-of-the-diverse-speaker-training-group-wpdiversity/\">share your feedback as comments on the post</a> by Dec. 18.</li></ul>\n\n\n\n<p><em>Have a story that we should include in the next “Month in WordPress” post? Please </em><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><em>submit it here</em></a><em>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"9283\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 5.6 Release Candidate 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2020/12/wordpress-5-6-release-candidate-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 01 Dec 2020 22:09:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=9274\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:388:\"The second release candidate for WordPress 5.6 is here! WordPress 5.6 is slated for release on December 8, 2020, and we need your help to get there—if you haven’t tried 5.6 yet, now is the time! You can test WordPress 5.6 release candidate 2 in two ways: Try the WordPress Beta Tester plugin (choose the “bleeding edge nightlies” option). Or download the release [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Josepha\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2249:\"\n<p>The second release candidate for WordPress 5.6 is here!</p>\n\n\n\n<p>WordPress 5.6 is slated for release on <strong>December 8, 2020</strong>, and we need <em>your</em> help to get there—if you haven’t tried 5.6 yet, now is the time!</p>\n\n\n\n<p>You can test WordPress 5.6 release candidate 2 in two ways:</p>\n\n\n\n<ul><li>Try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (choose the “bleeding edge nightlies” option).</li><li>Or <a href=\"https://wordpress.org/wordpress-5.6-RC2.zip\">download the release candidate here (zip)</a>.</li></ul>\n\n\n\n<p>Thank you to all of the contributors who tested the&nbsp;Beta releases and gave feedback. Testing for bugs is a critical part of polishing every release and a great way to contribute to WordPress.</p>\n\n\n\n<h2>Plugin and Theme Developers</h2>\n\n\n\n<p>Please test your plugins and themes against WordPress 5.6 and update the <em>Tested up to</em> version in the readme file to 5.6. If you find compatibility problems, please be sure to post to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">support forums</a>. That way, those can be figured out before the final release. </p>\n\n\n\n<p>For a more detailed breakdown of the changes included in WordPress 5.6, check out the <a href=\"https://wordpress.org/news/2020/10/wordpress-5-6-beta-1/\">WordPress 5.6 beta 1 post</a>. The <a href=\"https://make.wordpress.org/core/2020/11/20/wordpress-5-6-field-guide/\">WordPress 5.6 Field Guide</a> is also out! It’s your source for details on all the major changes.</p>\n\n\n\n<h2>How to Help</h2>\n\n\n\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help translate WordPress into more than 100 languages!</a></p>\n\n\n\n<p><em><strong>Think you found a bug?</strong> Post it to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. We would love to hear from you! If you’re comfortable writing a reproducible bug report you can <a href=\"https://make.wordpress.org/core/reports/\">file one on WordPress Trac</a>. Don&#8217;t forget to check <a href=\"https://core.trac.wordpress.org/tickets/major\">the list of known bugs</a></em>!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"9274\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"WordPress 5.6 Release Candidate\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wordpress.org/news/2020/11/wordpress-5-6-release-candidate/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 Nov 2020 22:43:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=9258\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"WordPress 5.6 Release Candidate is now available!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Josepha\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3349:\"\n<p>The first release candidate for WordPress 5.6 is now available!</p>\n\n\n\n<p>This is an important milestone in the community’s progress toward the final release of WordPress 5.6.</p>\n\n\n\n<p>“Release Candidate” means that the new version is ready for release, but with millions of users and thousands of plugins and themes, it’s possible something was missed. WordPress 5.6 is slated for release&nbsp;on&nbsp;<strong>December 8, 2020</strong>, but we need&nbsp;<em>your</em>&nbsp;help to get there—if you haven’t tried 5.6 yet,&nbsp;<strong>now is the time</strong>!</p>\n\n\n\n<p>You can test the WordPress 5.6 release candidate in two ways:</p>\n\n\n\n<ul><li>Try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (choose the “Bleeding edge&#8221; channel and Beta/RC Only” stream options)</li><li>Or <a href=\"https://wordpress.org/wordpress-5.6-RC1.zip\">download the release candidate here (zip)</a>.</li></ul>\n\n\n\n<p>Thank you to all of the contributors who tested the&nbsp;Beta releases and gave feedback. Testing for bugs is a critical part of polishing every release and a great way to contribute to WordPress.</p>\n\n\n\n<h2>What’s in WordPress 5.6?</h2>\n\n\n\n<p>The final release of 2020 continues the annual tradition of a new default theme that is custom built to showcase the new features and functionality of the software. Continued progress on the block editor is especially clear in this release, which brings more blocks to more places, and fewer clicks to implement your layouts.</p>\n\n\n\n<p>WordPress 5.6 also has lots of refinements to polish the developer experience. To learn more, subscribe to the&nbsp;<a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a>&nbsp;and pay special attention to the&nbsp;<a href=\"https://make.wordpress.org/core/tag/5-6+dev-notes/\">developer notes</a>&nbsp;tag for updates on those and other changes that could affect your products.</p>\n\n\n\n<h2>Plugin and Theme Developers</h2>\n\n\n\n<p>Please test your plugins and themes against WordPress 5.6 and update the&nbsp;<em>Tested up to</em>&nbsp;version in the readme file to 5.6. If you find compatibility problems, please be sure to post to the&nbsp;<a href=\"https://wordpress.org/support/forum/alphabeta/\">support forums</a>,&nbsp;so those can be figured out before the final release.</p>\n\n\n\n<p>The&nbsp;WordPress 5.6 Field Guide, due very shortly, will give you a more detailed dive into the major changes.</p>\n\n\n\n<h2>How to Help</h2>\n\n\n\n<p>Do you speak a language other than English?&nbsp;<a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a>&nbsp;This release also marks the&nbsp;<a href=\"https://make.wordpress.org/polyglots/handbook/glossary/#hard-freeze\">hard string freeze</a>&nbsp;point of the 5.6 release schedule.</p>\n\n\n\n<p><em><strong>If you think you’ve found a bug</strong>, you can post to the&nbsp;<a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a>&nbsp;in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report,&nbsp;<a href=\"https://make.wordpress.org/core/reports/\">file one on WordPress Trac</a>, where you can also find&nbsp;<a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"9258\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 5.6 Beta 4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2020/11/wordpress-5-6-beta-4/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 12 Nov 2020 23:49:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=9249\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:363:\"WordPress 5.6 Beta 4 is now available for testing! This software is still in development,&#160;so we recommend that you run this version on a test site. You can test the WordPress 5.6 beta in two ways: Try the WordPress Beta Tester plugin (choose the “bleeding edge nightlies” option). Or download the beta here (zip). The current target for the [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Josepha\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5658:\"\n<p>WordPress 5.6 Beta 4 is now available for testing!</p>\n\n\n\n<p><strong>This software is still in development,</strong>&nbsp;so we recommend that you run this version on a test site.</p>\n\n\n\n<p>You can test the WordPress 5.6 beta in two ways:</p>\n\n\n\n<ul><li>Try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (choose the “bleeding edge nightlies” option).</li><li>Or <a href=\"https://wordpress.org/wordpress-5.6-beta4.zip\">download the beta here (zip)</a>.</li></ul>\n\n\n\n<p>The current target for the final release is December 8, 2020. This is just over<strong> three weeks away</strong>, so your help is needed to ensure this release is tested properly.</p>\n\n\n\n<p>Thank you to all of the contributors that tested the <a href=\"https://wordpress.org/news/2020/11/wordpress-5-6-beta-3/\">beta 3</a> development release and provided feedback. Testing for bugs is an important part of polishing each release and a great way to contribute to WordPress.</p>\n\n\n\n<h2><strong>Some Highlights</strong></h2>\n\n\n\n<p>Since beta 3, <a rel=\"noreferrer noopener\" target=\"_blank\" href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=11%2F04%2F2020..11%2F12%2F2020&amp;milestone=5.6&amp;group=component&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">42 bugs</a> have been fixed. Here is a summary of a few changes included in beta 4:</p>\n\n\n\n<ul><li>There was a change to the auto-updates implementation for new installations of the software (<a href=\"https://core.trac.wordpress.org/ticket/50907\">#50907</a>). <em><a href=\"https://make.wordpress.org/core/2020/11/10/upgrade-install-component-meeting-summary-november-10-2020/\">Next steps</a>, and <a href=\"https://make.wordpress.org/core/2020/11/10/wp5-6-auto-update-implementation-change/\">rationale</a> are both available.</em></li><li>Added better handling of unexpected values in Site Health (<a href=\"https://core.trac.wordpress.org/ticket/50145\">#50145</a>).</li><li>Added a way for developers to filter the available authors list in Quick Edit (<a href=\"https://core.trac.wordpress.org/ticket/47685\">#47685</a>).</li><li>More accessible handling of the tag cloud widget (<a href=\"https://core.trac.wordpress.org/ticket/51455\">#51455</a>).</li><li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=11%2F04%2F2020..11%2F12%2F2020&amp;component=Media&amp;milestone=5.6&amp;group=component&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">Multiple improvements in the Media component</a>.</li><li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=11%2F04%2F2020..11%2F12%2F2020&amp;component=Build%2FTest+Tools&amp;milestone=5.6&amp;group=component&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">Multiple improvements in the Build/Test Tools component</a>.</li></ul>\n\n\n\n<p><em>To see all of the features for each Gutenberg release in detail, check out the release posts: <a href=\"https://make.wordpress.org/core/2020/07/22/whats-new-in-gutenberg-july-22/\">8.6</a>, <a href=\"https://make.wordpress.org/core/2020/08/05/whats-new-in-gutenberg-august-5/\">8.7</a>, <a href=\"https://make.wordpress.org/core/2020/08/19/whats-new-in-gutenberg-august-19/\">8.8</a>, <a href=\"https://make.wordpress.org/core/2020/09/03/whats-new-in-gutenberg-2-september/\">8.9</a>, <a href=\"https://make.wordpress.org/core/2020/09/16/whats-new-in-gutenberg-16-september/\">9.0</a>, <a href=\"https://make.wordpress.org/core/2020/10/01/whats-new-in-gutenberg-30-september/\">9.1</a>, <a href=\"https://make.wordpress.org/core/2020/10/21/whats-new-in-gutenberg-21-october/\">9.2</a>, and <a href=\"https://github.com/WordPress/gutenberg/releases/tag/v9.3.0-rc.1\">9.3</a>.</em></p>\n\n\n\n<h2 id=\"block-76156b2b-0a52-4502-b585-6cbe9481f55b\">Developer notes</h2>\n\n\n\n<p id=\"block-3fe5e264-0a95-4f12-9a18-0cb9dc5955d1\">WordPress 5.6 has lots of refinements to the developer experience. To keep up, subscribe to the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> and pay special attention to the <a href=\"https://make.wordpress.org/core/tag/5-6+dev-notes/\">developers’ notes</a> for updates on those and other changes that could affect your products.</p>\n\n\n\n<h2 id=\"block-bc89fd56-47b0-439f-8e2c-4a642c80a616\">How to Help</h2>\n\n\n\n<p id=\"block-9d871099-ec49-446c-8322-9e49b7498c10\">If you think you’ve found a bug, you can post to the&nbsp;<a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a>&nbsp;in the support forums. We’d love to hear from you!</p>\n\n\n\n<p id=\"block-bd71c1d3-39d9-4b2a-8193-3486497b45fd\">If you’re comfortable writing a reproducible bug report,&nbsp;<a href=\"https://core.trac.wordpress.org/newticket\">file one on WordPress Trac</a>,&nbsp;where you can also find a list of&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=new&amp;milestone=5.6&amp;group=component&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">known bugs</a>.</p>\n\n\n\n<p><em>Props to @tonyamork, @audrasjb for technical notes and @angelasjin,<em> </em><a href=\"https://profiles.wordpress.org/yvettesonneveld/\">@yvettesonneveld</a><em>, </em><a href=\"https://profiles.wordpress.org/cguntur/\">@cguntur</a>, <a href=\'https://profiles.wordpress.org/cbringmann/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>cbringmann</a> for final review.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"9249\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 5.6 Beta 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2020/11/wordpress-5-6-beta-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 02 Nov 2020 21:23:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=9234\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:379:\"WordPress 5.6 Beta 3 is now available for testing! This software is still in development,&#160;so we recommend that you run this version on a test site. You can test the WordPress 5.6 beta in two ways: Try the&#160;WordPress Beta Tester&#160;plugin (choose the “bleeding edge nightlies” option). Or&#160;download the beta here&#160;(zip). The current target for the [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Chloe Bringmann\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5206:\"\n<p>WordPress 5.6 Beta 3 is now available for testing!</p>\n\n\n\n<p><strong>This software is still in development,</strong>&nbsp;so we recommend that you run this version on a test site.</p>\n\n\n\n<p>You can test the WordPress 5.6 beta in two ways:</p>\n\n\n\n<ul><li>Try the&nbsp;<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a>&nbsp;plugin (choose the “bleeding edge nightlies” option).</li><li>Or&nbsp;<a href=\"https://wordpress.org/wordpress-5.6-beta3.zip\">download the beta here&nbsp;(zip)</a>.</li></ul>\n\n\n\n<p>The current target for the final release is December 8, 2020. This is just&nbsp;<strong>five weeks away</strong>, so your help is needed to ensure this release is tested properly.</p>\n\n\n\n<p>Thank you to all of the contributors that tested the&nbsp;<a href=\"https://wordpress.org/news/2020/10/wordpress-5-6-beta-2/\">beta 2&nbsp;</a>development release and provided feedback. Testing for bugs is an important part of polishing each release and a great way to contribute to WordPress.</p>\n\n\n\n<h2><strong>Some Highlights</strong></h2>\n\n\n\n<p>Since&nbsp;beta 2,&nbsp;<a rel=\"noreferrer noopener\" target=\"_blank\" href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=10%2F28%2F2020..11%2F03%2F2020&amp;milestone=5.6&amp;group=component&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">20 bugs</a>&nbsp;have been fixed. Here is a summary of a few changes included in beta 3:</p>\n\n\n\n<ul><li>Added block patterns for Twenty Twenty (see&nbsp;<a rel=\"noreferrer noopener\" target=\"_blank\" href=\"https://core.trac.wordpress.org/ticket/51098\">#51098</a>) and Twenty Nineteen (see&nbsp;<a rel=\"noreferrer noopener\" target=\"_blank\" href=\"https://core.trac.wordpress.org/ticket/51099\">#51099</a>) themes.</li><li>Added theme support for navigation-widgets (see&nbsp;<a rel=\"noreferrer noopener\" target=\"_blank\" href=\"https://core.trac.wordpress.org/ticket/51445\">#51445</a>).</li><li>Fixed incorrect slashes in the URL if the parent is empty for REST API (see&nbsp;<a rel=\"noreferrer noopener\" target=\"_blank\" href=\"https://core.trac.wordpress.org/ticket/44745\">#44745</a>).</li><li>Added a test to Site Health to verify that the&nbsp;<code>Authorization</code>&nbsp;header is working as expected for Application Passwords (see&nbsp;<a rel=\"noreferrer noopener\" target=\"_blank\" href=\"https://core.trac.wordpress.org/ticket/51638\">#51638</a>).</li><li>10 additional bugs fixed in the block editor (see&nbsp;<a rel=\"noreferrer noopener\" target=\"_blank\" href=\"https://github.com/WordPress/gutenberg/pull/26588\">#26588</a>).</li></ul>\n\n\n\n<p>To see all of the features for each Gutenberg release in detail, check out the release posts:&nbsp;<a href=\"https://make.wordpress.org/core/2020/07/22/whats-new-in-gutenberg-july-22/\">8.6</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2020/08/05/whats-new-in-gutenberg-august-5/\">8.7</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2020/08/19/whats-new-in-gutenberg-august-19/\">8.8</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2020/09/03/whats-new-in-gutenberg-2-september/\">8.9</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2020/09/16/whats-new-in-gutenberg-16-september/\">9.0</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2020/10/01/whats-new-in-gutenberg-30-september/\">9.1</a>, <a href=\"https://make.wordpress.org/core/2020/10/21/whats-new-in-gutenberg-21-october/\">9.2</a>, and <a href=\"https://github.com/WordPress/gutenberg/releases/tag/v9.3.0-rc.1\">9.3</a>.</p>\n\n\n\n<h2 id=\"block-76156b2b-0a52-4502-b585-6cbe9481f55b\">Developer notes</h2>\n\n\n\n<p id=\"block-3fe5e264-0a95-4f12-9a18-0cb9dc5955d1\">WordPress 5.6 has lots of refinements to the developer experience as well. To keep up, subscribe to the&nbsp;<a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a>&nbsp;and pay special attention to the&nbsp;<a href=\"https://make.wordpress.org/core/tag/5-6+dev-notes/\">developers’ notes</a>&nbsp;for updates on those and other changes that could affect your products.</p>\n\n\n\n<h2 id=\"block-bc89fd56-47b0-439f-8e2c-4a642c80a616\">How to Help</h2>\n\n\n\n<p id=\"block-9d871099-ec49-446c-8322-9e49b7498c10\">If you think you’ve found a bug, you can post to the&nbsp;<a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a>&nbsp;in the support forums. We’d love to hear from you!</p>\n\n\n\n<p id=\"block-bd71c1d3-39d9-4b2a-8193-3486497b45fd\">If you’re comfortable writing a reproducible bug report,&nbsp;<a href=\"https://core.trac.wordpress.org/newticket\">file one on WordPress Trac</a>,&nbsp;where you can also find a list of&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=new&amp;milestone=5.6&amp;group=component&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">known bugs</a>.</p>\n\n\n\n<p><em>Props to <a href=\'https://profiles.wordpress.org/hellofromtonya/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>hellofromtonya</a> for help and <a href=\'https://profiles.wordpress.org/chanthaboune/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chanthaboune</a>  for final review.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"9234\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"The Month in WordPress: October 2020\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/news/2020/11/the-month-in-wordpress-october-2020/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 02 Nov 2020 18:14:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=9225\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"October 2020 was a notable month for WordPress lovers, thanks to the release of several products and updates. Read on to keep up with all the latest news! The 2020 WordPress Annual Survey is out The team published the 2020 WordPress Annual survey —&#160; to help those who build WordPress to understand more about our [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Hari Shanker R\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:11855:\"\n<p>October 2020 was a notable month for WordPress lovers, thanks to the release of several products and updates. Read on to keep up with all the latest news!</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>The 2020 WordPress Annual Survey is out</h2>\n\n\n\n<p>The team published the <a href=\"https://wordpressdotorg.survey.fm/wordpress-2020-survey-english\">2020 WordPress Annual survey</a> —&nbsp; to help those who build WordPress to understand more about our software usage and our contributors’ experience. The Annual Survey will be open for at least 6 weeks and is available in <a href=\"https://wordpressdotorg.survey.fm/wordpress-2020-survey-french\">French</a>, <a href=\"https://wordpressdotorg.survey.fm/wordpress-2020-survey-german\">German</a>, <a href=\"https://wordpressdotorg.survey.fm/wordpress-2020-survey-japanese\">Japanese</a>, <a href=\"https://wordpressdotorg.survey.fm/wordpress-2020-survey-russian\">Russian</a>, and <a href=\"https://wordpressdotorg.survey.fm/wordpress-2020-survey-spanish\">Spanish</a>. The survey results (once complete) will be posted on <a href=\"https://wordpress.org/news/\">WordPress.org/news</a>. The<a href=\"https://wordpress.org/news/2020/10/take-the-2020-wordpress-annual-survey-and-view-the-2019-results/\"> 2019 survey results</a> have also been released and can now be viewed as <a href=\"https://docs.google.com/presentation/d/1FI7eEvSB5SHTSILIBpwOmH9rBffgD6mFnnqSkrEScYo/edit\">slides</a> or downloaded in <a href=\"https://www.dropbox.com/sh/bq62sficymopgos/AAA-wx73cDviVG84NSCTgjNDa?dl=0\">PDF format</a>.&nbsp;</p>\n\n\n\n<h2>WordPress Translation celebrations spanned four weeks</h2>\n\n\n\n<p>The last week of September and most of October were focused on recruiting and encouraging polyglot contributors to the WordPress translation project. What was originally envisioned as a single-day event lasted 24 days! The Polyglots and Marketing Teams are exploring how future mini-events can be supported to continue building the momentum. Recordings of the live talks and interviews with contributors are available <a href=\"https://www.youtube.com/playlist?list=PLCVEqsAbLfffK5WzOT9BhPsh82HgM8vj1\">on YouTube</a>. Write-ups from the different events are <a href=\"https://wptranslationday.org/\">on the WPTranslationDay website</a>. </p>\n\n\n\n<p>Want to help WordPress speak your own language? Follow <a href=\"https://make.wordpress.org/polyglots\">the Polyglots team blog</a> and join the <a href=\"https://wordpress.slack.com/archives/C02RP50LK\">#polyglots</a> channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.&nbsp;</p>\n\n\n\n<h2>WordPress maintenance and beta releases</h2>\n\n\n\n<p>The Core team released <a href=\"https://make.wordpress.org/core/2020/10/30/wordpress-5-5-3-release-some-technical-details/\">WordPress 5.5.3 on Oct. 31</a>, following the release of Version <a href=\"https://wordpress.org/news/2020/10/wordpress-5-5-2-security-and-maintenance-release/\">5.5.2 on Oct. 29</a>. Both releases fix several bugs and security issues with WordPress. You can update to the latest version directly from your WordPress dashboard or <a href=\"https://wordpress.org/download/\">download</a> it now from WordPress.org.&nbsp; The team also released WordPress 5.6 <a href=\"https://wordpress.org/news/2020/10/wordpress-5-6-beta-1/\">Beta 1</a> on Oct. 20, followed by <a href=\"https://wordpress.org/news/2020/10/wordpress-5-6-beta-2/\">Beta 2 </a>on Oct. 27. When ready, the final release will include improvements to the editor, auto-updates for major releases, PHP 8 support, and the Twenty Twenty One theme. You can test the Beta versions by <a href=\"https://wordpress.org/wordpress-5.6-beta2.zip\">downloading them from WordPress.org</a> or using the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin.<br></p>\n\n\n\n<p>Want to be involved in the next release? Follow WordPress 5.6 updates on the <a href=\"https://make.wordpress.org/core/5-6/\">development cycle</a> and sign-up for the <a href=\"https://make.wordpress.org/core/2020/10/22/code-review-commit-office-hours-for-5-6/\">code review/commit office hours</a>. You can help build WordPress Core by following<a href=\"https://make.wordpress.org/core/\"> the Core team blog</a> and joining the <a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#core</a> channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>. If you would like to help out with WordPress 5.6 outreach, contact the <a href=\"https://make.wordpress.org/marketing/\">WordPress Marketing team</a> on the <a href=\"https://wordpress.slack.com/archives/C0GKJ7TFA\">#marketing</a> channel.</p>\n\n\n\n<h2>Gutenberg 9.2 is released</h2>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2020/10/21/whats-new-in-gutenberg-21-october/\">Version 9.2</a> of the Gutenberg plugin came out on Oct. 21. This release offers support for video subtitles, the ability to transform selected blocks into the columns block, background patterns in cover blocks, along with several exciting features such as improvements to the widget screen, as well as bug fixes. You can find out more about the Gutenberg roadmap in the <a href=\"https://make.wordpress.org/core/2020/10/01/whats-next-in-gutenberg-october/\">What’s next in Gutenberg blog post</a>.</p>\n\n\n\n<p>Want to get involved in building Gutenberg? Follow <a href=\"https://make.wordpress.org/core/\">the Core team blog</a>, contribute to <a href=\"https://github.com/WordPress/gutenberg/\">Gutenberg on GitHub</a>, and join the #core-editor channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.</p>\n\n\n\n<h2>Learn WordPress is gearing up for launch</h2>\n\n\n\n<p>The <a href=\"https://learn.wordpress.org/\">Learn WordPress</a> initiative, which offers <a href=\"https://learn.wordpress.org/workshops/\">WordPress video workshops</a> followed by <a href=\"https://www.meetup.com/learn-wordpress-discussions/\">interactive discussions</a>, is aiming to put out two courses by the end of the year as part of its full launch. The team is working on creating courses and is requesting feedback from community members on the <a href=\"https://make.wordpress.org/community/2020/10/23/learn-wordpress-course-planning/\">planned list of courses</a>.<br><br>Want to contribute to Learn WordPress? You can now submit a <a href=\"https://learn.wordpress.org/workshop-presenter-application/\">workshop application</a> (submissions in non-English languages are welcome), apply to become a <a href=\"https://learn.wordpress.org/discussion-group-leader-application/\">discussion group leader</a>, organize <a href=\"https://make.wordpress.org/community/handbook/virtual-events/organize-learn-wordpress-discussion-groups-for-your-wordpress-meetup/\">discussions for your local WordPress meetup group</a>, or <a href=\"https://make.wordpress.org/training/2020/10/14/call-for-screenshots-contributors/\">update screenshots</a> on existing <a href=\"https://learn.wordpress.org/lesson-plans/\">lesson plans</a>.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>Further Reading:</h2>\n\n\n\n<ul><li>The <a href=\"https://make.wordpress.org/updates/2020/10/20/quarterly-updates-q3-2020/\">Q3 2020 update</a> from the WordPress project is now out!</li><li>The <a href=\"https://make.wordpress.org/marketing/\">WordPress Marketing team</a> has put together a list of <a href=\"https://github.com/wpmarketingteam/WP5.5\">WordPress 5.5 marketing resources</a> consisting of video presentations, slides, questions &amp; answers, social media posts, and more &#8211; aimed at both developers and non-developers. The team has also prepared a list of <a href=\"https://www.youtube.com/playlist?list=PLCVEqsAbLffcS1Rx-COZ5CZBOmXZJEe6k\">captioned screen-recordings</a> in several languages to aid new contributors. Contact the team on the <a href=\"https://wordpress.slack.com/archives/C0GKJ7TFA\">#marketing</a> channel if you would like to contribute to these and upcoming projects.&nbsp;</li><li>The <a href=\"https://make.wordpress.org/core\">WordPress Core team</a> has <a href=\"https://make.wordpress.org/core/2020/09/23/proposal-rest-api-authentication-application-passwords/\">announced a proposal</a> to introduce application passwords for REST API integrations.</li><li>Five online WordCamps took place in October: <a href=\"https://2020.rochester.wordcamp.org/\">WordCamp Rochester, NY</a>, <a href=\"https://austin.wordcamp.org/2020/\">WordCamp Austin, TX</a>, <a href=\"https://2020.italia.wordcamp.org/\">WordCamp Italia Online</a>, <a href=\"https://la.wordcamp.org/2020/\">WordCamp Los Angeles, CA</a>, and <a href=\"https://bulgaria.wordcamp.org/2020/\">WordCamp Bulgaria Online</a>. You can find livestream recaps of these camps on their websites. The camps are also in the process of uploading their videos to <a href=\"https://wordpress.tv/\">WordPress.tv</a>. Check out the <a href=\"https://central.wordcamp.org/schedule/\">WordCamp Schedule</a> to catch up with upcoming online WordCamps.</li><li>Contributor teams have started work on <a href=\"https://make.wordpress.org/core/2020/10/22/twenty-twenty-one-dark-mode-discussion/\">adding dark mode support for the Twenty Twenty One theme</a>. Additionally, the development of the <a href=\"https://make.wordpress.org/themes/2020/10/23/developing-the-full-site-editing-version-of-twenty-twenty-one/\">Full Site Editing version of Twenty Twenty One</a> has also kicked-off in the <a href=\"https://github.com/WordPress/theme-experiments/tree/master/twentytwentyone-blocks\">Theme Experiments GitHub repository</a>.</li><li><a href=\"https://buddypress.org/2020/10/buddypress-7-0-0-beta1/\">BuddyPress 7.0 beta</a>, which comes with new administration screens, blocks, and improved CLI support &#8211; is now available!&nbsp;</li><li>The Core team is <a href=\"https://make.wordpress.org/core/2020/10/06/revisiting-starter-content-on-org-and-beyond/\">revisiting starter content for WordPress themes</a> as part of the 5.6 release. The team also decided not to ship the widgets screen in WordPress 5.6 and have started discussions on <a href=\"https://make.wordpress.org/core/2020/10/29/discussion-align-the-wordpress-release-cycle-with-the-industry-standard/\">aligning the WordPress release cycle with industry standards</a>.</li><li>WordPress Accessibility enthusiasts all over the world joined hands for the first ever 24 hour <a href=\"https://wpaccessibilityday.org/\">WP Accessibility day</a> event on Oct. 2. You can find the recorded livestream of the event on its <a href=\"https://www.youtube.com/channel/UCes9XCUZd51CAigbBEGlfNg/featured?view_as=subscriber\">YouTube channel</a>.</li><li>The <a href=\"https://make.wordpress.org/meta\">Meta</a> team has <a href=\"https://make.wordpress.org/meta/2020/10/27/block-pattern-directory-ideas-and-discussion/\">kicked off a discussion</a> on setting up a <a href=\"https://developer.wordpress.org/block-editor/developers/block-api/block-patterns/\">Block pattern</a> directory (similar to the <a href=\"https://wordpress.org/support/article/block-directory/\">existing block directory</a>).&nbsp;</li><li>The <a href=\"https://make.wordpress.org/themes\">Themes</a> team has published a post clarifying <a href=\"https://make.wordpress.org/themes/2020/10/07/block-based-themes-and-wordpress-5-6/\">how Block based themes will work with WordPress 5.6</a>. Check out the <a href=\"https://developer.wordpress.org/block-editor/tutorials/block-based-themes/\">block-based theme tutorial</a> and its <a href=\"https://github.com/WordPress/gutenberg/blob/master/docs/designers-developers/developers/themes/block-based-themes.md\">documentation</a> to learn how to build block-based themes.&nbsp;</li></ul>\n\n\n\n<p><em>Have a story that we should include in the next “Month in WordPress” post? Please </em><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><em>submit it here</em></a><em>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"9225\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"WordPress 5.5.3 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/news/2020/10/wordpress-5-5-3-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Oct 2020 20:25:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=9212\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:372:\"WordPress 5.5.3 is now available.&#160; This maintenance release fixes an issue introduced in WordPress 5.5.2 which makes it impossible to install WordPress on a brand new website that does not have a database connection configured. This release does not affect sites where a database connection is already configured, for example, via one-click installers or an [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jake Spurlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4118:\"\n<p>WordPress 5.5.3 is now available.&nbsp;</p>\n\n\n\n<p>This maintenance release fixes an issue introduced in WordPress 5.5.2 which makes it impossible to install WordPress on a brand new website that does not have a database connection configured. This release does not affect sites where a database connection is already configured, for example, via one-click installers or an existing <code>wp-config.php</code> file.</p>\n\n\n\n<h2>5.5.3-alpha Issue</h2>\n\n\n\n<p>Earlier today &#8212; between approximately 15:30 and 16:00 UTC &#8212; the auto-update system