<?php

/**
 * Class WPMUDEV_Dashboard_Single_Site_Test_Preg_Math
 *
 * test preg_match regex compatibility with 7.3
 *
 * tests below only for functions that are being used,
 * for functions that are not being used, those assumed does not need further tests
 */
class WPMUDEV_Dashboard_Single_Site_Test_Preg_Math extends WP_UnitTestCase {

	public function setUp() {
		add_filter( 'http_response', array( $this, 'mock_analytics_response' ), 10, 3 );
		parent::setUp(); // TODO: Change the autogenerated stub
	}

	// always logout on teardown
	public function tearDown() {
		remove_filter( 'http_response', array( $this, 'mock_analytics_response' ), 10 );
		WPMUDEV_Dashboard_Test_Util::logout();
		parent::tearDown();
	}

	public function test_api_rest_url() {
		$rest_url = WPMUDEV_Dashboard::$api->rest_url( 'projects' );
		$this->assertSame( WPMUDEV_CUSTOM_API_SERVER . 'api/dashboard/v2/projects', $rest_url );
	}

	public function test_api_analytics_stats_overall() {
		WPMUDEV_Dashboard_Test_Util::login();
		WPMUDEV_Dashboard::$api->analytics_enable();
		WPMUDEV_Dashboard::$settings->set( 'enabled', true, 'analytics' );
		$overall = WPMUDEV_Dashboard::$api->analytics_stats_overall();
		$this->assertNotEmpty( $overall );
	}

	public function test_site_to_localtime() {
		$local_time = WPMUDEV_Dashboard::$site->to_localtime( time() );
		$this->assertNotEmpty( $local_time );
	}

	public function test_lib_crypt_rsa() {
		if ( ! class_exists( 'Crypt_RSA', false ) ) {
			require_once WPMUDEV_Dashboard::$site->plugin_path . 'lib/PHPSecLib/Crypt/RSA.php';
		}
		$rsa = new Crypt_RSA();
		$this->assertNotEmpty( $rsa->hashName ); // phpcs:ignore
	}

	public function mock_analytics_response( $response, $r, $url ) {
		if ( preg_match( '/\/api\/analytics\/v1\/site\/(.*)\/overall\//i', $url ) ) {
			$request_response              = new Requests_Response();
			$request_response->status_code = 200;
			$request_response->body        = WPMUDEV_Dashboard_Test_Util::open_json_data( 'analytics-overall.json' );
			$response                      = new WP_HTTP_Requests_Response( $request_response );
			$response                      = $response->to_array();
		}

		return $response;
	}
}
